"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends6 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _cssinjs = require("../../_util/cssinjs");
var _internal = require("../../theme/internal");
var skeletonClsLoading = new _cssinjs.Keyframes("ant-skeleton-loading", {
  '0%': {
    transform: 'translateX(-37.5%)'
  },
  '100%': {
    transform: 'translateX(37.5%)'
  }
});
var genSkeletonElementCommonSize = function genSkeletonElementCommonSize(size) {
  return {
    height: size,
    lineHeight: "".concat(size, "px")
  };
};
var genSkeletonElementAvatarSize = function genSkeletonElementAvatarSize(size) {
  return (0, _extends6.default)({
    width: size
  }, genSkeletonElementCommonSize(size));
};
var genSkeletonColor = function genSkeletonColor(token) {
  return {
    position: 'relative',
    // fix https://github.com/ant-design/ant-design/issues/36444
    // https://monshin.github.io/202109/css/safari-border-radius-overflow-hidden/
    /* stylelint-disable-next-line property-no-vendor-prefix,value-no-vendor-prefix */
    zIndex: 0,
    overflow: 'hidden',
    background: 'transparent',
    '&::after': {
      position: 'absolute',
      top: 0,
      insetInlineEnd: '-150%',
      bottom: 0,
      insetInlineStart: '-150%',
      background: token.skeletonLoadingBackground,
      animationName: skeletonClsLoading,
      animationDuration: token.skeletonLoadingMotionDuration,
      animationTimingFunction: 'ease',
      animationIterationCount: 'infinite',
      content: '""'
    }
  };
};
var genSkeletonElementInputSize = function genSkeletonElementInputSize(size) {
  return (0, _extends6.default)({
    width: size * 5,
    minWidth: size * 5
  }, genSkeletonElementCommonSize(size));
};
var genSkeletonElementAvatar = function genSkeletonElementAvatar(token) {
  var _ref;
  var skeletonAvatarCls = token.skeletonAvatarCls,
    color = token.color,
    controlHeight = token.controlHeight,
    controlHeightLG = token.controlHeightLG,
    controlHeightSM = token.controlHeightSM;
  return _ref = {}, (0, _defineProperty2.default)(_ref, "".concat(skeletonAvatarCls), (0, _extends6.default)({
    display: 'inline-block',
    verticalAlign: 'top',
    background: color
  }, genSkeletonElementAvatarSize(controlHeight))), (0, _defineProperty2.default)(_ref, "".concat(skeletonAvatarCls).concat(skeletonAvatarCls, "-circle"), {
    borderRadius: '50%'
  }), (0, _defineProperty2.default)(_ref, "".concat(skeletonAvatarCls).concat(skeletonAvatarCls, "-lg"), (0, _extends6.default)({}, genSkeletonElementAvatarSize(controlHeightLG))), (0, _defineProperty2.default)(_ref, "".concat(skeletonAvatarCls).concat(skeletonAvatarCls, "-sm"), (0, _extends6.default)({}, genSkeletonElementAvatarSize(controlHeightSM))), _ref;
};
var genSkeletonElementInput = function genSkeletonElementInput(token) {
  var _ref2;
  var controlHeight = token.controlHeight,
    borderRadiusSM = token.borderRadiusSM,
    skeletonInputCls = token.skeletonInputCls,
    controlHeightLG = token.controlHeightLG,
    controlHeightSM = token.controlHeightSM,
    color = token.color;
  return _ref2 = {}, (0, _defineProperty2.default)(_ref2, "".concat(skeletonInputCls), (0, _extends6.default)({
    display: 'inline-block',
    verticalAlign: 'top',
    background: color,
    borderRadius: borderRadiusSM
  }, genSkeletonElementInputSize(controlHeight))), (0, _defineProperty2.default)(_ref2, "".concat(skeletonInputCls, "-lg"), (0, _extends6.default)({}, genSkeletonElementInputSize(controlHeightLG))), (0, _defineProperty2.default)(_ref2, "".concat(skeletonInputCls, "-sm"), (0, _extends6.default)({}, genSkeletonElementInputSize(controlHeightSM))), _ref2;
};
var genSkeletonElementImageSize = function genSkeletonElementImageSize(size) {
  return (0, _extends6.default)({
    width: size
  }, genSkeletonElementCommonSize(size));
};
var genSkeletonElementImage = function genSkeletonElementImage(token) {
  var _extends2, _ref3;
  var skeletonImageCls = token.skeletonImageCls,
    imageSizeBase = token.imageSizeBase,
    color = token.color,
    borderRadiusSM = token.borderRadiusSM;
  return _ref3 = {}, (0, _defineProperty2.default)(_ref3, "".concat(skeletonImageCls), (0, _extends6.default)((0, _extends6.default)({
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    verticalAlign: 'top',
    background: color,
    borderRadius: borderRadiusSM
  }, genSkeletonElementImageSize(imageSizeBase * 2)), (_extends2 = {}, (0, _defineProperty2.default)(_extends2, "".concat(skeletonImageCls, "-path"), {
    fill: '#bfbfbf'
  }), (0, _defineProperty2.default)(_extends2, "".concat(skeletonImageCls, "-svg"), (0, _extends6.default)((0, _extends6.default)({}, genSkeletonElementImageSize(imageSizeBase)), {
    maxWidth: imageSizeBase * 4,
    maxHeight: imageSizeBase * 4
  })), (0, _defineProperty2.default)(_extends2, "".concat(skeletonImageCls, "-svg").concat(skeletonImageCls, "-svg-circle"), {
    borderRadius: '50%'
  }), _extends2))), (0, _defineProperty2.default)(_ref3, "".concat(skeletonImageCls).concat(skeletonImageCls, "-circle"), {
    borderRadius: '50%'
  }), _ref3;
};
var genSkeletonElementButtonShape = function genSkeletonElementButtonShape(token, size, buttonCls) {
  var _ref4;
  var skeletonButtonCls = token.skeletonButtonCls;
  return _ref4 = {}, (0, _defineProperty2.default)(_ref4, "".concat(buttonCls).concat(skeletonButtonCls, "-circle"), {
    width: size,
    minWidth: size,
    borderRadius: '50%'
  }), (0, _defineProperty2.default)(_ref4, "".concat(buttonCls).concat(skeletonButtonCls, "-round"), {
    borderRadius: size
  }), _ref4;
};
var genSkeletonElementButtonSize = function genSkeletonElementButtonSize(size) {
  return (0, _extends6.default)({
    width: size * 2,
    minWidth: size * 2
  }, genSkeletonElementCommonSize(size));
};
var genSkeletonElementButton = function genSkeletonElementButton(token) {
  var borderRadiusSM = token.borderRadiusSM,
    skeletonButtonCls = token.skeletonButtonCls,
    controlHeight = token.controlHeight,
    controlHeightLG = token.controlHeightLG,
    controlHeightSM = token.controlHeightSM,
    color = token.color;
  return (0, _extends6.default)((0, _extends6.default)((0, _extends6.default)((0, _extends6.default)((0, _extends6.default)((0, _defineProperty2.default)({}, "".concat(skeletonButtonCls), (0, _extends6.default)({
    display: 'inline-block',
    verticalAlign: 'top',
    background: color,
    borderRadius: borderRadiusSM,
    width: controlHeight * 2,
    minWidth: controlHeight * 2
  }, genSkeletonElementButtonSize(controlHeight))), genSkeletonElementButtonShape(token, controlHeight, skeletonButtonCls)), (0, _defineProperty2.default)({}, "".concat(skeletonButtonCls, "-lg"), (0, _extends6.default)({}, genSkeletonElementButtonSize(controlHeightLG)))), genSkeletonElementButtonShape(token, controlHeightLG, "".concat(skeletonButtonCls, "-lg"))), (0, _defineProperty2.default)({}, "".concat(skeletonButtonCls, "-sm"), (0, _extends6.default)({}, genSkeletonElementButtonSize(controlHeightSM)))), genSkeletonElementButtonShape(token, controlHeightSM, "".concat(skeletonButtonCls, "-sm")));
};
// =============================== Base ===============================
var genBaseStyle = function genBaseStyle(token) {
  var _$concat, _$concat3, _$concat4, _$concat$concat2, _ref5;
  var componentCls = token.componentCls,
    skeletonAvatarCls = token.skeletonAvatarCls,
    skeletonTitleCls = token.skeletonTitleCls,
    skeletonParagraphCls = token.skeletonParagraphCls,
    skeletonButtonCls = token.skeletonButtonCls,
    skeletonInputCls = token.skeletonInputCls,
    skeletonImageCls = token.skeletonImageCls,
    controlHeight = token.controlHeight,
    controlHeightLG = token.controlHeightLG,
    controlHeightSM = token.controlHeightSM,
    color = token.color,
    padding = token.padding,
    marginSM = token.marginSM,
    borderRadius = token.borderRadius,
    skeletonTitleHeight = token.skeletonTitleHeight,
    skeletonBlockRadius = token.skeletonBlockRadius,
    skeletonParagraphLineHeight = token.skeletonParagraphLineHeight,
    controlHeightXS = token.controlHeightXS,
    skeletonParagraphMarginTop = token.skeletonParagraphMarginTop;
  return _ref5 = {}, (0, _defineProperty2.default)(_ref5, "".concat(componentCls), (_$concat4 = {
    display: 'table',
    width: '100%'
  }, (0, _defineProperty2.default)(_$concat4, "".concat(componentCls, "-header"), (_$concat = {
    display: 'table-cell',
    paddingInlineEnd: padding,
    verticalAlign: 'top'
  }, (0, _defineProperty2.default)(_$concat, "".concat(skeletonAvatarCls), (0, _extends6.default)({
    display: 'inline-block',
    verticalAlign: 'top',
    background: color
  }, genSkeletonElementAvatarSize(controlHeight))), (0, _defineProperty2.default)(_$concat, "".concat(skeletonAvatarCls, "-circle"), {
    borderRadius: '50%'
  }), (0, _defineProperty2.default)(_$concat, "".concat(skeletonAvatarCls, "-lg"), (0, _extends6.default)({}, genSkeletonElementAvatarSize(controlHeightLG))), (0, _defineProperty2.default)(_$concat, "".concat(skeletonAvatarCls, "-sm"), (0, _extends6.default)({}, genSkeletonElementAvatarSize(controlHeightSM))), _$concat)), (0, _defineProperty2.default)(_$concat4, "".concat(componentCls, "-content"), (_$concat3 = {
    display: 'table-cell',
    width: '100%',
    verticalAlign: 'top'
  }, (0, _defineProperty2.default)(_$concat3, "".concat(skeletonTitleCls), (0, _defineProperty2.default)({
    width: '100%',
    height: skeletonTitleHeight,
    background: color,
    borderRadius: skeletonBlockRadius
  }, "+ ".concat(skeletonParagraphCls), {
    marginBlockStart: controlHeightSM
  })), (0, _defineProperty2.default)(_$concat3, "".concat(skeletonParagraphCls), {
    padding: 0,
    '> li': {
      width: '100%',
      height: skeletonParagraphLineHeight,
      listStyle: 'none',
      background: color,
      borderRadius: skeletonBlockRadius,
      '+ li': {
        marginBlockStart: controlHeightXS
      }
    }
  }), (0, _defineProperty2.default)(_$concat3, "".concat(skeletonParagraphCls, "> li:last-child:not(:first-child):not(:nth-child(2))"), {
    width: '61%'
  }), _$concat3)), (0, _defineProperty2.default)(_$concat4, "&-round ".concat(componentCls, "-content"), (0, _defineProperty2.default)({}, "".concat(skeletonTitleCls, ", ").concat(skeletonParagraphCls, " > li"), {
    borderRadius: borderRadius
  })), _$concat4)), (0, _defineProperty2.default)(_ref5, "".concat(componentCls, "-with-avatar ").concat(componentCls, "-content"), (0, _defineProperty2.default)({}, "".concat(skeletonTitleCls), (0, _defineProperty2.default)({
    marginBlockStart: marginSM
  }, "+ ".concat(skeletonParagraphCls), {
    marginBlockStart: skeletonParagraphMarginTop
  }))), (0, _defineProperty2.default)(_ref5, "".concat(componentCls).concat(componentCls, "-element"), (0, _extends6.default)((0, _extends6.default)((0, _extends6.default)((0, _extends6.default)({
    display: 'inline-block',
    width: 'auto'
  }, genSkeletonElementButton(token)), genSkeletonElementAvatar(token)), genSkeletonElementInput(token)), genSkeletonElementImage(token))), (0, _defineProperty2.default)(_ref5, "".concat(componentCls).concat(componentCls, "-block"), (_$concat$concat2 = {
    width: '100%'
  }, (0, _defineProperty2.default)(_$concat$concat2, "".concat(skeletonButtonCls), {
    width: '100%'
  }), (0, _defineProperty2.default)(_$concat$concat2, "".concat(skeletonInputCls), {
    width: '100%'
  }), _$concat$concat2)), (0, _defineProperty2.default)(_ref5, "".concat(componentCls).concat(componentCls, "-active"), (0, _defineProperty2.default)({}, "\n        ".concat(skeletonTitleCls, ",\n        ").concat(skeletonParagraphCls, " > li,\n        ").concat(skeletonAvatarCls, ",\n        ").concat(skeletonButtonCls, ",\n        ").concat(skeletonInputCls, ",\n        ").concat(skeletonImageCls, "\n      "), (0, _extends6.default)({}, genSkeletonColor(token)))), _ref5;
};
// ============================== Export ==============================
var _default = (0, _internal.genComponentStyleHook)('Skeleton', function (token) {
  var componentCls = token.componentCls;
  var skeletonToken = (0, _internal.mergeToken)(token, {
    skeletonAvatarCls: "".concat(componentCls, "-avatar"),
    skeletonTitleCls: "".concat(componentCls, "-title"),
    skeletonParagraphCls: "".concat(componentCls, "-paragraph"),
    skeletonButtonCls: "".concat(componentCls, "-button"),
    skeletonInputCls: "".concat(componentCls, "-input"),
    skeletonImageCls: "".concat(componentCls, "-image"),
    imageSizeBase: token.controlHeight * 1.5,
    skeletonTitleHeight: token.controlHeight / 2,
    skeletonBlockRadius: token.borderRadiusSM,
    skeletonParagraphLineHeight: token.controlHeight / 2,
    skeletonParagraphMarginTop: token.marginLG + token.marginXXS,
    borderRadius: 100,
    skeletonLoadingBackground: "linear-gradient(90deg, ".concat(token.color, " 25%, ").concat(token.colorGradientEnd, " 37%, ").concat(token.color, " 63%)"),
    skeletonLoadingMotionDuration: '1.4s'
  });
  return [genBaseStyle(skeletonToken)];
}, function (token) {
  var colorFillContent = token.colorFillContent,
    colorFill = token.colorFill;
  return {
    color: colorFillContent,
    colorGradientEnd: colorFill
  };
});
exports.default = _default;