"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sliderProps = exports.default = void 0;
var _vue = require("vue");
var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _Slider = _interopRequireDefault(require("../vc-slider/src/Slider"));
var _Range = _interopRequireDefault(require("../vc-slider/src/Range"));
var _Handle = _interopRequireDefault(require("../vc-slider/src/Handle"));
var _type = require("../_util/type");
var _useConfigInject2 = _interopRequireDefault(require("../config-provider/hooks/useConfigInject"));
var _SliderTooltip = _interopRequireDefault(require("./SliderTooltip"));
var _classNames2 = _interopRequireDefault(require("../_util/classNames"));
var _FormItemContext = require("../form/FormItemContext");
var _style = _interopRequireDefault(require("./style"));
var _devWarning = _interopRequireDefault(require("../vc-util/devWarning"));
var __rest = void 0 && (void 0).__rest || function (s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};

// CSSINJS

var defaultTipFormatter = function defaultTipFormatter(value) {
  return typeof value === 'number' ? value.toString() : '';
};
var sliderProps = function sliderProps() {
  return {
    id: String,
    prefixCls: String,
    tooltipPrefixCls: String,
    range: (0, _type.someType)([Boolean, Object]),
    reverse: (0, _type.booleanType)(),
    min: Number,
    max: Number,
    step: (0, _type.someType)([Object, Number]),
    marks: (0, _type.objectType)(),
    dots: (0, _type.booleanType)(),
    value: (0, _type.someType)([Array, Number]),
    defaultValue: (0, _type.someType)([Array, Number]),
    included: (0, _type.booleanType)(),
    disabled: (0, _type.booleanType)(),
    vertical: (0, _type.booleanType)(),
    tipFormatter: (0, _type.someType)([Function, Object], function () {
      return defaultTipFormatter;
    }),
    tooltipOpen: (0, _type.booleanType)(),
    /** @deprecated `tooltipVisible` is deprecated. Please use `tooltipOpen` instead. */
    tooltipVisible: (0, _type.booleanType)(),
    tooltipPlacement: (0, _type.stringType)(),
    getTooltipPopupContainer: (0, _type.functionType)(),
    autofocus: (0, _type.booleanType)(),
    handleStyle: (0, _type.someType)([Array, Object]),
    trackStyle: (0, _type.someType)([Array, Object]),
    onChange: (0, _type.functionType)(),
    onAfterChange: (0, _type.functionType)(),
    onFocus: (0, _type.functionType)(),
    onBlur: (0, _type.functionType)(),
    'onUpdate:value': (0, _type.functionType)()
  };
};
exports.sliderProps = sliderProps;
var Slider = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'ASlider',
  inheritAttrs: false,
  props: sliderProps(),
  // emits: ['update:value', 'change', 'afterChange', 'blur'],
  slots: ['mark'],
  setup: function setup(props, _ref) {
    var attrs = _ref.attrs,
      slots = _ref.slots,
      emit = _ref.emit,
      expose = _ref.expose;
    // Warning for deprecated usage
    if (process.env.NODE_ENV !== 'production') {
      [['tooltipVisible', 'tooltipOpen']].forEach(function (_ref2) {
        var _ref3 = (0, _slicedToArray2.default)(_ref2, 2),
          deprecatedName = _ref3[0],
          newName = _ref3[1];
        (0, _devWarning.default)(props.tooltipVisible === undefined, 'Slider', "`".concat(deprecatedName, "` is deprecated, please use `").concat(newName, "` instead."));
      });
    }
    var _useConfigInject = (0, _useConfigInject2.default)('slider', props),
      prefixCls = _useConfigInject.prefixCls,
      rootPrefixCls = _useConfigInject.rootPrefixCls,
      direction = _useConfigInject.direction,
      getPopupContainer = _useConfigInject.getPopupContainer,
      configProvider = _useConfigInject.configProvider;
    // style
    var _useStyle = (0, _style.default)(prefixCls),
      _useStyle2 = (0, _slicedToArray2.default)(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var formItemContext = (0, _FormItemContext.useInjectFormItemContext)();
    var sliderRef = (0, _vue.ref)();
    var visibles = (0, _vue.ref)({});
    var toggleTooltipOpen = function toggleTooltipOpen(index, visible) {
      visibles.value[index] = visible;
    };
    var tooltipPlacement = (0, _vue.computed)(function () {
      if (props.tooltipPlacement) {
        return props.tooltipPlacement;
      }
      if (!props.vertical) {
        return 'top';
      }
      return direction.value === 'rtl' ? 'left' : 'right';
    });
    var focus = function focus() {
      var _a;
      (_a = sliderRef.value) === null || _a === void 0 ? void 0 : _a.focus();
    };
    var blur = function blur() {
      var _a;
      (_a = sliderRef.value) === null || _a === void 0 ? void 0 : _a.blur();
    };
    var handleChange = function handleChange(val) {
      emit('update:value', val);
      emit('change', val);
      formItemContext.onFieldChange();
    };
    var handleBlur = function handleBlur(e) {
      emit('blur', e);
    };
    expose({
      focus: focus,
      blur: blur
    });
    var handleWithTooltip = function handleWithTooltip(_a) {
      var tooltipPrefixCls = _a.tooltipPrefixCls,
        _b = _a.info,
        value = _b.value,
        dragging = _b.dragging,
        index = _b.index,
        restProps = __rest(_b, ["value", "dragging", "index"]);
      var tipFormatter = props.tipFormatter,
        _props$tooltipOpen = props.tooltipOpen,
        tooltipOpen = _props$tooltipOpen === void 0 ? props.tooltipVisible : _props$tooltipOpen,
        getTooltipPopupContainer = props.getTooltipPopupContainer;
      var isTipFormatter = tipFormatter ? visibles.value[index] || dragging : false;
      var open = tooltipOpen || tooltipOpen === undefined && isTipFormatter;
      return (0, _vue.createVNode)(_SliderTooltip.default, {
        "prefixCls": tooltipPrefixCls,
        "title": tipFormatter ? tipFormatter(value) : '',
        "open": open,
        "placement": tooltipPlacement.value,
        "transitionName": "".concat(rootPrefixCls.value, "-zoom-down"),
        "key": index,
        "overlayClassName": "".concat(prefixCls.value, "-tooltip"),
        "getPopupContainer": getTooltipPopupContainer || (getPopupContainer === null || getPopupContainer === void 0 ? void 0 : getPopupContainer.value)
      }, {
        default: function _default() {
          return [(0, _vue.createVNode)(_Handle.default, (0, _objectSpread2.default)((0, _objectSpread2.default)({}, restProps), {}, {
            "value": value,
            "onMouseenter": function onMouseenter() {
              return toggleTooltipOpen(index, true);
            },
            "onMouseleave": function onMouseleave() {
              return toggleTooltipOpen(index, false);
            }
          }), null)];
        }
      });
    };
    return function () {
      var customizeTooltipPrefixCls = props.tooltipPrefixCls,
        range = props.range,
        _props$id = props.id,
        id = _props$id === void 0 ? formItemContext.id.value : _props$id,
        restProps = __rest(props, ["tooltipPrefixCls", "range", "id"]);
      var tooltipPrefixCls = configProvider.getPrefixCls('tooltip', customizeTooltipPrefixCls);
      var cls = (0, _classNames2.default)(attrs.class, (0, _defineProperty2.default)({}, "".concat(prefixCls.value, "-rtl"), direction.value === 'rtl'), hashId.value);
      // make reverse default on rtl direction
      if (direction.value === 'rtl' && !restProps.vertical) {
        restProps.reverse = !restProps.reverse;
      }
      // extrack draggableTrack from range={{ ... }}
      var draggableTrack;
      if ((0, _typeof2.default)(range) === 'object') {
        draggableTrack = range.draggableTrack;
      }
      if (range) {
        return wrapSSR((0, _vue.createVNode)(_Range.default, (0, _objectSpread2.default)((0, _objectSpread2.default)((0, _objectSpread2.default)({}, attrs), restProps), {}, {
          "step": restProps.step,
          "draggableTrack": draggableTrack,
          "class": cls,
          "ref": sliderRef,
          "handle": function handle(info) {
            return handleWithTooltip({
              tooltipPrefixCls: tooltipPrefixCls,
              prefixCls: prefixCls.value,
              info: info
            });
          },
          "prefixCls": prefixCls.value,
          "onChange": handleChange,
          "onBlur": handleBlur
        }), {
          mark: slots.mark
        }));
      }
      return wrapSSR((0, _vue.createVNode)(_Slider.default, (0, _objectSpread2.default)((0, _objectSpread2.default)((0, _objectSpread2.default)({}, attrs), restProps), {}, {
        "id": id,
        "step": restProps.step,
        "class": cls,
        "ref": sliderRef,
        "handle": function handle(info) {
          return handleWithTooltip({
            tooltipPrefixCls: tooltipPrefixCls,
            prefixCls: prefixCls.value,
            info: info
          });
        },
        "prefixCls": prefixCls.value,
        "onChange": handleChange,
        "onBlur": handleBlur
      }), {
        mark: slots.mark
      }));
    };
  }
});
var _default2 = (0, _type.withInstall)(Slider);
exports.default = _default2;