"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCompactItemContext = exports.spaceCompactProps = exports.spaceCompactItemProps = exports.default = exports.SpaceCompactItemContext = exports.NoCompactStyle = void 0;
var _vue = require("vue");
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _classNames3 = _interopRequireDefault(require("../_util/classNames"));
var _createContext = _interopRequireDefault(require("../_util/createContext"));
var _useConfigInject2 = _interopRequireDefault(require("../config-provider/hooks/useConfigInject"));
var _style = _interopRequireDefault(require("./style"));
var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));
var _type = require("../_util/type");
var _lodashEs = require("lodash");
var _propsUtil = require("../_util/props-util");
var spaceCompactItemProps = function spaceCompactItemProps() {
  return {
    compactSize: String,
    compactDirection: _vueTypes.default.oneOf((0, _type.tuple)('horizontal', 'vertical')).def('horizontal'),
    isFirstItem: (0, _type.booleanType)(),
    isLastItem: (0, _type.booleanType)()
  };
};
exports.spaceCompactItemProps = spaceCompactItemProps;
var SpaceCompactItemContext = (0, _createContext.default)(null);
exports.SpaceCompactItemContext = SpaceCompactItemContext;
var useCompactItemContext = function useCompactItemContext(prefixCls, direction) {
  var compactItemContext = SpaceCompactItemContext.useInject();
  var compactItemClassnames = (0, _vue.computed)(function () {
    var _classNames;
    if (!compactItemContext || (0, _lodashEs.isEmpty)(compactItemContext)) return '';
    var compactDirection = compactItemContext.compactDirection,
      isFirstItem = compactItemContext.isFirstItem,
      isLastItem = compactItemContext.isLastItem;
    var separator = compactDirection === 'vertical' ? '-vertical-' : '-';
    return (0, _classNames3.default)((_classNames = {}, (0, _defineProperty2.default)(_classNames, "".concat(prefixCls.value, "-compact").concat(separator, "item"), true), (0, _defineProperty2.default)(_classNames, "".concat(prefixCls.value, "-compact").concat(separator, "first-item"), isFirstItem), (0, _defineProperty2.default)(_classNames, "".concat(prefixCls.value, "-compact").concat(separator, "last-item"), isLastItem), (0, _defineProperty2.default)(_classNames, "".concat(prefixCls.value, "-compact").concat(separator, "item-rtl"), direction.value === 'rtl'), _classNames));
  });
  return {
    compactSize: (0, _vue.computed)(function () {
      return compactItemContext === null || compactItemContext === void 0 ? void 0 : compactItemContext.compactSize;
    }),
    compactDirection: (0, _vue.computed)(function () {
      return compactItemContext === null || compactItemContext === void 0 ? void 0 : compactItemContext.compactDirection;
    }),
    compactItemClassnames: compactItemClassnames
  };
};
exports.useCompactItemContext = useCompactItemContext;
var NoCompactStyle = (0, _vue.defineComponent)({
  name: 'NoCompactStyle',
  setup: function setup(_, _ref) {
    var slots = _ref.slots;
    SpaceCompactItemContext.useProvide(null);
    return function () {
      var _a;
      return (_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots);
    };
  }
});
exports.NoCompactStyle = NoCompactStyle;
var spaceCompactProps = function spaceCompactProps() {
  return {
    prefixCls: String,
    size: {
      type: String
    },
    direction: _vueTypes.default.oneOf((0, _type.tuple)('horizontal', 'vertical')).def('horizontal'),
    align: _vueTypes.default.oneOf((0, _type.tuple)('start', 'end', 'center', 'baseline')),
    block: {
      type: Boolean,
      default: undefined
    }
  };
};
exports.spaceCompactProps = spaceCompactProps;
var CompactItem = (0, _vue.defineComponent)({
  name: 'CompactItem',
  props: spaceCompactItemProps(),
  setup: function setup(props, _ref2) {
    var slots = _ref2.slots;
    SpaceCompactItemContext.useProvide(props);
    return function () {
      var _a;
      return (_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots);
    };
  }
});
var Compact = (0, _vue.defineComponent)({
  name: 'ASpaceCompact',
  inheritAttrs: false,
  props: spaceCompactProps(),
  setup: function setup(props, _ref3) {
    var attrs = _ref3.attrs,
      slots = _ref3.slots;
    var _useConfigInject = (0, _useConfigInject2.default)('space-compact', props),
      prefixCls = _useConfigInject.prefixCls,
      directionConfig = _useConfigInject.direction;
    var compactItemContext = SpaceCompactItemContext.useInject();
    var _useStyle = (0, _style.default)(prefixCls),
      _useStyle2 = (0, _slicedToArray2.default)(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var clx = (0, _vue.computed)(function () {
      var _classNames2;
      return (0, _classNames3.default)(prefixCls.value, hashId.value, (_classNames2 = {}, (0, _defineProperty2.default)(_classNames2, "".concat(prefixCls.value, "-rtl"), directionConfig.value === 'rtl'), (0, _defineProperty2.default)(_classNames2, "".concat(prefixCls.value, "-block"), props.block), (0, _defineProperty2.default)(_classNames2, "".concat(prefixCls.value, "-vertical"), props.direction === 'vertical'), _classNames2));
    });
    return function () {
      var _a;
      var childNodes = (0, _propsUtil.flattenChildren)(((_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots)) || []);
      // =========================== Render ===========================
      if (childNodes.length === 0) {
        return null;
      }
      return wrapSSR((0, _vue.createVNode)("div", (0, _objectSpread2.default)((0, _objectSpread2.default)({}, attrs), {}, {
        "class": [clx.value, attrs.class]
      }), [childNodes.map(function (child, i) {
        var _a;
        var key = child && child.key || "".concat(prefixCls.value, "-item-").concat(i);
        var noCompactItemContext = !compactItemContext || (0, _lodashEs.isEmpty)(compactItemContext);
        return (0, _vue.createVNode)(CompactItem, {
          "key": key,
          "compactSize": (_a = props.size) !== null && _a !== void 0 ? _a : 'middle',
          "compactDirection": props.direction,
          "isFirstItem": i === 0 && (noCompactItemContext || (compactItemContext === null || compactItemContext === void 0 ? void 0 : compactItemContext.isFirstItem)),
          "isLastItem": i === childNodes.length - 1 && (noCompactItemContext || (compactItemContext === null || compactItemContext === void 0 ? void 0 : compactItemContext.isLastItem))
        }, {
          default: function _default() {
            return [child];
          }
        });
      })]));
    };
  }
});
var _default2 = Compact;
exports.default = _default2;