"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends5 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var genStepsInlineStyle = function genStepsInlineStyle(token) {
  var _icon, _extends3, _$concat;
  var componentCls = token.componentCls,
    inlineDotSize = token.inlineDotSize,
    inlineTitleColor = token.inlineTitleColor,
    inlineTailColor = token.inlineTailColor;
  var containerPaddingTop = token.paddingXS + token.lineWidth;
  var titleStyle = (0, _defineProperty2.default)({}, "".concat(componentCls, "-item-container ").concat(componentCls, "-item-content ").concat(componentCls, "-item-title"), {
    color: inlineTitleColor
  });
  return (0, _defineProperty2.default)({}, "&".concat(componentCls, "-inline"), (0, _defineProperty2.default)({
    width: 'auto',
    display: 'inline-flex'
  }, "".concat(componentCls, "-item"), (_$concat = {
    flex: 'none',
    '&-container': (0, _defineProperty2.default)({
      padding: "".concat(containerPaddingTop, "px ").concat(token.paddingXXS, "px 0"),
      margin: "0 ".concat(token.marginXXS / 2, "px"),
      borderRadius: token.borderRadiusSM,
      cursor: 'pointer',
      transition: "background-color ".concat(token.motionDurationMid),
      '&:hover': {
        background: token.controlItemBgHover
      }
    }, "&[role='button']:hover", {
      opacity: 1
    }),
    '&-icon': (_icon = {
      width: inlineDotSize,
      height: inlineDotSize,
      marginInlineStart: "calc(50% - ".concat(inlineDotSize / 2, "px)")
    }, (0, _defineProperty2.default)(_icon, "> ".concat(componentCls, "-icon"), {
      top: 0
    }), (0, _defineProperty2.default)(_icon, "".concat(componentCls, "-icon-dot"), {
      borderRadius: token.fontSizeSM / 4
    }), _icon),
    '&-content': {
      width: 'auto',
      marginTop: token.marginXS - token.lineWidth
    },
    '&-title': {
      color: inlineTitleColor,
      fontSize: token.fontSizeSM,
      lineHeight: token.lineHeightSM,
      fontWeight: 'normal',
      marginBottom: token.marginXXS / 2
    },
    '&-description': {
      display: 'none'
    },
    '&-tail': {
      marginInlineStart: 0,
      top: containerPaddingTop + inlineDotSize / 2,
      transform: "translateY(-50%)",
      '&:after': {
        width: '100%',
        height: token.lineWidth,
        borderRadius: 0,
        marginInlineStart: 0,
        background: inlineTailColor
      }
    }
  }, (0, _defineProperty2.default)(_$concat, "&:first-child ".concat(componentCls, "-item-tail"), {
    width: '50%',
    marginInlineStart: '50%'
  }), (0, _defineProperty2.default)(_$concat, "&:last-child ".concat(componentCls, "-item-tail"), {
    display: 'block',
    width: '50%'
  }), (0, _defineProperty2.default)(_$concat, '&-wait', (0, _extends5.default)((0, _defineProperty2.default)({}, "".concat(componentCls, "-item-icon ").concat(componentCls, "-icon ").concat(componentCls, "-icon-dot"), {
    backgroundColor: token.colorBorderBg,
    border: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(inlineTailColor)
  }), titleStyle)), (0, _defineProperty2.default)(_$concat, '&-finish', (0, _extends5.default)((_extends3 = {}, (0, _defineProperty2.default)(_extends3, "".concat(componentCls, "-item-tail::after"), {
    backgroundColor: inlineTailColor
  }), (0, _defineProperty2.default)(_extends3, "".concat(componentCls, "-item-icon ").concat(componentCls, "-icon ").concat(componentCls, "-icon-dot"), {
    backgroundColor: inlineTailColor,
    border: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(inlineTailColor)
  }), _extends3), titleStyle)), (0, _defineProperty2.default)(_$concat, '&-error', titleStyle), (0, _defineProperty2.default)(_$concat, '&-active, &-process', (0, _extends5.default)((0, _defineProperty2.default)({}, "".concat(componentCls, "-item-icon"), {
    width: inlineDotSize,
    height: inlineDotSize,
    marginInlineStart: "calc(50% - ".concat(inlineDotSize / 2, "px)"),
    top: 0
  }), titleStyle)), (0, _defineProperty2.default)(_$concat, "&:not(".concat(componentCls, "-item-active) > ").concat(componentCls, "-item-container[role='button']:hover"), (0, _defineProperty2.default)({}, "".concat(componentCls, "-item-title"), {
    color: inlineTitleColor
  })), _$concat)));
};
var _default = genStepsInlineStyle;
exports.default = _default;