"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends5 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
require("../../_util/cssinjs");
var _internal = require("../../theme/internal");
var _style = require("../../style");
var _motion = _interopRequireDefault(require("./motion"));
var genCardStyle = function genCardStyle(token) {
  var _$concat$concat, _$concat$concat4, _$concat$concat5, _$concat$concat8, _$concat$concat9, _$concat5;
  var componentCls = token.componentCls,
    tabsCardHorizontalPadding = token.tabsCardHorizontalPadding,
    tabsCardHeadBackground = token.tabsCardHeadBackground,
    tabsCardGutter = token.tabsCardGutter,
    colorSplit = token.colorSplit;
  return (0, _defineProperty2.default)({}, "".concat(componentCls, "-card"), (_$concat5 = {}, (0, _defineProperty2.default)(_$concat5, "> ".concat(componentCls, "-nav, > div > ").concat(componentCls, "-nav"), (_$concat$concat = {}, (0, _defineProperty2.default)(_$concat$concat, "".concat(componentCls, "-tab"), {
    margin: 0,
    padding: tabsCardHorizontalPadding,
    background: tabsCardHeadBackground,
    border: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(colorSplit),
    transition: "all ".concat(token.motionDurationSlow, " ").concat(token.motionEaseInOut)
  }), (0, _defineProperty2.default)(_$concat$concat, "".concat(componentCls, "-tab-active"), {
    color: token.colorPrimary,
    background: token.colorBgContainer
  }), (0, _defineProperty2.default)(_$concat$concat, "".concat(componentCls, "-ink-bar"), {
    visibility: 'hidden'
  }), _$concat$concat)), (0, _defineProperty2.default)(_$concat5, "&".concat(componentCls, "-top, &").concat(componentCls, "-bottom"), (0, _defineProperty2.default)({}, "> ".concat(componentCls, "-nav, > div > ").concat(componentCls, "-nav"), (0, _defineProperty2.default)({}, "".concat(componentCls, "-tab + ").concat(componentCls, "-tab"), {
    marginLeft: {
      _skip_check_: true,
      value: "".concat(tabsCardGutter, "px")
    }
  }))), (0, _defineProperty2.default)(_$concat5, "&".concat(componentCls, "-top"), (0, _defineProperty2.default)({}, "> ".concat(componentCls, "-nav, > div > ").concat(componentCls, "-nav"), (_$concat$concat4 = {}, (0, _defineProperty2.default)(_$concat$concat4, "".concat(componentCls, "-tab"), {
    borderRadius: "".concat(token.borderRadiusLG, "px ").concat(token.borderRadiusLG, "px 0 0")
  }), (0, _defineProperty2.default)(_$concat$concat4, "".concat(componentCls, "-tab-active"), {
    borderBottomColor: token.colorBgContainer
  }), _$concat$concat4))), (0, _defineProperty2.default)(_$concat5, "&".concat(componentCls, "-bottom"), (0, _defineProperty2.default)({}, "> ".concat(componentCls, "-nav, > div > ").concat(componentCls, "-nav"), (_$concat$concat5 = {}, (0, _defineProperty2.default)(_$concat$concat5, "".concat(componentCls, "-tab"), {
    borderRadius: "0 0 ".concat(token.borderRadiusLG, "px ").concat(token.borderRadiusLG, "px")
  }), (0, _defineProperty2.default)(_$concat$concat5, "".concat(componentCls, "-tab-active"), {
    borderTopColor: token.colorBgContainer
  }), _$concat$concat5))), (0, _defineProperty2.default)(_$concat5, "&".concat(componentCls, "-left, &").concat(componentCls, "-right"), (0, _defineProperty2.default)({}, "> ".concat(componentCls, "-nav, > div > ").concat(componentCls, "-nav"), (0, _defineProperty2.default)({}, "".concat(componentCls, "-tab + ").concat(componentCls, "-tab"), {
    marginTop: "".concat(tabsCardGutter, "px")
  }))), (0, _defineProperty2.default)(_$concat5, "&".concat(componentCls, "-left"), (0, _defineProperty2.default)({}, "> ".concat(componentCls, "-nav, > div > ").concat(componentCls, "-nav"), (_$concat$concat8 = {}, (0, _defineProperty2.default)(_$concat$concat8, "".concat(componentCls, "-tab"), {
    borderRadius: {
      _skip_check_: true,
      value: "".concat(token.borderRadiusLG, "px 0 0 ").concat(token.borderRadiusLG, "px")
    }
  }), (0, _defineProperty2.default)(_$concat$concat8, "".concat(componentCls, "-tab-active"), {
    borderRightColor: {
      _skip_check_: true,
      value: token.colorBgContainer
    }
  }), _$concat$concat8))), (0, _defineProperty2.default)(_$concat5, "&".concat(componentCls, "-right"), (0, _defineProperty2.default)({}, "> ".concat(componentCls, "-nav, > div > ").concat(componentCls, "-nav"), (_$concat$concat9 = {}, (0, _defineProperty2.default)(_$concat$concat9, "".concat(componentCls, "-tab"), {
    borderRadius: {
      _skip_check_: true,
      value: "0 ".concat(token.borderRadiusLG, "px ").concat(token.borderRadiusLG, "px 0")
    }
  }), (0, _defineProperty2.default)(_$concat$concat9, "".concat(componentCls, "-tab-active"), {
    borderLeftColor: {
      _skip_check_: true,
      value: token.colorBgContainer
    }
  }), _$concat$concat9))), _$concat5));
};
var genDropdownStyle = function genDropdownStyle(token) {
  var componentCls = token.componentCls,
    tabsHoverColor = token.tabsHoverColor,
    dropdownEdgeChildVerticalPadding = token.dropdownEdgeChildVerticalPadding;
  return (0, _defineProperty2.default)({}, "".concat(componentCls, "-dropdown"), (0, _extends5.default)((0, _extends5.default)({}, (0, _style.resetComponent)(token)), (0, _defineProperty2.default)({
    position: 'absolute',
    top: -9999,
    left: {
      _skip_check_: true,
      value: -9999
    },
    zIndex: token.zIndexPopup,
    display: 'block',
    '&-hidden': {
      display: 'none'
    }
  }, "".concat(componentCls, "-dropdown-menu"), {
    maxHeight: token.tabsDropdownHeight,
    margin: 0,
    padding: "".concat(dropdownEdgeChildVerticalPadding, "px 0"),
    overflowX: 'hidden',
    overflowY: 'auto',
    textAlign: {
      _skip_check_: true,
      value: 'left'
    },
    listStyleType: 'none',
    backgroundColor: token.colorBgContainer,
    backgroundClip: 'padding-box',
    borderRadius: token.borderRadiusLG,
    outline: 'none',
    boxShadow: token.boxShadowSecondary,
    '&-item': (0, _extends5.default)((0, _extends5.default)({}, _style.textEllipsis), {
      display: 'flex',
      alignItems: 'center',
      minWidth: token.tabsDropdownWidth,
      margin: 0,
      padding: "".concat(token.paddingXXS, "px ").concat(token.paddingSM, "px"),
      color: token.colorText,
      fontWeight: 'normal',
      fontSize: token.fontSize,
      lineHeight: token.lineHeight,
      cursor: 'pointer',
      transition: "all ".concat(token.motionDurationSlow),
      '> span': {
        flex: 1,
        whiteSpace: 'nowrap'
      },
      '&-remove': {
        flex: 'none',
        marginLeft: {
          _skip_check_: true,
          value: token.marginSM
        },
        color: token.colorTextDescription,
        fontSize: token.fontSizeSM,
        background: 'transparent',
        border: 0,
        cursor: 'pointer',
        '&:hover': {
          color: tabsHoverColor
        }
      },
      '&:hover': {
        background: token.controlItemBgHover
      },
      '&-disabled': {
        '&, &:hover': {
          color: token.colorTextDisabled,
          background: 'transparent',
          cursor: 'not-allowed'
        }
      }
    })
  })));
};
var genPositionStyle = function genPositionStyle(token) {
  var _$concat6, _$concat$concat10, _$concat8, _$concat9, _$concat$concat14, _$concat10, _$concat11, _ref3;
  var componentCls = token.componentCls,
    margin = token.margin,
    colorSplit = token.colorSplit;
  return _ref3 = {}, (0, _defineProperty2.default)(_ref3, "".concat(componentCls, "-top, ").concat(componentCls, "-bottom"), (0, _defineProperty2.default)({
    flexDirection: 'column'
  }, "> ".concat(componentCls, "-nav, > div > ").concat(componentCls, "-nav"), (_$concat$concat10 = {
    margin: "0 0 ".concat(margin, "px 0"),
    '&::before': {
      position: 'absolute',
      right: {
        _skip_check_: true,
        value: 0
      },
      left: {
        _skip_check_: true,
        value: 0
      },
      borderBottom: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(colorSplit),
      content: "''"
    }
  }, (0, _defineProperty2.default)(_$concat$concat10, "".concat(componentCls, "-ink-bar"), {
    height: token.lineWidthBold,
    '&-animated': {
      transition: "width ".concat(token.motionDurationSlow, ", left ").concat(token.motionDurationSlow, ",\n            right ").concat(token.motionDurationSlow)
    }
  }), (0, _defineProperty2.default)(_$concat$concat10, "".concat(componentCls, "-nav-wrap"), (_$concat6 = {
    '&::before, &::after': {
      top: 0,
      bottom: 0,
      width: token.controlHeight
    },
    '&::before': {
      left: {
        _skip_check_: true,
        value: 0
      },
      boxShadow: token.boxShadowTabsOverflowLeft
    },
    '&::after': {
      right: {
        _skip_check_: true,
        value: 0
      },
      boxShadow: token.boxShadowTabsOverflowRight
    }
  }, (0, _defineProperty2.default)(_$concat6, "&".concat(componentCls, "-nav-wrap-ping-left::before"), {
    opacity: 1
  }), (0, _defineProperty2.default)(_$concat6, "&".concat(componentCls, "-nav-wrap-ping-right::after"), {
    opacity: 1
  }), _$concat6)), _$concat$concat10))), (0, _defineProperty2.default)(_ref3, "".concat(componentCls, "-top"), (0, _defineProperty2.default)({}, "> ".concat(componentCls, "-nav,\n        > div > ").concat(componentCls, "-nav"), (0, _defineProperty2.default)({
    '&::before': {
      bottom: 0
    }
  }, "".concat(componentCls, "-ink-bar"), {
    bottom: 0
  }))), (0, _defineProperty2.default)(_ref3, "".concat(componentCls, "-bottom"), (_$concat8 = {}, (0, _defineProperty2.default)(_$concat8, "> ".concat(componentCls, "-nav, > div > ").concat(componentCls, "-nav"), (0, _defineProperty2.default)({
    order: 1,
    marginTop: "".concat(margin, "px"),
    marginBottom: 0,
    '&::before': {
      top: 0
    }
  }, "".concat(componentCls, "-ink-bar"), {
    top: 0
  })), (0, _defineProperty2.default)(_$concat8, "> ".concat(componentCls, "-content-holder, > div > ").concat(componentCls, "-content-holder"), {
    order: 0
  }), _$concat8)), (0, _defineProperty2.default)(_ref3, "".concat(componentCls, "-left, ").concat(componentCls, "-right"), (0, _defineProperty2.default)({}, "> ".concat(componentCls, "-nav, > div > ").concat(componentCls, "-nav"), (_$concat$concat14 = {
    flexDirection: 'column',
    minWidth: token.controlHeight * 1.25
  }, (0, _defineProperty2.default)(_$concat$concat14, "".concat(componentCls, "-tab"), {
    padding: "".concat(token.paddingXS, "px ").concat(token.paddingLG, "px"),
    textAlign: 'center'
  }), (0, _defineProperty2.default)(_$concat$concat14, "".concat(componentCls, "-tab + ").concat(componentCls, "-tab"), {
    margin: "".concat(token.margin, "px 0 0 0")
  }), (0, _defineProperty2.default)(_$concat$concat14, "".concat(componentCls, "-nav-wrap"), (_$concat9 = {
    flexDirection: 'column',
    '&::before, &::after': {
      right: {
        _skip_check_: true,
        value: 0
      },
      left: {
        _skip_check_: true,
        value: 0
      },
      height: token.controlHeight
    },
    '&::before': {
      top: 0,
      boxShadow: token.boxShadowTabsOverflowTop
    },
    '&::after': {
      bottom: 0,
      boxShadow: token.boxShadowTabsOverflowBottom
    }
  }, (0, _defineProperty2.default)(_$concat9, "&".concat(componentCls, "-nav-wrap-ping-top::before"), {
    opacity: 1
  }), (0, _defineProperty2.default)(_$concat9, "&".concat(componentCls, "-nav-wrap-ping-bottom::after"), {
    opacity: 1
  }), _$concat9)), (0, _defineProperty2.default)(_$concat$concat14, "".concat(componentCls, "-ink-bar"), {
    width: token.lineWidthBold,
    '&-animated': {
      transition: "height ".concat(token.motionDurationSlow, ", top ").concat(token.motionDurationSlow)
    }
  }), (0, _defineProperty2.default)(_$concat$concat14, "".concat(componentCls, "-nav-list, ").concat(componentCls, "-nav-operations"), {
    flex: '1 0 auto',
    flexDirection: 'column'
  }), _$concat$concat14))), (0, _defineProperty2.default)(_ref3, "".concat(componentCls, "-left"), (_$concat10 = {}, (0, _defineProperty2.default)(_$concat10, "> ".concat(componentCls, "-nav, > div > ").concat(componentCls, "-nav"), (0, _defineProperty2.default)({}, "".concat(componentCls, "-ink-bar"), {
    right: {
      _skip_check_: true,
      value: 0
    }
  })), (0, _defineProperty2.default)(_$concat10, "> ".concat(componentCls, "-content-holder, > div > ").concat(componentCls, "-content-holder"), (0, _defineProperty2.default)({
    marginLeft: {
      _skip_check_: true,
      value: "-".concat(token.lineWidth, "px")
    },
    borderLeft: {
      _skip_check_: true,
      value: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(token.colorBorder)
    }
  }, "> ".concat(componentCls, "-content > ").concat(componentCls, "-tabpane"), {
    paddingLeft: {
      _skip_check_: true,
      value: token.paddingLG
    }
  })), _$concat10)), (0, _defineProperty2.default)(_ref3, "".concat(componentCls, "-right"), (_$concat11 = {}, (0, _defineProperty2.default)(_$concat11, "> ".concat(componentCls, "-nav, > div > ").concat(componentCls, "-nav"), (0, _defineProperty2.default)({
    order: 1
  }, "".concat(componentCls, "-ink-bar"), {
    left: {
      _skip_check_: true,
      value: 0
    }
  })), (0, _defineProperty2.default)(_$concat11, "> ".concat(componentCls, "-content-holder, > div > ").concat(componentCls, "-content-holder"), (0, _defineProperty2.default)({
    order: 0,
    marginRight: {
      _skip_check_: true,
      value: -token.lineWidth
    },
    borderRight: {
      _skip_check_: true,
      value: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(token.colorBorder)
    }
  }, "> ".concat(componentCls, "-content > ").concat(componentCls, "-tabpane"), {
    paddingRight: {
      _skip_check_: true,
      value: token.paddingLG
    }
  })), _$concat11)), _ref3;
};
var genSizeStyle = function genSizeStyle(token) {
  var _$concat19, _$concat22, _ref4;
  var componentCls = token.componentCls,
    padding = token.padding;
  return _ref4 = {}, (0, _defineProperty2.default)(_ref4, componentCls, {
    '&-small': (0, _defineProperty2.default)({}, "> ".concat(componentCls, "-nav"), (0, _defineProperty2.default)({}, "".concat(componentCls, "-tab"), {
      padding: "".concat(token.paddingXS, "px 0"),
      fontSize: token.fontSize
    })),
    '&-large': (0, _defineProperty2.default)({}, "> ".concat(componentCls, "-nav"), (0, _defineProperty2.default)({}, "".concat(componentCls, "-tab"), {
      padding: "".concat(padding, "px 0"),
      fontSize: token.fontSizeLG
    }))
  }), (0, _defineProperty2.default)(_ref4, "".concat(componentCls, "-card"), (_$concat22 = {}, (0, _defineProperty2.default)(_$concat22, "&".concat(componentCls, "-small"), (_$concat19 = {}, (0, _defineProperty2.default)(_$concat19, "> ".concat(componentCls, "-nav"), (0, _defineProperty2.default)({}, "".concat(componentCls, "-tab"), {
    padding: "".concat(token.paddingXXS * 1.5, "px ").concat(padding, "px")
  })), (0, _defineProperty2.default)(_$concat19, "&".concat(componentCls, "-bottom"), (0, _defineProperty2.default)({}, "> ".concat(componentCls, "-nav ").concat(componentCls, "-tab"), {
    borderRadius: "0 0 ".concat(token.borderRadius, "px ").concat(token.borderRadius, "px")
  })), (0, _defineProperty2.default)(_$concat19, "&".concat(componentCls, "-top"), (0, _defineProperty2.default)({}, "> ".concat(componentCls, "-nav ").concat(componentCls, "-tab"), {
    borderRadius: "".concat(token.borderRadius, "px ").concat(token.borderRadius, "px 0 0")
  })), (0, _defineProperty2.default)(_$concat19, "&".concat(componentCls, "-right"), (0, _defineProperty2.default)({}, "> ".concat(componentCls, "-nav ").concat(componentCls, "-tab"), {
    borderRadius: {
      _skip_check_: true,
      value: "0 ".concat(token.borderRadius, "px ").concat(token.borderRadius, "px 0")
    }
  })), (0, _defineProperty2.default)(_$concat19, "&".concat(componentCls, "-left"), (0, _defineProperty2.default)({}, "> ".concat(componentCls, "-nav ").concat(componentCls, "-tab"), {
    borderRadius: {
      _skip_check_: true,
      value: "".concat(token.borderRadius, "px 0 0 ").concat(token.borderRadius, "px")
    }
  })), _$concat19)), (0, _defineProperty2.default)(_$concat22, "&".concat(componentCls, "-large"), (0, _defineProperty2.default)({}, "> ".concat(componentCls, "-nav"), (0, _defineProperty2.default)({}, "".concat(componentCls, "-tab"), {
    padding: "".concat(token.paddingXS, "px ").concat(padding, "px ").concat(token.paddingXXS * 1.5, "px")
  }))), _$concat22)), _ref4;
};
var genTabStyle = function genTabStyle(token) {
  var _tabCls, _ref5;
  var componentCls = token.componentCls,
    tabsActiveColor = token.tabsActiveColor,
    tabsHoverColor = token.tabsHoverColor,
    iconCls = token.iconCls,
    tabsHorizontalGutter = token.tabsHorizontalGutter;
  var tabCls = "".concat(componentCls, "-tab");
  return _ref5 = {}, (0, _defineProperty2.default)(_ref5, tabCls, (_tabCls = {
    position: 'relative',
    display: 'inline-flex',
    alignItems: 'center',
    padding: "".concat(token.paddingSM, "px 0"),
    fontSize: "".concat(token.fontSize, "px"),
    background: 'transparent',
    border: 0,
    outline: 'none',
    cursor: 'pointer',
    '&-btn, &-remove': (0, _extends5.default)({
      '&:focus:not(:focus-visible), &:active': {
        color: tabsActiveColor
      }
    }, (0, _style.genFocusStyle)(token)),
    '&-btn': {
      outline: 'none',
      transition: 'all 0.3s'
    },
    '&-remove': {
      flex: 'none',
      marginRight: {
        _skip_check_: true,
        value: -token.marginXXS
      },
      marginLeft: {
        _skip_check_: true,
        value: token.marginXS
      },
      color: token.colorTextDescription,
      fontSize: token.fontSizeSM,
      background: 'transparent',
      border: 'none',
      outline: 'none',
      cursor: 'pointer',
      transition: "all ".concat(token.motionDurationSlow),
      '&:hover': {
        color: token.colorTextHeading
      }
    },
    '&:hover': {
      color: tabsHoverColor
    }
  }, (0, _defineProperty2.default)(_tabCls, "&".concat(tabCls, "-active ").concat(tabCls, "-btn"), {
    color: token.colorPrimary,
    textShadow: token.tabsActiveTextShadow
  }), (0, _defineProperty2.default)(_tabCls, "&".concat(tabCls, "-disabled"), {
    color: token.colorTextDisabled,
    cursor: 'not-allowed'
  }), (0, _defineProperty2.default)(_tabCls, "&".concat(tabCls, "-disabled ").concat(tabCls, "-btn, &").concat(tabCls, "-disabled ").concat(componentCls, "-remove"), {
    '&:focus, &:active': {
      color: token.colorTextDisabled
    }
  }), (0, _defineProperty2.default)(_tabCls, "& ".concat(tabCls, "-remove ").concat(iconCls), {
    margin: 0
  }), (0, _defineProperty2.default)(_tabCls, iconCls, {
    marginRight: {
      _skip_check_: true,
      value: token.marginSM
    }
  }), _tabCls)), (0, _defineProperty2.default)(_ref5, "".concat(tabCls, " + ").concat(tabCls), {
    margin: {
      _skip_check_: true,
      value: "0 0 0 ".concat(tabsHorizontalGutter, "px")
    }
  }), _ref5;
};
var genRtlStyle = function genRtlStyle(token) {
  var _$concat24, _$concat26, _$concat27, _rtlCls, _ref6;
  var componentCls = token.componentCls,
    tabsHorizontalGutter = token.tabsHorizontalGutter,
    iconCls = token.iconCls,
    tabsCardGutter = token.tabsCardGutter;
  var rtlCls = "".concat(componentCls, "-rtl");
  return _ref6 = {}, (0, _defineProperty2.default)(_ref6, rtlCls, (_rtlCls = {
    direction: 'rtl'
  }, (0, _defineProperty2.default)(_rtlCls, "".concat(componentCls, "-nav"), (0, _defineProperty2.default)({}, "".concat(componentCls, "-tab"), (_$concat24 = {
    margin: {
      _skip_check_: true,
      value: "0 0 0 ".concat(tabsHorizontalGutter, "px")
    }
  }, (0, _defineProperty2.default)(_$concat24, "".concat(componentCls, "-tab:last-of-type"), {
    marginLeft: {
      _skip_check_: true,
      value: 0
    }
  }), (0, _defineProperty2.default)(_$concat24, iconCls, {
    marginRight: {
      _skip_check_: true,
      value: 0
    },
    marginLeft: {
      _skip_check_: true,
      value: "".concat(token.marginSM, "px")
    }
  }), (0, _defineProperty2.default)(_$concat24, "".concat(componentCls, "-tab-remove"), (0, _defineProperty2.default)({
    marginRight: {
      _skip_check_: true,
      value: "".concat(token.marginXS, "px")
    },
    marginLeft: {
      _skip_check_: true,
      value: "-".concat(token.marginXXS, "px")
    }
  }, iconCls, {
    margin: 0
  })), _$concat24))), (0, _defineProperty2.default)(_rtlCls, "&".concat(componentCls, "-left"), (_$concat26 = {}, (0, _defineProperty2.default)(_$concat26, "> ".concat(componentCls, "-nav"), {
    order: 1
  }), (0, _defineProperty2.default)(_$concat26, "> ".concat(componentCls, "-content-holder"), {
    order: 0
  }), _$concat26)), (0, _defineProperty2.default)(_rtlCls, "&".concat(componentCls, "-right"), (_$concat27 = {}, (0, _defineProperty2.default)(_$concat27, "> ".concat(componentCls, "-nav"), {
    order: 0
  }), (0, _defineProperty2.default)(_$concat27, "> ".concat(componentCls, "-content-holder"), {
    order: 1
  }), _$concat27)), (0, _defineProperty2.default)(_rtlCls, "&".concat(componentCls, "-card").concat(componentCls, "-top, &").concat(componentCls, "-card").concat(componentCls, "-bottom"), (0, _defineProperty2.default)({}, "> ".concat(componentCls, "-nav, > div > ").concat(componentCls, "-nav"), (0, _defineProperty2.default)({}, "".concat(componentCls, "-tab + ").concat(componentCls, "-tab"), {
    marginRight: {
      _skip_check_: true,
      value: "".concat(tabsCardGutter, "px")
    },
    marginLeft: {
      _skip_check_: true,
      value: 0
    }
  }))), _rtlCls)), (0, _defineProperty2.default)(_ref6, "".concat(componentCls, "-dropdown-rtl"), {
    direction: 'rtl'
  }), (0, _defineProperty2.default)(_ref6, "".concat(componentCls, "-menu-item"), (0, _defineProperty2.default)({}, "".concat(componentCls, "-dropdown-rtl"), {
    textAlign: {
      _skip_check_: true,
      value: 'right'
    }
  })), _ref6;
};
var genTabsStyle = function genTabsStyle(token) {
  var _$concat$concat21, _extends3, _extends4, _ref7;
  var componentCls = token.componentCls,
    tabsCardHorizontalPadding = token.tabsCardHorizontalPadding,
    tabsCardHeight = token.tabsCardHeight,
    tabsCardGutter = token.tabsCardGutter,
    tabsHoverColor = token.tabsHoverColor,
    tabsActiveColor = token.tabsActiveColor,
    colorSplit = token.colorSplit;
  return _ref7 = {}, (0, _defineProperty2.default)(_ref7, componentCls, (0, _extends5.default)((0, _extends5.default)((0, _extends5.default)((0, _extends5.default)({}, (0, _style.resetComponent)(token)), (_extends3 = {
    display: 'flex'
  }, (0, _defineProperty2.default)(_extends3, "> ".concat(componentCls, "-nav, > div > ").concat(componentCls, "-nav"), (_$concat$concat21 = {
    position: 'relative',
    display: 'flex',
    flex: 'none',
    alignItems: 'center'
  }, (0, _defineProperty2.default)(_$concat$concat21, "".concat(componentCls, "-nav-wrap"), {
    position: 'relative',
    display: 'flex',
    flex: 'auto',
    alignSelf: 'stretch',
    overflow: 'hidden',
    whiteSpace: 'nowrap',
    transform: 'translate(0)',
    // >>>>> Ping shadow
    '&::before, &::after': {
      position: 'absolute',
      zIndex: 1,
      opacity: 0,
      transition: "opacity ".concat(token.motionDurationSlow),
      content: "''",
      pointerEvents: 'none'
    }
  }), (0, _defineProperty2.default)(_$concat$concat21, "".concat(componentCls, "-nav-list"), {
    position: 'relative',
    display: 'flex',
    transition: "opacity ".concat(token.motionDurationSlow)
  }), (0, _defineProperty2.default)(_$concat$concat21, "".concat(componentCls, "-nav-operations"), {
    display: 'flex',
    alignSelf: 'stretch'
  }), (0, _defineProperty2.default)(_$concat$concat21, "".concat(componentCls, "-nav-operations-hidden"), {
    position: 'absolute',
    visibility: 'hidden',
    pointerEvents: 'none'
  }), (0, _defineProperty2.default)(_$concat$concat21, "".concat(componentCls, "-nav-more"), {
    position: 'relative',
    padding: tabsCardHorizontalPadding,
    background: 'transparent',
    border: 0,
    '&::after': {
      position: 'absolute',
      right: {
        _skip_check_: true,
        value: 0
      },
      bottom: 0,
      left: {
        _skip_check_: true,
        value: 0
      },
      height: token.controlHeightLG / 8,
      transform: 'translateY(100%)',
      content: "''"
    }
  }), (0, _defineProperty2.default)(_$concat$concat21, "".concat(componentCls, "-nav-add"), (0, _extends5.default)({
    minWidth: "".concat(tabsCardHeight, "px"),
    marginLeft: {
      _skip_check_: true,
      value: "".concat(tabsCardGutter, "px")
    },
    padding: "0 ".concat(token.paddingXS, "px"),
    background: 'transparent',
    border: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(colorSplit),
    borderRadius: "".concat(token.borderRadiusLG, "px ").concat(token.borderRadiusLG, "px 0 0"),
    outline: 'none',
    cursor: 'pointer',
    color: token.colorText,
    transition: "all ".concat(token.motionDurationSlow, " ").concat(token.motionEaseInOut),
    '&:hover': {
      color: tabsHoverColor
    },
    '&:active, &:focus:not(:focus-visible)': {
      color: tabsActiveColor
    }
  }, (0, _style.genFocusStyle)(token))), _$concat$concat21)), (0, _defineProperty2.default)(_extends3, "".concat(componentCls, "-extra-content"), {
    flex: 'none'
  }), (0, _defineProperty2.default)(_extends3, "".concat(componentCls, "-ink-bar"), {
    position: 'absolute',
    background: token.colorPrimary,
    pointerEvents: 'none'
  }), _extends3)), genTabStyle(token)), (_extends4 = {}, (0, _defineProperty2.default)(_extends4, "".concat(componentCls, "-content"), {
    position: 'relative',
    width: '100%'
  }), (0, _defineProperty2.default)(_extends4, "".concat(componentCls, "-content-holder"), {
    flex: 'auto',
    minWidth: 0,
    minHeight: 0
  }), (0, _defineProperty2.default)(_extends4, "".concat(componentCls, "-tabpane"), {
    outline: 'none',
    '&-hidden': {
      display: 'none'
    }
  }), _extends4))), (0, _defineProperty2.default)(_ref7, "".concat(componentCls, "-centered"), (0, _defineProperty2.default)({}, "> ".concat(componentCls, "-nav, > div > ").concat(componentCls, "-nav"), (0, _defineProperty2.default)({}, "".concat(componentCls, "-nav-wrap"), (0, _defineProperty2.default)({}, "&:not([class*='".concat(componentCls, "-nav-wrap-ping'])"), {
    justifyContent: 'center'
  })))), _ref7;
};
// ============================== Export ==============================
var _default = (0, _internal.genComponentStyleHook)('Tabs', function (token) {
  var tabsCardHeight = token.controlHeightLG;
  var tabsToken = (0, _internal.mergeToken)(token, {
    tabsHoverColor: token.colorPrimaryHover,
    tabsActiveColor: token.colorPrimaryActive,
    tabsCardHorizontalPadding: "".concat((tabsCardHeight - Math.round(token.fontSize * token.lineHeight)) / 2 - token.lineWidth, "px ").concat(token.padding, "px"),
    tabsCardHeight: tabsCardHeight,
    tabsCardGutter: token.marginXXS / 2,
    tabsHorizontalGutter: 32,
    tabsCardHeadBackground: token.colorFillAlter,
    dropdownEdgeChildVerticalPadding: token.paddingXXS,
    tabsActiveTextShadow: '0 0 0.25px currentcolor',
    tabsDropdownHeight: 200,
    tabsDropdownWidth: 120
  });
  return [genSizeStyle(tabsToken), genRtlStyle(tabsToken), genPositionStyle(tabsToken), genDropdownStyle(tabsToken), genCardStyle(tabsToken), genTabsStyle(tabsToken), (0, _motion.default)(tabsToken)];
}, function (token) {
  return {
    zIndexPopup: token.zIndexPopupBase + 50
  };
});
exports.default = _default;