"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "CheckableTag", {
  enumerable: true,
  get: function get() {
    return _CheckableTag.default;
  }
});
exports.tagProps = exports.default = void 0;
var _vue = require("vue");
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _classNames2 = _interopRequireDefault(require("../_util/classNames"));
var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));
var _CloseOutlined = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/CloseOutlined"));
var _wave = _interopRequireDefault(require("../_util/wave"));
var _colors = require("../_util/colors");
var _type = require("../_util/type");
var _CheckableTag = _interopRequireDefault(require("./CheckableTag"));
var _useConfigInject2 = _interopRequireDefault(require("../config-provider/hooks/useConfigInject"));
var _warning = _interopRequireDefault(require("../_util/warning"));
var _style = _interopRequireDefault(require("./style"));
var tagProps = function tagProps() {
  return {
    prefixCls: String,
    color: {
      type: String
    },
    closable: {
      type: Boolean,
      default: false
    },
    closeIcon: _vueTypes.default.any,
    /** @deprecated `visible` will be removed in next major version. */
    visible: {
      type: Boolean,
      default: undefined
    },
    onClose: {
      type: Function
    },
    onClick: (0, _type.eventType)(),
    'onUpdate:visible': Function,
    icon: _vueTypes.default.any
  };
};
exports.tagProps = tagProps;
var Tag = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'ATag',
  inheritAttrs: false,
  props: tagProps(),
  // emits: ['update:visible', 'close'],
  slots: ['closeIcon', 'icon'],
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      emit = _ref.emit,
      attrs = _ref.attrs;
    var _useConfigInject = (0, _useConfigInject2.default)('tag', props),
      prefixCls = _useConfigInject.prefixCls,
      direction = _useConfigInject.direction;
    var _useStyle = (0, _style.default)(prefixCls),
      _useStyle2 = (0, _slicedToArray2.default)(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var visible = (0, _vue.shallowRef)(true);
    // Warning for deprecated usage
    if (process.env.NODE_ENV !== 'production') {
      (0, _warning.default)(props.visible === undefined, 'Tag', '`visible` is deprecated, please use `<Tag v-show="visible" />` instead.');
    }
    (0, _vue.watchEffect)(function () {
      if (props.visible !== undefined) {
        visible.value = props.visible;
      }
    });
    var handleCloseClick = function handleCloseClick(e) {
      e.stopPropagation();
      emit('update:visible', false);
      emit('close', e);
      if (e.defaultPrevented) {
        return;
      }
      if (props.visible === undefined) {
        visible.value = false;
      }
    };
    // const isPresetColor = computed(() => {
    //   const { color } = props;
    //   if (!color) {
    //     return false;
    //   }
    //   return PresetColorRegex.test(color) || PresetStatusColorRegex.test(color);
    // });
    var isInternalColor = (0, _vue.computed)(function () {
      return (0, _colors.isPresetColor)(props.color) || (0, _colors.isPresetStatusColor)(props.color);
    });
    var tagClassName = (0, _vue.computed)(function () {
      var _classNames;
      return (0, _classNames2.default)(prefixCls.value, hashId.value, (_classNames = {}, (0, _defineProperty2.default)(_classNames, "".concat(prefixCls.value, "-").concat(props.color), isInternalColor.value), (0, _defineProperty2.default)(_classNames, "".concat(prefixCls.value, "-has-color"), props.color && !isInternalColor.value), (0, _defineProperty2.default)(_classNames, "".concat(prefixCls.value, "-hidden"), !visible.value), (0, _defineProperty2.default)(_classNames, "".concat(prefixCls.value, "-rtl"), direction.value === 'rtl'), _classNames));
    });
    var handleClick = function handleClick(e) {
      emit('click', e);
    };
    return function () {
      var _a, _b, _c;
      var _props$icon = props.icon,
        icon = _props$icon === void 0 ? (_a = slots.icon) === null || _a === void 0 ? void 0 : _a.call(slots) : _props$icon,
        color = props.color,
        _props$closeIcon = props.closeIcon,
        closeIcon = _props$closeIcon === void 0 ? (_b = slots.closeIcon) === null || _b === void 0 ? void 0 : _b.call(slots) : _props$closeIcon,
        _props$closable = props.closable,
        closable = _props$closable === void 0 ? false : _props$closable;
      var renderCloseIcon = function renderCloseIcon() {
        if (closable) {
          return closeIcon ? (0, _vue.createVNode)("span", {
            "class": "".concat(prefixCls.value, "-close-icon"),
            "onClick": handleCloseClick
          }, [closeIcon]) : (0, _vue.createVNode)(_CloseOutlined.default, {
            "class": "".concat(prefixCls.value, "-close-icon"),
            "onClick": handleCloseClick
          }, null);
        }
        return null;
      };
      var tagStyle = {
        backgroundColor: color && !isInternalColor.value ? color : undefined
      };
      var iconNode = icon || null;
      var children = (_c = slots.default) === null || _c === void 0 ? void 0 : _c.call(slots);
      var kids = iconNode ? (0, _vue.createVNode)(_vue.Fragment, null, [iconNode, (0, _vue.createVNode)("span", null, [children])]) : children;
      var isNeedWave = props.onClick !== undefined;
      var tagNode = (0, _vue.createVNode)("span", (0, _objectSpread2.default)((0, _objectSpread2.default)({}, attrs), {}, {
        "onClick": handleClick,
        "class": [tagClassName.value, attrs.class],
        "style": [tagStyle, attrs.style]
      }), [kids, renderCloseIcon()]);
      return wrapSSR(isNeedWave ? (0, _vue.createVNode)(_wave.default, null, {
        default: function _default() {
          return [tagNode];
        }
      }) : tagNode);
    };
  }
});
Tag.CheckableTag = _CheckableTag.default;
Tag.install = function (app) {
  app.component(Tag.name, Tag);
  app.component(_CheckableTag.default.name, _CheckableTag.default);
  return app;
};
var _default2 = Tag;
exports.default = _default2;