"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = genComponentStyleHook;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _cssinjs = require("../../_util/cssinjs");
var _style = require("../../style");
var _internal = require("../internal");
var _vue = require("vue");
var _context = require("../../config-provider/context");
/* eslint-disable no-redeclare */

function genComponentStyleHook(component, styleFn, getDefaultToken) {
  return function (_prefixCls) {
    var prefixCls = (0, _vue.computed)(function () {
      return _prefixCls === null || _prefixCls === void 0 ? void 0 : _prefixCls.value;
    });
    var _useToken = (0, _internal.useToken)(),
      _useToken2 = (0, _slicedToArray2.default)(_useToken, 3),
      theme = _useToken2[0],
      token = _useToken2[1],
      hashId = _useToken2[2];
    var _useConfigContextInje = (0, _context.useConfigContextInject)(),
      getPrefixCls = _useConfigContextInje.getPrefixCls,
      iconPrefixCls = _useConfigContextInje.iconPrefixCls;
    var rootPrefixCls = (0, _vue.computed)(function () {
      return getPrefixCls();
    });
    var sharedInfo = (0, _vue.computed)(function () {
      return {
        theme: theme.value,
        token: token.value,
        hashId: hashId.value,
        path: ['Shared', rootPrefixCls.value]
      };
    });
    // Generate style for all a tags in antd component.
    (0, _cssinjs.useStyleRegister)(sharedInfo, function () {
      return [{
        // Link
        '&': (0, _style.genLinkStyle)(token.value)
      }];
    });
    var componentInfo = (0, _vue.computed)(function () {
      return {
        theme: theme.value,
        token: token.value,
        hashId: hashId.value,
        path: [component, prefixCls.value, iconPrefixCls.value]
      };
    });
    return [(0, _cssinjs.useStyleRegister)(componentInfo, function () {
      var _statisticToken = (0, _internal.statisticToken)(token.value),
        proxyToken = _statisticToken.token,
        flush = _statisticToken.flush;
      var defaultComponentToken = typeof getDefaultToken === 'function' ? getDefaultToken(proxyToken) : getDefaultToken;
      var mergedComponentToken = (0, _extends2.default)((0, _extends2.default)({}, defaultComponentToken), token.value[component]);
      var componentCls = ".".concat(prefixCls.value);
      var mergedToken = (0, _internal.mergeToken)(proxyToken, {
        componentCls: componentCls,
        prefixCls: prefixCls.value,
        iconCls: ".".concat(iconPrefixCls.value),
        antCls: ".".concat(rootPrefixCls.value)
      }, mergedComponentToken);
      var styleInterpolation = styleFn(mergedToken, {
        hashId: hashId.value,
        prefixCls: prefixCls.value,
        rootPrefixCls: rootPrefixCls.value,
        iconPrefixCls: iconPrefixCls.value,
        overrideComponentToken: token.value[component]
      });
      flush(component, mergedComponentToken);
      return [(0, _style.genCommonStyle)(token.value, prefixCls.value), styleInterpolation];
    }), hashId];
  };
}