"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tooltipProps = exports.tooltipDefaultProps = exports.default = void 0;
var _vue = require("vue");
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _vcTooltip = _interopRequireDefault(require("../vc-tooltip"));
var _classNames3 = _interopRequireDefault(require("../_util/classNames"));
var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));
var _warning = _interopRequireDefault(require("../_util/warning"));
var _propsUtil = require("../_util/props-util");
var _vnode = require("../_util/vnode");
var _abstractTooltipProps = _interopRequireDefault(require("./abstractTooltipProps"));
var _useConfigInject2 = _interopRequireDefault(require("../config-provider/hooks/useConfigInject"));
var _placements = _interopRequireDefault(require("../_util/placements"));
var _firstNotUndefined = _interopRequireDefault(require("../_util/firstNotUndefined"));
var _raf = _interopRequireDefault(require("../_util/raf"));
var _util = require("./util");
var _style = _interopRequireDefault(require("./style"));
var _transition = require("../_util/transition");
var splitObject = function splitObject(obj, keys) {
  var picked = {};
  var omitted = (0, _extends2.default)({}, obj);
  keys.forEach(function (key) {
    if (obj && key in obj) {
      picked[key] = obj[key];
      delete omitted[key];
    }
  });
  return {
    picked: picked,
    omitted: omitted
  };
};
var tooltipProps = function tooltipProps() {
  return (0, _extends2.default)((0, _extends2.default)({}, (0, _abstractTooltipProps.default)()), {
    title: _vueTypes.default.any
  });
};
exports.tooltipProps = tooltipProps;
var tooltipDefaultProps = function tooltipDefaultProps() {
  return {
    trigger: 'hover',
    align: {},
    placement: 'top',
    mouseEnterDelay: 0.1,
    mouseLeaveDelay: 0.1,
    arrowPointAtCenter: false,
    autoAdjustOverflow: true
  };
};
exports.tooltipDefaultProps = tooltipDefaultProps;
var _default2 = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'ATooltip',
  inheritAttrs: false,
  props: (0, _propsUtil.initDefaultProps)(tooltipProps(), {
    trigger: 'hover',
    align: {},
    placement: 'top',
    mouseEnterDelay: 0.1,
    mouseLeaveDelay: 0.1,
    arrowPointAtCenter: false,
    autoAdjustOverflow: true
  }),
  slots: ['title'],
  // emits: ['update:visible', 'visibleChange'],
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      emit = _ref.emit,
      attrs = _ref.attrs,
      expose = _ref.expose;
    if (process.env.NODE_ENV !== 'production') {
      [['visible', 'open'], ['onVisibleChange', 'onOpenChange']].forEach(function (_ref2) {
        var _ref3 = (0, _slicedToArray2.default)(_ref2, 2),
          deprecatedName = _ref3[0],
          newName = _ref3[1];
        (0, _warning.default)(props[deprecatedName] === undefined, 'Tooltip', "`".concat(deprecatedName, "` is deprecated, please use `").concat(newName, "` instead."));
      });
    }
    var _useConfigInject = (0, _useConfigInject2.default)('tooltip', props),
      prefixCls = _useConfigInject.prefixCls,
      getPopupContainer = _useConfigInject.getPopupContainer,
      direction = _useConfigInject.direction,
      rootPrefixCls = _useConfigInject.rootPrefixCls;
    var mergedOpen = (0, _vue.computed)(function () {
      var _a;
      return (_a = props.open) !== null && _a !== void 0 ? _a : props.visible;
    });
    var innerOpen = (0, _vue.ref)((0, _firstNotUndefined.default)([props.open, props.visible]));
    var tooltip = (0, _vue.ref)();
    var rafId;
    (0, _vue.watch)(mergedOpen, function (val) {
      _raf.default.cancel(rafId);
      rafId = (0, _raf.default)(function () {
        innerOpen.value = !!val;
      });
    });
    var isNoTitle = function isNoTitle() {
      var _a;
      var title = (_a = props.title) !== null && _a !== void 0 ? _a : slots.title;
      return !title && title !== 0;
    };
    var handleVisibleChange = function handleVisibleChange(val) {
      var noTitle = isNoTitle();
      if (mergedOpen.value === undefined) {
        innerOpen.value = noTitle ? false : val;
      }
      if (!noTitle) {
        emit('update:visible', val);
        emit('visibleChange', val);
        emit('update:open', val);
        emit('openChange', val);
      }
    };
    var getPopupDomNode = function getPopupDomNode() {
      return tooltip.value.getPopupDomNode();
    };
    expose({
      getPopupDomNode: getPopupDomNode,
      open: innerOpen,
      forcePopupAlign: function forcePopupAlign() {
        var _a;
        return (_a = tooltip.value) === null || _a === void 0 ? void 0 : _a.forcePopupAlign();
      }
    });
    var tooltipPlacements = (0, _vue.computed)(function () {
      var builtinPlacements = props.builtinPlacements,
        arrowPointAtCenter = props.arrowPointAtCenter,
        autoAdjustOverflow = props.autoAdjustOverflow;
      return builtinPlacements || (0, _placements.default)({
        arrowPointAtCenter: arrowPointAtCenter,
        autoAdjustOverflow: autoAdjustOverflow
      });
    });
    var isTrueProps = function isTrueProps(val) {
      return val || val === '';
    };
    var getDisabledCompatibleChildren = function getDisabledCompatibleChildren(ele) {
      var elementType = ele.type;
      if ((0, _typeof2.default)(elementType) === 'object' && ele.props) {
        if ((elementType.__ANT_BUTTON === true || elementType === 'button') && isTrueProps(ele.props.disabled) || elementType.__ANT_SWITCH === true && (isTrueProps(ele.props.disabled) || isTrueProps(ele.props.loading)) || elementType.__ANT_RADIO === true && isTrueProps(ele.props.disabled)) {
          // Pick some layout related style properties up to span
          // Prevent layout bugs like https://github.com/ant-design/ant-design/issues/5254
          var _splitObject = splitObject((0, _propsUtil.getStyle)(ele), ['position', 'left', 'right', 'top', 'bottom', 'float', 'display', 'zIndex']),
            picked = _splitObject.picked,
            omitted = _splitObject.omitted;
          var spanStyle = (0, _extends2.default)((0, _extends2.default)({
            display: 'inline-block'
          }, picked), {
            cursor: 'not-allowed',
            lineHeight: 1,
            width: ele.props && ele.props.block ? '100%' : undefined
          });
          var buttonStyle = (0, _extends2.default)((0, _extends2.default)({}, omitted), {
            pointerEvents: 'none'
          });
          var child = (0, _vnode.cloneElement)(ele, {
            style: buttonStyle
          }, true);
          return (0, _vue.createVNode)("span", {
            "style": spanStyle,
            "class": "".concat(prefixCls.value, "-disabled-compatible-wrapper")
          }, [child]);
        }
      }
      return ele;
    };
    var getOverlay = function getOverlay() {
      var _a, _b;
      return (_a = props.title) !== null && _a !== void 0 ? _a : (_b = slots.title) === null || _b === void 0 ? void 0 : _b.call(slots);
    };
    var onPopupAlign = function onPopupAlign(domNode, align) {
      var placements = tooltipPlacements.value;
      // 当前返回的位置
      var placement = Object.keys(placements).find(function (key) {
        var _a, _b;
        return placements[key].points[0] === ((_a = align.points) === null || _a === void 0 ? void 0 : _a[0]) && placements[key].points[1] === ((_b = align.points) === null || _b === void 0 ? void 0 : _b[1]);
      });
      if (placement) {
        // 根据当前坐标设置动画点
        var rect = domNode.getBoundingClientRect();
        var transformOrigin = {
          top: '50%',
          left: '50%'
        };
        if (placement.indexOf('top') >= 0 || placement.indexOf('Bottom') >= 0) {
          transformOrigin.top = "".concat(rect.height - align.offset[1], "px");
        } else if (placement.indexOf('Top') >= 0 || placement.indexOf('bottom') >= 0) {
          transformOrigin.top = "".concat(-align.offset[1], "px");
        }
        if (placement.indexOf('left') >= 0 || placement.indexOf('Right') >= 0) {
          transformOrigin.left = "".concat(rect.width - align.offset[0], "px");
        } else if (placement.indexOf('right') >= 0 || placement.indexOf('Left') >= 0) {
          transformOrigin.left = "".concat(-align.offset[0], "px");
        }
        domNode.style.transformOrigin = "".concat(transformOrigin.left, " ").concat(transformOrigin.top);
      }
    };
    var colorInfo = (0, _vue.computed)(function () {
      return (0, _util.parseColor)(prefixCls.value, props.color);
    });
    var injectFromPopover = (0, _vue.computed)(function () {
      return attrs['data-popover-inject'];
    });
    var _useStyle = (0, _style.default)(prefixCls, (0, _vue.computed)(function () {
        return !injectFromPopover.value;
      })),
      _useStyle2 = (0, _slicedToArray2.default)(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    return function () {
      var _classNames;
      var _a, _b;
      var openClassName = props.openClassName,
        overlayClassName = props.overlayClassName,
        overlayInnerStyle = props.overlayInnerStyle;
      var children = (_b = (0, _propsUtil.filterEmpty)((_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots))) !== null && _b !== void 0 ? _b : null;
      children = children.length === 1 ? children[0] : children;
      var tempVisible = innerOpen.value;
      // Hide tooltip when there is no title
      if (mergedOpen.value === undefined && isNoTitle()) {
        tempVisible = false;
      }
      if (!children) {
        return null;
      }
      var child = getDisabledCompatibleChildren((0, _propsUtil.isValidElement)(children) && !(0, _propsUtil.isFragment)(children) ? children : (0, _vue.createVNode)("span", null, [children]));
      var childCls = (0, _classNames3.default)((_classNames = {}, (0, _defineProperty2.default)(_classNames, openClassName || "".concat(prefixCls.value, "-open"), true), (0, _defineProperty2.default)(_classNames, child.props && child.props.class, child.props && child.props.class), _classNames));
      var customOverlayClassName = (0, _classNames3.default)(overlayClassName, (0, _defineProperty2.default)({}, "".concat(prefixCls.value, "-rtl"), direction.value === 'rtl'), colorInfo.value.className, hashId.value);
      var formattedOverlayInnerStyle = (0, _extends2.default)((0, _extends2.default)({}, colorInfo.value.overlayStyle), overlayInnerStyle);
      var arrowContentStyle = colorInfo.value.arrowStyle;
      var vcTooltipProps = (0, _extends2.default)((0, _extends2.default)((0, _extends2.default)({}, attrs), props), {
        prefixCls: prefixCls.value,
        getPopupContainer: getPopupContainer === null || getPopupContainer === void 0 ? void 0 : getPopupContainer.value,
        builtinPlacements: tooltipPlacements.value,
        visible: tempVisible,
        ref: tooltip,
        overlayClassName: customOverlayClassName,
        overlayInnerStyle: formattedOverlayInnerStyle,
        onVisibleChange: handleVisibleChange,
        onPopupAlign: onPopupAlign,
        transitionName: (0, _transition.getTransitionName)(rootPrefixCls.value, 'zoom-big-fast', props.transitionName)
      });
      return wrapSSR((0, _vue.createVNode)(_vcTooltip.default, vcTooltipProps, {
        default: function _default() {
          return [innerOpen.value ? (0, _vnode.cloneElement)(child, {
            class: childCls
          }) : child];
        },
        arrowContent: function arrowContent() {
          return (0, _vue.createVNode)("span", {
            "class": "".concat(prefixCls.value, "-arrow-content"),
            "style": arrowContentStyle
          }, null);
        },
        overlay: getOverlay
      }));
    };
  }
});
exports.default = _default2;