"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseColor = parseColor;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _classNames2 = _interopRequireDefault(require("../_util/classNames"));
var _colors = require("../_util/colors");
function parseColor(prefixCls, color) {
  var isInternalColor = (0, _colors.isPresetColor)(color);
  var className = (0, _classNames2.default)((0, _defineProperty2.default)({}, "".concat(prefixCls, "-").concat(color), color && isInternalColor));
  var overlayStyle = {};
  var arrowStyle = {};
  if (color && !isInternalColor) {
    overlayStyle.background = color;
    // @ts-ignore
    arrowStyle['--antd-arrow-background-color'] = color;
  }
  return {
    className: className,
    overlayStyle: overlayStyle,
    arrowStyle: arrowStyle
  };
}