"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.TreeSelectNode = void 0;
exports.treeSelectProps = treeSelectProps;
var _vue = require("vue");
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _vcTreeSelect = _interopRequireWildcard(require("../vc-tree-select"));
var _classNames3 = _interopRequireDefault(require("../_util/classNames"));
var _initDefaultProps = _interopRequireDefault(require("../_util/props-util/initDefaultProps"));
var _omit = _interopRequireDefault(require("../_util/omit"));
var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));
var _useConfigInject2 = _interopRequireDefault(require("../config-provider/hooks/useConfigInject"));
var _devWarning = _interopRequireDefault(require("../vc-util/devWarning"));
var _iconUtil = _interopRequireDefault(require("../select/utils/iconUtil"));
var _iconUtil2 = _interopRequireDefault(require("../tree/utils/iconUtil"));
var _warning = require("../vc-util/warning");
var _propsUtil = require("../_util/props-util");
var _FormItemContext = require("../form/FormItemContext");
var _transition = require("../_util/transition");
var _statusUtils = require("../_util/statusUtils");
var _type = require("../_util/type");
var _style = _interopRequireDefault(require("../select/style"));
var _style2 = _interopRequireDefault(require("./style"));
var _Compact = require("../space/Compact");
var _DisabledContext = require("../config-provider/DisabledContext");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
// CSSINJS

var getTransitionName = function getTransitionName(rootPrefixCls, motion, transitionName) {
  if (transitionName !== undefined) {
    return transitionName;
  }
  return "".concat(rootPrefixCls, "-").concat(motion);
};
function treeSelectProps() {
  return (0, _extends2.default)((0, _extends2.default)({}, (0, _omit.default)((0, _vcTreeSelect.treeSelectProps)(), ['showTreeIcon', 'treeMotion', 'inputIcon', 'getInputElement', 'treeLine', 'customSlots'])), {
    suffixIcon: _vueTypes.default.any,
    size: (0, _type.stringType)(),
    bordered: (0, _type.booleanType)(),
    treeLine: (0, _type.someType)([Boolean, Object]),
    replaceFields: (0, _type.objectType)(),
    placement: (0, _type.stringType)(),
    status: (0, _type.stringType)(),
    popupClassName: String,
    /** @deprecated Please use `popupClassName` instead */
    dropdownClassName: String,
    'onUpdate:value': (0, _type.functionType)(),
    'onUpdate:treeExpandedKeys': (0, _type.functionType)(),
    'onUpdate:searchValue': (0, _type.functionType)()
  });
}
var TreeSelect = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'ATreeSelect',
  inheritAttrs: false,
  props: (0, _initDefaultProps.default)(treeSelectProps(), {
    choiceTransitionName: '',
    listHeight: 256,
    treeIcon: false,
    listItemHeight: 26,
    bordered: true
  }),
  slots: ['title', 'titleRender', 'placeholder', 'maxTagPlaceholder', 'treeIcon', 'switcherIcon', 'notFoundContent'],
  setup: function setup(props, _ref) {
    var attrs = _ref.attrs,
      slots = _ref.slots,
      expose = _ref.expose,
      emit = _ref.emit;
    (0, _warning.warning)(!(props.treeData === undefined && slots.default), '`children` of TreeSelect is deprecated. Please use `treeData` instead.');
    (0, _devWarning.default)(props.multiple !== false || !props.treeCheckable, 'TreeSelect', '`multiple` will always be `true` when `treeCheckable` is true');
    (0, _devWarning.default)(props.replaceFields === undefined, 'TreeSelect', '`replaceFields` is deprecated, please use fieldNames instead');
    (0, _devWarning.default)(!props.dropdownClassName, 'TreeSelect', '`dropdownClassName` is deprecated. Please use `popupClassName` instead.');
    var formItemContext = (0, _FormItemContext.useInjectFormItemContext)();
    var formItemInputContext = _FormItemContext.FormItemInputContext.useInject();
    var mergedStatus = (0, _vue.computed)(function () {
      return (0, _statusUtils.getMergedStatus)(formItemInputContext.status, props.status);
    });
    var _useConfigInject = (0, _useConfigInject2.default)('select', props),
      prefixCls = _useConfigInject.prefixCls,
      renderEmpty = _useConfigInject.renderEmpty,
      direction = _useConfigInject.direction,
      virtual = _useConfigInject.virtual,
      dropdownMatchSelectWidth = _useConfigInject.dropdownMatchSelectWidth,
      contextSize = _useConfigInject.size,
      getPopupContainer = _useConfigInject.getPopupContainer,
      getPrefixCls = _useConfigInject.getPrefixCls,
      disabled = _useConfigInject.disabled;
    var _useCompactItemContex = (0, _Compact.useCompactItemContext)(prefixCls, direction),
      compactSize = _useCompactItemContex.compactSize,
      compactItemClassnames = _useCompactItemContex.compactItemClassnames;
    var mergedSize = (0, _vue.computed)(function () {
      return compactSize.value || contextSize.value;
    });
    var contextDisabled = (0, _DisabledContext.useInjectDisabled)();
    var mergedDisabled = (0, _vue.computed)(function () {
      var _a;
      return (_a = disabled.value) !== null && _a !== void 0 ? _a : contextDisabled.value;
    });
    var rootPrefixCls = (0, _vue.computed)(function () {
      return getPrefixCls();
    });
    // ===================== Placement =====================
    var placement = (0, _vue.computed)(function () {
      if (props.placement !== undefined) {
        return props.placement;
      }
      return direction.value === 'rtl' ? 'bottomRight' : 'bottomLeft';
    });
    var transitionName = (0, _vue.computed)(function () {
      return getTransitionName(rootPrefixCls.value, (0, _transition.getTransitionDirection)(placement.value), props.transitionName);
    });
    var choiceTransitionName = (0, _vue.computed)(function () {
      return getTransitionName(rootPrefixCls.value, '', props.choiceTransitionName);
    });
    var treePrefixCls = (0, _vue.computed)(function () {
      return getPrefixCls('select-tree', props.prefixCls);
    });
    var treeSelectPrefixCls = (0, _vue.computed)(function () {
      return getPrefixCls('tree-select', props.prefixCls);
    });
    // style
    var _useSelectStyle = (0, _style.default)(prefixCls),
      _useSelectStyle2 = (0, _slicedToArray2.default)(_useSelectStyle, 2),
      wrapSelectSSR = _useSelectStyle2[0],
      hashId = _useSelectStyle2[1];
    var _useStyle = (0, _style2.default)(treeSelectPrefixCls, treePrefixCls),
      _useStyle2 = (0, _slicedToArray2.default)(_useStyle, 1),
      wrapTreeSelectSSR = _useStyle2[0];
    var mergedDropdownClassName = (0, _vue.computed)(function () {
      return (0, _classNames3.default)(props.popupClassName || props.dropdownClassName, "".concat(treeSelectPrefixCls.value, "-dropdown"), (0, _defineProperty2.default)({}, "".concat(treeSelectPrefixCls.value, "-dropdown-rtl"), direction.value === 'rtl'), hashId.value);
    });
    var isMultiple = (0, _vue.computed)(function () {
      return !!(props.treeCheckable || props.multiple);
    });
    var mergedShowArrow = (0, _vue.computed)(function () {
      return props.showArrow !== undefined ? props.showArrow : props.loading || !isMultiple.value;
    });
    var treeSelectRef = (0, _vue.ref)();
    expose({
      focus: function focus() {
        var _a, _b;
        (_b = (_a = treeSelectRef.value).focus) === null || _b === void 0 ? void 0 : _b.call(_a);
      },
      blur: function blur() {
        var _a, _b;
        (_b = (_a = treeSelectRef.value).blur) === null || _b === void 0 ? void 0 : _b.call(_a);
      }
    });
    var handleChange = function handleChange() {
      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }
      emit('update:value', args[0]);
      emit.apply(void 0, ['change'].concat(args));
      formItemContext.onFieldChange();
    };
    var handleTreeExpand = function handleTreeExpand(keys) {
      emit('update:treeExpandedKeys', keys);
      emit('treeExpand', keys);
    };
    var handleSearch = function handleSearch(value) {
      emit('update:searchValue', value);
      emit('search', value);
    };
    var handleBlur = function handleBlur(e) {
      emit('blur', e);
      formItemContext.onFieldBlur();
    };
    return function () {
      var _classNames2;
      var _a, _b;
      var _props$notFoundConten = props.notFoundContent,
        notFoundContent = _props$notFoundConten === void 0 ? (_a = slots.notFoundContent) === null || _a === void 0 ? void 0 : _a.call(slots) : _props$notFoundConten,
        customizePrefixCls = props.prefixCls,
        bordered = props.bordered,
        listHeight = props.listHeight,
        listItemHeight = props.listItemHeight,
        multiple = props.multiple,
        treeIcon = props.treeIcon,
        treeLine = props.treeLine,
        showArrow = props.showArrow,
        _props$switcherIcon = props.switcherIcon,
        _switcherIcon = _props$switcherIcon === void 0 ? (_b = slots.switcherIcon) === null || _b === void 0 ? void 0 : _b.call(slots) : _props$switcherIcon,
        _props$fieldNames = props.fieldNames,
        fieldNames = _props$fieldNames === void 0 ? props.replaceFields : _props$fieldNames,
        _props$id = props.id,
        id = _props$id === void 0 ? formItemContext.id.value : _props$id;
      var isFormItemInput = formItemInputContext.isFormItemInput,
        hasFeedback = formItemInputContext.hasFeedback,
        feedbackIcon = formItemInputContext.feedbackIcon;
      // ===================== Icons =====================
      var _getIcons = (0, _iconUtil.default)((0, _extends2.default)((0, _extends2.default)({}, props), {
          multiple: isMultiple.value,
          showArrow: mergedShowArrow.value,
          hasFeedback: hasFeedback,
          feedbackIcon: feedbackIcon,
          prefixCls: prefixCls.value
        }), slots),
        suffixIcon = _getIcons.suffixIcon,
        removeIcon = _getIcons.removeIcon,
        clearIcon = _getIcons.clearIcon;
      // ===================== Empty =====================
      var mergedNotFound;
      if (notFoundContent !== undefined) {
        mergedNotFound = notFoundContent;
      } else {
        mergedNotFound = renderEmpty('Select');
      }
      // ==================== Render =====================
      var selectProps = (0, _omit.default)(props, ['suffixIcon', 'itemIcon', 'removeIcon', 'clearIcon', 'switcherIcon', 'bordered', 'status', 'onUpdate:value', 'onUpdate:treeExpandedKeys', 'onUpdate:searchValue']);
      var mergedClassName = (0, _classNames3.default)(!customizePrefixCls && treeSelectPrefixCls.value, (_classNames2 = {}, (0, _defineProperty2.default)(_classNames2, "".concat(prefixCls.value, "-lg"), mergedSize.value === 'large'), (0, _defineProperty2.default)(_classNames2, "".concat(prefixCls.value, "-sm"), mergedSize.value === 'small'), (0, _defineProperty2.default)(_classNames2, "".concat(prefixCls.value, "-rtl"), direction.value === 'rtl'), (0, _defineProperty2.default)(_classNames2, "".concat(prefixCls.value, "-borderless"), !bordered), (0, _defineProperty2.default)(_classNames2, "".concat(prefixCls.value, "-in-form-item"), isFormItemInput), _classNames2), (0, _statusUtils.getStatusClassNames)(prefixCls.value, mergedStatus.value, hasFeedback), compactItemClassnames.value, attrs.class, hashId.value);
      var otherProps = {};
      if (props.treeData === undefined && slots.default) {
        otherProps.children = (0, _propsUtil.flattenChildren)(slots.default());
      }
      return wrapSelectSSR(wrapTreeSelectSSR((0, _vue.createVNode)(_vcTreeSelect.default, (0, _objectSpread2.default)((0, _objectSpread2.default)((0, _objectSpread2.default)((0, _objectSpread2.default)({}, attrs), selectProps), {}, {
        "disabled": mergedDisabled.value,
        "virtual": virtual.value,
        "dropdownMatchSelectWidth": dropdownMatchSelectWidth.value,
        "id": id,
        "fieldNames": fieldNames,
        "ref": treeSelectRef,
        "prefixCls": prefixCls.value,
        "class": mergedClassName,
        "listHeight": listHeight,
        "listItemHeight": listItemHeight,
        "treeLine": !!treeLine,
        "inputIcon": suffixIcon,
        "multiple": multiple,
        "removeIcon": removeIcon,
        "clearIcon": clearIcon,
        "switcherIcon": function switcherIcon(nodeProps) {
          return (0, _iconUtil2.default)(treePrefixCls.value, _switcherIcon, nodeProps, slots.leafIcon, treeLine);
        },
        "showTreeIcon": treeIcon,
        "notFoundContent": mergedNotFound,
        "getPopupContainer": getPopupContainer === null || getPopupContainer === void 0 ? void 0 : getPopupContainer.value,
        "treeMotion": null,
        "dropdownClassName": mergedDropdownClassName.value,
        "choiceTransitionName": choiceTransitionName.value,
        "onChange": handleChange,
        "onBlur": handleBlur,
        "onSearch": handleSearch,
        "onTreeExpand": handleTreeExpand
      }, otherProps), {}, {
        "transitionName": transitionName.value,
        "customSlots": (0, _extends2.default)((0, _extends2.default)({}, slots), {
          treeCheckable: function treeCheckable() {
            return (0, _vue.createVNode)("span", {
              "class": "".concat(prefixCls.value, "-tree-checkbox-inner")
            }, null);
          }
        }),
        "maxTagPlaceholder": props.maxTagPlaceholder || slots.maxTagPlaceholder,
        "placement": placement.value,
        "showArrow": hasFeedback || showArrow
      }), (0, _extends2.default)((0, _extends2.default)({}, slots), {
        treeCheckable: function treeCheckable() {
          return (0, _vue.createVNode)("span", {
            "class": "".concat(prefixCls.value, "-tree-checkbox-inner")
          }, null);
        }
      }))));
    };
  }
});
/* istanbul ignore next */
var TreeSelectNode = _vcTreeSelect.TreeNode;
exports.TreeSelectNode = TreeSelectNode;
var _default = (0, _extends2.default)(TreeSelect, {
  TreeNode: _vcTreeSelect.TreeNode,
  SHOW_ALL: _vcTreeSelect.SHOW_ALL,
  SHOW_PARENT: _vcTreeSelect.SHOW_PARENT,
  SHOW_CHILD: _vcTreeSelect.SHOW_CHILD,
  install: function install(app) {
    app.component(TreeSelect.name, TreeSelect);
    app.component(TreeSelectNode.displayName, TreeSelectNode);
    return app;
  }
});
exports.default = _default;