"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.treeProps = exports.default = void 0;
var _vue = require("vue");
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _classNames2 = _interopRequireDefault(require("../_util/classNames"));
var _vcTree = _interopRequireDefault(require("../vc-tree"));
var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));
var _propsUtil = require("../_util/props-util");
var _initDefaultProps = _interopRequireDefault(require("../_util/props-util/initDefaultProps"));
var _props = require("../vc-tree/props");
var _useConfigInject2 = _interopRequireDefault(require("../config-provider/hooks/useConfigInject"));
var _iconUtil = _interopRequireDefault(require("./utils/iconUtil"));
var _dropIndicator = _interopRequireDefault(require("./utils/dropIndicator"));
var _devWarning = _interopRequireDefault(require("../vc-util/devWarning"));
var _warning = require("../vc-util/warning");
var _omit = _interopRequireDefault(require("../_util/omit"));
var _type = require("../_util/type");
var _style = _interopRequireDefault(require("./style"));
// CSSINJS

var treeProps = function treeProps() {
  var baseTreeProps = (0, _props.treeProps)();
  return (0, _extends2.default)((0, _extends2.default)({}, baseTreeProps), {
    showLine: (0, _type.someType)([Boolean, Object]),
    /** 是否支持多选 */
    multiple: (0, _type.booleanType)(),
    /** 是否自动展开父节点 */
    autoExpandParent: (0, _type.booleanType)(),
    /** checkable状态下节点选择完全受控（父子节点选中状态不再关联）*/
    checkStrictly: (0, _type.booleanType)(),
    /** 是否支持选中 */
    checkable: (0, _type.booleanType)(),
    /** 是否禁用树 */
    disabled: (0, _type.booleanType)(),
    /** 默认展开所有树节点 */
    defaultExpandAll: (0, _type.booleanType)(),
    /** 默认展开对应树节点 */
    defaultExpandParent: (0, _type.booleanType)(),
    /** 默认展开指定的树节点 */
    defaultExpandedKeys: (0, _type.arrayType)(),
    /** （受控）展开指定的树节点 */
    expandedKeys: (0, _type.arrayType)(),
    /** （受控）选中复选框的树节点 */
    checkedKeys: (0, _type.someType)([Array, Object]),
    /** 默认选中复选框的树节点 */
    defaultCheckedKeys: (0, _type.arrayType)(),
    /** （受控）设置选中的树节点 */
    selectedKeys: (0, _type.arrayType)(),
    /** 默认选中的树节点 */
    defaultSelectedKeys: (0, _type.arrayType)(),
    selectable: (0, _type.booleanType)(),
    loadedKeys: (0, _type.arrayType)(),
    draggable: (0, _type.booleanType)(),
    showIcon: (0, _type.booleanType)(),
    icon: (0, _type.functionType)(),
    switcherIcon: _vueTypes.default.any,
    prefixCls: String,
    /**
     * @default{title,key,children}
     * deprecated, please use `fieldNames` instead
     * 替换treeNode中 title,key,children字段为treeData中对应的字段
     */
    replaceFields: (0, _type.objectType)(),
    blockNode: (0, _type.booleanType)(),
    openAnimation: _vueTypes.default.any,
    onDoubleclick: baseTreeProps.onDblclick,
    'onUpdate:selectedKeys': (0, _type.functionType)(),
    'onUpdate:checkedKeys': (0, _type.functionType)(),
    'onUpdate:expandedKeys': (0, _type.functionType)()
  });
};
exports.treeProps = treeProps;
var _default = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'ATree',
  inheritAttrs: false,
  props: (0, _initDefaultProps.default)(treeProps(), {
    checkable: false,
    selectable: true,
    showIcon: false,
    blockNode: false
  }),
  slots: ['icon', 'title', 'switcherIcon', 'titleRender'],
  // emits: [
  //   'update:selectedKeys',
  //   'update:checkedKeys',
  //   'update:expandedKeys',
  //   'expand',
  //   'select',
  //   'check',
  //   'doubleclick',
  //   'dblclick',
  // ],
  setup: function setup(props, _ref) {
    var attrs = _ref.attrs,
      expose = _ref.expose,
      emit = _ref.emit,
      slots = _ref.slots;
    (0, _warning.warning)(!(props.treeData === undefined && slots.default), '`children` of Tree is deprecated. Please use `treeData` instead.');
    var _useConfigInject = (0, _useConfigInject2.default)('tree', props),
      prefixCls = _useConfigInject.prefixCls,
      direction = _useConfigInject.direction,
      virtual = _useConfigInject.virtual;
    // style
    var _useStyle = (0, _style.default)(prefixCls),
      _useStyle2 = (0, _slicedToArray2.default)(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var treeRef = (0, _vue.ref)();
    var scrollTo = function scrollTo(scroll) {
      var _a;
      (_a = treeRef.value) === null || _a === void 0 ? void 0 : _a.scrollTo(scroll);
    };
    expose({
      treeRef: treeRef,
      onNodeExpand: function onNodeExpand() {
        var _a2;
        var _a;
        (_a = treeRef.value) === null || _a === void 0 ? void 0 : (_a2 = _a).onNodeExpand.apply(_a2, arguments);
      },
      scrollTo: scrollTo,
      selectedKeys: (0, _vue.computed)(function () {
        var _a;
        return (_a = treeRef.value) === null || _a === void 0 ? void 0 : _a.selectedKeys;
      }),
      checkedKeys: (0, _vue.computed)(function () {
        var _a;
        return (_a = treeRef.value) === null || _a === void 0 ? void 0 : _a.checkedKeys;
      }),
      halfCheckedKeys: (0, _vue.computed)(function () {
        var _a;
        return (_a = treeRef.value) === null || _a === void 0 ? void 0 : _a.halfCheckedKeys;
      }),
      loadedKeys: (0, _vue.computed)(function () {
        var _a;
        return (_a = treeRef.value) === null || _a === void 0 ? void 0 : _a.loadedKeys;
      }),
      loadingKeys: (0, _vue.computed)(function () {
        var _a;
        return (_a = treeRef.value) === null || _a === void 0 ? void 0 : _a.loadingKeys;
      }),
      expandedKeys: (0, _vue.computed)(function () {
        var _a;
        return (_a = treeRef.value) === null || _a === void 0 ? void 0 : _a.expandedKeys;
      })
    });
    (0, _vue.watchEffect)(function () {
      (0, _devWarning.default)(props.replaceFields === undefined, 'Tree', '`replaceFields` is deprecated, please use fieldNames instead');
    });
    var handleCheck = function handleCheck(checkedObjOrKeys, eventObj) {
      emit('update:checkedKeys', checkedObjOrKeys);
      emit('check', checkedObjOrKeys, eventObj);
    };
    var handleExpand = function handleExpand(expandedKeys, eventObj) {
      emit('update:expandedKeys', expandedKeys);
      emit('expand', expandedKeys, eventObj);
    };
    var handleSelect = function handleSelect(selectedKeys, eventObj) {
      emit('update:selectedKeys', selectedKeys);
      emit('select', selectedKeys, eventObj);
    };
    return function () {
      var _classNames;
      var showIcon = props.showIcon,
        showLine = props.showLine,
        _props$switcherIcon = props.switcherIcon,
        _switcherIcon = _props$switcherIcon === void 0 ? slots.switcherIcon : _props$switcherIcon,
        _props$icon = props.icon,
        icon = _props$icon === void 0 ? slots.icon : _props$icon,
        blockNode = props.blockNode,
        checkable = props.checkable,
        selectable = props.selectable,
        _props$fieldNames = props.fieldNames,
        fieldNames = _props$fieldNames === void 0 ? props.replaceFields : _props$fieldNames,
        _props$motion = props.motion,
        motion = _props$motion === void 0 ? props.openAnimation : _props$motion,
        _props$itemHeight = props.itemHeight,
        itemHeight = _props$itemHeight === void 0 ? 28 : _props$itemHeight,
        onDoubleclick = props.onDoubleclick,
        onDblclick = props.onDblclick;
      var newProps = (0, _extends2.default)((0, _extends2.default)((0, _extends2.default)({}, attrs), (0, _omit.default)(props, ['onUpdate:checkedKeys', 'onUpdate:expandedKeys', 'onUpdate:selectedKeys', 'onDoubleclick'])), {
        showLine: Boolean(showLine),
        dropIndicatorRender: _dropIndicator.default,
        fieldNames: fieldNames,
        icon: icon,
        itemHeight: itemHeight
      });
      var children = slots.default ? (0, _propsUtil.filterEmpty)(slots.default()) : undefined;
      return wrapSSR((0, _vue.createVNode)(_vcTree.default, (0, _objectSpread2.default)((0, _objectSpread2.default)({}, newProps), {}, {
        "virtual": virtual.value,
        "motion": motion,
        "ref": treeRef,
        "prefixCls": prefixCls.value,
        "class": (0, _classNames2.default)((_classNames = {}, (0, _defineProperty2.default)(_classNames, "".concat(prefixCls.value, "-icon-hide"), !showIcon), (0, _defineProperty2.default)(_classNames, "".concat(prefixCls.value, "-block-node"), blockNode), (0, _defineProperty2.default)(_classNames, "".concat(prefixCls.value, "-unselectable"), !selectable), (0, _defineProperty2.default)(_classNames, "".concat(prefixCls.value, "-rtl"), direction.value === 'rtl'), _classNames), attrs.class, hashId.value),
        "direction": direction.value,
        "checkable": checkable,
        "selectable": selectable,
        "switcherIcon": function switcherIcon(nodeProps) {
          return (0, _iconUtil.default)(prefixCls.value, _switcherIcon, nodeProps, slots.leafIcon, showLine);
        },
        "onCheck": handleCheck,
        "onExpand": handleExpand,
        "onSelect": handleSelect,
        "onDblclick": onDblclick || onDoubleclick,
        "children": children
      }), (0, _extends2.default)((0, _extends2.default)({}, slots), {
        checkable: function checkable() {
          return (0, _vue.createVNode)("span", {
            "class": "".concat(prefixCls.value, "-checkbox-inner")
          }, null);
        }
      })));
    };
  }
});
exports.default = _default;