"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.listItemProps = exports.default = void 0;
var _vue = require("vue");
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _EyeOutlined = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/EyeOutlined"));
var _DeleteOutlined = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/DeleteOutlined"));
var _DownloadOutlined = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/DownloadOutlined"));
var _tooltip = _interopRequireDefault(require("../../tooltip"));
var _progress = _interopRequireDefault(require("../../progress"));
var _useConfigInject2 = _interopRequireDefault(require("../../config-provider/hooks/useConfigInject"));
var _transition = _interopRequireWildcard(require("../../_util/transition"));
var _type = require("../../_util/type");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
var listItemProps = function listItemProps() {
  return {
    prefixCls: String,
    locale: (0, _type.objectType)(undefined),
    file: (0, _type.objectType)(),
    items: (0, _type.arrayType)(),
    listType: (0, _type.stringType)(),
    isImgUrl: (0, _type.functionType)(),
    showRemoveIcon: (0, _type.booleanType)(),
    showDownloadIcon: (0, _type.booleanType)(),
    showPreviewIcon: (0, _type.booleanType)(),
    removeIcon: (0, _type.functionType)(),
    downloadIcon: (0, _type.functionType)(),
    previewIcon: (0, _type.functionType)(),
    iconRender: (0, _type.functionType)(),
    actionIconRender: (0, _type.functionType)(),
    itemRender: (0, _type.functionType)(),
    onPreview: (0, _type.functionType)(),
    onClose: (0, _type.functionType)(),
    onDownload: (0, _type.functionType)(),
    progress: (0, _type.objectType)()
  };
};
exports.listItemProps = listItemProps;
var _default2 = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'ListItem',
  inheritAttrs: false,
  props: listItemProps(),
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      attrs = _ref.attrs;
    var _a;
    var showProgress = (0, _vue.shallowRef)(false);
    var progressRafRef = (0, _vue.shallowRef)();
    (0, _vue.onMounted)(function () {
      progressRafRef.value = setTimeout(function () {
        showProgress.value = true;
      }, 300);
    });
    (0, _vue.onBeforeUnmount)(function () {
      clearTimeout(progressRafRef.value);
    });
    var mergedStatus = (0, _vue.shallowRef)((_a = props.file) === null || _a === void 0 ? void 0 : _a.status);
    (0, _vue.watch)(function () {
      var _a;
      return (_a = props.file) === null || _a === void 0 ? void 0 : _a.status;
    }, function (status) {
      if (status !== 'removed') {
        mergedStatus.value = status;
      }
    });
    var _useConfigInject = (0, _useConfigInject2.default)('upload', props),
      rootPrefixCls = _useConfigInject.rootPrefixCls;
    var transitionProps = (0, _vue.computed)(function () {
      return (0, _transition.getTransitionProps)("".concat(rootPrefixCls.value, "-fade"));
    });
    return function () {
      var _infoUploadingClass, _listContainerNameCla;
      var _a, _b;
      var prefixCls = props.prefixCls,
        locale = props.locale,
        listType = props.listType,
        file = props.file,
        items = props.items,
        progressProps = props.progress,
        _props$iconRender = props.iconRender,
        iconRender = _props$iconRender === void 0 ? slots.iconRender : _props$iconRender,
        _props$actionIconRend = props.actionIconRender,
        actionIconRender = _props$actionIconRend === void 0 ? slots.actionIconRender : _props$actionIconRend,
        _props$itemRender = props.itemRender,
        itemRender = _props$itemRender === void 0 ? slots.itemRender : _props$itemRender,
        isImgUrl = props.isImgUrl,
        showPreviewIcon = props.showPreviewIcon,
        showRemoveIcon = props.showRemoveIcon,
        showDownloadIcon = props.showDownloadIcon,
        _props$previewIcon = props.previewIcon,
        customPreviewIcon = _props$previewIcon === void 0 ? slots.previewIcon : _props$previewIcon,
        _props$removeIcon = props.removeIcon,
        customRemoveIcon = _props$removeIcon === void 0 ? slots.removeIcon : _props$removeIcon,
        _props$downloadIcon = props.downloadIcon,
        customDownloadIcon = _props$downloadIcon === void 0 ? slots.downloadIcon : _props$downloadIcon,
        onPreview = props.onPreview,
        onDownload = props.onDownload,
        onClose = props.onClose;
      var className = attrs.class,
        style = attrs.style;
      // This is used for legacy span make scrollHeight the wrong value.
      // We will force these to be `display: block` with non `picture-card`
      var iconNode = iconRender({
        file: file
      });
      var icon = (0, _vue.createVNode)("div", {
        "class": "".concat(prefixCls, "-text-icon")
      }, [iconNode]);
      if (listType === 'picture' || listType === 'picture-card') {
        if (mergedStatus.value === 'uploading' || !file.thumbUrl && !file.url) {
          var _uploadingClassName;
          var uploadingClassName = (_uploadingClassName = {}, (0, _defineProperty2.default)(_uploadingClassName, "".concat(prefixCls, "-list-item-thumbnail"), true), (0, _defineProperty2.default)(_uploadingClassName, "".concat(prefixCls, "-list-item-file"), mergedStatus.value !== 'uploading'), _uploadingClassName);
          icon = (0, _vue.createVNode)("div", {
            "class": uploadingClassName
          }, [iconNode]);
        } else {
          var _aClassName;
          var thumbnail = (isImgUrl === null || isImgUrl === void 0 ? void 0 : isImgUrl(file)) ? (0, _vue.createVNode)("img", {
            "src": file.thumbUrl || file.url,
            "alt": file.name,
            "class": "".concat(prefixCls, "-list-item-image"),
            "crossorigin": file.crossOrigin
          }, null) : iconNode;
          var aClassName = (_aClassName = {}, (0, _defineProperty2.default)(_aClassName, "".concat(prefixCls, "-list-item-thumbnail"), true), (0, _defineProperty2.default)(_aClassName, "".concat(prefixCls, "-list-item-file"), isImgUrl && !isImgUrl(file)), _aClassName);
          icon = (0, _vue.createVNode)("a", {
            "class": aClassName,
            "onClick": function onClick(e) {
              return onPreview(file, e);
            },
            "href": file.url || file.thumbUrl,
            "target": "_blank",
            "rel": "noopener noreferrer"
          }, [thumbnail]);
        }
      }
      var infoUploadingClass = (_infoUploadingClass = {}, (0, _defineProperty2.default)(_infoUploadingClass, "".concat(prefixCls, "-list-item"), true), (0, _defineProperty2.default)(_infoUploadingClass, "".concat(prefixCls, "-list-item-").concat(mergedStatus.value), true), _infoUploadingClass);
      var linkProps = typeof file.linkProps === 'string' ? JSON.parse(file.linkProps) : file.linkProps;
      var removeIcon = showRemoveIcon ? actionIconRender({
        customIcon: customRemoveIcon ? customRemoveIcon({
          file: file
        }) : (0, _vue.createVNode)(_DeleteOutlined.default, null, null),
        callback: function callback() {
          return onClose(file);
        },
        prefixCls: prefixCls,
        title: locale.removeFile
      }) : null;
      var downloadIcon = showDownloadIcon && mergedStatus.value === 'done' ? actionIconRender({
        customIcon: customDownloadIcon ? customDownloadIcon({
          file: file
        }) : (0, _vue.createVNode)(_DownloadOutlined.default, null, null),
        callback: function callback() {
          return onDownload(file);
        },
        prefixCls: prefixCls,
        title: locale.downloadFile
      }) : null;
      var downloadOrDelete = listType !== 'picture-card' && (0, _vue.createVNode)("span", {
        "key": "download-delete",
        "class": ["".concat(prefixCls, "-list-item-actions"), {
          picture: listType === 'picture'
        }]
      }, [downloadIcon, removeIcon]);
      var listItemNameClass = "".concat(prefixCls, "-list-item-name");
      var fileName = file.url ? [(0, _vue.createVNode)("a", (0, _objectSpread2.default)((0, _objectSpread2.default)({
        "key": "view",
        "target": "_blank",
        "rel": "noopener noreferrer",
        "class": listItemNameClass,
        "title": file.name
      }, linkProps), {}, {
        "href": file.url,
        "onClick": function onClick(e) {
          return onPreview(file, e);
        }
      }), [file.name]), downloadOrDelete] : [(0, _vue.createVNode)("span", {
        "key": "view",
        "class": listItemNameClass,
        "onClick": function onClick(e) {
          return onPreview(file, e);
        },
        "title": file.name
      }, [file.name]), downloadOrDelete];
      var previewStyle = {
        pointerEvents: 'none',
        opacity: 0.5
      };
      var previewIcon = showPreviewIcon ? (0, _vue.createVNode)("a", {
        "href": file.url || file.thumbUrl,
        "target": "_blank",
        "rel": "noopener noreferrer",
        "style": file.url || file.thumbUrl ? undefined : previewStyle,
        "onClick": function onClick(e) {
          return onPreview(file, e);
        },
        "title": locale.previewFile
      }, [customPreviewIcon ? customPreviewIcon({
        file: file
      }) : (0, _vue.createVNode)(_EyeOutlined.default, null, null)]) : null;
      var pictureCardActions = listType === 'picture-card' && mergedStatus.value !== 'uploading' && (0, _vue.createVNode)("span", {
        "class": "".concat(prefixCls, "-list-item-actions")
      }, [previewIcon, mergedStatus.value === 'done' && downloadIcon, removeIcon]);
      var dom = (0, _vue.createVNode)("div", {
        "class": infoUploadingClass
      }, [icon, fileName, pictureCardActions, showProgress.value && (0, _vue.createVNode)(_transition.default, transitionProps.value, {
        default: function _default() {
          return [(0, _vue.withDirectives)((0, _vue.createVNode)("div", {
            "class": "".concat(prefixCls, "-list-item-progress")
          }, ['percent' in file ? (0, _vue.createVNode)(_progress.default, (0, _objectSpread2.default)((0, _objectSpread2.default)({}, progressProps), {}, {
            "type": "line",
            "percent": file.percent
          }), null) : null]), [[_vue.vShow, mergedStatus.value === 'uploading']])];
        }
      })]);
      var listContainerNameClass = (_listContainerNameCla = {}, (0, _defineProperty2.default)(_listContainerNameCla, "".concat(prefixCls, "-list-item-container"), true), (0, _defineProperty2.default)(_listContainerNameCla, "".concat(className), !!className), _listContainerNameCla);
      var message = file.response && typeof file.response === 'string' ? file.response : ((_a = file.error) === null || _a === void 0 ? void 0 : _a.statusText) || ((_b = file.error) === null || _b === void 0 ? void 0 : _b.message) || locale.uploadError;
      var item = mergedStatus.value === 'error' ? (0, _vue.createVNode)(_tooltip.default, {
        "title": message,
        "getPopupContainer": function getPopupContainer(node) {
          return node.parentNode;
        }
      }, {
        default: function _default() {
          return [dom];
        }
      }) : dom;
      return (0, _vue.createVNode)("div", {
        "class": listContainerNameClass,
        "style": style
      }, [itemRender ? itemRender({
        originNode: item,
        file: file,
        fileList: items,
        actions: {
          download: onDownload.bind(null, file),
          preview: onPreview.bind(null, file),
          remove: onClose.bind(null, file)
        }
      }) : item]);
    };
  }
});
exports.default = _default2;