"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _vue = require("vue");
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _classNames3 = _interopRequireDefault(require("../_util/classNames"));
var _vnode = require("../_util/vnode");
var _inputProps = require("./inputProps");
var _commonUtils = require("./utils/commonUtils");
var _default = (0, _vue.defineComponent)({
  name: 'BaseInput',
  inheritAttrs: false,
  props: (0, _inputProps.baseInputProps)(),
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      attrs = _ref.attrs;
    var containerRef = (0, _vue.ref)();
    var onInputMouseDown = function onInputMouseDown(e) {
      var _a;
      if ((_a = containerRef.value) === null || _a === void 0 ? void 0 : _a.contains(e.target)) {
        var triggerFocus = props.triggerFocus;
        triggerFocus === null || triggerFocus === void 0 ? void 0 : triggerFocus();
      }
    };
    var getClearIcon = function getClearIcon() {
      var _classNames;
      var _a;
      var allowClear = props.allowClear,
        value = props.value,
        disabled = props.disabled,
        readonly = props.readonly,
        handleReset = props.handleReset,
        _props$suffix = props.suffix,
        suffix = _props$suffix === void 0 ? slots.suffix : _props$suffix,
        prefixCls = props.prefixCls;
      if (!allowClear) {
        return null;
      }
      var needClear = !disabled && !readonly && value;
      var className = "".concat(prefixCls, "-clear-icon");
      var iconNode = ((_a = slots.clearIcon) === null || _a === void 0 ? void 0 : _a.call(slots)) || '*';
      return (0, _vue.createVNode)("span", {
        "onClick": handleReset,
        "onMousedown": function onMousedown(e) {
          return e.preventDefault();
        },
        "class": (0, _classNames3.default)((_classNames = {}, (0, _defineProperty2.default)(_classNames, "".concat(className, "-hidden"), !needClear), (0, _defineProperty2.default)(_classNames, "".concat(className, "-has-suffix"), !!suffix), _classNames), className),
        "role": "button",
        "tabindex": -1
      }, [iconNode]);
    };
    return function () {
      var _a, _b;
      var focused = props.focused,
        value = props.value,
        disabled = props.disabled,
        allowClear = props.allowClear,
        readonly = props.readonly,
        hidden = props.hidden,
        prefixCls = props.prefixCls,
        _props$prefix = props.prefix,
        prefix = _props$prefix === void 0 ? (_a = slots.prefix) === null || _a === void 0 ? void 0 : _a.call(slots) : _props$prefix,
        _props$suffix2 = props.suffix,
        suffix = _props$suffix2 === void 0 ? (_b = slots.suffix) === null || _b === void 0 ? void 0 : _b.call(slots) : _props$suffix2,
        _props$addonAfter = props.addonAfter,
        addonAfter = _props$addonAfter === void 0 ? slots.addonAfter : _props$addonAfter,
        _props$addonBefore = props.addonBefore,
        addonBefore = _props$addonBefore === void 0 ? slots.addonBefore : _props$addonBefore,
        inputElement = props.inputElement,
        affixWrapperClassName = props.affixWrapperClassName,
        wrapperClassName = props.wrapperClassName,
        groupClassName = props.groupClassName;
      var element = (0, _vnode.cloneElement)(inputElement, {
        value: value,
        hidden: hidden
      });
      // ================== Prefix & Suffix ================== //
      if ((0, _commonUtils.hasPrefixSuffix)({
        prefix: prefix,
        suffix: suffix,
        allowClear: allowClear
      })) {
        var _classNames2;
        var affixWrapperPrefixCls = "".concat(prefixCls, "-affix-wrapper");
        var affixWrapperCls = (0, _classNames3.default)(affixWrapperPrefixCls, (_classNames2 = {}, (0, _defineProperty2.default)(_classNames2, "".concat(affixWrapperPrefixCls, "-disabled"), disabled), (0, _defineProperty2.default)(_classNames2, "".concat(affixWrapperPrefixCls, "-focused"), focused), (0, _defineProperty2.default)(_classNames2, "".concat(affixWrapperPrefixCls, "-readonly"), readonly), (0, _defineProperty2.default)(_classNames2, "".concat(affixWrapperPrefixCls, "-input-with-clear-btn"), suffix && allowClear && value), _classNames2), !(0, _commonUtils.hasAddon)({
          addonAfter: addonAfter,
          addonBefore: addonBefore
        }) && attrs.class, affixWrapperClassName);
        var suffixNode = (suffix || allowClear) && (0, _vue.createVNode)("span", {
          "class": "".concat(prefixCls, "-suffix")
        }, [getClearIcon(), suffix]);
        element = (0, _vue.createVNode)("span", {
          "class": affixWrapperCls,
          "style": attrs.style,
          "hidden": !(0, _commonUtils.hasAddon)({
            addonAfter: addonAfter,
            addonBefore: addonBefore
          }) && hidden,
          "onMousedown": onInputMouseDown,
          "ref": containerRef
        }, [prefix && (0, _vue.createVNode)("span", {
          "class": "".concat(prefixCls, "-prefix")
        }, [prefix]), (0, _vnode.cloneElement)(inputElement, {
          style: null,
          value: value,
          hidden: null
        }), suffixNode]);
      }
      // ================== Addon ================== //
      if ((0, _commonUtils.hasAddon)({
        addonAfter: addonAfter,
        addonBefore: addonBefore
      })) {
        var wrapperCls = "".concat(prefixCls, "-group");
        var addonCls = "".concat(wrapperCls, "-addon");
        var mergedWrapperClassName = (0, _classNames3.default)("".concat(prefixCls, "-wrapper"), wrapperCls, wrapperClassName);
        var mergedGroupClassName = (0, _classNames3.default)("".concat(prefixCls, "-group-wrapper"), attrs.class, groupClassName);
        // Need another wrapper for changing display:table to display:inline-block
        // and put style prop in wrapper
        return (0, _vue.createVNode)("span", {
          "class": mergedGroupClassName,
          "style": attrs.style,
          "hidden": hidden
        }, [(0, _vue.createVNode)("span", {
          "class": mergedWrapperClassName
        }, [addonBefore && (0, _vue.createVNode)("span", {
          "class": addonCls
        }, [addonBefore]), (0, _vnode.cloneElement)(element, {
          style: null,
          hidden: null
        }), addonAfter && (0, _vue.createVNode)("span", {
          "class": addonCls
        }, [addonAfter])])]);
      }
      return element;
    };
  }
});
exports.default = _default;