"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _vue = require("vue");
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));
var _classNames2 = _interopRequireDefault(require("../_util/classNames"));
var _Step = _interopRequireDefault(require("./Step"));
var _type = require("../_util/type");
var _propsUtil = require("../_util/props-util");
var _vnode = require("../_util/vnode");
var __rest = void 0 && (void 0).__rest || function (s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};
var _default = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'Steps',
  props: {
    type: _vueTypes.default.string.def('default'),
    prefixCls: _vueTypes.default.string.def('vc-steps'),
    iconPrefix: _vueTypes.default.string.def('vc'),
    direction: _vueTypes.default.string.def('horizontal'),
    labelPlacement: _vueTypes.default.string.def('horizontal'),
    status: (0, _type.stringType)('process'),
    size: _vueTypes.default.string.def(''),
    progressDot: _vueTypes.default.oneOfType([_vueTypes.default.looseBool, _vueTypes.default.func]).def(undefined),
    initial: _vueTypes.default.number.def(0),
    current: _vueTypes.default.number.def(0),
    items: _vueTypes.default.array.def(function () {
      return [];
    }),
    icons: _vueTypes.default.shape({
      finish: _vueTypes.default.any,
      error: _vueTypes.default.any
    }).loose,
    stepIcon: (0, _type.functionType)(),
    isInline: _vueTypes.default.looseBool,
    itemRender: (0, _type.functionType)()
  },
  slots: ['stepIcon', 'progressDot'],
  emits: ['change'],
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      emit = _ref.emit;
    var onStepClick = function onStepClick(next) {
      var current = props.current;
      if (current !== next) {
        emit('change', next);
      }
    };
    var renderStep = function renderStep(item, index, legacyRender) {
      var prefixCls = props.prefixCls,
        iconPrefix = props.iconPrefix,
        status = props.status,
        current = props.current,
        initial = props.initial,
        icons = props.icons,
        _props$stepIcon = props.stepIcon,
        stepIcon = _props$stepIcon === void 0 ? slots.stepIcon : _props$stepIcon,
        isInline = props.isInline,
        itemRender = props.itemRender,
        _props$progressDot = props.progressDot,
        progressDot = _props$progressDot === void 0 ? slots.progressDot : _props$progressDot;
      var mergedProgressDot = isInline || progressDot;
      var mergedItem = (0, _extends2.default)((0, _extends2.default)({}, item), {
        class: ''
      });
      var stepNumber = initial + index;
      var commonProps = {
        active: stepNumber === current,
        stepNumber: stepNumber + 1,
        stepIndex: stepNumber,
        key: stepNumber,
        prefixCls: prefixCls,
        iconPrefix: iconPrefix,
        progressDot: mergedProgressDot,
        stepIcon: stepIcon,
        icons: icons,
        onStepClick: onStepClick
      };
      // fix tail color
      if (status === 'error' && index === current - 1) {
        mergedItem.class = "".concat(prefixCls, "-next-error");
      }
      if (!mergedItem.status) {
        if (stepNumber === current) {
          mergedItem.status = status;
        } else if (stepNumber < current) {
          mergedItem.status = 'finish';
        } else {
          mergedItem.status = 'wait';
        }
      }
      if (isInline) {
        mergedItem.icon = undefined;
        mergedItem.subTitle = undefined;
      }
      if (legacyRender) {
        return legacyRender((0, _extends2.default)((0, _extends2.default)({}, mergedItem), commonProps));
      }
      if (itemRender) {
        mergedItem.itemRender = function (stepItem) {
          return itemRender(mergedItem, stepItem);
        };
      }
      return (0, _vue.createVNode)(_Step.default, (0, _objectSpread2.default)((0, _objectSpread2.default)((0, _objectSpread2.default)({}, mergedItem), commonProps), {}, {
        "__legacy": false
      }), null);
    };
    var renderStepWithNode = function renderStepWithNode(node, index) {
      return renderStep((0, _extends2.default)({}, node.props), index, function (stepProps) {
        var stepNode = (0, _vnode.cloneElement)(node, stepProps);
        return stepNode;
      });
    };
    return function () {
      var _classNames;
      var _a;
      var prefixCls = props.prefixCls,
        direction = props.direction,
        type = props.type,
        labelPlacement = props.labelPlacement,
        iconPrefix = props.iconPrefix,
        status = props.status,
        size = props.size,
        current = props.current,
        _props$progressDot2 = props.progressDot,
        progressDot = _props$progressDot2 === void 0 ? slots.progressDot : _props$progressDot2,
        initial = props.initial,
        icons = props.icons,
        items = props.items,
        isInline = props.isInline,
        itemRender = props.itemRender,
        restProps = __rest(props, ["prefixCls", "direction", "type", "labelPlacement", "iconPrefix", "status", "size", "current", "progressDot", "initial", "icons", "items", "isInline", "itemRender"]);
      var isNav = type === 'navigation';
      var mergedProgressDot = isInline || progressDot;
      var mergedDirection = isInline ? 'horizontal' : direction;
      var mergedSize = isInline ? undefined : size;
      var adjustedLabelPlacement = mergedProgressDot ? 'vertical' : labelPlacement;
      var classString = (0, _classNames2.default)(prefixCls, "".concat(prefixCls, "-").concat(direction), (_classNames = {}, (0, _defineProperty2.default)(_classNames, "".concat(prefixCls, "-").concat(mergedSize), mergedSize), (0, _defineProperty2.default)(_classNames, "".concat(prefixCls, "-label-").concat(adjustedLabelPlacement), mergedDirection === 'horizontal'), (0, _defineProperty2.default)(_classNames, "".concat(prefixCls, "-dot"), !!mergedProgressDot), (0, _defineProperty2.default)(_classNames, "".concat(prefixCls, "-navigation"), isNav), (0, _defineProperty2.default)(_classNames, "".concat(prefixCls, "-inline"), isInline), _classNames));
      return (0, _vue.createVNode)("div", (0, _objectSpread2.default)({
        "class": classString
      }, restProps), [items.filter(function (item) {
        return item;
      }).map(function (item, index) {
        return renderStep(item, index);
      }), (0, _propsUtil.filterEmpty)((_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots)).map(renderStepWithNode)]);
    };
  }
});
exports.default = _default;