import useCacheToken from './hooks/useCacheToken';
import useStyleRegister, { extractStyle } from './hooks/useStyleRegister';
import Keyframes from './Keyframes';
import { legacyNotSelectorLinter, logicalPropertiesLinter } from './linters';
import { createCache, useStyleInject, useStyleProvider, StyleProvider } from './StyleContext';
import { createTheme, Theme } from './theme';
import legacyLogicalPropertiesTransformer from './transformers/legacyLogicalProperties';
const cssinjs = {
  Theme,
  createTheme,
  useStyleRegister,
  useCacheToken,
  createCache,
  useStyleInject,
  useStyleProvider,
  Keyframes,
  extractStyle,
  // Transformer
  legacyLogicalPropertiesTransformer,
  // Linters
  logicalPropertiesLinter,
  legacyNotSelectorLinter,
  // cssinjs
  StyleProvider
};
export { Theme, createTheme, useStyleRegister, useCacheToken, createCache, useStyleInject, useStyleProvider, Keyframes, extractStyle,
// Transformer
legacyLogicalPropertiesTransformer,
// Linters
logicalPropertiesLinter, legacyNotSelectorLinter,
// cssinjs
StyleProvider };
export default cssinjs;