import type { CSSProperties, ExtractPropTypes, PropType, VNode } from 'vue';
import type { valueType, Formatter } from './utils';
import type { CustomSlotsType } from '../_util/type';
export declare const statisticProps: () => {
    prefixCls: StringConstructor;
    decimalSeparator: StringConstructor;
    groupSeparator: StringConstructor;
    format: StringConstructor;
    value: {
        type: PropType<valueType>;
        default: valueType;
    };
    valueStyle: {
        type: PropType<CSSProperties>;
        default: CSSProperties;
    };
    valueRender: {
        type: PropType<(node: VNode | JSX.Element) => VNode | JSX.Element>;
        default: (node: VNode | JSX.Element) => VNode | JSX.Element;
    };
    formatter: {
        default: Formatter;
        type: PropType<Formatter>;
    };
    precision: NumberConstructor;
    prefix: {
        type: PropType<import("../_util/type").VueNode>;
    };
    suffix: {
        type: PropType<import("../_util/type").VueNode>;
    };
    title: {
        type: PropType<import("../_util/type").VueNode>;
    };
    loading: {
        type: BooleanConstructor;
        default: boolean;
    };
};
export type StatisticProps = Partial<ExtractPropTypes<ReturnType<typeof statisticProps>>>;
declare const _default: import("vue").DefineComponent<{
    prefixCls: StringConstructor;
    decimalSeparator: StringConstructor;
    groupSeparator: StringConstructor;
    format: StringConstructor;
    value: {
        type: PropType<valueType>;
        default: valueType;
    };
    valueStyle: {
        type: PropType<CSSProperties>;
        default: CSSProperties;
    };
    valueRender: {
        type: PropType<(node: JSX.Element | VNode<import("vue").RendererNode, import("vue").RendererElement, {
            [key: string]: any;
        }>) => JSX.Element | VNode<import("vue").RendererNode, import("vue").RendererElement, {
            [key: string]: any;
        }>>;
        default: (node: JSX.Element | VNode<import("vue").RendererNode, import("vue").RendererElement, {
            [key: string]: any;
        }>) => JSX.Element | VNode<import("vue").RendererNode, import("vue").RendererElement, {
            [key: string]: any;
        }>;
    };
    formatter: {
        default: Formatter;
        type: PropType<Formatter>;
    };
    precision: NumberConstructor;
    prefix: {
        type: PropType<import("../_util/type").VueNode>;
    };
    suffix: {
        type: PropType<import("../_util/type").VueNode>;
    };
    title: {
        type: PropType<import("../_util/type").VueNode>;
    };
    loading: {
        type: BooleanConstructor;
        default: boolean;
    };
}, () => import("../_util/type").VueNode, unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {}, string, import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<ExtractPropTypes<{
    prefixCls: StringConstructor;
    decimalSeparator: StringConstructor;
    groupSeparator: StringConstructor;
    format: StringConstructor;
    value: {
        type: PropType<valueType>;
        default: valueType;
    };
    valueStyle: {
        type: PropType<CSSProperties>;
        default: CSSProperties;
    };
    valueRender: {
        type: PropType<(node: JSX.Element | VNode<import("vue").RendererNode, import("vue").RendererElement, {
            [key: string]: any;
        }>) => JSX.Element | VNode<import("vue").RendererNode, import("vue").RendererElement, {
            [key: string]: any;
        }>>;
        default: (node: JSX.Element | VNode<import("vue").RendererNode, import("vue").RendererElement, {
            [key: string]: any;
        }>) => JSX.Element | VNode<import("vue").RendererNode, import("vue").RendererElement, {
            [key: string]: any;
        }>;
    };
    formatter: {
        default: Formatter;
        type: PropType<Formatter>;
    };
    precision: NumberConstructor;
    prefix: {
        type: PropType<import("../_util/type").VueNode>;
    };
    suffix: {
        type: PropType<import("../_util/type").VueNode>;
    };
    title: {
        type: PropType<import("../_util/type").VueNode>;
    };
    loading: {
        type: BooleanConstructor;
        default: boolean;
    };
}>>, {
    value: valueType;
    loading: boolean;
    formatter: Formatter;
    valueStyle: CSSProperties;
    valueRender: (node: JSX.Element | VNode<import("vue").RendererNode, import("vue").RendererElement, {
        [key: string]: any;
    }>) => JSX.Element | VNode<import("vue").RendererNode, import("vue").RendererElement, {
        [key: string]: any;
    }>;
}, CustomSlotsType<{
    title?: any;
    prefix?: any;
    suffix?: any;
    formatter?: any;
    default?: any;
}>>;
export default _default;
