"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useCacheToken;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _hash = _interopRequireDefault(require("@emotion/hash"));
var _StyleContext = require("../StyleContext");
var _useGlobalCache = _interopRequireDefault(require("./useGlobalCache"));
var _util = require("../util");
var _vue = require("vue");
const EMPTY_OVERRIDE = {};
// Generate different prefix to make user selector break in production env.
// This helps developer not to do style override directly on the hash id.
const hashPrefix = process.env.NODE_ENV !== 'production' ? 'css-dev-only-do-not-override' : 'css';
const tokenKeys = new Map();
function recordCleanToken(tokenKey) {
  tokenKeys.set(tokenKey, (tokenKeys.get(tokenKey) || 0) + 1);
}
function removeStyleTags(key) {
  if (typeof document !== 'undefined') {
    const styles = document.querySelectorAll(`style[${_StyleContext.ATTR_TOKEN}="${key}"]`);
    styles.forEach(style => {
      var _a;
      if (style[_StyleContext.CSS_IN_JS_INSTANCE] === _StyleContext.CSS_IN_JS_INSTANCE_ID) {
        (_a = style.parentNode) === null || _a === void 0 ? void 0 : _a.removeChild(style);
      }
    });
  }
}
// Remove will check current keys first
function cleanTokenStyle(tokenKey) {
  tokenKeys.set(tokenKey, (tokenKeys.get(tokenKey) || 0) - 1);
  const tokenKeyList = Array.from(tokenKeys.keys());
  const cleanableKeyList = tokenKeyList.filter(key => {
    const count = tokenKeys.get(key) || 0;
    return count <= 0;
  });
  if (cleanableKeyList.length < tokenKeyList.length) {
    cleanableKeyList.forEach(key => {
      removeStyleTags(key);
      tokenKeys.delete(key);
    });
  }
}
/**
 * Cache theme derivative token as global shared one
 * @param theme Theme entity
 * @param tokens List of tokens, used for cache. Please do not dynamic generate object directly
 * @param option Additional config
 * @returns Call Theme.getDerivativeToken(tokenObject) to get token
 */
function useCacheToken(theme, tokens) {
  let option = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : (0, _vue.ref)({});
  // Basic - We do basic cache here
  const mergedToken = (0, _vue.computed)(() => (0, _extends2.default)({}, ...tokens.value));
  const tokenStr = (0, _vue.computed)(() => (0, _util.flattenToken)(mergedToken.value));
  const overrideTokenStr = (0, _vue.computed)(() => (0, _util.flattenToken)(option.value.override || EMPTY_OVERRIDE));
  const cachedToken = (0, _useGlobalCache.default)('token', (0, _vue.computed)(() => [option.value.salt || '', theme.value.id, tokenStr.value, overrideTokenStr.value]), () => {
    const {
      salt = '',
      override = EMPTY_OVERRIDE,
      formatToken
    } = option.value;
    const derivativeToken = theme.value.getDerivativeToken(mergedToken.value);
    // Merge with override
    let mergedDerivativeToken = (0, _extends2.default)((0, _extends2.default)({}, derivativeToken), override);
    // Format if needed
    if (formatToken) {
      mergedDerivativeToken = formatToken(mergedDerivativeToken);
    }
    // Optimize for `useStyleRegister` performance
    const tokenKey = (0, _util.token2key)(mergedDerivativeToken, salt);
    mergedDerivativeToken._tokenKey = tokenKey;
    recordCleanToken(tokenKey);
    const hashId = `${hashPrefix}-${(0, _hash.default)(tokenKey)}`;
    mergedDerivativeToken._hashId = hashId; // Not used
    return [mergedDerivativeToken, hashId];
  }, cache => {
    // Remove token will remove all related style
    cleanTokenStyle(cache[0]._tokenKey);
  });
  return cachedToken;
}