"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.breadcrumbProps = void 0;
var _vue = require("vue");
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));
var _propsUtil = require("../_util/props-util");
var _warning = _interopRequireDefault(require("../_util/warning"));
var _BreadcrumbItem = _interopRequireDefault(require("./BreadcrumbItem"));
var _menu = _interopRequireDefault(require("../menu"));
var _useConfigInject = _interopRequireDefault(require("../config-provider/hooks/useConfigInject"));
var _style = _interopRequireDefault(require("./style"));
const breadcrumbProps = () => ({
  prefixCls: String,
  routes: {
    type: Array
  },
  params: _vueTypes.default.any,
  separator: _vueTypes.default.any,
  itemRender: {
    type: Function
  }
});
exports.breadcrumbProps = breadcrumbProps;
function getBreadcrumbName(route, params) {
  if (!route.breadcrumbName) {
    return null;
  }
  const paramsKeys = Object.keys(params).join('|');
  const name = route.breadcrumbName.replace(new RegExp(`:(${paramsKeys})`, 'g'), (replacement, key) => params[key] || replacement);
  return name;
}
function defaultItemRender(opt) {
  const {
    route,
    params,
    routes,
    paths
  } = opt;
  const isLastItem = routes.indexOf(route) === routes.length - 1;
  const name = getBreadcrumbName(route, params);
  return isLastItem ? (0, _vue.createVNode)("span", null, [name]) : (0, _vue.createVNode)("a", {
    "href": `#/${paths.join('/')}`
  }, [name]);
}
var _default = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'ABreadcrumb',
  inheritAttrs: false,
  props: breadcrumbProps(),
  slots: Object,
  setup(props, _ref) {
    let {
      slots,
      attrs
    } = _ref;
    const {
      prefixCls,
      direction
    } = (0, _useConfigInject.default)('breadcrumb', props);
    const [wrapSSR, hashId] = (0, _style.default)(prefixCls);
    const getPath = (path, params) => {
      path = (path || '').replace(/^\//, '');
      Object.keys(params).forEach(key => {
        path = path.replace(`:${key}`, params[key]);
      });
      return path;
    };
    const addChildPath = (paths, childPath, params) => {
      const originalPaths = [...paths];
      const path = getPath(childPath || '', params);
      if (path) {
        originalPaths.push(path);
      }
      return originalPaths;
    };
    const genForRoutes = _ref2 => {
      let {
        routes = [],
        params = {},
        separator,
        itemRender = defaultItemRender
      } = _ref2;
      const paths = [];
      return routes.map(route => {
        const path = getPath(route.path, params);
        if (path) {
          paths.push(path);
        }
        const tempPaths = [...paths];
        // generated overlay by route.children
        let overlay = null;
        if (route.children && route.children.length) {
          overlay = (0, _vue.createVNode)(_menu.default, {
            "items": route.children.map(child => ({
              key: child.path || child.breadcrumbName,
              label: itemRender({
                route: child,
                params,
                routes,
                paths: addChildPath(tempPaths, child.path, params)
              })
            }))
          }, null);
        }
        const itemProps = {
          separator
        };
        if (overlay) {
          itemProps.overlay = overlay;
        }
        return (0, _vue.createVNode)(_BreadcrumbItem.default, (0, _objectSpread2.default)((0, _objectSpread2.default)({}, itemProps), {}, {
          "key": path || route.breadcrumbName
        }), {
          default: () => [itemRender({
            route,
            params,
            routes,
            paths: tempPaths
          })]
        });
      });
    };
    return () => {
      var _a;
      let crumbs;
      const {
        routes,
        params = {}
      } = props;
      const children = (0, _propsUtil.flattenChildren)((0, _propsUtil.getPropsSlot)(slots, props));
      const separator = (_a = (0, _propsUtil.getPropsSlot)(slots, props, 'separator')) !== null && _a !== void 0 ? _a : '/';
      const itemRender = props.itemRender || slots.itemRender || defaultItemRender;
      if (routes && routes.length > 0) {
        // generated by route
        crumbs = genForRoutes({
          routes,
          params,
          separator,
          itemRender
        });
      } else if (children.length) {
        crumbs = children.map((element, index) => {
          (0, _warning.default)(typeof element.type === 'object' && (element.type.__ANT_BREADCRUMB_ITEM || element.type.__ANT_BREADCRUMB_SEPARATOR), 'Breadcrumb', "Only accepts Breadcrumb.Item and Breadcrumb.Separator as it's children");
          return (0, _vue.cloneVNode)(element, {
            separator,
            key: index
          });
        });
      }
      const breadcrumbClassName = {
        [prefixCls.value]: true,
        [`${prefixCls.value}-rtl`]: direction.value === 'rtl',
        [`${attrs.class}`]: !!attrs.class,
        [hashId.value]: true
      };
      return wrapSSR((0, _vue.createVNode)("nav", (0, _objectSpread2.default)((0, _objectSpread2.default)({}, attrs), {}, {
        "class": breadcrumbClassName
      }), [(0, _vue.createVNode)("ol", null, [crumbs])]));
    };
  }
});
exports.default = _default;