import * as _vue from "vue";

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/* eslint-disable @typescript-eslint/no-empty-function */
import { shallowMount } from '@vue/test-utils';
import useHover from '../index';
import { ref } from 'vue';
describe('useHover', function () {
  test('should work with custom event', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
    var onEnter, onLeave, wrapper;
    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            onEnter = jest.fn(function () {});
            onLeave = jest.fn(function () {});
            wrapper = shallowMount({
              setup: function setup() {
                var eleRef = ref(null);

                var _useHover = useHover(eleRef, {
                  onEnter: onEnter,
                  onLeave: onLeave
                }),
                    _useHover2 = _slicedToArray(_useHover, 1),
                    isHover = _useHover2[0];

                return {
                  eleRef: eleRef,
                  isHover: isHover
                };
              },
              render: function render() {
                return _vue.createVNode("h1", {
                  "ref": "eleRef"
                }, [_vue.createTextVNode("move your mouse")]);
              }
            });
            _context.next = 5;
            return wrapper.vm.$nextTick();

          case 5:
            wrapper.find('h1').trigger('mouseenter');
            expect(onEnter).toHaveBeenCalled();
            expect(wrapper.vm.isHover).toBe(true);
            wrapper.find('h1').trigger('mouseleave');
            expect(onLeave).toHaveBeenCalled();
            expect(wrapper.vm.isHover).toBe(false);

          case 11:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  })));
});