"use strict";

var _vue = _interopRequireWildcard(require("vue"));

var _testUtils = require("@vue/test-utils");

var _index = _interopRequireDefault(require("../index"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? Object(arguments[i]) : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

describe('drag', function () {
  var utils;
  beforeEach(function () {
    utils = setup();
  });
  describe('starting drag', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4() {
    return regeneratorRuntime.wrap(function _callee4$(_context4) {
      while (1) {
        switch (_context4.prev = _context4.next) {
          case 0:
            it('should supply proper props to target', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
              var _yield$utils, wrapper;

              return regeneratorRuntime.wrap(function _callee$(_context) {
                while (1) {
                  switch (_context.prev = _context.next) {
                    case 0:
                      _context.next = 2;
                      return utils;

                    case 2:
                      _yield$utils = _context.sent;
                      wrapper = _yield$utils.wrapper;
                      wrapper.find('#handle').trigger('mousedown');
                      _context.next = 7;
                      return wrapper.vm.$nextTick();

                    case 7:
                      expect(wrapper.find('[aria-grabbed]')).toBeTruthy;

                    case 8:
                    case "end":
                      return _context.stop();
                  }
                }
              }, _callee);
            })));
            it('should return a delta position', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
              var startAt, delta, _yield$utils2, drag, wrapper;

              return regeneratorRuntime.wrap(function _callee2$(_context2) {
                while (1) {
                  switch (_context2.prev = _context2.next) {
                    case 0:
                      startAt = {
                        clientX: 10,
                        clientY: 10
                      };
                      delta = {
                        x: 5,
                        y: 5
                      };
                      _context2.next = 4;
                      return utils;

                    case 4:
                      _yield$utils2 = _context2.sent;
                      drag = _yield$utils2.drag;
                      wrapper = _yield$utils2.wrapper;
                      _context2.next = 9;
                      return drag({
                        start: startAt,
                        delta: delta
                      });

                    case 9:
                      _context2.next = 11;
                      return wrapper.vm.$nextTick();

                    case 11:
                      expect(wrapper.find('#output').text()).toEqual("".concat(delta.x, ", ").concat(delta.y));

                    case 12:
                    case "end":
                      return _context2.stop();
                  }
                }
              }, _callee2);
            })));
            it('should return a correct delta position after more drag', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3() {
              var startAt, delta, secondStart, _yield$utils3, drag, wrapper;

              return regeneratorRuntime.wrap(function _callee3$(_context3) {
                while (1) {
                  switch (_context3.prev = _context3.next) {
                    case 0:
                      startAt = {
                        clientX: 10,
                        clientY: 10
                      };
                      delta = {
                        x: 5,
                        y: 5
                      };
                      secondStart = {
                        clientX: startAt.clientX + delta.x,
                        clientY: startAt.clientY + delta.y
                      };
                      _context3.next = 5;
                      return utils;

                    case 5:
                      _yield$utils3 = _context3.sent;
                      drag = _yield$utils3.drag;
                      wrapper = _yield$utils3.wrapper;
                      _context3.next = 10;
                      return drag({
                        start: startAt,
                        delta: delta
                      });

                    case 10:
                      _context3.next = 12;
                      return drag({
                        start: secondStart,
                        delta: delta
                      });

                    case 12:
                      _context3.next = 14;
                      return wrapper.vm.$nextTick();

                    case 14:
                      expect(wrapper.find('#output').text()).toEqual("".concat(2 * delta.x, ", ").concat(2 * delta.y));

                    case 15:
                    case "end":
                      return _context3.stop();
                  }
                }
              }, _callee3);
            })));

          case 3:
          case "end":
            return _context4.stop();
        }
      }
    }, _callee4);
  })));
});
describe('decorate with styles', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee11() {
  var utils;
  return regeneratorRuntime.wrap(function _callee11$(_context11) {
    while (1) {
      switch (_context11.prev = _context11.next) {
        case 0:
          beforeEach(function () {
            utils = setup({
              useDraggableOption: {
                controlStyle: true
              }
            });
          });
          it("should change target's style when dragging", /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee5() {
            var _yield$utils4, wrapper, drag;

            return regeneratorRuntime.wrap(function _callee5$(_context5) {
              while (1) {
                switch (_context5.prev = _context5.next) {
                  case 0:
                    _context5.next = 2;
                    return utils;

                  case 2:
                    _yield$utils4 = _context5.sent;
                    wrapper = _yield$utils4.wrapper;
                    drag = _yield$utils4.drag;
                    _context5.next = 7;
                    return drag({
                      start: {
                        clientX: 3,
                        clientY: 3
                      },
                      delta: {
                        x: 10,
                        y: 15
                      }
                    });

                  case 7:
                    expect(wrapper.find('#main').element.style.transform).toEqual("translate(10px, 15px)");

                  case 8:
                  case "end":
                    return _context5.stop();
                }
              }
            }, _callee5);
          })));
          it("should change target's style when dragging (touches)", /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee6() {
            var _yield$utils5, wrapper, drag;

            return regeneratorRuntime.wrap(function _callee6$(_context6) {
              while (1) {
                switch (_context6.prev = _context6.next) {
                  case 0:
                    _context6.next = 2;
                    return utils;

                  case 2:
                    _yield$utils5 = _context6.sent;
                    wrapper = _yield$utils5.wrapper;
                    drag = _yield$utils5.drag;
                    _context6.next = 7;
                    return drag({
                      start: {
                        clientX: 3,
                        clientY: 3
                      },
                      delta: {
                        x: 10,
                        y: 15
                      },
                      touch: true
                    });

                  case 7:
                    _context6.next = 9;
                    return wrapper.vm.$nextTick();

                  case 9:
                    expect(wrapper.find('#main').element.style.transform).toEqual("translate(10px, 15px)");

                  case 10:
                  case "end":
                    return _context6.stop();
                }
              }
            }, _callee6);
          })));
          it('should set proper cursor', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee7() {
            var _yield$utils6, wrapper;

            return regeneratorRuntime.wrap(function _callee7$(_context7) {
              while (1) {
                switch (_context7.prev = _context7.next) {
                  case 0:
                    _context7.next = 2;
                    return utils;

                  case 2:
                    _yield$utils6 = _context7.sent;
                    wrapper = _yield$utils6.wrapper;
                    _context7.next = 6;
                    return wrapper.vm.$nextTick();

                  case 6:
                    expect(wrapper.find('#handle').element.style.cursor).toEqual('grab');

                  case 7:
                  case "end":
                    return _context7.stop();
                }
              }
            }, _callee7);
          })));
          it('should change cursor while dragging', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee8() {
            var _yield$utils7, wrapper;

            return regeneratorRuntime.wrap(function _callee8$(_context8) {
              while (1) {
                switch (_context8.prev = _context8.next) {
                  case 0:
                    _context8.next = 2;
                    return utils;

                  case 2:
                    _yield$utils7 = _context8.sent;
                    wrapper = _yield$utils7.wrapper;
                    wrapper.find('#handle').trigger('mousedown');
                    _context8.next = 7;
                    return wrapper.vm.$nextTick();

                  case 7:
                    expect(wrapper.find('#handle').element.style.cursor).toEqual('grabbing');

                  case 8:
                  case "end":
                    return _context8.stop();
                }
              }
            }, _callee8);
          })));
          it('should add `will-change: transform` to target', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee9() {
            var _yield$utils8, wrapper;

            return regeneratorRuntime.wrap(function _callee9$(_context9) {
              while (1) {
                switch (_context9.prev = _context9.next) {
                  case 0:
                    _context9.next = 2;
                    return utils;

                  case 2:
                    _yield$utils8 = _context9.sent;
                    wrapper = _yield$utils8.wrapper;
                    wrapper.find('#handle').trigger('mousedown');
                    expect(wrapper.find('#main').element.style.willChange).toEqual('transform');

                  case 6:
                  case "end":
                    return _context9.stop();
                }
              }
            }, _callee9);
          })));
          it('should remove `will-change: transform` from target', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee10() {
            var _yield$utils9, wrapper, drag;

            return regeneratorRuntime.wrap(function _callee10$(_context10) {
              while (1) {
                switch (_context10.prev = _context10.next) {
                  case 0:
                    _context10.next = 2;
                    return utils;

                  case 2:
                    _yield$utils9 = _context10.sent;
                    wrapper = _yield$utils9.wrapper;
                    drag = _yield$utils9.drag;
                    _context10.next = 7;
                    return drag({
                      start: {
                        clientX: 3,
                        clientY: 3
                      },
                      delta: {
                        x: 10,
                        y: 15
                      }
                    });

                  case 7:
                    expect(wrapper.find('#main').element.style.willChange).toEqual('');

                  case 8:
                  case "end":
                    return _context10.stop();
                }
              }
            }, _callee10);
          })));

        case 7:
        case "end":
          return _context11.stop();
      }
    }
  }, _callee11);
})));
describe('ending drag', function () {
  var utils;
  beforeEach(function () {
    utils = setup({
      useDraggableOption: {
        controlStyle: true
      },
      style: {}
    });
  });
  it('should supply proper props to target', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee12() {
    var _yield$utils10, drag, wrapper;

    return regeneratorRuntime.wrap(function _callee12$(_context12) {
      while (1) {
        switch (_context12.prev = _context12.next) {
          case 0:
            _context12.next = 2;
            return utils;

          case 2:
            _yield$utils10 = _context12.sent;
            drag = _yield$utils10.drag;
            wrapper = _yield$utils10.wrapper;
            _context12.next = 7;
            return drag();

          case 7:
            expect(wrapper.find('[aria-grabbed]')).toBeNull;

          case 8:
          case "end":
            return _context12.stop();
        }
      }
    }, _callee12);
  })));
});
describe('limit in viewport', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee16() {
  var utils;
  return regeneratorRuntime.wrap(function _callee16$(_context16) {
    while (1) {
      switch (_context16.prev = _context16.next) {
        case 0:
          beforeEach(function () {
            utils = setup({
              useDraggableOption: {
                controlStyle: true,
                viewport: true
              },
              style: _objectSpread({}, defaultStyle, {
                width: '180px',
                left: 'auto',
                right: '0'
              })
            });
          });
          it('should not change transition beyond given rect', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee13() {
            var _yield$utils11, drag, wrapper, targetElement, rect, startAt, delta;

            return regeneratorRuntime.wrap(function _callee13$(_context13) {
              while (1) {
                switch (_context13.prev = _context13.next) {
                  case 0:
                    _context13.next = 2;
                    return utils;

                  case 2:
                    _yield$utils11 = _context13.sent;
                    drag = _yield$utils11.drag;
                    wrapper = _yield$utils11.wrapper;
                    targetElement = wrapper.find('#main').element;
                    rect = targetElement.getBoundingClientRect();
                    startAt = {
                      clientX: rect.left + 5,
                      clientY: rect.top + 5
                    };
                    delta = {
                      x: 5,
                      y: 5
                    };
                    _context13.next = 11;
                    return drag({
                      start: startAt,
                      delta: delta
                    });

                  case 11:
                    _context13.next = 13;
                    return wrapper.vm.$nextTick();

                  case 13:
                    expect(targetElement.style.transform).toContain("translate(5px, 5px)");

                  case 14:
                  case "end":
                    return _context13.stop();
                }
              }
            }, _callee13);
          })));
          it('should leave transition as it was before limit', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee14() {
            var _yield$utils12, wrapper, beginDrag, move, targetElement, startAt, delta;

            return regeneratorRuntime.wrap(function _callee14$(_context14) {
              while (1) {
                switch (_context14.prev = _context14.next) {
                  case 0:
                    _context14.next = 2;
                    return utils;

                  case 2:
                    _yield$utils12 = _context14.sent;
                    wrapper = _yield$utils12.wrapper;
                    beginDrag = _yield$utils12.beginDrag;
                    move = _yield$utils12.move;
                    targetElement = wrapper.find('#main').element;
                    startAt = {
                      clientX: 0 + 5,
                      clientY: 0 + 5
                    };
                    delta = {
                      x: 5,
                      y: 1
                    };
                    _context14.next = 11;
                    return beginDrag(startAt);

                  case 11:
                    _context14.next = 13;
                    return move({
                      clientX: startAt.clientX + delta.x,
                      clientY: startAt.clientY + delta.y
                    });

                  case 13:
                    _context14.next = 15;
                    return move({
                      clientX: startAt.clientX + delta.x + 10,
                      clientY: startAt.clientY + delta.y
                    });

                  case 15:
                    _context14.next = 17;
                    return move({
                      clientX: startAt.clientX + delta.x + 25,
                      clientY: startAt.clientY + delta.y
                    });

                  case 17:
                    _context14.next = 19;
                    return move({
                      clientX: startAt.clientX + delta.x + 50,
                      clientY: startAt.clientY + delta.y
                    });

                  case 19:
                    _context14.next = 21;
                    return wrapper.vm.$nextTick();

                  case 21:
                    expect(targetElement.style.transform).toContain("translate(55px, 1px)");

                  case 22:
                  case "end":
                    return _context14.stop();
                }
              }
            }, _callee14);
          })));
          it('should keep limits when dragging more than once', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee15() {
            var _yield$utils13, drag, wrapper, targetElement, startAt, delta;

            return regeneratorRuntime.wrap(function _callee15$(_context15) {
              while (1) {
                switch (_context15.prev = _context15.next) {
                  case 0:
                    _context15.next = 2;
                    return utils;

                  case 2:
                    _yield$utils13 = _context15.sent;
                    drag = _yield$utils13.drag;
                    wrapper = _yield$utils13.wrapper;
                    targetElement = wrapper.find('#main').element;
                    targetElement.style.right = '50px';
                    startAt = {
                      clientX: 5,
                      clientY: 5
                    };
                    delta = {
                      x: 15,
                      y: 1
                    };
                    _context15.next = 11;
                    return drag({
                      start: startAt,
                      delta: delta
                    });

                  case 11:
                    _context15.next = 13;
                    return drag({
                      start: {
                        clientX: startAt.clientX + delta.x,
                        clientY: startAt.clientY + delta.y
                      },
                      delta: {
                        x: 50,
                        y: 0
                      }
                    });

                  case 13:
                    _context15.next = 15;
                    return wrapper.vm.$nextTick();

                  case 15:
                    expect(targetElement.style.transform).toContain("translate(65px, 1px)");

                  case 16:
                  case "end":
                    return _context15.stop();
                }
              }
            }, _callee15);
          })));

        case 4:
        case "end":
          return _context16.stop();
      }
    }
  }, _callee16);
}))); // describe('limit in rect', async () => {
//     const limits = {
//         left: 11,
//         right: window.innerWidth - 11,
//         top: 5,
//         bottom: window.innerHeight - 13
//     };
//     let utils!: ReturnType<typeof setup>
//     beforeEach(() => {
//         utils = setup({
//             useDraggableOption: {
//                 controlStyle: true,
//                 rectLimits: limits,
//             },
//             style: {
//                 ...defaultStyle,
//                 width: '180px',
//                 left: '20px'
//             }
//         });
//     });
//     it('should not change transition beyond given rect', async () => {
//         const { drag, wrapper } = await utils;
//         const targetElement = wrapper.find('#main').element as HTMLElement;
//         const rect = targetElement.getBoundingClientRect();
//         const startAt = { clientX: rect.left + 5, clientY: rect.top + 5 };
//         const delta = { x: -50, y: -90 };
//         await drag({ start: startAt, delta });
//         await wrapper.vm.$nextTick()
//         expect(targetElement.style.transform).toContain({
//             left: limits.left,
//             top: limits.top
//         });
//     });
//     it('should keep limits when dragging more than once', async () => {
//         const { drag, wrapper } = await utils;
//         const targetElement = wrapper.find('#main').element as HTMLElement;
//         targetElement.style.right = '50px';
//         targetElement.style.left = 'auto';
//         const rect = targetElement.getBoundingClientRect();
//         const startAt = { clientX: rect.left + 5, clientY: rect.top + 5 };
//         const delta = { x: 15, y: 1 };
//         drag({ start: startAt, delta });
//         drag({
//             start: {
//                 clientX: startAt.clientX + delta.x,
//                 clientY: startAt.clientY + delta.y
//             },
//             delta: { x: 50, y: 0 }
//         });
//         const { left, width } = targetElement.getBoundingClientRect();
//         expect(left).toEqual(limits.right - width);
//     });
// });

describe('reset drags', function () {
  var utils;
  beforeEach(function () {
    utils = setup({
      useDraggableOption: {
        controlStyle: true
      }
    });
  });
  it('should start dragging from the original position', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee17() {
    var _yield$utils14, wrapper, drag;

    return regeneratorRuntime.wrap(function _callee17$(_context17) {
      while (1) {
        switch (_context17.prev = _context17.next) {
          case 0:
            _context17.next = 2;
            return utils;

          case 2:
            _yield$utils14 = _context17.sent;
            wrapper = _yield$utils14.wrapper;
            drag = _yield$utils14.drag;
            _context17.next = 7;
            return drag({
              start: {
                clientX: 3,
                clientY: 5
              },
              delta: {
                x: 15,
                y: 20
              }
            });

          case 7:
            wrapper.find('#reset').trigger('click');
            _context17.next = 10;
            return wrapper.vm.$nextTick();

          case 10:
            expect(wrapper.find('#main').element.style.transform).toEqual('translate(0px, 0px)');

          case 11:
          case "end":
            return _context17.stop();
        }
      }
    }, _callee17);
  })));
  describe('after reset', function () {
    it('should start dragging from the original position', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee18() {
      var _yield$utils15, wrapper, drag;

      return regeneratorRuntime.wrap(function _callee18$(_context18) {
        while (1) {
          switch (_context18.prev = _context18.next) {
            case 0:
              _context18.next = 2;
              return utils;

            case 2:
              _yield$utils15 = _context18.sent;
              wrapper = _yield$utils15.wrapper;
              drag = _yield$utils15.drag;
              _context18.next = 7;
              return drag({
                start: {
                  clientX: 3,
                  clientY: 5
                },
                delta: {
                  x: 15,
                  y: 20
                }
              });

            case 7:
              wrapper.find('#reset').trigger('click');
              _context18.next = 10;
              return drag({
                start: {
                  clientX: 3,
                  clientY: 5
                },
                delta: {
                  x: 15,
                  y: 20
                }
              });

            case 10:
              expect(wrapper.find('#main').element.style.transform).toEqual('translate(15px, 20px)');

            case 11:
            case "end":
              return _context18.stop();
          }
        }
      }, _callee18);
    })));
  });
});
describe('useDraggable', function () {
  test('starting drag', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee19() {
    var _useDraggable, _useDraggable2, targetRef;

    return regeneratorRuntime.wrap(function _callee19$(_context19) {
      while (1) {
        switch (_context19.prev = _context19.next) {
          case 0:
            _useDraggable = (0, _index["default"])({
              controlStyle: true
            }), _useDraggable2 = _slicedToArray(_useDraggable, 1), targetRef = _useDraggable2[0];
            (0, _testUtils.mount)({
              setup: function setup() {
                targetRef;
                return {
                  targetRef: targetRef
                };
              },
              render: function render() {
                return _vue.createVNode(_vue.Fragment, null, [_vue.createVNode("h1", {
                  "ref": function ref(ele) {
                    targetRef.value = ele;
                  }
                }, [' ', _vue.createTextVNode("click"), ' '])]);
              }
            });

          case 2:
          case "end":
            return _context19.stop();
        }
      }
    }, _callee19);
  })));
});
var Consumer = (0, _vue.defineComponent)({
  props: ['useDraggableOption', 'style'],
  setup: function setup(props) {
    var _useDraggable3 = (0, _index["default"])(props.useDraggableOption),
        _useDraggable4 = _slicedToArray(_useDraggable3, 3),
        targetRef = _useDraggable4[0],
        handleRef = _useDraggable4[1],
        _useDraggable4$ = _useDraggable4[2],
        getTargetProps = _useDraggable4$.getTargetProps,
        resetState = _useDraggable4$.resetState,
        delta = _useDraggable4$.delta,
        dragging = _useDraggable4$.dragging;

    return function () {
      return _vue.createVNode("div", _vue.mergeProps(getTargetProps(), {
        "class": "container",
        "ref": targetRef,
        "id": "main",
        "style": props.style || defaultStyle
      }), [dragging && _vue.createVNode("span", null, [_vue.createTextVNode("Dragging to:")]), _vue.createVNode("output", {
        "id": "output"
      }, [delta.value.x, _vue.createTextVNode(", "), delta.value.y]), _vue.createVNode("button", {
        "id": "handle",
        "class": "handle",
        "ref": handleRef
      }, [_vue.createTextVNode("handle")]), _vue.createVNode("button", {
        "id": "reset",
        "onClick": resetState
      }, [_vue.createTextVNode("reset")])]);
    };
  }
});
var defaultStyle = {
  position: 'fixed',
  top: '11px',
  left: '11px'
};

function setup() {
  return _setup.apply(this, arguments);
}

function _setup() {
  _setup = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee24() {
    var props,
        wrapper,
        drag,
        _drag,
        beginDrag,
        _beginDrag,
        move,
        _move,
        endDrag,
        _endDrag,
        _args24 = arguments;

    return regeneratorRuntime.wrap(function _callee24$(_context24) {
      while (1) {
        switch (_context24.prev = _context24.next) {
          case 0:
            _endDrag = function _endDrag3() {
              _endDrag = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee23(end) {
                var touch,
                    target,
                    ev,
                    _ev2,
                    _args23 = arguments;

                return regeneratorRuntime.wrap(function _callee23$(_context23) {
                  while (1) {
                    switch (_context23.prev = _context23.next) {
                      case 0:
                        touch = _args23.length > 1 && _args23[1] !== undefined ? _args23[1] : false;
                        target = wrapper.find('#handle');

                        if (touch) {
                          ev = new TouchEvent('touchend', {
                            bubbles: true,
                            cancelable: true,
                            touches: [createTouch(_objectSpread({
                              target: target
                            }, end))]
                          });
                          document.dispatchEvent(ev);
                        } else {
                          _ev2 = new MouseEvent('mouseup', _objectSpread({
                            view: window,
                            bubbles: true,
                            cancelable: true
                          }, end));
                          document.dispatchEvent(_ev2);
                        }

                      case 3:
                      case "end":
                        return _context23.stop();
                    }
                  }
                }, _callee23);
              }));
              return _endDrag.apply(this, arguments);
            };

            endDrag = function _endDrag2(_x3) {
              return _endDrag.apply(this, arguments);
            };

            _move = function _move3() {
              _move = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee22(to) {
                var touch,
                    target,
                    ev,
                    _ev,
                    _args22 = arguments;

                return regeneratorRuntime.wrap(function _callee22$(_context22) {
                  while (1) {
                    switch (_context22.prev = _context22.next) {
                      case 0:
                        touch = _args22.length > 1 && _args22[1] !== undefined ? _args22[1] : false;
                        target = wrapper.find('#handle');

                        if (touch) {
                          ev = new TouchEvent('touchmove', {
                            bubbles: true,
                            cancelable: true,
                            touches: [createTouch(_objectSpread({
                              target: target
                            }, to))]
                          });
                          document.dispatchEvent(ev);
                        } else {
                          _ev = new MouseEvent('mousemove', _objectSpread({
                            view: window,
                            bubbles: true,
                            cancelable: true
                          }, to));
                          document.dispatchEvent(_ev);
                        }

                      case 3:
                      case "end":
                        return _context22.stop();
                    }
                  }
                }, _callee22);
              }));
              return _move.apply(this, arguments);
            };

            move = function _move2(_x2) {
              return _move.apply(this, arguments);
            };

            _beginDrag = function _beginDrag3() {
              _beginDrag = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee21(start) {
                var touch,
                    target,
                    ev,
                    _args21 = arguments;
                return regeneratorRuntime.wrap(function _callee21$(_context21) {
                  while (1) {
                    switch (_context21.prev = _context21.next) {
                      case 0:
                        touch = _args21.length > 1 && _args21[1] !== undefined ? _args21[1] : false;
                        target = wrapper.find('#handle');

                        if (touch) {
                          ev = new TouchEvent('touchstart', {
                            bubbles: true,
                            cancelable: true,
                            touches: [createTouch(_objectSpread({
                              target: target
                            }, start))]
                          });
                          target.element.dispatchEvent(ev);
                        } else {
                          target.trigger('mousedown', start);
                        }

                      case 3:
                      case "end":
                        return _context21.stop();
                    }
                  }
                }, _callee21);
              }));
              return _beginDrag.apply(this, arguments);
            };

            beginDrag = function _beginDrag2(_x) {
              return _beginDrag.apply(this, arguments);
            };

            _drag = function _drag3() {
              _drag = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee20() {
                var _ref21,
                    _ref21$start,
                    start,
                    _ref21$delta,
                    delta,
                    _ref21$touch,
                    touch,
                    _args20 = arguments;

                return regeneratorRuntime.wrap(function _callee20$(_context20) {
                  while (1) {
                    switch (_context20.prev = _context20.next) {
                      case 0:
                        _ref21 = _args20.length > 0 && _args20[0] !== undefined ? _args20[0] : {}, _ref21$start = _ref21.start, start = _ref21$start === void 0 ? {
                          clientX: 0,
                          clientY: 0
                        } : _ref21$start, _ref21$delta = _ref21.delta, delta = _ref21$delta === void 0 ? {
                          x: 0,
                          y: 0
                        } : _ref21$delta, _ref21$touch = _ref21.touch, touch = _ref21$touch === void 0 ? false : _ref21$touch;
                        beginDrag(start, touch);
                        _context20.next = 4;
                        return wrapper.vm.$nextTick();

                      case 4:
                        move({
                          clientX: start.clientX + delta.x,
                          clientY: start.clientY + delta.y
                        }, touch);
                        _context20.next = 7;
                        return wrapper.vm.$nextTick();

                      case 7:
                        endDrag({
                          clientX: start.clientX + delta.x,
                          clientY: start.clientY + delta.y
                        }, touch);

                      case 8:
                      case "end":
                        return _context20.stop();
                    }
                  }
                }, _callee20);
              }));
              return _drag.apply(this, arguments);
            };

            drag = function _drag2() {
              return _drag.apply(this, arguments);
            };

            props = _args24.length > 0 && _args24[0] !== undefined ? _args24[0] : {
              style: {},
              useDraggableOption: {}
            };
            wrapper = (0, _testUtils.mount)(_vue.createVNode(Consumer, {
              "useDraggableOption": props.useDraggableOption,
              "style": props.style
            }, null));
            return _context24.abrupt("return", {
              wrapper: wrapper,
              beginDrag: beginDrag,
              move: move,
              drag: drag
            });

          case 11:
          case "end":
            return _context24.stop();
        }
      }
    }, _callee24);
  }));
  return _setup.apply(this, arguments);
}

var Touch = function Touch(touchInit) {
  _classCallCheck(this, Touch);

  this.altitudeAngle = touchInit.altitudeAngle;
  this.azimuthAngle = touchInit.azimuthAngle;
  this.clientX = touchInit.clientX;
  this.clientY = touchInit.clientY;
  this.force = touchInit.force;
  this.identifier = touchInit.identifier;
  this.pageX = touchInit.pageX;
  this.pageY = touchInit.pageY;
  this.radiusX = touchInit.radiusX;
  this.radiusY = touchInit.radiusY;
  this.rotationAngle = touchInit.rotationAngle;
  this.screenX = touchInit.screenX;
  this.screenY = touchInit.screenY;
  this.target = touchInit.target;
  this.touchType = touchInit.touchType;
};

function createTouch(_ref20) {
  var target = _ref20.target,
      rest = _objectWithoutProperties(_ref20, ["target"]);

  return new Touch(_objectSpread({
    identifier: Date.now(),
    target: target
  }, rest));
}