"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _vue = _interopRequireWildcard(require("vue"));

var _antDesignVue = require("ant-design-vue");

require("ant-design-vue/dist/antd.min.css");

var _index = _interopRequireDefault(require("../index"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

// eslint-disable-next-line @typescript-eslint/no-unused-vars
var _default2 = {
  setup: function setup() {
    var modelRef = (0, _vue.reactive)({
      name1: '',
      name2: '111',
      obj: {
        //嵌套数据
        test: []
      }
    });
    var rulesRef = (0, _vue.reactive)({
      name1: [{
        required: true,
        message: 'Please input Activity name'
      }, {
        min: 3,
        max: 5,
        message: 'Length should be 3 to 5',
        trigger: 'blur'
      }],
      name2: [{
        required: true,
        message: 'Please input name2'
      }],
      'obj.test': [{
        required: true,
        message: 'Please select',
        type: 'array'
      }]
    });

    var _useForm = (0, _index["default"])(modelRef, rulesRef, {
      debounce: {
        wait: 300
      }
    }),
        resetFields = _useForm.resetFields,
        validate = _useForm.validate,
        validateInfos = _useForm.validateInfos,
        mergeValidateInfo = _useForm.mergeValidateInfo,
        clearValidate = _useForm.clearValidate;

    var handleClick = function handleClick(e) {
      e.preventDefault();
      validate().then(function () {
        console.log((0, _vue.toRaw)(modelRef));
      })["catch"](function (err) {
        console.log('error', err);
      });
    };

    var handleReset = function handleReset(e) {
      e.preventDefault();
      resetFields();
    };

    var clearValidateAll = function clearValidateAll() {
      clearValidate();
    };

    var clearValidateName1 = function clearValidateName1(name) {
      clearValidate(name);
    };

    var handleResetWithValues = function handleResetWithValues(e) {
      e.preventDefault();
      resetFields({
        name2: 'updated values'
      });
    };

    return function () {
      return _vue.createVNode(_antDesignVue.Form, null, {
        "default": function _default() {
          return [_vue.createVNode(_antDesignVue.Form.Item, _vue.mergeProps(mergeValidateInfo([validateInfos.name1, validateInfos.name2]), {
            "label": "Activity name1"
          }), {
            "default": function _default() {
              return [_vue.createVNode(_antDesignVue.Input, {
                'value': modelRef.name1,
                "onUpdate:value": function onUpdateValue($event) {
                  return modelRef.name1 = $event;
                },
                "onBlur": function onBlur() {
                  return validate('name1');
                }
              }, null)];
            }
          }), _vue.createVNode(_antDesignVue.Form.Item, _vue.mergeProps(validateInfos.name2, {
            "label": "Activity name2"
          }), {
            "default": function _default() {
              return [_vue.createVNode(_antDesignVue.Input, {
                'value': modelRef.name2,
                "onUpdate:value": function onUpdateValue($event) {
                  return modelRef.name2 = $event;
                }
              }, null)];
            }
          }), _vue.createVNode(_antDesignVue.Form.Item, _vue.mergeProps(validateInfos['obj.test'], {
            "label": "test"
          }), {
            "default": function _default() {
              return [_vue.createVNode(_antDesignVue.Select, {
                'value': modelRef.obj.test,
                "onUpdate:value": function onUpdateValue($event) {
                  return modelRef.obj.test = $event;
                },
                "mode": "multiple",
                "style": "width: 300px",
                "onBlur": console.log,
                "onFocus": console.log
              }, {
                "default": function _default() {
                  return [_vue.createVNode(_antDesignVue.Select.Option, {
                    "value": "china"
                  }, {
                    "default": function _default() {
                      return [_vue.createVNode("div", null, [_vue.createVNode("span", {
                        "role": "img",
                        "aria-label": "China"
                      }, [_vue.createTextVNode("\uD83C\uDDE8\uD83C\uDDF3")]), _vue.createTextVNode("China (\u4E2D\u56FD)")])];
                    }
                  }), _vue.createVNode(_antDesignVue.Select.Option, {
                    "value": "usa"
                  }, {
                    "default": function _default() {
                      return [_vue.createVNode("div", null, [_vue.createVNode("span", {
                        "role": "img",
                        "aria-label": "USA"
                      }, [_vue.createTextVNode("\uD83C\uDDFA\uD83C\uDDF8")]), _vue.createTextVNode("USA (\u7F8E\u56FD)")])];
                    }
                  })];
                }
              })];
            }
          }), _vue.createVNode("button", {
            "onClick": handleClick
          }, [_vue.createTextVNode("submit")]), _vue.createVNode("button", {
            "onClick": handleReset
          }, [_vue.createTextVNode("reset")]), _vue.createVNode("button", {
            "onClick": handleResetWithValues
          }, [_vue.createTextVNode("reset with new updated Values")]), _vue.createVNode("button", {
            "onClick": handleReset
          }, [_vue.createTextVNode("reset")]), _vue.createVNode("button", {
            "onClick": clearValidateAll
          }, [_vue.createTextVNode("clearValidateAll")]), _vue.createVNode("button", {
            "onClick": function onClick() {
              return clearValidateName1('name1');
            }
          }, [_vue.createTextVNode("clearValidateName1")])];
        }
      });
    };
  }
};
exports["default"] = _default2;