import { lintWarning } from "./utils";

var linter = function linter(key, value, info) {
  if (info.parentSelectors.some(function (selector) {
    var selectors = selector.split(',');
    return selectors.some(function (item) {
      return item.split('&').length > 2;
    });
  })) {
    lintWarning('Should not use more than one `&` in a selector.', info);
  }
};

export default linter;