import { HttpClient, HttpBackend } from '@angular/common/http';
import { Renderer2, RendererFactory2 } from '@angular/core';
import { Observable } from 'rxjs';
import { IconDefinition, CachedIconDefinition, TwoToneColorPalette, TwoToneColorPaletteSetter, ThemeType } from '../types';
export interface ReqIconTask {
    ob: Observable<IconDefinition | null>;
}
export declare class IconService {
    protected _rendererFactory: RendererFactory2;
    protected _handler: HttpBackend;
    protected _document: any;
    defaultTheme: ThemeType;
    protected _renderer: Renderer2;
    protected _http: HttpClient;
    /**
     * Register icons.
     */
    protected _svgDefinitions: Map<string, IconDefinition>;
    /**
     * Register rendered (with color) SVG icons.
     */
    protected _svgCachedDefinitions: Map<string, CachedIconDefinition>;
    /**
     * Default color settings.
     */
    protected _twoToneColorPalette: TwoToneColorPalette;
    /**
     * A url prefix so users can determine a static asset root.
     */
    protected _assetsSource: string;
    /**
     * To note whether a request to an icon is under processing.
     */
    protected _httpQueue: Map<string, ReqIconTask>;
    twoToneColor: TwoToneColorPaletteSetter;
    changeAssetsSource(prefix: string): void;
    /**
     * Register IconDefinition provided by Ant Design, parsing AbstractNode to svg string.
     * @param icons
     */
    addIcon(...icons: IconDefinition[]): void;
    /**
     * Register icon.
     * @param icons Icons that users want to use in their projects. User defined icons and predefined
     *   icons provided by ant-design should implement IconDefinition both.
     */
    protected _addIconLiteral(...icons: IconDefinition[]): void;
    protected _get(key: string): IconDefinition | null;
    /**
     * Get an static file and return it as a string, create a IconDefinition and cache it or return null.
     */
    protected _getFromRemote(url: string): Observable<IconDefinition | null>;
    private _createObservableRequest;
    /**
     * Icon component would call this method to get a SVG element.
     * This method returns a Observable SVG element because when user wants to get an icon dynamically, that would be async,
     * so we provided a unified interface here.
     */
    getRenderedContent(icon: IconDefinition | string, twoToneColor?: string): Observable<SVGElement | null>;
    protected _loadSVGFromCacheOrCreateNew(icon: IconDefinition, twoToneColor?: string): SVGElement;
    protected _createSVGElementFromString(str: string): SVGElement;
    protected _setSVGAttribute(svg: SVGElement): SVGElement;
    protected _colorizeSVGIcon(svg: SVGElement, twotone: boolean, pri: string, sec: string): SVGElement;
    clear(): void;
    constructor(_rendererFactory: RendererFactory2, _handler: HttpBackend, _document: any);
}
