/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,extraRequire,uselessCode} checked by tsc
 */
import { generate as generateColor } from 'ant-design-palettes';
/**
 * @param {?} message
 * @return {?}
 */
export function printErr(message) {
    console.error(`[@ant-design/icons-angular]: ${message}.`);
}
/**
 * @param {?} message
 * @return {?}
 */
export function printWarn(message) {
    console.warn(`[@ant-design/icons-angular]: ${message}.`);
}
/**
 * Use ant-design-palettes to generate a secondary color.
 * @param {?} primaryColor
 * @return {?}
 */
export function getSecondaryColor(primaryColor) {
    return generateColor(primaryColor)[0];
}
/**
 * Append a theme suffix to a type.
 * @param {?} name
 * @param {?} theme
 * @return {?}
 */
export function withSuffix(name, theme) {
    switch (theme) {
        case 'fill':
            return `${name}-fill`;
        case 'outline':
            return `${name}-o`;
        case 'twotone':
            return `${name}-twotone`;
        default:
            throw new TypeError(`Unknown theme type: ${theme}, name: ${name}`);
    }
}
/**
 * @param {?} name
 * @param {?} theme
 * @param {?} pri
 * @param {?} sec
 * @return {?}
 */
export function withSuffixAndColor(name, theme, pri, sec) {
    return `${withSuffix(name, theme)}-${pri}-${sec}`;
}
/**
 * @param {?} abbr
 * @return {?}
 */
export function mapAbbrToTheme(abbr) {
    return abbr === 'o' ? 'outline' : (/** @type {?} */ (abbr));
}
/**
 * @param {?} name
 * @return {?}
 */
export function alreadyHasAThemeSuffix(name) {
    return name.endsWith('-fill') || name.endsWith('-o') || name.endsWith('-twotone');
}
/**
 * @param {?} target
 * @return {?}
 */
export function isIconDefinition(target) {
    return (typeof target === 'object' &&
        typeof target.name === 'string' &&
        typeof target.theme === 'string' &&
        // IconDefinition.icon could be a SVG: We render SVG only once (the first time a icon is used)
        // and return a copy every time after that.
        (target.icon instanceof SVGElement || typeof target.icon === 'string'));
}
/**
 * @param {?} str
 * @return {?}
 */
export function getIconDefinitionFromAbbr(str) {
    /** @type {?} */
    const arr = str.split('-');
    /** @type {?} */
    const theme = mapAbbrToTheme(arr.splice(arr.length - 1, 1)[0]);
    /** @type {?} */
    const name = arr.join('-');
    return (/** @type {?} */ ({
        name,
        theme,
        icon: ''
    }));
}
/**
 * @param {?} svg
 * @return {?}
 */
export function cloneSVG(svg) {
    return (/** @type {?} */ (svg.cloneNode(true)));
}
/**
 * @param {?} raw
 * @return {?}
 */
export function replaceFillColor(raw) {
    return raw
        .replace(/['"]#333['"]/g, '"primaryColor"')
        .replace(/['"]#E6E6E6['"]/g, '"secondaryColor"')
        .replace(/['"]#D9D9D9['"]/g, '"secondaryColor"')
        .replace(/['"]#D8D8D8['"]/g, '"secondaryColor"');
}
//# sourceMappingURL=data:application/json;base64,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