import React from 'react';
export interface IconBaseProps {
    tabIndex?: number;
    className?: string;
    title?: string;
    onKeyUp?: React.KeyboardEventHandler<HTMLElement>;
    onClick?: React.MouseEventHandler<HTMLElement>;
    style?: React.CSSProperties;
    role?: string;
    spin?: boolean;
    rotate?: number;
}
export interface CustomIconComponentProps {
    width: string | number;
    height: string | number;
    fill: string;
    viewBox?: string;
    className?: string;
    style?: React.CSSProperties;
}
export interface IconComponentProps extends IconBaseProps {
    viewBox?: string;
    component?: React.ComponentType<CustomIconComponentProps>;
    ariaLabel?: React.AriaAttributes['aria-label'];
}
declare const Icon: React.FC<IconComponentProps>;
export default Icon;
