(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('react')) :
	typeof define === 'function' && define.amd ? define(['exports', 'react'], factory) :
	(global = global || self, factory(global.icons = {}, global.window.React));
}(this, (function (exports, React) { 'use strict';

	var React__default = 'default' in React ? React['default'] : React;

	function unwrapExports (x) {
		return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
	}

	function createCommonjsModule(fn, module) {
		return module = { exports: {} }, fn(module, module.exports), module.exports;
	}

	var AccountBookFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var AccountBookFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 184H712v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H384v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H144c-17.7 0-32 14.3-32 32v664c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V216c0-17.7-14.3-32-32-32zM648.3 426.8l-87.7 161.1h45.7c5.5 0 10 4.5 10 10v21.3c0 5.5-4.5 10-10 10h-63.4v29.7h63.4c5.5 0 10 4.5 10 10v21.3c0 5.5-4.5 10-10 10h-63.4V752c0 5.5-4.5 10-10 10h-41.3c-5.5 0-10-4.5-10-10v-51.8h-63.1c-5.5 0-10-4.5-10-10v-21.3c0-5.5 4.5-10 10-10h63.1v-29.7h-63.1c-5.5 0-10-4.5-10-10v-21.3c0-5.5 4.5-10 10-10h45.2l-88-161.1c-2.6-4.8-.9-10.9 4-13.6 1.5-.8 3.1-1.2 4.8-1.2h46c3.8 0 7.2 2.1 8.9 5.5l72.9 144.3 73.2-144.3a10 10 0 018.9-5.5h45c5.5 0 10 4.5 10 10 .1 1.7-.3 3.3-1.1 4.8z" } }] }, "name": "account-book", "theme": "filled" };
	exports.default = AccountBookFilled;
	});

	var AccountBookFilledSvg = unwrapExports(AccountBookFilled_1);

	function _arrayWithHoles(arr) {
	  if (Array.isArray(arr)) return arr;
	}

	var arrayWithHoles = _arrayWithHoles;

	function _iterableToArrayLimit(arr, i) {
	  if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return;
	  var _arr = [];
	  var _n = true;
	  var _d = false;
	  var _e = undefined;

	  try {
	    for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
	      _arr.push(_s.value);

	      if (i && _arr.length === i) break;
	    }
	  } catch (err) {
	    _d = true;
	    _e = err;
	  } finally {
	    try {
	      if (!_n && _i["return"] != null) _i["return"]();
	    } finally {
	      if (_d) throw _e;
	    }
	  }

	  return _arr;
	}

	var iterableToArrayLimit = _iterableToArrayLimit;

	function _arrayLikeToArray(arr, len) {
	  if (len == null || len > arr.length) len = arr.length;

	  for (var i = 0, arr2 = new Array(len); i < len; i++) {
	    arr2[i] = arr[i];
	  }

	  return arr2;
	}

	var arrayLikeToArray = _arrayLikeToArray;

	function _unsupportedIterableToArray(o, minLen) {
	  if (!o) return;
	  if (typeof o === "string") return arrayLikeToArray(o, minLen);
	  var n = Object.prototype.toString.call(o).slice(8, -1);
	  if (n === "Object" && o.constructor) n = o.constructor.name;
	  if (n === "Map" || n === "Set") return Array.from(o);
	  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return arrayLikeToArray(o, minLen);
	}

	var unsupportedIterableToArray = _unsupportedIterableToArray;

	function _nonIterableRest() {
	  throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
	}

	var nonIterableRest = _nonIterableRest;

	function _slicedToArray(arr, i) {
	  return arrayWithHoles(arr) || iterableToArrayLimit(arr, i) || unsupportedIterableToArray(arr, i) || nonIterableRest();
	}

	var slicedToArray = _slicedToArray;

	function _defineProperty(obj, key, value) {
	  if (key in obj) {
	    Object.defineProperty(obj, key, {
	      value: value,
	      enumerable: true,
	      configurable: true,
	      writable: true
	    });
	  } else {
	    obj[key] = value;
	  }

	  return obj;
	}

	var defineProperty = _defineProperty;

	function _objectWithoutPropertiesLoose(source, excluded) {
	  if (source == null) return {};
	  var target = {};
	  var sourceKeys = Object.keys(source);
	  var key, i;

	  for (i = 0; i < sourceKeys.length; i++) {
	    key = sourceKeys[i];
	    if (excluded.indexOf(key) >= 0) continue;
	    target[key] = source[key];
	  }

	  return target;
	}

	var objectWithoutPropertiesLoose = _objectWithoutPropertiesLoose;

	function _objectWithoutProperties(source, excluded) {
	  if (source == null) return {};
	  var target = objectWithoutPropertiesLoose(source, excluded);
	  var key, i;

	  if (Object.getOwnPropertySymbols) {
	    var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

	    for (i = 0; i < sourceSymbolKeys.length; i++) {
	      key = sourceSymbolKeys[i];
	      if (excluded.indexOf(key) >= 0) continue;
	      if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
	      target[key] = source[key];
	    }
	  }

	  return target;
	}

	var objectWithoutProperties = _objectWithoutProperties;

	var _classnames_2_2_6_classnames = createCommonjsModule(function (module) {
	/*!
	  Copyright (c) 2017 Jed Watson.
	  Licensed under the MIT License (MIT), see
	  http://jedwatson.github.io/classnames
	*/
	/* global define */

	(function () {

		var hasOwn = {}.hasOwnProperty;

		function classNames () {
			var classes = [];

			for (var i = 0; i < arguments.length; i++) {
				var arg = arguments[i];
				if (!arg) continue;

				var argType = typeof arg;

				if (argType === 'string' || argType === 'number') {
					classes.push(arg);
				} else if (Array.isArray(arg) && arg.length) {
					var inner = classNames.apply(null, arg);
					if (inner) {
						classes.push(inner);
					}
				} else if (argType === 'object') {
					for (var key in arg) {
						if (hasOwn.call(arg, key) && arg[key]) {
							classes.push(key);
						}
					}
				}
			}

			return classes.join(' ');
		}

		if ( module.exports) {
			classNames.default = classNames;
			module.exports = classNames;
		} else {
			window.classNames = classNames;
		}
	}());
	});

	function ownKeys(object, enumerableOnly) {
	  var keys = Object.keys(object);

	  if (Object.getOwnPropertySymbols) {
	    var symbols = Object.getOwnPropertySymbols(object);
	    if (enumerableOnly) symbols = symbols.filter(function (sym) {
	      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
	    });
	    keys.push.apply(keys, symbols);
	  }

	  return keys;
	}

	function _objectSpread2(target) {
	  for (var i = 1; i < arguments.length; i++) {
	    var source = arguments[i] != null ? arguments[i] : {};

	    if (i % 2) {
	      ownKeys(Object(source), true).forEach(function (key) {
	        defineProperty(target, key, source[key]);
	      });
	    } else if (Object.getOwnPropertyDescriptors) {
	      Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
	    } else {
	      ownKeys(Object(source)).forEach(function (key) {
	        Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
	      });
	    }
	  }

	  return target;
	}

	var objectSpread2 = _objectSpread2;

	var _typeof_1 = createCommonjsModule(function (module) {
	function _typeof(obj) {
	  "@babel/helpers - typeof";

	  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
	    module.exports = _typeof = function _typeof(obj) {
	      return typeof obj;
	    };
	  } else {
	    module.exports = _typeof = function _typeof(obj) {
	      return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
	    };
	  }

	  return _typeof(obj);
	}

	module.exports = _typeof;
	});

	/**
	 * Take input from [0, n] and return it as [0, 1]
	 * @hidden
	 */
	function bound01(n, max) {
	    if (isOnePointZero(n)) {
	        n = '100%';
	    }
	    var isPercent = isPercentage(n);
	    n = max === 360 ? n : Math.min(max, Math.max(0, parseFloat(n)));
	    // Automatically convert percentage into number
	    if (isPercent) {
	        n = parseInt(String(n * max), 10) / 100;
	    }
	    // Handle floating point rounding errors
	    if (Math.abs(n - max) < 0.000001) {
	        return 1;
	    }
	    // Convert into [0, 1] range if it isn't already
	    if (max === 360) {
	        // If n is a hue given in degrees,
	        // wrap around out-of-range values into [0, 360] range
	        // then convert into [0, 1].
	        n = (n < 0 ? (n % max) + max : n % max) / parseFloat(String(max));
	    }
	    else {
	        // If n not a hue given in degrees
	        // Convert into [0, 1] range if it isn't already.
	        n = (n % max) / parseFloat(String(max));
	    }
	    return n;
	}
	/**
	 * Force a number between 0 and 1
	 * @hidden
	 */
	function clamp01(val) {
	    return Math.min(1, Math.max(0, val));
	}
	/**
	 * Need to handle 1.0 as 100%, since once it is a number, there is no difference between it and 1
	 * <http://stackoverflow.com/questions/7422072/javascript-how-to-detect-number-as-a-decimal-including-1-0>
	 * @hidden
	 */
	function isOnePointZero(n) {
	    return typeof n === 'string' && n.includes('.') && parseFloat(n) === 1;
	}
	/**
	 * Check to see if string passed in is a percentage
	 * @hidden
	 */
	function isPercentage(n) {
	    return typeof n === 'string' && n.includes('%');
	}
	/**
	 * Return a valid alpha value [0,1] with all invalid values being set to 1
	 * @hidden
	 */
	function boundAlpha(a) {
	    a = parseFloat(a);
	    if (isNaN(a) || a < 0 || a > 1) {
	        a = 1;
	    }
	    return a;
	}
	/**
	 * Replace a decimal with it's percentage value
	 * @hidden
	 */
	function convertToPercentage(n) {
	    if (n <= 1) {
	        return Number(n) * 100 + "%";
	    }
	    return n;
	}
	/**
	 * Force a hex value to have 2 characters
	 * @hidden
	 */
	function pad2(c) {
	    return c.length === 1 ? '0' + c : String(c);
	}

	// `rgbToHsl`, `rgbToHsv`, `hslToRgb`, `hsvToRgb` modified from:
	// <http://mjijackson.com/2008/02/rgb-to-hsl-and-rgb-to-hsv-color-model-conversion-algorithms-in-javascript>
	/**
	 * Handle bounds / percentage checking to conform to CSS color spec
	 * <http://www.w3.org/TR/css3-color/>
	 * *Assumes:* r, g, b in [0, 255] or [0, 1]
	 * *Returns:* { r, g, b } in [0, 255]
	 */
	function rgbToRgb(r, g, b) {
	    return {
	        r: bound01(r, 255) * 255,
	        g: bound01(g, 255) * 255,
	        b: bound01(b, 255) * 255,
	    };
	}
	/**
	 * Converts an RGB color value to HSL.
	 * *Assumes:* r, g, and b are contained in [0, 255] or [0, 1]
	 * *Returns:* { h, s, l } in [0,1]
	 */
	function rgbToHsl(r, g, b) {
	    r = bound01(r, 255);
	    g = bound01(g, 255);
	    b = bound01(b, 255);
	    var max = Math.max(r, g, b);
	    var min = Math.min(r, g, b);
	    var h = 0;
	    var s = 0;
	    var l = (max + min) / 2;
	    if (max === min) {
	        s = 0;
	        h = 0; // achromatic
	    }
	    else {
	        var d = max - min;
	        s = l > 0.5 ? d / (2 - max - min) : d / (max + min);
	        switch (max) {
	            case r:
	                h = (g - b) / d + (g < b ? 6 : 0);
	                break;
	            case g:
	                h = (b - r) / d + 2;
	                break;
	            case b:
	                h = (r - g) / d + 4;
	                break;
	        }
	        h /= 6;
	    }
	    return { h: h, s: s, l: l };
	}
	function hue2rgb(p, q, t) {
	    if (t < 0) {
	        t += 1;
	    }
	    if (t > 1) {
	        t -= 1;
	    }
	    if (t < 1 / 6) {
	        return p + (q - p) * (6 * t);
	    }
	    if (t < 1 / 2) {
	        return q;
	    }
	    if (t < 2 / 3) {
	        return p + (q - p) * (2 / 3 - t) * 6;
	    }
	    return p;
	}
	/**
	 * Converts an HSL color value to RGB.
	 *
	 * *Assumes:* h is contained in [0, 1] or [0, 360] and s and l are contained [0, 1] or [0, 100]
	 * *Returns:* { r, g, b } in the set [0, 255]
	 */
	function hslToRgb(h, s, l) {
	    var r;
	    var g;
	    var b;
	    h = bound01(h, 360);
	    s = bound01(s, 100);
	    l = bound01(l, 100);
	    if (s === 0) {
	        // achromatic
	        g = l;
	        b = l;
	        r = l;
	    }
	    else {
	        var q = l < 0.5 ? l * (1 + s) : l + s - l * s;
	        var p = 2 * l - q;
	        r = hue2rgb(p, q, h + 1 / 3);
	        g = hue2rgb(p, q, h);
	        b = hue2rgb(p, q, h - 1 / 3);
	    }
	    return { r: r * 255, g: g * 255, b: b * 255 };
	}
	/**
	 * Converts an RGB color value to HSV
	 *
	 * *Assumes:* r, g, and b are contained in the set [0, 255] or [0, 1]
	 * *Returns:* { h, s, v } in [0,1]
	 */
	function rgbToHsv(r, g, b) {
	    r = bound01(r, 255);
	    g = bound01(g, 255);
	    b = bound01(b, 255);
	    var max = Math.max(r, g, b);
	    var min = Math.min(r, g, b);
	    var h = 0;
	    var v = max;
	    var d = max - min;
	    var s = max === 0 ? 0 : d / max;
	    if (max === min) {
	        h = 0; // achromatic
	    }
	    else {
	        switch (max) {
	            case r:
	                h = (g - b) / d + (g < b ? 6 : 0);
	                break;
	            case g:
	                h = (b - r) / d + 2;
	                break;
	            case b:
	                h = (r - g) / d + 4;
	                break;
	        }
	        h /= 6;
	    }
	    return { h: h, s: s, v: v };
	}
	/**
	 * Converts an HSV color value to RGB.
	 *
	 * *Assumes:* h is contained in [0, 1] or [0, 360] and s and v are contained in [0, 1] or [0, 100]
	 * *Returns:* { r, g, b } in the set [0, 255]
	 */
	function hsvToRgb(h, s, v) {
	    h = bound01(h, 360) * 6;
	    s = bound01(s, 100);
	    v = bound01(v, 100);
	    var i = Math.floor(h);
	    var f = h - i;
	    var p = v * (1 - s);
	    var q = v * (1 - f * s);
	    var t = v * (1 - (1 - f) * s);
	    var mod = i % 6;
	    var r = [v, q, p, p, t, v][mod];
	    var g = [t, v, v, q, p, p][mod];
	    var b = [p, p, t, v, v, q][mod];
	    return { r: r * 255, g: g * 255, b: b * 255 };
	}
	/**
	 * Converts an RGB color to hex
	 *
	 * Assumes r, g, and b are contained in the set [0, 255]
	 * Returns a 3 or 6 character hex
	 */
	function rgbToHex(r, g, b, allow3Char) {
	    var hex = [
	        pad2(Math.round(r).toString(16)),
	        pad2(Math.round(g).toString(16)),
	        pad2(Math.round(b).toString(16)),
	    ];
	    // Return a 3 character hex if possible
	    if (allow3Char &&
	        hex[0].startsWith(hex[0].charAt(1)) &&
	        hex[1].startsWith(hex[1].charAt(1)) &&
	        hex[2].startsWith(hex[2].charAt(1))) {
	        return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0);
	    }
	    return hex.join('');
	}
	/**
	 * Converts an RGBA color plus alpha transparency to hex
	 *
	 * Assumes r, g, b are contained in the set [0, 255] and
	 * a in [0, 1]. Returns a 4 or 8 character rgba hex
	 */
	// eslint-disable-next-line max-params
	function rgbaToHex(r, g, b, a, allow4Char) {
	    var hex = [
	        pad2(Math.round(r).toString(16)),
	        pad2(Math.round(g).toString(16)),
	        pad2(Math.round(b).toString(16)),
	        pad2(convertDecimalToHex(a)),
	    ];
	    // Return a 4 character hex if possible
	    if (allow4Char &&
	        hex[0].startsWith(hex[0].charAt(1)) &&
	        hex[1].startsWith(hex[1].charAt(1)) &&
	        hex[2].startsWith(hex[2].charAt(1)) &&
	        hex[3].startsWith(hex[3].charAt(1))) {
	        return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0) + hex[3].charAt(0);
	    }
	    return hex.join('');
	}
	/** Converts a decimal to a hex value */
	function convertDecimalToHex(d) {
	    return Math.round(parseFloat(d) * 255).toString(16);
	}
	/** Converts a hex value to a decimal */
	function convertHexToDecimal(h) {
	    return parseIntFromHex(h) / 255;
	}
	/** Parse a base-16 hex value into a base-10 integer */
	function parseIntFromHex(val) {
	    return parseInt(val, 16);
	}
	function numberInputToObject(color) {
	    return {
	        r: color >> 16,
	        g: (color & 0xff00) >> 8,
	        b: color & 0xff,
	    };
	}

	// https://github.com/bahamas10/css-color-names/blob/master/css-color-names.json
	/**
	 * @hidden
	 */
	var names = {
	    aliceblue: '#f0f8ff',
	    antiquewhite: '#faebd7',
	    aqua: '#00ffff',
	    aquamarine: '#7fffd4',
	    azure: '#f0ffff',
	    beige: '#f5f5dc',
	    bisque: '#ffe4c4',
	    black: '#000000',
	    blanchedalmond: '#ffebcd',
	    blue: '#0000ff',
	    blueviolet: '#8a2be2',
	    brown: '#a52a2a',
	    burlywood: '#deb887',
	    cadetblue: '#5f9ea0',
	    chartreuse: '#7fff00',
	    chocolate: '#d2691e',
	    coral: '#ff7f50',
	    cornflowerblue: '#6495ed',
	    cornsilk: '#fff8dc',
	    crimson: '#dc143c',
	    cyan: '#00ffff',
	    darkblue: '#00008b',
	    darkcyan: '#008b8b',
	    darkgoldenrod: '#b8860b',
	    darkgray: '#a9a9a9',
	    darkgreen: '#006400',
	    darkgrey: '#a9a9a9',
	    darkkhaki: '#bdb76b',
	    darkmagenta: '#8b008b',
	    darkolivegreen: '#556b2f',
	    darkorange: '#ff8c00',
	    darkorchid: '#9932cc',
	    darkred: '#8b0000',
	    darksalmon: '#e9967a',
	    darkseagreen: '#8fbc8f',
	    darkslateblue: '#483d8b',
	    darkslategray: '#2f4f4f',
	    darkslategrey: '#2f4f4f',
	    darkturquoise: '#00ced1',
	    darkviolet: '#9400d3',
	    deeppink: '#ff1493',
	    deepskyblue: '#00bfff',
	    dimgray: '#696969',
	    dimgrey: '#696969',
	    dodgerblue: '#1e90ff',
	    firebrick: '#b22222',
	    floralwhite: '#fffaf0',
	    forestgreen: '#228b22',
	    fuchsia: '#ff00ff',
	    gainsboro: '#dcdcdc',
	    ghostwhite: '#f8f8ff',
	    goldenrod: '#daa520',
	    gold: '#ffd700',
	    gray: '#808080',
	    green: '#008000',
	    greenyellow: '#adff2f',
	    grey: '#808080',
	    honeydew: '#f0fff0',
	    hotpink: '#ff69b4',
	    indianred: '#cd5c5c',
	    indigo: '#4b0082',
	    ivory: '#fffff0',
	    khaki: '#f0e68c',
	    lavenderblush: '#fff0f5',
	    lavender: '#e6e6fa',
	    lawngreen: '#7cfc00',
	    lemonchiffon: '#fffacd',
	    lightblue: '#add8e6',
	    lightcoral: '#f08080',
	    lightcyan: '#e0ffff',
	    lightgoldenrodyellow: '#fafad2',
	    lightgray: '#d3d3d3',
	    lightgreen: '#90ee90',
	    lightgrey: '#d3d3d3',
	    lightpink: '#ffb6c1',
	    lightsalmon: '#ffa07a',
	    lightseagreen: '#20b2aa',
	    lightskyblue: '#87cefa',
	    lightslategray: '#778899',
	    lightslategrey: '#778899',
	    lightsteelblue: '#b0c4de',
	    lightyellow: '#ffffe0',
	    lime: '#00ff00',
	    limegreen: '#32cd32',
	    linen: '#faf0e6',
	    magenta: '#ff00ff',
	    maroon: '#800000',
	    mediumaquamarine: '#66cdaa',
	    mediumblue: '#0000cd',
	    mediumorchid: '#ba55d3',
	    mediumpurple: '#9370db',
	    mediumseagreen: '#3cb371',
	    mediumslateblue: '#7b68ee',
	    mediumspringgreen: '#00fa9a',
	    mediumturquoise: '#48d1cc',
	    mediumvioletred: '#c71585',
	    midnightblue: '#191970',
	    mintcream: '#f5fffa',
	    mistyrose: '#ffe4e1',
	    moccasin: '#ffe4b5',
	    navajowhite: '#ffdead',
	    navy: '#000080',
	    oldlace: '#fdf5e6',
	    olive: '#808000',
	    olivedrab: '#6b8e23',
	    orange: '#ffa500',
	    orangered: '#ff4500',
	    orchid: '#da70d6',
	    palegoldenrod: '#eee8aa',
	    palegreen: '#98fb98',
	    paleturquoise: '#afeeee',
	    palevioletred: '#db7093',
	    papayawhip: '#ffefd5',
	    peachpuff: '#ffdab9',
	    peru: '#cd853f',
	    pink: '#ffc0cb',
	    plum: '#dda0dd',
	    powderblue: '#b0e0e6',
	    purple: '#800080',
	    rebeccapurple: '#663399',
	    red: '#ff0000',
	    rosybrown: '#bc8f8f',
	    royalblue: '#4169e1',
	    saddlebrown: '#8b4513',
	    salmon: '#fa8072',
	    sandybrown: '#f4a460',
	    seagreen: '#2e8b57',
	    seashell: '#fff5ee',
	    sienna: '#a0522d',
	    silver: '#c0c0c0',
	    skyblue: '#87ceeb',
	    slateblue: '#6a5acd',
	    slategray: '#708090',
	    slategrey: '#708090',
	    snow: '#fffafa',
	    springgreen: '#00ff7f',
	    steelblue: '#4682b4',
	    tan: '#d2b48c',
	    teal: '#008080',
	    thistle: '#d8bfd8',
	    tomato: '#ff6347',
	    turquoise: '#40e0d0',
	    violet: '#ee82ee',
	    wheat: '#f5deb3',
	    white: '#ffffff',
	    whitesmoke: '#f5f5f5',
	    yellow: '#ffff00',
	    yellowgreen: '#9acd32',
	};

	/**
	 * Given a string or object, convert that input to RGB
	 *
	 * Possible string inputs:
	 * ```
	 * "red"
	 * "#f00" or "f00"
	 * "#ff0000" or "ff0000"
	 * "#ff000000" or "ff000000"
	 * "rgb 255 0 0" or "rgb (255, 0, 0)"
	 * "rgb 1.0 0 0" or "rgb (1, 0, 0)"
	 * "rgba (255, 0, 0, 1)" or "rgba 255, 0, 0, 1"
	 * "rgba (1.0, 0, 0, 1)" or "rgba 1.0, 0, 0, 1"
	 * "hsl(0, 100%, 50%)" or "hsl 0 100% 50%"
	 * "hsla(0, 100%, 50%, 1)" or "hsla 0 100% 50%, 1"
	 * "hsv(0, 100%, 100%)" or "hsv 0 100% 100%"
	 * ```
	 */
	function inputToRGB(color) {
	    var rgb = { r: 0, g: 0, b: 0 };
	    var a = 1;
	    var s = null;
	    var v = null;
	    var l = null;
	    var ok = false;
	    var format = false;
	    if (typeof color === 'string') {
	        color = stringInputToObject(color);
	    }
	    if (typeof color === 'object') {
	        if (isValidCSSUnit(color.r) && isValidCSSUnit(color.g) && isValidCSSUnit(color.b)) {
	            rgb = rgbToRgb(color.r, color.g, color.b);
	            ok = true;
	            format = String(color.r).substr(-1) === '%' ? 'prgb' : 'rgb';
	        }
	        else if (isValidCSSUnit(color.h) && isValidCSSUnit(color.s) && isValidCSSUnit(color.v)) {
	            s = convertToPercentage(color.s);
	            v = convertToPercentage(color.v);
	            rgb = hsvToRgb(color.h, s, v);
	            ok = true;
	            format = 'hsv';
	        }
	        else if (isValidCSSUnit(color.h) && isValidCSSUnit(color.s) && isValidCSSUnit(color.l)) {
	            s = convertToPercentage(color.s);
	            l = convertToPercentage(color.l);
	            rgb = hslToRgb(color.h, s, l);
	            ok = true;
	            format = 'hsl';
	        }
	        if (Object.prototype.hasOwnProperty.call(color, 'a')) {
	            a = color.a;
	        }
	    }
	    a = boundAlpha(a);
	    return {
	        ok: ok,
	        format: color.format || format,
	        r: Math.min(255, Math.max(rgb.r, 0)),
	        g: Math.min(255, Math.max(rgb.g, 0)),
	        b: Math.min(255, Math.max(rgb.b, 0)),
	        a: a,
	    };
	}
	// <http://www.w3.org/TR/css3-values/#integers>
	var CSS_INTEGER = '[-\\+]?\\d+%?';
	// <http://www.w3.org/TR/css3-values/#number-value>
	var CSS_NUMBER = '[-\\+]?\\d*\\.\\d+%?';
	// Allow positive/negative integer/number.  Don't capture the either/or, just the entire outcome.
	var CSS_UNIT = "(?:" + CSS_NUMBER + ")|(?:" + CSS_INTEGER + ")";
	// Actual matching.
	// Parentheses and commas are optional, but not required.
	// Whitespace can take the place of commas or opening paren
	var PERMISSIVE_MATCH3 = "[\\s|\\(]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")\\s*\\)?";
	var PERMISSIVE_MATCH4 = "[\\s|\\(]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")\\s*\\)?";
	var matchers = {
	    CSS_UNIT: new RegExp(CSS_UNIT),
	    rgb: new RegExp('rgb' + PERMISSIVE_MATCH3),
	    rgba: new RegExp('rgba' + PERMISSIVE_MATCH4),
	    hsl: new RegExp('hsl' + PERMISSIVE_MATCH3),
	    hsla: new RegExp('hsla' + PERMISSIVE_MATCH4),
	    hsv: new RegExp('hsv' + PERMISSIVE_MATCH3),
	    hsva: new RegExp('hsva' + PERMISSIVE_MATCH4),
	    hex3: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,
	    hex6: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,
	    hex4: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,
	    hex8: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,
	};
	/**
	 * Permissive string parsing.  Take in a number of formats, and output an object
	 * based on detected format.  Returns `{ r, g, b }` or `{ h, s, l }` or `{ h, s, v}`
	 */
	function stringInputToObject(color) {
	    color = color.trim().toLowerCase();
	    if (color.length === 0) {
	        return false;
	    }
	    var named = false;
	    if (names[color]) {
	        color = names[color];
	        named = true;
	    }
	    else if (color === 'transparent') {
	        return { r: 0, g: 0, b: 0, a: 0, format: 'name' };
	    }
	    // Try to match string input using regular expressions.
	    // Keep most of the number bounding out of this function - don't worry about [0,1] or [0,100] or [0,360]
	    // Just return an object and let the conversion functions handle that.
	    // This way the result will be the same whether the tinycolor is initialized with string or object.
	    var match = matchers.rgb.exec(color);
	    if (match) {
	        return { r: match[1], g: match[2], b: match[3] };
	    }
	    match = matchers.rgba.exec(color);
	    if (match) {
	        return { r: match[1], g: match[2], b: match[3], a: match[4] };
	    }
	    match = matchers.hsl.exec(color);
	    if (match) {
	        return { h: match[1], s: match[2], l: match[3] };
	    }
	    match = matchers.hsla.exec(color);
	    if (match) {
	        return { h: match[1], s: match[2], l: match[3], a: match[4] };
	    }
	    match = matchers.hsv.exec(color);
	    if (match) {
	        return { h: match[1], s: match[2], v: match[3] };
	    }
	    match = matchers.hsva.exec(color);
	    if (match) {
	        return { h: match[1], s: match[2], v: match[3], a: match[4] };
	    }
	    match = matchers.hex8.exec(color);
	    if (match) {
	        return {
	            r: parseIntFromHex(match[1]),
	            g: parseIntFromHex(match[2]),
	            b: parseIntFromHex(match[3]),
	            a: convertHexToDecimal(match[4]),
	            format: named ? 'name' : 'hex8',
	        };
	    }
	    match = matchers.hex6.exec(color);
	    if (match) {
	        return {
	            r: parseIntFromHex(match[1]),
	            g: parseIntFromHex(match[2]),
	            b: parseIntFromHex(match[3]),
	            format: named ? 'name' : 'hex',
	        };
	    }
	    match = matchers.hex4.exec(color);
	    if (match) {
	        return {
	            r: parseIntFromHex(match[1] + match[1]),
	            g: parseIntFromHex(match[2] + match[2]),
	            b: parseIntFromHex(match[3] + match[3]),
	            a: convertHexToDecimal(match[4] + match[4]),
	            format: named ? 'name' : 'hex8',
	        };
	    }
	    match = matchers.hex3.exec(color);
	    if (match) {
	        return {
	            r: parseIntFromHex(match[1] + match[1]),
	            g: parseIntFromHex(match[2] + match[2]),
	            b: parseIntFromHex(match[3] + match[3]),
	            format: named ? 'name' : 'hex',
	        };
	    }
	    return false;
	}
	/**
	 * Check to see if it looks like a CSS unit
	 * (see `matchers` above for definition).
	 */
	function isValidCSSUnit(color) {
	    return Boolean(matchers.CSS_UNIT.exec(String(color)));
	}

	var TinyColor = /** @class */ (function () {
	    function TinyColor(color, opts) {
	        if (color === void 0) { color = ''; }
	        if (opts === void 0) { opts = {}; }
	        var _a;
	        // If input is already a tinycolor, return itself
	        if (color instanceof TinyColor) {
	            // eslint-disable-next-line no-constructor-return
	            return color;
	        }
	        if (typeof color === 'number') {
	            color = numberInputToObject(color);
	        }
	        this.originalInput = color;
	        var rgb = inputToRGB(color);
	        this.originalInput = color;
	        this.r = rgb.r;
	        this.g = rgb.g;
	        this.b = rgb.b;
	        this.a = rgb.a;
	        this.roundA = Math.round(100 * this.a) / 100;
	        this.format = (_a = opts.format) !== null && _a !== void 0 ? _a : rgb.format;
	        this.gradientType = opts.gradientType;
	        // Don't let the range of [0,255] come back in [0,1].
	        // Potentially lose a little bit of precision here, but will fix issues where
	        // .5 gets interpreted as half of the total, instead of half of 1
	        // If it was supposed to be 128, this was already taken care of by `inputToRgb`
	        if (this.r < 1) {
	            this.r = Math.round(this.r);
	        }
	        if (this.g < 1) {
	            this.g = Math.round(this.g);
	        }
	        if (this.b < 1) {
	            this.b = Math.round(this.b);
	        }
	        this.isValid = rgb.ok;
	    }
	    TinyColor.prototype.isDark = function () {
	        return this.getBrightness() < 128;
	    };
	    TinyColor.prototype.isLight = function () {
	        return !this.isDark();
	    };
	    /**
	     * Returns the perceived brightness of the color, from 0-255.
	     */
	    TinyColor.prototype.getBrightness = function () {
	        // http://www.w3.org/TR/AERT#color-contrast
	        var rgb = this.toRgb();
	        return (rgb.r * 299 + rgb.g * 587 + rgb.b * 114) / 1000;
	    };
	    /**
	     * Returns the perceived luminance of a color, from 0-1.
	     */
	    TinyColor.prototype.getLuminance = function () {
	        // http://www.w3.org/TR/2008/REC-WCAG20-20081211/#relativeluminancedef
	        var rgb = this.toRgb();
	        var R;
	        var G;
	        var B;
	        var RsRGB = rgb.r / 255;
	        var GsRGB = rgb.g / 255;
	        var BsRGB = rgb.b / 255;
	        if (RsRGB <= 0.03928) {
	            R = RsRGB / 12.92;
	        }
	        else {
	            R = Math.pow(((RsRGB + 0.055) / 1.055), 2.4);
	        }
	        if (GsRGB <= 0.03928) {
	            G = GsRGB / 12.92;
	        }
	        else {
	            G = Math.pow(((GsRGB + 0.055) / 1.055), 2.4);
	        }
	        if (BsRGB <= 0.03928) {
	            B = BsRGB / 12.92;
	        }
	        else {
	            B = Math.pow(((BsRGB + 0.055) / 1.055), 2.4);
	        }
	        return 0.2126 * R + 0.7152 * G + 0.0722 * B;
	    };
	    /**
	     * Returns the alpha value of a color, from 0-1.
	     */
	    TinyColor.prototype.getAlpha = function () {
	        return this.a;
	    };
	    /**
	     * Sets the alpha value on the current color.
	     *
	     * @param alpha - The new alpha value. The accepted range is 0-1.
	     */
	    TinyColor.prototype.setAlpha = function (alpha) {
	        this.a = boundAlpha(alpha);
	        this.roundA = Math.round(100 * this.a) / 100;
	        return this;
	    };
	    /**
	     * Returns the object as a HSVA object.
	     */
	    TinyColor.prototype.toHsv = function () {
	        var hsv = rgbToHsv(this.r, this.g, this.b);
	        return { h: hsv.h * 360, s: hsv.s, v: hsv.v, a: this.a };
	    };
	    /**
	     * Returns the hsva values interpolated into a string with the following format:
	     * "hsva(xxx, xxx, xxx, xx)".
	     */
	    TinyColor.prototype.toHsvString = function () {
	        var hsv = rgbToHsv(this.r, this.g, this.b);
	        var h = Math.round(hsv.h * 360);
	        var s = Math.round(hsv.s * 100);
	        var v = Math.round(hsv.v * 100);
	        return this.a === 1 ? "hsv(" + h + ", " + s + "%, " + v + "%)" : "hsva(" + h + ", " + s + "%, " + v + "%, " + this.roundA + ")";
	    };
	    /**
	     * Returns the object as a HSLA object.
	     */
	    TinyColor.prototype.toHsl = function () {
	        var hsl = rgbToHsl(this.r, this.g, this.b);
	        return { h: hsl.h * 360, s: hsl.s, l: hsl.l, a: this.a };
	    };
	    /**
	     * Returns the hsla values interpolated into a string with the following format:
	     * "hsla(xxx, xxx, xxx, xx)".
	     */
	    TinyColor.prototype.toHslString = function () {
	        var hsl = rgbToHsl(this.r, this.g, this.b);
	        var h = Math.round(hsl.h * 360);
	        var s = Math.round(hsl.s * 100);
	        var l = Math.round(hsl.l * 100);
	        return this.a === 1 ? "hsl(" + h + ", " + s + "%, " + l + "%)" : "hsla(" + h + ", " + s + "%, " + l + "%, " + this.roundA + ")";
	    };
	    /**
	     * Returns the hex value of the color.
	     * @param allow3Char will shorten hex value to 3 char if possible
	     */
	    TinyColor.prototype.toHex = function (allow3Char) {
	        if (allow3Char === void 0) { allow3Char = false; }
	        return rgbToHex(this.r, this.g, this.b, allow3Char);
	    };
	    /**
	     * Returns the hex value of the color -with a # appened.
	     * @param allow3Char will shorten hex value to 3 char if possible
	     */
	    TinyColor.prototype.toHexString = function (allow3Char) {
	        if (allow3Char === void 0) { allow3Char = false; }
	        return '#' + this.toHex(allow3Char);
	    };
	    /**
	     * Returns the hex 8 value of the color.
	     * @param allow4Char will shorten hex value to 4 char if possible
	     */
	    TinyColor.prototype.toHex8 = function (allow4Char) {
	        if (allow4Char === void 0) { allow4Char = false; }
	        return rgbaToHex(this.r, this.g, this.b, this.a, allow4Char);
	    };
	    /**
	     * Returns the hex 8 value of the color -with a # appened.
	     * @param allow4Char will shorten hex value to 4 char if possible
	     */
	    TinyColor.prototype.toHex8String = function (allow4Char) {
	        if (allow4Char === void 0) { allow4Char = false; }
	        return '#' + this.toHex8(allow4Char);
	    };
	    /**
	     * Returns the object as a RGBA object.
	     */
	    TinyColor.prototype.toRgb = function () {
	        return {
	            r: Math.round(this.r),
	            g: Math.round(this.g),
	            b: Math.round(this.b),
	            a: this.a,
	        };
	    };
	    /**
	     * Returns the RGBA values interpolated into a string with the following format:
	     * "RGBA(xxx, xxx, xxx, xx)".
	     */
	    TinyColor.prototype.toRgbString = function () {
	        var r = Math.round(this.r);
	        var g = Math.round(this.g);
	        var b = Math.round(this.b);
	        return this.a === 1 ? "rgb(" + r + ", " + g + ", " + b + ")" : "rgba(" + r + ", " + g + ", " + b + ", " + this.roundA + ")";
	    };
	    /**
	     * Returns the object as a RGBA object.
	     */
	    TinyColor.prototype.toPercentageRgb = function () {
	        var fmt = function (x) { return Math.round(bound01(x, 255) * 100) + "%"; };
	        return {
	            r: fmt(this.r),
	            g: fmt(this.g),
	            b: fmt(this.b),
	            a: this.a,
	        };
	    };
	    /**
	     * Returns the RGBA relative values interpolated into a string
	     */
	    TinyColor.prototype.toPercentageRgbString = function () {
	        var rnd = function (x) { return Math.round(bound01(x, 255) * 100); };
	        return this.a === 1
	            ? "rgb(" + rnd(this.r) + "%, " + rnd(this.g) + "%, " + rnd(this.b) + "%)"
	            : "rgba(" + rnd(this.r) + "%, " + rnd(this.g) + "%, " + rnd(this.b) + "%, " + this.roundA + ")";
	    };
	    /**
	     * The 'real' name of the color -if there is one.
	     */
	    TinyColor.prototype.toName = function () {
	        if (this.a === 0) {
	            return 'transparent';
	        }
	        if (this.a < 1) {
	            return false;
	        }
	        var hex = '#' + rgbToHex(this.r, this.g, this.b, false);
	        for (var _i = 0, _a = Object.entries(names); _i < _a.length; _i++) {
	            var _b = _a[_i], key = _b[0], value = _b[1];
	            if (hex === value) {
	                return key;
	            }
	        }
	        return false;
	    };
	    /**
	     * String representation of the color.
	     *
	     * @param format - The format to be used when displaying the string representation.
	     */
	    TinyColor.prototype.toString = function (format) {
	        var formatSet = Boolean(format);
	        format = format !== null && format !== void 0 ? format : this.format;
	        var formattedString = false;
	        var hasAlpha = this.a < 1 && this.a >= 0;
	        var needsAlphaFormat = !formatSet && hasAlpha && (format.startsWith('hex') || format === 'name');
	        if (needsAlphaFormat) {
	            // Special case for "transparent", all other non-alpha formats
	            // will return rgba when there is transparency.
	            if (format === 'name' && this.a === 0) {
	                return this.toName();
	            }
	            return this.toRgbString();
	        }
	        if (format === 'rgb') {
	            formattedString = this.toRgbString();
	        }
	        if (format === 'prgb') {
	            formattedString = this.toPercentageRgbString();
	        }
	        if (format === 'hex' || format === 'hex6') {
	            formattedString = this.toHexString();
	        }
	        if (format === 'hex3') {
	            formattedString = this.toHexString(true);
	        }
	        if (format === 'hex4') {
	            formattedString = this.toHex8String(true);
	        }
	        if (format === 'hex8') {
	            formattedString = this.toHex8String();
	        }
	        if (format === 'name') {
	            formattedString = this.toName();
	        }
	        if (format === 'hsl') {
	            formattedString = this.toHslString();
	        }
	        if (format === 'hsv') {
	            formattedString = this.toHsvString();
	        }
	        return formattedString || this.toHexString();
	    };
	    TinyColor.prototype.toNumber = function () {
	        return (Math.round(this.r) << 16) + (Math.round(this.g) << 8) + Math.round(this.b);
	    };
	    TinyColor.prototype.clone = function () {
	        return new TinyColor(this.toString());
	    };
	    /**
	     * Lighten the color a given amount. Providing 100 will always return white.
	     * @param amount - valid between 1-100
	     */
	    TinyColor.prototype.lighten = function (amount) {
	        if (amount === void 0) { amount = 10; }
	        var hsl = this.toHsl();
	        hsl.l += amount / 100;
	        hsl.l = clamp01(hsl.l);
	        return new TinyColor(hsl);
	    };
	    /**
	     * Brighten the color a given amount, from 0 to 100.
	     * @param amount - valid between 1-100
	     */
	    TinyColor.prototype.brighten = function (amount) {
	        if (amount === void 0) { amount = 10; }
	        var rgb = this.toRgb();
	        rgb.r = Math.max(0, Math.min(255, rgb.r - Math.round(255 * -(amount / 100))));
	        rgb.g = Math.max(0, Math.min(255, rgb.g - Math.round(255 * -(amount / 100))));
	        rgb.b = Math.max(0, Math.min(255, rgb.b - Math.round(255 * -(amount / 100))));
	        return new TinyColor(rgb);
	    };
	    /**
	     * Darken the color a given amount, from 0 to 100.
	     * Providing 100 will always return black.
	     * @param amount - valid between 1-100
	     */
	    TinyColor.prototype.darken = function (amount) {
	        if (amount === void 0) { amount = 10; }
	        var hsl = this.toHsl();
	        hsl.l -= amount / 100;
	        hsl.l = clamp01(hsl.l);
	        return new TinyColor(hsl);
	    };
	    /**
	     * Mix the color with pure white, from 0 to 100.
	     * Providing 0 will do nothing, providing 100 will always return white.
	     * @param amount - valid between 1-100
	     */
	    TinyColor.prototype.tint = function (amount) {
	        if (amount === void 0) { amount = 10; }
	        return this.mix('white', amount);
	    };
	    /**
	     * Mix the color with pure black, from 0 to 100.
	     * Providing 0 will do nothing, providing 100 will always return black.
	     * @param amount - valid between 1-100
	     */
	    TinyColor.prototype.shade = function (amount) {
	        if (amount === void 0) { amount = 10; }
	        return this.mix('black', amount);
	    };
	    /**
	     * Desaturate the color a given amount, from 0 to 100.
	     * Providing 100 will is the same as calling greyscale
	     * @param amount - valid between 1-100
	     */
	    TinyColor.prototype.desaturate = function (amount) {
	        if (amount === void 0) { amount = 10; }
	        var hsl = this.toHsl();
	        hsl.s -= amount / 100;
	        hsl.s = clamp01(hsl.s);
	        return new TinyColor(hsl);
	    };
	    /**
	     * Saturate the color a given amount, from 0 to 100.
	     * @param amount - valid between 1-100
	     */
	    TinyColor.prototype.saturate = function (amount) {
	        if (amount === void 0) { amount = 10; }
	        var hsl = this.toHsl();
	        hsl.s += amount / 100;
	        hsl.s = clamp01(hsl.s);
	        return new TinyColor(hsl);
	    };
	    /**
	     * Completely desaturates a color into greyscale.
	     * Same as calling `desaturate(100)`
	     */
	    TinyColor.prototype.greyscale = function () {
	        return this.desaturate(100);
	    };
	    /**
	     * Spin takes a positive or negative amount within [-360, 360] indicating the change of hue.
	     * Values outside of this range will be wrapped into this range.
	     */
	    TinyColor.prototype.spin = function (amount) {
	        var hsl = this.toHsl();
	        var hue = (hsl.h + amount) % 360;
	        hsl.h = hue < 0 ? 360 + hue : hue;
	        return new TinyColor(hsl);
	    };
	    /**
	     * Mix the current color a given amount with another color, from 0 to 100.
	     * 0 means no mixing (return current color).
	     */
	    TinyColor.prototype.mix = function (color, amount) {
	        if (amount === void 0) { amount = 50; }
	        var rgb1 = this.toRgb();
	        var rgb2 = new TinyColor(color).toRgb();
	        var p = amount / 100;
	        var rgba = {
	            r: (rgb2.r - rgb1.r) * p + rgb1.r,
	            g: (rgb2.g - rgb1.g) * p + rgb1.g,
	            b: (rgb2.b - rgb1.b) * p + rgb1.b,
	            a: (rgb2.a - rgb1.a) * p + rgb1.a,
	        };
	        return new TinyColor(rgba);
	    };
	    TinyColor.prototype.analogous = function (results, slices) {
	        if (results === void 0) { results = 6; }
	        if (slices === void 0) { slices = 30; }
	        var hsl = this.toHsl();
	        var part = 360 / slices;
	        var ret = [this];
	        for (hsl.h = (hsl.h - ((part * results) >> 1) + 720) % 360; --results;) {
	            hsl.h = (hsl.h + part) % 360;
	            ret.push(new TinyColor(hsl));
	        }
	        return ret;
	    };
	    /**
	     * taken from https://github.com/infusion/jQuery-xcolor/blob/master/jquery.xcolor.js
	     */
	    TinyColor.prototype.complement = function () {
	        var hsl = this.toHsl();
	        hsl.h = (hsl.h + 180) % 360;
	        return new TinyColor(hsl);
	    };
	    TinyColor.prototype.monochromatic = function (results) {
	        if (results === void 0) { results = 6; }
	        var hsv = this.toHsv();
	        var h = hsv.h;
	        var s = hsv.s;
	        var v = hsv.v;
	        var res = [];
	        var modification = 1 / results;
	        while (results--) {
	            res.push(new TinyColor({ h: h, s: s, v: v }));
	            v = (v + modification) % 1;
	        }
	        return res;
	    };
	    TinyColor.prototype.splitcomplement = function () {
	        var hsl = this.toHsl();
	        var h = hsl.h;
	        return [
	            this,
	            new TinyColor({ h: (h + 72) % 360, s: hsl.s, l: hsl.l }),
	            new TinyColor({ h: (h + 216) % 360, s: hsl.s, l: hsl.l }),
	        ];
	    };
	    /**
	     * Alias for `polyad(3)`
	     */
	    TinyColor.prototype.triad = function () {
	        return this.polyad(3);
	    };
	    /**
	     * Alias for `polyad(4)`
	     */
	    TinyColor.prototype.tetrad = function () {
	        return this.polyad(4);
	    };
	    /**
	     * Get polyad colors, like (for 1, 2, 3, 4, 5, 6, 7, 8, etc...)
	     * monad, dyad, triad, tetrad, pentad, hexad, heptad, octad, etc...
	     */
	    TinyColor.prototype.polyad = function (n) {
	        var hsl = this.toHsl();
	        var h = hsl.h;
	        var result = [this];
	        var increment = 360 / n;
	        for (var i = 1; i < n; i++) {
	            result.push(new TinyColor({ h: (h + i * increment) % 360, s: hsl.s, l: hsl.l }));
	        }
	        return result;
	    };
	    /**
	     * compare color vs current color
	     */
	    TinyColor.prototype.equals = function (color) {
	        return this.toRgbString() === new TinyColor(color).toRgbString();
	    };
	    return TinyColor;
	}());

	var hueStep = 2; // 色相阶梯

	var saturationStep = 0.16; // 饱和度阶梯，浅色部分

	var saturationStep2 = 0.05; // 饱和度阶梯，深色部分

	var brightnessStep1 = 0.05; // 亮度阶梯，浅色部分

	var brightnessStep2 = 0.15; // 亮度阶梯，深色部分

	var lightColorCount = 5; // 浅色数量，主色上

	var darkColorCount = 4; // 深色数量，主色下
	// 暗色主题颜色映射关系表

	var darkColorMap = [{
	  index: 7,
	  opacity: 0.15
	}, {
	  index: 6,
	  opacity: 0.25
	}, {
	  index: 5,
	  opacity: 0.3
	}, {
	  index: 5,
	  opacity: 0.45
	}, {
	  index: 5,
	  opacity: 0.65
	}, {
	  index: 5,
	  opacity: 0.85
	}, {
	  index: 4,
	  opacity: 0.9
	}, {
	  index: 3,
	  opacity: 0.95
	}, {
	  index: 2,
	  opacity: 0.97
	}, {
	  index: 1,
	  opacity: 0.98
	}];

	function getHue(hsv, i, light) {
	  var hue; // 根据色相不同，色相转向不同

	  if (Math.round(hsv.h) >= 60 && Math.round(hsv.h) <= 240) {
	    hue = light ? Math.round(hsv.h) - hueStep * i : Math.round(hsv.h) + hueStep * i;
	  } else {
	    hue = light ? Math.round(hsv.h) + hueStep * i : Math.round(hsv.h) - hueStep * i;
	  }

	  if (hue < 0) {
	    hue += 360;
	  } else if (hue >= 360) {
	    hue -= 360;
	  }

	  return hue;
	}

	function getSaturation(hsv, i, light) {
	  // grey color don't change saturation
	  if (hsv.h === 0 && hsv.s === 0) {
	    return hsv.s;
	  }

	  var saturation;

	  if (light) {
	    saturation = hsv.s - saturationStep * i;
	  } else if (i === darkColorCount) {
	    saturation = hsv.s + saturationStep;
	  } else {
	    saturation = hsv.s + saturationStep2 * i;
	  } // 边界值修正


	  if (saturation > 1) {
	    saturation = 1;
	  } // 第一格的 s 限制在 0.06-0.1 之间


	  if (light && i === lightColorCount && saturation > 0.1) {
	    saturation = 0.1;
	  }

	  if (saturation < 0.06) {
	    saturation = 0.06;
	  }

	  return Number(saturation.toFixed(2));
	}

	function getValue(hsv, i, light) {
	  var value;

	  if (light) {
	    value = hsv.v + brightnessStep1 * i;
	  } else {
	    value = hsv.v - brightnessStep2 * i;
	  }

	  if (value > 1) {
	    value = 1;
	  }

	  return Number(value.toFixed(2));
	}

	function generate(color) {
	  var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
	  var patterns = [];
	  var pColor = new TinyColor(color);

	  for (var i = lightColorCount; i > 0; i -= 1) {
	    var hsv = pColor.toHsv();
	    var colorString = new TinyColor({
	      h: getHue(hsv, i, true),
	      s: getSaturation(hsv, i, true),
	      v: getValue(hsv, i, true)
	    }).toHexString();
	    patterns.push(colorString);
	  }

	  patterns.push(pColor.toHexString());

	  for (var _i = 1; _i <= darkColorCount; _i += 1) {
	    var _hsv = pColor.toHsv();

	    var _colorString = new TinyColor({
	      h: getHue(_hsv, _i),
	      s: getSaturation(_hsv, _i),
	      v: getValue(_hsv, _i)
	    }).toHexString();

	    patterns.push(_colorString);
	  } // dark theme patterns


	  if (opts.theme === 'dark') {
	    return darkColorMap.map(function (_ref) {
	      var index = _ref.index,
	          opacity = _ref.opacity;
	      var darkColorString = new TinyColor(opts.backgroundColor || '#141414').mix(patterns[index], opacity * 100).toHexString();
	      return darkColorString;
	    });
	  }

	  return patterns;
	}

	var presetPrimaryColors = {
	  red: '#F5222D',
	  volcano: '#FA541C',
	  orange: '#FA8C16',
	  gold: '#FAAD14',
	  yellow: '#FADB14',
	  lime: '#A0D911',
	  green: '#52C41A',
	  cyan: '#13C2C2',
	  blue: '#1890FF',
	  geekblue: '#2F54EB',
	  purple: '#722ED1',
	  magenta: '#EB2F96',
	  grey: '#666666'
	};
	var presetPalettes = {};
	var presetDarkPalettes = {};
	Object.keys(presetPrimaryColors).forEach(function (key) {
	  presetPalettes[key] = generate(presetPrimaryColors[key]);
	  presetPalettes[key].primary = presetPalettes[key][5]; // dark presetPalettes

	  presetDarkPalettes[key] = generate(presetPrimaryColors[key], {
	    theme: 'dark',
	    backgroundColor: '#141414'
	  });
	  presetDarkPalettes[key].primary = presetDarkPalettes[key][5];
	});

	var warning_1 = createCommonjsModule(function (module, exports) {

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.warning = warning;
	exports.note = note;
	exports.resetWarned = resetWarned;
	exports.call = call;
	exports.warningOnce = warningOnce;
	exports.noteOnce = noteOnce;
	exports.default = void 0;

	/* eslint-disable no-console */
	var warned = {};

	function warning(valid, message) {
	  // Support uglify
	  if ( !valid && console !== undefined) {
	    console.error("Warning: ".concat(message));
	  }
	}

	function note(valid, message) {
	  // Support uglify
	  if ( !valid && console !== undefined) {
	    console.warn("Note: ".concat(message));
	  }
	}

	function resetWarned() {
	  warned = {};
	}

	function call(method, valid, message) {
	  if (!valid && !warned[message]) {
	    method(false, message);
	    warned[message] = true;
	  }
	}

	function warningOnce(valid, message) {
	  call(warning, valid, message);
	}

	function noteOnce(valid, message) {
	  call(note, valid, message);
	}

	var _default = warningOnce;
	/* eslint-enable */

	exports.default = _default;
	});

	var warn = unwrapExports(warning_1);
	var warning_2 = warning_1.warning;
	var warning_3 = warning_1.note;
	var warning_4 = warning_1.resetWarned;
	var warning_5 = warning_1.call;
	var warning_6 = warning_1.warningOnce;
	var warning_7 = warning_1.noteOnce;

	var containers = []; // will store container HTMLElement references
	var styleElements = []; // will store {prepend: HTMLElement, append: HTMLElement}

	var usage = 'insert-css: You need to provide a CSS string. Usage: insertCss(cssString[, options]).';

	function insertCss(css, options) {
	    options = options || {};

	    if (css === undefined) {
	        throw new Error(usage);
	    }

	    var position = options.prepend === true ? 'prepend' : 'append';
	    var container = options.container !== undefined ? options.container : document.querySelector('head');
	    var containerId = containers.indexOf(container);

	    // first time we see this container, create the necessary entries
	    if (containerId === -1) {
	        containerId = containers.push(container) - 1;
	        styleElements[containerId] = {};
	    }

	    // try to get the correponding container + position styleElement, create it otherwise
	    var styleElement;

	    if (styleElements[containerId] !== undefined && styleElements[containerId][position] !== undefined) {
	        styleElement = styleElements[containerId][position];
	    } else {
	        styleElement = styleElements[containerId][position] = createStyleElement();

	        if (position === 'prepend') {
	            container.insertBefore(styleElement, container.childNodes[0]);
	        } else {
	            container.appendChild(styleElement);
	        }
	    }

	    // strip potential UTF-8 BOM if css was read from a file
	    if (css.charCodeAt(0) === 0xFEFF) { css = css.substr(1, css.length); }

	    // actually add the stylesheet
	    if (styleElement.styleSheet) {
	        styleElement.styleSheet.cssText += css;
	    } else {
	        styleElement.textContent += css;
	    }

	    return styleElement;
	}
	function createStyleElement() {
	    var styleElement = document.createElement('style');
	    styleElement.setAttribute('type', 'text/css');
	    return styleElement;
	}

	var _insertCss_2_0_0_insertCss = insertCss;
	var insertCss_1 = insertCss;
	_insertCss_2_0_0_insertCss.insertCss = insertCss_1;

	function warning(valid, message) {
	  warn(valid, "[@ant-design/icons] ".concat(message));
	}
	function isIconDefinition(target) {
	  return _typeof_1(target) === 'object' && typeof target.name === 'string' && typeof target.theme === 'string' && (_typeof_1(target.icon) === 'object' || typeof target.icon === 'function');
	}
	function normalizeAttrs() {
	  var attrs = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
	  return Object.keys(attrs).reduce(function (acc, key) {
	    var val = attrs[key];

	    switch (key) {
	      case 'class':
	        acc.className = val;
	        delete acc.class;
	        break;

	      default:
	        acc[key] = val;
	    }

	    return acc;
	  }, {});
	}
	function generate$1(node, key, rootProps) {
	  if (!rootProps) {
	    return /*#__PURE__*/React__default.createElement(node.tag, objectSpread2({
	      key: key
	    }, normalizeAttrs(node.attrs)), (node.children || []).map(function (child, index) {
	      return generate$1(child, "".concat(key, "-").concat(node.tag, "-").concat(index));
	    }));
	  }

	  return /*#__PURE__*/React__default.createElement(node.tag, objectSpread2(objectSpread2({
	    key: key
	  }, normalizeAttrs(node.attrs)), rootProps), (node.children || []).map(function (child, index) {
	    return generate$1(child, "".concat(key, "-").concat(node.tag, "-").concat(index));
	  }));
	}
	function getSecondaryColor(primaryColor) {
	  // choose the second color
	  return generate(primaryColor)[0];
	}
	function normalizeTwoToneColors(twoToneColor) {
	  if (!twoToneColor) {
	    return [];
	  }

	  return Array.isArray(twoToneColor) ? twoToneColor : [twoToneColor];
	} // These props make sure that the SVG behaviours like general text.
	// Reference: https://blog.prototypr.io/align-svg-icons-to-text-and-say-goodbye-to-font-icons-d44b3d7b26b4

	var svgBaseProps = {
	  width: '1em',
	  height: '1em',
	  fill: 'currentColor',
	  'aria-hidden': 'true',
	  focusable: 'false'
	};
	var iconStyles = "\n.anticon {\n  display: inline-block;\n  color: inherit;\n  font-style: normal;\n  line-height: 0;\n  text-align: center;\n  text-transform: none;\n  vertical-align: -0.125em;\n  text-rendering: optimizeLegibility;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n}\n\n.anticon > * {\n  line-height: 1;\n}\n\n.anticon svg {\n  display: inline-block;\n}\n\n.anticon::before {\n  display: none;\n}\n\n.anticon .anticon-icon {\n  display: block;\n}\n\n.anticon[tabindex] {\n  cursor: pointer;\n}\n\n.anticon-spin::before,\n.anticon-spin {\n  display: inline-block;\n  -webkit-animation: loadingCircle 1s infinite linear;\n  animation: loadingCircle 1s infinite linear;\n}\n\n@-webkit-keyframes loadingCircle {\n  100% {\n    -webkit-transform: rotate(360deg);\n    transform: rotate(360deg);\n  }\n}\n\n@keyframes loadingCircle {\n  100% {\n    -webkit-transform: rotate(360deg);\n    transform: rotate(360deg);\n  }\n}\n";
	var cssInjectedFlag = false;
	var useInsertStyles = function useInsertStyles() {
	  var styleStr = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : iconStyles;
	  React.useEffect(function () {
	    if (!cssInjectedFlag) {
	      insertCss_1(styleStr, {
	        prepend: true
	      });
	      cssInjectedFlag = true;
	    }
	  }, []);
	};

	var twoToneColorPalette = {
	  primaryColor: '#333',
	  secondaryColor: '#E6E6E6',
	  calculated: false
	};

	function setTwoToneColors(_ref) {
	  var primaryColor = _ref.primaryColor,
	      secondaryColor = _ref.secondaryColor;
	  twoToneColorPalette.primaryColor = primaryColor;
	  twoToneColorPalette.secondaryColor = secondaryColor || getSecondaryColor(primaryColor);
	  twoToneColorPalette.calculated = !!secondaryColor;
	}

	function getTwoToneColors() {
	  return objectSpread2({}, twoToneColorPalette);
	}

	var IconBase = function IconBase(props) {
	  var icon = props.icon,
	      className = props.className,
	      onClick = props.onClick,
	      style = props.style,
	      primaryColor = props.primaryColor,
	      secondaryColor = props.secondaryColor,
	      restProps = objectWithoutProperties(props, ["icon", "className", "onClick", "style", "primaryColor", "secondaryColor"]);

	  var colors = twoToneColorPalette;

	  if (primaryColor) {
	    colors = {
	      primaryColor: primaryColor,
	      secondaryColor: secondaryColor || getSecondaryColor(primaryColor)
	    };
	  }

	  useInsertStyles();
	  warning(isIconDefinition(icon), "icon should be icon definiton, but got ".concat(icon));

	  if (!isIconDefinition(icon)) {
	    return null;
	  }

	  var target = icon;

	  if (target && typeof target.icon === 'function') {
	    target = objectSpread2(objectSpread2({}, target), {}, {
	      icon: target.icon(colors.primaryColor, colors.secondaryColor)
	    });
	  }

	  return generate$1(target.icon, "svg-".concat(target.name), objectSpread2({
	    className: className,
	    onClick: onClick,
	    style: style,
	    'data-icon': target.name,
	    width: '1em',
	    height: '1em',
	    fill: 'currentColor',
	    'aria-hidden': 'true'
	  }, restProps));
	};

	IconBase.displayName = 'IconReact';
	IconBase.getTwoToneColors = getTwoToneColors;
	IconBase.setTwoToneColors = setTwoToneColors;

	function setTwoToneColor(twoToneColor) {
	  var _normalizeTwoToneColo = normalizeTwoToneColors(twoToneColor),
	      _normalizeTwoToneColo2 = slicedToArray(_normalizeTwoToneColo, 2),
	      primaryColor = _normalizeTwoToneColo2[0],
	      secondaryColor = _normalizeTwoToneColo2[1];

	  return IconBase.setTwoToneColors({
	    primaryColor: primaryColor,
	    secondaryColor: secondaryColor
	  });
	}
	function getTwoToneColor() {
	  var colors = IconBase.getTwoToneColors();

	  if (!colors.calculated) {
	    return colors.primaryColor;
	  }

	  return [colors.primaryColor, colors.secondaryColor];
	}

	// should move it to antd main repo?

	setTwoToneColor('#1890ff');
	var Icon = /*#__PURE__*/React.forwardRef(function (props, ref) {
	  var className = props.className,
	      icon = props.icon,
	      spin = props.spin,
	      rotate = props.rotate,
	      tabIndex = props.tabIndex,
	      onClick = props.onClick,
	      twoToneColor = props.twoToneColor,
	      restProps = objectWithoutProperties(props, ["className", "icon", "spin", "rotate", "tabIndex", "onClick", "twoToneColor"]);

	  var classString = _classnames_2_2_6_classnames('anticon', defineProperty({}, "anticon-".concat(icon.name), Boolean(icon.name)), {
	    'anticon-spin': !!spin || icon.name === 'loading'
	  }, className);
	  var iconTabIndex = tabIndex;

	  if (iconTabIndex === undefined && onClick) {
	    iconTabIndex = -1;
	  }

	  var svgStyle = rotate ? {
	    msTransform: "rotate(".concat(rotate, "deg)"),
	    transform: "rotate(".concat(rotate, "deg)")
	  } : undefined;

	  var _normalizeTwoToneColo = normalizeTwoToneColors(twoToneColor),
	      _normalizeTwoToneColo2 = slicedToArray(_normalizeTwoToneColo, 2),
	      primaryColor = _normalizeTwoToneColo2[0],
	      secondaryColor = _normalizeTwoToneColo2[1];

	  return /*#__PURE__*/React.createElement("span", Object.assign({
	    role: "img",
	    "aria-label": icon.name
	  }, restProps, {
	    ref: ref,
	    tabIndex: iconTabIndex,
	    onClick: onClick,
	    className: classString
	  }), /*#__PURE__*/React.createElement(IconBase, {
	    icon: icon,
	    primaryColor: primaryColor,
	    secondaryColor: secondaryColor,
	    style: svgStyle
	  }));
	});
	Icon.displayName = 'AntdIcon';
	Icon.getTwoToneColor = getTwoToneColor;
	Icon.setTwoToneColor = setTwoToneColor;

	// GENERATE BY ./scripts/generate.ts

	var AccountBookFilled = function AccountBookFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: AccountBookFilledSvg
	  }));
	};

	AccountBookFilled.displayName = 'AccountBookFilled';
	var AccountBookFilled$1 = /*#__PURE__*/React.forwardRef(AccountBookFilled);

	var AccountBookOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var AccountBookOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 184H712v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H384v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H144c-17.7 0-32 14.3-32 32v664c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V216c0-17.7-14.3-32-32-32zm-40 656H184V256h128v48c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-48h256v48c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-48h128v584zM639.5 414h-45c-3 0-5.8 1.7-7.1 4.4L514 563.8h-2.8l-73.4-145.4a8 8 0 00-7.1-4.4h-46c-1.3 0-2.7.3-3.8 1-3.9 2.1-5.3 7-3.2 10.9l89.3 164h-48.6c-4.4 0-8 3.6-8 8v21.3c0 4.4 3.6 8 8 8h65.1v33.7h-65.1c-4.4 0-8 3.6-8 8v21.3c0 4.4 3.6 8 8 8h65.1V752c0 4.4 3.6 8 8 8h41.3c4.4 0 8-3.6 8-8v-53.8h65.4c4.4 0 8-3.6 8-8v-21.3c0-4.4-3.6-8-8-8h-65.4v-33.7h65.4c4.4 0 8-3.6 8-8v-21.3c0-4.4-3.6-8-8-8h-49.1l89.3-164.1c.6-1.2 1-2.5 1-3.8.1-4.4-3.4-8-7.9-8z" } }] }, "name": "account-book", "theme": "outlined" };
	exports.default = AccountBookOutlined;
	});

	var AccountBookOutlinedSvg = unwrapExports(AccountBookOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var AccountBookOutlined = function AccountBookOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: AccountBookOutlinedSvg
	  }));
	};

	AccountBookOutlined.displayName = 'AccountBookOutlined';
	var AccountBookOutlined$1 = /*#__PURE__*/React.forwardRef(AccountBookOutlined);

	var AccountBookTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var AccountBookTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M712 304c0 4.4-3.6 8-8 8h-56c-4.4 0-8-3.6-8-8v-48H384v48c0 4.4-3.6 8-8 8h-56c-4.4 0-8-3.6-8-8v-48H184v584h656V256H712v48zm-65.6 121.8l-89.3 164.1h49.1c4.4 0 8 3.6 8 8v21.3c0 4.4-3.6 8-8 8h-65.4v33.7h65.4c4.4 0 8 3.6 8 8v21.3c0 4.4-3.6 8-8 8h-65.4V752c0 4.4-3.6 8-8 8h-41.3c-4.4 0-8-3.6-8-8v-53.8h-65.1c-4.4 0-8-3.6-8-8v-21.3c0-4.4 3.6-8 8-8h65.1v-33.7h-65.1c-4.4 0-8-3.6-8-8v-21.3c0-4.4 3.6-8 8-8H467l-89.3-164c-2.1-3.9-.7-8.8 3.2-10.9 1.1-.7 2.5-1 3.8-1h46a8 8 0 017.1 4.4l73.4 145.4h2.8l73.4-145.4c1.3-2.7 4.1-4.4 7.1-4.4h45c4.5 0 8 3.6 7.9 8 0 1.3-.4 2.6-1 3.8z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M639.5 414h-45c-3 0-5.8 1.7-7.1 4.4L514 563.8h-2.8l-73.4-145.4a8 8 0 00-7.1-4.4h-46c-1.3 0-2.7.3-3.8 1-3.9 2.1-5.3 7-3.2 10.9l89.3 164h-48.6c-4.4 0-8 3.6-8 8v21.3c0 4.4 3.6 8 8 8h65.1v33.7h-65.1c-4.4 0-8 3.6-8 8v21.3c0 4.4 3.6 8 8 8h65.1V752c0 4.4 3.6 8 8 8h41.3c4.4 0 8-3.6 8-8v-53.8h65.4c4.4 0 8-3.6 8-8v-21.3c0-4.4-3.6-8-8-8h-65.4v-33.7h65.4c4.4 0 8-3.6 8-8v-21.3c0-4.4-3.6-8-8-8h-49.1l89.3-164.1c.6-1.2 1-2.5 1-3.8.1-4.4-3.4-8-7.9-8z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M880 184H712v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H384v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H144c-17.7 0-32 14.3-32 32v664c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V216c0-17.7-14.3-32-32-32zm-40 656H184V256h128v48c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-48h256v48c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-48h128v584z", "fill": primaryColor } }] }; }, "name": "account-book", "theme": "twotone" };
	exports.default = AccountBookTwoTone;
	});

	var AccountBookTwoToneSvg = unwrapExports(AccountBookTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var AccountBookTwoTone = function AccountBookTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: AccountBookTwoToneSvg
	  }));
	};

	AccountBookTwoTone.displayName = 'AccountBookTwoTone';
	var AccountBookTwoTone$1 = /*#__PURE__*/React.forwardRef(AccountBookTwoTone);

	var AimOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var AimOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M952 474H829.8C812.5 327.6 696.4 211.5 550 194.2V72c0-4.4-3.6-8-8-8h-60c-4.4 0-8 3.6-8 8v122.2C327.6 211.5 211.5 327.6 194.2 474H72c-4.4 0-8 3.6-8 8v60c0 4.4 3.6 8 8 8h122.2C211.5 696.4 327.6 812.5 474 829.8V952c0 4.4 3.6 8 8 8h60c4.4 0 8-3.6 8-8V829.8C696.4 812.5 812.5 696.4 829.8 550H952c4.4 0 8-3.6 8-8v-60c0-4.4-3.6-8-8-8zM512 756c-134.8 0-244-109.2-244-244s109.2-244 244-244 244 109.2 244 244-109.2 244-244 244z" } }, { "tag": "path", "attrs": { "d": "M512 392c-32.1 0-62.1 12.4-84.8 35.2-22.7 22.7-35.2 52.7-35.2 84.8s12.5 62.1 35.2 84.8C449.9 619.4 480 632 512 632s62.1-12.5 84.8-35.2C619.4 574.1 632 544 632 512s-12.5-62.1-35.2-84.8A118.57 118.57 0 00512 392z" } }] }, "name": "aim", "theme": "outlined" };
	exports.default = AimOutlined;
	});

	var AimOutlinedSvg = unwrapExports(AimOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var AimOutlined = function AimOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: AimOutlinedSvg
	  }));
	};

	AimOutlined.displayName = 'AimOutlined';
	var AimOutlined$1 = /*#__PURE__*/React.forwardRef(AimOutlined);

	var AlertFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var AlertFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 244c176.18 0 319 142.82 319 319v233a32 32 0 01-32 32H225a32 32 0 01-32-32V563c0-176.18 142.82-319 319-319zM484 68h56a8 8 0 018 8v96a8 8 0 01-8 8h-56a8 8 0 01-8-8V76a8 8 0 018-8zM177.25 191.66a8 8 0 0111.32 0l67.88 67.88a8 8 0 010 11.31l-39.6 39.6a8 8 0 01-11.31 0l-67.88-67.88a8 8 0 010-11.31l39.6-39.6zm669.6 0l39.6 39.6a8 8 0 010 11.3l-67.88 67.9a8 8 0 01-11.32 0l-39.6-39.6a8 8 0 010-11.32l67.89-67.88a8 8 0 0111.31 0zM192 892h640a32 32 0 0132 32v24a8 8 0 01-8 8H168a8 8 0 01-8-8v-24a32 32 0 0132-32zm148-317v253h64V575h-64z" } }] }, "name": "alert", "theme": "filled" };
	exports.default = AlertFilled;
	});

	var AlertFilledSvg = unwrapExports(AlertFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var AlertFilled = function AlertFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: AlertFilledSvg
	  }));
	};

	AlertFilled.displayName = 'AlertFilled';
	var AlertFilled$1 = /*#__PURE__*/React.forwardRef(AlertFilled);

	var AlertOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var AlertOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M193 796c0 17.7 14.3 32 32 32h574c17.7 0 32-14.3 32-32V563c0-176.2-142.8-319-319-319S193 386.8 193 563v233zm72-233c0-136.4 110.6-247 247-247s247 110.6 247 247v193H404V585c0-5.5-4.5-10-10-10h-44c-5.5 0-10 4.5-10 10v171h-75V563zm-48.1-252.5l39.6-39.6c3.1-3.1 3.1-8.2 0-11.3l-67.9-67.9a8.03 8.03 0 00-11.3 0l-39.6 39.6a8.03 8.03 0 000 11.3l67.9 67.9c3.1 3.1 8.1 3.1 11.3 0zm669.6-79.2l-39.6-39.6a8.03 8.03 0 00-11.3 0l-67.9 67.9a8.03 8.03 0 000 11.3l39.6 39.6c3.1 3.1 8.2 3.1 11.3 0l67.9-67.9c3.1-3.2 3.1-8.2 0-11.3zM832 892H192c-17.7 0-32 14.3-32 32v24c0 4.4 3.6 8 8 8h688c4.4 0 8-3.6 8-8v-24c0-17.7-14.3-32-32-32zM484 180h56c4.4 0 8-3.6 8-8V76c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v96c0 4.4 3.6 8 8 8z" } }] }, "name": "alert", "theme": "outlined" };
	exports.default = AlertOutlined;
	});

	var AlertOutlinedSvg = unwrapExports(AlertOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var AlertOutlined = function AlertOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: AlertOutlinedSvg
	  }));
	};

	AlertOutlined.displayName = 'AlertOutlined';
	var AlertOutlined$1 = /*#__PURE__*/React.forwardRef(AlertOutlined);

	var AlertTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var AlertTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M340 585c0-5.5 4.5-10 10-10h44c5.5 0 10 4.5 10 10v171h355V563c0-136.4-110.6-247-247-247S265 426.6 265 563v193h75V585z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M216.9 310.5l39.6-39.6c3.1-3.1 3.1-8.2 0-11.3l-67.9-67.9a8.03 8.03 0 00-11.3 0l-39.6 39.6a8.03 8.03 0 000 11.3l67.9 67.9c3.1 3.1 8.1 3.1 11.3 0zm669.6-79.2l-39.6-39.6a8.03 8.03 0 00-11.3 0l-67.9 67.9a8.03 8.03 0 000 11.3l39.6 39.6c3.1 3.1 8.2 3.1 11.3 0l67.9-67.9c3.1-3.2 3.1-8.2 0-11.3zM484 180h56c4.4 0 8-3.6 8-8V76c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v96c0 4.4 3.6 8 8 8zm348 712H192c-17.7 0-32 14.3-32 32v24c0 4.4 3.6 8 8 8h688c4.4 0 8-3.6 8-8v-24c0-17.7-14.3-32-32-32zm-639-96c0 17.7 14.3 32 32 32h574c17.7 0 32-14.3 32-32V563c0-176.2-142.8-319-319-319S193 386.8 193 563v233zm72-233c0-136.4 110.6-247 247-247s247 110.6 247 247v193H404V585c0-5.5-4.5-10-10-10h-44c-5.5 0-10 4.5-10 10v171h-75V563z", "fill": primaryColor } }] }; }, "name": "alert", "theme": "twotone" };
	exports.default = AlertTwoTone;
	});

	var AlertTwoToneSvg = unwrapExports(AlertTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var AlertTwoTone = function AlertTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: AlertTwoToneSvg
	  }));
	};

	AlertTwoTone.displayName = 'AlertTwoTone';
	var AlertTwoTone$1 = /*#__PURE__*/React.forwardRef(AlertTwoTone);

	var AlibabaOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var AlibabaOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M602.9 669.8c-37.2 2.6-33.6-17.3-11.5-46.2 50.4-67.2 143.7-158.5 147.9-225.2 5.8-86.6-81.3-113.4-171-113.4-62.4 1.6-127 18.9-171 34.6-151.6 53.5-246.6 137.5-306.9 232-62.4 93.4-43 183.2 91.8 185.8 101.8-4.2 170.5-32.5 239.7-68.2.5 0-192.5 55.1-263.9 14.7-7.9-4.2-15.7-10-17.8-26.2 0-33.1 54.6-67.7 86.6-78.7v-56.7c64.5 22.6 140.6 16.3 205.7-32 2.1 5.8 4.2 13.1 3.7 21h11c2.6-22.6-12.6-44.6-37.8-46.2 7.3 5.8 12.6 10.5 15.2 14.7l-1 1-.5.5c-83.9 58.8-165.3 31.5-173.1 29.9l46.7-45.7-13.1-33.1c92.9-32.5 169.5-56.2 296.9-78.7l-28.5-23 14.7-8.9c75.5 21 126.4 36.7 123.8 76.6-1 6.8-3.7 14.7-7.9 23.1C660.1 466.1 594 538 567.2 569c-17.3 20.5-34.6 39.4-46.7 58.3-13.6 19.4-20.5 37.3-21 53.5 2.6 131.8 391.4-61.9 468-112.9-111.7 47.8-232.9 93.5-364.6 101.9zm85-302.9c2.8 5.2 4.1 11.6 4.1 19.1-.1-6.8-1.4-13.3-4.1-19.1z" } }] }, "name": "alibaba", "theme": "outlined" };
	exports.default = AlibabaOutlined;
	});

	var AlibabaOutlinedSvg = unwrapExports(AlibabaOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var AlibabaOutlined = function AlibabaOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: AlibabaOutlinedSvg
	  }));
	};

	AlibabaOutlined.displayName = 'AlibabaOutlined';
	var AlibabaOutlined$1 = /*#__PURE__*/React.forwardRef(AlibabaOutlined);

	var AlignCenterOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var AlignCenterOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M264 230h496c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H264c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm496 424c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H264c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h496zm144 140H120c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-424H120c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8z" } }] }, "name": "align-center", "theme": "outlined" };
	exports.default = AlignCenterOutlined;
	});

	var AlignCenterOutlinedSvg = unwrapExports(AlignCenterOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var AlignCenterOutlined = function AlignCenterOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: AlignCenterOutlinedSvg
	  }));
	};

	AlignCenterOutlined.displayName = 'AlignCenterOutlined';
	var AlignCenterOutlined$1 = /*#__PURE__*/React.forwardRef(AlignCenterOutlined);

	var AlignLeftOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var AlignLeftOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M120 230h496c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H120c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm0 424h496c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H120c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm784 140H120c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-424H120c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8z" } }] }, "name": "align-left", "theme": "outlined" };
	exports.default = AlignLeftOutlined;
	});

	var AlignLeftOutlinedSvg = unwrapExports(AlignLeftOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var AlignLeftOutlined = function AlignLeftOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: AlignLeftOutlinedSvg
	  }));
	};

	AlignLeftOutlined.displayName = 'AlignLeftOutlined';
	var AlignLeftOutlined$1 = /*#__PURE__*/React.forwardRef(AlignLeftOutlined);

	var AlignRightOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var AlignRightOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M904 158H408c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h496c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 424H408c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h496c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 212H120c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-424H120c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8z" } }] }, "name": "align-right", "theme": "outlined" };
	exports.default = AlignRightOutlined;
	});

	var AlignRightOutlinedSvg = unwrapExports(AlignRightOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var AlignRightOutlined = function AlignRightOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: AlignRightOutlinedSvg
	  }));
	};

	AlignRightOutlined.displayName = 'AlignRightOutlined';
	var AlignRightOutlined$1 = /*#__PURE__*/React.forwardRef(AlignRightOutlined);

	var AlipayCircleFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var AlipayCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M308.6 545.7c-19.8 2-57.1 10.7-77.4 28.6-61 53-24.5 150 99 150 71.8 0 143.5-45.7 199.8-119-80.2-38.9-148.1-66.8-221.4-59.6zm460.5 67c100.1 33.4 154.7 43 166.7 44.8A445.9 445.9 0 00960 512c0-247.4-200.6-448-448-448S64 264.6 64 512s200.6 448 448 448c155.9 0 293.2-79.7 373.5-200.5-75.6-29.8-213.6-85-286.8-120.1-69.9 85.7-160.1 137.8-253.7 137.8-158.4 0-212.1-138.1-137.2-229 16.3-19.8 44.2-38.7 87.3-49.4 67.5-16.5 175 10.3 275.7 43.4 18.1-33.3 33.4-69.9 44.7-108.9H305.1V402h160v-56.2H271.3v-31.3h193.8v-80.1s0-13.5 13.7-13.5H557v93.6h191.7v31.3H557.1V402h156.4c-15 61.1-37.7 117.4-66.2 166.8 47.5 17.1 90.1 33.3 121.8 43.9z" } }] }, "name": "alipay-circle", "theme": "filled" };
	exports.default = AlipayCircleFilled;
	});

	var AlipayCircleFilledSvg = unwrapExports(AlipayCircleFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var AlipayCircleFilled = function AlipayCircleFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: AlipayCircleFilledSvg
	  }));
	};

	AlipayCircleFilled.displayName = 'AlipayCircleFilled';
	var AlipayCircleFilled$1 = /*#__PURE__*/React.forwardRef(AlipayCircleFilled);

	var AlipayCircleOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var AlipayCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M308.6 545.7c-19.8 2-57.1 10.7-77.4 28.6-61 53-24.5 150 99 150 71.8 0 143.5-45.7 199.8-119-80.2-38.9-148.1-66.8-221.4-59.6zm460.5 67c100.1 33.4 154.7 43 166.7 44.8A445.9 445.9 0 00960 512c0-247.4-200.6-448-448-448S64 264.6 64 512s200.6 448 448 448c155.9 0 293.2-79.7 373.5-200.5-75.6-29.8-213.6-85-286.8-120.1-69.9 85.7-160.1 137.8-253.7 137.8-158.4 0-212.1-138.1-137.2-229 16.3-19.8 44.2-38.7 87.3-49.4 67.5-16.5 175 10.3 275.7 43.4 18.1-33.3 33.4-69.9 44.7-108.9H305.1V402h160v-56.2H271.3v-31.3h193.8v-80.1s0-13.5 13.7-13.5H557v93.6h191.7v31.3H557.1V402h156.4c-15 61.1-37.7 117.4-66.2 166.8 47.5 17.1 90.1 33.3 121.8 43.9z" } }] }, "name": "alipay-circle", "theme": "outlined" };
	exports.default = AlipayCircleOutlined;
	});

	var AlipayCircleOutlinedSvg = unwrapExports(AlipayCircleOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var AlipayCircleOutlined = function AlipayCircleOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: AlipayCircleOutlinedSvg
	  }));
	};

	AlipayCircleOutlined.displayName = 'AlipayCircleOutlined';
	var AlipayCircleOutlined$1 = /*#__PURE__*/React.forwardRef(AlipayCircleOutlined);

	var AlipayOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var AlipayOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M789 610.3c-38.7-12.9-90.7-32.7-148.5-53.6 34.8-60.3 62.5-129 80.7-203.6H530.5v-68.6h233.6v-38.3H530.5V132h-95.4c-16.7 0-16.7 16.5-16.7 16.5v97.8H182.2v38.3h236.3v68.6H223.4v38.3h378.4a667.18 667.18 0 01-54.5 132.9c-122.8-40.4-253.8-73.2-336.1-53-52.6 13-86.5 36.1-106.5 60.3-91.4 111-25.9 279.6 167.2 279.6C386 811.2 496 747.6 581.2 643 708.3 704 960 808.7 960 808.7V659.4s-31.6-2.5-171-49.1zM253.9 746.6c-150.5 0-195-118.3-120.6-183.1 24.8-21.9 70.2-32.6 94.4-35 89.4-8.8 172.2 25.2 269.9 72.8-68.8 89.5-156.3 145.3-243.7 145.3z" } }] }, "name": "alipay", "theme": "outlined" };
	exports.default = AlipayOutlined;
	});

	var AlipayOutlinedSvg = unwrapExports(AlipayOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var AlipayOutlined = function AlipayOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: AlipayOutlinedSvg
	  }));
	};

	AlipayOutlined.displayName = 'AlipayOutlined';
	var AlipayOutlined$1 = /*#__PURE__*/React.forwardRef(AlipayOutlined);

	var AlipaySquareFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var AlipaySquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M308.6 545.7c-19.8 2-57.1 10.7-77.4 28.6-61 53-24.5 150 99 150 71.8 0 143.5-45.7 199.8-119-80.2-38.9-148.1-66.8-221.4-59.6zM880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm29.4 663.2S703 689.4 598.7 639.5C528.8 725.2 438.6 777.3 345 777.3c-158.4 0-212.1-138.1-137.2-229 16.3-19.8 44.2-38.7 87.3-49.4 67.5-16.5 175 10.3 275.7 43.4 18.1-33.3 33.4-69.9 44.7-108.9H305.1V402h160v-56.2H271.3v-31.3h193.8v-80.1s0-13.5 13.7-13.5H557v93.6h191.7v31.3H557.1V402h156.4c-15 61.1-37.7 117.4-66.2 166.8 47.5 17.1 90.1 33.3 121.8 43.9 114.3 38.2 140.2 40.2 140.2 40.2v122.3z" } }] }, "name": "alipay-square", "theme": "filled" };
	exports.default = AlipaySquareFilled;
	});

	var AlipaySquareFilledSvg = unwrapExports(AlipaySquareFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var AlipaySquareFilled = function AlipaySquareFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: AlipaySquareFilledSvg
	  }));
	};

	AlipaySquareFilled.displayName = 'AlipaySquareFilled';
	var AlipaySquareFilled$1 = /*#__PURE__*/React.forwardRef(AlipaySquareFilled);

	var AliwangwangFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var AliwangwangFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M868.2 377.4c-18.9-45.1-46.3-85.6-81.2-120.6a377.26 377.26 0 00-120.5-81.2A375.65 375.65 0 00519 145.8c-41.9 0-82.9 6.7-121.9 20C306 123.3 200.8 120 170.6 120c-2.2 0-7.4 0-9.4.2-11.9.4-22.8 6.5-29.2 16.4-6.5 9.9-7.7 22.4-3.4 33.5l64.3 161.6a378.59 378.59 0 00-52.8 193.2c0 51.4 10 101 29.8 147.6 18.9 45 46.2 85.6 81.2 120.5 34.7 34.8 75.4 62.1 120.5 81.2C418.3 894 467.9 904 519 904c51.3 0 100.9-10 147.7-29.8 44.9-18.9 85.5-46.3 120.4-81.2 34.7-34.8 62.1-75.4 81.2-120.6a376.5 376.5 0 0029.8-147.6c-.2-51.2-10.1-100.8-29.9-147.4zm-325.2 79c0 20.4-16.6 37.1-37.1 37.1-20.4 0-37.1-16.7-37.1-37.1v-55.1c0-20.4 16.6-37.1 37.1-37.1 20.4 0 37.1 16.6 37.1 37.1v55.1zm175.2 0c0 20.4-16.6 37.1-37.1 37.1S644 476.8 644 456.4v-55.1c0-20.4 16.7-37.1 37.1-37.1 20.4 0 37.1 16.6 37.1 37.1v55.1z" } }] }, "name": "aliwangwang", "theme": "filled" };
	exports.default = AliwangwangFilled;
	});

	var AliwangwangFilledSvg = unwrapExports(AliwangwangFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var AliwangwangFilled = function AliwangwangFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: AliwangwangFilledSvg
	  }));
	};

	AliwangwangFilled.displayName = 'AliwangwangFilled';
	var AliwangwangFilled$1 = /*#__PURE__*/React.forwardRef(AliwangwangFilled);

	var AliwangwangOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var AliwangwangOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M868.2 377.4c-18.9-45.1-46.3-85.6-81.2-120.6a377.26 377.26 0 00-120.5-81.2A375.65 375.65 0 00519 145.8c-41.9 0-82.9 6.7-121.9 20C306 123.3 200.8 120 170.6 120c-2.2 0-7.4 0-9.4.2-11.9.4-22.8 6.5-29.2 16.4-6.5 9.9-7.7 22.4-3.4 33.5l64.3 161.6a378.59 378.59 0 00-52.8 193.2c0 51.4 10 101 29.8 147.6 18.9 45 46.2 85.6 81.2 120.5 34.7 34.8 75.4 62.1 120.5 81.2C418.3 894 467.9 904 519 904c51.3 0 100.9-10.1 147.7-29.8 44.9-18.9 85.5-46.3 120.4-81.2 34.7-34.8 62.1-75.4 81.2-120.6a376.5 376.5 0 0029.8-147.6c-.2-51.2-10.1-100.8-29.9-147.4zm-66.4 266.5a307.08 307.08 0 01-65.9 98c-28.4 28.5-61.3 50.7-97.7 65.9h-.1c-38 16-78.3 24.2-119.9 24.2a306.51 306.51 0 01-217.5-90.2c-28.4-28.5-50.6-61.4-65.8-97.8v-.1c-16-37.8-24.1-78.2-24.1-119.9 0-55.4 14.8-109.7 42.8-157l13.2-22.1-9.5-23.9L206 192c14.9.6 35.9 2.1 59.7 5.6 43.8 6.5 82.5 17.5 114.9 32.6l19 8.9 19.9-6.8c31.5-10.8 64.8-16.2 98.9-16.2a306.51 306.51 0 01217.5 90.2c28.4 28.5 50.6 61.4 65.8 97.8l.1.1.1.1c16 37.6 24.1 78 24.2 119.8-.1 41.7-8.3 82-24.3 119.8zM681.1 364.2c-20.4 0-37.1 16.7-37.1 37.1v55.1c0 20.4 16.6 37.1 37.1 37.1s37.1-16.7 37.1-37.1v-55.1c0-20.5-16.7-37.1-37.1-37.1zm-175.2 0c-20.5 0-37.1 16.7-37.1 37.1v55.1c0 20.4 16.7 37.1 37.1 37.1 20.5 0 37.1-16.7 37.1-37.1v-55.1c0-20.5-16.7-37.1-37.1-37.1z" } }] }, "name": "aliwangwang", "theme": "outlined" };
	exports.default = AliwangwangOutlined;
	});

	var AliwangwangOutlinedSvg = unwrapExports(AliwangwangOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var AliwangwangOutlined = function AliwangwangOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: AliwangwangOutlinedSvg
	  }));
	};

	AliwangwangOutlined.displayName = 'AliwangwangOutlined';
	var AliwangwangOutlined$1 = /*#__PURE__*/React.forwardRef(AliwangwangOutlined);

	var AliyunOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var AliyunOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M959.2 383.9c-.3-82.1-66.9-148.6-149.1-148.6H575.9l21.6 85.2 201 43.7a42.58 42.58 0 0132.9 39.7c.1.5.1 216.1 0 216.6a42.58 42.58 0 01-32.9 39.7l-201 43.7-21.6 85.3h234.2c82.1 0 148.8-66.5 149.1-148.6V383.9zM225.5 660.4a42.58 42.58 0 01-32.9-39.7c-.1-.6-.1-216.1 0-216.6.8-19.4 14.6-35.5 32.9-39.7l201-43.7 21.6-85.2H213.8c-82.1 0-148.8 66.4-149.1 148.6V641c.3 82.1 67 148.6 149.1 148.6H448l-21.6-85.3-200.9-43.9zm200.9-158.8h171v21.3h-171z" } }] }, "name": "aliyun", "theme": "outlined" };
	exports.default = AliyunOutlined;
	});

	var AliyunOutlinedSvg = unwrapExports(AliyunOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var AliyunOutlined = function AliyunOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: AliyunOutlinedSvg
	  }));
	};

	AliyunOutlined.displayName = 'AliyunOutlined';
	var AliyunOutlined$1 = /*#__PURE__*/React.forwardRef(AliyunOutlined);

	var AmazonCircleFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var AmazonCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M485 467.5c-11.6 4.9-20.9 12.2-27.8 22-6.9 9.8-10.4 21.6-10.4 35.5 0 17.8 7.5 31.5 22.4 41.2 14.1 9.1 28.9 11.4 44.4 6.8 17.9-5.2 30-17.9 36.4-38.1 3-9.3 4.5-19.7 4.5-31.3v-50.2c-12.6.4-24.4 1.6-35.5 3.7-11.1 2.1-22.4 5.6-34 10.4zM512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm35.8 262.7c-7.2-10.9-20.1-16.4-38.7-16.4-1.3 0-3 .1-5.3.3-2.2.2-6.6 1.5-12.9 3.7a79.4 79.4 0 00-17.9 9.1c-5.5 3.8-11.5 10-18 18.4-6.4 8.5-11.5 18.4-15.3 29.8l-94-8.4c0-12.4 2.4-24.7 7-36.9 4.7-12.2 11.8-23.9 21.4-35 9.6-11.2 21.1-21 34.5-29.4 13.4-8.5 29.6-15.2 48.4-20.3 18.9-5.1 39.1-7.6 60.9-7.6 21.3 0 40.6 2.6 57.8 7.7 17.2 5.2 31.1 11.5 41.4 19.1a117 117 0 0125.9 25.7c6.9 9.6 11.7 18.5 14.4 26.7 2.7 8.2 4 15.7 4 22.8v182.5c0 6.4 1.4 13 4.3 19.8 2.9 6.8 6.3 12.8 10.2 18 3.9 5.2 7.9 9.9 12 14.3 4.1 4.3 7.6 7.7 10.6 9.9l4.1 3.4-72.5 69.4c-8.5-7.7-16.9-15.4-25.2-23.4-8.3-8-14.5-14-18.5-18.1l-6.1-6.2c-2.4-2.3-5-5.7-8-10.2-8.1 12.2-18.5 22.8-31.1 31.8-12.7 9-26.3 15.6-40.7 19.7-14.5 4.1-29.4 6.5-44.7 7.1-15.3.6-30-1.5-43.9-6.5-13.9-5-26.5-11.7-37.6-20.3-11.1-8.6-19.9-20.2-26.5-35-6.6-14.8-9.9-31.5-9.9-50.4 0-17.4 3-33.3 8.9-47.7 6-14.5 13.6-26.5 23-36.1 9.4-9.6 20.7-18.2 34-25.7s26.4-13.4 39.2-17.7c12.8-4.2 26.6-7.8 41.5-10.7 14.9-2.9 27.6-4.8 38.2-5.7 10.6-.9 21.2-1.6 31.8-2v-39.4c0-13.5-2.3-23.5-6.7-30.1zm180.5 379.6c-2.8 3.3-7.5 7.8-14.1 13.5s-16.8 12.7-30.5 21.1c-13.7 8.4-28.8 16-45 22.9-16.3 6.9-36.3 12.9-60.1 18-23.7 5.1-48.2 7.6-73.3 7.6-25.4 0-50.7-3.2-76.1-9.6-25.4-6.4-47.6-14.3-66.8-23.7-19.1-9.4-37.6-20.2-55.1-32.2-17.6-12.1-31.7-22.9-42.4-32.5-10.6-9.6-19.6-18.7-26.8-27.1-1.7-1.9-2.8-3.6-3.2-5.1-.4-1.5-.3-2.8.3-3.7.6-.9 1.5-1.6 2.6-2.2a7.42 7.42 0 017.4.8c40.9 24.2 72.9 41.3 95.9 51.4 82.9 36.4 168 45.7 255.3 27.9 40.5-8.3 82.1-22.2 124.9-41.8 3.2-1.2 6-1.5 8.3-.9 2.3.6 3.5 2.4 3.5 5.4 0 2.8-1.6 6.3-4.8 10.2zm59.9-29c-1.8 11.1-4.9 21.6-9.1 31.8-7.2 17.1-16.3 30-27.1 38.4-3.6 2.9-6.4 3.8-8.3 2.8-1.9-1-1.9-3.5 0-7.4 4.5-9.3 9.2-21.8 14.2-37.7 5-15.8 5.7-26 2.1-30.5-1.1-1.5-2.7-2.6-5-3.6-2.2-.9-5.1-1.5-8.6-1.9s-6.7-.6-9.4-.8c-2.8-.2-6.5-.2-11.2 0-4.7.2-8 .4-10.1.6a874.4 874.4 0 01-17.1 1.5c-1.3.2-2.7.4-4.1.5-1.5.1-2.7.2-3.5.3l-2.7.3c-1 .1-1.7.2-2.2.2h-3.2l-1-.2-.6-.5-.5-.9c-1.3-3.3 3.7-7.4 15-12.4s22.3-8.1 32.9-9.3c9.8-1.5 21.3-1.5 34.5-.3s21.3 3.7 24.3 7.4c2.3 3.5 2.5 10.7.7 21.7z" } }] }, "name": "amazon-circle", "theme": "filled" };
	exports.default = AmazonCircleFilled;
	});

	var AmazonCircleFilledSvg = unwrapExports(AmazonCircleFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var AmazonCircleFilled = function AmazonCircleFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: AmazonCircleFilledSvg
	  }));
	};

	AmazonCircleFilled.displayName = 'AmazonCircleFilled';
	var AmazonCircleFilled$1 = /*#__PURE__*/React.forwardRef(AmazonCircleFilled);

	var AmazonOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var AmazonOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M825 768.9c-3.3-.9-7.3-.4-11.9 1.3-61.6 28.2-121.5 48.3-179.7 60.2C507.7 856 385.2 842.6 266 790.3c-33.1-14.6-79.1-39.2-138-74a9.36 9.36 0 00-5.3-2c-2-.1-3.7.1-5.3.9-1.6.8-2.8 1.8-3.7 3.1-.9 1.3-1.1 3.1-.4 5.4.6 2.2 2.1 4.7 4.6 7.4 10.4 12.2 23.3 25.2 38.6 39s35.6 29.4 60.9 46.8c25.3 17.4 51.8 32.9 79.3 46.4 27.6 13.5 59.6 24.9 96.1 34.1s73 13.8 109.4 13.8c36.2 0 71.4-3.7 105.5-10.9 34.2-7.3 63-15.9 86.5-25.9 23.4-9.9 45-21 64.8-33 19.8-12 34.4-22.2 43.9-30.3 9.5-8.2 16.3-14.6 20.2-19.4 4.6-5.7 6.9-10.6 6.9-14.9.1-4.5-1.7-7.1-5-7.9zM527.4 348.1c-15.2 1.3-33.5 4.1-55 8.3-21.5 4.1-41.4 9.3-59.8 15.4s-37.2 14.6-56.3 25.4c-19.2 10.8-35.5 23.2-49 37s-24.5 31.1-33.1 52c-8.6 20.8-12.9 43.7-12.9 68.7 0 27.1 4.7 51.2 14.3 72.5 9.5 21.3 22.2 38 38.2 50.4 15.9 12.4 34 22.1 54 29.2 20 7.1 41.2 10.3 63.2 9.4 22-.9 43.5-4.3 64.4-10.3 20.8-5.9 40.4-15.4 58.6-28.3 18.2-12.9 33.1-28.2 44.8-45.7 4.3 6.6 8.1 11.5 11.5 14.7l8.7 8.9c5.8 5.9 14.7 14.6 26.7 26.1 11.9 11.5 24.1 22.7 36.3 33.7l104.4-99.9-6-4.9c-4.3-3.3-9.4-8-15.2-14.3-5.8-6.2-11.6-13.1-17.2-20.5-5.7-7.4-10.6-16.1-14.7-25.9-4.1-9.8-6.2-19.3-6.2-28.5V258.7c0-10.1-1.9-21-5.7-32.8-3.9-11.7-10.7-24.5-20.7-38.3-10-13.8-22.4-26.2-37.2-37-14.9-10.8-34.7-20-59.6-27.4-24.8-7.4-52.6-11.1-83.2-11.1-31.3 0-60.4 3.7-87.6 10.9-27.1 7.3-50.3 17-69.7 29.2-19.3 12.2-35.9 26.3-49.7 42.4-13.8 16.1-24.1 32.9-30.8 50.4-6.7 17.5-10.1 35.2-10.1 53.1L408 310c5.5-16.4 12.9-30.6 22-42.8 9.2-12.2 17.9-21 25.8-26.5 8-5.5 16.6-9.9 25.7-13.2 9.2-3.3 15.4-5 18.6-5.4 3.2-.3 5.7-.4 7.6-.4 26.7 0 45.2 7.9 55.6 23.6 6.5 9.5 9.7 23.9 9.7 43.3v56.6c-15.2.6-30.4 1.6-45.6 2.9zM573.1 500c0 16.6-2.2 31.7-6.5 45-9.2 29.1-26.7 47.4-52.4 54.8-22.4 6.6-43.7 3.3-63.9-9.8-21.5-14-32.2-33.8-32.2-59.3 0-19.9 5-36.9 15-51.1 10-14.1 23.3-24.7 40-31.7s33-12 49-14.9c15.9-3 33-4.8 51-5.4V500zm335.2 218.9c-4.3-5.4-15.9-8.9-34.9-10.7-19-1.8-35.5-1.7-49.7.4-15.3 1.8-31.1 6.2-47.3 13.4-16.3 7.1-23.4 13.1-21.6 17.8l.7 1.3.9.7 1.4.2h4.6c.8 0 1.8-.1 3.2-.2 1.4-.1 2.7-.3 3.9-.4 1.2-.1 2.9-.3 5.1-.4 2.1-.1 4.1-.4 6-.7.3 0 3.7-.3 10.3-.9 6.6-.6 11.4-1 14.3-1.3 2.9-.3 7.8-.6 14.5-.9 6.7-.3 12.1-.3 16.1 0 4 .3 8.5.7 13.6 1.1 5.1.4 9.2 1.3 12.4 2.7 3.2 1.3 5.6 3 7.1 5.1 5.2 6.6 4.2 21.2-3 43.9s-14 40.8-20.4 54.2c-2.8 5.7-2.8 9.2 0 10.7s6.7.1 11.9-4c15.6-12.2 28.6-30.6 39.1-55.3 6.1-14.6 10.5-29.8 13.1-45.7 2.4-15.9 2-26.2-1.3-31z" } }] }, "name": "amazon", "theme": "outlined" };
	exports.default = AmazonOutlined;
	});

	var AmazonOutlinedSvg = unwrapExports(AmazonOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var AmazonOutlined = function AmazonOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: AmazonOutlinedSvg
	  }));
	};

	AmazonOutlined.displayName = 'AmazonOutlined';
	var AmazonOutlined$1 = /*#__PURE__*/React.forwardRef(AmazonOutlined);

	var AmazonSquareFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var AmazonSquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM547.8 326.7c-7.2-10.9-20.1-16.4-38.7-16.4-1.3 0-3 .1-5.3.3-2.2.2-6.6 1.5-12.9 3.7a79.4 79.4 0 00-17.9 9.1c-5.5 3.8-11.5 10-18 18.4-6.4 8.5-11.5 18.4-15.3 29.8l-94-8.4c0-12.4 2.4-24.7 7-36.9s11.8-23.9 21.4-35c9.6-11.2 21.1-21 34.5-29.4 13.4-8.5 29.6-15.2 48.4-20.3 18.9-5.1 39.1-7.6 60.9-7.6 21.3 0 40.6 2.6 57.8 7.7 17.2 5.2 31.1 11.5 41.4 19.1a117 117 0 0125.9 25.7c6.9 9.6 11.7 18.5 14.4 26.7 2.7 8.2 4 15.7 4 22.8v182.5c0 6.4 1.4 13 4.3 19.8 2.9 6.8 6.3 12.8 10.2 18 3.9 5.2 7.9 9.9 12 14.3 4.1 4.3 7.6 7.7 10.6 9.9l4.1 3.4-72.5 69.4c-8.5-7.7-16.9-15.4-25.2-23.4-8.3-8-14.5-14-18.5-18.1l-6.1-6.2c-2.4-2.3-5-5.7-8-10.2-8.1 12.2-18.5 22.8-31.1 31.8-12.7 9-26.3 15.6-40.7 19.7-14.5 4.1-29.4 6.5-44.7 7.1-15.3.6-30-1.5-43.9-6.5-13.9-5-26.5-11.7-37.6-20.3-11.1-8.6-19.9-20.2-26.5-35-6.6-14.8-9.9-31.5-9.9-50.4 0-17.4 3-33.3 8.9-47.7 6-14.5 13.6-26.5 23-36.1 9.4-9.6 20.7-18.2 34-25.7s26.4-13.4 39.2-17.7c12.8-4.2 26.6-7.8 41.5-10.7 14.9-2.9 27.6-4.8 38.2-5.7 10.6-.9 21.2-1.6 31.8-2v-39.4c0-13.5-2.3-23.5-6.7-30.1zm180.5 379.6c-2.8 3.3-7.5 7.8-14.1 13.5s-16.8 12.7-30.5 21.1c-13.7 8.4-28.8 16-45 22.9-16.3 6.9-36.3 12.9-60.1 18-23.7 5.1-48.2 7.6-73.3 7.6-25.4 0-50.7-3.2-76.1-9.6-25.4-6.4-47.6-14.3-66.8-23.7-19.1-9.4-37.6-20.2-55.1-32.2-17.6-12.1-31.7-22.9-42.4-32.5-10.6-9.6-19.6-18.7-26.8-27.1-1.7-1.9-2.8-3.6-3.2-5.1-.4-1.5-.3-2.8.3-3.7.6-.9 1.5-1.6 2.6-2.2a7.42 7.42 0 017.4.8c40.9 24.2 72.9 41.3 95.9 51.4 82.9 36.4 168 45.7 255.3 27.9 40.5-8.3 82.1-22.2 124.9-41.8 3.2-1.2 6-1.5 8.3-.9 2.3.6 3.5 2.4 3.5 5.4 0 2.8-1.6 6.3-4.8 10.2zm59.9-29c-1.8 11.1-4.9 21.6-9.1 31.8-7.2 17.1-16.3 30-27.1 38.4-3.6 2.9-6.4 3.8-8.3 2.8-1.9-1-1.9-3.5 0-7.4 4.5-9.3 9.2-21.8 14.2-37.7 5-15.8 5.7-26 2.1-30.5-1.1-1.5-2.7-2.6-5-3.6-2.2-.9-5.1-1.5-8.6-1.9s-6.7-.6-9.4-.8c-2.8-.2-6.5-.2-11.2 0-4.7.2-8 .4-10.1.6a874.4 874.4 0 01-17.1 1.5c-1.3.2-2.7.4-4.1.5-1.5.1-2.7.2-3.5.3l-2.7.3c-1 .1-1.7.2-2.2.2h-3.2l-1-.2-.6-.5-.5-.9c-1.3-3.3 3.7-7.4 15-12.4s22.3-8.1 32.9-9.3c9.8-1.5 21.3-1.5 34.5-.3s21.3 3.7 24.3 7.4c2.3 3.5 2.5 10.7.7 21.7zM485 467.5c-11.6 4.9-20.9 12.2-27.8 22-6.9 9.8-10.4 21.6-10.4 35.5 0 17.8 7.5 31.5 22.4 41.2 14.1 9.1 28.9 11.4 44.4 6.8 17.9-5.2 30-17.9 36.4-38.1 3-9.3 4.5-19.7 4.5-31.3v-50.2c-12.6.4-24.4 1.6-35.5 3.7-11.1 2.1-22.4 5.6-34 10.4z" } }] }, "name": "amazon-square", "theme": "filled" };
	exports.default = AmazonSquareFilled;
	});

	var AmazonSquareFilledSvg = unwrapExports(AmazonSquareFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var AmazonSquareFilled = function AmazonSquareFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: AmazonSquareFilledSvg
	  }));
	};

	AmazonSquareFilled.displayName = 'AmazonSquareFilled';
	var AmazonSquareFilled$1 = /*#__PURE__*/React.forwardRef(AmazonSquareFilled);

	var AndroidFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var AndroidFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M270.1 741.7c0 23.4 19.1 42.5 42.6 42.5h48.7v120.4c0 30.5 24.5 55.4 54.6 55.4 30.2 0 54.6-24.8 54.6-55.4V784.1h85v120.4c0 30.5 24.5 55.4 54.6 55.4 30.2 0 54.6-24.8 54.6-55.4V784.1h48.7c23.5 0 42.6-19.1 42.6-42.5V346.4h-486v395.3zm357.1-600.1l44.9-65c2.6-3.8 2-8.9-1.5-11.4-3.5-2.4-8.5-1.2-11.1 2.6l-46.6 67.6c-30.7-12.1-64.9-18.8-100.8-18.8-35.9 0-70.1 6.7-100.8 18.8l-46.6-67.5c-2.6-3.8-7.6-5.1-11.1-2.6-3.5 2.4-4.1 7.4-1.5 11.4l44.9 65c-71.4 33.2-121.4 96.1-127.8 169.6h486c-6.6-73.6-56.7-136.5-128-169.7zM409.5 244.1a26.9 26.9 0 1126.9-26.9 26.97 26.97 0 01-26.9 26.9zm208.4 0a26.9 26.9 0 1126.9-26.9 26.97 26.97 0 01-26.9 26.9zm223.4 100.7c-30.2 0-54.6 24.8-54.6 55.4v216.4c0 30.5 24.5 55.4 54.6 55.4 30.2 0 54.6-24.8 54.6-55.4V400.1c.1-30.6-24.3-55.3-54.6-55.3zm-658.6 0c-30.2 0-54.6 24.8-54.6 55.4v216.4c0 30.5 24.5 55.4 54.6 55.4 30.2 0 54.6-24.8 54.6-55.4V400.1c0-30.6-24.5-55.3-54.6-55.3z" } }] }, "name": "android", "theme": "filled" };
	exports.default = AndroidFilled;
	});

	var AndroidFilledSvg = unwrapExports(AndroidFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var AndroidFilled = function AndroidFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: AndroidFilledSvg
	  }));
	};

	AndroidFilled.displayName = 'AndroidFilled';
	var AndroidFilled$1 = /*#__PURE__*/React.forwardRef(AndroidFilled);

	var AndroidOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var AndroidOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M448.3 225.2c-18.6 0-32 13.4-32 31.9s13.5 31.9 32 31.9c18.6 0 32-13.4 32-31.9.1-18.4-13.4-31.9-32-31.9zm393.9 96.4c-13.8-13.8-32.7-21.5-53.2-21.5-3.9 0-7.4.4-10.7 1v-1h-3.6c-5.5-30.6-18.6-60.5-38.1-87.4-18.7-25.7-43-47.9-70.8-64.9l25.1-35.8v-3.3c0-.8.4-2.3.7-3.8.6-2.4 1.4-5.5 1.4-8.9 0-18.5-13.5-31.9-32-31.9-9.8 0-19.5 5.7-25.9 15.4l-29.3 42.1c-30-9.8-62.4-15-93.8-15-31.3 0-63.7 5.2-93.8 15L389 79.4c-6.6-9.6-16.1-15.4-26-15.4-18.6 0-32 13.4-32 31.9 0 6.2 2.5 12.8 6.7 17.4l22.6 32.3c-28.7 17-53.5 39.4-72.2 65.1-19.4 26.9-32 56.8-36.7 87.4h-5.5v1c-3.2-.6-6.7-1-10.7-1-20.3 0-39.2 7.5-53.1 21.3-13.8 13.8-21.5 32.6-21.5 53v235c0 20.3 7.5 39.1 21.4 52.9 13.8 13.8 32.8 21.5 53.2 21.5 3.9 0 7.4-.4 10.7-1v93.5c0 29.2 23.9 53.1 53.2 53.1H331v58.3c0 20.3 7.5 39.1 21.4 52.9 13.8 13.8 32.8 21.5 53.2 21.5 20.3 0 39.2-7.5 53.1-21.3 13.8-13.8 21.5-32.6 21.5-53v-58.2H544v58.1c0 20.3 7.5 39.1 21.4 52.9 13.8 13.8 32.8 21.5 53.2 21.5 20.4 0 39.2-7.5 53.1-21.6 13.8-13.8 21.5-32.6 21.5-53v-58.2h31.9c29.3 0 53.2-23.8 53.2-53.1v-91.4c3.2.6 6.7 1 10.7 1 20.3 0 39.2-7.5 53.1-21.3 13.8-13.8 21.5-32.6 21.5-53v-235c-.1-20.3-7.6-39-21.4-52.9zM246 609.6c0 6.8-3.9 10.6-10.7 10.6-6.8 0-10.7-3.8-10.7-10.6V374.5c0-6.8 3.9-10.6 10.7-10.6 6.8 0 10.7 3.8 10.7 10.6v235.1zm131.1-396.8c37.5-27.3 85.3-42.3 135-42.3s97.5 15.1 135 42.5c32.4 23.7 54.2 54.2 62.7 87.5H314.4c8.5-33.4 30.5-64 62.7-87.7zm39.3 674.7c-.6 5.6-4.4 8.7-10.5 8.7-6.8 0-10.7-3.8-10.7-10.6v-58.2h21.2v60.1zm202.3 8.7c-6.8 0-10.7-3.8-10.7-10.6v-58.2h21.2v60.1c-.6 5.6-4.3 8.7-10.5 8.7zm95.8-132.6H309.9V364h404.6v399.6zm85.2-154c0 6.8-3.9 10.6-10.7 10.6-6.8 0-10.7-3.8-10.7-10.6V374.5c0-6.8 3.9-10.6 10.7-10.6 6.8 0 10.7 3.8 10.7 10.6v235.1zM576.1 225.2c-18.6 0-32 13.4-32 31.9s13.5 31.9 32 31.9c18.6 0 32.1-13.4 32.1-32-.1-18.6-13.4-31.8-32.1-31.8z" } }] }, "name": "android", "theme": "outlined" };
	exports.default = AndroidOutlined;
	});

	var AndroidOutlinedSvg = unwrapExports(AndroidOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var AndroidOutlined = function AndroidOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: AndroidOutlinedSvg
	  }));
	};

	AndroidOutlined.displayName = 'AndroidOutlined';
	var AndroidOutlined$1 = /*#__PURE__*/React.forwardRef(AndroidOutlined);

	var AntCloudOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var AntCloudOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M378.9 738c-3.1 0-6.1-.5-8.8-1.5l4.4 30.7h26.3l-15.5-29.9c-2.1.5-4.2.7-6.4.7zm421-291.2c-12.6 0-24.8 1.5-36.5 4.2-21.4-38.4-62.3-64.3-109.3-64.3-6.9 0-13.6.6-20.2 1.6-35.4-77.4-113.4-131.1-203.9-131.1-112.3 0-205.3 82.6-221.6 190.4C127.3 455.5 64 523.8 64 607c0 88.4 71.6 160.1 160 160.2h50l13.2-27.6c-26.2-8.3-43.3-29-39.1-48.8 4.6-21.6 32.8-33.9 63.1-27.5 22.9 4.9 40.4 19.1 45.5 35.1a26.1 26.1 0 0122.1-12.4h.2c-.8-3.2-1.2-6.5-1.2-9.9 0-20.1 14.8-36.7 34.1-39.6v-25.4c0-4.4 3.6-8 8-8s8 3.6 8 8v26.3c4.6 1.2 8.8 3.2 12.6 5.8l19.5-21.4c3-3.3 8-3.5 11.3-.5 3.3 3 3.5 8 .5 11.3l-20 22-.2.2a40 40 0 01-46.9 59.2c-.4 5.6-2.6 10.7-6 14.8l20 38.4H804v-.1c86.5-2.2 156-73 156-160.1 0-88.5-71.7-160.2-160.1-160.2zM338.2 737.2l-4.3 30h24.4l-5.9-41.5c-3.5 4.6-8.3 8.5-14.2 11.5zM797.5 305a48 48 0 1096 0 48 48 0 10-96 0zm-65.7 61.3a24 24 0 1048 0 24 24 0 10-48 0zM303.4 742.9l-11.6 24.3h26l3.5-24.7c-5.7.8-11.7 1-17.9.4z" } }] }, "name": "ant-cloud", "theme": "outlined" };
	exports.default = AntCloudOutlined;
	});

	var AntCloudOutlinedSvg = unwrapExports(AntCloudOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var AntCloudOutlined = function AntCloudOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: AntCloudOutlinedSvg
	  }));
	};

	AntCloudOutlined.displayName = 'AntCloudOutlined';
	var AntCloudOutlined$1 = /*#__PURE__*/React.forwardRef(AntCloudOutlined);

	var AntDesignOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var AntDesignOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M716.3 313.8c19-18.9 19-49.7 0-68.6l-69.9-69.9.1.1c-18.5-18.5-50.3-50.3-95.3-95.2-21.2-20.7-55.5-20.5-76.5.5L80.9 474.2a53.84 53.84 0 000 76.4L474.6 944a54.14 54.14 0 0076.5 0l165.1-165c19-18.9 19-49.7 0-68.6a48.7 48.7 0 00-68.7 0l-125 125.2c-5.2 5.2-13.3 5.2-18.5 0L189.5 521.4c-5.2-5.2-5.2-13.3 0-18.5l314.4-314.2c.4-.4.9-.7 1.3-1.1 5.2-4.1 12.4-3.7 17.2 1.1l125.2 125.1c19 19 49.8 19 68.7 0zM408.6 514.4a106.3 106.2 0 10212.6 0 106.3 106.2 0 10-212.6 0zm536.2-38.6L821.9 353.5c-19-18.9-49.8-18.9-68.7.1a48.4 48.4 0 000 68.6l83 82.9c5.2 5.2 5.2 13.3 0 18.5l-81.8 81.7a48.4 48.4 0 000 68.6 48.7 48.7 0 0068.7 0l121.8-121.7a53.93 53.93 0 00-.1-76.4z" } }] }, "name": "ant-design", "theme": "outlined" };
	exports.default = AntDesignOutlined;
	});

	var AntDesignOutlinedSvg = unwrapExports(AntDesignOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var AntDesignOutlined = function AntDesignOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: AntDesignOutlinedSvg
	  }));
	};

	AntDesignOutlined.displayName = 'AntDesignOutlined';
	var AntDesignOutlined$1 = /*#__PURE__*/React.forwardRef(AntDesignOutlined);

	var ApartmentOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ApartmentOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M908 640H804V488c0-4.4-3.6-8-8-8H548v-96h108c8.8 0 16-7.2 16-16V80c0-8.8-7.2-16-16-16H368c-8.8 0-16 7.2-16 16v288c0 8.8 7.2 16 16 16h108v96H228c-4.4 0-8 3.6-8 8v152H116c-8.8 0-16 7.2-16 16v288c0 8.8 7.2 16 16 16h288c8.8 0 16-7.2 16-16V656c0-8.8-7.2-16-16-16H292v-88h440v88H620c-8.8 0-16 7.2-16 16v288c0 8.8 7.2 16 16 16h288c8.8 0 16-7.2 16-16V656c0-8.8-7.2-16-16-16zm-564 76v168H176V716h168zm84-408V140h168v168H428zm420 576H680V716h168v168z" } }] }, "name": "apartment", "theme": "outlined" };
	exports.default = ApartmentOutlined;
	});

	var ApartmentOutlinedSvg = unwrapExports(ApartmentOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var ApartmentOutlined = function ApartmentOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ApartmentOutlinedSvg
	  }));
	};

	ApartmentOutlined.displayName = 'ApartmentOutlined';
	var ApartmentOutlined$1 = /*#__PURE__*/React.forwardRef(ApartmentOutlined);

	var ApiFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ApiFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M917.7 148.8l-42.4-42.4c-1.6-1.6-3.6-2.3-5.7-2.3s-4.1.8-5.7 2.3l-76.1 76.1a199.27 199.27 0 00-112.1-34.3c-51.2 0-102.4 19.5-141.5 58.6L432.3 308.7a8.03 8.03 0 000 11.3L704 591.7c1.6 1.6 3.6 2.3 5.7 2.3 2 0 4.1-.8 5.7-2.3l101.9-101.9c68.9-69 77-175.7 24.3-253.5l76.1-76.1c3.1-3.2 3.1-8.3 0-11.4zM578.9 546.7a8.03 8.03 0 00-11.3 0L501 613.3 410.7 523l66.7-66.7c3.1-3.1 3.1-8.2 0-11.3L441 408.6a8.03 8.03 0 00-11.3 0L363 475.3l-43-43a7.85 7.85 0 00-5.7-2.3c-2 0-4.1.8-5.7 2.3L206.8 534.2c-68.9 68.9-77 175.7-24.3 253.5l-76.1 76.1a8.03 8.03 0 000 11.3l42.4 42.4c1.6 1.6 3.6 2.3 5.7 2.3s4.1-.8 5.7-2.3l76.1-76.1c33.7 22.9 72.9 34.3 112.1 34.3 51.2 0 102.4-19.5 141.5-58.6l101.9-101.9c3.1-3.1 3.1-8.2 0-11.3l-43-43 66.7-66.7c3.1-3.1 3.1-8.2 0-11.3l-36.6-36.2z" } }] }, "name": "api", "theme": "filled" };
	exports.default = ApiFilled;
	});

	var ApiFilledSvg = unwrapExports(ApiFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var ApiFilled = function ApiFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ApiFilledSvg
	  }));
	};

	ApiFilled.displayName = 'ApiFilled';
	var ApiFilled$1 = /*#__PURE__*/React.forwardRef(ApiFilled);

	var ApiOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ApiOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M917.7 148.8l-42.4-42.4c-1.6-1.6-3.6-2.3-5.7-2.3s-4.1.8-5.7 2.3l-76.1 76.1a199.27 199.27 0 00-112.1-34.3c-51.2 0-102.4 19.5-141.5 58.6L432.3 308.7a8.03 8.03 0 000 11.3L704 591.7c1.6 1.6 3.6 2.3 5.7 2.3 2 0 4.1-.8 5.7-2.3l101.9-101.9c68.9-69 77-175.7 24.3-253.5l76.1-76.1c3.1-3.2 3.1-8.3 0-11.4zM769.1 441.7l-59.4 59.4-186.8-186.8 59.4-59.4c24.9-24.9 58.1-38.7 93.4-38.7 35.3 0 68.4 13.7 93.4 38.7 24.9 24.9 38.7 58.1 38.7 93.4 0 35.3-13.8 68.4-38.7 93.4zm-190.2 105a8.03 8.03 0 00-11.3 0L501 613.3 410.7 523l66.7-66.7c3.1-3.1 3.1-8.2 0-11.3L441 408.6a8.03 8.03 0 00-11.3 0L363 475.3l-43-43a7.85 7.85 0 00-5.7-2.3c-2 0-4.1.8-5.7 2.3L206.8 534.2c-68.9 69-77 175.7-24.3 253.5l-76.1 76.1a8.03 8.03 0 000 11.3l42.4 42.4c1.6 1.6 3.6 2.3 5.7 2.3s4.1-.8 5.7-2.3l76.1-76.1c33.7 22.9 72.9 34.3 112.1 34.3 51.2 0 102.4-19.5 141.5-58.6l101.9-101.9c3.1-3.1 3.1-8.2 0-11.3l-43-43 66.7-66.7c3.1-3.1 3.1-8.2 0-11.3l-36.6-36.2zM441.7 769.1a131.32 131.32 0 01-93.4 38.7c-35.3 0-68.4-13.7-93.4-38.7a131.32 131.32 0 01-38.7-93.4c0-35.3 13.7-68.4 38.7-93.4l59.4-59.4 186.8 186.8-59.4 59.4z" } }] }, "name": "api", "theme": "outlined" };
	exports.default = ApiOutlined;
	});

	var ApiOutlinedSvg = unwrapExports(ApiOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var ApiOutlined = function ApiOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ApiOutlinedSvg
	  }));
	};

	ApiOutlined.displayName = 'ApiOutlined';
	var ApiOutlined$1 = /*#__PURE__*/React.forwardRef(ApiOutlined);

	var ApiTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ApiTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M148.2 674.6zm106.7-92.3c-25 25-38.7 58.1-38.7 93.4s13.8 68.5 38.7 93.4c25 25 58.1 38.7 93.4 38.7 35.3 0 68.5-13.8 93.4-38.7l59.4-59.4-186.8-186.8-59.4 59.4zm420.8-366.1c-35.3 0-68.5 13.8-93.4 38.7l-59.4 59.4 186.8 186.8 59.4-59.4c24.9-25 38.7-58.1 38.7-93.4s-13.8-68.5-38.7-93.4c-25-25-58.1-38.7-93.4-38.7z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M578.9 546.7a8.03 8.03 0 00-11.3 0L501 613.3 410.7 523l66.7-66.7c3.1-3.1 3.1-8.2 0-11.3L441 408.6a8.03 8.03 0 00-11.3 0L363 475.3l-43-43a7.85 7.85 0 00-5.7-2.3c-2 0-4.1.8-5.7 2.3L206.8 534.2a199.45 199.45 0 00-58.6 140.4c-.2 39.5 11.2 79.1 34.3 113.1l-76.1 76.1a8.03 8.03 0 000 11.3l42.4 42.4c1.6 1.6 3.6 2.3 5.7 2.3s4.1-.8 5.7-2.3l76.1-76.1c33.7 22.9 72.9 34.3 112.1 34.3 51.2 0 102.4-19.5 141.5-58.6l101.9-101.9c3.1-3.1 3.1-8.2 0-11.3l-43-43 66.7-66.7c3.1-3.1 3.1-8.2 0-11.3l-36.6-36.2zM441.7 769.1a131.32 131.32 0 01-93.4 38.7c-35.3 0-68.4-13.7-93.4-38.7-24.9-24.9-38.7-58.1-38.7-93.4s13.7-68.4 38.7-93.4l59.4-59.4 186.8 186.8-59.4 59.4zm476-620.3l-42.4-42.4c-1.6-1.6-3.6-2.3-5.7-2.3s-4.1.8-5.7 2.3l-76.1 76.1a199.27 199.27 0 00-112.1-34.3c-51.2 0-102.4 19.5-141.5 58.6L432.3 308.7a8.03 8.03 0 000 11.3L704 591.7c1.6 1.6 3.6 2.3 5.7 2.3 2 0 4.1-.8 5.7-2.3l101.9-101.9c68.9-69 77-175.7 24.3-253.5l76.1-76.1c3.1-3.2 3.1-8.3 0-11.4zM769.1 441.7l-59.4 59.4-186.8-186.8 59.4-59.4c24.9-24.9 58.1-38.7 93.4-38.7s68.4 13.7 93.4 38.7c24.9 24.9 38.7 58.1 38.7 93.4s-13.8 68.4-38.7 93.4z", "fill": primaryColor } }] }; }, "name": "api", "theme": "twotone" };
	exports.default = ApiTwoTone;
	});

	var ApiTwoToneSvg = unwrapExports(ApiTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var ApiTwoTone = function ApiTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ApiTwoToneSvg
	  }));
	};

	ApiTwoTone.displayName = 'ApiTwoTone';
	var ApiTwoTone$1 = /*#__PURE__*/React.forwardRef(ApiTwoTone);

	var AppleFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var AppleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M747.4 535.7c-.4-68.2 30.5-119.6 92.9-157.5-34.9-50-87.7-77.5-157.3-82.8-65.9-5.2-138 38.4-164.4 38.4-27.9 0-91.7-36.6-141.9-36.6C273.1 298.8 163 379.8 163 544.6c0 48.7 8.9 99 26.7 150.8 23.8 68.2 109.6 235.3 199.1 232.6 46.8-1.1 79.9-33.2 140.8-33.2 59.1 0 89.7 33.2 141.9 33.2 90.3-1.3 167.9-153.2 190.5-221.6-121.1-57.1-114.6-167.2-114.6-170.7zm-105.1-305c50.7-60.2 46.1-115 44.6-134.7-44.8 2.6-96.6 30.5-126.1 64.8-32.5 36.8-51.6 82.3-47.5 133.6 48.4 3.7 92.6-21.2 129-63.7z" } }] }, "name": "apple", "theme": "filled" };
	exports.default = AppleFilled;
	});

	var AppleFilledSvg = unwrapExports(AppleFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var AppleFilled = function AppleFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: AppleFilledSvg
	  }));
	};

	AppleFilled.displayName = 'AppleFilled';
	var AppleFilled$1 = /*#__PURE__*/React.forwardRef(AppleFilled);

	var AppleOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var AppleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M747.4 535.7c-.4-68.2 30.5-119.6 92.9-157.5-34.9-50-87.7-77.5-157.3-82.8-65.9-5.2-138 38.4-164.4 38.4-27.9 0-91.7-36.6-141.9-36.6C273.1 298.8 163 379.8 163 544.6c0 48.7 8.9 99 26.7 150.8 23.8 68.2 109.6 235.3 199.1 232.6 46.8-1.1 79.9-33.2 140.8-33.2 59.1 0 89.7 33.2 141.9 33.2 90.3-1.3 167.9-153.2 190.5-221.6-121.1-57.1-114.6-167.2-114.6-170.7zm-10.6 267c-14.3 19.9-28.7 35.6-41.9 45.7-10.5 8-18.6 11.4-24 11.6-9-.1-17.7-2.3-34.7-8.8-1.2-.5-2.5-1-4.2-1.6l-4.4-1.7c-17.4-6.7-27.8-10.3-41.1-13.8-18.6-4.8-37.1-7.4-56.9-7.4-20.2 0-39.2 2.5-58.1 7.2-13.9 3.5-25.6 7.4-42.7 13.8-.7.3-8.1 3.1-10.2 3.9-3.5 1.3-6.2 2.3-8.7 3.2-10.4 3.6-17 5.1-22.9 5.2-.7 0-1.3-.1-1.8-.2-1.1-.2-2.5-.6-4.1-1.3-4.5-1.8-9.9-5.1-16-9.8-14-10.9-29.4-28-45.1-49.9-27.5-38.6-53.5-89.8-66-125.7-15.4-44.8-23-87.7-23-128.6 0-60.2 17.8-106 48.4-137.1 26.3-26.6 61.7-41.5 97.8-42.3 5.9.1 14.5 1.5 25.4 4.5 8.6 2.3 18 5.4 30.7 9.9 3.8 1.4 16.9 6.1 18.5 6.7 7.7 2.8 13.5 4.8 19.2 6.6 18.2 5.8 32.3 9 47.6 9 15.5 0 28.8-3.3 47.7-9.8 7.1-2.4 32.9-12 37.5-13.6 25.6-9.1 44.5-14 60.8-15.2 4.8-.4 9.1-.4 13.2-.1 22.7 1.8 42.1 6.3 58.6 13.8-37.6 43.4-57 96.5-56.9 158.4-.3 14.7.9 31.7 5.1 51.8 6.4 30.5 18.6 60.7 37.9 89 14.7 21.5 32.9 40.9 54.7 57.8-11.5 23.7-25.6 48.2-40.4 68.8zm-94.5-572c50.7-60.2 46.1-115 44.6-134.7-44.8 2.6-96.6 30.5-126.1 64.8-32.5 36.8-51.6 82.3-47.5 133.6 48.4 3.7 92.6-21.2 129-63.7z" } }] }, "name": "apple", "theme": "outlined" };
	exports.default = AppleOutlined;
	});

	var AppleOutlinedSvg = unwrapExports(AppleOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var AppleOutlined = function AppleOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: AppleOutlinedSvg
	  }));
	};

	AppleOutlined.displayName = 'AppleOutlined';
	var AppleOutlined$1 = /*#__PURE__*/React.forwardRef(AppleOutlined);

	var AppstoreAddOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var AppstoreAddOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M464 144H160c-8.8 0-16 7.2-16 16v304c0 8.8 7.2 16 16 16h304c8.8 0 16-7.2 16-16V160c0-8.8-7.2-16-16-16zm-52 268H212V212h200v200zm452-268H560c-8.8 0-16 7.2-16 16v304c0 8.8 7.2 16 16 16h304c8.8 0 16-7.2 16-16V160c0-8.8-7.2-16-16-16zm-52 268H612V212h200v200zm52 132H560c-8.8 0-16 7.2-16 16v304c0 8.8 7.2 16 16 16h304c8.8 0 16-7.2 16-16V560c0-8.8-7.2-16-16-16zm-52 268H612V612h200v200zM424 712H296V584c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v128H104c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h128v128c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V776h128c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8z" } }] }, "name": "appstore-add", "theme": "outlined" };
	exports.default = AppstoreAddOutlined;
	});

	var AppstoreAddOutlinedSvg = unwrapExports(AppstoreAddOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var AppstoreAddOutlined = function AppstoreAddOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: AppstoreAddOutlinedSvg
	  }));
	};

	AppstoreAddOutlined.displayName = 'AppstoreAddOutlined';
	var AppstoreAddOutlined$1 = /*#__PURE__*/React.forwardRef(AppstoreAddOutlined);

	var AppstoreFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var AppstoreFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M864 144H560c-8.8 0-16 7.2-16 16v304c0 8.8 7.2 16 16 16h304c8.8 0 16-7.2 16-16V160c0-8.8-7.2-16-16-16zm0 400H560c-8.8 0-16 7.2-16 16v304c0 8.8 7.2 16 16 16h304c8.8 0 16-7.2 16-16V560c0-8.8-7.2-16-16-16zM464 144H160c-8.8 0-16 7.2-16 16v304c0 8.8 7.2 16 16 16h304c8.8 0 16-7.2 16-16V160c0-8.8-7.2-16-16-16zm0 400H160c-8.8 0-16 7.2-16 16v304c0 8.8 7.2 16 16 16h304c8.8 0 16-7.2 16-16V560c0-8.8-7.2-16-16-16z" } }] }, "name": "appstore", "theme": "filled" };
	exports.default = AppstoreFilled;
	});

	var AppstoreFilledSvg = unwrapExports(AppstoreFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var AppstoreFilled = function AppstoreFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: AppstoreFilledSvg
	  }));
	};

	AppstoreFilled.displayName = 'AppstoreFilled';
	var AppstoreFilled$1 = /*#__PURE__*/React.forwardRef(AppstoreFilled);

	var AppstoreOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var AppstoreOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M464 144H160c-8.8 0-16 7.2-16 16v304c0 8.8 7.2 16 16 16h304c8.8 0 16-7.2 16-16V160c0-8.8-7.2-16-16-16zm-52 268H212V212h200v200zm452-268H560c-8.8 0-16 7.2-16 16v304c0 8.8 7.2 16 16 16h304c8.8 0 16-7.2 16-16V160c0-8.8-7.2-16-16-16zm-52 268H612V212h200v200zM464 544H160c-8.8 0-16 7.2-16 16v304c0 8.8 7.2 16 16 16h304c8.8 0 16-7.2 16-16V560c0-8.8-7.2-16-16-16zm-52 268H212V612h200v200zm452-268H560c-8.8 0-16 7.2-16 16v304c0 8.8 7.2 16 16 16h304c8.8 0 16-7.2 16-16V560c0-8.8-7.2-16-16-16zm-52 268H612V612h200v200z" } }] }, "name": "appstore", "theme": "outlined" };
	exports.default = AppstoreOutlined;
	});

	var AppstoreOutlinedSvg = unwrapExports(AppstoreOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var AppstoreOutlined = function AppstoreOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: AppstoreOutlinedSvg
	  }));
	};

	AppstoreOutlined.displayName = 'AppstoreOutlined';
	var AppstoreOutlined$1 = /*#__PURE__*/React.forwardRef(AppstoreOutlined);

	var AppstoreTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var AppstoreTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M864 144H560c-8.8 0-16 7.2-16 16v304c0 8.8 7.2 16 16 16h304c8.8 0 16-7.2 16-16V160c0-8.8-7.2-16-16-16zm-52 268H612V212h200v200zM464 544H160c-8.8 0-16 7.2-16 16v304c0 8.8 7.2 16 16 16h304c8.8 0 16-7.2 16-16V560c0-8.8-7.2-16-16-16zm-52 268H212V612h200v200zm52-668H160c-8.8 0-16 7.2-16 16v304c0 8.8 7.2 16 16 16h304c8.8 0 16-7.2 16-16V160c0-8.8-7.2-16-16-16zm-52 268H212V212h200v200zm452 132H560c-8.8 0-16 7.2-16 16v304c0 8.8 7.2 16 16 16h304c8.8 0 16-7.2 16-16V560c0-8.8-7.2-16-16-16zm-52 268H612V612h200v200z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M212 212h200v200H212zm400 0h200v200H612zM212 612h200v200H212zm400 0h200v200H612z", "fill": secondaryColor } }] }; }, "name": "appstore", "theme": "twotone" };
	exports.default = AppstoreTwoTone;
	});

	var AppstoreTwoToneSvg = unwrapExports(AppstoreTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var AppstoreTwoTone = function AppstoreTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: AppstoreTwoToneSvg
	  }));
	};

	AppstoreTwoTone.displayName = 'AppstoreTwoTone';
	var AppstoreTwoTone$1 = /*#__PURE__*/React.forwardRef(AppstoreTwoTone);

	var AreaChartOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var AreaChartOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M888 792H200V168c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v688c0 4.4 3.6 8 8 8h752c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-616-64h536c4.4 0 8-3.6 8-8V284c0-7.2-8.7-10.7-13.7-5.7L592 488.6l-125.4-124a8.03 8.03 0 00-11.3 0l-189 189.6a7.87 7.87 0 00-2.3 5.6V720c0 4.4 3.6 8 8 8z" } }] }, "name": "area-chart", "theme": "outlined" };
	exports.default = AreaChartOutlined;
	});

	var AreaChartOutlinedSvg = unwrapExports(AreaChartOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var AreaChartOutlined = function AreaChartOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: AreaChartOutlinedSvg
	  }));
	};

	AreaChartOutlined.displayName = 'AreaChartOutlined';
	var AreaChartOutlined$1 = /*#__PURE__*/React.forwardRef(AreaChartOutlined);

	var ArrowDownOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ArrowDownOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M862 465.3h-81c-4.6 0-9 2-12.1 5.5L550 723.1V160c0-4.4-3.6-8-8-8h-60c-4.4 0-8 3.6-8 8v563.1L255.1 470.8c-3-3.5-7.4-5.5-12.1-5.5h-81c-6.8 0-10.5 8.1-6 13.2L487.9 861a31.96 31.96 0 0048.3 0L868 478.5c4.5-5.2.8-13.2-6-13.2z" } }] }, "name": "arrow-down", "theme": "outlined" };
	exports.default = ArrowDownOutlined;
	});

	var ArrowDownOutlinedSvg = unwrapExports(ArrowDownOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var ArrowDownOutlined = function ArrowDownOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ArrowDownOutlinedSvg
	  }));
	};

	ArrowDownOutlined.displayName = 'ArrowDownOutlined';
	var ArrowDownOutlined$1 = /*#__PURE__*/React.forwardRef(ArrowDownOutlined);

	var ArrowLeftOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ArrowLeftOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M872 474H286.9l350.2-304c5.6-4.9 2.2-14-5.2-14h-88.5c-3.9 0-7.6 1.4-10.5 3.9L155 487.8a31.96 31.96 0 000 48.3L535.1 866c1.5 1.3 3.3 2 5.2 2h91.5c7.4 0 10.8-9.2 5.2-14L286.9 550H872c4.4 0 8-3.6 8-8v-60c0-4.4-3.6-8-8-8z" } }] }, "name": "arrow-left", "theme": "outlined" };
	exports.default = ArrowLeftOutlined;
	});

	var ArrowLeftOutlinedSvg = unwrapExports(ArrowLeftOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var ArrowLeftOutlined = function ArrowLeftOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ArrowLeftOutlinedSvg
	  }));
	};

	ArrowLeftOutlined.displayName = 'ArrowLeftOutlined';
	var ArrowLeftOutlined$1 = /*#__PURE__*/React.forwardRef(ArrowLeftOutlined);

	var ArrowRightOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ArrowRightOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M869 487.8L491.2 159.9c-2.9-2.5-6.6-3.9-10.5-3.9h-88.5c-7.4 0-10.8 9.2-5.2 14l350.2 304H152c-4.4 0-8 3.6-8 8v60c0 4.4 3.6 8 8 8h585.1L386.9 854c-5.6 4.9-2.2 14 5.2 14h91.5c1.9 0 3.8-.7 5.2-2L869 536.2a32.07 32.07 0 000-48.4z" } }] }, "name": "arrow-right", "theme": "outlined" };
	exports.default = ArrowRightOutlined;
	});

	var ArrowRightOutlinedSvg = unwrapExports(ArrowRightOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var ArrowRightOutlined = function ArrowRightOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ArrowRightOutlinedSvg
	  }));
	};

	ArrowRightOutlined.displayName = 'ArrowRightOutlined';
	var ArrowRightOutlined$1 = /*#__PURE__*/React.forwardRef(ArrowRightOutlined);

	var ArrowUpOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ArrowUpOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M868 545.5L536.1 163a31.96 31.96 0 00-48.3 0L156 545.5a7.97 7.97 0 006 13.2h81c4.6 0 9-2 12.1-5.5L474 300.9V864c0 4.4 3.6 8 8 8h60c4.4 0 8-3.6 8-8V300.9l218.9 252.3c3 3.5 7.4 5.5 12.1 5.5h81c6.8 0 10.5-8 6-13.2z" } }] }, "name": "arrow-up", "theme": "outlined" };
	exports.default = ArrowUpOutlined;
	});

	var ArrowUpOutlinedSvg = unwrapExports(ArrowUpOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var ArrowUpOutlined = function ArrowUpOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ArrowUpOutlinedSvg
	  }));
	};

	ArrowUpOutlined.displayName = 'ArrowUpOutlined';
	var ArrowUpOutlined$1 = /*#__PURE__*/React.forwardRef(ArrowUpOutlined);

	var ArrowsAltOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ArrowsAltOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M855 160.1l-189.2 23.5c-6.6.8-9.3 8.8-4.7 13.5l54.7 54.7-153.5 153.5a8.03 8.03 0 000 11.3l45.1 45.1c3.1 3.1 8.2 3.1 11.3 0l153.6-153.6 54.7 54.7a7.94 7.94 0 0013.5-4.7L863.9 169a7.9 7.9 0 00-8.9-8.9zM416.6 562.3a8.03 8.03 0 00-11.3 0L251.8 715.9l-54.7-54.7a7.94 7.94 0 00-13.5 4.7L160.1 855c-.6 5.2 3.7 9.5 8.9 8.9l189.2-23.5c6.6-.8 9.3-8.8 4.7-13.5l-54.7-54.7 153.6-153.6c3.1-3.1 3.1-8.2 0-11.3l-45.2-45z" } }] }, "name": "arrows-alt", "theme": "outlined" };
	exports.default = ArrowsAltOutlined;
	});

	var ArrowsAltOutlinedSvg = unwrapExports(ArrowsAltOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var ArrowsAltOutlined = function ArrowsAltOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ArrowsAltOutlinedSvg
	  }));
	};

	ArrowsAltOutlined.displayName = 'ArrowsAltOutlined';
	var ArrowsAltOutlined$1 = /*#__PURE__*/React.forwardRef(ArrowsAltOutlined);

	var AudioFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var AudioFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 624c93.9 0 170-75.2 170-168V232c0-92.8-76.1-168-170-168s-170 75.2-170 168v224c0 92.8 76.1 168 170 168zm330-170c0-4.4-3.6-8-8-8h-60c-4.4 0-8 3.6-8 8 0 140.3-113.7 254-254 254S258 594.3 258 454c0-4.4-3.6-8-8-8h-60c-4.4 0-8 3.6-8 8 0 168.7 126.6 307.9 290 327.6V884H326.7c-13.7 0-24.7 14.3-24.7 32v36c0 4.4 2.8 8 6.2 8h407.6c3.4 0 6.2-3.6 6.2-8v-36c0-17.7-11-32-24.7-32H548V782.1c165.3-18 294-158 294-328.1z" } }] }, "name": "audio", "theme": "filled" };
	exports.default = AudioFilled;
	});

	var AudioFilledSvg = unwrapExports(AudioFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var AudioFilled = function AudioFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: AudioFilledSvg
	  }));
	};

	AudioFilled.displayName = 'AudioFilled';
	var AudioFilled$1 = /*#__PURE__*/React.forwardRef(AudioFilled);

	var AudioMutedOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var AudioMutedOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M682 455V311l-76 76v68c-.1 50.7-42 92.1-94 92a95.8 95.8 0 01-52-15l-54 55c29.1 22.4 65.9 36 106 36 93.8 0 170-75.1 170-168z" } }, { "tag": "path", "attrs": { "d": "M833 446h-60c-4.4 0-8 3.6-8 8 0 140.3-113.7 254-254 254-63 0-120.7-23-165-61l-54 54a334.01 334.01 0 00179 81v102H326c-13.9 0-24.9 14.3-25 32v36c.1 4.4 2.9 8 6 8h408c3.2 0 6-3.6 6-8v-36c0-17.7-11-32-25-32H547V782c165.3-17.9 294-157.9 294-328 0-4.4-3.6-8-8-8zm13.1-377.7l-43.5-41.9a8 8 0 00-11.2.1l-129 129C634.3 101.2 577 64 511 64c-93.9 0-170 75.3-170 168v224c0 6.7.4 13.3 1.2 19.8l-68 68A252.33 252.33 0 01258 454c-.2-4.4-3.8-8-8-8h-60c-4.4 0-8 3.6-8 8 0 53 12.5 103 34.6 147.4l-137 137a8.03 8.03 0 000 11.3l42.7 42.7c3.1 3.1 8.2 3.1 11.3 0L846.2 79.8l.1-.1c3.1-3.2 3-8.3-.2-11.4zM417 401V232c0-50.6 41.9-92 94-92 46 0 84.1 32.3 92.3 74.7L417 401z" } }] }, "name": "audio-muted", "theme": "outlined" };
	exports.default = AudioMutedOutlined;
	});

	var AudioMutedOutlinedSvg = unwrapExports(AudioMutedOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var AudioMutedOutlined = function AudioMutedOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: AudioMutedOutlinedSvg
	  }));
	};

	AudioMutedOutlined.displayName = 'AudioMutedOutlined';
	var AudioMutedOutlined$1 = /*#__PURE__*/React.forwardRef(AudioMutedOutlined);

	var AudioOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var AudioOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M842 454c0-4.4-3.6-8-8-8h-60c-4.4 0-8 3.6-8 8 0 140.3-113.7 254-254 254S258 594.3 258 454c0-4.4-3.6-8-8-8h-60c-4.4 0-8 3.6-8 8 0 168.7 126.6 307.9 290 327.6V884H326.7c-13.7 0-24.7 14.3-24.7 32v36c0 4.4 2.8 8 6.2 8h407.6c3.4 0 6.2-3.6 6.2-8v-36c0-17.7-11-32-24.7-32H548V782.1c165.3-18 294-158 294-328.1zM512 624c93.9 0 170-75.2 170-168V232c0-92.8-76.1-168-170-168s-170 75.2-170 168v224c0 92.8 76.1 168 170 168zm-94-392c0-50.6 41.9-92 94-92s94 41.4 94 92v224c0 50.6-41.9 92-94 92s-94-41.4-94-92V232z" } }] }, "name": "audio", "theme": "outlined" };
	exports.default = AudioOutlined;
	});

	var AudioOutlinedSvg = unwrapExports(AudioOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var AudioOutlined = function AudioOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: AudioOutlinedSvg
	  }));
	};

	AudioOutlined.displayName = 'AudioOutlined';
	var AudioOutlined$1 = /*#__PURE__*/React.forwardRef(AudioOutlined);

	var AudioTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var AudioTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 552c54.3 0 98-43.2 98-96V232c0-52.8-43.7-96-98-96s-98 43.2-98 96v224c0 52.8 43.7 96 98 96z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M842 454c0-4.4-3.6-8-8-8h-60c-4.4 0-8 3.6-8 8 0 140.3-113.7 254-254 254S258 594.3 258 454c0-4.4-3.6-8-8-8h-60c-4.4 0-8 3.6-8 8 0 168.7 126.6 307.9 290 327.6V884H326.7c-13.7 0-24.7 14.3-24.7 32v36c0 4.4 2.8 8 6.2 8h407.6c3.4 0 6.2-3.6 6.2-8v-36c0-17.7-11-32-24.7-32H548V782.1c165.3-18 294-158 294-328.1z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 624c93.9 0 170-75.2 170-168V232c0-92.8-76.1-168-170-168s-170 75.2-170 168v224c0 92.8 76.1 168 170 168zm-98-392c0-52.8 43.7-96 98-96s98 43.2 98 96v224c0 52.8-43.7 96-98 96s-98-43.2-98-96V232z", "fill": primaryColor } }] }; }, "name": "audio", "theme": "twotone" };
	exports.default = AudioTwoTone;
	});

	var AudioTwoToneSvg = unwrapExports(AudioTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var AudioTwoTone = function AudioTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: AudioTwoToneSvg
	  }));
	};

	AudioTwoTone.displayName = 'AudioTwoTone';
	var AudioTwoTone$1 = /*#__PURE__*/React.forwardRef(AudioTwoTone);

	var AuditOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var AuditOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M296 250c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h384c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H296zm184 144H296c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h184c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8zm-48 458H208V148h560v320c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V108c0-17.7-14.3-32-32-32H168c-17.7 0-32 14.3-32 32v784c0 17.7 14.3 32 32 32h264c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm440-88H728v-36.6c46.3-13.8 80-56.6 80-107.4 0-61.9-50.1-112-112-112s-112 50.1-112 112c0 50.7 33.7 93.6 80 107.4V764H520c-8.8 0-16 7.2-16 16v152c0 8.8 7.2 16 16 16h352c8.8 0 16-7.2 16-16V780c0-8.8-7.2-16-16-16zM646 620c0-27.6 22.4-50 50-50s50 22.4 50 50-22.4 50-50 50-50-22.4-50-50zm180 266H566v-60h260v60z" } }] }, "name": "audit", "theme": "outlined" };
	exports.default = AuditOutlined;
	});

	var AuditOutlinedSvg = unwrapExports(AuditOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var AuditOutlined = function AuditOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: AuditOutlinedSvg
	  }));
	};

	AuditOutlined.displayName = 'AuditOutlined';
	var AuditOutlined$1 = /*#__PURE__*/React.forwardRef(AuditOutlined);

	var BackwardFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BackwardFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M485.6 249.9L198.2 498c-8.3 7.1-8.3 20.8 0 27.9l287.4 248.2c10.7 9.2 26.4.9 26.4-14V263.8c0-14.8-15.7-23.2-26.4-13.9zm320 0L518.2 498a18.6 18.6 0 00-6.2 14c0 5.2 2.1 10.4 6.2 14l287.4 248.2c10.7 9.2 26.4.9 26.4-14V263.8c0-14.8-15.7-23.2-26.4-13.9z" } }] }, "name": "backward", "theme": "filled" };
	exports.default = BackwardFilled;
	});

	var BackwardFilledSvg = unwrapExports(BackwardFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var BackwardFilled = function BackwardFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BackwardFilledSvg
	  }));
	};

	BackwardFilled.displayName = 'BackwardFilled';
	var BackwardFilled$1 = /*#__PURE__*/React.forwardRef(BackwardFilled);

	var BackwardOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BackwardOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M485.6 249.9L198.2 498c-8.3 7.1-8.3 20.8 0 27.9l287.4 248.2c10.7 9.2 26.4.9 26.4-14V263.8c0-14.8-15.7-23.2-26.4-13.9zm320 0L518.2 498a18.6 18.6 0 00-6.2 14c0 5.2 2.1 10.4 6.2 14l287.4 248.2c10.7 9.2 26.4.9 26.4-14V263.8c0-14.8-15.7-23.2-26.4-13.9z" } }] }, "name": "backward", "theme": "outlined" };
	exports.default = BackwardOutlined;
	});

	var BackwardOutlinedSvg = unwrapExports(BackwardOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var BackwardOutlined = function BackwardOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BackwardOutlinedSvg
	  }));
	};

	BackwardOutlined.displayName = 'BackwardOutlined';
	var BackwardOutlined$1 = /*#__PURE__*/React.forwardRef(BackwardOutlined);

	var BankFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BankFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M894 462c30.9 0 43.8-39.7 18.7-58L530.8 126.2a31.81 31.81 0 00-37.6 0L111.3 404c-25.1 18.2-12.2 58 18.8 58H192v374h-72c-4.4 0-8 3.6-8 8v52c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-52c0-4.4-3.6-8-8-8h-72V462h62zM381 836H264V462h117v374zm189 0H453V462h117v374zm190 0H642V462h118v374z" } }] }, "name": "bank", "theme": "filled" };
	exports.default = BankFilled;
	});

	var BankFilledSvg = unwrapExports(BankFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var BankFilled = function BankFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BankFilledSvg
	  }));
	};

	BankFilled.displayName = 'BankFilled';
	var BankFilled$1 = /*#__PURE__*/React.forwardRef(BankFilled);

	var BankOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BankOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M894 462c30.9 0 43.8-39.7 18.7-58L530.8 126.2a31.81 31.81 0 00-37.6 0L111.3 404c-25.1 18.2-12.2 58 18.8 58H192v374h-72c-4.4 0-8 3.6-8 8v52c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-52c0-4.4-3.6-8-8-8h-72V462h62zM512 196.7l271.1 197.2H240.9L512 196.7zM264 462h117v374H264V462zm189 0h117v374H453V462zm307 374H642V462h118v374z" } }] }, "name": "bank", "theme": "outlined" };
	exports.default = BankOutlined;
	});

	var BankOutlinedSvg = unwrapExports(BankOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var BankOutlined = function BankOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BankOutlinedSvg
	  }));
	};

	BankOutlined.displayName = 'BankOutlined';
	var BankOutlined$1 = /*#__PURE__*/React.forwardRef(BankOutlined);

	var BankTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BankTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M240.9 393.9h542.2L512 196.7z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M894 462c30.9 0 43.8-39.7 18.7-58L530.8 126.2a31.81 31.81 0 00-37.6 0L111.3 404c-25.1 18.2-12.2 58 18.8 58H192v374h-72c-4.4 0-8 3.6-8 8v52c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-52c0-4.4-3.6-8-8-8h-72V462h62zM381 836H264V462h117v374zm189 0H453V462h117v374zm190 0H642V462h118v374zM240.9 393.9L512 196.7l271.1 197.2H240.9z", "fill": primaryColor } }] }; }, "name": "bank", "theme": "twotone" };
	exports.default = BankTwoTone;
	});

	var BankTwoToneSvg = unwrapExports(BankTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var BankTwoTone = function BankTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BankTwoToneSvg
	  }));
	};

	BankTwoTone.displayName = 'BankTwoTone';
	var BankTwoTone$1 = /*#__PURE__*/React.forwardRef(BankTwoTone);

	var BarChartOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BarChartOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M888 792H200V168c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v688c0 4.4 3.6 8 8 8h752c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-600-80h56c4.4 0 8-3.6 8-8V560c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v144c0 4.4 3.6 8 8 8zm152 0h56c4.4 0 8-3.6 8-8V384c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v320c0 4.4 3.6 8 8 8zm152 0h56c4.4 0 8-3.6 8-8V462c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v242c0 4.4 3.6 8 8 8zm152 0h56c4.4 0 8-3.6 8-8V304c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v400c0 4.4 3.6 8 8 8z" } }] }, "name": "bar-chart", "theme": "outlined" };
	exports.default = BarChartOutlined;
	});

	var BarChartOutlinedSvg = unwrapExports(BarChartOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var BarChartOutlined = function BarChartOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BarChartOutlinedSvg
	  }));
	};

	BarChartOutlined.displayName = 'BarChartOutlined';
	var BarChartOutlined$1 = /*#__PURE__*/React.forwardRef(BarChartOutlined);

	var BarcodeOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BarcodeOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M120 160H72c-4.4 0-8 3.6-8 8v688c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V168c0-4.4-3.6-8-8-8zm833 0h-48c-4.4 0-8 3.6-8 8v688c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V168c0-4.4-3.6-8-8-8zM200 736h112c4.4 0 8-3.6 8-8V168c0-4.4-3.6-8-8-8H200c-4.4 0-8 3.6-8 8v560c0 4.4 3.6 8 8 8zm321 0h48c4.4 0 8-3.6 8-8V168c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v560c0 4.4 3.6 8 8 8zm126 0h178c4.4 0 8-3.6 8-8V168c0-4.4-3.6-8-8-8H647c-4.4 0-8 3.6-8 8v560c0 4.4 3.6 8 8 8zm-255 0h48c4.4 0 8-3.6 8-8V168c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v560c0 4.4 3.6 8 8 8zm-79 64H201c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h112c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8zm257 0h-48c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8zm256 0H648c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h178c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8zm-385 0h-48c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8z" } }] }, "name": "barcode", "theme": "outlined" };
	exports.default = BarcodeOutlined;
	});

	var BarcodeOutlinedSvg = unwrapExports(BarcodeOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var BarcodeOutlined = function BarcodeOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BarcodeOutlinedSvg
	  }));
	};

	BarcodeOutlined.displayName = 'BarcodeOutlined';
	var BarcodeOutlined$1 = /*#__PURE__*/React.forwardRef(BarcodeOutlined);

	var BarsOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BarsOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M912 192H328c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h584c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 284H328c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h584c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 284H328c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h584c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM104 228a56 56 0 10112 0 56 56 0 10-112 0zm0 284a56 56 0 10112 0 56 56 0 10-112 0zm0 284a56 56 0 10112 0 56 56 0 10-112 0z" } }] }, "name": "bars", "theme": "outlined" };
	exports.default = BarsOutlined;
	});

	var BarsOutlinedSvg = unwrapExports(BarsOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var BarsOutlined = function BarsOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BarsOutlinedSvg
	  }));
	};

	BarsOutlined.displayName = 'BarsOutlined';
	var BarsOutlined$1 = /*#__PURE__*/React.forwardRef(BarsOutlined);

	var BehanceCircleFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BehanceCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M420.3 470.3c8.7-6.3 12.9-16.7 12.9-31 .3-6.8-1.1-13.5-4.1-19.6-2.7-4.9-6.7-9-11.6-11.9a44.8 44.8 0 00-16.6-6c-6.4-1.2-12.9-1.8-19.3-1.7h-70.3v79.7h76.1c13.1.1 24.2-3.1 32.9-9.5zm11.8 72c-9.8-7.5-22.9-11.2-39.2-11.2h-81.8v94h80.2c7.5 0 14.4-.7 21.1-2.1a50.5 50.5 0 0017.8-7.2c5.1-3.3 9.2-7.8 12.3-13.6 3-5.8 4.5-13.2 4.5-22.1 0-17.7-5-30.2-14.9-37.8zM512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm86.5 286.9h138.4v33.7H598.5v-33.7zM512 628.8a89.52 89.52 0 01-27 31c-11.8 8.2-24.9 14.2-38.8 17.7a167.4 167.4 0 01-44.6 5.7H236V342.1h161c16.3 0 31.1 1.5 44.6 4.3 13.4 2.8 24.8 7.6 34.4 14.1 9.5 6.5 17 15.2 22.3 26 5.2 10.7 7.9 24.1 7.9 40 0 17.2-3.9 31.4-11.7 42.9-7.9 11.5-19.3 20.8-34.8 28.1 21.1 6 36.6 16.7 46.8 31.7 10.4 15.2 15.5 33.4 15.5 54.8 0 17.4-3.3 32.3-10 44.8zM790.8 576H612.4c0 19.4 6.7 38 16.8 48 10.2 9.9 24.8 14.9 43.9 14.9 13.8 0 25.5-3.5 35.5-10.4 9.9-6.9 15.9-14.2 18.1-21.8h59.8c-9.6 29.7-24.2 50.9-44 63.7-19.6 12.8-43.6 19.2-71.5 19.2-19.5 0-37-3.2-52.7-9.3-15.1-5.9-28.7-14.9-39.9-26.5a121.2 121.2 0 01-25.1-41.2c-6.1-16.9-9.1-34.7-8.9-52.6 0-18.5 3.1-35.7 9.1-51.7 11.5-31.1 35.4-56 65.9-68.9 16.3-6.8 33.8-10.2 51.5-10 21 0 39.2 4 55 12.2a111.6 111.6 0 0138.6 32.8c10.1 13.7 17.2 29.3 21.7 46.9 4.3 17.3 5.8 35.5 4.6 54.7zm-122-95.6c-10.8 0-19.9 1.9-26.9 5.6-7 3.7-12.8 8.3-17.2 13.6a48.4 48.4 0 00-9.1 17.4c-1.6 5.3-2.7 10.7-3.1 16.2H723c-1.6-17.3-7.6-30.1-15.6-39.1-8.4-8.9-21.9-13.7-38.6-13.7z" } }] }, "name": "behance-circle", "theme": "filled" };
	exports.default = BehanceCircleFilled;
	});

	var BehanceCircleFilledSvg = unwrapExports(BehanceCircleFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var BehanceCircleFilled = function BehanceCircleFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BehanceCircleFilledSvg
	  }));
	};

	BehanceCircleFilled.displayName = 'BehanceCircleFilled';
	var BehanceCircleFilled$1 = /*#__PURE__*/React.forwardRef(BehanceCircleFilled);

	var BehanceOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BehanceOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M634 294.3h199.5v48.4H634zM434.1 485.8c44.1-21.1 67.2-53.2 67.2-102.8 0-98.1-73-121.9-157.3-121.9H112v492.4h238.5c89.4 0 173.3-43 173.3-143 0-61.8-29.2-107.5-89.7-124.7zM220.2 345.1h101.5c39.1 0 74.2 10.9 74.2 56.3 0 41.8-27.3 58.6-66 58.6H220.2V345.1zm115.5 324.8H220.1V534.3H338c47.6 0 77.7 19.9 77.7 70.3 0 49.6-35.9 65.3-80 65.3zm575.8-89.5c0-105.5-61.7-193.4-173.3-193.4-108.5 0-182.3 81.7-182.3 188.8 0 111 69.9 187.2 182.3 187.2 85.1 0 140.2-38.3 166.7-120h-86.3c-9.4 30.5-47.6 46.5-77.3 46.5-57.4 0-87.4-33.6-87.4-90.7h256.9c.3-5.9.7-12.1.7-18.4zM653.9 537c3.1-46.9 34.4-76.2 81.2-76.2 49.2 0 73.8 28.9 78.1 76.2H653.9z" } }] }, "name": "behance", "theme": "outlined" };
	exports.default = BehanceOutlined;
	});

	var BehanceOutlinedSvg = unwrapExports(BehanceOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var BehanceOutlined = function BehanceOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BehanceOutlinedSvg
	  }));
	};

	BehanceOutlined.displayName = 'BehanceOutlined';
	var BehanceOutlined$1 = /*#__PURE__*/React.forwardRef(BehanceOutlined);

	var BehanceSquareFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BehanceSquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM598.5 350.9h138.4v33.7H598.5v-33.7zM512 628.8a89.52 89.52 0 01-27 31c-11.8 8.2-24.9 14.2-38.8 17.7a167.4 167.4 0 01-44.6 5.7H236V342.1h161c16.3 0 31.1 1.5 44.6 4.3 13.4 2.8 24.8 7.6 34.4 14.1 9.5 6.5 17 15.2 22.3 26 5.2 10.7 7.9 24.1 7.9 40 0 17.2-3.9 31.4-11.7 42.9-7.9 11.5-19.3 20.8-34.8 28.1 21.1 6 36.6 16.7 46.8 31.7 10.4 15.2 15.5 33.4 15.5 54.8 0 17.4-3.3 32.3-10 44.8zM790.8 576H612.4c0 19.4 6.7 38 16.8 48 10.2 9.9 24.8 14.9 43.9 14.9 13.8 0 25.5-3.5 35.5-10.4 9.9-6.9 15.9-14.2 18.1-21.8h59.8c-9.6 29.7-24.2 50.9-44 63.7-19.6 12.8-43.6 19.2-71.5 19.2-19.5 0-37-3.2-52.7-9.3-15.1-5.9-28.7-14.9-39.9-26.5a121.2 121.2 0 01-25.1-41.2c-6.1-16.9-9.1-34.7-8.9-52.6 0-18.5 3.1-35.7 9.1-51.7 11.5-31.1 35.4-56 65.9-68.9 16.3-6.8 33.8-10.2 51.5-10 21 0 39.2 4 55 12.2a111.6 111.6 0 0138.6 32.8c10.1 13.7 17.2 29.3 21.7 46.9 4.3 17.3 5.8 35.5 4.6 54.7zm-122-95.6c-10.8 0-19.9 1.9-26.9 5.6-7 3.7-12.8 8.3-17.2 13.6a48.4 48.4 0 00-9.1 17.4c-1.6 5.3-2.7 10.7-3.1 16.2H723c-1.6-17.3-7.6-30.1-15.6-39.1-8.4-8.9-21.9-13.7-38.6-13.7zm-248.5-10.1c8.7-6.3 12.9-16.7 12.9-31 .3-6.8-1.1-13.5-4.1-19.6-2.7-4.9-6.7-9-11.6-11.9a44.8 44.8 0 00-16.6-6c-6.4-1.2-12.9-1.8-19.3-1.7h-70.3v79.7h76.1c13.1.1 24.2-3.1 32.9-9.5zm11.8 72c-9.8-7.5-22.9-11.2-39.2-11.2h-81.8v94h80.2c7.5 0 14.4-.7 21.1-2.1s12.7-3.8 17.8-7.2c5.1-3.3 9.2-7.8 12.3-13.6 3-5.8 4.5-13.2 4.5-22.1 0-17.7-5-30.2-14.9-37.8z" } }] }, "name": "behance-square", "theme": "filled" };
	exports.default = BehanceSquareFilled;
	});

	var BehanceSquareFilledSvg = unwrapExports(BehanceSquareFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var BehanceSquareFilled = function BehanceSquareFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BehanceSquareFilledSvg
	  }));
	};

	BehanceSquareFilled.displayName = 'BehanceSquareFilled';
	var BehanceSquareFilled$1 = /*#__PURE__*/React.forwardRef(BehanceSquareFilled);

	var BehanceSquareOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BehanceSquareOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM598.5 350.9h138.4v33.7H598.5v-33.7zM512 628.8a89.52 89.52 0 01-27 31c-11.8 8.2-24.9 14.2-38.8 17.7a167.4 167.4 0 01-44.6 5.7H236V342.1h161c16.3 0 31.1 1.5 44.6 4.3 13.4 2.8 24.8 7.6 34.4 14.1 9.5 6.5 17 15.2 22.3 26 5.2 10.7 7.9 24.1 7.9 40 0 17.2-3.9 31.4-11.7 42.9-7.9 11.5-19.3 20.8-34.8 28.1 21.1 6 36.6 16.7 46.8 31.7 10.4 15.2 15.5 33.4 15.5 54.8 0 17.4-3.3 32.3-10 44.8zM790.8 576H612.4c0 19.4 6.7 38 16.8 48 10.2 9.9 24.8 14.9 43.9 14.9 13.8 0 25.5-3.5 35.5-10.4 9.9-6.9 15.9-14.2 18.1-21.8h59.8c-9.6 29.7-24.2 50.9-44 63.7-19.6 12.8-43.6 19.2-71.5 19.2-19.5 0-37-3.2-52.7-9.3-15.1-5.9-28.7-14.9-39.9-26.5a121.2 121.2 0 01-25.1-41.2c-6.1-16.9-9.1-34.7-8.9-52.6 0-18.5 3.1-35.7 9.1-51.7 11.5-31.1 35.4-56 65.9-68.9 16.3-6.8 33.8-10.2 51.5-10 21 0 39.2 4 55 12.2a111.6 111.6 0 0138.6 32.8c10.1 13.7 17.2 29.3 21.7 46.9 4.3 17.3 5.8 35.5 4.6 54.7zm-122-95.6c-10.8 0-19.9 1.9-26.9 5.6-7 3.7-12.8 8.3-17.2 13.6a48.4 48.4 0 00-9.1 17.4c-1.6 5.3-2.7 10.7-3.1 16.2H723c-1.6-17.3-7.6-30.1-15.6-39.1-8.4-8.9-21.9-13.7-38.6-13.7zm-248.5-10.1c8.7-6.3 12.9-16.7 12.9-31 .3-6.8-1.1-13.5-4.1-19.6-2.7-4.9-6.7-9-11.6-11.9a44.8 44.8 0 00-16.6-6c-6.4-1.2-12.9-1.8-19.3-1.7h-70.3v79.7h76.1c13.1.1 24.2-3.1 32.9-9.5zm11.8 72c-9.8-7.5-22.9-11.2-39.2-11.2h-81.8v94h80.2c7.5 0 14.4-.7 21.1-2.1s12.7-3.8 17.8-7.2c5.1-3.3 9.2-7.8 12.3-13.6 3-5.8 4.5-13.2 4.5-22.1 0-17.7-5-30.2-14.9-37.8z" } }] }, "name": "behance-square", "theme": "outlined" };
	exports.default = BehanceSquareOutlined;
	});

	var BehanceSquareOutlinedSvg = unwrapExports(BehanceSquareOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var BehanceSquareOutlined = function BehanceSquareOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BehanceSquareOutlinedSvg
	  }));
	};

	BehanceSquareOutlined.displayName = 'BehanceSquareOutlined';
	var BehanceSquareOutlined$1 = /*#__PURE__*/React.forwardRef(BehanceSquareOutlined);

	var BellFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BellFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M816 768h-24V428c0-141.1-104.3-257.8-240-277.2V112c0-22.1-17.9-40-40-40s-40 17.9-40 40v38.8C336.3 170.2 232 286.9 232 428v340h-24c-17.7 0-32 14.3-32 32v32c0 4.4 3.6 8 8 8h216c0 61.8 50.2 112 112 112s112-50.2 112-112h216c4.4 0 8-3.6 8-8v-32c0-17.7-14.3-32-32-32zM512 888c-26.5 0-48-21.5-48-48h96c0 26.5-21.5 48-48 48z" } }] }, "name": "bell", "theme": "filled" };
	exports.default = BellFilled;
	});

	var BellFilledSvg = unwrapExports(BellFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var BellFilled = function BellFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BellFilledSvg
	  }));
	};

	BellFilled.displayName = 'BellFilled';
	var BellFilled$1 = /*#__PURE__*/React.forwardRef(BellFilled);

	var BellOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BellOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M816 768h-24V428c0-141.1-104.3-257.7-240-277.1V112c0-22.1-17.9-40-40-40s-40 17.9-40 40v38.9c-135.7 19.4-240 136-240 277.1v340h-24c-17.7 0-32 14.3-32 32v32c0 4.4 3.6 8 8 8h216c0 61.8 50.2 112 112 112s112-50.2 112-112h216c4.4 0 8-3.6 8-8v-32c0-17.7-14.3-32-32-32zM512 888c-26.5 0-48-21.5-48-48h96c0 26.5-21.5 48-48 48zM304 768V428c0-55.6 21.6-107.8 60.9-147.1S456.4 220 512 220c55.6 0 107.8 21.6 147.1 60.9S720 372.4 720 428v340H304z" } }] }, "name": "bell", "theme": "outlined" };
	exports.default = BellOutlined;
	});

	var BellOutlinedSvg = unwrapExports(BellOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var BellOutlined = function BellOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BellOutlinedSvg
	  }));
	};

	BellOutlined.displayName = 'BellOutlined';
	var BellOutlined$1 = /*#__PURE__*/React.forwardRef(BellOutlined);

	var BellTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BellTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 220c-55.6 0-107.8 21.6-147.1 60.9S304 372.4 304 428v340h416V428c0-55.6-21.6-107.8-60.9-147.1S567.6 220 512 220zm280 208c0-141.1-104.3-257.8-240-277.2v.1c135.7 19.4 240 136 240 277.1zM472 150.9v-.1C336.3 170.2 232 286.9 232 428c0-141.1 104.3-257.7 240-277.1z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M816 768h-24V428c0-141.1-104.3-257.7-240-277.1V112c0-22.1-17.9-40-40-40s-40 17.9-40 40v38.9c-135.7 19.4-240 136-240 277.1v340h-24c-17.7 0-32 14.3-32 32v32c0 4.4 3.6 8 8 8h216c0 61.8 50.2 112 112 112s112-50.2 112-112h216c4.4 0 8-3.6 8-8v-32c0-17.7-14.3-32-32-32zM512 888c-26.5 0-48-21.5-48-48h96c0 26.5-21.5 48-48 48zm208-120H304V428c0-55.6 21.6-107.8 60.9-147.1S456.4 220 512 220c55.6 0 107.8 21.6 147.1 60.9S720 372.4 720 428v340z", "fill": primaryColor } }] }; }, "name": "bell", "theme": "twotone" };
	exports.default = BellTwoTone;
	});

	var BellTwoToneSvg = unwrapExports(BellTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var BellTwoTone = function BellTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BellTwoToneSvg
	  }));
	};

	BellTwoTone.displayName = 'BellTwoTone';
	var BellTwoTone$1 = /*#__PURE__*/React.forwardRef(BellTwoTone);

	var BgColorsOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BgColorsOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M766.4 744.3c43.7 0 79.4-36.2 79.4-80.5 0-53.5-79.4-140.8-79.4-140.8S687 610.3 687 663.8c0 44.3 35.7 80.5 79.4 80.5zm-377.1-44.1c7.1 7.1 18.6 7.1 25.6 0l256.1-256c7.1-7.1 7.1-18.6 0-25.6l-256-256c-.6-.6-1.3-1.2-2-1.7l-78.2-78.2a9.11 9.11 0 00-12.8 0l-48 48a9.11 9.11 0 000 12.8l67.2 67.2-207.8 207.9c-7.1 7.1-7.1 18.6 0 25.6l255.9 256zm12.9-448.6l178.9 178.9H223.4l178.8-178.9zM904 816H120c-4.4 0-8 3.6-8 8v80c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-80c0-4.4-3.6-8-8-8z" } }] }, "name": "bg-colors", "theme": "outlined" };
	exports.default = BgColorsOutlined;
	});

	var BgColorsOutlinedSvg = unwrapExports(BgColorsOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var BgColorsOutlined = function BgColorsOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BgColorsOutlinedSvg
	  }));
	};

	BgColorsOutlined.displayName = 'BgColorsOutlined';
	var BgColorsOutlined$1 = /*#__PURE__*/React.forwardRef(BgColorsOutlined);

	var BlockOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BlockOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M856 376H648V168c0-8.8-7.2-16-16-16H168c-8.8 0-16 7.2-16 16v464c0 8.8 7.2 16 16 16h208v208c0 8.8 7.2 16 16 16h464c8.8 0 16-7.2 16-16V392c0-8.8-7.2-16-16-16zm-480 16v188H220V220h360v156H392c-8.8 0-16 7.2-16 16zm204 52v136H444V444h136zm224 360H444V648h188c8.8 0 16-7.2 16-16V444h156v360z" } }] }, "name": "block", "theme": "outlined" };
	exports.default = BlockOutlined;
	});

	var BlockOutlinedSvg = unwrapExports(BlockOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var BlockOutlined = function BlockOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BlockOutlinedSvg
	  }));
	};

	BlockOutlined.displayName = 'BlockOutlined';
	var BlockOutlined$1 = /*#__PURE__*/React.forwardRef(BlockOutlined);

	var BoldOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BoldOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M697.8 481.4c33.6-35 54.2-82.3 54.2-134.3v-10.2C752 229.3 663.9 142 555.3 142H259.4c-15.1 0-27.4 12.3-27.4 27.4v679.1c0 16.3 13.2 29.5 29.5 29.5h318.7c117 0 211.8-94.2 211.8-210.5v-11c0-73-37.4-137.3-94.2-175.1zM328 238h224.7c57.1 0 103.3 44.4 103.3 99.3v9.5c0 54.8-46.3 99.3-103.3 99.3H328V238zm366.6 429.4c0 62.9-51.7 113.9-115.5 113.9H328V542.7h251.1c63.8 0 115.5 51 115.5 113.9v10.8z" } }] }, "name": "bold", "theme": "outlined" };
	exports.default = BoldOutlined;
	});

	var BoldOutlinedSvg = unwrapExports(BoldOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var BoldOutlined = function BoldOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BoldOutlinedSvg
	  }));
	};

	BoldOutlined.displayName = 'BoldOutlined';
	var BoldOutlined$1 = /*#__PURE__*/React.forwardRef(BoldOutlined);

	var BookFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BookFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M832 64H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V96c0-17.7-14.3-32-32-32zM668 345.9L621.5 312 572 347.4V124h96v221.9z" } }] }, "name": "book", "theme": "filled" };
	exports.default = BookFilled;
	});

	var BookFilledSvg = unwrapExports(BookFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var BookFilled = function BookFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BookFilledSvg
	  }));
	};

	BookFilled.displayName = 'BookFilled';
	var BookFilled$1 = /*#__PURE__*/React.forwardRef(BookFilled);

	var BookOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BookOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M832 64H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V96c0-17.7-14.3-32-32-32zm-260 72h96v209.9L621.5 312 572 347.4V136zm220 752H232V136h280v296.9c0 3.3 1 6.6 3 9.3a15.9 15.9 0 0022.3 3.7l83.8-59.9 81.4 59.4c2.7 2 6 3.1 9.4 3.1 8.8 0 16-7.2 16-16V136h64v752z" } }] }, "name": "book", "theme": "outlined" };
	exports.default = BookOutlined;
	});

	var BookOutlinedSvg = unwrapExports(BookOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var BookOutlined = function BookOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BookOutlinedSvg
	  }));
	};

	BookOutlined.displayName = 'BookOutlined';
	var BookOutlined$1 = /*#__PURE__*/React.forwardRef(BookOutlined);

	var BookTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BookTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M832 64H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V96c0-17.7-14.3-32-32-32zm-260 72h96v209.9L621.5 312 572 347.4V136zM232 888V136h280v296.9c0 3.3 1 6.6 3 9.3a15.9 15.9 0 0022.3 3.7l83.8-59.9 81.4 59.4c2.7 2 6 3.1 9.4 3.1 8.8 0 16-7.2 16-16V136h64v752H232z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M668 345.9V136h-96v211.4l49.5-35.4z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M727.9 136v296.5c0 8.8-7.2 16-16 16-3.4 0-6.7-1.1-9.4-3.1L621.1 386l-83.8 59.9a15.9 15.9 0 01-22.3-3.7c-2-2.7-3-6-3-9.3V136H232v752h559.9V136h-64z", "fill": secondaryColor } }] }; }, "name": "book", "theme": "twotone" };
	exports.default = BookTwoTone;
	});

	var BookTwoToneSvg = unwrapExports(BookTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var BookTwoTone = function BookTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BookTwoToneSvg
	  }));
	};

	BookTwoTone.displayName = 'BookTwoTone';
	var BookTwoTone$1 = /*#__PURE__*/React.forwardRef(BookTwoTone);

	var BorderBottomOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BorderBottomOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M872 808H152c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h720c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-720-94h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm0-498h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm0 332h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm0-166h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm166 166h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm0-332h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm332 0h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm0 332h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm222-72h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-388 72h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm388-404h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-388 72h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm388 426h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-388 72h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm388-404h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-388 72h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8z" } }] }, "name": "border-bottom", "theme": "outlined" };
	exports.default = BorderBottomOutlined;
	});

	var BorderBottomOutlinedSvg = unwrapExports(BorderBottomOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var BorderBottomOutlined = function BorderBottomOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BorderBottomOutlinedSvg
	  }));
	};

	BorderBottomOutlined.displayName = 'BorderBottomOutlined';
	var BorderBottomOutlined$1 = /*#__PURE__*/React.forwardRef(BorderBottomOutlined);

	var BorderHorizontalOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BorderHorizontalOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M540 144h-56c-4.4 0-8 3.6-8 8v720c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V152c0-4.4-3.6-8-8-8zm-166 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm498 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-664 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm498 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM208 310h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm664 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-664 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 166h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm664 332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM374 808h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm332 332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8z" } }] }, "name": "border-horizontal", "theme": "outlined" };
	exports.default = BorderHorizontalOutlined;
	});

	var BorderHorizontalOutlinedSvg = unwrapExports(BorderHorizontalOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var BorderHorizontalOutlined = function BorderHorizontalOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BorderHorizontalOutlinedSvg
	  }));
	};

	BorderHorizontalOutlined.displayName = 'BorderHorizontalOutlined';
	var BorderHorizontalOutlined$1 = /*#__PURE__*/React.forwardRef(BorderHorizontalOutlined);

	var BorderInnerOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BorderInnerOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M872 476H548V144h-72v332H152c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h324v332h72V548h324c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-166h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 498h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-664h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 498h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM650 216h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm56 592h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-332 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-56-592h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm-166 0h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm56 592h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-56-426h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm56 260h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8z" } }] }, "name": "border-inner", "theme": "outlined" };
	exports.default = BorderInnerOutlined;
	});

	var BorderInnerOutlinedSvg = unwrapExports(BorderInnerOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var BorderInnerOutlined = function BorderInnerOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BorderInnerOutlinedSvg
	  }));
	};

	BorderInnerOutlined.displayName = 'BorderInnerOutlined';
	var BorderInnerOutlined$1 = /*#__PURE__*/React.forwardRef(BorderInnerOutlined);

	var BorderLeftOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BorderLeftOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M208 144h-56c-4.4 0-8 3.6-8 8v720c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V152c0-4.4-3.6-8-8-8zm166 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm498 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-332 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm166 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM540 310h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm332 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-332 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 166h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm332 332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM374 808h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm332 332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8z" } }] }, "name": "border-left", "theme": "outlined" };
	exports.default = BorderLeftOutlined;
	});

	var BorderLeftOutlinedSvg = unwrapExports(BorderLeftOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var BorderLeftOutlined = function BorderLeftOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BorderLeftOutlinedSvg
	  }));
	};

	BorderLeftOutlined.displayName = 'BorderLeftOutlined';
	var BorderLeftOutlined$1 = /*#__PURE__*/React.forwardRef(BorderLeftOutlined);

	var BorderOuterOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BorderOuterOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656zM484 366h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zM302 548h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm364 0h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm-182 0h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm0 182h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8z" } }] }, "name": "border-outer", "theme": "outlined" };
	exports.default = BorderOuterOutlined;
	});

	var BorderOuterOutlinedSvg = unwrapExports(BorderOuterOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var BorderOuterOutlined = function BorderOuterOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BorderOuterOutlinedSvg
	  }));
	};

	BorderOuterOutlined.displayName = 'BorderOuterOutlined';
	var BorderOuterOutlined$1 = /*#__PURE__*/React.forwardRef(BorderOuterOutlined);

	var BorderOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BorderOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z" } }] }, "name": "border", "theme": "outlined" };
	exports.default = BorderOutlined;
	});

	var BorderOutlinedSvg = unwrapExports(BorderOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var BorderOutlined = function BorderOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BorderOutlinedSvg
	  }));
	};

	BorderOutlined.displayName = 'BorderOutlined';
	var BorderOutlined$1 = /*#__PURE__*/React.forwardRef(BorderOutlined);

	var BorderRightOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BorderRightOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M872 144h-56c-4.4 0-8 3.6-8 8v720c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V152c0-4.4-3.6-8-8-8zm-166 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-498 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm332 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-166 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm166 166h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-332 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm332 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 166h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM208 808h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm498 332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM374 808h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8z" } }] }, "name": "border-right", "theme": "outlined" };
	exports.default = BorderRightOutlined;
	});

	var BorderRightOutlinedSvg = unwrapExports(BorderRightOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var BorderRightOutlined = function BorderRightOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BorderRightOutlinedSvg
	  }));
	};

	BorderRightOutlined.displayName = 'BorderRightOutlined';
	var BorderRightOutlined$1 = /*#__PURE__*/React.forwardRef(BorderRightOutlined);

	var BorderTopOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BorderTopOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M872 144H152c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h720c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM208 310h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 498h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 166h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm166-166h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm332 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm166 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-332 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm332 332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-332 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm332-498h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-332 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm332 332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-332 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8z" } }] }, "name": "border-top", "theme": "outlined" };
	exports.default = BorderTopOutlined;
	});

	var BorderTopOutlinedSvg = unwrapExports(BorderTopOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var BorderTopOutlined = function BorderTopOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BorderTopOutlinedSvg
	  }));
	};

	BorderTopOutlined.displayName = 'BorderTopOutlined';
	var BorderTopOutlined$1 = /*#__PURE__*/React.forwardRef(BorderTopOutlined);

	var BorderVerticleOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BorderVerticleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M872 476H152c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h720c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-166h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 498h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-664h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 498h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM650 216h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm56 592h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-332 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-56-592h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm-166 0h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm332 0h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zM208 808h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm332 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM152 382h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm332 0h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zM208 642h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm332 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8z" } }] }, "name": "border-verticle", "theme": "outlined" };
	exports.default = BorderVerticleOutlined;
	});

	var BorderVerticleOutlinedSvg = unwrapExports(BorderVerticleOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var BorderVerticleOutlined = function BorderVerticleOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BorderVerticleOutlinedSvg
	  }));
	};

	BorderVerticleOutlined.displayName = 'BorderVerticleOutlined';
	var BorderVerticleOutlined$1 = /*#__PURE__*/React.forwardRef(BorderVerticleOutlined);

	var BorderlessTableOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BorderlessTableOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M117 368h231v64H117zm559 0h241v64H676zm-264 0h200v64H412zm0 224h200v64H412zm264 0h241v64H676zm-559 0h231v64H117zm295-160V179h-64v666h64V592zm264-64V179h-64v666h64V432z" } }] }, "name": "borderless-table", "theme": "outlined" };
	exports.default = BorderlessTableOutlined;
	});

	var BorderlessTableOutlinedSvg = unwrapExports(BorderlessTableOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var BorderlessTableOutlined = function BorderlessTableOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BorderlessTableOutlinedSvg
	  }));
	};

	BorderlessTableOutlined.displayName = 'BorderlessTableOutlined';
	var BorderlessTableOutlined$1 = /*#__PURE__*/React.forwardRef(BorderlessTableOutlined);

	var BoxPlotFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BoxPlotFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M952 224h-52c-4.4 0-8 3.6-8 8v248h-92V304c0-4.4-3.6-8-8-8H448v432h344c4.4 0 8-3.6 8-8V548h92v244c0 4.4 3.6 8 8 8h52c4.4 0 8-3.6 8-8V232c0-4.4-3.6-8-8-8zm-728 80v176h-92V232c0-4.4-3.6-8-8-8H72c-4.4 0-8 3.6-8 8v560c0 4.4 3.6 8 8 8h52c4.4 0 8-3.6 8-8V548h92v172c0 4.4 3.6 8 8 8h152V296H232c-4.4 0-8 3.6-8 8z" } }] }, "name": "box-plot", "theme": "filled" };
	exports.default = BoxPlotFilled;
	});

	var BoxPlotFilledSvg = unwrapExports(BoxPlotFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var BoxPlotFilled = function BoxPlotFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BoxPlotFilledSvg
	  }));
	};

	BoxPlotFilled.displayName = 'BoxPlotFilled';
	var BoxPlotFilled$1 = /*#__PURE__*/React.forwardRef(BoxPlotFilled);

	var BoxPlotOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BoxPlotOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M952 224h-52c-4.4 0-8 3.6-8 8v248h-92V304c0-4.4-3.6-8-8-8H232c-4.4 0-8 3.6-8 8v176h-92V232c0-4.4-3.6-8-8-8H72c-4.4 0-8 3.6-8 8v560c0 4.4 3.6 8 8 8h52c4.4 0 8-3.6 8-8V548h92v172c0 4.4 3.6 8 8 8h560c4.4 0 8-3.6 8-8V548h92v244c0 4.4 3.6 8 8 8h52c4.4 0 8-3.6 8-8V232c0-4.4-3.6-8-8-8zM296 368h88v288h-88V368zm432 288H448V368h280v288z" } }] }, "name": "box-plot", "theme": "outlined" };
	exports.default = BoxPlotOutlined;
	});

	var BoxPlotOutlinedSvg = unwrapExports(BoxPlotOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var BoxPlotOutlined = function BoxPlotOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BoxPlotOutlinedSvg
	  }));
	};

	BoxPlotOutlined.displayName = 'BoxPlotOutlined';
	var BoxPlotOutlined$1 = /*#__PURE__*/React.forwardRef(BoxPlotOutlined);

	var BoxPlotTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BoxPlotTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M296 368h88v288h-88zm152 0h280v288H448z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M952 224h-52c-4.4 0-8 3.6-8 8v248h-92V304c0-4.4-3.6-8-8-8H232c-4.4 0-8 3.6-8 8v176h-92V232c0-4.4-3.6-8-8-8H72c-4.4 0-8 3.6-8 8v560c0 4.4 3.6 8 8 8h52c4.4 0 8-3.6 8-8V548h92v172c0 4.4 3.6 8 8 8h560c4.4 0 8-3.6 8-8V548h92v244c0 4.4 3.6 8 8 8h52c4.4 0 8-3.6 8-8V232c0-4.4-3.6-8-8-8zM384 656h-88V368h88v288zm344 0H448V368h280v288z", "fill": primaryColor } }] }; }, "name": "box-plot", "theme": "twotone" };
	exports.default = BoxPlotTwoTone;
	});

	var BoxPlotTwoToneSvg = unwrapExports(BoxPlotTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var BoxPlotTwoTone = function BoxPlotTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BoxPlotTwoToneSvg
	  }));
	};

	BoxPlotTwoTone.displayName = 'BoxPlotTwoTone';
	var BoxPlotTwoTone$1 = /*#__PURE__*/React.forwardRef(BoxPlotTwoTone);

	var BranchesOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BranchesOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M740 161c-61.8 0-112 50.2-112 112 0 50.1 33.1 92.6 78.5 106.9v95.9L320 602.4V318.1c44.2-15 76-56.9 76-106.1 0-61.8-50.2-112-112-112s-112 50.2-112 112c0 49.2 31.8 91 76 106.1V706c-44.2 15-76 56.9-76 106.1 0 61.8 50.2 112 112 112s112-50.2 112-112c0-49.2-31.8-91-76-106.1v-27.8l423.5-138.7a50.52 50.52 0 0034.9-48.2V378.2c42.9-15.8 73.6-57 73.6-105.2 0-61.8-50.2-112-112-112zm-504 51a48.01 48.01 0 0196 0 48.01 48.01 0 01-96 0zm96 600a48.01 48.01 0 01-96 0 48.01 48.01 0 0196 0zm408-491a48.01 48.01 0 010-96 48.01 48.01 0 010 96z" } }] }, "name": "branches", "theme": "outlined" };
	exports.default = BranchesOutlined;
	});

	var BranchesOutlinedSvg = unwrapExports(BranchesOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var BranchesOutlined = function BranchesOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BranchesOutlinedSvg
	  }));
	};

	BranchesOutlined.displayName = 'BranchesOutlined';
	var BranchesOutlined$1 = /*#__PURE__*/React.forwardRef(BranchesOutlined);

	var BugFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BugFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M304 280h416c4.4 0 8-3.6 8-8 0-40-8.8-76.7-25.9-108.1a184.31 184.31 0 00-74-74C596.7 72.8 560 64 520 64h-16c-40 0-76.7 8.8-108.1 25.9a184.31 184.31 0 00-74 74C304.8 195.3 296 232 296 272c0 4.4 3.6 8 8 8z" } }, { "tag": "path", "attrs": { "d": "M940 512H792V412c76.8 0 139-62.2 139-139 0-4.4-3.6-8-8-8h-60c-4.4 0-8 3.6-8 8a63 63 0 01-63 63H232a63 63 0 01-63-63c0-4.4-3.6-8-8-8h-60c-4.4 0-8 3.6-8 8 0 76.8 62.2 139 139 139v100H84c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h148v96c0 6.5.2 13 .7 19.3C164.1 728.6 116 796.7 116 876c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8 0-44.2 23.9-82.9 59.6-103.7a273 273 0 0022.7 49c24.3 41.5 59 76.2 100.5 100.5 28.9 16.9 61 28.8 95.3 34.5 4.4 0 8-3.6 8-8V484c0-4.4 3.6-8 8-8h60c4.4 0 8 3.6 8 8v464.2c0 4.4 3.6 8 8 8 34.3-5.7 66.4-17.6 95.3-34.5a281.38 281.38 0 00123.2-149.5A120.4 120.4 0 01836 876c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8 0-79.3-48.1-147.4-116.7-176.7.4-6.4.7-12.8.7-19.3v-96h148c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8z" } }] }, "name": "bug", "theme": "filled" };
	exports.default = BugFilled;
	});

	var BugFilledSvg = unwrapExports(BugFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var BugFilled = function BugFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BugFilledSvg
	  }));
	};

	BugFilled.displayName = 'BugFilled';
	var BugFilled$1 = /*#__PURE__*/React.forwardRef(BugFilled);

	var BugOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BugOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M304 280h56c4.4 0 8-3.6 8-8 0-28.3 5.9-53.2 17.1-73.5 10.6-19.4 26-34.8 45.4-45.4C450.9 142 475.7 136 504 136h16c28.3 0 53.2 5.9 73.5 17.1 19.4 10.6 34.8 26 45.4 45.4C650 218.9 656 243.7 656 272c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8 0-40-8.8-76.7-25.9-108.1a184.31 184.31 0 00-74-74C596.7 72.8 560 64 520 64h-16c-40 0-76.7 8.8-108.1 25.9a184.31 184.31 0 00-74 74C304.8 195.3 296 232 296 272c0 4.4 3.6 8 8 8z" } }, { "tag": "path", "attrs": { "d": "M940 512H792V412c76.8 0 139-62.2 139-139 0-4.4-3.6-8-8-8h-60c-4.4 0-8 3.6-8 8a63 63 0 01-63 63H232a63 63 0 01-63-63c0-4.4-3.6-8-8-8h-60c-4.4 0-8 3.6-8 8 0 76.8 62.2 139 139 139v100H84c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h148v96c0 6.5.2 13 .7 19.3C164.1 728.6 116 796.7 116 876c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8 0-44.2 23.9-82.9 59.6-103.7a273 273 0 0022.7 49c24.3 41.5 59 76.2 100.5 100.5S460.5 960 512 960s99.8-13.9 141.3-38.2a281.38 281.38 0 00123.2-149.5A120 120 0 01836 876c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8 0-79.3-48.1-147.4-116.7-176.7.4-6.4.7-12.8.7-19.3v-96h148c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM716 680c0 36.8-9.7 72-27.8 102.9-17.7 30.3-43 55.6-73.3 73.3C584 874.3 548.8 884 512 884s-72-9.7-102.9-27.8c-30.3-17.7-55.6-43-73.3-73.3A202.75 202.75 0 01308 680V412h408v268z" } }] }, "name": "bug", "theme": "outlined" };
	exports.default = BugOutlined;
	});

	var BugOutlinedSvg = unwrapExports(BugOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var BugOutlined = function BugOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BugOutlinedSvg
	  }));
	};

	BugOutlined.displayName = 'BugOutlined';
	var BugOutlined$1 = /*#__PURE__*/React.forwardRef(BugOutlined);

	var BugTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BugTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M308 412v268c0 36.78 9.68 71.96 27.8 102.9a205.39 205.39 0 0073.3 73.3A202.68 202.68 0 00512 884c36.78 0 71.96-9.68 102.9-27.8a205.39 205.39 0 0073.3-73.3A202.68 202.68 0 00716 680V412H308zm484 172v96c0 6.5-.22 12.95-.66 19.35C859.94 728.64 908 796.7 908 876a8 8 0 01-8 8h-56a8 8 0 01-8-8c0-44.24-23.94-82.89-59.57-103.7a278.63 278.63 0 01-22.66 49.02 281.39 281.39 0 01-100.45 100.45C611.84 946.07 563.55 960 512 960s-99.84-13.93-141.32-38.23a281.39 281.39 0 01-100.45-100.45 278.63 278.63 0 01-22.66-49.02A119.95 119.95 0 00188 876a8 8 0 01-8 8h-56a8 8 0 01-8-8c0-79.3 48.07-147.36 116.66-176.65A284.12 284.12 0 01232 680v-96H84a8 8 0 01-8-8v-56a8 8 0 018-8h148V412c-76.77 0-139-62.23-139-139a8 8 0 018-8h60a8 8 0 018 8 63 63 0 0063 63h560a63 63 0 0063-63 8 8 0 018-8h60a8 8 0 018 8c0 76.77-62.23 139-139 139v100h148a8 8 0 018 8v56a8 8 0 01-8 8H792zM368 272a8 8 0 01-8 8h-56a8 8 0 01-8-8c0-40.04 8.78-76.75 25.9-108.07a184.57 184.57 0 0174.03-74.03C427.25 72.78 463.96 64 504 64h16c40.04 0 76.75 8.78 108.07 25.9a184.57 184.57 0 0174.03 74.03C719.22 195.25 728 231.96 728 272a8 8 0 01-8 8h-56a8 8 0 01-8-8c0-28.33-5.94-53.15-17.08-73.53a112.56 112.56 0 00-45.39-45.4C573.15 141.95 548.33 136 520 136h-16c-28.33 0-53.15 5.94-73.53 17.08a112.56 112.56 0 00-45.4 45.39C373.95 218.85 368 243.67 368 272z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M308 412v268c0 36.78 9.68 71.96 27.8 102.9a205.39 205.39 0 0073.3 73.3A202.68 202.68 0 00512 884c36.78 0 71.96-9.68 102.9-27.8a205.39 205.39 0 0073.3-73.3A202.68 202.68 0 00716 680V412H308z", "fill": secondaryColor } }] }; }, "name": "bug", "theme": "twotone" };
	exports.default = BugTwoTone;
	});

	var BugTwoToneSvg = unwrapExports(BugTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var BugTwoTone = function BugTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BugTwoToneSvg
	  }));
	};

	BugTwoTone.displayName = 'BugTwoTone';
	var BugTwoTone$1 = /*#__PURE__*/React.forwardRef(BugTwoTone);

	var BuildFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BuildFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M916 210H376c-17.7 0-32 14.3-32 32v236H108c-17.7 0-32 14.3-32 32v272c0 17.7 14.3 32 32 32h540c17.7 0 32-14.3 32-32V546h236c17.7 0 32-14.3 32-32V242c0-17.7-14.3-32-32-32zM612 746H412V546h200v200zm268-268H680V278h200v200z" } }] }, "name": "build", "theme": "filled" };
	exports.default = BuildFilled;
	});

	var BuildFilledSvg = unwrapExports(BuildFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var BuildFilled = function BuildFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BuildFilledSvg
	  }));
	};

	BuildFilled.displayName = 'BuildFilled';
	var BuildFilled$1 = /*#__PURE__*/React.forwardRef(BuildFilled);

	var BuildOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BuildOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M916 210H376c-17.7 0-32 14.3-32 32v236H108c-17.7 0-32 14.3-32 32v272c0 17.7 14.3 32 32 32h540c17.7 0 32-14.3 32-32V546h236c17.7 0 32-14.3 32-32V242c0-17.7-14.3-32-32-32zm-504 68h200v200H412V278zm-68 468H144V546h200v200zm268 0H412V546h200v200zm268-268H680V278h200v200z" } }] }, "name": "build", "theme": "outlined" };
	exports.default = BuildOutlined;
	});

	var BuildOutlinedSvg = unwrapExports(BuildOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var BuildOutlined = function BuildOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BuildOutlinedSvg
	  }));
	};

	BuildOutlined.displayName = 'BuildOutlined';
	var BuildOutlined$1 = /*#__PURE__*/React.forwardRef(BuildOutlined);

	var BuildTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BuildTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M144 546h200v200H144zm268-268h200v200H412z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M916 210H376c-17.7 0-32 14.3-32 32v236H108c-17.7 0-32 14.3-32 32v272c0 17.7 14.3 32 32 32h540c17.7 0 32-14.3 32-32V546h236c17.7 0 32-14.3 32-32V242c0-17.7-14.3-32-32-32zM344 746H144V546h200v200zm268 0H412V546h200v200zm0-268H412V278h200v200zm268 0H680V278h200v200z", "fill": primaryColor } }] }; }, "name": "build", "theme": "twotone" };
	exports.default = BuildTwoTone;
	});

	var BuildTwoToneSvg = unwrapExports(BuildTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var BuildTwoTone = function BuildTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BuildTwoToneSvg
	  }));
	};

	BuildTwoTone.displayName = 'BuildTwoTone';
	var BuildTwoTone$1 = /*#__PURE__*/React.forwardRef(BuildTwoTone);

	var BulbFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BulbFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M348 676.1C250 619.4 184 513.4 184 392c0-181.1 146.9-328 328-328s328 146.9 328 328c0 121.4-66 227.4-164 284.1V792c0 17.7-14.3 32-32 32H380c-17.7 0-32-14.3-32-32V676.1zM392 888h240c4.4 0 8 3.6 8 8v32c0 17.7-14.3 32-32 32H416c-17.7 0-32-14.3-32-32v-32c0-4.4 3.6-8 8-8z" } }] }, "name": "bulb", "theme": "filled" };
	exports.default = BulbFilled;
	});

	var BulbFilledSvg = unwrapExports(BulbFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var BulbFilled = function BulbFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BulbFilledSvg
	  }));
	};

	BulbFilled.displayName = 'BulbFilled';
	var BulbFilled$1 = /*#__PURE__*/React.forwardRef(BulbFilled);

	var BulbOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BulbOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M632 888H392c-4.4 0-8 3.6-8 8v32c0 17.7 14.3 32 32 32h192c17.7 0 32-14.3 32-32v-32c0-4.4-3.6-8-8-8zM512 64c-181.1 0-328 146.9-328 328 0 121.4 66 227.4 164 284.1V792c0 17.7 14.3 32 32 32h264c17.7 0 32-14.3 32-32V676.1c98-56.7 164-162.7 164-284.1 0-181.1-146.9-328-328-328zm127.9 549.8L604 634.6V752H420V634.6l-35.9-20.8C305.4 568.3 256 484.5 256 392c0-141.4 114.6-256 256-256s256 114.6 256 256c0 92.5-49.4 176.3-128.1 221.8z" } }] }, "name": "bulb", "theme": "outlined" };
	exports.default = BulbOutlined;
	});

	var BulbOutlinedSvg = unwrapExports(BulbOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var BulbOutlined = function BulbOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BulbOutlinedSvg
	  }));
	};

	BulbOutlined.displayName = 'BulbOutlined';
	var BulbOutlined$1 = /*#__PURE__*/React.forwardRef(BulbOutlined);

	var BulbTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var BulbTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 136c-141.4 0-256 114.6-256 256 0 92.5 49.4 176.3 128.1 221.8l35.9 20.8V752h184V634.6l35.9-20.8C718.6 568.3 768 484.5 768 392c0-141.4-114.6-256-256-256z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M632 888H392c-4.4 0-8 3.6-8 8v32c0 17.7 14.3 32 32 32h192c17.7 0 32-14.3 32-32v-32c0-4.4-3.6-8-8-8zM512 64c-181.1 0-328 146.9-328 328 0 121.4 66 227.4 164 284.1V792c0 17.7 14.3 32 32 32h264c17.7 0 32-14.3 32-32V676.1c98-56.7 164-162.7 164-284.1 0-181.1-146.9-328-328-328zm127.9 549.8L604 634.6V752H420V634.6l-35.9-20.8C305.4 568.3 256 484.5 256 392c0-141.4 114.6-256 256-256s256 114.6 256 256c0 92.5-49.4 176.3-128.1 221.8z", "fill": primaryColor } }] }; }, "name": "bulb", "theme": "twotone" };
	exports.default = BulbTwoTone;
	});

	var BulbTwoToneSvg = unwrapExports(BulbTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var BulbTwoTone = function BulbTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: BulbTwoToneSvg
	  }));
	};

	BulbTwoTone.displayName = 'BulbTwoTone';
	var BulbTwoTone$1 = /*#__PURE__*/React.forwardRef(BulbTwoTone);

	var CalculatorFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CalculatorFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM440.2 765h-50.8c-2.2 0-4.5-1.1-5.9-2.9L348 718.6l-35.5 43.5a7.38 7.38 0 01-5.9 2.9h-50.8c-6.6 0-10.2-7.9-5.8-13.1l62.7-76.8-61.2-74.9c-4.3-5.2-.7-13.1 5.9-13.1h50.9c2.2 0 4.5 1.1 5.9 2.9l34 41.6 34-41.6c1.5-1.9 3.6-2.9 5.9-2.9h50.8c6.6 0 10.2 7.9 5.9 13.1L383.5 675l62.7 76.8c4.2 5.3.6 13.2-6 13.2zm7.8-382c0 2.2-1.4 4-3.2 4H376v68.7c0 1.9-1.8 3.3-4 3.3h-48c-2.2 0-4-1.4-4-3.2V387h-68.8c-1.8 0-3.2-1.8-3.2-4v-48c0-2.2 1.4-4 3.2-4H320v-68.8c0-1.8 1.8-3.2 4-3.2h48c2.2 0 4 1.4 4 3.2V331h68.7c1.9 0 3.3 1.8 3.3 4v48zm328 369c0 2.2-1.4 4-3.2 4H579.2c-1.8 0-3.2-1.8-3.2-4v-48c0-2.2 1.4-4 3.2-4h193.5c1.9 0 3.3 1.8 3.3 4v48zm0-104c0 2.2-1.4 4-3.2 4H579.2c-1.8 0-3.2-1.8-3.2-4v-48c0-2.2 1.4-4 3.2-4h193.5c1.9 0 3.3 1.8 3.3 4v48zm0-265c0 2.2-1.4 4-3.2 4H579.2c-1.8 0-3.2-1.8-3.2-4v-48c0-2.2 1.4-4 3.2-4h193.5c1.9 0 3.3 1.8 3.3 4v48z" } }] }, "name": "calculator", "theme": "filled" };
	exports.default = CalculatorFilled;
	});

	var CalculatorFilledSvg = unwrapExports(CalculatorFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var CalculatorFilled = function CalculatorFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CalculatorFilledSvg
	  }));
	};

	CalculatorFilled.displayName = 'CalculatorFilled';
	var CalculatorFilled$1 = /*#__PURE__*/React.forwardRef(CalculatorFilled);

	var CalculatorOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CalculatorOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M251.2 387H320v68.8c0 1.8 1.8 3.2 4 3.2h48c2.2 0 4-1.4 4-3.3V387h68.8c1.8 0 3.2-1.8 3.2-4v-48c0-2.2-1.4-4-3.3-4H376v-68.8c0-1.8-1.8-3.2-4-3.2h-48c-2.2 0-4 1.4-4 3.2V331h-68.8c-1.8 0-3.2 1.8-3.2 4v48c0 2.2 1.4 4 3.2 4zm328 0h193.6c1.8 0 3.2-1.8 3.2-4v-48c0-2.2-1.4-4-3.3-4H579.2c-1.8 0-3.2 1.8-3.2 4v48c0 2.2 1.4 4 3.2 4zm0 265h193.6c1.8 0 3.2-1.8 3.2-4v-48c0-2.2-1.4-4-3.3-4H579.2c-1.8 0-3.2 1.8-3.2 4v48c0 2.2 1.4 4 3.2 4zm0 104h193.6c1.8 0 3.2-1.8 3.2-4v-48c0-2.2-1.4-4-3.3-4H579.2c-1.8 0-3.2 1.8-3.2 4v48c0 2.2 1.4 4 3.2 4zm-195.7-81l61.2-74.9c4.3-5.2.7-13.1-5.9-13.1H388c-2.3 0-4.5 1-5.9 2.9l-34 41.6-34-41.6a7.85 7.85 0 00-5.9-2.9h-50.9c-6.6 0-10.2 7.9-5.9 13.1l61.2 74.9-62.7 76.8c-4.4 5.2-.8 13.1 5.8 13.1h50.8c2.3 0 4.5-1 5.9-2.9l35.5-43.5 35.5 43.5c1.5 1.8 3.7 2.9 5.9 2.9h50.8c6.6 0 10.2-7.9 5.9-13.1L383.5 675zM880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-36 732H180V180h664v664z" } }] }, "name": "calculator", "theme": "outlined" };
	exports.default = CalculatorOutlined;
	});

	var CalculatorOutlinedSvg = unwrapExports(CalculatorOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var CalculatorOutlined = function CalculatorOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CalculatorOutlinedSvg
	  }));
	};

	CalculatorOutlined.displayName = 'CalculatorOutlined';
	var CalculatorOutlined$1 = /*#__PURE__*/React.forwardRef(CalculatorOutlined);

	var CalculatorTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CalculatorTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M184 840h656V184H184v656zm256.2-75h-50.8c-2.2 0-4.5-1.1-5.9-2.9L348 718.6l-35.5 43.5a7.38 7.38 0 01-5.9 2.9h-50.8c-6.6 0-10.2-7.9-5.8-13.1l62.7-76.8-61.2-74.9c-4.3-5.2-.7-13.1 5.9-13.1h50.9c2.2 0 4.5 1.1 5.9 2.9l34 41.6 34-41.6c1.5-1.9 3.6-2.9 5.9-2.9h50.8c6.6 0 10.2 7.9 5.9 13.1L383.5 675l62.7 76.8c4.2 5.3.6 13.2-6 13.2zM576 335c0-2.2 1.4-4 3.2-4h193.5c1.9 0 3.3 1.8 3.3 4v48c0 2.2-1.4 4-3.2 4H579.2c-1.8 0-3.2-1.8-3.2-4v-48zm0 265c0-2.2 1.4-4 3.2-4h193.5c1.9 0 3.3 1.8 3.3 4v48c0 2.2-1.4 4-3.2 4H579.2c-1.8 0-3.2-1.8-3.2-4v-48zm0 104c0-2.2 1.4-4 3.2-4h193.5c1.9 0 3.3 1.8 3.3 4v48c0 2.2-1.4 4-3.2 4H579.2c-1.8 0-3.2-1.8-3.2-4v-48zM248 335c0-2.2 1.4-4 3.2-4H320v-68.8c0-1.8 1.8-3.2 4-3.2h48c2.2 0 4 1.4 4 3.2V331h68.7c1.9 0 3.3 1.8 3.3 4v48c0 2.2-1.4 4-3.2 4H376v68.7c0 1.9-1.8 3.3-4 3.3h-48c-2.2 0-4-1.4-4-3.2V387h-68.8c-1.8 0-3.2-1.8-3.2-4v-48z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M383.5 675l61.3-74.8c4.3-5.2.7-13.1-5.9-13.1h-50.8c-2.3 0-4.4 1-5.9 2.9l-34 41.6-34-41.6a7.69 7.69 0 00-5.9-2.9h-50.9c-6.6 0-10.2 7.9-5.9 13.1l61.2 74.9-62.7 76.8c-4.4 5.2-.8 13.1 5.8 13.1h50.8c2.3 0 4.4-1 5.9-2.9l35.5-43.5 35.5 43.5c1.4 1.8 3.7 2.9 5.9 2.9h50.8c6.6 0 10.2-7.9 6-13.2L383.5 675zM251.2 387H320v68.8c0 1.8 1.8 3.2 4 3.2h48c2.2 0 4-1.4 4-3.3V387h68.8c1.8 0 3.2-1.8 3.2-4v-48c0-2.2-1.4-4-3.3-4H376v-68.8c0-1.8-1.8-3.2-4-3.2h-48c-2.2 0-4 1.4-4 3.2V331h-68.8c-1.8 0-3.2 1.8-3.2 4v48c0 2.2 1.4 4 3.2 4zm328 369h193.6c1.8 0 3.2-1.8 3.2-4v-48c0-2.2-1.4-4-3.3-4H579.2c-1.8 0-3.2 1.8-3.2 4v48c0 2.2 1.4 4 3.2 4zm0-104h193.6c1.8 0 3.2-1.8 3.2-4v-48c0-2.2-1.4-4-3.3-4H579.2c-1.8 0-3.2 1.8-3.2 4v48c0 2.2 1.4 4 3.2 4zm0-265h193.6c1.8 0 3.2-1.8 3.2-4v-48c0-2.2-1.4-4-3.3-4H579.2c-1.8 0-3.2 1.8-3.2 4v48c0 2.2 1.4 4 3.2 4z", "fill": primaryColor } }] }; }, "name": "calculator", "theme": "twotone" };
	exports.default = CalculatorTwoTone;
	});

	var CalculatorTwoToneSvg = unwrapExports(CalculatorTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var CalculatorTwoTone = function CalculatorTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CalculatorTwoToneSvg
	  }));
	};

	CalculatorTwoTone.displayName = 'CalculatorTwoTone';
	var CalculatorTwoTone$1 = /*#__PURE__*/React.forwardRef(CalculatorTwoTone);

	var CalendarFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CalendarFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M112 880c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V460H112v420zm768-696H712v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H384v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H144c-17.7 0-32 14.3-32 32v176h800V216c0-17.7-14.3-32-32-32z" } }] }, "name": "calendar", "theme": "filled" };
	exports.default = CalendarFilled;
	});

	var CalendarFilledSvg = unwrapExports(CalendarFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var CalendarFilled = function CalendarFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CalendarFilledSvg
	  }));
	};

	CalendarFilled.displayName = 'CalendarFilled';
	var CalendarFilled$1 = /*#__PURE__*/React.forwardRef(CalendarFilled);

	var CalendarOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CalendarOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 184H712v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H384v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H144c-17.7 0-32 14.3-32 32v664c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V216c0-17.7-14.3-32-32-32zm-40 656H184V460h656v380zM184 392V256h128v48c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-48h256v48c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-48h128v136H184z" } }] }, "name": "calendar", "theme": "outlined" };
	exports.default = CalendarOutlined;
	});

	var CalendarOutlinedSvg = unwrapExports(CalendarOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var CalendarOutlined = function CalendarOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CalendarOutlinedSvg
	  }));
	};

	CalendarOutlined.displayName = 'CalendarOutlined';
	var CalendarOutlined$1 = /*#__PURE__*/React.forwardRef(CalendarOutlined);

	var CalendarTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CalendarTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M712 304c0 4.4-3.6 8-8 8h-56c-4.4 0-8-3.6-8-8v-48H384v48c0 4.4-3.6 8-8 8h-56c-4.4 0-8-3.6-8-8v-48H184v136h656V256H712v48z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M880 184H712v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H384v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H144c-17.7 0-32 14.3-32 32v664c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V216c0-17.7-14.3-32-32-32zm-40 656H184V460h656v380zm0-448H184V256h128v48c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-48h256v48c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-48h128v136z", "fill": primaryColor } }] }; }, "name": "calendar", "theme": "twotone" };
	exports.default = CalendarTwoTone;
	});

	var CalendarTwoToneSvg = unwrapExports(CalendarTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var CalendarTwoTone = function CalendarTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CalendarTwoToneSvg
	  }));
	};

	CalendarTwoTone.displayName = 'CalendarTwoTone';
	var CalendarTwoTone$1 = /*#__PURE__*/React.forwardRef(CalendarTwoTone);

	var CameraFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CameraFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M864 260H728l-32.4-90.8a32.07 32.07 0 00-30.2-21.2H358.6c-13.5 0-25.6 8.5-30.1 21.2L296 260H160c-44.2 0-80 35.8-80 80v456c0 44.2 35.8 80 80 80h704c44.2 0 80-35.8 80-80V340c0-44.2-35.8-80-80-80zM512 716c-88.4 0-160-71.6-160-160s71.6-160 160-160 160 71.6 160 160-71.6 160-160 160zm-96-160a96 96 0 10192 0 96 96 0 10-192 0z" } }] }, "name": "camera", "theme": "filled" };
	exports.default = CameraFilled;
	});

	var CameraFilledSvg = unwrapExports(CameraFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var CameraFilled = function CameraFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CameraFilledSvg
	  }));
	};

	CameraFilled.displayName = 'CameraFilled';
	var CameraFilled$1 = /*#__PURE__*/React.forwardRef(CameraFilled);

	var CameraOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CameraOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M864 248H728l-32.4-90.8a32.07 32.07 0 00-30.2-21.2H358.6c-13.5 0-25.6 8.5-30.1 21.2L296 248H160c-44.2 0-80 35.8-80 80v456c0 44.2 35.8 80 80 80h704c44.2 0 80-35.8 80-80V328c0-44.2-35.8-80-80-80zm8 536c0 4.4-3.6 8-8 8H160c-4.4 0-8-3.6-8-8V328c0-4.4 3.6-8 8-8h186.7l17.1-47.8 22.9-64.2h250.5l22.9 64.2 17.1 47.8H864c4.4 0 8 3.6 8 8v456zM512 384c-88.4 0-160 71.6-160 160s71.6 160 160 160 160-71.6 160-160-71.6-160-160-160zm0 256c-53 0-96-43-96-96s43-96 96-96 96 43 96 96-43 96-96 96z" } }] }, "name": "camera", "theme": "outlined" };
	exports.default = CameraOutlined;
	});

	var CameraOutlinedSvg = unwrapExports(CameraOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var CameraOutlined = function CameraOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CameraOutlinedSvg
	  }));
	};

	CameraOutlined.displayName = 'CameraOutlined';
	var CameraOutlined$1 = /*#__PURE__*/React.forwardRef(CameraOutlined);

	var CameraTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CameraTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M864 320H677.2l-17.1-47.8-22.9-64.2H386.7l-22.9 64.2-17.1 47.8H160c-4.4 0-8 3.6-8 8v456c0 4.4 3.6 8 8 8h704c4.4 0 8-3.6 8-8V328c0-4.4-3.6-8-8-8zM512 704c-88.4 0-160-71.6-160-160s71.6-160 160-160 160 71.6 160 160-71.6 160-160 160z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M512 384c-88.4 0-160 71.6-160 160s71.6 160 160 160 160-71.6 160-160-71.6-160-160-160zm0 256c-53 0-96-43-96-96s43-96 96-96 96 43 96 96-43 96-96 96z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M864 248H728l-32.4-90.8a32.07 32.07 0 00-30.2-21.2H358.6c-13.5 0-25.6 8.5-30.1 21.2L296 248H160c-44.2 0-80 35.8-80 80v456c0 44.2 35.8 80 80 80h704c44.2 0 80-35.8 80-80V328c0-44.2-35.8-80-80-80zm8 536c0 4.4-3.6 8-8 8H160c-4.4 0-8-3.6-8-8V328c0-4.4 3.6-8 8-8h186.7l17.1-47.8 22.9-64.2h250.5l22.9 64.2 17.1 47.8H864c4.4 0 8 3.6 8 8v456z", "fill": primaryColor } }] }; }, "name": "camera", "theme": "twotone" };
	exports.default = CameraTwoTone;
	});

	var CameraTwoToneSvg = unwrapExports(CameraTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var CameraTwoTone = function CameraTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CameraTwoToneSvg
	  }));
	};

	CameraTwoTone.displayName = 'CameraTwoTone';
	var CameraTwoTone$1 = /*#__PURE__*/React.forwardRef(CameraTwoTone);

	var CarFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CarFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M959 413.4L935.3 372a8 8 0 00-10.9-2.9l-50.7 29.6-78.3-216.2a63.9 63.9 0 00-60.9-44.4H301.2c-34.7 0-65.5 22.4-76.2 55.5l-74.6 205.2-50.8-29.6a8 8 0 00-10.9 2.9L65 413.4c-2.2 3.8-.9 8.6 2.9 10.8l60.4 35.2-14.5 40c-1.2 3.2-1.8 6.6-1.8 10v348.2c0 15.7 11.8 28.4 26.3 28.4h67.6c12.3 0 23-9.3 25.6-22.3l7.7-37.7h545.6l7.7 37.7c2.7 13 13.3 22.3 25.6 22.3h67.6c14.5 0 26.3-12.7 26.3-28.4V509.4c0-3.4-.6-6.8-1.8-10l-14.5-40 60.3-35.2a8 8 0 003-10.8zM264 621c-22.1 0-40-17.9-40-40s17.9-40 40-40 40 17.9 40 40-17.9 40-40 40zm388 75c0 4.4-3.6 8-8 8H380c-4.4 0-8-3.6-8-8v-84c0-4.4 3.6-8 8-8h40c4.4 0 8 3.6 8 8v36h168v-36c0-4.4 3.6-8 8-8h40c4.4 0 8 3.6 8 8v84zm108-75c-22.1 0-40-17.9-40-40s17.9-40 40-40 40 17.9 40 40-17.9 40-40 40zM220 418l72.7-199.9.5-1.3.4-1.3c1.1-3.3 4.1-5.5 7.6-5.5h427.6l75.4 208H220z" } }] }, "name": "car", "theme": "filled" };
	exports.default = CarFilled;
	});

	var CarFilledSvg = unwrapExports(CarFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var CarFilled = function CarFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CarFilledSvg
	  }));
	};

	CarFilled.displayName = 'CarFilled';
	var CarFilled$1 = /*#__PURE__*/React.forwardRef(CarFilled);

	var CarOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CarOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M380 704h264c4.4 0 8-3.6 8-8v-84c0-4.4-3.6-8-8-8h-40c-4.4 0-8 3.6-8 8v36H428v-36c0-4.4-3.6-8-8-8h-40c-4.4 0-8 3.6-8 8v84c0 4.4 3.6 8 8 8zm340-123a40 40 0 1080 0 40 40 0 10-80 0zm239-167.6L935.3 372a8 8 0 00-10.9-2.9l-50.7 29.6-78.3-216.2a63.9 63.9 0 00-60.9-44.4H301.2c-34.7 0-65.5 22.4-76.2 55.5l-74.6 205.2-50.8-29.6a8 8 0 00-10.9 2.9L65 413.4c-2.2 3.8-.9 8.6 2.9 10.8l60.4 35.2-14.5 40c-1.2 3.2-1.8 6.6-1.8 10v348.2c0 15.7 11.8 28.4 26.3 28.4h67.6c12.3 0 23-9.3 25.6-22.3l7.7-37.7h545.6l7.7 37.7c2.7 13 13.3 22.3 25.6 22.3h67.6c14.5 0 26.3-12.7 26.3-28.4V509.4c0-3.4-.6-6.8-1.8-10l-14.5-40 60.3-35.2a8 8 0 003-10.8zM840 517v237H184V517l15.6-43h624.8l15.6 43zM292.7 218.1l.5-1.3.4-1.3c1.1-3.3 4.1-5.5 7.6-5.5h427.6l75.4 208H220l72.7-199.9zM224 581a40 40 0 1080 0 40 40 0 10-80 0z" } }] }, "name": "car", "theme": "outlined" };
	exports.default = CarOutlined;
	});

	var CarOutlinedSvg = unwrapExports(CarOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var CarOutlined = function CarOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CarOutlinedSvg
	  }));
	};

	CarOutlined.displayName = 'CarOutlined';
	var CarOutlined$1 = /*#__PURE__*/React.forwardRef(CarOutlined);

	var CarTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CarTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M199.6 474L184 517v237h656V517l-15.6-43H199.6zM264 621c-22.1 0-40-17.9-40-40s17.9-40 40-40 40 17.9 40 40-17.9 40-40 40zm388 75c0 4.4-3.6 8-8 8H380c-4.4 0-8-3.6-8-8v-84c0-4.4 3.6-8 8-8h40c4.4 0 8 3.6 8 8v36h168v-36c0-4.4 3.6-8 8-8h40c4.4 0 8 3.6 8 8v84zm108-75c-22.1 0-40-17.9-40-40s17.9-40 40-40 40 17.9 40 40-17.9 40-40 40z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M720 581a40 40 0 1080 0 40 40 0 10-80 0z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M959 413.4L935.3 372a8 8 0 00-10.9-2.9l-50.7 29.6-78.3-216.2a63.9 63.9 0 00-60.9-44.4H301.2c-34.7 0-65.5 22.4-76.2 55.5l-74.6 205.2-50.8-29.6a8 8 0 00-10.9 2.9L65 413.4c-2.2 3.8-.9 8.6 2.9 10.8l60.4 35.2-14.5 40c-1.2 3.2-1.8 6.6-1.8 10v348.2c0 15.7 11.8 28.4 26.3 28.4h67.6c12.3 0 23-9.3 25.6-22.3l7.7-37.7h545.6l7.7 37.7c2.7 13 13.3 22.3 25.6 22.3h67.6c14.5 0 26.3-12.7 26.3-28.4V509.4c0-3.4-.6-6.8-1.8-10l-14.5-40 60.3-35.2a8 8 0 003-10.8zM292.7 218.1l.5-1.3.4-1.3c1.1-3.3 4.1-5.5 7.6-5.5h427.6l75.4 208H220l72.7-199.9zM840 754H184V517l15.6-43h624.8l15.6 43v237z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M224 581a40 40 0 1080 0 40 40 0 10-80 0zm420 23h-40c-4.4 0-8 3.6-8 8v36H428v-36c0-4.4-3.6-8-8-8h-40c-4.4 0-8 3.6-8 8v84c0 4.4 3.6 8 8 8h264c4.4 0 8-3.6 8-8v-84c0-4.4-3.6-8-8-8z", "fill": primaryColor } }] }; }, "name": "car", "theme": "twotone" };
	exports.default = CarTwoTone;
	});

	var CarTwoToneSvg = unwrapExports(CarTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var CarTwoTone = function CarTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CarTwoToneSvg
	  }));
	};

	CarTwoTone.displayName = 'CarTwoTone';
	var CarTwoTone$1 = /*#__PURE__*/React.forwardRef(CarTwoTone);

	var CaretDownFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CaretDownFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M840.4 300H183.6c-19.7 0-30.7 20.8-18.5 35l328.4 380.8c9.4 10.9 27.5 10.9 37 0L858.9 335c12.2-14.2 1.2-35-18.5-35z" } }] }, "name": "caret-down", "theme": "filled" };
	exports.default = CaretDownFilled;
	});

	var CaretDownFilledSvg = unwrapExports(CaretDownFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var CaretDownFilled = function CaretDownFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CaretDownFilledSvg
	  }));
	};

	CaretDownFilled.displayName = 'CaretDownFilled';
	var CaretDownFilled$1 = /*#__PURE__*/React.forwardRef(CaretDownFilled);

	var CaretDownOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CaretDownOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M840.4 300H183.6c-19.7 0-30.7 20.8-18.5 35l328.4 380.8c9.4 10.9 27.5 10.9 37 0L858.9 335c12.2-14.2 1.2-35-18.5-35z" } }] }, "name": "caret-down", "theme": "outlined" };
	exports.default = CaretDownOutlined;
	});

	var CaretDownOutlinedSvg = unwrapExports(CaretDownOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var CaretDownOutlined = function CaretDownOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CaretDownOutlinedSvg
	  }));
	};

	CaretDownOutlined.displayName = 'CaretDownOutlined';
	var CaretDownOutlined$1 = /*#__PURE__*/React.forwardRef(CaretDownOutlined);

	var CaretLeftFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CaretLeftFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M689 165.1L308.2 493.5c-10.9 9.4-10.9 27.5 0 37L689 858.9c14.2 12.2 35 1.2 35-18.5V183.6c0-19.7-20.8-30.7-35-18.5z" } }] }, "name": "caret-left", "theme": "filled" };
	exports.default = CaretLeftFilled;
	});

	var CaretLeftFilledSvg = unwrapExports(CaretLeftFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var CaretLeftFilled = function CaretLeftFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CaretLeftFilledSvg
	  }));
	};

	CaretLeftFilled.displayName = 'CaretLeftFilled';
	var CaretLeftFilled$1 = /*#__PURE__*/React.forwardRef(CaretLeftFilled);

	var CaretLeftOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CaretLeftOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M689 165.1L308.2 493.5c-10.9 9.4-10.9 27.5 0 37L689 858.9c14.2 12.2 35 1.2 35-18.5V183.6c0-19.7-20.8-30.7-35-18.5z" } }] }, "name": "caret-left", "theme": "outlined" };
	exports.default = CaretLeftOutlined;
	});

	var CaretLeftOutlinedSvg = unwrapExports(CaretLeftOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var CaretLeftOutlined = function CaretLeftOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CaretLeftOutlinedSvg
	  }));
	};

	CaretLeftOutlined.displayName = 'CaretLeftOutlined';
	var CaretLeftOutlined$1 = /*#__PURE__*/React.forwardRef(CaretLeftOutlined);

	var CaretRightFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CaretRightFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M715.8 493.5L335 165.1c-14.2-12.2-35-1.2-35 18.5v656.8c0 19.7 20.8 30.7 35 18.5l380.8-328.4c10.9-9.4 10.9-27.6 0-37z" } }] }, "name": "caret-right", "theme": "filled" };
	exports.default = CaretRightFilled;
	});

	var CaretRightFilledSvg = unwrapExports(CaretRightFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var CaretRightFilled = function CaretRightFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CaretRightFilledSvg
	  }));
	};

	CaretRightFilled.displayName = 'CaretRightFilled';
	var CaretRightFilled$1 = /*#__PURE__*/React.forwardRef(CaretRightFilled);

	var CaretRightOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CaretRightOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M715.8 493.5L335 165.1c-14.2-12.2-35-1.2-35 18.5v656.8c0 19.7 20.8 30.7 35 18.5l380.8-328.4c10.9-9.4 10.9-27.6 0-37z" } }] }, "name": "caret-right", "theme": "outlined" };
	exports.default = CaretRightOutlined;
	});

	var CaretRightOutlinedSvg = unwrapExports(CaretRightOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var CaretRightOutlined = function CaretRightOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CaretRightOutlinedSvg
	  }));
	};

	CaretRightOutlined.displayName = 'CaretRightOutlined';
	var CaretRightOutlined$1 = /*#__PURE__*/React.forwardRef(CaretRightOutlined);

	var CaretUpFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CaretUpFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M858.9 689L530.5 308.2c-9.4-10.9-27.5-10.9-37 0L165.1 689c-12.2 14.2-1.2 35 18.5 35h656.8c19.7 0 30.7-20.8 18.5-35z" } }] }, "name": "caret-up", "theme": "filled" };
	exports.default = CaretUpFilled;
	});

	var CaretUpFilledSvg = unwrapExports(CaretUpFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var CaretUpFilled = function CaretUpFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CaretUpFilledSvg
	  }));
	};

	CaretUpFilled.displayName = 'CaretUpFilled';
	var CaretUpFilled$1 = /*#__PURE__*/React.forwardRef(CaretUpFilled);

	var CaretUpOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CaretUpOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M858.9 689L530.5 308.2c-9.4-10.9-27.5-10.9-37 0L165.1 689c-12.2 14.2-1.2 35 18.5 35h656.8c19.7 0 30.7-20.8 18.5-35z" } }] }, "name": "caret-up", "theme": "outlined" };
	exports.default = CaretUpOutlined;
	});

	var CaretUpOutlinedSvg = unwrapExports(CaretUpOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var CaretUpOutlined = function CaretUpOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CaretUpOutlinedSvg
	  }));
	};

	CaretUpOutlined.displayName = 'CaretUpOutlined';
	var CaretUpOutlined$1 = /*#__PURE__*/React.forwardRef(CaretUpOutlined);

	var CarryOutFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CarryOutFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 184H712v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H384v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H144c-17.7 0-32 14.3-32 32v664c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V216c0-17.7-14.3-32-32-32zM694.5 432.7L481.9 725.4a16.1 16.1 0 01-26 0l-126.4-174c-3.8-5.3 0-12.7 6.5-12.7h55.2c5.1 0 10 2.5 13 6.6l64.7 89 150.9-207.8c3-4.1 7.8-6.6 13-6.6H688c6.5.1 10.3 7.5 6.5 12.8z" } }] }, "name": "carry-out", "theme": "filled" };
	exports.default = CarryOutFilled;
	});

	var CarryOutFilledSvg = unwrapExports(CarryOutFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var CarryOutFilled = function CarryOutFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CarryOutFilledSvg
	  }));
	};

	CarryOutFilled.displayName = 'CarryOutFilled';
	var CarryOutFilled$1 = /*#__PURE__*/React.forwardRef(CarryOutFilled);

	var CarryOutOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CarryOutOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 184H712v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H384v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H144c-17.7 0-32 14.3-32 32v664c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V216c0-17.7-14.3-32-32-32zm-40 656H184V256h128v48c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-48h256v48c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-48h128v584zM688 420h-55.2c-5.1 0-10 2.5-13 6.6L468.9 634.4l-64.7-89c-3-4.1-7.8-6.6-13-6.6H336c-6.5 0-10.3 7.4-6.5 12.7l126.4 174a16.1 16.1 0 0026 0l212.6-292.7c3.8-5.4 0-12.8-6.5-12.8z" } }] }, "name": "carry-out", "theme": "outlined" };
	exports.default = CarryOutOutlined;
	});

	var CarryOutOutlinedSvg = unwrapExports(CarryOutOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var CarryOutOutlined = function CarryOutOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CarryOutOutlinedSvg
	  }));
	};

	CarryOutOutlined.displayName = 'CarryOutOutlined';
	var CarryOutOutlined$1 = /*#__PURE__*/React.forwardRef(CarryOutOutlined);

	var CarryOutTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CarryOutTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 184H712v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H384v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H144c-17.7 0-32 14.3-32 32v664c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V216c0-17.7-14.3-32-32-32zm-40 656H184V256h128v48c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-48h256v48c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-48h128v584z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M712 304c0 4.4-3.6 8-8 8h-56c-4.4 0-8-3.6-8-8v-48H384v48c0 4.4-3.6 8-8 8h-56c-4.4 0-8-3.6-8-8v-48H184v584h656V256H712v48zm-17.5 128.8L481.9 725.5a16.1 16.1 0 01-26 0l-126.4-174c-3.8-5.3 0-12.7 6.5-12.7h55.2c5.2 0 10 2.5 13 6.6l64.7 89 150.9-207.8c3-4.1 7.9-6.6 13-6.6H688c6.5 0 10.3 7.4 6.5 12.8z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M688 420h-55.2c-5.1 0-10 2.5-13 6.6L468.9 634.4l-64.7-89c-3-4.1-7.8-6.6-13-6.6H336c-6.5 0-10.3 7.4-6.5 12.7l126.4 174a16.1 16.1 0 0026 0l212.6-292.7c3.8-5.4 0-12.8-6.5-12.8z", "fill": primaryColor } }] }; }, "name": "carry-out", "theme": "twotone" };
	exports.default = CarryOutTwoTone;
	});

	var CarryOutTwoToneSvg = unwrapExports(CarryOutTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var CarryOutTwoTone = function CarryOutTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CarryOutTwoToneSvg
	  }));
	};

	CarryOutTwoTone.displayName = 'CarryOutTwoTone';
	var CarryOutTwoTone$1 = /*#__PURE__*/React.forwardRef(CarryOutTwoTone);

	var CheckCircleFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CheckCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm193.5 301.7l-210.6 292a31.8 31.8 0 01-51.7 0L318.5 484.9c-3.8-5.3 0-12.7 6.5-12.7h46.9c10.2 0 19.9 4.9 25.9 13.3l71.2 98.8 157.2-218c6-8.3 15.6-13.3 25.9-13.3H699c6.5 0 10.3 7.4 6.5 12.7z" } }] }, "name": "check-circle", "theme": "filled" };
	exports.default = CheckCircleFilled;
	});

	var CheckCircleFilledSvg = unwrapExports(CheckCircleFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var CheckCircleFilled = function CheckCircleFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CheckCircleFilledSvg
	  }));
	};

	CheckCircleFilled.displayName = 'CheckCircleFilled';
	var CheckCircleFilled$1 = /*#__PURE__*/React.forwardRef(CheckCircleFilled);

	var CheckCircleOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CheckCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M699 353h-46.9c-10.2 0-19.9 4.9-25.9 13.3L469 584.3l-71.2-98.8c-6-8.3-15.6-13.3-25.9-13.3H325c-6.5 0-10.3 7.4-6.5 12.7l124.6 172.8a31.8 31.8 0 0051.7 0l210.6-292c3.9-5.3.1-12.7-6.4-12.7z" } }, { "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z" } }] }, "name": "check-circle", "theme": "outlined" };
	exports.default = CheckCircleOutlined;
	});

	var CheckCircleOutlinedSvg = unwrapExports(CheckCircleOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var CheckCircleOutlined = function CheckCircleOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CheckCircleOutlinedSvg
	  }));
	};

	CheckCircleOutlined.displayName = 'CheckCircleOutlined';
	var CheckCircleOutlined$1 = /*#__PURE__*/React.forwardRef(CheckCircleOutlined);

	var CheckCircleTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CheckCircleTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm193.4 225.7l-210.6 292a31.8 31.8 0 01-51.7 0L318.5 484.9c-3.8-5.3 0-12.7 6.5-12.7h46.9c10.3 0 19.9 5 25.9 13.3l71.2 98.8 157.2-218c6-8.4 15.7-13.3 25.9-13.3H699c6.5 0 10.3 7.4 6.4 12.7z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M699 353h-46.9c-10.2 0-19.9 4.9-25.9 13.3L469 584.3l-71.2-98.8c-6-8.3-15.6-13.3-25.9-13.3H325c-6.5 0-10.3 7.4-6.5 12.7l124.6 172.8a31.8 31.8 0 0051.7 0l210.6-292c3.9-5.3.1-12.7-6.4-12.7z", "fill": primaryColor } }] }; }, "name": "check-circle", "theme": "twotone" };
	exports.default = CheckCircleTwoTone;
	});

	var CheckCircleTwoToneSvg = unwrapExports(CheckCircleTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var CheckCircleTwoTone = function CheckCircleTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CheckCircleTwoToneSvg
	  }));
	};

	CheckCircleTwoTone.displayName = 'CheckCircleTwoTone';
	var CheckCircleTwoTone$1 = /*#__PURE__*/React.forwardRef(CheckCircleTwoTone);

	var CheckOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CheckOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M912 190h-69.9c-9.8 0-19.1 4.5-25.1 12.2L404.7 724.5 207 474a32 32 0 00-25.1-12.2H112c-6.7 0-10.4 7.7-6.3 12.9l273.9 347c12.8 16.2 37.4 16.2 50.3 0l488.4-618.9c4.1-5.1.4-12.8-6.3-12.8z" } }] }, "name": "check", "theme": "outlined" };
	exports.default = CheckOutlined;
	});

	var CheckOutlinedSvg = unwrapExports(CheckOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var CheckOutlined = function CheckOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CheckOutlinedSvg
	  }));
	};

	CheckOutlined.displayName = 'CheckOutlined';
	var CheckOutlined$1 = /*#__PURE__*/React.forwardRef(CheckOutlined);

	var CheckSquareFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CheckSquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM695.5 365.7l-210.6 292a31.8 31.8 0 01-51.7 0L308.5 484.9c-3.8-5.3 0-12.7 6.5-12.7h46.9c10.2 0 19.9 4.9 25.9 13.3l71.2 98.8 157.2-218c6-8.3 15.6-13.3 25.9-13.3H689c6.5 0 10.3 7.4 6.5 12.7z" } }] }, "name": "check-square", "theme": "filled" };
	exports.default = CheckSquareFilled;
	});

	var CheckSquareFilledSvg = unwrapExports(CheckSquareFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var CheckSquareFilled = function CheckSquareFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CheckSquareFilledSvg
	  }));
	};

	CheckSquareFilled.displayName = 'CheckSquareFilled';
	var CheckSquareFilled$1 = /*#__PURE__*/React.forwardRef(CheckSquareFilled);

	var CheckSquareOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CheckSquareOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M433.1 657.7a31.8 31.8 0 0051.7 0l210.6-292c3.8-5.3 0-12.7-6.5-12.7H642c-10.2 0-19.9 4.9-25.9 13.3L459 584.3l-71.2-98.8c-6-8.3-15.6-13.3-25.9-13.3H315c-6.5 0-10.3 7.4-6.5 12.7l124.6 172.8z" } }, { "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z" } }] }, "name": "check-square", "theme": "outlined" };
	exports.default = CheckSquareOutlined;
	});

	var CheckSquareOutlinedSvg = unwrapExports(CheckSquareOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var CheckSquareOutlined = function CheckSquareOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CheckSquareOutlinedSvg
	  }));
	};

	CheckSquareOutlined.displayName = 'CheckSquareOutlined';
	var CheckSquareOutlined$1 = /*#__PURE__*/React.forwardRef(CheckSquareOutlined);

	var CheckSquareTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CheckSquareTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M184 840h656V184H184v656zm130-367.8h46.9c10.2 0 19.9 4.9 25.9 13.3l71.2 98.8 157.2-218c6-8.3 15.6-13.3 25.9-13.3H688c6.5 0 10.3 7.4 6.5 12.7l-210.6 292a31.8 31.8 0 01-51.7 0L307.5 484.9c-3.8-5.3 0-12.7 6.5-12.7z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M432.2 657.7a31.8 31.8 0 0051.7 0l210.6-292c3.8-5.3 0-12.7-6.5-12.7h-46.9c-10.3 0-19.9 5-25.9 13.3L458 584.3l-71.2-98.8c-6-8.4-15.7-13.3-25.9-13.3H314c-6.5 0-10.3 7.4-6.5 12.7l124.7 172.8z", "fill": primaryColor } }] }; }, "name": "check-square", "theme": "twotone" };
	exports.default = CheckSquareTwoTone;
	});

	var CheckSquareTwoToneSvg = unwrapExports(CheckSquareTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var CheckSquareTwoTone = function CheckSquareTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CheckSquareTwoToneSvg
	  }));
	};

	CheckSquareTwoTone.displayName = 'CheckSquareTwoTone';
	var CheckSquareTwoTone$1 = /*#__PURE__*/React.forwardRef(CheckSquareTwoTone);

	var ChromeFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ChromeFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M371.8 512c0 77.5 62.7 140.2 140.2 140.2S652.2 589.5 652.2 512 589.5 371.8 512 371.8 371.8 434.4 371.8 512zM900 362.4l-234.3 12.1c63.6 74.3 64.6 181.5 11.1 263.7l-188 289.2c78 4.2 158.4-12.9 231.2-55.2 180-104 253-322.1 180-509.8zM320.3 591.9L163.8 284.1A415.35 415.35 0 0096 512c0 208 152.3 380.3 351.4 410.8l106.9-209.4c-96.6 18.2-189.9-34.8-234-121.5zm218.5-285.5l344.4 18.1C848 254.7 792.6 194 719.8 151.7 653.9 113.6 581.5 95.5 510.5 96c-122.5.5-242.2 55.2-322.1 154.5l128.2 196.9c32-91.9 124.8-146.7 222.2-141z" } }] }, "name": "chrome", "theme": "filled" };
	exports.default = ChromeFilled;
	});

	var ChromeFilledSvg = unwrapExports(ChromeFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var ChromeFilled = function ChromeFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ChromeFilledSvg
	  }));
	};

	ChromeFilled.displayName = 'ChromeFilled';
	var ChromeFilled$1 = /*#__PURE__*/React.forwardRef(ChromeFilled);

	var ChromeOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ChromeOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M928 512.3v-.3c0-229.8-186.2-416-416-416S96 282.2 96 512v.4c0 229.8 186.2 416 416 416s416-186.2 416-416v-.3.2zm-6.7-74.6l.6 3.3-.6-3.3zM676.7 638.2c53.5-82.2 52.5-189.4-11.1-263.7l162.4-8.4c20.5 44.4 32 93.8 32 145.9 0 185.2-144.6 336.6-327.1 347.4l143.8-221.2zM512 652.3c-77.5 0-140.2-62.7-140.2-140.2 0-77.7 62.7-140.2 140.2-140.2S652.2 434.5 652.2 512 589.5 652.3 512 652.3zm369.2-331.7l-3-5.7 3 5.7zM512 164c121.3 0 228.2 62.1 290.4 156.2l-263.6-13.9c-97.5-5.7-190.2 49.2-222.3 141.1L227.8 311c63.1-88.9 166.9-147 284.2-147zM102.5 585.8c26 145 127.1 264 261.6 315.1C229.6 850 128.5 731 102.5 585.8zM164 512c0-55.9 13.2-108.7 36.6-155.5l119.7 235.4c44.1 86.7 137.4 139.7 234 121.6l-74 145.1C302.9 842.5 164 693.5 164 512zm324.7 415.4c4 .2 8 .4 12 .5-4-.2-8-.3-12-.5z" } }] }, "name": "chrome", "theme": "outlined" };
	exports.default = ChromeOutlined;
	});

	var ChromeOutlinedSvg = unwrapExports(ChromeOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var ChromeOutlined = function ChromeOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ChromeOutlinedSvg
	  }));
	};

	ChromeOutlined.displayName = 'ChromeOutlined';
	var ChromeOutlined$1 = /*#__PURE__*/React.forwardRef(ChromeOutlined);

	var CiCircleFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CiCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm-63.6 656c-103 0-162.4-68.6-162.4-182.6v-49C286 373.5 345.4 304 448.3 304c88.3 0 152.3 56.9 152.3 138.1 0 2.4-2 4.4-4.4 4.4h-52.6c-4.2 0-7.6-3.2-8-7.4-4-46.1-37.6-77.6-87-77.6-61.1 0-95.6 45.4-95.6 126.9v49.3c0 80.3 34.5 125.1 95.6 125.1 49.3 0 82.8-29.5 87-72.4.4-4.1 3.8-7.3 8-7.3h52.7c2.4 0 4.4 2 4.4 4.4 0 77.4-64.3 132.5-152.3 132.5zM738 704.1c0 4.4-3.6 8-8 8h-50.4c-4.4 0-8-3.6-8-8V319.9c0-4.4 3.6-8 8-8H730c4.4 0 8 3.6 8 8v384.2z" } }] }, "name": "ci-circle", "theme": "filled" };
	exports.default = CiCircleFilled;
	});

	var CiCircleFilledSvg = unwrapExports(CiCircleFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var CiCircleFilled = function CiCircleFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CiCircleFilledSvg
	  }));
	};

	CiCircleFilled.displayName = 'CiCircleFilled';
	var CiCircleFilled$1 = /*#__PURE__*/React.forwardRef(CiCircleFilled);

	var CiCircleOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CiCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372zm218-572.1h-50.4c-4.4 0-8 3.6-8 8v384.2c0 4.4 3.6 8 8 8H730c4.4 0 8-3.6 8-8V319.9c0-4.4-3.6-8-8-8zm-281.4 49.6c49.5 0 83.1 31.5 87 77.6.4 4.2 3.8 7.4 8 7.4h52.6c2.4 0 4.4-2 4.4-4.4 0-81.2-64-138.1-152.3-138.1C345.4 304 286 373.5 286 488.4v49c0 114 59.4 182.6 162.3 182.6 88 0 152.3-55.1 152.3-132.5 0-2.4-2-4.4-4.4-4.4h-52.7c-4.2 0-7.6 3.2-8 7.3-4.2 43-37.7 72.4-87 72.4-61.1 0-95.6-44.9-95.6-125.2v-49.3c.1-81.4 34.6-126.8 95.7-126.8z" } }] }, "name": "ci-circle", "theme": "outlined" };
	exports.default = CiCircleOutlined;
	});

	var CiCircleOutlinedSvg = unwrapExports(CiCircleOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var CiCircleOutlined = function CiCircleOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CiCircleOutlinedSvg
	  }));
	};

	CiCircleOutlined.displayName = 'CiCircleOutlined';
	var CiCircleOutlined$1 = /*#__PURE__*/React.forwardRef(CiCircleOutlined);

	var CiCircleTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CiCircleTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm-63.5 522.8c49.3 0 82.8-29.4 87-72.4.4-4.1 3.8-7.3 8-7.3h52.7c2.4 0 4.4 2 4.4 4.4 0 77.4-64.3 132.5-152.3 132.5C345.4 720 286 651.4 286 537.4v-49C286 373.5 345.4 304 448.3 304c88.3 0 152.3 56.9 152.3 138.1 0 2.4-2 4.4-4.4 4.4h-52.6c-4.2 0-7.6-3.2-8-7.4-3.9-46.1-37.5-77.6-87-77.6-61.1 0-95.6 45.4-95.7 126.8v49.3c0 80.3 34.5 125.2 95.6 125.2zM738 704.1c0 4.4-3.6 8-8 8h-50.4c-4.4 0-8-3.6-8-8V319.9c0-4.4 3.6-8 8-8H730c4.4 0 8 3.6 8 8v384.2z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M730 311.9h-50.4c-4.4 0-8 3.6-8 8v384.2c0 4.4 3.6 8 8 8H730c4.4 0 8-3.6 8-8V319.9c0-4.4-3.6-8-8-8zm-281.4 49.6c49.5 0 83.1 31.5 87 77.6.4 4.2 3.8 7.4 8 7.4h52.6c2.4 0 4.4-2 4.4-4.4 0-81.2-64-138.1-152.3-138.1C345.4 304 286 373.5 286 488.4v49c0 114 59.4 182.6 162.3 182.6 88 0 152.3-55.1 152.3-132.5 0-2.4-2-4.4-4.4-4.4h-52.7c-4.2 0-7.6 3.2-8 7.3-4.2 43-37.7 72.4-87 72.4-61.1 0-95.6-44.9-95.6-125.2v-49.3c.1-81.4 34.6-126.8 95.7-126.8z", "fill": primaryColor } }] }; }, "name": "ci-circle", "theme": "twotone" };
	exports.default = CiCircleTwoTone;
	});

	var CiCircleTwoToneSvg = unwrapExports(CiCircleTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var CiCircleTwoTone = function CiCircleTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CiCircleTwoToneSvg
	  }));
	};

	CiCircleTwoTone.displayName = 'CiCircleTwoTone';
	var CiCircleTwoTone$1 = /*#__PURE__*/React.forwardRef(CiCircleTwoTone);

	var CiOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CiOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372zm218-572.1h-50.4c-4.4 0-8 3.6-8 8v384.2c0 4.4 3.6 8 8 8H730c4.4 0 8-3.6 8-8V319.9c0-4.4-3.6-8-8-8zm-281.4 49.6c49.5 0 83.1 31.5 87 77.6.4 4.2 3.8 7.4 8 7.4h52.6c2.4 0 4.4-2 4.4-4.4 0-81.2-64-138.1-152.3-138.1C345.4 304 286 373.5 286 488.4v49c0 114 59.4 182.6 162.3 182.6 88 0 152.3-55.1 152.3-132.5 0-2.4-2-4.4-4.4-4.4h-52.7c-4.2 0-7.6 3.2-8 7.3-4.2 43-37.7 72.4-87 72.4-61.1 0-95.6-44.9-95.6-125.2v-49.3c.1-81.4 34.6-126.8 95.7-126.8z" } }] }, "name": "ci", "theme": "outlined" };
	exports.default = CiOutlined;
	});

	var CiOutlinedSvg = unwrapExports(CiOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var CiOutlined = function CiOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CiOutlinedSvg
	  }));
	};

	CiOutlined.displayName = 'CiOutlined';
	var CiOutlined$1 = /*#__PURE__*/React.forwardRef(CiOutlined);

	var CiTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CiTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm-63.5 522.8c49.3 0 82.8-29.4 87-72.4.4-4.1 3.8-7.3 8-7.3h52.7c2.4 0 4.4 2 4.4 4.4 0 77.4-64.3 132.5-152.3 132.5C345.4 720 286 651.4 286 537.4v-49C286 373.5 345.4 304 448.3 304c88.3 0 152.3 56.9 152.3 138.1 0 2.4-2 4.4-4.4 4.4h-52.6c-4.2 0-7.6-3.2-8-7.4-3.9-46.1-37.5-77.6-87-77.6-61.1 0-95.6 45.4-95.7 126.8v49.3c0 80.3 34.5 125.2 95.6 125.2zM738 704.1c0 4.4-3.6 8-8 8h-50.4c-4.4 0-8-3.6-8-8V319.9c0-4.4 3.6-8 8-8H730c4.4 0 8 3.6 8 8v384.2z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M730 311.9h-50.4c-4.4 0-8 3.6-8 8v384.2c0 4.4 3.6 8 8 8H730c4.4 0 8-3.6 8-8V319.9c0-4.4-3.6-8-8-8zm-281.4 49.6c49.5 0 83.1 31.5 87 77.6.4 4.2 3.8 7.4 8 7.4h52.6c2.4 0 4.4-2 4.4-4.4 0-81.2-64-138.1-152.3-138.1C345.4 304 286 373.5 286 488.4v49c0 114 59.4 182.6 162.3 182.6 88 0 152.3-55.1 152.3-132.5 0-2.4-2-4.4-4.4-4.4h-52.7c-4.2 0-7.6 3.2-8 7.3-4.2 43-37.7 72.4-87 72.4-61.1 0-95.6-44.9-95.6-125.2v-49.3c.1-81.4 34.6-126.8 95.7-126.8z", "fill": primaryColor } }] }; }, "name": "ci", "theme": "twotone" };
	exports.default = CiTwoTone;
	});

	var CiTwoToneSvg = unwrapExports(CiTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var CiTwoTone = function CiTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CiTwoToneSvg
	  }));
	};

	CiTwoTone.displayName = 'CiTwoTone';
	var CiTwoTone$1 = /*#__PURE__*/React.forwardRef(CiTwoTone);

	var ClearOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ClearOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M899.1 869.6l-53-305.6H864c14.4 0 26-11.6 26-26V346c0-14.4-11.6-26-26-26H618V138c0-14.4-11.6-26-26-26H432c-14.4 0-26 11.6-26 26v182H160c-14.4 0-26 11.6-26 26v192c0 14.4 11.6 26 26 26h17.9l-53 305.6a25.95 25.95 0 0025.6 30.4h723c1.5 0 3-.1 4.4-.4a25.88 25.88 0 0021.2-30zM204 390h272V182h72v208h272v104H204V390zm468 440V674c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v156H416V674c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v156H202.8l45.1-260H776l45.1 260H672z" } }] }, "name": "clear", "theme": "outlined" };
	exports.default = ClearOutlined;
	});

	var ClearOutlinedSvg = unwrapExports(ClearOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var ClearOutlined = function ClearOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ClearOutlinedSvg
	  }));
	};

	ClearOutlined.displayName = 'ClearOutlined';
	var ClearOutlined$1 = /*#__PURE__*/React.forwardRef(ClearOutlined);

	var ClockCircleFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ClockCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm176.5 585.7l-28.6 39a7.99 7.99 0 01-11.2 1.7L483.3 569.8a7.92 7.92 0 01-3.3-6.5V288c0-4.4 3.6-8 8-8h48.1c4.4 0 8 3.6 8 8v247.5l142.6 103.1c3.6 2.5 4.4 7.5 1.8 11.1z" } }] }, "name": "clock-circle", "theme": "filled" };
	exports.default = ClockCircleFilled;
	});

	var ClockCircleFilledSvg = unwrapExports(ClockCircleFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var ClockCircleFilled = function ClockCircleFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ClockCircleFilledSvg
	  }));
	};

	ClockCircleFilled.displayName = 'ClockCircleFilled';
	var ClockCircleFilled$1 = /*#__PURE__*/React.forwardRef(ClockCircleFilled);

	var ClockCircleOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ClockCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z" } }, { "tag": "path", "attrs": { "d": "M686.7 638.6L544.1 535.5V288c0-4.4-3.6-8-8-8H488c-4.4 0-8 3.6-8 8v275.4c0 2.6 1.2 5 3.3 6.5l165.4 120.6c3.6 2.6 8.6 1.8 11.2-1.7l28.6-39c2.6-3.7 1.8-8.7-1.8-11.2z" } }] }, "name": "clock-circle", "theme": "outlined" };
	exports.default = ClockCircleOutlined;
	});

	var ClockCircleOutlinedSvg = unwrapExports(ClockCircleOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var ClockCircleOutlined = function ClockCircleOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ClockCircleOutlinedSvg
	  }));
	};

	ClockCircleOutlined.displayName = 'ClockCircleOutlined';
	var ClockCircleOutlined$1 = /*#__PURE__*/React.forwardRef(ClockCircleOutlined);

	var ClockCircleTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ClockCircleTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm176.5 509.7l-28.6 39a7.99 7.99 0 01-11.2 1.7L483.3 569.8a7.92 7.92 0 01-3.3-6.5V288c0-4.4 3.6-8 8-8h48.1c4.4 0 8 3.6 8 8v247.5l142.6 103.1c3.6 2.5 4.4 7.5 1.8 11.1z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M686.7 638.6L544.1 535.5V288c0-4.4-3.6-8-8-8H488c-4.4 0-8 3.6-8 8v275.3c0 2.6 1.2 5 3.3 6.5l165.4 120.6c3.6 2.6 8.6 1.9 11.2-1.7l28.6-39c2.6-3.6 1.8-8.6-1.8-11.1z", "fill": primaryColor } }] }; }, "name": "clock-circle", "theme": "twotone" };
	exports.default = ClockCircleTwoTone;
	});

	var ClockCircleTwoToneSvg = unwrapExports(ClockCircleTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var ClockCircleTwoTone = function ClockCircleTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ClockCircleTwoToneSvg
	  }));
	};

	ClockCircleTwoTone.displayName = 'ClockCircleTwoTone';
	var ClockCircleTwoTone$1 = /*#__PURE__*/React.forwardRef(ClockCircleTwoTone);

	var CloseCircleFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CloseCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm165.4 618.2l-66-.3L512 563.4l-99.3 118.4-66.1.3c-4.4 0-8-3.5-8-8 0-1.9.7-3.7 1.9-5.2l130.1-155L340.5 359a8.32 8.32 0 01-1.9-5.2c0-4.4 3.6-8 8-8l66.1.3L512 464.6l99.3-118.4 66-.3c4.4 0 8 3.5 8 8 0 1.9-.7 3.7-1.9 5.2L553.5 514l130 155c1.2 1.5 1.9 3.3 1.9 5.2 0 4.4-3.6 8-8 8z" } }] }, "name": "close-circle", "theme": "filled" };
	exports.default = CloseCircleFilled;
	});

	var CloseCircleFilledSvg = unwrapExports(CloseCircleFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var CloseCircleFilled = function CloseCircleFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CloseCircleFilledSvg
	  }));
	};

	CloseCircleFilled.displayName = 'CloseCircleFilled';
	var CloseCircleFilled$1 = /*#__PURE__*/React.forwardRef(CloseCircleFilled);

	var CloseCircleOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CloseCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M685.4 354.8c0-4.4-3.6-8-8-8l-66 .3L512 465.6l-99.3-118.4-66.1-.3c-4.4 0-8 3.5-8 8 0 1.9.7 3.7 1.9 5.2l130.1 155L340.5 670a8.32 8.32 0 00-1.9 5.2c0 4.4 3.6 8 8 8l66.1-.3L512 564.4l99.3 118.4 66 .3c4.4 0 8-3.5 8-8 0-1.9-.7-3.7-1.9-5.2L553.5 515l130.1-155c1.2-1.4 1.8-3.3 1.8-5.2z" } }, { "tag": "path", "attrs": { "d": "M512 65C264.6 65 64 265.6 64 513s200.6 448 448 448 448-200.6 448-448S759.4 65 512 65zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z" } }] }, "name": "close-circle", "theme": "outlined" };
	exports.default = CloseCircleOutlined;
	});

	var CloseCircleOutlinedSvg = unwrapExports(CloseCircleOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var CloseCircleOutlined = function CloseCircleOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CloseCircleOutlinedSvg
	  }));
	};

	CloseCircleOutlined.displayName = 'CloseCircleOutlined';
	var CloseCircleOutlined$1 = /*#__PURE__*/React.forwardRef(CloseCircleOutlined);

	var CloseCircleTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CloseCircleTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm171.8 527.1c1.2 1.5 1.9 3.3 1.9 5.2 0 4.5-3.6 8-8 8l-66-.3-99.3-118.4-99.3 118.5-66.1.3c-4.4 0-8-3.6-8-8 0-1.9.7-3.7 1.9-5.2L471 512.3l-130.1-155a8.32 8.32 0 01-1.9-5.2c0-4.5 3.6-8 8-8l66.1.3 99.3 118.4 99.4-118.5 66-.3c4.4 0 8 3.6 8 8 0 1.9-.6 3.8-1.8 5.2l-130.1 155 129.9 154.9z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M685.8 352c0-4.4-3.6-8-8-8l-66 .3-99.4 118.5-99.3-118.4-66.1-.3c-4.4 0-8 3.5-8 8 0 1.9.7 3.7 1.9 5.2l130.1 155-130.1 154.9a8.32 8.32 0 00-1.9 5.2c0 4.4 3.6 8 8 8l66.1-.3 99.3-118.5L611.7 680l66 .3c4.4 0 8-3.5 8-8 0-1.9-.7-3.7-1.9-5.2L553.9 512.2l130.1-155c1.2-1.4 1.8-3.3 1.8-5.2z", "fill": primaryColor } }] }; }, "name": "close-circle", "theme": "twotone" };
	exports.default = CloseCircleTwoTone;
	});

	var CloseCircleTwoToneSvg = unwrapExports(CloseCircleTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var CloseCircleTwoTone = function CloseCircleTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CloseCircleTwoToneSvg
	  }));
	};

	CloseCircleTwoTone.displayName = 'CloseCircleTwoTone';
	var CloseCircleTwoTone$1 = /*#__PURE__*/React.forwardRef(CloseCircleTwoTone);

	var CloseOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CloseOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M563.8 512l262.5-312.9c4.4-5.2.7-13.1-6.1-13.1h-79.8c-4.7 0-9.2 2.1-12.3 5.7L511.6 449.8 295.1 191.7c-3-3.6-7.5-5.7-12.3-5.7H203c-6.8 0-10.5 7.9-6.1 13.1L459.4 512 196.9 824.9A7.95 7.95 0 00203 838h79.8c4.7 0 9.2-2.1 12.3-5.7l216.5-258.1 216.5 258.1c3 3.6 7.5 5.7 12.3 5.7h79.8c6.8 0 10.5-7.9 6.1-13.1L563.8 512z" } }] }, "name": "close", "theme": "outlined" };
	exports.default = CloseOutlined;
	});

	var CloseOutlinedSvg = unwrapExports(CloseOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var CloseOutlined = function CloseOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CloseOutlinedSvg
	  }));
	};

	CloseOutlined.displayName = 'CloseOutlined';
	var CloseOutlined$1 = /*#__PURE__*/React.forwardRef(CloseOutlined);

	var CloseSquareFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CloseSquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM676.1 657.9c4.4 5.2.7 13.1-6.1 13.1h-58.9c-4.7 0-9.2-2.1-12.3-5.7L512 561.8l-86.8 103.5c-3 3.6-7.5 5.7-12.3 5.7H354c-6.8 0-10.5-7.9-6.1-13.1L470.2 512 347.9 366.1A7.95 7.95 0 01354 353h58.9c4.7 0 9.2 2.1 12.3 5.7L512 462.2l86.8-103.5c3-3.6 7.5-5.7 12.3-5.7H670c6.8 0 10.5 7.9 6.1 13.1L553.8 512l122.3 145.9z" } }] }, "name": "close-square", "theme": "filled" };
	exports.default = CloseSquareFilled;
	});

	var CloseSquareFilledSvg = unwrapExports(CloseSquareFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var CloseSquareFilled = function CloseSquareFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CloseSquareFilledSvg
	  }));
	};

	CloseSquareFilled.displayName = 'CloseSquareFilled';
	var CloseSquareFilled$1 = /*#__PURE__*/React.forwardRef(CloseSquareFilled);

	var CloseSquareOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CloseSquareOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M354 671h58.9c4.7 0 9.2-2.1 12.3-5.7L512 561.8l86.8 103.5c3 3.6 7.5 5.7 12.3 5.7H670c6.8 0 10.5-7.9 6.1-13.1L553.8 512l122.4-145.9c4.4-5.2.7-13.1-6.1-13.1h-58.9c-4.7 0-9.2 2.1-12.3 5.7L512 462.2l-86.8-103.5c-3-3.6-7.5-5.7-12.3-5.7H354c-6.8 0-10.5 7.9-6.1 13.1L470.2 512 347.9 657.9A7.95 7.95 0 00354 671z" } }, { "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z" } }] }, "name": "close-square", "theme": "outlined" };
	exports.default = CloseSquareOutlined;
	});

	var CloseSquareOutlinedSvg = unwrapExports(CloseSquareOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var CloseSquareOutlined = function CloseSquareOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CloseSquareOutlinedSvg
	  }));
	};

	CloseSquareOutlined.displayName = 'CloseSquareOutlined';
	var CloseSquareOutlined$1 = /*#__PURE__*/React.forwardRef(CloseSquareOutlined);

	var CloseSquareTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CloseSquareTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M184 840h656V184H184v656zm163.9-473.9A7.95 7.95 0 01354 353h58.9c4.7 0 9.2 2.1 12.3 5.7L512 462.2l86.8-103.5c3-3.6 7.5-5.7 12.3-5.7H670c6.8 0 10.5 7.9 6.1 13.1L553.8 512l122.3 145.9c4.4 5.2.7 13.1-6.1 13.1h-58.9c-4.7 0-9.2-2.1-12.3-5.7L512 561.8l-86.8 103.5c-3 3.6-7.5 5.7-12.3 5.7H354c-6.8 0-10.5-7.9-6.1-13.1L470.2 512 347.9 366.1z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M354 671h58.9c4.8 0 9.3-2.1 12.3-5.7L512 561.8l86.8 103.5c3.1 3.6 7.6 5.7 12.3 5.7H670c6.8 0 10.5-7.9 6.1-13.1L553.8 512l122.3-145.9c4.4-5.2.7-13.1-6.1-13.1h-58.9c-4.8 0-9.3 2.1-12.3 5.7L512 462.2l-86.8-103.5c-3.1-3.6-7.6-5.7-12.3-5.7H354c-6.8 0-10.5 7.9-6.1 13.1L470.2 512 347.9 657.9A7.95 7.95 0 00354 671z", "fill": primaryColor } }] }; }, "name": "close-square", "theme": "twotone" };
	exports.default = CloseSquareTwoTone;
	});

	var CloseSquareTwoToneSvg = unwrapExports(CloseSquareTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var CloseSquareTwoTone = function CloseSquareTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CloseSquareTwoToneSvg
	  }));
	};

	CloseSquareTwoTone.displayName = 'CloseSquareTwoTone';
	var CloseSquareTwoTone$1 = /*#__PURE__*/React.forwardRef(CloseSquareTwoTone);

	var CloudDownloadOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CloudDownloadOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M624 706.3h-74.1V464c0-4.4-3.6-8-8-8h-60c-4.4 0-8 3.6-8 8v242.3H400c-6.7 0-10.4 7.7-6.3 12.9l112 141.7a8 8 0 0012.6 0l112-141.7c4.1-5.2.4-12.9-6.3-12.9z" } }, { "tag": "path", "attrs": { "d": "M811.4 366.7C765.6 245.9 648.9 160 512.2 160S258.8 245.8 213 366.6C127.3 389.1 64 467.2 64 560c0 110.5 89.5 200 199.9 200H304c4.4 0 8-3.6 8-8v-60c0-4.4-3.6-8-8-8h-40.1c-33.7 0-65.4-13.4-89-37.7-23.5-24.2-36-56.8-34.9-90.6.9-26.4 9.9-51.2 26.2-72.1 16.7-21.3 40.1-36.8 66.1-43.7l37.9-9.9 13.9-36.6c8.6-22.8 20.6-44.1 35.7-63.4a245.6 245.6 0 0152.4-49.9c41.1-28.9 89.5-44.2 140-44.2s98.9 15.3 140 44.2c19.9 14 37.5 30.8 52.4 49.9 15.1 19.3 27.1 40.7 35.7 63.4l13.8 36.5 37.8 10C846.1 454.5 884 503.8 884 560c0 33.1-12.9 64.3-36.3 87.7a123.07 123.07 0 01-87.6 36.3H720c-4.4 0-8 3.6-8 8v60c0 4.4 3.6 8 8 8h40.1C870.5 760 960 670.5 960 560c0-92.7-63.1-170.7-148.6-193.3z" } }] }, "name": "cloud-download", "theme": "outlined" };
	exports.default = CloudDownloadOutlined;
	});

	var CloudDownloadOutlinedSvg = unwrapExports(CloudDownloadOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var CloudDownloadOutlined = function CloudDownloadOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CloudDownloadOutlinedSvg
	  }));
	};

	CloudDownloadOutlined.displayName = 'CloudDownloadOutlined';
	var CloudDownloadOutlined$1 = /*#__PURE__*/React.forwardRef(CloudDownloadOutlined);

	var CloudFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CloudFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M811.4 418.7C765.6 297.9 648.9 212 512.2 212S258.8 297.8 213 418.6C127.3 441.1 64 519.1 64 612c0 110.5 89.5 200 199.9 200h496.2C870.5 812 960 722.5 960 612c0-92.7-63.1-170.7-148.6-193.3z" } }] }, "name": "cloud", "theme": "filled" };
	exports.default = CloudFilled;
	});

	var CloudFilledSvg = unwrapExports(CloudFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var CloudFilled = function CloudFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CloudFilledSvg
	  }));
	};

	CloudFilled.displayName = 'CloudFilled';
	var CloudFilled$1 = /*#__PURE__*/React.forwardRef(CloudFilled);

	var CloudOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CloudOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M811.4 418.7C765.6 297.9 648.9 212 512.2 212S258.8 297.8 213 418.6C127.3 441.1 64 519.1 64 612c0 110.5 89.5 200 199.9 200h496.2C870.5 812 960 722.5 960 612c0-92.7-63.1-170.7-148.6-193.3zm36.3 281a123.07 123.07 0 01-87.6 36.3H263.9c-33.1 0-64.2-12.9-87.6-36.3A123.3 123.3 0 01140 612c0-28 9.1-54.3 26.2-76.3a125.7 125.7 0 0166.1-43.7l37.9-9.9 13.9-36.6c8.6-22.8 20.6-44.1 35.7-63.4a245.6 245.6 0 0152.4-49.9c41.1-28.9 89.5-44.2 140-44.2s98.9 15.3 140 44.2c19.9 14 37.5 30.8 52.4 49.9 15.1 19.3 27.1 40.7 35.7 63.4l13.8 36.5 37.8 10c54.3 14.5 92.1 63.8 92.1 120 0 33.1-12.9 64.3-36.3 87.7z" } }] }, "name": "cloud", "theme": "outlined" };
	exports.default = CloudOutlined;
	});

	var CloudOutlinedSvg = unwrapExports(CloudOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var CloudOutlined = function CloudOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CloudOutlinedSvg
	  }));
	};

	CloudOutlined.displayName = 'CloudOutlined';
	var CloudOutlined$1 = /*#__PURE__*/React.forwardRef(CloudOutlined);

	var CloudServerOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CloudServerOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M704 446H320c-4.4 0-8 3.6-8 8v402c0 4.4 3.6 8 8 8h384c4.4 0 8-3.6 8-8V454c0-4.4-3.6-8-8-8zm-328 64h272v117H376V510zm272 290H376V683h272v117z" } }, { "tag": "path", "attrs": { "d": "M424 748a32 32 0 1064 0 32 32 0 10-64 0zm0-178a32 32 0 1064 0 32 32 0 10-64 0z" } }, { "tag": "path", "attrs": { "d": "M811.4 368.9C765.6 248 648.9 162 512.2 162S258.8 247.9 213 368.8C126.9 391.5 63.5 470.2 64 563.6 64.6 668 145.6 752.9 247.6 762c4.7.4 8.7-3.3 8.7-8v-60.4c0-4-3-7.4-7-7.9-27-3.4-52.5-15.2-72.1-34.5-24-23.5-37.2-55.1-37.2-88.6 0-28 9.1-54.4 26.2-76.4 16.7-21.4 40.2-36.9 66.1-43.7l37.9-10 13.9-36.7c8.6-22.8 20.6-44.2 35.7-63.5 14.9-19.2 32.6-36 52.4-50 41.1-28.9 89.5-44.2 140-44.2s98.9 15.3 140 44.3c19.9 14 37.5 30.8 52.4 50 15.1 19.3 27.1 40.7 35.7 63.5l13.8 36.6 37.8 10c54.2 14.4 92.1 63.7 92.1 120 0 33.6-13.2 65.1-37.2 88.6-19.5 19.2-44.9 31.1-71.9 34.5-4 .5-6.9 3.9-6.9 7.9V754c0 4.7 4.1 8.4 8.8 8 101.7-9.2 182.5-94 183.2-198.2.6-93.4-62.7-172.1-148.6-194.9z" } }] }, "name": "cloud-server", "theme": "outlined" };
	exports.default = CloudServerOutlined;
	});

	var CloudServerOutlinedSvg = unwrapExports(CloudServerOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var CloudServerOutlined = function CloudServerOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CloudServerOutlinedSvg
	  }));
	};

	CloudServerOutlined.displayName = 'CloudServerOutlined';
	var CloudServerOutlined$1 = /*#__PURE__*/React.forwardRef(CloudServerOutlined);

	var CloudSyncOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CloudSyncOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M811.4 368.9C765.6 248 648.9 162 512.2 162S258.8 247.9 213 368.8C126.9 391.5 63.5 470.2 64 563.6 64.6 668 145.6 752.9 247.6 762c4.7.4 8.7-3.3 8.7-8v-60.4c0-4-3-7.4-7-7.9-27-3.4-52.5-15.2-72.1-34.5-24-23.5-37.2-55.1-37.2-88.6 0-28 9.1-54.4 26.2-76.4 16.7-21.4 40.2-36.9 66.1-43.7l37.9-10 13.9-36.7c8.6-22.8 20.6-44.2 35.7-63.5 14.9-19.2 32.6-36 52.4-50 41.1-28.9 89.5-44.2 140-44.2s98.9 15.3 140 44.3c19.9 14 37.5 30.8 52.4 50 15.1 19.3 27.1 40.7 35.7 63.5l13.8 36.6 37.8 10c54.2 14.4 92.1 63.7 92.1 120 0 33.6-13.2 65.1-37.2 88.6-19.5 19.2-44.9 31.1-71.9 34.5-4 .5-6.9 3.9-6.9 7.9V754c0 4.7 4.1 8.4 8.8 8 101.7-9.2 182.5-94 183.2-198.2.6-93.4-62.7-172.1-148.6-194.9z" } }, { "tag": "path", "attrs": { "d": "M376.9 656.4c1.8-33.5 15.7-64.7 39.5-88.6 25.4-25.5 60-39.8 96-39.8 36.2 0 70.3 14.1 96 39.8 1.4 1.4 2.7 2.8 4.1 4.3l-25 19.6a8 8 0 003 14.1l98.2 24c5 1.2 9.9-2.6 9.9-7.7l.5-101.3c0-6.7-7.6-10.5-12.9-6.3L663 532.7c-36.6-42-90.4-68.6-150.5-68.6-107.4 0-195 85.1-199.4 191.7-.2 4.5 3.4 8.3 8 8.3H369c4.2-.1 7.7-3.4 7.9-7.7zM703 664h-47.9c-4.2 0-7.7 3.3-8 7.6-1.8 33.5-15.7 64.7-39.5 88.6-25.4 25.5-60 39.8-96 39.8-36.2 0-70.3-14.1-96-39.8-1.4-1.4-2.7-2.8-4.1-4.3l25-19.6a8 8 0 00-3-14.1l-98.2-24c-5-1.2-9.9 2.6-9.9 7.7l-.4 101.4c0 6.7 7.6 10.5 12.9 6.3l23.2-18.2c36.6 42 90.4 68.6 150.5 68.6 107.4 0 195-85.1 199.4-191.7.2-4.5-3.4-8.3-8-8.3z" } }] }, "name": "cloud-sync", "theme": "outlined" };
	exports.default = CloudSyncOutlined;
	});

	var CloudSyncOutlinedSvg = unwrapExports(CloudSyncOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var CloudSyncOutlined = function CloudSyncOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CloudSyncOutlinedSvg
	  }));
	};

	CloudSyncOutlined.displayName = 'CloudSyncOutlined';
	var CloudSyncOutlined$1 = /*#__PURE__*/React.forwardRef(CloudSyncOutlined);

	var CloudTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CloudTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M791.9 492l-37.8-10-13.8-36.5c-8.6-22.7-20.6-44.1-35.7-63.4a245.73 245.73 0 00-52.4-49.9c-41.1-28.9-89.5-44.2-140-44.2s-98.9 15.3-140 44.2a245.6 245.6 0 00-52.4 49.9 240.47 240.47 0 00-35.7 63.4l-13.9 36.6-37.9 9.9a125.7 125.7 0 00-66.1 43.7A123.1 123.1 0 00140 612c0 33.1 12.9 64.3 36.3 87.7 23.4 23.4 54.5 36.3 87.6 36.3h496.2c33.1 0 64.2-12.9 87.6-36.3A123.3 123.3 0 00884 612c0-56.2-37.8-105.5-92.1-120z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M811.4 418.7C765.6 297.9 648.9 212 512.2 212S258.8 297.8 213 418.6C127.3 441.1 64 519.1 64 612c0 110.5 89.5 200 199.9 200h496.2C870.5 812 960 722.5 960 612c0-92.7-63.1-170.7-148.6-193.3zm36.3 281a123.07 123.07 0 01-87.6 36.3H263.9c-33.1 0-64.2-12.9-87.6-36.3A123.3 123.3 0 01140 612c0-28 9.1-54.3 26.2-76.3a125.7 125.7 0 0166.1-43.7l37.9-9.9 13.9-36.6c8.6-22.8 20.6-44.1 35.7-63.4a245.6 245.6 0 0152.4-49.9c41.1-28.9 89.5-44.2 140-44.2s98.9 15.3 140 44.2c19.9 14 37.5 30.8 52.4 49.9 15.1 19.3 27.1 40.7 35.7 63.4l13.8 36.5 37.8 10c54.3 14.5 92.1 63.8 92.1 120 0 33.1-12.9 64.3-36.3 87.7z", "fill": primaryColor } }] }; }, "name": "cloud", "theme": "twotone" };
	exports.default = CloudTwoTone;
	});

	var CloudTwoToneSvg = unwrapExports(CloudTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var CloudTwoTone = function CloudTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CloudTwoToneSvg
	  }));
	};

	CloudTwoTone.displayName = 'CloudTwoTone';
	var CloudTwoTone$1 = /*#__PURE__*/React.forwardRef(CloudTwoTone);

	var CloudUploadOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CloudUploadOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M518.3 459a8 8 0 00-12.6 0l-112 141.7a7.98 7.98 0 006.3 12.9h73.9V856c0 4.4 3.6 8 8 8h60c4.4 0 8-3.6 8-8V613.7H624c6.7 0 10.4-7.7 6.3-12.9L518.3 459z" } }, { "tag": "path", "attrs": { "d": "M811.4 366.7C765.6 245.9 648.9 160 512.2 160S258.8 245.8 213 366.6C127.3 389.1 64 467.2 64 560c0 110.5 89.5 200 199.9 200H304c4.4 0 8-3.6 8-8v-60c0-4.4-3.6-8-8-8h-40.1c-33.7 0-65.4-13.4-89-37.7-23.5-24.2-36-56.8-34.9-90.6.9-26.4 9.9-51.2 26.2-72.1 16.7-21.3 40.1-36.8 66.1-43.7l37.9-9.9 13.9-36.6c8.6-22.8 20.6-44.1 35.7-63.4a245.6 245.6 0 0152.4-49.9c41.1-28.9 89.5-44.2 140-44.2s98.9 15.3 140 44.2c19.9 14 37.5 30.8 52.4 49.9 15.1 19.3 27.1 40.7 35.7 63.4l13.8 36.5 37.8 10C846.1 454.5 884 503.8 884 560c0 33.1-12.9 64.3-36.3 87.7a123.07 123.07 0 01-87.6 36.3H720c-4.4 0-8 3.6-8 8v60c0 4.4 3.6 8 8 8h40.1C870.5 760 960 670.5 960 560c0-92.7-63.1-170.7-148.6-193.3z" } }] }, "name": "cloud-upload", "theme": "outlined" };
	exports.default = CloudUploadOutlined;
	});

	var CloudUploadOutlinedSvg = unwrapExports(CloudUploadOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var CloudUploadOutlined = function CloudUploadOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CloudUploadOutlinedSvg
	  }));
	};

	CloudUploadOutlined.displayName = 'CloudUploadOutlined';
	var CloudUploadOutlined$1 = /*#__PURE__*/React.forwardRef(CloudUploadOutlined);

	var ClusterOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ClusterOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M888 680h-54V540H546v-92h238c8.8 0 16-7.2 16-16V168c0-8.8-7.2-16-16-16H240c-8.8 0-16 7.2-16 16v264c0 8.8 7.2 16 16 16h238v92H190v140h-54c-4.4 0-8 3.6-8 8v176c0 4.4 3.6 8 8 8h176c4.4 0 8-3.6 8-8V688c0-4.4-3.6-8-8-8h-54v-72h220v72h-54c-4.4 0-8 3.6-8 8v176c0 4.4 3.6 8 8 8h176c4.4 0 8-3.6 8-8V688c0-4.4-3.6-8-8-8h-54v-72h220v72h-54c-4.4 0-8 3.6-8 8v176c0 4.4 3.6 8 8 8h176c4.4 0 8-3.6 8-8V688c0-4.4-3.6-8-8-8zM256 805.3c0 1.5-1.2 2.7-2.7 2.7h-58.7c-1.5 0-2.7-1.2-2.7-2.7v-58.7c0-1.5 1.2-2.7 2.7-2.7h58.7c1.5 0 2.7 1.2 2.7 2.7v58.7zm288 0c0 1.5-1.2 2.7-2.7 2.7h-58.7c-1.5 0-2.7-1.2-2.7-2.7v-58.7c0-1.5 1.2-2.7 2.7-2.7h58.7c1.5 0 2.7 1.2 2.7 2.7v58.7zM288 384V216h448v168H288zm544 421.3c0 1.5-1.2 2.7-2.7 2.7h-58.7c-1.5 0-2.7-1.2-2.7-2.7v-58.7c0-1.5 1.2-2.7 2.7-2.7h58.7c1.5 0 2.7 1.2 2.7 2.7v58.7zM360 300a40 40 0 1080 0 40 40 0 10-80 0z" } }] }, "name": "cluster", "theme": "outlined" };
	exports.default = ClusterOutlined;
	});

	var ClusterOutlinedSvg = unwrapExports(ClusterOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var ClusterOutlined = function ClusterOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ClusterOutlinedSvg
	  }));
	};

	ClusterOutlined.displayName = 'ClusterOutlined';
	var ClusterOutlined$1 = /*#__PURE__*/React.forwardRef(ClusterOutlined);

	var CodeFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CodeFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM513.1 518.1l-192 161c-5.2 4.4-13.1.7-13.1-6.1v-62.7c0-2.3 1.1-4.6 2.9-6.1L420.7 512l-109.8-92.2a7.63 7.63 0 01-2.9-6.1V351c0-6.8 7.9-10.5 13.1-6.1l192 160.9c3.9 3.2 3.9 9.1 0 12.3zM716 673c0 4.4-3.4 8-7.5 8h-185c-4.1 0-7.5-3.6-7.5-8v-48c0-4.4 3.4-8 7.5-8h185c4.1 0 7.5 3.6 7.5 8v48z" } }] }, "name": "code", "theme": "filled" };
	exports.default = CodeFilled;
	});

	var CodeFilledSvg = unwrapExports(CodeFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var CodeFilled = function CodeFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CodeFilledSvg
	  }));
	};

	CodeFilled.displayName = 'CodeFilled';
	var CodeFilled$1 = /*#__PURE__*/React.forwardRef(CodeFilled);

	var CodeOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CodeOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M516 673c0 4.4 3.4 8 7.5 8h185c4.1 0 7.5-3.6 7.5-8v-48c0-4.4-3.4-8-7.5-8h-185c-4.1 0-7.5 3.6-7.5 8v48zm-194.9 6.1l192-161c3.8-3.2 3.8-9.1 0-12.3l-192-160.9A7.95 7.95 0 00308 351v62.7c0 2.4 1 4.6 2.9 6.1L420.7 512l-109.8 92.2a8.1 8.1 0 00-2.9 6.1V673c0 6.8 7.9 10.5 13.1 6.1zM880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z" } }] }, "name": "code", "theme": "outlined" };
	exports.default = CodeOutlined;
	});

	var CodeOutlinedSvg = unwrapExports(CodeOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var CodeOutlined = function CodeOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CodeOutlinedSvg
	  }));
	};

	CodeOutlined.displayName = 'CodeOutlined';
	var CodeOutlined$1 = /*#__PURE__*/React.forwardRef(CodeOutlined);

	var CodeSandboxCircleFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CodeSandboxCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm243.7 589.2L512 794 268.3 653.2V371.8l110-63.6-.4-.2h.2L512 231l134 77h-.2l-.3.2 110.1 63.6v281.4zM307.9 536.7l87.6 49.9V681l96.7 55.9V524.8L307.9 418.4zm203.9-151.8L418 331l-91.1 52.6 185.2 107 185.2-106.9-91.4-52.8zm20 352l97.3-56.2v-94.1l87-49.5V418.5L531.8 525z" } }] }, "name": "code-sandbox-circle", "theme": "filled" };
	exports.default = CodeSandboxCircleFilled;
	});

	var CodeSandboxCircleFilledSvg = unwrapExports(CodeSandboxCircleFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var CodeSandboxCircleFilled = function CodeSandboxCircleFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CodeSandboxCircleFilledSvg
	  }));
	};

	CodeSandboxCircleFilled.displayName = 'CodeSandboxCircleFilled';
	var CodeSandboxCircleFilled$1 = /*#__PURE__*/React.forwardRef(CodeSandboxCircleFilled);

	var CodeSandboxOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CodeSandboxOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M709.6 210l.4-.2h.2L512 96 313.9 209.8h-.2l.7.3L151.5 304v416L512 928l360.5-208V304l-162.9-94zM482.7 843.6L339.6 761V621.4L210 547.8V372.9l272.7 157.3v313.4zM238.2 321.5l134.7-77.8 138.9 79.7 139.1-79.9 135.2 78-273.9 158-274-158zM814 548.3l-128.8 73.1v139.1l-143.9 83V530.4L814 373.1v175.2z" } }] }, "name": "code-sandbox", "theme": "outlined" };
	exports.default = CodeSandboxOutlined;
	});

	var CodeSandboxOutlinedSvg = unwrapExports(CodeSandboxOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var CodeSandboxOutlined = function CodeSandboxOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CodeSandboxOutlinedSvg
	  }));
	};

	CodeSandboxOutlined.displayName = 'CodeSandboxOutlined';
	var CodeSandboxOutlined$1 = /*#__PURE__*/React.forwardRef(CodeSandboxOutlined);

	var CodeSandboxSquareFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CodeSandboxSquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M307.9 536.7l87.6 49.9V681l96.7 55.9V524.8L307.9 418.4zM880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM755.7 653.2L512 794 268.3 653.2V371.8l110-63.6-.4-.2h.2L512 231l134 77h-.2l-.3.2 110.1 63.6v281.4zm-223.9 83.7l97.3-56.2v-94.1l87-49.5V418.5L531.8 525zm-20-352L418 331l-91.1 52.6 185.2 107 185.2-106.9-91.4-52.8z" } }] }, "name": "code-sandbox-square", "theme": "filled" };
	exports.default = CodeSandboxSquareFilled;
	});

	var CodeSandboxSquareFilledSvg = unwrapExports(CodeSandboxSquareFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var CodeSandboxSquareFilled = function CodeSandboxSquareFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CodeSandboxSquareFilledSvg
	  }));
	};

	CodeSandboxSquareFilled.displayName = 'CodeSandboxSquareFilled';
	var CodeSandboxSquareFilled$1 = /*#__PURE__*/React.forwardRef(CodeSandboxSquareFilled);

	var CodeTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CodeTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M184 840h656V184H184v656zm339.5-223h185c4.1 0 7.5 3.6 7.5 8v48c0 4.4-3.4 8-7.5 8h-185c-4.1 0-7.5-3.6-7.5-8v-48c0-4.4 3.4-8 7.5-8zM308 610.3c0-2.3 1.1-4.6 2.9-6.1L420.7 512l-109.8-92.2a7.63 7.63 0 01-2.9-6.1V351c0-6.8 7.9-10.5 13.1-6.1l192 160.9c3.9 3.2 3.9 9.1 0 12.3l-192 161c-5.2 4.4-13.1.7-13.1-6.1v-62.7z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M321.1 679.1l192-161c3.9-3.2 3.9-9.1 0-12.3l-192-160.9A7.95 7.95 0 00308 351v62.7c0 2.4 1 4.6 2.9 6.1L420.7 512l-109.8 92.2a8.1 8.1 0 00-2.9 6.1V673c0 6.8 7.9 10.5 13.1 6.1zM516 673c0 4.4 3.4 8 7.5 8h185c4.1 0 7.5-3.6 7.5-8v-48c0-4.4-3.4-8-7.5-8h-185c-4.1 0-7.5 3.6-7.5 8v48z", "fill": primaryColor } }] }; }, "name": "code", "theme": "twotone" };
	exports.default = CodeTwoTone;
	});

	var CodeTwoToneSvg = unwrapExports(CodeTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var CodeTwoTone = function CodeTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CodeTwoToneSvg
	  }));
	};

	CodeTwoTone.displayName = 'CodeTwoTone';
	var CodeTwoTone$1 = /*#__PURE__*/React.forwardRef(CodeTwoTone);

	var CodepenCircleFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CodepenCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M488.1 414.7V303.4L300.9 428l83.6 55.8zm254.1 137.7v-79.8l-59.8 39.9zM512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm278 533c0 1.1-.1 2.1-.2 3.1 0 .4-.1.7-.2 1a14.16 14.16 0 01-.8 3.2c-.2.6-.4 1.2-.6 1.7-.2.4-.4.8-.5 1.2-.3.5-.5 1.1-.8 1.6-.2.4-.4.7-.7 1.1-.3.5-.7 1-1 1.5-.3.4-.5.7-.8 1-.4.4-.8.9-1.2 1.3-.3.3-.6.6-1 .9-.4.4-.9.8-1.4 1.1-.4.3-.7.6-1.1.8-.1.1-.3.2-.4.3L525.2 786c-4 2.7-8.6 4-13.2 4-4.7 0-9.3-1.4-13.3-4L244.6 616.9c-.1-.1-.3-.2-.4-.3l-1.1-.8c-.5-.4-.9-.7-1.3-1.1-.3-.3-.6-.6-1-.9-.4-.4-.8-.8-1.2-1.3a7 7 0 01-.8-1c-.4-.5-.7-1-1-1.5-.2-.4-.5-.7-.7-1.1-.3-.5-.6-1.1-.8-1.6-.2-.4-.4-.8-.5-1.2-.2-.6-.4-1.2-.6-1.7-.1-.4-.3-.8-.4-1.2-.2-.7-.3-1.3-.4-2-.1-.3-.1-.7-.2-1-.1-1-.2-2.1-.2-3.1V427.9c0-1 .1-2.1.2-3.1.1-.3.1-.7.2-1a14.16 14.16 0 01.8-3.2c.2-.6.4-1.2.6-1.7.2-.4.4-.8.5-1.2.2-.5.5-1.1.8-1.6.2-.4.4-.7.7-1.1.6-.9 1.2-1.7 1.8-2.5.4-.4.8-.9 1.2-1.3.3-.3.6-.6 1-.9.4-.4.9-.8 1.3-1.1.4-.3.7-.6 1.1-.8.1-.1.3-.2.4-.3L498.7 239c8-5.3 18.5-5.3 26.5 0l254.1 169.1c.1.1.3.2.4.3l1.1.8 1.4 1.1c.3.3.6.6 1 .9.4.4.8.8 1.2 1.3.7.8 1.3 1.6 1.8 2.5.2.4.5.7.7 1.1.3.5.6 1 .8 1.6.2.4.4.8.5 1.2.2.6.4 1.2.6 1.7.1.4.3.8.4 1.2.2.7.3 1.3.4 2 .1.3.1.7.2 1 .1 1 .2 2.1.2 3.1V597zm-254.1 13.3v111.3L723.1 597l-83.6-55.8zM281.8 472.6v79.8l59.8-39.9zM512 456.1l-84.5 56.4 84.5 56.4 84.5-56.4zM723.1 428L535.9 303.4v111.3l103.6 69.1zM384.5 541.2L300.9 597l187.2 124.6V610.3l-103.6-69.1z" } }] }, "name": "codepen-circle", "theme": "filled" };
	exports.default = CodepenCircleFilled;
	});

	var CodepenCircleFilledSvg = unwrapExports(CodepenCircleFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var CodepenCircleFilled = function CodepenCircleFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CodepenCircleFilledSvg
	  }));
	};

	CodepenCircleFilled.displayName = 'CodepenCircleFilled';
	var CodepenCircleFilled$1 = /*#__PURE__*/React.forwardRef(CodepenCircleFilled);

	var CodepenCircleOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CodepenCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M488.1 414.7V303.4L300.9 428l83.6 55.8zm254.1 137.7v-79.8l-59.8 39.9zM512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm278 533c0 1.1-.1 2.1-.2 3.1 0 .4-.1.7-.2 1a14.16 14.16 0 01-.8 3.2c-.2.6-.4 1.2-.6 1.7-.2.4-.4.8-.5 1.2-.3.5-.5 1.1-.8 1.6-.2.4-.4.7-.7 1.1-.3.5-.7 1-1 1.5-.3.4-.5.7-.8 1-.4.4-.8.9-1.2 1.3-.3.3-.6.6-1 .9-.4.4-.9.8-1.4 1.1-.4.3-.7.6-1.1.8-.1.1-.3.2-.4.3L525.2 786c-4 2.7-8.6 4-13.2 4-4.7 0-9.3-1.4-13.3-4L244.6 616.9c-.1-.1-.3-.2-.4-.3l-1.1-.8c-.5-.4-.9-.7-1.3-1.1-.3-.3-.6-.6-1-.9-.4-.4-.8-.8-1.2-1.3a7 7 0 01-.8-1c-.4-.5-.7-1-1-1.5-.2-.4-.5-.7-.7-1.1-.3-.5-.6-1.1-.8-1.6-.2-.4-.4-.8-.5-1.2-.2-.6-.4-1.2-.6-1.7-.1-.4-.3-.8-.4-1.2-.2-.7-.3-1.3-.4-2-.1-.3-.1-.7-.2-1-.1-1-.2-2.1-.2-3.1V427.9c0-1 .1-2.1.2-3.1.1-.3.1-.7.2-1a14.16 14.16 0 01.8-3.2c.2-.6.4-1.2.6-1.7.2-.4.4-.8.5-1.2.2-.5.5-1.1.8-1.6.2-.4.4-.7.7-1.1.6-.9 1.2-1.7 1.8-2.5.4-.4.8-.9 1.2-1.3.3-.3.6-.6 1-.9.4-.4.9-.8 1.3-1.1.4-.3.7-.6 1.1-.8.1-.1.3-.2.4-.3L498.7 239c8-5.3 18.5-5.3 26.5 0l254.1 169.1c.1.1.3.2.4.3l1.1.8 1.4 1.1c.3.3.6.6 1 .9.4.4.8.8 1.2 1.3.7.8 1.3 1.6 1.8 2.5.2.4.5.7.7 1.1.3.5.6 1 .8 1.6.2.4.4.8.5 1.2.2.6.4 1.2.6 1.7.1.4.3.8.4 1.2.2.7.3 1.3.4 2 .1.3.1.7.2 1 .1 1 .2 2.1.2 3.1V597zm-254.1 13.3v111.3L723.1 597l-83.6-55.8zM281.8 472.6v79.8l59.8-39.9zM512 456.1l-84.5 56.4 84.5 56.4 84.5-56.4zM723.1 428L535.9 303.4v111.3l103.6 69.1zM384.5 541.2L300.9 597l187.2 124.6V610.3l-103.6-69.1z" } }] }, "name": "codepen-circle", "theme": "outlined" };
	exports.default = CodepenCircleOutlined;
	});

	var CodepenCircleOutlinedSvg = unwrapExports(CodepenCircleOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var CodepenCircleOutlined = function CodepenCircleOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CodepenCircleOutlinedSvg
	  }));
	};

	CodepenCircleOutlined.displayName = 'CodepenCircleOutlined';
	var CodepenCircleOutlined$1 = /*#__PURE__*/React.forwardRef(CodepenCircleOutlined);

	var CodepenOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CodepenOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M911.7 385.3l-.3-1.5c-.2-1-.3-1.9-.6-2.9-.2-.6-.4-1.1-.5-1.7-.3-.8-.5-1.7-.9-2.5-.2-.6-.5-1.1-.8-1.7-.4-.8-.8-1.5-1.2-2.3-.3-.5-.6-1.1-1-1.6-.8-1.2-1.7-2.4-2.6-3.6-.5-.6-1.1-1.3-1.7-1.9-.4-.5-.9-.9-1.4-1.3-.6-.6-1.3-1.1-1.9-1.6-.5-.4-1-.8-1.6-1.2-.2-.1-.4-.3-.6-.4L531.1 117.8a34.3 34.3 0 00-38.1 0L127.3 361.3c-.2.1-.4.3-.6.4-.5.4-1 .8-1.6 1.2-.7.5-1.3 1.1-1.9 1.6-.5.4-.9.9-1.4 1.3-.6.6-1.2 1.2-1.7 1.9-1 1.1-1.8 2.3-2.6 3.6-.3.5-.7 1-1 1.6-.4.7-.8 1.5-1.2 2.3-.3.5-.5 1.1-.8 1.7-.3.8-.6 1.7-.9 2.5-.2.6-.4 1.1-.5 1.7-.2.9-.4 1.9-.6 2.9l-.3 1.5c-.2 1.5-.3 3-.3 4.5v243.5c0 1.5.1 3 .3 4.5l.3 1.5.6 2.9c.2.6.3 1.1.5 1.7.3.9.6 1.7.9 2.5.2.6.5 1.1.8 1.7.4.8.7 1.5 1.2 2.3.3.5.6 1.1 1 1.6.5.7.9 1.4 1.5 2.1l1.2 1.5c.5.6 1.1 1.3 1.7 1.9.4.5.9.9 1.4 1.3.6.6 1.3 1.1 1.9 1.6.5.4 1 .8 1.6 1.2.2.1.4.3.6.4L493 905.7c5.6 3.8 12.3 5.8 19.1 5.8 6.6 0 13.3-1.9 19.1-5.8l365.6-243.5c.2-.1.4-.3.6-.4.5-.4 1-.8 1.6-1.2.7-.5 1.3-1.1 1.9-1.6.5-.4.9-.9 1.4-1.3.6-.6 1.2-1.2 1.7-1.9l1.2-1.5 1.5-2.1c.3-.5.7-1 1-1.6.4-.8.8-1.5 1.2-2.3.3-.5.5-1.1.8-1.7.3-.8.6-1.7.9-2.5.2-.5.4-1.1.5-1.7.3-.9.4-1.9.6-2.9l.3-1.5c.2-1.5.3-3 .3-4.5V389.8c-.3-1.5-.4-3-.6-4.5zM546.4 210.5l269.4 179.4-120.3 80.4-149-99.6V210.5zm-68.8 0v160.2l-149 99.6-120.3-80.4 269.3-179.4zM180.7 454.1l86 57.5-86 57.5v-115zm296.9 358.5L208.3 633.2l120.3-80.4 149 99.6v160.2zM512 592.8l-121.6-81.2L512 430.3l121.6 81.2L512 592.8zm34.4 219.8V652.4l149-99.6 120.3 80.4-269.3 179.4zM843.3 569l-86-57.5 86-57.5v115z" } }] }, "name": "codepen", "theme": "outlined" };
	exports.default = CodepenOutlined;
	});

	var CodepenOutlinedSvg = unwrapExports(CodepenOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var CodepenOutlined = function CodepenOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CodepenOutlinedSvg
	  }));
	};

	CodepenOutlined.displayName = 'CodepenOutlined';
	var CodepenOutlined$1 = /*#__PURE__*/React.forwardRef(CodepenOutlined);

	var CodepenSquareFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CodepenSquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M723.1 428L535.9 303.4v111.3l103.6 69.1zM512 456.1l-84.5 56.4 84.5 56.4 84.5-56.4zm23.9 154.2v111.3L723.1 597l-83.6-55.8zm-151.4-69.1L300.9 597l187.2 124.6V610.3l-103.6-69.1zM880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-90 485c0 1.1-.1 2.1-.2 3.1 0 .4-.1.7-.2 1a14.16 14.16 0 01-.8 3.2c-.2.6-.4 1.2-.6 1.7-.2.4-.4.8-.5 1.2-.3.5-.5 1.1-.8 1.6-.2.4-.4.7-.7 1.1-.3.5-.7 1-1 1.5-.3.4-.5.7-.8 1-.4.4-.8.9-1.2 1.3-.3.3-.6.6-1 .9-.4.4-.9.8-1.4 1.1-.4.3-.7.6-1.1.8-.1.1-.3.2-.4.3L525.2 786c-4 2.7-8.6 4-13.2 4-4.7 0-9.3-1.4-13.3-4L244.6 616.9c-.1-.1-.3-.2-.4-.3l-1.1-.8c-.5-.4-.9-.7-1.3-1.1-.3-.3-.6-.6-1-.9-.4-.4-.8-.8-1.2-1.3a7 7 0 01-.8-1c-.4-.5-.7-1-1-1.5-.2-.4-.5-.7-.7-1.1-.3-.5-.6-1.1-.8-1.6-.2-.4-.4-.8-.5-1.2-.2-.6-.4-1.2-.6-1.7-.1-.4-.3-.8-.4-1.2-.2-.7-.3-1.3-.4-2-.1-.3-.1-.7-.2-1-.1-1-.2-2.1-.2-3.1V427.9c0-1 .1-2.1.2-3.1.1-.3.1-.7.2-1a14.16 14.16 0 01.8-3.2c.2-.6.4-1.2.6-1.7.2-.4.4-.8.5-1.2.2-.5.5-1.1.8-1.6.2-.4.4-.7.7-1.1.6-.9 1.2-1.7 1.8-2.5.4-.4.8-.9 1.2-1.3.3-.3.6-.6 1-.9.4-.4.9-.8 1.3-1.1.4-.3.7-.6 1.1-.8.1-.1.3-.2.4-.3L498.7 239c8-5.3 18.5-5.3 26.5 0l254.1 169.1c.1.1.3.2.4.3l1.1.8 1.4 1.1c.3.3.6.6 1 .9.4.4.8.8 1.2 1.3.7.8 1.3 1.6 1.8 2.5.2.4.5.7.7 1.1.3.5.6 1 .8 1.6.2.4.4.8.5 1.2.2.6.4 1.2.6 1.7.1.4.3.8.4 1.2.2.7.3 1.3.4 2 .1.3.1.7.2 1 .1 1 .2 2.1.2 3.1V597zm-47.8-44.6v-79.8l-59.8 39.9zm-460.4-79.8v79.8l59.8-39.9zm206.3-57.9V303.4L300.9 428l83.6 55.8z" } }] }, "name": "codepen-square", "theme": "filled" };
	exports.default = CodepenSquareFilled;
	});

	var CodepenSquareFilledSvg = unwrapExports(CodepenSquareFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var CodepenSquareFilled = function CodepenSquareFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CodepenSquareFilledSvg
	  }));
	};

	CodepenSquareFilled.displayName = 'CodepenSquareFilled';
	var CodepenSquareFilled$1 = /*#__PURE__*/React.forwardRef(CodepenSquareFilled);

	var CoffeeOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CoffeeOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M275 281c19.9 0 36-16.1 36-36V36c0-19.9-16.1-36-36-36s-36 16.1-36 36v209c0 19.9 16.1 36 36 36zm613 144H768c0-39.8-32.2-72-72-72H200c-39.8 0-72 32.2-72 72v248c0 3.4.2 6.7.7 9.9-.5 7-.7 14-.7 21.1 0 176.7 143.3 320 320 320 160.1 0 292.7-117.5 316.3-271H888c39.8 0 72-32.2 72-72V497c0-39.8-32.2-72-72-72zM696 681h-1.1c.7 7.6 1.1 15.2 1.1 23 0 137-111 248-248 248S200 841 200 704c0-7.8.4-15.4 1.1-23H200V425h496v256zm192-8H776V497h112v176zM613 281c19.9 0 36-16.1 36-36V36c0-19.9-16.1-36-36-36s-36 16.1-36 36v209c0 19.9 16.1 36 36 36zm-170 0c19.9 0 36-16.1 36-36V36c0-19.9-16.1-36-36-36s-36 16.1-36 36v209c0 19.9 16.1 36 36 36z" } }] }, "name": "coffee", "theme": "outlined" };
	exports.default = CoffeeOutlined;
	});

	var CoffeeOutlinedSvg = unwrapExports(CoffeeOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var CoffeeOutlined = function CoffeeOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CoffeeOutlinedSvg
	  }));
	};

	CoffeeOutlined.displayName = 'CoffeeOutlined';
	var CoffeeOutlined$1 = /*#__PURE__*/React.forwardRef(CoffeeOutlined);

	var ColumnHeightOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ColumnHeightOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M840 836H184c-4.4 0-8 3.6-8 8v60c0 4.4 3.6 8 8 8h656c4.4 0 8-3.6 8-8v-60c0-4.4-3.6-8-8-8zm0-724H184c-4.4 0-8 3.6-8 8v60c0 4.4 3.6 8 8 8h656c4.4 0 8-3.6 8-8v-60c0-4.4-3.6-8-8-8zM610.8 378c6 0 9.4-7 5.7-11.7L515.7 238.7a7.14 7.14 0 00-11.3 0L403.6 366.3a7.23 7.23 0 005.7 11.7H476v268h-62.8c-6 0-9.4 7-5.7 11.7l100.8 127.5c2.9 3.7 8.5 3.7 11.3 0l100.8-127.5c3.7-4.7.4-11.7-5.7-11.7H548V378h62.8z" } }] }, "name": "column-height", "theme": "outlined" };
	exports.default = ColumnHeightOutlined;
	});

	var ColumnHeightOutlinedSvg = unwrapExports(ColumnHeightOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var ColumnHeightOutlined = function ColumnHeightOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ColumnHeightOutlinedSvg
	  }));
	};

	ColumnHeightOutlined.displayName = 'ColumnHeightOutlined';
	var ColumnHeightOutlined$1 = /*#__PURE__*/React.forwardRef(ColumnHeightOutlined);

	var ColumnWidthOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ColumnWidthOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M180 176h-60c-4.4 0-8 3.6-8 8v656c0 4.4 3.6 8 8 8h60c4.4 0 8-3.6 8-8V184c0-4.4-3.6-8-8-8zm724 0h-60c-4.4 0-8 3.6-8 8v656c0 4.4 3.6 8 8 8h60c4.4 0 8-3.6 8-8V184c0-4.4-3.6-8-8-8zM785.3 504.3L657.7 403.6a7.23 7.23 0 00-11.7 5.7V476H378v-62.8c0-6-7-9.4-11.7-5.7L238.7 508.3a7.14 7.14 0 000 11.3l127.5 100.8c4.7 3.7 11.7.4 11.7-5.7V548h268v62.8c0 6 7 9.4 11.7 5.7l127.5-100.8c3.8-2.9 3.8-8.5.2-11.4z" } }] }, "name": "column-width", "theme": "outlined" };
	exports.default = ColumnWidthOutlined;
	});

	var ColumnWidthOutlinedSvg = unwrapExports(ColumnWidthOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var ColumnWidthOutlined = function ColumnWidthOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ColumnWidthOutlinedSvg
	  }));
	};

	ColumnWidthOutlined.displayName = 'ColumnWidthOutlined';
	var ColumnWidthOutlined$1 = /*#__PURE__*/React.forwardRef(ColumnWidthOutlined);

	var CommentOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CommentOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M573 421c-23.1 0-41 17.9-41 40s17.9 40 41 40c21.1 0 39-17.9 39-40s-17.9-40-39-40zm-280 0c-23.1 0-41 17.9-41 40s17.9 40 41 40c21.1 0 39-17.9 39-40s-17.9-40-39-40z" } }, { "tag": "path", "attrs": { "d": "M894 345a343.92 343.92 0 00-189-130v.1c-17.1-19-36.4-36.5-58-52.1-163.7-119-393.5-82.7-513 81-96.3 133-92.2 311.9 6 439l.8 132.6c0 3.2.5 6.4 1.5 9.4a31.95 31.95 0 0040.1 20.9L309 806c33.5 11.9 68.1 18.7 102.5 20.6l-.5.4c89.1 64.9 205.9 84.4 313 49l127.1 41.4c3.2 1 6.5 1.6 9.9 1.6 17.7 0 32-14.3 32-32V753c88.1-119.6 90.4-284.9 1-408zM323 735l-12-5-99 31-1-104-8-9c-84.6-103.2-90.2-251.9-11-361 96.4-132.2 281.2-161.4 413-66 132.2 96.1 161.5 280.6 66 412-80.1 109.9-223.5 150.5-348 102zm505-17l-8 10 1 104-98-33-12 5c-56 20.8-115.7 22.5-171 7l-.2-.1A367.31 367.31 0 00729 676c76.4-105.3 88.8-237.6 44.4-350.4l.6.4c23 16.5 44.1 37.1 62 62 72.6 99.6 68.5 235.2-8 330z" } }, { "tag": "path", "attrs": { "d": "M433 421c-23.1 0-41 17.9-41 40s17.9 40 41 40c21.1 0 39-17.9 39-40s-17.9-40-39-40z" } }] }, "name": "comment", "theme": "outlined" };
	exports.default = CommentOutlined;
	});

	var CommentOutlinedSvg = unwrapExports(CommentOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var CommentOutlined = function CommentOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CommentOutlinedSvg
	  }));
	};

	CommentOutlined.displayName = 'CommentOutlined';
	var CommentOutlined$1 = /*#__PURE__*/React.forwardRef(CommentOutlined);

	var CompassFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CompassFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zM327.3 702.4c-2 .9-4.4 0-5.3-2.1-.4-1-.4-2.2 0-3.2l98.7-225.5 132.1 132.1-225.5 98.7zm375.1-375.1l-98.7 225.5-132.1-132.1L697.1 322c2-.9 4.4 0 5.3 2.1.4 1 .4 2.1 0 3.2z" } }] }, "name": "compass", "theme": "filled" };
	exports.default = CompassFilled;
	});

	var CompassFilledSvg = unwrapExports(CompassFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var CompassFilled = function CompassFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CompassFilledSvg
	  }));
	};

	CompassFilled.displayName = 'CompassFilled';
	var CompassFilled$1 = /*#__PURE__*/React.forwardRef(CompassFilled);

	var CompassOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CompassOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372zm198.4-588.1a32 32 0 00-24.5.5L414.9 415 296.4 686c-3.6 8.2-3.6 17.5 0 25.7 3.4 7.8 9.7 13.9 17.7 17 3.8 1.5 7.7 2.2 11.7 2.2 4.4 0 8.7-.9 12.8-2.7l271-118.6 118.5-271a32.06 32.06 0 00-17.7-42.7zM576.8 534.4l26.2 26.2-42.4 42.4-26.2-26.2L380 644.4 447.5 490 422 464.4l42.4-42.4 25.5 25.5L644.4 380l-67.6 154.4zM464.4 422L422 464.4l25.5 25.6 86.9 86.8 26.2 26.2 42.4-42.4-26.2-26.2-86.8-86.9z" } }] }, "name": "compass", "theme": "outlined" };
	exports.default = CompassOutlined;
	});

	var CompassOutlinedSvg = unwrapExports(CompassOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var CompassOutlined = function CompassOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CompassOutlinedSvg
	  }));
	};

	CompassOutlined.displayName = 'CompassOutlined';
	var CompassOutlined$1 = /*#__PURE__*/React.forwardRef(CompassOutlined);

	var CompassTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CompassTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zM327.6 701.7c-2 .9-4.4 0-5.3-2.1-.4-1-.4-2.2 0-3.2L421 470.9 553.1 603l-225.5 98.7zm375.1-375.1L604 552.1 471.9 420l225.5-98.7c2-.9 4.4 0 5.3 2.1.4 1 .4 2.1 0 3.2z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M322.3 696.4c-.4 1-.4 2.2 0 3.2.9 2.1 3.3 3 5.3 2.1L553.1 603 421 470.9l-98.7 225.5zm375.1-375.1L471.9 420 604 552.1l98.7-225.5c.4-1.1.4-2.2 0-3.2-.9-2.1-3.3-3-5.3-2.1z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }] }; }, "name": "compass", "theme": "twotone" };
	exports.default = CompassTwoTone;
	});

	var CompassTwoToneSvg = unwrapExports(CompassTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var CompassTwoTone = function CompassTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CompassTwoToneSvg
	  }));
	};

	CompassTwoTone.displayName = 'CompassTwoTone';
	var CompassTwoTone$1 = /*#__PURE__*/React.forwardRef(CompassTwoTone);

	var CompressOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CompressOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M326 664H104c-8.8 0-16 7.2-16 16v48c0 8.8 7.2 16 16 16h174v176c0 8.8 7.2 16 16 16h48c8.8 0 16-7.2 16-16V696c0-17.7-14.3-32-32-32zm16-576h-48c-8.8 0-16 7.2-16 16v176H104c-8.8 0-16 7.2-16 16v48c0 8.8 7.2 16 16 16h222c17.7 0 32-14.3 32-32V104c0-8.8-7.2-16-16-16zm578 576H698c-17.7 0-32 14.3-32 32v224c0 8.8 7.2 16 16 16h48c8.8 0 16-7.2 16-16V744h174c8.8 0 16-7.2 16-16v-48c0-8.8-7.2-16-16-16zm0-384H746V104c0-8.8-7.2-16-16-16h-48c-8.8 0-16 7.2-16 16v224c0 17.7 14.3 32 32 32h222c8.8 0 16-7.2 16-16v-48c0-8.8-7.2-16-16-16z" } }] }, "name": "compress", "theme": "outlined" };
	exports.default = CompressOutlined;
	});

	var CompressOutlinedSvg = unwrapExports(CompressOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var CompressOutlined = function CompressOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CompressOutlinedSvg
	  }));
	};

	CompressOutlined.displayName = 'CompressOutlined';
	var CompressOutlined$1 = /*#__PURE__*/React.forwardRef(CompressOutlined);

	var ConsoleSqlOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ConsoleSqlOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M301.3 496.7c-23.8 0-40.2-10.5-41.6-26.9H205c.9 43.4 36.9 70.3 93.9 70.3 59.1 0 95-28.4 95-75.5 0-35.8-20-55.9-64.5-64.5l-29.1-5.6c-23.8-4.7-33.8-11.9-33.8-24.2 0-15 13.3-24.5 33.4-24.5 20.1 0 35.3 11.1 36.6 27h53c-.9-41.7-37.5-70.3-90.3-70.3-54.4 0-89.7 28.9-89.7 73 0 35.5 21.2 58 62.5 65.8l29.7 5.9c25.8 5.2 35.6 11.9 35.6 24.4.1 14.7-14.5 25.1-36 25.1z" } }, { "tag": "path", "attrs": { "d": "M928 140H96c-17.7 0-32 14.3-32 32v496c0 17.7 14.3 32 32 32h380v112H304c-8.8 0-16 7.2-16 16v48c0 4.4 3.6 8 8 8h432c4.4 0 8-3.6 8-8v-48c0-8.8-7.2-16-16-16H548V700h380c17.7 0 32-14.3 32-32V172c0-17.7-14.3-32-32-32zm-40 488H136V212h752v416z" } }, { "tag": "path", "attrs": { "d": "M828.5 486.7h-95.8V308.5h-57.4V534h153.2zm-298.6 53.4c14.1 0 27.2-2 39.1-5.8l13.3 20.3h53.3L607.9 511c21.1-20 33-51.1 33-89.8 0-73.3-43.3-118.8-110.9-118.8s-111.2 45.3-111.2 118.8c-.1 73.7 43 118.9 111.1 118.9zm0-190c31.6 0 52.7 27.7 52.7 71.1 0 16.7-3.6 30.6-10 40.5l-5.2-6.9h-48.8L542 491c-3.9.9-8 1.4-12.2 1.4-31.7 0-52.8-27.5-52.8-71.2.1-43.6 21.2-71.1 52.9-71.1z" } }] }, "name": "console-sql", "theme": "outlined" };
	exports.default = ConsoleSqlOutlined;
	});

	var ConsoleSqlOutlinedSvg = unwrapExports(ConsoleSqlOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var ConsoleSqlOutlined = function ConsoleSqlOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ConsoleSqlOutlinedSvg
	  }));
	};

	ConsoleSqlOutlined.displayName = 'ConsoleSqlOutlined';
	var ConsoleSqlOutlined$1 = /*#__PURE__*/React.forwardRef(ConsoleSqlOutlined);

	var ContactsFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ContactsFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M928 224H768v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56H548v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56H328v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56H96c-17.7 0-32 14.3-32 32v576c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V256c0-17.7-14.3-32-32-32zM661 736h-43.9c-4.2 0-7.6-3.3-7.9-7.5-3.8-50.6-46-90.5-97.2-90.5s-93.4 40-97.2 90.5c-.3 4.2-3.7 7.5-7.9 7.5H363a8 8 0 01-8-8.4c2.8-53.3 32-99.7 74.6-126.1a111.8 111.8 0 01-29.1-75.5c0-61.9 49.9-112 111.4-112 61.5 0 111.4 50.1 111.4 112 0 29.1-11 55.5-29.1 75.5 42.7 26.5 71.8 72.8 74.6 126.1.4 4.6-3.2 8.4-7.8 8.4zM512 474c-28.5 0-51.7 23.3-51.7 52s23.2 52 51.7 52c28.5 0 51.7-23.3 51.7-52s-23.2-52-51.7-52z" } }] }, "name": "contacts", "theme": "filled" };
	exports.default = ContactsFilled;
	});

	var ContactsFilledSvg = unwrapExports(ContactsFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var ContactsFilled = function ContactsFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ContactsFilledSvg
	  }));
	};

	ContactsFilled.displayName = 'ContactsFilled';
	var ContactsFilled$1 = /*#__PURE__*/React.forwardRef(ContactsFilled);

	var ContactsOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ContactsOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M594.3 601.5a111.8 111.8 0 0029.1-75.5c0-61.9-49.9-112-111.4-112s-111.4 50.1-111.4 112c0 29.1 11 55.5 29.1 75.5a158.09 158.09 0 00-74.6 126.1 8 8 0 008 8.4H407c4.2 0 7.6-3.3 7.9-7.5 3.8-50.6 46-90.5 97.2-90.5s93.4 40 97.2 90.5c.3 4.2 3.7 7.5 7.9 7.5H661a8 8 0 008-8.4c-2.8-53.3-32-99.7-74.7-126.1zM512 578c-28.5 0-51.7-23.3-51.7-52s23.2-52 51.7-52 51.7 23.3 51.7 52-23.2 52-51.7 52zm416-354H768v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56H548v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56H328v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56H96c-17.7 0-32 14.3-32 32v576c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V256c0-17.7-14.3-32-32-32zm-40 568H136V296h120v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56h148v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56h148v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56h120v496z" } }] }, "name": "contacts", "theme": "outlined" };
	exports.default = ContactsOutlined;
	});

	var ContactsOutlinedSvg = unwrapExports(ContactsOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var ContactsOutlined = function ContactsOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ContactsOutlinedSvg
	  }));
	};

	ContactsOutlined.displayName = 'ContactsOutlined';
	var ContactsOutlined$1 = /*#__PURE__*/React.forwardRef(ContactsOutlined);

	var ContactsTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ContactsTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M460.3 526a51.7 52 0 10103.4 0 51.7 52 0 10-103.4 0z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M768 352c0 4.4-3.6 8-8 8h-56c-4.4 0-8-3.6-8-8v-56H548v56c0 4.4-3.6 8-8 8h-56c-4.4 0-8-3.6-8-8v-56H328v56c0 4.4-3.6 8-8 8h-56c-4.4 0-8-3.6-8-8v-56H136v496h752V296H768v56zM661 736h-43.8c-4.2 0-7.6-3.3-7.9-7.5-3.8-50.5-46-90.5-97.2-90.5s-93.4 39.9-97.2 90.5c-.3 4.2-3.7 7.5-7.9 7.5h-43.9a8 8 0 01-8-8.4c2.8-53.3 31.9-99.6 74.6-126.1-18.1-20-29.1-46.4-29.1-75.5 0-61.9 49.9-112 111.4-112s111.4 50.1 111.4 112c0 29.1-11 55.6-29.1 75.5 42.7 26.4 71.9 72.8 74.7 126.1a8 8 0 01-8 8.4z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M594.3 601.5a111.8 111.8 0 0029.1-75.5c0-61.9-49.9-112-111.4-112s-111.4 50.1-111.4 112c0 29.1 11 55.5 29.1 75.5a158.09 158.09 0 00-74.6 126.1 8 8 0 008 8.4H407c4.2 0 7.6-3.3 7.9-7.5 3.8-50.6 46-90.5 97.2-90.5s93.4 40 97.2 90.5c.3 4.2 3.7 7.5 7.9 7.5H661a8 8 0 008-8.4c-2.8-53.3-32-99.7-74.7-126.1zM512 578c-28.5 0-51.7-23.3-51.7-52s23.2-52 51.7-52 51.7 23.3 51.7 52-23.2 52-51.7 52z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M928 224H768v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56H548v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56H328v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56H96c-17.7 0-32 14.3-32 32v576c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V256c0-17.7-14.3-32-32-32zm-40 568H136V296h120v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56h148v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56h148v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56h120v496z", "fill": primaryColor } }] }; }, "name": "contacts", "theme": "twotone" };
	exports.default = ContactsTwoTone;
	});

	var ContactsTwoToneSvg = unwrapExports(ContactsTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var ContactsTwoTone = function ContactsTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ContactsTwoToneSvg
	  }));
	};

	ContactsTwoTone.displayName = 'ContactsTwoTone';
	var ContactsTwoTone$1 = /*#__PURE__*/React.forwardRef(ContactsTwoTone);

	var ContainerFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ContainerFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M832 64H192c-17.7 0-32 14.3-32 32v529c0-.6.4-1 1-1h219.3l5.2 24.7C397.6 708.5 450.8 752 512 752s114.4-43.5 126.4-103.3l5.2-24.7H863c.6 0 1 .4 1 1V96c0-17.7-14.3-32-32-32zM712 493c0 4.4-3.6 8-8 8H320c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h384c4.4 0 8 3.6 8 8v48zm0-160c0 4.4-3.6 8-8 8H320c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h384c4.4 0 8 3.6 8 8v48zm151 354H694.1c-11.6 32.8-32 62.3-59.1 84.7-34.5 28.6-78.2 44.3-123 44.3s-88.5-15.8-123-44.3a194.02 194.02 0 01-59.1-84.7H161c-.6 0-1-.4-1-1v242c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V686c0 .6-.4 1-1 1z" } }] }, "name": "container", "theme": "filled" };
	exports.default = ContainerFilled;
	});

	var ContainerFilledSvg = unwrapExports(ContainerFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var ContainerFilled = function ContainerFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ContainerFilledSvg
	  }));
	};

	ContainerFilled.displayName = 'ContainerFilled';
	var ContainerFilled$1 = /*#__PURE__*/React.forwardRef(ContainerFilled);

	var ContainerOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ContainerOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M832 64H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V96c0-17.7-14.3-32-32-32zm-40 824H232V687h97.9c11.6 32.8 32 62.3 59.1 84.7 34.5 28.5 78.2 44.3 123 44.3s88.5-15.7 123-44.3c27.1-22.4 47.5-51.9 59.1-84.7H792v-63H643.6l-5.2 24.7C626.4 708.5 573.2 752 512 752s-114.4-43.5-126.5-103.3l-5.2-24.7H232V136h560v752zM320 341h384c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H320c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8zm0 160h384c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H320c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8z" } }] }, "name": "container", "theme": "outlined" };
	exports.default = ContainerOutlined;
	});

	var ContainerOutlinedSvg = unwrapExports(ContainerOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var ContainerOutlined = function ContainerOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ContainerOutlinedSvg
	  }));
	};

	ContainerOutlined.displayName = 'ContainerOutlined';
	var ContainerOutlined$1 = /*#__PURE__*/React.forwardRef(ContainerOutlined);

	var ContainerTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ContainerTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M635 771.7c-34.5 28.6-78.2 44.3-123 44.3s-88.5-15.8-123-44.3a194.02 194.02 0 01-59.1-84.7H232v201h560V687h-97.9c-11.6 32.8-32 62.3-59.1 84.7z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M320 501h384c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H320c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M832 64H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V96c0-17.7-14.3-32-32-32zm-40 824H232V687h97.9c11.6 32.8 32 62.3 59.1 84.7 34.5 28.5 78.2 44.3 123 44.3s88.5-15.7 123-44.3c27.1-22.4 47.5-51.9 59.1-84.7H792v201zm0-264H643.6l-5.2 24.7C626.4 708.5 573.2 752 512 752s-114.4-43.5-126.5-103.3l-5.2-24.7H232V136h560v488z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M320 341h384c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H320c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8z", "fill": primaryColor } }] }; }, "name": "container", "theme": "twotone" };
	exports.default = ContainerTwoTone;
	});

	var ContainerTwoToneSvg = unwrapExports(ContainerTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var ContainerTwoTone = function ContainerTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ContainerTwoToneSvg
	  }));
	};

	ContainerTwoTone.displayName = 'ContainerTwoTone';
	var ContainerTwoTone$1 = /*#__PURE__*/React.forwardRef(ContainerTwoTone);

	var ControlFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ControlFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM404 683v77c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8v-77c-41.7-13.6-72-52.8-72-99s30.3-85.5 72-99V264c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v221c41.7 13.6 72 52.8 72 99s-30.3 85.5-72 99zm279.6-143.9c.2 0 .3-.1.4-.1v221c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V539c.2 0 .3.1.4.1-42-13.4-72.4-52.7-72.4-99.1 0-46.4 30.4-85.7 72.4-99.1-.2 0-.3.1-.4.1v-77c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v77c-.2 0-.3-.1-.4-.1 42 13.4 72.4 52.7 72.4 99.1 0 46.4-30.4 85.7-72.4 99.1zM616 440a36 36 0 1072 0 36 36 0 10-72 0zM403.4 566.5l-1.5-2.4c0-.1-.1-.1-.1-.2l-.9-1.2c-.1-.1-.2-.2-.2-.3-1-1.3-2-2.5-3.2-3.6l-.2-.2c-.4-.4-.8-.8-1.2-1.1-.8-.8-1.7-1.5-2.6-2.1h-.1l-1.2-.9c-.1-.1-.3-.2-.4-.3-1.2-.8-2.5-1.6-3.9-2.2-.2-.1-.5-.2-.7-.4-.4-.2-.7-.3-1.1-.5-.3-.1-.7-.3-1-.4-.5-.2-1-.4-1.5-.5-.4-.1-.9-.3-1.3-.4l-.9-.3-1.4-.3c-.2-.1-.5-.1-.7-.2-.7-.1-1.4-.3-2.1-.4-.2 0-.4 0-.6-.1-.6-.1-1.1-.1-1.7-.2-.2 0-.4 0-.7-.1-.8 0-1.5-.1-2.3-.1s-1.5 0-2.3.1c-.2 0-.4 0-.7.1-.6 0-1.2.1-1.7.2-.2 0-.4 0-.6.1-.7.1-1.4.2-2.1.4-.2.1-.5.1-.7.2l-1.4.3-.9.3c-.4.1-.9.3-1.3.4-.5.2-1 .4-1.5.5-.3.1-.7.3-1 .4-.4.2-.7.3-1.1.5-.2.1-.5.2-.7.4-1.3.7-2.6 1.4-3.9 2.2-.1.1-.3.2-.4.3l-1.2.9h-.1c-.9.7-1.8 1.4-2.6 2.1-.4.4-.8.7-1.2 1.1l-.2.2a54.8 54.8 0 00-3.2 3.6c-.1.1-.2.2-.2.3l-.9 1.2c0 .1-.1.1-.1.2l-1.5 2.4c-.1.2-.2.3-.3.5-2.7 5.1-4.3 10.9-4.3 17s1.6 12 4.3 17c.1.2.2.3.3.5l1.5 2.4c0 .1.1.1.1.2l.9 1.2c.1.1.2.2.2.3 1 1.3 2 2.5 3.2 3.6l.2.2c.4.4.8.8 1.2 1.1.8.8 1.7 1.5 2.6 2.1h.1l1.2.9c.1.1.3.2.4.3 1.2.8 2.5 1.6 3.9 2.2.2.1.5.2.7.4.4.2.7.3 1.1.5.3.1.7.3 1 .4.5.2 1 .4 1.5.5.4.1.9.3 1.3.4l.9.3 1.4.3c.2.1.5.1.7.2.7.1 1.4.3 2.1.4.2 0 .4 0 .6.1.6.1 1.1.1 1.7.2.2 0 .4 0 .7.1.8 0 1.5.1 2.3.1s1.5 0 2.3-.1c.2 0 .4 0 .7-.1.6 0 1.2-.1 1.7-.2.2 0 .4 0 .6-.1.7-.1 1.4-.2 2.1-.4.2-.1.5-.1.7-.2l1.4-.3.9-.3c.4-.1.9-.3 1.3-.4.5-.2 1-.4 1.5-.5.3-.1.7-.3 1-.4.4-.2.7-.3 1.1-.5.2-.1.5-.2.7-.4 1.3-.7 2.6-1.4 3.9-2.2.1-.1.3-.2.4-.3l1.2-.9h.1c.9-.7 1.8-1.4 2.6-2.1.4-.4.8-.7 1.2-1.1l.2-.2c1.1-1.1 2.2-2.4 3.2-3.6.1-.1.2-.2.2-.3l.9-1.2c0-.1.1-.1.1-.2l1.5-2.4c.1-.2.2-.3.3-.5 2.7-5.1 4.3-10.9 4.3-17s-1.6-12-4.3-17c-.1-.2-.2-.4-.3-.5z" } }] }, "name": "control", "theme": "filled" };
	exports.default = ControlFilled;
	});

	var ControlFilledSvg = unwrapExports(ControlFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var ControlFilled = function ControlFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ControlFilledSvg
	  }));
	};

	ControlFilled.displayName = 'ControlFilled';
	var ControlFilled$1 = /*#__PURE__*/React.forwardRef(ControlFilled);

	var ControlOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ControlOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656zM340 683v77c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8v-77c-10.1 3.3-20.8 5-32 5s-21.9-1.8-32-5zm64-198V264c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v221c10.1-3.3 20.8-5 32-5s21.9 1.8 32 5zm-64 198c10.1 3.3 20.8 5 32 5s21.9-1.8 32-5c41.8-13.5 72-52.7 72-99s-30.2-85.5-72-99c-10.1-3.3-20.8-5-32-5s-21.9 1.8-32 5c-41.8 13.5-72 52.7-72 99s30.2 85.5 72 99zm.1-115.7c.3-.6.7-1.2 1-1.8v-.1l1.2-1.8c.1-.2.2-.3.3-.5.3-.5.7-.9 1-1.4.1-.1.2-.3.3-.4.5-.6.9-1.1 1.4-1.6l.3-.3 1.2-1.2.4-.4c.5-.5 1-.9 1.6-1.4.6-.5 1.1-.9 1.7-1.3.2-.1.3-.2.5-.3.5-.3.9-.7 1.4-1 .1-.1.3-.2.4-.3.6-.4 1.2-.7 1.9-1.1.1-.1.3-.1.4-.2.5-.3 1-.5 1.6-.8l.6-.3c.7-.3 1.3-.6 2-.8.7-.3 1.4-.5 2.1-.7.2-.1.4-.1.6-.2.6-.2 1.1-.3 1.7-.4.2 0 .3-.1.5-.1.7-.2 1.5-.3 2.2-.4.2 0 .3 0 .5-.1.6-.1 1.2-.1 1.8-.2h.6c.8 0 1.5-.1 2.3-.1s1.5 0 2.3.1h.6c.6 0 1.2.1 1.8.2.2 0 .3 0 .5.1.7.1 1.5.2 2.2.4.2 0 .3.1.5.1.6.1 1.2.3 1.7.4.2.1.4.1.6.2.7.2 1.4.4 2.1.7.7.2 1.3.5 2 .8l.6.3c.5.2 1.1.5 1.6.8.1.1.3.1.4.2.6.3 1.3.7 1.9 1.1.1.1.3.2.4.3.5.3 1 .6 1.4 1 .2.1.3.2.5.3.6.4 1.2.9 1.7 1.3s1.1.9 1.6 1.4l.4.4 1.2 1.2.3.3c.5.5 1 1.1 1.4 1.6.1.1.2.3.3.4.4.4.7.9 1 1.4.1.2.2.3.3.5l1.2 1.8s0 .1.1.1a36.18 36.18 0 015.1 18.5c0 6-1.5 11.7-4.1 16.7-.3.6-.7 1.2-1 1.8 0 0 0 .1-.1.1l-1.2 1.8c-.1.2-.2.3-.3.5-.3.5-.7.9-1 1.4-.1.1-.2.3-.3.4-.5.6-.9 1.1-1.4 1.6l-.3.3-1.2 1.2-.4.4c-.5.5-1 .9-1.6 1.4-.6.5-1.1.9-1.7 1.3-.2.1-.3.2-.5.3-.5.3-.9.7-1.4 1-.1.1-.3.2-.4.3-.6.4-1.2.7-1.9 1.1-.1.1-.3.1-.4.2-.5.3-1 .5-1.6.8l-.6.3c-.7.3-1.3.6-2 .8-.7.3-1.4.5-2.1.7-.2.1-.4.1-.6.2-.6.2-1.1.3-1.7.4-.2 0-.3.1-.5.1-.7.2-1.5.3-2.2.4-.2 0-.3 0-.5.1-.6.1-1.2.1-1.8.2h-.6c-.8 0-1.5.1-2.3.1s-1.5 0-2.3-.1h-.6c-.6 0-1.2-.1-1.8-.2-.2 0-.3 0-.5-.1-.7-.1-1.5-.2-2.2-.4-.2 0-.3-.1-.5-.1-.6-.1-1.2-.3-1.7-.4-.2-.1-.4-.1-.6-.2-.7-.2-1.4-.4-2.1-.7-.7-.2-1.3-.5-2-.8l-.6-.3c-.5-.2-1.1-.5-1.6-.8-.1-.1-.3-.1-.4-.2-.6-.3-1.3-.7-1.9-1.1-.1-.1-.3-.2-.4-.3-.5-.3-1-.6-1.4-1-.2-.1-.3-.2-.5-.3-.6-.4-1.2-.9-1.7-1.3s-1.1-.9-1.6-1.4l-.4-.4-1.2-1.2-.3-.3c-.5-.5-1-1.1-1.4-1.6-.1-.1-.2-.3-.3-.4-.4-.4-.7-.9-1-1.4-.1-.2-.2-.3-.3-.5l-1.2-1.8v-.1c-.4-.6-.7-1.2-1-1.8-2.6-5-4.1-10.7-4.1-16.7s1.5-11.7 4.1-16.7zM620 539v221c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V539c-10.1 3.3-20.8 5-32 5s-21.9-1.8-32-5zm64-198v-77c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v77c10.1-3.3 20.8-5 32-5s21.9 1.8 32 5zm-64 198c10.1 3.3 20.8 5 32 5s21.9-1.8 32-5c41.8-13.5 72-52.7 72-99s-30.2-85.5-72-99c-10.1-3.3-20.8-5-32-5s-21.9 1.8-32 5c-41.8 13.5-72 52.7-72 99s30.2 85.5 72 99zm.1-115.7c.3-.6.7-1.2 1-1.8v-.1l1.2-1.8c.1-.2.2-.3.3-.5.3-.5.7-.9 1-1.4.1-.1.2-.3.3-.4.5-.6.9-1.1 1.4-1.6l.3-.3 1.2-1.2.4-.4c.5-.5 1-.9 1.6-1.4.6-.5 1.1-.9 1.7-1.3.2-.1.3-.2.5-.3.5-.3.9-.7 1.4-1 .1-.1.3-.2.4-.3.6-.4 1.2-.7 1.9-1.1.1-.1.3-.1.4-.2.5-.3 1-.5 1.6-.8l.6-.3c.7-.3 1.3-.6 2-.8.7-.3 1.4-.5 2.1-.7.2-.1.4-.1.6-.2.6-.2 1.1-.3 1.7-.4.2 0 .3-.1.5-.1.7-.2 1.5-.3 2.2-.4.2 0 .3 0 .5-.1.6-.1 1.2-.1 1.8-.2h.6c.8 0 1.5-.1 2.3-.1s1.5 0 2.3.1h.6c.6 0 1.2.1 1.8.2.2 0 .3 0 .5.1.7.1 1.5.2 2.2.4.2 0 .3.1.5.1.6.1 1.2.3 1.7.4.2.1.4.1.6.2.7.2 1.4.4 2.1.7.7.2 1.3.5 2 .8l.6.3c.5.2 1.1.5 1.6.8.1.1.3.1.4.2.6.3 1.3.7 1.9 1.1.1.1.3.2.4.3.5.3 1 .6 1.4 1 .2.1.3.2.5.3.6.4 1.2.9 1.7 1.3s1.1.9 1.6 1.4l.4.4 1.2 1.2.3.3c.5.5 1 1.1 1.4 1.6.1.1.2.3.3.4.4.4.7.9 1 1.4.1.2.2.3.3.5l1.2 1.8v.1a36.18 36.18 0 015.1 18.5c0 6-1.5 11.7-4.1 16.7-.3.6-.7 1.2-1 1.8v.1l-1.2 1.8c-.1.2-.2.3-.3.5-.3.5-.7.9-1 1.4-.1.1-.2.3-.3.4-.5.6-.9 1.1-1.4 1.6l-.3.3-1.2 1.2-.4.4c-.5.5-1 .9-1.6 1.4-.6.5-1.1.9-1.7 1.3-.2.1-.3.2-.5.3-.5.3-.9.7-1.4 1-.1.1-.3.2-.4.3-.6.4-1.2.7-1.9 1.1-.1.1-.3.1-.4.2-.5.3-1 .5-1.6.8l-.6.3c-.7.3-1.3.6-2 .8-.7.3-1.4.5-2.1.7-.2.1-.4.1-.6.2-.6.2-1.1.3-1.7.4-.2 0-.3.1-.5.1-.7.2-1.5.3-2.2.4-.2 0-.3 0-.5.1-.6.1-1.2.1-1.8.2h-.6c-.8 0-1.5.1-2.3.1s-1.5 0-2.3-.1h-.6c-.6 0-1.2-.1-1.8-.2-.2 0-.3 0-.5-.1-.7-.1-1.5-.2-2.2-.4-.2 0-.3-.1-.5-.1-.6-.1-1.2-.3-1.7-.4-.2-.1-.4-.1-.6-.2-.7-.2-1.4-.4-2.1-.7-.7-.2-1.3-.5-2-.8l-.6-.3c-.5-.2-1.1-.5-1.6-.8-.1-.1-.3-.1-.4-.2-.6-.3-1.3-.7-1.9-1.1-.1-.1-.3-.2-.4-.3-.5-.3-1-.6-1.4-1-.2-.1-.3-.2-.5-.3-.6-.4-1.2-.9-1.7-1.3s-1.1-.9-1.6-1.4l-.4-.4-1.2-1.2-.3-.3c-.5-.5-1-1.1-1.4-1.6-.1-.1-.2-.3-.3-.4-.4-.4-.7-.9-1-1.4-.1-.2-.2-.3-.3-.5l-1.2-1.8v-.1c-.4-.6-.7-1.2-1-1.8-2.6-5-4.1-10.7-4.1-16.7s1.5-11.7 4.1-16.7z" } }] }, "name": "control", "theme": "outlined" };
	exports.default = ControlOutlined;
	});

	var ControlOutlinedSvg = unwrapExports(ControlOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var ControlOutlined = function ControlOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ControlOutlinedSvg
	  }));
	};

	ControlOutlined.displayName = 'ControlOutlined';
	var ControlOutlined$1 = /*#__PURE__*/React.forwardRef(ControlOutlined);

	var ControlTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ControlTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M616 440a36 36 0 1072 0 36 36 0 10-72 0zM340.4 601.5l1.5 2.4c0 .1.1.1.1.2l.9 1.2c.1.1.2.2.2.3 1 1.3 2 2.5 3.2 3.6l.2.2c.4.4.8.8 1.2 1.1.8.8 1.7 1.5 2.6 2.1h.1l1.2.9c.1.1.3.2.4.3 1.2.8 2.5 1.6 3.9 2.2.2.1.5.2.7.4.4.2.7.3 1.1.5.3.1.7.3 1 .4.5.2 1 .4 1.5.5.4.1.9.3 1.3.4l.9.3 1.4.3c.2.1.5.1.7.2.7.1 1.4.3 2.1.4.2 0 .4 0 .6.1.6.1 1.1.1 1.7.2.2 0 .4 0 .7.1.8 0 1.5.1 2.3.1s1.5 0 2.3-.1c.2 0 .4 0 .7-.1.6 0 1.2-.1 1.7-.2.2 0 .4 0 .6-.1.7-.1 1.4-.2 2.1-.4.2-.1.5-.1.7-.2l1.4-.3.9-.3c.4-.1.9-.3 1.3-.4.5-.2 1-.4 1.5-.5.3-.1.7-.3 1-.4.4-.2.7-.3 1.1-.5.2-.1.5-.2.7-.4 1.3-.7 2.6-1.4 3.9-2.2.1-.1.3-.2.4-.3l1.2-.9h.1c.9-.7 1.8-1.4 2.6-2.1.4-.4.8-.7 1.2-1.1l.2-.2c1.1-1.1 2.2-2.4 3.2-3.6.1-.1.2-.2.2-.3l.9-1.2c0-.1.1-.1.1-.2l1.5-2.4c.1-.2.2-.3.3-.5 2.7-5.1 4.3-10.9 4.3-17s-1.6-12-4.3-17c-.1-.2-.2-.4-.3-.5l-1.5-2.4c0-.1-.1-.1-.1-.2l-.9-1.2c-.1-.1-.2-.2-.2-.3-1-1.3-2-2.5-3.2-3.6l-.2-.2c-.4-.4-.8-.8-1.2-1.1-.8-.8-1.7-1.5-2.6-2.1h-.1l-1.2-.9c-.1-.1-.3-.2-.4-.3-1.2-.8-2.5-1.6-3.9-2.2-.2-.1-.5-.2-.7-.4-.4-.2-.7-.3-1.1-.5-.3-.1-.7-.3-1-.4-.5-.2-1-.4-1.5-.5-.4-.1-.9-.3-1.3-.4l-.9-.3-1.4-.3c-.2-.1-.5-.1-.7-.2-.7-.1-1.4-.3-2.1-.4-.2 0-.4 0-.6-.1-.6-.1-1.1-.1-1.7-.2-.2 0-.4 0-.7-.1-.8 0-1.5-.1-2.3-.1s-1.5 0-2.3.1c-.2 0-.4 0-.7.1-.6 0-1.2.1-1.7.2-.2 0-.4 0-.6.1-.7.1-1.4.2-2.1.4-.2.1-.5.1-.7.2l-1.4.3-.9.3c-.4.1-.9.3-1.3.4-.5.2-1 .4-1.5.5-.3.1-.7.3-1 .4-.4.2-.7.3-1.1.5-.2.1-.5.2-.7.4-1.3.7-2.6 1.4-3.9 2.2-.1.1-.3.2-.4.3l-1.2.9h-.1c-.9.7-1.8 1.4-2.6 2.1-.4.4-.8.7-1.2 1.1l-.2.2a54.8 54.8 0 00-3.2 3.6c-.1.1-.2.2-.2.3l-.9 1.2c0 .1-.1.1-.1.2l-1.5 2.4c-.1.2-.2.3-.3.5-2.7 5.1-4.3 10.9-4.3 17s1.6 12 4.3 17c.1.2.2.3.3.5z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M184 840h656V184H184v656zm436.4-499.1c-.2 0-.3.1-.4.1v-77c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v77c-.2 0-.3-.1-.4-.1 42 13.4 72.4 52.7 72.4 99.1 0 46.4-30.4 85.7-72.4 99.1.2 0 .3-.1.4-.1v221c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V539c.2 0 .3.1.4.1-42-13.4-72.4-52.7-72.4-99.1 0-46.4 30.4-85.7 72.4-99.1zM340 485V264c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v221c41.7 13.6 72 52.8 72 99s-30.3 85.5-72 99v77c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8v-77c-41.7-13.6-72-52.8-72-99s30.3-85.5 72-99z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M340 683v77c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8v-77c41.7-13.5 72-52.8 72-99s-30.3-85.4-72-99V264c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v221c-41.7 13.5-72 52.8-72 99s30.3 85.4 72 99zm.1-116c.1-.2.2-.3.3-.5l1.5-2.4c0-.1.1-.1.1-.2l.9-1.2c0-.1.1-.2.2-.3 1-1.2 2.1-2.5 3.2-3.6l.2-.2c.4-.4.8-.7 1.2-1.1.8-.7 1.7-1.4 2.6-2.1h.1l1.2-.9c.1-.1.3-.2.4-.3 1.3-.8 2.6-1.5 3.9-2.2.2-.2.5-.3.7-.4.4-.2.7-.3 1.1-.5.3-.1.7-.3 1-.4.5-.1 1-.3 1.5-.5.4-.1.9-.3 1.3-.4l.9-.3 1.4-.3c.2-.1.5-.1.7-.2.7-.2 1.4-.3 2.1-.4.2-.1.4-.1.6-.1.5-.1 1.1-.2 1.7-.2.3-.1.5-.1.7-.1.8-.1 1.5-.1 2.3-.1s1.5.1 2.3.1c.3.1.5.1.7.1.6.1 1.1.1 1.7.2.2.1.4.1.6.1.7.1 1.4.3 2.1.4.2.1.5.1.7.2l1.4.3.9.3c.4.1.9.3 1.3.4.5.1 1 .3 1.5.5.3.1.7.3 1 .4.4.2.7.3 1.1.5.2.2.5.3.7.4 1.4.6 2.7 1.4 3.9 2.2.1.1.3.2.4.3l1.2.9h.1c.9.6 1.8 1.3 2.6 2.1.4.3.8.7 1.2 1.1l.2.2c1.2 1.1 2.2 2.3 3.2 3.6 0 .1.1.2.2.3l.9 1.2c0 .1.1.1.1.2l1.5 2.4A36.03 36.03 0 01408 584c0 6.1-1.6 11.9-4.3 17-.1.2-.2.3-.3.5l-1.5 2.4c0 .1-.1.1-.1.2l-.9 1.2c0 .1-.1.2-.2.3-1 1.2-2.1 2.5-3.2 3.6l-.2.2c-.4.4-.8.7-1.2 1.1-.8.7-1.7 1.4-2.6 2.1h-.1l-1.2.9c-.1.1-.3.2-.4.3-1.3.8-2.6 1.5-3.9 2.2-.2.2-.5.3-.7.4-.4.2-.7.3-1.1.5-.3.1-.7.3-1 .4-.5.1-1 .3-1.5.5-.4.1-.9.3-1.3.4l-.9.3-1.4.3c-.2.1-.5.1-.7.2-.7.2-1.4.3-2.1.4-.2.1-.4.1-.6.1-.5.1-1.1.2-1.7.2-.3.1-.5.1-.7.1-.8.1-1.5.1-2.3.1s-1.5-.1-2.3-.1c-.3-.1-.5-.1-.7-.1-.6-.1-1.1-.1-1.7-.2-.2-.1-.4-.1-.6-.1-.7-.1-1.4-.3-2.1-.4-.2-.1-.5-.1-.7-.2l-1.4-.3-.9-.3c-.4-.1-.9-.3-1.3-.4-.5-.1-1-.3-1.5-.5-.3-.1-.7-.3-1-.4-.4-.2-.7-.3-1.1-.5-.2-.2-.5-.3-.7-.4-1.4-.6-2.7-1.4-3.9-2.2-.1-.1-.3-.2-.4-.3l-1.2-.9h-.1c-.9-.6-1.8-1.3-2.6-2.1-.4-.3-.8-.7-1.2-1.1l-.2-.2c-1.2-1.1-2.2-2.3-3.2-3.6 0-.1-.1-.2-.2-.3l-.9-1.2c0-.1-.1-.1-.1-.2l-1.5-2.4c-.1-.2-.2-.3-.3-.5-2.7-5-4.3-10.9-4.3-17s1.6-11.9 4.3-17zm280.3-27.9c-.1 0-.2-.1-.4-.1v221c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V539c-.1 0-.2.1-.4.1 42-13.4 72.4-52.7 72.4-99.1 0-46.4-30.4-85.7-72.4-99.1.1 0 .2.1.4.1v-77c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v77c.1 0 .2-.1.4-.1-42 13.4-72.4 52.7-72.4 99.1 0 46.4 30.4 85.7 72.4 99.1zM652 404c19.9 0 36 16.1 36 36s-16.1 36-36 36-36-16.1-36-36 16.1-36 36-36z", "fill": primaryColor } }] }; }, "name": "control", "theme": "twotone" };
	exports.default = ControlTwoTone;
	});

	var ControlTwoToneSvg = unwrapExports(ControlTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var ControlTwoTone = function ControlTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ControlTwoToneSvg
	  }));
	};

	ControlTwoTone.displayName = 'ControlTwoTone';
	var ControlTwoTone$1 = /*#__PURE__*/React.forwardRef(ControlTwoTone);

	var CopyFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CopyFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M832 64H296c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h496v688c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V96c0-17.7-14.3-32-32-32zM704 192H192c-17.7 0-32 14.3-32 32v530.7c0 8.5 3.4 16.6 9.4 22.6l173.3 173.3c2.2 2.2 4.7 4 7.4 5.5v1.9h4.2c3.5 1.3 7.2 2 11 2H704c17.7 0 32-14.3 32-32V224c0-17.7-14.3-32-32-32zM382 896h-.2L232 746.2v-.2h150v150z" } }] }, "name": "copy", "theme": "filled" };
	exports.default = CopyFilled;
	});

	var CopyFilledSvg = unwrapExports(CopyFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var CopyFilled = function CopyFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CopyFilledSvg
	  }));
	};

	CopyFilled.displayName = 'CopyFilled';
	var CopyFilled$1 = /*#__PURE__*/React.forwardRef(CopyFilled);

	var CopyOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CopyOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M832 64H296c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h496v688c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V96c0-17.7-14.3-32-32-32zM704 192H192c-17.7 0-32 14.3-32 32v530.7c0 8.5 3.4 16.6 9.4 22.6l173.3 173.3c2.2 2.2 4.7 4 7.4 5.5v1.9h4.2c3.5 1.3 7.2 2 11 2H704c17.7 0 32-14.3 32-32V224c0-17.7-14.3-32-32-32zM350 856.2L263.9 770H350v86.2zM664 888H414V746c0-22.1-17.9-40-40-40H232V264h432v624z" } }] }, "name": "copy", "theme": "outlined" };
	exports.default = CopyOutlined;
	});

	var CopyOutlinedSvg = unwrapExports(CopyOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var CopyOutlined = function CopyOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CopyOutlinedSvg
	  }));
	};

	CopyOutlined.displayName = 'CopyOutlined';
	var CopyOutlined$1 = /*#__PURE__*/React.forwardRef(CopyOutlined);

	var CopyTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CopyTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M232 706h142c22.1 0 40 17.9 40 40v142h250V264H232v442z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M832 64H296c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h496v688c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V96c0-17.7-14.3-32-32-32z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M704 192H192c-17.7 0-32 14.3-32 32v530.7c0 8.5 3.4 16.6 9.4 22.6l173.3 173.3c2.2 2.2 4.7 4 7.4 5.5v1.9h4.2c3.5 1.3 7.2 2 11 2H704c17.7 0 32-14.3 32-32V224c0-17.7-14.3-32-32-32zM350 856.2L263.9 770H350v86.2zM664 888H414V746c0-22.1-17.9-40-40-40H232V264h432v624z", "fill": primaryColor } }] }; }, "name": "copy", "theme": "twotone" };
	exports.default = CopyTwoTone;
	});

	var CopyTwoToneSvg = unwrapExports(CopyTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var CopyTwoTone = function CopyTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CopyTwoToneSvg
	  }));
	};

	CopyTwoTone.displayName = 'CopyTwoTone';
	var CopyTwoTone$1 = /*#__PURE__*/React.forwardRef(CopyTwoTone);

	var CopyrightCircleFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CopyrightCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm5.4 670c-110 0-173.4-73.2-173.4-194.9v-52.3C344 364.2 407.4 290 517.3 290c94.3 0 162.7 60.7 162.7 147.4 0 2.6-2.1 4.7-4.7 4.7h-56.7c-4.2 0-7.6-3.2-8-7.4-4-49.5-40-83.4-93-83.4-65.3 0-102.1 48.5-102.1 135.5v52.6c0 85.7 36.9 133.6 102.1 133.6 52.8 0 88.7-31.7 93-77.8.4-4.1 3.8-7.3 8-7.3h56.8c2.6 0 4.7 2.1 4.7 4.7 0 82.6-68.7 141.4-162.7 141.4z" } }] }, "name": "copyright-circle", "theme": "filled" };
	exports.default = CopyrightCircleFilled;
	});

	var CopyrightCircleFilledSvg = unwrapExports(CopyrightCircleFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var CopyrightCircleFilled = function CopyrightCircleFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CopyrightCircleFilledSvg
	  }));
	};

	CopyrightCircleFilled.displayName = 'CopyrightCircleFilled';
	var CopyrightCircleFilled$1 = /*#__PURE__*/React.forwardRef(CopyrightCircleFilled);

	var CopyrightCircleOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CopyrightCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372zm5.6-532.7c53 0 89 33.8 93 83.4.3 4.2 3.8 7.4 8 7.4h56.7c2.6 0 4.7-2.1 4.7-4.7 0-86.7-68.4-147.4-162.7-147.4C407.4 290 344 364.2 344 486.8v52.3C344 660.8 407.4 734 517.3 734c94 0 162.7-58.8 162.7-141.4 0-2.6-2.1-4.7-4.7-4.7h-56.8c-4.2 0-7.6 3.2-8 7.3-4.2 46.1-40.1 77.8-93 77.8-65.3 0-102.1-47.9-102.1-133.6v-52.6c.1-87 37-135.5 102.2-135.5z" } }] }, "name": "copyright-circle", "theme": "outlined" };
	exports.default = CopyrightCircleOutlined;
	});

	var CopyrightCircleOutlinedSvg = unwrapExports(CopyrightCircleOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var CopyrightCircleOutlined = function CopyrightCircleOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CopyrightCircleOutlinedSvg
	  }));
	};

	CopyrightCircleOutlined.displayName = 'CopyrightCircleOutlined';
	var CopyrightCircleOutlined$1 = /*#__PURE__*/React.forwardRef(CopyrightCircleOutlined);

	var CopyrightCircleTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CopyrightCircleTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm5.5 533c52.9 0 88.8-31.7 93-77.8.4-4.1 3.8-7.3 8-7.3h56.8c2.6 0 4.7 2.1 4.7 4.7 0 82.6-68.7 141.4-162.7 141.4C407.4 734 344 660.8 344 539.1v-52.3C344 364.2 407.4 290 517.3 290c94.3 0 162.7 60.7 162.7 147.4 0 2.6-2.1 4.7-4.7 4.7h-56.7c-4.2 0-7.7-3.2-8-7.4-4-49.6-40-83.4-93-83.4-65.2 0-102.1 48.5-102.2 135.5v52.6c0 85.7 36.8 133.6 102.1 133.6z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M517.6 351.3c53 0 89 33.8 93 83.4.3 4.2 3.8 7.4 8 7.4h56.7c2.6 0 4.7-2.1 4.7-4.7 0-86.7-68.4-147.4-162.7-147.4C407.4 290 344 364.2 344 486.8v52.3C344 660.8 407.4 734 517.3 734c94 0 162.7-58.8 162.7-141.4 0-2.6-2.1-4.7-4.7-4.7h-56.8c-4.2 0-7.6 3.2-8 7.3-4.2 46.1-40.1 77.8-93 77.8-65.3 0-102.1-47.9-102.1-133.6v-52.6c.1-87 37-135.5 102.2-135.5z", "fill": primaryColor } }] }; }, "name": "copyright-circle", "theme": "twotone" };
	exports.default = CopyrightCircleTwoTone;
	});

	var CopyrightCircleTwoToneSvg = unwrapExports(CopyrightCircleTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var CopyrightCircleTwoTone = function CopyrightCircleTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CopyrightCircleTwoToneSvg
	  }));
	};

	CopyrightCircleTwoTone.displayName = 'CopyrightCircleTwoTone';
	var CopyrightCircleTwoTone$1 = /*#__PURE__*/React.forwardRef(CopyrightCircleTwoTone);

	var CopyrightOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CopyrightOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372zm5.6-532.7c53 0 89 33.8 93 83.4.3 4.2 3.8 7.4 8 7.4h56.7c2.6 0 4.7-2.1 4.7-4.7 0-86.7-68.4-147.4-162.7-147.4C407.4 290 344 364.2 344 486.8v52.3C344 660.8 407.4 734 517.3 734c94 0 162.7-58.8 162.7-141.4 0-2.6-2.1-4.7-4.7-4.7h-56.8c-4.2 0-7.6 3.2-8 7.3-4.2 46.1-40.1 77.8-93 77.8-65.3 0-102.1-47.9-102.1-133.6v-52.6c.1-87 37-135.5 102.2-135.5z" } }] }, "name": "copyright", "theme": "outlined" };
	exports.default = CopyrightOutlined;
	});

	var CopyrightOutlinedSvg = unwrapExports(CopyrightOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var CopyrightOutlined = function CopyrightOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CopyrightOutlinedSvg
	  }));
	};

	CopyrightOutlined.displayName = 'CopyrightOutlined';
	var CopyrightOutlined$1 = /*#__PURE__*/React.forwardRef(CopyrightOutlined);

	var CopyrightTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CopyrightTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm5.5 533c52.9 0 88.8-31.7 93-77.8.4-4.1 3.8-7.3 8-7.3h56.8c2.6 0 4.7 2.1 4.7 4.7 0 82.6-68.7 141.4-162.7 141.4C407.4 734 344 660.8 344 539.1v-52.3C344 364.2 407.4 290 517.3 290c94.3 0 162.7 60.7 162.7 147.4 0 2.6-2.1 4.7-4.7 4.7h-56.7c-4.2 0-7.7-3.2-8-7.4-4-49.6-40-83.4-93-83.4-65.2 0-102.1 48.5-102.2 135.5v52.6c0 85.7 36.8 133.6 102.1 133.6z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M517.6 351.3c53 0 89 33.8 93 83.4.3 4.2 3.8 7.4 8 7.4h56.7c2.6 0 4.7-2.1 4.7-4.7 0-86.7-68.4-147.4-162.7-147.4C407.4 290 344 364.2 344 486.8v52.3C344 660.8 407.4 734 517.3 734c94 0 162.7-58.8 162.7-141.4 0-2.6-2.1-4.7-4.7-4.7h-56.8c-4.2 0-7.6 3.2-8 7.3-4.2 46.1-40.1 77.8-93 77.8-65.3 0-102.1-47.9-102.1-133.6v-52.6c.1-87 37-135.5 102.2-135.5z", "fill": primaryColor } }] }; }, "name": "copyright", "theme": "twotone" };
	exports.default = CopyrightTwoTone;
	});

	var CopyrightTwoToneSvg = unwrapExports(CopyrightTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var CopyrightTwoTone = function CopyrightTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CopyrightTwoToneSvg
	  }));
	};

	CopyrightTwoTone.displayName = 'CopyrightTwoTone';
	var CopyrightTwoTone$1 = /*#__PURE__*/React.forwardRef(CopyrightTwoTone);

	var CreditCardFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CreditCardFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M928 160H96c-17.7 0-32 14.3-32 32v160h896V192c0-17.7-14.3-32-32-32zM64 832c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V440H64v392zm579-184c0-4.4 3.6-8 8-8h165c4.4 0 8 3.6 8 8v72c0 4.4-3.6 8-8 8H651c-4.4 0-8-3.6-8-8v-72z" } }] }, "name": "credit-card", "theme": "filled" };
	exports.default = CreditCardFilled;
	});

	var CreditCardFilledSvg = unwrapExports(CreditCardFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var CreditCardFilled = function CreditCardFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CreditCardFilledSvg
	  }));
	};

	CreditCardFilled.displayName = 'CreditCardFilled';
	var CreditCardFilled$1 = /*#__PURE__*/React.forwardRef(CreditCardFilled);

	var CreditCardOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CreditCardOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M928 160H96c-17.7 0-32 14.3-32 32v640c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V192c0-17.7-14.3-32-32-32zm-792 72h752v120H136V232zm752 560H136V440h752v352zm-237-64h165c4.4 0 8-3.6 8-8v-72c0-4.4-3.6-8-8-8H651c-4.4 0-8 3.6-8 8v72c0 4.4 3.6 8 8 8z" } }] }, "name": "credit-card", "theme": "outlined" };
	exports.default = CreditCardOutlined;
	});

	var CreditCardOutlinedSvg = unwrapExports(CreditCardOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var CreditCardOutlined = function CreditCardOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CreditCardOutlinedSvg
	  }));
	};

	CreditCardOutlined.displayName = 'CreditCardOutlined';
	var CreditCardOutlined$1 = /*#__PURE__*/React.forwardRef(CreditCardOutlined);

	var CreditCardTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CreditCardTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M136 792h752V440H136v352zm507-144c0-4.4 3.6-8 8-8h165c4.4 0 8 3.6 8 8v72c0 4.4-3.6 8-8 8H651c-4.4 0-8-3.6-8-8v-72zM136 232h752v120H136z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M651 728h165c4.4 0 8-3.6 8-8v-72c0-4.4-3.6-8-8-8H651c-4.4 0-8 3.6-8 8v72c0 4.4 3.6 8 8 8z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M928 160H96c-17.7 0-32 14.3-32 32v640c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V192c0-17.7-14.3-32-32-32zm-40 632H136V440h752v352zm0-440H136V232h752v120z", "fill": primaryColor } }] }; }, "name": "credit-card", "theme": "twotone" };
	exports.default = CreditCardTwoTone;
	});

	var CreditCardTwoToneSvg = unwrapExports(CreditCardTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var CreditCardTwoTone = function CreditCardTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CreditCardTwoToneSvg
	  }));
	};

	CreditCardTwoTone.displayName = 'CreditCardTwoTone';
	var CreditCardTwoTone$1 = /*#__PURE__*/React.forwardRef(CreditCardTwoTone);

	var CrownFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CrownFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M899.6 276.5L705 396.4 518.4 147.5a8.06 8.06 0 00-12.9 0L319 396.4 124.3 276.5c-5.7-3.5-13.1 1.2-12.2 7.9L188.5 865c1.1 7.9 7.9 14 16 14h615.1c8 0 14.9-6 15.9-14l76.4-580.6c.8-6.7-6.5-11.4-12.3-7.9zM512 734.2c-62.1 0-112.6-50.5-112.6-112.6S449.9 509 512 509s112.6 50.5 112.6 112.6S574.1 734.2 512 734.2zm0-160.9c-26.6 0-48.2 21.6-48.2 48.3 0 26.6 21.6 48.3 48.2 48.3s48.2-21.6 48.2-48.3c0-26.6-21.6-48.3-48.2-48.3z" } }] }, "name": "crown", "theme": "filled" };
	exports.default = CrownFilled;
	});

	var CrownFilledSvg = unwrapExports(CrownFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var CrownFilled = function CrownFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CrownFilledSvg
	  }));
	};

	CrownFilled.displayName = 'CrownFilled';
	var CrownFilled$1 = /*#__PURE__*/React.forwardRef(CrownFilled);

	var CrownOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CrownOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M899.6 276.5L705 396.4 518.4 147.5a8.06 8.06 0 00-12.9 0L319 396.4 124.3 276.5c-5.7-3.5-13.1 1.2-12.2 7.9L188.5 865c1.1 7.9 7.9 14 16 14h615.1c8 0 14.9-6 15.9-14l76.4-580.6c.8-6.7-6.5-11.4-12.3-7.9zm-126 534.1H250.3l-53.8-409.4 139.8 86.1L512 252.9l175.7 234.4 139.8-86.1-53.9 409.4zM512 509c-62.1 0-112.6 50.5-112.6 112.6S449.9 734.2 512 734.2s112.6-50.5 112.6-112.6S574.1 509 512 509zm0 160.9c-26.6 0-48.2-21.6-48.2-48.3 0-26.6 21.6-48.3 48.2-48.3s48.2 21.6 48.2 48.3c0 26.6-21.6 48.3-48.2 48.3z" } }] }, "name": "crown", "theme": "outlined" };
	exports.default = CrownOutlined;
	});

	var CrownOutlinedSvg = unwrapExports(CrownOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var CrownOutlined = function CrownOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CrownOutlinedSvg
	  }));
	};

	CrownOutlined.displayName = 'CrownOutlined';
	var CrownOutlined$1 = /*#__PURE__*/React.forwardRef(CrownOutlined);

	var CrownTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CrownTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M911.9 283.9v.5L835.5 865c-1 8-7.9 14-15.9 14H204.5c-8.1 0-14.9-6.1-16-14l-76.4-580.6v-.6 1.6L188.5 866c1.1 7.9 7.9 14 16 14h615.1c8 0 14.9-6 15.9-14l76.4-580.6c.1-.5.1-1 0-1.5z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M773.6 810.6l53.9-409.4-139.8 86.1L512 252.9 336.3 487.3l-139.8-86.1 53.8 409.4h523.3zm-374.2-189c0-62.1 50.5-112.6 112.6-112.6s112.6 50.5 112.6 112.6v1c0 62.1-50.5 112.6-112.6 112.6s-112.6-50.5-112.6-112.6v-1z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M512 734.2c61.9 0 112.3-50.2 112.6-112.1v-.5c0-62.1-50.5-112.6-112.6-112.6s-112.6 50.5-112.6 112.6v.5c.3 61.9 50.7 112.1 112.6 112.1zm0-160.9c26.6 0 48.2 21.6 48.2 48.3 0 26.6-21.6 48.3-48.2 48.3s-48.2-21.6-48.2-48.3c0-26.6 21.6-48.3 48.2-48.3z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M188.5 865c1.1 7.9 7.9 14 16 14h615.1c8 0 14.9-6 15.9-14l76.4-580.6v-.5c.3-6.4-6.7-10.8-12.3-7.4L705 396.4 518.4 147.5a8.06 8.06 0 00-12.9 0L319 396.4 124.3 276.5c-5.5-3.4-12.6.9-12.2 7.3v.6L188.5 865zm147.8-377.7L512 252.9l175.7 234.4 139.8-86.1-53.9 409.4H250.3l-53.8-409.4 139.8 86.1z", "fill": primaryColor } }] }; }, "name": "crown", "theme": "twotone" };
	exports.default = CrownTwoTone;
	});

	var CrownTwoToneSvg = unwrapExports(CrownTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var CrownTwoTone = function CrownTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CrownTwoToneSvg
	  }));
	};

	CrownTwoTone.displayName = 'CrownTwoTone';
	var CrownTwoTone$1 = /*#__PURE__*/React.forwardRef(CrownTwoTone);

	var CustomerServiceFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CustomerServiceFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 128c-212.1 0-384 171.9-384 384v360c0 13.3 10.7 24 24 24h184c35.3 0 64-28.7 64-64V624c0-35.3-28.7-64-64-64H200v-48c0-172.3 139.7-312 312-312s312 139.7 312 312v48H688c-35.3 0-64 28.7-64 64v208c0 35.3 28.7 64 64 64h184c13.3 0 24-10.7 24-24V512c0-212.1-171.9-384-384-384z" } }] }, "name": "customer-service", "theme": "filled" };
	exports.default = CustomerServiceFilled;
	});

	var CustomerServiceFilledSvg = unwrapExports(CustomerServiceFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var CustomerServiceFilled = function CustomerServiceFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CustomerServiceFilledSvg
	  }));
	};

	CustomerServiceFilled.displayName = 'CustomerServiceFilled';
	var CustomerServiceFilled$1 = /*#__PURE__*/React.forwardRef(CustomerServiceFilled);

	var CustomerServiceOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CustomerServiceOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 128c-212.1 0-384 171.9-384 384v360c0 13.3 10.7 24 24 24h184c35.3 0 64-28.7 64-64V624c0-35.3-28.7-64-64-64H200v-48c0-172.3 139.7-312 312-312s312 139.7 312 312v48H688c-35.3 0-64 28.7-64 64v208c0 35.3 28.7 64 64 64h184c13.3 0 24-10.7 24-24V512c0-212.1-171.9-384-384-384zM328 632v192H200V632h128zm496 192H696V632h128v192z" } }] }, "name": "customer-service", "theme": "outlined" };
	exports.default = CustomerServiceOutlined;
	});

	var CustomerServiceOutlinedSvg = unwrapExports(CustomerServiceOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var CustomerServiceOutlined = function CustomerServiceOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CustomerServiceOutlinedSvg
	  }));
	};

	CustomerServiceOutlined.displayName = 'CustomerServiceOutlined';
	var CustomerServiceOutlined$1 = /*#__PURE__*/React.forwardRef(CustomerServiceOutlined);

	var CustomerServiceTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var CustomerServiceTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M696 632h128v192H696zm-496 0h128v192H200z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M512 128c-212.1 0-384 171.9-384 384v360c0 13.3 10.7 24 24 24h184c35.3 0 64-28.7 64-64V624c0-35.3-28.7-64-64-64H200v-48c0-172.3 139.7-312 312-312s312 139.7 312 312v48H688c-35.3 0-64 28.7-64 64v208c0 35.3 28.7 64 64 64h184c13.3 0 24-10.7 24-24V512c0-212.1-171.9-384-384-384zM328 632v192H200V632h128zm496 192H696V632h128v192z", "fill": primaryColor } }] }; }, "name": "customer-service", "theme": "twotone" };
	exports.default = CustomerServiceTwoTone;
	});

	var CustomerServiceTwoToneSvg = unwrapExports(CustomerServiceTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var CustomerServiceTwoTone = function CustomerServiceTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: CustomerServiceTwoToneSvg
	  }));
	};

	CustomerServiceTwoTone.displayName = 'CustomerServiceTwoTone';
	var CustomerServiceTwoTone$1 = /*#__PURE__*/React.forwardRef(CustomerServiceTwoTone);

	var DashOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DashOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M112 476h160v72H112zm320 0h160v72H432zm320 0h160v72H752z" } }] }, "name": "dash", "theme": "outlined" };
	exports.default = DashOutlined;
	});

	var DashOutlinedSvg = unwrapExports(DashOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var DashOutlined = function DashOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DashOutlinedSvg
	  }));
	};

	DashOutlined.displayName = 'DashOutlined';
	var DashOutlined$1 = /*#__PURE__*/React.forwardRef(DashOutlined);

	var DashboardFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DashboardFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M924.8 385.6a446.7 446.7 0 00-96-142.4 446.7 446.7 0 00-142.4-96C631.1 123.8 572.5 112 512 112s-119.1 11.8-174.4 35.2a446.7 446.7 0 00-142.4 96 446.7 446.7 0 00-96 142.4C75.8 440.9 64 499.5 64 560c0 132.7 58.3 257.7 159.9 343.1l1.7 1.4c5.8 4.8 13.1 7.5 20.6 7.5h531.7c7.5 0 14.8-2.7 20.6-7.5l1.7-1.4C901.7 817.7 960 692.7 960 560c0-60.5-11.9-119.1-35.2-174.4zM482 232c0-4.4 3.6-8 8-8h44c4.4 0 8 3.6 8 8v80c0 4.4-3.6 8-8 8h-44c-4.4 0-8-3.6-8-8v-80zM270 582c0 4.4-3.6 8-8 8h-80c-4.4 0-8-3.6-8-8v-44c0-4.4 3.6-8 8-8h80c4.4 0 8 3.6 8 8v44zm90.7-204.5l-31.1 31.1a8.03 8.03 0 01-11.3 0L261.7 352a8.03 8.03 0 010-11.3l31.1-31.1c3.1-3.1 8.2-3.1 11.3 0l56.6 56.6c3.1 3.1 3.1 8.2 0 11.3zm291.1 83.6l-84.5 84.5c5 18.7.2 39.4-14.5 54.1a55.95 55.95 0 01-79.2 0 55.95 55.95 0 010-79.2 55.87 55.87 0 0154.1-14.5l84.5-84.5c3.1-3.1 8.2-3.1 11.3 0l28.3 28.3c3.1 3.1 3.1 8.1 0 11.3zm43-52.4l-31.1-31.1a8.03 8.03 0 010-11.3l56.6-56.6c3.1-3.1 8.2-3.1 11.3 0l31.1 31.1c3.1 3.1 3.1 8.2 0 11.3l-56.6 56.6a8.03 8.03 0 01-11.3 0zM846 582c0 4.4-3.6 8-8 8h-80c-4.4 0-8-3.6-8-8v-44c0-4.4 3.6-8 8-8h80c4.4 0 8 3.6 8 8v44z" } }] }, "name": "dashboard", "theme": "filled" };
	exports.default = DashboardFilled;
	});

	var DashboardFilledSvg = unwrapExports(DashboardFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var DashboardFilled = function DashboardFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DashboardFilledSvg
	  }));
	};

	DashboardFilled.displayName = 'DashboardFilled';
	var DashboardFilled$1 = /*#__PURE__*/React.forwardRef(DashboardFilled);

	var DashboardOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DashboardOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M924.8 385.6a446.7 446.7 0 00-96-142.4 446.7 446.7 0 00-142.4-96C631.1 123.8 572.5 112 512 112s-119.1 11.8-174.4 35.2a446.7 446.7 0 00-142.4 96 446.7 446.7 0 00-96 142.4C75.8 440.9 64 499.5 64 560c0 132.7 58.3 257.7 159.9 343.1l1.7 1.4c5.8 4.8 13.1 7.5 20.6 7.5h531.7c7.5 0 14.8-2.7 20.6-7.5l1.7-1.4C901.7 817.7 960 692.7 960 560c0-60.5-11.9-119.1-35.2-174.4zM761.4 836H262.6A371.12 371.12 0 01140 560c0-99.4 38.7-192.8 109-263 70.3-70.3 163.7-109 263-109 99.4 0 192.8 38.7 263 109 70.3 70.3 109 163.7 109 263 0 105.6-44.5 205.5-122.6 276zM623.5 421.5a8.03 8.03 0 00-11.3 0L527.7 506c-18.7-5-39.4-.2-54.1 14.5a55.95 55.95 0 000 79.2 55.95 55.95 0 0079.2 0 55.87 55.87 0 0014.5-54.1l84.5-84.5c3.1-3.1 3.1-8.2 0-11.3l-28.3-28.3zM490 320h44c4.4 0 8-3.6 8-8v-80c0-4.4-3.6-8-8-8h-44c-4.4 0-8 3.6-8 8v80c0 4.4 3.6 8 8 8zm260 218v44c0 4.4 3.6 8 8 8h80c4.4 0 8-3.6 8-8v-44c0-4.4-3.6-8-8-8h-80c-4.4 0-8 3.6-8 8zm12.7-197.2l-31.1-31.1a8.03 8.03 0 00-11.3 0l-56.6 56.6a8.03 8.03 0 000 11.3l31.1 31.1c3.1 3.1 8.2 3.1 11.3 0l56.6-56.6c3.1-3.1 3.1-8.2 0-11.3zm-458.6-31.1a8.03 8.03 0 00-11.3 0l-31.1 31.1a8.03 8.03 0 000 11.3l56.6 56.6c3.1 3.1 8.2 3.1 11.3 0l31.1-31.1c3.1-3.1 3.1-8.2 0-11.3l-56.6-56.6zM262 530h-80c-4.4 0-8 3.6-8 8v44c0 4.4 3.6 8 8 8h80c4.4 0 8-3.6 8-8v-44c0-4.4-3.6-8-8-8z" } }] }, "name": "dashboard", "theme": "outlined" };
	exports.default = DashboardOutlined;
	});

	var DashboardOutlinedSvg = unwrapExports(DashboardOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var DashboardOutlined = function DashboardOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DashboardOutlinedSvg
	  }));
	};

	DashboardOutlined.displayName = 'DashboardOutlined';
	var DashboardOutlined$1 = /*#__PURE__*/React.forwardRef(DashboardOutlined);

	var DashboardTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DashboardTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 188c-99.3 0-192.7 38.7-263 109-70.3 70.2-109 163.6-109 263 0 105.6 44.5 205.5 122.6 276h498.8A371.12 371.12 0 00884 560c0-99.3-38.7-192.7-109-263-70.2-70.3-163.6-109-263-109zm-30 44c0-4.4 3.6-8 8-8h44c4.4 0 8 3.6 8 8v80c0 4.4-3.6 8-8 8h-44c-4.4 0-8-3.6-8-8v-80zM270 582c0 4.4-3.6 8-8 8h-80c-4.4 0-8-3.6-8-8v-44c0-4.4 3.6-8 8-8h80c4.4 0 8 3.6 8 8v44zm90.7-204.4l-31.1 31.1a8.03 8.03 0 01-11.3 0l-56.6-56.6a8.03 8.03 0 010-11.3l31.1-31.1c3.1-3.1 8.2-3.1 11.3 0l56.6 56.6c3.1 3.1 3.1 8.2 0 11.3zm291.1 83.5l-84.5 84.5c5 18.7.2 39.4-14.5 54.1a55.95 55.95 0 01-79.2 0 55.95 55.95 0 010-79.2 55.87 55.87 0 0154.1-14.5l84.5-84.5c3.1-3.1 8.2-3.1 11.3 0l28.3 28.3c3.1 3.1 3.1 8.2 0 11.3zm43-52.4l-31.1-31.1a8.03 8.03 0 010-11.3l56.6-56.6c3.1-3.1 8.2-3.1 11.3 0l31.1 31.1c3.1 3.1 3.1 8.2 0 11.3l-56.6 56.6a8.03 8.03 0 01-11.3 0zM846 538v44c0 4.4-3.6 8-8 8h-80c-4.4 0-8-3.6-8-8v-44c0-4.4 3.6-8 8-8h80c4.4 0 8 3.6 8 8z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M623.5 421.5a8.03 8.03 0 00-11.3 0L527.7 506c-18.7-5-39.4-.2-54.1 14.5a55.95 55.95 0 000 79.2 55.95 55.95 0 0079.2 0 55.87 55.87 0 0014.5-54.1l84.5-84.5c3.1-3.1 3.1-8.2 0-11.3l-28.3-28.3zM490 320h44c4.4 0 8-3.6 8-8v-80c0-4.4-3.6-8-8-8h-44c-4.4 0-8 3.6-8 8v80c0 4.4 3.6 8 8 8z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M924.8 385.6a446.7 446.7 0 00-96-142.4 446.7 446.7 0 00-142.4-96C631.1 123.8 572.5 112 512 112s-119.1 11.8-174.4 35.2a446.7 446.7 0 00-142.4 96 446.7 446.7 0 00-96 142.4C75.8 440.9 64 499.5 64 560c0 132.7 58.3 257.7 159.9 343.1l1.7 1.4c5.8 4.8 13.1 7.5 20.6 7.5h531.7c7.5 0 14.8-2.7 20.6-7.5l1.7-1.4C901.7 817.7 960 692.7 960 560c0-60.5-11.9-119.1-35.2-174.4zM761.4 836H262.6A371.12 371.12 0 01140 560c0-99.4 38.7-192.8 109-263 70.3-70.3 163.7-109 263-109 99.4 0 192.8 38.7 263 109 70.3 70.3 109 163.7 109 263 0 105.6-44.5 205.5-122.6 276z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M762.7 340.8l-31.1-31.1a8.03 8.03 0 00-11.3 0l-56.6 56.6a8.03 8.03 0 000 11.3l31.1 31.1c3.1 3.1 8.2 3.1 11.3 0l56.6-56.6c3.1-3.1 3.1-8.2 0-11.3zM750 538v44c0 4.4 3.6 8 8 8h80c4.4 0 8-3.6 8-8v-44c0-4.4-3.6-8-8-8h-80c-4.4 0-8 3.6-8 8zM304.1 309.7a8.03 8.03 0 00-11.3 0l-31.1 31.1a8.03 8.03 0 000 11.3l56.6 56.6c3.1 3.1 8.2 3.1 11.3 0l31.1-31.1c3.1-3.1 3.1-8.2 0-11.3l-56.6-56.6zM262 530h-80c-4.4 0-8 3.6-8 8v44c0 4.4 3.6 8 8 8h80c4.4 0 8-3.6 8-8v-44c0-4.4-3.6-8-8-8z", "fill": primaryColor } }] }; }, "name": "dashboard", "theme": "twotone" };
	exports.default = DashboardTwoTone;
	});

	var DashboardTwoToneSvg = unwrapExports(DashboardTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var DashboardTwoTone = function DashboardTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DashboardTwoToneSvg
	  }));
	};

	DashboardTwoTone.displayName = 'DashboardTwoTone';
	var DashboardTwoTone$1 = /*#__PURE__*/React.forwardRef(DashboardTwoTone);

	var DatabaseFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DatabaseFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M832 64H192c-17.7 0-32 14.3-32 32v224h704V96c0-17.7-14.3-32-32-32zM288 232c-22.1 0-40-17.9-40-40s17.9-40 40-40 40 17.9 40 40-17.9 40-40 40zM160 928c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V704H160v224zm128-136c22.1 0 40 17.9 40 40s-17.9 40-40 40-40-17.9-40-40 17.9-40 40-40zM160 640h704V384H160v256zm128-168c22.1 0 40 17.9 40 40s-17.9 40-40 40-40-17.9-40-40 17.9-40 40-40z" } }] }, "name": "database", "theme": "filled" };
	exports.default = DatabaseFilled;
	});

	var DatabaseFilledSvg = unwrapExports(DatabaseFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var DatabaseFilled = function DatabaseFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DatabaseFilledSvg
	  }));
	};

	DatabaseFilled.displayName = 'DatabaseFilled';
	var DatabaseFilled$1 = /*#__PURE__*/React.forwardRef(DatabaseFilled);

	var DatabaseOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DatabaseOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M832 64H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V96c0-17.7-14.3-32-32-32zm-600 72h560v208H232V136zm560 480H232V408h560v208zm0 272H232V680h560v208zM304 240a40 40 0 1080 0 40 40 0 10-80 0zm0 272a40 40 0 1080 0 40 40 0 10-80 0zm0 272a40 40 0 1080 0 40 40 0 10-80 0z" } }] }, "name": "database", "theme": "outlined" };
	exports.default = DatabaseOutlined;
	});

	var DatabaseOutlinedSvg = unwrapExports(DatabaseOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var DatabaseOutlined = function DatabaseOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DatabaseOutlinedSvg
	  }));
	};

	DatabaseOutlined.displayName = 'DatabaseOutlined';
	var DatabaseOutlined$1 = /*#__PURE__*/React.forwardRef(DatabaseOutlined);

	var DatabaseTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DatabaseTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M232 616h560V408H232v208zm112-144c22.1 0 40 17.9 40 40s-17.9 40-40 40-40-17.9-40-40 17.9-40 40-40zM232 888h560V680H232v208zm112-144c22.1 0 40 17.9 40 40s-17.9 40-40 40-40-17.9-40-40 17.9-40 40-40zM232 344h560V136H232v208zm112-144c22.1 0 40 17.9 40 40s-17.9 40-40 40-40-17.9-40-40 17.9-40 40-40z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M304 512a40 40 0 1080 0 40 40 0 10-80 0zm0 272a40 40 0 1080 0 40 40 0 10-80 0zm0-544a40 40 0 1080 0 40 40 0 10-80 0z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M832 64H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V96c0-17.7-14.3-32-32-32zm-40 824H232V680h560v208zm0-272H232V408h560v208zm0-272H232V136h560v208z", "fill": primaryColor } }] }; }, "name": "database", "theme": "twotone" };
	exports.default = DatabaseTwoTone;
	});

	var DatabaseTwoToneSvg = unwrapExports(DatabaseTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var DatabaseTwoTone = function DatabaseTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DatabaseTwoToneSvg
	  }));
	};

	DatabaseTwoTone.displayName = 'DatabaseTwoTone';
	var DatabaseTwoTone$1 = /*#__PURE__*/React.forwardRef(DatabaseTwoTone);

	var DeleteColumnOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DeleteColumnOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M651.1 641.9a7.84 7.84 0 00-5.1-1.9h-54.7c-2.4 0-4.6 1.1-6.1 2.9L512 730.7l-73.1-87.8a8.1 8.1 0 00-6.1-2.9H378c-1.9 0-3.7.7-5.1 1.9a7.97 7.97 0 00-1 11.3L474.2 776 371.8 898.9a8.06 8.06 0 006.1 13.2h54.7c2.4 0 4.6-1.1 6.1-2.9l73.1-87.8 73.1 87.8a8.1 8.1 0 006.1 2.9h55c1.9 0 3.7-.7 5.1-1.9 3.4-2.8 3.9-7.9 1-11.3L549.8 776l102.4-122.9c2.8-3.4 2.3-8.4-1.1-11.2zM472 544h80c4.4 0 8-3.6 8-8V120c0-4.4-3.6-8-8-8h-80c-4.4 0-8 3.6-8 8v416c0 4.4 3.6 8 8 8zM350 386H184V136c0-3.3-2.7-6-6-6h-60c-3.3 0-6 2.7-6 6v292c0 16.6 13.4 30 30 30h208c3.3 0 6-2.7 6-6v-60c0-3.3-2.7-6-6-6zm556-256h-60c-3.3 0-6 2.7-6 6v250H674c-3.3 0-6 2.7-6 6v60c0 3.3 2.7 6 6 6h208c16.6 0 30-13.4 30-30V136c0-3.3-2.7-6-6-6z" } }] }, "name": "delete-column", "theme": "outlined" };
	exports.default = DeleteColumnOutlined;
	});

	var DeleteColumnOutlinedSvg = unwrapExports(DeleteColumnOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var DeleteColumnOutlined = function DeleteColumnOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DeleteColumnOutlinedSvg
	  }));
	};

	DeleteColumnOutlined.displayName = 'DeleteColumnOutlined';
	var DeleteColumnOutlined$1 = /*#__PURE__*/React.forwardRef(DeleteColumnOutlined);

	var DeleteFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DeleteFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M864 256H736v-80c0-35.3-28.7-64-64-64H352c-35.3 0-64 28.7-64 64v80H160c-17.7 0-32 14.3-32 32v32c0 4.4 3.6 8 8 8h60.4l24.7 523c1.6 34.1 29.8 61 63.9 61h454c34.2 0 62.3-26.8 63.9-61l24.7-523H888c4.4 0 8-3.6 8-8v-32c0-17.7-14.3-32-32-32zm-200 0H360v-72h304v72z" } }] }, "name": "delete", "theme": "filled" };
	exports.default = DeleteFilled;
	});

	var DeleteFilledSvg = unwrapExports(DeleteFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var DeleteFilled = function DeleteFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DeleteFilledSvg
	  }));
	};

	DeleteFilled.displayName = 'DeleteFilled';
	var DeleteFilled$1 = /*#__PURE__*/React.forwardRef(DeleteFilled);

	var DeleteOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DeleteOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M360 184h-8c4.4 0 8-3.6 8-8v8h304v-8c0 4.4 3.6 8 8 8h-8v72h72v-80c0-35.3-28.7-64-64-64H352c-35.3 0-64 28.7-64 64v80h72v-72zm504 72H160c-17.7 0-32 14.3-32 32v32c0 4.4 3.6 8 8 8h60.4l24.7 523c1.6 34.1 29.8 61 63.9 61h454c34.2 0 62.3-26.8 63.9-61l24.7-523H888c4.4 0 8-3.6 8-8v-32c0-17.7-14.3-32-32-32zM731.3 840H292.7l-24.2-512h487l-24.2 512z" } }] }, "name": "delete", "theme": "outlined" };
	exports.default = DeleteOutlined;
	});

	var DeleteOutlinedSvg = unwrapExports(DeleteOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var DeleteOutlined = function DeleteOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DeleteOutlinedSvg
	  }));
	};

	DeleteOutlined.displayName = 'DeleteOutlined';
	var DeleteOutlined$1 = /*#__PURE__*/React.forwardRef(DeleteOutlined);

	var DeleteRowOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DeleteRowOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M819.8 512l102.4-122.9a8.06 8.06 0 00-6.1-13.2h-54.7c-2.4 0-4.6 1.1-6.1 2.9L782 466.7l-73.1-87.8a8.1 8.1 0 00-6.1-2.9H648c-1.9 0-3.7.7-5.1 1.9a7.97 7.97 0 00-1 11.3L744.2 512 641.8 634.9a8.06 8.06 0 006.1 13.2h54.7c2.4 0 4.6-1.1 6.1-2.9l73.1-87.8 73.1 87.8a8.1 8.1 0 006.1 2.9h55c1.9 0 3.7-.7 5.1-1.9 3.4-2.8 3.9-7.9 1-11.3L819.8 512zM536 464H120c-4.4 0-8 3.6-8 8v80c0 4.4 3.6 8 8 8h416c4.4 0 8-3.6 8-8v-80c0-4.4-3.6-8-8-8zm-84 204h-60c-3.3 0-6 2.7-6 6v166H136c-3.3 0-6 2.7-6 6v60c0 3.3 2.7 6 6 6h292c16.6 0 30-13.4 30-30V674c0-3.3-2.7-6-6-6zM136 184h250v166c0 3.3 2.7 6 6 6h60c3.3 0 6-2.7 6-6V142c0-16.6-13.4-30-30-30H136c-3.3 0-6 2.7-6 6v60c0 3.3 2.7 6 6 6z" } }] }, "name": "delete-row", "theme": "outlined" };
	exports.default = DeleteRowOutlined;
	});

	var DeleteRowOutlinedSvg = unwrapExports(DeleteRowOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var DeleteRowOutlined = function DeleteRowOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DeleteRowOutlinedSvg
	  }));
	};

	DeleteRowOutlined.displayName = 'DeleteRowOutlined';
	var DeleteRowOutlined$1 = /*#__PURE__*/React.forwardRef(DeleteRowOutlined);

	var DeleteTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DeleteTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M292.7 840h438.6l24.2-512h-487z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M864 256H736v-80c0-35.3-28.7-64-64-64H352c-35.3 0-64 28.7-64 64v80H160c-17.7 0-32 14.3-32 32v32c0 4.4 3.6 8 8 8h60.4l24.7 523c1.6 34.1 29.8 61 63.9 61h454c34.2 0 62.3-26.8 63.9-61l24.7-523H888c4.4 0 8-3.6 8-8v-32c0-17.7-14.3-32-32-32zm-504-72h304v72H360v-72zm371.3 656H292.7l-24.2-512h487l-24.2 512z", "fill": primaryColor } }] }; }, "name": "delete", "theme": "twotone" };
	exports.default = DeleteTwoTone;
	});

	var DeleteTwoToneSvg = unwrapExports(DeleteTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var DeleteTwoTone = function DeleteTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DeleteTwoToneSvg
	  }));
	};

	DeleteTwoTone.displayName = 'DeleteTwoTone';
	var DeleteTwoTone$1 = /*#__PURE__*/React.forwardRef(DeleteTwoTone);

	var DeliveredProcedureOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DeliveredProcedureOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M632 698.3l141.9-112a8 8 0 000-12.6L632 461.7c-5.3-4.2-13-.4-13 6.3v76H295c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h324v76c0 6.7 7.8 10.4 13 6.3zm261.3-405L730.7 130.7c-7.5-7.5-16.7-13-26.7-16V112H144c-17.7 0-32 14.3-32 32v278c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V184h136v136c0 17.7 14.3 32 32 32h320c17.7 0 32-14.3 32-32V205.8l136 136V422c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-83.5c0-17-6.7-33.2-18.7-45.2zM640 288H384V184h256v104zm264 436h-56c-4.4 0-8 3.6-8 8v108H184V732c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v148c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V732c0-4.4-3.6-8-8-8z" } }] }, "name": "delivered-procedure", "theme": "outlined" };
	exports.default = DeliveredProcedureOutlined;
	});

	var DeliveredProcedureOutlinedSvg = unwrapExports(DeliveredProcedureOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var DeliveredProcedureOutlined = function DeliveredProcedureOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DeliveredProcedureOutlinedSvg
	  }));
	};

	DeliveredProcedureOutlined.displayName = 'DeliveredProcedureOutlined';
	var DeliveredProcedureOutlined$1 = /*#__PURE__*/React.forwardRef(DeliveredProcedureOutlined);

	var DeploymentUnitOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DeploymentUnitOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M888.3 693.2c-42.5-24.6-94.3-18-129.2 12.8l-53-30.7V523.6c0-15.7-8.4-30.3-22-38.1l-136-78.3v-67.1c44.2-15 76-56.8 76-106.1 0-61.9-50.1-112-112-112s-112 50.1-112 112c0 49.3 31.8 91.1 76 106.1v67.1l-136 78.3c-13.6 7.8-22 22.4-22 38.1v151.6l-53 30.7c-34.9-30.8-86.8-37.4-129.2-12.8-53.5 31-71.7 99.4-41 152.9 30.8 53.5 98.9 71.9 152.2 41 42.5-24.6 62.7-73 53.6-118.8l48.7-28.3 140.6 81c6.8 3.9 14.4 5.9 22 5.9s15.2-2 22-5.9L674.5 740l48.7 28.3c-9.1 45.7 11.2 94.2 53.6 118.8 53.3 30.9 121.5 12.6 152.2-41 30.8-53.6 12.6-122-40.7-152.9zm-673 138.4a47.6 47.6 0 01-65.2-17.6c-13.2-22.9-5.4-52.3 17.5-65.5a47.6 47.6 0 0165.2 17.6c13.2 22.9 5.4 52.3-17.5 65.5zM522 463.8zM464 234a48.01 48.01 0 0196 0 48.01 48.01 0 01-96 0zm170 446.2l-122 70.3-122-70.3V539.8l122-70.3 122 70.3v140.4zm239.9 133.9c-13.2 22.9-42.4 30.8-65.2 17.6-22.8-13.2-30.7-42.6-17.5-65.5s42.4-30.8 65.2-17.6c22.9 13.2 30.7 42.5 17.5 65.5z" } }] }, "name": "deployment-unit", "theme": "outlined" };
	exports.default = DeploymentUnitOutlined;
	});

	var DeploymentUnitOutlinedSvg = unwrapExports(DeploymentUnitOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var DeploymentUnitOutlined = function DeploymentUnitOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DeploymentUnitOutlinedSvg
	  }));
	};

	DeploymentUnitOutlined.displayName = 'DeploymentUnitOutlined';
	var DeploymentUnitOutlined$1 = /*#__PURE__*/React.forwardRef(DeploymentUnitOutlined);

	var DesktopOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DesktopOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M928 140H96c-17.7 0-32 14.3-32 32v496c0 17.7 14.3 32 32 32h380v112H304c-8.8 0-16 7.2-16 16v48c0 4.4 3.6 8 8 8h432c4.4 0 8-3.6 8-8v-48c0-8.8-7.2-16-16-16H548V700h380c17.7 0 32-14.3 32-32V172c0-17.7-14.3-32-32-32zm-40 488H136V212h752v416z" } }] }, "name": "desktop", "theme": "outlined" };
	exports.default = DesktopOutlined;
	});

	var DesktopOutlinedSvg = unwrapExports(DesktopOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var DesktopOutlined = function DesktopOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DesktopOutlinedSvg
	  }));
	};

	DesktopOutlined.displayName = 'DesktopOutlined';
	var DesktopOutlined$1 = /*#__PURE__*/React.forwardRef(DesktopOutlined);

	var DiffFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DiffFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.2 306.6L611.3 72.9c-6-5.7-13.9-8.9-22.2-8.9H296c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h277l219 210.6V824c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V329.6c0-8.7-3.5-17-9.8-23zM553.4 201.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v704c0 17.7 14.3 32 32 32h512c17.7 0 32-14.3 32-32V397.3c0-8.5-3.4-16.6-9.4-22.6L553.4 201.4zM568 753c0 3.8-3.4 7-7.5 7h-225c-4.1 0-7.5-3.2-7.5-7v-42c0-3.8 3.4-7 7.5-7h225c4.1 0 7.5 3.2 7.5 7v42zm0-220c0 3.8-3.4 7-7.5 7H476v84.9c0 3.9-3.1 7.1-7 7.1h-42c-3.8 0-7-3.2-7-7.1V540h-84.5c-4.1 0-7.5-3.2-7.5-7v-42c0-3.9 3.4-7 7.5-7H420v-84.9c0-3.9 3.2-7.1 7-7.1h42c3.9 0 7 3.2 7 7.1V484h84.5c4.1 0 7.5 3.1 7.5 7v42z" } }] }, "name": "diff", "theme": "filled" };
	exports.default = DiffFilled;
	});

	var DiffFilledSvg = unwrapExports(DiffFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var DiffFilled = function DiffFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DiffFilledSvg
	  }));
	};

	DiffFilled.displayName = 'DiffFilled';
	var DiffFilled$1 = /*#__PURE__*/React.forwardRef(DiffFilled);

	var DiffOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DiffOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M476 399.1c0-3.9-3.1-7.1-7-7.1h-42c-3.8 0-7 3.2-7 7.1V484h-84.5c-4.1 0-7.5 3.1-7.5 7v42c0 3.8 3.4 7 7.5 7H420v84.9c0 3.9 3.2 7.1 7 7.1h42c3.9 0 7-3.2 7-7.1V540h84.5c4.1 0 7.5-3.2 7.5-7v-42c0-3.9-3.4-7-7.5-7H476v-84.9zM560.5 704h-225c-4.1 0-7.5 3.2-7.5 7v42c0 3.8 3.4 7 7.5 7h225c4.1 0 7.5-3.2 7.5-7v-42c0-3.8-3.4-7-7.5-7zm-7.1-502.6c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v704c0 17.7 14.3 32 32 32h512c17.7 0 32-14.3 32-32V397.3c0-8.5-3.4-16.6-9.4-22.6L553.4 201.4zM664 888H232V264h282.2L664 413.8V888zm190.2-581.4L611.3 72.9c-6-5.7-13.9-8.9-22.2-8.9H296c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h277l219 210.6V824c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V329.6c0-8.7-3.5-17-9.8-23z" } }] }, "name": "diff", "theme": "outlined" };
	exports.default = DiffOutlined;
	});

	var DiffOutlinedSvg = unwrapExports(DiffOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var DiffOutlined = function DiffOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DiffOutlinedSvg
	  }));
	};

	DiffOutlined.displayName = 'DiffOutlined';
	var DiffOutlined$1 = /*#__PURE__*/React.forwardRef(DiffOutlined);

	var DiffTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DiffTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M232 264v624h432V413.8L514.2 264H232zm336 489c0 3.8-3.4 7-7.5 7h-225c-4.1 0-7.5-3.2-7.5-7v-42c0-3.8 3.4-7 7.5-7h225c4.1 0 7.5 3.2 7.5 7v42zm0-262v42c0 3.8-3.4 7-7.5 7H476v84.9c0 3.9-3.1 7.1-7 7.1h-42c-3.8 0-7-3.2-7-7.1V540h-84.5c-4.1 0-7.5-3.2-7.5-7v-42c0-3.9 3.4-7 7.5-7H420v-84.9c0-3.9 3.2-7.1 7-7.1h42c3.9 0 7 3.2 7 7.1V484h84.5c4.1 0 7.5 3.1 7.5 7z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M854.2 306.6L611.3 72.9c-6-5.7-13.9-8.9-22.2-8.9H296c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h277l219 210.6V824c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V329.6c0-8.7-3.5-17-9.8-23z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M553.4 201.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v704c0 17.7 14.3 32 32 32h512c17.7 0 32-14.3 32-32V397.3c0-8.5-3.4-16.6-9.4-22.6L553.4 201.4zM664 888H232V264h282.2L664 413.8V888z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M476 399.1c0-3.9-3.1-7.1-7-7.1h-42c-3.8 0-7 3.2-7 7.1V484h-84.5c-4.1 0-7.5 3.1-7.5 7v42c0 3.8 3.4 7 7.5 7H420v84.9c0 3.9 3.2 7.1 7 7.1h42c3.9 0 7-3.2 7-7.1V540h84.5c4.1 0 7.5-3.2 7.5-7v-42c0-3.9-3.4-7-7.5-7H476v-84.9zM560.5 704h-225c-4.1 0-7.5 3.2-7.5 7v42c0 3.8 3.4 7 7.5 7h225c4.1 0 7.5-3.2 7.5-7v-42c0-3.8-3.4-7-7.5-7z", "fill": primaryColor } }] }; }, "name": "diff", "theme": "twotone" };
	exports.default = DiffTwoTone;
	});

	var DiffTwoToneSvg = unwrapExports(DiffTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var DiffTwoTone = function DiffTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DiffTwoToneSvg
	  }));
	};

	DiffTwoTone.displayName = 'DiffTwoTone';
	var DiffTwoTone$1 = /*#__PURE__*/React.forwardRef(DiffTwoTone);

	var DingdingOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DingdingOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M573.7 252.5C422.5 197.4 201.3 96.7 201.3 96.7c-15.7-4.1-17.9 11.1-17.9 11.1-5 61.1 33.6 160.5 53.6 182.8 19.9 22.3 319.1 113.7 319.1 113.7S326 357.9 270.5 341.9c-55.6-16-37.9 17.8-37.9 17.8 11.4 61.7 64.9 131.8 107.2 138.4 42.2 6.6 220.1 4 220.1 4s-35.5 4.1-93.2 11.9c-42.7 5.8-97 12.5-111.1 17.8-33.1 12.5 24 62.6 24 62.6 84.7 76.8 129.7 50.5 129.7 50.5 33.3-10.7 61.4-18.5 85.2-24.2L565 743.1h84.6L603 928l205.3-271.9H700.8l22.3-38.7c.3.5.4.8.4.8S799.8 496.1 829 433.8l.6-1h-.1c5-10.8 8.6-19.7 10-25.8 17-71.3-114.5-99.4-265.8-154.5z" } }] }, "name": "dingding", "theme": "outlined" };
	exports.default = DingdingOutlined;
	});

	var DingdingOutlinedSvg = unwrapExports(DingdingOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var DingdingOutlined = function DingdingOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DingdingOutlinedSvg
	  }));
	};

	DingdingOutlined.displayName = 'DingdingOutlined';
	var DingdingOutlined$1 = /*#__PURE__*/React.forwardRef(DingdingOutlined);

	var DingtalkCircleFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DingtalkCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm227 385.3c-1 4.2-3.5 10.4-7 17.8h.1l-.4.7c-20.3 43.1-73.1 127.7-73.1 127.7s-.1-.2-.3-.5l-15.5 26.8h74.5L575.1 810l32.3-128h-58.6l20.4-84.7c-16.5 3.9-35.9 9.4-59 16.8 0 0-31.2 18.2-89.9-35 0 0-39.6-34.7-16.6-43.4 9.8-3.7 47.4-8.4 77-12.3 40-5.4 64.6-8.2 64.6-8.2S422 517 392.7 512.5c-29.3-4.6-66.4-53.1-74.3-95.8 0 0-12.2-23.4 26.3-12.3 38.5 11.1 197.9 43.2 197.9 43.2s-207.4-63.3-221.2-78.7c-13.8-15.4-40.6-84.2-37.1-126.5 0 0 1.5-10.5 12.4-7.7 0 0 153.3 69.7 258.1 107.9 104.8 37.9 195.9 57.3 184.2 106.7z" } }] }, "name": "dingtalk-circle", "theme": "filled" };
	exports.default = DingtalkCircleFilled;
	});

	var DingtalkCircleFilledSvg = unwrapExports(DingtalkCircleFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var DingtalkCircleFilled = function DingtalkCircleFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DingtalkCircleFilledSvg
	  }));
	};

	DingtalkCircleFilled.displayName = 'DingtalkCircleFilled';
	var DingtalkCircleFilled$1 = /*#__PURE__*/React.forwardRef(DingtalkCircleFilled);

	var DingtalkOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DingtalkOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M573.7 252.5C422.5 197.4 201.3 96.7 201.3 96.7c-15.7-4.1-17.9 11.1-17.9 11.1-5 61.1 33.6 160.5 53.6 182.8 19.9 22.3 319.1 113.7 319.1 113.7S326 357.9 270.5 341.9c-55.6-16-37.9 17.8-37.9 17.8 11.4 61.7 64.9 131.8 107.2 138.4 42.2 6.6 220.1 4 220.1 4s-35.5 4.1-93.2 11.9c-42.7 5.8-97 12.5-111.1 17.8-33.1 12.5 24 62.6 24 62.6 84.7 76.8 129.7 50.5 129.7 50.5 33.3-10.7 61.4-18.5 85.2-24.2L565 743.1h84.6L603 928l205.3-271.9H700.8l22.3-38.7c.3.5.4.8.4.8S799.8 496.1 829 433.8l.6-1h-.1c5-10.8 8.6-19.7 10-25.8 17-71.3-114.5-99.4-265.8-154.5z" } }] }, "name": "dingtalk", "theme": "outlined" };
	exports.default = DingtalkOutlined;
	});

	var DingtalkOutlinedSvg = unwrapExports(DingtalkOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var DingtalkOutlined = function DingtalkOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DingtalkOutlinedSvg
	  }));
	};

	DingtalkOutlined.displayName = 'DingtalkOutlined';
	var DingtalkOutlined$1 = /*#__PURE__*/React.forwardRef(DingtalkOutlined);

	var DingtalkSquareFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DingtalkSquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM739 449.3c-1 4.2-3.5 10.4-7 17.8h.1l-.4.7c-20.3 43.1-73.1 127.7-73.1 127.7s-.1-.2-.3-.5l-15.5 26.8h74.5L575.1 810l32.3-128h-58.6l20.4-84.7c-16.5 3.9-35.9 9.4-59 16.8 0 0-31.2 18.2-89.9-35 0 0-39.6-34.7-16.6-43.4 9.8-3.7 47.4-8.4 77-12.3 40-5.4 64.6-8.2 64.6-8.2S422 517 392.7 512.5c-29.3-4.6-66.4-53.1-74.3-95.8 0 0-12.2-23.4 26.3-12.3 38.5 11.1 197.9 43.2 197.9 43.2s-207.4-63.3-221.2-78.7c-13.8-15.4-40.6-84.2-37.1-126.5 0 0 1.5-10.5 12.4-7.7 0 0 153.3 69.7 258.1 107.9 104.8 37.9 195.9 57.3 184.2 106.7z" } }] }, "name": "dingtalk-square", "theme": "filled" };
	exports.default = DingtalkSquareFilled;
	});

	var DingtalkSquareFilledSvg = unwrapExports(DingtalkSquareFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var DingtalkSquareFilled = function DingtalkSquareFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DingtalkSquareFilledSvg
	  }));
	};

	DingtalkSquareFilled.displayName = 'DingtalkSquareFilled';
	var DingtalkSquareFilled$1 = /*#__PURE__*/React.forwardRef(DingtalkSquareFilled);

	var DisconnectOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DisconnectOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M832.6 191.4c-84.6-84.6-221.5-84.6-306 0l-96.9 96.9 51 51 96.9-96.9c53.8-53.8 144.6-59.5 204 0 59.5 59.5 53.8 150.2 0 204l-96.9 96.9 51.1 51.1 96.9-96.9c84.4-84.6 84.4-221.5-.1-306.1zM446.5 781.6c-53.8 53.8-144.6 59.5-204 0-59.5-59.5-53.8-150.2 0-204l96.9-96.9-51.1-51.1-96.9 96.9c-84.6 84.6-84.6 221.5 0 306s221.5 84.6 306 0l96.9-96.9-51-51-96.8 97zM260.3 209.4a8.03 8.03 0 00-11.3 0L209.4 249a8.03 8.03 0 000 11.3l554.4 554.4c3.1 3.1 8.2 3.1 11.3 0l39.6-39.6c3.1-3.1 3.1-8.2 0-11.3L260.3 209.4z" } }] }, "name": "disconnect", "theme": "outlined" };
	exports.default = DisconnectOutlined;
	});

	var DisconnectOutlinedSvg = unwrapExports(DisconnectOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var DisconnectOutlined = function DisconnectOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DisconnectOutlinedSvg
	  }));
	};

	DisconnectOutlined.displayName = 'DisconnectOutlined';
	var DisconnectOutlined$1 = /*#__PURE__*/React.forwardRef(DisconnectOutlined);

	var DislikeFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DislikeFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M885.9 490.3c3.6-12 5.4-24.4 5.4-37 0-28.3-9.3-55.5-26.1-77.7 3.6-12 5.4-24.4 5.4-37 0-28.3-9.3-55.5-26.1-77.7 3.6-12 5.4-24.4 5.4-37 0-51.6-30.7-98.1-78.3-118.4a66.1 66.1 0 00-26.5-5.4H273v428h.3l85.8 310.8C372.9 889 418.9 924 470.9 924c29.7 0 57.4-11.8 77.9-33.4 20.5-21.5 31-49.7 29.5-79.4l-6-122.9h239.9c12.1 0 23.9-3.2 34.3-9.3 40.4-23.5 65.5-66.1 65.5-111 0-28.3-9.3-55.5-26.1-77.7zM112 132v364c0 17.7 14.3 32 32 32h65V100h-65c-17.7 0-32 14.3-32 32z" } }] }, "name": "dislike", "theme": "filled" };
	exports.default = DislikeFilled;
	});

	var DislikeFilledSvg = unwrapExports(DislikeFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var DislikeFilled = function DislikeFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DislikeFilledSvg
	  }));
	};

	DislikeFilled.displayName = 'DislikeFilled';
	var DislikeFilled$1 = /*#__PURE__*/React.forwardRef(DislikeFilled);

	var DislikeOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DislikeOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M885.9 490.3c3.6-12 5.4-24.4 5.4-37 0-28.3-9.3-55.5-26.1-77.7 3.6-12 5.4-24.4 5.4-37 0-28.3-9.3-55.5-26.1-77.7 3.6-12 5.4-24.4 5.4-37 0-51.6-30.7-98.1-78.3-118.4a66.1 66.1 0 00-26.5-5.4H144c-17.7 0-32 14.3-32 32v364c0 17.7 14.3 32 32 32h129.3l85.8 310.8C372.9 889 418.9 924 470.9 924c29.7 0 57.4-11.8 77.9-33.4 20.5-21.5 31-49.7 29.5-79.4l-6-122.9h239.9c12.1 0 23.9-3.2 34.3-9.3 40.4-23.5 65.5-66.1 65.5-111 0-28.3-9.3-55.5-26.1-77.7zM184 456V172h81v284h-81zm627.2 160.4H496.8l9.6 198.4c.6 11.9-4.7 23.1-14.6 30.5-6.1 4.5-13.6 6.8-21.1 6.7a44.28 44.28 0 01-42.2-32.3L329 459.2V172h415.4a56.85 56.85 0 0133.6 51.8c0 9.7-2.3 18.9-6.9 27.3l-13.9 25.4 21.9 19a56.76 56.76 0 0119.6 43c0 9.7-2.3 18.9-6.9 27.3l-13.9 25.4 21.9 19a56.76 56.76 0 0119.6 43c0 9.7-2.3 18.9-6.9 27.3l-14 25.5 21.9 19a56.76 56.76 0 0119.6 43c0 19.1-11 37.5-28.8 48.4z" } }] }, "name": "dislike", "theme": "outlined" };
	exports.default = DislikeOutlined;
	});

	var DislikeOutlinedSvg = unwrapExports(DislikeOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var DislikeOutlined = function DislikeOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DislikeOutlinedSvg
	  }));
	};

	DislikeOutlined.displayName = 'DislikeOutlined';
	var DislikeOutlined$1 = /*#__PURE__*/React.forwardRef(DislikeOutlined);

	var DislikeTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DislikeTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M273 100.1v428h.3l-.3-428zM820.4 525l-21.9-19 14-25.5a56.2 56.2 0 006.9-27.3c0-16.5-7.1-32.2-19.6-43l-21.9-19 13.9-25.4a56.2 56.2 0 006.9-27.3c0-16.5-7.1-32.2-19.6-43l-21.9-19 13.9-25.4a56.2 56.2 0 006.9-27.3c0-22.4-13.2-42.6-33.6-51.8H345v345.2c18.6 67.2 46.4 168 83.5 302.5a44.28 44.28 0 0042.2 32.3c7.5.1 15-2.2 21.1-6.7 9.9-7.4 15.2-18.6 14.6-30.5l-9.6-198.4h314.4C829 605.5 840 587.1 840 568c0-16.5-7.1-32.2-19.6-43z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M112 132v364c0 17.7 14.3 32 32 32h65V100h-65c-17.7 0-32 14.3-32 32zm773.9 358.3c3.6-12 5.4-24.4 5.4-37 0-28.3-9.3-55.5-26.1-77.7 3.6-12 5.4-24.4 5.4-37 0-28.3-9.3-55.5-26.1-77.7 3.6-12 5.4-24.4 5.4-37 0-51.6-30.7-98.1-78.3-118.4a66.1 66.1 0 00-26.5-5.4H273l.3 428 85.8 310.8C372.9 889 418.9 924 470.9 924c29.7 0 57.4-11.8 77.9-33.4 20.5-21.5 31-49.7 29.5-79.4l-6-122.9h239.9c12.1 0 23.9-3.2 34.3-9.3 40.4-23.5 65.5-66.1 65.5-111 0-28.3-9.3-55.5-26.1-77.7zm-74.7 126.1H496.8l9.6 198.4c.6 11.9-4.7 23.1-14.6 30.5-6.1 4.5-13.6 6.8-21.1 6.7a44.28 44.28 0 01-42.2-32.3c-37.1-134.4-64.9-235.2-83.5-302.5V172h399.4a56.85 56.85 0 0133.6 51.8c0 9.7-2.3 18.9-6.9 27.3l-13.9 25.4 21.9 19a56.76 56.76 0 0119.6 43c0 9.7-2.3 18.9-6.9 27.3l-13.9 25.4 21.9 19a56.76 56.76 0 0119.6 43c0 9.7-2.3 18.9-6.9 27.3l-14 25.5 21.9 19a56.76 56.76 0 0119.6 43c0 19.1-11 37.5-28.8 48.4z", "fill": primaryColor } }] }; }, "name": "dislike", "theme": "twotone" };
	exports.default = DislikeTwoTone;
	});

	var DislikeTwoToneSvg = unwrapExports(DislikeTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var DislikeTwoTone = function DislikeTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DislikeTwoToneSvg
	  }));
	};

	DislikeTwoTone.displayName = 'DislikeTwoTone';
	var DislikeTwoTone$1 = /*#__PURE__*/React.forwardRef(DislikeTwoTone);

	var DollarCircleFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DollarCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm22.3 665.2l.2 31.7c0 4.4-3.6 8.1-8 8.1h-28.4c-4.4 0-8-3.6-8-8v-31.4C401.3 723 359.5 672.4 355 617.4c-.4-4.7 3.3-8.7 8-8.7h46.2c3.9 0 7.3 2.8 7.9 6.6 5.1 31.7 29.8 55.4 74.1 61.3V533.9l-24.7-6.3c-52.3-12.5-102.1-45.1-102.1-112.7 0-72.9 55.4-112.1 126.2-119v-33c0-4.4 3.6-8 8-8h28.1c4.4 0 8 3.6 8 8v32.7c68.5 6.9 119.9 46.9 125.9 109.2.5 4.7-3.2 8.8-8 8.8h-44.9c-4 0-7.4-3-7.9-6.9-4-29.2-27.4-53-65.5-58.2v134.3l25.4 5.9c64.8 16 108.9 47 108.9 116.4 0 75.3-56 117.3-134.3 124.1zM426.6 410.3c0 25.4 15.7 45.1 49.5 57.3 4.7 1.9 9.4 3.4 15 5v-124c-36.9 4.7-64.5 25.4-64.5 61.7zm116.5 135.2c-2.8-.6-5.6-1.3-8.8-2.2V677c42.6-3.8 72-27.2 72-66.4 0-30.7-15.9-50.7-63.2-65.1z" } }] }, "name": "dollar-circle", "theme": "filled" };
	exports.default = DollarCircleFilled;
	});

	var DollarCircleFilledSvg = unwrapExports(DollarCircleFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var DollarCircleFilled = function DollarCircleFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DollarCircleFilledSvg
	  }));
	};

	DollarCircleFilled.displayName = 'DollarCircleFilled';
	var DollarCircleFilled$1 = /*#__PURE__*/React.forwardRef(DollarCircleFilled);

	var DollarCircleOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DollarCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372zm47.7-395.2l-25.4-5.9V348.6c38 5.2 61.5 29 65.5 58.2.5 4 3.9 6.9 7.9 6.9h44.9c4.7 0 8.4-4.1 8-8.8-6.1-62.3-57.4-102.3-125.9-109.2V263c0-4.4-3.6-8-8-8h-28.1c-4.4 0-8 3.6-8 8v33c-70.8 6.9-126.2 46-126.2 119 0 67.6 49.8 100.2 102.1 112.7l24.7 6.3v142.7c-44.2-5.9-69-29.5-74.1-61.3-.6-3.8-4-6.6-7.9-6.6H363c-4.7 0-8.4 4-8 8.7 4.5 55 46.2 105.6 135.2 112.1V761c0 4.4 3.6 8 8 8h28.4c4.4 0 8-3.6 8-8.1l-.2-31.7c78.3-6.9 134.3-48.8 134.3-124-.1-69.4-44.2-100.4-109-116.4zm-68.6-16.2c-5.6-1.6-10.3-3.1-15-5-33.8-12.2-49.5-31.9-49.5-57.3 0-36.3 27.5-57 64.5-61.7v124zM534.3 677V543.3c3.1.9 5.9 1.6 8.8 2.2 47.3 14.4 63.2 34.4 63.2 65.1 0 39.1-29.4 62.6-72 66.4z" } }] }, "name": "dollar-circle", "theme": "outlined" };
	exports.default = DollarCircleOutlined;
	});

	var DollarCircleOutlinedSvg = unwrapExports(DollarCircleOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var DollarCircleOutlined = function DollarCircleOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DollarCircleOutlinedSvg
	  }));
	};

	DollarCircleOutlined.displayName = 'DollarCircleOutlined';
	var DollarCircleOutlined$1 = /*#__PURE__*/React.forwardRef(DollarCircleOutlined);

	var DollarCircleTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DollarCircleTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M426.6 410.3c0 25.4 15.7 45.1 49.5 57.3 4.7 1.9 9.4 3.4 15 5v-124c-37 4.7-64.5 25.4-64.5 61.7zm116.5 135.2c-2.9-.6-5.7-1.3-8.8-2.2V677c42.6-3.8 72-27.3 72-66.4 0-30.7-15.9-50.7-63.2-65.1z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm22.4 589.2l.2 31.7c0 4.5-3.6 8.1-8 8.1h-28.4c-4.4 0-8-3.6-8-8v-31.4c-89-6.5-130.7-57.1-135.2-112.1-.4-4.7 3.3-8.7 8-8.7h46.2c3.9 0 7.3 2.8 7.9 6.6 5.1 31.8 29.9 55.4 74.1 61.3V534l-24.7-6.3c-52.3-12.5-102.1-45.1-102.1-112.7 0-73 55.4-112.1 126.2-119v-33c0-4.4 3.6-8 8-8h28.1c4.4 0 8 3.6 8 8v32.7c68.5 6.9 119.8 46.9 125.9 109.2a8.1 8.1 0 01-8 8.8h-44.9c-4 0-7.4-2.9-7.9-6.9-4-29.2-27.5-53-65.5-58.2v134.3l25.4 5.9c64.8 16 108.9 47 109 116.4 0 75.2-56 117.1-134.3 124z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M559.7 488.8l-25.4-5.9V348.6c38 5.2 61.5 29 65.5 58.2.5 4 3.9 6.9 7.9 6.9h44.9c4.7 0 8.4-4.1 8-8.8-6.1-62.3-57.4-102.3-125.9-109.2V263c0-4.4-3.6-8-8-8h-28.1c-4.4 0-8 3.6-8 8v33c-70.8 6.9-126.2 46-126.2 119 0 67.6 49.8 100.2 102.1 112.7l24.7 6.3v142.7c-44.2-5.9-69-29.5-74.1-61.3-.6-3.8-4-6.6-7.9-6.6H363c-4.7 0-8.4 4-8 8.7 4.5 55 46.2 105.6 135.2 112.1V761c0 4.4 3.6 8 8 8h28.4c4.4 0 8-3.6 8-8.1l-.2-31.7c78.3-6.9 134.3-48.8 134.3-124-.1-69.4-44.2-100.4-109-116.4zm-68.6-16.2c-5.6-1.6-10.3-3.1-15-5-33.8-12.2-49.5-31.9-49.5-57.3 0-36.3 27.5-57 64.5-61.7v124zM534.3 677V543.3c3.1.9 5.9 1.6 8.8 2.2 47.3 14.4 63.2 34.4 63.2 65.1 0 39.1-29.4 62.6-72 66.4z", "fill": primaryColor } }] }; }, "name": "dollar-circle", "theme": "twotone" };
	exports.default = DollarCircleTwoTone;
	});

	var DollarCircleTwoToneSvg = unwrapExports(DollarCircleTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var DollarCircleTwoTone = function DollarCircleTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DollarCircleTwoToneSvg
	  }));
	};

	DollarCircleTwoTone.displayName = 'DollarCircleTwoTone';
	var DollarCircleTwoTone$1 = /*#__PURE__*/React.forwardRef(DollarCircleTwoTone);

	var DollarOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DollarOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372zm47.7-395.2l-25.4-5.9V348.6c38 5.2 61.5 29 65.5 58.2.5 4 3.9 6.9 7.9 6.9h44.9c4.7 0 8.4-4.1 8-8.8-6.1-62.3-57.4-102.3-125.9-109.2V263c0-4.4-3.6-8-8-8h-28.1c-4.4 0-8 3.6-8 8v33c-70.8 6.9-126.2 46-126.2 119 0 67.6 49.8 100.2 102.1 112.7l24.7 6.3v142.7c-44.2-5.9-69-29.5-74.1-61.3-.6-3.8-4-6.6-7.9-6.6H363c-4.7 0-8.4 4-8 8.7 4.5 55 46.2 105.6 135.2 112.1V761c0 4.4 3.6 8 8 8h28.4c4.4 0 8-3.6 8-8.1l-.2-31.7c78.3-6.9 134.3-48.8 134.3-124-.1-69.4-44.2-100.4-109-116.4zm-68.6-16.2c-5.6-1.6-10.3-3.1-15-5-33.8-12.2-49.5-31.9-49.5-57.3 0-36.3 27.5-57 64.5-61.7v124zM534.3 677V543.3c3.1.9 5.9 1.6 8.8 2.2 47.3 14.4 63.2 34.4 63.2 65.1 0 39.1-29.4 62.6-72 66.4z" } }] }, "name": "dollar", "theme": "outlined" };
	exports.default = DollarOutlined;
	});

	var DollarOutlinedSvg = unwrapExports(DollarOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var DollarOutlined = function DollarOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DollarOutlinedSvg
	  }));
	};

	DollarOutlined.displayName = 'DollarOutlined';
	var DollarOutlined$1 = /*#__PURE__*/React.forwardRef(DollarOutlined);

	var DollarTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DollarTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M426.6 410.3c0 25.4 15.7 45.1 49.5 57.3 4.7 1.9 9.4 3.4 15 5v-124c-37 4.7-64.5 25.4-64.5 61.7zm116.5 135.2c-2.9-.6-5.7-1.3-8.8-2.2V677c42.6-3.8 72-27.3 72-66.4 0-30.7-15.9-50.7-63.2-65.1z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm22.4 589.2l.2 31.7c0 4.5-3.6 8.1-8 8.1h-28.4c-4.4 0-8-3.6-8-8v-31.4c-89-6.5-130.7-57.1-135.2-112.1-.4-4.7 3.3-8.7 8-8.7h46.2c3.9 0 7.3 2.8 7.9 6.6 5.1 31.8 29.9 55.4 74.1 61.3V534l-24.7-6.3c-52.3-12.5-102.1-45.1-102.1-112.7 0-73 55.4-112.1 126.2-119v-33c0-4.4 3.6-8 8-8h28.1c4.4 0 8 3.6 8 8v32.7c68.5 6.9 119.8 46.9 125.9 109.2a8.1 8.1 0 01-8 8.8h-44.9c-4 0-7.4-2.9-7.9-6.9-4-29.2-27.5-53-65.5-58.2v134.3l25.4 5.9c64.8 16 108.9 47 109 116.4 0 75.2-56 117.1-134.3 124z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M559.7 488.8l-25.4-5.9V348.6c38 5.2 61.5 29 65.5 58.2.5 4 3.9 6.9 7.9 6.9h44.9c4.7 0 8.4-4.1 8-8.8-6.1-62.3-57.4-102.3-125.9-109.2V263c0-4.4-3.6-8-8-8h-28.1c-4.4 0-8 3.6-8 8v33c-70.8 6.9-126.2 46-126.2 119 0 67.6 49.8 100.2 102.1 112.7l24.7 6.3v142.7c-44.2-5.9-69-29.5-74.1-61.3-.6-3.8-4-6.6-7.9-6.6H363c-4.7 0-8.4 4-8 8.7 4.5 55 46.2 105.6 135.2 112.1V761c0 4.4 3.6 8 8 8h28.4c4.4 0 8-3.6 8-8.1l-.2-31.7c78.3-6.9 134.3-48.8 134.3-124-.1-69.4-44.2-100.4-109-116.4zm-68.6-16.2c-5.6-1.6-10.3-3.1-15-5-33.8-12.2-49.5-31.9-49.5-57.3 0-36.3 27.5-57 64.5-61.7v124zM534.3 677V543.3c3.1.9 5.9 1.6 8.8 2.2 47.3 14.4 63.2 34.4 63.2 65.1 0 39.1-29.4 62.6-72 66.4z", "fill": primaryColor } }] }; }, "name": "dollar", "theme": "twotone" };
	exports.default = DollarTwoTone;
	});

	var DollarTwoToneSvg = unwrapExports(DollarTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var DollarTwoTone = function DollarTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DollarTwoToneSvg
	  }));
	};

	DollarTwoTone.displayName = 'DollarTwoTone';
	var DollarTwoTone$1 = /*#__PURE__*/React.forwardRef(DollarTwoTone);

	var DotChartOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DotChartOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M888 792H200V168c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v688c0 4.4 3.6 8 8 8h752c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM288 604a64 64 0 10128 0 64 64 0 10-128 0zm118-224a48 48 0 1096 0 48 48 0 10-96 0zm158 228a96 96 0 10192 0 96 96 0 10-192 0zm148-314a56 56 0 10112 0 56 56 0 10-112 0z" } }] }, "name": "dot-chart", "theme": "outlined" };
	exports.default = DotChartOutlined;
	});

	var DotChartOutlinedSvg = unwrapExports(DotChartOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var DotChartOutlined = function DotChartOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DotChartOutlinedSvg
	  }));
	};

	DotChartOutlined.displayName = 'DotChartOutlined';
	var DotChartOutlined$1 = /*#__PURE__*/React.forwardRef(DotChartOutlined);

	var DoubleLeftOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DoubleLeftOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M272.9 512l265.4-339.1c4.1-5.2.4-12.9-6.3-12.9h-77.3c-4.9 0-9.6 2.3-12.6 6.1L186.8 492.3a31.99 31.99 0 000 39.5l255.3 326.1c3 3.9 7.7 6.1 12.6 6.1H532c6.7 0 10.4-7.7 6.3-12.9L272.9 512zm304 0l265.4-339.1c4.1-5.2.4-12.9-6.3-12.9h-77.3c-4.9 0-9.6 2.3-12.6 6.1L490.8 492.3a31.99 31.99 0 000 39.5l255.3 326.1c3 3.9 7.7 6.1 12.6 6.1H836c6.7 0 10.4-7.7 6.3-12.9L576.9 512z" } }] }, "name": "double-left", "theme": "outlined" };
	exports.default = DoubleLeftOutlined;
	});

	var DoubleLeftOutlinedSvg = unwrapExports(DoubleLeftOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var DoubleLeftOutlined = function DoubleLeftOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DoubleLeftOutlinedSvg
	  }));
	};

	DoubleLeftOutlined.displayName = 'DoubleLeftOutlined';
	var DoubleLeftOutlined$1 = /*#__PURE__*/React.forwardRef(DoubleLeftOutlined);

	var DoubleRightOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DoubleRightOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M533.2 492.3L277.9 166.1c-3-3.9-7.7-6.1-12.6-6.1H188c-6.7 0-10.4 7.7-6.3 12.9L447.1 512 181.7 851.1A7.98 7.98 0 00188 864h77.3c4.9 0 9.6-2.3 12.6-6.1l255.3-326.1c9.1-11.7 9.1-27.9 0-39.5zm304 0L581.9 166.1c-3-3.9-7.7-6.1-12.6-6.1H492c-6.7 0-10.4 7.7-6.3 12.9L751.1 512 485.7 851.1A7.98 7.98 0 00492 864h77.3c4.9 0 9.6-2.3 12.6-6.1l255.3-326.1c9.1-11.7 9.1-27.9 0-39.5z" } }] }, "name": "double-right", "theme": "outlined" };
	exports.default = DoubleRightOutlined;
	});

	var DoubleRightOutlinedSvg = unwrapExports(DoubleRightOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var DoubleRightOutlined = function DoubleRightOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DoubleRightOutlinedSvg
	  }));
	};

	DoubleRightOutlined.displayName = 'DoubleRightOutlined';
	var DoubleRightOutlined$1 = /*#__PURE__*/React.forwardRef(DoubleRightOutlined);

	var DownCircleFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DownCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm184.5 353.7l-178 246a7.95 7.95 0 01-12.9 0l-178-246c-3.8-5.3 0-12.7 6.5-12.7H381c10.2 0 19.9 4.9 25.9 13.2L512 563.6l105.2-145.4c6-8.3 15.6-13.2 25.9-13.2H690c6.5 0 10.3 7.4 6.5 12.7z" } }] }, "name": "down-circle", "theme": "filled" };
	exports.default = DownCircleFilled;
	});

	var DownCircleFilledSvg = unwrapExports(DownCircleFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var DownCircleFilled = function DownCircleFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DownCircleFilledSvg
	  }));
	};

	DownCircleFilled.displayName = 'DownCircleFilled';
	var DownCircleFilled$1 = /*#__PURE__*/React.forwardRef(DownCircleFilled);

	var DownCircleOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DownCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M690 405h-46.9c-10.2 0-19.9 4.9-25.9 13.2L512 563.6 406.8 418.2c-6-8.3-15.6-13.2-25.9-13.2H334c-6.5 0-10.3 7.4-6.5 12.7l178 246c3.2 4.4 9.7 4.4 12.9 0l178-246c3.9-5.3.1-12.7-6.4-12.7z" } }, { "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z" } }] }, "name": "down-circle", "theme": "outlined" };
	exports.default = DownCircleOutlined;
	});

	var DownCircleOutlinedSvg = unwrapExports(DownCircleOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var DownCircleOutlined = function DownCircleOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DownCircleOutlinedSvg
	  }));
	};

	DownCircleOutlined.displayName = 'DownCircleOutlined';
	var DownCircleOutlined$1 = /*#__PURE__*/React.forwardRef(DownCircleOutlined);

	var DownCircleTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DownCircleTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm184.4 277.7l-178 246a7.95 7.95 0 01-12.9 0l-178-246c-3.8-5.3 0-12.7 6.5-12.7h46.9c10.3 0 19.9 4.9 25.9 13.2L512 563.6l105.2-145.4c6-8.3 15.7-13.2 25.9-13.2H690c6.5 0 10.3 7.4 6.4 12.7z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M690 405h-46.9c-10.2 0-19.9 4.9-25.9 13.2L512 563.6 406.8 418.2c-6-8.3-15.6-13.2-25.9-13.2H334c-6.5 0-10.3 7.4-6.5 12.7l178 246c3.2 4.4 9.7 4.4 12.9 0l178-246c3.9-5.3.1-12.7-6.4-12.7z", "fill": primaryColor } }] }; }, "name": "down-circle", "theme": "twotone" };
	exports.default = DownCircleTwoTone;
	});

	var DownCircleTwoToneSvg = unwrapExports(DownCircleTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var DownCircleTwoTone = function DownCircleTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DownCircleTwoToneSvg
	  }));
	};

	DownCircleTwoTone.displayName = 'DownCircleTwoTone';
	var DownCircleTwoTone$1 = /*#__PURE__*/React.forwardRef(DownCircleTwoTone);

	var DownOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DownOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M884 256h-75c-5.1 0-9.9 2.5-12.9 6.6L512 654.2 227.9 262.6c-3-4.1-7.8-6.6-12.9-6.6h-75c-6.5 0-10.3 7.4-6.5 12.7l352.6 486.1c12.8 17.6 39 17.6 51.7 0l352.6-486.1c3.9-5.3.1-12.7-6.4-12.7z" } }] }, "name": "down", "theme": "outlined" };
	exports.default = DownOutlined;
	});

	var DownOutlinedSvg = unwrapExports(DownOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var DownOutlined = function DownOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DownOutlinedSvg
	  }));
	};

	DownOutlined.displayName = 'DownOutlined';
	var DownOutlined$1 = /*#__PURE__*/React.forwardRef(DownOutlined);

	var DownSquareFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DownSquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM696.5 412.7l-178 246a7.95 7.95 0 01-12.9 0l-178-246c-3.8-5.3 0-12.7 6.5-12.7H381c10.2 0 19.9 4.9 25.9 13.2L512 558.6l105.2-145.4c6-8.3 15.6-13.2 25.9-13.2H690c6.5 0 10.3 7.4 6.5 12.7z" } }] }, "name": "down-square", "theme": "filled" };
	exports.default = DownSquareFilled;
	});

	var DownSquareFilledSvg = unwrapExports(DownSquareFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var DownSquareFilled = function DownSquareFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DownSquareFilledSvg
	  }));
	};

	DownSquareFilled.displayName = 'DownSquareFilled';
	var DownSquareFilled$1 = /*#__PURE__*/React.forwardRef(DownSquareFilled);

	var DownSquareOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DownSquareOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M505.5 658.7c3.2 4.4 9.7 4.4 12.9 0l178-246c3.8-5.3 0-12.7-6.5-12.7H643c-10.2 0-19.9 4.9-25.9 13.2L512 558.6 406.8 413.2c-6-8.3-15.6-13.2-25.9-13.2H334c-6.5 0-10.3 7.4-6.5 12.7l178 246z" } }, { "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z" } }] }, "name": "down-square", "theme": "outlined" };
	exports.default = DownSquareOutlined;
	});

	var DownSquareOutlinedSvg = unwrapExports(DownSquareOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var DownSquareOutlined = function DownSquareOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DownSquareOutlinedSvg
	  }));
	};

	DownSquareOutlined.displayName = 'DownSquareOutlined';
	var DownSquareOutlined$1 = /*#__PURE__*/React.forwardRef(DownSquareOutlined);

	var DownSquareTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DownSquareTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M184 840h656V184H184v656zm150-440h46.9c10.3 0 19.9 4.9 25.9 13.2L512 558.6l105.2-145.4c6-8.3 15.7-13.2 25.9-13.2H690c6.5 0 10.3 7.4 6.4 12.7l-178 246a7.95 7.95 0 01-12.9 0l-178-246c-3.8-5.3 0-12.7 6.5-12.7z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M505.5 658.7c3.2 4.4 9.7 4.4 12.9 0l178-246c3.9-5.3.1-12.7-6.4-12.7h-46.9c-10.2 0-19.9 4.9-25.9 13.2L512 558.6 406.8 413.2c-6-8.3-15.6-13.2-25.9-13.2H334c-6.5 0-10.3 7.4-6.5 12.7l178 246z", "fill": primaryColor } }] }; }, "name": "down-square", "theme": "twotone" };
	exports.default = DownSquareTwoTone;
	});

	var DownSquareTwoToneSvg = unwrapExports(DownSquareTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var DownSquareTwoTone = function DownSquareTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DownSquareTwoToneSvg
	  }));
	};

	DownSquareTwoTone.displayName = 'DownSquareTwoTone';
	var DownSquareTwoTone$1 = /*#__PURE__*/React.forwardRef(DownSquareTwoTone);

	var DownloadOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DownloadOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M505.7 661a8 8 0 0012.6 0l112-141.7c4.1-5.2.4-12.9-6.3-12.9h-74.1V168c0-4.4-3.6-8-8-8h-60c-4.4 0-8 3.6-8 8v338.3H400c-6.7 0-10.4 7.7-6.3 12.9l112 141.8zM878 626h-60c-4.4 0-8 3.6-8 8v154H214V634c0-4.4-3.6-8-8-8h-60c-4.4 0-8 3.6-8 8v198c0 17.7 14.3 32 32 32h684c17.7 0 32-14.3 32-32V634c0-4.4-3.6-8-8-8z" } }] }, "name": "download", "theme": "outlined" };
	exports.default = DownloadOutlined;
	});

	var DownloadOutlinedSvg = unwrapExports(DownloadOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var DownloadOutlined = function DownloadOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DownloadOutlinedSvg
	  }));
	};

	DownloadOutlined.displayName = 'DownloadOutlined';
	var DownloadOutlined$1 = /*#__PURE__*/React.forwardRef(DownloadOutlined);

	var DragOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DragOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M909.3 506.3L781.7 405.6a7.23 7.23 0 00-11.7 5.7V476H548V254h64.8c6 0 9.4-7 5.7-11.7L517.7 114.7a7.14 7.14 0 00-11.3 0L405.6 242.3a7.23 7.23 0 005.7 11.7H476v222H254v-64.8c0-6-7-9.4-11.7-5.7L114.7 506.3a7.14 7.14 0 000 11.3l127.5 100.8c4.7 3.7 11.7.4 11.7-5.7V548h222v222h-64.8c-6 0-9.4 7-5.7 11.7l100.8 127.5c2.9 3.7 8.5 3.7 11.3 0l100.8-127.5c3.7-4.7.4-11.7-5.7-11.7H548V548h222v64.8c0 6 7 9.4 11.7 5.7l127.5-100.8a7.3 7.3 0 00.1-11.4z" } }] }, "name": "drag", "theme": "outlined" };
	exports.default = DragOutlined;
	});

	var DragOutlinedSvg = unwrapExports(DragOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var DragOutlined = function DragOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DragOutlinedSvg
	  }));
	};

	DragOutlined.displayName = 'DragOutlined';
	var DragOutlined$1 = /*#__PURE__*/React.forwardRef(DragOutlined);

	var DribbbleCircleFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DribbbleCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M675.1 328.3a245.2 245.2 0 00-220.8-55.1c6.8 9.1 51.5 69.9 91.8 144 87.5-32.8 124.5-82.6 129-88.9zM554 552.8c-138.7 48.3-188.6 144.6-193 153.6 41.7 32.5 94.1 51.9 151 51.9 34.1 0 66.6-6.9 96.1-19.5-3.7-21.6-17.9-96.8-52.5-186.6l-1.6.6zm47.7-11.9c32.2 88.4 45.3 160.4 47.8 175.4 55.2-37.3 94.5-96.4 105.4-164.9-8.4-2.6-76.1-22.8-153.2-10.5zM512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 736c-158.8 0-288-129.2-288-288s129.2-288 288-288 288 129.2 288 288-129.2 288-288 288zm53.1-346.2c5.7 11.7 11.2 23.6 16.3 35.6 1.8 4.2 3.6 8.4 5.3 12.7 81.8-10.3 163.2 6.2 171.3 7.9-.5-58.1-21.3-111.4-55.5-153.3-5.3 7.1-46.5 60-137.4 97.1zM498.6 432c-40.8-72.5-84.7-133.4-91.2-142.3-68.8 32.5-120.3 95.9-136.2 172.2 11 .2 112.4.7 227.4-29.9zm30.6 82.5c3.2-1 6.4-2 9.7-2.9-6.2-14-12.9-28-19.9-41.7-122.8 36.8-242.1 35.2-252.8 35-.1 2.5-.1 5-.1 7.5 0 63.2 23.9 120.9 63.2 164.5 5.5-9.6 73-121.4 199.9-162.4z" } }] }, "name": "dribbble-circle", "theme": "filled" };
	exports.default = DribbbleCircleFilled;
	});

	var DribbbleCircleFilledSvg = unwrapExports(DribbbleCircleFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var DribbbleCircleFilled = function DribbbleCircleFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DribbbleCircleFilledSvg
	  }));
	};

	DribbbleCircleFilled.displayName = 'DribbbleCircleFilled';
	var DribbbleCircleFilled$1 = /*#__PURE__*/React.forwardRef(DribbbleCircleFilled);

	var DribbbleOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DribbbleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 96C282.6 96 96 282.6 96 512s186.6 416 416 416 416-186.6 416-416S741.4 96 512 96zm275.1 191.8c49.5 60.5 79.5 137.5 80.2 221.4-11.7-2.5-129.2-26.3-247.4-11.4-2.5-6.1-5-12.2-7.6-18.3-7.4-17.3-15.3-34.6-23.6-51.5C720 374.3 779.6 298 787.1 287.8zM512 157.2c90.3 0 172.8 33.9 235.5 89.5-6.4 9.1-59.9 81-186.2 128.4-58.2-107-122.7-194.8-132.6-208 27.3-6.6 55.2-9.9 83.3-9.9zM360.9 191c9.4 12.8 72.9 100.9 131.7 205.5C326.4 440.6 180 440 164.1 439.8c23.1-110.3 97.4-201.9 196.8-248.8zM156.7 512.5c0-3.6.1-7.3.2-10.9 15.5.3 187.7 2.5 365.2-50.6 10.2 19.9 19.9 40.1 28.8 60.3-4.7 1.3-9.4 2.7-14 4.2C353.6 574.9 256.1 736.4 248 750.1c-56.7-63-91.3-146.3-91.3-237.6zM512 867.8c-82.2 0-157.9-28-218.1-75 6.4-13.1 78.3-152 278.7-221.9l2.3-.8c49.9 129.6 70.5 238.3 75.8 269.5A350.46 350.46 0 01512 867.8zm198.5-60.7c-3.6-21.6-22.5-125.6-69-253.3C752.9 536 850.7 565.2 862.8 569c-15.8 98.8-72.5 184.2-152.3 238.1z" } }] }, "name": "dribbble", "theme": "outlined" };
	exports.default = DribbbleOutlined;
	});

	var DribbbleOutlinedSvg = unwrapExports(DribbbleOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var DribbbleOutlined = function DribbbleOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DribbbleOutlinedSvg
	  }));
	};

	DribbbleOutlined.displayName = 'DribbbleOutlined';
	var DribbbleOutlined$1 = /*#__PURE__*/React.forwardRef(DribbbleOutlined);

	var DribbbleSquareFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DribbbleSquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M498.6 432c-40.8-72.5-84.7-133.4-91.2-142.3-68.8 32.5-120.3 95.9-136.2 172.2 11 .2 112.4.7 227.4-29.9zm66.5 21.8c5.7 11.7 11.2 23.6 16.3 35.6 1.8 4.2 3.6 8.4 5.3 12.7 81.8-10.3 163.2 6.2 171.3 7.9-.5-58.1-21.3-111.4-55.5-153.3-5.3 7.1-46.5 60-137.4 97.1zM880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM512 800c-158.8 0-288-129.2-288-288s129.2-288 288-288 288 129.2 288 288-129.2 288-288 288zm89.7-259.1c32.2 88.4 45.3 160.4 47.8 175.4 55.2-37.3 94.5-96.4 105.4-164.9-8.4-2.6-76.1-22.8-153.2-10.5zm-72.5-26.4c3.2-1 6.4-2 9.7-2.9-6.2-14-12.9-28-19.9-41.7-122.8 36.8-242.1 35.2-252.8 35-.1 2.5-.1 5-.1 7.5 0 63.2 23.9 120.9 63.2 164.5 5.5-9.6 73-121.4 199.9-162.4zm145.9-186.2a245.2 245.2 0 00-220.8-55.1c6.8 9.1 51.5 69.9 91.8 144 87.5-32.8 124.5-82.6 129-88.9zM554 552.8c-138.7 48.3-188.6 144.6-193 153.6 41.7 32.5 94.1 51.9 151 51.9 34.1 0 66.6-6.9 96.1-19.5-3.7-21.6-17.9-96.8-52.5-186.6l-1.6.6z" } }] }, "name": "dribbble-square", "theme": "filled" };
	exports.default = DribbbleSquareFilled;
	});

	var DribbbleSquareFilledSvg = unwrapExports(DribbbleSquareFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var DribbbleSquareFilled = function DribbbleSquareFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DribbbleSquareFilledSvg
	  }));
	};

	DribbbleSquareFilled.displayName = 'DribbbleSquareFilled';
	var DribbbleSquareFilled$1 = /*#__PURE__*/React.forwardRef(DribbbleSquareFilled);

	var DribbbleSquareOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DribbbleSquareOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M498.6 432c-40.8-72.5-84.7-133.4-91.2-142.3-68.8 32.5-120.3 95.9-136.2 172.2 11 .2 112.4.7 227.4-29.9zm66.5 21.8c5.7 11.7 11.2 23.6 16.3 35.6 1.8 4.2 3.6 8.4 5.3 12.7 81.8-10.3 163.2 6.2 171.3 7.9-.5-58.1-21.3-111.4-55.5-153.3-5.3 7.1-46.5 60-137.4 97.1zM880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM512 800c-158.8 0-288-129.2-288-288s129.2-288 288-288 288 129.2 288 288-129.2 288-288 288zm89.7-259.1c32.2 88.4 45.3 160.4 47.8 175.4 55.2-37.3 94.5-96.4 105.4-164.9-8.4-2.6-76.1-22.8-153.2-10.5zm-72.5-26.4c3.2-1 6.4-2 9.7-2.9-6.2-14-12.9-28-19.9-41.7-122.8 36.8-242.1 35.2-252.8 35-.1 2.5-.1 5-.1 7.5 0 63.2 23.9 120.9 63.2 164.5 5.5-9.6 73-121.4 199.9-162.4zm145.9-186.2a245.2 245.2 0 00-220.8-55.1c6.8 9.1 51.5 69.9 91.8 144 87.5-32.8 124.5-82.6 129-88.9zM554 552.8c-138.7 48.3-188.6 144.6-193 153.6 41.7 32.5 94.1 51.9 151 51.9 34.1 0 66.6-6.9 96.1-19.5-3.7-21.6-17.9-96.8-52.5-186.6l-1.6.6z" } }] }, "name": "dribbble-square", "theme": "outlined" };
	exports.default = DribbbleSquareOutlined;
	});

	var DribbbleSquareOutlinedSvg = unwrapExports(DribbbleSquareOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var DribbbleSquareOutlined = function DribbbleSquareOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DribbbleSquareOutlinedSvg
	  }));
	};

	DribbbleSquareOutlined.displayName = 'DribbbleSquareOutlined';
	var DribbbleSquareOutlined$1 = /*#__PURE__*/React.forwardRef(DribbbleSquareOutlined);

	var DropboxCircleFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DropboxCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M663.8 455.5zm-151.5-93.8l-151.8 93.8 151.8 93.9 151.5-93.9zM512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm151.2 595.5L512.6 750l-151-90.5v-33.1l45.4 29.4 105.6-87.7 105.6 87.7 45.1-29.4v33.1zm-45.6-22.4l-105.3-87.7L407 637.1l-151-99.2 104.5-82.4L256 371.2 407 274l105.3 87.7L617.6 274 768 372.1l-104.2 83.5L768 539l-150.4 98.1z" } }] }, "name": "dropbox-circle", "theme": "filled" };
	exports.default = DropboxCircleFilled;
	});

	var DropboxCircleFilledSvg = unwrapExports(DropboxCircleFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var DropboxCircleFilled = function DropboxCircleFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DropboxCircleFilledSvg
	  }));
	};

	DropboxCircleFilled.displayName = 'DropboxCircleFilled';
	var DropboxCircleFilled$1 = /*#__PURE__*/React.forwardRef(DropboxCircleFilled);

	var DropboxOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DropboxOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M64 556.9l264.2 173.5L512.5 577 246.8 412.7zm896-290.3zm0 0L696.8 95 512.5 248.5l265.2 164.2L512.5 577l184.3 153.4L960 558.8 777.7 412.7zM513 609.8L328.2 763.3l-79.4-51.5v57.8L513 928l263.7-158.4v-57.8l-78.9 51.5zM328.2 95L64 265.1l182.8 147.6 265.7-164.2zM64 556.9z" } }] }, "name": "dropbox", "theme": "outlined" };
	exports.default = DropboxOutlined;
	});

	var DropboxOutlinedSvg = unwrapExports(DropboxOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var DropboxOutlined = function DropboxOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DropboxOutlinedSvg
	  }));
	};

	DropboxOutlined.displayName = 'DropboxOutlined';
	var DropboxOutlined$1 = /*#__PURE__*/React.forwardRef(DropboxOutlined);

	var DropboxSquareFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var DropboxSquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM663.2 659.5L512.6 750l-151-90.5v-33.1l45.4 29.4 105.6-87.7 105.6 87.7 45.1-29.4v33.1zm-45.6-22.4l-105.3-87.7L407 637.1l-151-99.2 104.5-82.4L256 371.2 407 274l105.3 87.7L617.6 274 768 372.1l-104.2 83.5L768 539l-150.4 98.1zM512.3 361.7l-151.8 93.8 151.8 93.9 151.5-93.9zm151.5 93.8z" } }] }, "name": "dropbox-square", "theme": "filled" };
	exports.default = DropboxSquareFilled;
	});

	var DropboxSquareFilledSvg = unwrapExports(DropboxSquareFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var DropboxSquareFilled = function DropboxSquareFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: DropboxSquareFilledSvg
	  }));
	};

	DropboxSquareFilled.displayName = 'DropboxSquareFilled';
	var DropboxSquareFilled$1 = /*#__PURE__*/React.forwardRef(DropboxSquareFilled);

	var EditFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var EditFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 836H144c-17.7 0-32 14.3-32 32v36c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-36c0-17.7-14.3-32-32-32zm-622.3-84c2 0 4-.2 6-.5L431.9 722c2-.4 3.9-1.3 5.3-2.8l423.9-423.9a9.96 9.96 0 000-14.1L694.9 114.9c-1.9-1.9-4.4-2.9-7.1-2.9s-5.2 1-7.1 2.9L256.8 538.8c-1.5 1.5-2.4 3.3-2.8 5.3l-29.5 168.2a33.5 33.5 0 009.4 29.8c6.6 6.4 14.9 9.9 23.8 9.9z" } }] }, "name": "edit", "theme": "filled" };
	exports.default = EditFilled;
	});

	var EditFilledSvg = unwrapExports(EditFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var EditFilled = function EditFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: EditFilledSvg
	  }));
	};

	EditFilled.displayName = 'EditFilled';
	var EditFilled$1 = /*#__PURE__*/React.forwardRef(EditFilled);

	var EditOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var EditOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M257.7 752c2 0 4-.2 6-.5L431.9 722c2-.4 3.9-1.3 5.3-2.8l423.9-423.9a9.96 9.96 0 000-14.1L694.9 114.9c-1.9-1.9-4.4-2.9-7.1-2.9s-5.2 1-7.1 2.9L256.8 538.8c-1.5 1.5-2.4 3.3-2.8 5.3l-29.5 168.2a33.5 33.5 0 009.4 29.8c6.6 6.4 14.9 9.9 23.8 9.9zm67.4-174.4L687.8 215l73.3 73.3-362.7 362.6-88.9 15.7 15.6-89zM880 836H144c-17.7 0-32 14.3-32 32v36c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-36c0-17.7-14.3-32-32-32z" } }] }, "name": "edit", "theme": "outlined" };
	exports.default = EditOutlined;
	});

	var EditOutlinedSvg = unwrapExports(EditOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var EditOutlined = function EditOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: EditOutlinedSvg
	  }));
	};

	EditOutlined.displayName = 'EditOutlined';
	var EditOutlined$1 = /*#__PURE__*/React.forwardRef(EditOutlined);

	var EditTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var EditTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M761.1 288.3L687.8 215 325.1 577.6l-15.6 89 88.9-15.7z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M880 836H144c-17.7 0-32 14.3-32 32v36c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-36c0-17.7-14.3-32-32-32zm-622.3-84c2 0 4-.2 6-.5L431.9 722c2-.4 3.9-1.3 5.3-2.8l423.9-423.9a9.96 9.96 0 000-14.1L694.9 114.9c-1.9-1.9-4.4-2.9-7.1-2.9s-5.2 1-7.1 2.9L256.8 538.8c-1.5 1.5-2.4 3.3-2.8 5.3l-29.5 168.2a33.5 33.5 0 009.4 29.8c6.6 6.4 14.9 9.9 23.8 9.9zm67.4-174.4L687.8 215l73.3 73.3-362.7 362.6-88.9 15.7 15.6-89z", "fill": primaryColor } }] }; }, "name": "edit", "theme": "twotone" };
	exports.default = EditTwoTone;
	});

	var EditTwoToneSvg = unwrapExports(EditTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var EditTwoTone = function EditTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: EditTwoToneSvg
	  }));
	};

	EditTwoTone.displayName = 'EditTwoTone';
	var EditTwoTone$1 = /*#__PURE__*/React.forwardRef(EditTwoTone);

	var EllipsisOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var EllipsisOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M176 511a56 56 0 10112 0 56 56 0 10-112 0zm280 0a56 56 0 10112 0 56 56 0 10-112 0zm280 0a56 56 0 10112 0 56 56 0 10-112 0z" } }] }, "name": "ellipsis", "theme": "outlined" };
	exports.default = EllipsisOutlined;
	});

	var EllipsisOutlinedSvg = unwrapExports(EllipsisOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var EllipsisOutlined = function EllipsisOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: EllipsisOutlinedSvg
	  }));
	};

	EllipsisOutlined.displayName = 'EllipsisOutlined';
	var EllipsisOutlined$1 = /*#__PURE__*/React.forwardRef(EllipsisOutlined);

	var EnterOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var EnterOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M864 170h-60c-4.4 0-8 3.6-8 8v518H310v-73c0-6.7-7.8-10.5-13-6.3l-141.9 112a8 8 0 000 12.6l141.9 112c5.3 4.2 13 .4 13-6.3v-75h498c35.3 0 64-28.7 64-64V178c0-4.4-3.6-8-8-8z" } }] }, "name": "enter", "theme": "outlined" };
	exports.default = EnterOutlined;
	});

	var EnterOutlinedSvg = unwrapExports(EnterOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var EnterOutlined = function EnterOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: EnterOutlinedSvg
	  }));
	};

	EnterOutlined.displayName = 'EnterOutlined';
	var EnterOutlined$1 = /*#__PURE__*/React.forwardRef(EnterOutlined);

	var EnvironmentFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var EnvironmentFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 327c-29.9 0-58 11.6-79.2 32.8A111.6 111.6 0 00400 439c0 29.9 11.7 58 32.8 79.2A111.6 111.6 0 00512 551c29.9 0 58-11.7 79.2-32.8C612.4 497 624 468.9 624 439c0-29.9-11.6-58-32.8-79.2S541.9 327 512 327zm342.6-37.9a362.49 362.49 0 00-79.9-115.7 370.83 370.83 0 00-118.2-77.8C610.7 76.6 562.1 67 512 67c-50.1 0-98.7 9.6-144.5 28.5-44.3 18.3-84 44.5-118.2 77.8A363.6 363.6 0 00169.4 289c-19.5 45-29.4 92.8-29.4 142 0 70.6 16.9 140.9 50.1 208.7 26.7 54.5 64 107.6 111 158.1 80.3 86.2 164.5 138.9 188.4 153a43.9 43.9 0 0022.4 6.1c7.8 0 15.5-2 22.4-6.1 23.9-14.1 108.1-66.8 188.4-153 47-50.4 84.3-103.6 111-158.1C867.1 572 884 501.8 884 431.1c0-49.2-9.9-97-29.4-142zM512 615c-97.2 0-176-78.8-176-176s78.8-176 176-176 176 78.8 176 176-78.8 176-176 176z" } }] }, "name": "environment", "theme": "filled" };
	exports.default = EnvironmentFilled;
	});

	var EnvironmentFilledSvg = unwrapExports(EnvironmentFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var EnvironmentFilled = function EnvironmentFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: EnvironmentFilledSvg
	  }));
	};

	EnvironmentFilled.displayName = 'EnvironmentFilled';
	var EnvironmentFilled$1 = /*#__PURE__*/React.forwardRef(EnvironmentFilled);

	var EnvironmentOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var EnvironmentOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 289.1a362.49 362.49 0 00-79.9-115.7 370.83 370.83 0 00-118.2-77.8C610.7 76.6 562.1 67 512 67c-50.1 0-98.7 9.6-144.5 28.5-44.3 18.3-84 44.5-118.2 77.8A363.6 363.6 0 00169.4 289c-19.5 45-29.4 92.8-29.4 142 0 70.6 16.9 140.9 50.1 208.7 26.7 54.5 64 107.6 111 158.1 80.3 86.2 164.5 138.9 188.4 153a43.9 43.9 0 0022.4 6.1c7.8 0 15.5-2 22.4-6.1 23.9-14.1 108.1-66.8 188.4-153 47-50.4 84.3-103.6 111-158.1C867.1 572 884 501.8 884 431.1c0-49.2-9.9-97-29.4-142zM512 880.2c-65.9-41.9-300-207.8-300-449.1 0-77.9 31.1-151.1 87.6-206.3C356.3 169.5 431.7 139 512 139s155.7 30.5 212.4 85.9C780.9 280 812 353.2 812 431.1c0 241.3-234.1 407.2-300 449.1zm0-617.2c-97.2 0-176 78.8-176 176s78.8 176 176 176 176-78.8 176-176-78.8-176-176-176zm79.2 255.2A111.6 111.6 0 01512 551c-29.9 0-58-11.7-79.2-32.8A111.6 111.6 0 01400 439c0-29.9 11.7-58 32.8-79.2C454 338.6 482.1 327 512 327c29.9 0 58 11.6 79.2 32.8C612.4 381 624 409.1 624 439c0 29.9-11.6 58-32.8 79.2z" } }] }, "name": "environment", "theme": "outlined" };
	exports.default = EnvironmentOutlined;
	});

	var EnvironmentOutlinedSvg = unwrapExports(EnvironmentOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var EnvironmentOutlined = function EnvironmentOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: EnvironmentOutlinedSvg
	  }));
	};

	EnvironmentOutlined.displayName = 'EnvironmentOutlined';
	var EnvironmentOutlined$1 = /*#__PURE__*/React.forwardRef(EnvironmentOutlined);

	var EnvironmentTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var EnvironmentTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M724.4 224.9C667.7 169.5 592.3 139 512 139s-155.7 30.5-212.4 85.8C243.1 280 212 353.2 212 431.1c0 241.3 234.1 407.2 300 449.1 65.9-41.9 300-207.8 300-449.1 0-77.9-31.1-151.1-87.6-206.2zM512 615c-97.2 0-176-78.8-176-176s78.8-176 176-176 176 78.8 176 176-78.8 176-176 176z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M512 263c-97.2 0-176 78.8-176 176s78.8 176 176 176 176-78.8 176-176-78.8-176-176-176zm79.2 255.2A111.6 111.6 0 01512 551c-29.9 0-58-11.7-79.2-32.8A111.6 111.6 0 01400 439c0-29.9 11.7-58 32.8-79.2C454 338.6 482.1 327 512 327c29.9 0 58 11.6 79.2 32.8S624 409.1 624 439c0 29.9-11.6 58-32.8 79.2z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M854.6 289.1a362.49 362.49 0 00-79.9-115.7 370.83 370.83 0 00-118.2-77.8C610.7 76.6 562.1 67 512 67c-50.1 0-98.7 9.6-144.5 28.5-44.3 18.3-84 44.5-118.2 77.8A363.6 363.6 0 00169.4 289c-19.5 45-29.4 92.8-29.4 142 0 70.6 16.9 140.9 50.1 208.7 26.7 54.5 64 107.6 111 158.1 80.3 86.2 164.5 138.9 188.4 153a43.9 43.9 0 0022.4 6.1c7.8 0 15.5-2 22.4-6.1 23.9-14.1 108.1-66.8 188.4-153 47-50.4 84.3-103.6 111-158.1C867.1 572 884 501.8 884 431.1c0-49.2-9.9-97-29.4-142zM512 880.2c-65.9-41.9-300-207.8-300-449.1 0-77.9 31.1-151.1 87.6-206.3C356.3 169.5 431.7 139 512 139s155.7 30.5 212.4 85.9C780.9 280 812 353.2 812 431.1c0 241.3-234.1 407.2-300 449.1z", "fill": primaryColor } }] }; }, "name": "environment", "theme": "twotone" };
	exports.default = EnvironmentTwoTone;
	});

	var EnvironmentTwoToneSvg = unwrapExports(EnvironmentTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var EnvironmentTwoTone = function EnvironmentTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: EnvironmentTwoToneSvg
	  }));
	};

	EnvironmentTwoTone.displayName = 'EnvironmentTwoTone';
	var EnvironmentTwoTone$1 = /*#__PURE__*/React.forwardRef(EnvironmentTwoTone);

	var EuroCircleFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var EuroCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm63.5 375.8c4.4 0 8 3.6 8 8V475c0 4.4-3.6 8-8 8h-136c-.3 4.4-.3 9.1-.3 13.8v36h136.2c4.4 0 8 3.6 8 8V568c0 4.4-3.6 8-8 8H444.9c15.3 62 61.3 98.6 129.8 98.6 19.9 0 37.1-1.2 51.8-4.1 4.9-1 9.5 2.8 9.5 7.8v42.8c0 3.8-2.7 7-6.4 7.8-15.9 3.4-34.3 5.1-55.3 5.1-109.8 0-183-58.8-200.2-158H344c-4.4 0-8-3.6-8-8v-27.2c0-4.4 3.6-8 8-8h26.1v-36.9c0-4.4 0-8.8.3-12.8H344c-4.4 0-8-3.6-8-8v-27.2c0-4.4 3.6-8 8-8h31.7c19.7-94.2 92-149.9 198.6-149.9 20.9 0 39.4 1.9 55.3 5.4 3.7.8 6.3 4 6.3 7.8V346h.1c0 5.1-4.6 8.8-9.6 7.8-14.7-2.9-31.8-4.4-51.7-4.4-65.4 0-110.4 33.5-127.6 90.4h128.4z" } }] }, "name": "euro-circle", "theme": "filled" };
	exports.default = EuroCircleFilled;
	});

	var EuroCircleFilledSvg = unwrapExports(EuroCircleFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var EuroCircleFilled = function EuroCircleFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: EuroCircleFilledSvg
	  }));
	};

	EuroCircleFilled.displayName = 'EuroCircleFilled';
	var EuroCircleFilled$1 = /*#__PURE__*/React.forwardRef(EuroCircleFilled);

	var EuroCircleOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var EuroCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372zm117.7-588.6c-15.9-3.5-34.4-5.4-55.3-5.4-106.7 0-178.9 55.7-198.6 149.9H344c-4.4 0-8 3.6-8 8v27.2c0 4.4 3.6 8 8 8h26.4c-.3 4.1-.3 8.4-.3 12.8v36.9H344c-4.4 0-8 3.6-8 8V568c0 4.4 3.6 8 8 8h30.2c17.2 99.2 90.4 158 200.2 158 20.9 0 39.4-1.7 55.3-5.1 3.7-.8 6.4-4 6.4-7.8v-42.8c0-5-4.6-8.8-9.5-7.8-14.7 2.8-31.9 4.1-51.8 4.1-68.5 0-114.5-36.6-129.8-98.6h130.6c4.4 0 8-3.6 8-8v-27.2c0-4.4-3.6-8-8-8H439.2v-36c0-4.7 0-9.4.3-13.8h135.9c4.4 0 8-3.6 8-8v-27.2c0-4.4-3.6-8-8-8H447.1c17.2-56.9 62.3-90.4 127.6-90.4 19.9 0 37.1 1.5 51.7 4.4a8 8 0 009.6-7.8v-42.8c0-3.8-2.6-7-6.3-7.8z" } }] }, "name": "euro-circle", "theme": "outlined" };
	exports.default = EuroCircleOutlined;
	});

	var EuroCircleOutlinedSvg = unwrapExports(EuroCircleOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var EuroCircleOutlined = function EuroCircleOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: EuroCircleOutlinedSvg
	  }));
	};

	EuroCircleOutlined.displayName = 'EuroCircleOutlined';
	var EuroCircleOutlined$1 = /*#__PURE__*/React.forwardRef(EuroCircleOutlined);

	var EuroCircleTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var EuroCircleTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm117.1 581.1c0 3.8-2.7 7-6.4 7.8-15.9 3.4-34.4 5.1-55.3 5.1-109.8 0-183-58.8-200.2-158H337c-4.4 0-8-3.6-8-8v-27.2c0-4.4 3.6-8 8-8h26.1v-36.9c0-4.4 0-8.7.3-12.8H337c-4.4 0-8-3.6-8-8v-27.2c0-4.4 3.6-8 8-8h31.8C388.5 345.7 460.7 290 567.4 290c20.9 0 39.4 1.9 55.3 5.4 3.7.8 6.3 4 6.3 7.8V346a8 8 0 01-9.6 7.8c-14.6-2.9-31.8-4.4-51.7-4.4-65.3 0-110.4 33.5-127.6 90.4h128.3c4.4 0 8 3.6 8 8V475c0 4.4-3.6 8-8 8H432.5c-.3 4.4-.3 9.1-.3 13.8v36h136.4c4.4 0 8 3.6 8 8V568c0 4.4-3.6 8-8 8H438c15.3 62 61.3 98.6 129.8 98.6 19.9 0 37.1-1.3 51.8-4.1 4.9-1 9.5 2.8 9.5 7.8v42.8z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M619.6 670.5c-14.7 2.8-31.9 4.1-51.8 4.1-68.5 0-114.5-36.6-129.8-98.6h130.6c4.4 0 8-3.6 8-8v-27.2c0-4.4-3.6-8-8-8H432.2v-36c0-4.7 0-9.4.3-13.8h135.9c4.4 0 8-3.6 8-8v-27.2c0-4.4-3.6-8-8-8H440.1c17.2-56.9 62.3-90.4 127.6-90.4 19.9 0 37.1 1.5 51.7 4.4a8 8 0 009.6-7.8v-42.8c0-3.8-2.6-7-6.3-7.8-15.9-3.5-34.4-5.4-55.3-5.4-106.7 0-178.9 55.7-198.6 149.9H337c-4.4 0-8 3.6-8 8v27.2c0 4.4 3.6 8 8 8h26.4c-.3 4.1-.3 8.4-.3 12.8v36.9H337c-4.4 0-8 3.6-8 8V568c0 4.4 3.6 8 8 8h30.2c17.2 99.2 90.4 158 200.2 158 20.9 0 39.4-1.7 55.3-5.1 3.7-.8 6.4-4 6.4-7.8v-42.8c0-5-4.6-8.8-9.5-7.8z", "fill": primaryColor } }] }; }, "name": "euro-circle", "theme": "twotone" };
	exports.default = EuroCircleTwoTone;
	});

	var EuroCircleTwoToneSvg = unwrapExports(EuroCircleTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var EuroCircleTwoTone = function EuroCircleTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: EuroCircleTwoToneSvg
	  }));
	};

	EuroCircleTwoTone.displayName = 'EuroCircleTwoTone';
	var EuroCircleTwoTone$1 = /*#__PURE__*/React.forwardRef(EuroCircleTwoTone);

	var EuroOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var EuroOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372zm117.7-588.6c-15.9-3.5-34.4-5.4-55.3-5.4-106.7 0-178.9 55.7-198.6 149.9H344c-4.4 0-8 3.6-8 8v27.2c0 4.4 3.6 8 8 8h26.4c-.3 4.1-.3 8.4-.3 12.8v36.9H344c-4.4 0-8 3.6-8 8V568c0 4.4 3.6 8 8 8h30.2c17.2 99.2 90.4 158 200.2 158 20.9 0 39.4-1.7 55.3-5.1 3.7-.8 6.4-4 6.4-7.8v-42.8c0-5-4.6-8.8-9.5-7.8-14.7 2.8-31.9 4.1-51.8 4.1-68.5 0-114.5-36.6-129.8-98.6h130.6c4.4 0 8-3.6 8-8v-27.2c0-4.4-3.6-8-8-8H439.2v-36c0-4.7 0-9.4.3-13.8h135.9c4.4 0 8-3.6 8-8v-27.2c0-4.4-3.6-8-8-8H447.1c17.2-56.9 62.3-90.4 127.6-90.4 19.9 0 37.1 1.5 51.7 4.4a8 8 0 009.6-7.8v-42.8c0-3.8-2.6-7-6.3-7.8z" } }] }, "name": "euro", "theme": "outlined" };
	exports.default = EuroOutlined;
	});

	var EuroOutlinedSvg = unwrapExports(EuroOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var EuroOutlined = function EuroOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: EuroOutlinedSvg
	  }));
	};

	EuroOutlined.displayName = 'EuroOutlined';
	var EuroOutlined$1 = /*#__PURE__*/React.forwardRef(EuroOutlined);

	var EuroTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var EuroTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm117.1 581.1c0 3.8-2.7 7-6.4 7.8-15.9 3.4-34.4 5.1-55.3 5.1-109.8 0-183-58.8-200.2-158H337c-4.4 0-8-3.6-8-8v-27.2c0-4.4 3.6-8 8-8h26.1v-36.9c0-4.4 0-8.7.3-12.8H337c-4.4 0-8-3.6-8-8v-27.2c0-4.4 3.6-8 8-8h31.8C388.5 345.7 460.7 290 567.4 290c20.9 0 39.4 1.9 55.3 5.4 3.7.8 6.3 4 6.3 7.8V346a8 8 0 01-9.6 7.8c-14.6-2.9-31.8-4.4-51.7-4.4-65.3 0-110.4 33.5-127.6 90.4h128.3c4.4 0 8 3.6 8 8V475c0 4.4-3.6 8-8 8H432.5c-.3 4.4-.3 9.1-.3 13.8v36h136.4c4.4 0 8 3.6 8 8V568c0 4.4-3.6 8-8 8H438c15.3 62 61.3 98.6 129.8 98.6 19.9 0 37.1-1.3 51.8-4.1 4.9-1 9.5 2.8 9.5 7.8v42.8z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M619.6 670.5c-14.7 2.8-31.9 4.1-51.8 4.1-68.5 0-114.5-36.6-129.8-98.6h130.6c4.4 0 8-3.6 8-8v-27.2c0-4.4-3.6-8-8-8H432.2v-36c0-4.7 0-9.4.3-13.8h135.9c4.4 0 8-3.6 8-8v-27.2c0-4.4-3.6-8-8-8H440.1c17.2-56.9 62.3-90.4 127.6-90.4 19.9 0 37.1 1.5 51.7 4.4a8 8 0 009.6-7.8v-42.8c0-3.8-2.6-7-6.3-7.8-15.9-3.5-34.4-5.4-55.3-5.4-106.7 0-178.9 55.7-198.6 149.9H337c-4.4 0-8 3.6-8 8v27.2c0 4.4 3.6 8 8 8h26.4c-.3 4.1-.3 8.4-.3 12.8v36.9H337c-4.4 0-8 3.6-8 8V568c0 4.4 3.6 8 8 8h30.2c17.2 99.2 90.4 158 200.2 158 20.9 0 39.4-1.7 55.3-5.1 3.7-.8 6.4-4 6.4-7.8v-42.8c0-5-4.6-8.8-9.5-7.8z", "fill": primaryColor } }] }; }, "name": "euro", "theme": "twotone" };
	exports.default = EuroTwoTone;
	});

	var EuroTwoToneSvg = unwrapExports(EuroTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var EuroTwoTone = function EuroTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: EuroTwoToneSvg
	  }));
	};

	EuroTwoTone.displayName = 'EuroTwoTone';
	var EuroTwoTone$1 = /*#__PURE__*/React.forwardRef(EuroTwoTone);

	var ExceptionOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ExceptionOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M688 312v-48c0-4.4-3.6-8-8-8H296c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h384c4.4 0 8-3.6 8-8zm-392 88c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h184c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H296zm376 116c-119.3 0-216 96.7-216 216s96.7 216 216 216 216-96.7 216-216-96.7-216-216-216zm107.5 323.5C750.8 868.2 712.6 884 672 884s-78.8-15.8-107.5-44.5C535.8 810.8 520 772.6 520 732s15.8-78.8 44.5-107.5C593.2 595.8 631.4 580 672 580s78.8 15.8 107.5 44.5C808.2 653.2 824 691.4 824 732s-15.8 78.8-44.5 107.5zM640 812a32 32 0 1064 0 32 32 0 10-64 0zm12-64h40c4.4 0 8-3.6 8-8V628c0-4.4-3.6-8-8-8h-40c-4.4 0-8 3.6-8 8v112c0 4.4 3.6 8 8 8zM440 852H208V148h560v344c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V108c0-17.7-14.3-32-32-32H168c-17.7 0-32 14.3-32 32v784c0 17.7 14.3 32 32 32h272c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8z" } }] }, "name": "exception", "theme": "outlined" };
	exports.default = ExceptionOutlined;
	});

	var ExceptionOutlinedSvg = unwrapExports(ExceptionOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var ExceptionOutlined = function ExceptionOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ExceptionOutlinedSvg
	  }));
	};

	ExceptionOutlined.displayName = 'ExceptionOutlined';
	var ExceptionOutlined$1 = /*#__PURE__*/React.forwardRef(ExceptionOutlined);

	var ExclamationCircleFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ExclamationCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm-32 232c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v272c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V296zm32 440a48.01 48.01 0 010-96 48.01 48.01 0 010 96z" } }] }, "name": "exclamation-circle", "theme": "filled" };
	exports.default = ExclamationCircleFilled;
	});

	var ExclamationCircleFilledSvg = unwrapExports(ExclamationCircleFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var ExclamationCircleFilled = function ExclamationCircleFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ExclamationCircleFilledSvg
	  }));
	};

	ExclamationCircleFilled.displayName = 'ExclamationCircleFilled';
	var ExclamationCircleFilled$1 = /*#__PURE__*/React.forwardRef(ExclamationCircleFilled);

	var ExclamationCircleOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ExclamationCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z" } }, { "tag": "path", "attrs": { "d": "M464 688a48 48 0 1096 0 48 48 0 10-96 0zm24-112h48c4.4 0 8-3.6 8-8V296c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v272c0 4.4 3.6 8 8 8z" } }] }, "name": "exclamation-circle", "theme": "outlined" };
	exports.default = ExclamationCircleOutlined;
	});

	var ExclamationCircleOutlinedSvg = unwrapExports(ExclamationCircleOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var ExclamationCircleOutlined = function ExclamationCircleOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ExclamationCircleOutlinedSvg
	  }));
	};

	ExclamationCircleOutlined.displayName = 'ExclamationCircleOutlined';
	var ExclamationCircleOutlined$1 = /*#__PURE__*/React.forwardRef(ExclamationCircleOutlined);

	var ExclamationCircleTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ExclamationCircleTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm-32 156c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v272c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V296zm32 440a48.01 48.01 0 010-96 48.01 48.01 0 010 96z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M488 576h48c4.4 0 8-3.6 8-8V296c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v272c0 4.4 3.6 8 8 8zm-24 112a48 48 0 1096 0 48 48 0 10-96 0z", "fill": primaryColor } }] }; }, "name": "exclamation-circle", "theme": "twotone" };
	exports.default = ExclamationCircleTwoTone;
	});

	var ExclamationCircleTwoToneSvg = unwrapExports(ExclamationCircleTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var ExclamationCircleTwoTone = function ExclamationCircleTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ExclamationCircleTwoToneSvg
	  }));
	};

	ExclamationCircleTwoTone.displayName = 'ExclamationCircleTwoTone';
	var ExclamationCircleTwoTone$1 = /*#__PURE__*/React.forwardRef(ExclamationCircleTwoTone);

	var ExclamationOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ExclamationOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M448 804a64 64 0 10128 0 64 64 0 10-128 0zm32-168h64c4.4 0 8-3.6 8-8V164c0-4.4-3.6-8-8-8h-64c-4.4 0-8 3.6-8 8v464c0 4.4 3.6 8 8 8z" } }] }, "name": "exclamation", "theme": "outlined" };
	exports.default = ExclamationOutlined;
	});

	var ExclamationOutlinedSvg = unwrapExports(ExclamationOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var ExclamationOutlined = function ExclamationOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ExclamationOutlinedSvg
	  }));
	};

	ExclamationOutlined.displayName = 'ExclamationOutlined';
	var ExclamationOutlined$1 = /*#__PURE__*/React.forwardRef(ExclamationOutlined);

	var ExpandAltOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ExpandAltOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M855 160.1l-189.2 23.5c-6.6.8-9.3 8.8-4.7 13.5l54.7 54.7-153.5 153.5a8.03 8.03 0 000 11.3l45.1 45.1c3.1 3.1 8.2 3.1 11.3 0l153.6-153.6 54.7 54.7a7.94 7.94 0 0013.5-4.7L863.9 169a7.9 7.9 0 00-8.9-8.9zM416.6 562.3a8.03 8.03 0 00-11.3 0L251.8 715.9l-54.7-54.7a7.94 7.94 0 00-13.5 4.7L160.1 855c-.6 5.2 3.7 9.5 8.9 8.9l189.2-23.5c6.6-.8 9.3-8.8 4.7-13.5l-54.7-54.7 153.6-153.6c3.1-3.1 3.1-8.2 0-11.3l-45.2-45z" } }] }, "name": "expand-alt", "theme": "outlined" };
	exports.default = ExpandAltOutlined;
	});

	var ExpandAltOutlinedSvg = unwrapExports(ExpandAltOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var ExpandAltOutlined = function ExpandAltOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ExpandAltOutlinedSvg
	  }));
	};

	ExpandAltOutlined.displayName = 'ExpandAltOutlined';
	var ExpandAltOutlined$1 = /*#__PURE__*/React.forwardRef(ExpandAltOutlined);

	var ExpandOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ExpandOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M342 88H120c-17.7 0-32 14.3-32 32v224c0 8.8 7.2 16 16 16h48c8.8 0 16-7.2 16-16V168h174c8.8 0 16-7.2 16-16v-48c0-8.8-7.2-16-16-16zm578 576h-48c-8.8 0-16 7.2-16 16v176H682c-8.8 0-16 7.2-16 16v48c0 8.8 7.2 16 16 16h222c17.7 0 32-14.3 32-32V680c0-8.8-7.2-16-16-16zM342 856H168V680c0-8.8-7.2-16-16-16h-48c-8.8 0-16 7.2-16 16v224c0 17.7 14.3 32 32 32h222c8.8 0 16-7.2 16-16v-48c0-8.8-7.2-16-16-16zM904 88H682c-8.8 0-16 7.2-16 16v48c0 8.8 7.2 16 16 16h174v176c0 8.8 7.2 16 16 16h48c8.8 0 16-7.2 16-16V120c0-17.7-14.3-32-32-32z" } }] }, "name": "expand", "theme": "outlined" };
	exports.default = ExpandOutlined;
	});

	var ExpandOutlinedSvg = unwrapExports(ExpandOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var ExpandOutlined = function ExpandOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ExpandOutlinedSvg
	  }));
	};

	ExpandOutlined.displayName = 'ExpandOutlined';
	var ExpandOutlined$1 = /*#__PURE__*/React.forwardRef(ExpandOutlined);

	var ExperimentFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ExperimentFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M218.9 636.3l42.6 26.6c.1.1.3.2.4.3l12.7 8 .3.3a186.9 186.9 0 0094.1 25.1c44.9 0 87.2-15.7 121-43.8a256.27 256.27 0 01164.9-59.9c52.3 0 102.2 15.7 144.6 44.5l7.9 5-111.6-289V179.8h63.5c4.4 0 8-3.6 8-8V120c0-4.4-3.6-8-8-8H264.7c-4.4 0-8 3.6-8 8v51.9c0 4.4 3.6 8 8 8h63.5v173.6L218.9 636.3zm333-203.1c22 0 39.9 17.9 39.9 39.9S573.9 513 551.9 513 512 495.1 512 473.1s17.9-39.9 39.9-39.9zM878 825.1l-29.9-77.4-85.7-53.5-.1.1c-.7-.5-1.5-1-2.2-1.5l-8.1-5-.3-.3c-29-17.5-62.3-26.8-97-26.8-44.9 0-87.2 15.7-121 43.8a256.27 256.27 0 01-164.9 59.9c-53 0-103.5-16.1-146.2-45.6l-28.9-18.1L146 825.1c-2.8 7.4-4.3 15.2-4.3 23 0 35.2 28.6 63.8 63.8 63.8h612.9c7.9 0 15.7-1.5 23-4.3a63.6 63.6 0 0036.6-82.5z" } }] }, "name": "experiment", "theme": "filled" };
	exports.default = ExperimentFilled;
	});

	var ExperimentFilledSvg = unwrapExports(ExperimentFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var ExperimentFilled = function ExperimentFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ExperimentFilledSvg
	  }));
	};

	ExperimentFilled.displayName = 'ExperimentFilled';
	var ExperimentFilled$1 = /*#__PURE__*/React.forwardRef(ExperimentFilled);

	var ExperimentOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ExperimentOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 472a40 40 0 1080 0 40 40 0 10-80 0zm367 352.9L696.3 352V178H768v-68H256v68h71.7v174L145 824.9c-2.8 7.4-4.3 15.2-4.3 23.1 0 35.3 28.7 64 64 64h614.6c7.9 0 15.7-1.5 23.1-4.3 33-12.7 49.4-49.8 36.6-82.8zM395.7 364.7V180h232.6v184.7L719.2 600c-20.7-5.3-42.1-8-63.9-8-61.2 0-119.2 21.5-165.3 60a188.78 188.78 0 01-121.3 43.9c-32.7 0-64.1-8.3-91.8-23.7l118.8-307.5zM210.5 844l41.7-107.8c35.7 18.1 75.4 27.8 116.6 27.8 61.2 0 119.2-21.5 165.3-60 33.9-28.2 76.3-43.9 121.3-43.9 35 0 68.4 9.5 97.6 27.1L813.5 844h-603z" } }] }, "name": "experiment", "theme": "outlined" };
	exports.default = ExperimentOutlined;
	});

	var ExperimentOutlinedSvg = unwrapExports(ExperimentOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var ExperimentOutlined = function ExperimentOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ExperimentOutlinedSvg
	  }));
	};

	ExperimentOutlined.displayName = 'ExperimentOutlined';
	var ExperimentOutlined$1 = /*#__PURE__*/React.forwardRef(ExperimentOutlined);

	var ExperimentTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ExperimentTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M551.9 513c19.6 0 35.9-14.2 39.3-32.8A40.02 40.02 0 01552 512a40 40 0 01-40-39.4v.5c0 22 17.9 39.9 39.9 39.9zM752 687.8l-.3-.3c-29-17.5-62.3-26.8-97-26.8-44.9 0-87.2 15.7-121 43.8a256.27 256.27 0 01-164.9 59.9c-41.2 0-81-9.8-116.7-28L210.5 844h603l-59.9-155.2-1.6-1z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M879 824.9L696.3 352V178H768v-68H256v68h71.7v174L145 824.9c-2.8 7.4-4.3 15.2-4.3 23.1 0 35.3 28.7 64 64 64h614.6c7.9 0 15.7-1.5 23.1-4.3 33-12.7 49.4-49.8 36.6-82.8zM395.7 364.7V180h232.6v184.7L719.2 600c-20.7-5.3-42.1-8-63.9-8-61.2 0-119.2 21.5-165.3 60a188.78 188.78 0 01-121.3 43.9c-32.7 0-64.1-8.3-91.8-23.7l118.8-307.5zM210.5 844l41.6-107.6.1-.2c35.7 18.1 75.4 27.8 116.6 27.8 61.2 0 119.2-21.5 165.3-60 33.9-28.2 76.3-43.9 121.3-43.9 35 0 68.4 9.5 97.6 27.1l.6 1.6L813.5 844h-603z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M552 512c19.3 0 35.4-13.6 39.2-31.8.6-2.7.8-5.4.8-8.2 0-22.1-17.9-40-40-40s-40 17.9-40 40v.6a40 40 0 0040 39.4z", "fill": primaryColor } }] }; }, "name": "experiment", "theme": "twotone" };
	exports.default = ExperimentTwoTone;
	});

	var ExperimentTwoToneSvg = unwrapExports(ExperimentTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var ExperimentTwoTone = function ExperimentTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ExperimentTwoToneSvg
	  }));
	};

	ExperimentTwoTone.displayName = 'ExperimentTwoTone';
	var ExperimentTwoTone$1 = /*#__PURE__*/React.forwardRef(ExperimentTwoTone);

	var ExportOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ExportOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M888.3 757.4h-53.8c-4.2 0-7.7 3.5-7.7 7.7v61.8H197.1V197.1h629.8v61.8c0 4.2 3.5 7.7 7.7 7.7h53.8c4.2 0 7.7-3.4 7.7-7.7V158.7c0-17-13.7-30.7-30.7-30.7H158.7c-17 0-30.7 13.7-30.7 30.7v706.6c0 17 13.7 30.7 30.7 30.7h706.6c17 0 30.7-13.7 30.7-30.7V765.1c0-4.3-3.5-7.7-7.7-7.7zm18.6-251.7L765 393.7c-5.3-4.2-13-.4-13 6.3v76H438c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h314v76c0 6.7 7.8 10.5 13 6.3l141.9-112a8 8 0 000-12.6z" } }] }, "name": "export", "theme": "outlined" };
	exports.default = ExportOutlined;
	});

	var ExportOutlinedSvg = unwrapExports(ExportOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var ExportOutlined = function ExportOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ExportOutlinedSvg
	  }));
	};

	ExportOutlined.displayName = 'ExportOutlined';
	var ExportOutlined$1 = /*#__PURE__*/React.forwardRef(ExportOutlined);

	var EyeFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var EyeFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M396 512a112 112 0 10224 0 112 112 0 10-224 0zm546.2-25.8C847.4 286.5 704.1 186 512 186c-192.2 0-335.4 100.5-430.2 300.3a60.3 60.3 0 000 51.5C176.6 737.5 319.9 838 512 838c192.2 0 335.4-100.5 430.2-300.3 7.7-16.2 7.7-35 0-51.5zM508 688c-97.2 0-176-78.8-176-176s78.8-176 176-176 176 78.8 176 176-78.8 176-176 176z" } }] }, "name": "eye", "theme": "filled" };
	exports.default = EyeFilled;
	});

	var EyeFilledSvg = unwrapExports(EyeFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var EyeFilled = function EyeFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: EyeFilledSvg
	  }));
	};

	EyeFilled.displayName = 'EyeFilled';
	var EyeFilled$1 = /*#__PURE__*/React.forwardRef(EyeFilled);

	var EyeInvisibleFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var EyeInvisibleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M508 624a112 112 0 00112-112c0-3.28-.15-6.53-.43-9.74L498.26 623.57c3.21.28 6.45.43 9.74.43zm370.72-458.44L836 122.88a8 8 0 00-11.31 0L715.37 232.23Q624.91 186 512 186q-288.3 0-430.2 300.3a60.3 60.3 0 000 51.5q56.7 119.43 136.55 191.45L112.56 835a8 8 0 000 11.31L155.25 889a8 8 0 0011.31 0l712.16-712.12a8 8 0 000-11.32zM332 512a176 176 0 01258.88-155.28l-48.62 48.62a112.08 112.08 0 00-140.92 140.92l-48.62 48.62A175.09 175.09 0 01332 512z" } }, { "tag": "path", "attrs": { "d": "M942.2 486.2Q889.4 375 816.51 304.85L672.37 449A176.08 176.08 0 01445 676.37L322.74 798.63Q407.82 838 512 838q288.3 0 430.2-300.3a60.29 60.29 0 000-51.5z" } }] }, "name": "eye-invisible", "theme": "filled" };
	exports.default = EyeInvisibleFilled;
	});

	var EyeInvisibleFilledSvg = unwrapExports(EyeInvisibleFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var EyeInvisibleFilled = function EyeInvisibleFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: EyeInvisibleFilledSvg
	  }));
	};

	EyeInvisibleFilled.displayName = 'EyeInvisibleFilled';
	var EyeInvisibleFilled$1 = /*#__PURE__*/React.forwardRef(EyeInvisibleFilled);

	var EyeInvisibleOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var EyeInvisibleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M942.2 486.2Q889.47 375.11 816.7 305l-50.88 50.88C807.31 395.53 843.45 447.4 874.7 512 791.5 684.2 673.4 766 512 766q-72.67 0-133.87-22.38L323 798.75Q408 838 512 838q288.3 0 430.2-300.3a60.29 60.29 0 000-51.5zm-63.57-320.64L836 122.88a8 8 0 00-11.32 0L715.31 232.2Q624.86 186 512 186q-288.3 0-430.2 300.3a60.3 60.3 0 000 51.5q56.69 119.4 136.5 191.41L112.48 835a8 8 0 000 11.31L155.17 889a8 8 0 0011.31 0l712.15-712.12a8 8 0 000-11.32zM149.3 512C232.6 339.8 350.7 258 512 258c54.54 0 104.13 9.36 149.12 28.39l-70.3 70.3a176 176 0 00-238.13 238.13l-83.42 83.42C223.1 637.49 183.3 582.28 149.3 512zm246.7 0a112.11 112.11 0 01146.2-106.69L401.31 546.2A112 112 0 01396 512z" } }, { "tag": "path", "attrs": { "d": "M508 624c-3.46 0-6.87-.16-10.25-.47l-52.82 52.82a176.09 176.09 0 00227.42-227.42l-52.82 52.82c.31 3.38.47 6.79.47 10.25a111.94 111.94 0 01-112 112z" } }] }, "name": "eye-invisible", "theme": "outlined" };
	exports.default = EyeInvisibleOutlined;
	});

	var EyeInvisibleOutlinedSvg = unwrapExports(EyeInvisibleOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var EyeInvisibleOutlined = function EyeInvisibleOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: EyeInvisibleOutlinedSvg
	  }));
	};

	EyeInvisibleOutlined.displayName = 'EyeInvisibleOutlined';
	var EyeInvisibleOutlined$1 = /*#__PURE__*/React.forwardRef(EyeInvisibleOutlined);

	var EyeInvisibleTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var EyeInvisibleTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M254.89 758.85l125.57-125.57a176 176 0 01248.82-248.82L757 256.72Q651.69 186.07 512 186q-288.3 0-430.2 300.3a60.3 60.3 0 000 51.5q69.27 145.91 173.09 221.05zM942.2 486.2Q889.46 375.11 816.7 305L672.48 449.27a176.09 176.09 0 01-227.22 227.21L323 798.75Q408 838 512 838q288.3 0 430.2-300.3a60.29 60.29 0 000-51.5z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M942.2 486.2Q889.47 375.11 816.7 305l-50.88 50.88C807.31 395.53 843.45 447.4 874.7 512 791.5 684.2 673.4 766 512 766q-72.67 0-133.87-22.38L323 798.75Q408 838 512 838q288.3 0 430.2-300.3a60.29 60.29 0 000-51.5zM878.63 165.56L836 122.88a8 8 0 00-11.32 0L715.31 232.2Q624.86 186 512 186q-288.3 0-430.2 300.3a60.3 60.3 0 000 51.5q56.69 119.4 136.5 191.41L112.48 835a8 8 0 000 11.31L155.17 889a8 8 0 0011.31 0l712.15-712.12a8 8 0 000-11.32zM149.3 512C232.6 339.8 350.7 258 512 258c54.54 0 104.13 9.36 149.12 28.39l-70.3 70.3a176 176 0 00-238.13 238.13l-83.42 83.42C223.1 637.49 183.3 582.28 149.3 512zm246.7 0a112.11 112.11 0 01146.2-106.69L401.31 546.2A112 112 0 01396 512z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M508 624c-3.46 0-6.87-.16-10.25-.47l-52.82 52.82a176.09 176.09 0 00227.42-227.42l-52.82 52.82c.31 3.38.47 6.79.47 10.25a111.94 111.94 0 01-112 112z", "fill": primaryColor } }] }; }, "name": "eye-invisible", "theme": "twotone" };
	exports.default = EyeInvisibleTwoTone;
	});

	var EyeInvisibleTwoToneSvg = unwrapExports(EyeInvisibleTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var EyeInvisibleTwoTone = function EyeInvisibleTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: EyeInvisibleTwoToneSvg
	  }));
	};

	EyeInvisibleTwoTone.displayName = 'EyeInvisibleTwoTone';
	var EyeInvisibleTwoTone$1 = /*#__PURE__*/React.forwardRef(EyeInvisibleTwoTone);

	var EyeOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var EyeOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M942.2 486.2C847.4 286.5 704.1 186 512 186c-192.2 0-335.4 100.5-430.2 300.3a60.3 60.3 0 000 51.5C176.6 737.5 319.9 838 512 838c192.2 0 335.4-100.5 430.2-300.3 7.7-16.2 7.7-35 0-51.5zM512 766c-161.3 0-279.4-81.8-362.7-254C232.6 339.8 350.7 258 512 258c161.3 0 279.4 81.8 362.7 254C791.5 684.2 673.4 766 512 766zm-4-430c-97.2 0-176 78.8-176 176s78.8 176 176 176 176-78.8 176-176-78.8-176-176-176zm0 288c-61.9 0-112-50.1-112-112s50.1-112 112-112 112 50.1 112 112-50.1 112-112 112z" } }] }, "name": "eye", "theme": "outlined" };
	exports.default = EyeOutlined;
	});

	var EyeOutlinedSvg = unwrapExports(EyeOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var EyeOutlined = function EyeOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: EyeOutlinedSvg
	  }));
	};

	EyeOutlined.displayName = 'EyeOutlined';
	var EyeOutlined$1 = /*#__PURE__*/React.forwardRef(EyeOutlined);

	var EyeTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var EyeTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M81.8 537.8a60.3 60.3 0 010-51.5C176.6 286.5 319.8 186 512 186c-192.2 0-335.4 100.5-430.2 300.3a60.3 60.3 0 000 51.5C176.6 737.5 319.9 838 512 838c-192.1 0-335.4-100.5-430.2-300.2z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M512 258c-161.3 0-279.4 81.8-362.7 254C232.6 684.2 350.7 766 512 766c161.4 0 279.5-81.8 362.7-254C791.4 339.8 673.3 258 512 258zm-4 430c-97.2 0-176-78.8-176-176s78.8-176 176-176 176 78.8 176 176-78.8 176-176 176z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M942.2 486.2C847.4 286.5 704.1 186 512 186c-192.2 0-335.4 100.5-430.2 300.3a60.3 60.3 0 000 51.5C176.6 737.5 319.9 838 512 838c192.2 0 335.4-100.5 430.2-300.3 7.7-16.2 7.7-35 0-51.5zM512 766c-161.3 0-279.4-81.8-362.7-254C232.6 339.8 350.7 258 512 258s279.4 81.8 362.7 254C791.5 684.2 673.4 766 512 766z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M508 336c-97.2 0-176 78.8-176 176s78.8 176 176 176 176-78.8 176-176-78.8-176-176-176zm0 288c-61.9 0-112-50.1-112-112s50.1-112 112-112 112 50.1 112 112-50.1 112-112 112z", "fill": primaryColor } }] }; }, "name": "eye", "theme": "twotone" };
	exports.default = EyeTwoTone;
	});

	var EyeTwoToneSvg = unwrapExports(EyeTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var EyeTwoTone = function EyeTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: EyeTwoToneSvg
	  }));
	};

	EyeTwoTone.displayName = 'EyeTwoTone';
	var EyeTwoTone$1 = /*#__PURE__*/React.forwardRef(EyeTwoTone);

	var FacebookFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FacebookFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-92.4 233.5h-63.9c-50.1 0-59.8 23.8-59.8 58.8v77.1h119.6l-15.6 120.7h-104V912H539.2V602.2H434.9V481.4h104.3v-89c0-103.3 63.1-159.6 155.3-159.6 44.2 0 82.1 3.3 93.2 4.8v107.9z" } }] }, "name": "facebook", "theme": "filled" };
	exports.default = FacebookFilled;
	});

	var FacebookFilledSvg = unwrapExports(FacebookFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var FacebookFilled = function FacebookFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FacebookFilledSvg
	  }));
	};

	FacebookFilled.displayName = 'FacebookFilled';
	var FacebookFilled$1 = /*#__PURE__*/React.forwardRef(FacebookFilled);

	var FacebookOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FacebookOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-32 736H663.9V602.2h104l15.6-120.7H663.9v-77.1c0-35 9.7-58.8 59.8-58.8h63.9v-108c-11.1-1.5-49-4.8-93.2-4.8-92.2 0-155.3 56.3-155.3 159.6v89H434.9v120.7h104.3V848H176V176h672v672z" } }] }, "name": "facebook", "theme": "outlined" };
	exports.default = FacebookOutlined;
	});

	var FacebookOutlinedSvg = unwrapExports(FacebookOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FacebookOutlined = function FacebookOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FacebookOutlinedSvg
	  }));
	};

	FacebookOutlined.displayName = 'FacebookOutlined';
	var FacebookOutlined$1 = /*#__PURE__*/React.forwardRef(FacebookOutlined);

	var FallOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FallOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M925.9 804l-24-199.2c-.8-6.6-8.9-9.4-13.6-4.7L829 659.5 557.7 388.3c-6.3-6.2-16.4-6.2-22.6 0L433.3 490 156.6 213.3a8.03 8.03 0 00-11.3 0l-45 45.2a8.03 8.03 0 000 11.3L422 591.7c6.2 6.3 16.4 6.3 22.6 0L546.4 490l226.1 226-59.3 59.3a8.01 8.01 0 004.7 13.6l199.2 24c5.1.7 9.5-3.7 8.8-8.9z" } }] }, "name": "fall", "theme": "outlined" };
	exports.default = FallOutlined;
	});

	var FallOutlinedSvg = unwrapExports(FallOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FallOutlined = function FallOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FallOutlinedSvg
	  }));
	};

	FallOutlined.displayName = 'FallOutlined';
	var FallOutlined$1 = /*#__PURE__*/React.forwardRef(FallOutlined);

	var FastBackwardFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FastBackwardFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M517.6 273.5L230.2 499.3a16.14 16.14 0 000 25.4l287.4 225.8c10.7 8.4 26.4.8 26.4-12.7V286.2c0-13.5-15.7-21.1-26.4-12.7zm320 0L550.2 499.3a16.14 16.14 0 000 25.4l287.4 225.8c10.7 8.4 26.4.8 26.4-12.7V286.2c0-13.5-15.7-21.1-26.4-12.7zm-620-25.5h-51.2c-3.5 0-6.4 2.7-6.4 6v516c0 3.3 2.9 6 6.4 6h51.2c3.5 0 6.4-2.7 6.4-6V254c0-3.3-2.9-6-6.4-6z" } }] }, "name": "fast-backward", "theme": "filled" };
	exports.default = FastBackwardFilled;
	});

	var FastBackwardFilledSvg = unwrapExports(FastBackwardFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var FastBackwardFilled = function FastBackwardFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FastBackwardFilledSvg
	  }));
	};

	FastBackwardFilled.displayName = 'FastBackwardFilled';
	var FastBackwardFilled$1 = /*#__PURE__*/React.forwardRef(FastBackwardFilled);

	var FastBackwardOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FastBackwardOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M517.6 273.5L230.2 499.3a16.14 16.14 0 000 25.4l287.4 225.8c10.7 8.4 26.4.8 26.4-12.7V286.2c0-13.5-15.7-21.1-26.4-12.7zm320 0L550.2 499.3a16.14 16.14 0 000 25.4l287.4 225.8c10.7 8.4 26.4.8 26.4-12.7V286.2c0-13.5-15.7-21.1-26.4-12.7zm-620-25.5h-51.2c-3.5 0-6.4 2.7-6.4 6v516c0 3.3 2.9 6 6.4 6h51.2c3.5 0 6.4-2.7 6.4-6V254c0-3.3-2.9-6-6.4-6z" } }] }, "name": "fast-backward", "theme": "outlined" };
	exports.default = FastBackwardOutlined;
	});

	var FastBackwardOutlinedSvg = unwrapExports(FastBackwardOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FastBackwardOutlined = function FastBackwardOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FastBackwardOutlinedSvg
	  }));
	};

	FastBackwardOutlined.displayName = 'FastBackwardOutlined';
	var FastBackwardOutlined$1 = /*#__PURE__*/React.forwardRef(FastBackwardOutlined);

	var FastForwardFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FastForwardFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M793.8 499.3L506.4 273.5c-10.7-8.4-26.4-.8-26.4 12.7v451.6c0 13.5 15.7 21.1 26.4 12.7l287.4-225.8a16.14 16.14 0 000-25.4zm-320 0L186.4 273.5c-10.7-8.4-26.4-.8-26.4 12.7v451.5c0 13.5 15.7 21.1 26.4 12.7l287.4-225.8c4.1-3.2 6.2-8 6.2-12.7 0-4.6-2.1-9.4-6.2-12.6zM857.6 248h-51.2c-3.5 0-6.4 2.7-6.4 6v516c0 3.3 2.9 6 6.4 6h51.2c3.5 0 6.4-2.7 6.4-6V254c0-3.3-2.9-6-6.4-6z" } }] }, "name": "fast-forward", "theme": "filled" };
	exports.default = FastForwardFilled;
	});

	var FastForwardFilledSvg = unwrapExports(FastForwardFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var FastForwardFilled = function FastForwardFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FastForwardFilledSvg
	  }));
	};

	FastForwardFilled.displayName = 'FastForwardFilled';
	var FastForwardFilled$1 = /*#__PURE__*/React.forwardRef(FastForwardFilled);

	var FastForwardOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FastForwardOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M793.8 499.3L506.4 273.5c-10.7-8.4-26.4-.8-26.4 12.7v451.6c0 13.5 15.7 21.1 26.4 12.7l287.4-225.8a16.14 16.14 0 000-25.4zm-320 0L186.4 273.5c-10.7-8.4-26.4-.8-26.4 12.7v451.5c0 13.5 15.7 21.1 26.4 12.7l287.4-225.8c4.1-3.2 6.2-8 6.2-12.7 0-4.6-2.1-9.4-6.2-12.6zM857.6 248h-51.2c-3.5 0-6.4 2.7-6.4 6v516c0 3.3 2.9 6 6.4 6h51.2c3.5 0 6.4-2.7 6.4-6V254c0-3.3-2.9-6-6.4-6z" } }] }, "name": "fast-forward", "theme": "outlined" };
	exports.default = FastForwardOutlined;
	});

	var FastForwardOutlinedSvg = unwrapExports(FastForwardOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FastForwardOutlined = function FastForwardOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FastForwardOutlinedSvg
	  }));
	};

	FastForwardOutlined.displayName = 'FastForwardOutlined';
	var FastForwardOutlined$1 = /*#__PURE__*/React.forwardRef(FastForwardOutlined);

	var FieldBinaryOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FieldBinaryOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M600 395.4h91V649h79V267c0-4.4-3.6-8-8-8h-48.2c-3.7 0-7 2.6-7.7 6.3-2.6 12.1-6.9 22.3-12.9 30.9a86.14 86.14 0 01-26.3 24.4c-10.3 6.2-22 10.5-35 12.9-10.4 1.9-21 3-32 3.1a8 8 0 00-7.9 8v42.8c0 4.4 3.6 8 8 8zM871 702H567c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h304c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8zM443.9 312.7c-16.1-19-34.4-32.4-55.2-40.4-21.3-8.2-44.1-12.3-68.4-12.3-23.9 0-46.4 4.1-67.7 12.3-20.8 8-39 21.4-54.8 40.3-15.9 19.1-28.7 44.7-38.3 77-9.6 32.5-14.5 73-14.5 121.5 0 49.9 4.9 91.4 14.5 124.4 9.6 32.8 22.4 58.7 38.3 77.7 15.8 18.9 34 32.3 54.8 40.3 21.3 8.2 43.8 12.3 67.7 12.3 24.4 0 47.2-4.1 68.4-12.3 20.8-8 39.2-21.4 55.2-40.4 16.1-19 29-44.9 38.6-77.7 9.6-33 14.5-74.5 14.5-124.4 0-48.4-4.9-88.9-14.5-121.5-9.5-32.1-22.4-57.7-38.6-76.8zm-29.5 251.7c-1 21.4-4.2 42-9.5 61.9-5.5 20.7-14.5 38.5-27 53.4-13.6 16.3-33.2 24.3-57.6 24.3-24 0-43.2-8.1-56.7-24.4-12.2-14.8-21.1-32.6-26.6-53.3-5.3-19.9-8.5-40.6-9.5-61.9-1-20.8-1.5-38.5-1.5-53.2 0-8.8.1-19.4.4-31.8.2-12.7 1.1-25.8 2.6-39.2 1.5-13.6 4-27.1 7.6-40.5 3.7-13.8 8.8-26.3 15.4-37.4 6.9-11.6 15.8-21.1 26.7-28.3 11.4-7.6 25.3-11.3 41.5-11.3 16.1 0 30.1 3.7 41.7 11.2a87.94 87.94 0 0127.4 28.2c6.9 11.2 12.1 23.8 15.6 37.7 3.3 13.2 5.8 26.6 7.5 40.1 1.8 13.5 2.8 26.6 3 39.4.2 12.4.4 23 .4 31.8.1 14.8-.4 32.5-1.4 53.3z" } }] }, "name": "field-binary", "theme": "outlined" };
	exports.default = FieldBinaryOutlined;
	});

	var FieldBinaryOutlinedSvg = unwrapExports(FieldBinaryOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FieldBinaryOutlined = function FieldBinaryOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FieldBinaryOutlinedSvg
	  }));
	};

	FieldBinaryOutlined.displayName = 'FieldBinaryOutlined';
	var FieldBinaryOutlined$1 = /*#__PURE__*/React.forwardRef(FieldBinaryOutlined);

	var FieldNumberOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FieldNumberOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M508 280h-63.3c-3.3 0-6 2.7-6 6v340.2H433L197.4 282.6c-1.1-1.6-3-2.6-4.9-2.6H126c-3.3 0-6 2.7-6 6v464c0 3.3 2.7 6 6 6h62.7c3.3 0 6-2.7 6-6V405.1h5.7l238.2 348.3c1.1 1.6 3 2.6 5 2.6H508c3.3 0 6-2.7 6-6V286c0-3.3-2.7-6-6-6zm378 413H582c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h304c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8zm-152.2-63c52.9 0 95.2-17.2 126.2-51.7 29.4-32.9 44-75.8 44-128.8 0-53.1-14.6-96.5-44-129.3-30.9-34.8-73.2-52.2-126.2-52.2-53.7 0-95.9 17.5-126.3 52.8-29.2 33.1-43.4 75.9-43.4 128.7 0 52.4 14.3 95.2 43.5 128.3 30.6 34.7 73 52.2 126.2 52.2zm-71.5-263.7c16.9-20.6 40.3-30.9 71.4-30.9 31.5 0 54.8 9.6 71 29.1 16.4 20.3 24.9 48.6 24.9 84.9 0 36.3-8.4 64.1-24.8 83.9-16.5 19.4-40 29.2-71.1 29.2-31.2 0-55-10.3-71.4-30.4-16.3-20.1-24.5-47.3-24.5-82.6.1-35.8 8.2-63 24.5-83.2z" } }] }, "name": "field-number", "theme": "outlined" };
	exports.default = FieldNumberOutlined;
	});

	var FieldNumberOutlinedSvg = unwrapExports(FieldNumberOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FieldNumberOutlined = function FieldNumberOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FieldNumberOutlinedSvg
	  }));
	};

	FieldNumberOutlined.displayName = 'FieldNumberOutlined';
	var FieldNumberOutlined$1 = /*#__PURE__*/React.forwardRef(FieldNumberOutlined);

	var FieldStringOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FieldStringOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M875.6 515.9c2.1.8 4.4-.3 5.2-2.4.2-.4.2-.9.2-1.4v-58.3c0-1.8-1.1-3.3-2.8-3.8-6-1.8-17.2-3-27.2-3-32.9 0-61.7 16.7-73.5 41.2v-28.6c0-4.4-3.6-8-8-8H717c-4.4 0-8 3.6-8 8V729c0 4.4 3.6 8 8 8h54.8c4.4 0 8-3.6 8-8V572.7c0-36.2 26.1-60.2 65.1-60.2 10.4.1 26.6 1.8 30.7 3.4zm-537-40.5l-54.7-12.6c-61.2-14.2-87.7-34.8-87.7-70.7 0-44.6 39.1-73.5 96.9-73.5 52.8 0 91.4 26.5 99.9 68.9h70C455.9 311.6 387.6 259 293.4 259c-103.3 0-171 55.5-171 139 0 68.6 38.6 109.5 122.2 128.5l61.6 14.3c63.6 14.9 91.6 37.1 91.6 75.1 0 44.1-43.5 75.2-102.5 75.2-60.6 0-104.5-27.2-112.8-70.5H111c7.2 79.9 75.6 130.4 179.1 130.4C402.3 751 471 695.2 471 605.3c0-70.2-38.6-108.5-132.4-129.9zM841 729a36 36 0 1072 0 36 36 0 10-72 0zM653 457.8h-51.4V396c0-4.4-3.6-8-8-8h-54.7c-4.4 0-8 3.6-8 8v61.8H495c-4.4 0-8 3.6-8 8v42.3c0 4.4 3.6 8 8 8h35.9v147.5c0 56.2 27.4 79.4 93.1 79.4 11.7 0 23.6-1.2 33.8-3.1 1.9-.3 3.2-2 3.2-3.9v-49.3c0-2.2-1.8-4-4-4h-.4c-4.9.5-6.2.6-8.3.8-4.1.3-7.8.5-12.6.5-24.1 0-34.1-10.3-34.1-35.6V516.1H653c4.4 0 8-3.6 8-8v-42.3c0-4.4-3.6-8-8-8z" } }] }, "name": "field-string", "theme": "outlined" };
	exports.default = FieldStringOutlined;
	});

	var FieldStringOutlinedSvg = unwrapExports(FieldStringOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FieldStringOutlined = function FieldStringOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FieldStringOutlinedSvg
	  }));
	};

	FieldStringOutlined.displayName = 'FieldStringOutlined';
	var FieldStringOutlined$1 = /*#__PURE__*/React.forwardRef(FieldStringOutlined);

	var FieldTimeOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FieldTimeOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M945 412H689c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h256c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8zM811 548H689c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h122c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8zM477.3 322.5H434c-6.2 0-11.2 5-11.2 11.2v248c0 3.6 1.7 6.9 4.6 9l148.9 108.6c5 3.6 12 2.6 15.6-2.4l25.7-35.1v-.1c3.6-5 2.5-12-2.5-15.6l-126.7-91.6V333.7c.1-6.2-5-11.2-11.1-11.2z" } }, { "tag": "path", "attrs": { "d": "M804.8 673.9H747c-5.6 0-10.9 2.9-13.9 7.7a321 321 0 01-44.5 55.7 317.17 317.17 0 01-101.3 68.3c-39.3 16.6-81 25-124 25-43.1 0-84.8-8.4-124-25-37.9-16-72-39-101.3-68.3s-52.3-63.4-68.3-101.3c-16.6-39.2-25-80.9-25-124 0-43.1 8.4-84.7 25-124 16-37.9 39-72 68.3-101.3 29.3-29.3 63.4-52.3 101.3-68.3 39.2-16.6 81-25 124-25 43.1 0 84.8 8.4 124 25 37.9 16 72 39 101.3 68.3a321 321 0 0144.5 55.7c3 4.8 8.3 7.7 13.9 7.7h57.8c6.9 0 11.3-7.2 8.2-13.3-65.2-129.7-197.4-214-345-215.7-216.1-2.7-395.6 174.2-396 390.1C71.6 727.5 246.9 903 463.2 903c149.5 0 283.9-84.6 349.8-215.8a9.18 9.18 0 00-8.2-13.3z" } }] }, "name": "field-time", "theme": "outlined" };
	exports.default = FieldTimeOutlined;
	});

	var FieldTimeOutlinedSvg = unwrapExports(FieldTimeOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FieldTimeOutlined = function FieldTimeOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FieldTimeOutlinedSvg
	  }));
	};

	FieldTimeOutlined.displayName = 'FieldTimeOutlined';
	var FieldTimeOutlined$1 = /*#__PURE__*/React.forwardRef(FieldTimeOutlined);

	var FileAddFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FileAddFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M480 580H372a8 8 0 00-8 8v48a8 8 0 008 8h108v108a8 8 0 008 8h48a8 8 0 008-8V644h108a8 8 0 008-8v-48a8 8 0 00-8-8H544V472a8 8 0 00-8-8h-48a8 8 0 00-8 8v108zm374.6-291.3c6 6 9.4 14.1 9.4 22.6V928c0 17.7-14.3 32-32 32H192c-17.7 0-32-14.3-32-32V96c0-17.7 14.3-32 32-32h424.7c8.5 0 16.7 3.4 22.7 9.4l215.2 215.3zM790.2 326L602 137.8V326h188.2z" } }] }, "name": "file-add", "theme": "filled" };
	exports.default = FileAddFilled;
	});

	var FileAddFilledSvg = unwrapExports(FileAddFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var FileAddFilled = function FileAddFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FileAddFilledSvg
	  }));
	};

	FileAddFilled.displayName = 'FileAddFilled';
	var FileAddFilled$1 = /*#__PURE__*/React.forwardRef(FileAddFilled);

	var FileAddOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FileAddOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM790.2 326H602V137.8L790.2 326zm1.8 562H232V136h302v216a42 42 0 0042 42h216v494zM544 472c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v108H372c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h108v108c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V644h108c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H544V472z" } }] }, "name": "file-add", "theme": "outlined" };
	exports.default = FileAddOutlined;
	});

	var FileAddOutlinedSvg = unwrapExports(FileAddOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FileAddOutlined = function FileAddOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FileAddOutlinedSvg
	  }));
	};

	FileAddOutlined.displayName = 'FileAddOutlined';
	var FileAddOutlined$1 = /*#__PURE__*/React.forwardRef(FileAddOutlined);

	var FileAddTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FileAddTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M534 352V136H232v752h560V394H576a42 42 0 01-42-42zm126 236v48c0 4.4-3.6 8-8 8H544v108c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V644H372c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h108V472c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v108h108c4.4 0 8 3.6 8 8z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM602 137.8L790.2 326H602V137.8zM792 888H232V136h302v216a42 42 0 0042 42h216v494z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M544 472c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v108H372c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h108v108c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V644h108c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H544V472z", "fill": primaryColor } }] }; }, "name": "file-add", "theme": "twotone" };
	exports.default = FileAddTwoTone;
	});

	var FileAddTwoToneSvg = unwrapExports(FileAddTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var FileAddTwoTone = function FileAddTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FileAddTwoToneSvg
	  }));
	};

	FileAddTwoTone.displayName = 'FileAddTwoTone';
	var FileAddTwoTone$1 = /*#__PURE__*/React.forwardRef(FileAddTwoTone);

	var FileDoneOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FileDoneOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M688 312v-48c0-4.4-3.6-8-8-8H296c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h384c4.4 0 8-3.6 8-8zm-392 88c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h184c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H296zm376 116c-119.3 0-216 96.7-216 216s96.7 216 216 216 216-96.7 216-216-96.7-216-216-216zm107.5 323.5C750.8 868.2 712.6 884 672 884s-78.8-15.8-107.5-44.5C535.8 810.8 520 772.6 520 732s15.8-78.8 44.5-107.5C593.2 595.8 631.4 580 672 580s78.8 15.8 107.5 44.5C808.2 653.2 824 691.4 824 732s-15.8 78.8-44.5 107.5zM761 656h-44.3c-2.6 0-5 1.2-6.5 3.3l-63.5 87.8-23.1-31.9a7.92 7.92 0 00-6.5-3.3H573c-6.5 0-10.3 7.4-6.5 12.7l73.8 102.1c3.2 4.4 9.7 4.4 12.9 0l114.2-158c3.9-5.3.1-12.7-6.4-12.7zM440 852H208V148h560v344c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V108c0-17.7-14.3-32-32-32H168c-17.7 0-32 14.3-32 32v784c0 17.7 14.3 32 32 32h272c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8z" } }] }, "name": "file-done", "theme": "outlined" };
	exports.default = FileDoneOutlined;
	});

	var FileDoneOutlinedSvg = unwrapExports(FileDoneOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FileDoneOutlined = function FileDoneOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FileDoneOutlinedSvg
	  }));
	};

	FileDoneOutlined.displayName = 'FileDoneOutlined';
	var FileDoneOutlined$1 = /*#__PURE__*/React.forwardRef(FileDoneOutlined);

	var FileExcelFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FileExcelFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.7c6 6 9.4 14.1 9.4 22.6V928c0 17.7-14.3 32-32 32H192c-17.7 0-32-14.3-32-32V96c0-17.7 14.3-32 32-32h424.7c8.5 0 16.7 3.4 22.7 9.4l215.2 215.3zM790.2 326L602 137.8V326h188.2zM575.34 477.84l-61.22 102.3L452.3 477.8a12 12 0 00-10.27-5.79h-38.44a12 12 0 00-6.4 1.85 12 12 0 00-3.75 16.56l82.34 130.42-83.45 132.78a12 12 0 00-1.84 6.39 12 12 0 0012 12h34.46a12 12 0 0010.21-5.7l62.7-101.47 62.3 101.45a12 12 0 0010.23 5.72h37.48a12 12 0 006.48-1.9 12 12 0 003.62-16.58l-83.83-130.55 85.3-132.47a12 12 0 001.9-6.5 12 12 0 00-12-12h-35.7a12 12 0 00-10.29 5.84z" } }] }, "name": "file-excel", "theme": "filled" };
	exports.default = FileExcelFilled;
	});

	var FileExcelFilledSvg = unwrapExports(FileExcelFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var FileExcelFilled = function FileExcelFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FileExcelFilledSvg
	  }));
	};

	FileExcelFilled.displayName = 'FileExcelFilled';
	var FileExcelFilled$1 = /*#__PURE__*/React.forwardRef(FileExcelFilled);

	var FileExcelOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FileExcelOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM790.2 326H602V137.8L790.2 326zm1.8 562H232V136h302v216a42 42 0 0042 42h216v494zM514.1 580.1l-61.8-102.4c-2.2-3.6-6.1-5.8-10.3-5.8h-38.4c-2.3 0-4.5.6-6.4 1.9-5.6 3.5-7.3 10.9-3.7 16.6l82.3 130.4-83.4 132.8a12.04 12.04 0 0010.2 18.4h34.5c4.2 0 8-2.2 10.2-5.7L510 664.8l62.3 101.4c2.2 3.6 6.1 5.7 10.2 5.7H620c2.3 0 4.5-.7 6.5-1.9 5.6-3.6 7.2-11 3.6-16.6l-84-130.4 85.3-132.5a12.04 12.04 0 00-10.1-18.5h-35.7c-4.2 0-8.1 2.2-10.3 5.8l-61.2 102.3z" } }] }, "name": "file-excel", "theme": "outlined" };
	exports.default = FileExcelOutlined;
	});

	var FileExcelOutlinedSvg = unwrapExports(FileExcelOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FileExcelOutlined = function FileExcelOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FileExcelOutlinedSvg
	  }));
	};

	FileExcelOutlined.displayName = 'FileExcelOutlined';
	var FileExcelOutlined$1 = /*#__PURE__*/React.forwardRef(FileExcelOutlined);

	var FileExcelTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FileExcelTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M534 352V136H232v752h560V394H576a42 42 0 01-42-42zm51.6 120h35.7a12.04 12.04 0 0110.1 18.5L546.1 623l84 130.4c3.6 5.6 2 13-3.6 16.6-2 1.2-4.2 1.9-6.5 1.9h-37.5c-4.1 0-8-2.1-10.2-5.7L510 664.8l-62.7 101.5c-2.2 3.5-6 5.7-10.2 5.7h-34.5a12.04 12.04 0 01-10.2-18.4l83.4-132.8-82.3-130.4c-3.6-5.7-1.9-13.1 3.7-16.6 1.9-1.3 4.1-1.9 6.4-1.9H442c4.2 0 8.1 2.2 10.3 5.8l61.8 102.4 61.2-102.3c2.2-3.6 6.1-5.8 10.3-5.8z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM602 137.8L790.2 326H602V137.8zM792 888H232V136h302v216a42 42 0 0042 42h216v494z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M514.1 580.1l-61.8-102.4c-2.2-3.6-6.1-5.8-10.3-5.8h-38.4c-2.3 0-4.5.6-6.4 1.9-5.6 3.5-7.3 10.9-3.7 16.6l82.3 130.4-83.4 132.8a12.04 12.04 0 0010.2 18.4h34.5c4.2 0 8-2.2 10.2-5.7L510 664.8l62.3 101.4c2.2 3.6 6.1 5.7 10.2 5.7H620c2.3 0 4.5-.7 6.5-1.9 5.6-3.6 7.2-11 3.6-16.6l-84-130.4 85.3-132.5a12.04 12.04 0 00-10.1-18.5h-35.7c-4.2 0-8.1 2.2-10.3 5.8l-61.2 102.3z", "fill": primaryColor } }] }; }, "name": "file-excel", "theme": "twotone" };
	exports.default = FileExcelTwoTone;
	});

	var FileExcelTwoToneSvg = unwrapExports(FileExcelTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var FileExcelTwoTone = function FileExcelTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FileExcelTwoToneSvg
	  }));
	};

	FileExcelTwoTone.displayName = 'FileExcelTwoTone';
	var FileExcelTwoTone$1 = /*#__PURE__*/React.forwardRef(FileExcelTwoTone);

	var FileExclamationFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FileExclamationFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.7c6 6 9.4 14.1 9.4 22.6V928c0 17.7-14.3 32-32 32H192c-17.7 0-32-14.3-32-32V96c0-17.7 14.3-32 32-32h424.7c8.5 0 16.7 3.4 22.7 9.4l215.2 215.3zM790.2 326L602 137.8V326h188.2zM512 784a40 40 0 100-80 40 40 0 000 80zm32-152V448a8 8 0 00-8-8h-48a8 8 0 00-8 8v184a8 8 0 008 8h48a8 8 0 008-8z" } }] }, "name": "file-exclamation", "theme": "filled" };
	exports.default = FileExclamationFilled;
	});

	var FileExclamationFilledSvg = unwrapExports(FileExclamationFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var FileExclamationFilled = function FileExclamationFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FileExclamationFilledSvg
	  }));
	};

	FileExclamationFilled.displayName = 'FileExclamationFilled';
	var FileExclamationFilled$1 = /*#__PURE__*/React.forwardRef(FileExclamationFilled);

	var FileExclamationOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FileExclamationOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM790.2 326H602V137.8L790.2 326zm1.8 562H232V136h302v216a42 42 0 0042 42h216v494zM472 744a40 40 0 1080 0 40 40 0 10-80 0zm16-104h48c4.4 0 8-3.6 8-8V448c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v184c0 4.4 3.6 8 8 8z" } }] }, "name": "file-exclamation", "theme": "outlined" };
	exports.default = FileExclamationOutlined;
	});

	var FileExclamationOutlinedSvg = unwrapExports(FileExclamationOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FileExclamationOutlined = function FileExclamationOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FileExclamationOutlinedSvg
	  }));
	};

	FileExclamationOutlined.displayName = 'FileExclamationOutlined';
	var FileExclamationOutlined$1 = /*#__PURE__*/React.forwardRef(FileExclamationOutlined);

	var FileExclamationTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FileExclamationTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M534 352V136H232v752h560V394H576a42 42 0 01-42-42zm-54 96c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v184c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V448zm32 336c-22.1 0-40-17.9-40-40s17.9-40 40-40 40 17.9 40 40-17.9 40-40 40z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM602 137.8L790.2 326H602V137.8zM792 888H232V136h302v216a42 42 0 0042 42h216v494z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M488 640h48c4.4 0 8-3.6 8-8V448c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v184c0 4.4 3.6 8 8 8zm-16 104a40 40 0 1080 0 40 40 0 10-80 0z", "fill": primaryColor } }] }; }, "name": "file-exclamation", "theme": "twotone" };
	exports.default = FileExclamationTwoTone;
	});

	var FileExclamationTwoToneSvg = unwrapExports(FileExclamationTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var FileExclamationTwoTone = function FileExclamationTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FileExclamationTwoToneSvg
	  }));
	};

	FileExclamationTwoTone.displayName = 'FileExclamationTwoTone';
	var FileExclamationTwoTone$1 = /*#__PURE__*/React.forwardRef(FileExclamationTwoTone);

	var FileFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FileFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.7c6 6 9.4 14.1 9.4 22.6V928c0 17.7-14.3 32-32 32H192c-17.7 0-32-14.3-32-32V96c0-17.7 14.3-32 32-32h424.7c8.5 0 16.7 3.4 22.7 9.4l215.2 215.3zM790.2 326L602 137.8V326h188.2z" } }] }, "name": "file", "theme": "filled" };
	exports.default = FileFilled;
	});

	var FileFilledSvg = unwrapExports(FileFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var FileFilled = function FileFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FileFilledSvg
	  }));
	};

	FileFilled.displayName = 'FileFilled';
	var FileFilled$1 = /*#__PURE__*/React.forwardRef(FileFilled);

	var FileGifOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FileGifOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M551.5 490.5H521c-4.6 0-8.4 3.7-8.4 8.4V720c0 4.6 3.7 8.4 8.4 8.4h30.5c4.6 0 8.4-3.7 8.4-8.4V498.9c-.1-4.6-3.8-8.4-8.4-8.4zM477.3 600h-88.1c-4.6 0-8.4 3.7-8.4 8.4v23.8c0 4.6 3.7 8.4 8.4 8.4h47.6v.7c-.6 29.9-23 49.8-56.5 49.8-39.2 0-63.6-30.7-63.6-81.4 0-50.1 23.9-80.6 62.3-80.6 28.1 0 47.5 13.5 55.4 38.3l.9 2.8h49.2l-.7-4.6C475.9 515.9 434.7 484 379 484c-68.8 0-113 49.4-113 125.9 0 77.5 43.7 126.1 113.6 126.1 64.4 0 106-40.3 106-102.9v-24.8c0-4.6-3.7-8.3-8.3-8.3z" } }, { "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM602 137.8L790.2 326H602V137.8zM792 888H232V136h302v216a42 42 0 0042 42h216v494z" } }, { "tag": "path", "attrs": { "d": "M608.2 727.8h32.3c4.6 0 8.4-3.7 8.4-8.4v-84.8h87.8c4.6 0 8.4-3.7 8.4-8.4v-25.5c0-4.6-3.7-8.4-8.4-8.4h-87.8v-58.9h96.8c4.6 0 8.4-3.7 8.4-8.4v-26.8c0-4.6-3.7-8.4-8.4-8.4H608.2c-4.6 0-8.4 3.7-8.4 8.4v221.1c0 4.8 3.8 8.5 8.4 8.5z" } }] }, "name": "file-gif", "theme": "outlined" };
	exports.default = FileGifOutlined;
	});

	var FileGifOutlinedSvg = unwrapExports(FileGifOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FileGifOutlined = function FileGifOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FileGifOutlinedSvg
	  }));
	};

	FileGifOutlined.displayName = 'FileGifOutlined';
	var FileGifOutlined$1 = /*#__PURE__*/React.forwardRef(FileGifOutlined);

	var FileImageFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FileImageFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.7L639.4 73.4c-6-6-14.2-9.4-22.7-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.6-9.4-22.6zM400 402c22.1 0 40 17.9 40 40s-17.9 40-40 40-40-17.9-40-40 17.9-40 40-40zm296 294H328c-6.7 0-10.4-7.7-6.3-12.9l99.8-127.2a8 8 0 0112.6 0l41.1 52.4 77.8-99.2a8 8 0 0112.6 0l136.5 174c4.3 5.2.5 12.9-6.1 12.9zm-94-370V137.8L790.2 326H602z" } }] }, "name": "file-image", "theme": "filled" };
	exports.default = FileImageFilled;
	});

	var FileImageFilledSvg = unwrapExports(FileImageFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var FileImageFilled = function FileImageFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FileImageFilledSvg
	  }));
	};

	FileImageFilled.displayName = 'FileImageFilled';
	var FileImageFilled$1 = /*#__PURE__*/React.forwardRef(FileImageFilled);

	var FileImageOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FileImageOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M553.1 509.1l-77.8 99.2-41.1-52.4a8 8 0 00-12.6 0l-99.8 127.2a7.98 7.98 0 006.3 12.9H696c6.7 0 10.4-7.7 6.3-12.9l-136.5-174a8.1 8.1 0 00-12.7 0zM360 442a40 40 0 1080 0 40 40 0 10-80 0zm494.6-153.4L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM790.2 326H602V137.8L790.2 326zm1.8 562H232V136h302v216a42 42 0 0042 42h216v494z" } }] }, "name": "file-image", "theme": "outlined" };
	exports.default = FileImageOutlined;
	});

	var FileImageOutlinedSvg = unwrapExports(FileImageOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FileImageOutlined = function FileImageOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FileImageOutlinedSvg
	  }));
	};

	FileImageOutlined.displayName = 'FileImageOutlined';
	var FileImageOutlined$1 = /*#__PURE__*/React.forwardRef(FileImageOutlined);

	var FileImageTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FileImageTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M534 352V136H232v752h560V394H576a42 42 0 01-42-42zm-134 50c22.1 0 40 17.9 40 40s-17.9 40-40 40-40-17.9-40-40 17.9-40 40-40zm296 294H328.1c-6.7 0-10.4-7.7-6.3-12.9l99.8-127.2a8 8 0 0112.6 0l41.1 52.4 77.8-99.2a8.1 8.1 0 0112.7 0l136.5 174c4.1 5.2.4 12.9-6.3 12.9z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM602 137.8L790.2 326H602V137.8zM792 888H232V136h302v216a42 42 0 0042 42h216v494z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M553.1 509.1l-77.8 99.2-41.1-52.4a8 8 0 00-12.6 0l-99.8 127.2a7.98 7.98 0 006.3 12.9H696c6.7 0 10.4-7.7 6.3-12.9l-136.5-174a8.1 8.1 0 00-12.7 0zM360 442a40 40 0 1080 0 40 40 0 10-80 0z", "fill": primaryColor } }] }; }, "name": "file-image", "theme": "twotone" };
	exports.default = FileImageTwoTone;
	});

	var FileImageTwoToneSvg = unwrapExports(FileImageTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var FileImageTwoTone = function FileImageTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FileImageTwoToneSvg
	  }));
	};

	FileImageTwoTone.displayName = 'FileImageTwoTone';
	var FileImageTwoTone$1 = /*#__PURE__*/React.forwardRef(FileImageTwoTone);

	var FileJpgOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FileJpgOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M874.6 301.8L596.8 21.3c-4.5-4.5-9.4-8.3-14.7-11.5-1.4-.8-2.8-1.6-4.3-2.3-.9-.5-1.9-.9-2.8-1.3-9-4-18.9-6.2-29-6.2H201c-39.8 0-73 32.2-73 72v880c0 39.8 33.2 72 73 72h623c39.8 0 71-32.2 71-72V352.5c0-19-7-37.2-20.4-50.7zM583 110.4L783.8 312H583V110.4zM823 952H200V72h311v240c0 39.8 33.2 72 73 72h239v568zM350 696.5c0 24.2-7.5 31.4-21.9 31.4-9 0-18.4-5.8-24.8-18.5L272.9 732c13.4 22.9 32.3 34.2 61.3 34.2 41.6 0 60.8-29.9 60.8-66.2V577h-45v119.5zM501.3 577H437v186h44v-62h21.6c39.1 0 73.1-19.6 73.1-63.6 0-45.8-33.5-60.4-74.4-60.4zm-.8 89H481v-53h18.2c21.5 0 33.4 6.2 33.4 24.9 0 18.1-10.5 28.1-32.1 28.1zm182.5-9v36h30v30.1c-4 2.9-11 4.7-17.7 4.7-34.3 0-50.7-21.4-50.7-58.2 0-36.1 19.7-57.4 47.1-57.4 15.3 0 25 6.2 34 14.4l23.7-28.3c-12.7-12.8-32.1-24.2-59.2-24.2-49.6 0-91.1 35.3-91.1 97 0 62.7 40 95.1 91.5 95.1 25.9 0 49.2-10.2 61.5-22.6V657H683z" } }] }, "name": "file-jpg", "theme": "outlined" };
	exports.default = FileJpgOutlined;
	});

	var FileJpgOutlinedSvg = unwrapExports(FileJpgOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FileJpgOutlined = function FileJpgOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FileJpgOutlinedSvg
	  }));
	};

	FileJpgOutlined.displayName = 'FileJpgOutlined';
	var FileJpgOutlined$1 = /*#__PURE__*/React.forwardRef(FileJpgOutlined);

	var FileMarkdownFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FileMarkdownFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.7c6 6 9.4 14.1 9.4 22.6V928c0 17.7-14.3 32-32 32H192c-17.7 0-32-14.3-32-32V96c0-17.7 14.3-32 32-32h424.7c8.5 0 16.7 3.4 22.7 9.4l215.2 215.3zM790.2 326L602 137.8V326h188.2zM426.13 600.93l59.11 132.97a16 16 0 0014.62 9.5h24.06a16 16 0 0014.63-9.51l59.1-133.35V758a16 16 0 0016.01 16H641a16 16 0 0016-16V486a16 16 0 00-16-16h-34.75a16 16 0 00-14.67 9.62L512.1 662.2l-79.48-182.59a16 16 0 00-14.67-9.61H383a16 16 0 00-16 16v272a16 16 0 0016 16h27.13a16 16 0 0016-16V600.93z" } }] }, "name": "file-markdown", "theme": "filled" };
	exports.default = FileMarkdownFilled;
	});

	var FileMarkdownFilledSvg = unwrapExports(FileMarkdownFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var FileMarkdownFilled = function FileMarkdownFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FileMarkdownFilledSvg
	  }));
	};

	FileMarkdownFilled.displayName = 'FileMarkdownFilled';
	var FileMarkdownFilled$1 = /*#__PURE__*/React.forwardRef(FileMarkdownFilled);

	var FileMarkdownOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FileMarkdownOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM790.2 326H602V137.8L790.2 326zm1.8 562H232V136h302v216a42 42 0 0042 42h216v494zM429 481.2c-1.9-4.4-6.2-7.2-11-7.2h-35c-6.6 0-12 5.4-12 12v272c0 6.6 5.4 12 12 12h27.1c6.6 0 12-5.4 12-12V582.1l66.8 150.2a12 12 0 0011 7.1H524c4.7 0 9-2.8 11-7.1l66.8-150.6V758c0 6.6 5.4 12 12 12H641c6.6 0 12-5.4 12-12V486c0-6.6-5.4-12-12-12h-34.7c-4.8 0-9.1 2.8-11 7.2l-83.1 191-83.2-191z" } }] }, "name": "file-markdown", "theme": "outlined" };
	exports.default = FileMarkdownOutlined;
	});

	var FileMarkdownOutlinedSvg = unwrapExports(FileMarkdownOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FileMarkdownOutlined = function FileMarkdownOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FileMarkdownOutlinedSvg
	  }));
	};

	FileMarkdownOutlined.displayName = 'FileMarkdownOutlined';
	var FileMarkdownOutlined$1 = /*#__PURE__*/React.forwardRef(FileMarkdownOutlined);

	var FileMarkdownTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FileMarkdownTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M534 352V136H232v752h560V394H576a42 42 0 01-42-42zm72.3 122H641c6.6 0 12 5.4 12 12v272c0 6.6-5.4 12-12 12h-27.2c-6.6 0-12-5.4-12-12V581.7L535 732.3c-2 4.3-6.3 7.1-11 7.1h-24.1a12 12 0 01-11-7.1l-66.8-150.2V758c0 6.6-5.4 12-12 12H383c-6.6 0-12-5.4-12-12V486c0-6.6 5.4-12 12-12h35c4.8 0 9.1 2.8 11 7.2l83.2 191 83.1-191c1.9-4.4 6.2-7.2 11-7.2z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM602 137.8L790.2 326H602V137.8zM792 888H232V136h302v216a42 42 0 0042 42h216v494z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M429 481.2c-1.9-4.4-6.2-7.2-11-7.2h-35c-6.6 0-12 5.4-12 12v272c0 6.6 5.4 12 12 12h27.1c6.6 0 12-5.4 12-12V582.1l66.8 150.2a12 12 0 0011 7.1H524c4.7 0 9-2.8 11-7.1l66.8-150.6V758c0 6.6 5.4 12 12 12H641c6.6 0 12-5.4 12-12V486c0-6.6-5.4-12-12-12h-34.7c-4.8 0-9.1 2.8-11 7.2l-83.1 191-83.2-191z", "fill": primaryColor } }] }; }, "name": "file-markdown", "theme": "twotone" };
	exports.default = FileMarkdownTwoTone;
	});

	var FileMarkdownTwoToneSvg = unwrapExports(FileMarkdownTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var FileMarkdownTwoTone = function FileMarkdownTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FileMarkdownTwoToneSvg
	  }));
	};

	FileMarkdownTwoTone.displayName = 'FileMarkdownTwoTone';
	var FileMarkdownTwoTone$1 = /*#__PURE__*/React.forwardRef(FileMarkdownTwoTone);

	var FileOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FileOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM790.2 326H602V137.8L790.2 326zm1.8 562H232V136h302v216a42 42 0 0042 42h216v494z" } }] }, "name": "file", "theme": "outlined" };
	exports.default = FileOutlined;
	});

	var FileOutlinedSvg = unwrapExports(FileOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FileOutlined = function FileOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FileOutlinedSvg
	  }));
	};

	FileOutlined.displayName = 'FileOutlined';
	var FileOutlined$1 = /*#__PURE__*/React.forwardRef(FileOutlined);

	var FilePdfFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FilePdfFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.7c6 6 9.4 14.1 9.4 22.6V928c0 17.7-14.3 32-32 32H192c-17.7 0-32-14.3-32-32V96c0-17.7 14.3-32 32-32h424.7c8.5 0 16.7 3.4 22.7 9.4l215.2 215.3zM790.2 326L602 137.8V326h188.2zM633.22 637.26c-15.18-.5-31.32.67-49.65 2.96-24.3-14.99-40.66-35.58-52.28-65.83l1.07-4.38 1.24-5.18c4.3-18.13 6.61-31.36 7.3-44.7.52-10.07-.04-19.36-1.83-27.97-3.3-18.59-16.45-29.46-33.02-30.13-15.45-.63-29.65 8-33.28 21.37-5.91 21.62-2.45 50.07 10.08 98.59-15.96 38.05-37.05 82.66-51.2 107.54-18.89 9.74-33.6 18.6-45.96 28.42-16.3 12.97-26.48 26.3-29.28 40.3-1.36 6.49.69 14.97 5.36 21.92 5.3 7.88 13.28 13 22.85 13.74 24.15 1.87 53.83-23.03 86.6-79.26 3.29-1.1 6.77-2.26 11.02-3.7l11.9-4.02c7.53-2.54 12.99-4.36 18.39-6.11 23.4-7.62 41.1-12.43 57.2-15.17 27.98 14.98 60.32 24.8 82.1 24.8 17.98 0 30.13-9.32 34.52-23.99 3.85-12.88.8-27.82-7.48-36.08-8.56-8.41-24.3-12.43-45.65-13.12zM385.23 765.68v-.36l.13-.34a54.86 54.86 0 015.6-10.76c4.28-6.58 10.17-13.5 17.47-20.87 3.92-3.95 8-7.8 12.79-12.12 1.07-.96 7.91-7.05 9.19-8.25l11.17-10.4-8.12 12.93c-12.32 19.64-23.46 33.78-33 43-3.51 3.4-6.6 5.9-9.1 7.51a16.43 16.43 0 01-2.61 1.42c-.41.17-.77.27-1.13.3a2.2 2.2 0 01-1.12-.15 2.07 2.07 0 01-1.27-1.91zM511.17 547.4l-2.26 4-1.4-4.38c-3.1-9.83-5.38-24.64-6.01-38-.72-15.2.49-24.32 5.29-24.32 6.74 0 9.83 10.8 10.07 27.05.22 14.28-2.03 29.14-5.7 35.65zm-5.81 58.46l1.53-4.05 2.09 3.8c11.69 21.24 26.86 38.96 43.54 51.31l3.6 2.66-4.39.9c-16.33 3.38-31.54 8.46-52.34 16.85 2.17-.88-21.62 8.86-27.64 11.17l-5.25 2.01 2.8-4.88c12.35-21.5 23.76-47.32 36.05-79.77zm157.62 76.26c-7.86 3.1-24.78.33-54.57-12.39l-7.56-3.22 8.2-.6c23.3-1.73 39.8-.45 49.42 3.07 4.1 1.5 6.83 3.39 8.04 5.55a4.64 4.64 0 01-1.36 6.31 6.7 6.7 0 01-2.17 1.28z" } }] }, "name": "file-pdf", "theme": "filled" };
	exports.default = FilePdfFilled;
	});

	var FilePdfFilledSvg = unwrapExports(FilePdfFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var FilePdfFilled = function FilePdfFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FilePdfFilledSvg
	  }));
	};

	FilePdfFilled.displayName = 'FilePdfFilled';
	var FilePdfFilled$1 = /*#__PURE__*/React.forwardRef(FilePdfFilled);

	var FilePdfOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FilePdfOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M531.3 574.4l.3-1.4c5.8-23.9 13.1-53.7 7.4-80.7-3.8-21.3-19.5-29.6-32.9-30.2-15.8-.7-29.9 8.3-33.4 21.4-6.6 24-.7 56.8 10.1 98.6-13.6 32.4-35.3 79.5-51.2 107.5-29.6 15.3-69.3 38.9-75.2 68.7-1.2 5.5.2 12.5 3.5 18.8 3.7 7 9.6 12.4 16.5 15 3 1.1 6.6 2 10.8 2 17.6 0 46.1-14.2 84.1-79.4 5.8-1.9 11.8-3.9 17.6-5.9 27.2-9.2 55.4-18.8 80.9-23.1 28.2 15.1 60.3 24.8 82.1 24.8 21.6 0 30.1-12.8 33.3-20.5 5.6-13.5 2.9-30.5-6.2-39.6-13.2-13-45.3-16.4-95.3-10.2-24.6-15-40.7-35.4-52.4-65.8zM421.6 726.3c-13.9 20.2-24.4 30.3-30.1 34.7 6.7-12.3 19.8-25.3 30.1-34.7zm87.6-235.5c5.2 8.9 4.5 35.8.5 49.4-4.9-19.9-5.6-48.1-2.7-51.4.8.1 1.5.7 2.2 2zm-1.6 120.5c10.7 18.5 24.2 34.4 39.1 46.2-21.6 4.9-41.3 13-58.9 20.2-4.2 1.7-8.3 3.4-12.3 5 13.3-24.1 24.4-51.4 32.1-71.4zm155.6 65.5c.1.2.2.5-.4.9h-.2l-.2.3c-.8.5-9 5.3-44.3-8.6 40.6-1.9 45 7.3 45.1 7.4zm191.4-388.2L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM790.2 326H602V137.8L790.2 326zm1.8 562H232V136h302v216a42 42 0 0042 42h216v494z" } }] }, "name": "file-pdf", "theme": "outlined" };
	exports.default = FilePdfOutlined;
	});

	var FilePdfOutlinedSvg = unwrapExports(FilePdfOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FilePdfOutlined = function FilePdfOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FilePdfOutlinedSvg
	  }));
	};

	FilePdfOutlined.displayName = 'FilePdfOutlined';
	var FilePdfOutlined$1 = /*#__PURE__*/React.forwardRef(FilePdfOutlined);

	var FilePdfTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FilePdfTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M509.2 490.8c-.7-1.3-1.4-1.9-2.2-2-2.9 3.3-2.2 31.5 2.7 51.4 4-13.6 4.7-40.5-.5-49.4zm-1.6 120.5c-7.7 20-18.8 47.3-32.1 71.4 4-1.6 8.1-3.3 12.3-5 17.6-7.2 37.3-15.3 58.9-20.2-14.9-11.8-28.4-27.7-39.1-46.2z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M534 352V136H232v752h560V394H576a42 42 0 01-42-42zm55 287.6c16.1-1.9 30.6-2.8 44.3-2.3 12.8.4 23.6 2 32 5.1.2.1.3.1.5.2.4.2.8.3 1.2.5.5.2 1.1.4 1.6.7.1.1.3.1.4.2 4.1 1.8 7.5 4 10.1 6.6 9.1 9.1 11.8 26.1 6.2 39.6-3.2 7.7-11.7 20.5-33.3 20.5-21.8 0-53.9-9.7-82.1-24.8-25.5 4.3-53.7 13.9-80.9 23.1-5.8 2-11.8 4-17.6 5.9-38 65.2-66.5 79.4-84.1 79.4-4.2 0-7.8-.9-10.8-2-6.9-2.6-12.8-8-16.5-15-.9-1.7-1.6-3.4-2.2-5.2-1.6-4.8-2.1-9.6-1.3-13.6l.6-2.7c.1-.2.1-.4.2-.6.2-.7.4-1.4.7-2.1 0-.1.1-.2.1-.3 4.1-11.9 13.6-23.4 27.7-34.6 12.3-9.8 27.1-18.7 45.9-28.4 15.9-28 37.6-75.1 51.2-107.4-10.8-41.8-16.7-74.6-10.1-98.6.9-3.3 2.5-6.4 4.6-9.1.2-.2.3-.4.5-.6.1-.1.1-.2.2-.2 6.3-7.5 16.9-11.9 28.1-11.5 16.6.7 29.7 11.5 33 30.1 1.7 8 2.2 16.5 1.9 25.7v.7c0 .5 0 1-.1 1.5-.7 13.3-3 26.6-7.3 44.7-.4 1.6-.8 3.2-1.2 5.2l-1 4.1-.1.3c.1.2.1.3.2.5l1.8 4.5c.1.3.3.7.4 1 .7 1.6 1.4 3.3 2.1 4.8v.1c8.7 18.8 19.7 33.4 33.9 45.1 4.3 3.5 8.9 6.7 13.9 9.8 1.8-.5 3.5-.7 5.3-.9z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M391.5 761c5.7-4.4 16.2-14.5 30.1-34.7-10.3 9.4-23.4 22.4-30.1 34.7zm270.9-83l.2-.3h.2c.6-.4.5-.7.4-.9-.1-.1-4.5-9.3-45.1-7.4 35.3 13.9 43.5 9.1 44.3 8.6z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM602 137.8L790.2 326H602V137.8zM792 888H232V136h302v216a42 42 0 0042 42h216v494z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M535.9 585.3c-.8-1.7-1.5-3.3-2.2-4.9-.1-.3-.3-.7-.4-1l-1.8-4.5c-.1-.2-.1-.3-.2-.5l.1-.3.2-1.1c4-16.3 8.6-35.3 9.4-54.4v-.7c.3-8.6-.2-17.2-2-25.6-3.8-21.3-19.5-29.6-32.9-30.2-11.3-.5-21.8 4-28.1 11.4-.1.1-.1.2-.2.2-.2.2-.4.4-.5.6-2.1 2.7-3.7 5.8-4.6 9.1-6.6 24-.7 56.8 10.1 98.6-13.6 32.4-35.3 79.4-51.2 107.4v.1c-27.7 14.3-64.1 35.8-73.6 62.9 0 .1-.1.2-.1.3-.2.7-.5 1.4-.7 2.1-.1.2-.1.4-.2.6-.2.9-.5 1.8-.6 2.7-.9 4-.4 8.8 1.3 13.6.6 1.8 1.3 3.5 2.2 5.2 3.7 7 9.6 12.4 16.5 15 3 1.1 6.6 2 10.8 2 17.6 0 46.1-14.2 84.1-79.4 5.8-1.9 11.8-3.9 17.6-5.9 27.2-9.2 55.4-18.8 80.9-23.1 28.2 15.1 60.3 24.8 82.1 24.8 21.6 0 30.1-12.8 33.3-20.5 5.6-13.5 2.9-30.5-6.2-39.6-2.6-2.6-6-4.8-10.1-6.6-.1-.1-.3-.1-.4-.2-.5-.2-1.1-.4-1.6-.7-.4-.2-.8-.3-1.2-.5-.2-.1-.3-.1-.5-.2-16.2-5.8-41.7-6.7-76.3-2.8l-5.3.6c-5-3-9.6-6.3-13.9-9.8-14.2-11.3-25.1-25.8-33.8-44.7zM391.5 761c6.7-12.3 19.8-25.3 30.1-34.7-13.9 20.2-24.4 30.3-30.1 34.7zM507 488.8c.8.1 1.5.7 2.2 2 5.2 8.9 4.5 35.8.5 49.4-4.9-19.9-5.6-48.1-2.7-51.4zm-19.2 188.9c-4.2 1.7-8.3 3.4-12.3 5 13.3-24.1 24.4-51.4 32.1-71.4 10.7 18.5 24.2 34.4 39.1 46.2-21.6 4.9-41.3 13-58.9 20.2zm175.4-.9c.1.2.2.5-.4.9h-.2l-.2.3c-.8.5-9 5.3-44.3-8.6 40.6-1.9 45 7.3 45.1 7.4z", "fill": primaryColor } }] }; }, "name": "file-pdf", "theme": "twotone" };
	exports.default = FilePdfTwoTone;
	});

	var FilePdfTwoToneSvg = unwrapExports(FilePdfTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var FilePdfTwoTone = function FilePdfTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FilePdfTwoToneSvg
	  }));
	};

	FilePdfTwoTone.displayName = 'FilePdfTwoTone';
	var FilePdfTwoTone$1 = /*#__PURE__*/React.forwardRef(FilePdfTwoTone);

	var FilePptFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FilePptFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.7c6 6 9.4 14.1 9.4 22.6V928c0 17.7-14.3 32-32 32H192c-17.7 0-32-14.3-32-32V96c0-17.7 14.3-32 32-32h424.7c8.5 0 16.7 3.4 22.7 9.4l215.2 215.3zM790.2 326L602 137.8V326h188.2zM468.53 760v-91.54h59.27c60.57 0 100.2-39.65 100.2-98.12 0-58.22-39.58-98.34-99.98-98.34H424a12 12 0 00-12 12v276a12 12 0 0012 12h32.53a12 12 0 0012-12zm0-139.33h34.9c47.82 0 67.19-12.93 67.19-50.33 0-32.05-18.12-50.12-49.87-50.12h-52.22v100.45z" } }] }, "name": "file-ppt", "theme": "filled" };
	exports.default = FilePptFilled;
	});

	var FilePptFilledSvg = unwrapExports(FilePptFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var FilePptFilled = function FilePptFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FilePptFilledSvg
	  }));
	};

	FilePptFilled.displayName = 'FilePptFilled';
	var FilePptFilled$1 = /*#__PURE__*/React.forwardRef(FilePptFilled);

	var FilePptOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FilePptOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M424 476c-4.4 0-8 3.6-8 8v276c0 4.4 3.6 8 8 8h32.5c4.4 0 8-3.6 8-8v-95.5h63.3c59.4 0 96.2-38.9 96.2-94.1 0-54.5-36.3-94.3-96-94.3H424zm150.6 94.3c0 43.4-26.5 54.3-71.2 54.3h-38.9V516.2h56.2c33.8 0 53.9 19.7 53.9 54.1zm280-281.7L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM790.2 326H602V137.8L790.2 326zm1.8 562H232V136h302v216a42 42 0 0042 42h216v494z" } }] }, "name": "file-ppt", "theme": "outlined" };
	exports.default = FilePptOutlined;
	});

	var FilePptOutlinedSvg = unwrapExports(FilePptOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FilePptOutlined = function FilePptOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FilePptOutlinedSvg
	  }));
	};

	FilePptOutlined.displayName = 'FilePptOutlined';
	var FilePptOutlined$1 = /*#__PURE__*/React.forwardRef(FilePptOutlined);

	var FilePptTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FilePptTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M464.5 516.2v108.4h38.9c44.7 0 71.2-10.9 71.2-54.3 0-34.4-20.1-54.1-53.9-54.1h-56.2z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M534 352V136H232v752h560V394H576a42 42 0 01-42-42zm90 218.4c0 55.2-36.8 94.1-96.2 94.1h-63.3V760c0 4.4-3.6 8-8 8H424c-4.4 0-8-3.6-8-8V484c0-4.4 3.6-8 8-8v.1h104c59.7 0 96 39.8 96 94.3z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM602 137.8L790.2 326H602V137.8zM792 888H232V136h302v216a42 42 0 0042 42h216v494z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M424 476.1c-4.4-.1-8 3.5-8 7.9v276c0 4.4 3.6 8 8 8h32.5c4.4 0 8-3.6 8-8v-95.5h63.3c59.4 0 96.2-38.9 96.2-94.1 0-54.5-36.3-94.3-96-94.3H424zm150.6 94.2c0 43.4-26.5 54.3-71.2 54.3h-38.9V516.2h56.2c33.8 0 53.9 19.7 53.9 54.1z", "fill": primaryColor } }] }; }, "name": "file-ppt", "theme": "twotone" };
	exports.default = FilePptTwoTone;
	});

	var FilePptTwoToneSvg = unwrapExports(FilePptTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var FilePptTwoTone = function FilePptTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FilePptTwoToneSvg
	  }));
	};

	FilePptTwoTone.displayName = 'FilePptTwoTone';
	var FilePptTwoTone$1 = /*#__PURE__*/React.forwardRef(FilePptTwoTone);

	var FileProtectOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FileProtectOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M644.7 669.2a7.92 7.92 0 00-6.5-3.3H594c-6.5 0-10.3 7.4-6.5 12.7l73.8 102.1c3.2 4.4 9.7 4.4 12.9 0l114.2-158c3.8-5.3 0-12.7-6.5-12.7h-44.3c-2.6 0-5 1.2-6.5 3.3l-63.5 87.8-22.9-31.9zM688 306v-48c0-4.4-3.6-8-8-8H296c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h384c4.4 0 8-3.6 8-8zm-392 88c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h184c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H296zm184 458H208V148h560v296c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V108c0-17.7-14.3-32-32-32H168c-17.7 0-32 14.3-32 32v784c0 17.7 14.3 32 32 32h312c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm402.6-320.8l-192-66.7c-.9-.3-1.7-.4-2.6-.4s-1.8.1-2.6.4l-192 66.7a7.96 7.96 0 00-5.4 7.5v251.1c0 2.5 1.1 4.8 3.1 6.3l192 150.2c1.4 1.1 3.2 1.7 4.9 1.7s3.5-.6 4.9-1.7l192-150.2c1.9-1.5 3.1-3.8 3.1-6.3V538.7c0-3.4-2.2-6.4-5.4-7.5zM826 763.7L688 871.6 550 763.7V577l138-48 138 48v186.7z" } }] }, "name": "file-protect", "theme": "outlined" };
	exports.default = FileProtectOutlined;
	});

	var FileProtectOutlinedSvg = unwrapExports(FileProtectOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FileProtectOutlined = function FileProtectOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FileProtectOutlinedSvg
	  }));
	};

	FileProtectOutlined.displayName = 'FileProtectOutlined';
	var FileProtectOutlined$1 = /*#__PURE__*/React.forwardRef(FileProtectOutlined);

	var FileSearchOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FileSearchOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M688 312v-48c0-4.4-3.6-8-8-8H296c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h384c4.4 0 8-3.6 8-8zm-392 88c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h184c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H296zm144 452H208V148h560v344c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V108c0-17.7-14.3-32-32-32H168c-17.7 0-32 14.3-32 32v784c0 17.7 14.3 32 32 32h272c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm445.7 51.5l-93.3-93.3C814.7 780.7 828 743.9 828 704c0-97.2-78.8-176-176-176s-176 78.8-176 176 78.8 176 176 176c35.8 0 69-10.7 96.8-29l94.7 94.7c1.6 1.6 3.6 2.3 5.6 2.3s4.1-.8 5.6-2.3l31-31a7.9 7.9 0 000-11.2zM652 816c-61.9 0-112-50.1-112-112s50.1-112 112-112 112 50.1 112 112-50.1 112-112 112z" } }] }, "name": "file-search", "theme": "outlined" };
	exports.default = FileSearchOutlined;
	});

	var FileSearchOutlinedSvg = unwrapExports(FileSearchOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FileSearchOutlined = function FileSearchOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FileSearchOutlinedSvg
	  }));
	};

	FileSearchOutlined.displayName = 'FileSearchOutlined';
	var FileSearchOutlined$1 = /*#__PURE__*/React.forwardRef(FileSearchOutlined);

	var FileSyncOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FileSyncOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M296 256c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h384c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H296zm192 200v-48c0-4.4-3.6-8-8-8H296c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h184c4.4 0 8-3.6 8-8zm-48 396H208V148h560v344c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V108c0-17.7-14.3-32-32-32H168c-17.7 0-32 14.3-32 32v784c0 17.7 14.3 32 32 32h272c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm104.1-115.6c1.8-34.5 16.2-66.8 40.8-91.4 26.2-26.2 62-41 99.1-41 37.4 0 72.6 14.6 99.1 41 3.2 3.2 6.3 6.6 9.2 10.1L769.2 673a8 8 0 003 14.1l93.3 22.5c5 1.2 9.8-2.6 9.9-7.7l.6-95.4a8 8 0 00-12.9-6.4l-20.3 15.8C805.4 569.6 748.1 540 684 540c-109.9 0-199.6 86.9-204 195.7-.2 4.5 3.5 8.3 8 8.3h48.1c4.3 0 7.8-3.3 8-7.6zM880 744h-48.1c-4.3 0-7.8 3.3-8 7.6-1.8 34.5-16.2 66.8-40.8 91.4-26.2 26.2-62 41-99.1 41-37.4 0-72.6-14.6-99.1-41-3.2-3.2-6.3-6.6-9.2-10.1l23.1-17.9a8 8 0 00-3-14.1l-93.3-22.5c-5-1.2-9.8 2.6-9.9 7.7l-.6 95.4a8 8 0 0012.9 6.4l20.3-15.8C562.6 918.4 619.9 948 684 948c109.9 0 199.6-86.9 204-195.7.2-4.5-3.5-8.3-8-8.3z" } }] }, "name": "file-sync", "theme": "outlined" };
	exports.default = FileSyncOutlined;
	});

	var FileSyncOutlinedSvg = unwrapExports(FileSyncOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FileSyncOutlined = function FileSyncOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FileSyncOutlinedSvg
	  }));
	};

	FileSyncOutlined.displayName = 'FileSyncOutlined';
	var FileSyncOutlined$1 = /*#__PURE__*/React.forwardRef(FileSyncOutlined);

	var FileTextFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FileTextFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.7c6 6 9.4 14.1 9.4 22.6V928c0 17.7-14.3 32-32 32H192c-17.7 0-32-14.3-32-32V96c0-17.7 14.3-32 32-32h424.7c8.5 0 16.7 3.4 22.7 9.4l215.2 215.3zM790.2 326L602 137.8V326h188.2zM320 482a8 8 0 00-8 8v48a8 8 0 008 8h384a8 8 0 008-8v-48a8 8 0 00-8-8H320zm0 136a8 8 0 00-8 8v48a8 8 0 008 8h184a8 8 0 008-8v-48a8 8 0 00-8-8H320z" } }] }, "name": "file-text", "theme": "filled" };
	exports.default = FileTextFilled;
	});

	var FileTextFilledSvg = unwrapExports(FileTextFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var FileTextFilled = function FileTextFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FileTextFilledSvg
	  }));
	};

	FileTextFilled.displayName = 'FileTextFilled';
	var FileTextFilled$1 = /*#__PURE__*/React.forwardRef(FileTextFilled);

	var FileTextOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FileTextOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM790.2 326H602V137.8L790.2 326zm1.8 562H232V136h302v216a42 42 0 0042 42h216v494zM504 618H320c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h184c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8zM312 490v48c0 4.4 3.6 8 8 8h384c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H320c-4.4 0-8 3.6-8 8z" } }] }, "name": "file-text", "theme": "outlined" };
	exports.default = FileTextOutlined;
	});

	var FileTextOutlinedSvg = unwrapExports(FileTextOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FileTextOutlined = function FileTextOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FileTextOutlinedSvg
	  }));
	};

	FileTextOutlined.displayName = 'FileTextOutlined';
	var FileTextOutlined$1 = /*#__PURE__*/React.forwardRef(FileTextOutlined);

	var FileTextTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FileTextTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M534 352V136H232v752h560V394H576a42 42 0 01-42-42zm-22 322c0 4.4-3.6 8-8 8H320c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h184c4.4 0 8 3.6 8 8v48zm200-184v48c0 4.4-3.6 8-8 8H320c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h384c4.4 0 8 3.6 8 8z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM602 137.8L790.2 326H602V137.8zM792 888H232V136h302v216a42 42 0 0042 42h216v494z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M312 490v48c0 4.4 3.6 8 8 8h384c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H320c-4.4 0-8 3.6-8 8zm192 128H320c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h184c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8z", "fill": primaryColor } }] }; }, "name": "file-text", "theme": "twotone" };
	exports.default = FileTextTwoTone;
	});

	var FileTextTwoToneSvg = unwrapExports(FileTextTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var FileTextTwoTone = function FileTextTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FileTextTwoToneSvg
	  }));
	};

	FileTextTwoTone.displayName = 'FileTextTwoTone';
	var FileTextTwoTone$1 = /*#__PURE__*/React.forwardRef(FileTextTwoTone);

	var FileTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FileTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M534 352V136H232v752h560V394H576a42 42 0 01-42-42z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM602 137.8L790.2 326H602V137.8zM792 888H232V136h302v216a42 42 0 0042 42h216v494z", "fill": primaryColor } }] }; }, "name": "file", "theme": "twotone" };
	exports.default = FileTwoTone;
	});

	var FileTwoToneSvg = unwrapExports(FileTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var FileTwoTone = function FileTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FileTwoToneSvg
	  }));
	};

	FileTwoTone.displayName = 'FileTwoTone';
	var FileTwoTone$1 = /*#__PURE__*/React.forwardRef(FileTwoTone);

	var FileUnknownFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FileUnknownFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.7c6 6 9.4 14.1 9.4 22.6V928c0 17.7-14.3 32-32 32H192c-17.7 0-32-14.3-32-32V96c0-17.7 14.3-32 32-32h424.7c8.5 0 16.7 3.4 22.7 9.4l215.2 215.3zM790.2 326L602 137.8V326h188.2zM402 549c0 5.4 4.4 9.5 9.8 9.5h32.4c5.4 0 9.8-4.2 9.8-9.4 0-28.2 25.8-51.6 58-51.6s58 23.4 58 51.5c0 25.3-21 47.2-49.3 50.9-19.3 2.8-34.5 20.3-34.7 40.1v32c0 5.5 4.5 10 10 10h32c5.5 0 10-4.5 10-10v-12.2c0-6 4-11.5 9.7-13.3 44.6-14.4 75-54 74.3-98.9-.8-55.5-49.2-100.8-108.5-101.6-61.4-.7-111.5 45.6-111.5 103zm110 227a32 32 0 100-64 32 32 0 000 64z" } }] }, "name": "file-unknown", "theme": "filled" };
	exports.default = FileUnknownFilled;
	});

	var FileUnknownFilledSvg = unwrapExports(FileUnknownFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var FileUnknownFilled = function FileUnknownFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FileUnknownFilledSvg
	  }));
	};

	FileUnknownFilled.displayName = 'FileUnknownFilled';
	var FileUnknownFilled$1 = /*#__PURE__*/React.forwardRef(FileUnknownFilled);

	var FileUnknownOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FileUnknownOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.7L639.4 73.4c-6-6-14.2-9.4-22.7-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.6-9.4-22.6zM790.2 326H602V137.8L790.2 326zm1.8 562H232V136h302v216a42 42 0 0042 42h216v494zM402 549c0 5.4 4.4 9.5 9.8 9.5h32.4c5.4 0 9.8-4.2 9.8-9.4 0-28.2 25.8-51.6 58-51.6s58 23.4 58 51.5c0 25.3-21 47.2-49.3 50.9-19.3 2.8-34.5 20.3-34.7 40.1v32c0 5.5 4.5 10 10 10h32c5.5 0 10-4.5 10-10v-12.2c0-6 4-11.5 9.7-13.3 44.6-14.4 75-54 74.3-98.9-.8-55.5-49.2-100.8-108.5-101.6-61.4-.7-111.5 45.6-111.5 103zm78 195a32 32 0 1064 0 32 32 0 10-64 0z" } }] }, "name": "file-unknown", "theme": "outlined" };
	exports.default = FileUnknownOutlined;
	});

	var FileUnknownOutlinedSvg = unwrapExports(FileUnknownOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FileUnknownOutlined = function FileUnknownOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FileUnknownOutlinedSvg
	  }));
	};

	FileUnknownOutlined.displayName = 'FileUnknownOutlined';
	var FileUnknownOutlined$1 = /*#__PURE__*/React.forwardRef(FileUnknownOutlined);

	var FileUnknownTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FileUnknownTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M534 352V136H232v752h560V394H576a42 42 0 01-42-42zm-22 424c-17.7 0-32-14.3-32-32s14.3-32 32-32 32 14.3 32 32-14.3 32-32 32zm110-228.4c.7 44.9-29.7 84.5-74.3 98.9-5.7 1.8-9.7 7.3-9.7 13.3V672c0 5.5-4.5 10-10 10h-32c-5.5 0-10-4.5-10-10v-32c.2-19.8 15.4-37.3 34.7-40.1C549 596.2 570 574.3 570 549c0-28.1-25.8-51.5-58-51.5s-58 23.4-58 51.6c0 5.2-4.4 9.4-9.8 9.4h-32.4c-5.4 0-9.8-4.1-9.8-9.5 0-57.4 50.1-103.7 111.5-103 59.3.8 107.7 46.1 108.5 101.6z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M854.6 288.7L639.4 73.4c-6-6-14.2-9.4-22.7-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.6-9.4-22.6zM602 137.8L790.2 326H602V137.8zM792 888H232V136h302v216a42 42 0 0042 42h216v494z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M480 744a32 32 0 1064 0 32 32 0 10-64 0zm-78-195c0 5.4 4.4 9.5 9.8 9.5h32.4c5.4 0 9.8-4.2 9.8-9.4 0-28.2 25.8-51.6 58-51.6s58 23.4 58 51.5c0 25.3-21 47.2-49.3 50.9-19.3 2.8-34.5 20.3-34.7 40.1v32c0 5.5 4.5 10 10 10h32c5.5 0 10-4.5 10-10v-12.2c0-6 4-11.5 9.7-13.3 44.6-14.4 75-54 74.3-98.9-.8-55.5-49.2-100.8-108.5-101.6-61.4-.7-111.5 45.6-111.5 103z", "fill": primaryColor } }] }; }, "name": "file-unknown", "theme": "twotone" };
	exports.default = FileUnknownTwoTone;
	});

	var FileUnknownTwoToneSvg = unwrapExports(FileUnknownTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var FileUnknownTwoTone = function FileUnknownTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FileUnknownTwoToneSvg
	  }));
	};

	FileUnknownTwoTone.displayName = 'FileUnknownTwoTone';
	var FileUnknownTwoTone$1 = /*#__PURE__*/React.forwardRef(FileUnknownTwoTone);

	var FileWordFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FileWordFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.7c6 6 9.4 14.1 9.4 22.6V928c0 17.7-14.3 32-32 32H192c-17.7 0-32-14.3-32-32V96c0-17.7 14.3-32 32-32h424.7c8.5 0 16.7 3.4 22.7 9.4l215.2 215.3zM790.2 326L602 137.8V326h188.2zM512 566.1l52.81 197a12 12 0 0011.6 8.9h31.77a12 12 0 0011.6-8.88l74.37-276a12 12 0 00.4-3.12 12 12 0 00-12-12h-35.57a12 12 0 00-11.7 9.31l-45.78 199.1-49.76-199.32A12 12 0 00528.1 472h-32.2a12 12 0 00-11.64 9.1L434.6 680.01 388.5 481.3a12 12 0 00-11.68-9.29h-35.39a12 12 0 00-3.11.41 12 12 0 00-8.47 14.7l74.17 276A12 12 0 00415.6 772h31.99a12 12 0 0011.59-8.9l52.81-197z" } }] }, "name": "file-word", "theme": "filled" };
	exports.default = FileWordFilled;
	});

	var FileWordFilledSvg = unwrapExports(FileWordFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var FileWordFilled = function FileWordFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FileWordFilledSvg
	  }));
	};

	FileWordFilled.displayName = 'FileWordFilled';
	var FileWordFilled$1 = /*#__PURE__*/React.forwardRef(FileWordFilled);

	var FileWordOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FileWordOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM790.2 326H602V137.8L790.2 326zm1.8 562H232V136h302v216a42 42 0 0042 42h216v494zM528.1 472h-32.2c-5.5 0-10.3 3.7-11.6 9.1L434.6 680l-46.1-198.7c-1.3-5.4-6.1-9.3-11.7-9.3h-35.4a12.02 12.02 0 00-11.6 15.1l74.2 276c1.4 5.2 6.2 8.9 11.6 8.9h32c5.4 0 10.2-3.6 11.6-8.9l52.8-197 52.8 197c1.4 5.2 6.2 8.9 11.6 8.9h31.8c5.4 0 10.2-3.6 11.6-8.9l74.4-276a12.04 12.04 0 00-11.6-15.1H647c-5.6 0-10.4 3.9-11.7 9.3l-45.8 199.1-49.8-199.3c-1.3-5.4-6.1-9.1-11.6-9.1z" } }] }, "name": "file-word", "theme": "outlined" };
	exports.default = FileWordOutlined;
	});

	var FileWordOutlinedSvg = unwrapExports(FileWordOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FileWordOutlined = function FileWordOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FileWordOutlinedSvg
	  }));
	};

	FileWordOutlined.displayName = 'FileWordOutlined';
	var FileWordOutlined$1 = /*#__PURE__*/React.forwardRef(FileWordOutlined);

	var FileWordTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FileWordTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M534 352V136H232v752h560V394H576a42 42 0 01-42-42zm101.3 129.3c1.3-5.4 6.1-9.3 11.7-9.3h35.6a12.04 12.04 0 0111.6 15.1l-74.4 276c-1.4 5.3-6.2 8.9-11.6 8.9h-31.8c-5.4 0-10.2-3.7-11.6-8.9l-52.8-197-52.8 197c-1.4 5.3-6.2 8.9-11.6 8.9h-32c-5.4 0-10.2-3.7-11.6-8.9l-74.2-276a12.02 12.02 0 0111.6-15.1h35.4c5.6 0 10.4 3.9 11.7 9.3L434.6 680l49.7-198.9c1.3-5.4 6.1-9.1 11.6-9.1h32.2c5.5 0 10.3 3.7 11.6 9.1l49.8 199.3 45.8-199.1z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM602 137.8L790.2 326H602V137.8zM792 888H232V136h302v216a42 42 0 0042 42h216v494z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M528.1 472h-32.2c-5.5 0-10.3 3.7-11.6 9.1L434.6 680l-46.1-198.7c-1.3-5.4-6.1-9.3-11.7-9.3h-35.4a12.02 12.02 0 00-11.6 15.1l74.2 276c1.4 5.2 6.2 8.9 11.6 8.9h32c5.4 0 10.2-3.6 11.6-8.9l52.8-197 52.8 197c1.4 5.2 6.2 8.9 11.6 8.9h31.8c5.4 0 10.2-3.6 11.6-8.9l74.4-276a12.04 12.04 0 00-11.6-15.1H647c-5.6 0-10.4 3.9-11.7 9.3l-45.8 199.1-49.8-199.3c-1.3-5.4-6.1-9.1-11.6-9.1z", "fill": primaryColor } }] }; }, "name": "file-word", "theme": "twotone" };
	exports.default = FileWordTwoTone;
	});

	var FileWordTwoToneSvg = unwrapExports(FileWordTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var FileWordTwoTone = function FileWordTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FileWordTwoToneSvg
	  }));
	};

	FileWordTwoTone.displayName = 'FileWordTwoTone';
	var FileWordTwoTone$1 = /*#__PURE__*/React.forwardRef(FileWordTwoTone);

	var FileZipFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FileZipFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.7c6 6 9.4 14.1 9.4 22.6V928c0 17.7-14.3 32-32 32H192c-17.7 0-32-14.3-32-32V96c0-17.7 14.3-32 32-32h424.7c8.5 0 16.7 3.4 22.7 9.4l215.2 215.3zM790.2 326L602 137.8V326h188.2zM296 136v64h64v-64h-64zm64 64v64h64v-64h-64zm-64 64v64h64v-64h-64zm64 64v64h64v-64h-64zm-64 64v64h64v-64h-64zm64 64v64h64v-64h-64zm-64 64v64h64v-64h-64zm0 64v160h128V584H296zm48 48h32v64h-32v-64z" } }] }, "name": "file-zip", "theme": "filled" };
	exports.default = FileZipFilled;
	});

	var FileZipFilledSvg = unwrapExports(FileZipFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var FileZipFilled = function FileZipFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FileZipFilledSvg
	  }));
	};

	FileZipFilled.displayName = 'FileZipFilled';
	var FileZipFilled$1 = /*#__PURE__*/React.forwardRef(FileZipFilled);

	var FileZipOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FileZipOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M296 392h64v64h-64zm0 190v160h128V582h-64v-62h-64v62zm80 48v64h-32v-64h32zm-16-302h64v64h-64zm-64-64h64v64h-64zm64 192h64v64h-64zm0-256h64v64h-64zm494.6 88.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM790.2 326H602V137.8L790.2 326zm1.8 562H232V136h64v64h64v-64h174v216a42 42 0 0042 42h216v494z" } }] }, "name": "file-zip", "theme": "outlined" };
	exports.default = FileZipOutlined;
	});

	var FileZipOutlinedSvg = unwrapExports(FileZipOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FileZipOutlined = function FileZipOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FileZipOutlinedSvg
	  }));
	};

	FileZipOutlined.displayName = 'FileZipOutlined';
	var FileZipOutlined$1 = /*#__PURE__*/React.forwardRef(FileZipOutlined);

	var FileZipTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FileZipTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M344 630h32v2h-32z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M534 352V136H360v64h64v64h-64v64h64v64h-64v64h64v64h-64v62h64v160H296V520h64v-64h-64v-64h64v-64h-64v-64h64v-64h-64v-64h-64v752h560V394H576a42 42 0 01-42-42z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM602 137.8L790.2 326H602V137.8zM792 888H232V136h64v64h64v-64h174v216a42 42 0 0042 42h216v494z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M296 392h64v64h-64zm0-128h64v64h-64zm0 318v160h128V582h-64v-62h-64v62zm48 50v-2h32v64h-32v-62zm16-432h64v64h-64zm0 256h64v64h-64zm0-128h64v64h-64z", "fill": primaryColor } }] }; }, "name": "file-zip", "theme": "twotone" };
	exports.default = FileZipTwoTone;
	});

	var FileZipTwoToneSvg = unwrapExports(FileZipTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var FileZipTwoTone = function FileZipTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FileZipTwoToneSvg
	  }));
	};

	FileZipTwoTone.displayName = 'FileZipTwoTone';
	var FileZipTwoTone$1 = /*#__PURE__*/React.forwardRef(FileZipTwoTone);

	var FilterFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FilterFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M349 838c0 17.7 14.2 32 31.8 32h262.4c17.6 0 31.8-14.3 31.8-32V642H349v196zm531.1-684H143.9c-24.5 0-39.8 26.7-27.5 48l221.3 376h348.8l221.3-376c12.1-21.3-3.2-48-27.7-48z" } }] }, "name": "filter", "theme": "filled" };
	exports.default = FilterFilled;
	});

	var FilterFilledSvg = unwrapExports(FilterFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var FilterFilled = function FilterFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FilterFilledSvg
	  }));
	};

	FilterFilled.displayName = 'FilterFilled';
	var FilterFilled$1 = /*#__PURE__*/React.forwardRef(FilterFilled);

	var FilterOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FilterOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880.1 154H143.9c-24.5 0-39.8 26.7-27.5 48L349 597.4V838c0 17.7 14.2 32 31.8 32h262.4c17.6 0 31.8-14.3 31.8-32V597.4L907.7 202c12.2-21.3-3.1-48-27.6-48zM603.4 798H420.6V642h182.9v156zm9.6-236.6l-9.5 16.6h-183l-9.5-16.6L212.7 226h598.6L613 561.4z" } }] }, "name": "filter", "theme": "outlined" };
	exports.default = FilterOutlined;
	});

	var FilterOutlinedSvg = unwrapExports(FilterOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FilterOutlined = function FilterOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FilterOutlinedSvg
	  }));
	};

	FilterOutlined.displayName = 'FilterOutlined';
	var FilterOutlined$1 = /*#__PURE__*/React.forwardRef(FilterOutlined);

	var FilterTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FilterTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M420.6 798h182.9V642H420.6zM411 561.4l9.5 16.6h183l9.5-16.6L811.3 226H212.7z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M880.1 154H143.9c-24.5 0-39.8 26.7-27.5 48L349 597.4V838c0 17.7 14.2 32 31.8 32h262.4c17.6 0 31.8-14.3 31.8-32V597.4L907.7 202c12.2-21.3-3.1-48-27.6-48zM603.5 798H420.6V642h182.9v156zm9.5-236.6l-9.5 16.6h-183l-9.5-16.6L212.7 226h598.6L613 561.4z", "fill": primaryColor } }] }; }, "name": "filter", "theme": "twotone" };
	exports.default = FilterTwoTone;
	});

	var FilterTwoToneSvg = unwrapExports(FilterTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var FilterTwoTone = function FilterTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FilterTwoToneSvg
	  }));
	};

	FilterTwoTone.displayName = 'FilterTwoTone';
	var FilterTwoTone$1 = /*#__PURE__*/React.forwardRef(FilterTwoTone);

	var FireFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FireFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M834.1 469.2A347.49 347.49 0 00751.2 354l-29.1-26.7a8.09 8.09 0 00-13 3.3l-13 37.3c-8.1 23.4-23 47.3-44.1 70.8-1.4 1.5-3 1.9-4.1 2-1.1.1-2.8-.1-4.3-1.5-1.4-1.2-2.1-3-2-4.8 3.7-60.2-14.3-128.1-53.7-202C555.3 171 510 123.1 453.4 89.7l-41.3-24.3c-5.4-3.2-12.3 1-12 7.3l2.2 48c1.5 32.8-2.3 61.8-11.3 85.9-11 29.5-26.8 56.9-47 81.5a295.64 295.64 0 01-47.5 46.1 352.6 352.6 0 00-100.3 121.5A347.75 347.75 0 00160 610c0 47.2 9.3 92.9 27.7 136a349.4 349.4 0 0075.5 110.9c32.4 32 70 57.2 111.9 74.7C418.5 949.8 464.5 959 512 959s93.5-9.2 136.9-27.3A348.6 348.6 0 00760.8 857c32.4-32 57.8-69.4 75.5-110.9a344.2 344.2 0 0027.7-136c0-48.8-10-96.2-29.9-140.9z" } }] }, "name": "fire", "theme": "filled" };
	exports.default = FireFilled;
	});

	var FireFilledSvg = unwrapExports(FireFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var FireFilled = function FireFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FireFilledSvg
	  }));
	};

	FireFilled.displayName = 'FireFilled';
	var FireFilled$1 = /*#__PURE__*/React.forwardRef(FireFilled);

	var FireOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FireOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M834.1 469.2A347.49 347.49 0 00751.2 354l-29.1-26.7a8.09 8.09 0 00-13 3.3l-13 37.3c-8.1 23.4-23 47.3-44.1 70.8-1.4 1.5-3 1.9-4.1 2-1.1.1-2.8-.1-4.3-1.5-1.4-1.2-2.1-3-2-4.8 3.7-60.2-14.3-128.1-53.7-202C555.3 171 510 123.1 453.4 89.7l-41.3-24.3c-5.4-3.2-12.3 1-12 7.3l2.2 48c1.5 32.8-2.3 61.8-11.3 85.9-11 29.5-26.8 56.9-47 81.5a295.64 295.64 0 01-47.5 46.1 352.6 352.6 0 00-100.3 121.5A347.75 347.75 0 00160 610c0 47.2 9.3 92.9 27.7 136a349.4 349.4 0 0075.5 110.9c32.4 32 70 57.2 111.9 74.7C418.5 949.8 464.5 959 512 959s93.5-9.2 136.9-27.3A348.6 348.6 0 00760.8 857c32.4-32 57.8-69.4 75.5-110.9a344.2 344.2 0 0027.7-136c0-48.8-10-96.2-29.9-140.9zM713 808.5c-53.7 53.2-125 82.4-201 82.4s-147.3-29.2-201-82.4c-53.5-53.1-83-123.5-83-198.4 0-43.5 9.8-85.2 29.1-124 18.8-37.9 46.8-71.8 80.8-97.9a349.6 349.6 0 0058.6-56.8c25-30.5 44.6-64.5 58.2-101a240 240 0 0012.1-46.5c24.1 22.2 44.3 49 61.2 80.4 33.4 62.6 48.8 118.3 45.8 165.7a74.01 74.01 0 0024.4 59.8 73.36 73.36 0 0053.4 18.8c19.7-1 37.8-9.7 51-24.4 13.3-14.9 24.8-30.1 34.4-45.6 14 17.9 25.7 37.4 35 58.4 15.9 35.8 24 73.9 24 113.1 0 74.9-29.5 145.4-83 198.4z" } }] }, "name": "fire", "theme": "outlined" };
	exports.default = FireOutlined;
	});

	var FireOutlinedSvg = unwrapExports(FireOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FireOutlined = function FireOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FireOutlinedSvg
	  }));
	};

	FireOutlined.displayName = 'FireOutlined';
	var FireOutlined$1 = /*#__PURE__*/React.forwardRef(FireOutlined);

	var FireTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FireTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M737 438.6c-9.6 15.5-21.1 30.7-34.4 45.6a73.1 73.1 0 01-51 24.4 73.36 73.36 0 01-53.4-18.8 74.01 74.01 0 01-24.4-59.8c3-47.4-12.4-103.1-45.8-165.7-16.9-31.4-37.1-58.2-61.2-80.4a240 240 0 01-12.1 46.5 354.26 354.26 0 01-58.2 101 349.6 349.6 0 01-58.6 56.8c-34 26.1-62 60-80.8 97.9a275.96 275.96 0 00-29.1 124c0 74.9 29.5 145.3 83 198.4 53.7 53.2 125 82.4 201 82.4s147.3-29.2 201-82.4c53.5-53 83-123.5 83-198.4 0-39.2-8.1-77.3-24-113.1-9.3-21-21-40.5-35-58.4z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M834.1 469.2A347.49 347.49 0 00751.2 354l-29.1-26.7a8.09 8.09 0 00-13 3.3l-13 37.3c-8.1 23.4-23 47.3-44.1 70.8-1.4 1.5-3 1.9-4.1 2-1.1.1-2.8-.1-4.3-1.5-1.4-1.2-2.1-3-2-4.8 3.7-60.2-14.3-128.1-53.7-202C555.3 171 510 123.1 453.4 89.7l-41.3-24.3c-5.4-3.2-12.3 1-12 7.3l2.2 48c1.5 32.8-2.3 61.8-11.3 85.9-11 29.5-26.8 56.9-47 81.5a295.64 295.64 0 01-47.5 46.1 352.6 352.6 0 00-100.3 121.5A347.75 347.75 0 00160 610c0 47.2 9.3 92.9 27.7 136a349.4 349.4 0 0075.5 110.9c32.4 32 70 57.2 111.9 74.7C418.5 949.8 464.5 959 512 959s93.5-9.2 136.9-27.3A348.6 348.6 0 00760.8 857c32.4-32 57.8-69.4 75.5-110.9a344.2 344.2 0 0027.7-136c0-48.8-10-96.2-29.9-140.9zM713 808.5c-53.7 53.2-125 82.4-201 82.4s-147.3-29.2-201-82.4c-53.5-53.1-83-123.5-83-198.4 0-43.5 9.8-85.2 29.1-124 18.8-37.9 46.8-71.8 80.8-97.9a349.6 349.6 0 0058.6-56.8c25-30.5 44.6-64.5 58.2-101a240 240 0 0012.1-46.5c24.1 22.2 44.3 49 61.2 80.4 33.4 62.6 48.8 118.3 45.8 165.7a74.01 74.01 0 0024.4 59.8 73.36 73.36 0 0053.4 18.8c19.7-1 37.8-9.7 51-24.4 13.3-14.9 24.8-30.1 34.4-45.6 14 17.9 25.7 37.4 35 58.4 15.9 35.8 24 73.9 24 113.1 0 74.9-29.5 145.4-83 198.4z", "fill": primaryColor } }] }; }, "name": "fire", "theme": "twotone" };
	exports.default = FireTwoTone;
	});

	var FireTwoToneSvg = unwrapExports(FireTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var FireTwoTone = function FireTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FireTwoToneSvg
	  }));
	};

	FireTwoTone.displayName = 'FireTwoTone';
	var FireTwoTone$1 = /*#__PURE__*/React.forwardRef(FireTwoTone);

	var FlagFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FlagFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 305H624V192c0-17.7-14.3-32-32-32H184v-40c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v784c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V640h248v113c0 17.7 14.3 32 32 32h416c17.7 0 32-14.3 32-32V337c0-17.7-14.3-32-32-32z" } }] }, "name": "flag", "theme": "filled" };
	exports.default = FlagFilled;
	});

	var FlagFilledSvg = unwrapExports(FlagFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var FlagFilled = function FlagFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FlagFilledSvg
	  }));
	};

	FlagFilled.displayName = 'FlagFilled';
	var FlagFilled$1 = /*#__PURE__*/React.forwardRef(FlagFilled);

	var FlagOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FlagOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 305H624V192c0-17.7-14.3-32-32-32H184v-40c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v784c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V640h248v113c0 17.7 14.3 32 32 32h416c17.7 0 32-14.3 32-32V337c0-17.7-14.3-32-32-32zM184 568V232h368v336H184zm656 145H504v-73h112c4.4 0 8-3.6 8-8V377h216v336z" } }] }, "name": "flag", "theme": "outlined" };
	exports.default = FlagOutlined;
	});

	var FlagOutlinedSvg = unwrapExports(FlagOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FlagOutlined = function FlagOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FlagOutlinedSvg
	  }));
	};

	FlagOutlined.displayName = 'FlagOutlined';
	var FlagOutlined$1 = /*#__PURE__*/React.forwardRef(FlagOutlined);

	var FlagTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FlagTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M184 232h368v336H184z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M624 632c0 4.4-3.6 8-8 8H504v73h336V377H624v255z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M880 305H624V192c0-17.7-14.3-32-32-32H184v-40c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v784c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V640h248v113c0 17.7 14.3 32 32 32h416c17.7 0 32-14.3 32-32V337c0-17.7-14.3-32-32-32zM184 568V232h368v336H184zm656 145H504v-73h112c4.4 0 8-3.6 8-8V377h216v336z", "fill": primaryColor } }] }; }, "name": "flag", "theme": "twotone" };
	exports.default = FlagTwoTone;
	});

	var FlagTwoToneSvg = unwrapExports(FlagTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var FlagTwoTone = function FlagTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FlagTwoToneSvg
	  }));
	};

	FlagTwoTone.displayName = 'FlagTwoTone';
	var FlagTwoTone$1 = /*#__PURE__*/React.forwardRef(FlagTwoTone);

	var FolderAddFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FolderAddFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 298.4H521L403.7 186.2a8.15 8.15 0 00-5.5-2.2H144c-17.7 0-32 14.3-32 32v592c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V330.4c0-17.7-14.3-32-32-32zM632 577c0 3.8-3.4 7-7.5 7H540v84.9c0 3.9-3.2 7.1-7 7.1h-42c-3.8 0-7-3.2-7-7.1V584h-84.5c-4.1 0-7.5-3.2-7.5-7v-42c0-3.8 3.4-7 7.5-7H484v-84.9c0-3.9 3.2-7.1 7-7.1h42c3.8 0 7 3.2 7 7.1V528h84.5c4.1 0 7.5 3.2 7.5 7v42z" } }] }, "name": "folder-add", "theme": "filled" };
	exports.default = FolderAddFilled;
	});

	var FolderAddFilledSvg = unwrapExports(FolderAddFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var FolderAddFilled = function FolderAddFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FolderAddFilledSvg
	  }));
	};

	FolderAddFilled.displayName = 'FolderAddFilled';
	var FolderAddFilled$1 = /*#__PURE__*/React.forwardRef(FolderAddFilled);

	var FolderAddOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FolderAddOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M484 443.1V528h-84.5c-4.1 0-7.5 3.1-7.5 7v42c0 3.8 3.4 7 7.5 7H484v84.9c0 3.9 3.2 7.1 7 7.1h42c3.9 0 7-3.2 7-7.1V584h84.5c4.1 0 7.5-3.2 7.5-7v-42c0-3.9-3.4-7-7.5-7H540v-84.9c0-3.9-3.1-7.1-7-7.1h-42c-3.8 0-7 3.2-7 7.1zm396-144.7H521L403.7 186.2a8.15 8.15 0 00-5.5-2.2H144c-17.7 0-32 14.3-32 32v592c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V330.4c0-17.7-14.3-32-32-32zM840 768H184V256h188.5l119.6 114.4H840V768z" } }] }, "name": "folder-add", "theme": "outlined" };
	exports.default = FolderAddOutlined;
	});

	var FolderAddOutlinedSvg = unwrapExports(FolderAddOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FolderAddOutlined = function FolderAddOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FolderAddOutlinedSvg
	  }));
	};

	FolderAddOutlined.displayName = 'FolderAddOutlined';
	var FolderAddOutlined$1 = /*#__PURE__*/React.forwardRef(FolderAddOutlined);

	var FolderAddTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FolderAddTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M372.5 256H184v512h656V370.4H492.1L372.5 256zM540 443.1V528h84.5c4.1 0 7.5 3.1 7.5 7v42c0 3.8-3.4 7-7.5 7H540v84.9c0 3.9-3.1 7.1-7 7.1h-42c-3.8 0-7-3.2-7-7.1V584h-84.5c-4.1 0-7.5-3.2-7.5-7v-42c0-3.9 3.4-7 7.5-7H484v-84.9c0-3.9 3.2-7.1 7-7.1h42c3.9 0 7 3.2 7 7.1z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M880 298.4H521L403.7 186.2a8.15 8.15 0 00-5.5-2.2H144c-17.7 0-32 14.3-32 32v592c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V330.4c0-17.7-14.3-32-32-32zM840 768H184V256h188.5l119.6 114.4H840V768z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M484 443.1V528h-84.5c-4.1 0-7.5 3.1-7.5 7v42c0 3.8 3.4 7 7.5 7H484v84.9c0 3.9 3.2 7.1 7 7.1h42c3.9 0 7-3.2 7-7.1V584h84.5c4.1 0 7.5-3.2 7.5-7v-42c0-3.9-3.4-7-7.5-7H540v-84.9c0-3.9-3.1-7.1-7-7.1h-42c-3.8 0-7 3.2-7 7.1z", "fill": primaryColor } }] }; }, "name": "folder-add", "theme": "twotone" };
	exports.default = FolderAddTwoTone;
	});

	var FolderAddTwoToneSvg = unwrapExports(FolderAddTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var FolderAddTwoTone = function FolderAddTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FolderAddTwoToneSvg
	  }));
	};

	FolderAddTwoTone.displayName = 'FolderAddTwoTone';
	var FolderAddTwoTone$1 = /*#__PURE__*/React.forwardRef(FolderAddTwoTone);

	var FolderFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FolderFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 298.4H521L403.7 186.2a8.15 8.15 0 00-5.5-2.2H144c-17.7 0-32 14.3-32 32v592c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V330.4c0-17.7-14.3-32-32-32z" } }] }, "name": "folder", "theme": "filled" };
	exports.default = FolderFilled;
	});

	var FolderFilledSvg = unwrapExports(FolderFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var FolderFilled = function FolderFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FolderFilledSvg
	  }));
	};

	FolderFilled.displayName = 'FolderFilled';
	var FolderFilled$1 = /*#__PURE__*/React.forwardRef(FolderFilled);

	var FolderOpenFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FolderOpenFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M928 444H820V330.4c0-17.7-14.3-32-32-32H473L355.7 186.2a8.15 8.15 0 00-5.5-2.2H96c-17.7 0-32 14.3-32 32v592c0 17.7 14.3 32 32 32h698c13 0 24.8-7.9 29.7-20l134-332c1.5-3.8 2.3-7.9 2.3-12 0-17.7-14.3-32-32-32zm-180 0H238c-13 0-24.8 7.9-29.7 20L136 643.2V256h188.5l119.6 114.4H748V444z" } }] }, "name": "folder-open", "theme": "filled" };
	exports.default = FolderOpenFilled;
	});

	var FolderOpenFilledSvg = unwrapExports(FolderOpenFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var FolderOpenFilled = function FolderOpenFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FolderOpenFilledSvg
	  }));
	};

	FolderOpenFilled.displayName = 'FolderOpenFilled';
	var FolderOpenFilled$1 = /*#__PURE__*/React.forwardRef(FolderOpenFilled);

	var FolderOpenOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FolderOpenOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M928 444H820V330.4c0-17.7-14.3-32-32-32H473L355.7 186.2a8.15 8.15 0 00-5.5-2.2H96c-17.7 0-32 14.3-32 32v592c0 17.7 14.3 32 32 32h698c13 0 24.8-7.9 29.7-20l134-332c1.5-3.8 2.3-7.9 2.3-12 0-17.7-14.3-32-32-32zM136 256h188.5l119.6 114.4H748V444H238c-13 0-24.8 7.9-29.7 20L136 643.2V256zm635.3 512H159l103.3-256h612.4L771.3 768z" } }] }, "name": "folder-open", "theme": "outlined" };
	exports.default = FolderOpenOutlined;
	});

	var FolderOpenOutlinedSvg = unwrapExports(FolderOpenOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FolderOpenOutlined = function FolderOpenOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FolderOpenOutlinedSvg
	  }));
	};

	FolderOpenOutlined.displayName = 'FolderOpenOutlined';
	var FolderOpenOutlined$1 = /*#__PURE__*/React.forwardRef(FolderOpenOutlined);

	var FolderOpenTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FolderOpenTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M159 768h612.3l103.4-256H262.3z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M928 444H820V330.4c0-17.7-14.3-32-32-32H473L355.7 186.2a8.15 8.15 0 00-5.5-2.2H96c-17.7 0-32 14.3-32 32v592c0 17.7 14.3 32 32 32h698c13 0 24.8-7.9 29.7-20l134-332c1.5-3.8 2.3-7.9 2.3-12 0-17.7-14.3-32-32-32zM136 256h188.5l119.6 114.4H748V444H238c-13 0-24.8 7.9-29.7 20L136 643.2V256zm635.3 512H159l103.3-256h612.4L771.3 768z", "fill": primaryColor } }] }; }, "name": "folder-open", "theme": "twotone" };
	exports.default = FolderOpenTwoTone;
	});

	var FolderOpenTwoToneSvg = unwrapExports(FolderOpenTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var FolderOpenTwoTone = function FolderOpenTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FolderOpenTwoToneSvg
	  }));
	};

	FolderOpenTwoTone.displayName = 'FolderOpenTwoTone';
	var FolderOpenTwoTone$1 = /*#__PURE__*/React.forwardRef(FolderOpenTwoTone);

	var FolderOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FolderOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 298.4H521L403.7 186.2a8.15 8.15 0 00-5.5-2.2H144c-17.7 0-32 14.3-32 32v592c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V330.4c0-17.7-14.3-32-32-32zM840 768H184V256h188.5l119.6 114.4H840V768z" } }] }, "name": "folder", "theme": "outlined" };
	exports.default = FolderOutlined;
	});

	var FolderOutlinedSvg = unwrapExports(FolderOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FolderOutlined = function FolderOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FolderOutlinedSvg
	  }));
	};

	FolderOutlined.displayName = 'FolderOutlined';
	var FolderOutlined$1 = /*#__PURE__*/React.forwardRef(FolderOutlined);

	var FolderTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FolderTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 298.4H521L403.7 186.2a8.15 8.15 0 00-5.5-2.2H144c-17.7 0-32 14.3-32 32v592c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V330.4c0-17.7-14.3-32-32-32zM840 768H184V256h188.5l119.6 114.4H840V768z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M372.5 256H184v512h656V370.4H492.1z", "fill": secondaryColor } }] }; }, "name": "folder", "theme": "twotone" };
	exports.default = FolderTwoTone;
	});

	var FolderTwoToneSvg = unwrapExports(FolderTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var FolderTwoTone = function FolderTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FolderTwoToneSvg
	  }));
	};

	FolderTwoTone.displayName = 'FolderTwoTone';
	var FolderTwoTone$1 = /*#__PURE__*/React.forwardRef(FolderTwoTone);

	var FolderViewOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FolderViewOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M309.1 554.3a42.92 42.92 0 000 36.4C353.3 684 421.6 732 512.5 732s159.2-48.1 203.4-141.3c5.4-11.5 5.4-24.8.1-36.3l-.1-.1-.1-.1C671.7 461 603.4 413 512.5 413s-159.2 48.1-203.4 141.3zM512.5 477c62.1 0 107.4 30 141.1 95.5C620 638 574.6 668 512.5 668s-107.4-30-141.1-95.5c33.7-65.5 79-95.5 141.1-95.5z" } }, { "tag": "path", "attrs": { "d": "M457 573a56 56 0 10112 0 56 56 0 10-112 0z" } }, { "tag": "path", "attrs": { "d": "M880 298.4H521L403.7 186.2a8.15 8.15 0 00-5.5-2.2H144c-17.7 0-32 14.3-32 32v592c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V330.4c0-17.7-14.3-32-32-32zM840 768H184V256h188.5l119.6 114.4H840V768z" } }] }, "name": "folder-view", "theme": "outlined" };
	exports.default = FolderViewOutlined;
	});

	var FolderViewOutlinedSvg = unwrapExports(FolderViewOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FolderViewOutlined = function FolderViewOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FolderViewOutlinedSvg
	  }));
	};

	FolderViewOutlined.displayName = 'FolderViewOutlined';
	var FolderViewOutlined$1 = /*#__PURE__*/React.forwardRef(FolderViewOutlined);

	var FontColorsOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FontColorsOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M904 816H120c-4.4 0-8 3.6-8 8v80c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-80c0-4.4-3.6-8-8-8zm-650.3-80h85c4.2 0 8-2.7 9.3-6.8l53.7-166h219.2l53.2 166c1.3 4 5 6.8 9.3 6.8h89.1c1.1 0 2.2-.2 3.2-.5a9.7 9.7 0 006-12.4L573.6 118.6a9.9 9.9 0 00-9.2-6.6H462.1c-4.2 0-7.9 2.6-9.2 6.6L244.5 723.1c-.4 1-.5 2.1-.5 3.2-.1 5.3 4.3 9.7 9.7 9.7zm255.9-516.1h4.1l83.8 263.8H424.9l84.7-263.8z" } }] }, "name": "font-colors", "theme": "outlined" };
	exports.default = FontColorsOutlined;
	});

	var FontColorsOutlinedSvg = unwrapExports(FontColorsOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FontColorsOutlined = function FontColorsOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FontColorsOutlinedSvg
	  }));
	};

	FontColorsOutlined.displayName = 'FontColorsOutlined';
	var FontColorsOutlined$1 = /*#__PURE__*/React.forwardRef(FontColorsOutlined);

	var FontSizeOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FontSizeOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M920 416H616c-4.4 0-8 3.6-8 8v112c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8v-56h60v320h-46c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h164c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8h-46V480h60v56c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V424c0-4.4-3.6-8-8-8zM656 296V168c0-4.4-3.6-8-8-8H104c-4.4 0-8 3.6-8 8v128c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-64h168v560h-92c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h264c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-92V232h168v64c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8z" } }] }, "name": "font-size", "theme": "outlined" };
	exports.default = FontSizeOutlined;
	});

	var FontSizeOutlinedSvg = unwrapExports(FontSizeOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FontSizeOutlined = function FontSizeOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FontSizeOutlinedSvg
	  }));
	};

	FontSizeOutlined.displayName = 'FontSizeOutlined';
	var FontSizeOutlined$1 = /*#__PURE__*/React.forwardRef(FontSizeOutlined);

	var ForkOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ForkOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M752 100c-61.8 0-112 50.2-112 112 0 47.7 29.9 88.5 72 104.6v27.6L512 601.4 312 344.2v-27.6c42.1-16.1 72-56.9 72-104.6 0-61.8-50.2-112-112-112s-112 50.2-112 112c0 50.6 33.8 93.5 80 107.3v34.4c0 9.7 3.3 19.3 9.3 27L476 672.3v33.6c-44.2 15-76 56.9-76 106.1 0 61.8 50.2 112 112 112s112-50.2 112-112c0-49.2-31.8-91-76-106.1v-33.6l226.7-291.6c6-7.7 9.3-17.3 9.3-27v-34.4c46.2-13.8 80-56.7 80-107.3 0-61.8-50.2-112-112-112zM224 212a48.01 48.01 0 0196 0 48.01 48.01 0 01-96 0zm336 600a48.01 48.01 0 01-96 0 48.01 48.01 0 0196 0zm192-552a48.01 48.01 0 010-96 48.01 48.01 0 010 96z" } }] }, "name": "fork", "theme": "outlined" };
	exports.default = ForkOutlined;
	});

	var ForkOutlinedSvg = unwrapExports(ForkOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var ForkOutlined = function ForkOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ForkOutlinedSvg
	  }));
	};

	ForkOutlined.displayName = 'ForkOutlined';
	var ForkOutlined$1 = /*#__PURE__*/React.forwardRef(ForkOutlined);

	var FormOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FormOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M904 512h-56c-4.4 0-8 3.6-8 8v320H184V184h320c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V520c0-4.4-3.6-8-8-8z" } }, { "tag": "path", "attrs": { "d": "M355.9 534.9L354 653.8c-.1 8.9 7.1 16.2 16 16.2h.4l118-2.9c2-.1 4-.9 5.4-2.3l415.9-415c3.1-3.1 3.1-8.2 0-11.3L785.4 114.3c-1.6-1.6-3.6-2.3-5.7-2.3s-4.1.8-5.7 2.3l-415.8 415a8.3 8.3 0 00-2.3 5.6zm63.5 23.6L779.7 199l45.2 45.1-360.5 359.7-45.7 1.1.7-46.4z" } }] }, "name": "form", "theme": "outlined" };
	exports.default = FormOutlined;
	});

	var FormOutlinedSvg = unwrapExports(FormOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FormOutlined = function FormOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FormOutlinedSvg
	  }));
	};

	FormOutlined.displayName = 'FormOutlined';
	var FormOutlined$1 = /*#__PURE__*/React.forwardRef(FormOutlined);

	var FormatPainterFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FormatPainterFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M840 192h-56v-72c0-13.3-10.7-24-24-24H168c-13.3 0-24 10.7-24 24v272c0 13.3 10.7 24 24 24h592c13.3 0 24-10.7 24-24V256h32v200H465c-22.1 0-40 17.9-40 40v136h-44c-4.4 0-8 3.6-8 8v228c0 1.1.2 2.2.6 3.1-.4 1.6-.6 3.2-.6 4.9 0 46.4 37.6 84 84 84s84-37.6 84-84c0-1.7-.2-3.3-.6-4.9.4-1 .6-2 .6-3.1V640c0-4.4-3.6-8-8-8h-44V520h351c22.1 0 40-17.9 40-40V232c0-22.1-17.9-40-40-40z" } }] }, "name": "format-painter", "theme": "filled" };
	exports.default = FormatPainterFilled;
	});

	var FormatPainterFilledSvg = unwrapExports(FormatPainterFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var FormatPainterFilled = function FormatPainterFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FormatPainterFilledSvg
	  }));
	};

	FormatPainterFilled.displayName = 'FormatPainterFilled';
	var FormatPainterFilled$1 = /*#__PURE__*/React.forwardRef(FormatPainterFilled);

	var FormatPainterOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FormatPainterOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M840 192h-56v-72c0-13.3-10.7-24-24-24H168c-13.3 0-24 10.7-24 24v272c0 13.3 10.7 24 24 24h592c13.3 0 24-10.7 24-24V256h32v200H465c-22.1 0-40 17.9-40 40v136h-44c-4.4 0-8 3.6-8 8v228c0 .6.1 1.3.2 1.9A83.99 83.99 0 00457 960c46.4 0 84-37.6 84-84 0-2.1-.1-4.1-.2-6.1.1-.6.2-1.2.2-1.9V640c0-4.4-3.6-8-8-8h-44V520h351c22.1 0 40-17.9 40-40V232c0-22.1-17.9-40-40-40zM720 352H208V160h512v192zM477 876c0 11-9 20-20 20s-20-9-20-20V696h40v180z" } }] }, "name": "format-painter", "theme": "outlined" };
	exports.default = FormatPainterOutlined;
	});

	var FormatPainterOutlinedSvg = unwrapExports(FormatPainterOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FormatPainterOutlined = function FormatPainterOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FormatPainterOutlinedSvg
	  }));
	};

	FormatPainterOutlined.displayName = 'FormatPainterOutlined';
	var FormatPainterOutlined$1 = /*#__PURE__*/React.forwardRef(FormatPainterOutlined);

	var ForwardFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ForwardFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M825.8 498L538.4 249.9c-10.7-9.2-26.4-.9-26.4 14v496.3c0 14.9 15.7 23.2 26.4 14L825.8 526c8.3-7.2 8.3-20.8 0-28zm-320 0L218.4 249.9c-10.7-9.2-26.4-.9-26.4 14v496.3c0 14.9 15.7 23.2 26.4 14L505.8 526c4.1-3.6 6.2-8.8 6.2-14 0-5.2-2.1-10.4-6.2-14z" } }] }, "name": "forward", "theme": "filled" };
	exports.default = ForwardFilled;
	});

	var ForwardFilledSvg = unwrapExports(ForwardFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var ForwardFilled = function ForwardFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ForwardFilledSvg
	  }));
	};

	ForwardFilled.displayName = 'ForwardFilled';
	var ForwardFilled$1 = /*#__PURE__*/React.forwardRef(ForwardFilled);

	var ForwardOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ForwardOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M825.8 498L538.4 249.9c-10.7-9.2-26.4-.9-26.4 14v496.3c0 14.9 15.7 23.2 26.4 14L825.8 526c8.3-7.2 8.3-20.8 0-28zm-320 0L218.4 249.9c-10.7-9.2-26.4-.9-26.4 14v496.3c0 14.9 15.7 23.2 26.4 14L505.8 526c4.1-3.6 6.2-8.8 6.2-14 0-5.2-2.1-10.4-6.2-14z" } }] }, "name": "forward", "theme": "outlined" };
	exports.default = ForwardOutlined;
	});

	var ForwardOutlinedSvg = unwrapExports(ForwardOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var ForwardOutlined = function ForwardOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ForwardOutlinedSvg
	  }));
	};

	ForwardOutlined.displayName = 'ForwardOutlined';
	var ForwardOutlined$1 = /*#__PURE__*/React.forwardRef(ForwardOutlined);

	var FrownFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FrownFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zM288 421a48.01 48.01 0 0196 0 48.01 48.01 0 01-96 0zm376 272h-48.1c-4.2 0-7.8-3.2-8.1-7.4C604 636.1 562.5 597 512 597s-92.1 39.1-95.8 88.6c-.3 4.2-3.9 7.4-8.1 7.4H360a8 8 0 01-8-8.4c4.4-84.3 74.5-151.6 160-151.6s155.6 67.3 160 151.6a8 8 0 01-8 8.4zm24-224a48.01 48.01 0 010-96 48.01 48.01 0 010 96z" } }] }, "name": "frown", "theme": "filled" };
	exports.default = FrownFilled;
	});

	var FrownFilledSvg = unwrapExports(FrownFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var FrownFilled = function FrownFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FrownFilledSvg
	  }));
	};

	FrownFilled.displayName = 'FrownFilled';
	var FrownFilled$1 = /*#__PURE__*/React.forwardRef(FrownFilled);

	var FrownOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FrownOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M288 421a48 48 0 1096 0 48 48 0 10-96 0zm352 0a48 48 0 1096 0 48 48 0 10-96 0zM512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm263 711c-34.2 34.2-74 61-118.3 79.8C611 874.2 562.3 884 512 884c-50.3 0-99-9.8-144.8-29.2A370.4 370.4 0 01248.9 775c-34.2-34.2-61-74-79.8-118.3C149.8 611 140 562.3 140 512s9.8-99 29.2-144.8A370.4 370.4 0 01249 248.9c34.2-34.2 74-61 118.3-79.8C413 149.8 461.7 140 512 140c50.3 0 99 9.8 144.8 29.2A370.4 370.4 0 01775.1 249c34.2 34.2 61 74 79.8 118.3C874.2 413 884 461.7 884 512s-9.8 99-29.2 144.8A368.89 368.89 0 01775 775zM512 533c-85.5 0-155.6 67.3-160 151.6a8 8 0 008 8.4h48.1c4.2 0 7.8-3.2 8.1-7.4C420 636.1 461.5 597 512 597s92.1 39.1 95.8 88.6c.3 4.2 3.9 7.4 8.1 7.4H664a8 8 0 008-8.4C667.6 600.3 597.5 533 512 533z" } }] }, "name": "frown", "theme": "outlined" };
	exports.default = FrownOutlined;
	});

	var FrownOutlinedSvg = unwrapExports(FrownOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FrownOutlined = function FrownOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FrownOutlinedSvg
	  }));
	};

	FrownOutlined.displayName = 'FrownOutlined';
	var FrownOutlined$1 = /*#__PURE__*/React.forwardRef(FrownOutlined);

	var FrownTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FrownTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zM288 421a48.01 48.01 0 0196 0 48.01 48.01 0 01-96 0zm376 272h-48.1c-4.2 0-7.8-3.2-8.1-7.4C604 636.1 562.5 597 512 597s-92.1 39.1-95.8 88.6c-.3 4.2-3.9 7.4-8.1 7.4H360a8 8 0 01-8-8.4c4.4-84.3 74.5-151.6 160-151.6s155.6 67.3 160 151.6a8 8 0 01-8 8.4zm24-224a48.01 48.01 0 010-96 48.01 48.01 0 010 96z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M288 421a48 48 0 1096 0 48 48 0 10-96 0zm224 112c-85.5 0-155.6 67.3-160 151.6a8 8 0 008 8.4h48.1c4.2 0 7.8-3.2 8.1-7.4 3.7-49.5 45.3-88.6 95.8-88.6s92 39.1 95.8 88.6c.3 4.2 3.9 7.4 8.1 7.4H664a8 8 0 008-8.4C667.6 600.3 597.5 533 512 533zm128-112a48 48 0 1096 0 48 48 0 10-96 0z", "fill": primaryColor } }] }; }, "name": "frown", "theme": "twotone" };
	exports.default = FrownTwoTone;
	});

	var FrownTwoToneSvg = unwrapExports(FrownTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var FrownTwoTone = function FrownTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FrownTwoToneSvg
	  }));
	};

	FrownTwoTone.displayName = 'FrownTwoTone';
	var FrownTwoTone$1 = /*#__PURE__*/React.forwardRef(FrownTwoTone);

	var FullscreenExitOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FullscreenExitOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M391 240.9c-.8-6.6-8.9-9.4-13.6-4.7l-43.7 43.7L200 146.3a8.03 8.03 0 00-11.3 0l-42.4 42.3a8.03 8.03 0 000 11.3L280 333.6l-43.9 43.9a8.01 8.01 0 004.7 13.6L401 410c5.1.6 9.5-3.7 8.9-8.9L391 240.9zm10.1 373.2L240.8 633c-6.6.8-9.4 8.9-4.7 13.6l43.9 43.9L146.3 824a8.03 8.03 0 000 11.3l42.4 42.3c3.1 3.1 8.2 3.1 11.3 0L333.7 744l43.7 43.7A8.01 8.01 0 00391 783l18.9-160.1c.6-5.1-3.7-9.4-8.8-8.8zm221.8-204.2L783.2 391c6.6-.8 9.4-8.9 4.7-13.6L744 333.6 877.7 200c3.1-3.1 3.1-8.2 0-11.3l-42.4-42.3a8.03 8.03 0 00-11.3 0L690.3 279.9l-43.7-43.7a8.01 8.01 0 00-13.6 4.7L614.1 401c-.6 5.2 3.7 9.5 8.8 8.9zM744 690.4l43.9-43.9a8.01 8.01 0 00-4.7-13.6L623 614c-5.1-.6-9.5 3.7-8.9 8.9L633 783.1c.8 6.6 8.9 9.4 13.6 4.7l43.7-43.7L824 877.7c3.1 3.1 8.2 3.1 11.3 0l42.4-42.3c3.1-3.1 3.1-8.2 0-11.3L744 690.4z" } }] }, "name": "fullscreen-exit", "theme": "outlined" };
	exports.default = FullscreenExitOutlined;
	});

	var FullscreenExitOutlinedSvg = unwrapExports(FullscreenExitOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FullscreenExitOutlined = function FullscreenExitOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FullscreenExitOutlinedSvg
	  }));
	};

	FullscreenExitOutlined.displayName = 'FullscreenExitOutlined';
	var FullscreenExitOutlined$1 = /*#__PURE__*/React.forwardRef(FullscreenExitOutlined);

	var FullscreenOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FullscreenOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M290 236.4l43.9-43.9a8.01 8.01 0 00-4.7-13.6L169 160c-5.1-.6-9.5 3.7-8.9 8.9L179 329.1c.8 6.6 8.9 9.4 13.6 4.7l43.7-43.7L370 423.7c3.1 3.1 8.2 3.1 11.3 0l42.4-42.3c3.1-3.1 3.1-8.2 0-11.3L290 236.4zm352.7 187.3c3.1 3.1 8.2 3.1 11.3 0l133.7-133.6 43.7 43.7a8.01 8.01 0 0013.6-4.7L863.9 169c.6-5.1-3.7-9.5-8.9-8.9L694.8 179c-6.6.8-9.4 8.9-4.7 13.6l43.9 43.9L600.3 370a8.03 8.03 0 000 11.3l42.4 42.4zM845 694.9c-.8-6.6-8.9-9.4-13.6-4.7l-43.7 43.7L654 600.3a8.03 8.03 0 00-11.3 0l-42.4 42.3a8.03 8.03 0 000 11.3L734 787.6l-43.9 43.9a8.01 8.01 0 004.7 13.6L855 864c5.1.6 9.5-3.7 8.9-8.9L845 694.9zm-463.7-94.6a8.03 8.03 0 00-11.3 0L236.3 733.9l-43.7-43.7a8.01 8.01 0 00-13.6 4.7L160.1 855c-.6 5.1 3.7 9.5 8.9 8.9L329.2 845c6.6-.8 9.4-8.9 4.7-13.6L290 787.6 423.7 654c3.1-3.1 3.1-8.2 0-11.3l-42.4-42.4z" } }] }, "name": "fullscreen", "theme": "outlined" };
	exports.default = FullscreenOutlined;
	});

	var FullscreenOutlinedSvg = unwrapExports(FullscreenOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FullscreenOutlined = function FullscreenOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FullscreenOutlinedSvg
	  }));
	};

	FullscreenOutlined.displayName = 'FullscreenOutlined';
	var FullscreenOutlined$1 = /*#__PURE__*/React.forwardRef(FullscreenOutlined);

	var FunctionOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FunctionOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M841 370c3-3.3 2.7-8.3-.6-11.3a8.24 8.24 0 00-5.3-2.1h-72.6c-2.4 0-4.6 1-6.1 2.8L633.5 504.6a7.96 7.96 0 01-13.4-1.9l-63.5-141.3a7.9 7.9 0 00-7.3-4.7H380.7l.9-4.7 8-42.3c10.5-55.4 38-81.4 85.8-81.4 18.6 0 35.5 1.7 48.8 4.7l14.1-66.8c-22.6-4.7-35.2-6.1-54.9-6.1-103.3 0-156.4 44.3-175.9 147.3l-9.4 49.4h-97.6c-3.8 0-7.1 2.7-7.8 6.4L181.9 415a8.07 8.07 0 007.8 9.7H284l-89 429.9a8.07 8.07 0 007.8 9.7H269c3.8 0 7.1-2.7 7.8-6.4l89.7-433.1h135.8l68.2 139.1c1.4 2.9 1 6.4-1.2 8.8l-180.6 203c-2.9 3.3-2.6 8.4.7 11.3 1.5 1.3 3.4 2 5.3 2h72.7c2.4 0 4.6-1 6.1-2.8l123.7-146.7c2.8-3.4 7.9-3.8 11.3-1 .9.8 1.6 1.7 2.1 2.8L676.4 784c1.3 2.8 4.1 4.7 7.3 4.7h64.6a8.02 8.02 0 007.2-11.5l-95.2-198.9c-1.4-2.9-.9-6.4 1.3-8.8L841 370z" } }] }, "name": "function", "theme": "outlined" };
	exports.default = FunctionOutlined;
	});

	var FunctionOutlinedSvg = unwrapExports(FunctionOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FunctionOutlined = function FunctionOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FunctionOutlinedSvg
	  }));
	};

	FunctionOutlined.displayName = 'FunctionOutlined';
	var FunctionOutlined$1 = /*#__PURE__*/React.forwardRef(FunctionOutlined);

	var FundFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FundFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M926 164H94c-17.7 0-32 14.3-32 32v640c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V196c0-17.7-14.3-32-32-32zm-92.3 194.4l-297 297.2a8.03 8.03 0 01-11.3 0L410.9 541.1 238.4 713.7a8.03 8.03 0 01-11.3 0l-36.8-36.8a8.03 8.03 0 010-11.3l214.9-215c3.1-3.1 8.2-3.1 11.3 0L531 565l254.5-254.6c3.1-3.1 8.2-3.1 11.3 0l36.8 36.8c3.2 3 3.2 8.1.1 11.2z" } }] }, "name": "fund", "theme": "filled" };
	exports.default = FundFilled;
	});

	var FundFilledSvg = unwrapExports(FundFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var FundFilled = function FundFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FundFilledSvg
	  }));
	};

	FundFilled.displayName = 'FundFilled';
	var FundFilled$1 = /*#__PURE__*/React.forwardRef(FundFilled);

	var FundOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FundOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M926 164H94c-17.7 0-32 14.3-32 32v640c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V196c0-17.7-14.3-32-32-32zm-40 632H134V236h752v560zm-658.9-82.3c3.1 3.1 8.2 3.1 11.3 0l172.5-172.5 114.4 114.5c3.1 3.1 8.2 3.1 11.3 0l297-297.2c3.1-3.1 3.1-8.2 0-11.3l-36.8-36.8a8.03 8.03 0 00-11.3 0L531 565 416.6 450.5a8.03 8.03 0 00-11.3 0l-214.9 215a8.03 8.03 0 000 11.3l36.7 36.9z" } }] }, "name": "fund", "theme": "outlined" };
	exports.default = FundOutlined;
	});

	var FundOutlinedSvg = unwrapExports(FundOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FundOutlined = function FundOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FundOutlinedSvg
	  }));
	};

	FundOutlined.displayName = 'FundOutlined';
	var FundOutlined$1 = /*#__PURE__*/React.forwardRef(FundOutlined);

	var FundProjectionScreenOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FundProjectionScreenOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M312.1 591.5c3.1 3.1 8.2 3.1 11.3 0l101.8-101.8 86.1 86.2c3.1 3.1 8.2 3.1 11.3 0l226.3-226.5c3.1-3.1 3.1-8.2 0-11.3l-36.8-36.8a8.03 8.03 0 00-11.3 0L517 485.3l-86.1-86.2a8.03 8.03 0 00-11.3 0L275.3 543.4a8.03 8.03 0 000 11.3l36.8 36.8z" } }, { "tag": "path", "attrs": { "d": "M904 160H548V96c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H120c-17.7 0-32 14.3-32 32v520c0 17.7 14.3 32 32 32h356.4v32L311.6 884.1a7.92 7.92 0 00-2.3 11l30.3 47.2v.1c2.4 3.7 7.4 4.7 11.1 2.3L512 838.9l161.3 105.8c3.7 2.4 8.7 1.4 11.1-2.3v-.1l30.3-47.2a8 8 0 00-2.3-11L548 776.3V744h356c17.7 0 32-14.3 32-32V192c0-17.7-14.3-32-32-32zm-40 512H160V232h704v440z" } }] }, "name": "fund-projection-screen", "theme": "outlined" };
	exports.default = FundProjectionScreenOutlined;
	});

	var FundProjectionScreenOutlinedSvg = unwrapExports(FundProjectionScreenOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FundProjectionScreenOutlined = function FundProjectionScreenOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FundProjectionScreenOutlinedSvg
	  }));
	};

	FundProjectionScreenOutlined.displayName = 'FundProjectionScreenOutlined';
	var FundProjectionScreenOutlined$1 = /*#__PURE__*/React.forwardRef(FundProjectionScreenOutlined);

	var FundTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FundTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M928 160H96c-17.7 0-32 14.3-32 32v640c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V192c0-17.7-14.3-32-32-32zm-40 632H136V232h752v560z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M136 792h752V232H136v560zm56.4-130.5l214.9-215c3.1-3.1 8.2-3.1 11.3 0L533 561l254.5-254.6c3.1-3.1 8.2-3.1 11.3 0l36.8 36.8c3.1 3.1 3.1 8.2 0 11.3l-297 297.2a8.03 8.03 0 01-11.3 0L412.9 537.2 240.4 709.7a8.03 8.03 0 01-11.3 0l-36.7-36.9a8.03 8.03 0 010-11.3z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M229.1 709.7c3.1 3.1 8.2 3.1 11.3 0l172.5-172.5 114.4 114.5c3.1 3.1 8.2 3.1 11.3 0l297-297.2c3.1-3.1 3.1-8.2 0-11.3l-36.8-36.8a8.03 8.03 0 00-11.3 0L533 561 418.6 446.5a8.03 8.03 0 00-11.3 0l-214.9 215a8.03 8.03 0 000 11.3l36.7 36.9z", "fill": primaryColor } }] }; }, "name": "fund", "theme": "twotone" };
	exports.default = FundTwoTone;
	});

	var FundTwoToneSvg = unwrapExports(FundTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var FundTwoTone = function FundTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FundTwoToneSvg
	  }));
	};

	FundTwoTone.displayName = 'FundTwoTone';
	var FundTwoTone$1 = /*#__PURE__*/React.forwardRef(FundTwoTone);

	var FundViewOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FundViewOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M956 686.5l-.1-.1-.1-.1C911.7 593 843.4 545 752.5 545s-159.2 48.1-203.4 141.3v.1a42.92 42.92 0 000 36.4C593.3 816 661.6 864 752.5 864s159.2-48.1 203.4-141.3c5.4-11.5 5.4-24.8.1-36.2zM752.5 800c-62.1 0-107.4-30-141.1-95.5C645 639 690.4 609 752.5 609c62.1 0 107.4 30 141.1 95.5C860 770 814.6 800 752.5 800z" } }, { "tag": "path", "attrs": { "d": "M697 705a56 56 0 10112 0 56 56 0 10-112 0zM136 232h704v253h72V192c0-17.7-14.3-32-32-32H96c-17.7 0-32 14.3-32 32v520c0 17.7 14.3 32 32 32h352v-72H136V232z" } }, { "tag": "path", "attrs": { "d": "M724.9 338.1l-36.8-36.8a8.03 8.03 0 00-11.3 0L493 485.3l-86.1-86.2a8.03 8.03 0 00-11.3 0L251.3 543.4a8.03 8.03 0 000 11.3l36.8 36.8c3.1 3.1 8.2 3.1 11.3 0l101.8-101.8 86.1 86.2c3.1 3.1 8.2 3.1 11.3 0l226.3-226.5c3.2-3.1 3.2-8.2 0-11.3z" } }] }, "name": "fund-view", "theme": "outlined" };
	exports.default = FundViewOutlined;
	});

	var FundViewOutlinedSvg = unwrapExports(FundViewOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FundViewOutlined = function FundViewOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FundViewOutlinedSvg
	  }));
	};

	FundViewOutlined.displayName = 'FundViewOutlined';
	var FundViewOutlined$1 = /*#__PURE__*/React.forwardRef(FundViewOutlined);

	var FunnelPlotFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FunnelPlotFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M336.7 586h350.6l84.9-148H251.8zm543.4-432H143.9c-24.5 0-39.8 26.7-27.5 48L215 374h594l98.7-172c12.2-21.3-3.1-48-27.6-48zM349 838c0 17.7 14.2 32 31.8 32h262.4c17.6 0 31.8-14.3 31.8-32V650H349v188z" } }] }, "name": "funnel-plot", "theme": "filled" };
	exports.default = FunnelPlotFilled;
	});

	var FunnelPlotFilledSvg = unwrapExports(FunnelPlotFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var FunnelPlotFilled = function FunnelPlotFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FunnelPlotFilledSvg
	  }));
	};

	FunnelPlotFilled.displayName = 'FunnelPlotFilled';
	var FunnelPlotFilled$1 = /*#__PURE__*/React.forwardRef(FunnelPlotFilled);

	var FunnelPlotOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FunnelPlotOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880.1 154H143.9c-24.5 0-39.8 26.7-27.5 48L349 607.4V838c0 17.7 14.2 32 31.8 32h262.4c17.6 0 31.8-14.3 31.8-32V607.4L907.7 202c12.2-21.3-3.1-48-27.6-48zM603.4 798H420.6V650h182.9v148zm9.6-226.6l-8.4 14.6H419.3l-8.4-14.6L334.4 438h355.2L613 571.4zM726.3 374H297.7l-85-148h598.6l-85 148z" } }] }, "name": "funnel-plot", "theme": "outlined" };
	exports.default = FunnelPlotOutlined;
	});

	var FunnelPlotOutlinedSvg = unwrapExports(FunnelPlotOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var FunnelPlotOutlined = function FunnelPlotOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FunnelPlotOutlinedSvg
	  }));
	};

	FunnelPlotOutlined.displayName = 'FunnelPlotOutlined';
	var FunnelPlotOutlined$1 = /*#__PURE__*/React.forwardRef(FunnelPlotOutlined);

	var FunnelPlotTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var FunnelPlotTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M420.6 798h182.9V650H420.6zM297.7 374h428.6l85-148H212.7zm113.2 197.4l8.4 14.6h185.3l8.4-14.6L689.6 438H334.4z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M880.1 154H143.9c-24.5 0-39.8 26.7-27.5 48L349 607.4V838c0 17.7 14.2 32 31.8 32h262.4c17.6 0 31.8-14.3 31.8-32V607.4L907.7 202c12.2-21.3-3.1-48-27.6-48zM603.5 798H420.6V650h182.9v148zm9.5-226.6l-8.4 14.6H419.3l-8.4-14.6L334.4 438h355.2L613 571.4zM726.3 374H297.7l-85-148h598.6l-85 148z", "fill": primaryColor } }] }; }, "name": "funnel-plot", "theme": "twotone" };
	exports.default = FunnelPlotTwoTone;
	});

	var FunnelPlotTwoToneSvg = unwrapExports(FunnelPlotTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var FunnelPlotTwoTone = function FunnelPlotTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: FunnelPlotTwoToneSvg
	  }));
	};

	FunnelPlotTwoTone.displayName = 'FunnelPlotTwoTone';
	var FunnelPlotTwoTone$1 = /*#__PURE__*/React.forwardRef(FunnelPlotTwoTone);

	var GatewayOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var GatewayOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M928 392c8.8 0 16-7.2 16-16V192c0-8.8-7.2-16-16-16H744c-8.8 0-16 7.2-16 16v56H296v-56c0-8.8-7.2-16-16-16H96c-8.8 0-16 7.2-16 16v184c0 8.8 7.2 16 16 16h56v240H96c-8.8 0-16 7.2-16 16v184c0 8.8 7.2 16 16 16h184c8.8 0 16-7.2 16-16v-56h432v56c0 8.8 7.2 16 16 16h184c8.8 0 16-7.2 16-16V648c0-8.8-7.2-16-16-16h-56V392h56zM792 240h88v88h-88v-88zm-648 88v-88h88v88h-88zm88 456h-88v-88h88v88zm648-88v88h-88v-88h88zm-80-64h-56c-8.8 0-16 7.2-16 16v56H296v-56c0-8.8-7.2-16-16-16h-56V392h56c8.8 0 16-7.2 16-16v-56h432v56c0 8.8 7.2 16 16 16h56v240z" } }] }, "name": "gateway", "theme": "outlined" };
	exports.default = GatewayOutlined;
	});

	var GatewayOutlinedSvg = unwrapExports(GatewayOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var GatewayOutlined = function GatewayOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: GatewayOutlinedSvg
	  }));
	};

	GatewayOutlined.displayName = 'GatewayOutlined';
	var GatewayOutlined$1 = /*#__PURE__*/React.forwardRef(GatewayOutlined);

	var GifOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var GifOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M944 299H692c-4.4 0-8 3.6-8 8v406c0 4.4 3.6 8 8 8h59.2c4.4 0 8-3.6 8-8V549.9h168.2c4.4 0 8-3.6 8-8V495c0-4.4-3.6-8-8-8H759.2V364.2H944c4.4 0 8-3.6 8-8V307c0-4.4-3.6-8-8-8zm-356 1h-56c-4.4 0-8 3.6-8 8v406c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V308c0-4.4-3.6-8-8-8zM452 500.9H290.5c-4.4 0-8 3.6-8 8v43.7c0 4.4 3.6 8 8 8h94.9l-.3 8.9c-1.2 58.8-45.6 98.5-110.9 98.5-76.2 0-123.9-59.7-123.9-156.7 0-95.8 46.8-155.2 121.5-155.2 54.8 0 93.1 26.9 108.5 75.4h76.2c-13.6-87.2-86-143.4-184.7-143.4C150 288 72 375.2 72 511.9 72 650.2 149.1 736 273 736c114.1 0 187-70.7 187-181.6v-45.5c0-4.4-3.6-8-8-8z" } }] }, "name": "gif", "theme": "outlined" };
	exports.default = GifOutlined;
	});

	var GifOutlinedSvg = unwrapExports(GifOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var GifOutlined = function GifOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: GifOutlinedSvg
	  }));
	};

	GifOutlined.displayName = 'GifOutlined';
	var GifOutlined$1 = /*#__PURE__*/React.forwardRef(GifOutlined);

	var GiftFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var GiftFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M160 894c0 17.7 14.3 32 32 32h286V550H160v344zm386 32h286c17.7 0 32-14.3 32-32V550H546v376zm334-616H732.4c13.6-21.4 21.6-46.8 21.6-74 0-76.1-61.9-138-138-138-41.4 0-78.7 18.4-104 47.4-25.3-29-62.6-47.4-104-47.4-76.1 0-138 61.9-138 138 0 27.2 7.9 52.6 21.6 74H144c-17.7 0-32 14.3-32 32v140h366V310h68v172h366V342c0-17.7-14.3-32-32-32zm-402-4h-70c-38.6 0-70-31.4-70-70s31.4-70 70-70 70 31.4 70 70v70zm138 0h-70v-70c0-38.6 31.4-70 70-70s70 31.4 70 70-31.4 70-70 70z" } }] }, "name": "gift", "theme": "filled" };
	exports.default = GiftFilled;
	});

	var GiftFilledSvg = unwrapExports(GiftFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var GiftFilled = function GiftFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: GiftFilledSvg
	  }));
	};

	GiftFilled.displayName = 'GiftFilled';
	var GiftFilled$1 = /*#__PURE__*/React.forwardRef(GiftFilled);

	var GiftOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var GiftOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 310H732.4c13.6-21.4 21.6-46.8 21.6-74 0-76.1-61.9-138-138-138-41.4 0-78.7 18.4-104 47.4-25.3-29-62.6-47.4-104-47.4-76.1 0-138 61.9-138 138 0 27.2 7.9 52.6 21.6 74H144c-17.7 0-32 14.3-32 32v200c0 4.4 3.6 8 8 8h40v344c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V550h40c4.4 0 8-3.6 8-8V342c0-17.7-14.3-32-32-32zm-334-74c0-38.6 31.4-70 70-70s70 31.4 70 70-31.4 70-70 70h-70v-70zm-138-70c38.6 0 70 31.4 70 70v70h-70c-38.6 0-70-31.4-70-70s31.4-70 70-70zM180 482V378h298v104H180zm48 68h250v308H228V550zm568 308H546V550h250v308zm48-376H546V378h298v104z" } }] }, "name": "gift", "theme": "outlined" };
	exports.default = GiftOutlined;
	});

	var GiftOutlinedSvg = unwrapExports(GiftOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var GiftOutlined = function GiftOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: GiftOutlinedSvg
	  }));
	};

	GiftOutlined.displayName = 'GiftOutlined';
	var GiftOutlined$1 = /*#__PURE__*/React.forwardRef(GiftOutlined);

	var GiftTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var GiftTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M546 378h298v104H546zM228 550h250v308H228zm-48-172h298v104H180zm366 172h250v308H546z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M880 310H732.4c13.6-21.4 21.6-46.8 21.6-74 0-76.1-61.9-138-138-138-41.4 0-78.7 18.4-104 47.4-25.3-29-62.6-47.4-104-47.4-76.1 0-138 61.9-138 138 0 27.2 7.9 52.6 21.6 74H144c-17.7 0-32 14.3-32 32v200c0 4.4 3.6 8 8 8h40v344c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V550h40c4.4 0 8-3.6 8-8V342c0-17.7-14.3-32-32-32zM478 858H228V550h250v308zm0-376H180V378h298v104zm0-176h-70c-38.6 0-70-31.4-70-70s31.4-70 70-70 70 31.4 70 70v70zm68-70c0-38.6 31.4-70 70-70s70 31.4 70 70-31.4 70-70 70h-70v-70zm250 622H546V550h250v308zm48-376H546V378h298v104z", "fill": primaryColor } }] }; }, "name": "gift", "theme": "twotone" };
	exports.default = GiftTwoTone;
	});

	var GiftTwoToneSvg = unwrapExports(GiftTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var GiftTwoTone = function GiftTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: GiftTwoToneSvg
	  }));
	};

	GiftTwoTone.displayName = 'GiftTwoTone';
	var GiftTwoTone$1 = /*#__PURE__*/React.forwardRef(GiftTwoTone);

	var GithubFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var GithubFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M511.6 76.3C264.3 76.2 64 276.4 64 523.5 64 718.9 189.3 885 363.8 946c23.5 5.9 19.9-10.8 19.9-22.2v-77.5c-135.7 15.9-141.2-73.9-150.3-88.9C215 726 171.5 718 184.5 703c30.9-15.9 62.4 4 98.9 57.9 26.4 39.1 77.9 32.5 104 26 5.7-23.5 17.9-44.5 34.7-60.8-140.6-25.2-199.2-111-199.2-213 0-49.5 16.3-95 48.3-131.7-20.4-60.5 1.9-112.3 4.9-120 58.1-5.2 118.5 41.6 123.2 45.3 33-8.9 70.7-13.6 112.9-13.6 42.4 0 80.2 4.9 113.5 13.9 11.3-8.6 67.3-48.8 121.3-43.9 2.9 7.7 24.7 58.3 5.5 118 32.4 36.8 48.9 82.7 48.9 132.3 0 102.2-59 188.1-200 212.9a127.5 127.5 0 0138.1 91v112.5c.8 9 0 17.9 15 17.9 177.1-59.7 304.6-227 304.6-424.1 0-247.2-200.4-447.3-447.5-447.3z" } }] }, "name": "github", "theme": "filled" };
	exports.default = GithubFilled;
	});

	var GithubFilledSvg = unwrapExports(GithubFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var GithubFilled = function GithubFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: GithubFilledSvg
	  }));
	};

	GithubFilled.displayName = 'GithubFilled';
	var GithubFilled$1 = /*#__PURE__*/React.forwardRef(GithubFilled);

	var GithubOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var GithubOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M511.6 76.3C264.3 76.2 64 276.4 64 523.5 64 718.9 189.3 885 363.8 946c23.5 5.9 19.9-10.8 19.9-22.2v-77.5c-135.7 15.9-141.2-73.9-150.3-88.9C215 726 171.5 718 184.5 703c30.9-15.9 62.4 4 98.9 57.9 26.4 39.1 77.9 32.5 104 26 5.7-23.5 17.9-44.5 34.7-60.8-140.6-25.2-199.2-111-199.2-213 0-49.5 16.3-95 48.3-131.7-20.4-60.5 1.9-112.3 4.9-120 58.1-5.2 118.5 41.6 123.2 45.3 33-8.9 70.7-13.6 112.9-13.6 42.4 0 80.2 4.9 113.5 13.9 11.3-8.6 67.3-48.8 121.3-43.9 2.9 7.7 24.7 58.3 5.5 118 32.4 36.8 48.9 82.7 48.9 132.3 0 102.2-59 188.1-200 212.9a127.5 127.5 0 0138.1 91v112.5c.8 9 0 17.9 15 17.9 177.1-59.7 304.6-227 304.6-424.1 0-247.2-200.4-447.3-447.5-447.3z" } }] }, "name": "github", "theme": "outlined" };
	exports.default = GithubOutlined;
	});

	var GithubOutlinedSvg = unwrapExports(GithubOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var GithubOutlined = function GithubOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: GithubOutlinedSvg
	  }));
	};

	GithubOutlined.displayName = 'GithubOutlined';
	var GithubOutlined$1 = /*#__PURE__*/React.forwardRef(GithubOutlined);

	var GitlabFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var GitlabFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M910.5 553.2l-109-370.8c-6.8-20.4-23.1-34.1-44.9-34.1s-39.5 12.3-46.3 32.7l-72.2 215.4H386.2L314 181.1c-6.8-20.4-24.5-32.7-46.3-32.7s-39.5 13.6-44.9 34.1L113.9 553.2c-4.1 13.6 1.4 28.6 12.3 36.8l385.4 289 386.7-289c10.8-8.1 16.3-23.1 12.2-36.8z" } }] }, "name": "gitlab", "theme": "filled" };
	exports.default = GitlabFilled;
	});

	var GitlabFilledSvg = unwrapExports(GitlabFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var GitlabFilled = function GitlabFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: GitlabFilledSvg
	  }));
	};

	GitlabFilled.displayName = 'GitlabFilled';
	var GitlabFilled$1 = /*#__PURE__*/React.forwardRef(GitlabFilled);

	var GitlabOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var GitlabOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M913.9 552.2L805 181.4v-.1c-7.6-22.9-25.7-36.5-48.3-36.5-23.4 0-42.5 13.5-49.7 35.2l-71.4 213H388.8l-71.4-213c-7.2-21.7-26.3-35.2-49.7-35.2-23.1 0-42.5 14.8-48.4 36.6L110.5 552.2c-4.4 14.7 1.2 31.4 13.5 40.7l368.5 276.4c2.6 3.6 6.2 6.3 10.4 7.8l8.6 6.4 8.5-6.4c4.9-1.7 9-4.7 11.9-8.9l368.4-275.4c12.4-9.2 18-25.9 13.6-40.6zM751.7 193.4c1-1.8 2.9-1.9 3.5-1.9 1.1 0 2.5.3 3.4 3L818 394.3H684.5l67.2-200.9zm-487.4 1c.9-2.6 2.3-2.9 3.4-2.9 2.7 0 2.9.1 3.4 1.7l67.3 201.2H206.5l57.8-200zM158.8 558.7l28.2-97.3 202.4 270.2-230.6-172.9zm73.9-116.4h122.1l90.8 284.3-212.9-284.3zM512.9 776L405.7 442.3H620L512.9 776zm157.9-333.7h119.5L580 723.1l90.8-280.8zm-40.7 293.9l207.3-276.7 29.5 99.2-236.8 177.5z" } }] }, "name": "gitlab", "theme": "outlined" };
	exports.default = GitlabOutlined;
	});

	var GitlabOutlinedSvg = unwrapExports(GitlabOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var GitlabOutlined = function GitlabOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: GitlabOutlinedSvg
	  }));
	};

	GitlabOutlined.displayName = 'GitlabOutlined';
	var GitlabOutlined$1 = /*#__PURE__*/React.forwardRef(GitlabOutlined);

	var GlobalOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var GlobalOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.4 800.9c.2-.3.5-.6.7-.9C920.6 722.1 960 621.7 960 512s-39.4-210.1-104.8-288c-.2-.3-.5-.5-.7-.8-1.1-1.3-2.1-2.5-3.2-3.7-.4-.5-.8-.9-1.2-1.4l-4.1-4.7-.1-.1c-1.5-1.7-3.1-3.4-4.6-5.1l-.1-.1c-3.2-3.4-6.4-6.8-9.7-10.1l-.1-.1-4.8-4.8-.3-.3c-1.5-1.5-3-2.9-4.5-4.3-.5-.5-1-1-1.6-1.5-1-1-2-1.9-3-2.8-.3-.3-.7-.6-1-1C736.4 109.2 629.5 64 512 64s-224.4 45.2-304.3 119.2c-.3.3-.7.6-1 1-1 .9-2 1.9-3 2.9-.5.5-1 1-1.6 1.5-1.5 1.4-3 2.9-4.5 4.3l-.3.3-4.8 4.8-.1.1c-3.3 3.3-6.5 6.7-9.7 10.1l-.1.1c-1.6 1.7-3.1 3.4-4.6 5.1l-.1.1c-1.4 1.5-2.8 3.1-4.1 4.7-.4.5-.8.9-1.2 1.4-1.1 1.2-2.1 2.5-3.2 3.7-.2.3-.5.5-.7.8C103.4 301.9 64 402.3 64 512s39.4 210.1 104.8 288c.2.3.5.6.7.9l3.1 3.7c.4.5.8.9 1.2 1.4l4.1 4.7c0 .1.1.1.1.2 1.5 1.7 3 3.4 4.6 5l.1.1c3.2 3.4 6.4 6.8 9.6 10.1l.1.1c1.6 1.6 3.1 3.2 4.7 4.7l.3.3c3.3 3.3 6.7 6.5 10.1 9.6 80.1 74 187 119.2 304.5 119.2s224.4-45.2 304.3-119.2a300 300 0 0010-9.6l.3-.3c1.6-1.6 3.2-3.1 4.7-4.7l.1-.1c3.3-3.3 6.5-6.7 9.6-10.1l.1-.1c1.5-1.7 3.1-3.3 4.6-5 0-.1.1-.1.1-.2 1.4-1.5 2.8-3.1 4.1-4.7.4-.5.8-.9 1.2-1.4a99 99 0 003.3-3.7zm4.1-142.6c-13.8 32.6-32 62.8-54.2 90.2a444.07 444.07 0 00-81.5-55.9c11.6-46.9 18.8-98.4 20.7-152.6H887c-3 40.9-12.6 80.6-28.5 118.3zM887 484H743.5c-1.9-54.2-9.1-105.7-20.7-152.6 29.3-15.6 56.6-34.4 81.5-55.9A373.86 373.86 0 01887 484zM658.3 165.5c39.7 16.8 75.8 40 107.6 69.2a394.72 394.72 0 01-59.4 41.8c-15.7-45-35.8-84.1-59.2-115.4 3.7 1.4 7.4 2.9 11 4.4zm-90.6 700.6c-9.2 7.2-18.4 12.7-27.7 16.4V697a389.1 389.1 0 01115.7 26.2c-8.3 24.6-17.9 47.3-29 67.8-17.4 32.4-37.8 58.3-59 75.1zm59-633.1c11 20.6 20.7 43.3 29 67.8A389.1 389.1 0 01540 327V141.6c9.2 3.7 18.5 9.1 27.7 16.4 21.2 16.7 41.6 42.6 59 75zM540 640.9V540h147.5c-1.6 44.2-7.1 87.1-16.3 127.8l-.3 1.2A445.02 445.02 0 00540 640.9zm0-156.9V383.1c45.8-2.8 89.8-12.5 130.9-28.1l.3 1.2c9.2 40.7 14.7 83.5 16.3 127.8H540zm-56 56v100.9c-45.8 2.8-89.8 12.5-130.9 28.1l-.3-1.2c-9.2-40.7-14.7-83.5-16.3-127.8H484zm-147.5-56c1.6-44.2 7.1-87.1 16.3-127.8l.3-1.2c41.1 15.6 85 25.3 130.9 28.1V484H336.5zM484 697v185.4c-9.2-3.7-18.5-9.1-27.7-16.4-21.2-16.7-41.7-42.7-59.1-75.1-11-20.6-20.7-43.3-29-67.8 37.2-14.6 75.9-23.3 115.8-26.1zm0-370a389.1 389.1 0 01-115.7-26.2c8.3-24.6 17.9-47.3 29-67.8 17.4-32.4 37.8-58.4 59.1-75.1 9.2-7.2 18.4-12.7 27.7-16.4V327zM365.7 165.5c3.7-1.5 7.3-3 11-4.4-23.4 31.3-43.5 70.4-59.2 115.4-21-12-40.9-26-59.4-41.8 31.8-29.2 67.9-52.4 107.6-69.2zM165.5 365.7c13.8-32.6 32-62.8 54.2-90.2 24.9 21.5 52.2 40.3 81.5 55.9-11.6 46.9-18.8 98.4-20.7 152.6H137c3-40.9 12.6-80.6 28.5-118.3zM137 540h143.5c1.9 54.2 9.1 105.7 20.7 152.6a444.07 444.07 0 00-81.5 55.9A373.86 373.86 0 01137 540zm228.7 318.5c-39.7-16.8-75.8-40-107.6-69.2 18.5-15.8 38.4-29.7 59.4-41.8 15.7 45 35.8 84.1 59.2 115.4-3.7-1.4-7.4-2.9-11-4.4zm292.6 0c-3.7 1.5-7.3 3-11 4.4 23.4-31.3 43.5-70.4 59.2-115.4 21 12 40.9 26 59.4 41.8a373.81 373.81 0 01-107.6 69.2z" } }] }, "name": "global", "theme": "outlined" };
	exports.default = GlobalOutlined;
	});

	var GlobalOutlinedSvg = unwrapExports(GlobalOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var GlobalOutlined = function GlobalOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: GlobalOutlinedSvg
	  }));
	};

	GlobalOutlined.displayName = 'GlobalOutlined';
	var GlobalOutlined$1 = /*#__PURE__*/React.forwardRef(GlobalOutlined);

	var GoldFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var GoldFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M905.9 806.7l-40.2-248c-.6-3.9-4-6.7-7.9-6.7H596.2c-3.9 0-7.3 2.8-7.9 6.7l-40.2 248c-.1.4-.1.9-.1 1.3 0 4.4 3.6 8 8 8h342c.4 0 .9 0 1.3-.1 4.3-.7 7.3-4.8 6.6-9.2zm-470.2-248c-.6-3.9-4-6.7-7.9-6.7H166.2c-3.9 0-7.3 2.8-7.9 6.7l-40.2 248c-.1.4-.1.9-.1 1.3 0 4.4 3.6 8 8 8h342c.4 0 .9 0 1.3-.1 4.4-.7 7.3-4.8 6.6-9.2l-40.2-248zM342 472h342c.4 0 .9 0 1.3-.1 4.4-.7 7.3-4.8 6.6-9.2l-40.2-248c-.6-3.9-4-6.7-7.9-6.7H382.2c-3.9 0-7.3 2.8-7.9 6.7l-40.2 248c-.1.4-.1.9-.1 1.3 0 4.4 3.6 8 8 8z" } }] }, "name": "gold", "theme": "filled" };
	exports.default = GoldFilled;
	});

	var GoldFilledSvg = unwrapExports(GoldFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var GoldFilled = function GoldFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: GoldFilledSvg
	  }));
	};

	GoldFilled.displayName = 'GoldFilled';
	var GoldFilled$1 = /*#__PURE__*/React.forwardRef(GoldFilled);

	var GoldOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var GoldOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M342 472h342c.4 0 .9 0 1.3-.1 4.4-.7 7.3-4.8 6.6-9.2l-40.2-248c-.6-3.9-4-6.7-7.9-6.7H382.2c-3.9 0-7.3 2.8-7.9 6.7l-40.2 248c-.1.4-.1.9-.1 1.3 0 4.4 3.6 8 8 8zm91.2-196h159.5l20.7 128h-201l20.8-128zm2.5 282.7c-.6-3.9-4-6.7-7.9-6.7H166.2c-3.9 0-7.3 2.8-7.9 6.7l-40.2 248c-.1.4-.1.9-.1 1.3 0 4.4 3.6 8 8 8h342c.4 0 .9 0 1.3-.1 4.4-.7 7.3-4.8 6.6-9.2l-40.2-248zM196.5 748l20.7-128h159.5l20.7 128H196.5zm709.4 58.7l-40.2-248c-.6-3.9-4-6.7-7.9-6.7H596.2c-3.9 0-7.3 2.8-7.9 6.7l-40.2 248c-.1.4-.1.9-.1 1.3 0 4.4 3.6 8 8 8h342c.4 0 .9 0 1.3-.1 4.3-.7 7.3-4.8 6.6-9.2zM626.5 748l20.7-128h159.5l20.7 128H626.5z" } }] }, "name": "gold", "theme": "outlined" };
	exports.default = GoldOutlined;
	});

	var GoldOutlinedSvg = unwrapExports(GoldOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var GoldOutlined = function GoldOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: GoldOutlinedSvg
	  }));
	};

	GoldOutlined.displayName = 'GoldOutlined';
	var GoldOutlined$1 = /*#__PURE__*/React.forwardRef(GoldOutlined);

	var GoldTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var GoldTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M435.7 558.7c-.6-3.9-4-6.7-7.9-6.7H166.2c-3.9 0-7.3 2.8-7.9 6.7l-40.2 248c-.1.4-.1.9-.1 1.3 0 4.4 3.6 8 8 8h342c.4 0 .9 0 1.3-.1 4.4-.7 7.3-4.8 6.6-9.2l-40.2-248zM196.5 748l20.7-128h159.5l20.7 128H196.5zm709.4 58.7l-40.2-248c-.6-3.9-4-6.7-7.9-6.7H596.2c-3.9 0-7.3 2.8-7.9 6.7l-40.2 248c-.1.4-.1.9-.1 1.3 0 4.4 3.6 8 8 8h342c.4 0 .9 0 1.3-.1 4.3-.7 7.3-4.8 6.6-9.2zM626.5 748l20.7-128h159.5l20.7 128H626.5zM342 472h342c.4 0 .9 0 1.3-.1 4.4-.7 7.3-4.8 6.6-9.2l-40.2-248c-.6-3.9-4-6.7-7.9-6.7H382.2c-3.9 0-7.3 2.8-7.9 6.7l-40.2 248c-.1.4-.1.9-.1 1.3 0 4.4 3.6 8 8 8zm91.2-196h159.5l20.7 128h-201l20.8-128z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M592.7 276H433.2l-20.8 128h201zM217.2 620l-20.7 128h200.9l-20.7-128zm430 0l-20.7 128h200.9l-20.7-128z", "fill": secondaryColor } }] }; }, "name": "gold", "theme": "twotone" };
	exports.default = GoldTwoTone;
	});

	var GoldTwoToneSvg = unwrapExports(GoldTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var GoldTwoTone = function GoldTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: GoldTwoToneSvg
	  }));
	};

	GoldTwoTone.displayName = 'GoldTwoTone';
	var GoldTwoTone$1 = /*#__PURE__*/React.forwardRef(GoldTwoTone);

	var GoldenFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var GoldenFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M905.9 806.7l-40.2-248c-.6-3.9-4-6.7-7.9-6.7H596.2c-3.9 0-7.3 2.8-7.9 6.7l-40.2 248c-.1.4-.1.9-.1 1.3 0 4.4 3.6 8 8 8h342c.4 0 .9 0 1.3-.1 4.3-.7 7.3-4.8 6.6-9.2zm-470.2-248c-.6-3.9-4-6.7-7.9-6.7H166.2c-3.9 0-7.3 2.8-7.9 6.7l-40.2 248c-.1.4-.1.9-.1 1.3 0 4.4 3.6 8 8 8h342c.4 0 .9 0 1.3-.1 4.4-.7 7.3-4.8 6.6-9.2l-40.2-248zM342 472h342c.4 0 .9 0 1.3-.1 4.4-.7 7.3-4.8 6.6-9.2l-40.2-248c-.6-3.9-4-6.7-7.9-6.7H382.2c-3.9 0-7.3 2.8-7.9 6.7l-40.2 248c-.1.4-.1.9-.1 1.3 0 4.4 3.6 8 8 8z" } }] }, "name": "golden", "theme": "filled" };
	exports.default = GoldenFilled;
	});

	var GoldenFilledSvg = unwrapExports(GoldenFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var GoldenFilled = function GoldenFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: GoldenFilledSvg
	  }));
	};

	GoldenFilled.displayName = 'GoldenFilled';
	var GoldenFilled$1 = /*#__PURE__*/React.forwardRef(GoldenFilled);

	var GoogleCircleFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var GoogleCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm167 633.6C638.4 735 583 757 516.9 757c-95.7 0-178.5-54.9-218.8-134.9C281.5 589 272 551.6 272 512s9.5-77 26.1-110.1c40.3-80.1 123.1-135 218.8-135 66 0 121.4 24.3 163.9 63.8L610.6 401c-25.4-24.3-57.7-36.6-93.6-36.6-63.8 0-117.8 43.1-137.1 101-4.9 14.7-7.7 30.4-7.7 46.6s2.8 31.9 7.7 46.6c19.3 57.9 73.3 101 137 101 33 0 61-8.7 82.9-23.4 26-17.4 43.2-43.3 48.9-74H516.9v-94.8h230.7c2.9 16.1 4.4 32.8 4.4 50.1 0 74.7-26.7 137.4-73 180.1z" } }] }, "name": "google-circle", "theme": "filled" };
	exports.default = GoogleCircleFilled;
	});

	var GoogleCircleFilledSvg = unwrapExports(GoogleCircleFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var GoogleCircleFilled = function GoogleCircleFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: GoogleCircleFilledSvg
	  }));
	};

	GoogleCircleFilled.displayName = 'GoogleCircleFilled';
	var GoogleCircleFilled$1 = /*#__PURE__*/React.forwardRef(GoogleCircleFilled);

	var GoogleOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var GoogleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M881 442.4H519.7v148.5h206.4c-8.9 48-35.9 88.6-76.6 115.8-34.4 23-78.3 36.6-129.9 36.6-99.9 0-184.4-67.5-214.6-158.2-7.6-23-12-47.6-12-72.9s4.4-49.9 12-72.9c30.3-90.6 114.8-158.1 214.7-158.1 56.3 0 106.8 19.4 146.6 57.4l110-110.1c-66.5-62-153.2-100-256.6-100-149.9 0-279.6 86-342.7 211.4-26 51.8-40.8 110.4-40.8 172.4S151 632.8 177 684.6C240.1 810 369.8 896 519.7 896c103.6 0 190.4-34.4 253.8-93 72.5-66.8 114.4-165.2 114.4-282.1 0-27.2-2.4-53.3-6.9-78.5z" } }] }, "name": "google", "theme": "outlined" };
	exports.default = GoogleOutlined;
	});

	var GoogleOutlinedSvg = unwrapExports(GoogleOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var GoogleOutlined = function GoogleOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: GoogleOutlinedSvg
	  }));
	};

	GoogleOutlined.displayName = 'GoogleOutlined';
	var GoogleOutlined$1 = /*#__PURE__*/React.forwardRef(GoogleOutlined);

	var GooglePlusCircleFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var GooglePlusCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm36.5 558.8c-43.9 61.8-132.1 79.8-200.9 53.3-69-26.3-118-99.2-112.1-173.5 1.5-90.9 85.2-170.6 176.1-167.5 43.6-2 84.6 16.9 118 43.6-14.3 16.2-29 31.8-44.8 46.3-40.1-27.7-97.2-35.6-137.3-3.6-57.4 39.7-60 133.4-4.8 176.1 53.7 48.7 155.2 24.5 170.1-50.1-33.6-.5-67.4 0-101-1.1-.1-20.1-.2-40.1-.1-60.2 56.2-.2 112.5-.3 168.8.2 3.3 47.3-3 97.5-32 136.5zM791 536.5c-16.8.2-33.6.3-50.4.4-.2 16.8-.3 33.6-.3 50.4H690c-.2-16.8-.2-33.5-.3-50.3-16.8-.2-33.6-.3-50.4-.5v-50.1c16.8-.2 33.6-.3 50.4-.3.1-16.8.3-33.6.4-50.4h50.2l.3 50.4c16.8.2 33.6.2 50.4.3v50.1z" } }] }, "name": "google-plus-circle", "theme": "filled" };
	exports.default = GooglePlusCircleFilled;
	});

	var GooglePlusCircleFilledSvg = unwrapExports(GooglePlusCircleFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var GooglePlusCircleFilled = function GooglePlusCircleFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: GooglePlusCircleFilledSvg
	  }));
	};

	GooglePlusCircleFilled.displayName = 'GooglePlusCircleFilled';
	var GooglePlusCircleFilled$1 = /*#__PURE__*/React.forwardRef(GooglePlusCircleFilled);

	var GooglePlusOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var GooglePlusOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M879.5 470.4c-.3-27-.4-54.2-.5-81.3h-80.8c-.3 27-.5 54.1-.7 81.3-27.2.1-54.2.3-81.2.6v80.9c27 .3 54.2.5 81.2.8.3 27 .3 54.1.5 81.1h80.9c.1-27 .3-54.1.5-81.3 27.2-.3 54.2-.4 81.2-.7v-80.9c-26.9-.2-54.1-.2-81.1-.5zm-530 .4c-.1 32.3 0 64.7.1 97 54.2 1.8 108.5 1 162.7 1.8-23.9 120.3-187.4 159.3-273.9 80.7-89-68.9-84.8-220 7.7-284 64.7-51.6 156.6-38.9 221.3 5.8 25.4-23.5 49.2-48.7 72.1-74.7-53.8-42.9-119.8-73.5-190-70.3-146.6-4.9-281.3 123.5-283.7 270.2-9.4 119.9 69.4 237.4 180.6 279.8 110.8 42.7 252.9 13.6 323.7-86 46.7-62.9 56.8-143.9 51.3-220-90.7-.7-181.3-.6-271.9-.3z" } }] }, "name": "google-plus", "theme": "outlined" };
	exports.default = GooglePlusOutlined;
	});

	var GooglePlusOutlinedSvg = unwrapExports(GooglePlusOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var GooglePlusOutlined = function GooglePlusOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: GooglePlusOutlinedSvg
	  }));
	};

	GooglePlusOutlined.displayName = 'GooglePlusOutlined';
	var GooglePlusOutlined$1 = /*#__PURE__*/React.forwardRef(GooglePlusOutlined);

	var GooglePlusSquareFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var GooglePlusSquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM548.5 622.8c-43.9 61.8-132.1 79.8-200.9 53.3-69-26.3-118-99.2-112.1-173.5 1.5-90.9 85.2-170.6 176.1-167.5 43.6-2 84.6 16.9 118 43.6-14.3 16.2-29 31.8-44.8 46.3-40.1-27.7-97.2-35.6-137.3-3.6-57.4 39.7-60 133.4-4.8 176.1 53.7 48.7 155.2 24.5 170.1-50.1-33.6-.5-67.4 0-101-1.1-.1-20.1-.2-40.1-.1-60.2 56.2-.2 112.5-.3 168.8.2 3.3 47.3-3 97.5-32 136.5zM791 536.5c-16.8.2-33.6.3-50.4.4-.2 16.8-.3 33.6-.3 50.4H690c-.2-16.8-.2-33.5-.3-50.3-16.8-.2-33.6-.3-50.4-.5v-50.1c16.8-.2 33.6-.3 50.4-.3.1-16.8.3-33.6.4-50.4h50.2l.3 50.4c16.8.2 33.6.2 50.4.3v50.1z" } }] }, "name": "google-plus-square", "theme": "filled" };
	exports.default = GooglePlusSquareFilled;
	});

	var GooglePlusSquareFilledSvg = unwrapExports(GooglePlusSquareFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var GooglePlusSquareFilled = function GooglePlusSquareFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: GooglePlusSquareFilledSvg
	  }));
	};

	GooglePlusSquareFilled.displayName = 'GooglePlusSquareFilled';
	var GooglePlusSquareFilled$1 = /*#__PURE__*/React.forwardRef(GooglePlusSquareFilled);

	var GoogleSquareFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var GoogleSquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM679 697.6C638.4 735 583 757 516.9 757c-95.7 0-178.5-54.9-218.8-134.9A245.02 245.02 0 01272 512c0-39.6 9.5-77 26.1-110.1 40.3-80.1 123.1-135 218.8-135 66 0 121.4 24.3 163.9 63.8L610.6 401c-25.4-24.3-57.7-36.6-93.6-36.6-63.8 0-117.8 43.1-137.1 101-4.9 14.7-7.7 30.4-7.7 46.6s2.8 31.9 7.7 46.6c19.3 57.9 73.3 101 137 101 33 0 61-8.7 82.9-23.4 26-17.4 43.2-43.3 48.9-74H516.9v-94.8h230.7c2.9 16.1 4.4 32.8 4.4 50.1 0 74.7-26.7 137.4-73 180.1z" } }] }, "name": "google-square", "theme": "filled" };
	exports.default = GoogleSquareFilled;
	});

	var GoogleSquareFilledSvg = unwrapExports(GoogleSquareFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var GoogleSquareFilled = function GoogleSquareFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: GoogleSquareFilledSvg
	  }));
	};

	GoogleSquareFilled.displayName = 'GoogleSquareFilled';
	var GoogleSquareFilled$1 = /*#__PURE__*/React.forwardRef(GoogleSquareFilled);

	var GroupOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var GroupOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M912 820.1V203.9c28-9.9 48-36.6 48-67.9 0-39.8-32.2-72-72-72-31.3 0-58 20-67.9 48H203.9C194 84 167.3 64 136 64c-39.8 0-72 32.2-72 72 0 31.3 20 58 48 67.9v616.2C84 830 64 856.7 64 888c0 39.8 32.2 72 72 72 31.3 0 58-20 67.9-48h616.2c9.9 28 36.6 48 67.9 48 39.8 0 72-32.2 72-72 0-31.3-20-58-48-67.9zM888 112c13.3 0 24 10.7 24 24s-10.7 24-24 24-24-10.7-24-24 10.7-24 24-24zM136 912c-13.3 0-24-10.7-24-24s10.7-24 24-24 24 10.7 24 24-10.7 24-24 24zm0-752c-13.3 0-24-10.7-24-24s10.7-24 24-24 24 10.7 24 24-10.7 24-24 24zm704 680H184V184h656v656zm48 72c-13.3 0-24-10.7-24-24s10.7-24 24-24 24 10.7 24 24-10.7 24-24 24z" } }, { "tag": "path", "attrs": { "d": "M288 474h448c8.8 0 16-7.2 16-16V282c0-8.8-7.2-16-16-16H288c-8.8 0-16 7.2-16 16v176c0 8.8 7.2 16 16 16zm56-136h336v64H344v-64zm-56 420h448c8.8 0 16-7.2 16-16V566c0-8.8-7.2-16-16-16H288c-8.8 0-16 7.2-16 16v176c0 8.8 7.2 16 16 16zm56-136h336v64H344v-64z" } }] }, "name": "group", "theme": "outlined" };
	exports.default = GroupOutlined;
	});

	var GroupOutlinedSvg = unwrapExports(GroupOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var GroupOutlined = function GroupOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: GroupOutlinedSvg
	  }));
	};

	GroupOutlined.displayName = 'GroupOutlined';
	var GroupOutlined$1 = /*#__PURE__*/React.forwardRef(GroupOutlined);

	var HddFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var HddFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M832 64H192c-17.7 0-32 14.3-32 32v224h704V96c0-17.7-14.3-32-32-32zM456 216c0 4.4-3.6 8-8 8H264c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h184c4.4 0 8 3.6 8 8v48zM160 928c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V704H160v224zm576-136c22.1 0 40 17.9 40 40s-17.9 40-40 40-40-17.9-40-40 17.9-40 40-40zM160 640h704V384H160v256zm96-152c0-4.4 3.6-8 8-8h184c4.4 0 8 3.6 8 8v48c0 4.4-3.6 8-8 8H264c-4.4 0-8-3.6-8-8v-48z" } }] }, "name": "hdd", "theme": "filled" };
	exports.default = HddFilled;
	});

	var HddFilledSvg = unwrapExports(HddFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var HddFilled = function HddFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: HddFilledSvg
	  }));
	};

	HddFilled.displayName = 'HddFilled';
	var HddFilled$1 = /*#__PURE__*/React.forwardRef(HddFilled);

	var HddOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var HddOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M832 64H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V96c0-17.7-14.3-32-32-32zm-600 72h560v208H232V136zm560 480H232V408h560v208zm0 272H232V680h560v208zM496 208H312c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h184c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8zM312 544h184c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H312c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8zm328 244a40 40 0 1080 0 40 40 0 10-80 0z" } }] }, "name": "hdd", "theme": "outlined" };
	exports.default = HddOutlined;
	});

	var HddOutlinedSvg = unwrapExports(HddOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var HddOutlined = function HddOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: HddOutlinedSvg
	  }));
	};

	HddOutlined.displayName = 'HddOutlined';
	var HddOutlined$1 = /*#__PURE__*/React.forwardRef(HddOutlined);

	var HddTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var HddTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M232 888h560V680H232v208zm448-140c22.1 0 40 17.9 40 40s-17.9 40-40 40-40-17.9-40-40 17.9-40 40-40zM232 616h560V408H232v208zm72-128c0-4.4 3.6-8 8-8h184c4.4 0 8 3.6 8 8v48c0 4.4-3.6 8-8 8H312c-4.4 0-8-3.6-8-8v-48zm-72-144h560V136H232v208zm72-128c0-4.4 3.6-8 8-8h184c4.4 0 8 3.6 8 8v48c0 4.4-3.6 8-8 8H312c-4.4 0-8-3.6-8-8v-48z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M832 64H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V96c0-17.7-14.3-32-32-32zm-40 824H232V680h560v208zm0-272H232V408h560v208zm0-272H232V136h560v208z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M312 544h184c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H312c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8zm0-272h184c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H312c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8zm328 516a40 40 0 1080 0 40 40 0 10-80 0z", "fill": primaryColor } }] }; }, "name": "hdd", "theme": "twotone" };
	exports.default = HddTwoTone;
	});

	var HddTwoToneSvg = unwrapExports(HddTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var HddTwoTone = function HddTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: HddTwoToneSvg
	  }));
	};

	HddTwoTone.displayName = 'HddTwoTone';
	var HddTwoTone$1 = /*#__PURE__*/React.forwardRef(HddTwoTone);

	var HeartFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var HeartFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M923 283.6a260.04 260.04 0 00-56.9-82.8 264.4 264.4 0 00-84-55.5A265.34 265.34 0 00679.7 125c-49.3 0-97.4 13.5-139.2 39-10 6.1-19.5 12.8-28.5 20.1-9-7.3-18.5-14-28.5-20.1-41.8-25.5-89.9-39-139.2-39-35.5 0-69.9 6.8-102.4 20.3-31.4 13-59.7 31.7-84 55.5a258.44 258.44 0 00-56.9 82.8c-13.9 32.3-21 66.6-21 101.9 0 33.3 6.8 68 20.3 103.3 11.3 29.5 27.5 60.1 48.2 91 32.8 48.9 77.9 99.9 133.9 151.6 92.8 85.7 184.7 144.9 188.6 147.3l23.7 15.2c10.5 6.7 24 6.7 34.5 0l23.7-15.2c3.9-2.5 95.7-61.6 188.6-147.3 56-51.7 101.1-102.7 133.9-151.6 20.7-30.9 37-61.5 48.2-91 13.5-35.3 20.3-70 20.3-103.3.1-35.3-7-69.6-20.9-101.9z" } }] }, "name": "heart", "theme": "filled" };
	exports.default = HeartFilled;
	});

	var HeartFilledSvg = unwrapExports(HeartFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var HeartFilled = function HeartFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: HeartFilledSvg
	  }));
	};

	HeartFilled.displayName = 'HeartFilled';
	var HeartFilled$1 = /*#__PURE__*/React.forwardRef(HeartFilled);

	var HeartOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var HeartOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M923 283.6a260.04 260.04 0 00-56.9-82.8 264.4 264.4 0 00-84-55.5A265.34 265.34 0 00679.7 125c-49.3 0-97.4 13.5-139.2 39-10 6.1-19.5 12.8-28.5 20.1-9-7.3-18.5-14-28.5-20.1-41.8-25.5-89.9-39-139.2-39-35.5 0-69.9 6.8-102.4 20.3-31.4 13-59.7 31.7-84 55.5a258.44 258.44 0 00-56.9 82.8c-13.9 32.3-21 66.6-21 101.9 0 33.3 6.8 68 20.3 103.3 11.3 29.5 27.5 60.1 48.2 91 32.8 48.9 77.9 99.9 133.9 151.6 92.8 85.7 184.7 144.9 188.6 147.3l23.7 15.2c10.5 6.7 24 6.7 34.5 0l23.7-15.2c3.9-2.5 95.7-61.6 188.6-147.3 56-51.7 101.1-102.7 133.9-151.6 20.7-30.9 37-61.5 48.2-91 13.5-35.3 20.3-70 20.3-103.3.1-35.3-7-69.6-20.9-101.9zM512 814.8S156 586.7 156 385.5C156 283.6 240.3 201 344.3 201c73.1 0 136.5 40.8 167.7 100.4C543.2 241.8 606.6 201 679.7 201c104 0 188.3 82.6 188.3 184.5 0 201.2-356 429.3-356 429.3z" } }] }, "name": "heart", "theme": "outlined" };
	exports.default = HeartOutlined;
	});

	var HeartOutlinedSvg = unwrapExports(HeartOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var HeartOutlined = function HeartOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: HeartOutlinedSvg
	  }));
	};

	HeartOutlined.displayName = 'HeartOutlined';
	var HeartOutlined$1 = /*#__PURE__*/React.forwardRef(HeartOutlined);

	var HeartTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var HeartTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M923 283.6a260.04 260.04 0 00-56.9-82.8 264.4 264.4 0 00-84-55.5A265.34 265.34 0 00679.7 125c-49.3 0-97.4 13.5-139.2 39-10 6.1-19.5 12.8-28.5 20.1-9-7.3-18.5-14-28.5-20.1-41.8-25.5-89.9-39-139.2-39-35.5 0-69.9 6.8-102.4 20.3-31.4 13-59.7 31.7-84 55.5a258.44 258.44 0 00-56.9 82.8c-13.9 32.3-21 66.6-21 101.9 0 33.3 6.8 68 20.3 103.3 11.3 29.5 27.5 60.1 48.2 91 32.8 48.9 77.9 99.9 133.9 151.6 92.8 85.7 184.7 144.9 188.6 147.3l23.7 15.2c10.5 6.7 24 6.7 34.5 0l23.7-15.2c3.9-2.5 95.7-61.6 188.6-147.3 56-51.7 101.1-102.7 133.9-151.6 20.7-30.9 37-61.5 48.2-91 13.5-35.3 20.3-70 20.3-103.3.1-35.3-7-69.6-20.9-101.9zM512 814.8S156 586.7 156 385.5C156 283.6 240.3 201 344.3 201c73.1 0 136.5 40.8 167.7 100.4C543.2 241.8 606.6 201 679.7 201c104 0 188.3 82.6 188.3 184.5 0 201.2-356 429.3-356 429.3z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M679.7 201c-73.1 0-136.5 40.8-167.7 100.4C480.8 241.8 417.4 201 344.3 201c-104 0-188.3 82.6-188.3 184.5 0 201.2 356 429.3 356 429.3s356-228.1 356-429.3C868 283.6 783.7 201 679.7 201z", "fill": secondaryColor } }] }; }, "name": "heart", "theme": "twotone" };
	exports.default = HeartTwoTone;
	});

	var HeartTwoToneSvg = unwrapExports(HeartTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var HeartTwoTone = function HeartTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: HeartTwoToneSvg
	  }));
	};

	HeartTwoTone.displayName = 'HeartTwoTone';
	var HeartTwoTone$1 = /*#__PURE__*/React.forwardRef(HeartTwoTone);

	var HeatMapOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var HeatMapOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M955.7 856l-416-720c-6.2-10.7-16.9-16-27.7-16s-21.6 5.3-27.7 16l-416 720C56 877.4 71.4 904 96 904h832c24.6 0 40-26.6 27.7-48zm-790.4-23.9L512 231.9 858.7 832H165.3zm319-474.1l-228 394c-12.3 21.3 3.1 48 27.7 48h455.8c24.7 0 40.1-26.7 27.7-48L539.7 358c-6.2-10.7-17-16-27.7-16-10.8 0-21.6 5.3-27.7 16zm214 386H325.7L512 422l186.3 322zm-214-194.1l-57 98.4C415 669.5 430.4 696 455 696h114c24.6 0 39.9-26.5 27.7-47.7l-57-98.4c-6.1-10.6-16.9-15.9-27.7-15.9s-21.5 5.3-27.7 15.9zm57.1 98.4h-58.7l29.4-50.7 29.3 50.7z" } }] }, "name": "heat-map", "theme": "outlined" };
	exports.default = HeatMapOutlined;
	});

	var HeatMapOutlinedSvg = unwrapExports(HeatMapOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var HeatMapOutlined = function HeatMapOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: HeatMapOutlinedSvg
	  }));
	};

	HeatMapOutlined.displayName = 'HeatMapOutlined';
	var HeatMapOutlined$1 = /*#__PURE__*/React.forwardRef(HeatMapOutlined);

	var HighlightFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var HighlightFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M957.6 507.4L603.2 158.2a7.9 7.9 0 00-11.2 0L353.3 393.4a8.03 8.03 0 00-.1 11.3l.1.1 40 39.4-117.2 115.3a8.03 8.03 0 00-.1 11.3l.1.1 39.5 38.9-189.1 187H72.1c-4.4 0-8.1 3.6-8.1 8V860c0 4.4 3.6 8 8 8h344.9c2.1 0 4.1-.8 5.6-2.3l76.1-75.6 40.4 39.8a7.9 7.9 0 0011.2 0l117.1-115.6 40.1 39.5a7.9 7.9 0 0011.2 0l238.7-235.2c3.4-3 3.4-8 .3-11.2z" } }] }, "name": "highlight", "theme": "filled" };
	exports.default = HighlightFilled;
	});

	var HighlightFilledSvg = unwrapExports(HighlightFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var HighlightFilled = function HighlightFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: HighlightFilledSvg
	  }));
	};

	HighlightFilled.displayName = 'HighlightFilled';
	var HighlightFilled$1 = /*#__PURE__*/React.forwardRef(HighlightFilled);

	var HighlightOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var HighlightOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M957.6 507.4L603.2 158.2a7.9 7.9 0 00-11.2 0L353.3 393.4a8.03 8.03 0 00-.1 11.3l.1.1 40 39.4-117.2 115.3a8.03 8.03 0 00-.1 11.3l.1.1 39.5 38.9-189.1 187H72.1c-4.4 0-8.1 3.6-8.1 8V860c0 4.4 3.6 8 8 8h344.9c2.1 0 4.1-.8 5.6-2.3l76.1-75.6 40.4 39.8a7.9 7.9 0 0011.2 0l117.1-115.6 40.1 39.5a7.9 7.9 0 0011.2 0l238.7-235.2c3.4-3 3.4-8 .3-11.2zM389.8 796.2H229.6l134.4-133 80.1 78.9-54.3 54.1zm154.8-62.1L373.2 565.2l68.6-67.6 171.4 168.9-68.6 67.6zM713.1 658L450.3 399.1 597.6 254l262.8 259-147.3 145z" } }] }, "name": "highlight", "theme": "outlined" };
	exports.default = HighlightOutlined;
	});

	var HighlightOutlinedSvg = unwrapExports(HighlightOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var HighlightOutlined = function HighlightOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: HighlightOutlinedSvg
	  }));
	};

	HighlightOutlined.displayName = 'HighlightOutlined';
	var HighlightOutlined$1 = /*#__PURE__*/React.forwardRef(HighlightOutlined);

	var HighlightTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var HighlightTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M229.6 796.3h160.2l54.3-54.1-80.1-78.9zm220.7-397.1l262.8 258.9 147.3-145-262.8-259zm-77.1 166.1l171.4 168.9 68.6-67.6-171.4-168.9z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M957.6 507.5L603.2 158.3a7.9 7.9 0 00-11.2 0L353.3 393.5a8.03 8.03 0 00-.1 11.3l.1.1 40 39.4-117.2 115.3a8.03 8.03 0 00-.1 11.3l.1.1 39.5 38.9-189.1 187H72.1c-4.4 0-8.1 3.6-8.1 8v55.2c0 4.4 3.6 8 8 8h344.9c2.1 0 4.1-.8 5.6-2.3l76.1-75.6L539 830a7.9 7.9 0 0011.2 0l117.1-115.6 40.1 39.5a7.9 7.9 0 0011.2 0l238.7-235.2c3.4-3 3.4-8 .3-11.2zM389.8 796.3H229.6l134.4-133 80.1 78.9-54.3 54.1zm154.8-62.1L373.2 565.3l68.6-67.6 171.4 168.9-68.6 67.6zm168.5-76.1L450.3 399.2l147.3-145.1 262.8 259-147.3 145z", "fill": primaryColor } }] }; }, "name": "highlight", "theme": "twotone" };
	exports.default = HighlightTwoTone;
	});

	var HighlightTwoToneSvg = unwrapExports(HighlightTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var HighlightTwoTone = function HighlightTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: HighlightTwoToneSvg
	  }));
	};

	HighlightTwoTone.displayName = 'HighlightTwoTone';
	var HighlightTwoTone$1 = /*#__PURE__*/React.forwardRef(HighlightTwoTone);

	var HistoryOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var HistoryOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M536.1 273H488c-4.4 0-8 3.6-8 8v275.3c0 2.6 1.2 5 3.3 6.5l165.3 120.7c3.6 2.6 8.6 1.9 11.2-1.7l28.6-39c2.7-3.7 1.9-8.7-1.7-11.2L544.1 528.5V281c0-4.4-3.6-8-8-8zm219.8 75.2l156.8 38.3c5 1.2 9.9-2.6 9.9-7.7l.8-161.5c0-6.7-7.7-10.5-12.9-6.3L752.9 334.1a8 8 0 003 14.1zm167.7 301.1l-56.7-19.5a8 8 0 00-10.1 4.8c-1.9 5.1-3.9 10.1-6 15.1-17.8 42.1-43.3 80-75.9 112.5a353 353 0 01-112.5 75.9 352.18 352.18 0 01-137.7 27.8c-47.8 0-94.1-9.3-137.7-27.8a353 353 0 01-112.5-75.9c-32.5-32.5-58-70.4-75.9-112.5A353.44 353.44 0 01171 512c0-47.8 9.3-94.2 27.8-137.8 17.8-42.1 43.3-80 75.9-112.5a353 353 0 01112.5-75.9C430.6 167.3 477 158 524.8 158s94.1 9.3 137.7 27.8A353 353 0 01775 261.7c10.2 10.3 19.8 21 28.6 32.3l59.8-46.8C784.7 146.6 662.2 81.9 524.6 82 285 82.1 92.6 276.7 95 516.4 97.4 751.9 288.9 942 524.8 942c185.5 0 343.5-117.6 403.7-282.3 1.5-4.2-.7-8.9-4.9-10.4z" } }] }, "name": "history", "theme": "outlined" };
	exports.default = HistoryOutlined;
	});

	var HistoryOutlinedSvg = unwrapExports(HistoryOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var HistoryOutlined = function HistoryOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: HistoryOutlinedSvg
	  }));
	};

	HistoryOutlined.displayName = 'HistoryOutlined';
	var HistoryOutlined$1 = /*#__PURE__*/React.forwardRef(HistoryOutlined);

	var HomeFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var HomeFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M946.5 505L534.6 93.4a31.93 31.93 0 00-45.2 0L77.5 505c-12 12-18.8 28.3-18.8 45.3 0 35.3 28.7 64 64 64h43.4V908c0 17.7 14.3 32 32 32H448V716h112v224h265.9c17.7 0 32-14.3 32-32V614.3h43.4c17 0 33.3-6.7 45.3-18.8 24.9-25 24.9-65.5-.1-90.5z" } }] }, "name": "home", "theme": "filled" };
	exports.default = HomeFilled;
	});

	var HomeFilledSvg = unwrapExports(HomeFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var HomeFilled = function HomeFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: HomeFilledSvg
	  }));
	};

	HomeFilled.displayName = 'HomeFilled';
	var HomeFilled$1 = /*#__PURE__*/React.forwardRef(HomeFilled);

	var HomeOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var HomeOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M946.5 505L560.1 118.8l-25.9-25.9a31.5 31.5 0 00-44.4 0L77.5 505a63.9 63.9 0 00-18.8 46c.4 35.2 29.7 63.3 64.9 63.3h42.5V940h691.8V614.3h43.4c17.1 0 33.2-6.7 45.3-18.8a63.6 63.6 0 0018.7-45.3c0-17-6.7-33.1-18.8-45.2zM568 868H456V664h112v204zm217.9-325.7V868H632V640c0-22.1-17.9-40-40-40H432c-22.1 0-40 17.9-40 40v228H238.1V542.3h-96l370-369.7 23.1 23.1L882 542.3h-96.1z" } }] }, "name": "home", "theme": "outlined" };
	exports.default = HomeOutlined;
	});

	var HomeOutlinedSvg = unwrapExports(HomeOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var HomeOutlined = function HomeOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: HomeOutlinedSvg
	  }));
	};

	HomeOutlined.displayName = 'HomeOutlined';
	var HomeOutlined$1 = /*#__PURE__*/React.forwardRef(HomeOutlined);

	var HomeTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var HomeTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512.1 172.6l-370 369.7h96V868H392V640c0-22.1 17.9-40 40-40h160c22.1 0 40 17.9 40 40v228h153.9V542.3H882L535.2 195.7l-23.1-23.1zm434.5 422.9c-6 6-13.1 10.8-20.8 13.9 7.7-3.2 14.8-7.9 20.8-13.9zm-887-34.7c5 30.3 31.4 53.5 63.1 53.5h.9c-31.9 0-58.9-23-64-53.5zm-.9-10.5v-1.9 1.9zm.1-2.6c.1-3.1.5-6.1 1-9.1-.6 2.9-.9 6-1 9.1z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M951 510c0-.1-.1-.1-.1-.2l-1.8-2.1c-.1-.1-.2-.3-.4-.4-.7-.8-1.5-1.6-2.2-2.4L560.1 118.8l-25.9-25.9a31.5 31.5 0 00-44.4 0L77.5 505a63.6 63.6 0 00-16 26.6l-.6 2.1-.3 1.1-.3 1.2c-.2.7-.3 1.4-.4 2.1 0 .1 0 .3-.1.4-.6 3-.9 6-1 9.1v3.3c0 .5 0 1 .1 1.5 0 .5 0 .9.1 1.4 0 .5.1 1 .1 1.5 0 .6.1 1.2.2 1.8 0 .3.1.6.1.9l.3 2.5v.1c5.1 30.5 32.2 53.5 64 53.5h42.5V940h691.7V614.3h43.4c8.6 0 16.9-1.7 24.5-4.9s14.7-7.9 20.8-13.9a63.6 63.6 0 0018.7-45.3c0-14.7-5-28.8-14.3-40.2zM568 868H456V664h112v204zm217.9-325.7V868H632V640c0-22.1-17.9-40-40-40H432c-22.1 0-40 17.9-40 40v228H238.1V542.3h-96l370-369.7 23.1 23.1L882 542.3h-96.1z", "fill": primaryColor } }] }; }, "name": "home", "theme": "twotone" };
	exports.default = HomeTwoTone;
	});

	var HomeTwoToneSvg = unwrapExports(HomeTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var HomeTwoTone = function HomeTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: HomeTwoToneSvg
	  }));
	};

	HomeTwoTone.displayName = 'HomeTwoTone';
	var HomeTwoTone$1 = /*#__PURE__*/React.forwardRef(HomeTwoTone);

	var HourglassFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var HourglassFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M742 318V184h86c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H196c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h86v134c0 81.5 42.4 153.2 106.4 194-64 40.8-106.4 112.5-106.4 194v134h-86c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h632c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-86V706c0-81.5-42.4-153.2-106.4-194 64-40.8 106.4-112.5 106.4-194z" } }] }, "name": "hourglass", "theme": "filled" };
	exports.default = HourglassFilled;
	});

	var HourglassFilledSvg = unwrapExports(HourglassFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var HourglassFilled = function HourglassFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: HourglassFilledSvg
	  }));
	};

	HourglassFilled.displayName = 'HourglassFilled';
	var HourglassFilled$1 = /*#__PURE__*/React.forwardRef(HourglassFilled);

	var HourglassOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var HourglassOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M742 318V184h86c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H196c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h86v134c0 81.5 42.4 153.2 106.4 194-64 40.8-106.4 112.5-106.4 194v134h-86c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h632c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-86V706c0-81.5-42.4-153.2-106.4-194 64-40.8 106.4-112.5 106.4-194zm-72 388v134H354V706c0-42.2 16.4-81.9 46.3-111.7C430.1 564.4 469.8 548 512 548s81.9 16.4 111.7 46.3C653.6 624.1 670 663.8 670 706zm0-388c0 42.2-16.4 81.9-46.3 111.7C593.9 459.6 554.2 476 512 476s-81.9-16.4-111.7-46.3A156.63 156.63 0 01354 318V184h316v134z" } }] }, "name": "hourglass", "theme": "outlined" };
	exports.default = HourglassOutlined;
	});

	var HourglassOutlinedSvg = unwrapExports(HourglassOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var HourglassOutlined = function HourglassOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: HourglassOutlinedSvg
	  }));
	};

	HourglassOutlined.displayName = 'HourglassOutlined';
	var HourglassOutlined$1 = /*#__PURE__*/React.forwardRef(HourglassOutlined);

	var HourglassTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var HourglassTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 548c-42.2 0-81.9 16.4-111.7 46.3A156.63 156.63 0 00354 706v134h316V706c0-42.2-16.4-81.9-46.3-111.7A156.63 156.63 0 00512 548zM354 318c0 42.2 16.4 81.9 46.3 111.7C430.1 459.6 469.8 476 512 476s81.9-16.4 111.7-46.3C653.6 399.9 670 360.2 670 318V184H354v134z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M742 318V184h86c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H196c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h86v134c0 81.5 42.4 153.2 106.4 194-64 40.8-106.4 112.5-106.4 194v134h-86c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h632c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-86V706c0-81.5-42.4-153.2-106.4-194 64-40.8 106.4-112.5 106.4-194zm-72 388v134H354V706c0-42.2 16.4-81.9 46.3-111.7C430.1 564.4 469.8 548 512 548s81.9 16.4 111.7 46.3C653.6 624.1 670 663.8 670 706zm0-388c0 42.2-16.4 81.9-46.3 111.7C593.9 459.6 554.2 476 512 476s-81.9-16.4-111.7-46.3A156.63 156.63 0 01354 318V184h316v134z", "fill": primaryColor } }] }; }, "name": "hourglass", "theme": "twotone" };
	exports.default = HourglassTwoTone;
	});

	var HourglassTwoToneSvg = unwrapExports(HourglassTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var HourglassTwoTone = function HourglassTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: HourglassTwoToneSvg
	  }));
	};

	HourglassTwoTone.displayName = 'HourglassTwoTone';
	var HourglassTwoTone$1 = /*#__PURE__*/React.forwardRef(HourglassTwoTone);

	var Html5Filled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var Html5Filled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M145.2 96l66 746.6L512 928l299.6-85.4L878.9 96H145.2zm595 177.1l-4.8 47.2-1.7 19.5H382.3l8.2 94.2h335.1l-3.3 24.3-21.2 242.2-1.7 16.2-187 51.6v.3h-1.2l-.3.1v-.1h-.1l-188.6-52L310.8 572h91.1l6.5 73.2 102.4 27.7h.4l102-27.6 11.4-118.6H510.9v-.1H306l-22.8-253.5-1.7-24.3h460.3l-1.6 24.3z" } }] }, "name": "html5", "theme": "filled" };
	exports.default = Html5Filled;
	});

	var Html5FilledSvg = unwrapExports(Html5Filled_1);

	// GENERATE BY ./scripts/generate.ts

	var Html5Filled = function Html5Filled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: Html5FilledSvg
	  }));
	};

	Html5Filled.displayName = 'Html5Filled';
	var Html5Filled$1 = /*#__PURE__*/React.forwardRef(Html5Filled);

	var Html5Outlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var Html5Outlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M145 96l66 746.6L511.8 928l299.6-85.4L878.7 96H145zm610.9 700.6l-244.1 69.6-245.2-69.6-56.7-641.2h603.8l-57.8 641.2zM281 249l1.7 24.3 22.7 253.5h206.5v-.1h112.9l-11.4 118.5L511 672.9v.2h-.8l-102.4-27.7-6.5-73.2h-91l11.3 144.7 188.6 52h1.7v-.4l187.7-51.7 1.7-16.3 21.2-242.2 3.2-24.3H511v.2H389.9l-8.2-94.2h352.1l1.7-19.5 4.8-47.2L742 249H511z" } }] }, "name": "html5", "theme": "outlined" };
	exports.default = Html5Outlined;
	});

	var Html5OutlinedSvg = unwrapExports(Html5Outlined_1);

	// GENERATE BY ./scripts/generate.ts

	var Html5Outlined = function Html5Outlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: Html5OutlinedSvg
	  }));
	};

	Html5Outlined.displayName = 'Html5Outlined';
	var Html5Outlined$1 = /*#__PURE__*/React.forwardRef(Html5Outlined);

	var Html5TwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var Html5TwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M145 96l66 746.6L511.8 928l299.6-85.4L878.7 96H145zm610.9 700.6l-244.1 69.6-245.2-69.6-56.7-641.2h603.8l-57.8 641.2z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M209.9 155.4l56.7 641.2 245.2 69.6 244.1-69.6 57.8-641.2H209.9zm530.4 117.9l-4.8 47.2-1.7 19.5H381.7l8.2 94.2H511v-.2h214.7l-3.2 24.3-21.2 242.2-1.7 16.3-187.7 51.7v.4h-1.7l-188.6-52-11.3-144.7h91l6.5 73.2 102.4 27.7h.8v-.2l102.4-27.7 11.4-118.5H511.9v.1H305.4l-22.7-253.5L281 249h461l-1.7 24.3z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M281 249l1.7 24.3 22.7 253.5h206.5v-.1h112.9l-11.4 118.5L511 672.9v.2h-.8l-102.4-27.7-6.5-73.2h-91l11.3 144.7 188.6 52h1.7v-.4l187.7-51.7 1.7-16.3 21.2-242.2 3.2-24.3H511v.2H389.9l-8.2-94.2h352.1l1.7-19.5 4.8-47.2L742 249H511z", "fill": primaryColor } }] }; }, "name": "html5", "theme": "twotone" };
	exports.default = Html5TwoTone;
	});

	var Html5TwoToneSvg = unwrapExports(Html5TwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var Html5TwoTone = function Html5TwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: Html5TwoToneSvg
	  }));
	};

	Html5TwoTone.displayName = 'Html5TwoTone';
	var Html5TwoTone$1 = /*#__PURE__*/React.forwardRef(Html5TwoTone);

	var IdcardFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var IdcardFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M373 411c-28.5 0-51.7 23.3-51.7 52s23.2 52 51.7 52 51.7-23.3 51.7-52-23.2-52-51.7-52zm555-251H96c-17.7 0-32 14.3-32 32v640c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V192c0-17.7-14.3-32-32-32zM608 420c0-4.4 1-8 2.3-8h123.4c1.3 0 2.3 3.6 2.3 8v48c0 4.4-1 8-2.3 8H610.3c-1.3 0-2.3-3.6-2.3-8v-48zm-86 253h-43.9c-4.2 0-7.6-3.3-7.9-7.5-3.8-50.5-46-90.5-97.2-90.5s-93.4 40-97.2 90.5c-.3 4.2-3.7 7.5-7.9 7.5H224a8 8 0 01-8-8.4c2.8-53.3 32-99.7 74.6-126.1a111.8 111.8 0 01-29.1-75.5c0-61.9 49.9-112 111.4-112s111.4 50.1 111.4 112c0 29.1-11 55.5-29.1 75.5 42.7 26.5 71.8 72.8 74.6 126.1.4 4.6-3.2 8.4-7.8 8.4zm278.9-53H615.1c-3.9 0-7.1-3.6-7.1-8v-48c0-4.4 3.2-8 7.1-8h185.7c3.9 0 7.1 3.6 7.1 8v48h.1c0 4.4-3.2 8-7.1 8z" } }] }, "name": "idcard", "theme": "filled" };
	exports.default = IdcardFilled;
	});

	var IdcardFilledSvg = unwrapExports(IdcardFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var IdcardFilled = function IdcardFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: IdcardFilledSvg
	  }));
	};

	IdcardFilled.displayName = 'IdcardFilled';
	var IdcardFilled$1 = /*#__PURE__*/React.forwardRef(IdcardFilled);

	var IdcardOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var IdcardOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M928 160H96c-17.7 0-32 14.3-32 32v640c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V192c0-17.7-14.3-32-32-32zm-40 632H136V232h752v560zM610.3 476h123.4c1.3 0 2.3-3.6 2.3-8v-48c0-4.4-1-8-2.3-8H610.3c-1.3 0-2.3 3.6-2.3 8v48c0 4.4 1 8 2.3 8zm4.8 144h185.7c3.9 0 7.1-3.6 7.1-8v-48c0-4.4-3.2-8-7.1-8H615.1c-3.9 0-7.1 3.6-7.1 8v48c0 4.4 3.2 8 7.1 8zM224 673h43.9c4.2 0 7.6-3.3 7.9-7.5 3.8-50.5 46-90.5 97.2-90.5s93.4 40 97.2 90.5c.3 4.2 3.7 7.5 7.9 7.5H522a8 8 0 008-8.4c-2.8-53.3-32-99.7-74.6-126.1a111.8 111.8 0 0029.1-75.5c0-61.9-49.9-112-111.4-112s-111.4 50.1-111.4 112c0 29.1 11 55.5 29.1 75.5a158.09 158.09 0 00-74.6 126.1c-.4 4.6 3.2 8.4 7.8 8.4zm149-262c28.5 0 51.7 23.3 51.7 52s-23.2 52-51.7 52-51.7-23.3-51.7-52 23.2-52 51.7-52z" } }] }, "name": "idcard", "theme": "outlined" };
	exports.default = IdcardOutlined;
	});

	var IdcardOutlinedSvg = unwrapExports(IdcardOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var IdcardOutlined = function IdcardOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: IdcardOutlinedSvg
	  }));
	};

	IdcardOutlined.displayName = 'IdcardOutlined';
	var IdcardOutlined$1 = /*#__PURE__*/React.forwardRef(IdcardOutlined);

	var IdcardTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var IdcardTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M928 160H96c-17.7 0-32 14.3-32 32v640c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V192c0-17.7-14.3-32-32-32zm-40 632H136V232h752v560z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M136 792h752V232H136v560zm472-372c0-4.4 1-8 2.3-8h123.4c1.3 0 2.3 3.6 2.3 8v48c0 4.4-1 8-2.3 8H610.3c-1.3 0-2.3-3.6-2.3-8v-48zm0 144c0-4.4 3.2-8 7.1-8h185.7c3.9 0 7.1 3.6 7.1 8v48c0 4.4-3.2 8-7.1 8H615.1c-3.9 0-7.1-3.6-7.1-8v-48zM216.2 664.6c2.8-53.3 31.9-99.6 74.6-126.1-18.1-20-29.1-46.4-29.1-75.5 0-61.9 49.9-112 111.4-112s111.4 50.1 111.4 112c0 29.1-11 55.6-29.1 75.5 42.6 26.4 71.8 72.8 74.6 126.1a8 8 0 01-8 8.4h-43.9c-4.2 0-7.6-3.3-7.9-7.5-3.8-50.5-46-90.5-97.2-90.5s-93.4 40-97.2 90.5c-.3 4.2-3.7 7.5-7.9 7.5H224c-4.6 0-8.2-3.8-7.8-8.4z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M321.3 463a51.7 52 0 10103.4 0 51.7 52 0 10-103.4 0z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M610.3 476h123.4c1.3 0 2.3-3.6 2.3-8v-48c0-4.4-1-8-2.3-8H610.3c-1.3 0-2.3 3.6-2.3 8v48c0 4.4 1 8 2.3 8zm4.8 144h185.7c3.9 0 7.1-3.6 7.1-8v-48c0-4.4-3.2-8-7.1-8H615.1c-3.9 0-7.1 3.6-7.1 8v48c0 4.4 3.2 8 7.1 8zM224 673h43.9c4.2 0 7.6-3.3 7.9-7.5 3.8-50.5 46-90.5 97.2-90.5s93.4 40 97.2 90.5c.3 4.2 3.7 7.5 7.9 7.5H522a8 8 0 008-8.4c-2.8-53.3-32-99.7-74.6-126.1a111.8 111.8 0 0029.1-75.5c0-61.9-49.9-112-111.4-112s-111.4 50.1-111.4 112c0 29.1 11 55.5 29.1 75.5a158.09 158.09 0 00-74.6 126.1c-.4 4.6 3.2 8.4 7.8 8.4zm149-262c28.5 0 51.7 23.3 51.7 52s-23.2 52-51.7 52-51.7-23.3-51.7-52 23.2-52 51.7-52z", "fill": primaryColor } }] }; }, "name": "idcard", "theme": "twotone" };
	exports.default = IdcardTwoTone;
	});

	var IdcardTwoToneSvg = unwrapExports(IdcardTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var IdcardTwoTone = function IdcardTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: IdcardTwoToneSvg
	  }));
	};

	IdcardTwoTone.displayName = 'IdcardTwoTone';
	var IdcardTwoTone$1 = /*#__PURE__*/React.forwardRef(IdcardTwoTone);

	var IeCircleFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var IeCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M693.6 284.4c-24 0-51.1 11.7-72.6 22 46.3 18 86 57.3 112.3 99.6 7.1-18.9 14.6-47.9 14.6-67.9 0-32-22.8-53.7-54.3-53.7zM512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm253.9 492.9H437.1c0 100.4 144.3 136 196.8 47.4h120.8c-32.6 91.7-119.7 146-216.8 146-35.1 0-70.3-.1-101.7-15.6-87.4 44.5-180.3 56.6-180.3-42 0-45.8 23.2-107.1 44-145C335 484 381.3 422.8 435.6 374.5c-43.7 18.9-91.1 66.3-122 101.2 25.9-112.8 129.5-193.6 237.1-186.5 130-59.8 209.7-34.1 209.7 38.6 0 27.4-10.6 63.3-21.4 87.9 25.2 45.5 33.3 97.6 26.9 141.2zM540.5 399.1c-53.7 0-102 39.7-104 94.9h208c-2-55.1-50.6-94.9-104-94.9zM320.6 602.9c-73 152.4 11.5 172.2 100.3 123.3-46.6-27.5-82.6-72.2-100.3-123.3z" } }] }, "name": "ie-circle", "theme": "filled" };
	exports.default = IeCircleFilled;
	});

	var IeCircleFilledSvg = unwrapExports(IeCircleFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var IeCircleFilled = function IeCircleFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: IeCircleFilledSvg
	  }));
	};

	IeCircleFilled.displayName = 'IeCircleFilled';
	var IeCircleFilled$1 = /*#__PURE__*/React.forwardRef(IeCircleFilled);

	var IeOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var IeOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M852.6 367.6c16.3-36.9 32.1-90.7 32.1-131.8 0-109.1-119.5-147.6-314.5-57.9-161.4-10.8-316.8 110.5-355.6 279.7 46.3-52.3 117.4-123.4 183-151.7C316.1 378.3 246.7 470 194 565.6c-31.1 56.9-66 148.8-66 217.5 0 147.9 139.3 129.8 270.4 63 47.1 23.1 99.8 23.4 152.5 23.4 145.7 0 276.4-81.4 325.2-219H694.9c-78.8 132.9-295.2 79.5-295.2-71.2h493.2c9.6-65.4-2.5-143.6-40.3-211.7zM224.8 648.3c26.6 76.7 80.6 143.8 150.4 185-133.1 73.4-259.9 43.6-150.4-185zm174-163.3c3-82.7 75.4-142.3 156-142.3 80.1 0 153 59.6 156 142.3h-312zm276.8-281.4c32.1-15.4 72.8-33 108.8-33 47.1 0 81.4 32.6 81.4 80.6 0 30-11.1 73.5-21.9 101.8-39.3-63.5-98.9-122.4-168.3-149.4z" } }] }, "name": "ie", "theme": "outlined" };
	exports.default = IeOutlined;
	});

	var IeOutlinedSvg = unwrapExports(IeOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var IeOutlined = function IeOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: IeOutlinedSvg
	  }));
	};

	IeOutlined.displayName = 'IeOutlined';
	var IeOutlined$1 = /*#__PURE__*/React.forwardRef(IeOutlined);

	var IeSquareFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var IeSquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM765.9 556.9H437.1c0 100.4 144.3 136 196.8 47.4h120.8c-32.6 91.7-119.7 146-216.8 146-35.1 0-70.3-.1-101.7-15.6-87.4 44.5-180.3 56.6-180.3-42 0-45.8 23.2-107.1 44-145C335 484 381.3 422.8 435.6 374.5c-43.7 18.9-91.1 66.3-122 101.2 25.9-112.8 129.5-193.6 237.1-186.5 130-59.8 209.7-34.1 209.7 38.6 0 27.4-10.6 63.3-21.4 87.9 25.2 45.5 33.3 97.6 26.9 141.2zm-72.3-272.5c-24 0-51.1 11.7-72.6 22 46.3 18 86 57.3 112.3 99.6 7.1-18.9 14.6-47.9 14.6-67.9 0-32-22.8-53.7-54.3-53.7zM540.5 399.1c-53.7 0-102 39.7-104 94.9h208c-2-55.1-50.6-94.9-104-94.9zM320.6 602.9c-73 152.4 11.5 172.2 100.3 123.3-46.6-27.5-82.6-72.2-100.3-123.3z" } }] }, "name": "ie-square", "theme": "filled" };
	exports.default = IeSquareFilled;
	});

	var IeSquareFilledSvg = unwrapExports(IeSquareFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var IeSquareFilled = function IeSquareFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: IeSquareFilledSvg
	  }));
	};

	IeSquareFilled.displayName = 'IeSquareFilled';
	var IeSquareFilled$1 = /*#__PURE__*/React.forwardRef(IeSquareFilled);

	var ImportOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ImportOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M888.3 757.4h-53.8c-4.2 0-7.7 3.5-7.7 7.7v61.8H197.1V197.1h629.8v61.8c0 4.2 3.5 7.7 7.7 7.7h53.8c4.2 0 7.7-3.4 7.7-7.7V158.7c0-17-13.7-30.7-30.7-30.7H158.7c-17 0-30.7 13.7-30.7 30.7v706.6c0 17 13.7 30.7 30.7 30.7h706.6c17 0 30.7-13.7 30.7-30.7V765.1c0-4.3-3.5-7.7-7.7-7.7zM902 476H588v-76c0-6.7-7.8-10.5-13-6.3l-141.9 112a8 8 0 000 12.6l141.9 112c5.3 4.2 13 .4 13-6.3v-76h314c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8z" } }] }, "name": "import", "theme": "outlined" };
	exports.default = ImportOutlined;
	});

	var ImportOutlinedSvg = unwrapExports(ImportOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var ImportOutlined = function ImportOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ImportOutlinedSvg
	  }));
	};

	ImportOutlined.displayName = 'ImportOutlined';
	var ImportOutlined$1 = /*#__PURE__*/React.forwardRef(ImportOutlined);

	var InboxOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var InboxOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M885.2 446.3l-.2-.8-112.2-285.1c-5-16.1-19.9-27.2-36.8-27.2H281.2c-17 0-32.1 11.3-36.9 27.6L139.4 443l-.3.7-.2.8c-1.3 4.9-1.7 9.9-1 14.8-.1 1.6-.2 3.2-.2 4.8V830a60.9 60.9 0 0060.8 60.8h627.2c33.5 0 60.8-27.3 60.9-60.8V464.1c0-1.3 0-2.6-.1-3.7.4-4.9 0-9.6-1.3-14.1zm-295.8-43l-.3 15.7c-.8 44.9-31.8 75.1-77.1 75.1-22.1 0-41.1-7.1-54.8-20.6S436 441.2 435.6 419l-.3-15.7H229.5L309 210h399.2l81.7 193.3H589.4zm-375 76.8h157.3c24.3 57.1 76 90.8 140.4 90.8 33.7 0 65-9.4 90.3-27.2 22.2-15.6 39.5-37.4 50.7-63.6h156.5V814H214.4V480.1z" } }] }, "name": "inbox", "theme": "outlined" };
	exports.default = InboxOutlined;
	});

	var InboxOutlinedSvg = unwrapExports(InboxOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var InboxOutlined = function InboxOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: InboxOutlinedSvg
	  }));
	};

	InboxOutlined.displayName = 'InboxOutlined';
	var InboxOutlined$1 = /*#__PURE__*/React.forwardRef(InboxOutlined);

	var InfoCircleFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var InfoCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm32 664c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V456c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v272zm-32-344a48.01 48.01 0 010-96 48.01 48.01 0 010 96z" } }] }, "name": "info-circle", "theme": "filled" };
	exports.default = InfoCircleFilled;
	});

	var InfoCircleFilledSvg = unwrapExports(InfoCircleFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var InfoCircleFilled = function InfoCircleFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: InfoCircleFilledSvg
	  }));
	};

	InfoCircleFilled.displayName = 'InfoCircleFilled';
	var InfoCircleFilled$1 = /*#__PURE__*/React.forwardRef(InfoCircleFilled);

	var InfoCircleOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var InfoCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z" } }, { "tag": "path", "attrs": { "d": "M464 336a48 48 0 1096 0 48 48 0 10-96 0zm72 112h-48c-4.4 0-8 3.6-8 8v272c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V456c0-4.4-3.6-8-8-8z" } }] }, "name": "info-circle", "theme": "outlined" };
	exports.default = InfoCircleOutlined;
	});

	var InfoCircleOutlinedSvg = unwrapExports(InfoCircleOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var InfoCircleOutlined = function InfoCircleOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: InfoCircleOutlinedSvg
	  }));
	};

	InfoCircleOutlined.displayName = 'InfoCircleOutlined';
	var InfoCircleOutlined$1 = /*#__PURE__*/React.forwardRef(InfoCircleOutlined);

	var InfoCircleTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var InfoCircleTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm32 588c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V456c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v272zm-32-344a48.01 48.01 0 010-96 48.01 48.01 0 010 96z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M464 336a48 48 0 1096 0 48 48 0 10-96 0zm72 112h-48c-4.4 0-8 3.6-8 8v272c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V456c0-4.4-3.6-8-8-8z", "fill": primaryColor } }] }; }, "name": "info-circle", "theme": "twotone" };
	exports.default = InfoCircleTwoTone;
	});

	var InfoCircleTwoToneSvg = unwrapExports(InfoCircleTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var InfoCircleTwoTone = function InfoCircleTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: InfoCircleTwoToneSvg
	  }));
	};

	InfoCircleTwoTone.displayName = 'InfoCircleTwoTone';
	var InfoCircleTwoTone$1 = /*#__PURE__*/React.forwardRef(InfoCircleTwoTone);

	var InfoOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var InfoOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M448 224a64 64 0 10128 0 64 64 0 10-128 0zm96 168h-64c-4.4 0-8 3.6-8 8v464c0 4.4 3.6 8 8 8h64c4.4 0 8-3.6 8-8V400c0-4.4-3.6-8-8-8z" } }] }, "name": "info", "theme": "outlined" };
	exports.default = InfoOutlined;
	});

	var InfoOutlinedSvg = unwrapExports(InfoOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var InfoOutlined = function InfoOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: InfoOutlinedSvg
	  }));
	};

	InfoOutlined.displayName = 'InfoOutlined';
	var InfoOutlined$1 = /*#__PURE__*/React.forwardRef(InfoOutlined);

	var InsertRowAboveOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var InsertRowAboveOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M878.7 336H145.3c-18.4 0-33.3 14.3-33.3 32v464c0 17.7 14.9 32 33.3 32h733.3c18.4 0 33.3-14.3 33.3-32V368c.1-17.7-14.8-32-33.2-32zM360 792H184V632h176v160zm0-224H184V408h176v160zm240 224H424V632h176v160zm0-224H424V408h176v160zm240 224H664V632h176v160zm0-224H664V408h176v160zm64-408H120c-4.4 0-8 3.6-8 8v80c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-80c0-4.4-3.6-8-8-8z" } }] }, "name": "insert-row-above", "theme": "outlined" };
	exports.default = InsertRowAboveOutlined;
	});

	var InsertRowAboveOutlinedSvg = unwrapExports(InsertRowAboveOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var InsertRowAboveOutlined = function InsertRowAboveOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: InsertRowAboveOutlinedSvg
	  }));
	};

	InsertRowAboveOutlined.displayName = 'InsertRowAboveOutlined';
	var InsertRowAboveOutlined$1 = /*#__PURE__*/React.forwardRef(InsertRowAboveOutlined);

	var InsertRowBelowOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var InsertRowBelowOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M904 768H120c-4.4 0-8 3.6-8 8v80c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-80c0-4.4-3.6-8-8-8zm-25.3-608H145.3c-18.4 0-33.3 14.3-33.3 32v464c0 17.7 14.9 32 33.3 32h733.3c18.4 0 33.3-14.3 33.3-32V192c.1-17.7-14.8-32-33.2-32zM360 616H184V456h176v160zm0-224H184V232h176v160zm240 224H424V456h176v160zm0-224H424V232h176v160zm240 224H664V456h176v160zm0-224H664V232h176v160z" } }] }, "name": "insert-row-below", "theme": "outlined" };
	exports.default = InsertRowBelowOutlined;
	});

	var InsertRowBelowOutlinedSvg = unwrapExports(InsertRowBelowOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var InsertRowBelowOutlined = function InsertRowBelowOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: InsertRowBelowOutlinedSvg
	  }));
	};

	InsertRowBelowOutlined.displayName = 'InsertRowBelowOutlined';
	var InsertRowBelowOutlined$1 = /*#__PURE__*/React.forwardRef(InsertRowBelowOutlined);

	var InsertRowLeftOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var InsertRowLeftOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M248 112h-80c-4.4 0-8 3.6-8 8v784c0 4.4 3.6 8 8 8h80c4.4 0 8-3.6 8-8V120c0-4.4-3.6-8-8-8zm584 0H368c-17.7 0-32 14.9-32 33.3v733.3c0 18.4 14.3 33.3 32 33.3h464c17.7 0 32-14.9 32-33.3V145.3c0-18.4-14.3-33.3-32-33.3zM568 840H408V664h160v176zm0-240H408V424h160v176zm0-240H408V184h160v176zm224 480H632V664h160v176zm0-240H632V424h160v176zm0-240H632V184h160v176z" } }] }, "name": "insert-row-left", "theme": "outlined" };
	exports.default = InsertRowLeftOutlined;
	});

	var InsertRowLeftOutlinedSvg = unwrapExports(InsertRowLeftOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var InsertRowLeftOutlined = function InsertRowLeftOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: InsertRowLeftOutlinedSvg
	  }));
	};

	InsertRowLeftOutlined.displayName = 'InsertRowLeftOutlined';
	var InsertRowLeftOutlined$1 = /*#__PURE__*/React.forwardRef(InsertRowLeftOutlined);

	var InsertRowRightOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var InsertRowRightOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M856 112h-80c-4.4 0-8 3.6-8 8v784c0 4.4 3.6 8 8 8h80c4.4 0 8-3.6 8-8V120c0-4.4-3.6-8-8-8zm-200 0H192c-17.7 0-32 14.9-32 33.3v733.3c0 18.4 14.3 33.3 32 33.3h464c17.7 0 32-14.9 32-33.3V145.3c0-18.4-14.3-33.3-32-33.3zM392 840H232V664h160v176zm0-240H232V424h160v176zm0-240H232V184h160v176zm224 480H456V664h160v176zm0-240H456V424h160v176zm0-240H456V184h160v176z" } }] }, "name": "insert-row-right", "theme": "outlined" };
	exports.default = InsertRowRightOutlined;
	});

	var InsertRowRightOutlinedSvg = unwrapExports(InsertRowRightOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var InsertRowRightOutlined = function InsertRowRightOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: InsertRowRightOutlinedSvg
	  }));
	};

	InsertRowRightOutlined.displayName = 'InsertRowRightOutlined';
	var InsertRowRightOutlined$1 = /*#__PURE__*/React.forwardRef(InsertRowRightOutlined);

	var InstagramFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var InstagramFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 378.7c-73.4 0-133.3 59.9-133.3 133.3S438.6 645.3 512 645.3 645.3 585.4 645.3 512 585.4 378.7 512 378.7zM911.8 512c0-55.2.5-109.9-2.6-165-3.1-64-17.7-120.8-64.5-167.6-46.9-46.9-103.6-61.4-167.6-64.5-55.2-3.1-109.9-2.6-165-2.6-55.2 0-109.9-.5-165 2.6-64 3.1-120.8 17.7-167.6 64.5C132.6 226.3 118.1 283 115 347c-3.1 55.2-2.6 109.9-2.6 165s-.5 109.9 2.6 165c3.1 64 17.7 120.8 64.5 167.6 46.9 46.9 103.6 61.4 167.6 64.5 55.2 3.1 109.9 2.6 165 2.6 55.2 0 109.9.5 165-2.6 64-3.1 120.8-17.7 167.6-64.5 46.9-46.9 61.4-103.6 64.5-167.6 3.2-55.1 2.6-109.8 2.6-165zM512 717.1c-113.5 0-205.1-91.6-205.1-205.1S398.5 306.9 512 306.9 717.1 398.5 717.1 512 625.5 717.1 512 717.1zm213.5-370.7c-26.5 0-47.9-21.4-47.9-47.9s21.4-47.9 47.9-47.9 47.9 21.4 47.9 47.9a47.84 47.84 0 01-47.9 47.9z" } }] }, "name": "instagram", "theme": "filled" };
	exports.default = InstagramFilled;
	});

	var InstagramFilledSvg = unwrapExports(InstagramFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var InstagramFilled = function InstagramFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: InstagramFilledSvg
	  }));
	};

	InstagramFilled.displayName = 'InstagramFilled';
	var InstagramFilled$1 = /*#__PURE__*/React.forwardRef(InstagramFilled);

	var InstagramOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var InstagramOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 306.9c-113.5 0-205.1 91.6-205.1 205.1S398.5 717.1 512 717.1 717.1 625.5 717.1 512 625.5 306.9 512 306.9zm0 338.4c-73.4 0-133.3-59.9-133.3-133.3S438.6 378.7 512 378.7 645.3 438.6 645.3 512 585.4 645.3 512 645.3zm213.5-394.6c-26.5 0-47.9 21.4-47.9 47.9s21.4 47.9 47.9 47.9 47.9-21.3 47.9-47.9a47.84 47.84 0 00-47.9-47.9zM911.8 512c0-55.2.5-109.9-2.6-165-3.1-64-17.7-120.8-64.5-167.6-46.9-46.9-103.6-61.4-167.6-64.5-55.2-3.1-109.9-2.6-165-2.6-55.2 0-109.9-.5-165 2.6-64 3.1-120.8 17.7-167.6 64.5C132.6 226.3 118.1 283 115 347c-3.1 55.2-2.6 109.9-2.6 165s-.5 109.9 2.6 165c3.1 64 17.7 120.8 64.5 167.6 46.9 46.9 103.6 61.4 167.6 64.5 55.2 3.1 109.9 2.6 165 2.6 55.2 0 109.9.5 165-2.6 64-3.1 120.8-17.7 167.6-64.5 46.9-46.9 61.4-103.6 64.5-167.6 3.2-55.1 2.6-109.8 2.6-165zm-88 235.8c-7.3 18.2-16.1 31.8-30.2 45.8-14.1 14.1-27.6 22.9-45.8 30.2C695.2 844.7 570.3 840 512 840c-58.3 0-183.3 4.7-235.9-16.1-18.2-7.3-31.8-16.1-45.8-30.2-14.1-14.1-22.9-27.6-30.2-45.8C179.3 695.2 184 570.3 184 512c0-58.3-4.7-183.3 16.1-235.9 7.3-18.2 16.1-31.8 30.2-45.8s27.6-22.9 45.8-30.2C328.7 179.3 453.7 184 512 184s183.3-4.7 235.9 16.1c18.2 7.3 31.8 16.1 45.8 30.2 14.1 14.1 22.9 27.6 30.2 45.8C844.7 328.7 840 453.7 840 512c0 58.3 4.7 183.2-16.2 235.8z" } }] }, "name": "instagram", "theme": "outlined" };
	exports.default = InstagramOutlined;
	});

	var InstagramOutlinedSvg = unwrapExports(InstagramOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var InstagramOutlined = function InstagramOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: InstagramOutlinedSvg
	  }));
	};

	InstagramOutlined.displayName = 'InstagramOutlined';
	var InstagramOutlined$1 = /*#__PURE__*/React.forwardRef(InstagramOutlined);

	var InsuranceFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var InsuranceFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M519.9 358.8h97.9v41.6h-97.9zm347-188.9L527.1 54.1C523 52.7 517.5 52 512 52s-11 .7-15.1 2.1L157.1 169.9c-8.3 2.8-15.1 12.4-15.1 21.2v482.4c0 8.8 5.7 20.4 12.6 25.9L499.3 968c3.5 2.7 8 4.1 12.6 4.1s9.2-1.4 12.6-4.1l344.7-268.6c6.9-5.4 12.6-17 12.6-25.9V191.1c.2-8.8-6.6-18.3-14.9-21.2zM411.3 656h-.2c0 4.4-3.6 8-8 8h-37.3c-4.4 0-8-3.6-8-8V471.4c-7.7 9.2-15.4 17.9-23.1 26a6.04 6.04 0 01-10.2-2.4l-13.2-43.5c-.6-2-.2-4.1 1.2-5.6 37-43.4 64.7-95.1 82.2-153.6 1.1-3.5 5-5.3 8.4-3.7l38.6 18.3c2.7 1.3 4.1 4.4 3.2 7.2a429.2 429.2 0 01-33.6 79V656zm296.5-49.2l-26.3 35.3a5.92 5.92 0 01-8.9.7c-30.6-29.3-56.8-65.2-78.1-106.9V656c0 4.4-3.6 8-8 8h-36.2c-4.4 0-8-3.6-8-8V536c-22 44.7-49 80.8-80.6 107.6a5.9 5.9 0 01-8.9-1.4L430 605.7a6 6 0 011.6-8.1c28.6-20.3 51.9-45.2 71-76h-55.1c-4.4 0-8-3.6-8-8V478c0-4.4 3.6-8 8-8h94.9v-18.6h-65.9c-4.4 0-8-3.6-8-8V316c0-4.4 3.6-8 8-8h184.7c4.4 0 8 3.6 8 8v127.2c0 4.4-3.6 8-8 8h-66.7v18.6h98.8c4.4 0 8 3.6 8 8v35.6c0 4.4-3.6 8-8 8h-59c18.1 29.1 41.8 54.3 72.3 76.9 2.6 2.1 3.2 5.9 1.2 8.5z" } }] }, "name": "insurance", "theme": "filled" };
	exports.default = InsuranceFilled;
	});

	var InsuranceFilledSvg = unwrapExports(InsuranceFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var InsuranceFilled = function InsuranceFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: InsuranceFilledSvg
	  }));
	};

	InsuranceFilled.displayName = 'InsuranceFilled';
	var InsuranceFilled$1 = /*#__PURE__*/React.forwardRef(InsuranceFilled);

	var InsuranceOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var InsuranceOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M441.6 306.8L403 288.6a6.1 6.1 0 00-8.4 3.7c-17.5 58.5-45.2 110.1-82.2 153.6a6.05 6.05 0 00-1.2 5.6l13.2 43.5c1.3 4.4 7 5.7 10.2 2.4 7.7-8.1 15.4-16.9 23.1-26V656c0 4.4 3.6 8 8 8H403c4.4 0 8-3.6 8-8V393.1a429.2 429.2 0 0033.6-79c1-2.9-.3-6-3-7.3zm26.8 9.2v127.2c0 4.4 3.6 8 8 8h65.9v18.6h-94.9c-4.4 0-8 3.6-8 8v35.6c0 4.4 3.6 8 8 8h55.1c-19.1 30.8-42.4 55.7-71 76a6 6 0 00-1.6 8.1l22.8 36.5c1.9 3.1 6.2 3.8 8.9 1.4 31.6-26.8 58.7-62.9 80.6-107.6v120c0 4.4 3.6 8 8 8h36.2c4.4 0 8-3.6 8-8V536c21.3 41.7 47.5 77.5 78.1 106.9 2.6 2.5 6.8 2.1 8.9-.7l26.3-35.3c2-2.7 1.4-6.5-1.2-8.4-30.5-22.6-54.2-47.8-72.3-76.9h59c4.4 0 8-3.6 8-8V478c0-4.4-3.6-8-8-8h-98.8v-18.6h66.7c4.4 0 8-3.6 8-8V316c0-4.4-3.6-8-8-8H476.4c-4.4 0-8 3.6-8 8zm51.5 42.8h97.9v41.6h-97.9v-41.6zm347-188.9L527.1 54.1C523 52.7 517.5 52 512 52s-11 .7-15.1 2.1L157.1 169.9c-8.3 2.8-15.1 12.4-15.1 21.2v482.4c0 8.8 5.7 20.4 12.6 25.9L499.3 968c3.5 2.7 8 4.1 12.6 4.1s9.2-1.4 12.6-4.1l344.7-268.6c6.9-5.4 12.6-17 12.6-25.9V191.1c.2-8.8-6.6-18.3-14.9-21.2zM810 654.3L512 886.5 214 654.3V226.7l298-101.6 298 101.6v427.6z" } }] }, "name": "insurance", "theme": "outlined" };
	exports.default = InsuranceOutlined;
	});

	var InsuranceOutlinedSvg = unwrapExports(InsuranceOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var InsuranceOutlined = function InsuranceOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: InsuranceOutlinedSvg
	  }));
	};

	InsuranceOutlined.displayName = 'InsuranceOutlined';
	var InsuranceOutlined$1 = /*#__PURE__*/React.forwardRef(InsuranceOutlined);

	var InsuranceTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var InsuranceTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M866.9 169.9L527.1 54.1C523 52.7 517.5 52 512 52s-11 .7-15.1 2.1L157.1 169.9c-8.3 2.8-15.1 12.4-15.1 21.2v482.4c0 8.8 5.7 20.4 12.6 25.9L499.3 968c3.5 2.7 8 4.1 12.6 4.1s9.2-1.4 12.6-4.1l344.7-268.6c6.9-5.4 12.6-17 12.6-25.9V191.1c.2-8.8-6.6-18.3-14.9-21.2zM810 654.3L512 886.5 214 654.3V226.7l298-101.6 298 101.6v427.6z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M521.9 358.8h97.9v41.6h-97.9z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M214 226.7v427.6l298 232.2 298-232.2V226.7L512 125.1 214 226.7zM413.3 656h-.2c0 4.4-3.6 8-8 8h-37.3c-4.4 0-8-3.6-8-8V471.4c-7.7 9.2-15.4 17.9-23.1 26a6.04 6.04 0 01-10.2-2.4l-13.2-43.5c-.6-2-.2-4.1 1.2-5.6 37-43.4 64.7-95.1 82.2-153.6 1.1-3.5 5-5.3 8.4-3.7l38.6 18.3c2.7 1.3 4.1 4.4 3.2 7.2a429.2 429.2 0 01-33.6 79V656zm257.9-340v127.2c0 4.4-3.6 8-8 8h-66.7v18.6h98.8c4.4 0 8 3.6 8 8v35.6c0 4.4-3.6 8-8 8h-59c18.1 29.1 41.8 54.3 72.3 76.9 2.6 2.1 3.2 5.9 1.2 8.5l-26.3 35.3a5.92 5.92 0 01-8.9.7c-30.6-29.3-56.8-65.2-78.1-106.9V656c0 4.4-3.6 8-8 8h-36.2c-4.4 0-8-3.6-8-8V536c-22 44.7-49 80.8-80.6 107.6a6.38 6.38 0 01-4.8 1.4c-1.7-.3-3.2-1.3-4.1-2.8L432 605.7a6 6 0 011.6-8.1c28.6-20.3 51.9-45.2 71-76h-55.1c-4.4 0-8-3.6-8-8V478c0-4.4 3.6-8 8-8h94.9v-18.6h-65.9c-4.4 0-8-3.6-8-8V316c0-4.4 3.6-8 8-8h184.7c4.4 0 8 3.6 8 8z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M443.7 306.9l-38.6-18.3c-3.4-1.6-7.3.2-8.4 3.7-17.5 58.5-45.2 110.2-82.2 153.6a5.7 5.7 0 00-1.2 5.6l13.2 43.5c1.4 4.5 7 5.8 10.2 2.4 7.7-8.1 15.4-16.8 23.1-26V656c0 4.4 3.6 8 8 8h37.3c4.4 0 8-3.6 8-8h.2V393.1a429.2 429.2 0 0033.6-79c.9-2.8-.5-5.9-3.2-7.2zm26.8 9.1v127.4c0 4.4 3.6 8 8 8h65.9V470h-94.9c-4.4 0-8 3.6-8 8v35.6c0 4.4 3.6 8 8 8h55.1c-19.1 30.8-42.4 55.7-71 76a6 6 0 00-1.6 8.1l22.8 36.5c.9 1.5 2.4 2.5 4.1 2.8 1.7.3 3.5-.2 4.8-1.4 31.6-26.8 58.6-62.9 80.6-107.6v120c0 4.4 3.6 8 8 8h36.2c4.4 0 8-3.6 8-8V535.9c21.3 41.7 47.5 77.6 78.1 106.9 2.6 2.5 6.7 2.2 8.9-.7l26.3-35.3c2-2.6 1.4-6.4-1.2-8.5-30.5-22.6-54.2-47.8-72.3-76.9h59c4.4 0 8-3.6 8-8v-35.6c0-4.4-3.6-8-8-8h-98.8v-18.6h66.7c4.4 0 8-3.6 8-8V316c0-4.4-3.6-8-8-8H478.5c-4.4 0-8 3.6-8 8zm51.4 42.8h97.9v41.6h-97.9v-41.6z", "fill": primaryColor } }] }; }, "name": "insurance", "theme": "twotone" };
	exports.default = InsuranceTwoTone;
	});

	var InsuranceTwoToneSvg = unwrapExports(InsuranceTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var InsuranceTwoTone = function InsuranceTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: InsuranceTwoToneSvg
	  }));
	};

	InsuranceTwoTone.displayName = 'InsuranceTwoTone';
	var InsuranceTwoTone$1 = /*#__PURE__*/React.forwardRef(InsuranceTwoTone);

	var InteractionFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var InteractionFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM726 585.7c0 55.3-44.7 100.1-99.7 100.1H420.6v53.4c0 5.7-6.5 8.8-10.9 5.3l-109.1-85.7c-3.5-2.7-3.5-8 0-10.7l109.1-85.7c4.4-3.5 10.9-.3 10.9 5.3v53.4h205.7c19.6 0 35.5-16 35.5-35.6v-78.9c0-3.7 3-6.8 6.8-6.8h50.7c3.7 0 6.8 3 6.8 6.8v79.1zm-2.6-209.9l-109.1 85.7c-4.4 3.5-10.9.3-10.9-5.3v-53.4H397.7c-19.6 0-35.5 16-35.5 35.6v78.9c0 3.7-3 6.8-6.8 6.8h-50.7c-3.7 0-6.8-3-6.8-6.8v-78.9c0-55.3 44.7-100.1 99.7-100.1h205.7v-53.4c0-5.7 6.5-8.8 10.9-5.3l109.1 85.7c3.6 2.5 3.6 7.8.1 10.5z" } }] }, "name": "interaction", "theme": "filled" };
	exports.default = InteractionFilled;
	});

	var InteractionFilledSvg = unwrapExports(InteractionFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var InteractionFilled = function InteractionFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: InteractionFilledSvg
	  }));
	};

	InteractionFilled.displayName = 'InteractionFilled';
	var InteractionFilled$1 = /*#__PURE__*/React.forwardRef(InteractionFilled);

	var InteractionOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var InteractionOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656zM304.8 524h50.7c3.7 0 6.8-3 6.8-6.8v-78.9c0-19.7 15.9-35.6 35.5-35.6h205.7v53.4c0 5.7 6.5 8.8 10.9 5.3l109.1-85.7c3.5-2.7 3.5-8 0-10.7l-109.1-85.7c-4.4-3.5-10.9-.3-10.9 5.3V338H397.7c-55.1 0-99.7 44.8-99.7 100.1V517c0 4 3 7 6.8 7zm-4.2 134.9l109.1 85.7c4.4 3.5 10.9.3 10.9-5.3v-53.4h205.7c55.1 0 99.7-44.8 99.7-100.1v-78.9c0-3.7-3-6.8-6.8-6.8h-50.7c-3.7 0-6.8 3-6.8 6.8v78.9c0 19.7-15.9 35.6-35.5 35.6H420.6V568c0-5.7-6.5-8.8-10.9-5.3l-109.1 85.7c-3.5 2.5-3.5 7.8 0 10.5z" } }] }, "name": "interaction", "theme": "outlined" };
	exports.default = InteractionOutlined;
	});

	var InteractionOutlinedSvg = unwrapExports(InteractionOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var InteractionOutlined = function InteractionOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: InteractionOutlinedSvg
	  }));
	};

	InteractionOutlined.displayName = 'InteractionOutlined';
	var InteractionOutlined$1 = /*#__PURE__*/React.forwardRef(InteractionOutlined);

	var InteractionTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var InteractionTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M184 840h656V184H184v656zm114-401.9c0-55.3 44.6-100.1 99.7-100.1h205.8v-53.4c0-5.6 6.5-8.8 10.9-5.3L723.5 365c3.5 2.7 3.5 8 0 10.7l-109.1 85.7c-4.4 3.5-10.9.4-10.9-5.3v-53.4H397.8c-19.6 0-35.5 15.9-35.5 35.6v78.9c0 3.8-3.1 6.8-6.8 6.8h-50.7c-3.8 0-6.8-3-6.8-7v-78.9zm2.6 210.3l109.1-85.7c4.4-3.5 10.9-.4 10.9 5.3v53.4h205.6c19.6 0 35.5-15.9 35.5-35.6v-78.9c0-3.8 3.1-6.8 6.8-6.8h50.7c3.8 0 6.8 3.1 6.8 6.8v78.9c0 55.3-44.6 100.1-99.7 100.1H420.6v53.4c0 5.6-6.5 8.8-10.9 5.3l-109.1-85.7c-3.5-2.7-3.5-8 0-10.5z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M304.8 524h50.7c3.7 0 6.8-3 6.8-6.8v-78.9c0-19.7 15.9-35.6 35.5-35.6h205.7v53.4c0 5.7 6.5 8.8 10.9 5.3l109.1-85.7c3.5-2.7 3.5-8 0-10.7l-109.1-85.7c-4.4-3.5-10.9-.3-10.9 5.3V338H397.7c-55.1 0-99.7 44.8-99.7 100.1V517c0 4 3 7 6.8 7zm-4.2 134.9l109.1 85.7c4.4 3.5 10.9.3 10.9-5.3v-53.4h205.7c55.1 0 99.7-44.8 99.7-100.1v-78.9c0-3.7-3-6.8-6.8-6.8h-50.7c-3.7 0-6.8 3-6.8 6.8v78.9c0 19.7-15.9 35.6-35.5 35.6H420.6V568c0-5.7-6.5-8.8-10.9-5.3l-109.1 85.7c-3.5 2.5-3.5 7.8 0 10.5z", "fill": primaryColor } }] }; }, "name": "interaction", "theme": "twotone" };
	exports.default = InteractionTwoTone;
	});

	var InteractionTwoToneSvg = unwrapExports(InteractionTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var InteractionTwoTone = function InteractionTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: InteractionTwoToneSvg
	  }));
	};

	InteractionTwoTone.displayName = 'InteractionTwoTone';
	var InteractionTwoTone$1 = /*#__PURE__*/React.forwardRef(InteractionTwoTone);

	var IssuesCloseOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var IssuesCloseOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M464 688a48 48 0 1096 0 48 48 0 10-96 0zm72-112c4.4 0 8-3.6 8-8V296c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v272c0 4.4 3.6 8 8 8h48zm400-188h-59.3c-2.6 0-5 1.2-6.5 3.3L763.7 538.1l-49.9-68.8a7.92 7.92 0 00-6.5-3.3H648c-6.5 0-10.3 7.4-6.5 12.7l109.2 150.7a16.1 16.1 0 0026 0l165.8-228.7c3.8-5.3 0-12.7-6.5-12.7zm-44 306h-64.2c-5.5 0-10.6 2.9-13.6 7.5a352.2 352.2 0 01-49.8 62.2A355.92 355.92 0 01651.1 840a355 355 0 01-138.7 27.9c-48.1 0-94.8-9.4-138.7-27.9a355.92 355.92 0 01-113.3-76.3A353.06 353.06 0 01184 650.5c-18.6-43.8-28-90.5-28-138.5s9.4-94.7 28-138.5c17.9-42.4 43.6-80.5 76.4-113.2 32.8-32.7 70.9-58.4 113.3-76.3a355 355 0 01138.7-27.9c48.1 0 94.8 9.4 138.7 27.9 42.4 17.9 80.5 43.6 113.3 76.3 19 19 35.6 39.8 49.8 62.2 2.9 4.7 8.1 7.5 13.6 7.5H892c6 0 9.8-6.3 7.2-11.6C828.8 178.5 684.7 82 517.7 80 278.9 77.2 80.5 272.5 80 511.2 79.5 750.1 273.3 944 512.4 944c169.2 0 315.6-97 386.7-238.4A8 8 0 00892 694z" } }] }, "name": "issues-close", "theme": "outlined" };
	exports.default = IssuesCloseOutlined;
	});

	var IssuesCloseOutlinedSvg = unwrapExports(IssuesCloseOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var IssuesCloseOutlined = function IssuesCloseOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: IssuesCloseOutlinedSvg
	  }));
	};

	IssuesCloseOutlined.displayName = 'IssuesCloseOutlined';
	var IssuesCloseOutlined$1 = /*#__PURE__*/React.forwardRef(IssuesCloseOutlined);

	var ItalicOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ItalicOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M798 160H366c-4.4 0-8 3.6-8 8v64c0 4.4 3.6 8 8 8h181.2l-156 544H229c-4.4 0-8 3.6-8 8v64c0 4.4 3.6 8 8 8h432c4.4 0 8-3.6 8-8v-64c0-4.4-3.6-8-8-8H474.4l156-544H798c4.4 0 8-3.6 8-8v-64c0-4.4-3.6-8-8-8z" } }] }, "name": "italic", "theme": "outlined" };
	exports.default = ItalicOutlined;
	});

	var ItalicOutlinedSvg = unwrapExports(ItalicOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var ItalicOutlined = function ItalicOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ItalicOutlinedSvg
	  }));
	};

	ItalicOutlined.displayName = 'ItalicOutlined';
	var ItalicOutlined$1 = /*#__PURE__*/React.forwardRef(ItalicOutlined);

	var KeyOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var KeyOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M608 112c-167.9 0-304 136.1-304 304 0 70.3 23.9 135 63.9 186.5l-41.1 41.1-62.3-62.3a8.15 8.15 0 00-11.4 0l-39.8 39.8a8.15 8.15 0 000 11.4l62.3 62.3-44.9 44.9-62.3-62.3a8.15 8.15 0 00-11.4 0l-39.8 39.8a8.15 8.15 0 000 11.4l62.3 62.3-65.3 65.3a8.03 8.03 0 000 11.3l42.3 42.3c3.1 3.1 8.2 3.1 11.3 0l253.6-253.6A304.06 304.06 0 00608 720c167.9 0 304-136.1 304-304S775.9 112 608 112zm161.2 465.2C726.2 620.3 668.9 644 608 644c-60.9 0-118.2-23.7-161.2-66.8-43.1-43-66.8-100.3-66.8-161.2 0-60.9 23.7-118.2 66.8-161.2 43-43.1 100.3-66.8 161.2-66.8 60.9 0 118.2 23.7 161.2 66.8 43.1 43 66.8 100.3 66.8 161.2 0 60.9-23.7 118.2-66.8 161.2z" } }] }, "name": "key", "theme": "outlined" };
	exports.default = KeyOutlined;
	});

	var KeyOutlinedSvg = unwrapExports(KeyOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var KeyOutlined = function KeyOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: KeyOutlinedSvg
	  }));
	};

	KeyOutlined.displayName = 'KeyOutlined';
	var KeyOutlined$1 = /*#__PURE__*/React.forwardRef(KeyOutlined);

	var LaptopOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var LaptopOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M956.9 845.1L896.4 632V168c0-17.7-14.3-32-32-32h-704c-17.7 0-32 14.3-32 32v464L67.9 845.1C60.4 866 75.8 888 98 888h828.8c22.2 0 37.6-22 30.1-42.9zM200.4 208h624v395h-624V208zm228.3 608l8.1-37h150.3l8.1 37H428.7zm224 0l-19.1-86.7c-.8-3.7-4.1-6.3-7.8-6.3H398.2c-3.8 0-7 2.6-7.8 6.3L371.3 816H151l42.3-149h638.2l42.3 149H652.7z" } }] }, "name": "laptop", "theme": "outlined" };
	exports.default = LaptopOutlined;
	});

	var LaptopOutlinedSvg = unwrapExports(LaptopOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var LaptopOutlined = function LaptopOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: LaptopOutlinedSvg
	  }));
	};

	LaptopOutlined.displayName = 'LaptopOutlined';
	var LaptopOutlined$1 = /*#__PURE__*/React.forwardRef(LaptopOutlined);

	var LayoutFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var LayoutFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M384 912h496c17.7 0 32-14.3 32-32V340H384v572zm496-800H384v164h528V144c0-17.7-14.3-32-32-32zm-768 32v736c0 17.7 14.3 32 32 32h176V112H144c-17.7 0-32 14.3-32 32z" } }] }, "name": "layout", "theme": "filled" };
	exports.default = LayoutFilled;
	});

	var LayoutFilledSvg = unwrapExports(LayoutFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var LayoutFilled = function LayoutFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: LayoutFilledSvg
	  }));
	};

	LayoutFilled.displayName = 'LayoutFilled';
	var LayoutFilled$1 = /*#__PURE__*/React.forwardRef(LayoutFilled);

	var LayoutOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var LayoutOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-696 72h136v656H184V184zm656 656H384V384h456v456zM384 320V184h456v136H384z" } }] }, "name": "layout", "theme": "outlined" };
	exports.default = LayoutOutlined;
	});

	var LayoutOutlinedSvg = unwrapExports(LayoutOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var LayoutOutlined = function LayoutOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: LayoutOutlinedSvg
	  }));
	};

	LayoutOutlined.displayName = 'LayoutOutlined';
	var LayoutOutlined$1 = /*#__PURE__*/React.forwardRef(LayoutOutlined);

	var LayoutTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var LayoutTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M384 185h456v136H384zm-200 0h136v656H184zm696-73H144c-17.7 0-32 14.3-32 32v1c0-17.7 14.3-32 32-32h736c17.7 0 32 14.3 32 32v-1c0-17.7-14.3-32-32-32zM384 385h456v456H384z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M880 113H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V145c0-17.7-14.3-32-32-32zM320 841H184V185h136v656zm520 0H384V385h456v456zm0-520H384V185h456v136z", "fill": primaryColor } }] }; }, "name": "layout", "theme": "twotone" };
	exports.default = LayoutTwoTone;
	});

	var LayoutTwoToneSvg = unwrapExports(LayoutTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var LayoutTwoTone = function LayoutTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: LayoutTwoToneSvg
	  }));
	};

	LayoutTwoTone.displayName = 'LayoutTwoTone';
	var LayoutTwoTone$1 = /*#__PURE__*/React.forwardRef(LayoutTwoTone);

	var LeftCircleFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var LeftCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm104 316.9c0 10.2-4.9 19.9-13.2 25.9L457.4 512l145.4 105.2c8.3 6 13.2 15.6 13.2 25.9V690c0 6.5-7.4 10.3-12.7 6.5l-246-178a7.95 7.95 0 010-12.9l246-178a8 8 0 0112.7 6.5v46.8z" } }] }, "name": "left-circle", "theme": "filled" };
	exports.default = LeftCircleFilled;
	});

	var LeftCircleFilledSvg = unwrapExports(LeftCircleFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var LeftCircleFilled = function LeftCircleFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: LeftCircleFilledSvg
	  }));
	};

	LeftCircleFilled.displayName = 'LeftCircleFilled';
	var LeftCircleFilled$1 = /*#__PURE__*/React.forwardRef(LeftCircleFilled);

	var LeftCircleOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var LeftCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M603.3 327.5l-246 178a7.95 7.95 0 000 12.9l246 178c5.3 3.8 12.7 0 12.7-6.5V643c0-10.2-4.9-19.9-13.2-25.9L457.4 512l145.4-105.2c8.3-6 13.2-15.6 13.2-25.9V334c0-6.5-7.4-10.3-12.7-6.5z" } }, { "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z" } }] }, "name": "left-circle", "theme": "outlined" };
	exports.default = LeftCircleOutlined;
	});

	var LeftCircleOutlinedSvg = unwrapExports(LeftCircleOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var LeftCircleOutlined = function LeftCircleOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: LeftCircleOutlinedSvg
	  }));
	};

	LeftCircleOutlined.displayName = 'LeftCircleOutlined';
	var LeftCircleOutlined$1 = /*#__PURE__*/React.forwardRef(LeftCircleOutlined);

	var LeftCircleTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var LeftCircleTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm104 240.9c0 10.3-4.9 19.9-13.2 25.9L457.4 512l145.4 105.1c8.3 6 13.2 15.7 13.2 25.9v46.9c0 6.5-7.4 10.3-12.7 6.5l-246-178a7.95 7.95 0 010-12.9l246-178c5.3-3.8 12.7 0 12.7 6.5v46.9z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M603.3 327.5l-246 178a7.95 7.95 0 000 12.9l246 178c5.3 3.8 12.7 0 12.7-6.5V643c0-10.2-4.9-19.9-13.2-25.9L457.4 512l145.4-105.2c8.3-6 13.2-15.6 13.2-25.9V334c0-6.5-7.4-10.3-12.7-6.5z", "fill": primaryColor } }] }; }, "name": "left-circle", "theme": "twotone" };
	exports.default = LeftCircleTwoTone;
	});

	var LeftCircleTwoToneSvg = unwrapExports(LeftCircleTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var LeftCircleTwoTone = function LeftCircleTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: LeftCircleTwoToneSvg
	  }));
	};

	LeftCircleTwoTone.displayName = 'LeftCircleTwoTone';
	var LeftCircleTwoTone$1 = /*#__PURE__*/React.forwardRef(LeftCircleTwoTone);

	var LeftOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var LeftOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M724 218.3V141c0-6.7-7.7-10.4-12.9-6.3L260.3 486.8a31.86 31.86 0 000 50.3l450.8 352.1c5.3 4.1 12.9.4 12.9-6.3v-77.3c0-4.9-2.3-9.6-6.1-12.6l-360-281 360-281.1c3.8-3 6.1-7.7 6.1-12.6z" } }] }, "name": "left", "theme": "outlined" };
	exports.default = LeftOutlined;
	});

	var LeftOutlinedSvg = unwrapExports(LeftOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var LeftOutlined = function LeftOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: LeftOutlinedSvg
	  }));
	};

	LeftOutlined.displayName = 'LeftOutlined';
	var LeftOutlined$1 = /*#__PURE__*/React.forwardRef(LeftOutlined);

	var LeftSquareFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var LeftSquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM624 380.9c0 10.2-4.9 19.9-13.2 25.9L465.4 512l145.4 105.2c8.3 6 13.2 15.6 13.2 25.9V690c0 6.5-7.4 10.3-12.7 6.5l-246-178a7.95 7.95 0 010-12.9l246-178c5.3-3.8 12.7 0 12.7 6.5v46.8z" } }] }, "name": "left-square", "theme": "filled" };
	exports.default = LeftSquareFilled;
	});

	var LeftSquareFilledSvg = unwrapExports(LeftSquareFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var LeftSquareFilled = function LeftSquareFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: LeftSquareFilledSvg
	  }));
	};

	LeftSquareFilled.displayName = 'LeftSquareFilled';
	var LeftSquareFilled$1 = /*#__PURE__*/React.forwardRef(LeftSquareFilled);

	var LeftSquareOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var LeftSquareOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M365.3 518.5l246 178c5.3 3.8 12.7 0 12.7-6.5v-46.9c0-10.2-4.9-19.9-13.2-25.9L465.4 512l145.4-105.2c8.3-6 13.2-15.6 13.2-25.9V334c0-6.5-7.4-10.3-12.7-6.5l-246 178a8.05 8.05 0 000 13z" } }, { "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z" } }] }, "name": "left-square", "theme": "outlined" };
	exports.default = LeftSquareOutlined;
	});

	var LeftSquareOutlinedSvg = unwrapExports(LeftSquareOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var LeftSquareOutlined = function LeftSquareOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: LeftSquareOutlinedSvg
	  }));
	};

	LeftSquareOutlined.displayName = 'LeftSquareOutlined';
	var LeftSquareOutlined$1 = /*#__PURE__*/React.forwardRef(LeftSquareOutlined);

	var LeftSquareTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var LeftSquareTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M184 840h656V184H184v656zm181.3-334.5l246-178c5.3-3.8 12.7 0 12.7 6.5v46.9c0 10.3-4.9 19.9-13.2 25.9L465.4 512l145.4 105.2c8.3 6 13.2 15.7 13.2 25.9V690c0 6.5-7.4 10.3-12.7 6.4l-246-178a7.95 7.95 0 010-12.9z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M365.3 518.4l246 178c5.3 3.9 12.7.1 12.7-6.4v-46.9c0-10.2-4.9-19.9-13.2-25.9L465.4 512l145.4-105.2c8.3-6 13.2-15.6 13.2-25.9V334c0-6.5-7.4-10.3-12.7-6.5l-246 178a7.95 7.95 0 000 12.9z", "fill": primaryColor } }] }; }, "name": "left-square", "theme": "twotone" };
	exports.default = LeftSquareTwoTone;
	});

	var LeftSquareTwoToneSvg = unwrapExports(LeftSquareTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var LeftSquareTwoTone = function LeftSquareTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: LeftSquareTwoToneSvg
	  }));
	};

	LeftSquareTwoTone.displayName = 'LeftSquareTwoTone';
	var LeftSquareTwoTone$1 = /*#__PURE__*/React.forwardRef(LeftSquareTwoTone);

	var LikeFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var LikeFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M885.9 533.7c16.8-22.2 26.1-49.4 26.1-77.7 0-44.9-25.1-87.4-65.5-111.1a67.67 67.67 0 00-34.3-9.3H572.4l6-122.9c1.4-29.7-9.1-57.9-29.5-79.4A106.62 106.62 0 00471 99.9c-52 0-98 35-111.8 85.1l-85.9 311h-.3v428h472.3c9.2 0 18.2-1.8 26.5-5.4 47.6-20.3 78.3-66.8 78.3-118.4 0-12.6-1.8-25-5.4-37 16.8-22.2 26.1-49.4 26.1-77.7 0-12.6-1.8-25-5.4-37 16.8-22.2 26.1-49.4 26.1-77.7-.2-12.6-2-25.1-5.6-37.1zM112 528v364c0 17.7 14.3 32 32 32h65V496h-65c-17.7 0-32 14.3-32 32z" } }] }, "name": "like", "theme": "filled" };
	exports.default = LikeFilled;
	});

	var LikeFilledSvg = unwrapExports(LikeFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var LikeFilled = function LikeFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: LikeFilledSvg
	  }));
	};

	LikeFilled.displayName = 'LikeFilled';
	var LikeFilled$1 = /*#__PURE__*/React.forwardRef(LikeFilled);

	var LikeOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var LikeOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M885.9 533.7c16.8-22.2 26.1-49.4 26.1-77.7 0-44.9-25.1-87.4-65.5-111.1a67.67 67.67 0 00-34.3-9.3H572.4l6-122.9c1.4-29.7-9.1-57.9-29.5-79.4A106.62 106.62 0 00471 99.9c-52 0-98 35-111.8 85.1l-85.9 311H144c-17.7 0-32 14.3-32 32v364c0 17.7 14.3 32 32 32h601.3c9.2 0 18.2-1.8 26.5-5.4 47.6-20.3 78.3-66.8 78.3-118.4 0-12.6-1.8-25-5.4-37 16.8-22.2 26.1-49.4 26.1-77.7 0-12.6-1.8-25-5.4-37 16.8-22.2 26.1-49.4 26.1-77.7-.2-12.6-2-25.1-5.6-37.1zM184 852V568h81v284h-81zm636.4-353l-21.9 19 13.9 25.4a56.2 56.2 0 016.9 27.3c0 16.5-7.2 32.2-19.6 43l-21.9 19 13.9 25.4a56.2 56.2 0 016.9 27.3c0 16.5-7.2 32.2-19.6 43l-21.9 19 13.9 25.4a56.2 56.2 0 016.9 27.3c0 22.4-13.2 42.6-33.6 51.8H329V564.8l99.5-360.5a44.1 44.1 0 0142.2-32.3c7.6 0 15.1 2.2 21.1 6.7 9.9 7.4 15.2 18.6 14.6 30.5l-9.6 198.4h314.4C829 418.5 840 436.9 840 456c0 16.5-7.2 32.1-19.6 43z" } }] }, "name": "like", "theme": "outlined" };
	exports.default = LikeOutlined;
	});

	var LikeOutlinedSvg = unwrapExports(LikeOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var LikeOutlined = function LikeOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: LikeOutlinedSvg
	  }));
	};

	LikeOutlined.displayName = 'LikeOutlined';
	var LikeOutlined$1 = /*#__PURE__*/React.forwardRef(LikeOutlined);

	var LikeTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var LikeTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M273 495.9v428l.3-428zm538.2-88.3H496.8l9.6-198.4c.6-11.9-4.7-23.1-14.6-30.5-6.1-4.5-13.6-6.8-21.1-6.7-19.6.1-36.9 13.4-42.2 32.3-37.1 134.4-64.9 235.2-83.5 302.5V852h399.4a56.85 56.85 0 0033.6-51.8c0-9.7-2.3-18.9-6.9-27.3l-13.9-25.4 21.9-19a56.76 56.76 0 0019.6-43c0-9.7-2.3-18.9-6.9-27.3l-13.9-25.4 21.9-19a56.76 56.76 0 0019.6-43c0-9.7-2.3-18.9-6.9-27.3l-14-25.5 21.9-19a56.76 56.76 0 0019.6-43c0-19.1-11-37.5-28.8-48.4z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M112 528v364c0 17.7 14.3 32 32 32h65V496h-65c-17.7 0-32 14.3-32 32zm773.9 5.7c16.8-22.2 26.1-49.4 26.1-77.7 0-44.9-25.1-87.5-65.5-111a67.67 67.67 0 00-34.3-9.3H572.3l6-122.9c1.5-29.7-9-57.9-29.5-79.4a106.4 106.4 0 00-77.9-33.4c-52 0-98 35-111.8 85.1l-85.8 310.8-.3 428h472.1c9.3 0 18.2-1.8 26.5-5.4 47.6-20.3 78.3-66.8 78.3-118.4 0-12.6-1.8-25-5.4-37 16.8-22.2 26.1-49.4 26.1-77.7 0-12.6-1.8-25-5.4-37 16.8-22.2 26.1-49.4 26.1-77.7 0-12.6-1.8-25-5.4-37zM820.4 499l-21.9 19 14 25.5a56.2 56.2 0 016.9 27.3c0 16.5-7.1 32.2-19.6 43l-21.9 19 13.9 25.4a56.2 56.2 0 016.9 27.3c0 16.5-7.1 32.2-19.6 43l-21.9 19 13.9 25.4a56.2 56.2 0 016.9 27.3c0 22.4-13.2 42.6-33.6 51.8H345V506.8c18.6-67.2 46.4-168 83.5-302.5a44.28 44.28 0 0142.2-32.3c7.5-.1 15 2.2 21.1 6.7 9.9 7.4 15.2 18.6 14.6 30.5l-9.6 198.4h314.4C829 418.5 840 436.9 840 456c0 16.5-7.1 32.2-19.6 43z", "fill": primaryColor } }] }; }, "name": "like", "theme": "twotone" };
	exports.default = LikeTwoTone;
	});

	var LikeTwoToneSvg = unwrapExports(LikeTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var LikeTwoTone = function LikeTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: LikeTwoToneSvg
	  }));
	};

	LikeTwoTone.displayName = 'LikeTwoTone';
	var LikeTwoTone$1 = /*#__PURE__*/React.forwardRef(LikeTwoTone);

	var LineChartOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var LineChartOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M888 792H200V168c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v688c0 4.4 3.6 8 8 8h752c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM305.8 637.7c3.1 3.1 8.1 3.1 11.3 0l138.3-137.6L583 628.5c3.1 3.1 8.2 3.1 11.3 0l275.4-275.3c3.1-3.1 3.1-8.2 0-11.3l-39.6-39.6a8.03 8.03 0 00-11.3 0l-230 229.9L461.4 404a8.03 8.03 0 00-11.3 0L266.3 586.7a8.03 8.03 0 000 11.3l39.5 39.7z" } }] }, "name": "line-chart", "theme": "outlined" };
	exports.default = LineChartOutlined;
	});

	var LineChartOutlinedSvg = unwrapExports(LineChartOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var LineChartOutlined = function LineChartOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: LineChartOutlinedSvg
	  }));
	};

	LineChartOutlined.displayName = 'LineChartOutlined';
	var LineChartOutlined$1 = /*#__PURE__*/React.forwardRef(LineChartOutlined);

	var LineHeightOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var LineHeightOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M648 160H104c-4.4 0-8 3.6-8 8v128c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-64h168v560h-92c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h264c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-92V232h168v64c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V168c0-4.4-3.6-8-8-8zm272.8 546H856V318h64.8c6 0 9.4-7 5.7-11.7L825.7 178.7a7.14 7.14 0 00-11.3 0L713.6 306.3a7.23 7.23 0 005.7 11.7H784v388h-64.8c-6 0-9.4 7-5.7 11.7l100.8 127.5c2.9 3.7 8.5 3.7 11.3 0l100.8-127.5a7.2 7.2 0 00-5.6-11.7z" } }] }, "name": "line-height", "theme": "outlined" };
	exports.default = LineHeightOutlined;
	});

	var LineHeightOutlinedSvg = unwrapExports(LineHeightOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var LineHeightOutlined = function LineHeightOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: LineHeightOutlinedSvg
	  }));
	};

	LineHeightOutlined.displayName = 'LineHeightOutlined';
	var LineHeightOutlined$1 = /*#__PURE__*/React.forwardRef(LineHeightOutlined);

	var LineOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var LineOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M904 476H120c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8z" } }] }, "name": "line", "theme": "outlined" };
	exports.default = LineOutlined;
	});

	var LineOutlinedSvg = unwrapExports(LineOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var LineOutlined = function LineOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: LineOutlinedSvg
	  }));
	};

	LineOutlined.displayName = 'LineOutlined';
	var LineOutlined$1 = /*#__PURE__*/React.forwardRef(LineOutlined);

	var LinkOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var LinkOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M574 665.4a8.03 8.03 0 00-11.3 0L446.5 781.6c-53.8 53.8-144.6 59.5-204 0-59.5-59.5-53.8-150.2 0-204l116.2-116.2c3.1-3.1 3.1-8.2 0-11.3l-39.8-39.8a8.03 8.03 0 00-11.3 0L191.4 526.5c-84.6 84.6-84.6 221.5 0 306s221.5 84.6 306 0l116.2-116.2c3.1-3.1 3.1-8.2 0-11.3L574 665.4zm258.6-474c-84.6-84.6-221.5-84.6-306 0L410.3 307.6a8.03 8.03 0 000 11.3l39.7 39.7c3.1 3.1 8.2 3.1 11.3 0l116.2-116.2c53.8-53.8 144.6-59.5 204 0 59.5 59.5 53.8 150.2 0 204L665.3 562.6a8.03 8.03 0 000 11.3l39.8 39.8c3.1 3.1 8.2 3.1 11.3 0l116.2-116.2c84.5-84.6 84.5-221.5 0-306.1zM610.1 372.3a8.03 8.03 0 00-11.3 0L372.3 598.7a8.03 8.03 0 000 11.3l39.6 39.6c3.1 3.1 8.2 3.1 11.3 0l226.4-226.4c3.1-3.1 3.1-8.2 0-11.3l-39.5-39.6z" } }] }, "name": "link", "theme": "outlined" };
	exports.default = LinkOutlined;
	});

	var LinkOutlinedSvg = unwrapExports(LinkOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var LinkOutlined = function LinkOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: LinkOutlinedSvg
	  }));
	};

	LinkOutlined.displayName = 'LinkOutlined';
	var LinkOutlined$1 = /*#__PURE__*/React.forwardRef(LinkOutlined);

	var LinkedinFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var LinkedinFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM349.3 793.7H230.6V411.9h118.7v381.8zm-59.3-434a68.8 68.8 0 1168.8-68.8c-.1 38-30.9 68.8-68.8 68.8zm503.7 434H675.1V608c0-44.3-.8-101.2-61.7-101.2-61.7 0-71.2 48.2-71.2 98v188.9H423.7V411.9h113.8v52.2h1.6c15.8-30 54.5-61.7 112.3-61.7 120.2 0 142.3 79.1 142.3 181.9v209.4z" } }] }, "name": "linkedin", "theme": "filled" };
	exports.default = LinkedinFilled;
	});

	var LinkedinFilledSvg = unwrapExports(LinkedinFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var LinkedinFilled = function LinkedinFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: LinkedinFilledSvg
	  }));
	};

	LinkedinFilled.displayName = 'LinkedinFilled';
	var LinkedinFilled$1 = /*#__PURE__*/React.forwardRef(LinkedinFilled);

	var LinkedinOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var LinkedinOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M847.7 112H176.3c-35.5 0-64.3 28.8-64.3 64.3v671.4c0 35.5 28.8 64.3 64.3 64.3h671.4c35.5 0 64.3-28.8 64.3-64.3V176.3c0-35.5-28.8-64.3-64.3-64.3zm0 736c-447.8-.1-671.7-.2-671.7-.3.1-447.8.2-671.7.3-671.7 447.8.1 671.7.2 671.7.3-.1 447.8-.2 671.7-.3 671.7zM230.6 411.9h118.7v381.8H230.6zm59.4-52.2c37.9 0 68.8-30.8 68.8-68.8a68.8 68.8 0 10-137.6 0c-.1 38 30.7 68.8 68.8 68.8zm252.3 245.1c0-49.8 9.5-98 71.2-98 60.8 0 61.7 56.9 61.7 101.2v185.7h118.6V584.3c0-102.8-22.2-181.9-142.3-181.9-57.7 0-96.4 31.7-112.3 61.7h-1.6v-52.2H423.7v381.8h118.6V604.8z" } }] }, "name": "linkedin", "theme": "outlined" };
	exports.default = LinkedinOutlined;
	});

	var LinkedinOutlinedSvg = unwrapExports(LinkedinOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var LinkedinOutlined = function LinkedinOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: LinkedinOutlinedSvg
	  }));
	};

	LinkedinOutlined.displayName = 'LinkedinOutlined';
	var LinkedinOutlined$1 = /*#__PURE__*/React.forwardRef(LinkedinOutlined);

	var Loading3QuartersOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var Loading3QuartersOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 1024c-69.1 0-136.2-13.5-199.3-40.2C251.7 958 197 921 150 874c-47-47-84-101.7-109.8-162.7C13.5 648.2 0 581.1 0 512c0-19.9 16.1-36 36-36s36 16.1 36 36c0 59.4 11.6 117 34.6 171.3 22.2 52.4 53.9 99.5 94.3 139.9 40.4 40.4 87.5 72.2 139.9 94.3C395 940.4 452.6 952 512 952c59.4 0 117-11.6 171.3-34.6 52.4-22.2 99.5-53.9 139.9-94.3 40.4-40.4 72.2-87.5 94.3-139.9C940.4 629 952 571.4 952 512c0-59.4-11.6-117-34.6-171.3a440.45 440.45 0 00-94.3-139.9 437.71 437.71 0 00-139.9-94.3C629 83.6 571.4 72 512 72c-19.9 0-36-16.1-36-36s16.1-36 36-36c69.1 0 136.2 13.5 199.3 40.2C772.3 66 827 103 874 150c47 47 83.9 101.8 109.7 162.7 26.7 63.1 40.2 130.2 40.2 199.3s-13.5 136.2-40.2 199.3C958 772.3 921 827 874 874c-47 47-101.8 83.9-162.7 109.7-63.1 26.8-130.2 40.3-199.3 40.3z" } }] }, "name": "loading-3-quarters", "theme": "outlined" };
	exports.default = Loading3QuartersOutlined;
	});

	var Loading3QuartersOutlinedSvg = unwrapExports(Loading3QuartersOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var Loading3QuartersOutlined = function Loading3QuartersOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: Loading3QuartersOutlinedSvg
	  }));
	};

	Loading3QuartersOutlined.displayName = 'Loading3QuartersOutlined';
	var Loading3QuartersOutlined$1 = /*#__PURE__*/React.forwardRef(Loading3QuartersOutlined);

	var LoadingOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var LoadingOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M988 548c-19.9 0-36-16.1-36-36 0-59.4-11.6-117-34.6-171.3a440.45 440.45 0 00-94.3-139.9 437.71 437.71 0 00-139.9-94.3C629 83.6 571.4 72 512 72c-19.9 0-36-16.1-36-36s16.1-36 36-36c69.1 0 136.2 13.5 199.3 40.3C772.3 66 827 103 874 150c47 47 83.9 101.8 109.7 162.7 26.7 63.1 40.2 130.2 40.2 199.3.1 19.9-16 36-35.9 36z" } }] }, "name": "loading", "theme": "outlined" };
	exports.default = LoadingOutlined;
	});

	var LoadingOutlinedSvg = unwrapExports(LoadingOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var LoadingOutlined = function LoadingOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: LoadingOutlinedSvg
	  }));
	};

	LoadingOutlined.displayName = 'LoadingOutlined';
	var LoadingOutlined$1 = /*#__PURE__*/React.forwardRef(LoadingOutlined);

	var LockFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var LockFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M832 464h-68V240c0-70.7-57.3-128-128-128H388c-70.7 0-128 57.3-128 128v224h-68c-17.7 0-32 14.3-32 32v384c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V496c0-17.7-14.3-32-32-32zM540 701v53c0 4.4-3.6 8-8 8h-40c-4.4 0-8-3.6-8-8v-53a48.01 48.01 0 1156 0zm152-237H332V240c0-30.9 25.1-56 56-56h248c30.9 0 56 25.1 56 56v224z" } }] }, "name": "lock", "theme": "filled" };
	exports.default = LockFilled;
	});

	var LockFilledSvg = unwrapExports(LockFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var LockFilled = function LockFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: LockFilledSvg
	  }));
	};

	LockFilled.displayName = 'LockFilled';
	var LockFilled$1 = /*#__PURE__*/React.forwardRef(LockFilled);

	var LockOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var LockOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M832 464h-68V240c0-70.7-57.3-128-128-128H388c-70.7 0-128 57.3-128 128v224h-68c-17.7 0-32 14.3-32 32v384c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V496c0-17.7-14.3-32-32-32zM332 240c0-30.9 25.1-56 56-56h248c30.9 0 56 25.1 56 56v224H332V240zm460 600H232V536h560v304zM484 701v53c0 4.4 3.6 8 8 8h40c4.4 0 8-3.6 8-8v-53a48.01 48.01 0 10-56 0z" } }] }, "name": "lock", "theme": "outlined" };
	exports.default = LockOutlined;
	});

	var LockOutlinedSvg = unwrapExports(LockOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var LockOutlined = function LockOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: LockOutlinedSvg
	  }));
	};

	LockOutlined.displayName = 'LockOutlined';
	var LockOutlined$1 = /*#__PURE__*/React.forwardRef(LockOutlined);

	var LockTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var LockTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M832 464h-68V240c0-70.7-57.3-128-128-128H388c-70.7 0-128 57.3-128 128v224h-68c-17.7 0-32 14.3-32 32v384c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V496c0-17.7-14.3-32-32-32zM332 240c0-30.9 25.1-56 56-56h248c30.9 0 56 25.1 56 56v224H332V240zm460 600H232V536h560v304z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M232 840h560V536H232v304zm280-226a48.01 48.01 0 0128 87v53c0 4.4-3.6 8-8 8h-40c-4.4 0-8-3.6-8-8v-53a48.01 48.01 0 0128-87z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M484 701v53c0 4.4 3.6 8 8 8h40c4.4 0 8-3.6 8-8v-53a48.01 48.01 0 10-56 0z", "fill": primaryColor } }] }; }, "name": "lock", "theme": "twotone" };
	exports.default = LockTwoTone;
	});

	var LockTwoToneSvg = unwrapExports(LockTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var LockTwoTone = function LockTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: LockTwoToneSvg
	  }));
	};

	LockTwoTone.displayName = 'LockTwoTone';
	var LockTwoTone$1 = /*#__PURE__*/React.forwardRef(LockTwoTone);

	var LoginOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var LoginOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M521.7 82c-152.5-.4-286.7 78.5-363.4 197.7-3.4 5.3.4 12.3 6.7 12.3h70.3c4.8 0 9.3-2.1 12.3-5.8 7-8.5 14.5-16.7 22.4-24.5 32.6-32.5 70.5-58.1 112.7-75.9 43.6-18.4 90-27.8 137.9-27.8 47.9 0 94.3 9.3 137.9 27.8 42.2 17.8 80.1 43.4 112.7 75.9 32.6 32.5 58.1 70.4 76 112.5C865.7 417.8 875 464.1 875 512c0 47.9-9.4 94.2-27.8 137.8-17.8 42.1-43.4 80-76 112.5s-70.5 58.1-112.7 75.9A352.8 352.8 0 01520.6 866c-47.9 0-94.3-9.4-137.9-27.8A353.84 353.84 0 01270 762.3c-7.9-7.9-15.3-16.1-22.4-24.5-3-3.7-7.6-5.8-12.3-5.8H165c-6.3 0-10.2 7-6.7 12.3C234.9 863.2 368.5 942 520.6 942c236.2 0 428-190.1 430.4-425.6C953.4 277.1 761.3 82.6 521.7 82zM395.02 624v-76h-314c-4.4 0-8-3.6-8-8v-56c0-4.4 3.6-8 8-8h314v-76c0-6.7 7.8-10.5 13-6.3l141.9 112a8 8 0 010 12.6l-141.9 112c-5.2 4.1-13 .4-13-6.3z" } }] }, "name": "login", "theme": "outlined" };
	exports.default = LoginOutlined;
	});

	var LoginOutlinedSvg = unwrapExports(LoginOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var LoginOutlined = function LoginOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: LoginOutlinedSvg
	  }));
	};

	LoginOutlined.displayName = 'LoginOutlined';
	var LoginOutlined$1 = /*#__PURE__*/React.forwardRef(LoginOutlined);

	var LogoutOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var LogoutOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M868 732h-70.3c-4.8 0-9.3 2.1-12.3 5.8-7 8.5-14.5 16.7-22.4 24.5a353.84 353.84 0 01-112.7 75.9A352.8 352.8 0 01512.4 866c-47.9 0-94.3-9.4-137.9-27.8a353.84 353.84 0 01-112.7-75.9 353.28 353.28 0 01-76-112.5C167.3 606.2 158 559.9 158 512s9.4-94.2 27.8-137.8c17.8-42.1 43.4-80 76-112.5s70.5-58.1 112.7-75.9c43.6-18.4 90-27.8 137.9-27.8 47.9 0 94.3 9.3 137.9 27.8 42.2 17.8 80.1 43.4 112.7 75.9 7.9 7.9 15.3 16.1 22.4 24.5 3 3.7 7.6 5.8 12.3 5.8H868c6.3 0 10.2-7 6.7-12.3C798 160.5 663.8 81.6 511.3 82 271.7 82.6 79.6 277.1 82 516.4 84.4 751.9 276.2 942 512.4 942c152.1 0 285.7-78.8 362.3-197.7 3.4-5.3-.4-12.3-6.7-12.3zm88.9-226.3L815 393.7c-5.3-4.2-13-.4-13 6.3v76H488c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h314v76c0 6.7 7.8 10.5 13 6.3l141.9-112a8 8 0 000-12.6z" } }] }, "name": "logout", "theme": "outlined" };
	exports.default = LogoutOutlined;
	});

	var LogoutOutlinedSvg = unwrapExports(LogoutOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var LogoutOutlined = function LogoutOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: LogoutOutlinedSvg
	  }));
	};

	LogoutOutlined.displayName = 'LogoutOutlined';
	var LogoutOutlined$1 = /*#__PURE__*/React.forwardRef(LogoutOutlined);

	var MacCommandFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var MacCommandFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M624 672a48.01 48.01 0 0096 0c0-26.5-21.5-48-48-48h-48v48zm96-320a48.01 48.01 0 00-96 0v48h48c26.5 0 48-21.5 48-48z" } }, { "tag": "path", "attrs": { "d": "M928 64H96c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V96c0-17.7-14.3-32-32-32zM672 560c61.9 0 112 50.1 112 112s-50.1 112-112 112-112-50.1-112-112v-48h-96v48c0 61.9-50.1 112-112 112s-112-50.1-112-112 50.1-112 112-112h48v-96h-48c-61.9 0-112-50.1-112-112s50.1-112 112-112 112 50.1 112 112v48h96v-48c0-61.9 50.1-112 112-112s112 50.1 112 112-50.1 112-112 112h-48v96h48z" } }, { "tag": "path", "attrs": { "d": "M464 464h96v96h-96zM352 304a48.01 48.01 0 000 96h48v-48c0-26.5-21.5-48-48-48zm-48 368a48.01 48.01 0 0096 0v-48h-48c-26.5 0-48 21.5-48 48z" } }] }, "name": "mac-command", "theme": "filled" };
	exports.default = MacCommandFilled;
	});

	var MacCommandFilledSvg = unwrapExports(MacCommandFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var MacCommandFilled = function MacCommandFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: MacCommandFilledSvg
	  }));
	};

	MacCommandFilled.displayName = 'MacCommandFilled';
	var MacCommandFilled$1 = /*#__PURE__*/React.forwardRef(MacCommandFilled);

	var MacCommandOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var MacCommandOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z" } }, { "tag": "path", "attrs": { "d": "M370.8 554.4c-54.6 0-98.8 44.2-98.8 98.8s44.2 98.8 98.8 98.8 98.8-44.2 98.8-98.8v-42.4h84.7v42.4c0 54.6 44.2 98.8 98.8 98.8s98.8-44.2 98.8-98.8-44.2-98.8-98.8-98.8h-42.4v-84.7h42.4c54.6 0 98.8-44.2 98.8-98.8 0-54.6-44.2-98.8-98.8-98.8s-98.8 44.2-98.8 98.8v42.4h-84.7v-42.4c0-54.6-44.2-98.8-98.8-98.8S272 316.2 272 370.8s44.2 98.8 98.8 98.8h42.4v84.7h-42.4zm42.4 98.8c0 23.4-19 42.4-42.4 42.4s-42.4-19-42.4-42.4 19-42.4 42.4-42.4h42.4v42.4zm197.6-282.4c0-23.4 19-42.4 42.4-42.4s42.4 19 42.4 42.4-19 42.4-42.4 42.4h-42.4v-42.4zm0 240h42.4c23.4 0 42.4 19 42.4 42.4s-19 42.4-42.4 42.4-42.4-19-42.4-42.4v-42.4zM469.6 469.6h84.7v84.7h-84.7v-84.7zm-98.8-56.4c-23.4 0-42.4-19-42.4-42.4s19-42.4 42.4-42.4 42.4 19 42.4 42.4v42.4h-42.4z" } }] }, "name": "mac-command", "theme": "outlined" };
	exports.default = MacCommandOutlined;
	});

	var MacCommandOutlinedSvg = unwrapExports(MacCommandOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var MacCommandOutlined = function MacCommandOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: MacCommandOutlinedSvg
	  }));
	};

	MacCommandOutlined.displayName = 'MacCommandOutlined';
	var MacCommandOutlined$1 = /*#__PURE__*/React.forwardRef(MacCommandOutlined);

	var MailFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var MailFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M928 160H96c-17.7 0-32 14.3-32 32v640c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V192c0-17.7-14.3-32-32-32zm-80.8 108.9L531.7 514.4c-7.8 6.1-18.7 6.1-26.5 0L189.6 268.9A7.2 7.2 0 01194 256h648.8a7.2 7.2 0 014.4 12.9z" } }] }, "name": "mail", "theme": "filled" };
	exports.default = MailFilled;
	});

	var MailFilledSvg = unwrapExports(MailFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var MailFilled = function MailFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: MailFilledSvg
	  }));
	};

	MailFilled.displayName = 'MailFilled';
	var MailFilled$1 = /*#__PURE__*/React.forwardRef(MailFilled);

	var MailOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var MailOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M928 160H96c-17.7 0-32 14.3-32 32v640c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V192c0-17.7-14.3-32-32-32zm-40 110.8V792H136V270.8l-27.6-21.5 39.3-50.5 42.8 33.3h643.1l42.8-33.3 39.3 50.5-27.7 21.5zM833.6 232L512 482 190.4 232l-42.8-33.3-39.3 50.5 27.6 21.5 341.6 265.6a55.99 55.99 0 0068.7 0L888 270.8l27.6-21.5-39.3-50.5-42.7 33.2z" } }] }, "name": "mail", "theme": "outlined" };
	exports.default = MailOutlined;
	});

	var MailOutlinedSvg = unwrapExports(MailOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var MailOutlined = function MailOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: MailOutlinedSvg
	  }));
	};

	MailOutlined.displayName = 'MailOutlined';
	var MailOutlined$1 = /*#__PURE__*/React.forwardRef(MailOutlined);

	var MailTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var MailTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M477.5 536.3L135.9 270.7l-27.5-21.4 27.6 21.5V792h752V270.8L546.2 536.3a55.99 55.99 0 01-68.7 0z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M876.3 198.8l39.3 50.5-27.6 21.5 27.7-21.5-39.3-50.5z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M928 160H96c-17.7 0-32 14.3-32 32v640c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V192c0-17.7-14.3-32-32-32zm-94.5 72.1L512 482 190.5 232.1h643zm54.5 38.7V792H136V270.8l-27.6-21.5 27.5 21.4 341.6 265.6a55.99 55.99 0 0068.7 0L888 270.8l27.6-21.5-39.3-50.5h.1l39.3 50.5-27.7 21.5z", "fill": primaryColor } }] }; }, "name": "mail", "theme": "twotone" };
	exports.default = MailTwoTone;
	});

	var MailTwoToneSvg = unwrapExports(MailTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var MailTwoTone = function MailTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: MailTwoToneSvg
	  }));
	};

	MailTwoTone.displayName = 'MailTwoTone';
	var MailTwoTone$1 = /*#__PURE__*/React.forwardRef(MailTwoTone);

	var ManOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ManOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M874 120H622c-3.3 0-6 2.7-6 6v56c0 3.3 2.7 6 6 6h160.4L583.1 387.3c-50-38.5-111-59.3-175.1-59.3-76.9 0-149.3 30-203.6 84.4S120 539.1 120 616s30 149.3 84.4 203.6C258.7 874 331.1 904 408 904s149.3-30 203.6-84.4C666 765.3 696 692.9 696 616c0-64.1-20.8-124.9-59.2-174.9L836 241.9V402c0 3.3 2.7 6 6 6h56c3.3 0 6-2.7 6-6V150c0-16.5-13.5-30-30-30zM408 828c-116.9 0-212-95.1-212-212s95.1-212 212-212 212 95.1 212 212-95.1 212-212 212z" } }] }, "name": "man", "theme": "outlined" };
	exports.default = ManOutlined;
	});

	var ManOutlinedSvg = unwrapExports(ManOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var ManOutlined = function ManOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ManOutlinedSvg
	  }));
	};

	ManOutlined.displayName = 'ManOutlined';
	var ManOutlined$1 = /*#__PURE__*/React.forwardRef(ManOutlined);

	var MedicineBoxFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var MedicineBoxFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M839.2 278.1a32 32 0 00-30.4-22.1H736V144c0-17.7-14.3-32-32-32H320c-17.7 0-32 14.3-32 32v112h-72.8a31.9 31.9 0 00-30.4 22.1L112 502v378c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V502l-72.8-223.9zM660 628c0 4.4-3.6 8-8 8H544v108c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V636H372c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h108V464c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v108h108c4.4 0 8 3.6 8 8v48zm4-372H360v-72h304v72z" } }] }, "name": "medicine-box", "theme": "filled" };
	exports.default = MedicineBoxFilled;
	});

	var MedicineBoxFilledSvg = unwrapExports(MedicineBoxFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var MedicineBoxFilled = function MedicineBoxFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: MedicineBoxFilledSvg
	  }));
	};

	MedicineBoxFilled.displayName = 'MedicineBoxFilled';
	var MedicineBoxFilled$1 = /*#__PURE__*/React.forwardRef(MedicineBoxFilled);

	var MedicineBoxOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var MedicineBoxOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M839.2 278.1a32 32 0 00-30.4-22.1H736V144c0-17.7-14.3-32-32-32H320c-17.7 0-32 14.3-32 32v112h-72.8a31.9 31.9 0 00-30.4 22.1L112 502v378c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V502l-72.8-223.9zM360 184h304v72H360v-72zm480 656H184V513.4L244.3 328h535.4L840 513.4V840zM652 572H544V464c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v108H372c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h108v108c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V636h108c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8z" } }] }, "name": "medicine-box", "theme": "outlined" };
	exports.default = MedicineBoxOutlined;
	});

	var MedicineBoxOutlinedSvg = unwrapExports(MedicineBoxOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var MedicineBoxOutlined = function MedicineBoxOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: MedicineBoxOutlinedSvg
	  }));
	};

	MedicineBoxOutlined.displayName = 'MedicineBoxOutlined';
	var MedicineBoxOutlined$1 = /*#__PURE__*/React.forwardRef(MedicineBoxOutlined);

	var MedicineBoxTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var MedicineBoxTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M244.3 328L184 513.4V840h656V513.4L779.7 328H244.3zM660 628c0 4.4-3.6 8-8 8H544v108c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V636H372c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h108V464c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v108h108c4.4 0 8 3.6 8 8v48z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M652 572H544V464c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v108H372c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h108v108c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V636h108c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M839.2 278.1a32 32 0 00-30.4-22.1H736V144c0-17.7-14.3-32-32-32H320c-17.7 0-32 14.3-32 32v112h-72.8a31.9 31.9 0 00-30.4 22.1L112 502v378c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V502l-72.8-223.9zM360 184h304v72H360v-72zm480 656H184V513.4L244.3 328h535.4L840 513.4V840z", "fill": primaryColor } }] }; }, "name": "medicine-box", "theme": "twotone" };
	exports.default = MedicineBoxTwoTone;
	});

	var MedicineBoxTwoToneSvg = unwrapExports(MedicineBoxTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var MedicineBoxTwoTone = function MedicineBoxTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: MedicineBoxTwoToneSvg
	  }));
	};

	MedicineBoxTwoTone.displayName = 'MedicineBoxTwoTone';
	var MedicineBoxTwoTone$1 = /*#__PURE__*/React.forwardRef(MedicineBoxTwoTone);

	var MediumCircleFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var MediumCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm256 253.7l-40.8 39.1c-3.6 2.7-5.3 7.1-4.6 11.4v287.7c-.7 4.4 1 8.8 4.6 11.4l40 39.1v8.7H566.4v-8.3l41.3-40.1c4.1-4.1 4.1-5.3 4.1-11.4V422.5l-115 291.6h-15.5L347.5 422.5V618c-1.2 8.2 1.7 16.5 7.5 22.4l53.8 65.1v8.7H256v-8.7l53.8-65.1a26.1 26.1 0 007-22.4V392c.7-6.3-1.7-12.4-6.5-16.7l-47.8-57.6V309H411l114.6 251.5 100.9-251.3H768v8.5z" } }] }, "name": "medium-circle", "theme": "filled" };
	exports.default = MediumCircleFilled;
	});

	var MediumCircleFilledSvg = unwrapExports(MediumCircleFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var MediumCircleFilled = function MediumCircleFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: MediumCircleFilledSvg
	  }));
	};

	MediumCircleFilled.displayName = 'MediumCircleFilled';
	var MediumCircleFilled$1 = /*#__PURE__*/React.forwardRef(MediumCircleFilled);

	var MediumOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var MediumOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M834.7 279.8l61.3-58.9V208H683.7L532.4 586.4 360.3 208H137.7v12.9l71.6 86.6c7 6.4 10.6 15.8 9.7 25.2V673c2.2 12.3-1.7 24.8-10.3 33.7L128 805v12.7h228.6v-12.9l-80.6-98a39.99 39.99 0 01-11.1-33.7V378.7l200.7 439.2h23.3l172.6-439.2v349.9c0 9.2 0 11.1-6 17.2l-62.1 60.3V819h301.2v-12.9l-59.9-58.9c-5.2-4-7.9-10.7-6.8-17.2V297a18.1 18.1 0 016.8-17.2z" } }] }, "name": "medium", "theme": "outlined" };
	exports.default = MediumOutlined;
	});

	var MediumOutlinedSvg = unwrapExports(MediumOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var MediumOutlined = function MediumOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: MediumOutlinedSvg
	  }));
	};

	MediumOutlined.displayName = 'MediumOutlined';
	var MediumOutlined$1 = /*#__PURE__*/React.forwardRef(MediumOutlined);

	var MediumSquareFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var MediumSquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM768 317.7l-40.8 39.1c-3.6 2.7-5.3 7.1-4.6 11.4v287.7c-.7 4.4 1 8.8 4.6 11.4l40 39.1v8.7H566.4v-8.3l41.3-40.1c4.1-4.1 4.1-5.3 4.1-11.4V422.5l-115 291.6h-15.5L347.5 422.5V618c-1.2 8.2 1.7 16.5 7.5 22.4l53.8 65.1v8.7H256v-8.7l53.8-65.1a26.1 26.1 0 007-22.4V392c.7-6.3-1.7-12.4-6.5-16.7l-47.8-57.6V309H411l114.6 251.5 100.9-251.3H768v8.5z" } }] }, "name": "medium-square", "theme": "filled" };
	exports.default = MediumSquareFilled;
	});

	var MediumSquareFilledSvg = unwrapExports(MediumSquareFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var MediumSquareFilled = function MediumSquareFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: MediumSquareFilledSvg
	  }));
	};

	MediumSquareFilled.displayName = 'MediumSquareFilled';
	var MediumSquareFilled$1 = /*#__PURE__*/React.forwardRef(MediumSquareFilled);

	var MediumWorkmarkOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var MediumWorkmarkOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M517.2 590.55c0 3.55 0 4.36 2.4 6.55l13.43 13.25v.57h-59.57v-25.47a41.44 41.44 0 01-39.5 27.65c-30.61 0-52.84-24.25-52.84-68.87 0-41.8 23.99-69.69 57.65-69.69a35.15 35.15 0 0134.61 21.67v-56.19a6.99 6.99 0 00-2.71-6.79l-12.8-12.45v-.56l59.33-7.04v177.37zm-43.74-8.09v-83.83a22.2 22.2 0 00-17.74-8.4c-14.48 0-28.47 13.25-28.47 52.62 0 36.86 12.07 49.88 27.1 49.88a23.91 23.91 0 0019.11-10.27zm83.23 28.46V497.74a7.65 7.65 0 00-2.4-6.79l-13.19-13.74v-.57h59.56v114.8c0 3.55 0 4.36 2.4 6.54l13.12 12.45v.57l-59.49-.08zm-2.16-175.67c0-13.4 10.74-24.25 23.99-24.25 13.25 0 23.98 10.86 23.98 24.25 0 13.4-10.73 24.25-23.98 24.25s-23.99-10.85-23.99-24.25zm206.83 155.06c0 3.55 0 4.6 2.4 6.79l13.43 13.25v.57h-59.88V581.9a43.4 43.4 0 01-41.01 31.2c-26.55 0-40.78-19.56-40.78-56.59 0-17.86 0-37.43.56-59.41a6.91 6.91 0 00-2.4-6.55L620.5 477.2v-.57h59.09v73.81c0 24.25 3.51 40.42 18.54 40.42a23.96 23.96 0 0019.35-12.2v-80.85a7.65 7.65 0 00-2.4-6.79l-13.27-13.82v-.57h59.56V590.3zm202.76 20.6c0-4.36.8-59.97.8-72.75 0-24.25-3.76-40.98-20.63-40.98a26.7 26.7 0 00-21.19 11.64 99.68 99.68 0 012.4 23.04c0 16.81-.56 38.23-.8 59.66a6.91 6.91 0 002.4 6.55l13.43 12.45v.56h-60.12c0-4.04.8-59.98.8-72.76 0-24.65-3.76-40.98-20.39-40.98-8.2.3-15.68 4.8-19.83 11.96v82.46c0 3.56 0 4.37 2.4 6.55l13.11 12.45v.56h-59.48V498.15a7.65 7.65 0 00-2.4-6.8l-13.19-14.14v-.57H841v28.78c5.53-19 23.13-31.76 42.7-30.96 19.82 0 33.26 11.16 38.93 32.34a46.41 46.41 0 0144.77-32.34c26.55 0 41.58 19.8 41.58 57.23 0 17.87-.56 38.24-.8 59.66a6.5 6.5 0 002.72 6.55l13.11 12.45v.57h-59.88zM215.87 593.3l17.66 17.05v.57h-89.62v-.57l17.99-17.05a6.91 6.91 0 002.4-6.55V477.69c0-4.6 0-10.83.8-16.16L104.66 613.1h-.72l-62.6-139.45c-1.37-3.47-1.77-3.72-2.65-6.06v91.43a32.08 32.08 0 002.96 17.87l25.19 33.46v.57H0v-.57l25.18-33.55a32.16 32.16 0 002.96-17.78V457.97A19.71 19.71 0 0024 444.15L6.16 420.78v-.56h63.96l53.56 118.1 47.17-118.1h62.6v.56l-17.58 19.8a6.99 6.99 0 00-2.72 6.8v139.37a6.5 6.5 0 002.72 6.55zm70.11-54.65v.56c0 34.6 17.67 48.5 38.38 48.5a43.5 43.5 0 0040.77-24.97h.56c-7.2 34.2-28.14 50.36-59.48 50.36-33.82 0-65.72-20.61-65.72-68.39 0-50.2 31.98-70.25 67.32-70.25 28.46 0 58.76 13.58 58.76 57.24v6.95h-80.59zm0-6.95h39.42v-7.04c0-35.57-7.28-45.03-18.23-45.03-13.27 0-21.35 14.15-21.35 52.07h.16z" } }] }, "name": "medium-workmark", "theme": "outlined" };
	exports.default = MediumWorkmarkOutlined;
	});

	var MediumWorkmarkOutlinedSvg = unwrapExports(MediumWorkmarkOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var MediumWorkmarkOutlined = function MediumWorkmarkOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: MediumWorkmarkOutlinedSvg
	  }));
	};

	MediumWorkmarkOutlined.displayName = 'MediumWorkmarkOutlined';
	var MediumWorkmarkOutlined$1 = /*#__PURE__*/React.forwardRef(MediumWorkmarkOutlined);

	var MehFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var MehFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zM288 421a48.01 48.01 0 0196 0 48.01 48.01 0 01-96 0zm384 200c0 4.4-3.6 8-8 8H360c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h304c4.4 0 8 3.6 8 8v48zm16-152a48.01 48.01 0 010-96 48.01 48.01 0 010 96z" } }] }, "name": "meh", "theme": "filled" };
	exports.default = MehFilled;
	});

	var MehFilledSvg = unwrapExports(MehFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var MehFilled = function MehFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: MehFilledSvg
	  }));
	};

	MehFilled.displayName = 'MehFilled';
	var MehFilled$1 = /*#__PURE__*/React.forwardRef(MehFilled);

	var MehOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var MehOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M288 421a48 48 0 1096 0 48 48 0 10-96 0zm352 0a48 48 0 1096 0 48 48 0 10-96 0zM512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm263 711c-34.2 34.2-74 61-118.3 79.8C611 874.2 562.3 884 512 884c-50.3 0-99-9.8-144.8-29.2A370.4 370.4 0 01248.9 775c-34.2-34.2-61-74-79.8-118.3C149.8 611 140 562.3 140 512s9.8-99 29.2-144.8A370.4 370.4 0 01249 248.9c34.2-34.2 74-61 118.3-79.8C413 149.8 461.7 140 512 140c50.3 0 99 9.8 144.8 29.2A370.4 370.4 0 01775.1 249c34.2 34.2 61 74 79.8 118.3C874.2 413 884 461.7 884 512s-9.8 99-29.2 144.8A368.89 368.89 0 01775 775zM664 565H360c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h304c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8z" } }] }, "name": "meh", "theme": "outlined" };
	exports.default = MehOutlined;
	});

	var MehOutlinedSvg = unwrapExports(MehOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var MehOutlined = function MehOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: MehOutlinedSvg
	  }));
	};

	MehOutlined.displayName = 'MehOutlined';
	var MehOutlined$1 = /*#__PURE__*/React.forwardRef(MehOutlined);

	var MehTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var MehTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zM288 421a48.01 48.01 0 0196 0 48.01 48.01 0 01-96 0zm384 200c0 4.4-3.6 8-8 8H360c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h304c4.4 0 8 3.6 8 8v48zm16-152a48.01 48.01 0 010-96 48.01 48.01 0 010 96z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M288 421a48 48 0 1096 0 48 48 0 10-96 0zm376 144H360c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h304c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8zm-24-144a48 48 0 1096 0 48 48 0 10-96 0z", "fill": primaryColor } }] }; }, "name": "meh", "theme": "twotone" };
	exports.default = MehTwoTone;
	});

	var MehTwoToneSvg = unwrapExports(MehTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var MehTwoTone = function MehTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: MehTwoToneSvg
	  }));
	};

	MehTwoTone.displayName = 'MehTwoTone';
	var MehTwoTone$1 = /*#__PURE__*/React.forwardRef(MehTwoTone);

	var MenuFoldOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var MenuFoldOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M408 442h480c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H408c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm-8 204c0 4.4 3.6 8 8 8h480c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H408c-4.4 0-8 3.6-8 8v56zm504-486H120c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 632H120c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM115.4 518.9L271.7 642c5.8 4.6 14.4.5 14.4-6.9V388.9c0-7.4-8.5-11.5-14.4-6.9L115.4 505.1a8.74 8.74 0 000 13.8z" } }] }, "name": "menu-fold", "theme": "outlined" };
	exports.default = MenuFoldOutlined;
	});

	var MenuFoldOutlinedSvg = unwrapExports(MenuFoldOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var MenuFoldOutlined = function MenuFoldOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: MenuFoldOutlinedSvg
	  }));
	};

	MenuFoldOutlined.displayName = 'MenuFoldOutlined';
	var MenuFoldOutlined$1 = /*#__PURE__*/React.forwardRef(MenuFoldOutlined);

	var MenuOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var MenuOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M904 160H120c-4.4 0-8 3.6-8 8v64c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-64c0-4.4-3.6-8-8-8zm0 624H120c-4.4 0-8 3.6-8 8v64c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-64c0-4.4-3.6-8-8-8zm0-312H120c-4.4 0-8 3.6-8 8v64c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-64c0-4.4-3.6-8-8-8z" } }] }, "name": "menu", "theme": "outlined" };
	exports.default = MenuOutlined;
	});

	var MenuOutlinedSvg = unwrapExports(MenuOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var MenuOutlined = function MenuOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: MenuOutlinedSvg
	  }));
	};

	MenuOutlined.displayName = 'MenuOutlined';
	var MenuOutlined$1 = /*#__PURE__*/React.forwardRef(MenuOutlined);

	var MenuUnfoldOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var MenuUnfoldOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M408 442h480c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H408c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm-8 204c0 4.4 3.6 8 8 8h480c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H408c-4.4 0-8 3.6-8 8v56zm504-486H120c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 632H120c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM142.4 642.1L298.7 519a8.84 8.84 0 000-13.9L142.4 381.9c-5.8-4.6-14.4-.5-14.4 6.9v246.3a8.9 8.9 0 0014.4 7z" } }] }, "name": "menu-unfold", "theme": "outlined" };
	exports.default = MenuUnfoldOutlined;
	});

	var MenuUnfoldOutlinedSvg = unwrapExports(MenuUnfoldOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var MenuUnfoldOutlined = function MenuUnfoldOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: MenuUnfoldOutlinedSvg
	  }));
	};

	MenuUnfoldOutlined.displayName = 'MenuUnfoldOutlined';
	var MenuUnfoldOutlined$1 = /*#__PURE__*/React.forwardRef(MenuUnfoldOutlined);

	var MergeCellsOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var MergeCellsOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M482.2 508.4L331.3 389c-3-2.4-7.3-.2-7.3 3.6V478H184V184h204v128c0 2.2 1.8 4 4 4h60c2.2 0 4-1.8 4-4V144c0-15.5-12.5-28-28-28H144c-15.5 0-28 12.5-28 28v736c0 15.5 12.5 28 28 28h284c15.5 0 28-12.5 28-28V712c0-2.2-1.8-4-4-4h-60c-2.2 0-4 1.8-4 4v128H184V546h140v85.4c0 3.8 4.4 6 7.3 3.6l150.9-119.4a4.5 4.5 0 000-7.2zM880 116H596c-15.5 0-28 12.5-28 28v168c0 2.2 1.8 4 4 4h60c2.2 0 4-1.8 4-4V184h204v294H700v-85.4c0-3.8-4.3-6-7.3-3.6l-151 119.4a4.52 4.52 0 000 7.1l151 119.5c2.9 2.3 7.3.2 7.3-3.6V546h140v294H636V712c0-2.2-1.8-4-4-4h-60c-2.2 0-4 1.8-4 4v168c0 15.5 12.5 28 28 28h284c15.5 0 28-12.5 28-28V144c0-15.5-12.5-28-28-28z" } }] }, "name": "merge-cells", "theme": "outlined" };
	exports.default = MergeCellsOutlined;
	});

	var MergeCellsOutlinedSvg = unwrapExports(MergeCellsOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var MergeCellsOutlined = function MergeCellsOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: MergeCellsOutlinedSvg
	  }));
	};

	MergeCellsOutlined.displayName = 'MergeCellsOutlined';
	var MergeCellsOutlined$1 = /*#__PURE__*/React.forwardRef(MergeCellsOutlined);

	var MessageFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var MessageFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M924.3 338.4a447.57 447.57 0 00-96.1-143.3 443.09 443.09 0 00-143-96.3A443.91 443.91 0 00512 64h-2c-60.5.3-119 12.3-174.1 35.9a444.08 444.08 0 00-141.7 96.5 445 445 0 00-95 142.8A449.89 449.89 0 0065 514.1c.3 69.4 16.9 138.3 47.9 199.9v152c0 25.4 20.6 46 45.9 46h151.8a447.72 447.72 0 00199.5 48h2.1c59.8 0 117.7-11.6 172.3-34.3A443.2 443.2 0 00827 830.5c41.2-40.9 73.6-88.7 96.3-142 23.5-55.2 35.5-113.9 35.8-174.5.2-60.9-11.6-120-34.8-175.6zM312.4 560c-26.4 0-47.9-21.5-47.9-48s21.5-48 47.9-48 47.9 21.5 47.9 48-21.4 48-47.9 48zm199.6 0c-26.4 0-47.9-21.5-47.9-48s21.5-48 47.9-48 47.9 21.5 47.9 48-21.5 48-47.9 48zm199.6 0c-26.4 0-47.9-21.5-47.9-48s21.5-48 47.9-48 47.9 21.5 47.9 48-21.5 48-47.9 48z" } }] }, "name": "message", "theme": "filled" };
	exports.default = MessageFilled;
	});

	var MessageFilledSvg = unwrapExports(MessageFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var MessageFilled = function MessageFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: MessageFilledSvg
	  }));
	};

	MessageFilled.displayName = 'MessageFilled';
	var MessageFilled$1 = /*#__PURE__*/React.forwardRef(MessageFilled);

	var MessageOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var MessageOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M464 512a48 48 0 1096 0 48 48 0 10-96 0zm200 0a48 48 0 1096 0 48 48 0 10-96 0zm-400 0a48 48 0 1096 0 48 48 0 10-96 0zm661.2-173.6c-22.6-53.7-55-101.9-96.3-143.3a444.35 444.35 0 00-143.3-96.3C630.6 75.7 572.2 64 512 64h-2c-60.6.3-119.3 12.3-174.5 35.9a445.35 445.35 0 00-142 96.5c-40.9 41.3-73 89.3-95.2 142.8-23 55.4-34.6 114.3-34.3 174.9A449.4 449.4 0 00112 714v152a46 46 0 0046 46h152.1A449.4 449.4 0 00510 960h2.1c59.9 0 118-11.6 172.7-34.3a444.48 444.48 0 00142.8-95.2c41.3-40.9 73.8-88.7 96.5-142 23.6-55.2 35.6-113.9 35.9-174.5.3-60.9-11.5-120-34.8-175.6zm-151.1 438C704 845.8 611 884 512 884h-1.7c-60.3-.3-120.2-15.3-173.1-43.5l-8.4-4.5H188V695.2l-4.5-8.4C155.3 633.9 140.3 574 140 513.7c-.4-99.7 37.7-193.3 107.6-263.8 69.8-70.5 163.1-109.5 262.8-109.9h1.7c50 0 98.5 9.7 144.2 28.9 44.6 18.7 84.6 45.6 119 80 34.3 34.3 61.3 74.4 80 119 19.4 46.2 29.1 95.2 28.9 145.8-.6 99.6-39.7 192.9-110.1 262.7z" } }] }, "name": "message", "theme": "outlined" };
	exports.default = MessageOutlined;
	});

	var MessageOutlinedSvg = unwrapExports(MessageOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var MessageOutlined = function MessageOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: MessageOutlinedSvg
	  }));
	};

	MessageOutlined.displayName = 'MessageOutlined';
	var MessageOutlined$1 = /*#__PURE__*/React.forwardRef(MessageOutlined);

	var MessageTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var MessageTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M775.3 248.9a369.62 369.62 0 00-119-80A370.2 370.2 0 00512.1 140h-1.7c-99.7.4-193 39.4-262.8 109.9-69.9 70.5-108 164.1-107.6 263.8.3 60.3 15.3 120.2 43.5 173.1l4.5 8.4V836h140.8l8.4 4.5c52.9 28.2 112.8 43.2 173.1 43.5h1.7c99 0 192-38.2 262.1-107.6 70.4-69.8 109.5-163.1 110.1-262.7.2-50.6-9.5-99.6-28.9-145.8a370.15 370.15 0 00-80-119zM312 560a48.01 48.01 0 010-96 48.01 48.01 0 010 96zm200 0a48.01 48.01 0 010-96 48.01 48.01 0 010 96zm200 0a48.01 48.01 0 010-96 48.01 48.01 0 010 96z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M664 512a48 48 0 1096 0 48 48 0 10-96 0zm-400 0a48 48 0 1096 0 48 48 0 10-96 0z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M925.2 338.4c-22.6-53.7-55-101.9-96.3-143.3a444.35 444.35 0 00-143.3-96.3C630.6 75.7 572.2 64 512 64h-2c-60.6.3-119.3 12.3-174.5 35.9a445.35 445.35 0 00-142 96.5c-40.9 41.3-73 89.3-95.2 142.8-23 55.4-34.6 114.3-34.3 174.9A449.4 449.4 0 00112 714v152a46 46 0 0046 46h152.1A449.4 449.4 0 00510 960h2.1c59.9 0 118-11.6 172.7-34.3a444.48 444.48 0 00142.8-95.2c41.3-40.9 73.8-88.7 96.5-142 23.6-55.2 35.6-113.9 35.9-174.5.3-60.9-11.5-120-34.8-175.6zm-151.1 438C704 845.8 611 884 512 884h-1.7c-60.3-.3-120.2-15.3-173.1-43.5l-8.4-4.5H188V695.2l-4.5-8.4C155.3 633.9 140.3 574 140 513.7c-.4-99.7 37.7-193.3 107.6-263.8 69.8-70.5 163.1-109.5 262.8-109.9h1.7c50 0 98.5 9.7 144.2 28.9 44.6 18.7 84.6 45.6 119 80 34.3 34.3 61.3 74.4 80 119 19.4 46.2 29.1 95.2 28.9 145.8-.6 99.6-39.7 192.9-110.1 262.7z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M464 512a48 48 0 1096 0 48 48 0 10-96 0z", "fill": primaryColor } }] }; }, "name": "message", "theme": "twotone" };
	exports.default = MessageTwoTone;
	});

	var MessageTwoToneSvg = unwrapExports(MessageTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var MessageTwoTone = function MessageTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: MessageTwoToneSvg
	  }));
	};

	MessageTwoTone.displayName = 'MessageTwoTone';
	var MessageTwoTone$1 = /*#__PURE__*/React.forwardRef(MessageTwoTone);

	var MinusCircleFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var MinusCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm192 472c0 4.4-3.6 8-8 8H328c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h368c4.4 0 8 3.6 8 8v48z" } }] }, "name": "minus-circle", "theme": "filled" };
	exports.default = MinusCircleFilled;
	});

	var MinusCircleFilledSvg = unwrapExports(MinusCircleFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var MinusCircleFilled = function MinusCircleFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: MinusCircleFilledSvg
	  }));
	};

	MinusCircleFilled.displayName = 'MinusCircleFilled';
	var MinusCircleFilled$1 = /*#__PURE__*/React.forwardRef(MinusCircleFilled);

	var MinusCircleOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var MinusCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M696 480H328c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h368c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8z" } }, { "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z" } }] }, "name": "minus-circle", "theme": "outlined" };
	exports.default = MinusCircleOutlined;
	});

	var MinusCircleOutlinedSvg = unwrapExports(MinusCircleOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var MinusCircleOutlined = function MinusCircleOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: MinusCircleOutlinedSvg
	  }));
	};

	MinusCircleOutlined.displayName = 'MinusCircleOutlined';
	var MinusCircleOutlined$1 = /*#__PURE__*/React.forwardRef(MinusCircleOutlined);

	var MinusCircleTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var MinusCircleTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm192 396c0 4.4-3.6 8-8 8H328c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h368c4.4 0 8 3.6 8 8v48z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M696 480H328c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h368c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8z", "fill": primaryColor } }] }; }, "name": "minus-circle", "theme": "twotone" };
	exports.default = MinusCircleTwoTone;
	});

	var MinusCircleTwoToneSvg = unwrapExports(MinusCircleTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var MinusCircleTwoTone = function MinusCircleTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: MinusCircleTwoToneSvg
	  }));
	};

	MinusCircleTwoTone.displayName = 'MinusCircleTwoTone';
	var MinusCircleTwoTone$1 = /*#__PURE__*/React.forwardRef(MinusCircleTwoTone);

	var MinusOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var MinusOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M872 474H152c-4.4 0-8 3.6-8 8v60c0 4.4 3.6 8 8 8h720c4.4 0 8-3.6 8-8v-60c0-4.4-3.6-8-8-8z" } }] }, "name": "minus", "theme": "outlined" };
	exports.default = MinusOutlined;
	});

	var MinusOutlinedSvg = unwrapExports(MinusOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var MinusOutlined = function MinusOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: MinusOutlinedSvg
	  }));
	};

	MinusOutlined.displayName = 'MinusOutlined';
	var MinusOutlined$1 = /*#__PURE__*/React.forwardRef(MinusOutlined);

	var MinusSquareFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var MinusSquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM704 536c0 4.4-3.6 8-8 8H328c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h368c4.4 0 8 3.6 8 8v48z" } }] }, "name": "minus-square", "theme": "filled" };
	exports.default = MinusSquareFilled;
	});

	var MinusSquareFilledSvg = unwrapExports(MinusSquareFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var MinusSquareFilled = function MinusSquareFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: MinusSquareFilledSvg
	  }));
	};

	MinusSquareFilled.displayName = 'MinusSquareFilled';
	var MinusSquareFilled$1 = /*#__PURE__*/React.forwardRef(MinusSquareFilled);

	var MinusSquareOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var MinusSquareOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M328 544h368c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H328c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8z" } }, { "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z" } }] }, "name": "minus-square", "theme": "outlined" };
	exports.default = MinusSquareOutlined;
	});

	var MinusSquareOutlinedSvg = unwrapExports(MinusSquareOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var MinusSquareOutlined = function MinusSquareOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: MinusSquareOutlinedSvg
	  }));
	};

	MinusSquareOutlined.displayName = 'MinusSquareOutlined';
	var MinusSquareOutlined$1 = /*#__PURE__*/React.forwardRef(MinusSquareOutlined);

	var MinusSquareTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var MinusSquareTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M184 840h656V184H184v656zm136-352c0-4.4 3.6-8 8-8h368c4.4 0 8 3.6 8 8v48c0 4.4-3.6 8-8 8H328c-4.4 0-8-3.6-8-8v-48z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M328 544h368c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H328c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8z", "fill": primaryColor } }] }; }, "name": "minus-square", "theme": "twotone" };
	exports.default = MinusSquareTwoTone;
	});

	var MinusSquareTwoToneSvg = unwrapExports(MinusSquareTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var MinusSquareTwoTone = function MinusSquareTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: MinusSquareTwoToneSvg
	  }));
	};

	MinusSquareTwoTone.displayName = 'MinusSquareTwoTone';
	var MinusSquareTwoTone$1 = /*#__PURE__*/React.forwardRef(MinusSquareTwoTone);

	var MobileFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var MobileFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M744 62H280c-35.3 0-64 28.7-64 64v768c0 35.3 28.7 64 64 64h464c35.3 0 64-28.7 64-64V126c0-35.3-28.7-64-64-64zM512 824c-22.1 0-40-17.9-40-40s17.9-40 40-40 40 17.9 40 40-17.9 40-40 40z" } }] }, "name": "mobile", "theme": "filled" };
	exports.default = MobileFilled;
	});

	var MobileFilledSvg = unwrapExports(MobileFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var MobileFilled = function MobileFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: MobileFilledSvg
	  }));
	};

	MobileFilled.displayName = 'MobileFilled';
	var MobileFilled$1 = /*#__PURE__*/React.forwardRef(MobileFilled);

	var MobileOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var MobileOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M744 62H280c-35.3 0-64 28.7-64 64v768c0 35.3 28.7 64 64 64h464c35.3 0 64-28.7 64-64V126c0-35.3-28.7-64-64-64zm-8 824H288V134h448v752zM472 784a40 40 0 1080 0 40 40 0 10-80 0z" } }] }, "name": "mobile", "theme": "outlined" };
	exports.default = MobileOutlined;
	});

	var MobileOutlinedSvg = unwrapExports(MobileOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var MobileOutlined = function MobileOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: MobileOutlinedSvg
	  }));
	};

	MobileOutlined.displayName = 'MobileOutlined';
	var MobileOutlined$1 = /*#__PURE__*/React.forwardRef(MobileOutlined);

	var MobileTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var MobileTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M744 64H280c-35.3 0-64 28.7-64 64v768c0 35.3 28.7 64 64 64h464c35.3 0 64-28.7 64-64V128c0-35.3-28.7-64-64-64zm-8 824H288V136h448v752z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M288 888h448V136H288v752zm224-142c22.1 0 40 17.9 40 40s-17.9 40-40 40-40-17.9-40-40 17.9-40 40-40z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M472 786a40 40 0 1080 0 40 40 0 10-80 0z", "fill": primaryColor } }] }; }, "name": "mobile", "theme": "twotone" };
	exports.default = MobileTwoTone;
	});

	var MobileTwoToneSvg = unwrapExports(MobileTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var MobileTwoTone = function MobileTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: MobileTwoToneSvg
	  }));
	};

	MobileTwoTone.displayName = 'MobileTwoTone';
	var MobileTwoTone$1 = /*#__PURE__*/React.forwardRef(MobileTwoTone);

	var MoneyCollectFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var MoneyCollectFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M911.5 699.7a8 8 0 00-10.3-4.8L840 717.2V179c0-37.6-30.4-68-68-68H252c-37.6 0-68 30.4-68 68v538.2l-61.3-22.3c-.9-.3-1.8-.5-2.7-.5-4.4 0-8 3.6-8 8V762c0 3.3 2.1 6.3 5.3 7.5L501 909.1c7.1 2.6 14.8 2.6 21.9 0l383.8-139.5c3.2-1.2 5.3-4.2 5.3-7.5v-59.6c0-1-.2-1.9-.5-2.8zm-243.8-377L564 514.3h57.6c4.4 0 8 3.6 8 8v27.1c0 4.4-3.6 8-8 8h-76.3v39h76.3c4.4 0 8 3.6 8 8v27.1c0 4.4-3.6 8-8 8h-76.3V703c0 4.4-3.6 8-8 8h-49.9c-4.4 0-8-3.6-8-8v-63.4h-76c-4.4 0-8-3.6-8-8v-27.1c0-4.4 3.6-8 8-8h76v-39h-76c-4.4 0-8-3.6-8-8v-27.1c0-4.4 3.6-8 8-8h57L356.5 322.8c-2.1-3.8-.7-8.7 3.2-10.8 1.2-.7 2.5-1 3.8-1h55.7a8 8 0 017.1 4.4L511 484.2h3.3L599 315.4c1.3-2.7 4.1-4.4 7.1-4.4h54.5c4.4 0 8 3.6 8.1 7.9 0 1.3-.4 2.6-1 3.8z" } }] }, "name": "money-collect", "theme": "filled" };
	exports.default = MoneyCollectFilled;
	});

	var MoneyCollectFilledSvg = unwrapExports(MoneyCollectFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var MoneyCollectFilled = function MoneyCollectFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: MoneyCollectFilledSvg
	  }));
	};

	MoneyCollectFilled.displayName = 'MoneyCollectFilled';
	var MoneyCollectFilled$1 = /*#__PURE__*/React.forwardRef(MoneyCollectFilled);

	var MoneyCollectOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var MoneyCollectOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M911.5 700.7a8 8 0 00-10.3-4.8L840 718.2V180c0-37.6-30.4-68-68-68H252c-37.6 0-68 30.4-68 68v538.2l-61.3-22.3c-.9-.3-1.8-.5-2.7-.5-4.4 0-8 3.6-8 8V763c0 3.3 2.1 6.3 5.3 7.5L501 910.1c7.1 2.6 14.8 2.6 21.9 0l383.8-139.5c3.2-1.2 5.3-4.2 5.3-7.5v-59.6c0-1-.2-1.9-.5-2.8zM512 837.5l-256-93.1V184h512v560.4l-256 93.1zM660.6 312h-54.5c-3 0-5.8 1.7-7.1 4.4l-84.7 168.8H511l-84.7-168.8a8 8 0 00-7.1-4.4h-55.7c-1.3 0-2.6.3-3.8 1-3.9 2.1-5.3 7-3.2 10.8l103.9 191.6h-57c-4.4 0-8 3.6-8 8v27.1c0 4.4 3.6 8 8 8h76v39h-76c-4.4 0-8 3.6-8 8v27.1c0 4.4 3.6 8 8 8h76V704c0 4.4 3.6 8 8 8h49.9c4.4 0 8-3.6 8-8v-63.5h76.3c4.4 0 8-3.6 8-8v-27.1c0-4.4-3.6-8-8-8h-76.3v-39h76.3c4.4 0 8-3.6 8-8v-27.1c0-4.4-3.6-8-8-8H564l103.7-191.6c.6-1.2 1-2.5 1-3.8-.1-4.3-3.7-7.9-8.1-7.9z" } }] }, "name": "money-collect", "theme": "outlined" };
	exports.default = MoneyCollectOutlined;
	});

	var MoneyCollectOutlinedSvg = unwrapExports(MoneyCollectOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var MoneyCollectOutlined = function MoneyCollectOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: MoneyCollectOutlinedSvg
	  }));
	};

	MoneyCollectOutlined.displayName = 'MoneyCollectOutlined';
	var MoneyCollectOutlined$1 = /*#__PURE__*/React.forwardRef(MoneyCollectOutlined);

	var MoneyCollectTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var MoneyCollectTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M256 744.4l256 93.1 256-93.1V184H256v560.4zM359.7 313c1.2-.7 2.5-1 3.8-1h55.7a8 8 0 017.1 4.4L511 485.2h3.3L599 316.4c1.3-2.7 4.1-4.4 7.1-4.4h54.5c4.4 0 8 3.6 8.1 7.9 0 1.3-.4 2.6-1 3.8L564 515.3h57.6c4.4 0 8 3.6 8 8v27.1c0 4.4-3.6 8-8 8h-76.3v39h76.3c4.4 0 8 3.6 8 8v27.1c0 4.4-3.6 8-8 8h-76.3V704c0 4.4-3.6 8-8 8h-49.9c-4.4 0-8-3.6-8-8v-63.4h-76c-4.4 0-8-3.6-8-8v-27.1c0-4.4 3.6-8 8-8h76v-39h-76c-4.4 0-8-3.6-8-8v-27.1c0-4.4 3.6-8 8-8h57L356.5 323.8c-2.1-3.8-.7-8.7 3.2-10.8z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M911.5 700.7a8 8 0 00-10.3-4.8L840 718.2V180c0-37.6-30.4-68-68-68H252c-37.6 0-68 30.4-68 68v538.2l-61.3-22.3c-.9-.3-1.8-.5-2.7-.5-4.4 0-8 3.6-8 8V763c0 3.3 2.1 6.3 5.3 7.5L501 910.1c7.1 2.6 14.8 2.6 21.9 0l383.8-139.5c3.2-1.2 5.3-4.2 5.3-7.5v-59.6c0-1-.2-1.9-.5-2.8zM768 744.4l-256 93.1-256-93.1V184h512v560.4z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M460.4 515.4h-57c-4.4 0-8 3.6-8 8v27.1c0 4.4 3.6 8 8 8h76v39h-76c-4.4 0-8 3.6-8 8v27.1c0 4.4 3.6 8 8 8h76V704c0 4.4 3.6 8 8 8h49.9c4.4 0 8-3.6 8-8v-63.5h76.3c4.4 0 8-3.6 8-8v-27.1c0-4.4-3.6-8-8-8h-76.3v-39h76.3c4.4 0 8-3.6 8-8v-27.1c0-4.4-3.6-8-8-8H564l103.7-191.6c.6-1.2 1-2.5 1-3.8-.1-4.3-3.7-7.9-8.1-7.9h-54.5c-3 0-5.8 1.7-7.1 4.4l-84.7 168.8H511l-84.7-168.8a8 8 0 00-7.1-4.4h-55.7c-1.3 0-2.6.3-3.8 1-3.9 2.1-5.3 7-3.2 10.8l103.9 191.6z", "fill": primaryColor } }] }; }, "name": "money-collect", "theme": "twotone" };
	exports.default = MoneyCollectTwoTone;
	});

	var MoneyCollectTwoToneSvg = unwrapExports(MoneyCollectTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var MoneyCollectTwoTone = function MoneyCollectTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: MoneyCollectTwoToneSvg
	  }));
	};

	MoneyCollectTwoTone.displayName = 'MoneyCollectTwoTone';
	var MoneyCollectTwoTone$1 = /*#__PURE__*/React.forwardRef(MoneyCollectTwoTone);

	var MonitorOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var MonitorOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M692.8 412.7l.2-.2-34.6-44.3a7.97 7.97 0 00-11.2-1.4l-50.4 39.3-70.5-90.1a7.97 7.97 0 00-11.2-1.4l-37.9 29.7a7.97 7.97 0 00-1.4 11.2l70.5 90.2-.2.1 34.6 44.3c2.7 3.5 7.7 4.1 11.2 1.4l50.4-39.3 64.1 82c2.7 3.5 7.7 4.1 11.2 1.4l37.9-29.6c3.5-2.7 4.1-7.7 1.4-11.2l-64.1-82.1zM608 112c-167.9 0-304 136.1-304 304 0 70.3 23.9 135 63.9 186.5L114.3 856.1a8.03 8.03 0 000 11.3l42.3 42.3c3.1 3.1 8.2 3.1 11.3 0l253.6-253.6C473 696.1 537.7 720 608 720c167.9 0 304-136.1 304-304S775.9 112 608 112zm161.2 465.2C726.2 620.3 668.9 644 608 644s-118.2-23.7-161.2-66.8C403.7 534.2 380 476.9 380 416s23.7-118.2 66.8-161.2c43-43.1 100.3-66.8 161.2-66.8s118.2 23.7 161.2 66.8c43.1 43 66.8 100.3 66.8 161.2s-23.7 118.2-66.8 161.2z" } }] }, "name": "monitor", "theme": "outlined" };
	exports.default = MonitorOutlined;
	});

	var MonitorOutlinedSvg = unwrapExports(MonitorOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var MonitorOutlined = function MonitorOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: MonitorOutlinedSvg
	  }));
	};

	MonitorOutlined.displayName = 'MonitorOutlined';
	var MonitorOutlined$1 = /*#__PURE__*/React.forwardRef(MonitorOutlined);

	var MoreOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var MoreOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M456 231a56 56 0 10112 0 56 56 0 10-112 0zm0 280a56 56 0 10112 0 56 56 0 10-112 0zm0 280a56 56 0 10112 0 56 56 0 10-112 0z" } }] }, "name": "more", "theme": "outlined" };
	exports.default = MoreOutlined;
	});

	var MoreOutlinedSvg = unwrapExports(MoreOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var MoreOutlined = function MoreOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: MoreOutlinedSvg
	  }));
	};

	MoreOutlined.displayName = 'MoreOutlined';
	var MoreOutlined$1 = /*#__PURE__*/React.forwardRef(MoreOutlined);

	var NodeCollapseOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var NodeCollapseOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M952 612c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H298a95.92 95.92 0 00-89-60c-53 0-96 43-96 96s43 96 96 96c40.3 0 74.8-24.8 89-60h150.3v152c0 55.2 44.8 100 100 100H952c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H548.3c-15.5 0-28-12.5-28-28V612H952zM451.7 313.7l172.5 136.2c6.3 5.1 15.8.5 15.8-7.7V344h264c4.4 0 8-3.6 8-8v-60c0-4.4-3.6-8-8-8H640v-98.2c0-8.1-9.4-12.8-15.8-7.7L451.7 298.3a9.9 9.9 0 000 15.4z" } }] }, "name": "node-collapse", "theme": "outlined" };
	exports.default = NodeCollapseOutlined;
	});

	var NodeCollapseOutlinedSvg = unwrapExports(NodeCollapseOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var NodeCollapseOutlined = function NodeCollapseOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: NodeCollapseOutlinedSvg
	  }));
	};

	NodeCollapseOutlined.displayName = 'NodeCollapseOutlined';
	var NodeCollapseOutlined$1 = /*#__PURE__*/React.forwardRef(NodeCollapseOutlined);

	var NodeExpandOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var NodeExpandOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M952 612c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H298a95.92 95.92 0 00-89-60c-53 0-96 43-96 96s43 96 96 96c40.3 0 74.8-24.8 89-60h150.3v152c0 55.2 44.8 100 100 100H952c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H548.3c-15.5 0-28-12.5-28-28V612H952zM456 344h264v98.2c0 8.1 9.5 12.8 15.8 7.7l172.5-136.2c5-3.9 5-11.4 0-15.3L735.8 162.1c-6.4-5.1-15.8-.5-15.8 7.7V268H456c-4.4 0-8 3.6-8 8v60c0 4.4 3.6 8 8 8z" } }] }, "name": "node-expand", "theme": "outlined" };
	exports.default = NodeExpandOutlined;
	});

	var NodeExpandOutlinedSvg = unwrapExports(NodeExpandOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var NodeExpandOutlined = function NodeExpandOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: NodeExpandOutlinedSvg
	  }));
	};

	NodeExpandOutlined.displayName = 'NodeExpandOutlined';
	var NodeExpandOutlined$1 = /*#__PURE__*/React.forwardRef(NodeExpandOutlined);

	var NodeIndexOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var NodeIndexOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M843.5 737.4c-12.4-75.2-79.2-129.1-155.3-125.4S550.9 676 546 752c-153.5-4.8-208-40.7-199.1-113.7 3.3-27.3 19.8-41.9 50.1-49 18.4-4.3 38.8-4.9 57.3-3.2 1.7.2 3.5.3 5.2.5 11.3 2.7 22.8 5 34.3 6.8 34.1 5.6 68.8 8.4 101.8 6.6 92.8-5 156-45.9 159.2-132.7 3.1-84.1-54.7-143.7-147.9-183.6-29.9-12.8-61.6-22.7-93.3-30.2-14.3-3.4-26.3-5.7-35.2-7.2-7.9-75.9-71.5-133.8-147.8-134.4-76.3-.6-140.9 56.1-150.1 131.9s40 146.3 114.2 163.9c74.2 17.6 149.9-23.3 175.7-95.1 9.4 1.7 18.7 3.6 28 5.8 28.2 6.6 56.4 15.4 82.4 26.6 70.7 30.2 109.3 70.1 107.5 119.9-1.6 44.6-33.6 65.2-96.2 68.6-27.5 1.5-57.6-.9-87.3-5.8-8.3-1.4-15.9-2.8-22.6-4.3-3.9-.8-6.6-1.5-7.8-1.8l-3.1-.6c-2.2-.3-5.9-.8-10.7-1.3-25-2.3-52.1-1.5-78.5 4.6-55.2 12.9-93.9 47.2-101.1 105.8-15.7 126.2 78.6 184.7 276 188.9 29.1 70.4 106.4 107.9 179.6 87 73.3-20.9 119.3-93.4 106.9-168.6zM329.1 345.2a83.3 83.3 0 11.01-166.61 83.3 83.3 0 01-.01 166.61zM695.6 845a83.3 83.3 0 11.01-166.61A83.3 83.3 0 01695.6 845z" } }] }, "name": "node-index", "theme": "outlined" };
	exports.default = NodeIndexOutlined;
	});

	var NodeIndexOutlinedSvg = unwrapExports(NodeIndexOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var NodeIndexOutlined = function NodeIndexOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: NodeIndexOutlinedSvg
	  }));
	};

	NodeIndexOutlined.displayName = 'NodeIndexOutlined';
	var NodeIndexOutlined$1 = /*#__PURE__*/React.forwardRef(NodeIndexOutlined);

	var NotificationFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var NotificationFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112c-3.8 0-7.7.7-11.6 2.3L292 345.9H128c-8.8 0-16 7.4-16 16.6v299c0 9.2 7.2 16.6 16 16.6h101.6c-3.7 11.6-5.6 23.9-5.6 36.4 0 65.9 53.8 119.5 120 119.5 55.4 0 102.1-37.6 115.9-88.4l408.6 164.2c3.9 1.5 7.8 2.3 11.6 2.3 16.9 0 32-14.2 32-33.2V145.2C912 126.2 897 112 880 112zM344 762.3c-26.5 0-48-21.4-48-47.8 0-11.2 3.9-21.9 11-30.4l84.9 34.1c-2 24.6-22.7 44.1-47.9 44.1z" } }] }, "name": "notification", "theme": "filled" };
	exports.default = NotificationFilled;
	});

	var NotificationFilledSvg = unwrapExports(NotificationFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var NotificationFilled = function NotificationFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: NotificationFilledSvg
	  }));
	};

	NotificationFilled.displayName = 'NotificationFilled';
	var NotificationFilled$1 = /*#__PURE__*/React.forwardRef(NotificationFilled);

	var NotificationOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var NotificationOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112c-3.8 0-7.7.7-11.6 2.3L292 345.9H128c-8.8 0-16 7.4-16 16.6v299c0 9.2 7.2 16.6 16 16.6h101.7c-3.7 11.6-5.7 23.9-5.7 36.4 0 65.9 53.8 119.5 120 119.5 55.4 0 102.1-37.6 115.9-88.4l408.6 164.2c3.9 1.5 7.8 2.3 11.6 2.3 16.9 0 32-14.2 32-33.2V145.2C912 126.2 897 112 880 112zM344 762.3c-26.5 0-48-21.4-48-47.8 0-11.2 3.9-21.9 11-30.4l84.9 34.1c-2 24.6-22.7 44.1-47.9 44.1zm496 58.4L318.8 611.3l-12.9-5.2H184V417.9h121.9l12.9-5.2L840 203.3v617.4z" } }] }, "name": "notification", "theme": "outlined" };
	exports.default = NotificationOutlined;
	});

	var NotificationOutlinedSvg = unwrapExports(NotificationOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var NotificationOutlined = function NotificationOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: NotificationOutlinedSvg
	  }));
	};

	NotificationOutlined.displayName = 'NotificationOutlined';
	var NotificationOutlined$1 = /*#__PURE__*/React.forwardRef(NotificationOutlined);

	var NotificationTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var NotificationTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M229.6 678.1c-3.7 11.6-5.6 23.9-5.6 36.4 0-12.5 2-24.8 5.7-36.4h-.1zm76.3-260.2H184v188.2h121.9l12.9 5.2L840 820.7V203.3L318.8 412.7z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M880 112c-3.8 0-7.7.7-11.6 2.3L292 345.9H128c-8.8 0-16 7.4-16 16.6v299c0 9.2 7.2 16.6 16 16.6h101.7c-3.7 11.6-5.7 23.9-5.7 36.4 0 65.9 53.8 119.5 120 119.5 55.4 0 102.1-37.6 115.9-88.4l408.6 164.2c3.9 1.5 7.8 2.3 11.6 2.3 16.9 0 32-14.2 32-33.2V145.2C912 126.2 897 112 880 112zM344 762.3c-26.5 0-48-21.4-48-47.8 0-11.2 3.9-21.9 11-30.4l84.9 34.1c-2 24.6-22.7 44.1-47.9 44.1zm496 58.4L318.8 611.3l-12.9-5.2H184V417.9h121.9l12.9-5.2L840 203.3v617.4z", "fill": primaryColor } }] }; }, "name": "notification", "theme": "twotone" };
	exports.default = NotificationTwoTone;
	});

	var NotificationTwoToneSvg = unwrapExports(NotificationTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var NotificationTwoTone = function NotificationTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: NotificationTwoToneSvg
	  }));
	};

	NotificationTwoTone.displayName = 'NotificationTwoTone';
	var NotificationTwoTone$1 = /*#__PURE__*/React.forwardRef(NotificationTwoTone);

	var NumberOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var NumberOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M872 394c4.4 0 8-3.6 8-8v-60c0-4.4-3.6-8-8-8H708V152c0-4.4-3.6-8-8-8h-64c-4.4 0-8 3.6-8 8v166H400V152c0-4.4-3.6-8-8-8h-64c-4.4 0-8 3.6-8 8v166H152c-4.4 0-8 3.6-8 8v60c0 4.4 3.6 8 8 8h168v236H152c-4.4 0-8 3.6-8 8v60c0 4.4 3.6 8 8 8h168v166c0 4.4 3.6 8 8 8h64c4.4 0 8-3.6 8-8V706h228v166c0 4.4 3.6 8 8 8h64c4.4 0 8-3.6 8-8V706h164c4.4 0 8-3.6 8-8v-60c0-4.4-3.6-8-8-8H708V394h164zM628 630H400V394h228v236z" } }] }, "name": "number", "theme": "outlined" };
	exports.default = NumberOutlined;
	});

	var NumberOutlinedSvg = unwrapExports(NumberOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var NumberOutlined = function NumberOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: NumberOutlinedSvg
	  }));
	};

	NumberOutlined.displayName = 'NumberOutlined';
	var NumberOutlined$1 = /*#__PURE__*/React.forwardRef(NumberOutlined);

	var OneToOneOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var OneToOneOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M316 672h60c4.4 0 8-3.6 8-8V360c0-4.4-3.6-8-8-8h-60c-4.4 0-8 3.6-8 8v304c0 4.4 3.6 8 8 8zm196-50c22.1 0 40-17.9 40-39 0-23.1-17.9-41-40-41s-40 17.9-40 41c0 21.1 17.9 39 40 39zm0-140c22.1 0 40-17.9 40-39 0-23.1-17.9-41-40-41s-40 17.9-40 41c0 21.1 17.9 39 40 39z" } }, { "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z" } }, { "tag": "path", "attrs": { "d": "M648 672h60c4.4 0 8-3.6 8-8V360c0-4.4-3.6-8-8-8h-60c-4.4 0-8 3.6-8 8v304c0 4.4 3.6 8 8 8z" } }] }, "name": "one-to-one", "theme": "outlined" };
	exports.default = OneToOneOutlined;
	});

	var OneToOneOutlinedSvg = unwrapExports(OneToOneOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var OneToOneOutlined = function OneToOneOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: OneToOneOutlinedSvg
	  }));
	};

	OneToOneOutlined.displayName = 'OneToOneOutlined';
	var OneToOneOutlined$1 = /*#__PURE__*/React.forwardRef(OneToOneOutlined);

	var OrderedListOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var OrderedListOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M920 760H336c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h584c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-568H336c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h584c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 284H336c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h584c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM216 712H100c-2.2 0-4 1.8-4 4v34c0 2.2 1.8 4 4 4h72.4v20.5h-35.7c-2.2 0-4 1.8-4 4v34c0 2.2 1.8 4 4 4h35.7V838H100c-2.2 0-4 1.8-4 4v34c0 2.2 1.8 4 4 4h116c2.2 0 4-1.8 4-4V716c0-2.2-1.8-4-4-4zM100 188h38v120c0 2.2 1.8 4 4 4h40c2.2 0 4-1.8 4-4V152c0-4.4-3.6-8-8-8h-78c-2.2 0-4 1.8-4 4v36c0 2.2 1.8 4 4 4zm116 240H100c-2.2 0-4 1.8-4 4v36c0 2.2 1.8 4 4 4h68.4l-70.3 77.7a8.3 8.3 0 00-2.1 5.4V592c0 2.2 1.8 4 4 4h116c2.2 0 4-1.8 4-4v-36c0-2.2-1.8-4-4-4h-68.4l70.3-77.7a8.3 8.3 0 002.1-5.4V432c0-2.2-1.8-4-4-4z" } }] }, "name": "ordered-list", "theme": "outlined" };
	exports.default = OrderedListOutlined;
	});

	var OrderedListOutlinedSvg = unwrapExports(OrderedListOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var OrderedListOutlined = function OrderedListOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: OrderedListOutlinedSvg
	  }));
	};

	OrderedListOutlined.displayName = 'OrderedListOutlined';
	var OrderedListOutlined$1 = /*#__PURE__*/React.forwardRef(OrderedListOutlined);

	var PaperClipOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PaperClipOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M779.3 196.6c-94.2-94.2-247.6-94.2-341.7 0l-261 260.8c-1.7 1.7-2.6 4-2.6 6.4s.9 4.7 2.6 6.4l36.9 36.9a9 9 0 0012.7 0l261-260.8c32.4-32.4 75.5-50.2 121.3-50.2s88.9 17.8 121.2 50.2c32.4 32.4 50.2 75.5 50.2 121.2 0 45.8-17.8 88.8-50.2 121.2l-266 265.9-43.1 43.1c-40.3 40.3-105.8 40.3-146.1 0-19.5-19.5-30.2-45.4-30.2-73s10.7-53.5 30.2-73l263.9-263.8c6.7-6.6 15.5-10.3 24.9-10.3h.1c9.4 0 18.1 3.7 24.7 10.3 6.7 6.7 10.3 15.5 10.3 24.9 0 9.3-3.7 18.1-10.3 24.7L372.4 653c-1.7 1.7-2.6 4-2.6 6.4s.9 4.7 2.6 6.4l36.9 36.9a9 9 0 0012.7 0l215.6-215.6c19.9-19.9 30.8-46.3 30.8-74.4s-11-54.6-30.8-74.4c-41.1-41.1-107.9-41-149 0L463 364 224.8 602.1A172.22 172.22 0 00174 724.8c0 46.3 18.1 89.8 50.8 122.5 33.9 33.8 78.3 50.7 122.7 50.7 44.4 0 88.8-16.9 122.6-50.7l309.2-309C824.8 492.7 850 432 850 367.5c.1-64.6-25.1-125.3-70.7-170.9z" } }] }, "name": "paper-clip", "theme": "outlined" };
	exports.default = PaperClipOutlined;
	});

	var PaperClipOutlinedSvg = unwrapExports(PaperClipOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var PaperClipOutlined = function PaperClipOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PaperClipOutlinedSvg
	  }));
	};

	PaperClipOutlined.displayName = 'PaperClipOutlined';
	var PaperClipOutlined$1 = /*#__PURE__*/React.forwardRef(PaperClipOutlined);

	var PartitionOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PartitionOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M640.6 429.8h257.1c7.9 0 14.3-6.4 14.3-14.3V158.3c0-7.9-6.4-14.3-14.3-14.3H640.6c-7.9 0-14.3 6.4-14.3 14.3v92.9H490.6c-3.9 0-7.1 3.2-7.1 7.1v221.5h-85.7v-96.5c0-7.9-6.4-14.3-14.3-14.3H126.3c-7.9 0-14.3 6.4-14.3 14.3v257.2c0 7.9 6.4 14.3 14.3 14.3h257.1c7.9 0 14.3-6.4 14.3-14.3V544h85.7v221.5c0 3.9 3.2 7.1 7.1 7.1h135.7v92.9c0 7.9 6.4 14.3 14.3 14.3h257.1c7.9 0 14.3-6.4 14.3-14.3v-257c0-7.9-6.4-14.3-14.3-14.3h-257c-7.9 0-14.3 6.4-14.3 14.3v100h-78.6v-393h78.6v100c0 7.9 6.4 14.3 14.3 14.3zm53.5-217.9h150V362h-150V211.9zM329.9 587h-150V437h150v150zm364.2 75.1h150v150.1h-150V662.1z" } }] }, "name": "partition", "theme": "outlined" };
	exports.default = PartitionOutlined;
	});

	var PartitionOutlinedSvg = unwrapExports(PartitionOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var PartitionOutlined = function PartitionOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PartitionOutlinedSvg
	  }));
	};

	PartitionOutlined.displayName = 'PartitionOutlined';
	var PartitionOutlined$1 = /*#__PURE__*/React.forwardRef(PartitionOutlined);

	var PauseCircleFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PauseCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm-80 600c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V360c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v304zm224 0c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V360c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v304z" } }] }, "name": "pause-circle", "theme": "filled" };
	exports.default = PauseCircleFilled;
	});

	var PauseCircleFilledSvg = unwrapExports(PauseCircleFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var PauseCircleFilled = function PauseCircleFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PauseCircleFilledSvg
	  }));
	};

	PauseCircleFilled.displayName = 'PauseCircleFilled';
	var PauseCircleFilled$1 = /*#__PURE__*/React.forwardRef(PauseCircleFilled);

	var PauseCircleOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PauseCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372zm-88-532h-48c-4.4 0-8 3.6-8 8v304c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V360c0-4.4-3.6-8-8-8zm224 0h-48c-4.4 0-8 3.6-8 8v304c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V360c0-4.4-3.6-8-8-8z" } }] }, "name": "pause-circle", "theme": "outlined" };
	exports.default = PauseCircleOutlined;
	});

	var PauseCircleOutlinedSvg = unwrapExports(PauseCircleOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var PauseCircleOutlined = function PauseCircleOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PauseCircleOutlinedSvg
	  }));
	};

	PauseCircleOutlined.displayName = 'PauseCircleOutlined';
	var PauseCircleOutlined$1 = /*#__PURE__*/React.forwardRef(PauseCircleOutlined);

	var PauseCircleTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PauseCircleTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm-80 524c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V360c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v304zm224 0c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V360c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v304z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M424 352h-48c-4.4 0-8 3.6-8 8v304c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V360c0-4.4-3.6-8-8-8zm224 0h-48c-4.4 0-8 3.6-8 8v304c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V360c0-4.4-3.6-8-8-8z", "fill": primaryColor } }] }; }, "name": "pause-circle", "theme": "twotone" };
	exports.default = PauseCircleTwoTone;
	});

	var PauseCircleTwoToneSvg = unwrapExports(PauseCircleTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var PauseCircleTwoTone = function PauseCircleTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PauseCircleTwoToneSvg
	  }));
	};

	PauseCircleTwoTone.displayName = 'PauseCircleTwoTone';
	var PauseCircleTwoTone$1 = /*#__PURE__*/React.forwardRef(PauseCircleTwoTone);

	var PauseOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PauseOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M304 176h80v672h-80zm408 0h-64c-4.4 0-8 3.6-8 8v656c0 4.4 3.6 8 8 8h64c4.4 0 8-3.6 8-8V184c0-4.4-3.6-8-8-8z" } }] }, "name": "pause", "theme": "outlined" };
	exports.default = PauseOutlined;
	});

	var PauseOutlinedSvg = unwrapExports(PauseOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var PauseOutlined = function PauseOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PauseOutlinedSvg
	  }));
	};

	PauseOutlined.displayName = 'PauseOutlined';
	var PauseOutlined$1 = /*#__PURE__*/React.forwardRef(PauseOutlined);

	var PayCircleFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PayCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm166.6 246.8L567.5 515.6h62c4.4 0 8 3.6 8 8v29.9c0 4.4-3.6 8-8 8h-82V603h82c4.4 0 8 3.6 8 8v29.9c0 4.4-3.6 8-8 8h-82V717c0 4.4-3.6 8-8 8h-54.3c-4.4 0-8-3.6-8-8v-68.1h-81.7c-4.4 0-8-3.6-8-8V611c0-4.4 3.6-8 8-8h81.7v-41.5h-81.7c-4.4 0-8-3.6-8-8v-29.9c0-4.4 3.6-8 8-8h61.4L345.4 310.8a8.07 8.07 0 017-11.9h60.7c3 0 5.8 1.7 7.1 4.4l90.6 180h3.4l90.6-180a8 8 0 017.1-4.4h59.5c4.4 0 8 3.6 8 8 .2 1.4-.2 2.7-.8 3.9z" } }] }, "name": "pay-circle", "theme": "filled" };
	exports.default = PayCircleFilled;
	});

	var PayCircleFilledSvg = unwrapExports(PayCircleFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var PayCircleFilled = function PayCircleFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PayCircleFilledSvg
	  }));
	};

	PayCircleFilled.displayName = 'PayCircleFilled';
	var PayCircleFilled$1 = /*#__PURE__*/React.forwardRef(PayCircleFilled);

	var PayCircleOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PayCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372zm159.6-585h-59.5c-3 0-5.8 1.7-7.1 4.4l-90.6 180H511l-90.6-180a8 8 0 00-7.1-4.4h-60.7c-1.3 0-2.6.3-3.8 1-3.9 2.1-5.3 7-3.2 10.9L457 515.7h-61.4c-4.4 0-8 3.6-8 8v29.9c0 4.4 3.6 8 8 8h81.7V603h-81.7c-4.4 0-8 3.6-8 8v29.9c0 4.4 3.6 8 8 8h81.7V717c0 4.4 3.6 8 8 8h54.3c4.4 0 8-3.6 8-8v-68.1h82c4.4 0 8-3.6 8-8V611c0-4.4-3.6-8-8-8h-82v-41.5h82c4.4 0 8-3.6 8-8v-29.9c0-4.4-3.6-8-8-8h-62l111.1-204.8c.6-1.2 1-2.5 1-3.8-.1-4.4-3.7-8-8.1-8z" } }] }, "name": "pay-circle", "theme": "outlined" };
	exports.default = PayCircleOutlined;
	});

	var PayCircleOutlinedSvg = unwrapExports(PayCircleOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var PayCircleOutlined = function PayCircleOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PayCircleOutlinedSvg
	  }));
	};

	PayCircleOutlined.displayName = 'PayCircleOutlined';
	var PayCircleOutlined$1 = /*#__PURE__*/React.forwardRef(PayCircleOutlined);

	var PercentageOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PercentageOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M855.7 210.8l-42.4-42.4a8.03 8.03 0 00-11.3 0L168.3 801.9a8.03 8.03 0 000 11.3l42.4 42.4c3.1 3.1 8.2 3.1 11.3 0L855.6 222c3.2-3 3.2-8.1.1-11.2zM304 448c79.4 0 144-64.6 144-144s-64.6-144-144-144-144 64.6-144 144 64.6 144 144 144zm0-216c39.7 0 72 32.3 72 72s-32.3 72-72 72-72-32.3-72-72 32.3-72 72-72zm416 344c-79.4 0-144 64.6-144 144s64.6 144 144 144 144-64.6 144-144-64.6-144-144-144zm0 216c-39.7 0-72-32.3-72-72s32.3-72 72-72 72 32.3 72 72-32.3 72-72 72z" } }] }, "name": "percentage", "theme": "outlined" };
	exports.default = PercentageOutlined;
	});

	var PercentageOutlinedSvg = unwrapExports(PercentageOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var PercentageOutlined = function PercentageOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PercentageOutlinedSvg
	  }));
	};

	PercentageOutlined.displayName = 'PercentageOutlined';
	var PercentageOutlined$1 = /*#__PURE__*/React.forwardRef(PercentageOutlined);

	var PhoneFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PhoneFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M885.6 230.2L779.1 123.8a80.83 80.83 0 00-57.3-23.8c-21.7 0-42.1 8.5-57.4 23.8L549.8 238.4a80.83 80.83 0 00-23.8 57.3c0 21.7 8.5 42.1 23.8 57.4l83.8 83.8A393.82 393.82 0 01553.1 553 395.34 395.34 0 01437 633.8L353.2 550a80.83 80.83 0 00-57.3-23.8c-21.7 0-42.1 8.5-57.4 23.8L123.8 664.5a80.89 80.89 0 00-23.8 57.4c0 21.7 8.5 42.1 23.8 57.4l106.3 106.3c24.4 24.5 58.1 38.4 92.7 38.4 7.3 0 14.3-.6 21.2-1.8 134.8-22.2 268.5-93.9 376.4-201.7C828.2 612.8 899.8 479.2 922.3 344c6.8-41.3-6.9-83.8-36.7-113.8z" } }] }, "name": "phone", "theme": "filled" };
	exports.default = PhoneFilled;
	});

	var PhoneFilledSvg = unwrapExports(PhoneFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var PhoneFilled = function PhoneFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PhoneFilledSvg
	  }));
	};

	PhoneFilled.displayName = 'PhoneFilled';
	var PhoneFilled$1 = /*#__PURE__*/React.forwardRef(PhoneFilled);

	var PhoneOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PhoneOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M877.1 238.7L770.6 132.3c-13-13-30.4-20.3-48.8-20.3s-35.8 7.2-48.8 20.3L558.3 246.8c-13 13-20.3 30.5-20.3 48.9 0 18.5 7.2 35.8 20.3 48.9l89.6 89.7a405.46 405.46 0 01-86.4 127.3c-36.7 36.9-79.6 66-127.2 86.6l-89.6-89.7c-13-13-30.4-20.3-48.8-20.3a68.2 68.2 0 00-48.8 20.3L132.3 673c-13 13-20.3 30.5-20.3 48.9 0 18.5 7.2 35.8 20.3 48.9l106.4 106.4c22.2 22.2 52.8 34.9 84.2 34.9 6.5 0 12.8-.5 19.2-1.6 132.4-21.8 263.8-92.3 369.9-198.3C818 606 888.4 474.6 910.4 342.1c6.3-37.6-6.3-76.3-33.3-103.4zm-37.6 91.5c-19.5 117.9-82.9 235.5-178.4 331s-213 158.9-330.9 178.4c-14.8 2.5-30-2.5-40.8-13.2L184.9 721.9 295.7 611l119.8 120 .9.9 21.6-8a481.29 481.29 0 00285.7-285.8l8-21.6-120.8-120.7 110.8-110.9 104.5 104.5c10.8 10.8 15.8 26 13.3 40.8z" } }] }, "name": "phone", "theme": "outlined" };
	exports.default = PhoneOutlined;
	});

	var PhoneOutlinedSvg = unwrapExports(PhoneOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var PhoneOutlined = function PhoneOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PhoneOutlinedSvg
	  }));
	};

	PhoneOutlined.displayName = 'PhoneOutlined';
	var PhoneOutlined$1 = /*#__PURE__*/React.forwardRef(PhoneOutlined);

	var PhoneTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PhoneTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M721.7 184.9L610.9 295.8l120.8 120.7-8 21.6A481.29 481.29 0 01438 723.9l-21.6 8-.9-.9-119.8-120-110.8 110.9 104.5 104.5c10.8 10.7 26 15.7 40.8 13.2 117.9-19.5 235.4-82.9 330.9-178.4s158.9-213.1 178.4-331c2.5-14.8-2.5-30-13.3-40.8L721.7 184.9z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M877.1 238.7L770.6 132.3c-13-13-30.4-20.3-48.8-20.3s-35.8 7.2-48.8 20.3L558.3 246.8c-13 13-20.3 30.5-20.3 48.9 0 18.5 7.2 35.8 20.3 48.9l89.6 89.7a405.46 405.46 0 01-86.4 127.3c-36.7 36.9-79.6 66-127.2 86.6l-89.6-89.7c-13-13-30.4-20.3-48.8-20.3a68.2 68.2 0 00-48.8 20.3L132.3 673c-13 13-20.3 30.5-20.3 48.9 0 18.5 7.2 35.8 20.3 48.9l106.4 106.4c22.2 22.2 52.8 34.9 84.2 34.9 6.5 0 12.8-.5 19.2-1.6 132.4-21.8 263.8-92.3 369.9-198.3C818 606 888.4 474.6 910.4 342.1c6.3-37.6-6.3-76.3-33.3-103.4zm-37.6 91.5c-19.5 117.9-82.9 235.5-178.4 331s-213 158.9-330.9 178.4c-14.8 2.5-30-2.5-40.8-13.2L184.9 721.9 295.7 611l119.8 120 .9.9 21.6-8a481.29 481.29 0 00285.7-285.8l8-21.6-120.8-120.7 110.8-110.9 104.5 104.5c10.8 10.8 15.8 26 13.3 40.8z", "fill": primaryColor } }] }; }, "name": "phone", "theme": "twotone" };
	exports.default = PhoneTwoTone;
	});

	var PhoneTwoToneSvg = unwrapExports(PhoneTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var PhoneTwoTone = function PhoneTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PhoneTwoToneSvg
	  }));
	};

	PhoneTwoTone.displayName = 'PhoneTwoTone';
	var PhoneTwoTone$1 = /*#__PURE__*/React.forwardRef(PhoneTwoTone);

	var PicCenterOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PicCenterOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M952 792H72c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h880c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-632H72c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h880c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM848 660c8.8 0 16-7.2 16-16V380c0-8.8-7.2-16-16-16H176c-8.8 0-16 7.2-16 16v264c0 8.8 7.2 16 16 16h672zM232 436h560v152H232V436z" } }] }, "name": "pic-center", "theme": "outlined" };
	exports.default = PicCenterOutlined;
	});

	var PicCenterOutlinedSvg = unwrapExports(PicCenterOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var PicCenterOutlined = function PicCenterOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PicCenterOutlinedSvg
	  }));
	};

	PicCenterOutlined.displayName = 'PicCenterOutlined';
	var PicCenterOutlined$1 = /*#__PURE__*/React.forwardRef(PicCenterOutlined);

	var PicLeftOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PicLeftOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M952 792H72c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h880c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-632H72c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h880c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM608 660c8.8 0 16-7.2 16-16V380c0-8.8-7.2-16-16-16H96c-8.8 0-16 7.2-16 16v264c0 8.8 7.2 16 16 16h512zM152 436h400v152H152V436zm552 210c0 4.4 3.6 8 8 8h224c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H712c-4.4 0-8 3.6-8 8v56zm8-204h224c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H712c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8z" } }] }, "name": "pic-left", "theme": "outlined" };
	exports.default = PicLeftOutlined;
	});

	var PicLeftOutlinedSvg = unwrapExports(PicLeftOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var PicLeftOutlined = function PicLeftOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PicLeftOutlinedSvg
	  }));
	};

	PicLeftOutlined.displayName = 'PicLeftOutlined';
	var PicLeftOutlined$1 = /*#__PURE__*/React.forwardRef(PicLeftOutlined);

	var PicRightOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PicRightOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M952 792H72c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h880c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-632H72c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h880c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-24 500c8.8 0 16-7.2 16-16V380c0-8.8-7.2-16-16-16H416c-8.8 0-16 7.2-16 16v264c0 8.8 7.2 16 16 16h512zM472 436h400v152H472V436zM80 646c0 4.4 3.6 8 8 8h224c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H88c-4.4 0-8 3.6-8 8v56zm8-204h224c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H88c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8z" } }] }, "name": "pic-right", "theme": "outlined" };
	exports.default = PicRightOutlined;
	});

	var PicRightOutlinedSvg = unwrapExports(PicRightOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var PicRightOutlined = function PicRightOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PicRightOutlinedSvg
	  }));
	};

	PicRightOutlined.displayName = 'PicRightOutlined';
	var PicRightOutlined$1 = /*#__PURE__*/React.forwardRef(PicRightOutlined);

	var PictureFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PictureFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M928 160H96c-17.7 0-32 14.3-32 32v640c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V192c0-17.7-14.3-32-32-32zM338 304c35.3 0 64 28.7 64 64s-28.7 64-64 64-64-28.7-64-64 28.7-64 64-64zm513.9 437.1a8.11 8.11 0 01-5.2 1.9H177.2c-4.4 0-8-3.6-8-8 0-1.9.7-3.7 1.9-5.2l170.3-202c2.8-3.4 7.9-3.8 11.3-1 .3.3.7.6 1 1l99.4 118 158.1-187.5c2.8-3.4 7.9-3.8 11.3-1 .3.3.7.6 1 1l229.6 271.6c2.6 3.3 2.2 8.4-1.2 11.2z" } }] }, "name": "picture", "theme": "filled" };
	exports.default = PictureFilled;
	});

	var PictureFilledSvg = unwrapExports(PictureFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var PictureFilled = function PictureFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PictureFilledSvg
	  }));
	};

	PictureFilled.displayName = 'PictureFilled';
	var PictureFilled$1 = /*#__PURE__*/React.forwardRef(PictureFilled);

	var PictureOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PictureOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M928 160H96c-17.7 0-32 14.3-32 32v640c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V192c0-17.7-14.3-32-32-32zm-40 632H136v-39.9l138.5-164.3 150.1 178L658.1 489 888 761.6V792zm0-129.8L664.2 396.8c-3.2-3.8-9-3.8-12.2 0L424.6 666.4l-144-170.7c-3.2-3.8-9-3.8-12.2 0L136 652.7V232h752v430.2zM304 456a88 88 0 100-176 88 88 0 000 176zm0-116c15.5 0 28 12.5 28 28s-12.5 28-28 28-28-12.5-28-28 12.5-28 28-28z" } }] }, "name": "picture", "theme": "outlined" };
	exports.default = PictureOutlined;
	});

	var PictureOutlinedSvg = unwrapExports(PictureOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var PictureOutlined = function PictureOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PictureOutlinedSvg
	  }));
	};

	PictureOutlined.displayName = 'PictureOutlined';
	var PictureOutlined$1 = /*#__PURE__*/React.forwardRef(PictureOutlined);

	var PictureTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PictureTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M928 160H96c-17.7 0-32 14.3-32 32v640c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V192c0-17.7-14.3-32-32-32zm-40 632H136v-39.9l138.5-164.3 150.1 178L658.1 489 888 761.6V792zm0-129.8L664.2 396.8c-3.2-3.8-9-3.8-12.2 0L424.6 666.4l-144-170.7c-3.2-3.8-9-3.8-12.2 0L136 652.7V232h752v430.2z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M424.6 765.8l-150.1-178L136 752.1V792h752v-30.4L658.1 489z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M136 652.7l132.4-157c3.2-3.8 9-3.8 12.2 0l144 170.7L652 396.8c3.2-3.8 9-3.8 12.2 0L888 662.2V232H136v420.7zM304 280a88 88 0 110 176 88 88 0 010-176z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M276 368a28 28 0 1056 0 28 28 0 10-56 0z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M304 456a88 88 0 100-176 88 88 0 000 176zm0-116c15.5 0 28 12.5 28 28s-12.5 28-28 28-28-12.5-28-28 12.5-28 28-28z", "fill": primaryColor } }] }; }, "name": "picture", "theme": "twotone" };
	exports.default = PictureTwoTone;
	});

	var PictureTwoToneSvg = unwrapExports(PictureTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var PictureTwoTone = function PictureTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PictureTwoToneSvg
	  }));
	};

	PictureTwoTone.displayName = 'PictureTwoTone';
	var PictureTwoTone$1 = /*#__PURE__*/React.forwardRef(PictureTwoTone);

	var PieChartFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PieChartFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M863.1 518.5H505.5V160.9c0-4.4-3.6-8-8-8h-26a398.57 398.57 0 00-282.5 117 397.47 397.47 0 00-85.6 127C82.6 446.2 72 498.5 72 552.5S82.6 658.7 103.4 708c20.1 47.5 48.9 90.3 85.6 127 36.7 36.7 79.4 65.5 127 85.6a396.64 396.64 0 00155.6 31.5 398.57 398.57 0 00282.5-117c36.7-36.7 65.5-79.4 85.6-127a396.64 396.64 0 0031.5-155.6v-26c-.1-4.4-3.7-8-8.1-8zM951 463l-2.6-28.2c-8.5-92-49.3-178.8-115.1-244.3A398.5 398.5 0 00588.4 75.6L560.1 73c-4.7-.4-8.7 3.2-8.7 7.9v383.7c0 4.4 3.6 8 8 8l383.6-1c4.7-.1 8.4-4 8-8.6z" } }] }, "name": "pie-chart", "theme": "filled" };
	exports.default = PieChartFilled;
	});

	var PieChartFilledSvg = unwrapExports(PieChartFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var PieChartFilled = function PieChartFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PieChartFilledSvg
	  }));
	};

	PieChartFilled.displayName = 'PieChartFilled';
	var PieChartFilled$1 = /*#__PURE__*/React.forwardRef(PieChartFilled);

	var PieChartOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PieChartOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M864 518H506V160c0-4.4-3.6-8-8-8h-26a398.46 398.46 0 00-282.8 117.1 398.19 398.19 0 00-85.7 127.1A397.61 397.61 0 0072 552a398.46 398.46 0 00117.1 282.8c36.7 36.7 79.5 65.6 127.1 85.7A397.61 397.61 0 00472 952a398.46 398.46 0 00282.8-117.1c36.7-36.7 65.6-79.5 85.7-127.1A397.61 397.61 0 00872 552v-26c0-4.4-3.6-8-8-8zM705.7 787.8A331.59 331.59 0 01470.4 884c-88.1-.4-170.9-34.9-233.2-97.2C174.5 724.1 140 640.7 140 552c0-88.7 34.5-172.1 97.2-234.8 54.6-54.6 124.9-87.9 200.8-95.5V586h364.3c-7.7 76.3-41.3 147-96.6 201.8zM952 462.4l-2.6-28.2c-8.5-92.1-49.4-179-115.2-244.6A399.4 399.4 0 00589 74.6L560.7 72c-4.7-.4-8.7 3.2-8.7 7.9V464c0 4.4 3.6 8 8 8l384-1c4.7 0 8.4-4 8-8.6zm-332.2-58.2V147.6a332.24 332.24 0 01166.4 89.8c45.7 45.6 77 103.6 90 166.1l-256.4.7z" } }] }, "name": "pie-chart", "theme": "outlined" };
	exports.default = PieChartOutlined;
	});

	var PieChartOutlinedSvg = unwrapExports(PieChartOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var PieChartOutlined = function PieChartOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PieChartOutlinedSvg
	  }));
	};

	PieChartOutlined.displayName = 'PieChartOutlined';
	var PieChartOutlined$1 = /*#__PURE__*/React.forwardRef(PieChartOutlined);

	var PieChartTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PieChartTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M316.2 920.5c-47.6-20.1-90.4-49-127.1-85.7a398.19 398.19 0 01-85.7-127.1A397.12 397.12 0 0172 552.2v.2a398.57 398.57 0 00117 282.5c36.7 36.7 79.4 65.5 127 85.6A396.64 396.64 0 00471.6 952c27 0 53.6-2.7 79.7-7.9-25.9 5.2-52.4 7.8-79.3 7.8-54 .1-106.4-10.5-155.8-31.4zM560 472c-4.4 0-8-3.6-8-8V79.9c0-1.3.3-2.5.9-3.6-.9 1.3-1.5 2.9-1.5 4.6v383.7c0 4.4 3.6 8 8 8l383.6-1c1.6 0 3.1-.5 4.4-1.3-1 .5-2.2.7-3.4.7l-384 1z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M619.8 147.6v256.6l256.4-.7c-13-62.5-44.3-120.5-90-166.1a332.24 332.24 0 00-166.4-89.8z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M438 221.7c-75.9 7.6-146.2 40.9-200.8 95.5C174.5 379.9 140 463.3 140 552s34.5 172.1 97.2 234.8c62.3 62.3 145.1 96.8 233.2 97.2 88.2.4 172.7-34.1 235.3-96.2C761 733 794.6 662.3 802.3 586H438V221.7z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M864 518H506V160c0-4.4-3.6-8-8-8h-26a398.46 398.46 0 00-282.8 117.1 398.19 398.19 0 00-85.7 127.1A397.61 397.61 0 0072 552v.2c0 53.9 10.6 106.2 31.4 155.5 20.1 47.6 49 90.4 85.7 127.1 36.7 36.7 79.5 65.6 127.1 85.7A397.61 397.61 0 00472 952c26.9 0 53.4-2.6 79.3-7.8 26.1-5.3 51.7-13.1 76.4-23.6 47.6-20.1 90.4-49 127.1-85.7 36.7-36.7 65.6-79.5 85.7-127.1A397.61 397.61 0 00872 552v-26c0-4.4-3.6-8-8-8zM705.7 787.8A331.59 331.59 0 01470.4 884c-88.1-.4-170.9-34.9-233.2-97.2C174.5 724.1 140 640.7 140 552s34.5-172.1 97.2-234.8c54.6-54.6 124.9-87.9 200.8-95.5V586h364.3c-7.7 76.3-41.3 147-96.6 201.8z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M952 462.4l-2.6-28.2c-8.5-92.1-49.4-179-115.2-244.6A399.4 399.4 0 00589 74.6L560.7 72c-3.4-.3-6.4 1.5-7.8 4.3a8.7 8.7 0 00-.9 3.6V464c0 4.4 3.6 8 8 8l384-1c1.2 0 2.3-.3 3.4-.7a8.1 8.1 0 004.6-7.9zm-332.2-58.2V147.6a332.24 332.24 0 01166.4 89.8c45.7 45.6 77 103.6 90 166.1l-256.4.7z", "fill": primaryColor } }] }; }, "name": "pie-chart", "theme": "twotone" };
	exports.default = PieChartTwoTone;
	});

	var PieChartTwoToneSvg = unwrapExports(PieChartTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var PieChartTwoTone = function PieChartTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PieChartTwoToneSvg
	  }));
	};

	PieChartTwoTone.displayName = 'PieChartTwoTone';
	var PieChartTwoTone$1 = /*#__PURE__*/React.forwardRef(PieChartTwoTone);

	var PlayCircleFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PlayCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm144.1 454.9L437.7 677.8a8.02 8.02 0 01-12.7-6.5V353.7a8 8 0 0112.7-6.5L656.1 506a7.9 7.9 0 010 12.9z" } }] }, "name": "play-circle", "theme": "filled" };
	exports.default = PlayCircleFilled;
	});

	var PlayCircleFilledSvg = unwrapExports(PlayCircleFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var PlayCircleFilled = function PlayCircleFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PlayCircleFilledSvg
	  }));
	};

	PlayCircleFilled.displayName = 'PlayCircleFilled';
	var PlayCircleFilled$1 = /*#__PURE__*/React.forwardRef(PlayCircleFilled);

	var PlayCircleOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PlayCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z" } }, { "tag": "path", "attrs": { "d": "M719.4 499.1l-296.1-215A15.9 15.9 0 00398 297v430c0 13.1 14.8 20.5 25.3 12.9l296.1-215a15.9 15.9 0 000-25.8zm-257.6 134V390.9L628.5 512 461.8 633.1z" } }] }, "name": "play-circle", "theme": "outlined" };
	exports.default = PlayCircleOutlined;
	});

	var PlayCircleOutlinedSvg = unwrapExports(PlayCircleOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var PlayCircleOutlined = function PlayCircleOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PlayCircleOutlinedSvg
	  }));
	};

	PlayCircleOutlined.displayName = 'PlayCircleOutlined';
	var PlayCircleOutlined$1 = /*#__PURE__*/React.forwardRef(PlayCircleOutlined);

	var PlayCircleTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PlayCircleTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm164.1 378.2L457.7 677.1a8.02 8.02 0 01-12.7-6.5V353a8 8 0 0112.7-6.5l218.4 158.8a7.9 7.9 0 010 12.9z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M676.1 505.3L457.7 346.5A8 8 0 00445 353v317.6a8.02 8.02 0 0012.7 6.5l218.4-158.9a7.9 7.9 0 000-12.9z", "fill": primaryColor } }] }; }, "name": "play-circle", "theme": "twotone" };
	exports.default = PlayCircleTwoTone;
	});

	var PlayCircleTwoToneSvg = unwrapExports(PlayCircleTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var PlayCircleTwoTone = function PlayCircleTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PlayCircleTwoToneSvg
	  }));
	};

	PlayCircleTwoTone.displayName = 'PlayCircleTwoTone';
	var PlayCircleTwoTone$1 = /*#__PURE__*/React.forwardRef(PlayCircleTwoTone);

	var PlaySquareFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PlaySquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM641.7 520.8L442.3 677.6c-7.4 5.8-18.3.6-18.3-8.8V355.3c0-9.4 10.9-14.7 18.3-8.8l199.4 156.7a11.2 11.2 0 010 17.6z" } }] }, "name": "play-square", "theme": "filled" };
	exports.default = PlaySquareFilled;
	});

	var PlaySquareFilledSvg = unwrapExports(PlaySquareFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var PlaySquareFilled = function PlaySquareFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PlaySquareFilledSvg
	  }));
	};

	PlaySquareFilled.displayName = 'PlaySquareFilled';
	var PlaySquareFilled$1 = /*#__PURE__*/React.forwardRef(PlaySquareFilled);

	var PlaySquareOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PlaySquareOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M442.3 677.6l199.4-156.7a11.3 11.3 0 000-17.7L442.3 346.4c-7.4-5.8-18.3-.6-18.3 8.8v313.5c0 9.4 10.9 14.7 18.3 8.9z" } }, { "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z" } }] }, "name": "play-square", "theme": "outlined" };
	exports.default = PlaySquareOutlined;
	});

	var PlaySquareOutlinedSvg = unwrapExports(PlaySquareOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var PlaySquareOutlined = function PlaySquareOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PlaySquareOutlinedSvg
	  }));
	};

	PlaySquareOutlined.displayName = 'PlaySquareOutlined';
	var PlaySquareOutlined$1 = /*#__PURE__*/React.forwardRef(PlaySquareOutlined);

	var PlaySquareTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PlaySquareTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M184 840h656V184H184v656zm240-484.7c0-9.4 10.9-14.7 18.3-8.8l199.4 156.7a11.2 11.2 0 010 17.6L442.3 677.6c-7.4 5.8-18.3.6-18.3-8.8V355.3z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M442.3 677.6l199.4-156.8a11.2 11.2 0 000-17.6L442.3 346.5c-7.4-5.9-18.3-.6-18.3 8.8v313.5c0 9.4 10.9 14.6 18.3 8.8z", "fill": primaryColor } }] }; }, "name": "play-square", "theme": "twotone" };
	exports.default = PlaySquareTwoTone;
	});

	var PlaySquareTwoToneSvg = unwrapExports(PlaySquareTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var PlaySquareTwoTone = function PlaySquareTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PlaySquareTwoToneSvg
	  }));
	};

	PlaySquareTwoTone.displayName = 'PlaySquareTwoTone';
	var PlaySquareTwoTone$1 = /*#__PURE__*/React.forwardRef(PlaySquareTwoTone);

	var PlusCircleFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PlusCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm192 472c0 4.4-3.6 8-8 8H544v152c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V544H328c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h152V328c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v152h152c4.4 0 8 3.6 8 8v48z" } }] }, "name": "plus-circle", "theme": "filled" };
	exports.default = PlusCircleFilled;
	});

	var PlusCircleFilledSvg = unwrapExports(PlusCircleFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var PlusCircleFilled = function PlusCircleFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PlusCircleFilledSvg
	  }));
	};

	PlusCircleFilled.displayName = 'PlusCircleFilled';
	var PlusCircleFilled$1 = /*#__PURE__*/React.forwardRef(PlusCircleFilled);

	var PlusCircleOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PlusCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M696 480H544V328c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v152H328c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h152v152c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V544h152c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8z" } }, { "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z" } }] }, "name": "plus-circle", "theme": "outlined" };
	exports.default = PlusCircleOutlined;
	});

	var PlusCircleOutlinedSvg = unwrapExports(PlusCircleOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var PlusCircleOutlined = function PlusCircleOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PlusCircleOutlinedSvg
	  }));
	};

	PlusCircleOutlined.displayName = 'PlusCircleOutlined';
	var PlusCircleOutlined$1 = /*#__PURE__*/React.forwardRef(PlusCircleOutlined);

	var PlusCircleTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PlusCircleTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm192 396c0 4.4-3.6 8-8 8H544v152c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V544H328c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h152V328c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v152h152c4.4 0 8 3.6 8 8v48z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M696 480H544V328c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v152H328c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h152v152c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V544h152c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8z", "fill": primaryColor } }] }; }, "name": "plus-circle", "theme": "twotone" };
	exports.default = PlusCircleTwoTone;
	});

	var PlusCircleTwoToneSvg = unwrapExports(PlusCircleTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var PlusCircleTwoTone = function PlusCircleTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PlusCircleTwoToneSvg
	  }));
	};

	PlusCircleTwoTone.displayName = 'PlusCircleTwoTone';
	var PlusCircleTwoTone$1 = /*#__PURE__*/React.forwardRef(PlusCircleTwoTone);

	var PlusOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PlusOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M482 152h60q8 0 8 8v704q0 8-8 8h-60q-8 0-8-8V160q0-8 8-8z" } }, { "tag": "path", "attrs": { "d": "M176 474h672q8 0 8 8v60q0 8-8 8H176q-8 0-8-8v-60q0-8 8-8z" } }] }, "name": "plus", "theme": "outlined" };
	exports.default = PlusOutlined;
	});

	var PlusOutlinedSvg = unwrapExports(PlusOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var PlusOutlined = function PlusOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PlusOutlinedSvg
	  }));
	};

	PlusOutlined.displayName = 'PlusOutlined';
	var PlusOutlined$1 = /*#__PURE__*/React.forwardRef(PlusOutlined);

	var PlusSquareFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PlusSquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM704 536c0 4.4-3.6 8-8 8H544v152c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V544H328c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h152V328c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v152h152c4.4 0 8 3.6 8 8v48z" } }] }, "name": "plus-square", "theme": "filled" };
	exports.default = PlusSquareFilled;
	});

	var PlusSquareFilledSvg = unwrapExports(PlusSquareFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var PlusSquareFilled = function PlusSquareFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PlusSquareFilledSvg
	  }));
	};

	PlusSquareFilled.displayName = 'PlusSquareFilled';
	var PlusSquareFilled$1 = /*#__PURE__*/React.forwardRef(PlusSquareFilled);

	var PlusSquareOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PlusSquareOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M328 544h152v152c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V544h152c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H544V328c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v152H328c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8z" } }, { "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z" } }] }, "name": "plus-square", "theme": "outlined" };
	exports.default = PlusSquareOutlined;
	});

	var PlusSquareOutlinedSvg = unwrapExports(PlusSquareOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var PlusSquareOutlined = function PlusSquareOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PlusSquareOutlinedSvg
	  }));
	};

	PlusSquareOutlined.displayName = 'PlusSquareOutlined';
	var PlusSquareOutlined$1 = /*#__PURE__*/React.forwardRef(PlusSquareOutlined);

	var PlusSquareTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PlusSquareTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M184 840h656V184H184v656zm136-352c0-4.4 3.6-8 8-8h152V328c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v152h152c4.4 0 8 3.6 8 8v48c0 4.4-3.6 8-8 8H544v152c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V544H328c-4.4 0-8-3.6-8-8v-48z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M328 544h152v152c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V544h152c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H544V328c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v152H328c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8z", "fill": primaryColor } }] }; }, "name": "plus-square", "theme": "twotone" };
	exports.default = PlusSquareTwoTone;
	});

	var PlusSquareTwoToneSvg = unwrapExports(PlusSquareTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var PlusSquareTwoTone = function PlusSquareTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PlusSquareTwoToneSvg
	  }));
	};

	PlusSquareTwoTone.displayName = 'PlusSquareTwoTone';
	var PlusSquareTwoTone$1 = /*#__PURE__*/React.forwardRef(PlusSquareTwoTone);

	var PoundCircleFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PoundCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm146 658c0 4.4-3.6 8-8 8H376.2c-4.4 0-8-3.6-8-8v-38.5c0-3.7 2.5-6.9 6.1-7.8 44-10.9 72.8-49 72.8-94.2 0-14.7-2.5-29.4-5.9-44.2H374c-4.4 0-8-3.6-8-8v-30c0-4.4 3.6-8 8-8h53.7c-7.8-25.1-14.6-50.7-14.6-77.1 0-75.8 58.6-120.3 151.5-120.3 26.5 0 51.4 5.5 70.3 12.7 3.1 1.2 5.2 4.2 5.2 7.5v39.5a8 8 0 01-10.6 7.6c-17.9-6.4-39-10.5-60.4-10.5-53.3 0-87.3 26.6-87.3 70.2 0 24.7 6.2 47.9 13.4 70.5h112c4.4 0 8 3.6 8 8v30c0 4.4-3.6 8-8 8h-98.6c3.1 13.2 5.3 26.9 5.3 41 0 40.7-16.5 73.9-43.9 91.1v4.7h180c4.4 0 8 3.6 8 8V722z" } }] }, "name": "pound-circle", "theme": "filled" };
	exports.default = PoundCircleFilled;
	});

	var PoundCircleFilledSvg = unwrapExports(PoundCircleFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var PoundCircleFilled = function PoundCircleFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PoundCircleFilledSvg
	  }));
	};

	PoundCircleFilled.displayName = 'PoundCircleFilled';
	var PoundCircleFilled$1 = /*#__PURE__*/React.forwardRef(PoundCircleFilled);

	var PoundCircleOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PoundCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372zm138-209.8H469.8v-4.7c27.4-17.2 43.9-50.4 43.9-91.1 0-14.1-2.2-27.9-5.3-41H607c4.4 0 8-3.6 8-8v-30c0-4.4-3.6-8-8-8H495c-7.2-22.6-13.4-45.7-13.4-70.5 0-43.5 34-70.2 87.3-70.2 21.5 0 42.5 4.1 60.4 10.5 5.2 1.9 10.6-2 10.6-7.6v-39.5c0-3.3-2.1-6.3-5.2-7.5-18.8-7.2-43.8-12.7-70.3-12.7-92.9 0-151.5 44.5-151.5 120.3 0 26.3 6.9 52 14.6 77.1H374c-4.4 0-8 3.6-8 8v30c0 4.4 3.6 8 8 8h67.1c3.4 14.7 5.9 29.4 5.9 44.2 0 45.2-28.8 83.3-72.8 94.2-3.6.9-6.1 4.1-6.1 7.8V722c0 4.4 3.6 8 8 8H650c4.4 0 8-3.6 8-8v-39.8c0-4.4-3.6-8-8-8z" } }] }, "name": "pound-circle", "theme": "outlined" };
	exports.default = PoundCircleOutlined;
	});

	var PoundCircleOutlinedSvg = unwrapExports(PoundCircleOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var PoundCircleOutlined = function PoundCircleOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PoundCircleOutlinedSvg
	  }));
	};

	PoundCircleOutlined.displayName = 'PoundCircleOutlined';
	var PoundCircleOutlined$1 = /*#__PURE__*/React.forwardRef(PoundCircleOutlined);

	var PoundCircleTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PoundCircleTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm146 582.1c0 4.4-3.6 8-8 8H376.2c-4.4 0-8-3.6-8-8v-38.5c0-3.7 2.5-6.9 6.1-7.8 44-10.9 72.8-49 72.8-94.2 0-14.7-2.5-29.4-5.9-44.2H374c-4.4 0-8-3.6-8-8v-30c0-4.4 3.6-8 8-8h53.7c-7.8-25.1-14.6-50.7-14.6-77.1 0-75.8 58.6-120.3 151.5-120.3 26.5 0 51.4 5.5 70.3 12.7 3.1 1.2 5.2 4.2 5.2 7.5v39.5a8 8 0 01-10.6 7.6c-17.9-6.4-39-10.5-60.4-10.5-53.3 0-87.3 26.6-87.3 70.2 0 24.7 6.2 47.9 13.4 70.5h112c4.4 0 8 3.6 8 8v30c0 4.4-3.6 8-8 8h-98.6c3.1 13.2 5.3 26.9 5.3 41 0 40.7-16.5 73.9-43.9 91.1v4.7h180c4.4 0 8 3.6 8 8v39.8z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M650 674.3H470v-4.7c27.4-17.2 43.9-50.4 43.9-91.1 0-14.1-2.2-27.8-5.3-41h98.6c4.4 0 8-3.6 8-8v-30c0-4.4-3.6-8-8-8h-112c-7.2-22.6-13.4-45.8-13.4-70.5 0-43.6 34-70.2 87.3-70.2 21.4 0 42.5 4.1 60.4 10.5a8 8 0 0010.6-7.6v-39.5c0-3.3-2.1-6.3-5.2-7.5-18.9-7.2-43.8-12.7-70.3-12.7-92.9 0-151.5 44.5-151.5 120.3 0 26.4 6.8 52 14.6 77.1H374c-4.4 0-8 3.6-8 8v30c0 4.4 3.6 8 8 8h67.2c3.4 14.8 5.9 29.5 5.9 44.2 0 45.2-28.8 83.3-72.8 94.2-3.6.9-6.1 4.1-6.1 7.8v38.5c0 4.4 3.6 8 8 8H650c4.4 0 8-3.6 8-8v-39.8c0-4.4-3.6-8-8-8z", "fill": primaryColor } }] }; }, "name": "pound-circle", "theme": "twotone" };
	exports.default = PoundCircleTwoTone;
	});

	var PoundCircleTwoToneSvg = unwrapExports(PoundCircleTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var PoundCircleTwoTone = function PoundCircleTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PoundCircleTwoToneSvg
	  }));
	};

	PoundCircleTwoTone.displayName = 'PoundCircleTwoTone';
	var PoundCircleTwoTone$1 = /*#__PURE__*/React.forwardRef(PoundCircleTwoTone);

	var PoundOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PoundOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372zm138-209.8H469.8v-4.7c27.4-17.2 43.9-50.4 43.9-91.1 0-14.1-2.2-27.9-5.3-41H607c4.4 0 8-3.6 8-8v-30c0-4.4-3.6-8-8-8H495c-7.2-22.6-13.4-45.7-13.4-70.5 0-43.5 34-70.2 87.3-70.2 21.5 0 42.5 4.1 60.4 10.5 5.2 1.9 10.6-2 10.6-7.6v-39.5c0-3.3-2.1-6.3-5.2-7.5-18.8-7.2-43.8-12.7-70.3-12.7-92.9 0-151.5 44.5-151.5 120.3 0 26.3 6.9 52 14.6 77.1H374c-4.4 0-8 3.6-8 8v30c0 4.4 3.6 8 8 8h67.1c3.4 14.7 5.9 29.4 5.9 44.2 0 45.2-28.8 83.3-72.8 94.2-3.6.9-6.1 4.1-6.1 7.8V722c0 4.4 3.6 8 8 8H650c4.4 0 8-3.6 8-8v-39.8c0-4.4-3.6-8-8-8z" } }] }, "name": "pound", "theme": "outlined" };
	exports.default = PoundOutlined;
	});

	var PoundOutlinedSvg = unwrapExports(PoundOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var PoundOutlined = function PoundOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PoundOutlinedSvg
	  }));
	};

	PoundOutlined.displayName = 'PoundOutlined';
	var PoundOutlined$1 = /*#__PURE__*/React.forwardRef(PoundOutlined);

	var PoweroffOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PoweroffOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M705.6 124.9a8 8 0 00-11.6 7.2v64.2c0 5.5 2.9 10.6 7.5 13.6a352.2 352.2 0 0162.2 49.8c32.7 32.8 58.4 70.9 76.3 113.3a355 355 0 0127.9 138.7c0 48.1-9.4 94.8-27.9 138.7a355.92 355.92 0 01-76.3 113.3 353.06 353.06 0 01-113.2 76.4c-43.8 18.6-90.5 28-138.5 28s-94.7-9.4-138.5-28a353.06 353.06 0 01-113.2-76.4A355.92 355.92 0 01184 650.4a355 355 0 01-27.9-138.7c0-48.1 9.4-94.8 27.9-138.7 17.9-42.4 43.6-80.5 76.3-113.3 19-19 39.8-35.6 62.2-49.8 4.7-2.9 7.5-8.1 7.5-13.6V132c0-6-6.3-9.8-11.6-7.2C178.5 195.2 82 339.3 80 506.3 77.2 745.1 272.5 943.5 511.2 944c239 .5 432.8-193.3 432.8-432.4 0-169.2-97-315.7-238.4-386.7zM480 560h64c4.4 0 8-3.6 8-8V88c0-4.4-3.6-8-8-8h-64c-4.4 0-8 3.6-8 8v464c0 4.4 3.6 8 8 8z" } }] }, "name": "poweroff", "theme": "outlined" };
	exports.default = PoweroffOutlined;
	});

	var PoweroffOutlinedSvg = unwrapExports(PoweroffOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var PoweroffOutlined = function PoweroffOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PoweroffOutlinedSvg
	  }));
	};

	PoweroffOutlined.displayName = 'PoweroffOutlined';
	var PoweroffOutlined$1 = /*#__PURE__*/React.forwardRef(PoweroffOutlined);

	var PrinterFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PrinterFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M732 120c0-4.4-3.6-8-8-8H300c-4.4 0-8 3.6-8 8v148h440V120zm120 212H172c-44.2 0-80 35.8-80 80v328c0 17.7 14.3 32 32 32h168v132c0 4.4 3.6 8 8 8h424c4.4 0 8-3.6 8-8V772h168c17.7 0 32-14.3 32-32V412c0-44.2-35.8-80-80-80zM664 844H360V568h304v276zm164-360c0 4.4-3.6 8-8 8h-40c-4.4 0-8-3.6-8-8v-40c0-4.4 3.6-8 8-8h40c4.4 0 8 3.6 8 8v40z" } }] }, "name": "printer", "theme": "filled" };
	exports.default = PrinterFilled;
	});

	var PrinterFilledSvg = unwrapExports(PrinterFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var PrinterFilled = function PrinterFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PrinterFilledSvg
	  }));
	};

	PrinterFilled.displayName = 'PrinterFilled';
	var PrinterFilled$1 = /*#__PURE__*/React.forwardRef(PrinterFilled);

	var PrinterOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PrinterOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M820 436h-40c-4.4 0-8 3.6-8 8v40c0 4.4 3.6 8 8 8h40c4.4 0 8-3.6 8-8v-40c0-4.4-3.6-8-8-8zm32-104H732V120c0-4.4-3.6-8-8-8H300c-4.4 0-8 3.6-8 8v212H172c-44.2 0-80 35.8-80 80v328c0 17.7 14.3 32 32 32h168v132c0 4.4 3.6 8 8 8h424c4.4 0 8-3.6 8-8V772h168c17.7 0 32-14.3 32-32V412c0-44.2-35.8-80-80-80zM360 180h304v152H360V180zm304 664H360V568h304v276zm200-140H732V500H292v204H160V412c0-6.6 5.4-12 12-12h680c6.6 0 12 5.4 12 12v292z" } }] }, "name": "printer", "theme": "outlined" };
	exports.default = PrinterOutlined;
	});

	var PrinterOutlinedSvg = unwrapExports(PrinterOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var PrinterOutlined = function PrinterOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PrinterOutlinedSvg
	  }));
	};

	PrinterOutlined.displayName = 'PrinterOutlined';
	var PrinterOutlined$1 = /*#__PURE__*/React.forwardRef(PrinterOutlined);

	var PrinterTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PrinterTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M360 180h304v152H360zm492 220H172c-6.6 0-12 5.4-12 12v292h132V500h440v204h132V412c0-6.6-5.4-12-12-12zm-24 84c0 4.4-3.6 8-8 8h-40c-4.4 0-8-3.6-8-8v-40c0-4.4 3.6-8 8-8h40c4.4 0 8 3.6 8 8v40z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M852 332H732V120c0-4.4-3.6-8-8-8H300c-4.4 0-8 3.6-8 8v212H172c-44.2 0-80 35.8-80 80v328c0 17.7 14.3 32 32 32h168v132c0 4.4 3.6 8 8 8h424c4.4 0 8-3.6 8-8V772h168c17.7 0 32-14.3 32-32V412c0-44.2-35.8-80-80-80zM360 180h304v152H360V180zm304 664H360V568h304v276zm200-140H732V500H292v204H160V412c0-6.6 5.4-12 12-12h680c6.6 0 12 5.4 12 12v292z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M820 436h-40c-4.4 0-8 3.6-8 8v40c0 4.4 3.6 8 8 8h40c4.4 0 8-3.6 8-8v-40c0-4.4-3.6-8-8-8z", "fill": primaryColor } }] }; }, "name": "printer", "theme": "twotone" };
	exports.default = PrinterTwoTone;
	});

	var PrinterTwoToneSvg = unwrapExports(PrinterTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var PrinterTwoTone = function PrinterTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PrinterTwoToneSvg
	  }));
	};

	PrinterTwoTone.displayName = 'PrinterTwoTone';
	var PrinterTwoTone$1 = /*#__PURE__*/React.forwardRef(PrinterTwoTone);

	var ProfileFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ProfileFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM380 696c-22.1 0-40-17.9-40-40s17.9-40 40-40 40 17.9 40 40-17.9 40-40 40zm0-144c-22.1 0-40-17.9-40-40s17.9-40 40-40 40 17.9 40 40-17.9 40-40 40zm0-144c-22.1 0-40-17.9-40-40s17.9-40 40-40 40 17.9 40 40-17.9 40-40 40zm304 272c0 4.4-3.6 8-8 8H492c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h184c4.4 0 8 3.6 8 8v48zm0-144c0 4.4-3.6 8-8 8H492c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h184c4.4 0 8 3.6 8 8v48zm0-144c0 4.4-3.6 8-8 8H492c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h184c4.4 0 8 3.6 8 8v48z" } }] }, "name": "profile", "theme": "filled" };
	exports.default = ProfileFilled;
	});

	var ProfileFilledSvg = unwrapExports(ProfileFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var ProfileFilled = function ProfileFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ProfileFilledSvg
	  }));
	};

	ProfileFilled.displayName = 'ProfileFilled';
	var ProfileFilled$1 = /*#__PURE__*/React.forwardRef(ProfileFilled);

	var ProfileOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ProfileOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656zM492 400h184c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H492c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8zm0 144h184c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H492c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8zm0 144h184c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H492c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8zM340 368a40 40 0 1080 0 40 40 0 10-80 0zm0 144a40 40 0 1080 0 40 40 0 10-80 0zm0 144a40 40 0 1080 0 40 40 0 10-80 0z" } }] }, "name": "profile", "theme": "outlined" };
	exports.default = ProfileOutlined;
	});

	var ProfileOutlinedSvg = unwrapExports(ProfileOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var ProfileOutlined = function ProfileOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ProfileOutlinedSvg
	  }));
	};

	ProfileOutlined.displayName = 'ProfileOutlined';
	var ProfileOutlined$1 = /*#__PURE__*/React.forwardRef(ProfileOutlined);

	var ProfileTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ProfileTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M184 840h656V184H184v656zm300-496c0-4.4 3.6-8 8-8h184c4.4 0 8 3.6 8 8v48c0 4.4-3.6 8-8 8H492c-4.4 0-8-3.6-8-8v-48zm0 144c0-4.4 3.6-8 8-8h184c4.4 0 8 3.6 8 8v48c0 4.4-3.6 8-8 8H492c-4.4 0-8-3.6-8-8v-48zm0 144c0-4.4 3.6-8 8-8h184c4.4 0 8 3.6 8 8v48c0 4.4-3.6 8-8 8H492c-4.4 0-8-3.6-8-8v-48zM380 328c22.1 0 40 17.9 40 40s-17.9 40-40 40-40-17.9-40-40 17.9-40 40-40zm0 144c22.1 0 40 17.9 40 40s-17.9 40-40 40-40-17.9-40-40 17.9-40 40-40zm0 144c22.1 0 40 17.9 40 40s-17.9 40-40 40-40-17.9-40-40 17.9-40 40-40z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M340 656a40 40 0 1080 0 40 40 0 10-80 0zm0-144a40 40 0 1080 0 40 40 0 10-80 0zm0-144a40 40 0 1080 0 40 40 0 10-80 0zm152 320h184c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H492c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8zm0-144h184c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H492c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8zm0-144h184c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H492c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8z", "fill": primaryColor } }] }; }, "name": "profile", "theme": "twotone" };
	exports.default = ProfileTwoTone;
	});

	var ProfileTwoToneSvg = unwrapExports(ProfileTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var ProfileTwoTone = function ProfileTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ProfileTwoToneSvg
	  }));
	};

	ProfileTwoTone.displayName = 'ProfileTwoTone';
	var ProfileTwoTone$1 = /*#__PURE__*/React.forwardRef(ProfileTwoTone);

	var ProjectFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ProjectFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM368 744c0 4.4-3.6 8-8 8h-80c-4.4 0-8-3.6-8-8V280c0-4.4 3.6-8 8-8h80c4.4 0 8 3.6 8 8v464zm192-280c0 4.4-3.6 8-8 8h-80c-4.4 0-8-3.6-8-8V280c0-4.4 3.6-8 8-8h80c4.4 0 8 3.6 8 8v184zm192 72c0 4.4-3.6 8-8 8h-80c-4.4 0-8-3.6-8-8V280c0-4.4 3.6-8 8-8h80c4.4 0 8 3.6 8 8v256z" } }] }, "name": "project", "theme": "filled" };
	exports.default = ProjectFilled;
	});

	var ProjectFilledSvg = unwrapExports(ProjectFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var ProjectFilled = function ProjectFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ProjectFilledSvg
	  }));
	};

	ProjectFilled.displayName = 'ProjectFilled';
	var ProjectFilled$1 = /*#__PURE__*/React.forwardRef(ProjectFilled);

	var ProjectOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ProjectOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M280 752h80c4.4 0 8-3.6 8-8V280c0-4.4-3.6-8-8-8h-80c-4.4 0-8 3.6-8 8v464c0 4.4 3.6 8 8 8zm192-280h80c4.4 0 8-3.6 8-8V280c0-4.4-3.6-8-8-8h-80c-4.4 0-8 3.6-8 8v184c0 4.4 3.6 8 8 8zm192 72h80c4.4 0 8-3.6 8-8V280c0-4.4-3.6-8-8-8h-80c-4.4 0-8 3.6-8 8v256c0 4.4 3.6 8 8 8zm216-432H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z" } }] }, "name": "project", "theme": "outlined" };
	exports.default = ProjectOutlined;
	});

	var ProjectOutlinedSvg = unwrapExports(ProjectOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var ProjectOutlined = function ProjectOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ProjectOutlinedSvg
	  }));
	};

	ProjectOutlined.displayName = 'ProjectOutlined';
	var ProjectOutlined$1 = /*#__PURE__*/React.forwardRef(ProjectOutlined);

	var ProjectTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ProjectTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M184 840h656V184H184v656zm472-560c0-4.4 3.6-8 8-8h80c4.4 0 8 3.6 8 8v256c0 4.4-3.6 8-8 8h-80c-4.4 0-8-3.6-8-8V280zm-192 0c0-4.4 3.6-8 8-8h80c4.4 0 8 3.6 8 8v184c0 4.4-3.6 8-8 8h-80c-4.4 0-8-3.6-8-8V280zm-192 0c0-4.4 3.6-8 8-8h80c4.4 0 8 3.6 8 8v464c0 4.4-3.6 8-8 8h-80c-4.4 0-8-3.6-8-8V280z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M280 752h80c4.4 0 8-3.6 8-8V280c0-4.4-3.6-8-8-8h-80c-4.4 0-8 3.6-8 8v464c0 4.4 3.6 8 8 8zm192-280h80c4.4 0 8-3.6 8-8V280c0-4.4-3.6-8-8-8h-80c-4.4 0-8 3.6-8 8v184c0 4.4 3.6 8 8 8zm192 72h80c4.4 0 8-3.6 8-8V280c0-4.4-3.6-8-8-8h-80c-4.4 0-8 3.6-8 8v256c0 4.4 3.6 8 8 8z", "fill": primaryColor } }] }; }, "name": "project", "theme": "twotone" };
	exports.default = ProjectTwoTone;
	});

	var ProjectTwoToneSvg = unwrapExports(ProjectTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var ProjectTwoTone = function ProjectTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ProjectTwoToneSvg
	  }));
	};

	ProjectTwoTone.displayName = 'ProjectTwoTone';
	var ProjectTwoTone$1 = /*#__PURE__*/React.forwardRef(ProjectTwoTone);

	var PropertySafetyFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PropertySafetyFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M866.9 169.9L527.1 54.1C523 52.7 517.5 52 512 52s-11 .7-15.1 2.1L157.1 169.9c-8.3 2.8-15.1 12.4-15.1 21.2v482.4c0 8.8 5.7 20.4 12.6 25.9L499.3 968c3.5 2.7 8 4.1 12.6 4.1s9.2-1.4 12.6-4.1l344.7-268.6c6.9-5.4 12.6-17 12.6-25.9V191.1c.2-8.8-6.6-18.3-14.9-21.2zM648.3 332.8l-87.7 161.1h45.7c5.5 0 10 4.5 10 10v21.3c0 5.5-4.5 10-10 10h-63.4v29.7h63.4c5.5 0 10 4.5 10 10v21.3c0 5.5-4.5 10-10 10h-63.4V658c0 5.5-4.5 10-10 10h-41.3c-5.5 0-10-4.5-10-10v-51.8h-63.1c-5.5 0-10-4.5-10-10v-21.3c0-5.5 4.5-10 10-10h63.1v-29.7h-63.1c-5.5 0-10-4.5-10-10v-21.3c0-5.5 4.5-10 10-10h45.2l-88-161.1c-2.6-4.8-.9-10.9 4-13.6 1.5-.8 3.1-1.2 4.8-1.2h46c3.8 0 7.2 2.1 8.9 5.5l72.9 144.3 73.2-144.3a10 10 0 018.9-5.5h45c5.5 0 10 4.5 10 10 .1 1.7-.3 3.3-1.1 4.8z" } }] }, "name": "property-safety", "theme": "filled" };
	exports.default = PropertySafetyFilled;
	});

	var PropertySafetyFilledSvg = unwrapExports(PropertySafetyFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var PropertySafetyFilled = function PropertySafetyFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PropertySafetyFilledSvg
	  }));
	};

	PropertySafetyFilled.displayName = 'PropertySafetyFilled';
	var PropertySafetyFilled$1 = /*#__PURE__*/React.forwardRef(PropertySafetyFilled);

	var PropertySafetyOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PropertySafetyOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M866.9 169.9L527.1 54.1C523 52.7 517.5 52 512 52s-11 .7-15.1 2.1L157.1 169.9c-8.3 2.8-15.1 12.4-15.1 21.2v482.4c0 8.8 5.7 20.4 12.6 25.9L499.3 968c3.5 2.7 8 4.1 12.6 4.1s9.2-1.4 12.6-4.1l344.7-268.6c6.9-5.4 12.6-17 12.6-25.9V191.1c.2-8.8-6.6-18.3-14.9-21.2zM810 654.3L512 886.5 214 654.3V226.7l298-101.6 298 101.6v427.6zM430.5 318h-46c-1.7 0-3.3.4-4.8 1.2a10.1 10.1 0 00-4 13.6l88 161.1h-45.2c-5.5 0-10 4.5-10 10v21.3c0 5.5 4.5 10 10 10h63.1v29.7h-63.1c-5.5 0-10 4.5-10 10v21.3c0 5.5 4.5 10 10 10h63.1V658c0 5.5 4.5 10 10 10h41.3c5.5 0 10-4.5 10-10v-51.8h63.4c5.5 0 10-4.5 10-10v-21.3c0-5.5-4.5-10-10-10h-63.4v-29.7h63.4c5.5 0 10-4.5 10-10v-21.3c0-5.5-4.5-10-10-10h-45.7l87.7-161.1a10.05 10.05 0 00-8.8-14.8h-45c-3.8 0-7.2 2.1-8.9 5.5l-73.2 144.3-72.9-144.3c-1.7-3.4-5.2-5.5-9-5.5z" } }] }, "name": "property-safety", "theme": "outlined" };
	exports.default = PropertySafetyOutlined;
	});

	var PropertySafetyOutlinedSvg = unwrapExports(PropertySafetyOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var PropertySafetyOutlined = function PropertySafetyOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PropertySafetyOutlinedSvg
	  }));
	};

	PropertySafetyOutlined.displayName = 'PropertySafetyOutlined';
	var PropertySafetyOutlined$1 = /*#__PURE__*/React.forwardRef(PropertySafetyOutlined);

	var PropertySafetyTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PropertySafetyTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M866.9 169.9L527.1 54.1C523 52.7 517.5 52 512 52s-11 .7-15.1 2.1L157.1 169.9c-8.3 2.8-15.1 12.4-15.1 21.2v482.4c0 8.8 5.7 20.4 12.6 25.9L499.3 968c3.5 2.7 8 4.1 12.6 4.1s9.2-1.4 12.6-4.1l344.7-268.6c6.9-5.4 12.6-17 12.6-25.9V191.1c.2-8.8-6.6-18.3-14.9-21.2zM810 654.3L512 886.5 214 654.3V226.7l298-101.6 298 101.6v427.6z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M214 226.7v427.6l298 232.2 298-232.2V226.7L512 125.1 214 226.7zM593.9 318h45c5.5 0 10 4.5 10 10 .1 1.7-.3 3.3-1.1 4.8l-87.7 161.1h45.7c5.5 0 10 4.5 10 10v21.3c0 5.5-4.5 10-10 10h-63.4v29.7h63.4c5.5 0 10 4.5 10 10v21.3c0 5.5-4.5 10-10 10h-63.4V658c0 5.5-4.5 10-10 10h-41.3c-5.5 0-10-4.5-10-10v-51.8H418c-5.5 0-10-4.5-10-10v-21.3c0-5.5 4.5-10 10-10h63.1v-29.7H418c-5.5 0-10-4.5-10-10v-21.3c0-5.5 4.5-10 10-10h45.2l-88-161.1c-2.6-4.8-.9-10.9 4-13.6 1.5-.8 3.1-1.2 4.8-1.2h46c3.8 0 7.2 2.1 8.9 5.5l72.9 144.3L585 323.5a10 10 0 018.9-5.5z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M438.9 323.5a9.88 9.88 0 00-8.9-5.5h-46c-1.7 0-3.3.4-4.8 1.2-4.9 2.7-6.6 8.8-4 13.6l88 161.1H418c-5.5 0-10 4.5-10 10v21.3c0 5.5 4.5 10 10 10h63.1v29.7H418c-5.5 0-10 4.5-10 10v21.3c0 5.5 4.5 10 10 10h63.1V658c0 5.5 4.5 10 10 10h41.3c5.5 0 10-4.5 10-10v-51.8h63.4c5.5 0 10-4.5 10-10v-21.3c0-5.5-4.5-10-10-10h-63.4v-29.7h63.4c5.5 0 10-4.5 10-10v-21.3c0-5.5-4.5-10-10-10h-45.7l87.7-161.1c.8-1.5 1.2-3.1 1.1-4.8 0-5.5-4.5-10-10-10h-45a10 10 0 00-8.9 5.5l-73.2 144.3-72.9-144.3z", "fill": primaryColor } }] }; }, "name": "property-safety", "theme": "twotone" };
	exports.default = PropertySafetyTwoTone;
	});

	var PropertySafetyTwoToneSvg = unwrapExports(PropertySafetyTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var PropertySafetyTwoTone = function PropertySafetyTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PropertySafetyTwoToneSvg
	  }));
	};

	PropertySafetyTwoTone.displayName = 'PropertySafetyTwoTone';
	var PropertySafetyTwoTone$1 = /*#__PURE__*/React.forwardRef(PropertySafetyTwoTone);

	var PullRequestOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PullRequestOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M788 705.9V192c0-8.8-7.2-16-16-16H602v-68.8c0-6-7-9.4-11.7-5.7L462.7 202.3a7.14 7.14 0 000 11.3l127.5 100.8c4.7 3.7 11.7.4 11.7-5.7V240h114v465.9c-44.2 15-76 56.9-76 106.1 0 61.8 50.2 112 112 112s112-50.2 112-112c.1-49.2-31.7-91-75.9-106.1zM752 860a48.01 48.01 0 010-96 48.01 48.01 0 010 96zM384 212c0-61.8-50.2-112-112-112s-112 50.2-112 112c0 49.2 31.8 91 76 106.1V706c-44.2 15-76 56.9-76 106.1 0 61.8 50.2 112 112 112s112-50.2 112-112c0-49.2-31.8-91-76-106.1V318.1c44.2-15.1 76-56.9 76-106.1zm-160 0a48.01 48.01 0 0196 0 48.01 48.01 0 01-96 0zm96 600a48.01 48.01 0 01-96 0 48.01 48.01 0 0196 0z" } }] }, "name": "pull-request", "theme": "outlined" };
	exports.default = PullRequestOutlined;
	});

	var PullRequestOutlinedSvg = unwrapExports(PullRequestOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var PullRequestOutlined = function PullRequestOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PullRequestOutlinedSvg
	  }));
	};

	PullRequestOutlined.displayName = 'PullRequestOutlined';
	var PullRequestOutlined$1 = /*#__PURE__*/React.forwardRef(PullRequestOutlined);

	var PushpinFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PushpinFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M878.3 392.1L631.9 145.7c-6.5-6.5-15-9.7-23.5-9.7s-17 3.2-23.5 9.7L423.8 306.9c-12.2-1.4-24.5-2-36.8-2-73.2 0-146.4 24.1-206.5 72.3-15.4 12.3-16.6 35.4-2.7 49.4l181.7 181.7-215.4 215.2a15.8 15.8 0 00-4.6 9.8l-3.4 37.2c-.9 9.4 6.6 17.4 15.9 17.4.5 0 1 0 1.5-.1l37.2-3.4c3.7-.3 7.2-2 9.8-4.6l215.4-215.4 181.7 181.7c6.5 6.5 15 9.7 23.5 9.7 9.7 0 19.3-4.2 25.9-12.4 56.3-70.3 79.7-158.3 70.2-243.4l161.1-161.1c12.9-12.8 12.9-33.8 0-46.8z" } }] }, "name": "pushpin", "theme": "filled" };
	exports.default = PushpinFilled;
	});

	var PushpinFilledSvg = unwrapExports(PushpinFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var PushpinFilled = function PushpinFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PushpinFilledSvg
	  }));
	};

	PushpinFilled.displayName = 'PushpinFilled';
	var PushpinFilled$1 = /*#__PURE__*/React.forwardRef(PushpinFilled);

	var PushpinOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PushpinOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M878.3 392.1L631.9 145.7c-6.5-6.5-15-9.7-23.5-9.7s-17 3.2-23.5 9.7L423.8 306.9c-12.2-1.4-24.5-2-36.8-2-73.2 0-146.4 24.1-206.5 72.3a33.23 33.23 0 00-2.7 49.4l181.7 181.7-215.4 215.2a15.8 15.8 0 00-4.6 9.8l-3.4 37.2c-.9 9.4 6.6 17.4 15.9 17.4.5 0 1 0 1.5-.1l37.2-3.4c3.7-.3 7.2-2 9.8-4.6l215.4-215.4 181.7 181.7c6.5 6.5 15 9.7 23.5 9.7 9.7 0 19.3-4.2 25.9-12.4 56.3-70.3 79.7-158.3 70.2-243.4l161.1-161.1c12.9-12.8 12.9-33.8 0-46.8zM666.2 549.3l-24.5 24.5 3.8 34.4a259.92 259.92 0 01-30.4 153.9L262 408.8c12.9-7.1 26.3-13.1 40.3-17.9 27.2-9.4 55.7-14.1 84.7-14.1 9.6 0 19.3.5 28.9 1.6l34.4 3.8 24.5-24.5L608.5 224 800 415.5 666.2 549.3z" } }] }, "name": "pushpin", "theme": "outlined" };
	exports.default = PushpinOutlined;
	});

	var PushpinOutlinedSvg = unwrapExports(PushpinOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var PushpinOutlined = function PushpinOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PushpinOutlinedSvg
	  }));
	};

	PushpinOutlined.displayName = 'PushpinOutlined';
	var PushpinOutlined$1 = /*#__PURE__*/React.forwardRef(PushpinOutlined);

	var PushpinTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var PushpinTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M474.8 357.7l-24.5 24.5-34.4-3.8c-9.6-1.1-19.3-1.6-28.9-1.6-29 0-57.5 4.7-84.7 14.1-14 4.8-27.4 10.8-40.3 17.9l353.1 353.3a259.92 259.92 0 0030.4-153.9l-3.8-34.4 24.5-24.5L800 415.5 608.5 224 474.8 357.7z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M878.3 392.1L631.9 145.7c-6.5-6.5-15-9.7-23.5-9.7s-17 3.2-23.5 9.7L423.8 306.9c-12.2-1.4-24.5-2-36.8-2-73.2 0-146.4 24.1-206.5 72.3a33.23 33.23 0 00-2.7 49.4l181.7 181.7-215.4 215.2a15.8 15.8 0 00-4.6 9.8l-3.4 37.2c-.9 9.4 6.6 17.4 15.9 17.4.5 0 1 0 1.5-.1l37.2-3.4c3.7-.3 7.2-2 9.8-4.6l215.4-215.4 181.7 181.7c6.5 6.5 15 9.7 23.5 9.7 9.7 0 19.3-4.2 25.9-12.4 56.3-70.3 79.7-158.3 70.2-243.4l161.1-161.1c12.9-12.8 12.9-33.8 0-46.8zM666.2 549.3l-24.5 24.5 3.8 34.4a259.92 259.92 0 01-30.4 153.9L262 408.8c12.9-7.1 26.3-13.1 40.3-17.9 27.2-9.4 55.7-14.1 84.7-14.1 9.6 0 19.3.5 28.9 1.6l34.4 3.8 24.5-24.5L608.5 224 800 415.5 666.2 549.3z", "fill": primaryColor } }] }; }, "name": "pushpin", "theme": "twotone" };
	exports.default = PushpinTwoTone;
	});

	var PushpinTwoToneSvg = unwrapExports(PushpinTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var PushpinTwoTone = function PushpinTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: PushpinTwoToneSvg
	  }));
	};

	PushpinTwoTone.displayName = 'PushpinTwoTone';
	var PushpinTwoTone$1 = /*#__PURE__*/React.forwardRef(PushpinTwoTone);

	var QqCircleFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var QqCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm210.5 612.4c-11.5 1.4-44.9-52.7-44.9-52.7 0 31.3-16.2 72.2-51.1 101.8 16.9 5.2 54.9 19.2 45.9 34.4-7.3 12.3-125.6 7.9-159.8 4-34.2 3.8-152.5 8.3-159.8-4-9.1-15.2 28.9-29.2 45.8-34.4-35-29.5-51.1-70.4-51.1-101.8 0 0-33.4 54.1-44.9 52.7-5.4-.7-12.4-29.6 9.4-99.7 10.3-33 22-60.5 40.2-105.8-3.1-116.9 45.3-215 160.4-215 113.9 0 163.3 96.1 160.4 215 18.1 45.2 29.9 72.8 40.2 105.8 21.7 70.1 14.6 99.1 9.3 99.7z" } }] }, "name": "qq-circle", "theme": "filled" };
	exports.default = QqCircleFilled;
	});

	var QqCircleFilledSvg = unwrapExports(QqCircleFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var QqCircleFilled = function QqCircleFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: QqCircleFilledSvg
	  }));
	};

	QqCircleFilled.displayName = 'QqCircleFilled';
	var QqCircleFilled$1 = /*#__PURE__*/React.forwardRef(QqCircleFilled);

	var QqOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var QqOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M824.8 613.2c-16-51.4-34.4-94.6-62.7-165.3C766.5 262.2 689.3 112 511.5 112 331.7 112 256.2 265.2 261 447.9c-28.4 70.8-46.7 113.7-62.7 165.3-34 109.5-23 154.8-14.6 155.8 18 2.2 70.1-82.4 70.1-82.4 0 49 25.2 112.9 79.8 159-26.4 8.1-85.7 29.9-71.6 53.8 11.4 19.3 196.2 12.3 249.5 6.3 53.3 6 238.1 13 249.5-6.3 14.1-23.8-45.3-45.7-71.6-53.8 54.6-46.2 79.8-110.1 79.8-159 0 0 52.1 84.6 70.1 82.4 8.5-1.1 19.5-46.4-14.5-155.8z" } }] }, "name": "qq", "theme": "outlined" };
	exports.default = QqOutlined;
	});

	var QqOutlinedSvg = unwrapExports(QqOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var QqOutlined = function QqOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: QqOutlinedSvg
	  }));
	};

	QqOutlined.displayName = 'QqOutlined';
	var QqOutlined$1 = /*#__PURE__*/React.forwardRef(QqOutlined);

	var QqSquareFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var QqSquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM722.5 676.4c-11.5 1.4-44.9-52.7-44.9-52.7 0 31.3-16.2 72.2-51.1 101.8 16.9 5.2 54.9 19.2 45.9 34.4-7.3 12.3-125.6 7.9-159.8 4-34.2 3.8-152.5 8.3-159.8-4-9.1-15.2 28.9-29.2 45.8-34.4-35-29.5-51.1-70.4-51.1-101.8 0 0-33.4 54.1-44.9 52.7-5.4-.7-12.4-29.6 9.4-99.7 10.3-33 22-60.5 40.2-105.8-3.1-116.9 45.3-215 160.4-215 113.9 0 163.3 96.1 160.4 215 18.1 45.2 29.9 72.8 40.2 105.8 21.7 70.1 14.6 99.1 9.3 99.7z" } }] }, "name": "qq-square", "theme": "filled" };
	exports.default = QqSquareFilled;
	});

	var QqSquareFilledSvg = unwrapExports(QqSquareFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var QqSquareFilled = function QqSquareFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: QqSquareFilledSvg
	  }));
	};

	QqSquareFilled.displayName = 'QqSquareFilled';
	var QqSquareFilled$1 = /*#__PURE__*/React.forwardRef(QqSquareFilled);

	var QrcodeOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var QrcodeOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M468 128H160c-17.7 0-32 14.3-32 32v308c0 4.4 3.6 8 8 8h332c4.4 0 8-3.6 8-8V136c0-4.4-3.6-8-8-8zm-56 284H192V192h220v220zm-138-74h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm194 210H136c-4.4 0-8 3.6-8 8v308c0 17.7 14.3 32 32 32h308c4.4 0 8-3.6 8-8V556c0-4.4-3.6-8-8-8zm-56 284H192V612h220v220zm-138-74h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm590-630H556c-4.4 0-8 3.6-8 8v332c0 4.4 3.6 8 8 8h332c4.4 0 8-3.6 8-8V160c0-17.7-14.3-32-32-32zm-32 284H612V192h220v220zm-138-74h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm194 210h-48c-4.4 0-8 3.6-8 8v134h-78V556c0-4.4-3.6-8-8-8H556c-4.4 0-8 3.6-8 8v332c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V644h78v102c0 4.4 3.6 8 8 8h190c4.4 0 8-3.6 8-8V556c0-4.4-3.6-8-8-8zM746 832h-48c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8zm142 0h-48c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8z" } }] }, "name": "qrcode", "theme": "outlined" };
	exports.default = QrcodeOutlined;
	});

	var QrcodeOutlinedSvg = unwrapExports(QrcodeOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var QrcodeOutlined = function QrcodeOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: QrcodeOutlinedSvg
	  }));
	};

	QrcodeOutlined.displayName = 'QrcodeOutlined';
	var QrcodeOutlined$1 = /*#__PURE__*/React.forwardRef(QrcodeOutlined);

	var QuestionCircleFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var QuestionCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 708c-22.1 0-40-17.9-40-40s17.9-40 40-40 40 17.9 40 40-17.9 40-40 40zm62.9-219.5a48.3 48.3 0 00-30.9 44.8V620c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8v-21.5c0-23.1 6.7-45.9 19.9-64.9 12.9-18.6 30.9-32.8 52.1-40.9 34-13.1 56-41.6 56-72.7 0-44.1-43.1-80-96-80s-96 35.9-96 80v7.6c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V420c0-39.3 17.2-76 48.4-103.3C430.4 290.4 470 276 512 276s81.6 14.5 111.6 40.7C654.8 344 672 380.7 672 420c0 57.8-38.1 109.8-97.1 132.5z" } }] }, "name": "question-circle", "theme": "filled" };
	exports.default = QuestionCircleFilled;
	});

	var QuestionCircleFilledSvg = unwrapExports(QuestionCircleFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var QuestionCircleFilled = function QuestionCircleFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: QuestionCircleFilledSvg
	  }));
	};

	QuestionCircleFilled.displayName = 'QuestionCircleFilled';
	var QuestionCircleFilled$1 = /*#__PURE__*/React.forwardRef(QuestionCircleFilled);

	var QuestionCircleOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var QuestionCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z" } }, { "tag": "path", "attrs": { "d": "M623.6 316.7C593.6 290.4 554 276 512 276s-81.6 14.5-111.6 40.7C369.2 344 352 380.7 352 420v7.6c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V420c0-44.1 43.1-80 96-80s96 35.9 96 80c0 31.1-22 59.6-56.1 72.7-21.2 8.1-39.2 22.3-52.1 40.9-13.1 19-19.9 41.8-19.9 64.9V620c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8v-22.7a48.3 48.3 0 0130.9-44.8c59-22.7 97.1-74.7 97.1-132.5.1-39.3-17.1-76-48.3-103.3zM472 732a40 40 0 1080 0 40 40 0 10-80 0z" } }] }, "name": "question-circle", "theme": "outlined" };
	exports.default = QuestionCircleOutlined;
	});

	var QuestionCircleOutlinedSvg = unwrapExports(QuestionCircleOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var QuestionCircleOutlined = function QuestionCircleOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: QuestionCircleOutlinedSvg
	  }));
	};

	QuestionCircleOutlined.displayName = 'QuestionCircleOutlined';
	var QuestionCircleOutlined$1 = /*#__PURE__*/React.forwardRef(QuestionCircleOutlined);

	var QuestionCircleTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var QuestionCircleTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm0 632c-22.1 0-40-17.9-40-40s17.9-40 40-40 40 17.9 40 40-17.9 40-40 40zm62.9-219.5a48.3 48.3 0 00-30.9 44.8V620c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8v-21.5c0-23.1 6.7-45.9 19.9-64.9 12.9-18.6 30.9-32.8 52.1-40.9 34-13.1 56-41.6 56-72.7 0-44.1-43.1-80-96-80s-96 35.9-96 80v7.6c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V420c0-39.3 17.2-76 48.4-103.3C430.4 290.4 470 276 512 276s81.6 14.5 111.6 40.7C654.8 344 672 380.7 672 420c0 57.8-38.1 109.8-97.1 132.5z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M472 732a40 40 0 1080 0 40 40 0 10-80 0zm151.6-415.3C593.6 290.5 554 276 512 276s-81.6 14.4-111.6 40.7C369.2 344 352 380.7 352 420v7.6c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V420c0-44.1 43.1-80 96-80s96 35.9 96 80c0 31.1-22 59.6-56 72.7-21.2 8.1-39.2 22.3-52.1 40.9-13.2 19-19.9 41.8-19.9 64.9V620c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8v-22.7a48.3 48.3 0 0130.9-44.8c59-22.7 97.1-74.7 97.1-132.5 0-39.3-17.2-76-48.4-103.3z", "fill": primaryColor } }] }; }, "name": "question-circle", "theme": "twotone" };
	exports.default = QuestionCircleTwoTone;
	});

	var QuestionCircleTwoToneSvg = unwrapExports(QuestionCircleTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var QuestionCircleTwoTone = function QuestionCircleTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: QuestionCircleTwoToneSvg
	  }));
	};

	QuestionCircleTwoTone.displayName = 'QuestionCircleTwoTone';
	var QuestionCircleTwoTone$1 = /*#__PURE__*/React.forwardRef(QuestionCircleTwoTone);

	var QuestionOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var QuestionOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M764 280.9c-14-30.6-33.9-58.1-59.3-81.6C653.1 151.4 584.6 125 512 125s-141.1 26.4-192.7 74.2c-25.4 23.6-45.3 51-59.3 81.7-14.6 32-22 65.9-22 100.9v27c0 6.2 5 11.2 11.2 11.2h54c6.2 0 11.2-5 11.2-11.2v-27c0-99.5 88.6-180.4 197.6-180.4s197.6 80.9 197.6 180.4c0 40.8-14.5 79.2-42 111.2-27.2 31.7-65.6 54.4-108.1 64-24.3 5.5-46.2 19.2-61.7 38.8a110.85 110.85 0 00-23.9 68.6v31.4c0 6.2 5 11.2 11.2 11.2h54c6.2 0 11.2-5 11.2-11.2v-31.4c0-15.7 10.9-29.5 26-32.9 58.4-13.2 111.4-44.7 149.3-88.7 19.1-22.3 34-47.1 44.3-74 10.7-27.9 16.1-57.2 16.1-87 0-35-7.4-69-22-100.9zM512 787c-30.9 0-56 25.1-56 56s25.1 56 56 56 56-25.1 56-56-25.1-56-56-56z" } }] }, "name": "question", "theme": "outlined" };
	exports.default = QuestionOutlined;
	});

	var QuestionOutlinedSvg = unwrapExports(QuestionOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var QuestionOutlined = function QuestionOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: QuestionOutlinedSvg
	  }));
	};

	QuestionOutlined.displayName = 'QuestionOutlined';
	var QuestionOutlined$1 = /*#__PURE__*/React.forwardRef(QuestionOutlined);

	var RadarChartOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var RadarChartOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M926.8 397.1l-396-288a31.81 31.81 0 00-37.6 0l-396 288a31.99 31.99 0 00-11.6 35.8l151.3 466a32 32 0 0030.4 22.1h489.5c13.9 0 26.1-8.9 30.4-22.1l151.3-466c4.2-13.2-.5-27.6-11.7-35.8zM838.6 417l-98.5 32-200-144.7V199.9L838.6 417zM466 567.2l-89.1 122.3-55.2-169.2L466 567.2zm-116.3-96.8L484 373.3v140.8l-134.3-43.7zM512 599.2l93.9 128.9H418.1L512 599.2zm28.1-225.9l134.2 97.1L540.1 514V373.3zM558 567.2l144.3-46.9-55.2 169.2L558 567.2zm-74-367.3v104.4L283.9 449l-98.5-32L484 199.9zM169.3 470.8l86.5 28.1 80.4 246.4-53.8 73.9-113.1-348.4zM327.1 853l50.3-69h269.3l50.3 69H327.1zm414.5-33.8l-53.8-73.9 80.4-246.4 86.5-28.1-113.1 348.4z" } }] }, "name": "radar-chart", "theme": "outlined" };
	exports.default = RadarChartOutlined;
	});

	var RadarChartOutlinedSvg = unwrapExports(RadarChartOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var RadarChartOutlined = function RadarChartOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: RadarChartOutlinedSvg
	  }));
	};

	RadarChartOutlined.displayName = 'RadarChartOutlined';
	var RadarChartOutlined$1 = /*#__PURE__*/React.forwardRef(RadarChartOutlined);

	var RadiusBottomleftOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var RadiusBottomleftOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M712 824h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm2-696h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM136 374h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm0-174h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm752 624h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-174h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-174h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-174h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-174h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-348 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-230 72h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm230 624H358c-87.3 0-158-70.7-158-158V484c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v182c0 127 103 230 230 230h182c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8z" } }] }, "name": "radius-bottomleft", "theme": "outlined" };
	exports.default = RadiusBottomleftOutlined;
	});

	var RadiusBottomleftOutlinedSvg = unwrapExports(RadiusBottomleftOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var RadiusBottomleftOutlined = function RadiusBottomleftOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: RadiusBottomleftOutlinedSvg
	  }));
	};

	RadiusBottomleftOutlined.displayName = 'RadiusBottomleftOutlined';
	var RadiusBottomleftOutlined$1 = /*#__PURE__*/React.forwardRef(RadiusBottomleftOutlined);

	var RadiusBottomrightOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var RadiusBottomrightOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M368 824h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-58-624h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm578 102h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-174h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM192 824h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-174h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-174h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-174h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-174h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm292 72h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm174 0h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm230 276h-56c-4.4 0-8 3.6-8 8v182c0 87.3-70.7 158-158 158H484c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h182c127 0 230-103 230-230V484c0-4.4-3.6-8-8-8z" } }] }, "name": "radius-bottomright", "theme": "outlined" };
	exports.default = RadiusBottomrightOutlined;
	});

	var RadiusBottomrightOutlinedSvg = unwrapExports(RadiusBottomrightOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var RadiusBottomrightOutlined = function RadiusBottomrightOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: RadiusBottomrightOutlinedSvg
	  }));
	};

	RadiusBottomrightOutlined.displayName = 'RadiusBottomrightOutlined';
	var RadiusBottomrightOutlined$1 = /*#__PURE__*/React.forwardRef(RadiusBottomrightOutlined);

	var RadiusSettingOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var RadiusSettingOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M396 140h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-44 684h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm524-204h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM192 344h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 160h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 160h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 160h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm320 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm160 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm140-284c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V370c0-127-103-230-230-230H484c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h170c87.3 0 158 70.7 158 158v170zM236 96H92c-4.4 0-8 3.6-8 8v144c0 4.4 3.6 8 8 8h144c4.4 0 8-3.6 8-8V104c0-4.4-3.6-8-8-8zm-48 101.6c0 1.3-1.1 2.4-2.4 2.4h-43.2c-1.3 0-2.4-1.1-2.4-2.4v-43.2c0-1.3 1.1-2.4 2.4-2.4h43.2c1.3 0 2.4 1.1 2.4 2.4v43.2zM920 780H776c-4.4 0-8 3.6-8 8v144c0 4.4 3.6 8 8 8h144c4.4 0 8-3.6 8-8V788c0-4.4-3.6-8-8-8zm-48 101.6c0 1.3-1.1 2.4-2.4 2.4h-43.2c-1.3 0-2.4-1.1-2.4-2.4v-43.2c0-1.3 1.1-2.4 2.4-2.4h43.2c1.3 0 2.4 1.1 2.4 2.4v43.2z" } }] }, "name": "radius-setting", "theme": "outlined" };
	exports.default = RadiusSettingOutlined;
	});

	var RadiusSettingOutlinedSvg = unwrapExports(RadiusSettingOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var RadiusSettingOutlined = function RadiusSettingOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: RadiusSettingOutlinedSvg
	  }));
	};

	RadiusSettingOutlined.displayName = 'RadiusSettingOutlined';
	var RadiusSettingOutlined$1 = /*#__PURE__*/React.forwardRef(RadiusSettingOutlined);

	var RadiusUpleftOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var RadiusUpleftOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M656 200h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm58 624h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM192 650h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 174h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm696-696h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 174h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 174h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 174h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 174h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-348 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-174 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm174-696H358c-127 0-230 103-230 230v182c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V358c0-87.3 70.7-158 158-158h182c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8z" } }] }, "name": "radius-upleft", "theme": "outlined" };
	exports.default = RadiusUpleftOutlined;
	});

	var RadiusUpleftOutlinedSvg = unwrapExports(RadiusUpleftOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var RadiusUpleftOutlined = function RadiusUpleftOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: RadiusUpleftOutlinedSvg
	  }));
	};

	RadiusUpleftOutlined.displayName = 'RadiusUpleftOutlined';
	var RadiusUpleftOutlined$1 = /*#__PURE__*/React.forwardRef(RadiusUpleftOutlined);

	var RadiusUprightOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var RadiusUprightOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M368 128h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-2 696h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm522-174h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 174h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM192 128h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 174h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 174h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 174h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 174h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm348 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm174 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-48-696H484c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h182c87.3 0 158 70.7 158 158v182c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V358c0-127-103-230-230-230z" } }] }, "name": "radius-upright", "theme": "outlined" };
	exports.default = RadiusUprightOutlined;
	});

	var RadiusUprightOutlinedSvg = unwrapExports(RadiusUprightOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var RadiusUprightOutlined = function RadiusUprightOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: RadiusUprightOutlinedSvg
	  }));
	};

	RadiusUprightOutlined.displayName = 'RadiusUprightOutlined';
	var RadiusUprightOutlined$1 = /*#__PURE__*/React.forwardRef(RadiusUprightOutlined);

	var ReadFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ReadFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M928 161H699.2c-49.1 0-97.1 14.1-138.4 40.7L512 233l-48.8-31.3A255.2 255.2 0 00324.8 161H96c-17.7 0-32 14.3-32 32v568c0 17.7 14.3 32 32 32h228.8c49.1 0 97.1 14.1 138.4 40.7l44.4 28.6c1.3.8 2.8 1.3 4.3 1.3s3-.4 4.3-1.3l44.4-28.6C602 807.1 650.1 793 699.2 793H928c17.7 0 32-14.3 32-32V193c0-17.7-14.3-32-32-32zM404 553.5c0 4.1-3.2 7.5-7.1 7.5H211.1c-3.9 0-7.1-3.4-7.1-7.5v-45c0-4.1 3.2-7.5 7.1-7.5h185.7c3.9 0 7.1 3.4 7.1 7.5v45zm0-140c0 4.1-3.2 7.5-7.1 7.5H211.1c-3.9 0-7.1-3.4-7.1-7.5v-45c0-4.1 3.2-7.5 7.1-7.5h185.7c3.9 0 7.1 3.4 7.1 7.5v45zm416 140c0 4.1-3.2 7.5-7.1 7.5H627.1c-3.9 0-7.1-3.4-7.1-7.5v-45c0-4.1 3.2-7.5 7.1-7.5h185.7c3.9 0 7.1 3.4 7.1 7.5v45zm0-140c0 4.1-3.2 7.5-7.1 7.5H627.1c-3.9 0-7.1-3.4-7.1-7.5v-45c0-4.1 3.2-7.5 7.1-7.5h185.7c3.9 0 7.1 3.4 7.1 7.5v45z" } }] }, "name": "read", "theme": "filled" };
	exports.default = ReadFilled;
	});

	var ReadFilledSvg = unwrapExports(ReadFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var ReadFilled = function ReadFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ReadFilledSvg
	  }));
	};

	ReadFilled.displayName = 'ReadFilled';
	var ReadFilled$1 = /*#__PURE__*/React.forwardRef(ReadFilled);

	var ReadOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ReadOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M928 161H699.2c-49.1 0-97.1 14.1-138.4 40.7L512 233l-48.8-31.3A255.2 255.2 0 00324.8 161H96c-17.7 0-32 14.3-32 32v568c0 17.7 14.3 32 32 32h228.8c49.1 0 97.1 14.1 138.4 40.7l44.4 28.6c1.3.8 2.8 1.3 4.3 1.3s3-.4 4.3-1.3l44.4-28.6C602 807.1 650.1 793 699.2 793H928c17.7 0 32-14.3 32-32V193c0-17.7-14.3-32-32-32zM324.8 721H136V233h188.8c35.4 0 69.8 10.1 99.5 29.2l48.8 31.3 6.9 4.5v462c-47.6-25.6-100.8-39-155.2-39zm563.2 0H699.2c-54.4 0-107.6 13.4-155.2 39V298l6.9-4.5 48.8-31.3c29.7-19.1 64.1-29.2 99.5-29.2H888v488zM396.9 361H211.1c-3.9 0-7.1 3.4-7.1 7.5v45c0 4.1 3.2 7.5 7.1 7.5h185.7c3.9 0 7.1-3.4 7.1-7.5v-45c.1-4.1-3.1-7.5-7-7.5zm223.1 7.5v45c0 4.1 3.2 7.5 7.1 7.5h185.7c3.9 0 7.1-3.4 7.1-7.5v-45c0-4.1-3.2-7.5-7.1-7.5H627.1c-3.9 0-7.1 3.4-7.1 7.5zM396.9 501H211.1c-3.9 0-7.1 3.4-7.1 7.5v45c0 4.1 3.2 7.5 7.1 7.5h185.7c3.9 0 7.1-3.4 7.1-7.5v-45c.1-4.1-3.1-7.5-7-7.5zm416 0H627.1c-3.9 0-7.1 3.4-7.1 7.5v45c0 4.1 3.2 7.5 7.1 7.5h185.7c3.9 0 7.1-3.4 7.1-7.5v-45c.1-4.1-3.1-7.5-7-7.5z" } }] }, "name": "read", "theme": "outlined" };
	exports.default = ReadOutlined;
	});

	var ReadOutlinedSvg = unwrapExports(ReadOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var ReadOutlined = function ReadOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ReadOutlinedSvg
	  }));
	};

	ReadOutlined.displayName = 'ReadOutlined';
	var ReadOutlined$1 = /*#__PURE__*/React.forwardRef(ReadOutlined);

	var ReconciliationFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ReconciliationFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M676 623c-18.8 0-34 15.2-34 34s15.2 34 34 34 34-15.2 34-34-15.2-34-34-34zm204-455H668c0-30.9-25.1-56-56-56h-80c-30.9 0-56 25.1-56 56H264c-17.7 0-32 14.3-32 32v200h-88c-17.7 0-32 14.3-32 32v448c0 17.7 14.3 32 32 32h336c17.7 0 32-14.3 32-32v-16h368c17.7 0 32-14.3 32-32V200c0-17.7-14.3-32-32-32zM448 848H176V616h272v232zm0-296H176v-88h272v88zm20-272v-48h72v-56h64v56h72v48H468zm180 168v56c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8v-56c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8zm28 301c-50.8 0-92-41.2-92-92s41.2-92 92-92 92 41.2 92 92-41.2 92-92 92zm92-245c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8v-96c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v96zm-92 61c-50.8 0-92 41.2-92 92s41.2 92 92 92 92-41.2 92-92-41.2-92-92-92zm0 126c-18.8 0-34-15.2-34-34s15.2-34 34-34 34 15.2 34 34-15.2 34-34 34z" } }] }, "name": "reconciliation", "theme": "filled" };
	exports.default = ReconciliationFilled;
	});

	var ReconciliationFilledSvg = unwrapExports(ReconciliationFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var ReconciliationFilled = function ReconciliationFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ReconciliationFilledSvg
	  }));
	};

	ReconciliationFilled.displayName = 'ReconciliationFilled';
	var ReconciliationFilled$1 = /*#__PURE__*/React.forwardRef(ReconciliationFilled);

	var ReconciliationOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ReconciliationOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M676 565c-50.8 0-92 41.2-92 92s41.2 92 92 92 92-41.2 92-92-41.2-92-92-92zm0 126c-18.8 0-34-15.2-34-34s15.2-34 34-34 34 15.2 34 34-15.2 34-34 34zm204-523H668c0-30.9-25.1-56-56-56h-80c-30.9 0-56 25.1-56 56H264c-17.7 0-32 14.3-32 32v200h-88c-17.7 0-32 14.3-32 32v448c0 17.7 14.3 32 32 32h336c17.7 0 32-14.3 32-32v-16h368c17.7 0 32-14.3 32-32V200c0-17.7-14.3-32-32-32zm-412 64h72v-56h64v56h72v48H468v-48zm-20 616H176V616h272v232zm0-296H176v-88h272v88zm392 240H512V432c0-17.7-14.3-32-32-32H304V240h100v104h336V240h100v552zM704 408v96c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8v-96c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8zM592 512h48c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8z" } }] }, "name": "reconciliation", "theme": "outlined" };
	exports.default = ReconciliationOutlined;
	});

	var ReconciliationOutlinedSvg = unwrapExports(ReconciliationOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var ReconciliationOutlined = function ReconciliationOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ReconciliationOutlinedSvg
	  }));
	};

	ReconciliationOutlined.displayName = 'ReconciliationOutlined';
	var ReconciliationOutlined$1 = /*#__PURE__*/React.forwardRef(ReconciliationOutlined);

	var ReconciliationTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ReconciliationTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M740 344H404V240H304v160h176c17.7 0 32 14.3 32 32v360h328V240H740v104zM584 448c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v56c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8v-56zm92 301c-50.8 0-92-41.2-92-92s41.2-92 92-92 92 41.2 92 92-41.2 92-92 92zm92-341v96c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8v-96c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M642 657a34 34 0 1068 0 34 34 0 10-68 0z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M592 512h48c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm112-104v96c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8v-96c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M880 168H668c0-30.9-25.1-56-56-56h-80c-30.9 0-56 25.1-56 56H264c-17.7 0-32 14.3-32 32v200h-88c-17.7 0-32 14.3-32 32v448c0 17.7 14.3 32 32 32h336c17.7 0 32-14.3 32-32v-16h368c17.7 0 32-14.3 32-32V200c0-17.7-14.3-32-32-32zm-412 64h72v-56h64v56h72v48H468v-48zm-20 616H176V616h272v232zm0-296H176v-88h272v88zm392 240H512V432c0-17.7-14.3-32-32-32H304V240h100v104h336V240h100v552z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M676 565c-50.8 0-92 41.2-92 92s41.2 92 92 92 92-41.2 92-92-41.2-92-92-92zm0 126c-18.8 0-34-15.2-34-34s15.2-34 34-34 34 15.2 34 34-15.2 34-34 34z", "fill": primaryColor } }] }; }, "name": "reconciliation", "theme": "twotone" };
	exports.default = ReconciliationTwoTone;
	});

	var ReconciliationTwoToneSvg = unwrapExports(ReconciliationTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var ReconciliationTwoTone = function ReconciliationTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ReconciliationTwoToneSvg
	  }));
	};

	ReconciliationTwoTone.displayName = 'ReconciliationTwoTone';
	var ReconciliationTwoTone$1 = /*#__PURE__*/React.forwardRef(ReconciliationTwoTone);

	var RedEnvelopeFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var RedEnvelopeFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M832 64H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V96c0-17.7-14.3-32-32-32zM647 470.4l-87.2 161h45.9c4.6 0 8.4 3.8 8.4 8.4v25.1c0 4.6-3.8 8.4-8.4 8.4h-63.3v28.6h63.3c4.6 0 8.4 3.8 8.4 8.4v25c.2 4.6-3.6 8.5-8.2 8.5h-63.3v49.9c0 4.6-3.8 8.4-8.4 8.4h-43.7c-4.6 0-8.4-3.8-8.4-8.4v-49.9h-63c-4.6 0-8.4-3.8-8.4-8.4v-25.1c0-4.6 3.8-8.4 8.4-8.4h63v-28.6h-63c-4.6 0-8.4-3.8-8.4-8.4v-25.1c0-4.6 3.8-8.4 8.4-8.4h45.4l-87.5-161c-2.2-4.1-.7-9.1 3.4-11.4 1.3-.6 2.6-1 3.9-1h48.8c3.2 0 6.1 1.8 7.5 4.6l71.9 141.8 71.9-141.9a8.5 8.5 0 017.5-4.6h47.8c4.6 0 8.4 3.8 8.4 8.4-.1 1.5-.5 2.9-1.1 4.1zM512.6 323L289 148h446L512.6 323z" } }] }, "name": "red-envelope", "theme": "filled" };
	exports.default = RedEnvelopeFilled;
	});

	var RedEnvelopeFilledSvg = unwrapExports(RedEnvelopeFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var RedEnvelopeFilled = function RedEnvelopeFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: RedEnvelopeFilledSvg
	  }));
	};

	RedEnvelopeFilled.displayName = 'RedEnvelopeFilled';
	var RedEnvelopeFilled$1 = /*#__PURE__*/React.forwardRef(RedEnvelopeFilled);

	var RedEnvelopeOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var RedEnvelopeOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M440.6 462.6a8.38 8.38 0 00-7.5-4.6h-48.8c-1.3 0-2.6.4-3.9 1a8.4 8.4 0 00-3.4 11.4l87.4 161.1H419c-4.6 0-8.4 3.8-8.4 8.4V665c0 4.6 3.8 8.4 8.4 8.4h63V702h-63c-4.6 0-8.4 3.8-8.4 8.4v25.1c0 4.6 3.8 8.4 8.4 8.4h63v49.9c0 4.6 3.8 8.4 8.4 8.4h43.7c4.6 0 8.4-3.8 8.4-8.4v-49.9h63.3c4.7 0 8.4-3.8 8.2-8.5v-25c0-4.6-3.8-8.4-8.4-8.4h-63.3v-28.6h63.3c4.6 0 8.4-3.8 8.4-8.4v-25.1c0-4.6-3.8-8.4-8.4-8.4h-45.9l87.2-161a8.45 8.45 0 00-7.4-12.4h-47.8c-3.1 0-6 1.8-7.5 4.6l-71.9 141.9-71.7-142zM832 64H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V96c0-17.7-14.3-32-32-32zm-40 824H232V193.1l260.3 204.1c11.6 9.1 27.9 9.1 39.5 0L792 193.1V888zm0-751.3h-31.7L512 331.3 263.7 136.7H232v-.7h560v.7z" } }] }, "name": "red-envelope", "theme": "outlined" };
	exports.default = RedEnvelopeOutlined;
	});

	var RedEnvelopeOutlinedSvg = unwrapExports(RedEnvelopeOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var RedEnvelopeOutlined = function RedEnvelopeOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: RedEnvelopeOutlinedSvg
	  }));
	};

	RedEnvelopeOutlined.displayName = 'RedEnvelopeOutlined';
	var RedEnvelopeOutlined$1 = /*#__PURE__*/React.forwardRef(RedEnvelopeOutlined);

	var RedEnvelopeTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var RedEnvelopeTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M832 64H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V96c0-17.7-14.3-32-32-32zm-40 824H232V193.1l260.3 204.1c11.6 9.1 27.9 9.1 39.5 0L792 193.1V888zm0-751.3h-31.7L512 331.3 263.7 136.7H232v-.7h560v.7z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M492.3 397.2L232 193.1V888h560V193.1L531.8 397.2a31.99 31.99 0 01-39.5 0zm99.4 60.9h47.8a8.45 8.45 0 017.4 12.4l-87.2 161h45.9c4.6 0 8.4 3.8 8.4 8.4V665c0 4.6-3.8 8.4-8.4 8.4h-63.3V702h63.3c4.6 0 8.4 3.8 8.4 8.4v25c.2 4.7-3.5 8.5-8.2 8.5h-63.3v49.9c0 4.6-3.8 8.4-8.4 8.4h-43.7c-4.6 0-8.4-3.8-8.4-8.4v-49.9h-63c-4.6 0-8.4-3.8-8.4-8.4v-25.1c0-4.6 3.8-8.4 8.4-8.4h63v-28.6h-63c-4.6 0-8.4-3.8-8.4-8.4v-25.1c0-4.6 3.8-8.4 8.4-8.4h45.4L377 470.4a8.4 8.4 0 013.4-11.4c1.3-.6 2.6-1 3.9-1h48.8c3.2 0 6.1 1.8 7.5 4.6l71.7 142 71.9-141.9a8.6 8.6 0 017.5-4.6z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M232 136.7h31.7L512 331.3l248.3-194.6H792v-.7H232z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M440.6 462.6a8.38 8.38 0 00-7.5-4.6h-48.8c-1.3 0-2.6.4-3.9 1a8.4 8.4 0 00-3.4 11.4l87.4 161.1H419c-4.6 0-8.4 3.8-8.4 8.4V665c0 4.6 3.8 8.4 8.4 8.4h63V702h-63c-4.6 0-8.4 3.8-8.4 8.4v25.1c0 4.6 3.8 8.4 8.4 8.4h63v49.9c0 4.6 3.8 8.4 8.4 8.4h43.7c4.6 0 8.4-3.8 8.4-8.4v-49.9h63.3c4.7 0 8.4-3.8 8.2-8.5v-25c0-4.6-3.8-8.4-8.4-8.4h-63.3v-28.6h63.3c4.6 0 8.4-3.8 8.4-8.4v-25.1c0-4.6-3.8-8.4-8.4-8.4h-45.9l87.2-161a8.45 8.45 0 00-7.4-12.4h-47.8c-3.1 0-6 1.8-7.5 4.6l-71.9 141.9-71.7-142z", "fill": primaryColor } }] }; }, "name": "red-envelope", "theme": "twotone" };
	exports.default = RedEnvelopeTwoTone;
	});

	var RedEnvelopeTwoToneSvg = unwrapExports(RedEnvelopeTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var RedEnvelopeTwoTone = function RedEnvelopeTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: RedEnvelopeTwoToneSvg
	  }));
	};

	RedEnvelopeTwoTone.displayName = 'RedEnvelopeTwoTone';
	var RedEnvelopeTwoTone$1 = /*#__PURE__*/React.forwardRef(RedEnvelopeTwoTone);

	var RedditCircleFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var RedditCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M584 548a36 36 0 1072 0 36 36 0 10-72 0zm144-108a35.9 35.9 0 00-32.5 20.6c18.8 14.3 34.4 30.7 45.9 48.8A35.98 35.98 0 00728 440zM512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm245 477.9c4.6 13.5 7 27.6 7 42.1 0 99.4-112.8 180-252 180s-252-80.6-252-180c0-14.5 2.4-28.6 7-42.1A72.01 72.01 0 01296 404c27.1 0 50.6 14.9 62.9 37 36.2-19.8 80.2-32.8 128.1-36.1l58.4-131.1c4.3-9.8 15.2-14.8 25.5-11.8l91.6 26.5a54.03 54.03 0 01101.6 25.6c0 29.8-24.2 54-54 54-23.5 0-43.5-15.1-50.9-36.1L577 308.3l-43 96.5c49.1 3 94.2 16.1 131.2 36.3 12.3-22.1 35.8-37 62.9-37 39.8 0 72 32.2 72 72-.1 29.3-17.8 54.6-43.1 65.8zm-171.3 83c-14.9 11.7-44.3 24.3-73.7 24.3s-58.9-12.6-73.7-24.3c-9.3-7.3-22.7-5.7-30 3.6-7.3 9.3-5.7 22.7 3.6 30 25.7 20.4 65 33.5 100.1 33.5 35.1 0 74.4-13.1 100.2-33.5 9.3-7.3 10.9-20.8 3.6-30a21.46 21.46 0 00-30.1-3.6zM296 440a35.98 35.98 0 00-13.4 69.4c11.5-18.1 27.1-34.5 45.9-48.8A35.9 35.9 0 00296 440zm72 108a36 36 0 1072 0 36 36 0 10-72 0z" } }] }, "name": "reddit-circle", "theme": "filled" };
	exports.default = RedditCircleFilled;
	});

	var RedditCircleFilledSvg = unwrapExports(RedditCircleFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var RedditCircleFilled = function RedditCircleFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: RedditCircleFilledSvg
	  }));
	};

	RedditCircleFilled.displayName = 'RedditCircleFilled';
	var RedditCircleFilled$1 = /*#__PURE__*/React.forwardRef(RedditCircleFilled);

	var RedditOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var RedditOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M288 568a56 56 0 10112 0 56 56 0 10-112 0zm338.7 119.7c-23.1 18.2-68.9 37.8-114.7 37.8s-91.6-19.6-114.7-37.8c-14.4-11.3-35.3-8.9-46.7 5.5s-8.9 35.3 5.5 46.7C396.3 771.6 457.5 792 512 792s115.7-20.4 155.9-52.1a33.25 33.25 0 10-41.2-52.2zM960 456c0-61.9-50.1-112-112-112-42.1 0-78.7 23.2-97.9 57.6-57.6-31.5-127.7-51.8-204.1-56.5L612.9 195l127.9 36.9c11.5 32.6 42.6 56.1 79.2 56.1 46.4 0 84-37.6 84-84s-37.6-84-84-84c-32 0-59.8 17.9-74 44.2L603.5 123a33.2 33.2 0 00-39.6 18.4l-90.8 203.9c-74.5 5.2-142.9 25.4-199.2 56.2A111.94 111.94 0 00176 344c-61.9 0-112 50.1-112 112 0 45.8 27.5 85.1 66.8 102.5-7.1 21-10.8 43-10.8 65.5 0 154.6 175.5 280 392 280s392-125.4 392-280c0-22.6-3.8-44.5-10.8-65.5C932.5 541.1 960 501.8 960 456zM820 172.5a31.5 31.5 0 110 63 31.5 31.5 0 010-63zM120 456c0-30.9 25.1-56 56-56a56 56 0 0150.6 32.1c-29.3 22.2-53.5 47.8-71.5 75.9a56.23 56.23 0 01-35.1-52zm392 381.5c-179.8 0-325.5-95.6-325.5-213.5S332.2 410.5 512 410.5 837.5 506.1 837.5 624 691.8 837.5 512 837.5zM868.8 508c-17.9-28.1-42.2-53.7-71.5-75.9 9-18.9 28.3-32.1 50.6-32.1 30.9 0 56 25.1 56 56 .1 23.5-14.5 43.7-35.1 52zM624 568a56 56 0 10112 0 56 56 0 10-112 0z" } }] }, "name": "reddit", "theme": "outlined" };
	exports.default = RedditOutlined;
	});

	var RedditOutlinedSvg = unwrapExports(RedditOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var RedditOutlined = function RedditOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: RedditOutlinedSvg
	  }));
	};

	RedditOutlined.displayName = 'RedditOutlined';
	var RedditOutlined$1 = /*#__PURE__*/React.forwardRef(RedditOutlined);

	var RedditSquareFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var RedditSquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M296 440a35.98 35.98 0 00-13.4 69.4c11.5-18.1 27.1-34.5 45.9-48.8A35.9 35.9 0 00296 440zm289.7 184.9c-14.9 11.7-44.3 24.3-73.7 24.3s-58.9-12.6-73.7-24.3c-9.3-7.3-22.7-5.7-30 3.6-7.3 9.3-5.7 22.7 3.6 30 25.7 20.4 65 33.5 100.1 33.5 35.1 0 74.4-13.1 100.2-33.5 9.3-7.3 10.9-20.8 3.6-30a21.46 21.46 0 00-30.1-3.6zM880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM757 541.9c4.6 13.5 7 27.6 7 42.1 0 99.4-112.8 180-252 180s-252-80.6-252-180c0-14.5 2.4-28.6 7-42.1A72.01 72.01 0 01296 404c27.1 0 50.6 14.9 62.9 37 36.2-19.8 80.2-32.8 128.1-36.1l58.4-131.1c4.3-9.8 15.2-14.8 25.5-11.8l91.6 26.5a54.03 54.03 0 01101.6 25.6c0 29.8-24.2 54-54 54-23.5 0-43.5-15.1-50.9-36.1L577 308.3l-43 96.5c49.1 3 94.2 16.1 131.2 36.3 12.3-22.1 35.8-37 62.9-37 39.8 0 72 32.2 72 72-.1 29.3-17.8 54.6-43.1 65.8zM584 548a36 36 0 1072 0 36 36 0 10-72 0zm144-108a35.9 35.9 0 00-32.5 20.6c18.8 14.3 34.4 30.7 45.9 48.8A35.98 35.98 0 00728 440zM368 548a36 36 0 1072 0 36 36 0 10-72 0z" } }] }, "name": "reddit-square", "theme": "filled" };
	exports.default = RedditSquareFilled;
	});

	var RedditSquareFilledSvg = unwrapExports(RedditSquareFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var RedditSquareFilled = function RedditSquareFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: RedditSquareFilledSvg
	  }));
	};

	RedditSquareFilled.displayName = 'RedditSquareFilled';
	var RedditSquareFilled$1 = /*#__PURE__*/React.forwardRef(RedditSquareFilled);

	var RedoOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var RedoOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M758.2 839.1C851.8 765.9 912 651.9 912 523.9 912 303 733.5 124.3 512.6 124 291.4 123.7 112 302.8 112 523.9c0 125.2 57.5 236.9 147.6 310.2 3.5 2.8 8.6 2.2 11.4-1.3l39.4-50.5c2.7-3.4 2.1-8.3-1.2-11.1-8.1-6.6-15.9-13.7-23.4-21.2a318.64 318.64 0 01-68.6-101.7C200.4 609 192 567.1 192 523.9s8.4-85.1 25.1-124.5c16.1-38.1 39.2-72.3 68.6-101.7 29.4-29.4 63.6-52.5 101.7-68.6C426.9 212.4 468.8 204 512 204s85.1 8.4 124.5 25.1c38.1 16.1 72.3 39.2 101.7 68.6 29.4 29.4 52.5 63.6 68.6 101.7 16.7 39.4 25.1 81.3 25.1 124.5s-8.4 85.1-25.1 124.5a318.64 318.64 0 01-68.6 101.7c-9.3 9.3-19.1 18-29.3 26L668.2 724a8 8 0 00-14.1 3l-39.6 162.2c-1.2 5 2.6 9.9 7.7 9.9l167 .8c6.7 0 10.5-7.7 6.3-12.9l-37.3-47.9z" } }] }, "name": "redo", "theme": "outlined" };
	exports.default = RedoOutlined;
	});

	var RedoOutlinedSvg = unwrapExports(RedoOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var RedoOutlined = function RedoOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: RedoOutlinedSvg
	  }));
	};

	RedoOutlined.displayName = 'RedoOutlined';
	var RedoOutlined$1 = /*#__PURE__*/React.forwardRef(RedoOutlined);

	var ReloadOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var ReloadOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M909.1 209.3l-56.4 44.1C775.8 155.1 656.2 92 521.9 92 290 92 102.3 279.5 102 511.5 101.7 743.7 289.8 932 521.9 932c181.3 0 335.8-115 394.6-276.1 1.5-4.2-.7-8.9-4.9-10.3l-56.7-19.5a8 8 0 00-10.1 4.8c-1.8 5-3.8 10-5.9 14.9-17.3 41-42.1 77.8-73.7 109.4A344.77 344.77 0 01655.9 829c-42.3 17.9-87.4 27-133.8 27-46.5 0-91.5-9.1-133.8-27A341.5 341.5 0 01279 755.2a342.16 342.16 0 01-73.7-109.4c-17.9-42.4-27-87.4-27-133.9s9.1-91.5 27-133.9c17.3-41 42.1-77.8 73.7-109.4 31.6-31.6 68.4-56.4 109.3-73.8 42.3-17.9 87.4-27 133.8-27 46.5 0 91.5 9.1 133.8 27a341.5 341.5 0 01109.3 73.8c9.9 9.9 19.2 20.4 27.8 31.4l-60.2 47a8 8 0 003 14.1l175.6 43c5 1.2 9.9-2.6 9.9-7.7l.8-180.9c-.1-6.6-7.8-10.3-13-6.2z" } }] }, "name": "reload", "theme": "outlined" };
	exports.default = ReloadOutlined;
	});

	var ReloadOutlinedSvg = unwrapExports(ReloadOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var ReloadOutlined = function ReloadOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: ReloadOutlinedSvg
	  }));
	};

	ReloadOutlined.displayName = 'ReloadOutlined';
	var ReloadOutlined$1 = /*#__PURE__*/React.forwardRef(ReloadOutlined);

	var RestFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var RestFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M832 256h-28.1l-35.7-120.9c-4-13.7-16.5-23.1-30.7-23.1h-451c-14.3 0-26.8 9.4-30.7 23.1L220.1 256H192c-17.7 0-32 14.3-32 32v28c0 4.4 3.6 8 8 8h45.8l47.7 558.7a32 32 0 0031.9 29.3h429.2a32 32 0 0031.9-29.3L802.2 324H856c4.4 0 8-3.6 8-8v-28c0-17.7-14.3-32-32-32zM508 704c-79.5 0-144-64.5-144-144s64.5-144 144-144 144 64.5 144 144-64.5 144-144 144zM291 256l22.4-76h397.2l22.4 76H291zm137 304a80 80 0 10160 0 80 80 0 10-160 0z" } }] }, "name": "rest", "theme": "filled" };
	exports.default = RestFilled;
	});

	var RestFilledSvg = unwrapExports(RestFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var RestFilled = function RestFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: RestFilledSvg
	  }));
	};

	RestFilled.displayName = 'RestFilled';
	var RestFilled$1 = /*#__PURE__*/React.forwardRef(RestFilled);

	var RestOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var RestOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M508 704c79.5 0 144-64.5 144-144s-64.5-144-144-144-144 64.5-144 144 64.5 144 144 144zm0-224c44.2 0 80 35.8 80 80s-35.8 80-80 80-80-35.8-80-80 35.8-80 80-80z" } }, { "tag": "path", "attrs": { "d": "M832 256h-28.1l-35.7-120.9c-4-13.7-16.5-23.1-30.7-23.1h-451c-14.3 0-26.8 9.4-30.7 23.1L220.1 256H192c-17.7 0-32 14.3-32 32v28c0 4.4 3.6 8 8 8h45.8l47.7 558.7a32 32 0 0031.9 29.3h429.2a32 32 0 0031.9-29.3L802.2 324H856c4.4 0 8-3.6 8-8v-28c0-17.7-14.3-32-32-32zm-518.6-76h397.2l22.4 76H291l22.4-76zm376.2 664H326.4L282 324h451.9l-44.3 520z" } }] }, "name": "rest", "theme": "outlined" };
	exports.default = RestOutlined;
	});

	var RestOutlinedSvg = unwrapExports(RestOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var RestOutlined = function RestOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: RestOutlinedSvg
	  }));
	};

	RestOutlined.displayName = 'RestOutlined';
	var RestOutlined$1 = /*#__PURE__*/React.forwardRef(RestOutlined);

	var RestTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var RestTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M326.4 844h363.2l44.3-520H282l44.4 520zM508 416c79.5 0 144 64.5 144 144s-64.5 144-144 144-144-64.5-144-144 64.5-144 144-144z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M508 704c79.5 0 144-64.5 144-144s-64.5-144-144-144-144 64.5-144 144 64.5 144 144 144zm0-224c44.2 0 80 35.8 80 80s-35.8 80-80 80-80-35.8-80-80 35.8-80 80-80z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M832 256h-28.1l-35.7-120.9c-4-13.7-16.5-23.1-30.7-23.1h-451c-14.3 0-26.8 9.4-30.7 23.1L220.1 256H192c-17.7 0-32 14.3-32 32v28c0 4.4 3.6 8 8 8h45.8l47.7 558.7a32 32 0 0031.9 29.3h429.2a32 32 0 0031.9-29.3L802.2 324H856c4.4 0 8-3.6 8-8v-28c0-17.7-14.3-32-32-32zm-518.6-76h397.2l22.4 76H291l22.4-76zm376.2 664H326.4L282 324h451.9l-44.3 520z", "fill": primaryColor } }] }; }, "name": "rest", "theme": "twotone" };
	exports.default = RestTwoTone;
	});

	var RestTwoToneSvg = unwrapExports(RestTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var RestTwoTone = function RestTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: RestTwoToneSvg
	  }));
	};

	RestTwoTone.displayName = 'RestTwoTone';
	var RestTwoTone$1 = /*#__PURE__*/React.forwardRef(RestTwoTone);

	var RetweetOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var RetweetOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M136 552h63.6c4.4 0 8-3.6 8-8V288.7h528.6v72.6c0 1.9.6 3.7 1.8 5.2a8.3 8.3 0 0011.7 1.4L893 255.4c4.3-5 3.6-10.3 0-13.2L749.7 129.8a8.22 8.22 0 00-5.2-1.8c-4.6 0-8.4 3.8-8.4 8.4V209H199.7c-39.5 0-71.7 32.2-71.7 71.8V544c0 4.4 3.6 8 8 8zm752-80h-63.6c-4.4 0-8 3.6-8 8v255.3H287.8v-72.6c0-1.9-.6-3.7-1.8-5.2a8.3 8.3 0 00-11.7-1.4L131 768.6c-4.3 5-3.6 10.3 0 13.2l143.3 112.4c1.5 1.2 3.3 1.8 5.2 1.8 4.6 0 8.4-3.8 8.4-8.4V815h536.6c39.5 0 71.7-32.2 71.7-71.8V480c-.2-4.4-3.8-8-8.2-8z" } }] }, "name": "retweet", "theme": "outlined" };
	exports.default = RetweetOutlined;
	});

	var RetweetOutlinedSvg = unwrapExports(RetweetOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var RetweetOutlined = function RetweetOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: RetweetOutlinedSvg
	  }));
	};

	RetweetOutlined.displayName = 'RetweetOutlined';
	var RetweetOutlined$1 = /*#__PURE__*/React.forwardRef(RetweetOutlined);

	var RightCircleFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var RightCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm154.7 454.5l-246 178c-5.3 3.8-12.7 0-12.7-6.5v-46.9c0-10.2 4.9-19.9 13.2-25.9L566.6 512 421.2 406.8c-8.3-6-13.2-15.6-13.2-25.9V334c0-6.5 7.4-10.3 12.7-6.5l246 178c4.4 3.2 4.4 9.8 0 13z" } }] }, "name": "right-circle", "theme": "filled" };
	exports.default = RightCircleFilled;
	});

	var RightCircleFilledSvg = unwrapExports(RightCircleFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var RightCircleFilled = function RightCircleFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: RightCircleFilledSvg
	  }));
	};

	RightCircleFilled.displayName = 'RightCircleFilled';
	var RightCircleFilled$1 = /*#__PURE__*/React.forwardRef(RightCircleFilled);

	var RightCircleOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var RightCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M666.7 505.5l-246-178A8 8 0 00408 334v46.9c0 10.2 4.9 19.9 13.2 25.9L566.6 512 421.2 617.2c-8.3 6-13.2 15.6-13.2 25.9V690c0 6.5 7.4 10.3 12.7 6.5l246-178c4.4-3.2 4.4-9.8 0-13z" } }, { "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z" } }] }, "name": "right-circle", "theme": "outlined" };
	exports.default = RightCircleOutlined;
	});

	var RightCircleOutlinedSvg = unwrapExports(RightCircleOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var RightCircleOutlined = function RightCircleOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: RightCircleOutlinedSvg
	  }));
	};

	RightCircleOutlined.displayName = 'RightCircleOutlined';
	var RightCircleOutlined$1 = /*#__PURE__*/React.forwardRef(RightCircleOutlined);

	var RightCircleTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var RightCircleTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm154.7 378.4l-246 178c-5.3 3.8-12.7 0-12.7-6.5V643c0-10.2 4.9-19.9 13.2-25.9L566.6 512 421.2 406.8c-8.3-6-13.2-15.6-13.2-25.9V334c0-6.5 7.4-10.3 12.7-6.5l246 178c4.4 3.2 4.4 9.7 0 12.9z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M666.7 505.5l-246-178c-5.3-3.8-12.7 0-12.7 6.5v46.9c0 10.3 4.9 19.9 13.2 25.9L566.6 512 421.2 617.1c-8.3 6-13.2 15.7-13.2 25.9v46.9c0 6.5 7.4 10.3 12.7 6.5l246-178c4.4-3.2 4.4-9.7 0-12.9z", "fill": primaryColor } }] }; }, "name": "right-circle", "theme": "twotone" };
	exports.default = RightCircleTwoTone;
	});

	var RightCircleTwoToneSvg = unwrapExports(RightCircleTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var RightCircleTwoTone = function RightCircleTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: RightCircleTwoToneSvg
	  }));
	};

	RightCircleTwoTone.displayName = 'RightCircleTwoTone';
	var RightCircleTwoTone$1 = /*#__PURE__*/React.forwardRef(RightCircleTwoTone);

	var RightOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var RightOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M765.7 486.8L314.9 134.7A7.97 7.97 0 00302 141v77.3c0 4.9 2.3 9.6 6.1 12.6l360 281.1-360 281.1c-3.9 3-6.1 7.7-6.1 12.6V883c0 6.7 7.7 10.4 12.9 6.3l450.8-352.1a31.96 31.96 0 000-50.4z" } }] }, "name": "right", "theme": "outlined" };
	exports.default = RightOutlined;
	});

	var RightOutlinedSvg = unwrapExports(RightOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var RightOutlined = function RightOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: RightOutlinedSvg
	  }));
	};

	RightOutlined.displayName = 'RightOutlined';
	var RightOutlined$1 = /*#__PURE__*/React.forwardRef(RightOutlined);

	var RightSquareFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var RightSquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM658.7 518.5l-246 178c-5.3 3.8-12.7 0-12.7-6.5v-46.9c0-10.2 4.9-19.9 13.2-25.9L558.6 512 413.2 406.8c-8.3-6-13.2-15.6-13.2-25.9V334c0-6.5 7.4-10.3 12.7-6.5l246 178c4.4 3.2 4.4 9.8 0 13z" } }] }, "name": "right-square", "theme": "filled" };
	exports.default = RightSquareFilled;
	});

	var RightSquareFilledSvg = unwrapExports(RightSquareFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var RightSquareFilled = function RightSquareFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: RightSquareFilledSvg
	  }));
	};

	RightSquareFilled.displayName = 'RightSquareFilled';
	var RightSquareFilled$1 = /*#__PURE__*/React.forwardRef(RightSquareFilled);

	var RightSquareOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var RightSquareOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M412.7 696.5l246-178c4.4-3.2 4.4-9.7 0-12.9l-246-178c-5.3-3.8-12.7 0-12.7 6.5V381c0 10.2 4.9 19.9 13.2 25.9L558.6 512 413.2 617.2c-8.3 6-13.2 15.6-13.2 25.9V690c0 6.5 7.4 10.3 12.7 6.5z" } }, { "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z" } }] }, "name": "right-square", "theme": "outlined" };
	exports.default = RightSquareOutlined;
	});

	var RightSquareOutlinedSvg = unwrapExports(RightSquareOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var RightSquareOutlined = function RightSquareOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: RightSquareOutlinedSvg
	  }));
	};

	RightSquareOutlined.displayName = 'RightSquareOutlined';
	var RightSquareOutlined$1 = /*#__PURE__*/React.forwardRef(RightSquareOutlined);

	var RightSquareTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var RightSquareTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M184 840h656V184H184v656zm216-196.9c0-10.2 4.9-19.9 13.2-25.9L558.6 512 413.2 406.8c-8.3-6-13.2-15.6-13.2-25.9V334c0-6.5 7.4-10.3 12.7-6.5l246 178c4.4 3.2 4.4 9.7 0 12.9l-246 178c-5.3 3.9-12.7.1-12.7-6.4v-46.9z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M412.7 696.4l246-178c4.4-3.2 4.4-9.7 0-12.9l-246-178c-5.3-3.8-12.7 0-12.7 6.5v46.9c0 10.3 4.9 19.9 13.2 25.9L558.6 512 413.2 617.2c-8.3 6-13.2 15.7-13.2 25.9V690c0 6.5 7.4 10.3 12.7 6.4z", "fill": primaryColor } }] }; }, "name": "right-square", "theme": "twotone" };
	exports.default = RightSquareTwoTone;
	});

	var RightSquareTwoToneSvg = unwrapExports(RightSquareTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var RightSquareTwoTone = function RightSquareTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: RightSquareTwoToneSvg
	  }));
	};

	RightSquareTwoTone.displayName = 'RightSquareTwoTone';
	var RightSquareTwoTone$1 = /*#__PURE__*/React.forwardRef(RightSquareTwoTone);

	var RiseOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var RiseOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M917 211.1l-199.2 24c-6.6.8-9.4 8.9-4.7 13.6l59.3 59.3-226 226-101.8-101.7c-6.3-6.3-16.4-6.2-22.6 0L100.3 754.1a8.03 8.03 0 000 11.3l45 45.2c3.1 3.1 8.2 3.1 11.3 0L433.3 534 535 635.7c6.3 6.2 16.4 6.2 22.6 0L829 364.5l59.3 59.3a8.01 8.01 0 0013.6-4.7l24-199.2c.7-5.1-3.7-9.5-8.9-8.8z" } }] }, "name": "rise", "theme": "outlined" };
	exports.default = RiseOutlined;
	});

	var RiseOutlinedSvg = unwrapExports(RiseOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var RiseOutlined = function RiseOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: RiseOutlinedSvg
	  }));
	};

	RiseOutlined.displayName = 'RiseOutlined';
	var RiseOutlined$1 = /*#__PURE__*/React.forwardRef(RiseOutlined);

	var RobotFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var RobotFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M852 64H172c-17.7 0-32 14.3-32 32v660c0 17.7 14.3 32 32 32h680c17.7 0 32-14.3 32-32V96c0-17.7-14.3-32-32-32zM300 328c0-33.1 26.9-60 60-60s60 26.9 60 60-26.9 60-60 60-60-26.9-60-60zm372 248c0 4.4-3.6 8-8 8H360c-4.4 0-8-3.6-8-8v-60c0-4.4 3.6-8 8-8h304c4.4 0 8 3.6 8 8v60zm-8-188c-33.1 0-60-26.9-60-60s26.9-60 60-60 60 26.9 60 60-26.9 60-60 60zm135 476H225c-13.8 0-25 14.3-25 32v56c0 4.4 2.8 8 6.2 8h611.5c3.4 0 6.2-3.6 6.2-8v-56c.1-17.7-11.1-32-24.9-32z" } }] }, "name": "robot", "theme": "filled" };
	exports.default = RobotFilled;
	});

	var RobotFilledSvg = unwrapExports(RobotFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var RobotFilled = function RobotFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: RobotFilledSvg
	  }));
	};

	RobotFilled.displayName = 'RobotFilled';
	var RobotFilled$1 = /*#__PURE__*/React.forwardRef(RobotFilled);

	var RobotOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var RobotOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M300 328a60 60 0 10120 0 60 60 0 10-120 0zM852 64H172c-17.7 0-32 14.3-32 32v660c0 17.7 14.3 32 32 32h680c17.7 0 32-14.3 32-32V96c0-17.7-14.3-32-32-32zm-32 660H204V128h616v596zM604 328a60 60 0 10120 0 60 60 0 10-120 0zm250.2 556H169.8c-16.5 0-29.8 14.3-29.8 32v36c0 4.4 3.3 8 7.4 8h729.1c4.1 0 7.4-3.6 7.4-8v-36c.1-17.7-13.2-32-29.7-32zM664 508H360c-4.4 0-8 3.6-8 8v60c0 4.4 3.6 8 8 8h304c4.4 0 8-3.6 8-8v-60c0-4.4-3.6-8-8-8z" } }] }, "name": "robot", "theme": "outlined" };
	exports.default = RobotOutlined;
	});

	var RobotOutlinedSvg = unwrapExports(RobotOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var RobotOutlined = function RobotOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: RobotOutlinedSvg
	  }));
	};

	RobotOutlined.displayName = 'RobotOutlined';
	var RobotOutlined$1 = /*#__PURE__*/React.forwardRef(RobotOutlined);

	var RocketFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var RocketFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M864 736c0-111.6-65.4-208-160-252.9V317.3c0-15.1-5.3-29.7-15.1-41.2L536.5 95.4C530.1 87.8 521 84 512 84s-18.1 3.8-24.5 11.4L335.1 276.1a63.97 63.97 0 00-15.1 41.2v165.8C225.4 528 160 624.4 160 736h156.5c-2.3 7.2-3.5 15-3.5 23.8 0 22.1 7.6 43.7 21.4 60.8a97.2 97.2 0 0043.1 30.6c23.1 54 75.6 88.8 134.5 88.8 29.1 0 57.3-8.6 81.4-24.8 23.6-15.8 41.9-37.9 53-64a97 97 0 0043.1-30.5 97.52 97.52 0 0021.4-60.8c0-8.4-1.1-16.4-3.1-23.8L864 736zM512 352a48.01 48.01 0 010 96 48.01 48.01 0 010-96zm116.1 432.2c-5.2 3-11.2 4.2-17.1 3.4l-19.5-2.4-2.8 19.4c-5.4 37.9-38.4 66.5-76.7 66.5s-71.3-28.6-76.7-66.5l-2.8-19.5-19.5 2.5a27.7 27.7 0 01-17.1-3.5c-8.7-5-14.1-14.3-14.1-24.4 0-10.6 5.9-19.4 14.6-23.8h231.3c8.8 4.5 14.6 13.3 14.6 23.8-.1 10.2-5.5 19.6-14.2 24.5z" } }] }, "name": "rocket", "theme": "filled" };
	exports.default = RocketFilled;
	});

	var RocketFilledSvg = unwrapExports(RocketFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var RocketFilled = function RocketFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: RocketFilledSvg
	  }));
	};

	RocketFilled.displayName = 'RocketFilled';
	var RocketFilled$1 = /*#__PURE__*/React.forwardRef(RocketFilled);

	var RocketOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var RocketOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M864 736c0-111.6-65.4-208-160-252.9V317.3c0-15.1-5.3-29.7-15.1-41.2L536.5 95.4C530.1 87.8 521 84 512 84s-18.1 3.8-24.5 11.4L335.1 276.1a63.97 63.97 0 00-15.1 41.2v165.8C225.4 528 160 624.4 160 736h156.5c-2.3 7.2-3.5 15-3.5 23.8 0 22.1 7.6 43.7 21.4 60.8a97.2 97.2 0 0043.1 30.6c23.1 54 75.6 88.8 134.5 88.8 29.1 0 57.3-8.6 81.4-24.8 23.6-15.8 41.9-37.9 53-64a97 97 0 0043.1-30.5 97.52 97.52 0 0021.4-60.8c0-8.4-1.1-16.4-3.1-23.8H864zM762.3 621.4c9.4 14.6 17 30.3 22.5 46.6H700V558.7a211.6 211.6 0 0162.3 62.7zM388 483.1V318.8l124-147 124 147V668H388V483.1zM239.2 668c5.5-16.3 13.1-32 22.5-46.6 16.3-25.2 37.5-46.5 62.3-62.7V668h-84.8zm388.9 116.2c-5.2 3-11.2 4.2-17.1 3.4l-19.5-2.4-2.8 19.4c-5.4 37.9-38.4 66.5-76.7 66.5-38.3 0-71.3-28.6-76.7-66.5l-2.8-19.5-19.5 2.5a27.7 27.7 0 01-17.1-3.5c-8.7-5-14.1-14.3-14.1-24.4 0-10.6 5.9-19.4 14.6-23.8h231.3c8.8 4.5 14.6 13.3 14.6 23.8-.1 10.2-5.5 19.6-14.2 24.5zM464 400a48 48 0 1096 0 48 48 0 10-96 0z" } }] }, "name": "rocket", "theme": "outlined" };
	exports.default = RocketOutlined;
	});

	var RocketOutlinedSvg = unwrapExports(RocketOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var RocketOutlined = function RocketOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: RocketOutlinedSvg
	  }));
	};

	RocketOutlined.displayName = 'RocketOutlined';
	var RocketOutlined$1 = /*#__PURE__*/React.forwardRef(RocketOutlined);

	var RocketTwoTone_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var RocketTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M261.7 621.4c-9.4 14.6-17 30.3-22.5 46.6H324V558.7c-24.8 16.2-46 37.5-62.3 62.7zM700 558.7V668h84.8c-5.5-16.3-13.1-32-22.5-46.6a211.6 211.6 0 00-62.3-62.7zm-64-239.9l-124-147-124 147V668h248V318.8zM512 448a48.01 48.01 0 010-96 48.01 48.01 0 010 96z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M864 736c0-111.6-65.4-208-160-252.9V317.3c0-15.1-5.3-29.7-15.1-41.2L536.5 95.4C530.1 87.8 521 84 512 84s-18.1 3.8-24.5 11.4L335.1 276.1a63.97 63.97 0 00-15.1 41.2v165.8C225.4 528 160 624.4 160 736h156.5c-2.3 7.2-3.5 15-3.5 23.8 0 22.1 7.6 43.7 21.4 60.8a97.2 97.2 0 0043.1 30.6c23.1 54 75.6 88.8 134.5 88.8 29.1 0 57.3-8.6 81.4-24.8 23.6-15.8 41.9-37.9 53-64a97 97 0 0043.1-30.5 97.52 97.52 0 0021.4-60.8c0-8.4-1.1-16.4-3.1-23.8L864 736zm-540-68h-84.8c5.5-16.3 13.1-32 22.5-46.6 16.3-25.2 37.5-46.5 62.3-62.7V668zm64-184.9V318.8l124-147 124 147V668H388V483.1zm240.1 301.1c-5.2 3-11.2 4.2-17.1 3.4l-19.5-2.4-2.8 19.4c-5.4 37.9-38.4 66.5-76.7 66.5s-71.3-28.6-76.7-66.5l-2.8-19.5-19.5 2.5a27.7 27.7 0 01-17.1-3.5c-8.7-5-14.1-14.3-14.1-24.4 0-10.6 5.9-19.4 14.6-23.8h231.3c8.8 4.5 14.6 13.3 14.6 23.8-.1 10.2-5.5 19.6-14.2 24.5zM700 668V558.7a211.6 211.6 0 0162.3 62.7c9.4 14.6 17 30.3 22.5 46.6H700z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M464 400a48 48 0 1096 0 48 48 0 10-96 0z", "fill": primaryColor } }] }; }, "name": "rocket", "theme": "twotone" };
	exports.default = RocketTwoTone;
	});

	var RocketTwoToneSvg = unwrapExports(RocketTwoTone_1);

	// GENERATE BY ./scripts/generate.ts

	var RocketTwoTone = function RocketTwoTone(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: RocketTwoToneSvg
	  }));
	};

	RocketTwoTone.displayName = 'RocketTwoTone';
	var RocketTwoTone$1 = /*#__PURE__*/React.forwardRef(RocketTwoTone);

	var RollbackOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var RollbackOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M793 242H366v-74c0-6.7-7.7-10.4-12.9-6.3l-142 112a8 8 0 000 12.6l142 112c5.2 4.1 12.9.4 12.9-6.3v-74h415v470H175c-4.4 0-8 3.6-8 8v60c0 4.4 3.6 8 8 8h618c35.3 0 64-28.7 64-64V306c0-35.3-28.7-64-64-64z" } }] }, "name": "rollback", "theme": "outlined" };
	exports.default = RollbackOutlined;
	});

	var RollbackOutlinedSvg = unwrapExports(RollbackOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var RollbackOutlined = function RollbackOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: RollbackOutlinedSvg
	  }));
	};

	RollbackOutlined.displayName = 'RollbackOutlined';
	var RollbackOutlined$1 = /*#__PURE__*/React.forwardRef(RollbackOutlined);

	var RotateLeftOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var RotateLeftOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M672 418H144c-17.7 0-32 14.3-32 32v414c0 17.7 14.3 32 32 32h528c17.7 0 32-14.3 32-32V450c0-17.7-14.3-32-32-32zm-44 402H188V494h440v326z" } }, { "tag": "path", "attrs": { "d": "M819.3 328.5c-78.8-100.7-196-153.6-314.6-154.2l-.2-64c0-6.5-7.6-10.1-12.6-6.1l-128 101c-4 3.1-3.9 9.1 0 12.3L492 318.6c5.1 4 12.7.4 12.6-6.1v-63.9c12.9.1 25.9.9 38.8 2.5 42.1 5.2 82.1 18.2 119 38.7 38.1 21.2 71.2 49.7 98.4 84.3 27.1 34.7 46.7 73.7 58.1 115.8a325.95 325.95 0 016.5 140.9h74.9c14.8-103.6-11.3-213-81-302.3z" } }] }, "name": "rotate-left", "theme": "outlined" };
	exports.default = RotateLeftOutlined;
	});

	var RotateLeftOutlinedSvg = unwrapExports(RotateLeftOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var RotateLeftOutlined = function RotateLeftOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: RotateLeftOutlinedSvg
	  }));
	};

	RotateLeftOutlined.displayName = 'RotateLeftOutlined';
	var RotateLeftOutlined$1 = /*#__PURE__*/React.forwardRef(RotateLeftOutlined);

	var RotateRightOutlined_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var RotateRightOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M480.5 251.2c13-1.6 25.9-2.4 38.8-2.5v63.9c0 6.5 7.5 10.1 12.6 6.1L660 217.6c4-3.2 4-9.2 0-12.3l-128-101c-5.1-4-12.6-.4-12.6 6.1l-.2 64c-118.6.5-235.8 53.4-314.6 154.2A399.75 399.75 0 00123.5 631h74.9c-.9-5.3-1.7-10.7-2.4-16.1-5.1-42.1-2.1-84.1 8.9-124.8 11.4-42.2 31-81.1 58.1-115.8 27.2-34.7 60.3-63.2 98.4-84.3 37-20.6 76.9-33.6 119.1-38.8z" } }, { "tag": "path", "attrs": { "d": "M880 418H352c-17.7 0-32 14.3-32 32v414c0 17.7 14.3 32 32 32h528c17.7 0 32-14.3 32-32V450c0-17.7-14.3-32-32-32zm-44 402H396V494h440v326z" } }] }, "name": "rotate-right", "theme": "outlined" };
	exports.default = RotateRightOutlined;
	});

	var RotateRightOutlinedSvg = unwrapExports(RotateRightOutlined_1);

	// GENERATE BY ./scripts/generate.ts

	var RotateRightOutlined = function RotateRightOutlined(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: RotateRightOutlinedSvg
	  }));
	};

	RotateRightOutlined.displayName = 'RotateRightOutlined';
	var RotateRightOutlined$1 = /*#__PURE__*/React.forwardRef(RotateRightOutlined);

	var SafetyCertificateFilled_1 = createCommonjsModule(function (module, exports) {
	// This icon file is generated automatically.
	Object.defineProperty(exports, "__esModule", { value: true });
	var SafetyCertificateFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M866.9 169.9L527.1 54.1C523 52.7 517.5 52 512 52s-11 .7-15.1 2.1L157.1 169.9c-8.3 2.8-15.1 12.4-15.1 21.2v482.4c0 8.8 5.7 20.4 12.6 25.9L499.3 968c3.5 2.7 8 4.1 12.6 4.1s9.2-1.4 12.6-4.1l344.7-268.6c6.9-5.4 12.6-17 12.6-25.9V191.1c.2-8.8-6.6-18.3-14.9-21.2zM694.5 340.7L481.9 633.4a16.1 16.1 0 01-26 0l-126.4-174c-3.8-5.3 0-12.7 6.5-12.7h55.2c5.1 0 10 2.5 13 6.6l64.7 89 150.9-207.8c3-4.1 7.8-6.6 13-6.6H688c6.5.1 10.3 7.5 6.5 12.8z" } }] }, "name": "safety-certificate", "theme": "filled" };
	exports.default = SafetyCertificateFilled;
	});

	var SafetyCertificateFilledSvg = unwrapExports(SafetyCertificateFilled_1);

	// GENERATE BY ./scripts/generate.ts

	var SafetyCertificateFilled = function SafetyCertificateFilled(props, ref) {
	  return /*#__PURE__*/React.createElement(Icon, Object.assign({}, props, {
	    ref: ref,
	    icon: SafetyCertificateFilledSvg
	  }));
	};

	SafetyCertificateFilled.displayName = 'SafetyCertificateFilled';
	var SafetyCertificateFilled$1 = /*#__PURE__*/React.forwardRef(SafetyCertificateFilled);

	var SafetyCertificateOutlined_1 = createCommonjsModule(function (module, exports