(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('react')) :
  typeof define === 'function' && define.amd ? define(['exports', 'react'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.icons = {}, global.window.React));
}(this, (function (exports, React) { 'use strict';

  function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

  var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

  var IconContext = /*#__PURE__*/React.createContext({});

  var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

  function getDefaultExportFromCjs (x) {
  	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
  }

  function createCommonjsModule(fn, basedir, module) {
  	return module = {
  		path: basedir,
  		exports: {},
  		require: function (path, base) {
  			return commonjsRequire(path, (base === undefined || base === null) ? module.path : base);
  		}
  	}, fn(module, module.exports), module.exports;
  }

  function commonjsRequire () {
  	throw new Error('Dynamic requires are not currently supported by @rollup/plugin-commonjs');
  }

  var _typeof_1 = createCommonjsModule(function (module) {
  function _typeof(o) {
    "@babel/helpers - typeof";

    return (module.exports = _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) {
      return typeof o;
    } : function (o) {
      return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o;
    }, module.exports.__esModule = true, module.exports["default"] = module.exports), _typeof(o);
  }
  module.exports = _typeof, module.exports.__esModule = true, module.exports["default"] = module.exports;
  });

  var _typeof = /*@__PURE__*/getDefaultExportFromCjs(_typeof_1);

  var toPrimitive_1 = createCommonjsModule(function (module) {
  var _typeof = _typeof_1["default"];
  function toPrimitive(t, r) {
    if ("object" != _typeof(t) || !t) return t;
    var e = t[Symbol.toPrimitive];
    if (void 0 !== e) {
      var i = e.call(t, r || "default");
      if ("object" != _typeof(i)) return i;
      throw new TypeError("@@toPrimitive must return a primitive value.");
    }
    return ("string" === r ? String : Number)(t);
  }
  module.exports = toPrimitive, module.exports.__esModule = true, module.exports["default"] = module.exports;
  });

  var toPropertyKey_1 = createCommonjsModule(function (module) {
  var _typeof = _typeof_1["default"];

  function toPropertyKey(t) {
    var i = toPrimitive_1(t, "string");
    return "symbol" == _typeof(i) ? i : i + "";
  }
  module.exports = toPropertyKey, module.exports.__esModule = true, module.exports["default"] = module.exports;
  });

  var defineProperty = createCommonjsModule(function (module) {
  function _defineProperty(obj, key, value) {
    key = toPropertyKey_1(key);
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }
    return obj;
  }
  module.exports = _defineProperty, module.exports.__esModule = true, module.exports["default"] = module.exports;
  });

  var _defineProperty = /*@__PURE__*/getDefaultExportFromCjs(defineProperty);

  var objectSpread2 = createCommonjsModule(function (module) {
  function ownKeys(e, r) {
    var t = Object.keys(e);
    if (Object.getOwnPropertySymbols) {
      var o = Object.getOwnPropertySymbols(e);
      r && (o = o.filter(function (r) {
        return Object.getOwnPropertyDescriptor(e, r).enumerable;
      })), t.push.apply(t, o);
    }
    return t;
  }
  function _objectSpread2(e) {
    for (var r = 1; r < arguments.length; r++) {
      var t = null != arguments[r] ? arguments[r] : {};
      r % 2 ? ownKeys(Object(t), !0).forEach(function (r) {
        defineProperty(e, r, t[r]);
      }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) {
        Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r));
      });
    }
    return e;
  }
  module.exports = _objectSpread2, module.exports.__esModule = true, module.exports["default"] = module.exports;
  });

  var _objectSpread = /*@__PURE__*/getDefaultExportFromCjs(objectSpread2);

  var AccountBookFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var AccountBookFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 184H712v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H384v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H144c-17.7 0-32 14.3-32 32v664c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V216c0-17.7-14.3-32-32-32zM648.3 426.8l-87.7 161.1h45.7c5.5 0 10 4.5 10 10v21.3c0 5.5-4.5 10-10 10h-63.4v29.7h63.4c5.5 0 10 4.5 10 10v21.3c0 5.5-4.5 10-10 10h-63.4V752c0 5.5-4.5 10-10 10h-41.3c-5.5 0-10-4.5-10-10v-51.8h-63.1c-5.5 0-10-4.5-10-10v-21.3c0-5.5 4.5-10 10-10h63.1v-29.7h-63.1c-5.5 0-10-4.5-10-10v-21.3c0-5.5 4.5-10 10-10h45.2l-88-161.1c-2.6-4.8-.9-10.9 4-13.6 1.5-.8 3.1-1.2 4.8-1.2h46c3.8 0 7.2 2.1 8.9 5.5l72.9 144.3 73.2-144.3a10 10 0 018.9-5.5h45c5.5 0 10 4.5 10 10 .1 1.7-.3 3.3-1.1 4.8z" } }] }, "name": "account-book", "theme": "filled" };
  exports.default = AccountBookFilled;
  });

  var AccountBookFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(AccountBookFilled_1);

  var arrayWithHoles = createCommonjsModule(function (module) {
  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }
  module.exports = _arrayWithHoles, module.exports.__esModule = true, module.exports["default"] = module.exports;
  });

  var iterableToArrayLimit = createCommonjsModule(function (module) {
  function _iterableToArrayLimit(r, l) {
    var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"];
    if (null != t) {
      var e,
        n,
        i,
        u,
        a = [],
        f = !0,
        o = !1;
      try {
        if (i = (t = t.call(r)).next, 0 === l) {
          if (Object(t) !== t) return;
          f = !1;
        } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0);
      } catch (r) {
        o = !0, n = r;
      } finally {
        try {
          if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return;
        } finally {
          if (o) throw n;
        }
      }
      return a;
    }
  }
  module.exports = _iterableToArrayLimit, module.exports.__esModule = true, module.exports["default"] = module.exports;
  });

  var arrayLikeToArray = createCommonjsModule(function (module) {
  function _arrayLikeToArray(arr, len) {
    if (len == null || len > arr.length) len = arr.length;
    for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];
    return arr2;
  }
  module.exports = _arrayLikeToArray, module.exports.__esModule = true, module.exports["default"] = module.exports;
  });

  var unsupportedIterableToArray = createCommonjsModule(function (module) {
  function _unsupportedIterableToArray(o, minLen) {
    if (!o) return;
    if (typeof o === "string") return arrayLikeToArray(o, minLen);
    var n = Object.prototype.toString.call(o).slice(8, -1);
    if (n === "Object" && o.constructor) n = o.constructor.name;
    if (n === "Map" || n === "Set") return Array.from(o);
    if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return arrayLikeToArray(o, minLen);
  }
  module.exports = _unsupportedIterableToArray, module.exports.__esModule = true, module.exports["default"] = module.exports;
  });

  var nonIterableRest = createCommonjsModule(function (module) {
  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  module.exports = _nonIterableRest, module.exports.__esModule = true, module.exports["default"] = module.exports;
  });

  var slicedToArray = createCommonjsModule(function (module) {
  function _slicedToArray(arr, i) {
    return arrayWithHoles(arr) || iterableToArrayLimit(arr, i) || unsupportedIterableToArray(arr, i) || nonIterableRest();
  }
  module.exports = _slicedToArray, module.exports.__esModule = true, module.exports["default"] = module.exports;
  });

  var _slicedToArray = /*@__PURE__*/getDefaultExportFromCjs(slicedToArray);

  var objectWithoutPropertiesLoose = createCommonjsModule(function (module) {
  function _objectWithoutPropertiesLoose(source, excluded) {
    if (source == null) return {};
    var target = {};
    var sourceKeys = Object.keys(source);
    var key, i;
    for (i = 0; i < sourceKeys.length; i++) {
      key = sourceKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      target[key] = source[key];
    }
    return target;
  }
  module.exports = _objectWithoutPropertiesLoose, module.exports.__esModule = true, module.exports["default"] = module.exports;
  });

  var objectWithoutProperties = createCommonjsModule(function (module) {
  function _objectWithoutProperties(source, excluded) {
    if (source == null) return {};
    var target = objectWithoutPropertiesLoose(source, excluded);
    var key, i;
    if (Object.getOwnPropertySymbols) {
      var sourceSymbolKeys = Object.getOwnPropertySymbols(source);
      for (i = 0; i < sourceSymbolKeys.length; i++) {
        key = sourceSymbolKeys[i];
        if (excluded.indexOf(key) >= 0) continue;
        if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
        target[key] = source[key];
      }
    }
    return target;
  }
  module.exports = _objectWithoutProperties, module.exports.__esModule = true, module.exports["default"] = module.exports;
  });

  var _objectWithoutProperties = /*@__PURE__*/getDefaultExportFromCjs(objectWithoutProperties);

  var classnames = createCommonjsModule(function (module) {
  /*!
  	Copyright (c) 2018 Jed Watson.
  	Licensed under the MIT License (MIT), see
  	http://jedwatson.github.io/classnames
  */
  /* global define */

  (function () {

  	var hasOwn = {}.hasOwnProperty;

  	function classNames () {
  		var classes = '';

  		for (var i = 0; i < arguments.length; i++) {
  			var arg = arguments[i];
  			if (arg) {
  				classes = appendClass(classes, parseValue(arg));
  			}
  		}

  		return classes;
  	}

  	function parseValue (arg) {
  		if (typeof arg === 'string' || typeof arg === 'number') {
  			return arg;
  		}

  		if (typeof arg !== 'object') {
  			return '';
  		}

  		if (Array.isArray(arg)) {
  			return classNames.apply(null, arg);
  		}

  		if (arg.toString !== Object.prototype.toString && !arg.toString.toString().includes('[native code]')) {
  			return arg.toString();
  		}

  		var classes = '';

  		for (var key in arg) {
  			if (hasOwn.call(arg, key) && arg[key]) {
  				classes = appendClass(classes, key);
  			}
  		}

  		return classes;
  	}

  	function appendClass (value, newClass) {
  		if (!newClass) {
  			return value;
  		}
  	
  		if (value) {
  			return value + ' ' + newClass;
  		}
  	
  		return value + newClass;
  	}

  	if ( module.exports) {
  		classNames.default = classNames;
  		module.exports = classNames;
  	} else {
  		window.classNames = classNames;
  	}
  }());
  });

  /**
   * Take input from [0, n] and return it as [0, 1]
   * @hidden
   */
  function bound01(n, max) {
      if (isOnePointZero(n)) {
          n = '100%';
      }
      var isPercent = isPercentage(n);
      n = max === 360 ? n : Math.min(max, Math.max(0, parseFloat(n)));
      // Automatically convert percentage into number
      if (isPercent) {
          n = parseInt(String(n * max), 10) / 100;
      }
      // Handle floating point rounding errors
      if (Math.abs(n - max) < 0.000001) {
          return 1;
      }
      // Convert into [0, 1] range if it isn't already
      if (max === 360) {
          // If n is a hue given in degrees,
          // wrap around out-of-range values into [0, 360] range
          // then convert into [0, 1].
          n = (n < 0 ? (n % max) + max : n % max) / parseFloat(String(max));
      }
      else {
          // If n not a hue given in degrees
          // Convert into [0, 1] range if it isn't already.
          n = (n % max) / parseFloat(String(max));
      }
      return n;
  }
  /**
   * Need to handle 1.0 as 100%, since once it is a number, there is no difference between it and 1
   * <http://stackoverflow.com/questions/7422072/javascript-how-to-detect-number-as-a-decimal-including-1-0>
   * @hidden
   */
  function isOnePointZero(n) {
      return typeof n === 'string' && n.indexOf('.') !== -1 && parseFloat(n) === 1;
  }
  /**
   * Check to see if string passed in is a percentage
   * @hidden
   */
  function isPercentage(n) {
      return typeof n === 'string' && n.indexOf('%') !== -1;
  }
  /**
   * Return a valid alpha value [0,1] with all invalid values being set to 1
   * @hidden
   */
  function boundAlpha(a) {
      a = parseFloat(a);
      if (isNaN(a) || a < 0 || a > 1) {
          a = 1;
      }
      return a;
  }
  /**
   * Replace a decimal with it's percentage value
   * @hidden
   */
  function convertToPercentage(n) {
      if (n <= 1) {
          return "".concat(Number(n) * 100, "%");
      }
      return n;
  }
  /**
   * Force a hex value to have 2 characters
   * @hidden
   */
  function pad2(c) {
      return c.length === 1 ? '0' + c : String(c);
  }

  // `rgbToHsl`, `rgbToHsv`, `hslToRgb`, `hsvToRgb` modified from:
  // <http://mjijackson.com/2008/02/rgb-to-hsl-and-rgb-to-hsv-color-model-conversion-algorithms-in-javascript>
  /**
   * Handle bounds / percentage checking to conform to CSS color spec
   * <http://www.w3.org/TR/css3-color/>
   * *Assumes:* r, g, b in [0, 255] or [0, 1]
   * *Returns:* { r, g, b } in [0, 255]
   */
  function rgbToRgb(r, g, b) {
      return {
          r: bound01(r, 255) * 255,
          g: bound01(g, 255) * 255,
          b: bound01(b, 255) * 255,
      };
  }
  function hue2rgb(p, q, t) {
      if (t < 0) {
          t += 1;
      }
      if (t > 1) {
          t -= 1;
      }
      if (t < 1 / 6) {
          return p + (q - p) * (6 * t);
      }
      if (t < 1 / 2) {
          return q;
      }
      if (t < 2 / 3) {
          return p + (q - p) * (2 / 3 - t) * 6;
      }
      return p;
  }
  /**
   * Converts an HSL color value to RGB.
   *
   * *Assumes:* h is contained in [0, 1] or [0, 360] and s and l are contained [0, 1] or [0, 100]
   * *Returns:* { r, g, b } in the set [0, 255]
   */
  function hslToRgb(h, s, l) {
      var r;
      var g;
      var b;
      h = bound01(h, 360);
      s = bound01(s, 100);
      l = bound01(l, 100);
      if (s === 0) {
          // achromatic
          g = l;
          b = l;
          r = l;
      }
      else {
          var q = l < 0.5 ? l * (1 + s) : l + s - l * s;
          var p = 2 * l - q;
          r = hue2rgb(p, q, h + 1 / 3);
          g = hue2rgb(p, q, h);
          b = hue2rgb(p, q, h - 1 / 3);
      }
      return { r: r * 255, g: g * 255, b: b * 255 };
  }
  /**
   * Converts an RGB color value to HSV
   *
   * *Assumes:* r, g, and b are contained in the set [0, 255] or [0, 1]
   * *Returns:* { h, s, v } in [0,1]
   */
  function rgbToHsv(r, g, b) {
      r = bound01(r, 255);
      g = bound01(g, 255);
      b = bound01(b, 255);
      var max = Math.max(r, g, b);
      var min = Math.min(r, g, b);
      var h = 0;
      var v = max;
      var d = max - min;
      var s = max === 0 ? 0 : d / max;
      if (max === min) {
          h = 0; // achromatic
      }
      else {
          switch (max) {
              case r:
                  h = (g - b) / d + (g < b ? 6 : 0);
                  break;
              case g:
                  h = (b - r) / d + 2;
                  break;
              case b:
                  h = (r - g) / d + 4;
                  break;
          }
          h /= 6;
      }
      return { h: h, s: s, v: v };
  }
  /**
   * Converts an HSV color value to RGB.
   *
   * *Assumes:* h is contained in [0, 1] or [0, 360] and s and v are contained in [0, 1] or [0, 100]
   * *Returns:* { r, g, b } in the set [0, 255]
   */
  function hsvToRgb(h, s, v) {
      h = bound01(h, 360) * 6;
      s = bound01(s, 100);
      v = bound01(v, 100);
      var i = Math.floor(h);
      var f = h - i;
      var p = v * (1 - s);
      var q = v * (1 - f * s);
      var t = v * (1 - (1 - f) * s);
      var mod = i % 6;
      var r = [v, q, p, p, t, v][mod];
      var g = [t, v, v, q, p, p][mod];
      var b = [p, p, t, v, v, q][mod];
      return { r: r * 255, g: g * 255, b: b * 255 };
  }
  /**
   * Converts an RGB color to hex
   *
   * Assumes r, g, and b are contained in the set [0, 255]
   * Returns a 3 or 6 character hex
   */
  function rgbToHex(r, g, b, allow3Char) {
      var hex = [
          pad2(Math.round(r).toString(16)),
          pad2(Math.round(g).toString(16)),
          pad2(Math.round(b).toString(16)),
      ];
      // Return a 3 character hex if possible
      if (allow3Char &&
          hex[0].startsWith(hex[0].charAt(1)) &&
          hex[1].startsWith(hex[1].charAt(1)) &&
          hex[2].startsWith(hex[2].charAt(1))) {
          return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0);
      }
      return hex.join('');
  }
  /** Converts a hex value to a decimal */
  function convertHexToDecimal(h) {
      return parseIntFromHex(h) / 255;
  }
  /** Parse a base-16 hex value into a base-10 integer */
  function parseIntFromHex(val) {
      return parseInt(val, 16);
  }

  // https://github.com/bahamas10/css-color-names/blob/master/css-color-names.json
  /**
   * @hidden
   */
  var names = {
      aliceblue: '#f0f8ff',
      antiquewhite: '#faebd7',
      aqua: '#00ffff',
      aquamarine: '#7fffd4',
      azure: '#f0ffff',
      beige: '#f5f5dc',
      bisque: '#ffe4c4',
      black: '#000000',
      blanchedalmond: '#ffebcd',
      blue: '#0000ff',
      blueviolet: '#8a2be2',
      brown: '#a52a2a',
      burlywood: '#deb887',
      cadetblue: '#5f9ea0',
      chartreuse: '#7fff00',
      chocolate: '#d2691e',
      coral: '#ff7f50',
      cornflowerblue: '#6495ed',
      cornsilk: '#fff8dc',
      crimson: '#dc143c',
      cyan: '#00ffff',
      darkblue: '#00008b',
      darkcyan: '#008b8b',
      darkgoldenrod: '#b8860b',
      darkgray: '#a9a9a9',
      darkgreen: '#006400',
      darkgrey: '#a9a9a9',
      darkkhaki: '#bdb76b',
      darkmagenta: '#8b008b',
      darkolivegreen: '#556b2f',
      darkorange: '#ff8c00',
      darkorchid: '#9932cc',
      darkred: '#8b0000',
      darksalmon: '#e9967a',
      darkseagreen: '#8fbc8f',
      darkslateblue: '#483d8b',
      darkslategray: '#2f4f4f',
      darkslategrey: '#2f4f4f',
      darkturquoise: '#00ced1',
      darkviolet: '#9400d3',
      deeppink: '#ff1493',
      deepskyblue: '#00bfff',
      dimgray: '#696969',
      dimgrey: '#696969',
      dodgerblue: '#1e90ff',
      firebrick: '#b22222',
      floralwhite: '#fffaf0',
      forestgreen: '#228b22',
      fuchsia: '#ff00ff',
      gainsboro: '#dcdcdc',
      ghostwhite: '#f8f8ff',
      goldenrod: '#daa520',
      gold: '#ffd700',
      gray: '#808080',
      green: '#008000',
      greenyellow: '#adff2f',
      grey: '#808080',
      honeydew: '#f0fff0',
      hotpink: '#ff69b4',
      indianred: '#cd5c5c',
      indigo: '#4b0082',
      ivory: '#fffff0',
      khaki: '#f0e68c',
      lavenderblush: '#fff0f5',
      lavender: '#e6e6fa',
      lawngreen: '#7cfc00',
      lemonchiffon: '#fffacd',
      lightblue: '#add8e6',
      lightcoral: '#f08080',
      lightcyan: '#e0ffff',
      lightgoldenrodyellow: '#fafad2',
      lightgray: '#d3d3d3',
      lightgreen: '#90ee90',
      lightgrey: '#d3d3d3',
      lightpink: '#ffb6c1',
      lightsalmon: '#ffa07a',
      lightseagreen: '#20b2aa',
      lightskyblue: '#87cefa',
      lightslategray: '#778899',
      lightslategrey: '#778899',
      lightsteelblue: '#b0c4de',
      lightyellow: '#ffffe0',
      lime: '#00ff00',
      limegreen: '#32cd32',
      linen: '#faf0e6',
      magenta: '#ff00ff',
      maroon: '#800000',
      mediumaquamarine: '#66cdaa',
      mediumblue: '#0000cd',
      mediumorchid: '#ba55d3',
      mediumpurple: '#9370db',
      mediumseagreen: '#3cb371',
      mediumslateblue: '#7b68ee',
      mediumspringgreen: '#00fa9a',
      mediumturquoise: '#48d1cc',
      mediumvioletred: '#c71585',
      midnightblue: '#191970',
      mintcream: '#f5fffa',
      mistyrose: '#ffe4e1',
      moccasin: '#ffe4b5',
      navajowhite: '#ffdead',
      navy: '#000080',
      oldlace: '#fdf5e6',
      olive: '#808000',
      olivedrab: '#6b8e23',
      orange: '#ffa500',
      orangered: '#ff4500',
      orchid: '#da70d6',
      palegoldenrod: '#eee8aa',
      palegreen: '#98fb98',
      paleturquoise: '#afeeee',
      palevioletred: '#db7093',
      papayawhip: '#ffefd5',
      peachpuff: '#ffdab9',
      peru: '#cd853f',
      pink: '#ffc0cb',
      plum: '#dda0dd',
      powderblue: '#b0e0e6',
      purple: '#800080',
      rebeccapurple: '#663399',
      red: '#ff0000',
      rosybrown: '#bc8f8f',
      royalblue: '#4169e1',
      saddlebrown: '#8b4513',
      salmon: '#fa8072',
      sandybrown: '#f4a460',
      seagreen: '#2e8b57',
      seashell: '#fff5ee',
      sienna: '#a0522d',
      silver: '#c0c0c0',
      skyblue: '#87ceeb',
      slateblue: '#6a5acd',
      slategray: '#708090',
      slategrey: '#708090',
      snow: '#fffafa',
      springgreen: '#00ff7f',
      steelblue: '#4682b4',
      tan: '#d2b48c',
      teal: '#008080',
      thistle: '#d8bfd8',
      tomato: '#ff6347',
      turquoise: '#40e0d0',
      violet: '#ee82ee',
      wheat: '#f5deb3',
      white: '#ffffff',
      whitesmoke: '#f5f5f5',
      yellow: '#ffff00',
      yellowgreen: '#9acd32',
  };

  /* eslint-disable @typescript-eslint/no-redundant-type-constituents */
  /**
   * Given a string or object, convert that input to RGB
   *
   * Possible string inputs:
   * ```
   * "red"
   * "#f00" or "f00"
   * "#ff0000" or "ff0000"
   * "#ff000000" or "ff000000"
   * "rgb 255 0 0" or "rgb (255, 0, 0)"
   * "rgb 1.0 0 0" or "rgb (1, 0, 0)"
   * "rgba (255, 0, 0, 1)" or "rgba 255, 0, 0, 1"
   * "rgba (1.0, 0, 0, 1)" or "rgba 1.0, 0, 0, 1"
   * "hsl(0, 100%, 50%)" or "hsl 0 100% 50%"
   * "hsla(0, 100%, 50%, 1)" or "hsla 0 100% 50%, 1"
   * "hsv(0, 100%, 100%)" or "hsv 0 100% 100%"
   * ```
   */
  function inputToRGB(color) {
      var rgb = { r: 0, g: 0, b: 0 };
      var a = 1;
      var s = null;
      var v = null;
      var l = null;
      var ok = false;
      var format = false;
      if (typeof color === 'string') {
          color = stringInputToObject(color);
      }
      if (typeof color === 'object') {
          if (isValidCSSUnit(color.r) && isValidCSSUnit(color.g) && isValidCSSUnit(color.b)) {
              rgb = rgbToRgb(color.r, color.g, color.b);
              ok = true;
              format = String(color.r).substr(-1) === '%' ? 'prgb' : 'rgb';
          }
          else if (isValidCSSUnit(color.h) && isValidCSSUnit(color.s) && isValidCSSUnit(color.v)) {
              s = convertToPercentage(color.s);
              v = convertToPercentage(color.v);
              rgb = hsvToRgb(color.h, s, v);
              ok = true;
              format = 'hsv';
          }
          else if (isValidCSSUnit(color.h) && isValidCSSUnit(color.s) && isValidCSSUnit(color.l)) {
              s = convertToPercentage(color.s);
              l = convertToPercentage(color.l);
              rgb = hslToRgb(color.h, s, l);
              ok = true;
              format = 'hsl';
          }
          if (Object.prototype.hasOwnProperty.call(color, 'a')) {
              a = color.a;
          }
      }
      a = boundAlpha(a);
      return {
          ok: ok,
          format: color.format || format,
          r: Math.min(255, Math.max(rgb.r, 0)),
          g: Math.min(255, Math.max(rgb.g, 0)),
          b: Math.min(255, Math.max(rgb.b, 0)),
          a: a,
      };
  }
  // <http://www.w3.org/TR/css3-values/#integers>
  var CSS_INTEGER = '[-\\+]?\\d+%?';
  // <http://www.w3.org/TR/css3-values/#number-value>
  var CSS_NUMBER = '[-\\+]?\\d*\\.\\d+%?';
  // Allow positive/negative integer/number.  Don't capture the either/or, just the entire outcome.
  var CSS_UNIT = "(?:".concat(CSS_NUMBER, ")|(?:").concat(CSS_INTEGER, ")");
  // Actual matching.
  // Parentheses and commas are optional, but not required.
  // Whitespace can take the place of commas or opening paren
  var PERMISSIVE_MATCH3 = "[\\s|\\(]+(".concat(CSS_UNIT, ")[,|\\s]+(").concat(CSS_UNIT, ")[,|\\s]+(").concat(CSS_UNIT, ")\\s*\\)?");
  var PERMISSIVE_MATCH4 = "[\\s|\\(]+(".concat(CSS_UNIT, ")[,|\\s]+(").concat(CSS_UNIT, ")[,|\\s]+(").concat(CSS_UNIT, ")[,|\\s]+(").concat(CSS_UNIT, ")\\s*\\)?");
  var matchers = {
      CSS_UNIT: new RegExp(CSS_UNIT),
      rgb: new RegExp('rgb' + PERMISSIVE_MATCH3),
      rgba: new RegExp('rgba' + PERMISSIVE_MATCH4),
      hsl: new RegExp('hsl' + PERMISSIVE_MATCH3),
      hsla: new RegExp('hsla' + PERMISSIVE_MATCH4),
      hsv: new RegExp('hsv' + PERMISSIVE_MATCH3),
      hsva: new RegExp('hsva' + PERMISSIVE_MATCH4),
      hex3: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,
      hex6: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,
      hex4: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,
      hex8: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,
  };
  /**
   * Permissive string parsing.  Take in a number of formats, and output an object
   * based on detected format.  Returns `{ r, g, b }` or `{ h, s, l }` or `{ h, s, v}`
   */
  function stringInputToObject(color) {
      color = color.trim().toLowerCase();
      if (color.length === 0) {
          return false;
      }
      var named = false;
      if (names[color]) {
          color = names[color];
          named = true;
      }
      else if (color === 'transparent') {
          return { r: 0, g: 0, b: 0, a: 0, format: 'name' };
      }
      // Try to match string input using regular expressions.
      // Keep most of the number bounding out of this function - don't worry about [0,1] or [0,100] or [0,360]
      // Just return an object and let the conversion functions handle that.
      // This way the result will be the same whether the tinycolor is initialized with string or object.
      var match = matchers.rgb.exec(color);
      if (match) {
          return { r: match[1], g: match[2], b: match[3] };
      }
      match = matchers.rgba.exec(color);
      if (match) {
          return { r: match[1], g: match[2], b: match[3], a: match[4] };
      }
      match = matchers.hsl.exec(color);
      if (match) {
          return { h: match[1], s: match[2], l: match[3] };
      }
      match = matchers.hsla.exec(color);
      if (match) {
          return { h: match[1], s: match[2], l: match[3], a: match[4] };
      }
      match = matchers.hsv.exec(color);
      if (match) {
          return { h: match[1], s: match[2], v: match[3] };
      }
      match = matchers.hsva.exec(color);
      if (match) {
          return { h: match[1], s: match[2], v: match[3], a: match[4] };
      }
      match = matchers.hex8.exec(color);
      if (match) {
          return {
              r: parseIntFromHex(match[1]),
              g: parseIntFromHex(match[2]),
              b: parseIntFromHex(match[3]),
              a: convertHexToDecimal(match[4]),
              format: named ? 'name' : 'hex8',
          };
      }
      match = matchers.hex6.exec(color);
      if (match) {
          return {
              r: parseIntFromHex(match[1]),
              g: parseIntFromHex(match[2]),
              b: parseIntFromHex(match[3]),
              format: named ? 'name' : 'hex',
          };
      }
      match = matchers.hex4.exec(color);
      if (match) {
          return {
              r: parseIntFromHex(match[1] + match[1]),
              g: parseIntFromHex(match[2] + match[2]),
              b: parseIntFromHex(match[3] + match[3]),
              a: convertHexToDecimal(match[4] + match[4]),
              format: named ? 'name' : 'hex8',
          };
      }
      match = matchers.hex3.exec(color);
      if (match) {
          return {
              r: parseIntFromHex(match[1] + match[1]),
              g: parseIntFromHex(match[2] + match[2]),
              b: parseIntFromHex(match[3] + match[3]),
              format: named ? 'name' : 'hex',
          };
      }
      return false;
  }
  /**
   * Check to see if it looks like a CSS unit
   * (see `matchers` above for definition).
   */
  function isValidCSSUnit(color) {
      return Boolean(matchers.CSS_UNIT.exec(String(color)));
  }

  var hueStep = 2; // 色相阶梯

  var saturationStep = 0.16; // 饱和度阶梯，浅色部分

  var saturationStep2 = 0.05; // 饱和度阶梯，深色部分

  var brightnessStep1 = 0.05; // 亮度阶梯，浅色部分

  var brightnessStep2 = 0.15; // 亮度阶梯，深色部分

  var lightColorCount = 5; // 浅色数量，主色上

  var darkColorCount = 4; // 深色数量，主色下
  // 暗色主题颜色映射关系表

  var darkColorMap = [{
    index: 7,
    opacity: 0.15
  }, {
    index: 6,
    opacity: 0.25
  }, {
    index: 5,
    opacity: 0.3
  }, {
    index: 5,
    opacity: 0.45
  }, {
    index: 5,
    opacity: 0.65
  }, {
    index: 5,
    opacity: 0.85
  }, {
    index: 4,
    opacity: 0.9
  }, {
    index: 3,
    opacity: 0.95
  }, {
    index: 2,
    opacity: 0.97
  }, {
    index: 1,
    opacity: 0.98
  }]; // Wrapper function ported from TinyColor.prototype.toHsv
  // Keep it here because of `hsv.h * 360`

  function toHsv(_ref) {
    var r = _ref.r,
        g = _ref.g,
        b = _ref.b;
    var hsv = rgbToHsv(r, g, b);
    return {
      h: hsv.h * 360,
      s: hsv.s,
      v: hsv.v
    };
  } // Wrapper function ported from TinyColor.prototype.toHexString
  // Keep it here because of the prefix `#`


  function toHex(_ref2) {
    var r = _ref2.r,
        g = _ref2.g,
        b = _ref2.b;
    return "#".concat(rgbToHex(r, g, b, false));
  } // Wrapper function ported from TinyColor.prototype.mix, not treeshakable.
  // Amount in range [0, 1]
  // Assume color1 & color2 has no alpha, since the following src code did so.


  function mix(rgb1, rgb2, amount) {
    var p = amount / 100;
    var rgb = {
      r: (rgb2.r - rgb1.r) * p + rgb1.r,
      g: (rgb2.g - rgb1.g) * p + rgb1.g,
      b: (rgb2.b - rgb1.b) * p + rgb1.b
    };
    return rgb;
  }

  function getHue(hsv, i, light) {
    var hue; // 根据色相不同，色相转向不同

    if (Math.round(hsv.h) >= 60 && Math.round(hsv.h) <= 240) {
      hue = light ? Math.round(hsv.h) - hueStep * i : Math.round(hsv.h) + hueStep * i;
    } else {
      hue = light ? Math.round(hsv.h) + hueStep * i : Math.round(hsv.h) - hueStep * i;
    }

    if (hue < 0) {
      hue += 360;
    } else if (hue >= 360) {
      hue -= 360;
    }

    return hue;
  }

  function getSaturation(hsv, i, light) {
    // grey color don't change saturation
    if (hsv.h === 0 && hsv.s === 0) {
      return hsv.s;
    }

    var saturation;

    if (light) {
      saturation = hsv.s - saturationStep * i;
    } else if (i === darkColorCount) {
      saturation = hsv.s + saturationStep;
    } else {
      saturation = hsv.s + saturationStep2 * i;
    } // 边界值修正


    if (saturation > 1) {
      saturation = 1;
    } // 第一格的 s 限制在 0.06-0.1 之间


    if (light && i === lightColorCount && saturation > 0.1) {
      saturation = 0.1;
    }

    if (saturation < 0.06) {
      saturation = 0.06;
    }

    return Number(saturation.toFixed(2));
  }

  function getValue(hsv, i, light) {
    var value;

    if (light) {
      value = hsv.v + brightnessStep1 * i;
    } else {
      value = hsv.v - brightnessStep2 * i;
    }

    if (value > 1) {
      value = 1;
    }

    return Number(value.toFixed(2));
  }

  function generate(color) {
    var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var patterns = [];
    var pColor = inputToRGB(color);

    for (var i = lightColorCount; i > 0; i -= 1) {
      var hsv = toHsv(pColor);
      var colorString = toHex(inputToRGB({
        h: getHue(hsv, i, true),
        s: getSaturation(hsv, i, true),
        v: getValue(hsv, i, true)
      }));
      patterns.push(colorString);
    }

    patterns.push(toHex(pColor));

    for (var _i = 1; _i <= darkColorCount; _i += 1) {
      var _hsv = toHsv(pColor);

      var _colorString = toHex(inputToRGB({
        h: getHue(_hsv, _i),
        s: getSaturation(_hsv, _i),
        v: getValue(_hsv, _i)
      }));

      patterns.push(_colorString);
    } // dark theme patterns


    if (opts.theme === 'dark') {
      return darkColorMap.map(function (_ref3) {
        var index = _ref3.index,
            opacity = _ref3.opacity;
        var darkColorString = toHex(mix(inputToRGB(opts.backgroundColor || '#141414'), inputToRGB(patterns[index]), opacity * 100));
        return darkColorString;
      });
    }

    return patterns;
  }

  var presetPrimaryColors = {
    red: '#F5222D',
    volcano: '#FA541C',
    orange: '#FA8C16',
    gold: '#FAAD14',
    yellow: '#FADB14',
    lime: '#A0D911',
    green: '#52C41A',
    cyan: '#13C2C2',
    blue: '#1890FF',
    geekblue: '#2F54EB',
    purple: '#722ED1',
    magenta: '#EB2F96',
    grey: '#666666'
  };
  var presetPalettes = {};
  var presetDarkPalettes = {};
  Object.keys(presetPrimaryColors).forEach(function (key) {
    presetPalettes[key] = generate(presetPrimaryColors[key]);
    presetPalettes[key].primary = presetPalettes[key][5]; // dark presetPalettes

    presetDarkPalettes[key] = generate(presetPrimaryColors[key], {
      theme: 'dark',
      backgroundColor: '#141414'
    });
    presetDarkPalettes[key].primary = presetDarkPalettes[key][5];
  });

  var warning_1 = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.call = call;
  exports.default = void 0;
  exports.note = note;
  exports.noteOnce = noteOnce;
  exports.preMessage = void 0;
  exports.resetWarned = resetWarned;
  exports.warning = warning;
  exports.warningOnce = warningOnce;
  /* eslint-disable no-console */
  var warned = {};
  var preWarningFns = [];

  /**
   * Pre warning enable you to parse content before console.error.
   * Modify to null will prevent warning.
   */
  var preMessage = exports.preMessage = function preMessage(fn) {
    preWarningFns.push(fn);
  };

  /**
   * Warning if condition not match.
   * @param valid Condition
   * @param message Warning message
   * @example
   * ```js
   * warning(false, 'some error'); // print some error
   * warning(true, 'some error'); // print nothing
   * warning(1 === 2, 'some error'); // print some error
   * ```
   */
  function warning(valid, message) {
    if ( !valid && console !== undefined) {
      var finalMessage = preWarningFns.reduce(function (msg, preMessageFn) {
        return preMessageFn(msg !== null && msg !== void 0 ? msg : '', 'warning');
      }, message);
      if (finalMessage) {
        console.error("Warning: ".concat(finalMessage));
      }
    }
  }

  /** @see Similar to {@link warning} */
  function note(valid, message) {
    if ( !valid && console !== undefined) {
      var finalMessage = preWarningFns.reduce(function (msg, preMessageFn) {
        return preMessageFn(msg !== null && msg !== void 0 ? msg : '', 'note');
      }, message);
      if (finalMessage) {
        console.warn("Note: ".concat(finalMessage));
      }
    }
  }
  function resetWarned() {
    warned = {};
  }
  function call(method, valid, message) {
    if (!valid && !warned[message]) {
      method(false, message);
      warned[message] = true;
    }
  }

  /** @see Same as {@link warning}, but only warn once for the same message */
  function warningOnce(valid, message) {
    call(warning, valid, message);
  }

  /** @see Same as {@link warning}, but only warn once for the same message */
  function noteOnce(valid, message) {
    call(note, valid, message);
  }
  warningOnce.preMessage = preMessage;
  warningOnce.resetWarned = resetWarned;
  warningOnce.noteOnce = noteOnce;
  var _default = exports.default = warningOnce;
  });

  var warn = /*@__PURE__*/getDefaultExportFromCjs(warning_1);

  var interopRequireDefault = createCommonjsModule(function (module) {
  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {
      "default": obj
    };
  }
  module.exports = _interopRequireDefault, module.exports.__esModule = true, module.exports["default"] = module.exports;
  });

  var canUseDom_1 = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = canUseDom;
  function canUseDom() {
    return !!(typeof window !== 'undefined' && window.document && window.document.createElement);
  }
  });

  var contains_1 = createCommonjsModule(function (module, exports) {

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = contains;
  function contains(root, n) {
    if (!root) {
      return false;
    }

    // Use native if support
    if (root.contains) {
      return root.contains(n);
    }

    // `document.contains` not support with IE11
    var node = n;
    while (node) {
      if (node === root) {
        return true;
      }
      node = node.parentNode;
    }
    return false;
  }
  });

  var dynamicCSS = createCommonjsModule(function (module, exports) {

  var _interopRequireDefault = interopRequireDefault.default;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.clearContainerCache = clearContainerCache;
  exports.injectCSS = injectCSS;
  exports.removeCSS = removeCSS;
  exports.updateCSS = updateCSS;
  var _objectSpread2 = _interopRequireDefault(objectSpread2);
  var _canUseDom = _interopRequireDefault(canUseDom_1);
  var _contains = _interopRequireDefault(contains_1);
  var APPEND_ORDER = 'data-rc-order';
  var APPEND_PRIORITY = 'data-rc-priority';
  var MARK_KEY = "rc-util-key";
  var containerCache = new Map();
  function getMark() {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      mark = _ref.mark;
    if (mark) {
      return mark.startsWith('data-') ? mark : "data-".concat(mark);
    }
    return MARK_KEY;
  }
  function getContainer(option) {
    if (option.attachTo) {
      return option.attachTo;
    }
    var head = document.querySelector('head');
    return head || document.body;
  }
  function getOrder(prepend) {
    if (prepend === 'queue') {
      return 'prependQueue';
    }
    return prepend ? 'prepend' : 'append';
  }

  /**
   * Find style which inject by rc-util
   */
  function findStyles(container) {
    return Array.from((containerCache.get(container) || container).children).filter(function (node) {
      return node.tagName === 'STYLE';
    });
  }
  function injectCSS(css) {
    var option = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    if (!(0, _canUseDom.default)()) {
      return null;
    }
    var csp = option.csp,
      prepend = option.prepend,
      _option$priority = option.priority,
      priority = _option$priority === void 0 ? 0 : _option$priority;
    var mergedOrder = getOrder(prepend);
    var isPrependQueue = mergedOrder === 'prependQueue';
    var styleNode = document.createElement('style');
    styleNode.setAttribute(APPEND_ORDER, mergedOrder);
    if (isPrependQueue && priority) {
      styleNode.setAttribute(APPEND_PRIORITY, "".concat(priority));
    }
    if (csp !== null && csp !== void 0 && csp.nonce) {
      styleNode.nonce = csp === null || csp === void 0 ? void 0 : csp.nonce;
    }
    styleNode.innerHTML = css;
    var container = getContainer(option);
    var firstChild = container.firstChild;
    if (prepend) {
      // If is queue `prepend`, it will prepend first style and then append rest style
      if (isPrependQueue) {
        var existStyle = (option.styles || findStyles(container)).filter(function (node) {
          // Ignore style which not injected by rc-util with prepend
          if (!['prepend', 'prependQueue'].includes(node.getAttribute(APPEND_ORDER))) {
            return false;
          }

          // Ignore style which priority less then new style
          var nodePriority = Number(node.getAttribute(APPEND_PRIORITY) || 0);
          return priority >= nodePriority;
        });
        if (existStyle.length) {
          container.insertBefore(styleNode, existStyle[existStyle.length - 1].nextSibling);
          return styleNode;
        }
      }

      // Use `insertBefore` as `prepend`
      container.insertBefore(styleNode, firstChild);
    } else {
      container.appendChild(styleNode);
    }
    return styleNode;
  }
  function findExistNode(key) {
    var option = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var container = getContainer(option);
    return (option.styles || findStyles(container)).find(function (node) {
      return node.getAttribute(getMark(option)) === key;
    });
  }
  function removeCSS(key) {
    var option = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var existNode = findExistNode(key, option);
    if (existNode) {
      var container = getContainer(option);
      container.removeChild(existNode);
    }
  }

  /**
   * qiankun will inject `appendChild` to insert into other
   */
  function syncRealContainer(container, option) {
    var cachedRealContainer = containerCache.get(container);

    // Find real container when not cached or cached container removed
    if (!cachedRealContainer || !(0, _contains.default)(document, cachedRealContainer)) {
      var placeholderStyle = injectCSS('', option);
      var parentNode = placeholderStyle.parentNode;
      containerCache.set(container, parentNode);
      container.removeChild(placeholderStyle);
    }
  }

  /**
   * manually clear container cache to avoid global cache in unit testes
   */
  function clearContainerCache() {
    containerCache.clear();
  }
  function updateCSS(css, key) {
    var originOption = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var container = getContainer(originOption);
    var styles = findStyles(container);
    var option = (0, _objectSpread2.default)((0, _objectSpread2.default)({}, originOption), {}, {
      styles: styles
    });

    // Sync real parent
    syncRealContainer(container, option);
    var existNode = findExistNode(key, option);
    if (existNode) {
      var _option$csp, _option$csp2;
      if ((_option$csp = option.csp) !== null && _option$csp !== void 0 && _option$csp.nonce && existNode.nonce !== ((_option$csp2 = option.csp) === null || _option$csp2 === void 0 ? void 0 : _option$csp2.nonce)) {
        var _option$csp3;
        existNode.nonce = (_option$csp3 = option.csp) === null || _option$csp3 === void 0 ? void 0 : _option$csp3.nonce;
      }
      if (existNode.innerHTML !== css) {
        existNode.innerHTML = css;
      }
      return existNode;
    }
    var newNode = injectCSS(css, option);
    newNode.setAttribute(getMark(option), key);
    return newNode;
  }
  });

  /** Detect free variable `global` from Node.js. */
  var freeGlobal = typeof commonjsGlobal == 'object' && commonjsGlobal && commonjsGlobal.Object === Object && commonjsGlobal;

  var _freeGlobal = freeGlobal;

  /** Detect free variable `self`. */
  var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

  /** Used as a reference to the global object. */
  var root = _freeGlobal || freeSelf || Function('return this')();

  var _root = root;

  /** Built-in value references. */
  var Symbol$1 = _root.Symbol;

  var _Symbol = Symbol$1;

  /**
   * A specialized version of `_.map` for arrays without support for iteratee
   * shorthands.
   *
   * @private
   * @param {Array} [array] The array to iterate over.
   * @param {Function} iteratee The function invoked per iteration.
   * @returns {Array} Returns the new mapped array.
   */
  function arrayMap(array, iteratee) {
    var index = -1,
        length = array == null ? 0 : array.length,
        result = Array(length);

    while (++index < length) {
      result[index] = iteratee(array[index], index, array);
    }
    return result;
  }

  var _arrayMap = arrayMap;

  /**
   * Checks if `value` is classified as an `Array` object.
   *
   * @static
   * @memberOf _
   * @since 0.1.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is an array, else `false`.
   * @example
   *
   * _.isArray([1, 2, 3]);
   * // => true
   *
   * _.isArray(document.body.children);
   * // => false
   *
   * _.isArray('abc');
   * // => false
   *
   * _.isArray(_.noop);
   * // => false
   */
  var isArray = Array.isArray;

  var isArray_1 = isArray;

  /** Used for built-in method references. */
  var objectProto = Object.prototype;

  /** Used to check objects for own properties. */
  var hasOwnProperty = objectProto.hasOwnProperty;

  /**
   * Used to resolve the
   * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
   * of values.
   */
  var nativeObjectToString = objectProto.toString;

  /** Built-in value references. */
  var symToStringTag = _Symbol ? _Symbol.toStringTag : undefined;

  /**
   * A specialized version of `baseGetTag` which ignores `Symbol.toStringTag` values.
   *
   * @private
   * @param {*} value The value to query.
   * @returns {string} Returns the raw `toStringTag`.
   */
  function getRawTag(value) {
    var isOwn = hasOwnProperty.call(value, symToStringTag),
        tag = value[symToStringTag];

    try {
      value[symToStringTag] = undefined;
      var unmasked = true;
    } catch (e) {}

    var result = nativeObjectToString.call(value);
    if (unmasked) {
      if (isOwn) {
        value[symToStringTag] = tag;
      } else {
        delete value[symToStringTag];
      }
    }
    return result;
  }

  var _getRawTag = getRawTag;

  /** Used for built-in method references. */
  var objectProto$1 = Object.prototype;

  /**
   * Used to resolve the
   * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
   * of values.
   */
  var nativeObjectToString$1 = objectProto$1.toString;

  /**
   * Converts `value` to a string using `Object.prototype.toString`.
   *
   * @private
   * @param {*} value The value to convert.
   * @returns {string} Returns the converted string.
   */
  function objectToString(value) {
    return nativeObjectToString$1.call(value);
  }

  var _objectToString = objectToString;

  /** `Object#toString` result references. */
  var nullTag = '[object Null]',
      undefinedTag = '[object Undefined]';

  /** Built-in value references. */
  var symToStringTag$1 = _Symbol ? _Symbol.toStringTag : undefined;

  /**
   * The base implementation of `getTag` without fallbacks for buggy environments.
   *
   * @private
   * @param {*} value The value to query.
   * @returns {string} Returns the `toStringTag`.
   */
  function baseGetTag(value) {
    if (value == null) {
      return value === undefined ? undefinedTag : nullTag;
    }
    return (symToStringTag$1 && symToStringTag$1 in Object(value))
      ? _getRawTag(value)
      : _objectToString(value);
  }

  var _baseGetTag = baseGetTag;

  /**
   * Checks if `value` is object-like. A value is object-like if it's not `null`
   * and has a `typeof` result of "object".
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
   * @example
   *
   * _.isObjectLike({});
   * // => true
   *
   * _.isObjectLike([1, 2, 3]);
   * // => true
   *
   * _.isObjectLike(_.noop);
   * // => false
   *
   * _.isObjectLike(null);
   * // => false
   */
  function isObjectLike(value) {
    return value != null && typeof value == 'object';
  }

  var isObjectLike_1 = isObjectLike;

  /** `Object#toString` result references. */
  var symbolTag = '[object Symbol]';

  /**
   * Checks if `value` is classified as a `Symbol` primitive or object.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
   * @example
   *
   * _.isSymbol(Symbol.iterator);
   * // => true
   *
   * _.isSymbol('abc');
   * // => false
   */
  function isSymbol(value) {
    return typeof value == 'symbol' ||
      (isObjectLike_1(value) && _baseGetTag(value) == symbolTag);
  }

  var isSymbol_1 = isSymbol;

  /** Used as references for various `Number` constants. */
  var INFINITY = 1 / 0;

  /** Used to convert symbols to primitives and strings. */
  var symbolProto = _Symbol ? _Symbol.prototype : undefined,
      symbolToString = symbolProto ? symbolProto.toString : undefined;

  /**
   * The base implementation of `_.toString` which doesn't convert nullish
   * values to empty strings.
   *
   * @private
   * @param {*} value The value to process.
   * @returns {string} Returns the string.
   */
  function baseToString(value) {
    // Exit early for strings to avoid a performance hit in some environments.
    if (typeof value == 'string') {
      return value;
    }
    if (isArray_1(value)) {
      // Recursively convert values (susceptible to call stack limits).
      return _arrayMap(value, baseToString) + '';
    }
    if (isSymbol_1(value)) {
      return symbolToString ? symbolToString.call(value) : '';
    }
    var result = (value + '');
    return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
  }

  var _baseToString = baseToString;

  /**
   * Converts `value` to a string. An empty string is returned for `null`
   * and `undefined` values. The sign of `-0` is preserved.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Lang
   * @param {*} value The value to convert.
   * @returns {string} Returns the converted string.
   * @example
   *
   * _.toString(null);
   * // => ''
   *
   * _.toString(-0);
   * // => '-0'
   *
   * _.toString([1, 2, 3]);
   * // => '1,2,3'
   */
  function toString(value) {
    return value == null ? '' : _baseToString(value);
  }

  var toString_1 = toString;

  /**
   * The base implementation of `_.slice` without an iteratee call guard.
   *
   * @private
   * @param {Array} array The array to slice.
   * @param {number} [start=0] The start position.
   * @param {number} [end=array.length] The end position.
   * @returns {Array} Returns the slice of `array`.
   */
  function baseSlice(array, start, end) {
    var index = -1,
        length = array.length;

    if (start < 0) {
      start = -start > length ? 0 : (length + start);
    }
    end = end > length ? length : end;
    if (end < 0) {
      end += length;
    }
    length = start > end ? 0 : ((end - start) >>> 0);
    start >>>= 0;

    var result = Array(length);
    while (++index < length) {
      result[index] = array[index + start];
    }
    return result;
  }

  var _baseSlice = baseSlice;

  /**
   * Casts `array` to a slice if it's needed.
   *
   * @private
   * @param {Array} array The array to inspect.
   * @param {number} start The start position.
   * @param {number} [end=array.length] The end position.
   * @returns {Array} Returns the cast slice.
   */
  function castSlice(array, start, end) {
    var length = array.length;
    end = end === undefined ? length : end;
    return (!start && end >= length) ? array : _baseSlice(array, start, end);
  }

  var _castSlice = castSlice;

  /** Used to compose unicode character classes. */
  var rsAstralRange = '\\ud800-\\udfff',
      rsComboMarksRange = '\\u0300-\\u036f',
      reComboHalfMarksRange = '\\ufe20-\\ufe2f',
      rsComboSymbolsRange = '\\u20d0-\\u20ff',
      rsComboRange = rsComboMarksRange + reComboHalfMarksRange + rsComboSymbolsRange,
      rsVarRange = '\\ufe0e\\ufe0f';

  /** Used to compose unicode capture groups. */
  var rsZWJ = '\\u200d';

  /** Used to detect strings with [zero-width joiners or code points from the astral planes](http://eev.ee/blog/2015/09/12/dark-corners-of-unicode/). */
  var reHasUnicode = RegExp('[' + rsZWJ + rsAstralRange  + rsComboRange + rsVarRange + ']');

  /**
   * Checks if `string` contains Unicode symbols.
   *
   * @private
   * @param {string} string The string to inspect.
   * @returns {boolean} Returns `true` if a symbol is found, else `false`.
   */
  function hasUnicode(string) {
    return reHasUnicode.test(string);
  }

  var _hasUnicode = hasUnicode;

  /**
   * Converts an ASCII `string` to an array.
   *
   * @private
   * @param {string} string The string to convert.
   * @returns {Array} Returns the converted array.
   */
  function asciiToArray(string) {
    return string.split('');
  }

  var _asciiToArray = asciiToArray;

  /** Used to compose unicode character classes. */
  var rsAstralRange$1 = '\\ud800-\\udfff',
      rsComboMarksRange$1 = '\\u0300-\\u036f',
      reComboHalfMarksRange$1 = '\\ufe20-\\ufe2f',
      rsComboSymbolsRange$1 = '\\u20d0-\\u20ff',
      rsComboRange$1 = rsComboMarksRange$1 + reComboHalfMarksRange$1 + rsComboSymbolsRange$1,
      rsVarRange$1 = '\\ufe0e\\ufe0f';

  /** Used to compose unicode capture groups. */
  var rsAstral = '[' + rsAstralRange$1 + ']',
      rsCombo = '[' + rsComboRange$1 + ']',
      rsFitz = '\\ud83c[\\udffb-\\udfff]',
      rsModifier = '(?:' + rsCombo + '|' + rsFitz + ')',
      rsNonAstral = '[^' + rsAstralRange$1 + ']',
      rsRegional = '(?:\\ud83c[\\udde6-\\uddff]){2}',
      rsSurrPair = '[\\ud800-\\udbff][\\udc00-\\udfff]',
      rsZWJ$1 = '\\u200d';

  /** Used to compose unicode regexes. */
  var reOptMod = rsModifier + '?',
      rsOptVar = '[' + rsVarRange$1 + ']?',
      rsOptJoin = '(?:' + rsZWJ$1 + '(?:' + [rsNonAstral, rsRegional, rsSurrPair].join('|') + ')' + rsOptVar + reOptMod + ')*',
      rsSeq = rsOptVar + reOptMod + rsOptJoin,
      rsSymbol = '(?:' + [rsNonAstral + rsCombo + '?', rsCombo, rsRegional, rsSurrPair, rsAstral].join('|') + ')';

  /** Used to match [string symbols](https://mathiasbynens.be/notes/javascript-unicode). */
  var reUnicode = RegExp(rsFitz + '(?=' + rsFitz + ')|' + rsSymbol + rsSeq, 'g');

  /**
   * Converts a Unicode `string` to an array.
   *
   * @private
   * @param {string} string The string to convert.
   * @returns {Array} Returns the converted array.
   */
  function unicodeToArray(string) {
    return string.match(reUnicode) || [];
  }

  var _unicodeToArray = unicodeToArray;

  /**
   * Converts `string` to an array.
   *
   * @private
   * @param {string} string The string to convert.
   * @returns {Array} Returns the converted array.
   */
  function stringToArray(string) {
    return _hasUnicode(string)
      ? _unicodeToArray(string)
      : _asciiToArray(string);
  }

  var _stringToArray = stringToArray;

  /**
   * Creates a function like `_.lowerFirst`.
   *
   * @private
   * @param {string} methodName The name of the `String` case method to use.
   * @returns {Function} Returns the new case function.
   */
  function createCaseFirst(methodName) {
    return function(string) {
      string = toString_1(string);

      var strSymbols = _hasUnicode(string)
        ? _stringToArray(string)
        : undefined;

      var chr = strSymbols
        ? strSymbols[0]
        : string.charAt(0);

      var trailing = strSymbols
        ? _castSlice(strSymbols, 1).join('')
        : string.slice(1);

      return chr[methodName]() + trailing;
    };
  }

  var _createCaseFirst = createCaseFirst;

  /**
   * Converts the first character of `string` to upper case.
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category String
   * @param {string} [string=''] The string to convert.
   * @returns {string} Returns the converted string.
   * @example
   *
   * _.upperFirst('fred');
   * // => 'Fred'
   *
   * _.upperFirst('FRED');
   * // => 'FRED'
   */
  var upperFirst = _createCaseFirst('toUpperCase');

  var upperFirst_1 = upperFirst;

  /**
   * Converts the first character of `string` to upper case and the remaining
   * to lower case.
   *
   * @static
   * @memberOf _
   * @since 3.0.0
   * @category String
   * @param {string} [string=''] The string to capitalize.
   * @returns {string} Returns the capitalized string.
   * @example
   *
   * _.capitalize('FRED');
   * // => 'Fred'
   */
  function capitalize(string) {
    return upperFirst_1(toString_1(string).toLowerCase());
  }

  var capitalize_1 = capitalize;

  /**
   * A specialized version of `_.reduce` for arrays without support for
   * iteratee shorthands.
   *
   * @private
   * @param {Array} [array] The array to iterate over.
   * @param {Function} iteratee The function invoked per iteration.
   * @param {*} [accumulator] The initial value.
   * @param {boolean} [initAccum] Specify using the first element of `array` as
   *  the initial value.
   * @returns {*} Returns the accumulated value.
   */
  function arrayReduce(array, iteratee, accumulator, initAccum) {
    var index = -1,
        length = array == null ? 0 : array.length;

    if (initAccum && length) {
      accumulator = array[++index];
    }
    while (++index < length) {
      accumulator = iteratee(accumulator, array[index], index, array);
    }
    return accumulator;
  }

  var _arrayReduce = arrayReduce;

  /**
   * The base implementation of `_.propertyOf` without support for deep paths.
   *
   * @private
   * @param {Object} object The object to query.
   * @returns {Function} Returns the new accessor function.
   */
  function basePropertyOf(object) {
    return function(key) {
      return object == null ? undefined : object[key];
    };
  }

  var _basePropertyOf = basePropertyOf;

  /** Used to map Latin Unicode letters to basic Latin letters. */
  var deburredLetters = {
    // Latin-1 Supplement block.
    '\xc0': 'A',  '\xc1': 'A', '\xc2': 'A', '\xc3': 'A', '\xc4': 'A', '\xc5': 'A',
    '\xe0': 'a',  '\xe1': 'a', '\xe2': 'a', '\xe3': 'a', '\xe4': 'a', '\xe5': 'a',
    '\xc7': 'C',  '\xe7': 'c',
    '\xd0': 'D',  '\xf0': 'd',
    '\xc8': 'E',  '\xc9': 'E', '\xca': 'E', '\xcb': 'E',
    '\xe8': 'e',  '\xe9': 'e', '\xea': 'e', '\xeb': 'e',
    '\xcc': 'I',  '\xcd': 'I', '\xce': 'I', '\xcf': 'I',
    '\xec': 'i',  '\xed': 'i', '\xee': 'i', '\xef': 'i',
    '\xd1': 'N',  '\xf1': 'n',
    '\xd2': 'O',  '\xd3': 'O', '\xd4': 'O', '\xd5': 'O', '\xd6': 'O', '\xd8': 'O',
    '\xf2': 'o',  '\xf3': 'o', '\xf4': 'o', '\xf5': 'o', '\xf6': 'o', '\xf8': 'o',
    '\xd9': 'U',  '\xda': 'U', '\xdb': 'U', '\xdc': 'U',
    '\xf9': 'u',  '\xfa': 'u', '\xfb': 'u', '\xfc': 'u',
    '\xdd': 'Y',  '\xfd': 'y', '\xff': 'y',
    '\xc6': 'Ae', '\xe6': 'ae',
    '\xde': 'Th', '\xfe': 'th',
    '\xdf': 'ss',
    // Latin Extended-A block.
    '\u0100': 'A',  '\u0102': 'A', '\u0104': 'A',
    '\u0101': 'a',  '\u0103': 'a', '\u0105': 'a',
    '\u0106': 'C',  '\u0108': 'C', '\u010a': 'C', '\u010c': 'C',
    '\u0107': 'c',  '\u0109': 'c', '\u010b': 'c', '\u010d': 'c',
    '\u010e': 'D',  '\u0110': 'D', '\u010f': 'd', '\u0111': 'd',
    '\u0112': 'E',  '\u0114': 'E', '\u0116': 'E', '\u0118': 'E', '\u011a': 'E',
    '\u0113': 'e',  '\u0115': 'e', '\u0117': 'e', '\u0119': 'e', '\u011b': 'e',
    '\u011c': 'G',  '\u011e': 'G', '\u0120': 'G', '\u0122': 'G',
    '\u011d': 'g',  '\u011f': 'g', '\u0121': 'g', '\u0123': 'g',
    '\u0124': 'H',  '\u0126': 'H', '\u0125': 'h', '\u0127': 'h',
    '\u0128': 'I',  '\u012a': 'I', '\u012c': 'I', '\u012e': 'I', '\u0130': 'I',
    '\u0129': 'i',  '\u012b': 'i', '\u012d': 'i', '\u012f': 'i', '\u0131': 'i',
    '\u0134': 'J',  '\u0135': 'j',
    '\u0136': 'K',  '\u0137': 'k', '\u0138': 'k',
    '\u0139': 'L',  '\u013b': 'L', '\u013d': 'L', '\u013f': 'L', '\u0141': 'L',
    '\u013a': 'l',  '\u013c': 'l', '\u013e': 'l', '\u0140': 'l', '\u0142': 'l',
    '\u0143': 'N',  '\u0145': 'N', '\u0147': 'N', '\u014a': 'N',
    '\u0144': 'n',  '\u0146': 'n', '\u0148': 'n', '\u014b': 'n',
    '\u014c': 'O',  '\u014e': 'O', '\u0150': 'O',
    '\u014d': 'o',  '\u014f': 'o', '\u0151': 'o',
    '\u0154': 'R',  '\u0156': 'R', '\u0158': 'R',
    '\u0155': 'r',  '\u0157': 'r', '\u0159': 'r',
    '\u015a': 'S',  '\u015c': 'S', '\u015e': 'S', '\u0160': 'S',
    '\u015b': 's',  '\u015d': 's', '\u015f': 's', '\u0161': 's',
    '\u0162': 'T',  '\u0164': 'T', '\u0166': 'T',
    '\u0163': 't',  '\u0165': 't', '\u0167': 't',
    '\u0168': 'U',  '\u016a': 'U', '\u016c': 'U', '\u016e': 'U', '\u0170': 'U', '\u0172': 'U',
    '\u0169': 'u',  '\u016b': 'u', '\u016d': 'u', '\u016f': 'u', '\u0171': 'u', '\u0173': 'u',
    '\u0174': 'W',  '\u0175': 'w',
    '\u0176': 'Y',  '\u0177': 'y', '\u0178': 'Y',
    '\u0179': 'Z',  '\u017b': 'Z', '\u017d': 'Z',
    '\u017a': 'z',  '\u017c': 'z', '\u017e': 'z',
    '\u0132': 'IJ', '\u0133': 'ij',
    '\u0152': 'Oe', '\u0153': 'oe',
    '\u0149': "'n", '\u017f': 's'
  };

  /**
   * Used by `_.deburr` to convert Latin-1 Supplement and Latin Extended-A
   * letters to basic Latin letters.
   *
   * @private
   * @param {string} letter The matched letter to deburr.
   * @returns {string} Returns the deburred letter.
   */
  var deburrLetter = _basePropertyOf(deburredLetters);

  var _deburrLetter = deburrLetter;

  /** Used to match Latin Unicode letters (excluding mathematical operators). */
  var reLatin = /[\xc0-\xd6\xd8-\xf6\xf8-\xff\u0100-\u017f]/g;

  /** Used to compose unicode character classes. */
  var rsComboMarksRange$2 = '\\u0300-\\u036f',
      reComboHalfMarksRange$2 = '\\ufe20-\\ufe2f',
      rsComboSymbolsRange$2 = '\\u20d0-\\u20ff',
      rsComboRange$2 = rsComboMarksRange$2 + reComboHalfMarksRange$2 + rsComboSymbolsRange$2;

  /** Used to compose unicode capture groups. */
  var rsCombo$1 = '[' + rsComboRange$2 + ']';

  /**
   * Used to match [combining diacritical marks](https://en.wikipedia.org/wiki/Combining_Diacritical_Marks) and
   * [combining diacritical marks for symbols](https://en.wikipedia.org/wiki/Combining_Diacritical_Marks_for_Symbols).
   */
  var reComboMark = RegExp(rsCombo$1, 'g');

  /**
   * Deburrs `string` by converting
   * [Latin-1 Supplement](https://en.wikipedia.org/wiki/Latin-1_Supplement_(Unicode_block)#Character_table)
   * and [Latin Extended-A](https://en.wikipedia.org/wiki/Latin_Extended-A)
   * letters to basic Latin letters and removing
   * [combining diacritical marks](https://en.wikipedia.org/wiki/Combining_Diacritical_Marks).
   *
   * @static
   * @memberOf _
   * @since 3.0.0
   * @category String
   * @param {string} [string=''] The string to deburr.
   * @returns {string} Returns the deburred string.
   * @example
   *
   * _.deburr('déjà vu');
   * // => 'deja vu'
   */
  function deburr(string) {
    string = toString_1(string);
    return string && string.replace(reLatin, _deburrLetter).replace(reComboMark, '');
  }

  var deburr_1 = deburr;

  /** Used to match words composed of alphanumeric characters. */
  var reAsciiWord = /[^\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\x7f]+/g;

  /**
   * Splits an ASCII `string` into an array of its words.
   *
   * @private
   * @param {string} The string to inspect.
   * @returns {Array} Returns the words of `string`.
   */
  function asciiWords(string) {
    return string.match(reAsciiWord) || [];
  }

  var _asciiWords = asciiWords;

  /** Used to detect strings that need a more robust regexp to match words. */
  var reHasUnicodeWord = /[a-z][A-Z]|[A-Z]{2}[a-z]|[0-9][a-zA-Z]|[a-zA-Z][0-9]|[^a-zA-Z0-9 ]/;

  /**
   * Checks if `string` contains a word composed of Unicode symbols.
   *
   * @private
   * @param {string} string The string to inspect.
   * @returns {boolean} Returns `true` if a word is found, else `false`.
   */
  function hasUnicodeWord(string) {
    return reHasUnicodeWord.test(string);
  }

  var _hasUnicodeWord = hasUnicodeWord;

  /** Used to compose unicode character classes. */
  var rsAstralRange$2 = '\\ud800-\\udfff',
      rsComboMarksRange$3 = '\\u0300-\\u036f',
      reComboHalfMarksRange$3 = '\\ufe20-\\ufe2f',
      rsComboSymbolsRange$3 = '\\u20d0-\\u20ff',
      rsComboRange$3 = rsComboMarksRange$3 + reComboHalfMarksRange$3 + rsComboSymbolsRange$3,
      rsDingbatRange = '\\u2700-\\u27bf',
      rsLowerRange = 'a-z\\xdf-\\xf6\\xf8-\\xff',
      rsMathOpRange = '\\xac\\xb1\\xd7\\xf7',
      rsNonCharRange = '\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf',
      rsPunctuationRange = '\\u2000-\\u206f',
      rsSpaceRange = ' \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000',
      rsUpperRange = 'A-Z\\xc0-\\xd6\\xd8-\\xde',
      rsVarRange$2 = '\\ufe0e\\ufe0f',
      rsBreakRange = rsMathOpRange + rsNonCharRange + rsPunctuationRange + rsSpaceRange;

  /** Used to compose unicode capture groups. */
  var rsApos = "['\u2019]",
      rsBreak = '[' + rsBreakRange + ']',
      rsCombo$2 = '[' + rsComboRange$3 + ']',
      rsDigits = '\\d+',
      rsDingbat = '[' + rsDingbatRange + ']',
      rsLower = '[' + rsLowerRange + ']',
      rsMisc = '[^' + rsAstralRange$2 + rsBreakRange + rsDigits + rsDingbatRange + rsLowerRange + rsUpperRange + ']',
      rsFitz$1 = '\\ud83c[\\udffb-\\udfff]',
      rsModifier$1 = '(?:' + rsCombo$2 + '|' + rsFitz$1 + ')',
      rsNonAstral$1 = '[^' + rsAstralRange$2 + ']',
      rsRegional$1 = '(?:\\ud83c[\\udde6-\\uddff]){2}',
      rsSurrPair$1 = '[\\ud800-\\udbff][\\udc00-\\udfff]',
      rsUpper = '[' + rsUpperRange + ']',
      rsZWJ$2 = '\\u200d';

  /** Used to compose unicode regexes. */
  var rsMiscLower = '(?:' + rsLower + '|' + rsMisc + ')',
      rsMiscUpper = '(?:' + rsUpper + '|' + rsMisc + ')',
      rsOptContrLower = '(?:' + rsApos + '(?:d|ll|m|re|s|t|ve))?',
      rsOptContrUpper = '(?:' + rsApos + '(?:D|LL|M|RE|S|T|VE))?',
      reOptMod$1 = rsModifier$1 + '?',
      rsOptVar$1 = '[' + rsVarRange$2 + ']?',
      rsOptJoin$1 = '(?:' + rsZWJ$2 + '(?:' + [rsNonAstral$1, rsRegional$1, rsSurrPair$1].join('|') + ')' + rsOptVar$1 + reOptMod$1 + ')*',
      rsOrdLower = '\\d*(?:1st|2nd|3rd|(?![123])\\dth)(?=\\b|[A-Z_])',
      rsOrdUpper = '\\d*(?:1ST|2ND|3RD|(?![123])\\dTH)(?=\\b|[a-z_])',
      rsSeq$1 = rsOptVar$1 + reOptMod$1 + rsOptJoin$1,
      rsEmoji = '(?:' + [rsDingbat, rsRegional$1, rsSurrPair$1].join('|') + ')' + rsSeq$1;

  /** Used to match complex or compound words. */
  var reUnicodeWord = RegExp([
    rsUpper + '?' + rsLower + '+' + rsOptContrLower + '(?=' + [rsBreak, rsUpper, '$'].join('|') + ')',
    rsMiscUpper + '+' + rsOptContrUpper + '(?=' + [rsBreak, rsUpper + rsMiscLower, '$'].join('|') + ')',
    rsUpper + '?' + rsMiscLower + '+' + rsOptContrLower,
    rsUpper + '+' + rsOptContrUpper,
    rsOrdUpper,
    rsOrdLower,
    rsDigits,
    rsEmoji
  ].join('|'), 'g');

  /**
   * Splits a Unicode `string` into an array of its words.
   *
   * @private
   * @param {string} The string to inspect.
   * @returns {Array} Returns the words of `string`.
   */
  function unicodeWords(string) {
    return string.match(reUnicodeWord) || [];
  }

  var _unicodeWords = unicodeWords;

  /**
   * Splits `string` into an array of its words.
   *
   * @static
   * @memberOf _
   * @since 3.0.0
   * @category String
   * @param {string} [string=''] The string to inspect.
   * @param {RegExp|string} [pattern] The pattern to match words.
   * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
   * @returns {Array} Returns the words of `string`.
   * @example
   *
   * _.words('fred, barney, & pebbles');
   * // => ['fred', 'barney', 'pebbles']
   *
   * _.words('fred, barney, & pebbles', /[^, ]+/g);
   * // => ['fred', 'barney', '&', 'pebbles']
   */
  function words(string, pattern, guard) {
    string = toString_1(string);
    pattern = guard ? undefined : pattern;

    if (pattern === undefined) {
      return _hasUnicodeWord(string) ? _unicodeWords(string) : _asciiWords(string);
    }
    return string.match(pattern) || [];
  }

  var words_1 = words;

  /** Used to compose unicode capture groups. */
  var rsApos$1 = "['\u2019]";

  /** Used to match apostrophes. */
  var reApos = RegExp(rsApos$1, 'g');

  /**
   * Creates a function like `_.camelCase`.
   *
   * @private
   * @param {Function} callback The function to combine each word.
   * @returns {Function} Returns the new compounder function.
   */
  function createCompounder(callback) {
    return function(string) {
      return _arrayReduce(words_1(deburr_1(string).replace(reApos, '')), callback, '');
    };
  }

  var _createCompounder = createCompounder;

  /**
   * Converts `string` to [camel case](https://en.wikipedia.org/wiki/CamelCase).
   *
   * @static
   * @memberOf _
   * @since 3.0.0
   * @category String
   * @param {string} [string=''] The string to convert.
   * @returns {string} Returns the camel cased string.
   * @example
   *
   * _.camelCase('Foo Bar');
   * // => 'fooBar'
   *
   * _.camelCase('--foo-bar--');
   * // => 'fooBar'
   *
   * _.camelCase('__FOO_BAR__');
   * // => 'fooBar'
   */
  var camelCase = _createCompounder(function(result, word, index) {
    word = word.toLowerCase();
    return result + (index ? capitalize_1(word) : word);
  });

  var camelCase_1 = camelCase;

  function warning(valid, message) {
    warn(valid, "[@ant-design/icons] ".concat(message));
  }
  function isIconDefinition(target) {
    return _typeof(target) === 'object' && typeof target.name === 'string' && typeof target.theme === 'string' && (_typeof(target.icon) === 'object' || typeof target.icon === 'function');
  }
  function normalizeAttrs() {
    var attrs = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    return Object.keys(attrs).reduce(function (acc, key) {
      var val = attrs[key];
      switch (key) {
        case 'class':
          acc.className = val;
          delete acc.class;
          break;
        default:
          delete acc[key];
          acc[camelCase_1(key)] = val;
      }
      return acc;
    }, {});
  }
  function generate$1(node, key, rootProps) {
    if (!rootProps) {
      return /*#__PURE__*/React__default['default'].createElement(node.tag, _objectSpread({
        key: key
      }, normalizeAttrs(node.attrs)), (node.children || []).map(function (child, index) {
        return generate$1(child, "".concat(key, "-").concat(node.tag, "-").concat(index));
      }));
    }
    return /*#__PURE__*/React__default['default'].createElement(node.tag, _objectSpread(_objectSpread({
      key: key
    }, normalizeAttrs(node.attrs)), rootProps), (node.children || []).map(function (child, index) {
      return generate$1(child, "".concat(key, "-").concat(node.tag, "-").concat(index));
    }));
  }
  function getSecondaryColor(primaryColor) {
    // choose the second color
    return generate(primaryColor)[0];
  }
  function normalizeTwoToneColors(twoToneColor) {
    if (!twoToneColor) {
      return [];
    }
    return Array.isArray(twoToneColor) ? twoToneColor : [twoToneColor];
  }
  // These props make sure that the SVG behaviours like general text.
  // Reference: https://blog.prototypr.io/align-svg-icons-to-text-and-say-goodbye-to-font-icons-d44b3d7b26b4
  var svgBaseProps = {
    width: '1em',
    height: '1em',
    fill: 'currentColor',
    'aria-hidden': 'true',
    focusable: 'false'
  };
  var iconStyles = "\n.anticon {\n  display: inline-flex;\n  alignItems: center;\n  color: inherit;\n  font-style: normal;\n  line-height: 0;\n  text-align: center;\n  text-transform: none;\n  vertical-align: -0.125em;\n  text-rendering: optimizeLegibility;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n}\n\n.anticon > * {\n  line-height: 1;\n}\n\n.anticon svg {\n  display: inline-block;\n}\n\n.anticon::before {\n  display: none;\n}\n\n.anticon .anticon-icon {\n  display: block;\n}\n\n.anticon[tabindex] {\n  cursor: pointer;\n}\n\n.anticon-spin::before,\n.anticon-spin {\n  display: inline-block;\n  -webkit-animation: loadingCircle 1s infinite linear;\n  animation: loadingCircle 1s infinite linear;\n}\n\n@-webkit-keyframes loadingCircle {\n  100% {\n    -webkit-transform: rotate(360deg);\n    transform: rotate(360deg);\n  }\n}\n\n@keyframes loadingCircle {\n  100% {\n    -webkit-transform: rotate(360deg);\n    transform: rotate(360deg);\n  }\n}\n";
  var useInsertStyles = function useInsertStyles() {
    var styleStr = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : iconStyles;
    var _useContext = React.useContext(IconContext),
      csp = _useContext.csp;
    React.useEffect(function () {
      dynamicCSS.updateCSS(styleStr, '@ant-design-icons', {
        prepend: true,
        csp: csp
      });
    }, []);
  };

  var _excluded = ["icon", "className", "onClick", "style", "primaryColor", "secondaryColor"];
  var twoToneColorPalette = {
    primaryColor: '#333',
    secondaryColor: '#E6E6E6',
    calculated: false
  };
  function setTwoToneColors(_ref) {
    var primaryColor = _ref.primaryColor,
      secondaryColor = _ref.secondaryColor;
    twoToneColorPalette.primaryColor = primaryColor;
    twoToneColorPalette.secondaryColor = secondaryColor || getSecondaryColor(primaryColor);
    twoToneColorPalette.calculated = !!secondaryColor;
  }
  function getTwoToneColors() {
    return _objectSpread({}, twoToneColorPalette);
  }
  var IconBase = function IconBase(props) {
    var icon = props.icon,
      className = props.className,
      onClick = props.onClick,
      style = props.style,
      primaryColor = props.primaryColor,
      secondaryColor = props.secondaryColor,
      restProps = _objectWithoutProperties(props, _excluded);
    var colors = twoToneColorPalette;
    if (primaryColor) {
      colors = {
        primaryColor: primaryColor,
        secondaryColor: secondaryColor || getSecondaryColor(primaryColor)
      };
    }
    useInsertStyles();
    warning(isIconDefinition(icon), "icon should be icon definiton, but got ".concat(icon));
    if (!isIconDefinition(icon)) {
      return null;
    }
    var target = icon;
    if (target && typeof target.icon === 'function') {
      target = _objectSpread(_objectSpread({}, target), {}, {
        icon: target.icon(colors.primaryColor, colors.secondaryColor)
      });
    }
    return generate$1(target.icon, "svg-".concat(target.name), _objectSpread({
      className: className,
      onClick: onClick,
      style: style,
      'data-icon': target.name,
      width: '1em',
      height: '1em',
      fill: 'currentColor',
      'aria-hidden': 'true'
    }, restProps));
  };
  IconBase.displayName = 'IconReact';
  IconBase.getTwoToneColors = getTwoToneColors;
  IconBase.setTwoToneColors = setTwoToneColors;

  function setTwoToneColor(twoToneColor) {
    var _normalizeTwoToneColo = normalizeTwoToneColors(twoToneColor),
      _normalizeTwoToneColo2 = _slicedToArray(_normalizeTwoToneColo, 2),
      primaryColor = _normalizeTwoToneColo2[0],
      secondaryColor = _normalizeTwoToneColo2[1];
    return IconBase.setTwoToneColors({
      primaryColor: primaryColor,
      secondaryColor: secondaryColor
    });
  }
  function getTwoToneColor() {
    var colors = IconBase.getTwoToneColors();
    if (!colors.calculated) {
      return colors.primaryColor;
    }
    return [colors.primaryColor, colors.secondaryColor];
  }

  var _excluded$1 = ["className", "icon", "spin", "rotate", "tabIndex", "onClick", "twoToneColor"];
  // Initial setting
  // should move it to antd main repo?
  setTwoToneColor('#1890ff');
  var Icon = /*#__PURE__*/React.forwardRef(function (props, ref) {
    var className = props.className,
      icon = props.icon,
      spin = props.spin,
      rotate = props.rotate,
      tabIndex = props.tabIndex,
      onClick = props.onClick,
      twoToneColor = props.twoToneColor,
      restProps = _objectWithoutProperties(props, _excluded$1);
    var _React$useContext = React.useContext(IconContext),
      _React$useContext$pre = _React$useContext.prefixCls,
      prefixCls = _React$useContext$pre === void 0 ? 'anticon' : _React$useContext$pre,
      rootClassName = _React$useContext.rootClassName;
    var classString = classnames(rootClassName, prefixCls, _defineProperty(_defineProperty({}, "".concat(prefixCls, "-").concat(icon.name), !!icon.name), "".concat(prefixCls, "-spin"), !!spin || icon.name === 'loading'), className);
    var iconTabIndex = tabIndex;
    if (iconTabIndex === undefined && onClick) {
      iconTabIndex = -1;
    }
    var svgStyle = rotate ? {
      msTransform: "rotate(".concat(rotate, "deg)"),
      transform: "rotate(".concat(rotate, "deg)")
    } : undefined;
    var _normalizeTwoToneColo = normalizeTwoToneColors(twoToneColor),
      _normalizeTwoToneColo2 = _slicedToArray(_normalizeTwoToneColo, 2),
      primaryColor = _normalizeTwoToneColo2[0],
      secondaryColor = _normalizeTwoToneColo2[1];
    return /*#__PURE__*/React.createElement("span", _objectSpread(_objectSpread({
      role: "img",
      "aria-label": icon.name
    }, restProps), {}, {
      ref: ref,
      tabIndex: iconTabIndex,
      onClick: onClick,
      className: classString
    }), /*#__PURE__*/React.createElement(IconBase, {
      icon: icon,
      primaryColor: primaryColor,
      secondaryColor: secondaryColor,
      style: svgStyle
    }));
  });
  Icon.displayName = 'AntdIcon';
  Icon.getTwoToneColor = getTwoToneColor;
  Icon.setTwoToneColor = setTwoToneColor;

  var AccountBookFilled = function AccountBookFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: AccountBookFilledSvg
    }));
  };
  var RefIcon = /*#__PURE__*/React.forwardRef(AccountBookFilled);
  {
    RefIcon.displayName = 'AccountBookFilled';
  }

  var AccountBookOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var AccountBookOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 184H712v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H384v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H144c-17.7 0-32 14.3-32 32v664c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V216c0-17.7-14.3-32-32-32zm-40 656H184V256h128v48c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-48h256v48c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-48h128v584zM639.5 414h-45c-3 0-5.8 1.7-7.1 4.4L514 563.8h-2.8l-73.4-145.4a8 8 0 00-7.1-4.4h-46c-1.3 0-2.7.3-3.8 1-3.9 2.1-5.3 7-3.2 10.9l89.3 164h-48.6c-4.4 0-8 3.6-8 8v21.3c0 4.4 3.6 8 8 8h65.1v33.7h-65.1c-4.4 0-8 3.6-8 8v21.3c0 4.4 3.6 8 8 8h65.1V752c0 4.4 3.6 8 8 8h41.3c4.4 0 8-3.6 8-8v-53.8h65.4c4.4 0 8-3.6 8-8v-21.3c0-4.4-3.6-8-8-8h-65.4v-33.7h65.4c4.4 0 8-3.6 8-8v-21.3c0-4.4-3.6-8-8-8h-49.1l89.3-164.1c.6-1.2 1-2.5 1-3.8.1-4.4-3.4-8-7.9-8z" } }] }, "name": "account-book", "theme": "outlined" };
  exports.default = AccountBookOutlined;
  });

  var AccountBookOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(AccountBookOutlined_1);

  var AccountBookOutlined = function AccountBookOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: AccountBookOutlinedSvg
    }));
  };
  var RefIcon$1 = /*#__PURE__*/React.forwardRef(AccountBookOutlined);
  {
    RefIcon$1.displayName = 'AccountBookOutlined';
  }

  var AccountBookTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var AccountBookTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M712 304c0 4.4-3.6 8-8 8h-56c-4.4 0-8-3.6-8-8v-48H384v48c0 4.4-3.6 8-8 8h-56c-4.4 0-8-3.6-8-8v-48H184v584h656V256H712v48zm-65.6 121.8l-89.3 164.1h49.1c4.4 0 8 3.6 8 8v21.3c0 4.4-3.6 8-8 8h-65.4v33.7h65.4c4.4 0 8 3.6 8 8v21.3c0 4.4-3.6 8-8 8h-65.4V752c0 4.4-3.6 8-8 8h-41.3c-4.4 0-8-3.6-8-8v-53.8h-65.1c-4.4 0-8-3.6-8-8v-21.3c0-4.4 3.6-8 8-8h65.1v-33.7h-65.1c-4.4 0-8-3.6-8-8v-21.3c0-4.4 3.6-8 8-8H467l-89.3-164c-2.1-3.9-.7-8.8 3.2-10.9 1.1-.7 2.5-1 3.8-1h46a8 8 0 017.1 4.4l73.4 145.4h2.8l73.4-145.4c1.3-2.7 4.1-4.4 7.1-4.4h45c4.5 0 8 3.6 7.9 8 0 1.3-.4 2.6-1 3.8z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M639.5 414h-45c-3 0-5.8 1.7-7.1 4.4L514 563.8h-2.8l-73.4-145.4a8 8 0 00-7.1-4.4h-46c-1.3 0-2.7.3-3.8 1-3.9 2.1-5.3 7-3.2 10.9l89.3 164h-48.6c-4.4 0-8 3.6-8 8v21.3c0 4.4 3.6 8 8 8h65.1v33.7h-65.1c-4.4 0-8 3.6-8 8v21.3c0 4.4 3.6 8 8 8h65.1V752c0 4.4 3.6 8 8 8h41.3c4.4 0 8-3.6 8-8v-53.8h65.4c4.4 0 8-3.6 8-8v-21.3c0-4.4-3.6-8-8-8h-65.4v-33.7h65.4c4.4 0 8-3.6 8-8v-21.3c0-4.4-3.6-8-8-8h-49.1l89.3-164.1c.6-1.2 1-2.5 1-3.8.1-4.4-3.4-8-7.9-8z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M880 184H712v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H384v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H144c-17.7 0-32 14.3-32 32v664c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V216c0-17.7-14.3-32-32-32zm-40 656H184V256h128v48c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-48h256v48c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-48h128v584z", "fill": primaryColor } }] }; }, "name": "account-book", "theme": "twotone" };
  exports.default = AccountBookTwoTone;
  });

  var AccountBookTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(AccountBookTwoTone_1);

  var AccountBookTwoTone = function AccountBookTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: AccountBookTwoToneSvg
    }));
  };
  var RefIcon$2 = /*#__PURE__*/React.forwardRef(AccountBookTwoTone);
  {
    RefIcon$2.displayName = 'AccountBookTwoTone';
  }

  var AimOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var AimOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M952 474H829.8C812.5 327.6 696.4 211.5 550 194.2V72c0-4.4-3.6-8-8-8h-60c-4.4 0-8 3.6-8 8v122.2C327.6 211.5 211.5 327.6 194.2 474H72c-4.4 0-8 3.6-8 8v60c0 4.4 3.6 8 8 8h122.2C211.5 696.4 327.6 812.5 474 829.8V952c0 4.4 3.6 8 8 8h60c4.4 0 8-3.6 8-8V829.8C696.4 812.5 812.5 696.4 829.8 550H952c4.4 0 8-3.6 8-8v-60c0-4.4-3.6-8-8-8zM512 756c-134.8 0-244-109.2-244-244s109.2-244 244-244 244 109.2 244 244-109.2 244-244 244z" } }, { "tag": "path", "attrs": { "d": "M512 392c-32.1 0-62.1 12.4-84.8 35.2-22.7 22.7-35.2 52.7-35.2 84.8s12.5 62.1 35.2 84.8C449.9 619.4 480 632 512 632s62.1-12.5 84.8-35.2C619.4 574.1 632 544 632 512s-12.5-62.1-35.2-84.8A118.57 118.57 0 00512 392z" } }] }, "name": "aim", "theme": "outlined" };
  exports.default = AimOutlined;
  });

  var AimOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(AimOutlined_1);

  var AimOutlined = function AimOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: AimOutlinedSvg
    }));
  };
  var RefIcon$3 = /*#__PURE__*/React.forwardRef(AimOutlined);
  {
    RefIcon$3.displayName = 'AimOutlined';
  }

  var AlertFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var AlertFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 244c176.18 0 319 142.82 319 319v233a32 32 0 01-32 32H225a32 32 0 01-32-32V563c0-176.18 142.82-319 319-319zM484 68h56a8 8 0 018 8v96a8 8 0 01-8 8h-56a8 8 0 01-8-8V76a8 8 0 018-8zM177.25 191.66a8 8 0 0111.32 0l67.88 67.88a8 8 0 010 11.31l-39.6 39.6a8 8 0 01-11.31 0l-67.88-67.88a8 8 0 010-11.31l39.6-39.6zm669.6 0l39.6 39.6a8 8 0 010 11.3l-67.88 67.9a8 8 0 01-11.32 0l-39.6-39.6a8 8 0 010-11.32l67.89-67.88a8 8 0 0111.31 0zM192 892h640a32 32 0 0132 32v24a8 8 0 01-8 8H168a8 8 0 01-8-8v-24a32 32 0 0132-32zm148-317v253h64V575h-64z" } }] }, "name": "alert", "theme": "filled" };
  exports.default = AlertFilled;
  });

  var AlertFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(AlertFilled_1);

  var AlertFilled = function AlertFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: AlertFilledSvg
    }));
  };
  var RefIcon$4 = /*#__PURE__*/React.forwardRef(AlertFilled);
  {
    RefIcon$4.displayName = 'AlertFilled';
  }

  var AlertOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var AlertOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M193 796c0 17.7 14.3 32 32 32h574c17.7 0 32-14.3 32-32V563c0-176.2-142.8-319-319-319S193 386.8 193 563v233zm72-233c0-136.4 110.6-247 247-247s247 110.6 247 247v193H404V585c0-5.5-4.5-10-10-10h-44c-5.5 0-10 4.5-10 10v171h-75V563zm-48.1-252.5l39.6-39.6c3.1-3.1 3.1-8.2 0-11.3l-67.9-67.9a8.03 8.03 0 00-11.3 0l-39.6 39.6a8.03 8.03 0 000 11.3l67.9 67.9c3.1 3.1 8.1 3.1 11.3 0zm669.6-79.2l-39.6-39.6a8.03 8.03 0 00-11.3 0l-67.9 67.9a8.03 8.03 0 000 11.3l39.6 39.6c3.1 3.1 8.2 3.1 11.3 0l67.9-67.9c3.1-3.2 3.1-8.2 0-11.3zM832 892H192c-17.7 0-32 14.3-32 32v24c0 4.4 3.6 8 8 8h688c4.4 0 8-3.6 8-8v-24c0-17.7-14.3-32-32-32zM484 180h56c4.4 0 8-3.6 8-8V76c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v96c0 4.4 3.6 8 8 8z" } }] }, "name": "alert", "theme": "outlined" };
  exports.default = AlertOutlined;
  });

  var AlertOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(AlertOutlined_1);

  var AlertOutlined = function AlertOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: AlertOutlinedSvg
    }));
  };
  var RefIcon$5 = /*#__PURE__*/React.forwardRef(AlertOutlined);
  {
    RefIcon$5.displayName = 'AlertOutlined';
  }

  var AlertTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var AlertTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M340 585c0-5.5 4.5-10 10-10h44c5.5 0 10 4.5 10 10v171h355V563c0-136.4-110.6-247-247-247S265 426.6 265 563v193h75V585z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M216.9 310.5l39.6-39.6c3.1-3.1 3.1-8.2 0-11.3l-67.9-67.9a8.03 8.03 0 00-11.3 0l-39.6 39.6a8.03 8.03 0 000 11.3l67.9 67.9c3.1 3.1 8.1 3.1 11.3 0zm669.6-79.2l-39.6-39.6a8.03 8.03 0 00-11.3 0l-67.9 67.9a8.03 8.03 0 000 11.3l39.6 39.6c3.1 3.1 8.2 3.1 11.3 0l67.9-67.9c3.1-3.2 3.1-8.2 0-11.3zM484 180h56c4.4 0 8-3.6 8-8V76c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v96c0 4.4 3.6 8 8 8zm348 712H192c-17.7 0-32 14.3-32 32v24c0 4.4 3.6 8 8 8h688c4.4 0 8-3.6 8-8v-24c0-17.7-14.3-32-32-32zm-639-96c0 17.7 14.3 32 32 32h574c17.7 0 32-14.3 32-32V563c0-176.2-142.8-319-319-319S193 386.8 193 563v233zm72-233c0-136.4 110.6-247 247-247s247 110.6 247 247v193H404V585c0-5.5-4.5-10-10-10h-44c-5.5 0-10 4.5-10 10v171h-75V563z", "fill": primaryColor } }] }; }, "name": "alert", "theme": "twotone" };
  exports.default = AlertTwoTone;
  });

  var AlertTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(AlertTwoTone_1);

  var AlertTwoTone = function AlertTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: AlertTwoToneSvg
    }));
  };
  var RefIcon$6 = /*#__PURE__*/React.forwardRef(AlertTwoTone);
  {
    RefIcon$6.displayName = 'AlertTwoTone';
  }

  var AlibabaOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var AlibabaOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M602.9 669.8c-37.2 2.6-33.6-17.3-11.5-46.2 50.4-67.2 143.7-158.5 147.9-225.2 5.8-86.6-81.3-113.4-171-113.4-62.4 1.6-127 18.9-171 34.6-151.6 53.5-246.6 137.5-306.9 232-62.4 93.4-43 183.2 91.8 185.8 101.8-4.2 170.5-32.5 239.7-68.2.5 0-192.5 55.1-263.9 14.7-7.9-4.2-15.7-10-17.8-26.2 0-33.1 54.6-67.7 86.6-78.7v-56.7c64.5 22.6 140.6 16.3 205.7-32 2.1 5.8 4.2 13.1 3.7 21h11c2.6-22.6-12.6-44.6-37.8-46.2 7.3 5.8 12.6 10.5 15.2 14.7l-1 1-.5.5c-83.9 58.8-165.3 31.5-173.1 29.9l46.7-45.7-13.1-33.1c92.9-32.5 169.5-56.2 296.9-78.7l-28.5-23 14.7-8.9c75.5 21 126.4 36.7 123.8 76.6-1 6.8-3.7 14.7-7.9 23.1C660.1 466.1 594 538 567.2 569c-17.3 20.5-34.6 39.4-46.7 58.3-13.6 19.4-20.5 37.3-21 53.5 2.6 131.8 391.4-61.9 468-112.9-111.7 47.8-232.9 93.5-364.6 101.9zm85-302.9c2.8 5.2 4.1 11.6 4.1 19.1-.1-6.8-1.4-13.3-4.1-19.1z" } }] }, "name": "alibaba", "theme": "outlined" };
  exports.default = AlibabaOutlined;
  });

  var AlibabaOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(AlibabaOutlined_1);

  var AlibabaOutlined = function AlibabaOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: AlibabaOutlinedSvg
    }));
  };
  var RefIcon$7 = /*#__PURE__*/React.forwardRef(AlibabaOutlined);
  {
    RefIcon$7.displayName = 'AlibabaOutlined';
  }

  var AlignCenterOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var AlignCenterOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M264 230h496c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H264c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm496 424c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H264c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h496zm144 140H120c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-424H120c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8z" } }] }, "name": "align-center", "theme": "outlined" };
  exports.default = AlignCenterOutlined;
  });

  var AlignCenterOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(AlignCenterOutlined_1);

  var AlignCenterOutlined = function AlignCenterOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: AlignCenterOutlinedSvg
    }));
  };
  var RefIcon$8 = /*#__PURE__*/React.forwardRef(AlignCenterOutlined);
  {
    RefIcon$8.displayName = 'AlignCenterOutlined';
  }

  var AlignLeftOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var AlignLeftOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M120 230h496c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H120c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm0 424h496c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H120c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm784 140H120c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-424H120c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8z" } }] }, "name": "align-left", "theme": "outlined" };
  exports.default = AlignLeftOutlined;
  });

  var AlignLeftOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(AlignLeftOutlined_1);

  var AlignLeftOutlined = function AlignLeftOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: AlignLeftOutlinedSvg
    }));
  };
  var RefIcon$9 = /*#__PURE__*/React.forwardRef(AlignLeftOutlined);
  {
    RefIcon$9.displayName = 'AlignLeftOutlined';
  }

  var AlignRightOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var AlignRightOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M904 158H408c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h496c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 424H408c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h496c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 212H120c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-424H120c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8z" } }] }, "name": "align-right", "theme": "outlined" };
  exports.default = AlignRightOutlined;
  });

  var AlignRightOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(AlignRightOutlined_1);

  var AlignRightOutlined = function AlignRightOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: AlignRightOutlinedSvg
    }));
  };
  var RefIcon$a = /*#__PURE__*/React.forwardRef(AlignRightOutlined);
  {
    RefIcon$a.displayName = 'AlignRightOutlined';
  }

  var AlipayCircleFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var AlipayCircleFilled = { "icon": { "tag": "svg", "attrs": { "fill-rule": "evenodd", "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64c247.42 0 448 200.58 448 448S759.42 960 512 960 64 759.42 64 512 264.58 64 512 64m32.5 168c-69.67 0-86.06 16.84-86.72 39.08l-.02 1.43v46.62H291.45c-9.92 0-14.28 23.05-14.27 39.3 0 2.7 2.08 4.93 4.77 4.93h175.81v58.3h-116.5c-9.96 0-14.3 23.76-14.27 39.47a4.77 4.77 0 004.77 4.76h233.45c-4.53 41.06-15.43 77.59-30.72 109.32l-1.22 2.5-.32-.28c-60.24-28.47-120.43-52.57-194.4-52.57l-2.62.01c-84.98 1.11-144.71 56.5-145.91 127.04l-.02 1.22.02 2.13c1.24 70.4 63.56 126.45 148.52 126.45 61.25 0 116.38-16.85 163.46-45.02a138.58 138.58 0 0014.07-7.96 345.6 345.6 0 0050.3-41.16l9.45 6.35 12.46 8.32c57.53 38.26 113.76 72.62 169.86 79.27a142.62 142.62 0 0018.31 1.16c43.02 0 55-52.68 57.39-95.51l.14-2.84c.4-8.46-6.2-15.6-14.65-15.86-75.46-2.37-136.45-22.05-192-46.11l-6.27-2.75c35.15-56.8 56.66-121.81 57.15-186.66l.09-1.08c.4-5.51-4-10.2-9.52-10.2H549.33v-58.3h165.73c9.92 0 14.28-22.12 14.27-39.31a4.85 4.85 0 00-4.78-4.92H549.32v-82.35a4.8 4.8 0 00-4.83-4.78M328 583.85c54.63 0 107.08 22.41 158.1 52.19l5.76 3.4c-103.57 119.84-247.17 95.9-261.72 26.37a66.89 66.89 0 01-1.14-9.83l-.06-2.34.02-.9c.97-40.12 45.33-68.9 99.04-68.9" } }] }, "name": "alipay-circle", "theme": "filled" };
  exports.default = AlipayCircleFilled;
  });

  var AlipayCircleFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(AlipayCircleFilled_1);

  var AlipayCircleFilled = function AlipayCircleFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: AlipayCircleFilledSvg
    }));
  };
  var RefIcon$b = /*#__PURE__*/React.forwardRef(AlipayCircleFilled);
  {
    RefIcon$b.displayName = 'AlipayCircleFilled';
  }

  var AlipayCircleOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var AlipayCircleOutlined = { "icon": { "tag": "svg", "attrs": { "fill-rule": "evenodd", "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64c247.42 0 448 200.58 448 448S759.42 960 512 960 64 759.42 64 512 264.58 64 512 64m32.5 168c-69.67 0-86.06 16.84-86.72 39.08l-.02 1.43v46.62H291.45c-9.92 0-14.28 23.05-14.27 39.3 0 2.7 2.08 4.93 4.77 4.93h175.81v58.3h-116.5c-9.96 0-14.3 23.76-14.27 39.47a4.77 4.77 0 004.77 4.76h233.45c-4.53 41.06-15.43 77.59-30.72 109.32l-1.22 2.5-.32-.28c-60.24-28.47-120.43-52.57-194.4-52.57l-2.62.01c-84.98 1.11-144.71 56.5-145.91 127.04l-.02 1.22.02 2.13c1.24 70.4 63.56 126.45 148.52 126.45 61.25 0 116.38-16.85 163.46-45.02a138.58 138.58 0 0014.07-7.96 345.6 345.6 0 0050.3-41.16l9.45 6.35 12.46 8.32c57.53 38.26 113.76 72.62 169.86 79.27a142.62 142.62 0 0018.31 1.16c43.02 0 55-52.68 57.39-95.51l.14-2.84c.4-8.46-6.2-15.6-14.65-15.86-75.46-2.37-136.45-22.05-192-46.11l-6.27-2.75c35.15-56.8 56.66-121.81 57.15-186.66l.09-1.08c.4-5.51-4-10.2-9.52-10.2H549.33v-58.3h165.73c9.92 0 14.28-22.12 14.27-39.31a4.85 4.85 0 00-4.78-4.92H549.32v-82.35a4.8 4.8 0 00-4.83-4.78M328 583.85c54.63 0 107.08 22.41 158.1 52.19l5.76 3.4c-103.57 119.84-247.17 95.9-261.72 26.37a66.89 66.89 0 01-1.14-9.83l-.06-2.34.02-.9c.97-40.12 45.33-68.9 99.04-68.9" } }] }, "name": "alipay-circle", "theme": "outlined" };
  exports.default = AlipayCircleOutlined;
  });

  var AlipayCircleOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(AlipayCircleOutlined_1);

  var AlipayCircleOutlined = function AlipayCircleOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: AlipayCircleOutlinedSvg
    }));
  };
  var RefIcon$c = /*#__PURE__*/React.forwardRef(AlipayCircleOutlined);
  {
    RefIcon$c.displayName = 'AlipayCircleOutlined';
  }

  var AlipayOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var AlipayOutlined = { "icon": { "tag": "svg", "attrs": { "fill-rule": "evenodd", "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M557.2 129a6.68 6.68 0 016.72 6.65V250.2h243.8a6.74 6.74 0 016.65 6.84c.02 23.92-6.05 54.69-19.85 54.69H563.94v81.1h166.18c7.69 0 13.8 6.51 13.25 14.18l-.11 1.51c-.7 90.2-30.63 180.64-79.52 259.65l8.71 3.82c77.3 33.48 162.15 60.85 267.15 64.14a21.08 21.08 0 0120.38 22.07l-.2 3.95c-3.34 59.57-20 132.85-79.85 132.85-8.8 0-17.29-.55-25.48-1.61-78.04-9.25-156.28-57.05-236.32-110.27l-17.33-11.57-13.15-8.83a480.83 480.83 0 01-69.99 57.25 192.8 192.8 0 01-19.57 11.08c-65.51 39.18-142.21 62.6-227.42 62.62-118.2 0-204.92-77.97-206.64-175.9l-.03-2.95.03-1.7c1.66-98.12 84.77-175.18 203-176.72l3.64-.03c102.92 0 186.66 33.54 270.48 73.14l.44.38 1.7-3.47c21.27-44.14 36.44-94.95 42.74-152.06h-324.8a6.64 6.64 0 01-6.63-6.62c-.04-21.86 6-54.91 19.85-54.91h162.1v-81.1H191.92a6.71 6.71 0 01-6.64-6.85c-.01-22.61 6.06-54.68 19.86-54.68h231.4v-64.85l.02-1.99c.9-30.93 23.72-54.36 120.64-54.36M256.9 619c-74.77 0-136.53 39.93-137.88 95.6l-.02 1.26.08 3.24a92.55 92.55 0 001.58 13.64c20.26 96.5 220.16 129.71 364.34-36.59l-8.03-4.72C405.95 650.11 332.94 619 256.9 619" } }] }, "name": "alipay", "theme": "outlined" };
  exports.default = AlipayOutlined;
  });

  var AlipayOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(AlipayOutlined_1);

  var AlipayOutlined = function AlipayOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: AlipayOutlinedSvg
    }));
  };
  var RefIcon$d = /*#__PURE__*/React.forwardRef(AlipayOutlined);
  {
    RefIcon$d.displayName = 'AlipayOutlined';
  }

  var AlipaySquareFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var AlipaySquareFilled = { "icon": { "tag": "svg", "attrs": { "fill-rule": "evenodd", "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M894.6 116.54a30.9 30.9 0 0112.86 12.85c2.96 5.54 4.54 11.04 4.54 26.2V868.4c0 15.16-1.58 20.66-4.54 26.2a30.9 30.9 0 01-12.85 12.85c-5.54 2.96-11.04 4.54-26.2 4.54H155.6c-15.16 0-20.66-1.58-26.2-4.54a30.9 30.9 0 01-12.85-12.85c-2.92-5.47-4.5-10.9-4.54-25.59V155.6c0-15.16 1.58-20.66 4.54-26.2a30.9 30.9 0 0112.85-12.85c5.47-2.92 10.9-4.5 25.59-4.54H868.4c15.16 0 20.66 1.58 26.2 4.54M541 262c-62.2 0-76.83 15.04-77.42 34.9l-.02 1.27v41.62H315.08c-8.86 0-12.75 20.59-12.74 35.1a4.3 4.3 0 004.26 4.4h156.97v52.05H359.56c-8.9 0-12.77 21.22-12.75 35.25a4.26 4.26 0 004.26 4.25h208.44c-4.04 36.66-13.78 69.27-27.43 97.6l-1.09 2.23-.28-.25c-53.8-25.42-107.53-46.94-173.58-46.94l-2.33.01c-75.88 1-129.21 50.45-130.28 113.43l-.02 1.1.02 1.89c1.1 62.85 56.75 112.9 132.6 112.9 54.7 0 103.91-15.04 145.95-40.2a123.73 123.73 0 0012.56-7.1 308.6 308.6 0 0044.92-36.75l8.44 5.67 11.12 7.43c51.36 34.15 101.57 64.83 151.66 70.77a127.34 127.34 0 0016.35 1.04c38.4 0 49.1-47.04 51.24-85.28l.13-2.53a13.53 13.53 0 00-13.08-14.17c-67.39-2.1-121.84-19.68-171.44-41.17l-5.6-2.44c31.39-50.72 50.6-108.77 51.04-166.67l.07-.96a8.51 8.51 0 00-8.5-9.1H545.33v-52.06H693.3c8.86 0 12.75-19.75 12.75-35.1-.01-2.4-1.87-4.4-4.27-4.4H545.32v-73.52a4.29 4.29 0 00-4.31-4.27m-193.3 314.15c48.77 0 95.6 20.01 141.15 46.6l5.15 3.04c-92.48 107-220.69 85.62-233.68 23.54a59.72 59.72 0 01-1.02-8.78l-.05-2.08.01-.81c.87-35.82 40.48-61.51 88.44-61.51" } }] }, "name": "alipay-square", "theme": "filled" };
  exports.default = AlipaySquareFilled;
  });

  var AlipaySquareFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(AlipaySquareFilled_1);

  var AlipaySquareFilled = function AlipaySquareFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: AlipaySquareFilledSvg
    }));
  };
  var RefIcon$e = /*#__PURE__*/React.forwardRef(AlipaySquareFilled);
  {
    RefIcon$e.displayName = 'AlipaySquareFilled';
  }

  var AliwangwangFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var AliwangwangFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M868.2 377.4c-18.9-45.1-46.3-85.6-81.2-120.6a377.26 377.26 0 00-120.5-81.2A375.65 375.65 0 00519 145.8c-41.9 0-82.9 6.7-121.9 20C306 123.3 200.8 120 170.6 120c-2.2 0-7.4 0-9.4.2-11.9.4-22.8 6.5-29.2 16.4-6.5 9.9-7.7 22.4-3.4 33.5l64.3 161.6a378.59 378.59 0 00-52.8 193.2c0 51.4 10 101 29.8 147.6 18.9 45 46.2 85.6 81.2 120.5 34.7 34.8 75.4 62.1 120.5 81.2C418.3 894 467.9 904 519 904c51.3 0 100.9-10 147.7-29.8 44.9-18.9 85.5-46.3 120.4-81.2 34.7-34.8 62.1-75.4 81.2-120.6a376.5 376.5 0 0029.8-147.6c-.2-51.2-10.1-100.8-29.9-147.4zm-325.2 79c0 20.4-16.6 37.1-37.1 37.1-20.4 0-37.1-16.7-37.1-37.1v-55.1c0-20.4 16.6-37.1 37.1-37.1 20.4 0 37.1 16.6 37.1 37.1v55.1zm175.2 0c0 20.4-16.6 37.1-37.1 37.1S644 476.8 644 456.4v-55.1c0-20.4 16.7-37.1 37.1-37.1 20.4 0 37.1 16.6 37.1 37.1v55.1z" } }] }, "name": "aliwangwang", "theme": "filled" };
  exports.default = AliwangwangFilled;
  });

  var AliwangwangFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(AliwangwangFilled_1);

  var AliwangwangFilled = function AliwangwangFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: AliwangwangFilledSvg
    }));
  };
  var RefIcon$f = /*#__PURE__*/React.forwardRef(AliwangwangFilled);
  {
    RefIcon$f.displayName = 'AliwangwangFilled';
  }

  var AliwangwangOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var AliwangwangOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M868.2 377.4c-18.9-45.1-46.3-85.6-81.2-120.6a377.26 377.26 0 00-120.5-81.2A375.65 375.65 0 00519 145.8c-41.9 0-82.9 6.7-121.9 20C306 123.3 200.8 120 170.6 120c-2.2 0-7.4 0-9.4.2-11.9.4-22.8 6.5-29.2 16.4-6.5 9.9-7.7 22.4-3.4 33.5l64.3 161.6a378.59 378.59 0 00-52.8 193.2c0 51.4 10 101 29.8 147.6 18.9 45 46.2 85.6 81.2 120.5 34.7 34.8 75.4 62.1 120.5 81.2C418.3 894 467.9 904 519 904c51.3 0 100.9-10.1 147.7-29.8 44.9-18.9 85.5-46.3 120.4-81.2 34.7-34.8 62.1-75.4 81.2-120.6a376.5 376.5 0 0029.8-147.6c-.2-51.2-10.1-100.8-29.9-147.4zm-66.4 266.5a307.08 307.08 0 01-65.9 98c-28.4 28.5-61.3 50.7-97.7 65.9h-.1c-38 16-78.3 24.2-119.9 24.2a306.51 306.51 0 01-217.5-90.2c-28.4-28.5-50.6-61.4-65.8-97.8v-.1c-16-37.8-24.1-78.2-24.1-119.9 0-55.4 14.8-109.7 42.8-157l13.2-22.1-9.5-23.9L206 192c14.9.6 35.9 2.1 59.7 5.6 43.8 6.5 82.5 17.5 114.9 32.6l19 8.9 19.9-6.8c31.5-10.8 64.8-16.2 98.9-16.2a306.51 306.51 0 01217.5 90.2c28.4 28.5 50.6 61.4 65.8 97.8l.1.1.1.1c16 37.6 24.1 78 24.2 119.8-.1 41.7-8.3 82-24.3 119.8zM681.1 364.2c-20.4 0-37.1 16.7-37.1 37.1v55.1c0 20.4 16.6 37.1 37.1 37.1s37.1-16.7 37.1-37.1v-55.1c0-20.5-16.7-37.1-37.1-37.1zm-175.2 0c-20.5 0-37.1 16.7-37.1 37.1v55.1c0 20.4 16.7 37.1 37.1 37.1 20.5 0 37.1-16.7 37.1-37.1v-55.1c0-20.5-16.7-37.1-37.1-37.1z" } }] }, "name": "aliwangwang", "theme": "outlined" };
  exports.default = AliwangwangOutlined;
  });

  var AliwangwangOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(AliwangwangOutlined_1);

  var AliwangwangOutlined = function AliwangwangOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: AliwangwangOutlinedSvg
    }));
  };
  var RefIcon$g = /*#__PURE__*/React.forwardRef(AliwangwangOutlined);
  {
    RefIcon$g.displayName = 'AliwangwangOutlined';
  }

  var AliyunOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var AliyunOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M959.2 383.9c-.3-82.1-66.9-148.6-149.1-148.6H575.9l21.6 85.2 201 43.7a42.58 42.58 0 0132.9 39.7c.1.5.1 216.1 0 216.6a42.58 42.58 0 01-32.9 39.7l-201 43.7-21.6 85.3h234.2c82.1 0 148.8-66.5 149.1-148.6V383.9zM225.5 660.4a42.58 42.58 0 01-32.9-39.7c-.1-.6-.1-216.1 0-216.6.8-19.4 14.6-35.5 32.9-39.7l201-43.7 21.6-85.2H213.8c-82.1 0-148.8 66.4-149.1 148.6V641c.3 82.1 67 148.6 149.1 148.6H448l-21.6-85.3-200.9-43.9zm200.9-158.8h171v21.3h-171z" } }] }, "name": "aliyun", "theme": "outlined" };
  exports.default = AliyunOutlined;
  });

  var AliyunOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(AliyunOutlined_1);

  var AliyunOutlined = function AliyunOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: AliyunOutlinedSvg
    }));
  };
  var RefIcon$h = /*#__PURE__*/React.forwardRef(AliyunOutlined);
  {
    RefIcon$h.displayName = 'AliyunOutlined';
  }

  var AmazonCircleFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var AmazonCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M485 467.5c-11.6 4.9-20.9 12.2-27.8 22-6.9 9.8-10.4 21.6-10.4 35.5 0 17.8 7.5 31.5 22.4 41.2 14.1 9.1 28.9 11.4 44.4 6.8 17.9-5.2 30-17.9 36.4-38.1 3-9.3 4.5-19.7 4.5-31.3v-50.2c-12.6.4-24.4 1.6-35.5 3.7-11.1 2.1-22.4 5.6-34 10.4zM512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm35.8 262.7c-7.2-10.9-20.1-16.4-38.7-16.4-1.3 0-3 .1-5.3.3-2.2.2-6.6 1.5-12.9 3.7a79.4 79.4 0 00-17.9 9.1c-5.5 3.8-11.5 10-18 18.4-6.4 8.5-11.5 18.4-15.3 29.8l-94-8.4c0-12.4 2.4-24.7 7-36.9 4.7-12.2 11.8-23.9 21.4-35 9.6-11.2 21.1-21 34.5-29.4 13.4-8.5 29.6-15.2 48.4-20.3 18.9-5.1 39.1-7.6 60.9-7.6 21.3 0 40.6 2.6 57.8 7.7 17.2 5.2 31.1 11.5 41.4 19.1a117 117 0 0125.9 25.7c6.9 9.6 11.7 18.5 14.4 26.7 2.7 8.2 4 15.7 4 22.8v182.5c0 6.4 1.4 13 4.3 19.8 2.9 6.8 6.3 12.8 10.2 18 3.9 5.2 7.9 9.9 12 14.3 4.1 4.3 7.6 7.7 10.6 9.9l4.1 3.4-72.5 69.4c-8.5-7.7-16.9-15.4-25.2-23.4-8.3-8-14.5-14-18.5-18.1l-6.1-6.2c-2.4-2.3-5-5.7-8-10.2-8.1 12.2-18.5 22.8-31.1 31.8-12.7 9-26.3 15.6-40.7 19.7-14.5 4.1-29.4 6.5-44.7 7.1-15.3.6-30-1.5-43.9-6.5-13.9-5-26.5-11.7-37.6-20.3-11.1-8.6-19.9-20.2-26.5-35-6.6-14.8-9.9-31.5-9.9-50.4 0-17.4 3-33.3 8.9-47.7 6-14.5 13.6-26.5 23-36.1 9.4-9.6 20.7-18.2 34-25.7s26.4-13.4 39.2-17.7c12.8-4.2 26.6-7.8 41.5-10.7 14.9-2.9 27.6-4.8 38.2-5.7 10.6-.9 21.2-1.6 31.8-2v-39.4c0-13.5-2.3-23.5-6.7-30.1zm180.5 379.6c-2.8 3.3-7.5 7.8-14.1 13.5s-16.8 12.7-30.5 21.1c-13.7 8.4-28.8 16-45 22.9-16.3 6.9-36.3 12.9-60.1 18-23.7 5.1-48.2 7.6-73.3 7.6-25.4 0-50.7-3.2-76.1-9.6-25.4-6.4-47.6-14.3-66.8-23.7-19.1-9.4-37.6-20.2-55.1-32.2-17.6-12.1-31.7-22.9-42.4-32.5-10.6-9.6-19.6-18.7-26.8-27.1-1.7-1.9-2.8-3.6-3.2-5.1-.4-1.5-.3-2.8.3-3.7.6-.9 1.5-1.6 2.6-2.2a7.42 7.42 0 017.4.8c40.9 24.2 72.9 41.3 95.9 51.4 82.9 36.4 168 45.7 255.3 27.9 40.5-8.3 82.1-22.2 124.9-41.8 3.2-1.2 6-1.5 8.3-.9 2.3.6 3.5 2.4 3.5 5.4 0 2.8-1.6 6.3-4.8 10.2zm59.9-29c-1.8 11.1-4.9 21.6-9.1 31.8-7.2 17.1-16.3 30-27.1 38.4-3.6 2.9-6.4 3.8-8.3 2.8-1.9-1-1.9-3.5 0-7.4 4.5-9.3 9.2-21.8 14.2-37.7 5-15.8 5.7-26 2.1-30.5-1.1-1.5-2.7-2.6-5-3.6-2.2-.9-5.1-1.5-8.6-1.9s-6.7-.6-9.4-.8c-2.8-.2-6.5-.2-11.2 0-4.7.2-8 .4-10.1.6a874.4 874.4 0 01-17.1 1.5c-1.3.2-2.7.4-4.1.5-1.5.1-2.7.2-3.5.3l-2.7.3c-1 .1-1.7.2-2.2.2h-3.2l-1-.2-.6-.5-.5-.9c-1.3-3.3 3.7-7.4 15-12.4s22.3-8.1 32.9-9.3c9.8-1.5 21.3-1.5 34.5-.3s21.3 3.7 24.3 7.4c2.3 3.5 2.5 10.7.7 21.7z" } }] }, "name": "amazon-circle", "theme": "filled" };
  exports.default = AmazonCircleFilled;
  });

  var AmazonCircleFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(AmazonCircleFilled_1);

  var AmazonCircleFilled = function AmazonCircleFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: AmazonCircleFilledSvg
    }));
  };
  var RefIcon$i = /*#__PURE__*/React.forwardRef(AmazonCircleFilled);
  {
    RefIcon$i.displayName = 'AmazonCircleFilled';
  }

  var AmazonOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var AmazonOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M825 768.9c-3.3-.9-7.3-.4-11.9 1.3-61.6 28.2-121.5 48.3-179.7 60.2C507.7 856 385.2 842.6 266 790.3c-33.1-14.6-79.1-39.2-138-74a9.36 9.36 0 00-5.3-2c-2-.1-3.7.1-5.3.9-1.6.8-2.8 1.8-3.7 3.1-.9 1.3-1.1 3.1-.4 5.4.6 2.2 2.1 4.7 4.6 7.4 10.4 12.2 23.3 25.2 38.6 39s35.6 29.4 60.9 46.8c25.3 17.4 51.8 32.9 79.3 46.4 27.6 13.5 59.6 24.9 96.1 34.1s73 13.8 109.4 13.8c36.2 0 71.4-3.7 105.5-10.9 34.2-7.3 63-15.9 86.5-25.9 23.4-9.9 45-21 64.8-33 19.8-12 34.4-22.2 43.9-30.3 9.5-8.2 16.3-14.6 20.2-19.4 4.6-5.7 6.9-10.6 6.9-14.9.1-4.5-1.7-7.1-5-7.9zM527.4 348.1c-15.2 1.3-33.5 4.1-55 8.3-21.5 4.1-41.4 9.3-59.8 15.4s-37.2 14.6-56.3 25.4c-19.2 10.8-35.5 23.2-49 37s-24.5 31.1-33.1 52c-8.6 20.8-12.9 43.7-12.9 68.7 0 27.1 4.7 51.2 14.3 72.5 9.5 21.3 22.2 38 38.2 50.4 15.9 12.4 34 22.1 54 29.2 20 7.1 41.2 10.3 63.2 9.4 22-.9 43.5-4.3 64.4-10.3 20.8-5.9 40.4-15.4 58.6-28.3 18.2-12.9 33.1-28.2 44.8-45.7 4.3 6.6 8.1 11.5 11.5 14.7l8.7 8.9c5.8 5.9 14.7 14.6 26.7 26.1 11.9 11.5 24.1 22.7 36.3 33.7l104.4-99.9-6-4.9c-4.3-3.3-9.4-8-15.2-14.3-5.8-6.2-11.6-13.1-17.2-20.5-5.7-7.4-10.6-16.1-14.7-25.9-4.1-9.8-6.2-19.3-6.2-28.5V258.7c0-10.1-1.9-21-5.7-32.8-3.9-11.7-10.7-24.5-20.7-38.3-10-13.8-22.4-26.2-37.2-37-14.9-10.8-34.7-20-59.6-27.4-24.8-7.4-52.6-11.1-83.2-11.1-31.3 0-60.4 3.7-87.6 10.9-27.1 7.3-50.3 17-69.7 29.2-19.3 12.2-35.9 26.3-49.7 42.4-13.8 16.1-24.1 32.9-30.8 50.4-6.7 17.5-10.1 35.2-10.1 53.1L408 310c5.5-16.4 12.9-30.6 22-42.8 9.2-12.2 17.9-21 25.8-26.5 8-5.5 16.6-9.9 25.7-13.2 9.2-3.3 15.4-5 18.6-5.4 3.2-.3 5.7-.4 7.6-.4 26.7 0 45.2 7.9 55.6 23.6 6.5 9.5 9.7 23.9 9.7 43.3v56.6c-15.2.6-30.4 1.6-45.6 2.9zM573.1 500c0 16.6-2.2 31.7-6.5 45-9.2 29.1-26.7 47.4-52.4 54.8-22.4 6.6-43.7 3.3-63.9-9.8-21.5-14-32.2-33.8-32.2-59.3 0-19.9 5-36.9 15-51.1 10-14.1 23.3-24.7 40-31.7s33-12 49-14.9c15.9-3 33-4.8 51-5.4V500zm335.2 218.9c-4.3-5.4-15.9-8.9-34.9-10.7-19-1.8-35.5-1.7-49.7.4-15.3 1.8-31.1 6.2-47.3 13.4-16.3 7.1-23.4 13.1-21.6 17.8l.7 1.3.9.7 1.4.2h4.6c.8 0 1.8-.1 3.2-.2 1.4-.1 2.7-.3 3.9-.4 1.2-.1 2.9-.3 5.1-.4 2.1-.1 4.1-.4 6-.7.3 0 3.7-.3 10.3-.9 6.6-.6 11.4-1 14.3-1.3 2.9-.3 7.8-.6 14.5-.9 6.7-.3 12.1-.3 16.1 0 4 .3 8.5.7 13.6 1.1 5.1.4 9.2 1.3 12.4 2.7 3.2 1.3 5.6 3 7.1 5.1 5.2 6.6 4.2 21.2-3 43.9s-14 40.8-20.4 54.2c-2.8 5.7-2.8 9.2 0 10.7s6.7.1 11.9-4c15.6-12.2 28.6-30.6 39.1-55.3 6.1-14.6 10.5-29.8 13.1-45.7 2.4-15.9 2-26.2-1.3-31z" } }] }, "name": "amazon", "theme": "outlined" };
  exports.default = AmazonOutlined;
  });

  var AmazonOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(AmazonOutlined_1);

  var AmazonOutlined = function AmazonOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: AmazonOutlinedSvg
    }));
  };
  var RefIcon$j = /*#__PURE__*/React.forwardRef(AmazonOutlined);
  {
    RefIcon$j.displayName = 'AmazonOutlined';
  }

  var AmazonSquareFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var AmazonSquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM547.8 326.7c-7.2-10.9-20.1-16.4-38.7-16.4-1.3 0-3 .1-5.3.3-2.2.2-6.6 1.5-12.9 3.7a79.4 79.4 0 00-17.9 9.1c-5.5 3.8-11.5 10-18 18.4-6.4 8.5-11.5 18.4-15.3 29.8l-94-8.4c0-12.4 2.4-24.7 7-36.9s11.8-23.9 21.4-35c9.6-11.2 21.1-21 34.5-29.4 13.4-8.5 29.6-15.2 48.4-20.3 18.9-5.1 39.1-7.6 60.9-7.6 21.3 0 40.6 2.6 57.8 7.7 17.2 5.2 31.1 11.5 41.4 19.1a117 117 0 0125.9 25.7c6.9 9.6 11.7 18.5 14.4 26.7 2.7 8.2 4 15.7 4 22.8v182.5c0 6.4 1.4 13 4.3 19.8 2.9 6.8 6.3 12.8 10.2 18 3.9 5.2 7.9 9.9 12 14.3 4.1 4.3 7.6 7.7 10.6 9.9l4.1 3.4-72.5 69.4c-8.5-7.7-16.9-15.4-25.2-23.4-8.3-8-14.5-14-18.5-18.1l-6.1-6.2c-2.4-2.3-5-5.7-8-10.2-8.1 12.2-18.5 22.8-31.1 31.8-12.7 9-26.3 15.6-40.7 19.7-14.5 4.1-29.4 6.5-44.7 7.1-15.3.6-30-1.5-43.9-6.5-13.9-5-26.5-11.7-37.6-20.3-11.1-8.6-19.9-20.2-26.5-35-6.6-14.8-9.9-31.5-9.9-50.4 0-17.4 3-33.3 8.9-47.7 6-14.5 13.6-26.5 23-36.1 9.4-9.6 20.7-18.2 34-25.7s26.4-13.4 39.2-17.7c12.8-4.2 26.6-7.8 41.5-10.7 14.9-2.9 27.6-4.8 38.2-5.7 10.6-.9 21.2-1.6 31.8-2v-39.4c0-13.5-2.3-23.5-6.7-30.1zm180.5 379.6c-2.8 3.3-7.5 7.8-14.1 13.5s-16.8 12.7-30.5 21.1c-13.7 8.4-28.8 16-45 22.9-16.3 6.9-36.3 12.9-60.1 18-23.7 5.1-48.2 7.6-73.3 7.6-25.4 0-50.7-3.2-76.1-9.6-25.4-6.4-47.6-14.3-66.8-23.7-19.1-9.4-37.6-20.2-55.1-32.2-17.6-12.1-31.7-22.9-42.4-32.5-10.6-9.6-19.6-18.7-26.8-27.1-1.7-1.9-2.8-3.6-3.2-5.1-.4-1.5-.3-2.8.3-3.7.6-.9 1.5-1.6 2.6-2.2a7.42 7.42 0 017.4.8c40.9 24.2 72.9 41.3 95.9 51.4 82.9 36.4 168 45.7 255.3 27.9 40.5-8.3 82.1-22.2 124.9-41.8 3.2-1.2 6-1.5 8.3-.9 2.3.6 3.5 2.4 3.5 5.4 0 2.8-1.6 6.3-4.8 10.2zm59.9-29c-1.8 11.1-4.9 21.6-9.1 31.8-7.2 17.1-16.3 30-27.1 38.4-3.6 2.9-6.4 3.8-8.3 2.8-1.9-1-1.9-3.5 0-7.4 4.5-9.3 9.2-21.8 14.2-37.7 5-15.8 5.7-26 2.1-30.5-1.1-1.5-2.7-2.6-5-3.6-2.2-.9-5.1-1.5-8.6-1.9s-6.7-.6-9.4-.8c-2.8-.2-6.5-.2-11.2 0-4.7.2-8 .4-10.1.6a874.4 874.4 0 01-17.1 1.5c-1.3.2-2.7.4-4.1.5-1.5.1-2.7.2-3.5.3l-2.7.3c-1 .1-1.7.2-2.2.2h-3.2l-1-.2-.6-.5-.5-.9c-1.3-3.3 3.7-7.4 15-12.4s22.3-8.1 32.9-9.3c9.8-1.5 21.3-1.5 34.5-.3s21.3 3.7 24.3 7.4c2.3 3.5 2.5 10.7.7 21.7zM485 467.5c-11.6 4.9-20.9 12.2-27.8 22-6.9 9.8-10.4 21.6-10.4 35.5 0 17.8 7.5 31.5 22.4 41.2 14.1 9.1 28.9 11.4 44.4 6.8 17.9-5.2 30-17.9 36.4-38.1 3-9.3 4.5-19.7 4.5-31.3v-50.2c-12.6.4-24.4 1.6-35.5 3.7-11.1 2.1-22.4 5.6-34 10.4z" } }] }, "name": "amazon-square", "theme": "filled" };
  exports.default = AmazonSquareFilled;
  });

  var AmazonSquareFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(AmazonSquareFilled_1);

  var AmazonSquareFilled = function AmazonSquareFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: AmazonSquareFilledSvg
    }));
  };
  var RefIcon$k = /*#__PURE__*/React.forwardRef(AmazonSquareFilled);
  {
    RefIcon$k.displayName = 'AmazonSquareFilled';
  }

  var AndroidFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var AndroidFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M270.1 741.7c0 23.4 19.1 42.5 42.6 42.5h48.7v120.4c0 30.5 24.5 55.4 54.6 55.4 30.2 0 54.6-24.8 54.6-55.4V784.1h85v120.4c0 30.5 24.5 55.4 54.6 55.4 30.2 0 54.6-24.8 54.6-55.4V784.1h48.7c23.5 0 42.6-19.1 42.6-42.5V346.4h-486v395.3zm357.1-600.1l44.9-65c2.6-3.8 2-8.9-1.5-11.4-3.5-2.4-8.5-1.2-11.1 2.6l-46.6 67.6c-30.7-12.1-64.9-18.8-100.8-18.8-35.9 0-70.1 6.7-100.8 18.8l-46.6-67.5c-2.6-3.8-7.6-5.1-11.1-2.6-3.5 2.4-4.1 7.4-1.5 11.4l44.9 65c-71.4 33.2-121.4 96.1-127.8 169.6h486c-6.6-73.6-56.7-136.5-128-169.7zM409.5 244.1a26.9 26.9 0 1126.9-26.9 26.97 26.97 0 01-26.9 26.9zm208.4 0a26.9 26.9 0 1126.9-26.9 26.97 26.97 0 01-26.9 26.9zm223.4 100.7c-30.2 0-54.6 24.8-54.6 55.4v216.4c0 30.5 24.5 55.4 54.6 55.4 30.2 0 54.6-24.8 54.6-55.4V400.1c.1-30.6-24.3-55.3-54.6-55.3zm-658.6 0c-30.2 0-54.6 24.8-54.6 55.4v216.4c0 30.5 24.5 55.4 54.6 55.4 30.2 0 54.6-24.8 54.6-55.4V400.1c0-30.6-24.5-55.3-54.6-55.3z" } }] }, "name": "android", "theme": "filled" };
  exports.default = AndroidFilled;
  });

  var AndroidFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(AndroidFilled_1);

  var AndroidFilled = function AndroidFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: AndroidFilledSvg
    }));
  };
  var RefIcon$l = /*#__PURE__*/React.forwardRef(AndroidFilled);
  {
    RefIcon$l.displayName = 'AndroidFilled';
  }

  var AndroidOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var AndroidOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M448.3 225.2c-18.6 0-32 13.4-32 31.9s13.5 31.9 32 31.9c18.6 0 32-13.4 32-31.9.1-18.4-13.4-31.9-32-31.9zm393.9 96.4c-13.8-13.8-32.7-21.5-53.2-21.5-3.9 0-7.4.4-10.7 1v-1h-3.6c-5.5-30.6-18.6-60.5-38.1-87.4-18.7-25.7-43-47.9-70.8-64.9l25.1-35.8v-3.3c0-.8.4-2.3.7-3.8.6-2.4 1.4-5.5 1.4-8.9 0-18.5-13.5-31.9-32-31.9-9.8 0-19.5 5.7-25.9 15.4l-29.3 42.1c-30-9.8-62.4-15-93.8-15-31.3 0-63.7 5.2-93.8 15L389 79.4c-6.6-9.6-16.1-15.4-26-15.4-18.6 0-32 13.4-32 31.9 0 6.2 2.5 12.8 6.7 17.4l22.6 32.3c-28.7 17-53.5 39.4-72.2 65.1-19.4 26.9-32 56.8-36.7 87.4h-5.5v1c-3.2-.6-6.7-1-10.7-1-20.3 0-39.2 7.5-53.1 21.3-13.8 13.8-21.5 32.6-21.5 53v235c0 20.3 7.5 39.1 21.4 52.9 13.8 13.8 32.8 21.5 53.2 21.5 3.9 0 7.4-.4 10.7-1v93.5c0 29.2 23.9 53.1 53.2 53.1H331v58.3c0 20.3 7.5 39.1 21.4 52.9 13.8 13.8 32.8 21.5 53.2 21.5 20.3 0 39.2-7.5 53.1-21.3 13.8-13.8 21.5-32.6 21.5-53v-58.2H544v58.1c0 20.3 7.5 39.1 21.4 52.9 13.8 13.8 32.8 21.5 53.2 21.5 20.4 0 39.2-7.5 53.1-21.6 13.8-13.8 21.5-32.6 21.5-53v-58.2h31.9c29.3 0 53.2-23.8 53.2-53.1v-91.4c3.2.6 6.7 1 10.7 1 20.3 0 39.2-7.5 53.1-21.3 13.8-13.8 21.5-32.6 21.5-53v-235c-.1-20.3-7.6-39-21.4-52.9zM246 609.6c0 6.8-3.9 10.6-10.7 10.6-6.8 0-10.7-3.8-10.7-10.6V374.5c0-6.8 3.9-10.6 10.7-10.6 6.8 0 10.7 3.8 10.7 10.6v235.1zm131.1-396.8c37.5-27.3 85.3-42.3 135-42.3s97.5 15.1 135 42.5c32.4 23.7 54.2 54.2 62.7 87.5H314.4c8.5-33.4 30.5-64 62.7-87.7zm39.3 674.7c-.6 5.6-4.4 8.7-10.5 8.7-6.8 0-10.7-3.8-10.7-10.6v-58.2h21.2v60.1zm202.3 8.7c-6.8 0-10.7-3.8-10.7-10.6v-58.2h21.2v60.1c-.6 5.6-4.3 8.7-10.5 8.7zm95.8-132.6H309.9V364h404.6v399.6zm85.2-154c0 6.8-3.9 10.6-10.7 10.6-6.8 0-10.7-3.8-10.7-10.6V374.5c0-6.8 3.9-10.6 10.7-10.6 6.8 0 10.7 3.8 10.7 10.6v235.1zM576.1 225.2c-18.6 0-32 13.4-32 31.9s13.5 31.9 32 31.9c18.6 0 32.1-13.4 32.1-32-.1-18.6-13.4-31.8-32.1-31.8z" } }] }, "name": "android", "theme": "outlined" };
  exports.default = AndroidOutlined;
  });

  var AndroidOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(AndroidOutlined_1);

  var AndroidOutlined = function AndroidOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: AndroidOutlinedSvg
    }));
  };
  var RefIcon$m = /*#__PURE__*/React.forwardRef(AndroidOutlined);
  {
    RefIcon$m.displayName = 'AndroidOutlined';
  }

  var AntCloudOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var AntCloudOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M378.9 738c-3.1 0-6.1-.5-8.8-1.5l4.4 30.7h26.3l-15.5-29.9c-2.1.5-4.2.7-6.4.7zm421-291.2c-12.6 0-24.8 1.5-36.5 4.2-21.4-38.4-62.3-64.3-109.3-64.3-6.9 0-13.6.6-20.2 1.6-35.4-77.4-113.4-131.1-203.9-131.1-112.3 0-205.3 82.6-221.6 190.4C127.3 455.5 64 523.8 64 607c0 88.4 71.6 160.1 160 160.2h50l13.2-27.6c-26.2-8.3-43.3-29-39.1-48.8 4.6-21.6 32.8-33.9 63.1-27.5 22.9 4.9 40.4 19.1 45.5 35.1a26.1 26.1 0 0122.1-12.4h.2c-.8-3.2-1.2-6.5-1.2-9.9 0-20.1 14.8-36.7 34.1-39.6v-25.4c0-4.4 3.6-8 8-8s8 3.6 8 8v26.3c4.6 1.2 8.8 3.2 12.6 5.8l19.5-21.4c3-3.3 8-3.5 11.3-.5 3.3 3 3.5 8 .5 11.3l-20 22-.2.2a40 40 0 01-46.9 59.2c-.4 5.6-2.6 10.7-6 14.8l20 38.4H804v-.1c86.5-2.2 156-73 156-160.1 0-88.5-71.7-160.2-160.1-160.2zM338.2 737.2l-4.3 30h24.4l-5.9-41.5c-3.5 4.6-8.3 8.5-14.2 11.5zM797.5 305a48 48 0 1096 0 48 48 0 10-96 0zm-65.7 61.3a24 24 0 1048 0 24 24 0 10-48 0zM303.4 742.9l-11.6 24.3h26l3.5-24.7c-5.7.8-11.7 1-17.9.4z" } }] }, "name": "ant-cloud", "theme": "outlined" };
  exports.default = AntCloudOutlined;
  });

  var AntCloudOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(AntCloudOutlined_1);

  var AntCloudOutlined = function AntCloudOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: AntCloudOutlinedSvg
    }));
  };
  var RefIcon$n = /*#__PURE__*/React.forwardRef(AntCloudOutlined);
  {
    RefIcon$n.displayName = 'AntCloudOutlined';
  }

  var AntDesignOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var AntDesignOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M716.3 313.8c19-18.9 19-49.7 0-68.6l-69.9-69.9.1.1c-18.5-18.5-50.3-50.3-95.3-95.2-21.2-20.7-55.5-20.5-76.5.5L80.9 474.2a53.84 53.84 0 000 76.4L474.6 944a54.14 54.14 0 0076.5 0l165.1-165c19-18.9 19-49.7 0-68.6a48.7 48.7 0 00-68.7 0l-125 125.2c-5.2 5.2-13.3 5.2-18.5 0L189.5 521.4c-5.2-5.2-5.2-13.3 0-18.5l314.4-314.2c.4-.4.9-.7 1.3-1.1 5.2-4.1 12.4-3.7 17.2 1.1l125.2 125.1c19 19 49.8 19 68.7 0zM408.6 514.4a106.3 106.2 0 10212.6 0 106.3 106.2 0 10-212.6 0zm536.2-38.6L821.9 353.5c-19-18.9-49.8-18.9-68.7.1a48.4 48.4 0 000 68.6l83 82.9c5.2 5.2 5.2 13.3 0 18.5l-81.8 81.7a48.4 48.4 0 000 68.6 48.7 48.7 0 0068.7 0l121.8-121.7a53.93 53.93 0 00-.1-76.4z" } }] }, "name": "ant-design", "theme": "outlined" };
  exports.default = AntDesignOutlined;
  });

  var AntDesignOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(AntDesignOutlined_1);

  var AntDesignOutlined = function AntDesignOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: AntDesignOutlinedSvg
    }));
  };
  var RefIcon$o = /*#__PURE__*/React.forwardRef(AntDesignOutlined);
  {
    RefIcon$o.displayName = 'AntDesignOutlined';
  }

  var ApartmentOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ApartmentOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M908 640H804V488c0-4.4-3.6-8-8-8H548v-96h108c8.8 0 16-7.2 16-16V80c0-8.8-7.2-16-16-16H368c-8.8 0-16 7.2-16 16v288c0 8.8 7.2 16 16 16h108v96H228c-4.4 0-8 3.6-8 8v152H116c-8.8 0-16 7.2-16 16v288c0 8.8 7.2 16 16 16h288c8.8 0 16-7.2 16-16V656c0-8.8-7.2-16-16-16H292v-88h440v88H620c-8.8 0-16 7.2-16 16v288c0 8.8 7.2 16 16 16h288c8.8 0 16-7.2 16-16V656c0-8.8-7.2-16-16-16zm-564 76v168H176V716h168zm84-408V140h168v168H428zm420 576H680V716h168v168z" } }] }, "name": "apartment", "theme": "outlined" };
  exports.default = ApartmentOutlined;
  });

  var ApartmentOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(ApartmentOutlined_1);

  var ApartmentOutlined = function ApartmentOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ApartmentOutlinedSvg
    }));
  };
  var RefIcon$p = /*#__PURE__*/React.forwardRef(ApartmentOutlined);
  {
    RefIcon$p.displayName = 'ApartmentOutlined';
  }

  var ApiFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ApiFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M917.7 148.8l-42.4-42.4c-1.6-1.6-3.6-2.3-5.7-2.3s-4.1.8-5.7 2.3l-76.1 76.1a199.27 199.27 0 00-112.1-34.3c-51.2 0-102.4 19.5-141.5 58.6L432.3 308.7a8.03 8.03 0 000 11.3L704 591.7c1.6 1.6 3.6 2.3 5.7 2.3 2 0 4.1-.8 5.7-2.3l101.9-101.9c68.9-69 77-175.7 24.3-253.5l76.1-76.1c3.1-3.2 3.1-8.3 0-11.4zM578.9 546.7a8.03 8.03 0 00-11.3 0L501 613.3 410.7 523l66.7-66.7c3.1-3.1 3.1-8.2 0-11.3L441 408.6a8.03 8.03 0 00-11.3 0L363 475.3l-43-43a7.85 7.85 0 00-5.7-2.3c-2 0-4.1.8-5.7 2.3L206.8 534.2c-68.9 68.9-77 175.7-24.3 253.5l-76.1 76.1a8.03 8.03 0 000 11.3l42.4 42.4c1.6 1.6 3.6 2.3 5.7 2.3s4.1-.8 5.7-2.3l76.1-76.1c33.7 22.9 72.9 34.3 112.1 34.3 51.2 0 102.4-19.5 141.5-58.6l101.9-101.9c3.1-3.1 3.1-8.2 0-11.3l-43-43 66.7-66.7c3.1-3.1 3.1-8.2 0-11.3l-36.6-36.2z" } }] }, "name": "api", "theme": "filled" };
  exports.default = ApiFilled;
  });

  var ApiFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(ApiFilled_1);

  var ApiFilled = function ApiFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ApiFilledSvg
    }));
  };
  var RefIcon$q = /*#__PURE__*/React.forwardRef(ApiFilled);
  {
    RefIcon$q.displayName = 'ApiFilled';
  }

  var ApiOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ApiOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M917.7 148.8l-42.4-42.4c-1.6-1.6-3.6-2.3-5.7-2.3s-4.1.8-5.7 2.3l-76.1 76.1a199.27 199.27 0 00-112.1-34.3c-51.2 0-102.4 19.5-141.5 58.6L432.3 308.7a8.03 8.03 0 000 11.3L704 591.7c1.6 1.6 3.6 2.3 5.7 2.3 2 0 4.1-.8 5.7-2.3l101.9-101.9c68.9-69 77-175.7 24.3-253.5l76.1-76.1c3.1-3.2 3.1-8.3 0-11.4zM769.1 441.7l-59.4 59.4-186.8-186.8 59.4-59.4c24.9-24.9 58.1-38.7 93.4-38.7 35.3 0 68.4 13.7 93.4 38.7 24.9 24.9 38.7 58.1 38.7 93.4 0 35.3-13.8 68.4-38.7 93.4zm-190.2 105a8.03 8.03 0 00-11.3 0L501 613.3 410.7 523l66.7-66.7c3.1-3.1 3.1-8.2 0-11.3L441 408.6a8.03 8.03 0 00-11.3 0L363 475.3l-43-43a7.85 7.85 0 00-5.7-2.3c-2 0-4.1.8-5.7 2.3L206.8 534.2c-68.9 69-77 175.7-24.3 253.5l-76.1 76.1a8.03 8.03 0 000 11.3l42.4 42.4c1.6 1.6 3.6 2.3 5.7 2.3s4.1-.8 5.7-2.3l76.1-76.1c33.7 22.9 72.9 34.3 112.1 34.3 51.2 0 102.4-19.5 141.5-58.6l101.9-101.9c3.1-3.1 3.1-8.2 0-11.3l-43-43 66.7-66.7c3.1-3.1 3.1-8.2 0-11.3l-36.6-36.2zM441.7 769.1a131.32 131.32 0 01-93.4 38.7c-35.3 0-68.4-13.7-93.4-38.7a131.32 131.32 0 01-38.7-93.4c0-35.3 13.7-68.4 38.7-93.4l59.4-59.4 186.8 186.8-59.4 59.4z" } }] }, "name": "api", "theme": "outlined" };
  exports.default = ApiOutlined;
  });

  var ApiOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(ApiOutlined_1);

  var ApiOutlined = function ApiOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ApiOutlinedSvg
    }));
  };
  var RefIcon$r = /*#__PURE__*/React.forwardRef(ApiOutlined);
  {
    RefIcon$r.displayName = 'ApiOutlined';
  }

  var ApiTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ApiTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M148.2 674.6zm106.7-92.3c-25 25-38.7 58.1-38.7 93.4s13.8 68.5 38.7 93.4c25 25 58.1 38.7 93.4 38.7 35.3 0 68.5-13.8 93.4-38.7l59.4-59.4-186.8-186.8-59.4 59.4zm420.8-366.1c-35.3 0-68.5 13.8-93.4 38.7l-59.4 59.4 186.8 186.8 59.4-59.4c24.9-25 38.7-58.1 38.7-93.4s-13.8-68.5-38.7-93.4c-25-25-58.1-38.7-93.4-38.7z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M578.9 546.7a8.03 8.03 0 00-11.3 0L501 613.3 410.7 523l66.7-66.7c3.1-3.1 3.1-8.2 0-11.3L441 408.6a8.03 8.03 0 00-11.3 0L363 475.3l-43-43a7.85 7.85 0 00-5.7-2.3c-2 0-4.1.8-5.7 2.3L206.8 534.2a199.45 199.45 0 00-58.6 140.4c-.2 39.5 11.2 79.1 34.3 113.1l-76.1 76.1a8.03 8.03 0 000 11.3l42.4 42.4c1.6 1.6 3.6 2.3 5.7 2.3s4.1-.8 5.7-2.3l76.1-76.1c33.7 22.9 72.9 34.3 112.1 34.3 51.2 0 102.4-19.5 141.5-58.6l101.9-101.9c3.1-3.1 3.1-8.2 0-11.3l-43-43 66.7-66.7c3.1-3.1 3.1-8.2 0-11.3l-36.6-36.2zM441.7 769.1a131.32 131.32 0 01-93.4 38.7c-35.3 0-68.4-13.7-93.4-38.7-24.9-24.9-38.7-58.1-38.7-93.4s13.7-68.4 38.7-93.4l59.4-59.4 186.8 186.8-59.4 59.4zm476-620.3l-42.4-42.4c-1.6-1.6-3.6-2.3-5.7-2.3s-4.1.8-5.7 2.3l-76.1 76.1a199.27 199.27 0 00-112.1-34.3c-51.2 0-102.4 19.5-141.5 58.6L432.3 308.7a8.03 8.03 0 000 11.3L704 591.7c1.6 1.6 3.6 2.3 5.7 2.3 2 0 4.1-.8 5.7-2.3l101.9-101.9c68.9-69 77-175.7 24.3-253.5l76.1-76.1c3.1-3.2 3.1-8.3 0-11.4zM769.1 441.7l-59.4 59.4-186.8-186.8 59.4-59.4c24.9-24.9 58.1-38.7 93.4-38.7s68.4 13.7 93.4 38.7c24.9 24.9 38.7 58.1 38.7 93.4s-13.8 68.4-38.7 93.4z", "fill": primaryColor } }] }; }, "name": "api", "theme": "twotone" };
  exports.default = ApiTwoTone;
  });

  var ApiTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(ApiTwoTone_1);

  var ApiTwoTone = function ApiTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ApiTwoToneSvg
    }));
  };
  var RefIcon$s = /*#__PURE__*/React.forwardRef(ApiTwoTone);
  {
    RefIcon$s.displayName = 'ApiTwoTone';
  }

  var AppleFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var AppleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M747.4 535.7c-.4-68.2 30.5-119.6 92.9-157.5-34.9-50-87.7-77.5-157.3-82.8-65.9-5.2-138 38.4-164.4 38.4-27.9 0-91.7-36.6-141.9-36.6C273.1 298.8 163 379.8 163 544.6c0 48.7 8.9 99 26.7 150.8 23.8 68.2 109.6 235.3 199.1 232.6 46.8-1.1 79.9-33.2 140.8-33.2 59.1 0 89.7 33.2 141.9 33.2 90.3-1.3 167.9-153.2 190.5-221.6-121.1-57.1-114.6-167.2-114.6-170.7zm-105.1-305c50.7-60.2 46.1-115 44.6-134.7-44.8 2.6-96.6 30.5-126.1 64.8-32.5 36.8-51.6 82.3-47.5 133.6 48.4 3.7 92.6-21.2 129-63.7z" } }] }, "name": "apple", "theme": "filled" };
  exports.default = AppleFilled;
  });

  var AppleFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(AppleFilled_1);

  var AppleFilled = function AppleFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: AppleFilledSvg
    }));
  };
  var RefIcon$t = /*#__PURE__*/React.forwardRef(AppleFilled);
  {
    RefIcon$t.displayName = 'AppleFilled';
  }

  var AppleOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var AppleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M747.4 535.7c-.4-68.2 30.5-119.6 92.9-157.5-34.9-50-87.7-77.5-157.3-82.8-65.9-5.2-138 38.4-164.4 38.4-27.9 0-91.7-36.6-141.9-36.6C273.1 298.8 163 379.8 163 544.6c0 48.7 8.9 99 26.7 150.8 23.8 68.2 109.6 235.3 199.1 232.6 46.8-1.1 79.9-33.2 140.8-33.2 59.1 0 89.7 33.2 141.9 33.2 90.3-1.3 167.9-153.2 190.5-221.6-121.1-57.1-114.6-167.2-114.6-170.7zm-10.6 267c-14.3 19.9-28.7 35.6-41.9 45.7-10.5 8-18.6 11.4-24 11.6-9-.1-17.7-2.3-34.7-8.8-1.2-.5-2.5-1-4.2-1.6l-4.4-1.7c-17.4-6.7-27.8-10.3-41.1-13.8-18.6-4.8-37.1-7.4-56.9-7.4-20.2 0-39.2 2.5-58.1 7.2-13.9 3.5-25.6 7.4-42.7 13.8-.7.3-8.1 3.1-10.2 3.9-3.5 1.3-6.2 2.3-8.7 3.2-10.4 3.6-17 5.1-22.9 5.2-.7 0-1.3-.1-1.8-.2-1.1-.2-2.5-.6-4.1-1.3-4.5-1.8-9.9-5.1-16-9.8-14-10.9-29.4-28-45.1-49.9-27.5-38.6-53.5-89.8-66-125.7-15.4-44.8-23-87.7-23-128.6 0-60.2 17.8-106 48.4-137.1 26.3-26.6 61.7-41.5 97.8-42.3 5.9.1 14.5 1.5 25.4 4.5 8.6 2.3 18 5.4 30.7 9.9 3.8 1.4 16.9 6.1 18.5 6.7 7.7 2.8 13.5 4.8 19.2 6.6 18.2 5.8 32.3 9 47.6 9 15.5 0 28.8-3.3 47.7-9.8 7.1-2.4 32.9-12 37.5-13.6 25.6-9.1 44.5-14 60.8-15.2 4.8-.4 9.1-.4 13.2-.1 22.7 1.8 42.1 6.3 58.6 13.8-37.6 43.4-57 96.5-56.9 158.4-.3 14.7.9 31.7 5.1 51.8 6.4 30.5 18.6 60.7 37.9 89 14.7 21.5 32.9 40.9 54.7 57.8-11.5 23.7-25.6 48.2-40.4 68.8zm-94.5-572c50.7-60.2 46.1-115 44.6-134.7-44.8 2.6-96.6 30.5-126.1 64.8-32.5 36.8-51.6 82.3-47.5 133.6 48.4 3.7 92.6-21.2 129-63.7z" } }] }, "name": "apple", "theme": "outlined" };
  exports.default = AppleOutlined;
  });

  var AppleOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(AppleOutlined_1);

  var AppleOutlined = function AppleOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: AppleOutlinedSvg
    }));
  };
  var RefIcon$u = /*#__PURE__*/React.forwardRef(AppleOutlined);
  {
    RefIcon$u.displayName = 'AppleOutlined';
  }

  var AppstoreAddOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var AppstoreAddOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M464 144H160c-8.8 0-16 7.2-16 16v304c0 8.8 7.2 16 16 16h304c8.8 0 16-7.2 16-16V160c0-8.8-7.2-16-16-16zm-52 268H212V212h200v200zm452-268H560c-8.8 0-16 7.2-16 16v304c0 8.8 7.2 16 16 16h304c8.8 0 16-7.2 16-16V160c0-8.8-7.2-16-16-16zm-52 268H612V212h200v200zm52 132H560c-8.8 0-16 7.2-16 16v304c0 8.8 7.2 16 16 16h304c8.8 0 16-7.2 16-16V560c0-8.8-7.2-16-16-16zm-52 268H612V612h200v200zM424 712H296V584c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v128H104c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h128v128c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V776h128c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8z" } }] }, "name": "appstore-add", "theme": "outlined" };
  exports.default = AppstoreAddOutlined;
  });

  var AppstoreAddOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(AppstoreAddOutlined_1);

  var AppstoreAddOutlined = function AppstoreAddOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: AppstoreAddOutlinedSvg
    }));
  };
  var RefIcon$v = /*#__PURE__*/React.forwardRef(AppstoreAddOutlined);
  {
    RefIcon$v.displayName = 'AppstoreAddOutlined';
  }

  var AppstoreFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var AppstoreFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M864 144H560c-8.8 0-16 7.2-16 16v304c0 8.8 7.2 16 16 16h304c8.8 0 16-7.2 16-16V160c0-8.8-7.2-16-16-16zm0 400H560c-8.8 0-16 7.2-16 16v304c0 8.8 7.2 16 16 16h304c8.8 0 16-7.2 16-16V560c0-8.8-7.2-16-16-16zM464 144H160c-8.8 0-16 7.2-16 16v304c0 8.8 7.2 16 16 16h304c8.8 0 16-7.2 16-16V160c0-8.8-7.2-16-16-16zm0 400H160c-8.8 0-16 7.2-16 16v304c0 8.8 7.2 16 16 16h304c8.8 0 16-7.2 16-16V560c0-8.8-7.2-16-16-16z" } }] }, "name": "appstore", "theme": "filled" };
  exports.default = AppstoreFilled;
  });

  var AppstoreFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(AppstoreFilled_1);

  var AppstoreFilled = function AppstoreFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: AppstoreFilledSvg
    }));
  };
  var RefIcon$w = /*#__PURE__*/React.forwardRef(AppstoreFilled);
  {
    RefIcon$w.displayName = 'AppstoreFilled';
  }

  var AppstoreOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var AppstoreOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M464 144H160c-8.8 0-16 7.2-16 16v304c0 8.8 7.2 16 16 16h304c8.8 0 16-7.2 16-16V160c0-8.8-7.2-16-16-16zm-52 268H212V212h200v200zm452-268H560c-8.8 0-16 7.2-16 16v304c0 8.8 7.2 16 16 16h304c8.8 0 16-7.2 16-16V160c0-8.8-7.2-16-16-16zm-52 268H612V212h200v200zM464 544H160c-8.8 0-16 7.2-16 16v304c0 8.8 7.2 16 16 16h304c8.8 0 16-7.2 16-16V560c0-8.8-7.2-16-16-16zm-52 268H212V612h200v200zm452-268H560c-8.8 0-16 7.2-16 16v304c0 8.8 7.2 16 16 16h304c8.8 0 16-7.2 16-16V560c0-8.8-7.2-16-16-16zm-52 268H612V612h200v200z" } }] }, "name": "appstore", "theme": "outlined" };
  exports.default = AppstoreOutlined;
  });

  var AppstoreOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(AppstoreOutlined_1);

  var AppstoreOutlined = function AppstoreOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: AppstoreOutlinedSvg
    }));
  };
  var RefIcon$x = /*#__PURE__*/React.forwardRef(AppstoreOutlined);
  {
    RefIcon$x.displayName = 'AppstoreOutlined';
  }

  var AppstoreTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var AppstoreTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M864 144H560c-8.8 0-16 7.2-16 16v304c0 8.8 7.2 16 16 16h304c8.8 0 16-7.2 16-16V160c0-8.8-7.2-16-16-16zm-52 268H612V212h200v200zM464 544H160c-8.8 0-16 7.2-16 16v304c0 8.8 7.2 16 16 16h304c8.8 0 16-7.2 16-16V560c0-8.8-7.2-16-16-16zm-52 268H212V612h200v200zm52-668H160c-8.8 0-16 7.2-16 16v304c0 8.8 7.2 16 16 16h304c8.8 0 16-7.2 16-16V160c0-8.8-7.2-16-16-16zm-52 268H212V212h200v200zm452 132H560c-8.8 0-16 7.2-16 16v304c0 8.8 7.2 16 16 16h304c8.8 0 16-7.2 16-16V560c0-8.8-7.2-16-16-16zm-52 268H612V612h200v200z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M212 212h200v200H212zm400 0h200v200H612zM212 612h200v200H212zm400 0h200v200H612z", "fill": secondaryColor } }] }; }, "name": "appstore", "theme": "twotone" };
  exports.default = AppstoreTwoTone;
  });

  var AppstoreTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(AppstoreTwoTone_1);

  var AppstoreTwoTone = function AppstoreTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: AppstoreTwoToneSvg
    }));
  };
  var RefIcon$y = /*#__PURE__*/React.forwardRef(AppstoreTwoTone);
  {
    RefIcon$y.displayName = 'AppstoreTwoTone';
  }

  var AreaChartOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var AreaChartOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M888 792H200V168c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v688c0 4.4 3.6 8 8 8h752c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-616-64h536c4.4 0 8-3.6 8-8V284c0-7.2-8.7-10.7-13.7-5.7L592 488.6l-125.4-124a8.03 8.03 0 00-11.3 0l-189 189.6a7.87 7.87 0 00-2.3 5.6V720c0 4.4 3.6 8 8 8z" } }] }, "name": "area-chart", "theme": "outlined" };
  exports.default = AreaChartOutlined;
  });

  var AreaChartOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(AreaChartOutlined_1);

  var AreaChartOutlined = function AreaChartOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: AreaChartOutlinedSvg
    }));
  };
  var RefIcon$z = /*#__PURE__*/React.forwardRef(AreaChartOutlined);
  {
    RefIcon$z.displayName = 'AreaChartOutlined';
  }

  var ArrowDownOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ArrowDownOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M862 465.3h-81c-4.6 0-9 2-12.1 5.5L550 723.1V160c0-4.4-3.6-8-8-8h-60c-4.4 0-8 3.6-8 8v563.1L255.1 470.8c-3-3.5-7.4-5.5-12.1-5.5h-81c-6.8 0-10.5 8.1-6 13.2L487.9 861a31.96 31.96 0 0048.3 0L868 478.5c4.5-5.2.8-13.2-6-13.2z" } }] }, "name": "arrow-down", "theme": "outlined" };
  exports.default = ArrowDownOutlined;
  });

  var ArrowDownOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(ArrowDownOutlined_1);

  var ArrowDownOutlined = function ArrowDownOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ArrowDownOutlinedSvg
    }));
  };
  var RefIcon$A = /*#__PURE__*/React.forwardRef(ArrowDownOutlined);
  {
    RefIcon$A.displayName = 'ArrowDownOutlined';
  }

  var ArrowLeftOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ArrowLeftOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M872 474H286.9l350.2-304c5.6-4.9 2.2-14-5.2-14h-88.5c-3.9 0-7.6 1.4-10.5 3.9L155 487.8a31.96 31.96 0 000 48.3L535.1 866c1.5 1.3 3.3 2 5.2 2h91.5c7.4 0 10.8-9.2 5.2-14L286.9 550H872c4.4 0 8-3.6 8-8v-60c0-4.4-3.6-8-8-8z" } }] }, "name": "arrow-left", "theme": "outlined" };
  exports.default = ArrowLeftOutlined;
  });

  var ArrowLeftOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(ArrowLeftOutlined_1);

  var ArrowLeftOutlined = function ArrowLeftOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ArrowLeftOutlinedSvg
    }));
  };
  var RefIcon$B = /*#__PURE__*/React.forwardRef(ArrowLeftOutlined);
  {
    RefIcon$B.displayName = 'ArrowLeftOutlined';
  }

  var ArrowRightOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ArrowRightOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M869 487.8L491.2 159.9c-2.9-2.5-6.6-3.9-10.5-3.9h-88.5c-7.4 0-10.8 9.2-5.2 14l350.2 304H152c-4.4 0-8 3.6-8 8v60c0 4.4 3.6 8 8 8h585.1L386.9 854c-5.6 4.9-2.2 14 5.2 14h91.5c1.9 0 3.8-.7 5.2-2L869 536.2a32.07 32.07 0 000-48.4z" } }] }, "name": "arrow-right", "theme": "outlined" };
  exports.default = ArrowRightOutlined;
  });

  var ArrowRightOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(ArrowRightOutlined_1);

  var ArrowRightOutlined = function ArrowRightOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ArrowRightOutlinedSvg
    }));
  };
  var RefIcon$C = /*#__PURE__*/React.forwardRef(ArrowRightOutlined);
  {
    RefIcon$C.displayName = 'ArrowRightOutlined';
  }

  var ArrowUpOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ArrowUpOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M868 545.5L536.1 163a31.96 31.96 0 00-48.3 0L156 545.5a7.97 7.97 0 006 13.2h81c4.6 0 9-2 12.1-5.5L474 300.9V864c0 4.4 3.6 8 8 8h60c4.4 0 8-3.6 8-8V300.9l218.9 252.3c3 3.5 7.4 5.5 12.1 5.5h81c6.8 0 10.5-8 6-13.2z" } }] }, "name": "arrow-up", "theme": "outlined" };
  exports.default = ArrowUpOutlined;
  });

  var ArrowUpOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(ArrowUpOutlined_1);

  var ArrowUpOutlined = function ArrowUpOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ArrowUpOutlinedSvg
    }));
  };
  var RefIcon$D = /*#__PURE__*/React.forwardRef(ArrowUpOutlined);
  {
    RefIcon$D.displayName = 'ArrowUpOutlined';
  }

  var ArrowsAltOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ArrowsAltOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M855 160.1l-189.2 23.5c-6.6.8-9.3 8.8-4.7 13.5l54.7 54.7-153.5 153.5a8.03 8.03 0 000 11.3l45.1 45.1c3.1 3.1 8.2 3.1 11.3 0l153.6-153.6 54.7 54.7a7.94 7.94 0 0013.5-4.7L863.9 169a7.9 7.9 0 00-8.9-8.9zM416.6 562.3a8.03 8.03 0 00-11.3 0L251.8 715.9l-54.7-54.7a7.94 7.94 0 00-13.5 4.7L160.1 855c-.6 5.2 3.7 9.5 8.9 8.9l189.2-23.5c6.6-.8 9.3-8.8 4.7-13.5l-54.7-54.7 153.6-153.6c3.1-3.1 3.1-8.2 0-11.3l-45.2-45z" } }] }, "name": "arrows-alt", "theme": "outlined" };
  exports.default = ArrowsAltOutlined;
  });

  var ArrowsAltOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(ArrowsAltOutlined_1);

  var ArrowsAltOutlined = function ArrowsAltOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ArrowsAltOutlinedSvg
    }));
  };
  var RefIcon$E = /*#__PURE__*/React.forwardRef(ArrowsAltOutlined);
  {
    RefIcon$E.displayName = 'ArrowsAltOutlined';
  }

  var AudioFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var AudioFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 624c93.9 0 170-75.2 170-168V232c0-92.8-76.1-168-170-168s-170 75.2-170 168v224c0 92.8 76.1 168 170 168zm330-170c0-4.4-3.6-8-8-8h-60c-4.4 0-8 3.6-8 8 0 140.3-113.7 254-254 254S258 594.3 258 454c0-4.4-3.6-8-8-8h-60c-4.4 0-8 3.6-8 8 0 168.7 126.6 307.9 290 327.6V884H326.7c-13.7 0-24.7 14.3-24.7 32v36c0 4.4 2.8 8 6.2 8h407.6c3.4 0 6.2-3.6 6.2-8v-36c0-17.7-11-32-24.7-32H548V782.1c165.3-18 294-158 294-328.1z" } }] }, "name": "audio", "theme": "filled" };
  exports.default = AudioFilled;
  });

  var AudioFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(AudioFilled_1);

  var AudioFilled = function AudioFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: AudioFilledSvg
    }));
  };
  var RefIcon$F = /*#__PURE__*/React.forwardRef(AudioFilled);
  {
    RefIcon$F.displayName = 'AudioFilled';
  }

  var AudioMutedOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var AudioMutedOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M682 455V311l-76 76v68c-.1 50.7-42 92.1-94 92a95.8 95.8 0 01-52-15l-54 55c29.1 22.4 65.9 36 106 36 93.8 0 170-75.1 170-168z" } }, { "tag": "path", "attrs": { "d": "M833 446h-60c-4.4 0-8 3.6-8 8 0 140.3-113.7 254-254 254-63 0-120.7-23-165-61l-54 54a334.01 334.01 0 00179 81v102H326c-13.9 0-24.9 14.3-25 32v36c.1 4.4 2.9 8 6 8h408c3.2 0 6-3.6 6-8v-36c0-17.7-11-32-25-32H547V782c165.3-17.9 294-157.9 294-328 0-4.4-3.6-8-8-8zm13.1-377.7l-43.5-41.9a8 8 0 00-11.2.1l-129 129C634.3 101.2 577 64 511 64c-93.9 0-170 75.3-170 168v224c0 6.7.4 13.3 1.2 19.8l-68 68A252.33 252.33 0 01258 454c-.2-4.4-3.8-8-8-8h-60c-4.4 0-8 3.6-8 8 0 53 12.5 103 34.6 147.4l-137 137a8.03 8.03 0 000 11.3l42.7 42.7c3.1 3.1 8.2 3.1 11.3 0L846.2 79.8l.1-.1c3.1-3.2 3-8.3-.2-11.4zM417 401V232c0-50.6 41.9-92 94-92 46 0 84.1 32.3 92.3 74.7L417 401z" } }] }, "name": "audio-muted", "theme": "outlined" };
  exports.default = AudioMutedOutlined;
  });

  var AudioMutedOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(AudioMutedOutlined_1);

  var AudioMutedOutlined = function AudioMutedOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: AudioMutedOutlinedSvg
    }));
  };
  var RefIcon$G = /*#__PURE__*/React.forwardRef(AudioMutedOutlined);
  {
    RefIcon$G.displayName = 'AudioMutedOutlined';
  }

  var AudioOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var AudioOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M842 454c0-4.4-3.6-8-8-8h-60c-4.4 0-8 3.6-8 8 0 140.3-113.7 254-254 254S258 594.3 258 454c0-4.4-3.6-8-8-8h-60c-4.4 0-8 3.6-8 8 0 168.7 126.6 307.9 290 327.6V884H326.7c-13.7 0-24.7 14.3-24.7 32v36c0 4.4 2.8 8 6.2 8h407.6c3.4 0 6.2-3.6 6.2-8v-36c0-17.7-11-32-24.7-32H548V782.1c165.3-18 294-158 294-328.1zM512 624c93.9 0 170-75.2 170-168V232c0-92.8-76.1-168-170-168s-170 75.2-170 168v224c0 92.8 76.1 168 170 168zm-94-392c0-50.6 41.9-92 94-92s94 41.4 94 92v224c0 50.6-41.9 92-94 92s-94-41.4-94-92V232z" } }] }, "name": "audio", "theme": "outlined" };
  exports.default = AudioOutlined;
  });

  var AudioOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(AudioOutlined_1);

  var AudioOutlined = function AudioOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: AudioOutlinedSvg
    }));
  };
  var RefIcon$H = /*#__PURE__*/React.forwardRef(AudioOutlined);
  {
    RefIcon$H.displayName = 'AudioOutlined';
  }

  var AudioTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var AudioTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 552c54.3 0 98-43.2 98-96V232c0-52.8-43.7-96-98-96s-98 43.2-98 96v224c0 52.8 43.7 96 98 96z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M842 454c0-4.4-3.6-8-8-8h-60c-4.4 0-8 3.6-8 8 0 140.3-113.7 254-254 254S258 594.3 258 454c0-4.4-3.6-8-8-8h-60c-4.4 0-8 3.6-8 8 0 168.7 126.6 307.9 290 327.6V884H326.7c-13.7 0-24.7 14.3-24.7 32v36c0 4.4 2.8 8 6.2 8h407.6c3.4 0 6.2-3.6 6.2-8v-36c0-17.7-11-32-24.7-32H548V782.1c165.3-18 294-158 294-328.1z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 624c93.9 0 170-75.2 170-168V232c0-92.8-76.1-168-170-168s-170 75.2-170 168v224c0 92.8 76.1 168 170 168zm-98-392c0-52.8 43.7-96 98-96s98 43.2 98 96v224c0 52.8-43.7 96-98 96s-98-43.2-98-96V232z", "fill": primaryColor } }] }; }, "name": "audio", "theme": "twotone" };
  exports.default = AudioTwoTone;
  });

  var AudioTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(AudioTwoTone_1);

  var AudioTwoTone = function AudioTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: AudioTwoToneSvg
    }));
  };
  var RefIcon$I = /*#__PURE__*/React.forwardRef(AudioTwoTone);
  {
    RefIcon$I.displayName = 'AudioTwoTone';
  }

  var AuditOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var AuditOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M296 250c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h384c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H296zm184 144H296c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h184c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8zm-48 458H208V148h560v320c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V108c0-17.7-14.3-32-32-32H168c-17.7 0-32 14.3-32 32v784c0 17.7 14.3 32 32 32h264c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm440-88H728v-36.6c46.3-13.8 80-56.6 80-107.4 0-61.9-50.1-112-112-112s-112 50.1-112 112c0 50.7 33.7 93.6 80 107.4V764H520c-8.8 0-16 7.2-16 16v152c0 8.8 7.2 16 16 16h352c8.8 0 16-7.2 16-16V780c0-8.8-7.2-16-16-16zM646 620c0-27.6 22.4-50 50-50s50 22.4 50 50-22.4 50-50 50-50-22.4-50-50zm180 266H566v-60h260v60z" } }] }, "name": "audit", "theme": "outlined" };
  exports.default = AuditOutlined;
  });

  var AuditOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(AuditOutlined_1);

  var AuditOutlined = function AuditOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: AuditOutlinedSvg
    }));
  };
  var RefIcon$J = /*#__PURE__*/React.forwardRef(AuditOutlined);
  {
    RefIcon$J.displayName = 'AuditOutlined';
  }

  var BackwardFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BackwardFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M485.6 249.9L198.2 498c-8.3 7.1-8.3 20.8 0 27.9l287.4 248.2c10.7 9.2 26.4.9 26.4-14V263.8c0-14.8-15.7-23.2-26.4-13.9zm320 0L518.2 498a18.6 18.6 0 00-6.2 14c0 5.2 2.1 10.4 6.2 14l287.4 248.2c10.7 9.2 26.4.9 26.4-14V263.8c0-14.8-15.7-23.2-26.4-13.9z" } }] }, "name": "backward", "theme": "filled" };
  exports.default = BackwardFilled;
  });

  var BackwardFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(BackwardFilled_1);

  var BackwardFilled = function BackwardFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BackwardFilledSvg
    }));
  };
  var RefIcon$K = /*#__PURE__*/React.forwardRef(BackwardFilled);
  {
    RefIcon$K.displayName = 'BackwardFilled';
  }

  var BackwardOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BackwardOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M485.6 249.9L198.2 498c-8.3 7.1-8.3 20.8 0 27.9l287.4 248.2c10.7 9.2 26.4.9 26.4-14V263.8c0-14.8-15.7-23.2-26.4-13.9zm320 0L518.2 498a18.6 18.6 0 00-6.2 14c0 5.2 2.1 10.4 6.2 14l287.4 248.2c10.7 9.2 26.4.9 26.4-14V263.8c0-14.8-15.7-23.2-26.4-13.9z" } }] }, "name": "backward", "theme": "outlined" };
  exports.default = BackwardOutlined;
  });

  var BackwardOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(BackwardOutlined_1);

  var BackwardOutlined = function BackwardOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BackwardOutlinedSvg
    }));
  };
  var RefIcon$L = /*#__PURE__*/React.forwardRef(BackwardOutlined);
  {
    RefIcon$L.displayName = 'BackwardOutlined';
  }

  var BaiduOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BaiduOutlined = { "icon": { "tag": "svg", "attrs": { "fill-rule": "evenodd", "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M250.02 547.04c92.37-19.8 79.77-130.07 76.95-154.18-4.56-37.2-48.26-102.16-107.63-97.02-74.7 6.7-85.65 114.58-85.65 114.58-10.04 49.88 24.2 156.43 116.33 136.62m84.7 214.14c10.28 38.7 43.95 40.43 43.95 40.43H427V683.55h-51.74c-23.22 6.96-34.5 25.1-36.98 32.8-2.74 7.8-8.71 27.6-3.57 44.83m169.07-531.1c0-72.42-41.13-131.08-92.2-131.08-50.92 0-92.21 58.66-92.21 131.07 0 72.5 41.3 131.16 92.2 131.16 51.08 0 92.21-58.66 92.21-131.16m248.1 9.1c8.86-54.92-35.08-118.88-83.34-129.82-48.34-11.1-108.7 66.28-114.18 116.74-6.55 61.72 8.79 123.28 76.86 132.06 68.16 8.87 112.03-63.87 120.65-118.97m46.35 433.02s-105.47-81.53-167-169.6c-83.4-129.91-201.98-77.05-241.62-11.02-39.47 66.03-101 107.87-109.7 118.9-8.87 10.93-127.36 74.8-101.07 191.55 26.28 116.65 118.73 114.5 118.73 114.5s68.08 6.7 147.1-10.94C523.7 888.03 591.7 910 591.7 910s184.57 61.72 235.07-57.18c50.41-118.97-28.53-180.61-28.53-180.61M362.42 849.17c-51.83-10.36-72.47-45.65-75.13-51.7-2.57-6.13-17.24-34.55-9.45-82.85 22.39-72.41 86.23-77.63 86.23-77.63h63.85v-78.46l54.4.82.08 289.82zm205.38-.83c-53.56-13.75-56.05-51.78-56.05-51.78V643.95l56.05-.92v137.12c3.4 14.59 21.65 17.32 21.65 17.32h56.88V643.95h59.62v204.39zm323.84-397.72c0-26.35-21.89-105.72-103.15-105.72-81.43 0-92.29 74.9-92.29 127.84 0 50.54 4.31 121.13 105.4 118.8 101.15-2.15 90.04-114.41 90.04-140.92" } }] }, "name": "baidu", "theme": "outlined" };
  exports.default = BaiduOutlined;
  });

  var BaiduOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(BaiduOutlined_1);

  var BaiduOutlined = function BaiduOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BaiduOutlinedSvg
    }));
  };
  var RefIcon$M = /*#__PURE__*/React.forwardRef(BaiduOutlined);
  {
    RefIcon$M.displayName = 'BaiduOutlined';
  }

  var BankFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BankFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M894 462c30.9 0 43.8-39.7 18.7-58L530.8 126.2a31.81 31.81 0 00-37.6 0L111.3 404c-25.1 18.2-12.2 58 18.8 58H192v374h-72c-4.4 0-8 3.6-8 8v52c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-52c0-4.4-3.6-8-8-8h-72V462h62zM381 836H264V462h117v374zm189 0H453V462h117v374zm190 0H642V462h118v374z" } }] }, "name": "bank", "theme": "filled" };
  exports.default = BankFilled;
  });

  var BankFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(BankFilled_1);

  var BankFilled = function BankFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BankFilledSvg
    }));
  };
  var RefIcon$N = /*#__PURE__*/React.forwardRef(BankFilled);
  {
    RefIcon$N.displayName = 'BankFilled';
  }

  var BankOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BankOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M894 462c30.9 0 43.8-39.7 18.7-58L530.8 126.2a31.81 31.81 0 00-37.6 0L111.3 404c-25.1 18.2-12.2 58 18.8 58H192v374h-72c-4.4 0-8 3.6-8 8v52c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-52c0-4.4-3.6-8-8-8h-72V462h62zM512 196.7l271.1 197.2H240.9L512 196.7zM264 462h117v374H264V462zm189 0h117v374H453V462zm307 374H642V462h118v374z" } }] }, "name": "bank", "theme": "outlined" };
  exports.default = BankOutlined;
  });

  var BankOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(BankOutlined_1);

  var BankOutlined = function BankOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BankOutlinedSvg
    }));
  };
  var RefIcon$O = /*#__PURE__*/React.forwardRef(BankOutlined);
  {
    RefIcon$O.displayName = 'BankOutlined';
  }

  var BankTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BankTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M240.9 393.9h542.2L512 196.7z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M894 462c30.9 0 43.8-39.7 18.7-58L530.8 126.2a31.81 31.81 0 00-37.6 0L111.3 404c-25.1 18.2-12.2 58 18.8 58H192v374h-72c-4.4 0-8 3.6-8 8v52c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-52c0-4.4-3.6-8-8-8h-72V462h62zM381 836H264V462h117v374zm189 0H453V462h117v374zm190 0H642V462h118v374zM240.9 393.9L512 196.7l271.1 197.2H240.9z", "fill": primaryColor } }] }; }, "name": "bank", "theme": "twotone" };
  exports.default = BankTwoTone;
  });

  var BankTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(BankTwoTone_1);

  var BankTwoTone = function BankTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BankTwoToneSvg
    }));
  };
  var RefIcon$P = /*#__PURE__*/React.forwardRef(BankTwoTone);
  {
    RefIcon$P.displayName = 'BankTwoTone';
  }

  var BarChartOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BarChartOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M888 792H200V168c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v688c0 4.4 3.6 8 8 8h752c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-600-80h56c4.4 0 8-3.6 8-8V560c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v144c0 4.4 3.6 8 8 8zm152 0h56c4.4 0 8-3.6 8-8V384c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v320c0 4.4 3.6 8 8 8zm152 0h56c4.4 0 8-3.6 8-8V462c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v242c0 4.4 3.6 8 8 8zm152 0h56c4.4 0 8-3.6 8-8V304c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v400c0 4.4 3.6 8 8 8z" } }] }, "name": "bar-chart", "theme": "outlined" };
  exports.default = BarChartOutlined;
  });

  var BarChartOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(BarChartOutlined_1);

  var BarChartOutlined = function BarChartOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BarChartOutlinedSvg
    }));
  };
  var RefIcon$Q = /*#__PURE__*/React.forwardRef(BarChartOutlined);
  {
    RefIcon$Q.displayName = 'BarChartOutlined';
  }

  var BarcodeOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BarcodeOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M120 160H72c-4.4 0-8 3.6-8 8v688c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V168c0-4.4-3.6-8-8-8zm833 0h-48c-4.4 0-8 3.6-8 8v688c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V168c0-4.4-3.6-8-8-8zM200 736h112c4.4 0 8-3.6 8-8V168c0-4.4-3.6-8-8-8H200c-4.4 0-8 3.6-8 8v560c0 4.4 3.6 8 8 8zm321 0h48c4.4 0 8-3.6 8-8V168c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v560c0 4.4 3.6 8 8 8zm126 0h178c4.4 0 8-3.6 8-8V168c0-4.4-3.6-8-8-8H647c-4.4 0-8 3.6-8 8v560c0 4.4 3.6 8 8 8zm-255 0h48c4.4 0 8-3.6 8-8V168c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v560c0 4.4 3.6 8 8 8zm-79 64H201c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h112c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8zm257 0h-48c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8zm256 0H648c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h178c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8zm-385 0h-48c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8z" } }] }, "name": "barcode", "theme": "outlined" };
  exports.default = BarcodeOutlined;
  });

  var BarcodeOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(BarcodeOutlined_1);

  var BarcodeOutlined = function BarcodeOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BarcodeOutlinedSvg
    }));
  };
  var RefIcon$R = /*#__PURE__*/React.forwardRef(BarcodeOutlined);
  {
    RefIcon$R.displayName = 'BarcodeOutlined';
  }

  var BarsOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BarsOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M912 192H328c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h584c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 284H328c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h584c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 284H328c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h584c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM104 228a56 56 0 10112 0 56 56 0 10-112 0zm0 284a56 56 0 10112 0 56 56 0 10-112 0zm0 284a56 56 0 10112 0 56 56 0 10-112 0z" } }] }, "name": "bars", "theme": "outlined" };
  exports.default = BarsOutlined;
  });

  var BarsOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(BarsOutlined_1);

  var BarsOutlined = function BarsOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BarsOutlinedSvg
    }));
  };
  var RefIcon$S = /*#__PURE__*/React.forwardRef(BarsOutlined);
  {
    RefIcon$S.displayName = 'BarsOutlined';
  }

  var BehanceCircleFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BehanceCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M420.3 470.3c8.7-6.3 12.9-16.7 12.9-31 .3-6.8-1.1-13.5-4.1-19.6-2.7-4.9-6.7-9-11.6-11.9a44.8 44.8 0 00-16.6-6c-6.4-1.2-12.9-1.8-19.3-1.7h-70.3v79.7h76.1c13.1.1 24.2-3.1 32.9-9.5zm11.8 72c-9.8-7.5-22.9-11.2-39.2-11.2h-81.8v94h80.2c7.5 0 14.4-.7 21.1-2.1a50.5 50.5 0 0017.8-7.2c5.1-3.3 9.2-7.8 12.3-13.6 3-5.8 4.5-13.2 4.5-22.1 0-17.7-5-30.2-14.9-37.8zM512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm86.5 286.9h138.4v33.7H598.5v-33.7zM512 628.8a89.52 89.52 0 01-27 31c-11.8 8.2-24.9 14.2-38.8 17.7a167.4 167.4 0 01-44.6 5.7H236V342.1h161c16.3 0 31.1 1.5 44.6 4.3 13.4 2.8 24.8 7.6 34.4 14.1 9.5 6.5 17 15.2 22.3 26 5.2 10.7 7.9 24.1 7.9 40 0 17.2-3.9 31.4-11.7 42.9-7.9 11.5-19.3 20.8-34.8 28.1 21.1 6 36.6 16.7 46.8 31.7 10.4 15.2 15.5 33.4 15.5 54.8 0 17.4-3.3 32.3-10 44.8zM790.8 576H612.4c0 19.4 6.7 38 16.8 48 10.2 9.9 24.8 14.9 43.9 14.9 13.8 0 25.5-3.5 35.5-10.4 9.9-6.9 15.9-14.2 18.1-21.8h59.8c-9.6 29.7-24.2 50.9-44 63.7-19.6 12.8-43.6 19.2-71.5 19.2-19.5 0-37-3.2-52.7-9.3-15.1-5.9-28.7-14.9-39.9-26.5a121.2 121.2 0 01-25.1-41.2c-6.1-16.9-9.1-34.7-8.9-52.6 0-18.5 3.1-35.7 9.1-51.7 11.5-31.1 35.4-56 65.9-68.9 16.3-6.8 33.8-10.2 51.5-10 21 0 39.2 4 55 12.2a111.6 111.6 0 0138.6 32.8c10.1 13.7 17.2 29.3 21.7 46.9 4.3 17.3 5.8 35.5 4.6 54.7zm-122-95.6c-10.8 0-19.9 1.9-26.9 5.6-7 3.7-12.8 8.3-17.2 13.6a48.4 48.4 0 00-9.1 17.4c-1.6 5.3-2.7 10.7-3.1 16.2H723c-1.6-17.3-7.6-30.1-15.6-39.1-8.4-8.9-21.9-13.7-38.6-13.7z" } }] }, "name": "behance-circle", "theme": "filled" };
  exports.default = BehanceCircleFilled;
  });

  var BehanceCircleFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(BehanceCircleFilled_1);

  var BehanceCircleFilled = function BehanceCircleFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BehanceCircleFilledSvg
    }));
  };
  var RefIcon$T = /*#__PURE__*/React.forwardRef(BehanceCircleFilled);
  {
    RefIcon$T.displayName = 'BehanceCircleFilled';
  }

  var BehanceOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BehanceOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M634 294.3h199.5v48.4H634zM434.1 485.8c44.1-21.1 67.2-53.2 67.2-102.8 0-98.1-73-121.9-157.3-121.9H112v492.4h238.5c89.4 0 173.3-43 173.3-143 0-61.8-29.2-107.5-89.7-124.7zM220.2 345.1h101.5c39.1 0 74.2 10.9 74.2 56.3 0 41.8-27.3 58.6-66 58.6H220.2V345.1zm115.5 324.8H220.1V534.3H338c47.6 0 77.7 19.9 77.7 70.3 0 49.6-35.9 65.3-80 65.3zm575.8-89.5c0-105.5-61.7-193.4-173.3-193.4-108.5 0-182.3 81.7-182.3 188.8 0 111 69.9 187.2 182.3 187.2 85.1 0 140.2-38.3 166.7-120h-86.3c-9.4 30.5-47.6 46.5-77.3 46.5-57.4 0-87.4-33.6-87.4-90.7h256.9c.3-5.9.7-12.1.7-18.4zM653.9 537c3.1-46.9 34.4-76.2 81.2-76.2 49.2 0 73.8 28.9 78.1 76.2H653.9z" } }] }, "name": "behance", "theme": "outlined" };
  exports.default = BehanceOutlined;
  });

  var BehanceOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(BehanceOutlined_1);

  var BehanceOutlined = function BehanceOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BehanceOutlinedSvg
    }));
  };
  var RefIcon$U = /*#__PURE__*/React.forwardRef(BehanceOutlined);
  {
    RefIcon$U.displayName = 'BehanceOutlined';
  }

  var BehanceSquareFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BehanceSquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM598.5 350.9h138.4v33.7H598.5v-33.7zM512 628.8a89.52 89.52 0 01-27 31c-11.8 8.2-24.9 14.2-38.8 17.7a167.4 167.4 0 01-44.6 5.7H236V342.1h161c16.3 0 31.1 1.5 44.6 4.3 13.4 2.8 24.8 7.6 34.4 14.1 9.5 6.5 17 15.2 22.3 26 5.2 10.7 7.9 24.1 7.9 40 0 17.2-3.9 31.4-11.7 42.9-7.9 11.5-19.3 20.8-34.8 28.1 21.1 6 36.6 16.7 46.8 31.7 10.4 15.2 15.5 33.4 15.5 54.8 0 17.4-3.3 32.3-10 44.8zM790.8 576H612.4c0 19.4 6.7 38 16.8 48 10.2 9.9 24.8 14.9 43.9 14.9 13.8 0 25.5-3.5 35.5-10.4 9.9-6.9 15.9-14.2 18.1-21.8h59.8c-9.6 29.7-24.2 50.9-44 63.7-19.6 12.8-43.6 19.2-71.5 19.2-19.5 0-37-3.2-52.7-9.3-15.1-5.9-28.7-14.9-39.9-26.5a121.2 121.2 0 01-25.1-41.2c-6.1-16.9-9.1-34.7-8.9-52.6 0-18.5 3.1-35.7 9.1-51.7 11.5-31.1 35.4-56 65.9-68.9 16.3-6.8 33.8-10.2 51.5-10 21 0 39.2 4 55 12.2a111.6 111.6 0 0138.6 32.8c10.1 13.7 17.2 29.3 21.7 46.9 4.3 17.3 5.8 35.5 4.6 54.7zm-122-95.6c-10.8 0-19.9 1.9-26.9 5.6-7 3.7-12.8 8.3-17.2 13.6a48.4 48.4 0 00-9.1 17.4c-1.6 5.3-2.7 10.7-3.1 16.2H723c-1.6-17.3-7.6-30.1-15.6-39.1-8.4-8.9-21.9-13.7-38.6-13.7zm-248.5-10.1c8.7-6.3 12.9-16.7 12.9-31 .3-6.8-1.1-13.5-4.1-19.6-2.7-4.9-6.7-9-11.6-11.9a44.8 44.8 0 00-16.6-6c-6.4-1.2-12.9-1.8-19.3-1.7h-70.3v79.7h76.1c13.1.1 24.2-3.1 32.9-9.5zm11.8 72c-9.8-7.5-22.9-11.2-39.2-11.2h-81.8v94h80.2c7.5 0 14.4-.7 21.1-2.1s12.7-3.8 17.8-7.2c5.1-3.3 9.2-7.8 12.3-13.6 3-5.8 4.5-13.2 4.5-22.1 0-17.7-5-30.2-14.9-37.8z" } }] }, "name": "behance-square", "theme": "filled" };
  exports.default = BehanceSquareFilled;
  });

  var BehanceSquareFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(BehanceSquareFilled_1);

  var BehanceSquareFilled = function BehanceSquareFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BehanceSquareFilledSvg
    }));
  };
  var RefIcon$V = /*#__PURE__*/React.forwardRef(BehanceSquareFilled);
  {
    RefIcon$V.displayName = 'BehanceSquareFilled';
  }

  var BehanceSquareOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BehanceSquareOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM598.5 350.9h138.4v33.7H598.5v-33.7zM512 628.8a89.52 89.52 0 01-27 31c-11.8 8.2-24.9 14.2-38.8 17.7a167.4 167.4 0 01-44.6 5.7H236V342.1h161c16.3 0 31.1 1.5 44.6 4.3 13.4 2.8 24.8 7.6 34.4 14.1 9.5 6.5 17 15.2 22.3 26 5.2 10.7 7.9 24.1 7.9 40 0 17.2-3.9 31.4-11.7 42.9-7.9 11.5-19.3 20.8-34.8 28.1 21.1 6 36.6 16.7 46.8 31.7 10.4 15.2 15.5 33.4 15.5 54.8 0 17.4-3.3 32.3-10 44.8zM790.8 576H612.4c0 19.4 6.7 38 16.8 48 10.2 9.9 24.8 14.9 43.9 14.9 13.8 0 25.5-3.5 35.5-10.4 9.9-6.9 15.9-14.2 18.1-21.8h59.8c-9.6 29.7-24.2 50.9-44 63.7-19.6 12.8-43.6 19.2-71.5 19.2-19.5 0-37-3.2-52.7-9.3-15.1-5.9-28.7-14.9-39.9-26.5a121.2 121.2 0 01-25.1-41.2c-6.1-16.9-9.1-34.7-8.9-52.6 0-18.5 3.1-35.7 9.1-51.7 11.5-31.1 35.4-56 65.9-68.9 16.3-6.8 33.8-10.2 51.5-10 21 0 39.2 4 55 12.2a111.6 111.6 0 0138.6 32.8c10.1 13.7 17.2 29.3 21.7 46.9 4.3 17.3 5.8 35.5 4.6 54.7zm-122-95.6c-10.8 0-19.9 1.9-26.9 5.6-7 3.7-12.8 8.3-17.2 13.6a48.4 48.4 0 00-9.1 17.4c-1.6 5.3-2.7 10.7-3.1 16.2H723c-1.6-17.3-7.6-30.1-15.6-39.1-8.4-8.9-21.9-13.7-38.6-13.7zm-248.5-10.1c8.7-6.3 12.9-16.7 12.9-31 .3-6.8-1.1-13.5-4.1-19.6-2.7-4.9-6.7-9-11.6-11.9a44.8 44.8 0 00-16.6-6c-6.4-1.2-12.9-1.8-19.3-1.7h-70.3v79.7h76.1c13.1.1 24.2-3.1 32.9-9.5zm11.8 72c-9.8-7.5-22.9-11.2-39.2-11.2h-81.8v94h80.2c7.5 0 14.4-.7 21.1-2.1s12.7-3.8 17.8-7.2c5.1-3.3 9.2-7.8 12.3-13.6 3-5.8 4.5-13.2 4.5-22.1 0-17.7-5-30.2-14.9-37.8z" } }] }, "name": "behance-square", "theme": "outlined" };
  exports.default = BehanceSquareOutlined;
  });

  var BehanceSquareOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(BehanceSquareOutlined_1);

  var BehanceSquareOutlined = function BehanceSquareOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BehanceSquareOutlinedSvg
    }));
  };
  var RefIcon$W = /*#__PURE__*/React.forwardRef(BehanceSquareOutlined);
  {
    RefIcon$W.displayName = 'BehanceSquareOutlined';
  }

  var BellFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BellFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M816 768h-24V428c0-141.1-104.3-257.8-240-277.2V112c0-22.1-17.9-40-40-40s-40 17.9-40 40v38.8C336.3 170.2 232 286.9 232 428v340h-24c-17.7 0-32 14.3-32 32v32c0 4.4 3.6 8 8 8h216c0 61.8 50.2 112 112 112s112-50.2 112-112h216c4.4 0 8-3.6 8-8v-32c0-17.7-14.3-32-32-32zM512 888c-26.5 0-48-21.5-48-48h96c0 26.5-21.5 48-48 48z" } }] }, "name": "bell", "theme": "filled" };
  exports.default = BellFilled;
  });

  var BellFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(BellFilled_1);

  var BellFilled = function BellFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BellFilledSvg
    }));
  };
  var RefIcon$X = /*#__PURE__*/React.forwardRef(BellFilled);
  {
    RefIcon$X.displayName = 'BellFilled';
  }

  var BellOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BellOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M816 768h-24V428c0-141.1-104.3-257.7-240-277.1V112c0-22.1-17.9-40-40-40s-40 17.9-40 40v38.9c-135.7 19.4-240 136-240 277.1v340h-24c-17.7 0-32 14.3-32 32v32c0 4.4 3.6 8 8 8h216c0 61.8 50.2 112 112 112s112-50.2 112-112h216c4.4 0 8-3.6 8-8v-32c0-17.7-14.3-32-32-32zM512 888c-26.5 0-48-21.5-48-48h96c0 26.5-21.5 48-48 48zM304 768V428c0-55.6 21.6-107.8 60.9-147.1S456.4 220 512 220c55.6 0 107.8 21.6 147.1 60.9S720 372.4 720 428v340H304z" } }] }, "name": "bell", "theme": "outlined" };
  exports.default = BellOutlined;
  });

  var BellOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(BellOutlined_1);

  var BellOutlined = function BellOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BellOutlinedSvg
    }));
  };
  var RefIcon$Y = /*#__PURE__*/React.forwardRef(BellOutlined);
  {
    RefIcon$Y.displayName = 'BellOutlined';
  }

  var BellTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BellTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 220c-55.6 0-107.8 21.6-147.1 60.9S304 372.4 304 428v340h416V428c0-55.6-21.6-107.8-60.9-147.1S567.6 220 512 220zm280 208c0-141.1-104.3-257.8-240-277.2v.1c135.7 19.4 240 136 240 277.1zM472 150.9v-.1C336.3 170.2 232 286.9 232 428c0-141.1 104.3-257.7 240-277.1z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M816 768h-24V428c0-141.1-104.3-257.7-240-277.1V112c0-22.1-17.9-40-40-40s-40 17.9-40 40v38.9c-135.7 19.4-240 136-240 277.1v340h-24c-17.7 0-32 14.3-32 32v32c0 4.4 3.6 8 8 8h216c0 61.8 50.2 112 112 112s112-50.2 112-112h216c4.4 0 8-3.6 8-8v-32c0-17.7-14.3-32-32-32zM512 888c-26.5 0-48-21.5-48-48h96c0 26.5-21.5 48-48 48zm208-120H304V428c0-55.6 21.6-107.8 60.9-147.1S456.4 220 512 220c55.6 0 107.8 21.6 147.1 60.9S720 372.4 720 428v340z", "fill": primaryColor } }] }; }, "name": "bell", "theme": "twotone" };
  exports.default = BellTwoTone;
  });

  var BellTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(BellTwoTone_1);

  var BellTwoTone = function BellTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BellTwoToneSvg
    }));
  };
  var RefIcon$Z = /*#__PURE__*/React.forwardRef(BellTwoTone);
  {
    RefIcon$Z.displayName = 'BellTwoTone';
  }

  var BgColorsOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BgColorsOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M766.4 744.3c43.7 0 79.4-36.2 79.4-80.5 0-53.5-79.4-140.8-79.4-140.8S687 610.3 687 663.8c0 44.3 35.7 80.5 79.4 80.5zm-377.1-44.1c7.1 7.1 18.6 7.1 25.6 0l256.1-256c7.1-7.1 7.1-18.6 0-25.6l-256-256c-.6-.6-1.3-1.2-2-1.7l-78.2-78.2a9.11 9.11 0 00-12.8 0l-48 48a9.11 9.11 0 000 12.8l67.2 67.2-207.8 207.9c-7.1 7.1-7.1 18.6 0 25.6l255.9 256zm12.9-448.6l178.9 178.9H223.4l178.8-178.9zM904 816H120c-4.4 0-8 3.6-8 8v80c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-80c0-4.4-3.6-8-8-8z" } }] }, "name": "bg-colors", "theme": "outlined" };
  exports.default = BgColorsOutlined;
  });

  var BgColorsOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(BgColorsOutlined_1);

  var BgColorsOutlined = function BgColorsOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BgColorsOutlinedSvg
    }));
  };
  var RefIcon$_ = /*#__PURE__*/React.forwardRef(BgColorsOutlined);
  {
    RefIcon$_.displayName = 'BgColorsOutlined';
  }

  var BilibiliFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BilibiliFilled = { "icon": { "tag": "svg", "attrs": { "fill-rule": "evenodd", "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M310.13 596.45c-8-4.46-16.5-8.43-25-11.9a273.55 273.55 0 00-26.99-7.44c-2.5-.99-2.5 1-2.5 1.49 0 7.93.5 18.84 1.5 27.77 1 7.44 2 15.37 4 22.8 0 .5 0 1 .5 1.5 1 .99 2 1.48 3 .49 8-4.46 16-8.43 23-13.39 7.5-5.45 15.5-11.9 22-18.35 1.5-1.48 0-2.47.5-2.97m323.95-11.9a273.55 273.55 0 00-27-7.44c-2.5-.99-2.5 1-2.5 1.49 0 7.93.5 18.84 1.5 27.77 1 7.43 2 15.37 4 22.8 0 .5 0 1 .5 1.5 1 .99 2 1.48 3 .49 8-4.46 16-8.43 23-13.39 7.5-5.45 15.5-11.9 22-18.35 2-1.48.5-2.47.5-2.97-7.5-4.46-16.5-8.43-25-11.9" } }, { "tag": "path", "attrs": { "d": "M741.5 112H283c-94.5 0-171 76.5-171 171.5v458c.5 94 77 170.5 171 170.5h458c94.5 0 171-76.5 171-170.5v-458c.5-95-76-171.5-170.5-171.5m95 343.5H852v48h-15.5zM741 454l2 43-13.5 1.5-5-44.5zm-23.5 0l4 45.5L707 501l-6.5-47.5h17zM487 455.5h15v48h-15zm-96-1.5l2 43-13.5 1.5-5-44.5zm-23.5 0l4 45.5-14.5 2-6-47.5zM364 603c-20.5 65.5-148 59.5-159.5 57.5-9-161.5-23-196.5-34.5-275.5l54.5-22.5c1 71.5 9 185 9 185s108.5-15.5 132 47c.5 3 0 6-1.5 8.5m20.5 35.5l-23.5-124h35.5l13 123zm44.5-8l-27-235 33.5-1.5 21 236H429zm34-175h17.5v48H467zm41 190h-26.5l-9.5-126h36zm210-43C693.5 668 566 662 554.5 660c-9-161-23-196-34.5-275l54.5-22.5c1 71.5 9 185 9 185S692 532 715.5 594c.5 3 0 6-1.5 8.5m19.5 36l-23-124H746l13 123zm45.5-8l-27.5-235L785 394l21 236h-27zm33.5-175H830v48h-13zm41 190H827l-9.5-126h36z" } }] }, "name": "bilibili", "theme": "filled" };
  exports.default = BilibiliFilled;
  });

  var BilibiliFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(BilibiliFilled_1);

  var BilibiliFilled = function BilibiliFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BilibiliFilledSvg
    }));
  };
  var RefIcon$$ = /*#__PURE__*/React.forwardRef(BilibiliFilled);
  {
    RefIcon$$.displayName = 'BilibiliFilled';
  }

  var BilibiliOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BilibiliOutlined = { "icon": { "tag": "svg", "attrs": { "fill-rule": "evenodd", "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M235.52 616.57c16.73-.74 32.28-1.77 47.69-2.07 66.8-1.18 132.4 6.81 194.76 32 30.5 12.3 59.98 26.52 86.5 46.51 21.76 16.45 26.5 36.9 16.58 67.11-6.22 18.67-18.66 32.74-34.36 45.04-37.03 28.88-75.83 54.96-120.41 69.62A595.87 595.87 0 01330 898.04c-42.8 6.67-86.2 9.63-129.45 13.63-8.88.89-17.92-.3-26.8-.3-4.6 0-5.78-2.37-5.93-6.37-1.18-19.7-2.07-39.55-3.85-59.25a2609.47 2609.47 0 00-7.7-76.3c-4-35.4-8.44-70.66-12.89-105.92-4.59-37.18-9.33-74.21-13.77-111.4-4.44-36.3-8.44-72.73-13.18-109.03-5.34-41.48-11.26-82.96-16.89-124.44-6.66-49.03-15.85-97.62-28.43-145.47-.6-2.07 1.18-6.67 2.96-7.26 41.91-16.89 83.98-33.33 125.89-50.07 13.92-5.63 15.1-7.26 15.25 10.37.15 75.1.45 150.21 1.63 225.32.6 39.11 2.08 78.22 4.74 117.18 3.26 47.55 8.3 95.1 12.6 142.66 0 2.07.88 4 1.33 5.19m83.68 218.06a74372.3 74372.3 0 00114.78-86.96c-4.74-6.82-109.3-47.85-133.89-53.33 6.22 46.37 12.59 92.59 19.1 140.29m434.13-14.39c-19.94-202.14-36.78-406.5-75.32-609.67 12.55-1.48 25.1-3.25 37.8-4.3 14.63-1.32 29.4-1.92 44.01-3.1 12.26-1.04 16.84 2.22 17.58 14.22 2.21 32.13 4.13 64.26 6.35 96.4 2.95 43.39 6.05 86.92 9.15 130.31 2.22 31.25 4.14 62.64 6.65 93.89 2.8 34.2 5.9 68.27 9 102.47 2.22 25.18 4.3 50.5 6.8 75.68 2.66 27.24 5.61 54.49 8.42 81.74.74 7.85 1.62 15.7 2.21 23.54.3 4.3-2.06 4.89-6.05 4.45-21.7-2.23-43.42-3.85-66.6-5.63M572 527.15c17.62-2.51 34.64-5.32 51.66-7.25 12.29-1.48 24.72-1.63 37.01-2.81 6.66-.6 10.95 1.77 11.99 8.29 2.81 17.32 5.77 34.79 7.85 52.26 3.4 29.02 6.07 58.18 9.17 87.2 2.67 25.46 5.33 50.78 8.3 76.24 3.25 27.24 6.8 54.33 10.2 81.42 1.04 8 1.78 16.14 2.82 24.88a9507.1 9507.1 0 00-74.76 9.62C614.93 747.15 593.61 638.19 572 527.15m382 338.83c-24.08 0-47.28.14-70.47-.3-1.93 0-5.35-3.4-5.5-5.48-3.57-37.05-6.69-73.96-9.96-111l-9.37-103.16c-3.27-35.42-6.39-70.84-9.66-106.26-.15-2.07-.6-4-1.04-7.11 8.62-1.04 16.8-2.67 25.12-2.67 22.45 0 44.9.6 67.5 1.19 5.8.14 8.32 4 8.62 9.33.75 11.12 1.79 22.08 1.79 33.2.14 52.17-.15 104.48.3 156.65.44 41.65 1.78 83.44 2.67 125.08zM622.07 480c-5.3-42.57-10.62-84.1-16.07-127.4 13.86-.16 27.71-.6 41.42-.6 4.57 0 6.64 2.51 7.08 7.54 3.69 38.72 7.52 77.45 11.5 117.65-14.3.74-29.04 1.78-43.93 2.81M901 364.07c11.94 0 24.62-.15 37.45 0 6.42.14 9.55 2.67 9.55 10.24-.45 36.22-.15 72.45-.15 108.53V491c-15.37-.74-30.14-1.49-46.7-2.23-.15-41.12-.15-82.4-.15-124.7M568.57 489c-7.43-41.2-15-82.1-22.57-124.02 13.51-2.07 27.02-4.29 40.39-5.9 5.94-.75 4.9 4.42 5.2 7.67 1.63 13.88 2.81 27.6 4.3 41.49 2.37 21.7 4.75 43.4 6.98 64.96.3 2.8 0 5.76 0 8.86-11.29 2.36-22.57 4.58-34.3 6.94M839 365.16c12.72 0 25.43.15 38-.15 5.69-.15 7.78 1.04 7.63 7.56-.44 17.36.15 34.7.3 52.2.15 21.51 0 43.17 0 64.52-12.86 1.34-24.09 2.37-36.2 3.71-3.15-41.97-6.44-83.8-9.73-127.84" } }] }, "name": "bilibili", "theme": "outlined" };
  exports.default = BilibiliOutlined;
  });

  var BilibiliOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(BilibiliOutlined_1);

  var BilibiliOutlined = function BilibiliOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BilibiliOutlinedSvg
    }));
  };
  var RefIcon$10 = /*#__PURE__*/React.forwardRef(BilibiliOutlined);
  {
    RefIcon$10.displayName = 'BilibiliOutlined';
  }

  var BlockOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BlockOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M856 376H648V168c0-8.8-7.2-16-16-16H168c-8.8 0-16 7.2-16 16v464c0 8.8 7.2 16 16 16h208v208c0 8.8 7.2 16 16 16h464c8.8 0 16-7.2 16-16V392c0-8.8-7.2-16-16-16zm-480 16v188H220V220h360v156H392c-8.8 0-16 7.2-16 16zm204 52v136H444V444h136zm224 360H444V648h188c8.8 0 16-7.2 16-16V444h156v360z" } }] }, "name": "block", "theme": "outlined" };
  exports.default = BlockOutlined;
  });

  var BlockOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(BlockOutlined_1);

  var BlockOutlined = function BlockOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BlockOutlinedSvg
    }));
  };
  var RefIcon$11 = /*#__PURE__*/React.forwardRef(BlockOutlined);
  {
    RefIcon$11.displayName = 'BlockOutlined';
  }

  var BoldOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BoldOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M697.8 481.4c33.6-35 54.2-82.3 54.2-134.3v-10.2C752 229.3 663.9 142 555.3 142H259.4c-15.1 0-27.4 12.3-27.4 27.4v679.1c0 16.3 13.2 29.5 29.5 29.5h318.7c117 0 211.8-94.2 211.8-210.5v-11c0-73-37.4-137.3-94.2-175.1zM328 238h224.7c57.1 0 103.3 44.4 103.3 99.3v9.5c0 54.8-46.3 99.3-103.3 99.3H328V238zm366.6 429.4c0 62.9-51.7 113.9-115.5 113.9H328V542.7h251.1c63.8 0 115.5 51 115.5 113.9v10.8z" } }] }, "name": "bold", "theme": "outlined" };
  exports.default = BoldOutlined;
  });

  var BoldOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(BoldOutlined_1);

  var BoldOutlined = function BoldOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BoldOutlinedSvg
    }));
  };
  var RefIcon$12 = /*#__PURE__*/React.forwardRef(BoldOutlined);
  {
    RefIcon$12.displayName = 'BoldOutlined';
  }

  var BookFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BookFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M832 64H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V96c0-17.7-14.3-32-32-32zM668 345.9L621.5 312 572 347.4V124h96v221.9z" } }] }, "name": "book", "theme": "filled" };
  exports.default = BookFilled;
  });

  var BookFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(BookFilled_1);

  var BookFilled = function BookFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BookFilledSvg
    }));
  };
  var RefIcon$13 = /*#__PURE__*/React.forwardRef(BookFilled);
  {
    RefIcon$13.displayName = 'BookFilled';
  }

  var BookOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BookOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M832 64H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V96c0-17.7-14.3-32-32-32zm-260 72h96v209.9L621.5 312 572 347.4V136zm220 752H232V136h280v296.9c0 3.3 1 6.6 3 9.3a15.9 15.9 0 0022.3 3.7l83.8-59.9 81.4 59.4c2.7 2 6 3.1 9.4 3.1 8.8 0 16-7.2 16-16V136h64v752z" } }] }, "name": "book", "theme": "outlined" };
  exports.default = BookOutlined;
  });

  var BookOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(BookOutlined_1);

  var BookOutlined = function BookOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BookOutlinedSvg
    }));
  };
  var RefIcon$14 = /*#__PURE__*/React.forwardRef(BookOutlined);
  {
    RefIcon$14.displayName = 'BookOutlined';
  }

  var BookTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BookTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M832 64H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V96c0-17.7-14.3-32-32-32zm-260 72h96v209.9L621.5 312 572 347.4V136zM232 888V136h280v296.9c0 3.3 1 6.6 3 9.3a15.9 15.9 0 0022.3 3.7l83.8-59.9 81.4 59.4c2.7 2 6 3.1 9.4 3.1 8.8 0 16-7.2 16-16V136h64v752H232z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M668 345.9V136h-96v211.4l49.5-35.4z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M727.9 136v296.5c0 8.8-7.2 16-16 16-3.4 0-6.7-1.1-9.4-3.1L621.1 386l-83.8 59.9a15.9 15.9 0 01-22.3-3.7c-2-2.7-3-6-3-9.3V136H232v752h559.9V136h-64z", "fill": secondaryColor } }] }; }, "name": "book", "theme": "twotone" };
  exports.default = BookTwoTone;
  });

  var BookTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(BookTwoTone_1);

  var BookTwoTone = function BookTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BookTwoToneSvg
    }));
  };
  var RefIcon$15 = /*#__PURE__*/React.forwardRef(BookTwoTone);
  {
    RefIcon$15.displayName = 'BookTwoTone';
  }

  var BorderBottomOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BorderBottomOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M872 808H152c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h720c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-720-94h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm0-498h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm0 332h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm0-166h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm166 166h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm0-332h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm332 0h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm0 332h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm222-72h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-388 72h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm388-404h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-388 72h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm388 426h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-388 72h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm388-404h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-388 72h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8z" } }] }, "name": "border-bottom", "theme": "outlined" };
  exports.default = BorderBottomOutlined;
  });

  var BorderBottomOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(BorderBottomOutlined_1);

  var BorderBottomOutlined = function BorderBottomOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BorderBottomOutlinedSvg
    }));
  };
  var RefIcon$16 = /*#__PURE__*/React.forwardRef(BorderBottomOutlined);
  {
    RefIcon$16.displayName = 'BorderBottomOutlined';
  }

  var BorderHorizontalOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BorderHorizontalOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M540 144h-56c-4.4 0-8 3.6-8 8v720c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V152c0-4.4-3.6-8-8-8zm-166 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm498 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-664 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm498 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM208 310h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm664 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-664 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 166h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm664 332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM374 808h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm332 332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8z" } }] }, "name": "border-horizontal", "theme": "outlined" };
  exports.default = BorderHorizontalOutlined;
  });

  var BorderHorizontalOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(BorderHorizontalOutlined_1);

  var BorderHorizontalOutlined = function BorderHorizontalOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BorderHorizontalOutlinedSvg
    }));
  };
  var RefIcon$17 = /*#__PURE__*/React.forwardRef(BorderHorizontalOutlined);
  {
    RefIcon$17.displayName = 'BorderHorizontalOutlined';
  }

  var BorderInnerOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BorderInnerOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M872 476H548V144h-72v332H152c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h324v332h72V548h324c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-166h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 498h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-664h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 498h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM650 216h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm56 592h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-332 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-56-592h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm-166 0h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm56 592h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-56-426h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm56 260h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8z" } }] }, "name": "border-inner", "theme": "outlined" };
  exports.default = BorderInnerOutlined;
  });

  var BorderInnerOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(BorderInnerOutlined_1);

  var BorderInnerOutlined = function BorderInnerOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BorderInnerOutlinedSvg
    }));
  };
  var RefIcon$18 = /*#__PURE__*/React.forwardRef(BorderInnerOutlined);
  {
    RefIcon$18.displayName = 'BorderInnerOutlined';
  }

  var BorderLeftOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BorderLeftOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M208 144h-56c-4.4 0-8 3.6-8 8v720c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V152c0-4.4-3.6-8-8-8zm166 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm498 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-332 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm166 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM540 310h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm332 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-332 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 166h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm332 332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM374 808h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm332 332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8z" } }] }, "name": "border-left", "theme": "outlined" };
  exports.default = BorderLeftOutlined;
  });

  var BorderLeftOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(BorderLeftOutlined_1);

  var BorderLeftOutlined = function BorderLeftOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BorderLeftOutlinedSvg
    }));
  };
  var RefIcon$19 = /*#__PURE__*/React.forwardRef(BorderLeftOutlined);
  {
    RefIcon$19.displayName = 'BorderLeftOutlined';
  }

  var BorderOuterOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BorderOuterOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656zM484 366h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zM302 548h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm364 0h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm-182 0h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm0 182h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8z" } }] }, "name": "border-outer", "theme": "outlined" };
  exports.default = BorderOuterOutlined;
  });

  var BorderOuterOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(BorderOuterOutlined_1);

  var BorderOuterOutlined = function BorderOuterOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BorderOuterOutlinedSvg
    }));
  };
  var RefIcon$1a = /*#__PURE__*/React.forwardRef(BorderOuterOutlined);
  {
    RefIcon$1a.displayName = 'BorderOuterOutlined';
  }

  var BorderOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BorderOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z" } }] }, "name": "border", "theme": "outlined" };
  exports.default = BorderOutlined;
  });

  var BorderOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(BorderOutlined_1);

  var BorderOutlined = function BorderOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BorderOutlinedSvg
    }));
  };
  var RefIcon$1b = /*#__PURE__*/React.forwardRef(BorderOutlined);
  {
    RefIcon$1b.displayName = 'BorderOutlined';
  }

  var BorderRightOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BorderRightOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M872 144h-56c-4.4 0-8 3.6-8 8v720c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V152c0-4.4-3.6-8-8-8zm-166 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-498 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm332 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-166 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm166 166h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-332 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm332 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 166h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM208 808h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm498 332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM374 808h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8z" } }] }, "name": "border-right", "theme": "outlined" };
  exports.default = BorderRightOutlined;
  });

  var BorderRightOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(BorderRightOutlined_1);

  var BorderRightOutlined = function BorderRightOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BorderRightOutlinedSvg
    }));
  };
  var RefIcon$1c = /*#__PURE__*/React.forwardRef(BorderRightOutlined);
  {
    RefIcon$1c.displayName = 'BorderRightOutlined';
  }

  var BorderTopOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BorderTopOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M872 144H152c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h720c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM208 310h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 498h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 166h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm166-166h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm332 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm166 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-332 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm332 332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-332 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm332-498h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-332 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm332 332h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-332 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8z" } }] }, "name": "border-top", "theme": "outlined" };
  exports.default = BorderTopOutlined;
  });

  var BorderTopOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(BorderTopOutlined_1);

  var BorderTopOutlined = function BorderTopOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BorderTopOutlinedSvg
    }));
  };
  var RefIcon$1d = /*#__PURE__*/React.forwardRef(BorderTopOutlined);
  {
    RefIcon$1d.displayName = 'BorderTopOutlined';
  }

  var BorderVerticleOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BorderVerticleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M872 476H152c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h720c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-166h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 498h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-664h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 498h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM650 216h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm56 592h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-332 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-56-592h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm-166 0h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm332 0h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zM208 808h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm332 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM152 382h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm332 0h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zM208 642h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm332 0h-56c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8z" } }] }, "name": "border-verticle", "theme": "outlined" };
  exports.default = BorderVerticleOutlined;
  });

  var BorderVerticleOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(BorderVerticleOutlined_1);

  var BorderVerticleOutlined = function BorderVerticleOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BorderVerticleOutlinedSvg
    }));
  };
  var RefIcon$1e = /*#__PURE__*/React.forwardRef(BorderVerticleOutlined);
  {
    RefIcon$1e.displayName = 'BorderVerticleOutlined';
  }

  var BorderlessTableOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BorderlessTableOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M117 368h231v64H117zm559 0h241v64H676zm-264 0h200v64H412zm0 224h200v64H412zm264 0h241v64H676zm-559 0h231v64H117zm295-160V179h-64v666h64V592zm264-64V179h-64v666h64V432z" } }] }, "name": "borderless-table", "theme": "outlined" };
  exports.default = BorderlessTableOutlined;
  });

  var BorderlessTableOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(BorderlessTableOutlined_1);

  var BorderlessTableOutlined = function BorderlessTableOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BorderlessTableOutlinedSvg
    }));
  };
  var RefIcon$1f = /*#__PURE__*/React.forwardRef(BorderlessTableOutlined);
  {
    RefIcon$1f.displayName = 'BorderlessTableOutlined';
  }

  var BoxPlotFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BoxPlotFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M952 224h-52c-4.4 0-8 3.6-8 8v248h-92V304c0-4.4-3.6-8-8-8H448v432h344c4.4 0 8-3.6 8-8V548h92v244c0 4.4 3.6 8 8 8h52c4.4 0 8-3.6 8-8V232c0-4.4-3.6-8-8-8zm-728 80v176h-92V232c0-4.4-3.6-8-8-8H72c-4.4 0-8 3.6-8 8v560c0 4.4 3.6 8 8 8h52c4.4 0 8-3.6 8-8V548h92v172c0 4.4 3.6 8 8 8h152V296H232c-4.4 0-8 3.6-8 8z" } }] }, "name": "box-plot", "theme": "filled" };
  exports.default = BoxPlotFilled;
  });

  var BoxPlotFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(BoxPlotFilled_1);

  var BoxPlotFilled = function BoxPlotFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BoxPlotFilledSvg
    }));
  };
  var RefIcon$1g = /*#__PURE__*/React.forwardRef(BoxPlotFilled);
  {
    RefIcon$1g.displayName = 'BoxPlotFilled';
  }

  var BoxPlotOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BoxPlotOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M952 224h-52c-4.4 0-8 3.6-8 8v248h-92V304c0-4.4-3.6-8-8-8H232c-4.4 0-8 3.6-8 8v176h-92V232c0-4.4-3.6-8-8-8H72c-4.4 0-8 3.6-8 8v560c0 4.4 3.6 8 8 8h52c4.4 0 8-3.6 8-8V548h92v172c0 4.4 3.6 8 8 8h560c4.4 0 8-3.6 8-8V548h92v244c0 4.4 3.6 8 8 8h52c4.4 0 8-3.6 8-8V232c0-4.4-3.6-8-8-8zM296 368h88v288h-88V368zm432 288H448V368h280v288z" } }] }, "name": "box-plot", "theme": "outlined" };
  exports.default = BoxPlotOutlined;
  });

  var BoxPlotOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(BoxPlotOutlined_1);

  var BoxPlotOutlined = function BoxPlotOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BoxPlotOutlinedSvg
    }));
  };
  var RefIcon$1h = /*#__PURE__*/React.forwardRef(BoxPlotOutlined);
  {
    RefIcon$1h.displayName = 'BoxPlotOutlined';
  }

  var BoxPlotTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BoxPlotTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M296 368h88v288h-88zm152 0h280v288H448z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M952 224h-52c-4.4 0-8 3.6-8 8v248h-92V304c0-4.4-3.6-8-8-8H232c-4.4 0-8 3.6-8 8v176h-92V232c0-4.4-3.6-8-8-8H72c-4.4 0-8 3.6-8 8v560c0 4.4 3.6 8 8 8h52c4.4 0 8-3.6 8-8V548h92v172c0 4.4 3.6 8 8 8h560c4.4 0 8-3.6 8-8V548h92v244c0 4.4 3.6 8 8 8h52c4.4 0 8-3.6 8-8V232c0-4.4-3.6-8-8-8zM384 656h-88V368h88v288zm344 0H448V368h280v288z", "fill": primaryColor } }] }; }, "name": "box-plot", "theme": "twotone" };
  exports.default = BoxPlotTwoTone;
  });

  var BoxPlotTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(BoxPlotTwoTone_1);

  var BoxPlotTwoTone = function BoxPlotTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BoxPlotTwoToneSvg
    }));
  };
  var RefIcon$1i = /*#__PURE__*/React.forwardRef(BoxPlotTwoTone);
  {
    RefIcon$1i.displayName = 'BoxPlotTwoTone';
  }

  var BranchesOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BranchesOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M740 161c-61.8 0-112 50.2-112 112 0 50.1 33.1 92.6 78.5 106.9v95.9L320 602.4V318.1c44.2-15 76-56.9 76-106.1 0-61.8-50.2-112-112-112s-112 50.2-112 112c0 49.2 31.8 91 76 106.1V706c-44.2 15-76 56.9-76 106.1 0 61.8 50.2 112 112 112s112-50.2 112-112c0-49.2-31.8-91-76-106.1v-27.8l423.5-138.7a50.52 50.52 0 0034.9-48.2V378.2c42.9-15.8 73.6-57 73.6-105.2 0-61.8-50.2-112-112-112zm-504 51a48.01 48.01 0 0196 0 48.01 48.01 0 01-96 0zm96 600a48.01 48.01 0 01-96 0 48.01 48.01 0 0196 0zm408-491a48.01 48.01 0 010-96 48.01 48.01 0 010 96z" } }] }, "name": "branches", "theme": "outlined" };
  exports.default = BranchesOutlined;
  });

  var BranchesOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(BranchesOutlined_1);

  var BranchesOutlined = function BranchesOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BranchesOutlinedSvg
    }));
  };
  var RefIcon$1j = /*#__PURE__*/React.forwardRef(BranchesOutlined);
  {
    RefIcon$1j.displayName = 'BranchesOutlined';
  }

  var BugFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BugFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M304 280h416c4.4 0 8-3.6 8-8 0-40-8.8-76.7-25.9-108.1a184.31 184.31 0 00-74-74C596.7 72.8 560 64 520 64h-16c-40 0-76.7 8.8-108.1 25.9a184.31 184.31 0 00-74 74C304.8 195.3 296 232 296 272c0 4.4 3.6 8 8 8z" } }, { "tag": "path", "attrs": { "d": "M940 512H792V412c76.8 0 139-62.2 139-139 0-4.4-3.6-8-8-8h-60c-4.4 0-8 3.6-8 8a63 63 0 01-63 63H232a63 63 0 01-63-63c0-4.4-3.6-8-8-8h-60c-4.4 0-8 3.6-8 8 0 76.8 62.2 139 139 139v100H84c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h148v96c0 6.5.2 13 .7 19.3C164.1 728.6 116 796.7 116 876c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8 0-44.2 23.9-82.9 59.6-103.7a273 273 0 0022.7 49c24.3 41.5 59 76.2 100.5 100.5 28.9 16.9 61 28.8 95.3 34.5 4.4 0 8-3.6 8-8V484c0-4.4 3.6-8 8-8h60c4.4 0 8 3.6 8 8v464.2c0 4.4 3.6 8 8 8 34.3-5.7 66.4-17.6 95.3-34.5a281.38 281.38 0 00123.2-149.5A120.4 120.4 0 01836 876c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8 0-79.3-48.1-147.4-116.7-176.7.4-6.4.7-12.8.7-19.3v-96h148c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8z" } }] }, "name": "bug", "theme": "filled" };
  exports.default = BugFilled;
  });

  var BugFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(BugFilled_1);

  var BugFilled = function BugFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BugFilledSvg
    }));
  };
  var RefIcon$1k = /*#__PURE__*/React.forwardRef(BugFilled);
  {
    RefIcon$1k.displayName = 'BugFilled';
  }

  var BugOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BugOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M304 280h56c4.4 0 8-3.6 8-8 0-28.3 5.9-53.2 17.1-73.5 10.6-19.4 26-34.8 45.4-45.4C450.9 142 475.7 136 504 136h16c28.3 0 53.2 5.9 73.5 17.1 19.4 10.6 34.8 26 45.4 45.4C650 218.9 656 243.7 656 272c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8 0-40-8.8-76.7-25.9-108.1a184.31 184.31 0 00-74-74C596.7 72.8 560 64 520 64h-16c-40 0-76.7 8.8-108.1 25.9a184.31 184.31 0 00-74 74C304.8 195.3 296 232 296 272c0 4.4 3.6 8 8 8z" } }, { "tag": "path", "attrs": { "d": "M940 512H792V412c76.8 0 139-62.2 139-139 0-4.4-3.6-8-8-8h-60c-4.4 0-8 3.6-8 8a63 63 0 01-63 63H232a63 63 0 01-63-63c0-4.4-3.6-8-8-8h-60c-4.4 0-8 3.6-8 8 0 76.8 62.2 139 139 139v100H84c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h148v96c0 6.5.2 13 .7 19.3C164.1 728.6 116 796.7 116 876c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8 0-44.2 23.9-82.9 59.6-103.7a273 273 0 0022.7 49c24.3 41.5 59 76.2 100.5 100.5S460.5 960 512 960s99.8-13.9 141.3-38.2a281.38 281.38 0 00123.2-149.5A120 120 0 01836 876c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8 0-79.3-48.1-147.4-116.7-176.7.4-6.4.7-12.8.7-19.3v-96h148c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM716 680c0 36.8-9.7 72-27.8 102.9-17.7 30.3-43 55.6-73.3 73.3C584 874.3 548.8 884 512 884s-72-9.7-102.9-27.8c-30.3-17.7-55.6-43-73.3-73.3A202.75 202.75 0 01308 680V412h408v268z" } }] }, "name": "bug", "theme": "outlined" };
  exports.default = BugOutlined;
  });

  var BugOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(BugOutlined_1);

  var BugOutlined = function BugOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BugOutlinedSvg
    }));
  };
  var RefIcon$1l = /*#__PURE__*/React.forwardRef(BugOutlined);
  {
    RefIcon$1l.displayName = 'BugOutlined';
  }

  var BugTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BugTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M308 412v268c0 36.78 9.68 71.96 27.8 102.9a205.39 205.39 0 0073.3 73.3A202.68 202.68 0 00512 884c36.78 0 71.96-9.68 102.9-27.8a205.39 205.39 0 0073.3-73.3A202.68 202.68 0 00716 680V412H308zm484 172v96c0 6.5-.22 12.95-.66 19.35C859.94 728.64 908 796.7 908 876a8 8 0 01-8 8h-56a8 8 0 01-8-8c0-44.24-23.94-82.89-59.57-103.7a278.63 278.63 0 01-22.66 49.02 281.39 281.39 0 01-100.45 100.45C611.84 946.07 563.55 960 512 960s-99.84-13.93-141.32-38.23a281.39 281.39 0 01-100.45-100.45 278.63 278.63 0 01-22.66-49.02A119.95 119.95 0 00188 876a8 8 0 01-8 8h-56a8 8 0 01-8-8c0-79.3 48.07-147.36 116.66-176.65A284.12 284.12 0 01232 680v-96H84a8 8 0 01-8-8v-56a8 8 0 018-8h148V412c-76.77 0-139-62.23-139-139a8 8 0 018-8h60a8 8 0 018 8 63 63 0 0063 63h560a63 63 0 0063-63 8 8 0 018-8h60a8 8 0 018 8c0 76.77-62.23 139-139 139v100h148a8 8 0 018 8v56a8 8 0 01-8 8H792zM368 272a8 8 0 01-8 8h-56a8 8 0 01-8-8c0-40.04 8.78-76.75 25.9-108.07a184.57 184.57 0 0174.03-74.03C427.25 72.78 463.96 64 504 64h16c40.04 0 76.75 8.78 108.07 25.9a184.57 184.57 0 0174.03 74.03C719.22 195.25 728 231.96 728 272a8 8 0 01-8 8h-56a8 8 0 01-8-8c0-28.33-5.94-53.15-17.08-73.53a112.56 112.56 0 00-45.39-45.4C573.15 141.95 548.33 136 520 136h-16c-28.33 0-53.15 5.94-73.53 17.08a112.56 112.56 0 00-45.4 45.39C373.95 218.85 368 243.67 368 272z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M308 412v268c0 36.78 9.68 71.96 27.8 102.9a205.39 205.39 0 0073.3 73.3A202.68 202.68 0 00512 884c36.78 0 71.96-9.68 102.9-27.8a205.39 205.39 0 0073.3-73.3A202.68 202.68 0 00716 680V412H308z", "fill": secondaryColor } }] }; }, "name": "bug", "theme": "twotone" };
  exports.default = BugTwoTone;
  });

  var BugTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(BugTwoTone_1);

  var BugTwoTone = function BugTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BugTwoToneSvg
    }));
  };
  var RefIcon$1m = /*#__PURE__*/React.forwardRef(BugTwoTone);
  {
    RefIcon$1m.displayName = 'BugTwoTone';
  }

  var BuildFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BuildFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M916 210H376c-17.7 0-32 14.3-32 32v236H108c-17.7 0-32 14.3-32 32v272c0 17.7 14.3 32 32 32h540c17.7 0 32-14.3 32-32V546h236c17.7 0 32-14.3 32-32V242c0-17.7-14.3-32-32-32zM612 746H412V546h200v200zm268-268H680V278h200v200z" } }] }, "name": "build", "theme": "filled" };
  exports.default = BuildFilled;
  });

  var BuildFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(BuildFilled_1);

  var BuildFilled = function BuildFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BuildFilledSvg
    }));
  };
  var RefIcon$1n = /*#__PURE__*/React.forwardRef(BuildFilled);
  {
    RefIcon$1n.displayName = 'BuildFilled';
  }

  var BuildOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BuildOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M916 210H376c-17.7 0-32 14.3-32 32v236H108c-17.7 0-32 14.3-32 32v272c0 17.7 14.3 32 32 32h540c17.7 0 32-14.3 32-32V546h236c17.7 0 32-14.3 32-32V242c0-17.7-14.3-32-32-32zm-504 68h200v200H412V278zm-68 468H144V546h200v200zm268 0H412V546h200v200zm268-268H680V278h200v200z" } }] }, "name": "build", "theme": "outlined" };
  exports.default = BuildOutlined;
  });

  var BuildOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(BuildOutlined_1);

  var BuildOutlined = function BuildOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BuildOutlinedSvg
    }));
  };
  var RefIcon$1o = /*#__PURE__*/React.forwardRef(BuildOutlined);
  {
    RefIcon$1o.displayName = 'BuildOutlined';
  }

  var BuildTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BuildTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M144 546h200v200H144zm268-268h200v200H412z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M916 210H376c-17.7 0-32 14.3-32 32v236H108c-17.7 0-32 14.3-32 32v272c0 17.7 14.3 32 32 32h540c17.7 0 32-14.3 32-32V546h236c17.7 0 32-14.3 32-32V242c0-17.7-14.3-32-32-32zM344 746H144V546h200v200zm268 0H412V546h200v200zm0-268H412V278h200v200zm268 0H680V278h200v200z", "fill": primaryColor } }] }; }, "name": "build", "theme": "twotone" };
  exports.default = BuildTwoTone;
  });

  var BuildTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(BuildTwoTone_1);

  var BuildTwoTone = function BuildTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BuildTwoToneSvg
    }));
  };
  var RefIcon$1p = /*#__PURE__*/React.forwardRef(BuildTwoTone);
  {
    RefIcon$1p.displayName = 'BuildTwoTone';
  }

  var BulbFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BulbFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M348 676.1C250 619.4 184 513.4 184 392c0-181.1 146.9-328 328-328s328 146.9 328 328c0 121.4-66 227.4-164 284.1V792c0 17.7-14.3 32-32 32H380c-17.7 0-32-14.3-32-32V676.1zM392 888h240c4.4 0 8 3.6 8 8v32c0 17.7-14.3 32-32 32H416c-17.7 0-32-14.3-32-32v-32c0-4.4 3.6-8 8-8z" } }] }, "name": "bulb", "theme": "filled" };
  exports.default = BulbFilled;
  });

  var BulbFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(BulbFilled_1);

  var BulbFilled = function BulbFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BulbFilledSvg
    }));
  };
  var RefIcon$1q = /*#__PURE__*/React.forwardRef(BulbFilled);
  {
    RefIcon$1q.displayName = 'BulbFilled';
  }

  var BulbOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BulbOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M632 888H392c-4.4 0-8 3.6-8 8v32c0 17.7 14.3 32 32 32h192c17.7 0 32-14.3 32-32v-32c0-4.4-3.6-8-8-8zM512 64c-181.1 0-328 146.9-328 328 0 121.4 66 227.4 164 284.1V792c0 17.7 14.3 32 32 32h264c17.7 0 32-14.3 32-32V676.1c98-56.7 164-162.7 164-284.1 0-181.1-146.9-328-328-328zm127.9 549.8L604 634.6V752H420V634.6l-35.9-20.8C305.4 568.3 256 484.5 256 392c0-141.4 114.6-256 256-256s256 114.6 256 256c0 92.5-49.4 176.3-128.1 221.8z" } }] }, "name": "bulb", "theme": "outlined" };
  exports.default = BulbOutlined;
  });

  var BulbOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(BulbOutlined_1);

  var BulbOutlined = function BulbOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BulbOutlinedSvg
    }));
  };
  var RefIcon$1r = /*#__PURE__*/React.forwardRef(BulbOutlined);
  {
    RefIcon$1r.displayName = 'BulbOutlined';
  }

  var BulbTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var BulbTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 136c-141.4 0-256 114.6-256 256 0 92.5 49.4 176.3 128.1 221.8l35.9 20.8V752h184V634.6l35.9-20.8C718.6 568.3 768 484.5 768 392c0-141.4-114.6-256-256-256z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M632 888H392c-4.4 0-8 3.6-8 8v32c0 17.7 14.3 32 32 32h192c17.7 0 32-14.3 32-32v-32c0-4.4-3.6-8-8-8zM512 64c-181.1 0-328 146.9-328 328 0 121.4 66 227.4 164 284.1V792c0 17.7 14.3 32 32 32h264c17.7 0 32-14.3 32-32V676.1c98-56.7 164-162.7 164-284.1 0-181.1-146.9-328-328-328zm127.9 549.8L604 634.6V752H420V634.6l-35.9-20.8C305.4 568.3 256 484.5 256 392c0-141.4 114.6-256 256-256s256 114.6 256 256c0 92.5-49.4 176.3-128.1 221.8z", "fill": primaryColor } }] }; }, "name": "bulb", "theme": "twotone" };
  exports.default = BulbTwoTone;
  });

  var BulbTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(BulbTwoTone_1);

  var BulbTwoTone = function BulbTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: BulbTwoToneSvg
    }));
  };
  var RefIcon$1s = /*#__PURE__*/React.forwardRef(BulbTwoTone);
  {
    RefIcon$1s.displayName = 'BulbTwoTone';
  }

  var CalculatorFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CalculatorFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM440.2 765h-50.8c-2.2 0-4.5-1.1-5.9-2.9L348 718.6l-35.5 43.5a7.38 7.38 0 01-5.9 2.9h-50.8c-6.6 0-10.2-7.9-5.8-13.1l62.7-76.8-61.2-74.9c-4.3-5.2-.7-13.1 5.9-13.1h50.9c2.2 0 4.5 1.1 5.9 2.9l34 41.6 34-41.6c1.5-1.9 3.6-2.9 5.9-2.9h50.8c6.6 0 10.2 7.9 5.9 13.1L383.5 675l62.7 76.8c4.2 5.3.6 13.2-6 13.2zm7.8-382c0 2.2-1.4 4-3.2 4H376v68.7c0 1.9-1.8 3.3-4 3.3h-48c-2.2 0-4-1.4-4-3.2V387h-68.8c-1.8 0-3.2-1.8-3.2-4v-48c0-2.2 1.4-4 3.2-4H320v-68.8c0-1.8 1.8-3.2 4-3.2h48c2.2 0 4 1.4 4 3.2V331h68.7c1.9 0 3.3 1.8 3.3 4v48zm328 369c0 2.2-1.4 4-3.2 4H579.2c-1.8 0-3.2-1.8-3.2-4v-48c0-2.2 1.4-4 3.2-4h193.5c1.9 0 3.3 1.8 3.3 4v48zm0-104c0 2.2-1.4 4-3.2 4H579.2c-1.8 0-3.2-1.8-3.2-4v-48c0-2.2 1.4-4 3.2-4h193.5c1.9 0 3.3 1.8 3.3 4v48zm0-265c0 2.2-1.4 4-3.2 4H579.2c-1.8 0-3.2-1.8-3.2-4v-48c0-2.2 1.4-4 3.2-4h193.5c1.9 0 3.3 1.8 3.3 4v48z" } }] }, "name": "calculator", "theme": "filled" };
  exports.default = CalculatorFilled;
  });

  var CalculatorFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(CalculatorFilled_1);

  var CalculatorFilled = function CalculatorFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CalculatorFilledSvg
    }));
  };
  var RefIcon$1t = /*#__PURE__*/React.forwardRef(CalculatorFilled);
  {
    RefIcon$1t.displayName = 'CalculatorFilled';
  }

  var CalculatorOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CalculatorOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M251.2 387H320v68.8c0 1.8 1.8 3.2 4 3.2h48c2.2 0 4-1.4 4-3.3V387h68.8c1.8 0 3.2-1.8 3.2-4v-48c0-2.2-1.4-4-3.3-4H376v-68.8c0-1.8-1.8-3.2-4-3.2h-48c-2.2 0-4 1.4-4 3.2V331h-68.8c-1.8 0-3.2 1.8-3.2 4v48c0 2.2 1.4 4 3.2 4zm328 0h193.6c1.8 0 3.2-1.8 3.2-4v-48c0-2.2-1.4-4-3.3-4H579.2c-1.8 0-3.2 1.8-3.2 4v48c0 2.2 1.4 4 3.2 4zm0 265h193.6c1.8 0 3.2-1.8 3.2-4v-48c0-2.2-1.4-4-3.3-4H579.2c-1.8 0-3.2 1.8-3.2 4v48c0 2.2 1.4 4 3.2 4zm0 104h193.6c1.8 0 3.2-1.8 3.2-4v-48c0-2.2-1.4-4-3.3-4H579.2c-1.8 0-3.2 1.8-3.2 4v48c0 2.2 1.4 4 3.2 4zm-195.7-81l61.2-74.9c4.3-5.2.7-13.1-5.9-13.1H388c-2.3 0-4.5 1-5.9 2.9l-34 41.6-34-41.6a7.85 7.85 0 00-5.9-2.9h-50.9c-6.6 0-10.2 7.9-5.9 13.1l61.2 74.9-62.7 76.8c-4.4 5.2-.8 13.1 5.8 13.1h50.8c2.3 0 4.5-1 5.9-2.9l35.5-43.5 35.5 43.5c1.5 1.8 3.7 2.9 5.9 2.9h50.8c6.6 0 10.2-7.9 5.9-13.1L383.5 675zM880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-36 732H180V180h664v664z" } }] }, "name": "calculator", "theme": "outlined" };
  exports.default = CalculatorOutlined;
  });

  var CalculatorOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(CalculatorOutlined_1);

  var CalculatorOutlined = function CalculatorOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CalculatorOutlinedSvg
    }));
  };
  var RefIcon$1u = /*#__PURE__*/React.forwardRef(CalculatorOutlined);
  {
    RefIcon$1u.displayName = 'CalculatorOutlined';
  }

  var CalculatorTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CalculatorTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M184 840h656V184H184v656zm256.2-75h-50.8c-2.2 0-4.5-1.1-5.9-2.9L348 718.6l-35.5 43.5a7.38 7.38 0 01-5.9 2.9h-50.8c-6.6 0-10.2-7.9-5.8-13.1l62.7-76.8-61.2-74.9c-4.3-5.2-.7-13.1 5.9-13.1h50.9c2.2 0 4.5 1.1 5.9 2.9l34 41.6 34-41.6c1.5-1.9 3.6-2.9 5.9-2.9h50.8c6.6 0 10.2 7.9 5.9 13.1L383.5 675l62.7 76.8c4.2 5.3.6 13.2-6 13.2zM576 335c0-2.2 1.4-4 3.2-4h193.5c1.9 0 3.3 1.8 3.3 4v48c0 2.2-1.4 4-3.2 4H579.2c-1.8 0-3.2-1.8-3.2-4v-48zm0 265c0-2.2 1.4-4 3.2-4h193.5c1.9 0 3.3 1.8 3.3 4v48c0 2.2-1.4 4-3.2 4H579.2c-1.8 0-3.2-1.8-3.2-4v-48zm0 104c0-2.2 1.4-4 3.2-4h193.5c1.9 0 3.3 1.8 3.3 4v48c0 2.2-1.4 4-3.2 4H579.2c-1.8 0-3.2-1.8-3.2-4v-48zM248 335c0-2.2 1.4-4 3.2-4H320v-68.8c0-1.8 1.8-3.2 4-3.2h48c2.2 0 4 1.4 4 3.2V331h68.7c1.9 0 3.3 1.8 3.3 4v48c0 2.2-1.4 4-3.2 4H376v68.7c0 1.9-1.8 3.3-4 3.3h-48c-2.2 0-4-1.4-4-3.2V387h-68.8c-1.8 0-3.2-1.8-3.2-4v-48z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M383.5 675l61.3-74.8c4.3-5.2.7-13.1-5.9-13.1h-50.8c-2.3 0-4.4 1-5.9 2.9l-34 41.6-34-41.6a7.69 7.69 0 00-5.9-2.9h-50.9c-6.6 0-10.2 7.9-5.9 13.1l61.2 74.9-62.7 76.8c-4.4 5.2-.8 13.1 5.8 13.1h50.8c2.3 0 4.4-1 5.9-2.9l35.5-43.5 35.5 43.5c1.4 1.8 3.7 2.9 5.9 2.9h50.8c6.6 0 10.2-7.9 6-13.2L383.5 675zM251.2 387H320v68.8c0 1.8 1.8 3.2 4 3.2h48c2.2 0 4-1.4 4-3.3V387h68.8c1.8 0 3.2-1.8 3.2-4v-48c0-2.2-1.4-4-3.3-4H376v-68.8c0-1.8-1.8-3.2-4-3.2h-48c-2.2 0-4 1.4-4 3.2V331h-68.8c-1.8 0-3.2 1.8-3.2 4v48c0 2.2 1.4 4 3.2 4zm328 369h193.6c1.8 0 3.2-1.8 3.2-4v-48c0-2.2-1.4-4-3.3-4H579.2c-1.8 0-3.2 1.8-3.2 4v48c0 2.2 1.4 4 3.2 4zm0-104h193.6c1.8 0 3.2-1.8 3.2-4v-48c0-2.2-1.4-4-3.3-4H579.2c-1.8 0-3.2 1.8-3.2 4v48c0 2.2 1.4 4 3.2 4zm0-265h193.6c1.8 0 3.2-1.8 3.2-4v-48c0-2.2-1.4-4-3.3-4H579.2c-1.8 0-3.2 1.8-3.2 4v48c0 2.2 1.4 4 3.2 4z", "fill": primaryColor } }] }; }, "name": "calculator", "theme": "twotone" };
  exports.default = CalculatorTwoTone;
  });

  var CalculatorTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(CalculatorTwoTone_1);

  var CalculatorTwoTone = function CalculatorTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CalculatorTwoToneSvg
    }));
  };
  var RefIcon$1v = /*#__PURE__*/React.forwardRef(CalculatorTwoTone);
  {
    RefIcon$1v.displayName = 'CalculatorTwoTone';
  }

  var CalendarFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CalendarFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M112 880c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V460H112v420zm768-696H712v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H384v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H144c-17.7 0-32 14.3-32 32v176h800V216c0-17.7-14.3-32-32-32z" } }] }, "name": "calendar", "theme": "filled" };
  exports.default = CalendarFilled;
  });

  var CalendarFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(CalendarFilled_1);

  var CalendarFilled = function CalendarFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CalendarFilledSvg
    }));
  };
  var RefIcon$1w = /*#__PURE__*/React.forwardRef(CalendarFilled);
  {
    RefIcon$1w.displayName = 'CalendarFilled';
  }

  var CalendarOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CalendarOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 184H712v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H384v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H144c-17.7 0-32 14.3-32 32v664c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V216c0-17.7-14.3-32-32-32zm-40 656H184V460h656v380zM184 392V256h128v48c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-48h256v48c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-48h128v136H184z" } }] }, "name": "calendar", "theme": "outlined" };
  exports.default = CalendarOutlined;
  });

  var CalendarOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(CalendarOutlined_1);

  var CalendarOutlined = function CalendarOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CalendarOutlinedSvg
    }));
  };
  var RefIcon$1x = /*#__PURE__*/React.forwardRef(CalendarOutlined);
  {
    RefIcon$1x.displayName = 'CalendarOutlined';
  }

  var CalendarTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CalendarTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M712 304c0 4.4-3.6 8-8 8h-56c-4.4 0-8-3.6-8-8v-48H384v48c0 4.4-3.6 8-8 8h-56c-4.4 0-8-3.6-8-8v-48H184v136h656V256H712v48z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M880 184H712v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H384v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H144c-17.7 0-32 14.3-32 32v664c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V216c0-17.7-14.3-32-32-32zm-40 656H184V460h656v380zm0-448H184V256h128v48c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-48h256v48c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-48h128v136z", "fill": primaryColor } }] }; }, "name": "calendar", "theme": "twotone" };
  exports.default = CalendarTwoTone;
  });

  var CalendarTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(CalendarTwoTone_1);

  var CalendarTwoTone = function CalendarTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CalendarTwoToneSvg
    }));
  };
  var RefIcon$1y = /*#__PURE__*/React.forwardRef(CalendarTwoTone);
  {
    RefIcon$1y.displayName = 'CalendarTwoTone';
  }

  var CameraFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CameraFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M864 260H728l-32.4-90.8a32.07 32.07 0 00-30.2-21.2H358.6c-13.5 0-25.6 8.5-30.1 21.2L296 260H160c-44.2 0-80 35.8-80 80v456c0 44.2 35.8 80 80 80h704c44.2 0 80-35.8 80-80V340c0-44.2-35.8-80-80-80zM512 716c-88.4 0-160-71.6-160-160s71.6-160 160-160 160 71.6 160 160-71.6 160-160 160zm-96-160a96 96 0 10192 0 96 96 0 10-192 0z" } }] }, "name": "camera", "theme": "filled" };
  exports.default = CameraFilled;
  });

  var CameraFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(CameraFilled_1);

  var CameraFilled = function CameraFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CameraFilledSvg
    }));
  };
  var RefIcon$1z = /*#__PURE__*/React.forwardRef(CameraFilled);
  {
    RefIcon$1z.displayName = 'CameraFilled';
  }

  var CameraOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CameraOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M864 248H728l-32.4-90.8a32.07 32.07 0 00-30.2-21.2H358.6c-13.5 0-25.6 8.5-30.1 21.2L296 248H160c-44.2 0-80 35.8-80 80v456c0 44.2 35.8 80 80 80h704c44.2 0 80-35.8 80-80V328c0-44.2-35.8-80-80-80zm8 536c0 4.4-3.6 8-8 8H160c-4.4 0-8-3.6-8-8V328c0-4.4 3.6-8 8-8h186.7l17.1-47.8 22.9-64.2h250.5l22.9 64.2 17.1 47.8H864c4.4 0 8 3.6 8 8v456zM512 384c-88.4 0-160 71.6-160 160s71.6 160 160 160 160-71.6 160-160-71.6-160-160-160zm0 256c-53 0-96-43-96-96s43-96 96-96 96 43 96 96-43 96-96 96z" } }] }, "name": "camera", "theme": "outlined" };
  exports.default = CameraOutlined;
  });

  var CameraOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(CameraOutlined_1);

  var CameraOutlined = function CameraOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CameraOutlinedSvg
    }));
  };
  var RefIcon$1A = /*#__PURE__*/React.forwardRef(CameraOutlined);
  {
    RefIcon$1A.displayName = 'CameraOutlined';
  }

  var CameraTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CameraTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M864 320H677.2l-17.1-47.8-22.9-64.2H386.7l-22.9 64.2-17.1 47.8H160c-4.4 0-8 3.6-8 8v456c0 4.4 3.6 8 8 8h704c4.4 0 8-3.6 8-8V328c0-4.4-3.6-8-8-8zM512 704c-88.4 0-160-71.6-160-160s71.6-160 160-160 160 71.6 160 160-71.6 160-160 160z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M512 384c-88.4 0-160 71.6-160 160s71.6 160 160 160 160-71.6 160-160-71.6-160-160-160zm0 256c-53 0-96-43-96-96s43-96 96-96 96 43 96 96-43 96-96 96z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M864 248H728l-32.4-90.8a32.07 32.07 0 00-30.2-21.2H358.6c-13.5 0-25.6 8.5-30.1 21.2L296 248H160c-44.2 0-80 35.8-80 80v456c0 44.2 35.8 80 80 80h704c44.2 0 80-35.8 80-80V328c0-44.2-35.8-80-80-80zm8 536c0 4.4-3.6 8-8 8H160c-4.4 0-8-3.6-8-8V328c0-4.4 3.6-8 8-8h186.7l17.1-47.8 22.9-64.2h250.5l22.9 64.2 17.1 47.8H864c4.4 0 8 3.6 8 8v456z", "fill": primaryColor } }] }; }, "name": "camera", "theme": "twotone" };
  exports.default = CameraTwoTone;
  });

  var CameraTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(CameraTwoTone_1);

  var CameraTwoTone = function CameraTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CameraTwoToneSvg
    }));
  };
  var RefIcon$1B = /*#__PURE__*/React.forwardRef(CameraTwoTone);
  {
    RefIcon$1B.displayName = 'CameraTwoTone';
  }

  var CarFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CarFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M959 413.4L935.3 372a8 8 0 00-10.9-2.9l-50.7 29.6-78.3-216.2a63.9 63.9 0 00-60.9-44.4H301.2c-34.7 0-65.5 22.4-76.2 55.5l-74.6 205.2-50.8-29.6a8 8 0 00-10.9 2.9L65 413.4c-2.2 3.8-.9 8.6 2.9 10.8l60.4 35.2-14.5 40c-1.2 3.2-1.8 6.6-1.8 10v348.2c0 15.7 11.8 28.4 26.3 28.4h67.6c12.3 0 23-9.3 25.6-22.3l7.7-37.7h545.6l7.7 37.7c2.7 13 13.3 22.3 25.6 22.3h67.6c14.5 0 26.3-12.7 26.3-28.4V509.4c0-3.4-.6-6.8-1.8-10l-14.5-40 60.3-35.2a8 8 0 003-10.8zM264 621c-22.1 0-40-17.9-40-40s17.9-40 40-40 40 17.9 40 40-17.9 40-40 40zm388 75c0 4.4-3.6 8-8 8H380c-4.4 0-8-3.6-8-8v-84c0-4.4 3.6-8 8-8h40c4.4 0 8 3.6 8 8v36h168v-36c0-4.4 3.6-8 8-8h40c4.4 0 8 3.6 8 8v84zm108-75c-22.1 0-40-17.9-40-40s17.9-40 40-40 40 17.9 40 40-17.9 40-40 40zM220 418l72.7-199.9.5-1.3.4-1.3c1.1-3.3 4.1-5.5 7.6-5.5h427.6l75.4 208H220z" } }] }, "name": "car", "theme": "filled" };
  exports.default = CarFilled;
  });

  var CarFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(CarFilled_1);

  var CarFilled = function CarFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CarFilledSvg
    }));
  };
  var RefIcon$1C = /*#__PURE__*/React.forwardRef(CarFilled);
  {
    RefIcon$1C.displayName = 'CarFilled';
  }

  var CarOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CarOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M380 704h264c4.4 0 8-3.6 8-8v-84c0-4.4-3.6-8-8-8h-40c-4.4 0-8 3.6-8 8v36H428v-36c0-4.4-3.6-8-8-8h-40c-4.4 0-8 3.6-8 8v84c0 4.4 3.6 8 8 8zm340-123a40 40 0 1080 0 40 40 0 10-80 0zm239-167.6L935.3 372a8 8 0 00-10.9-2.9l-50.7 29.6-78.3-216.2a63.9 63.9 0 00-60.9-44.4H301.2c-34.7 0-65.5 22.4-76.2 55.5l-74.6 205.2-50.8-29.6a8 8 0 00-10.9 2.9L65 413.4c-2.2 3.8-.9 8.6 2.9 10.8l60.4 35.2-14.5 40c-1.2 3.2-1.8 6.6-1.8 10v348.2c0 15.7 11.8 28.4 26.3 28.4h67.6c12.3 0 23-9.3 25.6-22.3l7.7-37.7h545.6l7.7 37.7c2.7 13 13.3 22.3 25.6 22.3h67.6c14.5 0 26.3-12.7 26.3-28.4V509.4c0-3.4-.6-6.8-1.8-10l-14.5-40 60.3-35.2a8 8 0 003-10.8zM840 517v237H184V517l15.6-43h624.8l15.6 43zM292.7 218.1l.5-1.3.4-1.3c1.1-3.3 4.1-5.5 7.6-5.5h427.6l75.4 208H220l72.7-199.9zM224 581a40 40 0 1080 0 40 40 0 10-80 0z" } }] }, "name": "car", "theme": "outlined" };
  exports.default = CarOutlined;
  });

  var CarOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(CarOutlined_1);

  var CarOutlined = function CarOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CarOutlinedSvg
    }));
  };
  var RefIcon$1D = /*#__PURE__*/React.forwardRef(CarOutlined);
  {
    RefIcon$1D.displayName = 'CarOutlined';
  }

  var CarTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CarTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M199.6 474L184 517v237h656V517l-15.6-43H199.6zM264 621c-22.1 0-40-17.9-40-40s17.9-40 40-40 40 17.9 40 40-17.9 40-40 40zm388 75c0 4.4-3.6 8-8 8H380c-4.4 0-8-3.6-8-8v-84c0-4.4 3.6-8 8-8h40c4.4 0 8 3.6 8 8v36h168v-36c0-4.4 3.6-8 8-8h40c4.4 0 8 3.6 8 8v84zm108-75c-22.1 0-40-17.9-40-40s17.9-40 40-40 40 17.9 40 40-17.9 40-40 40z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M720 581a40 40 0 1080 0 40 40 0 10-80 0z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M959 413.4L935.3 372a8 8 0 00-10.9-2.9l-50.7 29.6-78.3-216.2a63.9 63.9 0 00-60.9-44.4H301.2c-34.7 0-65.5 22.4-76.2 55.5l-74.6 205.2-50.8-29.6a8 8 0 00-10.9 2.9L65 413.4c-2.2 3.8-.9 8.6 2.9 10.8l60.4 35.2-14.5 40c-1.2 3.2-1.8 6.6-1.8 10v348.2c0 15.7 11.8 28.4 26.3 28.4h67.6c12.3 0 23-9.3 25.6-22.3l7.7-37.7h545.6l7.7 37.7c2.7 13 13.3 22.3 25.6 22.3h67.6c14.5 0 26.3-12.7 26.3-28.4V509.4c0-3.4-.6-6.8-1.8-10l-14.5-40 60.3-35.2a8 8 0 003-10.8zM292.7 218.1l.5-1.3.4-1.3c1.1-3.3 4.1-5.5 7.6-5.5h427.6l75.4 208H220l72.7-199.9zM840 754H184V517l15.6-43h624.8l15.6 43v237z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M224 581a40 40 0 1080 0 40 40 0 10-80 0zm420 23h-40c-4.4 0-8 3.6-8 8v36H428v-36c0-4.4-3.6-8-8-8h-40c-4.4 0-8 3.6-8 8v84c0 4.4 3.6 8 8 8h264c4.4 0 8-3.6 8-8v-84c0-4.4-3.6-8-8-8z", "fill": primaryColor } }] }; }, "name": "car", "theme": "twotone" };
  exports.default = CarTwoTone;
  });

  var CarTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(CarTwoTone_1);

  var CarTwoTone = function CarTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CarTwoToneSvg
    }));
  };
  var RefIcon$1E = /*#__PURE__*/React.forwardRef(CarTwoTone);
  {
    RefIcon$1E.displayName = 'CarTwoTone';
  }

  var CaretDownFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CaretDownFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M840.4 300H183.6c-19.7 0-30.7 20.8-18.5 35l328.4 380.8c9.4 10.9 27.5 10.9 37 0L858.9 335c12.2-14.2 1.2-35-18.5-35z" } }] }, "name": "caret-down", "theme": "filled" };
  exports.default = CaretDownFilled;
  });

  var CaretDownFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(CaretDownFilled_1);

  var CaretDownFilled = function CaretDownFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CaretDownFilledSvg
    }));
  };
  var RefIcon$1F = /*#__PURE__*/React.forwardRef(CaretDownFilled);
  {
    RefIcon$1F.displayName = 'CaretDownFilled';
  }

  var CaretDownOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CaretDownOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M840.4 300H183.6c-19.7 0-30.7 20.8-18.5 35l328.4 380.8c9.4 10.9 27.5 10.9 37 0L858.9 335c12.2-14.2 1.2-35-18.5-35z" } }] }, "name": "caret-down", "theme": "outlined" };
  exports.default = CaretDownOutlined;
  });

  var CaretDownOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(CaretDownOutlined_1);

  var CaretDownOutlined = function CaretDownOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CaretDownOutlinedSvg
    }));
  };
  var RefIcon$1G = /*#__PURE__*/React.forwardRef(CaretDownOutlined);
  {
    RefIcon$1G.displayName = 'CaretDownOutlined';
  }

  var CaretLeftFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CaretLeftFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M689 165.1L308.2 493.5c-10.9 9.4-10.9 27.5 0 37L689 858.9c14.2 12.2 35 1.2 35-18.5V183.6c0-19.7-20.8-30.7-35-18.5z" } }] }, "name": "caret-left", "theme": "filled" };
  exports.default = CaretLeftFilled;
  });

  var CaretLeftFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(CaretLeftFilled_1);

  var CaretLeftFilled = function CaretLeftFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CaretLeftFilledSvg
    }));
  };
  var RefIcon$1H = /*#__PURE__*/React.forwardRef(CaretLeftFilled);
  {
    RefIcon$1H.displayName = 'CaretLeftFilled';
  }

  var CaretLeftOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CaretLeftOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M689 165.1L308.2 493.5c-10.9 9.4-10.9 27.5 0 37L689 858.9c14.2 12.2 35 1.2 35-18.5V183.6c0-19.7-20.8-30.7-35-18.5z" } }] }, "name": "caret-left", "theme": "outlined" };
  exports.default = CaretLeftOutlined;
  });

  var CaretLeftOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(CaretLeftOutlined_1);

  var CaretLeftOutlined = function CaretLeftOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CaretLeftOutlinedSvg
    }));
  };
  var RefIcon$1I = /*#__PURE__*/React.forwardRef(CaretLeftOutlined);
  {
    RefIcon$1I.displayName = 'CaretLeftOutlined';
  }

  var CaretRightFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CaretRightFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M715.8 493.5L335 165.1c-14.2-12.2-35-1.2-35 18.5v656.8c0 19.7 20.8 30.7 35 18.5l380.8-328.4c10.9-9.4 10.9-27.6 0-37z" } }] }, "name": "caret-right", "theme": "filled" };
  exports.default = CaretRightFilled;
  });

  var CaretRightFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(CaretRightFilled_1);

  var CaretRightFilled = function CaretRightFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CaretRightFilledSvg
    }));
  };
  var RefIcon$1J = /*#__PURE__*/React.forwardRef(CaretRightFilled);
  {
    RefIcon$1J.displayName = 'CaretRightFilled';
  }

  var CaretRightOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CaretRightOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M715.8 493.5L335 165.1c-14.2-12.2-35-1.2-35 18.5v656.8c0 19.7 20.8 30.7 35 18.5l380.8-328.4c10.9-9.4 10.9-27.6 0-37z" } }] }, "name": "caret-right", "theme": "outlined" };
  exports.default = CaretRightOutlined;
  });

  var CaretRightOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(CaretRightOutlined_1);

  var CaretRightOutlined = function CaretRightOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CaretRightOutlinedSvg
    }));
  };
  var RefIcon$1K = /*#__PURE__*/React.forwardRef(CaretRightOutlined);
  {
    RefIcon$1K.displayName = 'CaretRightOutlined';
  }

  var CaretUpFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CaretUpFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M858.9 689L530.5 308.2c-9.4-10.9-27.5-10.9-37 0L165.1 689c-12.2 14.2-1.2 35 18.5 35h656.8c19.7 0 30.7-20.8 18.5-35z" } }] }, "name": "caret-up", "theme": "filled" };
  exports.default = CaretUpFilled;
  });

  var CaretUpFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(CaretUpFilled_1);

  var CaretUpFilled = function CaretUpFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CaretUpFilledSvg
    }));
  };
  var RefIcon$1L = /*#__PURE__*/React.forwardRef(CaretUpFilled);
  {
    RefIcon$1L.displayName = 'CaretUpFilled';
  }

  var CaretUpOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CaretUpOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M858.9 689L530.5 308.2c-9.4-10.9-27.5-10.9-37 0L165.1 689c-12.2 14.2-1.2 35 18.5 35h656.8c19.7 0 30.7-20.8 18.5-35z" } }] }, "name": "caret-up", "theme": "outlined" };
  exports.default = CaretUpOutlined;
  });

  var CaretUpOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(CaretUpOutlined_1);

  var CaretUpOutlined = function CaretUpOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CaretUpOutlinedSvg
    }));
  };
  var RefIcon$1M = /*#__PURE__*/React.forwardRef(CaretUpOutlined);
  {
    RefIcon$1M.displayName = 'CaretUpOutlined';
  }

  var CarryOutFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CarryOutFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 184H712v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H384v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H144c-17.7 0-32 14.3-32 32v664c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V216c0-17.7-14.3-32-32-32zM694.5 432.7L481.9 725.4a16.1 16.1 0 01-26 0l-126.4-174c-3.8-5.3 0-12.7 6.5-12.7h55.2c5.1 0 10 2.5 13 6.6l64.7 89 150.9-207.8c3-4.1 7.8-6.6 13-6.6H688c6.5.1 10.3 7.5 6.5 12.8z" } }] }, "name": "carry-out", "theme": "filled" };
  exports.default = CarryOutFilled;
  });

  var CarryOutFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(CarryOutFilled_1);

  var CarryOutFilled = function CarryOutFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CarryOutFilledSvg
    }));
  };
  var RefIcon$1N = /*#__PURE__*/React.forwardRef(CarryOutFilled);
  {
    RefIcon$1N.displayName = 'CarryOutFilled';
  }

  var CarryOutOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CarryOutOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 184H712v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H384v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H144c-17.7 0-32 14.3-32 32v664c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V216c0-17.7-14.3-32-32-32zm-40 656H184V256h128v48c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-48h256v48c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-48h128v584zM688 420h-55.2c-5.1 0-10 2.5-13 6.6L468.9 634.4l-64.7-89c-3-4.1-7.8-6.6-13-6.6H336c-6.5 0-10.3 7.4-6.5 12.7l126.4 174a16.1 16.1 0 0026 0l212.6-292.7c3.8-5.4 0-12.8-6.5-12.8z" } }] }, "name": "carry-out", "theme": "outlined" };
  exports.default = CarryOutOutlined;
  });

  var CarryOutOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(CarryOutOutlined_1);

  var CarryOutOutlined = function CarryOutOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CarryOutOutlinedSvg
    }));
  };
  var RefIcon$1O = /*#__PURE__*/React.forwardRef(CarryOutOutlined);
  {
    RefIcon$1O.displayName = 'CarryOutOutlined';
  }

  var CarryOutTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CarryOutTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 184H712v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H384v-64c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H144c-17.7 0-32 14.3-32 32v664c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V216c0-17.7-14.3-32-32-32zm-40 656H184V256h128v48c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-48h256v48c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-48h128v584z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M712 304c0 4.4-3.6 8-8 8h-56c-4.4 0-8-3.6-8-8v-48H384v48c0 4.4-3.6 8-8 8h-56c-4.4 0-8-3.6-8-8v-48H184v584h656V256H712v48zm-17.5 128.8L481.9 725.5a16.1 16.1 0 01-26 0l-126.4-174c-3.8-5.3 0-12.7 6.5-12.7h55.2c5.2 0 10 2.5 13 6.6l64.7 89 150.9-207.8c3-4.1 7.9-6.6 13-6.6H688c6.5 0 10.3 7.4 6.5 12.8z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M688 420h-55.2c-5.1 0-10 2.5-13 6.6L468.9 634.4l-64.7-89c-3-4.1-7.8-6.6-13-6.6H336c-6.5 0-10.3 7.4-6.5 12.7l126.4 174a16.1 16.1 0 0026 0l212.6-292.7c3.8-5.4 0-12.8-6.5-12.8z", "fill": primaryColor } }] }; }, "name": "carry-out", "theme": "twotone" };
  exports.default = CarryOutTwoTone;
  });

  var CarryOutTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(CarryOutTwoTone_1);

  var CarryOutTwoTone = function CarryOutTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CarryOutTwoToneSvg
    }));
  };
  var RefIcon$1P = /*#__PURE__*/React.forwardRef(CarryOutTwoTone);
  {
    RefIcon$1P.displayName = 'CarryOutTwoTone';
  }

  var CheckCircleFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CheckCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm193.5 301.7l-210.6 292a31.8 31.8 0 01-51.7 0L318.5 484.9c-3.8-5.3 0-12.7 6.5-12.7h46.9c10.2 0 19.9 4.9 25.9 13.3l71.2 98.8 157.2-218c6-8.3 15.6-13.3 25.9-13.3H699c6.5 0 10.3 7.4 6.5 12.7z" } }] }, "name": "check-circle", "theme": "filled" };
  exports.default = CheckCircleFilled;
  });

  var CheckCircleFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(CheckCircleFilled_1);

  var CheckCircleFilled = function CheckCircleFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CheckCircleFilledSvg
    }));
  };
  var RefIcon$1Q = /*#__PURE__*/React.forwardRef(CheckCircleFilled);
  {
    RefIcon$1Q.displayName = 'CheckCircleFilled';
  }

  var CheckCircleOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CheckCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M699 353h-46.9c-10.2 0-19.9 4.9-25.9 13.3L469 584.3l-71.2-98.8c-6-8.3-15.6-13.3-25.9-13.3H325c-6.5 0-10.3 7.4-6.5 12.7l124.6 172.8a31.8 31.8 0 0051.7 0l210.6-292c3.9-5.3.1-12.7-6.4-12.7z" } }, { "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z" } }] }, "name": "check-circle", "theme": "outlined" };
  exports.default = CheckCircleOutlined;
  });

  var CheckCircleOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(CheckCircleOutlined_1);

  var CheckCircleOutlined = function CheckCircleOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CheckCircleOutlinedSvg
    }));
  };
  var RefIcon$1R = /*#__PURE__*/React.forwardRef(CheckCircleOutlined);
  {
    RefIcon$1R.displayName = 'CheckCircleOutlined';
  }

  var CheckCircleTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CheckCircleTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm193.4 225.7l-210.6 292a31.8 31.8 0 01-51.7 0L318.5 484.9c-3.8-5.3 0-12.7 6.5-12.7h46.9c10.3 0 19.9 5 25.9 13.3l71.2 98.8 157.2-218c6-8.4 15.7-13.3 25.9-13.3H699c6.5 0 10.3 7.4 6.4 12.7z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M699 353h-46.9c-10.2 0-19.9 4.9-25.9 13.3L469 584.3l-71.2-98.8c-6-8.3-15.6-13.3-25.9-13.3H325c-6.5 0-10.3 7.4-6.5 12.7l124.6 172.8a31.8 31.8 0 0051.7 0l210.6-292c3.9-5.3.1-12.7-6.4-12.7z", "fill": primaryColor } }] }; }, "name": "check-circle", "theme": "twotone" };
  exports.default = CheckCircleTwoTone;
  });

  var CheckCircleTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(CheckCircleTwoTone_1);

  var CheckCircleTwoTone = function CheckCircleTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CheckCircleTwoToneSvg
    }));
  };
  var RefIcon$1S = /*#__PURE__*/React.forwardRef(CheckCircleTwoTone);
  {
    RefIcon$1S.displayName = 'CheckCircleTwoTone';
  }

  var CheckOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CheckOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M912 190h-69.9c-9.8 0-19.1 4.5-25.1 12.2L404.7 724.5 207 474a32 32 0 00-25.1-12.2H112c-6.7 0-10.4 7.7-6.3 12.9l273.9 347c12.8 16.2 37.4 16.2 50.3 0l488.4-618.9c4.1-5.1.4-12.8-6.3-12.8z" } }] }, "name": "check", "theme": "outlined" };
  exports.default = CheckOutlined;
  });

  var CheckOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(CheckOutlined_1);

  var CheckOutlined = function CheckOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CheckOutlinedSvg
    }));
  };
  var RefIcon$1T = /*#__PURE__*/React.forwardRef(CheckOutlined);
  {
    RefIcon$1T.displayName = 'CheckOutlined';
  }

  var CheckSquareFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CheckSquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM695.5 365.7l-210.6 292a31.8 31.8 0 01-51.7 0L308.5 484.9c-3.8-5.3 0-12.7 6.5-12.7h46.9c10.2 0 19.9 4.9 25.9 13.3l71.2 98.8 157.2-218c6-8.3 15.6-13.3 25.9-13.3H689c6.5 0 10.3 7.4 6.5 12.7z" } }] }, "name": "check-square", "theme": "filled" };
  exports.default = CheckSquareFilled;
  });

  var CheckSquareFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(CheckSquareFilled_1);

  var CheckSquareFilled = function CheckSquareFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CheckSquareFilledSvg
    }));
  };
  var RefIcon$1U = /*#__PURE__*/React.forwardRef(CheckSquareFilled);
  {
    RefIcon$1U.displayName = 'CheckSquareFilled';
  }

  var CheckSquareOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CheckSquareOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M433.1 657.7a31.8 31.8 0 0051.7 0l210.6-292c3.8-5.3 0-12.7-6.5-12.7H642c-10.2 0-19.9 4.9-25.9 13.3L459 584.3l-71.2-98.8c-6-8.3-15.6-13.3-25.9-13.3H315c-6.5 0-10.3 7.4-6.5 12.7l124.6 172.8z" } }, { "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z" } }] }, "name": "check-square", "theme": "outlined" };
  exports.default = CheckSquareOutlined;
  });

  var CheckSquareOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(CheckSquareOutlined_1);

  var CheckSquareOutlined = function CheckSquareOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CheckSquareOutlinedSvg
    }));
  };
  var RefIcon$1V = /*#__PURE__*/React.forwardRef(CheckSquareOutlined);
  {
    RefIcon$1V.displayName = 'CheckSquareOutlined';
  }

  var CheckSquareTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CheckSquareTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M184 840h656V184H184v656zm130-367.8h46.9c10.2 0 19.9 4.9 25.9 13.3l71.2 98.8 157.2-218c6-8.3 15.6-13.3 25.9-13.3H688c6.5 0 10.3 7.4 6.5 12.7l-210.6 292a31.8 31.8 0 01-51.7 0L307.5 484.9c-3.8-5.3 0-12.7 6.5-12.7z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M432.2 657.7a31.8 31.8 0 0051.7 0l210.6-292c3.8-5.3 0-12.7-6.5-12.7h-46.9c-10.3 0-19.9 5-25.9 13.3L458 584.3l-71.2-98.8c-6-8.4-15.7-13.3-25.9-13.3H314c-6.5 0-10.3 7.4-6.5 12.7l124.7 172.8z", "fill": primaryColor } }] }; }, "name": "check-square", "theme": "twotone" };
  exports.default = CheckSquareTwoTone;
  });

  var CheckSquareTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(CheckSquareTwoTone_1);

  var CheckSquareTwoTone = function CheckSquareTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CheckSquareTwoToneSvg
    }));
  };
  var RefIcon$1W = /*#__PURE__*/React.forwardRef(CheckSquareTwoTone);
  {
    RefIcon$1W.displayName = 'CheckSquareTwoTone';
  }

  var ChromeFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ChromeFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M371.8 512c0 77.5 62.7 140.2 140.2 140.2S652.2 589.5 652.2 512 589.5 371.8 512 371.8 371.8 434.4 371.8 512zM900 362.4l-234.3 12.1c63.6 74.3 64.6 181.5 11.1 263.7l-188 289.2c78 4.2 158.4-12.9 231.2-55.2 180-104 253-322.1 180-509.8zM320.3 591.9L163.8 284.1A415.35 415.35 0 0096 512c0 208 152.3 380.3 351.4 410.8l106.9-209.4c-96.6 18.2-189.9-34.8-234-121.5zm218.5-285.5l344.4 18.1C848 254.7 792.6 194 719.8 151.7 653.9 113.6 581.5 95.5 510.5 96c-122.5.5-242.2 55.2-322.1 154.5l128.2 196.9c32-91.9 124.8-146.7 222.2-141z" } }] }, "name": "chrome", "theme": "filled" };
  exports.default = ChromeFilled;
  });

  var ChromeFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(ChromeFilled_1);

  var ChromeFilled = function ChromeFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ChromeFilledSvg
    }));
  };
  var RefIcon$1X = /*#__PURE__*/React.forwardRef(ChromeFilled);
  {
    RefIcon$1X.displayName = 'ChromeFilled';
  }

  var ChromeOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ChromeOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M928 512.3v-.3c0-229.8-186.2-416-416-416S96 282.2 96 512v.4c0 229.8 186.2 416 416 416s416-186.2 416-416v-.3.2zm-6.7-74.6l.6 3.3-.6-3.3zM676.7 638.2c53.5-82.2 52.5-189.4-11.1-263.7l162.4-8.4c20.5 44.4 32 93.8 32 145.9 0 185.2-144.6 336.6-327.1 347.4l143.8-221.2zM512 652.3c-77.5 0-140.2-62.7-140.2-140.2 0-77.7 62.7-140.2 140.2-140.2S652.2 434.5 652.2 512 589.5 652.3 512 652.3zm369.2-331.7l-3-5.7 3 5.7zM512 164c121.3 0 228.2 62.1 290.4 156.2l-263.6-13.9c-97.5-5.7-190.2 49.2-222.3 141.1L227.8 311c63.1-88.9 166.9-147 284.2-147zM102.5 585.8c26 145 127.1 264 261.6 315.1C229.6 850 128.5 731 102.5 585.8zM164 512c0-55.9 13.2-108.7 36.6-155.5l119.7 235.4c44.1 86.7 137.4 139.7 234 121.6l-74 145.1C302.9 842.5 164 693.5 164 512zm324.7 415.4c4 .2 8 .4 12 .5-4-.2-8-.3-12-.5z" } }] }, "name": "chrome", "theme": "outlined" };
  exports.default = ChromeOutlined;
  });

  var ChromeOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(ChromeOutlined_1);

  var ChromeOutlined = function ChromeOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ChromeOutlinedSvg
    }));
  };
  var RefIcon$1Y = /*#__PURE__*/React.forwardRef(ChromeOutlined);
  {
    RefIcon$1Y.displayName = 'ChromeOutlined';
  }

  var CiCircleFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CiCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm-63.6 656c-103 0-162.4-68.6-162.4-182.6v-49C286 373.5 345.4 304 448.3 304c88.3 0 152.3 56.9 152.3 138.1 0 2.4-2 4.4-4.4 4.4h-52.6c-4.2 0-7.6-3.2-8-7.4-4-46.1-37.6-77.6-87-77.6-61.1 0-95.6 45.4-95.6 126.9v49.3c0 80.3 34.5 125.1 95.6 125.1 49.3 0 82.8-29.5 87-72.4.4-4.1 3.8-7.3 8-7.3h52.7c2.4 0 4.4 2 4.4 4.4 0 77.4-64.3 132.5-152.3 132.5zM738 704.1c0 4.4-3.6 8-8 8h-50.4c-4.4 0-8-3.6-8-8V319.9c0-4.4 3.6-8 8-8H730c4.4 0 8 3.6 8 8v384.2z" } }] }, "name": "ci-circle", "theme": "filled" };
  exports.default = CiCircleFilled;
  });

  var CiCircleFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(CiCircleFilled_1);

  var CiCircleFilled = function CiCircleFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CiCircleFilledSvg
    }));
  };
  var RefIcon$1Z = /*#__PURE__*/React.forwardRef(CiCircleFilled);
  {
    RefIcon$1Z.displayName = 'CiCircleFilled';
  }

  var CiCircleOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CiCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372zm218-572.1h-50.4c-4.4 0-8 3.6-8 8v384.2c0 4.4 3.6 8 8 8H730c4.4 0 8-3.6 8-8V319.9c0-4.4-3.6-8-8-8zm-281.4 49.6c49.5 0 83.1 31.5 87 77.6.4 4.2 3.8 7.4 8 7.4h52.6c2.4 0 4.4-2 4.4-4.4 0-81.2-64-138.1-152.3-138.1C345.4 304 286 373.5 286 488.4v49c0 114 59.4 182.6 162.3 182.6 88 0 152.3-55.1 152.3-132.5 0-2.4-2-4.4-4.4-4.4h-52.7c-4.2 0-7.6 3.2-8 7.3-4.2 43-37.7 72.4-87 72.4-61.1 0-95.6-44.9-95.6-125.2v-49.3c.1-81.4 34.6-126.8 95.7-126.8z" } }] }, "name": "ci-circle", "theme": "outlined" };
  exports.default = CiCircleOutlined;
  });

  var CiCircleOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(CiCircleOutlined_1);

  var CiCircleOutlined = function CiCircleOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CiCircleOutlinedSvg
    }));
  };
  var RefIcon$1_ = /*#__PURE__*/React.forwardRef(CiCircleOutlined);
  {
    RefIcon$1_.displayName = 'CiCircleOutlined';
  }

  var CiCircleTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CiCircleTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm-63.5 522.8c49.3 0 82.8-29.4 87-72.4.4-4.1 3.8-7.3 8-7.3h52.7c2.4 0 4.4 2 4.4 4.4 0 77.4-64.3 132.5-152.3 132.5C345.4 720 286 651.4 286 537.4v-49C286 373.5 345.4 304 448.3 304c88.3 0 152.3 56.9 152.3 138.1 0 2.4-2 4.4-4.4 4.4h-52.6c-4.2 0-7.6-3.2-8-7.4-3.9-46.1-37.5-77.6-87-77.6-61.1 0-95.6 45.4-95.7 126.8v49.3c0 80.3 34.5 125.2 95.6 125.2zM738 704.1c0 4.4-3.6 8-8 8h-50.4c-4.4 0-8-3.6-8-8V319.9c0-4.4 3.6-8 8-8H730c4.4 0 8 3.6 8 8v384.2z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M730 311.9h-50.4c-4.4 0-8 3.6-8 8v384.2c0 4.4 3.6 8 8 8H730c4.4 0 8-3.6 8-8V319.9c0-4.4-3.6-8-8-8zm-281.4 49.6c49.5 0 83.1 31.5 87 77.6.4 4.2 3.8 7.4 8 7.4h52.6c2.4 0 4.4-2 4.4-4.4 0-81.2-64-138.1-152.3-138.1C345.4 304 286 373.5 286 488.4v49c0 114 59.4 182.6 162.3 182.6 88 0 152.3-55.1 152.3-132.5 0-2.4-2-4.4-4.4-4.4h-52.7c-4.2 0-7.6 3.2-8 7.3-4.2 43-37.7 72.4-87 72.4-61.1 0-95.6-44.9-95.6-125.2v-49.3c.1-81.4 34.6-126.8 95.7-126.8z", "fill": primaryColor } }] }; }, "name": "ci-circle", "theme": "twotone" };
  exports.default = CiCircleTwoTone;
  });

  var CiCircleTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(CiCircleTwoTone_1);

  var CiCircleTwoTone = function CiCircleTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CiCircleTwoToneSvg
    }));
  };
  var RefIcon$1$ = /*#__PURE__*/React.forwardRef(CiCircleTwoTone);
  {
    RefIcon$1$.displayName = 'CiCircleTwoTone';
  }

  var CiOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CiOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372zm218-572.1h-50.4c-4.4 0-8 3.6-8 8v384.2c0 4.4 3.6 8 8 8H730c4.4 0 8-3.6 8-8V319.9c0-4.4-3.6-8-8-8zm-281.4 49.6c49.5 0 83.1 31.5 87 77.6.4 4.2 3.8 7.4 8 7.4h52.6c2.4 0 4.4-2 4.4-4.4 0-81.2-64-138.1-152.3-138.1C345.4 304 286 373.5 286 488.4v49c0 114 59.4 182.6 162.3 182.6 88 0 152.3-55.1 152.3-132.5 0-2.4-2-4.4-4.4-4.4h-52.7c-4.2 0-7.6 3.2-8 7.3-4.2 43-37.7 72.4-87 72.4-61.1 0-95.6-44.9-95.6-125.2v-49.3c.1-81.4 34.6-126.8 95.7-126.8z" } }] }, "name": "ci", "theme": "outlined" };
  exports.default = CiOutlined;
  });

  var CiOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(CiOutlined_1);

  var CiOutlined = function CiOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CiOutlinedSvg
    }));
  };
  var RefIcon$20 = /*#__PURE__*/React.forwardRef(CiOutlined);
  {
    RefIcon$20.displayName = 'CiOutlined';
  }

  var CiTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CiTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm-63.5 522.8c49.3 0 82.8-29.4 87-72.4.4-4.1 3.8-7.3 8-7.3h52.7c2.4 0 4.4 2 4.4 4.4 0 77.4-64.3 132.5-152.3 132.5C345.4 720 286 651.4 286 537.4v-49C286 373.5 345.4 304 448.3 304c88.3 0 152.3 56.9 152.3 138.1 0 2.4-2 4.4-4.4 4.4h-52.6c-4.2 0-7.6-3.2-8-7.4-3.9-46.1-37.5-77.6-87-77.6-61.1 0-95.6 45.4-95.7 126.8v49.3c0 80.3 34.5 125.2 95.6 125.2zM738 704.1c0 4.4-3.6 8-8 8h-50.4c-4.4 0-8-3.6-8-8V319.9c0-4.4 3.6-8 8-8H730c4.4 0 8 3.6 8 8v384.2z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M730 311.9h-50.4c-4.4 0-8 3.6-8 8v384.2c0 4.4 3.6 8 8 8H730c4.4 0 8-3.6 8-8V319.9c0-4.4-3.6-8-8-8zm-281.4 49.6c49.5 0 83.1 31.5 87 77.6.4 4.2 3.8 7.4 8 7.4h52.6c2.4 0 4.4-2 4.4-4.4 0-81.2-64-138.1-152.3-138.1C345.4 304 286 373.5 286 488.4v49c0 114 59.4 182.6 162.3 182.6 88 0 152.3-55.1 152.3-132.5 0-2.4-2-4.4-4.4-4.4h-52.7c-4.2 0-7.6 3.2-8 7.3-4.2 43-37.7 72.4-87 72.4-61.1 0-95.6-44.9-95.6-125.2v-49.3c.1-81.4 34.6-126.8 95.7-126.8z", "fill": primaryColor } }] }; }, "name": "ci", "theme": "twotone" };
  exports.default = CiTwoTone;
  });

  var CiTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(CiTwoTone_1);

  var CiTwoTone = function CiTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CiTwoToneSvg
    }));
  };
  var RefIcon$21 = /*#__PURE__*/React.forwardRef(CiTwoTone);
  {
    RefIcon$21.displayName = 'CiTwoTone';
  }

  var ClearOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ClearOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M899.1 869.6l-53-305.6H864c14.4 0 26-11.6 26-26V346c0-14.4-11.6-26-26-26H618V138c0-14.4-11.6-26-26-26H432c-14.4 0-26 11.6-26 26v182H160c-14.4 0-26 11.6-26 26v192c0 14.4 11.6 26 26 26h17.9l-53 305.6a25.95 25.95 0 0025.6 30.4h723c1.5 0 3-.1 4.4-.4a25.88 25.88 0 0021.2-30zM204 390h272V182h72v208h272v104H204V390zm468 440V674c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v156H416V674c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v156H202.8l45.1-260H776l45.1 260H672z" } }] }, "name": "clear", "theme": "outlined" };
  exports.default = ClearOutlined;
  });

  var ClearOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(ClearOutlined_1);

  var ClearOutlined = function ClearOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ClearOutlinedSvg
    }));
  };
  var RefIcon$22 = /*#__PURE__*/React.forwardRef(ClearOutlined);
  {
    RefIcon$22.displayName = 'ClearOutlined';
  }

  var ClockCircleFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ClockCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm176.5 585.7l-28.6 39a7.99 7.99 0 01-11.2 1.7L483.3 569.8a7.92 7.92 0 01-3.3-6.5V288c0-4.4 3.6-8 8-8h48.1c4.4 0 8 3.6 8 8v247.5l142.6 103.1c3.6 2.5 4.4 7.5 1.8 11.1z" } }] }, "name": "clock-circle", "theme": "filled" };
  exports.default = ClockCircleFilled;
  });

  var ClockCircleFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(ClockCircleFilled_1);

  var ClockCircleFilled = function ClockCircleFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ClockCircleFilledSvg
    }));
  };
  var RefIcon$23 = /*#__PURE__*/React.forwardRef(ClockCircleFilled);
  {
    RefIcon$23.displayName = 'ClockCircleFilled';
  }

  var ClockCircleOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ClockCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z" } }, { "tag": "path", "attrs": { "d": "M686.7 638.6L544.1 535.5V288c0-4.4-3.6-8-8-8H488c-4.4 0-8 3.6-8 8v275.4c0 2.6 1.2 5 3.3 6.5l165.4 120.6c3.6 2.6 8.6 1.8 11.2-1.7l28.6-39c2.6-3.7 1.8-8.7-1.8-11.2z" } }] }, "name": "clock-circle", "theme": "outlined" };
  exports.default = ClockCircleOutlined;
  });

  var ClockCircleOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(ClockCircleOutlined_1);

  var ClockCircleOutlined = function ClockCircleOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ClockCircleOutlinedSvg
    }));
  };
  var RefIcon$24 = /*#__PURE__*/React.forwardRef(ClockCircleOutlined);
  {
    RefIcon$24.displayName = 'ClockCircleOutlined';
  }

  var ClockCircleTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ClockCircleTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm176.5 509.7l-28.6 39a7.99 7.99 0 01-11.2 1.7L483.3 569.8a7.92 7.92 0 01-3.3-6.5V288c0-4.4 3.6-8 8-8h48.1c4.4 0 8 3.6 8 8v247.5l142.6 103.1c3.6 2.5 4.4 7.5 1.8 11.1z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M686.7 638.6L544.1 535.5V288c0-4.4-3.6-8-8-8H488c-4.4 0-8 3.6-8 8v275.3c0 2.6 1.2 5 3.3 6.5l165.4 120.6c3.6 2.6 8.6 1.9 11.2-1.7l28.6-39c2.6-3.6 1.8-8.6-1.8-11.1z", "fill": primaryColor } }] }; }, "name": "clock-circle", "theme": "twotone" };
  exports.default = ClockCircleTwoTone;
  });

  var ClockCircleTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(ClockCircleTwoTone_1);

  var ClockCircleTwoTone = function ClockCircleTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ClockCircleTwoToneSvg
    }));
  };
  var RefIcon$25 = /*#__PURE__*/React.forwardRef(ClockCircleTwoTone);
  {
    RefIcon$25.displayName = 'ClockCircleTwoTone';
  }

  var CloseCircleFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CloseCircleFilled = { "icon": { "tag": "svg", "attrs": { "fill-rule": "evenodd", "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64c247.4 0 448 200.6 448 448S759.4 960 512 960 64 759.4 64 512 264.6 64 512 64zm127.98 274.82h-.04l-.08.06L512 466.75 384.14 338.88c-.04-.05-.06-.06-.08-.06a.12.12 0 00-.07 0c-.03 0-.05.01-.09.05l-45.02 45.02a.2.2 0 00-.05.09.12.12 0 000 .07v.02a.27.27 0 00.06.06L466.75 512 338.88 639.86c-.05.04-.06.06-.06.08a.12.12 0 000 .07c0 .03.01.05.05.09l45.02 45.02a.2.2 0 00.09.05.12.12 0 00.07 0c.02 0 .04-.01.08-.05L512 557.25l127.86 127.87c.04.04.06.05.08.05a.12.12 0 00.07 0c.03 0 .05-.01.09-.05l45.02-45.02a.2.2 0 00.05-.09.12.12 0 000-.07v-.02a.27.27 0 00-.05-.06L557.25 512l127.87-127.86c.04-.04.05-.06.05-.08a.12.12 0 000-.07c0-.03-.01-.05-.05-.09l-45.02-45.02a.2.2 0 00-.09-.05.12.12 0 00-.07 0z" } }] }, "name": "close-circle", "theme": "filled" };
  exports.default = CloseCircleFilled;
  });

  var CloseCircleFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(CloseCircleFilled_1);

  var CloseCircleFilled = function CloseCircleFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CloseCircleFilledSvg
    }));
  };
  var RefIcon$26 = /*#__PURE__*/React.forwardRef(CloseCircleFilled);
  {
    RefIcon$26.displayName = 'CloseCircleFilled';
  }

  var CloseCircleOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CloseCircleOutlined = { "icon": { "tag": "svg", "attrs": { "fill-rule": "evenodd", "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64c247.4 0 448 200.6 448 448S759.4 960 512 960 64 759.4 64 512 264.6 64 512 64zm0 76c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm128.01 198.83c.03 0 .05.01.09.06l45.02 45.01a.2.2 0 01.05.09.12.12 0 010 .07c0 .02-.01.04-.05.08L557.25 512l127.87 127.86a.27.27 0 01.05.06v.02a.12.12 0 010 .07c0 .03-.01.05-.05.09l-45.02 45.02a.2.2 0 01-.09.05.12.12 0 01-.07 0c-.02 0-.04-.01-.08-.05L512 557.25 384.14 685.12c-.04.04-.06.05-.08.05a.12.12 0 01-.07 0c-.03 0-.05-.01-.09-.05l-45.02-45.02a.2.2 0 01-.05-.09.12.12 0 010-.07c0-.02.01-.04.06-.08L466.75 512 338.88 384.14a.27.27 0 01-.05-.06l-.01-.02a.12.12 0 010-.07c0-.03.01-.05.05-.09l45.02-45.02a.2.2 0 01.09-.05.12.12 0 01.07 0c.02 0 .04.01.08.06L512 466.75l127.86-127.86c.04-.05.06-.06.08-.06a.12.12 0 01.07 0z" } }] }, "name": "close-circle", "theme": "outlined" };
  exports.default = CloseCircleOutlined;
  });

  var CloseCircleOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(CloseCircleOutlined_1);

  var CloseCircleOutlined = function CloseCircleOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CloseCircleOutlinedSvg
    }));
  };
  var RefIcon$27 = /*#__PURE__*/React.forwardRef(CloseCircleOutlined);
  {
    RefIcon$27.displayName = 'CloseCircleOutlined';
  }

  var CloseCircleTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CloseCircleTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm171.8 527.1c1.2 1.5 1.9 3.3 1.9 5.2 0 4.5-3.6 8-8 8l-66-.3-99.3-118.4-99.3 118.5-66.1.3c-4.4 0-8-3.6-8-8 0-1.9.7-3.7 1.9-5.2L471 512.3l-130.1-155a8.32 8.32 0 01-1.9-5.2c0-4.5 3.6-8 8-8l66.1.3 99.3 118.4 99.4-118.5 66-.3c4.4 0 8 3.6 8 8 0 1.9-.6 3.8-1.8 5.2l-130.1 155 129.9 154.9z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M685.8 352c0-4.4-3.6-8-8-8l-66 .3-99.4 118.5-99.3-118.4-66.1-.3c-4.4 0-8 3.5-8 8 0 1.9.7 3.7 1.9 5.2l130.1 155-130.1 154.9a8.32 8.32 0 00-1.9 5.2c0 4.4 3.6 8 8 8l66.1-.3 99.3-118.5L611.7 680l66 .3c4.4 0 8-3.5 8-8 0-1.9-.7-3.7-1.9-5.2L553.9 512.2l130.1-155c1.2-1.4 1.8-3.3 1.8-5.2z", "fill": primaryColor } }] }; }, "name": "close-circle", "theme": "twotone" };
  exports.default = CloseCircleTwoTone;
  });

  var CloseCircleTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(CloseCircleTwoTone_1);

  var CloseCircleTwoTone = function CloseCircleTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CloseCircleTwoToneSvg
    }));
  };
  var RefIcon$28 = /*#__PURE__*/React.forwardRef(CloseCircleTwoTone);
  {
    RefIcon$28.displayName = 'CloseCircleTwoTone';
  }

  var CloseOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CloseOutlined = { "icon": { "tag": "svg", "attrs": { "fill-rule": "evenodd", "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M799.86 166.31c.02 0 .04.02.08.06l57.69 57.7c.04.03.05.05.06.08a.12.12 0 010 .06c0 .03-.02.05-.06.09L569.93 512l287.7 287.7c.04.04.05.06.06.09a.12.12 0 010 .07c0 .02-.02.04-.06.08l-57.7 57.69c-.03.04-.05.05-.07.06a.12.12 0 01-.07 0c-.03 0-.05-.02-.09-.06L512 569.93l-287.7 287.7c-.04.04-.06.05-.09.06a.12.12 0 01-.07 0c-.02 0-.04-.02-.08-.06l-57.69-57.7c-.04-.03-.05-.05-.06-.07a.12.12 0 010-.07c0-.03.02-.05.06-.09L454.07 512l-287.7-287.7c-.04-.04-.05-.06-.06-.09a.12.12 0 010-.07c0-.02.02-.04.06-.08l57.7-57.69c.03-.04.05-.05.07-.06a.12.12 0 01.07 0c.03 0 .05.02.09.06L512 454.07l287.7-287.7c.04-.04.06-.05.09-.06a.12.12 0 01.07 0z" } }] }, "name": "close", "theme": "outlined" };
  exports.default = CloseOutlined;
  });

  var CloseOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(CloseOutlined_1);

  var CloseOutlined = function CloseOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CloseOutlinedSvg
    }));
  };
  var RefIcon$29 = /*#__PURE__*/React.forwardRef(CloseOutlined);
  {
    RefIcon$29.displayName = 'CloseOutlined';
  }

  var CloseSquareFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CloseSquareFilled = { "icon": { "tag": "svg", "attrs": { "fill-rule": "evenodd", "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112c17.7 0 32 14.3 32 32v736c0 17.7-14.3 32-32 32H144c-17.7 0-32-14.3-32-32V144c0-17.7 14.3-32 32-32zM639.98 338.82h-.04l-.08.06L512 466.75 384.14 338.88c-.04-.05-.06-.06-.08-.06a.12.12 0 00-.07 0c-.03 0-.05.01-.09.05l-45.02 45.02a.2.2 0 00-.05.09.12.12 0 000 .07v.02a.27.27 0 00.06.06L466.75 512 338.88 639.86c-.05.04-.06.06-.06.08a.12.12 0 000 .07c0 .03.01.05.05.09l45.02 45.02a.2.2 0 00.09.05.12.12 0 00.07 0c.02 0 .04-.01.08-.05L512 557.25l127.86 127.87c.04.04.06.05.08.05a.12.12 0 00.07 0c.03 0 .05-.01.09-.05l45.02-45.02a.2.2 0 00.05-.09.12.12 0 000-.07v-.02a.27.27 0 00-.05-.06L557.25 512l127.87-127.86c.04-.04.05-.06.05-.08a.12.12 0 000-.07c0-.03-.01-.05-.05-.09l-45.02-45.02a.2.2 0 00-.09-.05.12.12 0 00-.07 0z" } }] }, "name": "close-square", "theme": "filled" };
  exports.default = CloseSquareFilled;
  });

  var CloseSquareFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(CloseSquareFilled_1);

  var CloseSquareFilled = function CloseSquareFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CloseSquareFilledSvg
    }));
  };
  var RefIcon$2a = /*#__PURE__*/React.forwardRef(CloseSquareFilled);
  {
    RefIcon$2a.displayName = 'CloseSquareFilled';
  }

  var CloseSquareOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CloseSquareOutlined = { "icon": { "tag": "svg", "attrs": { "fill-rule": "evenodd", "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112c17.7 0 32 14.3 32 32v736c0 17.7-14.3 32-32 32H144c-17.7 0-32-14.3-32-32V144c0-17.7 14.3-32 32-32zm-40 72H184v656h656V184zM640.01 338.83c.03 0 .05.01.09.06l45.02 45.01a.2.2 0 01.05.09.12.12 0 010 .07c0 .02-.01.04-.05.08L557.25 512l127.87 127.86a.27.27 0 01.05.06v.02a.12.12 0 010 .07c0 .03-.01.05-.05.09l-45.02 45.02a.2.2 0 01-.09.05.12.12 0 01-.07 0c-.02 0-.04-.01-.08-.05L512 557.25 384.14 685.12c-.04.04-.06.05-.08.05a.12.12 0 01-.07 0c-.03 0-.05-.01-.09-.05l-45.02-45.02a.2.2 0 01-.05-.09.12.12 0 010-.07c0-.02.01-.04.06-.08L466.75 512 338.88 384.14a.27.27 0 01-.05-.06l-.01-.02a.12.12 0 010-.07c0-.03.01-.05.05-.09l45.02-45.02a.2.2 0 01.09-.05.12.12 0 01.07 0c.02 0 .04.01.08.06L512 466.75l127.86-127.86c.04-.05.06-.06.08-.06a.12.12 0 01.07 0z" } }] }, "name": "close-square", "theme": "outlined" };
  exports.default = CloseSquareOutlined;
  });

  var CloseSquareOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(CloseSquareOutlined_1);

  var CloseSquareOutlined = function CloseSquareOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CloseSquareOutlinedSvg
    }));
  };
  var RefIcon$2b = /*#__PURE__*/React.forwardRef(CloseSquareOutlined);
  {
    RefIcon$2b.displayName = 'CloseSquareOutlined';
  }

  var CloseSquareTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CloseSquareTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M184 840h656V184H184v656zm163.9-473.9A7.95 7.95 0 01354 353h58.9c4.7 0 9.2 2.1 12.3 5.7L512 462.2l86.8-103.5c3-3.6 7.5-5.7 12.3-5.7H670c6.8 0 10.5 7.9 6.1 13.1L553.8 512l122.3 145.9c4.4 5.2.7 13.1-6.1 13.1h-58.9c-4.7 0-9.2-2.1-12.3-5.7L512 561.8l-86.8 103.5c-3 3.6-7.5 5.7-12.3 5.7H354c-6.8 0-10.5-7.9-6.1-13.1L470.2 512 347.9 366.1z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M354 671h58.9c4.8 0 9.3-2.1 12.3-5.7L512 561.8l86.8 103.5c3.1 3.6 7.6 5.7 12.3 5.7H670c6.8 0 10.5-7.9 6.1-13.1L553.8 512l122.3-145.9c4.4-5.2.7-13.1-6.1-13.1h-58.9c-4.8 0-9.3 2.1-12.3 5.7L512 462.2l-86.8-103.5c-3.1-3.6-7.6-5.7-12.3-5.7H354c-6.8 0-10.5 7.9-6.1 13.1L470.2 512 347.9 657.9A7.95 7.95 0 00354 671z", "fill": primaryColor } }] }; }, "name": "close-square", "theme": "twotone" };
  exports.default = CloseSquareTwoTone;
  });

  var CloseSquareTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(CloseSquareTwoTone_1);

  var CloseSquareTwoTone = function CloseSquareTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CloseSquareTwoToneSvg
    }));
  };
  var RefIcon$2c = /*#__PURE__*/React.forwardRef(CloseSquareTwoTone);
  {
    RefIcon$2c.displayName = 'CloseSquareTwoTone';
  }

  var CloudDownloadOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CloudDownloadOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M624 706.3h-74.1V464c0-4.4-3.6-8-8-8h-60c-4.4 0-8 3.6-8 8v242.3H400c-6.7 0-10.4 7.7-6.3 12.9l112 141.7a8 8 0 0012.6 0l112-141.7c4.1-5.2.4-12.9-6.3-12.9z" } }, { "tag": "path", "attrs": { "d": "M811.4 366.7C765.6 245.9 648.9 160 512.2 160S258.8 245.8 213 366.6C127.3 389.1 64 467.2 64 560c0 110.5 89.5 200 199.9 200H304c4.4 0 8-3.6 8-8v-60c0-4.4-3.6-8-8-8h-40.1c-33.7 0-65.4-13.4-89-37.7-23.5-24.2-36-56.8-34.9-90.6.9-26.4 9.9-51.2 26.2-72.1 16.7-21.3 40.1-36.8 66.1-43.7l37.9-9.9 13.9-36.6c8.6-22.8 20.6-44.1 35.7-63.4a245.6 245.6 0 0152.4-49.9c41.1-28.9 89.5-44.2 140-44.2s98.9 15.3 140 44.2c19.9 14 37.5 30.8 52.4 49.9 15.1 19.3 27.1 40.7 35.7 63.4l13.8 36.5 37.8 10C846.1 454.5 884 503.8 884 560c0 33.1-12.9 64.3-36.3 87.7a123.07 123.07 0 01-87.6 36.3H720c-4.4 0-8 3.6-8 8v60c0 4.4 3.6 8 8 8h40.1C870.5 760 960 670.5 960 560c0-92.7-63.1-170.7-148.6-193.3z" } }] }, "name": "cloud-download", "theme": "outlined" };
  exports.default = CloudDownloadOutlined;
  });

  var CloudDownloadOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(CloudDownloadOutlined_1);

  var CloudDownloadOutlined = function CloudDownloadOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CloudDownloadOutlinedSvg
    }));
  };
  var RefIcon$2d = /*#__PURE__*/React.forwardRef(CloudDownloadOutlined);
  {
    RefIcon$2d.displayName = 'CloudDownloadOutlined';
  }

  var CloudFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CloudFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M811.4 418.7C765.6 297.9 648.9 212 512.2 212S258.8 297.8 213 418.6C127.3 441.1 64 519.1 64 612c0 110.5 89.5 200 199.9 200h496.2C870.5 812 960 722.5 960 612c0-92.7-63.1-170.7-148.6-193.3z" } }] }, "name": "cloud", "theme": "filled" };
  exports.default = CloudFilled;
  });

  var CloudFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(CloudFilled_1);

  var CloudFilled = function CloudFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CloudFilledSvg
    }));
  };
  var RefIcon$2e = /*#__PURE__*/React.forwardRef(CloudFilled);
  {
    RefIcon$2e.displayName = 'CloudFilled';
  }

  var CloudOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CloudOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M811.4 418.7C765.6 297.9 648.9 212 512.2 212S258.8 297.8 213 418.6C127.3 441.1 64 519.1 64 612c0 110.5 89.5 200 199.9 200h496.2C870.5 812 960 722.5 960 612c0-92.7-63.1-170.7-148.6-193.3zm36.3 281a123.07 123.07 0 01-87.6 36.3H263.9c-33.1 0-64.2-12.9-87.6-36.3A123.3 123.3 0 01140 612c0-28 9.1-54.3 26.2-76.3a125.7 125.7 0 0166.1-43.7l37.9-9.9 13.9-36.6c8.6-22.8 20.6-44.1 35.7-63.4a245.6 245.6 0 0152.4-49.9c41.1-28.9 89.5-44.2 140-44.2s98.9 15.3 140 44.2c19.9 14 37.5 30.8 52.4 49.9 15.1 19.3 27.1 40.7 35.7 63.4l13.8 36.5 37.8 10c54.3 14.5 92.1 63.8 92.1 120 0 33.1-12.9 64.3-36.3 87.7z" } }] }, "name": "cloud", "theme": "outlined" };
  exports.default = CloudOutlined;
  });

  var CloudOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(CloudOutlined_1);

  var CloudOutlined = function CloudOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CloudOutlinedSvg
    }));
  };
  var RefIcon$2f = /*#__PURE__*/React.forwardRef(CloudOutlined);
  {
    RefIcon$2f.displayName = 'CloudOutlined';
  }

  var CloudServerOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CloudServerOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M704 446H320c-4.4 0-8 3.6-8 8v402c0 4.4 3.6 8 8 8h384c4.4 0 8-3.6 8-8V454c0-4.4-3.6-8-8-8zm-328 64h272v117H376V510zm272 290H376V683h272v117z" } }, { "tag": "path", "attrs": { "d": "M424 748a32 32 0 1064 0 32 32 0 10-64 0zm0-178a32 32 0 1064 0 32 32 0 10-64 0z" } }, { "tag": "path", "attrs": { "d": "M811.4 368.9C765.6 248 648.9 162 512.2 162S258.8 247.9 213 368.8C126.9 391.5 63.5 470.2 64 563.6 64.6 668 145.6 752.9 247.6 762c4.7.4 8.7-3.3 8.7-8v-60.4c0-4-3-7.4-7-7.9-27-3.4-52.5-15.2-72.1-34.5-24-23.5-37.2-55.1-37.2-88.6 0-28 9.1-54.4 26.2-76.4 16.7-21.4 40.2-36.9 66.1-43.7l37.9-10 13.9-36.7c8.6-22.8 20.6-44.2 35.7-63.5 14.9-19.2 32.6-36 52.4-50 41.1-28.9 89.5-44.2 140-44.2s98.9 15.3 140 44.3c19.9 14 37.5 30.8 52.4 50 15.1 19.3 27.1 40.7 35.7 63.5l13.8 36.6 37.8 10c54.2 14.4 92.1 63.7 92.1 120 0 33.6-13.2 65.1-37.2 88.6-19.5 19.2-44.9 31.1-71.9 34.5-4 .5-6.9 3.9-6.9 7.9V754c0 4.7 4.1 8.4 8.8 8 101.7-9.2 182.5-94 183.2-198.2.6-93.4-62.7-172.1-148.6-194.9z" } }] }, "name": "cloud-server", "theme": "outlined" };
  exports.default = CloudServerOutlined;
  });

  var CloudServerOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(CloudServerOutlined_1);

  var CloudServerOutlined = function CloudServerOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CloudServerOutlinedSvg
    }));
  };
  var RefIcon$2g = /*#__PURE__*/React.forwardRef(CloudServerOutlined);
  {
    RefIcon$2g.displayName = 'CloudServerOutlined';
  }

  var CloudSyncOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CloudSyncOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M811.4 368.9C765.6 248 648.9 162 512.2 162S258.8 247.9 213 368.8C126.9 391.5 63.5 470.2 64 563.6 64.6 668 145.6 752.9 247.6 762c4.7.4 8.7-3.3 8.7-8v-60.4c0-4-3-7.4-7-7.9-27-3.4-52.5-15.2-72.1-34.5-24-23.5-37.2-55.1-37.2-88.6 0-28 9.1-54.4 26.2-76.4 16.7-21.4 40.2-36.9 66.1-43.7l37.9-10 13.9-36.7c8.6-22.8 20.6-44.2 35.7-63.5 14.9-19.2 32.6-36 52.4-50 41.1-28.9 89.5-44.2 140-44.2s98.9 15.3 140 44.3c19.9 14 37.5 30.8 52.4 50 15.1 19.3 27.1 40.7 35.7 63.5l13.8 36.6 37.8 10c54.2 14.4 92.1 63.7 92.1 120 0 33.6-13.2 65.1-37.2 88.6-19.5 19.2-44.9 31.1-71.9 34.5-4 .5-6.9 3.9-6.9 7.9V754c0 4.7 4.1 8.4 8.8 8 101.7-9.2 182.5-94 183.2-198.2.6-93.4-62.7-172.1-148.6-194.9z" } }, { "tag": "path", "attrs": { "d": "M376.9 656.4c1.8-33.5 15.7-64.7 39.5-88.6 25.4-25.5 60-39.8 96-39.8 36.2 0 70.3 14.1 96 39.8 1.4 1.4 2.7 2.8 4.1 4.3l-25 19.6a8 8 0 003 14.1l98.2 24c5 1.2 9.9-2.6 9.9-7.7l.5-101.3c0-6.7-7.6-10.5-12.9-6.3L663 532.7c-36.6-42-90.4-68.6-150.5-68.6-107.4 0-195 85.1-199.4 191.7-.2 4.5 3.4 8.3 8 8.3H369c4.2-.1 7.7-3.4 7.9-7.7zM703 664h-47.9c-4.2 0-7.7 3.3-8 7.6-1.8 33.5-15.7 64.7-39.5 88.6-25.4 25.5-60 39.8-96 39.8-36.2 0-70.3-14.1-96-39.8-1.4-1.4-2.7-2.8-4.1-4.3l25-19.6a8 8 0 00-3-14.1l-98.2-24c-5-1.2-9.9 2.6-9.9 7.7l-.4 101.4c0 6.7 7.6 10.5 12.9 6.3l23.2-18.2c36.6 42 90.4 68.6 150.5 68.6 107.4 0 195-85.1 199.4-191.7.2-4.5-3.4-8.3-8-8.3z" } }] }, "name": "cloud-sync", "theme": "outlined" };
  exports.default = CloudSyncOutlined;
  });

  var CloudSyncOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(CloudSyncOutlined_1);

  var CloudSyncOutlined = function CloudSyncOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CloudSyncOutlinedSvg
    }));
  };
  var RefIcon$2h = /*#__PURE__*/React.forwardRef(CloudSyncOutlined);
  {
    RefIcon$2h.displayName = 'CloudSyncOutlined';
  }

  var CloudTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CloudTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M791.9 492l-37.8-10-13.8-36.5c-8.6-22.7-20.6-44.1-35.7-63.4a245.73 245.73 0 00-52.4-49.9c-41.1-28.9-89.5-44.2-140-44.2s-98.9 15.3-140 44.2a245.6 245.6 0 00-52.4 49.9 240.47 240.47 0 00-35.7 63.4l-13.9 36.6-37.9 9.9a125.7 125.7 0 00-66.1 43.7A123.1 123.1 0 00140 612c0 33.1 12.9 64.3 36.3 87.7 23.4 23.4 54.5 36.3 87.6 36.3h496.2c33.1 0 64.2-12.9 87.6-36.3A123.3 123.3 0 00884 612c0-56.2-37.8-105.5-92.1-120z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M811.4 418.7C765.6 297.9 648.9 212 512.2 212S258.8 297.8 213 418.6C127.3 441.1 64 519.1 64 612c0 110.5 89.5 200 199.9 200h496.2C870.5 812 960 722.5 960 612c0-92.7-63.1-170.7-148.6-193.3zm36.3 281a123.07 123.07 0 01-87.6 36.3H263.9c-33.1 0-64.2-12.9-87.6-36.3A123.3 123.3 0 01140 612c0-28 9.1-54.3 26.2-76.3a125.7 125.7 0 0166.1-43.7l37.9-9.9 13.9-36.6c8.6-22.8 20.6-44.1 35.7-63.4a245.6 245.6 0 0152.4-49.9c41.1-28.9 89.5-44.2 140-44.2s98.9 15.3 140 44.2c19.9 14 37.5 30.8 52.4 49.9 15.1 19.3 27.1 40.7 35.7 63.4l13.8 36.5 37.8 10c54.3 14.5 92.1 63.8 92.1 120 0 33.1-12.9 64.3-36.3 87.7z", "fill": primaryColor } }] }; }, "name": "cloud", "theme": "twotone" };
  exports.default = CloudTwoTone;
  });

  var CloudTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(CloudTwoTone_1);

  var CloudTwoTone = function CloudTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CloudTwoToneSvg
    }));
  };
  var RefIcon$2i = /*#__PURE__*/React.forwardRef(CloudTwoTone);
  {
    RefIcon$2i.displayName = 'CloudTwoTone';
  }

  var CloudUploadOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CloudUploadOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M518.3 459a8 8 0 00-12.6 0l-112 141.7a7.98 7.98 0 006.3 12.9h73.9V856c0 4.4 3.6 8 8 8h60c4.4 0 8-3.6 8-8V613.7H624c6.7 0 10.4-7.7 6.3-12.9L518.3 459z" } }, { "tag": "path", "attrs": { "d": "M811.4 366.7C765.6 245.9 648.9 160 512.2 160S258.8 245.8 213 366.6C127.3 389.1 64 467.2 64 560c0 110.5 89.5 200 199.9 200H304c4.4 0 8-3.6 8-8v-60c0-4.4-3.6-8-8-8h-40.1c-33.7 0-65.4-13.4-89-37.7-23.5-24.2-36-56.8-34.9-90.6.9-26.4 9.9-51.2 26.2-72.1 16.7-21.3 40.1-36.8 66.1-43.7l37.9-9.9 13.9-36.6c8.6-22.8 20.6-44.1 35.7-63.4a245.6 245.6 0 0152.4-49.9c41.1-28.9 89.5-44.2 140-44.2s98.9 15.3 140 44.2c19.9 14 37.5 30.8 52.4 49.9 15.1 19.3 27.1 40.7 35.7 63.4l13.8 36.5 37.8 10C846.1 454.5 884 503.8 884 560c0 33.1-12.9 64.3-36.3 87.7a123.07 123.07 0 01-87.6 36.3H720c-4.4 0-8 3.6-8 8v60c0 4.4 3.6 8 8 8h40.1C870.5 760 960 670.5 960 560c0-92.7-63.1-170.7-148.6-193.3z" } }] }, "name": "cloud-upload", "theme": "outlined" };
  exports.default = CloudUploadOutlined;
  });

  var CloudUploadOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(CloudUploadOutlined_1);

  var CloudUploadOutlined = function CloudUploadOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CloudUploadOutlinedSvg
    }));
  };
  var RefIcon$2j = /*#__PURE__*/React.forwardRef(CloudUploadOutlined);
  {
    RefIcon$2j.displayName = 'CloudUploadOutlined';
  }

  var ClusterOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ClusterOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M888 680h-54V540H546v-92h238c8.8 0 16-7.2 16-16V168c0-8.8-7.2-16-16-16H240c-8.8 0-16 7.2-16 16v264c0 8.8 7.2 16 16 16h238v92H190v140h-54c-4.4 0-8 3.6-8 8v176c0 4.4 3.6 8 8 8h176c4.4 0 8-3.6 8-8V688c0-4.4-3.6-8-8-8h-54v-72h220v72h-54c-4.4 0-8 3.6-8 8v176c0 4.4 3.6 8 8 8h176c4.4 0 8-3.6 8-8V688c0-4.4-3.6-8-8-8h-54v-72h220v72h-54c-4.4 0-8 3.6-8 8v176c0 4.4 3.6 8 8 8h176c4.4 0 8-3.6 8-8V688c0-4.4-3.6-8-8-8zM256 805.3c0 1.5-1.2 2.7-2.7 2.7h-58.7c-1.5 0-2.7-1.2-2.7-2.7v-58.7c0-1.5 1.2-2.7 2.7-2.7h58.7c1.5 0 2.7 1.2 2.7 2.7v58.7zm288 0c0 1.5-1.2 2.7-2.7 2.7h-58.7c-1.5 0-2.7-1.2-2.7-2.7v-58.7c0-1.5 1.2-2.7 2.7-2.7h58.7c1.5 0 2.7 1.2 2.7 2.7v58.7zM288 384V216h448v168H288zm544 421.3c0 1.5-1.2 2.7-2.7 2.7h-58.7c-1.5 0-2.7-1.2-2.7-2.7v-58.7c0-1.5 1.2-2.7 2.7-2.7h58.7c1.5 0 2.7 1.2 2.7 2.7v58.7zM360 300a40 40 0 1080 0 40 40 0 10-80 0z" } }] }, "name": "cluster", "theme": "outlined" };
  exports.default = ClusterOutlined;
  });

  var ClusterOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(ClusterOutlined_1);

  var ClusterOutlined = function ClusterOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ClusterOutlinedSvg
    }));
  };
  var RefIcon$2k = /*#__PURE__*/React.forwardRef(ClusterOutlined);
  {
    RefIcon$2k.displayName = 'ClusterOutlined';
  }

  var CodeFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CodeFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM513.1 518.1l-192 161c-5.2 4.4-13.1.7-13.1-6.1v-62.7c0-2.3 1.1-4.6 2.9-6.1L420.7 512l-109.8-92.2a7.63 7.63 0 01-2.9-6.1V351c0-6.8 7.9-10.5 13.1-6.1l192 160.9c3.9 3.2 3.9 9.1 0 12.3zM716 673c0 4.4-3.4 8-7.5 8h-185c-4.1 0-7.5-3.6-7.5-8v-48c0-4.4 3.4-8 7.5-8h185c4.1 0 7.5 3.6 7.5 8v48z" } }] }, "name": "code", "theme": "filled" };
  exports.default = CodeFilled;
  });

  var CodeFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(CodeFilled_1);

  var CodeFilled = function CodeFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CodeFilledSvg
    }));
  };
  var RefIcon$2l = /*#__PURE__*/React.forwardRef(CodeFilled);
  {
    RefIcon$2l.displayName = 'CodeFilled';
  }

  var CodeOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CodeOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M516 673c0 4.4 3.4 8 7.5 8h185c4.1 0 7.5-3.6 7.5-8v-48c0-4.4-3.4-8-7.5-8h-185c-4.1 0-7.5 3.6-7.5 8v48zm-194.9 6.1l192-161c3.8-3.2 3.8-9.1 0-12.3l-192-160.9A7.95 7.95 0 00308 351v62.7c0 2.4 1 4.6 2.9 6.1L420.7 512l-109.8 92.2a8.1 8.1 0 00-2.9 6.1V673c0 6.8 7.9 10.5 13.1 6.1zM880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z" } }] }, "name": "code", "theme": "outlined" };
  exports.default = CodeOutlined;
  });

  var CodeOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(CodeOutlined_1);

  var CodeOutlined = function CodeOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CodeOutlinedSvg
    }));
  };
  var RefIcon$2m = /*#__PURE__*/React.forwardRef(CodeOutlined);
  {
    RefIcon$2m.displayName = 'CodeOutlined';
  }

  var CodeSandboxCircleFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CodeSandboxCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm243.7 589.2L512 794 268.3 653.2V371.8l110-63.6-.4-.2h.2L512 231l134 77h-.2l-.3.2 110.1 63.6v281.4zM307.9 536.7l87.6 49.9V681l96.7 55.9V524.8L307.9 418.4zm203.9-151.8L418 331l-91.1 52.6 185.2 107 185.2-106.9-91.4-52.8zm20 352l97.3-56.2v-94.1l87-49.5V418.5L531.8 525z" } }] }, "name": "code-sandbox-circle", "theme": "filled" };
  exports.default = CodeSandboxCircleFilled;
  });

  var CodeSandboxCircleFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(CodeSandboxCircleFilled_1);

  var CodeSandboxCircleFilled = function CodeSandboxCircleFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CodeSandboxCircleFilledSvg
    }));
  };
  var RefIcon$2n = /*#__PURE__*/React.forwardRef(CodeSandboxCircleFilled);
  {
    RefIcon$2n.displayName = 'CodeSandboxCircleFilled';
  }

  var CodeSandboxOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CodeSandboxOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M709.6 210l.4-.2h.2L512 96 313.9 209.8h-.2l.7.3L151.5 304v416L512 928l360.5-208V304l-162.9-94zM482.7 843.6L339.6 761V621.4L210 547.8V372.9l272.7 157.3v313.4zM238.2 321.5l134.7-77.8 138.9 79.7 139.1-79.9 135.2 78-273.9 158-274-158zM814 548.3l-128.8 73.1v139.1l-143.9 83V530.4L814 373.1v175.2z" } }] }, "name": "code-sandbox", "theme": "outlined" };
  exports.default = CodeSandboxOutlined;
  });

  var CodeSandboxOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(CodeSandboxOutlined_1);

  var CodeSandboxOutlined = function CodeSandboxOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CodeSandboxOutlinedSvg
    }));
  };
  var RefIcon$2o = /*#__PURE__*/React.forwardRef(CodeSandboxOutlined);
  {
    RefIcon$2o.displayName = 'CodeSandboxOutlined';
  }

  var CodeSandboxSquareFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CodeSandboxSquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M307.9 536.7l87.6 49.9V681l96.7 55.9V524.8L307.9 418.4zM880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM755.7 653.2L512 794 268.3 653.2V371.8l110-63.6-.4-.2h.2L512 231l134 77h-.2l-.3.2 110.1 63.6v281.4zm-223.9 83.7l97.3-56.2v-94.1l87-49.5V418.5L531.8 525zm-20-352L418 331l-91.1 52.6 185.2 107 185.2-106.9-91.4-52.8z" } }] }, "name": "code-sandbox-square", "theme": "filled" };
  exports.default = CodeSandboxSquareFilled;
  });

  var CodeSandboxSquareFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(CodeSandboxSquareFilled_1);

  var CodeSandboxSquareFilled = function CodeSandboxSquareFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CodeSandboxSquareFilledSvg
    }));
  };
  var RefIcon$2p = /*#__PURE__*/React.forwardRef(CodeSandboxSquareFilled);
  {
    RefIcon$2p.displayName = 'CodeSandboxSquareFilled';
  }

  var CodeTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CodeTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M184 840h656V184H184v656zm339.5-223h185c4.1 0 7.5 3.6 7.5 8v48c0 4.4-3.4 8-7.5 8h-185c-4.1 0-7.5-3.6-7.5-8v-48c0-4.4 3.4-8 7.5-8zM308 610.3c0-2.3 1.1-4.6 2.9-6.1L420.7 512l-109.8-92.2a7.63 7.63 0 01-2.9-6.1V351c0-6.8 7.9-10.5 13.1-6.1l192 160.9c3.9 3.2 3.9 9.1 0 12.3l-192 161c-5.2 4.4-13.1.7-13.1-6.1v-62.7z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M321.1 679.1l192-161c3.9-3.2 3.9-9.1 0-12.3l-192-160.9A7.95 7.95 0 00308 351v62.7c0 2.4 1 4.6 2.9 6.1L420.7 512l-109.8 92.2a8.1 8.1 0 00-2.9 6.1V673c0 6.8 7.9 10.5 13.1 6.1zM516 673c0 4.4 3.4 8 7.5 8h185c4.1 0 7.5-3.6 7.5-8v-48c0-4.4-3.4-8-7.5-8h-185c-4.1 0-7.5 3.6-7.5 8v48z", "fill": primaryColor } }] }; }, "name": "code", "theme": "twotone" };
  exports.default = CodeTwoTone;
  });

  var CodeTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(CodeTwoTone_1);

  var CodeTwoTone = function CodeTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CodeTwoToneSvg
    }));
  };
  var RefIcon$2q = /*#__PURE__*/React.forwardRef(CodeTwoTone);
  {
    RefIcon$2q.displayName = 'CodeTwoTone';
  }

  var CodepenCircleFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CodepenCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M488.1 414.7V303.4L300.9 428l83.6 55.8zm254.1 137.7v-79.8l-59.8 39.9zM512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm278 533c0 1.1-.1 2.1-.2 3.1 0 .4-.1.7-.2 1a14.16 14.16 0 01-.8 3.2c-.2.6-.4 1.2-.6 1.7-.2.4-.4.8-.5 1.2-.3.5-.5 1.1-.8 1.6-.2.4-.4.7-.7 1.1-.3.5-.7 1-1 1.5-.3.4-.5.7-.8 1-.4.4-.8.9-1.2 1.3-.3.3-.6.6-1 .9-.4.4-.9.8-1.4 1.1-.4.3-.7.6-1.1.8-.1.1-.3.2-.4.3L525.2 786c-4 2.7-8.6 4-13.2 4-4.7 0-9.3-1.4-13.3-4L244.6 616.9c-.1-.1-.3-.2-.4-.3l-1.1-.8c-.5-.4-.9-.7-1.3-1.1-.3-.3-.6-.6-1-.9-.4-.4-.8-.8-1.2-1.3a7 7 0 01-.8-1c-.4-.5-.7-1-1-1.5-.2-.4-.5-.7-.7-1.1-.3-.5-.6-1.1-.8-1.6-.2-.4-.4-.8-.5-1.2-.2-.6-.4-1.2-.6-1.7-.1-.4-.3-.8-.4-1.2-.2-.7-.3-1.3-.4-2-.1-.3-.1-.7-.2-1-.1-1-.2-2.1-.2-3.1V427.9c0-1 .1-2.1.2-3.1.1-.3.1-.7.2-1a14.16 14.16 0 01.8-3.2c.2-.6.4-1.2.6-1.7.2-.4.4-.8.5-1.2.2-.5.5-1.1.8-1.6.2-.4.4-.7.7-1.1.6-.9 1.2-1.7 1.8-2.5.4-.4.8-.9 1.2-1.3.3-.3.6-.6 1-.9.4-.4.9-.8 1.3-1.1.4-.3.7-.6 1.1-.8.1-.1.3-.2.4-.3L498.7 239c8-5.3 18.5-5.3 26.5 0l254.1 169.1c.1.1.3.2.4.3l1.1.8 1.4 1.1c.3.3.6.6 1 .9.4.4.8.8 1.2 1.3.7.8 1.3 1.6 1.8 2.5.2.4.5.7.7 1.1.3.5.6 1 .8 1.6.2.4.4.8.5 1.2.2.6.4 1.2.6 1.7.1.4.3.8.4 1.2.2.7.3 1.3.4 2 .1.3.1.7.2 1 .1 1 .2 2.1.2 3.1V597zm-254.1 13.3v111.3L723.1 597l-83.6-55.8zM281.8 472.6v79.8l59.8-39.9zM512 456.1l-84.5 56.4 84.5 56.4 84.5-56.4zM723.1 428L535.9 303.4v111.3l103.6 69.1zM384.5 541.2L300.9 597l187.2 124.6V610.3l-103.6-69.1z" } }] }, "name": "codepen-circle", "theme": "filled" };
  exports.default = CodepenCircleFilled;
  });

  var CodepenCircleFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(CodepenCircleFilled_1);

  var CodepenCircleFilled = function CodepenCircleFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CodepenCircleFilledSvg
    }));
  };
  var RefIcon$2r = /*#__PURE__*/React.forwardRef(CodepenCircleFilled);
  {
    RefIcon$2r.displayName = 'CodepenCircleFilled';
  }

  var CodepenCircleOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CodepenCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M488.1 414.7V303.4L300.9 428l83.6 55.8zm254.1 137.7v-79.8l-59.8 39.9zM512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm278 533c0 1.1-.1 2.1-.2 3.1 0 .4-.1.7-.2 1a14.16 14.16 0 01-.8 3.2c-.2.6-.4 1.2-.6 1.7-.2.4-.4.8-.5 1.2-.3.5-.5 1.1-.8 1.6-.2.4-.4.7-.7 1.1-.3.5-.7 1-1 1.5-.3.4-.5.7-.8 1-.4.4-.8.9-1.2 1.3-.3.3-.6.6-1 .9-.4.4-.9.8-1.4 1.1-.4.3-.7.6-1.1.8-.1.1-.3.2-.4.3L525.2 786c-4 2.7-8.6 4-13.2 4-4.7 0-9.3-1.4-13.3-4L244.6 616.9c-.1-.1-.3-.2-.4-.3l-1.1-.8c-.5-.4-.9-.7-1.3-1.1-.3-.3-.6-.6-1-.9-.4-.4-.8-.8-1.2-1.3a7 7 0 01-.8-1c-.4-.5-.7-1-1-1.5-.2-.4-.5-.7-.7-1.1-.3-.5-.6-1.1-.8-1.6-.2-.4-.4-.8-.5-1.2-.2-.6-.4-1.2-.6-1.7-.1-.4-.3-.8-.4-1.2-.2-.7-.3-1.3-.4-2-.1-.3-.1-.7-.2-1-.1-1-.2-2.1-.2-3.1V427.9c0-1 .1-2.1.2-3.1.1-.3.1-.7.2-1a14.16 14.16 0 01.8-3.2c.2-.6.4-1.2.6-1.7.2-.4.4-.8.5-1.2.2-.5.5-1.1.8-1.6.2-.4.4-.7.7-1.1.6-.9 1.2-1.7 1.8-2.5.4-.4.8-.9 1.2-1.3.3-.3.6-.6 1-.9.4-.4.9-.8 1.3-1.1.4-.3.7-.6 1.1-.8.1-.1.3-.2.4-.3L498.7 239c8-5.3 18.5-5.3 26.5 0l254.1 169.1c.1.1.3.2.4.3l1.1.8 1.4 1.1c.3.3.6.6 1 .9.4.4.8.8 1.2 1.3.7.8 1.3 1.6 1.8 2.5.2.4.5.7.7 1.1.3.5.6 1 .8 1.6.2.4.4.8.5 1.2.2.6.4 1.2.6 1.7.1.4.3.8.4 1.2.2.7.3 1.3.4 2 .1.3.1.7.2 1 .1 1 .2 2.1.2 3.1V597zm-254.1 13.3v111.3L723.1 597l-83.6-55.8zM281.8 472.6v79.8l59.8-39.9zM512 456.1l-84.5 56.4 84.5 56.4 84.5-56.4zM723.1 428L535.9 303.4v111.3l103.6 69.1zM384.5 541.2L300.9 597l187.2 124.6V610.3l-103.6-69.1z" } }] }, "name": "codepen-circle", "theme": "outlined" };
  exports.default = CodepenCircleOutlined;
  });

  var CodepenCircleOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(CodepenCircleOutlined_1);

  var CodepenCircleOutlined = function CodepenCircleOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CodepenCircleOutlinedSvg
    }));
  };
  var RefIcon$2s = /*#__PURE__*/React.forwardRef(CodepenCircleOutlined);
  {
    RefIcon$2s.displayName = 'CodepenCircleOutlined';
  }

  var CodepenOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CodepenOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M911.7 385.3l-.3-1.5c-.2-1-.3-1.9-.6-2.9-.2-.6-.4-1.1-.5-1.7-.3-.8-.5-1.7-.9-2.5-.2-.6-.5-1.1-.8-1.7-.4-.8-.8-1.5-1.2-2.3-.3-.5-.6-1.1-1-1.6-.8-1.2-1.7-2.4-2.6-3.6-.5-.6-1.1-1.3-1.7-1.9-.4-.5-.9-.9-1.4-1.3-.6-.6-1.3-1.1-1.9-1.6-.5-.4-1-.8-1.6-1.2-.2-.1-.4-.3-.6-.4L531.1 117.8a34.3 34.3 0 00-38.1 0L127.3 361.3c-.2.1-.4.3-.6.4-.5.4-1 .8-1.6 1.2-.7.5-1.3 1.1-1.9 1.6-.5.4-.9.9-1.4 1.3-.6.6-1.2 1.2-1.7 1.9-1 1.1-1.8 2.3-2.6 3.6-.3.5-.7 1-1 1.6-.4.7-.8 1.5-1.2 2.3-.3.5-.5 1.1-.8 1.7-.3.8-.6 1.7-.9 2.5-.2.6-.4 1.1-.5 1.7-.2.9-.4 1.9-.6 2.9l-.3 1.5c-.2 1.5-.3 3-.3 4.5v243.5c0 1.5.1 3 .3 4.5l.3 1.5.6 2.9c.2.6.3 1.1.5 1.7.3.9.6 1.7.9 2.5.2.6.5 1.1.8 1.7.4.8.7 1.5 1.2 2.3.3.5.6 1.1 1 1.6.5.7.9 1.4 1.5 2.1l1.2 1.5c.5.6 1.1 1.3 1.7 1.9.4.5.9.9 1.4 1.3.6.6 1.3 1.1 1.9 1.6.5.4 1 .8 1.6 1.2.2.1.4.3.6.4L493 905.7c5.6 3.8 12.3 5.8 19.1 5.8 6.6 0 13.3-1.9 19.1-5.8l365.6-243.5c.2-.1.4-.3.6-.4.5-.4 1-.8 1.6-1.2.7-.5 1.3-1.1 1.9-1.6.5-.4.9-.9 1.4-1.3.6-.6 1.2-1.2 1.7-1.9l1.2-1.5 1.5-2.1c.3-.5.7-1 1-1.6.4-.8.8-1.5 1.2-2.3.3-.5.5-1.1.8-1.7.3-.8.6-1.7.9-2.5.2-.5.4-1.1.5-1.7.3-.9.4-1.9.6-2.9l.3-1.5c.2-1.5.3-3 .3-4.5V389.8c-.3-1.5-.4-3-.6-4.5zM546.4 210.5l269.4 179.4-120.3 80.4-149-99.6V210.5zm-68.8 0v160.2l-149 99.6-120.3-80.4 269.3-179.4zM180.7 454.1l86 57.5-86 57.5v-115zm296.9 358.5L208.3 633.2l120.3-80.4 149 99.6v160.2zM512 592.8l-121.6-81.2L512 430.3l121.6 81.2L512 592.8zm34.4 219.8V652.4l149-99.6 120.3 80.4-269.3 179.4zM843.3 569l-86-57.5 86-57.5v115z" } }] }, "name": "codepen", "theme": "outlined" };
  exports.default = CodepenOutlined;
  });

  var CodepenOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(CodepenOutlined_1);

  var CodepenOutlined = function CodepenOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CodepenOutlinedSvg
    }));
  };
  var RefIcon$2t = /*#__PURE__*/React.forwardRef(CodepenOutlined);
  {
    RefIcon$2t.displayName = 'CodepenOutlined';
  }

  var CodepenSquareFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CodepenSquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M723.1 428L535.9 303.4v111.3l103.6 69.1zM512 456.1l-84.5 56.4 84.5 56.4 84.5-56.4zm23.9 154.2v111.3L723.1 597l-83.6-55.8zm-151.4-69.1L300.9 597l187.2 124.6V610.3l-103.6-69.1zM880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-90 485c0 1.1-.1 2.1-.2 3.1 0 .4-.1.7-.2 1a14.16 14.16 0 01-.8 3.2c-.2.6-.4 1.2-.6 1.7-.2.4-.4.8-.5 1.2-.3.5-.5 1.1-.8 1.6-.2.4-.4.7-.7 1.1-.3.5-.7 1-1 1.5-.3.4-.5.7-.8 1-.4.4-.8.9-1.2 1.3-.3.3-.6.6-1 .9-.4.4-.9.8-1.4 1.1-.4.3-.7.6-1.1.8-.1.1-.3.2-.4.3L525.2 786c-4 2.7-8.6 4-13.2 4-4.7 0-9.3-1.4-13.3-4L244.6 616.9c-.1-.1-.3-.2-.4-.3l-1.1-.8c-.5-.4-.9-.7-1.3-1.1-.3-.3-.6-.6-1-.9-.4-.4-.8-.8-1.2-1.3a7 7 0 01-.8-1c-.4-.5-.7-1-1-1.5-.2-.4-.5-.7-.7-1.1-.3-.5-.6-1.1-.8-1.6-.2-.4-.4-.8-.5-1.2-.2-.6-.4-1.2-.6-1.7-.1-.4-.3-.8-.4-1.2-.2-.7-.3-1.3-.4-2-.1-.3-.1-.7-.2-1-.1-1-.2-2.1-.2-3.1V427.9c0-1 .1-2.1.2-3.1.1-.3.1-.7.2-1a14.16 14.16 0 01.8-3.2c.2-.6.4-1.2.6-1.7.2-.4.4-.8.5-1.2.2-.5.5-1.1.8-1.6.2-.4.4-.7.7-1.1.6-.9 1.2-1.7 1.8-2.5.4-.4.8-.9 1.2-1.3.3-.3.6-.6 1-.9.4-.4.9-.8 1.3-1.1.4-.3.7-.6 1.1-.8.1-.1.3-.2.4-.3L498.7 239c8-5.3 18.5-5.3 26.5 0l254.1 169.1c.1.1.3.2.4.3l1.1.8 1.4 1.1c.3.3.6.6 1 .9.4.4.8.8 1.2 1.3.7.8 1.3 1.6 1.8 2.5.2.4.5.7.7 1.1.3.5.6 1 .8 1.6.2.4.4.8.5 1.2.2.6.4 1.2.6 1.7.1.4.3.8.4 1.2.2.7.3 1.3.4 2 .1.3.1.7.2 1 .1 1 .2 2.1.2 3.1V597zm-47.8-44.6v-79.8l-59.8 39.9zm-460.4-79.8v79.8l59.8-39.9zm206.3-57.9V303.4L300.9 428l83.6 55.8z" } }] }, "name": "codepen-square", "theme": "filled" };
  exports.default = CodepenSquareFilled;
  });

  var CodepenSquareFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(CodepenSquareFilled_1);

  var CodepenSquareFilled = function CodepenSquareFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CodepenSquareFilledSvg
    }));
  };
  var RefIcon$2u = /*#__PURE__*/React.forwardRef(CodepenSquareFilled);
  {
    RefIcon$2u.displayName = 'CodepenSquareFilled';
  }

  var CoffeeOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CoffeeOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M275 281c19.9 0 36-16.1 36-36V36c0-19.9-16.1-36-36-36s-36 16.1-36 36v209c0 19.9 16.1 36 36 36zm613 144H768c0-39.8-32.2-72-72-72H200c-39.8 0-72 32.2-72 72v248c0 3.4.2 6.7.7 9.9-.5 7-.7 14-.7 21.1 0 176.7 143.3 320 320 320 160.1 0 292.7-117.5 316.3-271H888c39.8 0 72-32.2 72-72V497c0-39.8-32.2-72-72-72zM696 681h-1.1c.7 7.6 1.1 15.2 1.1 23 0 137-111 248-248 248S200 841 200 704c0-7.8.4-15.4 1.1-23H200V425h496v256zm192-8H776V497h112v176zM613 281c19.9 0 36-16.1 36-36V36c0-19.9-16.1-36-36-36s-36 16.1-36 36v209c0 19.9 16.1 36 36 36zm-170 0c19.9 0 36-16.1 36-36V36c0-19.9-16.1-36-36-36s-36 16.1-36 36v209c0 19.9 16.1 36 36 36z" } }] }, "name": "coffee", "theme": "outlined" };
  exports.default = CoffeeOutlined;
  });

  var CoffeeOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(CoffeeOutlined_1);

  var CoffeeOutlined = function CoffeeOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CoffeeOutlinedSvg
    }));
  };
  var RefIcon$2v = /*#__PURE__*/React.forwardRef(CoffeeOutlined);
  {
    RefIcon$2v.displayName = 'CoffeeOutlined';
  }

  var ColumnHeightOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ColumnHeightOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M840 836H184c-4.4 0-8 3.6-8 8v60c0 4.4 3.6 8 8 8h656c4.4 0 8-3.6 8-8v-60c0-4.4-3.6-8-8-8zm0-724H184c-4.4 0-8 3.6-8 8v60c0 4.4 3.6 8 8 8h656c4.4 0 8-3.6 8-8v-60c0-4.4-3.6-8-8-8zM610.8 378c6 0 9.4-7 5.7-11.7L515.7 238.7a7.14 7.14 0 00-11.3 0L403.6 366.3a7.23 7.23 0 005.7 11.7H476v268h-62.8c-6 0-9.4 7-5.7 11.7l100.8 127.5c2.9 3.7 8.5 3.7 11.3 0l100.8-127.5c3.7-4.7.4-11.7-5.7-11.7H548V378h62.8z" } }] }, "name": "column-height", "theme": "outlined" };
  exports.default = ColumnHeightOutlined;
  });

  var ColumnHeightOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(ColumnHeightOutlined_1);

  var ColumnHeightOutlined = function ColumnHeightOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ColumnHeightOutlinedSvg
    }));
  };
  var RefIcon$2w = /*#__PURE__*/React.forwardRef(ColumnHeightOutlined);
  {
    RefIcon$2w.displayName = 'ColumnHeightOutlined';
  }

  var ColumnWidthOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ColumnWidthOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M180 176h-60c-4.4 0-8 3.6-8 8v656c0 4.4 3.6 8 8 8h60c4.4 0 8-3.6 8-8V184c0-4.4-3.6-8-8-8zm724 0h-60c-4.4 0-8 3.6-8 8v656c0 4.4 3.6 8 8 8h60c4.4 0 8-3.6 8-8V184c0-4.4-3.6-8-8-8zM785.3 504.3L657.7 403.6a7.23 7.23 0 00-11.7 5.7V476H378v-62.8c0-6-7-9.4-11.7-5.7L238.7 508.3a7.14 7.14 0 000 11.3l127.5 100.8c4.7 3.7 11.7.4 11.7-5.7V548h268v62.8c0 6 7 9.4 11.7 5.7l127.5-100.8c3.8-2.9 3.8-8.5.2-11.4z" } }] }, "name": "column-width", "theme": "outlined" };
  exports.default = ColumnWidthOutlined;
  });

  var ColumnWidthOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(ColumnWidthOutlined_1);

  var ColumnWidthOutlined = function ColumnWidthOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ColumnWidthOutlinedSvg
    }));
  };
  var RefIcon$2x = /*#__PURE__*/React.forwardRef(ColumnWidthOutlined);
  {
    RefIcon$2x.displayName = 'ColumnWidthOutlined';
  }

  var CommentOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CommentOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M573 421c-23.1 0-41 17.9-41 40s17.9 40 41 40c21.1 0 39-17.9 39-40s-17.9-40-39-40zm-280 0c-23.1 0-41 17.9-41 40s17.9 40 41 40c21.1 0 39-17.9 39-40s-17.9-40-39-40z" } }, { "tag": "path", "attrs": { "d": "M894 345a343.92 343.92 0 00-189-130v.1c-17.1-19-36.4-36.5-58-52.1-163.7-119-393.5-82.7-513 81-96.3 133-92.2 311.9 6 439l.8 132.6c0 3.2.5 6.4 1.5 9.4a31.95 31.95 0 0040.1 20.9L309 806c33.5 11.9 68.1 18.7 102.5 20.6l-.5.4c89.1 64.9 205.9 84.4 313 49l127.1 41.4c3.2 1 6.5 1.6 9.9 1.6 17.7 0 32-14.3 32-32V753c88.1-119.6 90.4-284.9 1-408zM323 735l-12-5-99 31-1-104-8-9c-84.6-103.2-90.2-251.9-11-361 96.4-132.2 281.2-161.4 413-66 132.2 96.1 161.5 280.6 66 412-80.1 109.9-223.5 150.5-348 102zm505-17l-8 10 1 104-98-33-12 5c-56 20.8-115.7 22.5-171 7l-.2-.1A367.31 367.31 0 00729 676c76.4-105.3 88.8-237.6 44.4-350.4l.6.4c23 16.5 44.1 37.1 62 62 72.6 99.6 68.5 235.2-8 330z" } }, { "tag": "path", "attrs": { "d": "M433 421c-23.1 0-41 17.9-41 40s17.9 40 41 40c21.1 0 39-17.9 39-40s-17.9-40-39-40z" } }] }, "name": "comment", "theme": "outlined" };
  exports.default = CommentOutlined;
  });

  var CommentOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(CommentOutlined_1);

  var CommentOutlined = function CommentOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CommentOutlinedSvg
    }));
  };
  var RefIcon$2y = /*#__PURE__*/React.forwardRef(CommentOutlined);
  {
    RefIcon$2y.displayName = 'CommentOutlined';
  }

  var CompassFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CompassFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zM327.3 702.4c-2 .9-4.4 0-5.3-2.1-.4-1-.4-2.2 0-3.2l98.7-225.5 132.1 132.1-225.5 98.7zm375.1-375.1l-98.7 225.5-132.1-132.1L697.1 322c2-.9 4.4 0 5.3 2.1.4 1 .4 2.1 0 3.2z" } }] }, "name": "compass", "theme": "filled" };
  exports.default = CompassFilled;
  });

  var CompassFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(CompassFilled_1);

  var CompassFilled = function CompassFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CompassFilledSvg
    }));
  };
  var RefIcon$2z = /*#__PURE__*/React.forwardRef(CompassFilled);
  {
    RefIcon$2z.displayName = 'CompassFilled';
  }

  var CompassOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CompassOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372zm198.4-588.1a32 32 0 00-24.5.5L414.9 415 296.4 686c-3.6 8.2-3.6 17.5 0 25.7 3.4 7.8 9.7 13.9 17.7 17 3.8 1.5 7.7 2.2 11.7 2.2 4.4 0 8.7-.9 12.8-2.7l271-118.6 118.5-271a32.06 32.06 0 00-17.7-42.7zM576.8 534.4l26.2 26.2-42.4 42.4-26.2-26.2L380 644.4 447.5 490 422 464.4l42.4-42.4 25.5 25.5L644.4 380l-67.6 154.4zM464.4 422L422 464.4l25.5 25.6 86.9 86.8 26.2 26.2 42.4-42.4-26.2-26.2-86.8-86.9z" } }] }, "name": "compass", "theme": "outlined" };
  exports.default = CompassOutlined;
  });

  var CompassOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(CompassOutlined_1);

  var CompassOutlined = function CompassOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CompassOutlinedSvg
    }));
  };
  var RefIcon$2A = /*#__PURE__*/React.forwardRef(CompassOutlined);
  {
    RefIcon$2A.displayName = 'CompassOutlined';
  }

  var CompassTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CompassTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zM327.6 701.7c-2 .9-4.4 0-5.3-2.1-.4-1-.4-2.2 0-3.2L421 470.9 553.1 603l-225.5 98.7zm375.1-375.1L604 552.1 471.9 420l225.5-98.7c2-.9 4.4 0 5.3 2.1.4 1 .4 2.1 0 3.2z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M322.3 696.4c-.4 1-.4 2.2 0 3.2.9 2.1 3.3 3 5.3 2.1L553.1 603 421 470.9l-98.7 225.5zm375.1-375.1L471.9 420 604 552.1l98.7-225.5c.4-1.1.4-2.2 0-3.2-.9-2.1-3.3-3-5.3-2.1z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }] }; }, "name": "compass", "theme": "twotone" };
  exports.default = CompassTwoTone;
  });

  var CompassTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(CompassTwoTone_1);

  var CompassTwoTone = function CompassTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CompassTwoToneSvg
    }));
  };
  var RefIcon$2B = /*#__PURE__*/React.forwardRef(CompassTwoTone);
  {
    RefIcon$2B.displayName = 'CompassTwoTone';
  }

  var CompressOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CompressOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M326 664H104c-8.8 0-16 7.2-16 16v48c0 8.8 7.2 16 16 16h174v176c0 8.8 7.2 16 16 16h48c8.8 0 16-7.2 16-16V696c0-17.7-14.3-32-32-32zm16-576h-48c-8.8 0-16 7.2-16 16v176H104c-8.8 0-16 7.2-16 16v48c0 8.8 7.2 16 16 16h222c17.7 0 32-14.3 32-32V104c0-8.8-7.2-16-16-16zm578 576H698c-17.7 0-32 14.3-32 32v224c0 8.8 7.2 16 16 16h48c8.8 0 16-7.2 16-16V744h174c8.8 0 16-7.2 16-16v-48c0-8.8-7.2-16-16-16zm0-384H746V104c0-8.8-7.2-16-16-16h-48c-8.8 0-16 7.2-16 16v224c0 17.7 14.3 32 32 32h222c8.8 0 16-7.2 16-16v-48c0-8.8-7.2-16-16-16z" } }] }, "name": "compress", "theme": "outlined" };
  exports.default = CompressOutlined;
  });

  var CompressOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(CompressOutlined_1);

  var CompressOutlined = function CompressOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CompressOutlinedSvg
    }));
  };
  var RefIcon$2C = /*#__PURE__*/React.forwardRef(CompressOutlined);
  {
    RefIcon$2C.displayName = 'CompressOutlined';
  }

  var ConsoleSqlOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ConsoleSqlOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M301.3 496.7c-23.8 0-40.2-10.5-41.6-26.9H205c.9 43.4 36.9 70.3 93.9 70.3 59.1 0 95-28.4 95-75.5 0-35.8-20-55.9-64.5-64.5l-29.1-5.6c-23.8-4.7-33.8-11.9-33.8-24.2 0-15 13.3-24.5 33.4-24.5 20.1 0 35.3 11.1 36.6 27h53c-.9-41.7-37.5-70.3-90.3-70.3-54.4 0-89.7 28.9-89.7 73 0 35.5 21.2 58 62.5 65.8l29.7 5.9c25.8 5.2 35.6 11.9 35.6 24.4.1 14.7-14.5 25.1-36 25.1z" } }, { "tag": "path", "attrs": { "d": "M928 140H96c-17.7 0-32 14.3-32 32v496c0 17.7 14.3 32 32 32h380v112H304c-8.8 0-16 7.2-16 16v48c0 4.4 3.6 8 8 8h432c4.4 0 8-3.6 8-8v-48c0-8.8-7.2-16-16-16H548V700h380c17.7 0 32-14.3 32-32V172c0-17.7-14.3-32-32-32zm-40 488H136V212h752v416z" } }, { "tag": "path", "attrs": { "d": "M828.5 486.7h-95.8V308.5h-57.4V534h153.2zm-298.6 53.4c14.1 0 27.2-2 39.1-5.8l13.3 20.3h53.3L607.9 511c21.1-20 33-51.1 33-89.8 0-73.3-43.3-118.8-110.9-118.8s-111.2 45.3-111.2 118.8c-.1 73.7 43 118.9 111.1 118.9zm0-190c31.6 0 52.7 27.7 52.7 71.1 0 16.7-3.6 30.6-10 40.5l-5.2-6.9h-48.8L542 491c-3.9.9-8 1.4-12.2 1.4-31.7 0-52.8-27.5-52.8-71.2.1-43.6 21.2-71.1 52.9-71.1z" } }] }, "name": "console-sql", "theme": "outlined" };
  exports.default = ConsoleSqlOutlined;
  });

  var ConsoleSqlOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(ConsoleSqlOutlined_1);

  var ConsoleSqlOutlined = function ConsoleSqlOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ConsoleSqlOutlinedSvg
    }));
  };
  var RefIcon$2D = /*#__PURE__*/React.forwardRef(ConsoleSqlOutlined);
  {
    RefIcon$2D.displayName = 'ConsoleSqlOutlined';
  }

  var ContactsFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ContactsFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M928 224H768v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56H548v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56H328v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56H96c-17.7 0-32 14.3-32 32v576c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V256c0-17.7-14.3-32-32-32zM661 736h-43.9c-4.2 0-7.6-3.3-7.9-7.5-3.8-50.6-46-90.5-97.2-90.5s-93.4 40-97.2 90.5c-.3 4.2-3.7 7.5-7.9 7.5H363a8 8 0 01-8-8.4c2.8-53.3 32-99.7 74.6-126.1a111.8 111.8 0 01-29.1-75.5c0-61.9 49.9-112 111.4-112 61.5 0 111.4 50.1 111.4 112 0 29.1-11 55.5-29.1 75.5 42.7 26.5 71.8 72.8 74.6 126.1.4 4.6-3.2 8.4-7.8 8.4zM512 474c-28.5 0-51.7 23.3-51.7 52s23.2 52 51.7 52c28.5 0 51.7-23.3 51.7-52s-23.2-52-51.7-52z" } }] }, "name": "contacts", "theme": "filled" };
  exports.default = ContactsFilled;
  });

  var ContactsFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(ContactsFilled_1);

  var ContactsFilled = function ContactsFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ContactsFilledSvg
    }));
  };
  var RefIcon$2E = /*#__PURE__*/React.forwardRef(ContactsFilled);
  {
    RefIcon$2E.displayName = 'ContactsFilled';
  }

  var ContactsOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ContactsOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M594.3 601.5a111.8 111.8 0 0029.1-75.5c0-61.9-49.9-112-111.4-112s-111.4 50.1-111.4 112c0 29.1 11 55.5 29.1 75.5a158.09 158.09 0 00-74.6 126.1 8 8 0 008 8.4H407c4.2 0 7.6-3.3 7.9-7.5 3.8-50.6 46-90.5 97.2-90.5s93.4 40 97.2 90.5c.3 4.2 3.7 7.5 7.9 7.5H661a8 8 0 008-8.4c-2.8-53.3-32-99.7-74.7-126.1zM512 578c-28.5 0-51.7-23.3-51.7-52s23.2-52 51.7-52 51.7 23.3 51.7 52-23.2 52-51.7 52zm416-354H768v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56H548v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56H328v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56H96c-17.7 0-32 14.3-32 32v576c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V256c0-17.7-14.3-32-32-32zm-40 568H136V296h120v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56h148v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56h148v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56h120v496z" } }] }, "name": "contacts", "theme": "outlined" };
  exports.default = ContactsOutlined;
  });

  var ContactsOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(ContactsOutlined_1);

  var ContactsOutlined = function ContactsOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ContactsOutlinedSvg
    }));
  };
  var RefIcon$2F = /*#__PURE__*/React.forwardRef(ContactsOutlined);
  {
    RefIcon$2F.displayName = 'ContactsOutlined';
  }

  var ContactsTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ContactsTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M460.3 526a51.7 52 0 10103.4 0 51.7 52 0 10-103.4 0z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M768 352c0 4.4-3.6 8-8 8h-56c-4.4 0-8-3.6-8-8v-56H548v56c0 4.4-3.6 8-8 8h-56c-4.4 0-8-3.6-8-8v-56H328v56c0 4.4-3.6 8-8 8h-56c-4.4 0-8-3.6-8-8v-56H136v496h752V296H768v56zM661 736h-43.8c-4.2 0-7.6-3.3-7.9-7.5-3.8-50.5-46-90.5-97.2-90.5s-93.4 39.9-97.2 90.5c-.3 4.2-3.7 7.5-7.9 7.5h-43.9a8 8 0 01-8-8.4c2.8-53.3 31.9-99.6 74.6-126.1-18.1-20-29.1-46.4-29.1-75.5 0-61.9 49.9-112 111.4-112s111.4 50.1 111.4 112c0 29.1-11 55.6-29.1 75.5 42.7 26.4 71.9 72.8 74.7 126.1a8 8 0 01-8 8.4z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M594.3 601.5a111.8 111.8 0 0029.1-75.5c0-61.9-49.9-112-111.4-112s-111.4 50.1-111.4 112c0 29.1 11 55.5 29.1 75.5a158.09 158.09 0 00-74.6 126.1 8 8 0 008 8.4H407c4.2 0 7.6-3.3 7.9-7.5 3.8-50.6 46-90.5 97.2-90.5s93.4 40 97.2 90.5c.3 4.2 3.7 7.5 7.9 7.5H661a8 8 0 008-8.4c-2.8-53.3-32-99.7-74.7-126.1zM512 578c-28.5 0-51.7-23.3-51.7-52s23.2-52 51.7-52 51.7 23.3 51.7 52-23.2 52-51.7 52z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M928 224H768v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56H548v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56H328v-56c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v56H96c-17.7 0-32 14.3-32 32v576c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V256c0-17.7-14.3-32-32-32zm-40 568H136V296h120v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56h148v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56h148v56c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-56h120v496z", "fill": primaryColor } }] }; }, "name": "contacts", "theme": "twotone" };
  exports.default = ContactsTwoTone;
  });

  var ContactsTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(ContactsTwoTone_1);

  var ContactsTwoTone = function ContactsTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ContactsTwoToneSvg
    }));
  };
  var RefIcon$2G = /*#__PURE__*/React.forwardRef(ContactsTwoTone);
  {
    RefIcon$2G.displayName = 'ContactsTwoTone';
  }

  var ContainerFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ContainerFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M832 64H192c-17.7 0-32 14.3-32 32v529c0-.6.4-1 1-1h219.3l5.2 24.7C397.6 708.5 450.8 752 512 752s114.4-43.5 126.4-103.3l5.2-24.7H863c.6 0 1 .4 1 1V96c0-17.7-14.3-32-32-32zM712 493c0 4.4-3.6 8-8 8H320c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h384c4.4 0 8 3.6 8 8v48zm0-160c0 4.4-3.6 8-8 8H320c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h384c4.4 0 8 3.6 8 8v48zm151 354H694.1c-11.6 32.8-32 62.3-59.1 84.7-34.5 28.6-78.2 44.3-123 44.3s-88.5-15.8-123-44.3a194.02 194.02 0 01-59.1-84.7H161c-.6 0-1-.4-1-1v242c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V686c0 .6-.4 1-1 1z" } }] }, "name": "container", "theme": "filled" };
  exports.default = ContainerFilled;
  });

  var ContainerFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(ContainerFilled_1);

  var ContainerFilled = function ContainerFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ContainerFilledSvg
    }));
  };
  var RefIcon$2H = /*#__PURE__*/React.forwardRef(ContainerFilled);
  {
    RefIcon$2H.displayName = 'ContainerFilled';
  }

  var ContainerOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ContainerOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M832 64H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V96c0-17.7-14.3-32-32-32zm-40 824H232V687h97.9c11.6 32.8 32 62.3 59.1 84.7 34.5 28.5 78.2 44.3 123 44.3s88.5-15.7 123-44.3c27.1-22.4 47.5-51.9 59.1-84.7H792v-63H643.6l-5.2 24.7C626.4 708.5 573.2 752 512 752s-114.4-43.5-126.5-103.3l-5.2-24.7H232V136h560v752zM320 341h384c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H320c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8zm0 160h384c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H320c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8z" } }] }, "name": "container", "theme": "outlined" };
  exports.default = ContainerOutlined;
  });

  var ContainerOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(ContainerOutlined_1);

  var ContainerOutlined = function ContainerOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ContainerOutlinedSvg
    }));
  };
  var RefIcon$2I = /*#__PURE__*/React.forwardRef(ContainerOutlined);
  {
    RefIcon$2I.displayName = 'ContainerOutlined';
  }

  var ContainerTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ContainerTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M635 771.7c-34.5 28.6-78.2 44.3-123 44.3s-88.5-15.8-123-44.3a194.02 194.02 0 01-59.1-84.7H232v201h560V687h-97.9c-11.6 32.8-32 62.3-59.1 84.7z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M320 501h384c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H320c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M832 64H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V96c0-17.7-14.3-32-32-32zm-40 824H232V687h97.9c11.6 32.8 32 62.3 59.1 84.7 34.5 28.5 78.2 44.3 123 44.3s88.5-15.7 123-44.3c27.1-22.4 47.5-51.9 59.1-84.7H792v201zm0-264H643.6l-5.2 24.7C626.4 708.5 573.2 752 512 752s-114.4-43.5-126.5-103.3l-5.2-24.7H232V136h560v488z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M320 341h384c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H320c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8z", "fill": primaryColor } }] }; }, "name": "container", "theme": "twotone" };
  exports.default = ContainerTwoTone;
  });

  var ContainerTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(ContainerTwoTone_1);

  var ContainerTwoTone = function ContainerTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ContainerTwoToneSvg
    }));
  };
  var RefIcon$2J = /*#__PURE__*/React.forwardRef(ContainerTwoTone);
  {
    RefIcon$2J.displayName = 'ContainerTwoTone';
  }

  var ControlFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ControlFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM404 683v77c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8v-77c-41.7-13.6-72-52.8-72-99s30.3-85.5 72-99V264c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v221c41.7 13.6 72 52.8 72 99s-30.3 85.5-72 99zm279.6-143.9c.2 0 .3-.1.4-.1v221c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V539c.2 0 .3.1.4.1-42-13.4-72.4-52.7-72.4-99.1 0-46.4 30.4-85.7 72.4-99.1-.2 0-.3.1-.4.1v-77c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v77c-.2 0-.3-.1-.4-.1 42 13.4 72.4 52.7 72.4 99.1 0 46.4-30.4 85.7-72.4 99.1zM616 440a36 36 0 1072 0 36 36 0 10-72 0zM403.4 566.5l-1.5-2.4c0-.1-.1-.1-.1-.2l-.9-1.2c-.1-.1-.2-.2-.2-.3-1-1.3-2-2.5-3.2-3.6l-.2-.2c-.4-.4-.8-.8-1.2-1.1-.8-.8-1.7-1.5-2.6-2.1h-.1l-1.2-.9c-.1-.1-.3-.2-.4-.3-1.2-.8-2.5-1.6-3.9-2.2-.2-.1-.5-.2-.7-.4-.4-.2-.7-.3-1.1-.5-.3-.1-.7-.3-1-.4-.5-.2-1-.4-1.5-.5-.4-.1-.9-.3-1.3-.4l-.9-.3-1.4-.3c-.2-.1-.5-.1-.7-.2-.7-.1-1.4-.3-2.1-.4-.2 0-.4 0-.6-.1-.6-.1-1.1-.1-1.7-.2-.2 0-.4 0-.7-.1-.8 0-1.5-.1-2.3-.1s-1.5 0-2.3.1c-.2 0-.4 0-.7.1-.6 0-1.2.1-1.7.2-.2 0-.4 0-.6.1-.7.1-1.4.2-2.1.4-.2.1-.5.1-.7.2l-1.4.3-.9.3c-.4.1-.9.3-1.3.4-.5.2-1 .4-1.5.5-.3.1-.7.3-1 .4-.4.2-.7.3-1.1.5-.2.1-.5.2-.7.4-1.3.7-2.6 1.4-3.9 2.2-.1.1-.3.2-.4.3l-1.2.9h-.1c-.9.7-1.8 1.4-2.6 2.1-.4.4-.8.7-1.2 1.1l-.2.2a54.8 54.8 0 00-3.2 3.6c-.1.1-.2.2-.2.3l-.9 1.2c0 .1-.1.1-.1.2l-1.5 2.4c-.1.2-.2.3-.3.5-2.7 5.1-4.3 10.9-4.3 17s1.6 12 4.3 17c.1.2.2.3.3.5l1.5 2.4c0 .1.1.1.1.2l.9 1.2c.1.1.2.2.2.3 1 1.3 2 2.5 3.2 3.6l.2.2c.4.4.8.8 1.2 1.1.8.8 1.7 1.5 2.6 2.1h.1l1.2.9c.1.1.3.2.4.3 1.2.8 2.5 1.6 3.9 2.2.2.1.5.2.7.4.4.2.7.3 1.1.5.3.1.7.3 1 .4.5.2 1 .4 1.5.5.4.1.9.3 1.3.4l.9.3 1.4.3c.2.1.5.1.7.2.7.1 1.4.3 2.1.4.2 0 .4 0 .6.1.6.1 1.1.1 1.7.2.2 0 .4 0 .7.1.8 0 1.5.1 2.3.1s1.5 0 2.3-.1c.2 0 .4 0 .7-.1.6 0 1.2-.1 1.7-.2.2 0 .4 0 .6-.1.7-.1 1.4-.2 2.1-.4.2-.1.5-.1.7-.2l1.4-.3.9-.3c.4-.1.9-.3 1.3-.4.5-.2 1-.4 1.5-.5.3-.1.7-.3 1-.4.4-.2.7-.3 1.1-.5.2-.1.5-.2.7-.4 1.3-.7 2.6-1.4 3.9-2.2.1-.1.3-.2.4-.3l1.2-.9h.1c.9-.7 1.8-1.4 2.6-2.1.4-.4.8-.7 1.2-1.1l.2-.2c1.1-1.1 2.2-2.4 3.2-3.6.1-.1.2-.2.2-.3l.9-1.2c0-.1.1-.1.1-.2l1.5-2.4c.1-.2.2-.3.3-.5 2.7-5.1 4.3-10.9 4.3-17s-1.6-12-4.3-17c-.1-.2-.2-.4-.3-.5z" } }] }, "name": "control", "theme": "filled" };
  exports.default = ControlFilled;
  });

  var ControlFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(ControlFilled_1);

  var ControlFilled = function ControlFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ControlFilledSvg
    }));
  };
  var RefIcon$2K = /*#__PURE__*/React.forwardRef(ControlFilled);
  {
    RefIcon$2K.displayName = 'ControlFilled';
  }

  var ControlOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ControlOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656zM340 683v77c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8v-77c-10.1 3.3-20.8 5-32 5s-21.9-1.8-32-5zm64-198V264c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v221c10.1-3.3 20.8-5 32-5s21.9 1.8 32 5zm-64 198c10.1 3.3 20.8 5 32 5s21.9-1.8 32-5c41.8-13.5 72-52.7 72-99s-30.2-85.5-72-99c-10.1-3.3-20.8-5-32-5s-21.9 1.8-32 5c-41.8 13.5-72 52.7-72 99s30.2 85.5 72 99zm.1-115.7c.3-.6.7-1.2 1-1.8v-.1l1.2-1.8c.1-.2.2-.3.3-.5.3-.5.7-.9 1-1.4.1-.1.2-.3.3-.4.5-.6.9-1.1 1.4-1.6l.3-.3 1.2-1.2.4-.4c.5-.5 1-.9 1.6-1.4.6-.5 1.1-.9 1.7-1.3.2-.1.3-.2.5-.3.5-.3.9-.7 1.4-1 .1-.1.3-.2.4-.3.6-.4 1.2-.7 1.9-1.1.1-.1.3-.1.4-.2.5-.3 1-.5 1.6-.8l.6-.3c.7-.3 1.3-.6 2-.8.7-.3 1.4-.5 2.1-.7.2-.1.4-.1.6-.2.6-.2 1.1-.3 1.7-.4.2 0 .3-.1.5-.1.7-.2 1.5-.3 2.2-.4.2 0 .3 0 .5-.1.6-.1 1.2-.1 1.8-.2h.6c.8 0 1.5-.1 2.3-.1s1.5 0 2.3.1h.6c.6 0 1.2.1 1.8.2.2 0 .3 0 .5.1.7.1 1.5.2 2.2.4.2 0 .3.1.5.1.6.1 1.2.3 1.7.4.2.1.4.1.6.2.7.2 1.4.4 2.1.7.7.2 1.3.5 2 .8l.6.3c.5.2 1.1.5 1.6.8.1.1.3.1.4.2.6.3 1.3.7 1.9 1.1.1.1.3.2.4.3.5.3 1 .6 1.4 1 .2.1.3.2.5.3.6.4 1.2.9 1.7 1.3s1.1.9 1.6 1.4l.4.4 1.2 1.2.3.3c.5.5 1 1.1 1.4 1.6.1.1.2.3.3.4.4.4.7.9 1 1.4.1.2.2.3.3.5l1.2 1.8s0 .1.1.1a36.18 36.18 0 015.1 18.5c0 6-1.5 11.7-4.1 16.7-.3.6-.7 1.2-1 1.8 0 0 0 .1-.1.1l-1.2 1.8c-.1.2-.2.3-.3.5-.3.5-.7.9-1 1.4-.1.1-.2.3-.3.4-.5.6-.9 1.1-1.4 1.6l-.3.3-1.2 1.2-.4.4c-.5.5-1 .9-1.6 1.4-.6.5-1.1.9-1.7 1.3-.2.1-.3.2-.5.3-.5.3-.9.7-1.4 1-.1.1-.3.2-.4.3-.6.4-1.2.7-1.9 1.1-.1.1-.3.1-.4.2-.5.3-1 .5-1.6.8l-.6.3c-.7.3-1.3.6-2 .8-.7.3-1.4.5-2.1.7-.2.1-.4.1-.6.2-.6.2-1.1.3-1.7.4-.2 0-.3.1-.5.1-.7.2-1.5.3-2.2.4-.2 0-.3 0-.5.1-.6.1-1.2.1-1.8.2h-.6c-.8 0-1.5.1-2.3.1s-1.5 0-2.3-.1h-.6c-.6 0-1.2-.1-1.8-.2-.2 0-.3 0-.5-.1-.7-.1-1.5-.2-2.2-.4-.2 0-.3-.1-.5-.1-.6-.1-1.2-.3-1.7-.4-.2-.1-.4-.1-.6-.2-.7-.2-1.4-.4-2.1-.7-.7-.2-1.3-.5-2-.8l-.6-.3c-.5-.2-1.1-.5-1.6-.8-.1-.1-.3-.1-.4-.2-.6-.3-1.3-.7-1.9-1.1-.1-.1-.3-.2-.4-.3-.5-.3-1-.6-1.4-1-.2-.1-.3-.2-.5-.3-.6-.4-1.2-.9-1.7-1.3s-1.1-.9-1.6-1.4l-.4-.4-1.2-1.2-.3-.3c-.5-.5-1-1.1-1.4-1.6-.1-.1-.2-.3-.3-.4-.4-.4-.7-.9-1-1.4-.1-.2-.2-.3-.3-.5l-1.2-1.8v-.1c-.4-.6-.7-1.2-1-1.8-2.6-5-4.1-10.7-4.1-16.7s1.5-11.7 4.1-16.7zM620 539v221c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V539c-10.1 3.3-20.8 5-32 5s-21.9-1.8-32-5zm64-198v-77c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v77c10.1-3.3 20.8-5 32-5s21.9 1.8 32 5zm-64 198c10.1 3.3 20.8 5 32 5s21.9-1.8 32-5c41.8-13.5 72-52.7 72-99s-30.2-85.5-72-99c-10.1-3.3-20.8-5-32-5s-21.9 1.8-32 5c-41.8 13.5-72 52.7-72 99s30.2 85.5 72 99zm.1-115.7c.3-.6.7-1.2 1-1.8v-.1l1.2-1.8c.1-.2.2-.3.3-.5.3-.5.7-.9 1-1.4.1-.1.2-.3.3-.4.5-.6.9-1.1 1.4-1.6l.3-.3 1.2-1.2.4-.4c.5-.5 1-.9 1.6-1.4.6-.5 1.1-.9 1.7-1.3.2-.1.3-.2.5-.3.5-.3.9-.7 1.4-1 .1-.1.3-.2.4-.3.6-.4 1.2-.7 1.9-1.1.1-.1.3-.1.4-.2.5-.3 1-.5 1.6-.8l.6-.3c.7-.3 1.3-.6 2-.8.7-.3 1.4-.5 2.1-.7.2-.1.4-.1.6-.2.6-.2 1.1-.3 1.7-.4.2 0 .3-.1.5-.1.7-.2 1.5-.3 2.2-.4.2 0 .3 0 .5-.1.6-.1 1.2-.1 1.8-.2h.6c.8 0 1.5-.1 2.3-.1s1.5 0 2.3.1h.6c.6 0 1.2.1 1.8.2.2 0 .3 0 .5.1.7.1 1.5.2 2.2.4.2 0 .3.1.5.1.6.1 1.2.3 1.7.4.2.1.4.1.6.2.7.2 1.4.4 2.1.7.7.2 1.3.5 2 .8l.6.3c.5.2 1.1.5 1.6.8.1.1.3.1.4.2.6.3 1.3.7 1.9 1.1.1.1.3.2.4.3.5.3 1 .6 1.4 1 .2.1.3.2.5.3.6.4 1.2.9 1.7 1.3s1.1.9 1.6 1.4l.4.4 1.2 1.2.3.3c.5.5 1 1.1 1.4 1.6.1.1.2.3.3.4.4.4.7.9 1 1.4.1.2.2.3.3.5l1.2 1.8v.1a36.18 36.18 0 015.1 18.5c0 6-1.5 11.7-4.1 16.7-.3.6-.7 1.2-1 1.8v.1l-1.2 1.8c-.1.2-.2.3-.3.5-.3.5-.7.9-1 1.4-.1.1-.2.3-.3.4-.5.6-.9 1.1-1.4 1.6l-.3.3-1.2 1.2-.4.4c-.5.5-1 .9-1.6 1.4-.6.5-1.1.9-1.7 1.3-.2.1-.3.2-.5.3-.5.3-.9.7-1.4 1-.1.1-.3.2-.4.3-.6.4-1.2.7-1.9 1.1-.1.1-.3.1-.4.2-.5.3-1 .5-1.6.8l-.6.3c-.7.3-1.3.6-2 .8-.7.3-1.4.5-2.1.7-.2.1-.4.1-.6.2-.6.2-1.1.3-1.7.4-.2 0-.3.1-.5.1-.7.2-1.5.3-2.2.4-.2 0-.3 0-.5.1-.6.1-1.2.1-1.8.2h-.6c-.8 0-1.5.1-2.3.1s-1.5 0-2.3-.1h-.6c-.6 0-1.2-.1-1.8-.2-.2 0-.3 0-.5-.1-.7-.1-1.5-.2-2.2-.4-.2 0-.3-.1-.5-.1-.6-.1-1.2-.3-1.7-.4-.2-.1-.4-.1-.6-.2-.7-.2-1.4-.4-2.1-.7-.7-.2-1.3-.5-2-.8l-.6-.3c-.5-.2-1.1-.5-1.6-.8-.1-.1-.3-.1-.4-.2-.6-.3-1.3-.7-1.9-1.1-.1-.1-.3-.2-.4-.3-.5-.3-1-.6-1.4-1-.2-.1-.3-.2-.5-.3-.6-.4-1.2-.9-1.7-1.3s-1.1-.9-1.6-1.4l-.4-.4-1.2-1.2-.3-.3c-.5-.5-1-1.1-1.4-1.6-.1-.1-.2-.3-.3-.4-.4-.4-.7-.9-1-1.4-.1-.2-.2-.3-.3-.5l-1.2-1.8v-.1c-.4-.6-.7-1.2-1-1.8-2.6-5-4.1-10.7-4.1-16.7s1.5-11.7 4.1-16.7z" } }] }, "name": "control", "theme": "outlined" };
  exports.default = ControlOutlined;
  });

  var ControlOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(ControlOutlined_1);

  var ControlOutlined = function ControlOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ControlOutlinedSvg
    }));
  };
  var RefIcon$2L = /*#__PURE__*/React.forwardRef(ControlOutlined);
  {
    RefIcon$2L.displayName = 'ControlOutlined';
  }

  var ControlTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ControlTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M616 440a36 36 0 1072 0 36 36 0 10-72 0zM340.4 601.5l1.5 2.4c0 .1.1.1.1.2l.9 1.2c.1.1.2.2.2.3 1 1.3 2 2.5 3.2 3.6l.2.2c.4.4.8.8 1.2 1.1.8.8 1.7 1.5 2.6 2.1h.1l1.2.9c.1.1.3.2.4.3 1.2.8 2.5 1.6 3.9 2.2.2.1.5.2.7.4.4.2.7.3 1.1.5.3.1.7.3 1 .4.5.2 1 .4 1.5.5.4.1.9.3 1.3.4l.9.3 1.4.3c.2.1.5.1.7.2.7.1 1.4.3 2.1.4.2 0 .4 0 .6.1.6.1 1.1.1 1.7.2.2 0 .4 0 .7.1.8 0 1.5.1 2.3.1s1.5 0 2.3-.1c.2 0 .4 0 .7-.1.6 0 1.2-.1 1.7-.2.2 0 .4 0 .6-.1.7-.1 1.4-.2 2.1-.4.2-.1.5-.1.7-.2l1.4-.3.9-.3c.4-.1.9-.3 1.3-.4.5-.2 1-.4 1.5-.5.3-.1.7-.3 1-.4.4-.2.7-.3 1.1-.5.2-.1.5-.2.7-.4 1.3-.7 2.6-1.4 3.9-2.2.1-.1.3-.2.4-.3l1.2-.9h.1c.9-.7 1.8-1.4 2.6-2.1.4-.4.8-.7 1.2-1.1l.2-.2c1.1-1.1 2.2-2.4 3.2-3.6.1-.1.2-.2.2-.3l.9-1.2c0-.1.1-.1.1-.2l1.5-2.4c.1-.2.2-.3.3-.5 2.7-5.1 4.3-10.9 4.3-17s-1.6-12-4.3-17c-.1-.2-.2-.4-.3-.5l-1.5-2.4c0-.1-.1-.1-.1-.2l-.9-1.2c-.1-.1-.2-.2-.2-.3-1-1.3-2-2.5-3.2-3.6l-.2-.2c-.4-.4-.8-.8-1.2-1.1-.8-.8-1.7-1.5-2.6-2.1h-.1l-1.2-.9c-.1-.1-.3-.2-.4-.3-1.2-.8-2.5-1.6-3.9-2.2-.2-.1-.5-.2-.7-.4-.4-.2-.7-.3-1.1-.5-.3-.1-.7-.3-1-.4-.5-.2-1-.4-1.5-.5-.4-.1-.9-.3-1.3-.4l-.9-.3-1.4-.3c-.2-.1-.5-.1-.7-.2-.7-.1-1.4-.3-2.1-.4-.2 0-.4 0-.6-.1-.6-.1-1.1-.1-1.7-.2-.2 0-.4 0-.7-.1-.8 0-1.5-.1-2.3-.1s-1.5 0-2.3.1c-.2 0-.4 0-.7.1-.6 0-1.2.1-1.7.2-.2 0-.4 0-.6.1-.7.1-1.4.2-2.1.4-.2.1-.5.1-.7.2l-1.4.3-.9.3c-.4.1-.9.3-1.3.4-.5.2-1 .4-1.5.5-.3.1-.7.3-1 .4-.4.2-.7.3-1.1.5-.2.1-.5.2-.7.4-1.3.7-2.6 1.4-3.9 2.2-.1.1-.3.2-.4.3l-1.2.9h-.1c-.9.7-1.8 1.4-2.6 2.1-.4.4-.8.7-1.2 1.1l-.2.2a54.8 54.8 0 00-3.2 3.6c-.1.1-.2.2-.2.3l-.9 1.2c0 .1-.1.1-.1.2l-1.5 2.4c-.1.2-.2.3-.3.5-2.7 5.1-4.3 10.9-4.3 17s1.6 12 4.3 17c.1.2.2.3.3.5z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M184 840h656V184H184v656zm436.4-499.1c-.2 0-.3.1-.4.1v-77c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v77c-.2 0-.3-.1-.4-.1 42 13.4 72.4 52.7 72.4 99.1 0 46.4-30.4 85.7-72.4 99.1.2 0 .3-.1.4-.1v221c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V539c.2 0 .3.1.4.1-42-13.4-72.4-52.7-72.4-99.1 0-46.4 30.4-85.7 72.4-99.1zM340 485V264c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v221c41.7 13.6 72 52.8 72 99s-30.3 85.5-72 99v77c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8v-77c-41.7-13.6-72-52.8-72-99s30.3-85.5 72-99z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M340 683v77c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8v-77c41.7-13.5 72-52.8 72-99s-30.3-85.4-72-99V264c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v221c-41.7 13.5-72 52.8-72 99s30.3 85.4 72 99zm.1-116c.1-.2.2-.3.3-.5l1.5-2.4c0-.1.1-.1.1-.2l.9-1.2c0-.1.1-.2.2-.3 1-1.2 2.1-2.5 3.2-3.6l.2-.2c.4-.4.8-.7 1.2-1.1.8-.7 1.7-1.4 2.6-2.1h.1l1.2-.9c.1-.1.3-.2.4-.3 1.3-.8 2.6-1.5 3.9-2.2.2-.2.5-.3.7-.4.4-.2.7-.3 1.1-.5.3-.1.7-.3 1-.4.5-.1 1-.3 1.5-.5.4-.1.9-.3 1.3-.4l.9-.3 1.4-.3c.2-.1.5-.1.7-.2.7-.2 1.4-.3 2.1-.4.2-.1.4-.1.6-.1.5-.1 1.1-.2 1.7-.2.3-.1.5-.1.7-.1.8-.1 1.5-.1 2.3-.1s1.5.1 2.3.1c.3.1.5.1.7.1.6.1 1.1.1 1.7.2.2.1.4.1.6.1.7.1 1.4.3 2.1.4.2.1.5.1.7.2l1.4.3.9.3c.4.1.9.3 1.3.4.5.1 1 .3 1.5.5.3.1.7.3 1 .4.4.2.7.3 1.1.5.2.2.5.3.7.4 1.4.6 2.7 1.4 3.9 2.2.1.1.3.2.4.3l1.2.9h.1c.9.6 1.8 1.3 2.6 2.1.4.3.8.7 1.2 1.1l.2.2c1.2 1.1 2.2 2.3 3.2 3.6 0 .1.1.2.2.3l.9 1.2c0 .1.1.1.1.2l1.5 2.4A36.03 36.03 0 01408 584c0 6.1-1.6 11.9-4.3 17-.1.2-.2.3-.3.5l-1.5 2.4c0 .1-.1.1-.1.2l-.9 1.2c0 .1-.1.2-.2.3-1 1.2-2.1 2.5-3.2 3.6l-.2.2c-.4.4-.8.7-1.2 1.1-.8.7-1.7 1.4-2.6 2.1h-.1l-1.2.9c-.1.1-.3.2-.4.3-1.3.8-2.6 1.5-3.9 2.2-.2.2-.5.3-.7.4-.4.2-.7.3-1.1.5-.3.1-.7.3-1 .4-.5.1-1 .3-1.5.5-.4.1-.9.3-1.3.4l-.9.3-1.4.3c-.2.1-.5.1-.7.2-.7.2-1.4.3-2.1.4-.2.1-.4.1-.6.1-.5.1-1.1.2-1.7.2-.3.1-.5.1-.7.1-.8.1-1.5.1-2.3.1s-1.5-.1-2.3-.1c-.3-.1-.5-.1-.7-.1-.6-.1-1.1-.1-1.7-.2-.2-.1-.4-.1-.6-.1-.7-.1-1.4-.3-2.1-.4-.2-.1-.5-.1-.7-.2l-1.4-.3-.9-.3c-.4-.1-.9-.3-1.3-.4-.5-.1-1-.3-1.5-.5-.3-.1-.7-.3-1-.4-.4-.2-.7-.3-1.1-.5-.2-.2-.5-.3-.7-.4-1.4-.6-2.7-1.4-3.9-2.2-.1-.1-.3-.2-.4-.3l-1.2-.9h-.1c-.9-.6-1.8-1.3-2.6-2.1-.4-.3-.8-.7-1.2-1.1l-.2-.2c-1.2-1.1-2.2-2.3-3.2-3.6 0-.1-.1-.2-.2-.3l-.9-1.2c0-.1-.1-.1-.1-.2l-1.5-2.4c-.1-.2-.2-.3-.3-.5-2.7-5-4.3-10.9-4.3-17s1.6-11.9 4.3-17zm280.3-27.9c-.1 0-.2-.1-.4-.1v221c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V539c-.1 0-.2.1-.4.1 42-13.4 72.4-52.7 72.4-99.1 0-46.4-30.4-85.7-72.4-99.1.1 0 .2.1.4.1v-77c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v77c.1 0 .2-.1.4-.1-42 13.4-72.4 52.7-72.4 99.1 0 46.4 30.4 85.7 72.4 99.1zM652 404c19.9 0 36 16.1 36 36s-16.1 36-36 36-36-16.1-36-36 16.1-36 36-36z", "fill": primaryColor } }] }; }, "name": "control", "theme": "twotone" };
  exports.default = ControlTwoTone;
  });

  var ControlTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(ControlTwoTone_1);

  var ControlTwoTone = function ControlTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ControlTwoToneSvg
    }));
  };
  var RefIcon$2M = /*#__PURE__*/React.forwardRef(ControlTwoTone);
  {
    RefIcon$2M.displayName = 'ControlTwoTone';
  }

  var CopyFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CopyFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M832 64H296c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h496v688c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V96c0-17.7-14.3-32-32-32zM704 192H192c-17.7 0-32 14.3-32 32v530.7c0 8.5 3.4 16.6 9.4 22.6l173.3 173.3c2.2 2.2 4.7 4 7.4 5.5v1.9h4.2c3.5 1.3 7.2 2 11 2H704c17.7 0 32-14.3 32-32V224c0-17.7-14.3-32-32-32zM382 896h-.2L232 746.2v-.2h150v150z" } }] }, "name": "copy", "theme": "filled" };
  exports.default = CopyFilled;
  });

  var CopyFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(CopyFilled_1);

  var CopyFilled = function CopyFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CopyFilledSvg
    }));
  };
  var RefIcon$2N = /*#__PURE__*/React.forwardRef(CopyFilled);
  {
    RefIcon$2N.displayName = 'CopyFilled';
  }

  var CopyOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CopyOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M832 64H296c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h496v688c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V96c0-17.7-14.3-32-32-32zM704 192H192c-17.7 0-32 14.3-32 32v530.7c0 8.5 3.4 16.6 9.4 22.6l173.3 173.3c2.2 2.2 4.7 4 7.4 5.5v1.9h4.2c3.5 1.3 7.2 2 11 2H704c17.7 0 32-14.3 32-32V224c0-17.7-14.3-32-32-32zM350 856.2L263.9 770H350v86.2zM664 888H414V746c0-22.1-17.9-40-40-40H232V264h432v624z" } }] }, "name": "copy", "theme": "outlined" };
  exports.default = CopyOutlined;
  });

  var CopyOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(CopyOutlined_1);

  var CopyOutlined = function CopyOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CopyOutlinedSvg
    }));
  };
  var RefIcon$2O = /*#__PURE__*/React.forwardRef(CopyOutlined);
  {
    RefIcon$2O.displayName = 'CopyOutlined';
  }

  var CopyTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CopyTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M232 706h142c22.1 0 40 17.9 40 40v142h250V264H232v442z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M832 64H296c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h496v688c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V96c0-17.7-14.3-32-32-32z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M704 192H192c-17.7 0-32 14.3-32 32v530.7c0 8.5 3.4 16.6 9.4 22.6l173.3 173.3c2.2 2.2 4.7 4 7.4 5.5v1.9h4.2c3.5 1.3 7.2 2 11 2H704c17.7 0 32-14.3 32-32V224c0-17.7-14.3-32-32-32zM350 856.2L263.9 770H350v86.2zM664 888H414V746c0-22.1-17.9-40-40-40H232V264h432v624z", "fill": primaryColor } }] }; }, "name": "copy", "theme": "twotone" };
  exports.default = CopyTwoTone;
  });

  var CopyTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(CopyTwoTone_1);

  var CopyTwoTone = function CopyTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CopyTwoToneSvg
    }));
  };
  var RefIcon$2P = /*#__PURE__*/React.forwardRef(CopyTwoTone);
  {
    RefIcon$2P.displayName = 'CopyTwoTone';
  }

  var CopyrightCircleFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CopyrightCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm5.4 670c-110 0-173.4-73.2-173.4-194.9v-52.3C344 364.2 407.4 290 517.3 290c94.3 0 162.7 60.7 162.7 147.4 0 2.6-2.1 4.7-4.7 4.7h-56.7c-4.2 0-7.6-3.2-8-7.4-4-49.5-40-83.4-93-83.4-65.3 0-102.1 48.5-102.1 135.5v52.6c0 85.7 36.9 133.6 102.1 133.6 52.8 0 88.7-31.7 93-77.8.4-4.1 3.8-7.3 8-7.3h56.8c2.6 0 4.7 2.1 4.7 4.7 0 82.6-68.7 141.4-162.7 141.4z" } }] }, "name": "copyright-circle", "theme": "filled" };
  exports.default = CopyrightCircleFilled;
  });

  var CopyrightCircleFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(CopyrightCircleFilled_1);

  var CopyrightCircleFilled = function CopyrightCircleFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CopyrightCircleFilledSvg
    }));
  };
  var RefIcon$2Q = /*#__PURE__*/React.forwardRef(CopyrightCircleFilled);
  {
    RefIcon$2Q.displayName = 'CopyrightCircleFilled';
  }

  var CopyrightCircleOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CopyrightCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372zm5.6-532.7c53 0 89 33.8 93 83.4.3 4.2 3.8 7.4 8 7.4h56.7c2.6 0 4.7-2.1 4.7-4.7 0-86.7-68.4-147.4-162.7-147.4C407.4 290 344 364.2 344 486.8v52.3C344 660.8 407.4 734 517.3 734c94 0 162.7-58.8 162.7-141.4 0-2.6-2.1-4.7-4.7-4.7h-56.8c-4.2 0-7.6 3.2-8 7.3-4.2 46.1-40.1 77.8-93 77.8-65.3 0-102.1-47.9-102.1-133.6v-52.6c.1-87 37-135.5 102.2-135.5z" } }] }, "name": "copyright-circle", "theme": "outlined" };
  exports.default = CopyrightCircleOutlined;
  });

  var CopyrightCircleOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(CopyrightCircleOutlined_1);

  var CopyrightCircleOutlined = function CopyrightCircleOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CopyrightCircleOutlinedSvg
    }));
  };
  var RefIcon$2R = /*#__PURE__*/React.forwardRef(CopyrightCircleOutlined);
  {
    RefIcon$2R.displayName = 'CopyrightCircleOutlined';
  }

  var CopyrightCircleTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CopyrightCircleTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm5.5 533c52.9 0 88.8-31.7 93-77.8.4-4.1 3.8-7.3 8-7.3h56.8c2.6 0 4.7 2.1 4.7 4.7 0 82.6-68.7 141.4-162.7 141.4C407.4 734 344 660.8 344 539.1v-52.3C344 364.2 407.4 290 517.3 290c94.3 0 162.7 60.7 162.7 147.4 0 2.6-2.1 4.7-4.7 4.7h-56.7c-4.2 0-7.7-3.2-8-7.4-4-49.6-40-83.4-93-83.4-65.2 0-102.1 48.5-102.2 135.5v52.6c0 85.7 36.8 133.6 102.1 133.6z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M517.6 351.3c53 0 89 33.8 93 83.4.3 4.2 3.8 7.4 8 7.4h56.7c2.6 0 4.7-2.1 4.7-4.7 0-86.7-68.4-147.4-162.7-147.4C407.4 290 344 364.2 344 486.8v52.3C344 660.8 407.4 734 517.3 734c94 0 162.7-58.8 162.7-141.4 0-2.6-2.1-4.7-4.7-4.7h-56.8c-4.2 0-7.6 3.2-8 7.3-4.2 46.1-40.1 77.8-93 77.8-65.3 0-102.1-47.9-102.1-133.6v-52.6c.1-87 37-135.5 102.2-135.5z", "fill": primaryColor } }] }; }, "name": "copyright-circle", "theme": "twotone" };
  exports.default = CopyrightCircleTwoTone;
  });

  var CopyrightCircleTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(CopyrightCircleTwoTone_1);

  var CopyrightCircleTwoTone = function CopyrightCircleTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CopyrightCircleTwoToneSvg
    }));
  };
  var RefIcon$2S = /*#__PURE__*/React.forwardRef(CopyrightCircleTwoTone);
  {
    RefIcon$2S.displayName = 'CopyrightCircleTwoTone';
  }

  var CopyrightOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CopyrightOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372zm5.6-532.7c53 0 89 33.8 93 83.4.3 4.2 3.8 7.4 8 7.4h56.7c2.6 0 4.7-2.1 4.7-4.7 0-86.7-68.4-147.4-162.7-147.4C407.4 290 344 364.2 344 486.8v52.3C344 660.8 407.4 734 517.3 734c94 0 162.7-58.8 162.7-141.4 0-2.6-2.1-4.7-4.7-4.7h-56.8c-4.2 0-7.6 3.2-8 7.3-4.2 46.1-40.1 77.8-93 77.8-65.3 0-102.1-47.9-102.1-133.6v-52.6c.1-87 37-135.5 102.2-135.5z" } }] }, "name": "copyright", "theme": "outlined" };
  exports.default = CopyrightOutlined;
  });

  var CopyrightOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(CopyrightOutlined_1);

  var CopyrightOutlined = function CopyrightOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CopyrightOutlinedSvg
    }));
  };
  var RefIcon$2T = /*#__PURE__*/React.forwardRef(CopyrightOutlined);
  {
    RefIcon$2T.displayName = 'CopyrightOutlined';
  }

  var CopyrightTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CopyrightTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm5.5 533c52.9 0 88.8-31.7 93-77.8.4-4.1 3.8-7.3 8-7.3h56.8c2.6 0 4.7 2.1 4.7 4.7 0 82.6-68.7 141.4-162.7 141.4C407.4 734 344 660.8 344 539.1v-52.3C344 364.2 407.4 290 517.3 290c94.3 0 162.7 60.7 162.7 147.4 0 2.6-2.1 4.7-4.7 4.7h-56.7c-4.2 0-7.7-3.2-8-7.4-4-49.6-40-83.4-93-83.4-65.2 0-102.1 48.5-102.2 135.5v52.6c0 85.7 36.8 133.6 102.1 133.6z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M517.6 351.3c53 0 89 33.8 93 83.4.3 4.2 3.8 7.4 8 7.4h56.7c2.6 0 4.7-2.1 4.7-4.7 0-86.7-68.4-147.4-162.7-147.4C407.4 290 344 364.2 344 486.8v52.3C344 660.8 407.4 734 517.3 734c94 0 162.7-58.8 162.7-141.4 0-2.6-2.1-4.7-4.7-4.7h-56.8c-4.2 0-7.6 3.2-8 7.3-4.2 46.1-40.1 77.8-93 77.8-65.3 0-102.1-47.9-102.1-133.6v-52.6c.1-87 37-135.5 102.2-135.5z", "fill": primaryColor } }] }; }, "name": "copyright", "theme": "twotone" };
  exports.default = CopyrightTwoTone;
  });

  var CopyrightTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(CopyrightTwoTone_1);

  var CopyrightTwoTone = function CopyrightTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CopyrightTwoToneSvg
    }));
  };
  var RefIcon$2U = /*#__PURE__*/React.forwardRef(CopyrightTwoTone);
  {
    RefIcon$2U.displayName = 'CopyrightTwoTone';
  }

  var CreditCardFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CreditCardFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M928 160H96c-17.7 0-32 14.3-32 32v160h896V192c0-17.7-14.3-32-32-32zM64 832c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V440H64v392zm579-184c0-4.4 3.6-8 8-8h165c4.4 0 8 3.6 8 8v72c0 4.4-3.6 8-8 8H651c-4.4 0-8-3.6-8-8v-72z" } }] }, "name": "credit-card", "theme": "filled" };
  exports.default = CreditCardFilled;
  });

  var CreditCardFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(CreditCardFilled_1);

  var CreditCardFilled = function CreditCardFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CreditCardFilledSvg
    }));
  };
  var RefIcon$2V = /*#__PURE__*/React.forwardRef(CreditCardFilled);
  {
    RefIcon$2V.displayName = 'CreditCardFilled';
  }

  var CreditCardOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CreditCardOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M928 160H96c-17.7 0-32 14.3-32 32v640c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V192c0-17.7-14.3-32-32-32zm-792 72h752v120H136V232zm752 560H136V440h752v352zm-237-64h165c4.4 0 8-3.6 8-8v-72c0-4.4-3.6-8-8-8H651c-4.4 0-8 3.6-8 8v72c0 4.4 3.6 8 8 8z" } }] }, "name": "credit-card", "theme": "outlined" };
  exports.default = CreditCardOutlined;
  });

  var CreditCardOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(CreditCardOutlined_1);

  var CreditCardOutlined = function CreditCardOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CreditCardOutlinedSvg
    }));
  };
  var RefIcon$2W = /*#__PURE__*/React.forwardRef(CreditCardOutlined);
  {
    RefIcon$2W.displayName = 'CreditCardOutlined';
  }

  var CreditCardTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CreditCardTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M136 792h752V440H136v352zm507-144c0-4.4 3.6-8 8-8h165c4.4 0 8 3.6 8 8v72c0 4.4-3.6 8-8 8H651c-4.4 0-8-3.6-8-8v-72zM136 232h752v120H136z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M651 728h165c4.4 0 8-3.6 8-8v-72c0-4.4-3.6-8-8-8H651c-4.4 0-8 3.6-8 8v72c0 4.4 3.6 8 8 8z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M928 160H96c-17.7 0-32 14.3-32 32v640c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V192c0-17.7-14.3-32-32-32zm-40 632H136V440h752v352zm0-440H136V232h752v120z", "fill": primaryColor } }] }; }, "name": "credit-card", "theme": "twotone" };
  exports.default = CreditCardTwoTone;
  });

  var CreditCardTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(CreditCardTwoTone_1);

  var CreditCardTwoTone = function CreditCardTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CreditCardTwoToneSvg
    }));
  };
  var RefIcon$2X = /*#__PURE__*/React.forwardRef(CreditCardTwoTone);
  {
    RefIcon$2X.displayName = 'CreditCardTwoTone';
  }

  var CrownFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CrownFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M899.6 276.5L705 396.4 518.4 147.5a8.06 8.06 0 00-12.9 0L319 396.4 124.3 276.5c-5.7-3.5-13.1 1.2-12.2 7.9L188.5 865c1.1 7.9 7.9 14 16 14h615.1c8 0 14.9-6 15.9-14l76.4-580.6c.8-6.7-6.5-11.4-12.3-7.9zM512 734.2c-62.1 0-112.6-50.5-112.6-112.6S449.9 509 512 509s112.6 50.5 112.6 112.6S574.1 734.2 512 734.2zm0-160.9c-26.6 0-48.2 21.6-48.2 48.3 0 26.6 21.6 48.3 48.2 48.3s48.2-21.6 48.2-48.3c0-26.6-21.6-48.3-48.2-48.3z" } }] }, "name": "crown", "theme": "filled" };
  exports.default = CrownFilled;
  });

  var CrownFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(CrownFilled_1);

  var CrownFilled = function CrownFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CrownFilledSvg
    }));
  };
  var RefIcon$2Y = /*#__PURE__*/React.forwardRef(CrownFilled);
  {
    RefIcon$2Y.displayName = 'CrownFilled';
  }

  var CrownOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CrownOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M899.6 276.5L705 396.4 518.4 147.5a8.06 8.06 0 00-12.9 0L319 396.4 124.3 276.5c-5.7-3.5-13.1 1.2-12.2 7.9L188.5 865c1.1 7.9 7.9 14 16 14h615.1c8 0 14.9-6 15.9-14l76.4-580.6c.8-6.7-6.5-11.4-12.3-7.9zm-126 534.1H250.3l-53.8-409.4 139.8 86.1L512 252.9l175.7 234.4 139.8-86.1-53.9 409.4zM512 509c-62.1 0-112.6 50.5-112.6 112.6S449.9 734.2 512 734.2s112.6-50.5 112.6-112.6S574.1 509 512 509zm0 160.9c-26.6 0-48.2-21.6-48.2-48.3 0-26.6 21.6-48.3 48.2-48.3s48.2 21.6 48.2 48.3c0 26.6-21.6 48.3-48.2 48.3z" } }] }, "name": "crown", "theme": "outlined" };
  exports.default = CrownOutlined;
  });

  var CrownOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(CrownOutlined_1);

  var CrownOutlined = function CrownOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CrownOutlinedSvg
    }));
  };
  var RefIcon$2Z = /*#__PURE__*/React.forwardRef(CrownOutlined);
  {
    RefIcon$2Z.displayName = 'CrownOutlined';
  }

  var CrownTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CrownTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M911.9 283.9v.5L835.5 865c-1 8-7.9 14-15.9 14H204.5c-8.1 0-14.9-6.1-16-14l-76.4-580.6v-.6 1.6L188.5 866c1.1 7.9 7.9 14 16 14h615.1c8 0 14.9-6 15.9-14l76.4-580.6c.1-.5.1-1 0-1.5z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M773.6 810.6l53.9-409.4-139.8 86.1L512 252.9 336.3 487.3l-139.8-86.1 53.8 409.4h523.3zm-374.2-189c0-62.1 50.5-112.6 112.6-112.6s112.6 50.5 112.6 112.6v1c0 62.1-50.5 112.6-112.6 112.6s-112.6-50.5-112.6-112.6v-1z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M512 734.2c61.9 0 112.3-50.2 112.6-112.1v-.5c0-62.1-50.5-112.6-112.6-112.6s-112.6 50.5-112.6 112.6v.5c.3 61.9 50.7 112.1 112.6 112.1zm0-160.9c26.6 0 48.2 21.6 48.2 48.3 0 26.6-21.6 48.3-48.2 48.3s-48.2-21.6-48.2-48.3c0-26.6 21.6-48.3 48.2-48.3z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M188.5 865c1.1 7.9 7.9 14 16 14h615.1c8 0 14.9-6 15.9-14l76.4-580.6v-.5c.3-6.4-6.7-10.8-12.3-7.4L705 396.4 518.4 147.5a8.06 8.06 0 00-12.9 0L319 396.4 124.3 276.5c-5.5-3.4-12.6.9-12.2 7.3v.6L188.5 865zm147.8-377.7L512 252.9l175.7 234.4 139.8-86.1-53.9 409.4H250.3l-53.8-409.4 139.8 86.1z", "fill": primaryColor } }] }; }, "name": "crown", "theme": "twotone" };
  exports.default = CrownTwoTone;
  });

  var CrownTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(CrownTwoTone_1);

  var CrownTwoTone = function CrownTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CrownTwoToneSvg
    }));
  };
  var RefIcon$2_ = /*#__PURE__*/React.forwardRef(CrownTwoTone);
  {
    RefIcon$2_.displayName = 'CrownTwoTone';
  }

  var CustomerServiceFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CustomerServiceFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 128c-212.1 0-384 171.9-384 384v360c0 13.3 10.7 24 24 24h184c35.3 0 64-28.7 64-64V624c0-35.3-28.7-64-64-64H200v-48c0-172.3 139.7-312 312-312s312 139.7 312 312v48H688c-35.3 0-64 28.7-64 64v208c0 35.3 28.7 64 64 64h184c13.3 0 24-10.7 24-24V512c0-212.1-171.9-384-384-384z" } }] }, "name": "customer-service", "theme": "filled" };
  exports.default = CustomerServiceFilled;
  });

  var CustomerServiceFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(CustomerServiceFilled_1);

  var CustomerServiceFilled = function CustomerServiceFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CustomerServiceFilledSvg
    }));
  };
  var RefIcon$2$ = /*#__PURE__*/React.forwardRef(CustomerServiceFilled);
  {
    RefIcon$2$.displayName = 'CustomerServiceFilled';
  }

  var CustomerServiceOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CustomerServiceOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 128c-212.1 0-384 171.9-384 384v360c0 13.3 10.7 24 24 24h184c35.3 0 64-28.7 64-64V624c0-35.3-28.7-64-64-64H200v-48c0-172.3 139.7-312 312-312s312 139.7 312 312v48H688c-35.3 0-64 28.7-64 64v208c0 35.3 28.7 64 64 64h184c13.3 0 24-10.7 24-24V512c0-212.1-171.9-384-384-384zM328 632v192H200V632h128zm496 192H696V632h128v192z" } }] }, "name": "customer-service", "theme": "outlined" };
  exports.default = CustomerServiceOutlined;
  });

  var CustomerServiceOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(CustomerServiceOutlined_1);

  var CustomerServiceOutlined = function CustomerServiceOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CustomerServiceOutlinedSvg
    }));
  };
  var RefIcon$30 = /*#__PURE__*/React.forwardRef(CustomerServiceOutlined);
  {
    RefIcon$30.displayName = 'CustomerServiceOutlined';
  }

  var CustomerServiceTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var CustomerServiceTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M696 632h128v192H696zm-496 0h128v192H200z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M512 128c-212.1 0-384 171.9-384 384v360c0 13.3 10.7 24 24 24h184c35.3 0 64-28.7 64-64V624c0-35.3-28.7-64-64-64H200v-48c0-172.3 139.7-312 312-312s312 139.7 312 312v48H688c-35.3 0-64 28.7-64 64v208c0 35.3 28.7 64 64 64h184c13.3 0 24-10.7 24-24V512c0-212.1-171.9-384-384-384zM328 632v192H200V632h128zm496 192H696V632h128v192z", "fill": primaryColor } }] }; }, "name": "customer-service", "theme": "twotone" };
  exports.default = CustomerServiceTwoTone;
  });

  var CustomerServiceTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(CustomerServiceTwoTone_1);

  var CustomerServiceTwoTone = function CustomerServiceTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: CustomerServiceTwoToneSvg
    }));
  };
  var RefIcon$31 = /*#__PURE__*/React.forwardRef(CustomerServiceTwoTone);
  {
    RefIcon$31.displayName = 'CustomerServiceTwoTone';
  }

  var DashOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DashOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M112 476h160v72H112zm320 0h160v72H432zm320 0h160v72H752z" } }] }, "name": "dash", "theme": "outlined" };
  exports.default = DashOutlined;
  });

  var DashOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(DashOutlined_1);

  var DashOutlined = function DashOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DashOutlinedSvg
    }));
  };
  var RefIcon$32 = /*#__PURE__*/React.forwardRef(DashOutlined);
  {
    RefIcon$32.displayName = 'DashOutlined';
  }

  var DashboardFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DashboardFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M924.8 385.6a446.7 446.7 0 00-96-142.4 446.7 446.7 0 00-142.4-96C631.1 123.8 572.5 112 512 112s-119.1 11.8-174.4 35.2a446.7 446.7 0 00-142.4 96 446.7 446.7 0 00-96 142.4C75.8 440.9 64 499.5 64 560c0 132.7 58.3 257.7 159.9 343.1l1.7 1.4c5.8 4.8 13.1 7.5 20.6 7.5h531.7c7.5 0 14.8-2.7 20.6-7.5l1.7-1.4C901.7 817.7 960 692.7 960 560c0-60.5-11.9-119.1-35.2-174.4zM482 232c0-4.4 3.6-8 8-8h44c4.4 0 8 3.6 8 8v80c0 4.4-3.6 8-8 8h-44c-4.4 0-8-3.6-8-8v-80zM270 582c0 4.4-3.6 8-8 8h-80c-4.4 0-8-3.6-8-8v-44c0-4.4 3.6-8 8-8h80c4.4 0 8 3.6 8 8v44zm90.7-204.5l-31.1 31.1a8.03 8.03 0 01-11.3 0L261.7 352a8.03 8.03 0 010-11.3l31.1-31.1c3.1-3.1 8.2-3.1 11.3 0l56.6 56.6c3.1 3.1 3.1 8.2 0 11.3zm291.1 83.6l-84.5 84.5c5 18.7.2 39.4-14.5 54.1a55.95 55.95 0 01-79.2 0 55.95 55.95 0 010-79.2 55.87 55.87 0 0154.1-14.5l84.5-84.5c3.1-3.1 8.2-3.1 11.3 0l28.3 28.3c3.1 3.1 3.1 8.1 0 11.3zm43-52.4l-31.1-31.1a8.03 8.03 0 010-11.3l56.6-56.6c3.1-3.1 8.2-3.1 11.3 0l31.1 31.1c3.1 3.1 3.1 8.2 0 11.3l-56.6 56.6a8.03 8.03 0 01-11.3 0zM846 582c0 4.4-3.6 8-8 8h-80c-4.4 0-8-3.6-8-8v-44c0-4.4 3.6-8 8-8h80c4.4 0 8 3.6 8 8v44z" } }] }, "name": "dashboard", "theme": "filled" };
  exports.default = DashboardFilled;
  });

  var DashboardFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(DashboardFilled_1);

  var DashboardFilled = function DashboardFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DashboardFilledSvg
    }));
  };
  var RefIcon$33 = /*#__PURE__*/React.forwardRef(DashboardFilled);
  {
    RefIcon$33.displayName = 'DashboardFilled';
  }

  var DashboardOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DashboardOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M924.8 385.6a446.7 446.7 0 00-96-142.4 446.7 446.7 0 00-142.4-96C631.1 123.8 572.5 112 512 112s-119.1 11.8-174.4 35.2a446.7 446.7 0 00-142.4 96 446.7 446.7 0 00-96 142.4C75.8 440.9 64 499.5 64 560c0 132.7 58.3 257.7 159.9 343.1l1.7 1.4c5.8 4.8 13.1 7.5 20.6 7.5h531.7c7.5 0 14.8-2.7 20.6-7.5l1.7-1.4C901.7 817.7 960 692.7 960 560c0-60.5-11.9-119.1-35.2-174.4zM761.4 836H262.6A371.12 371.12 0 01140 560c0-99.4 38.7-192.8 109-263 70.3-70.3 163.7-109 263-109 99.4 0 192.8 38.7 263 109 70.3 70.3 109 163.7 109 263 0 105.6-44.5 205.5-122.6 276zM623.5 421.5a8.03 8.03 0 00-11.3 0L527.7 506c-18.7-5-39.4-.2-54.1 14.5a55.95 55.95 0 000 79.2 55.95 55.95 0 0079.2 0 55.87 55.87 0 0014.5-54.1l84.5-84.5c3.1-3.1 3.1-8.2 0-11.3l-28.3-28.3zM490 320h44c4.4 0 8-3.6 8-8v-80c0-4.4-3.6-8-8-8h-44c-4.4 0-8 3.6-8 8v80c0 4.4 3.6 8 8 8zm260 218v44c0 4.4 3.6 8 8 8h80c4.4 0 8-3.6 8-8v-44c0-4.4-3.6-8-8-8h-80c-4.4 0-8 3.6-8 8zm12.7-197.2l-31.1-31.1a8.03 8.03 0 00-11.3 0l-56.6 56.6a8.03 8.03 0 000 11.3l31.1 31.1c3.1 3.1 8.2 3.1 11.3 0l56.6-56.6c3.1-3.1 3.1-8.2 0-11.3zm-458.6-31.1a8.03 8.03 0 00-11.3 0l-31.1 31.1a8.03 8.03 0 000 11.3l56.6 56.6c3.1 3.1 8.2 3.1 11.3 0l31.1-31.1c3.1-3.1 3.1-8.2 0-11.3l-56.6-56.6zM262 530h-80c-4.4 0-8 3.6-8 8v44c0 4.4 3.6 8 8 8h80c4.4 0 8-3.6 8-8v-44c0-4.4-3.6-8-8-8z" } }] }, "name": "dashboard", "theme": "outlined" };
  exports.default = DashboardOutlined;
  });

  var DashboardOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(DashboardOutlined_1);

  var DashboardOutlined = function DashboardOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DashboardOutlinedSvg
    }));
  };
  var RefIcon$34 = /*#__PURE__*/React.forwardRef(DashboardOutlined);
  {
    RefIcon$34.displayName = 'DashboardOutlined';
  }

  var DashboardTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DashboardTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 188c-99.3 0-192.7 38.7-263 109-70.3 70.2-109 163.6-109 263 0 105.6 44.5 205.5 122.6 276h498.8A371.12 371.12 0 00884 560c0-99.3-38.7-192.7-109-263-70.2-70.3-163.6-109-263-109zm-30 44c0-4.4 3.6-8 8-8h44c4.4 0 8 3.6 8 8v80c0 4.4-3.6 8-8 8h-44c-4.4 0-8-3.6-8-8v-80zM270 582c0 4.4-3.6 8-8 8h-80c-4.4 0-8-3.6-8-8v-44c0-4.4 3.6-8 8-8h80c4.4 0 8 3.6 8 8v44zm90.7-204.4l-31.1 31.1a8.03 8.03 0 01-11.3 0l-56.6-56.6a8.03 8.03 0 010-11.3l31.1-31.1c3.1-3.1 8.2-3.1 11.3 0l56.6 56.6c3.1 3.1 3.1 8.2 0 11.3zm291.1 83.5l-84.5 84.5c5 18.7.2 39.4-14.5 54.1a55.95 55.95 0 01-79.2 0 55.95 55.95 0 010-79.2 55.87 55.87 0 0154.1-14.5l84.5-84.5c3.1-3.1 8.2-3.1 11.3 0l28.3 28.3c3.1 3.1 3.1 8.2 0 11.3zm43-52.4l-31.1-31.1a8.03 8.03 0 010-11.3l56.6-56.6c3.1-3.1 8.2-3.1 11.3 0l31.1 31.1c3.1 3.1 3.1 8.2 0 11.3l-56.6 56.6a8.03 8.03 0 01-11.3 0zM846 538v44c0 4.4-3.6 8-8 8h-80c-4.4 0-8-3.6-8-8v-44c0-4.4 3.6-8 8-8h80c4.4 0 8 3.6 8 8z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M623.5 421.5a8.03 8.03 0 00-11.3 0L527.7 506c-18.7-5-39.4-.2-54.1 14.5a55.95 55.95 0 000 79.2 55.95 55.95 0 0079.2 0 55.87 55.87 0 0014.5-54.1l84.5-84.5c3.1-3.1 3.1-8.2 0-11.3l-28.3-28.3zM490 320h44c4.4 0 8-3.6 8-8v-80c0-4.4-3.6-8-8-8h-44c-4.4 0-8 3.6-8 8v80c0 4.4 3.6 8 8 8z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M924.8 385.6a446.7 446.7 0 00-96-142.4 446.7 446.7 0 00-142.4-96C631.1 123.8 572.5 112 512 112s-119.1 11.8-174.4 35.2a446.7 446.7 0 00-142.4 96 446.7 446.7 0 00-96 142.4C75.8 440.9 64 499.5 64 560c0 132.7 58.3 257.7 159.9 343.1l1.7 1.4c5.8 4.8 13.1 7.5 20.6 7.5h531.7c7.5 0 14.8-2.7 20.6-7.5l1.7-1.4C901.7 817.7 960 692.7 960 560c0-60.5-11.9-119.1-35.2-174.4zM761.4 836H262.6A371.12 371.12 0 01140 560c0-99.4 38.7-192.8 109-263 70.3-70.3 163.7-109 263-109 99.4 0 192.8 38.7 263 109 70.3 70.3 109 163.7 109 263 0 105.6-44.5 205.5-122.6 276z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M762.7 340.8l-31.1-31.1a8.03 8.03 0 00-11.3 0l-56.6 56.6a8.03 8.03 0 000 11.3l31.1 31.1c3.1 3.1 8.2 3.1 11.3 0l56.6-56.6c3.1-3.1 3.1-8.2 0-11.3zM750 538v44c0 4.4 3.6 8 8 8h80c4.4 0 8-3.6 8-8v-44c0-4.4-3.6-8-8-8h-80c-4.4 0-8 3.6-8 8zM304.1 309.7a8.03 8.03 0 00-11.3 0l-31.1 31.1a8.03 8.03 0 000 11.3l56.6 56.6c3.1 3.1 8.2 3.1 11.3 0l31.1-31.1c3.1-3.1 3.1-8.2 0-11.3l-56.6-56.6zM262 530h-80c-4.4 0-8 3.6-8 8v44c0 4.4 3.6 8 8 8h80c4.4 0 8-3.6 8-8v-44c0-4.4-3.6-8-8-8z", "fill": primaryColor } }] }; }, "name": "dashboard", "theme": "twotone" };
  exports.default = DashboardTwoTone;
  });

  var DashboardTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(DashboardTwoTone_1);

  var DashboardTwoTone = function DashboardTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DashboardTwoToneSvg
    }));
  };
  var RefIcon$35 = /*#__PURE__*/React.forwardRef(DashboardTwoTone);
  {
    RefIcon$35.displayName = 'DashboardTwoTone';
  }

  var DatabaseFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DatabaseFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M832 64H192c-17.7 0-32 14.3-32 32v224h704V96c0-17.7-14.3-32-32-32zM288 232c-22.1 0-40-17.9-40-40s17.9-40 40-40 40 17.9 40 40-17.9 40-40 40zM160 928c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V704H160v224zm128-136c22.1 0 40 17.9 40 40s-17.9 40-40 40-40-17.9-40-40 17.9-40 40-40zM160 640h704V384H160v256zm128-168c22.1 0 40 17.9 40 40s-17.9 40-40 40-40-17.9-40-40 17.9-40 40-40z" } }] }, "name": "database", "theme": "filled" };
  exports.default = DatabaseFilled;
  });

  var DatabaseFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(DatabaseFilled_1);

  var DatabaseFilled = function DatabaseFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DatabaseFilledSvg
    }));
  };
  var RefIcon$36 = /*#__PURE__*/React.forwardRef(DatabaseFilled);
  {
    RefIcon$36.displayName = 'DatabaseFilled';
  }

  var DatabaseOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DatabaseOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M832 64H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V96c0-17.7-14.3-32-32-32zm-600 72h560v208H232V136zm560 480H232V408h560v208zm0 272H232V680h560v208zM304 240a40 40 0 1080 0 40 40 0 10-80 0zm0 272a40 40 0 1080 0 40 40 0 10-80 0zm0 272a40 40 0 1080 0 40 40 0 10-80 0z" } }] }, "name": "database", "theme": "outlined" };
  exports.default = DatabaseOutlined;
  });

  var DatabaseOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(DatabaseOutlined_1);

  var DatabaseOutlined = function DatabaseOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DatabaseOutlinedSvg
    }));
  };
  var RefIcon$37 = /*#__PURE__*/React.forwardRef(DatabaseOutlined);
  {
    RefIcon$37.displayName = 'DatabaseOutlined';
  }

  var DatabaseTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DatabaseTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M232 616h560V408H232v208zm112-144c22.1 0 40 17.9 40 40s-17.9 40-40 40-40-17.9-40-40 17.9-40 40-40zM232 888h560V680H232v208zm112-144c22.1 0 40 17.9 40 40s-17.9 40-40 40-40-17.9-40-40 17.9-40 40-40zM232 344h560V136H232v208zm112-144c22.1 0 40 17.9 40 40s-17.9 40-40 40-40-17.9-40-40 17.9-40 40-40z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M304 512a40 40 0 1080 0 40 40 0 10-80 0zm0 272a40 40 0 1080 0 40 40 0 10-80 0zm0-544a40 40 0 1080 0 40 40 0 10-80 0z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M832 64H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V96c0-17.7-14.3-32-32-32zm-40 824H232V680h560v208zm0-272H232V408h560v208zm0-272H232V136h560v208z", "fill": primaryColor } }] }; }, "name": "database", "theme": "twotone" };
  exports.default = DatabaseTwoTone;
  });

  var DatabaseTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(DatabaseTwoTone_1);

  var DatabaseTwoTone = function DatabaseTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DatabaseTwoToneSvg
    }));
  };
  var RefIcon$38 = /*#__PURE__*/React.forwardRef(DatabaseTwoTone);
  {
    RefIcon$38.displayName = 'DatabaseTwoTone';
  }

  var DeleteColumnOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DeleteColumnOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M651.1 641.9a7.84 7.84 0 00-5.1-1.9h-54.7c-2.4 0-4.6 1.1-6.1 2.9L512 730.7l-73.1-87.8a8.1 8.1 0 00-6.1-2.9H378c-1.9 0-3.7.7-5.1 1.9a7.97 7.97 0 00-1 11.3L474.2 776 371.8 898.9a8.06 8.06 0 006.1 13.2h54.7c2.4 0 4.6-1.1 6.1-2.9l73.1-87.8 73.1 87.8a8.1 8.1 0 006.1 2.9h55c1.9 0 3.7-.7 5.1-1.9 3.4-2.8 3.9-7.9 1-11.3L549.8 776l102.4-122.9c2.8-3.4 2.3-8.4-1.1-11.2zM472 544h80c4.4 0 8-3.6 8-8V120c0-4.4-3.6-8-8-8h-80c-4.4 0-8 3.6-8 8v416c0 4.4 3.6 8 8 8zM350 386H184V136c0-3.3-2.7-6-6-6h-60c-3.3 0-6 2.7-6 6v292c0 16.6 13.4 30 30 30h208c3.3 0 6-2.7 6-6v-60c0-3.3-2.7-6-6-6zm556-256h-60c-3.3 0-6 2.7-6 6v250H674c-3.3 0-6 2.7-6 6v60c0 3.3 2.7 6 6 6h208c16.6 0 30-13.4 30-30V136c0-3.3-2.7-6-6-6z" } }] }, "name": "delete-column", "theme": "outlined" };
  exports.default = DeleteColumnOutlined;
  });

  var DeleteColumnOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(DeleteColumnOutlined_1);

  var DeleteColumnOutlined = function DeleteColumnOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DeleteColumnOutlinedSvg
    }));
  };
  var RefIcon$39 = /*#__PURE__*/React.forwardRef(DeleteColumnOutlined);
  {
    RefIcon$39.displayName = 'DeleteColumnOutlined';
  }

  var DeleteFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DeleteFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M864 256H736v-80c0-35.3-28.7-64-64-64H352c-35.3 0-64 28.7-64 64v80H160c-17.7 0-32 14.3-32 32v32c0 4.4 3.6 8 8 8h60.4l24.7 523c1.6 34.1 29.8 61 63.9 61h454c34.2 0 62.3-26.8 63.9-61l24.7-523H888c4.4 0 8-3.6 8-8v-32c0-17.7-14.3-32-32-32zm-200 0H360v-72h304v72z" } }] }, "name": "delete", "theme": "filled" };
  exports.default = DeleteFilled;
  });

  var DeleteFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(DeleteFilled_1);

  var DeleteFilled = function DeleteFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DeleteFilledSvg
    }));
  };
  var RefIcon$3a = /*#__PURE__*/React.forwardRef(DeleteFilled);
  {
    RefIcon$3a.displayName = 'DeleteFilled';
  }

  var DeleteOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DeleteOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M360 184h-8c4.4 0 8-3.6 8-8v8h304v-8c0 4.4 3.6 8 8 8h-8v72h72v-80c0-35.3-28.7-64-64-64H352c-35.3 0-64 28.7-64 64v80h72v-72zm504 72H160c-17.7 0-32 14.3-32 32v32c0 4.4 3.6 8 8 8h60.4l24.7 523c1.6 34.1 29.8 61 63.9 61h454c34.2 0 62.3-26.8 63.9-61l24.7-523H888c4.4 0 8-3.6 8-8v-32c0-17.7-14.3-32-32-32zM731.3 840H292.7l-24.2-512h487l-24.2 512z" } }] }, "name": "delete", "theme": "outlined" };
  exports.default = DeleteOutlined;
  });

  var DeleteOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(DeleteOutlined_1);

  var DeleteOutlined = function DeleteOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DeleteOutlinedSvg
    }));
  };
  var RefIcon$3b = /*#__PURE__*/React.forwardRef(DeleteOutlined);
  {
    RefIcon$3b.displayName = 'DeleteOutlined';
  }

  var DeleteRowOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DeleteRowOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M819.8 512l102.4-122.9a8.06 8.06 0 00-6.1-13.2h-54.7c-2.4 0-4.6 1.1-6.1 2.9L782 466.7l-73.1-87.8a8.1 8.1 0 00-6.1-2.9H648c-1.9 0-3.7.7-5.1 1.9a7.97 7.97 0 00-1 11.3L744.2 512 641.8 634.9a8.06 8.06 0 006.1 13.2h54.7c2.4 0 4.6-1.1 6.1-2.9l73.1-87.8 73.1 87.8a8.1 8.1 0 006.1 2.9h55c1.9 0 3.7-.7 5.1-1.9 3.4-2.8 3.9-7.9 1-11.3L819.8 512zM536 464H120c-4.4 0-8 3.6-8 8v80c0 4.4 3.6 8 8 8h416c4.4 0 8-3.6 8-8v-80c0-4.4-3.6-8-8-8zm-84 204h-60c-3.3 0-6 2.7-6 6v166H136c-3.3 0-6 2.7-6 6v60c0 3.3 2.7 6 6 6h292c16.6 0 30-13.4 30-30V674c0-3.3-2.7-6-6-6zM136 184h250v166c0 3.3 2.7 6 6 6h60c3.3 0 6-2.7 6-6V142c0-16.6-13.4-30-30-30H136c-3.3 0-6 2.7-6 6v60c0 3.3 2.7 6 6 6z" } }] }, "name": "delete-row", "theme": "outlined" };
  exports.default = DeleteRowOutlined;
  });

  var DeleteRowOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(DeleteRowOutlined_1);

  var DeleteRowOutlined = function DeleteRowOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DeleteRowOutlinedSvg
    }));
  };
  var RefIcon$3c = /*#__PURE__*/React.forwardRef(DeleteRowOutlined);
  {
    RefIcon$3c.displayName = 'DeleteRowOutlined';
  }

  var DeleteTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DeleteTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M292.7 840h438.6l24.2-512h-487z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M864 256H736v-80c0-35.3-28.7-64-64-64H352c-35.3 0-64 28.7-64 64v80H160c-17.7 0-32 14.3-32 32v32c0 4.4 3.6 8 8 8h60.4l24.7 523c1.6 34.1 29.8 61 63.9 61h454c34.2 0 62.3-26.8 63.9-61l24.7-523H888c4.4 0 8-3.6 8-8v-32c0-17.7-14.3-32-32-32zm-504-72h304v72H360v-72zm371.3 656H292.7l-24.2-512h487l-24.2 512z", "fill": primaryColor } }] }; }, "name": "delete", "theme": "twotone" };
  exports.default = DeleteTwoTone;
  });

  var DeleteTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(DeleteTwoTone_1);

  var DeleteTwoTone = function DeleteTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DeleteTwoToneSvg
    }));
  };
  var RefIcon$3d = /*#__PURE__*/React.forwardRef(DeleteTwoTone);
  {
    RefIcon$3d.displayName = 'DeleteTwoTone';
  }

  var DeliveredProcedureOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DeliveredProcedureOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M632 698.3l141.9-112a8 8 0 000-12.6L632 461.7c-5.3-4.2-13-.4-13 6.3v76H295c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h324v76c0 6.7 7.8 10.4 13 6.3zm261.3-405L730.7 130.7c-7.5-7.5-16.7-13-26.7-16V112H144c-17.7 0-32 14.3-32 32v278c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V184h136v136c0 17.7 14.3 32 32 32h320c17.7 0 32-14.3 32-32V205.8l136 136V422c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-83.5c0-17-6.7-33.2-18.7-45.2zM640 288H384V184h256v104zm264 436h-56c-4.4 0-8 3.6-8 8v108H184V732c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v148c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V732c0-4.4-3.6-8-8-8z" } }] }, "name": "delivered-procedure", "theme": "outlined" };
  exports.default = DeliveredProcedureOutlined;
  });

  var DeliveredProcedureOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(DeliveredProcedureOutlined_1);

  var DeliveredProcedureOutlined = function DeliveredProcedureOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DeliveredProcedureOutlinedSvg
    }));
  };
  var RefIcon$3e = /*#__PURE__*/React.forwardRef(DeliveredProcedureOutlined);
  {
    RefIcon$3e.displayName = 'DeliveredProcedureOutlined';
  }

  var DeploymentUnitOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DeploymentUnitOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M888.3 693.2c-42.5-24.6-94.3-18-129.2 12.8l-53-30.7V523.6c0-15.7-8.4-30.3-22-38.1l-136-78.3v-67.1c44.2-15 76-56.8 76-106.1 0-61.9-50.1-112-112-112s-112 50.1-112 112c0 49.3 31.8 91.1 76 106.1v67.1l-136 78.3c-13.6 7.8-22 22.4-22 38.1v151.6l-53 30.7c-34.9-30.8-86.8-37.4-129.2-12.8-53.5 31-71.7 99.4-41 152.9 30.8 53.5 98.9 71.9 152.2 41 42.5-24.6 62.7-73 53.6-118.8l48.7-28.3 140.6 81c6.8 3.9 14.4 5.9 22 5.9s15.2-2 22-5.9L674.5 740l48.7 28.3c-9.1 45.7 11.2 94.2 53.6 118.8 53.3 30.9 121.5 12.6 152.2-41 30.8-53.6 12.6-122-40.7-152.9zm-673 138.4a47.6 47.6 0 01-65.2-17.6c-13.2-22.9-5.4-52.3 17.5-65.5a47.6 47.6 0 0165.2 17.6c13.2 22.9 5.4 52.3-17.5 65.5zM522 463.8zM464 234a48.01 48.01 0 0196 0 48.01 48.01 0 01-96 0zm170 446.2l-122 70.3-122-70.3V539.8l122-70.3 122 70.3v140.4zm239.9 133.9c-13.2 22.9-42.4 30.8-65.2 17.6-22.8-13.2-30.7-42.6-17.5-65.5s42.4-30.8 65.2-17.6c22.9 13.2 30.7 42.5 17.5 65.5z" } }] }, "name": "deployment-unit", "theme": "outlined" };
  exports.default = DeploymentUnitOutlined;
  });

  var DeploymentUnitOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(DeploymentUnitOutlined_1);

  var DeploymentUnitOutlined = function DeploymentUnitOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DeploymentUnitOutlinedSvg
    }));
  };
  var RefIcon$3f = /*#__PURE__*/React.forwardRef(DeploymentUnitOutlined);
  {
    RefIcon$3f.displayName = 'DeploymentUnitOutlined';
  }

  var DesktopOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DesktopOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M928 140H96c-17.7 0-32 14.3-32 32v496c0 17.7 14.3 32 32 32h380v112H304c-8.8 0-16 7.2-16 16v48c0 4.4 3.6 8 8 8h432c4.4 0 8-3.6 8-8v-48c0-8.8-7.2-16-16-16H548V700h380c17.7 0 32-14.3 32-32V172c0-17.7-14.3-32-32-32zm-40 488H136V212h752v416z" } }] }, "name": "desktop", "theme": "outlined" };
  exports.default = DesktopOutlined;
  });

  var DesktopOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(DesktopOutlined_1);

  var DesktopOutlined = function DesktopOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DesktopOutlinedSvg
    }));
  };
  var RefIcon$3g = /*#__PURE__*/React.forwardRef(DesktopOutlined);
  {
    RefIcon$3g.displayName = 'DesktopOutlined';
  }

  var DiffFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DiffFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.2 306.6L611.3 72.9c-6-5.7-13.9-8.9-22.2-8.9H296c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h277l219 210.6V824c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V329.6c0-8.7-3.5-17-9.8-23zM553.4 201.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v704c0 17.7 14.3 32 32 32h512c17.7 0 32-14.3 32-32V397.3c0-8.5-3.4-16.6-9.4-22.6L553.4 201.4zM568 753c0 3.8-3.4 7-7.5 7h-225c-4.1 0-7.5-3.2-7.5-7v-42c0-3.8 3.4-7 7.5-7h225c4.1 0 7.5 3.2 7.5 7v42zm0-220c0 3.8-3.4 7-7.5 7H476v84.9c0 3.9-3.1 7.1-7 7.1h-42c-3.8 0-7-3.2-7-7.1V540h-84.5c-4.1 0-7.5-3.2-7.5-7v-42c0-3.9 3.4-7 7.5-7H420v-84.9c0-3.9 3.2-7.1 7-7.1h42c3.9 0 7 3.2 7 7.1V484h84.5c4.1 0 7.5 3.1 7.5 7v42z" } }] }, "name": "diff", "theme": "filled" };
  exports.default = DiffFilled;
  });

  var DiffFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(DiffFilled_1);

  var DiffFilled = function DiffFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DiffFilledSvg
    }));
  };
  var RefIcon$3h = /*#__PURE__*/React.forwardRef(DiffFilled);
  {
    RefIcon$3h.displayName = 'DiffFilled';
  }

  var DiffOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DiffOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M476 399.1c0-3.9-3.1-7.1-7-7.1h-42c-3.8 0-7 3.2-7 7.1V484h-84.5c-4.1 0-7.5 3.1-7.5 7v42c0 3.8 3.4 7 7.5 7H420v84.9c0 3.9 3.2 7.1 7 7.1h42c3.9 0 7-3.2 7-7.1V540h84.5c4.1 0 7.5-3.2 7.5-7v-42c0-3.9-3.4-7-7.5-7H476v-84.9zM560.5 704h-225c-4.1 0-7.5 3.2-7.5 7v42c0 3.8 3.4 7 7.5 7h225c4.1 0 7.5-3.2 7.5-7v-42c0-3.8-3.4-7-7.5-7zm-7.1-502.6c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v704c0 17.7 14.3 32 32 32h512c17.7 0 32-14.3 32-32V397.3c0-8.5-3.4-16.6-9.4-22.6L553.4 201.4zM664 888H232V264h282.2L664 413.8V888zm190.2-581.4L611.3 72.9c-6-5.7-13.9-8.9-22.2-8.9H296c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h277l219 210.6V824c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V329.6c0-8.7-3.5-17-9.8-23z" } }] }, "name": "diff", "theme": "outlined" };
  exports.default = DiffOutlined;
  });

  var DiffOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(DiffOutlined_1);

  var DiffOutlined = function DiffOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DiffOutlinedSvg
    }));
  };
  var RefIcon$3i = /*#__PURE__*/React.forwardRef(DiffOutlined);
  {
    RefIcon$3i.displayName = 'DiffOutlined';
  }

  var DiffTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DiffTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M232 264v624h432V413.8L514.2 264H232zm336 489c0 3.8-3.4 7-7.5 7h-225c-4.1 0-7.5-3.2-7.5-7v-42c0-3.8 3.4-7 7.5-7h225c4.1 0 7.5 3.2 7.5 7v42zm0-262v42c0 3.8-3.4 7-7.5 7H476v84.9c0 3.9-3.1 7.1-7 7.1h-42c-3.8 0-7-3.2-7-7.1V540h-84.5c-4.1 0-7.5-3.2-7.5-7v-42c0-3.9 3.4-7 7.5-7H420v-84.9c0-3.9 3.2-7.1 7-7.1h42c3.9 0 7 3.2 7 7.1V484h84.5c4.1 0 7.5 3.1 7.5 7z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M854.2 306.6L611.3 72.9c-6-5.7-13.9-8.9-22.2-8.9H296c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h277l219 210.6V824c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V329.6c0-8.7-3.5-17-9.8-23z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M553.4 201.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v704c0 17.7 14.3 32 32 32h512c17.7 0 32-14.3 32-32V397.3c0-8.5-3.4-16.6-9.4-22.6L553.4 201.4zM664 888H232V264h282.2L664 413.8V888z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M476 399.1c0-3.9-3.1-7.1-7-7.1h-42c-3.8 0-7 3.2-7 7.1V484h-84.5c-4.1 0-7.5 3.1-7.5 7v42c0 3.8 3.4 7 7.5 7H420v84.9c0 3.9 3.2 7.1 7 7.1h42c3.9 0 7-3.2 7-7.1V540h84.5c4.1 0 7.5-3.2 7.5-7v-42c0-3.9-3.4-7-7.5-7H476v-84.9zM560.5 704h-225c-4.1 0-7.5 3.2-7.5 7v42c0 3.8 3.4 7 7.5 7h225c4.1 0 7.5-3.2 7.5-7v-42c0-3.8-3.4-7-7.5-7z", "fill": primaryColor } }] }; }, "name": "diff", "theme": "twotone" };
  exports.default = DiffTwoTone;
  });

  var DiffTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(DiffTwoTone_1);

  var DiffTwoTone = function DiffTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DiffTwoToneSvg
    }));
  };
  var RefIcon$3j = /*#__PURE__*/React.forwardRef(DiffTwoTone);
  {
    RefIcon$3j.displayName = 'DiffTwoTone';
  }

  var DingdingOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DingdingOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M573.7 252.5C422.5 197.4 201.3 96.7 201.3 96.7c-15.7-4.1-17.9 11.1-17.9 11.1-5 61.1 33.6 160.5 53.6 182.8 19.9 22.3 319.1 113.7 319.1 113.7S326 357.9 270.5 341.9c-55.6-16-37.9 17.8-37.9 17.8 11.4 61.7 64.9 131.8 107.2 138.4 42.2 6.6 220.1 4 220.1 4s-35.5 4.1-93.2 11.9c-42.7 5.8-97 12.5-111.1 17.8-33.1 12.5 24 62.6 24 62.6 84.7 76.8 129.7 50.5 129.7 50.5 33.3-10.7 61.4-18.5 85.2-24.2L565 743.1h84.6L603 928l205.3-271.9H700.8l22.3-38.7c.3.5.4.8.4.8S799.8 496.1 829 433.8l.6-1h-.1c5-10.8 8.6-19.7 10-25.8 17-71.3-114.5-99.4-265.8-154.5z" } }] }, "name": "dingding", "theme": "outlined" };
  exports.default = DingdingOutlined;
  });

  var DingdingOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(DingdingOutlined_1);

  var DingdingOutlined = function DingdingOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DingdingOutlinedSvg
    }));
  };
  var RefIcon$3k = /*#__PURE__*/React.forwardRef(DingdingOutlined);
  {
    RefIcon$3k.displayName = 'DingdingOutlined';
  }

  var DingtalkCircleFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DingtalkCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm227 385.3c-1 4.2-3.5 10.4-7 17.8h.1l-.4.7c-20.3 43.1-73.1 127.7-73.1 127.7s-.1-.2-.3-.5l-15.5 26.8h74.5L575.1 810l32.3-128h-58.6l20.4-84.7c-16.5 3.9-35.9 9.4-59 16.8 0 0-31.2 18.2-89.9-35 0 0-39.6-34.7-16.6-43.4 9.8-3.7 47.4-8.4 77-12.3 40-5.4 64.6-8.2 64.6-8.2S422 517 392.7 512.5c-29.3-4.6-66.4-53.1-74.3-95.8 0 0-12.2-23.4 26.3-12.3 38.5 11.1 197.9 43.2 197.9 43.2s-207.4-63.3-221.2-78.7c-13.8-15.4-40.6-84.2-37.1-126.5 0 0 1.5-10.5 12.4-7.7 0 0 153.3 69.7 258.1 107.9 104.8 37.9 195.9 57.3 184.2 106.7z" } }] }, "name": "dingtalk-circle", "theme": "filled" };
  exports.default = DingtalkCircleFilled;
  });

  var DingtalkCircleFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(DingtalkCircleFilled_1);

  var DingtalkCircleFilled = function DingtalkCircleFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DingtalkCircleFilledSvg
    }));
  };
  var RefIcon$3l = /*#__PURE__*/React.forwardRef(DingtalkCircleFilled);
  {
    RefIcon$3l.displayName = 'DingtalkCircleFilled';
  }

  var DingtalkOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DingtalkOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M573.7 252.5C422.5 197.4 201.3 96.7 201.3 96.7c-15.7-4.1-17.9 11.1-17.9 11.1-5 61.1 33.6 160.5 53.6 182.8 19.9 22.3 319.1 113.7 319.1 113.7S326 357.9 270.5 341.9c-55.6-16-37.9 17.8-37.9 17.8 11.4 61.7 64.9 131.8 107.2 138.4 42.2 6.6 220.1 4 220.1 4s-35.5 4.1-93.2 11.9c-42.7 5.8-97 12.5-111.1 17.8-33.1 12.5 24 62.6 24 62.6 84.7 76.8 129.7 50.5 129.7 50.5 33.3-10.7 61.4-18.5 85.2-24.2L565 743.1h84.6L603 928l205.3-271.9H700.8l22.3-38.7c.3.5.4.8.4.8S799.8 496.1 829 433.8l.6-1h-.1c5-10.8 8.6-19.7 10-25.8 17-71.3-114.5-99.4-265.8-154.5z" } }] }, "name": "dingtalk", "theme": "outlined" };
  exports.default = DingtalkOutlined;
  });

  var DingtalkOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(DingtalkOutlined_1);

  var DingtalkOutlined = function DingtalkOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DingtalkOutlinedSvg
    }));
  };
  var RefIcon$3m = /*#__PURE__*/React.forwardRef(DingtalkOutlined);
  {
    RefIcon$3m.displayName = 'DingtalkOutlined';
  }

  var DingtalkSquareFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DingtalkSquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM739 449.3c-1 4.2-3.5 10.4-7 17.8h.1l-.4.7c-20.3 43.1-73.1 127.7-73.1 127.7s-.1-.2-.3-.5l-15.5 26.8h74.5L575.1 810l32.3-128h-58.6l20.4-84.7c-16.5 3.9-35.9 9.4-59 16.8 0 0-31.2 18.2-89.9-35 0 0-39.6-34.7-16.6-43.4 9.8-3.7 47.4-8.4 77-12.3 40-5.4 64.6-8.2 64.6-8.2S422 517 392.7 512.5c-29.3-4.6-66.4-53.1-74.3-95.8 0 0-12.2-23.4 26.3-12.3 38.5 11.1 197.9 43.2 197.9 43.2s-207.4-63.3-221.2-78.7c-13.8-15.4-40.6-84.2-37.1-126.5 0 0 1.5-10.5 12.4-7.7 0 0 153.3 69.7 258.1 107.9 104.8 37.9 195.9 57.3 184.2 106.7z" } }] }, "name": "dingtalk-square", "theme": "filled" };
  exports.default = DingtalkSquareFilled;
  });

  var DingtalkSquareFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(DingtalkSquareFilled_1);

  var DingtalkSquareFilled = function DingtalkSquareFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DingtalkSquareFilledSvg
    }));
  };
  var RefIcon$3n = /*#__PURE__*/React.forwardRef(DingtalkSquareFilled);
  {
    RefIcon$3n.displayName = 'DingtalkSquareFilled';
  }

  var DisconnectOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DisconnectOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M832.6 191.4c-84.6-84.6-221.5-84.6-306 0l-96.9 96.9 51 51 96.9-96.9c53.8-53.8 144.6-59.5 204 0 59.5 59.5 53.8 150.2 0 204l-96.9 96.9 51.1 51.1 96.9-96.9c84.4-84.6 84.4-221.5-.1-306.1zM446.5 781.6c-53.8 53.8-144.6 59.5-204 0-59.5-59.5-53.8-150.2 0-204l96.9-96.9-51.1-51.1-96.9 96.9c-84.6 84.6-84.6 221.5 0 306s221.5 84.6 306 0l96.9-96.9-51-51-96.8 97zM260.3 209.4a8.03 8.03 0 00-11.3 0L209.4 249a8.03 8.03 0 000 11.3l554.4 554.4c3.1 3.1 8.2 3.1 11.3 0l39.6-39.6c3.1-3.1 3.1-8.2 0-11.3L260.3 209.4z" } }] }, "name": "disconnect", "theme": "outlined" };
  exports.default = DisconnectOutlined;
  });

  var DisconnectOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(DisconnectOutlined_1);

  var DisconnectOutlined = function DisconnectOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DisconnectOutlinedSvg
    }));
  };
  var RefIcon$3o = /*#__PURE__*/React.forwardRef(DisconnectOutlined);
  {
    RefIcon$3o.displayName = 'DisconnectOutlined';
  }

  var DiscordFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DiscordFilled = { "icon": { "tag": "svg", "attrs": { "fill-rule": "evenodd", "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M811.15 87c51.16 0 92.41 41.36 94.85 90.03V960l-97.4-82.68-53.48-48.67-58.35-50.85 24.37 80.2H210.41c-51 0-92.41-38.74-92.41-90.06V177.21c0-48.67 41.48-90.1 92.6-90.1h600.3zM588.16 294.1h-1.09l-7.34 7.28c75.38 21.8 111.85 55.86 111.85 55.86-48.58-24.28-92.36-36.42-136.14-41.32-31.64-4.91-63.28-2.33-90 0h-7.28c-17.09 0-53.45 7.27-102.18 26.7-16.98 7.39-26.72 12.22-26.72 12.22s36.43-36.42 116.72-55.86l-4.9-4.9s-60.8-2.33-126.44 46.15c0 0-65.64 114.26-65.64 255.13 0 0 36.36 63.24 136.11 65.64 0 0 14.55-19.37 29.27-36.42-56-17-77.82-51.02-77.82-51.02s4.88 2.4 12.19 7.27h2.18c1.09 0 1.6.54 2.18 1.09v.21c.58.59 1.09 1.1 2.18 1.1 12 4.94 24 9.8 33.82 14.53a297.58 297.58 0 0065.45 19.48c33.82 4.9 72.59 7.27 116.73 0 21.82-4.9 43.64-9.7 65.46-19.44 14.18-7.27 31.63-14.54 50.8-26.79 0 0-21.82 34.02-80.19 51.03 12 16.94 28.91 36.34 28.91 36.34 99.79-2.18 138.55-65.42 140.73-62.73 0-140.65-66-255.13-66-255.13-59.45-44.12-115.09-45.8-124.91-45.8l2.04-.72zM595 454c25.46 0 46 21.76 46 48.41 0 26.83-20.65 48.59-46 48.59s-46-21.76-46-48.37c.07-26.84 20.75-48.52 46-48.52zm-165.85 0c25.35 0 45.85 21.76 45.85 48.41 0 26.83-20.65 48.59-46 48.59s-46-21.76-46-48.37c0-26.84 20.65-48.52 46-48.52z" } }] }, "name": "discord", "theme": "filled" };
  exports.default = DiscordFilled;
  });

  var DiscordFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(DiscordFilled_1);

  var DiscordFilled = function DiscordFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DiscordFilledSvg
    }));
  };
  var RefIcon$3p = /*#__PURE__*/React.forwardRef(DiscordFilled);
  {
    RefIcon$3p.displayName = 'DiscordFilled';
  }

  var DiscordOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DiscordOutlined = { "icon": { "tag": "svg", "attrs": { "fill-rule": "evenodd", "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M405 158l-25 3s-112.13 12.26-194.02 78.02h-.96l-1.02.96c-18.37 16.9-26.37 37.67-39 68.04a982.08 982.08 0 00-38 112C83.27 505.87 64 609.87 64 705v8l4 8c29.63 52 82.24 85.12 131 108 48.74 22.88 90.89 35 120 36l19.02.99 9.98-17 35-62c37.13 8.38 79.88 14 129 14 49.12 0 91.87-5.62 129-14l35 62 10.02 17 18.97-1c29.12-.98 71.27-13.11 120-36 48.77-22.87 101.38-56 131.01-108l4-8v-8c0-95.13-19.26-199.13-43-284.98a982.08 982.08 0 00-38-112c-12.63-30.4-20.63-51.14-39-68l-1-1.03h-1.02C756.16 173.26 644 161.01 644 161.01L619 158l-9.02 23s-9.24 23.37-14.97 50.02a643.04 643.04 0 00-83.01-6.01c-17.12 0-46.72 1.12-83 6.01a359.85 359.85 0 00-15.02-50.01zm-44 73.02c1.37 4.48 2.74 8.36 4 12-41.38 10.24-85.51 25.86-126 50.98l34 54.02C356 296.5 475.22 289 512 289c36.74 0 156 7.49 239 59L785 294c-40.49-25.12-84.62-40.74-126-51 1.26-3.62 2.63-7.5 4-12 29.86 6 86.89 19.77 134 57.02-.26.12 12 18.62 23 44.99 11.26 27.13 23.74 63.26 35 104 21.64 78.11 38.63 173.25 40 256.99-20.15 30.75-57.5 58.5-97.02 77.02A311.8 311.8 0 01720 795.98l-16-26.97c9.5-3.52 18.88-7.36 27-11.01 49.26-21.63 76-45 76-45l-42-48s-18 16.52-60 35.02C663.03 718.52 598.87 737 512 737s-151-18.5-193-37c-42-18.49-60-35-60-35l-42 48s26.74 23.36 76 44.99a424.47 424.47 0 0027 11l-16 27.02a311.8 311.8 0 01-78.02-25.03c-39.48-18.5-76.86-46.24-96.96-76.99 1.35-83.74 18.34-178.88 40-257A917.22 917.22 0 01204 333c11-26.36 23.26-44.86 23-44.98 47.11-37.25 104.14-51.01 134-57m39 217.99c-24.74 0-46.62 14.11-60 32-13.38 17.89-20 39.87-20 64s6.62 46.11 20 64c13.38 17.89 35.26 32 60 32 24.74 0 46.62-14.11 60-32 13.38-17.89 20-39.87 20-64s-6.62-46.11-20-64c-13.38-17.89-35.26-32-60-32m224 0c-24.74 0-46.62 14.11-60 32-13.38 17.89-20 39.87-20 64s6.62 46.11 20 64c13.38 17.89 35.26 32 60 32 24.74 0 46.62-14.11 60-32 13.38-17.89 20-39.87 20-64s-6.62-46.11-20-64c-13.38-17.89-35.26-32-60-32m-224 64c1.76 0 4 .64 8 6.01 4 5.35 8 14.72 8 25.99 0 11.26-4 20.64-8 26.01-4 5.35-6.24 5.99-8 5.99-1.76 0-4-.64-8-6.02a44.83 44.83 0 01-8-25.98c0-11.27 4-20.64 8-26.02 4-5.34 6.24-5.98 8-5.98m224 0c1.76 0 4 .64 8 6.01 4 5.35 8 14.72 8 25.99 0 11.26-4 20.64-8 26.01-4 5.35-6.24 5.99-8 5.99-1.76 0-4-.64-8-6.02a44.83 44.83 0 01-8-25.98c0-11.27 4-20.64 8-26.02 4-5.34 6.24-5.98 8-5.98" } }] }, "name": "discord", "theme": "outlined" };
  exports.default = DiscordOutlined;
  });

  var DiscordOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(DiscordOutlined_1);

  var DiscordOutlined = function DiscordOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DiscordOutlinedSvg
    }));
  };
  var RefIcon$3q = /*#__PURE__*/React.forwardRef(DiscordOutlined);
  {
    RefIcon$3q.displayName = 'DiscordOutlined';
  }

  var DislikeFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DislikeFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M885.9 490.3c3.6-12 5.4-24.4 5.4-37 0-28.3-9.3-55.5-26.1-77.7 3.6-12 5.4-24.4 5.4-37 0-28.3-9.3-55.5-26.1-77.7 3.6-12 5.4-24.4 5.4-37 0-51.6-30.7-98.1-78.3-118.4a66.1 66.1 0 00-26.5-5.4H273v428h.3l85.8 310.8C372.9 889 418.9 924 470.9 924c29.7 0 57.4-11.8 77.9-33.4 20.5-21.5 31-49.7 29.5-79.4l-6-122.9h239.9c12.1 0 23.9-3.2 34.3-9.3 40.4-23.5 65.5-66.1 65.5-111 0-28.3-9.3-55.5-26.1-77.7zM112 132v364c0 17.7 14.3 32 32 32h65V100h-65c-17.7 0-32 14.3-32 32z" } }] }, "name": "dislike", "theme": "filled" };
  exports.default = DislikeFilled;
  });

  var DislikeFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(DislikeFilled_1);

  var DislikeFilled = function DislikeFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DislikeFilledSvg
    }));
  };
  var RefIcon$3r = /*#__PURE__*/React.forwardRef(DislikeFilled);
  {
    RefIcon$3r.displayName = 'DislikeFilled';
  }

  var DislikeOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DislikeOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M885.9 490.3c3.6-12 5.4-24.4 5.4-37 0-28.3-9.3-55.5-26.1-77.7 3.6-12 5.4-24.4 5.4-37 0-28.3-9.3-55.5-26.1-77.7 3.6-12 5.4-24.4 5.4-37 0-51.6-30.7-98.1-78.3-118.4a66.1 66.1 0 00-26.5-5.4H144c-17.7 0-32 14.3-32 32v364c0 17.7 14.3 32 32 32h129.3l85.8 310.8C372.9 889 418.9 924 470.9 924c29.7 0 57.4-11.8 77.9-33.4 20.5-21.5 31-49.7 29.5-79.4l-6-122.9h239.9c12.1 0 23.9-3.2 34.3-9.3 40.4-23.5 65.5-66.1 65.5-111 0-28.3-9.3-55.5-26.1-77.7zM184 456V172h81v284h-81zm627.2 160.4H496.8l9.6 198.4c.6 11.9-4.7 23.1-14.6 30.5-6.1 4.5-13.6 6.8-21.1 6.7a44.28 44.28 0 01-42.2-32.3L329 459.2V172h415.4a56.85 56.85 0 0133.6 51.8c0 9.7-2.3 18.9-6.9 27.3l-13.9 25.4 21.9 19a56.76 56.76 0 0119.6 43c0 9.7-2.3 18.9-6.9 27.3l-13.9 25.4 21.9 19a56.76 56.76 0 0119.6 43c0 9.7-2.3 18.9-6.9 27.3l-14 25.5 21.9 19a56.76 56.76 0 0119.6 43c0 19.1-11 37.5-28.8 48.4z" } }] }, "name": "dislike", "theme": "outlined" };
  exports.default = DislikeOutlined;
  });

  var DislikeOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(DislikeOutlined_1);

  var DislikeOutlined = function DislikeOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DislikeOutlinedSvg
    }));
  };
  var RefIcon$3s = /*#__PURE__*/React.forwardRef(DislikeOutlined);
  {
    RefIcon$3s.displayName = 'DislikeOutlined';
  }

  var DislikeTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DislikeTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M273 100.1v428h.3l-.3-428zM820.4 525l-21.9-19 14-25.5a56.2 56.2 0 006.9-27.3c0-16.5-7.1-32.2-19.6-43l-21.9-19 13.9-25.4a56.2 56.2 0 006.9-27.3c0-16.5-7.1-32.2-19.6-43l-21.9-19 13.9-25.4a56.2 56.2 0 006.9-27.3c0-22.4-13.2-42.6-33.6-51.8H345v345.2c18.6 67.2 46.4 168 83.5 302.5a44.28 44.28 0 0042.2 32.3c7.5.1 15-2.2 21.1-6.7 9.9-7.4 15.2-18.6 14.6-30.5l-9.6-198.4h314.4C829 605.5 840 587.1 840 568c0-16.5-7.1-32.2-19.6-43z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M112 132v364c0 17.7 14.3 32 32 32h65V100h-65c-17.7 0-32 14.3-32 32zm773.9 358.3c3.6-12 5.4-24.4 5.4-37 0-28.3-9.3-55.5-26.1-77.7 3.6-12 5.4-24.4 5.4-37 0-28.3-9.3-55.5-26.1-77.7 3.6-12 5.4-24.4 5.4-37 0-51.6-30.7-98.1-78.3-118.4a66.1 66.1 0 00-26.5-5.4H273l.3 428 85.8 310.8C372.9 889 418.9 924 470.9 924c29.7 0 57.4-11.8 77.9-33.4 20.5-21.5 31-49.7 29.5-79.4l-6-122.9h239.9c12.1 0 23.9-3.2 34.3-9.3 40.4-23.5 65.5-66.1 65.5-111 0-28.3-9.3-55.5-26.1-77.7zm-74.7 126.1H496.8l9.6 198.4c.6 11.9-4.7 23.1-14.6 30.5-6.1 4.5-13.6 6.8-21.1 6.7a44.28 44.28 0 01-42.2-32.3c-37.1-134.4-64.9-235.2-83.5-302.5V172h399.4a56.85 56.85 0 0133.6 51.8c0 9.7-2.3 18.9-6.9 27.3l-13.9 25.4 21.9 19a56.76 56.76 0 0119.6 43c0 9.7-2.3 18.9-6.9 27.3l-13.9 25.4 21.9 19a56.76 56.76 0 0119.6 43c0 9.7-2.3 18.9-6.9 27.3l-14 25.5 21.9 19a56.76 56.76 0 0119.6 43c0 19.1-11 37.5-28.8 48.4z", "fill": primaryColor } }] }; }, "name": "dislike", "theme": "twotone" };
  exports.default = DislikeTwoTone;
  });

  var DislikeTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(DislikeTwoTone_1);

  var DislikeTwoTone = function DislikeTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DislikeTwoToneSvg
    }));
  };
  var RefIcon$3t = /*#__PURE__*/React.forwardRef(DislikeTwoTone);
  {
    RefIcon$3t.displayName = 'DislikeTwoTone';
  }

  var DockerOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DockerOutlined = { "icon": { "tag": "svg", "attrs": { "fill-rule": "evenodd", "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M555.88 488.24h-92.62v-82.79h92.62zm0-286.24h-92.62v85.59h92.62zm109.45 203.45H572.7v82.79h92.62zm-218.9-101.02h-92.61v84.18h92.6zm109.45 0h-92.61v84.18h92.6zm388.69 140.3c-19.65-14.02-67.36-18.23-102.44-11.22-4.2-33.67-23.85-63.14-57.53-89.8l-19.65-12.62-12.62 19.64c-25.26 39.29-32.28 103.83-5.62 145.92-12.63 7.02-36.48 15.44-67.35 15.44H67.56c-12.63 71.56 8.42 164.16 61.74 227.3C181.22 801.13 259.8 832 360.83 832c220.3 0 384.48-101.02 460.25-286.24 29.47 0 95.42 0 127.7-63.14 1.4-2.8 9.82-18.24 11.22-23.85zm-717.04-39.28h-92.61v82.79h92.6zm109.45 0h-92.61v82.79h92.6zm109.45 0h-92.61v82.79h92.6zM336.98 304.43h-92.61v84.19h92.6z" } }] }, "name": "docker", "theme": "outlined" };
  exports.default = DockerOutlined;
  });

  var DockerOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(DockerOutlined_1);

  var DockerOutlined = function DockerOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DockerOutlinedSvg
    }));
  };
  var RefIcon$3u = /*#__PURE__*/React.forwardRef(DockerOutlined);
  {
    RefIcon$3u.displayName = 'DockerOutlined';
  }

  var DollarCircleFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DollarCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm22.3 665.2l.2 31.7c0 4.4-3.6 8.1-8 8.1h-28.4c-4.4 0-8-3.6-8-8v-31.4C401.3 723 359.5 672.4 355 617.4c-.4-4.7 3.3-8.7 8-8.7h46.2c3.9 0 7.3 2.8 7.9 6.6 5.1 31.7 29.8 55.4 74.1 61.3V533.9l-24.7-6.3c-52.3-12.5-102.1-45.1-102.1-112.7 0-72.9 55.4-112.1 126.2-119v-33c0-4.4 3.6-8 8-8h28.1c4.4 0 8 3.6 8 8v32.7c68.5 6.9 119.9 46.9 125.9 109.2.5 4.7-3.2 8.8-8 8.8h-44.9c-4 0-7.4-3-7.9-6.9-4-29.2-27.4-53-65.5-58.2v134.3l25.4 5.9c64.8 16 108.9 47 108.9 116.4 0 75.3-56 117.3-134.3 124.1zM426.6 410.3c0 25.4 15.7 45.1 49.5 57.3 4.7 1.9 9.4 3.4 15 5v-124c-36.9 4.7-64.5 25.4-64.5 61.7zm116.5 135.2c-2.8-.6-5.6-1.3-8.8-2.2V677c42.6-3.8 72-27.2 72-66.4 0-30.7-15.9-50.7-63.2-65.1z" } }] }, "name": "dollar-circle", "theme": "filled" };
  exports.default = DollarCircleFilled;
  });

  var DollarCircleFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(DollarCircleFilled_1);

  var DollarCircleFilled = function DollarCircleFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DollarCircleFilledSvg
    }));
  };
  var RefIcon$3v = /*#__PURE__*/React.forwardRef(DollarCircleFilled);
  {
    RefIcon$3v.displayName = 'DollarCircleFilled';
  }

  var DollarCircleOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DollarCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372zm47.7-395.2l-25.4-5.9V348.6c38 5.2 61.5 29 65.5 58.2.5 4 3.9 6.9 7.9 6.9h44.9c4.7 0 8.4-4.1 8-8.8-6.1-62.3-57.4-102.3-125.9-109.2V263c0-4.4-3.6-8-8-8h-28.1c-4.4 0-8 3.6-8 8v33c-70.8 6.9-126.2 46-126.2 119 0 67.6 49.8 100.2 102.1 112.7l24.7 6.3v142.7c-44.2-5.9-69-29.5-74.1-61.3-.6-3.8-4-6.6-7.9-6.6H363c-4.7 0-8.4 4-8 8.7 4.5 55 46.2 105.6 135.2 112.1V761c0 4.4 3.6 8 8 8h28.4c4.4 0 8-3.6 8-8.1l-.2-31.7c78.3-6.9 134.3-48.8 134.3-124-.1-69.4-44.2-100.4-109-116.4zm-68.6-16.2c-5.6-1.6-10.3-3.1-15-5-33.8-12.2-49.5-31.9-49.5-57.3 0-36.3 27.5-57 64.5-61.7v124zM534.3 677V543.3c3.1.9 5.9 1.6 8.8 2.2 47.3 14.4 63.2 34.4 63.2 65.1 0 39.1-29.4 62.6-72 66.4z" } }] }, "name": "dollar-circle", "theme": "outlined" };
  exports.default = DollarCircleOutlined;
  });

  var DollarCircleOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(DollarCircleOutlined_1);

  var DollarCircleOutlined = function DollarCircleOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DollarCircleOutlinedSvg
    }));
  };
  var RefIcon$3w = /*#__PURE__*/React.forwardRef(DollarCircleOutlined);
  {
    RefIcon$3w.displayName = 'DollarCircleOutlined';
  }

  var DollarCircleTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DollarCircleTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M426.6 410.3c0 25.4 15.7 45.1 49.5 57.3 4.7 1.9 9.4 3.4 15 5v-124c-37 4.7-64.5 25.4-64.5 61.7zm116.5 135.2c-2.9-.6-5.7-1.3-8.8-2.2V677c42.6-3.8 72-27.3 72-66.4 0-30.7-15.9-50.7-63.2-65.1z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm22.4 589.2l.2 31.7c0 4.5-3.6 8.1-8 8.1h-28.4c-4.4 0-8-3.6-8-8v-31.4c-89-6.5-130.7-57.1-135.2-112.1-.4-4.7 3.3-8.7 8-8.7h46.2c3.9 0 7.3 2.8 7.9 6.6 5.1 31.8 29.9 55.4 74.1 61.3V534l-24.7-6.3c-52.3-12.5-102.1-45.1-102.1-112.7 0-73 55.4-112.1 126.2-119v-33c0-4.4 3.6-8 8-8h28.1c4.4 0 8 3.6 8 8v32.7c68.5 6.9 119.8 46.9 125.9 109.2a8.1 8.1 0 01-8 8.8h-44.9c-4 0-7.4-2.9-7.9-6.9-4-29.2-27.5-53-65.5-58.2v134.3l25.4 5.9c64.8 16 108.9 47 109 116.4 0 75.2-56 117.1-134.3 124z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M559.7 488.8l-25.4-5.9V348.6c38 5.2 61.5 29 65.5 58.2.5 4 3.9 6.9 7.9 6.9h44.9c4.7 0 8.4-4.1 8-8.8-6.1-62.3-57.4-102.3-125.9-109.2V263c0-4.4-3.6-8-8-8h-28.1c-4.4 0-8 3.6-8 8v33c-70.8 6.9-126.2 46-126.2 119 0 67.6 49.8 100.2 102.1 112.7l24.7 6.3v142.7c-44.2-5.9-69-29.5-74.1-61.3-.6-3.8-4-6.6-7.9-6.6H363c-4.7 0-8.4 4-8 8.7 4.5 55 46.2 105.6 135.2 112.1V761c0 4.4 3.6 8 8 8h28.4c4.4 0 8-3.6 8-8.1l-.2-31.7c78.3-6.9 134.3-48.8 134.3-124-.1-69.4-44.2-100.4-109-116.4zm-68.6-16.2c-5.6-1.6-10.3-3.1-15-5-33.8-12.2-49.5-31.9-49.5-57.3 0-36.3 27.5-57 64.5-61.7v124zM534.3 677V543.3c3.1.9 5.9 1.6 8.8 2.2 47.3 14.4 63.2 34.4 63.2 65.1 0 39.1-29.4 62.6-72 66.4z", "fill": primaryColor } }] }; }, "name": "dollar-circle", "theme": "twotone" };
  exports.default = DollarCircleTwoTone;
  });

  var DollarCircleTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(DollarCircleTwoTone_1);

  var DollarCircleTwoTone = function DollarCircleTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DollarCircleTwoToneSvg
    }));
  };
  var RefIcon$3x = /*#__PURE__*/React.forwardRef(DollarCircleTwoTone);
  {
    RefIcon$3x.displayName = 'DollarCircleTwoTone';
  }

  var DollarOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DollarOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372zm47.7-395.2l-25.4-5.9V348.6c38 5.2 61.5 29 65.5 58.2.5 4 3.9 6.9 7.9 6.9h44.9c4.7 0 8.4-4.1 8-8.8-6.1-62.3-57.4-102.3-125.9-109.2V263c0-4.4-3.6-8-8-8h-28.1c-4.4 0-8 3.6-8 8v33c-70.8 6.9-126.2 46-126.2 119 0 67.6 49.8 100.2 102.1 112.7l24.7 6.3v142.7c-44.2-5.9-69-29.5-74.1-61.3-.6-3.8-4-6.6-7.9-6.6H363c-4.7 0-8.4 4-8 8.7 4.5 55 46.2 105.6 135.2 112.1V761c0 4.4 3.6 8 8 8h28.4c4.4 0 8-3.6 8-8.1l-.2-31.7c78.3-6.9 134.3-48.8 134.3-124-.1-69.4-44.2-100.4-109-116.4zm-68.6-16.2c-5.6-1.6-10.3-3.1-15-5-33.8-12.2-49.5-31.9-49.5-57.3 0-36.3 27.5-57 64.5-61.7v124zM534.3 677V543.3c3.1.9 5.9 1.6 8.8 2.2 47.3 14.4 63.2 34.4 63.2 65.1 0 39.1-29.4 62.6-72 66.4z" } }] }, "name": "dollar", "theme": "outlined" };
  exports.default = DollarOutlined;
  });

  var DollarOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(DollarOutlined_1);

  var DollarOutlined = function DollarOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DollarOutlinedSvg
    }));
  };
  var RefIcon$3y = /*#__PURE__*/React.forwardRef(DollarOutlined);
  {
    RefIcon$3y.displayName = 'DollarOutlined';
  }

  var DollarTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DollarTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M426.6 410.3c0 25.4 15.7 45.1 49.5 57.3 4.7 1.9 9.4 3.4 15 5v-124c-37 4.7-64.5 25.4-64.5 61.7zm116.5 135.2c-2.9-.6-5.7-1.3-8.8-2.2V677c42.6-3.8 72-27.3 72-66.4 0-30.7-15.9-50.7-63.2-65.1z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm22.4 589.2l.2 31.7c0 4.5-3.6 8.1-8 8.1h-28.4c-4.4 0-8-3.6-8-8v-31.4c-89-6.5-130.7-57.1-135.2-112.1-.4-4.7 3.3-8.7 8-8.7h46.2c3.9 0 7.3 2.8 7.9 6.6 5.1 31.8 29.9 55.4 74.1 61.3V534l-24.7-6.3c-52.3-12.5-102.1-45.1-102.1-112.7 0-73 55.4-112.1 126.2-119v-33c0-4.4 3.6-8 8-8h28.1c4.4 0 8 3.6 8 8v32.7c68.5 6.9 119.8 46.9 125.9 109.2a8.1 8.1 0 01-8 8.8h-44.9c-4 0-7.4-2.9-7.9-6.9-4-29.2-27.5-53-65.5-58.2v134.3l25.4 5.9c64.8 16 108.9 47 109 116.4 0 75.2-56 117.1-134.3 124z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M559.7 488.8l-25.4-5.9V348.6c38 5.2 61.5 29 65.5 58.2.5 4 3.9 6.9 7.9 6.9h44.9c4.7 0 8.4-4.1 8-8.8-6.1-62.3-57.4-102.3-125.9-109.2V263c0-4.4-3.6-8-8-8h-28.1c-4.4 0-8 3.6-8 8v33c-70.8 6.9-126.2 46-126.2 119 0 67.6 49.8 100.2 102.1 112.7l24.7 6.3v142.7c-44.2-5.9-69-29.5-74.1-61.3-.6-3.8-4-6.6-7.9-6.6H363c-4.7 0-8.4 4-8 8.7 4.5 55 46.2 105.6 135.2 112.1V761c0 4.4 3.6 8 8 8h28.4c4.4 0 8-3.6 8-8.1l-.2-31.7c78.3-6.9 134.3-48.8 134.3-124-.1-69.4-44.2-100.4-109-116.4zm-68.6-16.2c-5.6-1.6-10.3-3.1-15-5-33.8-12.2-49.5-31.9-49.5-57.3 0-36.3 27.5-57 64.5-61.7v124zM534.3 677V543.3c3.1.9 5.9 1.6 8.8 2.2 47.3 14.4 63.2 34.4 63.2 65.1 0 39.1-29.4 62.6-72 66.4z", "fill": primaryColor } }] }; }, "name": "dollar", "theme": "twotone" };
  exports.default = DollarTwoTone;
  });

  var DollarTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(DollarTwoTone_1);

  var DollarTwoTone = function DollarTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DollarTwoToneSvg
    }));
  };
  var RefIcon$3z = /*#__PURE__*/React.forwardRef(DollarTwoTone);
  {
    RefIcon$3z.displayName = 'DollarTwoTone';
  }

  var DotChartOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DotChartOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M888 792H200V168c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v688c0 4.4 3.6 8 8 8h752c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM288 604a64 64 0 10128 0 64 64 0 10-128 0zm118-224a48 48 0 1096 0 48 48 0 10-96 0zm158 228a96 96 0 10192 0 96 96 0 10-192 0zm148-314a56 56 0 10112 0 56 56 0 10-112 0z" } }] }, "name": "dot-chart", "theme": "outlined" };
  exports.default = DotChartOutlined;
  });

  var DotChartOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(DotChartOutlined_1);

  var DotChartOutlined = function DotChartOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DotChartOutlinedSvg
    }));
  };
  var RefIcon$3A = /*#__PURE__*/React.forwardRef(DotChartOutlined);
  {
    RefIcon$3A.displayName = 'DotChartOutlined';
  }

  var DotNetOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DotNetOutlined = { "icon": { "tag": "svg", "attrs": { "fill-rule": "evenodd", "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "g", "attrs": { "fill-opacity": ".88" }, "children": [{ "tag": "path", "attrs": { "d": "M101.28 662c-10.65 0-19.53-3.3-26.63-9.89-7.1-6.6-10.65-14.7-10.65-24.32 0-9.89 3.65-18 10.96-24.31 7.3-6.32 16.42-9.48 27.35-9.48 11.06 0 20.1 3.2 27.14 9.58 7.03 6.39 10.55 14.46 10.55 24.21 0 10.03-3.58 18.24-10.76 24.63-7.17 6.39-16.49 9.58-27.96 9.58M458 657h-66.97l-121.4-185.35c-7.13-10.84-12.06-19-14.8-24.48h-.82c1.1 10.42 1.65 26.33 1.65 47.72V657H193V362h71.49l116.89 179.6a423.23 423.23 0 0114.79 24.06h.82c-1.1-6.86-1.64-20.37-1.64-40.53V362H458zM702 657H525V362h170.2v54.1H591.49v65.63H688v53.9h-96.52v67.47H702zM960 416.1h-83.95V657h-66.5V416.1H726V362h234z" } }] }] }, "name": "dot-net", "theme": "outlined" };
  exports.default = DotNetOutlined;
  });

  var DotNetOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(DotNetOutlined_1);

  var DotNetOutlined = function DotNetOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DotNetOutlinedSvg
    }));
  };
  var RefIcon$3B = /*#__PURE__*/React.forwardRef(DotNetOutlined);
  {
    RefIcon$3B.displayName = 'DotNetOutlined';
  }

  var DoubleLeftOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DoubleLeftOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M272.9 512l265.4-339.1c4.1-5.2.4-12.9-6.3-12.9h-77.3c-4.9 0-9.6 2.3-12.6 6.1L186.8 492.3a31.99 31.99 0 000 39.5l255.3 326.1c3 3.9 7.7 6.1 12.6 6.1H532c6.7 0 10.4-7.7 6.3-12.9L272.9 512zm304 0l265.4-339.1c4.1-5.2.4-12.9-6.3-12.9h-77.3c-4.9 0-9.6 2.3-12.6 6.1L490.8 492.3a31.99 31.99 0 000 39.5l255.3 326.1c3 3.9 7.7 6.1 12.6 6.1H836c6.7 0 10.4-7.7 6.3-12.9L576.9 512z" } }] }, "name": "double-left", "theme": "outlined" };
  exports.default = DoubleLeftOutlined;
  });

  var DoubleLeftOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(DoubleLeftOutlined_1);

  var DoubleLeftOutlined = function DoubleLeftOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DoubleLeftOutlinedSvg
    }));
  };
  var RefIcon$3C = /*#__PURE__*/React.forwardRef(DoubleLeftOutlined);
  {
    RefIcon$3C.displayName = 'DoubleLeftOutlined';
  }

  var DoubleRightOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DoubleRightOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M533.2 492.3L277.9 166.1c-3-3.9-7.7-6.1-12.6-6.1H188c-6.7 0-10.4 7.7-6.3 12.9L447.1 512 181.7 851.1A7.98 7.98 0 00188 864h77.3c4.9 0 9.6-2.3 12.6-6.1l255.3-326.1c9.1-11.7 9.1-27.9 0-39.5zm304 0L581.9 166.1c-3-3.9-7.7-6.1-12.6-6.1H492c-6.7 0-10.4 7.7-6.3 12.9L751.1 512 485.7 851.1A7.98 7.98 0 00492 864h77.3c4.9 0 9.6-2.3 12.6-6.1l255.3-326.1c9.1-11.7 9.1-27.9 0-39.5z" } }] }, "name": "double-right", "theme": "outlined" };
  exports.default = DoubleRightOutlined;
  });

  var DoubleRightOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(DoubleRightOutlined_1);

  var DoubleRightOutlined = function DoubleRightOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DoubleRightOutlinedSvg
    }));
  };
  var RefIcon$3D = /*#__PURE__*/React.forwardRef(DoubleRightOutlined);
  {
    RefIcon$3D.displayName = 'DoubleRightOutlined';
  }

  var DownCircleFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DownCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm184.5 353.7l-178 246a7.95 7.95 0 01-12.9 0l-178-246c-3.8-5.3 0-12.7 6.5-12.7H381c10.2 0 19.9 4.9 25.9 13.2L512 563.6l105.2-145.4c6-8.3 15.6-13.2 25.9-13.2H690c6.5 0 10.3 7.4 6.5 12.7z" } }] }, "name": "down-circle", "theme": "filled" };
  exports.default = DownCircleFilled;
  });

  var DownCircleFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(DownCircleFilled_1);

  var DownCircleFilled = function DownCircleFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DownCircleFilledSvg
    }));
  };
  var RefIcon$3E = /*#__PURE__*/React.forwardRef(DownCircleFilled);
  {
    RefIcon$3E.displayName = 'DownCircleFilled';
  }

  var DownCircleOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DownCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M690 405h-46.9c-10.2 0-19.9 4.9-25.9 13.2L512 563.6 406.8 418.2c-6-8.3-15.6-13.2-25.9-13.2H334c-6.5 0-10.3 7.4-6.5 12.7l178 246c3.2 4.4 9.7 4.4 12.9 0l178-246c3.9-5.3.1-12.7-6.4-12.7z" } }, { "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z" } }] }, "name": "down-circle", "theme": "outlined" };
  exports.default = DownCircleOutlined;
  });

  var DownCircleOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(DownCircleOutlined_1);

  var DownCircleOutlined = function DownCircleOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DownCircleOutlinedSvg
    }));
  };
  var RefIcon$3F = /*#__PURE__*/React.forwardRef(DownCircleOutlined);
  {
    RefIcon$3F.displayName = 'DownCircleOutlined';
  }

  var DownCircleTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DownCircleTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm184.4 277.7l-178 246a7.95 7.95 0 01-12.9 0l-178-246c-3.8-5.3 0-12.7 6.5-12.7h46.9c10.3 0 19.9 4.9 25.9 13.2L512 563.6l105.2-145.4c6-8.3 15.7-13.2 25.9-13.2H690c6.5 0 10.3 7.4 6.4 12.7z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M690 405h-46.9c-10.2 0-19.9 4.9-25.9 13.2L512 563.6 406.8 418.2c-6-8.3-15.6-13.2-25.9-13.2H334c-6.5 0-10.3 7.4-6.5 12.7l178 246c3.2 4.4 9.7 4.4 12.9 0l178-246c3.9-5.3.1-12.7-6.4-12.7z", "fill": primaryColor } }] }; }, "name": "down-circle", "theme": "twotone" };
  exports.default = DownCircleTwoTone;
  });

  var DownCircleTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(DownCircleTwoTone_1);

  var DownCircleTwoTone = function DownCircleTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DownCircleTwoToneSvg
    }));
  };
  var RefIcon$3G = /*#__PURE__*/React.forwardRef(DownCircleTwoTone);
  {
    RefIcon$3G.displayName = 'DownCircleTwoTone';
  }

  var DownOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DownOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M884 256h-75c-5.1 0-9.9 2.5-12.9 6.6L512 654.2 227.9 262.6c-3-4.1-7.8-6.6-12.9-6.6h-75c-6.5 0-10.3 7.4-6.5 12.7l352.6 486.1c12.8 17.6 39 17.6 51.7 0l352.6-486.1c3.9-5.3.1-12.7-6.4-12.7z" } }] }, "name": "down", "theme": "outlined" };
  exports.default = DownOutlined;
  });

  var DownOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(DownOutlined_1);

  var DownOutlined = function DownOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DownOutlinedSvg
    }));
  };
  var RefIcon$3H = /*#__PURE__*/React.forwardRef(DownOutlined);
  {
    RefIcon$3H.displayName = 'DownOutlined';
  }

  var DownSquareFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DownSquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM696.5 412.7l-178 246a7.95 7.95 0 01-12.9 0l-178-246c-3.8-5.3 0-12.7 6.5-12.7H381c10.2 0 19.9 4.9 25.9 13.2L512 558.6l105.2-145.4c6-8.3 15.6-13.2 25.9-13.2H690c6.5 0 10.3 7.4 6.5 12.7z" } }] }, "name": "down-square", "theme": "filled" };
  exports.default = DownSquareFilled;
  });

  var DownSquareFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(DownSquareFilled_1);

  var DownSquareFilled = function DownSquareFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DownSquareFilledSvg
    }));
  };
  var RefIcon$3I = /*#__PURE__*/React.forwardRef(DownSquareFilled);
  {
    RefIcon$3I.displayName = 'DownSquareFilled';
  }

  var DownSquareOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DownSquareOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M505.5 658.7c3.2 4.4 9.7 4.4 12.9 0l178-246c3.8-5.3 0-12.7-6.5-12.7H643c-10.2 0-19.9 4.9-25.9 13.2L512 558.6 406.8 413.2c-6-8.3-15.6-13.2-25.9-13.2H334c-6.5 0-10.3 7.4-6.5 12.7l178 246z" } }, { "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z" } }] }, "name": "down-square", "theme": "outlined" };
  exports.default = DownSquareOutlined;
  });

  var DownSquareOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(DownSquareOutlined_1);

  var DownSquareOutlined = function DownSquareOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DownSquareOutlinedSvg
    }));
  };
  var RefIcon$3J = /*#__PURE__*/React.forwardRef(DownSquareOutlined);
  {
    RefIcon$3J.displayName = 'DownSquareOutlined';
  }

  var DownSquareTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DownSquareTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M184 840h656V184H184v656zm150-440h46.9c10.3 0 19.9 4.9 25.9 13.2L512 558.6l105.2-145.4c6-8.3 15.7-13.2 25.9-13.2H690c6.5 0 10.3 7.4 6.4 12.7l-178 246a7.95 7.95 0 01-12.9 0l-178-246c-3.8-5.3 0-12.7 6.5-12.7z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M505.5 658.7c3.2 4.4 9.7 4.4 12.9 0l178-246c3.9-5.3.1-12.7-6.4-12.7h-46.9c-10.2 0-19.9 4.9-25.9 13.2L512 558.6 406.8 413.2c-6-8.3-15.6-13.2-25.9-13.2H334c-6.5 0-10.3 7.4-6.5 12.7l178 246z", "fill": primaryColor } }] }; }, "name": "down-square", "theme": "twotone" };
  exports.default = DownSquareTwoTone;
  });

  var DownSquareTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(DownSquareTwoTone_1);

  var DownSquareTwoTone = function DownSquareTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DownSquareTwoToneSvg
    }));
  };
  var RefIcon$3K = /*#__PURE__*/React.forwardRef(DownSquareTwoTone);
  {
    RefIcon$3K.displayName = 'DownSquareTwoTone';
  }

  var DownloadOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DownloadOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M505.7 661a8 8 0 0012.6 0l112-141.7c4.1-5.2.4-12.9-6.3-12.9h-74.1V168c0-4.4-3.6-8-8-8h-60c-4.4 0-8 3.6-8 8v338.3H400c-6.7 0-10.4 7.7-6.3 12.9l112 141.8zM878 626h-60c-4.4 0-8 3.6-8 8v154H214V634c0-4.4-3.6-8-8-8h-60c-4.4 0-8 3.6-8 8v198c0 17.7 14.3 32 32 32h684c17.7 0 32-14.3 32-32V634c0-4.4-3.6-8-8-8z" } }] }, "name": "download", "theme": "outlined" };
  exports.default = DownloadOutlined;
  });

  var DownloadOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(DownloadOutlined_1);

  var DownloadOutlined = function DownloadOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DownloadOutlinedSvg
    }));
  };
  var RefIcon$3L = /*#__PURE__*/React.forwardRef(DownloadOutlined);
  {
    RefIcon$3L.displayName = 'DownloadOutlined';
  }

  var DragOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DragOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M909.3 506.3L781.7 405.6a7.23 7.23 0 00-11.7 5.7V476H548V254h64.8c6 0 9.4-7 5.7-11.7L517.7 114.7a7.14 7.14 0 00-11.3 0L405.6 242.3a7.23 7.23 0 005.7 11.7H476v222H254v-64.8c0-6-7-9.4-11.7-5.7L114.7 506.3a7.14 7.14 0 000 11.3l127.5 100.8c4.7 3.7 11.7.4 11.7-5.7V548h222v222h-64.8c-6 0-9.4 7-5.7 11.7l100.8 127.5c2.9 3.7 8.5 3.7 11.3 0l100.8-127.5c3.7-4.7.4-11.7-5.7-11.7H548V548h222v64.8c0 6 7 9.4 11.7 5.7l127.5-100.8a7.3 7.3 0 00.1-11.4z" } }] }, "name": "drag", "theme": "outlined" };
  exports.default = DragOutlined;
  });

  var DragOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(DragOutlined_1);

  var DragOutlined = function DragOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DragOutlinedSvg
    }));
  };
  var RefIcon$3M = /*#__PURE__*/React.forwardRef(DragOutlined);
  {
    RefIcon$3M.displayName = 'DragOutlined';
  }

  var DribbbleCircleFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DribbbleCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M675.1 328.3a245.2 245.2 0 00-220.8-55.1c6.8 9.1 51.5 69.9 91.8 144 87.5-32.8 124.5-82.6 129-88.9zM554 552.8c-138.7 48.3-188.6 144.6-193 153.6 41.7 32.5 94.1 51.9 151 51.9 34.1 0 66.6-6.9 96.1-19.5-3.7-21.6-17.9-96.8-52.5-186.6l-1.6.6zm47.7-11.9c32.2 88.4 45.3 160.4 47.8 175.4 55.2-37.3 94.5-96.4 105.4-164.9-8.4-2.6-76.1-22.8-153.2-10.5zM512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 736c-158.8 0-288-129.2-288-288s129.2-288 288-288 288 129.2 288 288-129.2 288-288 288zm53.1-346.2c5.7 11.7 11.2 23.6 16.3 35.6 1.8 4.2 3.6 8.4 5.3 12.7 81.8-10.3 163.2 6.2 171.3 7.9-.5-58.1-21.3-111.4-55.5-153.3-5.3 7.1-46.5 60-137.4 97.1zM498.6 432c-40.8-72.5-84.7-133.4-91.2-142.3-68.8 32.5-120.3 95.9-136.2 172.2 11 .2 112.4.7 227.4-29.9zm30.6 82.5c3.2-1 6.4-2 9.7-2.9-6.2-14-12.9-28-19.9-41.7-122.8 36.8-242.1 35.2-252.8 35-.1 2.5-.1 5-.1 7.5 0 63.2 23.9 120.9 63.2 164.5 5.5-9.6 73-121.4 199.9-162.4z" } }] }, "name": "dribbble-circle", "theme": "filled" };
  exports.default = DribbbleCircleFilled;
  });

  var DribbbleCircleFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(DribbbleCircleFilled_1);

  var DribbbleCircleFilled = function DribbbleCircleFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DribbbleCircleFilledSvg
    }));
  };
  var RefIcon$3N = /*#__PURE__*/React.forwardRef(DribbbleCircleFilled);
  {
    RefIcon$3N.displayName = 'DribbbleCircleFilled';
  }

  var DribbbleOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DribbbleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 96C282.6 96 96 282.6 96 512s186.6 416 416 416 416-186.6 416-416S741.4 96 512 96zm275.1 191.8c49.5 60.5 79.5 137.5 80.2 221.4-11.7-2.5-129.2-26.3-247.4-11.4-2.5-6.1-5-12.2-7.6-18.3-7.4-17.3-15.3-34.6-23.6-51.5C720 374.3 779.6 298 787.1 287.8zM512 157.2c90.3 0 172.8 33.9 235.5 89.5-6.4 9.1-59.9 81-186.2 128.4-58.2-107-122.7-194.8-132.6-208 27.3-6.6 55.2-9.9 83.3-9.9zM360.9 191c9.4 12.8 72.9 100.9 131.7 205.5C326.4 440.6 180 440 164.1 439.8c23.1-110.3 97.4-201.9 196.8-248.8zM156.7 512.5c0-3.6.1-7.3.2-10.9 15.5.3 187.7 2.5 365.2-50.6 10.2 19.9 19.9 40.1 28.8 60.3-4.7 1.3-9.4 2.7-14 4.2C353.6 574.9 256.1 736.4 248 750.1c-56.7-63-91.3-146.3-91.3-237.6zM512 867.8c-82.2 0-157.9-28-218.1-75 6.4-13.1 78.3-152 278.7-221.9l2.3-.8c49.9 129.6 70.5 238.3 75.8 269.5A350.46 350.46 0 01512 867.8zm198.5-60.7c-3.6-21.6-22.5-125.6-69-253.3C752.9 536 850.7 565.2 862.8 569c-15.8 98.8-72.5 184.2-152.3 238.1z" } }] }, "name": "dribbble", "theme": "outlined" };
  exports.default = DribbbleOutlined;
  });

  var DribbbleOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(DribbbleOutlined_1);

  var DribbbleOutlined = function DribbbleOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DribbbleOutlinedSvg
    }));
  };
  var RefIcon$3O = /*#__PURE__*/React.forwardRef(DribbbleOutlined);
  {
    RefIcon$3O.displayName = 'DribbbleOutlined';
  }

  var DribbbleSquareFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DribbbleSquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M498.6 432c-40.8-72.5-84.7-133.4-91.2-142.3-68.8 32.5-120.3 95.9-136.2 172.2 11 .2 112.4.7 227.4-29.9zm66.5 21.8c5.7 11.7 11.2 23.6 16.3 35.6 1.8 4.2 3.6 8.4 5.3 12.7 81.8-10.3 163.2 6.2 171.3 7.9-.5-58.1-21.3-111.4-55.5-153.3-5.3 7.1-46.5 60-137.4 97.1zM880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM512 800c-158.8 0-288-129.2-288-288s129.2-288 288-288 288 129.2 288 288-129.2 288-288 288zm89.7-259.1c32.2 88.4 45.3 160.4 47.8 175.4 55.2-37.3 94.5-96.4 105.4-164.9-8.4-2.6-76.1-22.8-153.2-10.5zm-72.5-26.4c3.2-1 6.4-2 9.7-2.9-6.2-14-12.9-28-19.9-41.7-122.8 36.8-242.1 35.2-252.8 35-.1 2.5-.1 5-.1 7.5 0 63.2 23.9 120.9 63.2 164.5 5.5-9.6 73-121.4 199.9-162.4zm145.9-186.2a245.2 245.2 0 00-220.8-55.1c6.8 9.1 51.5 69.9 91.8 144 87.5-32.8 124.5-82.6 129-88.9zM554 552.8c-138.7 48.3-188.6 144.6-193 153.6 41.7 32.5 94.1 51.9 151 51.9 34.1 0 66.6-6.9 96.1-19.5-3.7-21.6-17.9-96.8-52.5-186.6l-1.6.6z" } }] }, "name": "dribbble-square", "theme": "filled" };
  exports.default = DribbbleSquareFilled;
  });

  var DribbbleSquareFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(DribbbleSquareFilled_1);

  var DribbbleSquareFilled = function DribbbleSquareFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DribbbleSquareFilledSvg
    }));
  };
  var RefIcon$3P = /*#__PURE__*/React.forwardRef(DribbbleSquareFilled);
  {
    RefIcon$3P.displayName = 'DribbbleSquareFilled';
  }

  var DribbbleSquareOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DribbbleSquareOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M498.6 432c-40.8-72.5-84.7-133.4-91.2-142.3-68.8 32.5-120.3 95.9-136.2 172.2 11 .2 112.4.7 227.4-29.9zm66.5 21.8c5.7 11.7 11.2 23.6 16.3 35.6 1.8 4.2 3.6 8.4 5.3 12.7 81.8-10.3 163.2 6.2 171.3 7.9-.5-58.1-21.3-111.4-55.5-153.3-5.3 7.1-46.5 60-137.4 97.1zM880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM512 800c-158.8 0-288-129.2-288-288s129.2-288 288-288 288 129.2 288 288-129.2 288-288 288zm89.7-259.1c32.2 88.4 45.3 160.4 47.8 175.4 55.2-37.3 94.5-96.4 105.4-164.9-8.4-2.6-76.1-22.8-153.2-10.5zm-72.5-26.4c3.2-1 6.4-2 9.7-2.9-6.2-14-12.9-28-19.9-41.7-122.8 36.8-242.1 35.2-252.8 35-.1 2.5-.1 5-.1 7.5 0 63.2 23.9 120.9 63.2 164.5 5.5-9.6 73-121.4 199.9-162.4zm145.9-186.2a245.2 245.2 0 00-220.8-55.1c6.8 9.1 51.5 69.9 91.8 144 87.5-32.8 124.5-82.6 129-88.9zM554 552.8c-138.7 48.3-188.6 144.6-193 153.6 41.7 32.5 94.1 51.9 151 51.9 34.1 0 66.6-6.9 96.1-19.5-3.7-21.6-17.9-96.8-52.5-186.6l-1.6.6z" } }] }, "name": "dribbble-square", "theme": "outlined" };
  exports.default = DribbbleSquareOutlined;
  });

  var DribbbleSquareOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(DribbbleSquareOutlined_1);

  var DribbbleSquareOutlined = function DribbbleSquareOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DribbbleSquareOutlinedSvg
    }));
  };
  var RefIcon$3Q = /*#__PURE__*/React.forwardRef(DribbbleSquareOutlined);
  {
    RefIcon$3Q.displayName = 'DribbbleSquareOutlined';
  }

  var DropboxCircleFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DropboxCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M663.8 455.5zm-151.5-93.8l-151.8 93.8 151.8 93.9 151.5-93.9zM512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm151.2 595.5L512.6 750l-151-90.5v-33.1l45.4 29.4 105.6-87.7 105.6 87.7 45.1-29.4v33.1zm-45.6-22.4l-105.3-87.7L407 637.1l-151-99.2 104.5-82.4L256 371.2 407 274l105.3 87.7L617.6 274 768 372.1l-104.2 83.5L768 539l-150.4 98.1z" } }] }, "name": "dropbox-circle", "theme": "filled" };
  exports.default = DropboxCircleFilled;
  });

  var DropboxCircleFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(DropboxCircleFilled_1);

  var DropboxCircleFilled = function DropboxCircleFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DropboxCircleFilledSvg
    }));
  };
  var RefIcon$3R = /*#__PURE__*/React.forwardRef(DropboxCircleFilled);
  {
    RefIcon$3R.displayName = 'DropboxCircleFilled';
  }

  var DropboxOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DropboxOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M64 556.9l264.2 173.5L512.5 577 246.8 412.7zm896-290.3zm0 0L696.8 95 512.5 248.5l265.2 164.2L512.5 577l184.3 153.4L960 558.8 777.7 412.7zM513 609.8L328.2 763.3l-79.4-51.5v57.8L513 928l263.7-158.4v-57.8l-78.9 51.5zM328.2 95L64 265.1l182.8 147.6 265.7-164.2zM64 556.9z" } }] }, "name": "dropbox", "theme": "outlined" };
  exports.default = DropboxOutlined;
  });

  var DropboxOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(DropboxOutlined_1);

  var DropboxOutlined = function DropboxOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DropboxOutlinedSvg
    }));
  };
  var RefIcon$3S = /*#__PURE__*/React.forwardRef(DropboxOutlined);
  {
    RefIcon$3S.displayName = 'DropboxOutlined';
  }

  var DropboxSquareFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var DropboxSquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM663.2 659.5L512.6 750l-151-90.5v-33.1l45.4 29.4 105.6-87.7 105.6 87.7 45.1-29.4v33.1zm-45.6-22.4l-105.3-87.7L407 637.1l-151-99.2 104.5-82.4L256 371.2 407 274l105.3 87.7L617.6 274 768 372.1l-104.2 83.5L768 539l-150.4 98.1zM512.3 361.7l-151.8 93.8 151.8 93.9 151.5-93.9zm151.5 93.8z" } }] }, "name": "dropbox-square", "theme": "filled" };
  exports.default = DropboxSquareFilled;
  });

  var DropboxSquareFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(DropboxSquareFilled_1);

  var DropboxSquareFilled = function DropboxSquareFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: DropboxSquareFilledSvg
    }));
  };
  var RefIcon$3T = /*#__PURE__*/React.forwardRef(DropboxSquareFilled);
  {
    RefIcon$3T.displayName = 'DropboxSquareFilled';
  }

  var EditFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var EditFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 836H144c-17.7 0-32 14.3-32 32v36c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-36c0-17.7-14.3-32-32-32zm-622.3-84c2 0 4-.2 6-.5L431.9 722c2-.4 3.9-1.3 5.3-2.8l423.9-423.9a9.96 9.96 0 000-14.1L694.9 114.9c-1.9-1.9-4.4-2.9-7.1-2.9s-5.2 1-7.1 2.9L256.8 538.8c-1.5 1.5-2.4 3.3-2.8 5.3l-29.5 168.2a33.5 33.5 0 009.4 29.8c6.6 6.4 14.9 9.9 23.8 9.9z" } }] }, "name": "edit", "theme": "filled" };
  exports.default = EditFilled;
  });

  var EditFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(EditFilled_1);

  var EditFilled = function EditFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: EditFilledSvg
    }));
  };
  var RefIcon$3U = /*#__PURE__*/React.forwardRef(EditFilled);
  {
    RefIcon$3U.displayName = 'EditFilled';
  }

  var EditOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var EditOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M257.7 752c2 0 4-.2 6-.5L431.9 722c2-.4 3.9-1.3 5.3-2.8l423.9-423.9a9.96 9.96 0 000-14.1L694.9 114.9c-1.9-1.9-4.4-2.9-7.1-2.9s-5.2 1-7.1 2.9L256.8 538.8c-1.5 1.5-2.4 3.3-2.8 5.3l-29.5 168.2a33.5 33.5 0 009.4 29.8c6.6 6.4 14.9 9.9 23.8 9.9zm67.4-174.4L687.8 215l73.3 73.3-362.7 362.6-88.9 15.7 15.6-89zM880 836H144c-17.7 0-32 14.3-32 32v36c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-36c0-17.7-14.3-32-32-32z" } }] }, "name": "edit", "theme": "outlined" };
  exports.default = EditOutlined;
  });

  var EditOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(EditOutlined_1);

  var EditOutlined = function EditOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: EditOutlinedSvg
    }));
  };
  var RefIcon$3V = /*#__PURE__*/React.forwardRef(EditOutlined);
  {
    RefIcon$3V.displayName = 'EditOutlined';
  }

  var EditTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var EditTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M761.1 288.3L687.8 215 325.1 577.6l-15.6 89 88.9-15.7z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M880 836H144c-17.7 0-32 14.3-32 32v36c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-36c0-17.7-14.3-32-32-32zm-622.3-84c2 0 4-.2 6-.5L431.9 722c2-.4 3.9-1.3 5.3-2.8l423.9-423.9a9.96 9.96 0 000-14.1L694.9 114.9c-1.9-1.9-4.4-2.9-7.1-2.9s-5.2 1-7.1 2.9L256.8 538.8c-1.5 1.5-2.4 3.3-2.8 5.3l-29.5 168.2a33.5 33.5 0 009.4 29.8c6.6 6.4 14.9 9.9 23.8 9.9zm67.4-174.4L687.8 215l73.3 73.3-362.7 362.6-88.9 15.7 15.6-89z", "fill": primaryColor } }] }; }, "name": "edit", "theme": "twotone" };
  exports.default = EditTwoTone;
  });

  var EditTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(EditTwoTone_1);

  var EditTwoTone = function EditTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: EditTwoToneSvg
    }));
  };
  var RefIcon$3W = /*#__PURE__*/React.forwardRef(EditTwoTone);
  {
    RefIcon$3W.displayName = 'EditTwoTone';
  }

  var EllipsisOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var EllipsisOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M176 511a56 56 0 10112 0 56 56 0 10-112 0zm280 0a56 56 0 10112 0 56 56 0 10-112 0zm280 0a56 56 0 10112 0 56 56 0 10-112 0z" } }] }, "name": "ellipsis", "theme": "outlined" };
  exports.default = EllipsisOutlined;
  });

  var EllipsisOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(EllipsisOutlined_1);

  var EllipsisOutlined = function EllipsisOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: EllipsisOutlinedSvg
    }));
  };
  var RefIcon$3X = /*#__PURE__*/React.forwardRef(EllipsisOutlined);
  {
    RefIcon$3X.displayName = 'EllipsisOutlined';
  }

  var EnterOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var EnterOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M864 170h-60c-4.4 0-8 3.6-8 8v518H310v-73c0-6.7-7.8-10.5-13-6.3l-141.9 112a8 8 0 000 12.6l141.9 112c5.3 4.2 13 .4 13-6.3v-75h498c35.3 0 64-28.7 64-64V178c0-4.4-3.6-8-8-8z" } }] }, "name": "enter", "theme": "outlined" };
  exports.default = EnterOutlined;
  });

  var EnterOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(EnterOutlined_1);

  var EnterOutlined = function EnterOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: EnterOutlinedSvg
    }));
  };
  var RefIcon$3Y = /*#__PURE__*/React.forwardRef(EnterOutlined);
  {
    RefIcon$3Y.displayName = 'EnterOutlined';
  }

  var EnvironmentFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var EnvironmentFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 327c-29.9 0-58 11.6-79.2 32.8A111.6 111.6 0 00400 439c0 29.9 11.7 58 32.8 79.2A111.6 111.6 0 00512 551c29.9 0 58-11.7 79.2-32.8C612.4 497 624 468.9 624 439c0-29.9-11.6-58-32.8-79.2S541.9 327 512 327zm342.6-37.9a362.49 362.49 0 00-79.9-115.7 370.83 370.83 0 00-118.2-77.8C610.7 76.6 562.1 67 512 67c-50.1 0-98.7 9.6-144.5 28.5-44.3 18.3-84 44.5-118.2 77.8A363.6 363.6 0 00169.4 289c-19.5 45-29.4 92.8-29.4 142 0 70.6 16.9 140.9 50.1 208.7 26.7 54.5 64 107.6 111 158.1 80.3 86.2 164.5 138.9 188.4 153a43.9 43.9 0 0022.4 6.1c7.8 0 15.5-2 22.4-6.1 23.9-14.1 108.1-66.8 188.4-153 47-50.4 84.3-103.6 111-158.1C867.1 572 884 501.8 884 431.1c0-49.2-9.9-97-29.4-142zM512 615c-97.2 0-176-78.8-176-176s78.8-176 176-176 176 78.8 176 176-78.8 176-176 176z" } }] }, "name": "environment", "theme": "filled" };
  exports.default = EnvironmentFilled;
  });

  var EnvironmentFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(EnvironmentFilled_1);

  var EnvironmentFilled = function EnvironmentFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: EnvironmentFilledSvg
    }));
  };
  var RefIcon$3Z = /*#__PURE__*/React.forwardRef(EnvironmentFilled);
  {
    RefIcon$3Z.displayName = 'EnvironmentFilled';
  }

  var EnvironmentOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var EnvironmentOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 289.1a362.49 362.49 0 00-79.9-115.7 370.83 370.83 0 00-118.2-77.8C610.7 76.6 562.1 67 512 67c-50.1 0-98.7 9.6-144.5 28.5-44.3 18.3-84 44.5-118.2 77.8A363.6 363.6 0 00169.4 289c-19.5 45-29.4 92.8-29.4 142 0 70.6 16.9 140.9 50.1 208.7 26.7 54.5 64 107.6 111 158.1 80.3 86.2 164.5 138.9 188.4 153a43.9 43.9 0 0022.4 6.1c7.8 0 15.5-2 22.4-6.1 23.9-14.1 108.1-66.8 188.4-153 47-50.4 84.3-103.6 111-158.1C867.1 572 884 501.8 884 431.1c0-49.2-9.9-97-29.4-142zM512 880.2c-65.9-41.9-300-207.8-300-449.1 0-77.9 31.1-151.1 87.6-206.3C356.3 169.5 431.7 139 512 139s155.7 30.5 212.4 85.9C780.9 280 812 353.2 812 431.1c0 241.3-234.1 407.2-300 449.1zm0-617.2c-97.2 0-176 78.8-176 176s78.8 176 176 176 176-78.8 176-176-78.8-176-176-176zm79.2 255.2A111.6 111.6 0 01512 551c-29.9 0-58-11.7-79.2-32.8A111.6 111.6 0 01400 439c0-29.9 11.7-58 32.8-79.2C454 338.6 482.1 327 512 327c29.9 0 58 11.6 79.2 32.8C612.4 381 624 409.1 624 439c0 29.9-11.6 58-32.8 79.2z" } }] }, "name": "environment", "theme": "outlined" };
  exports.default = EnvironmentOutlined;
  });

  var EnvironmentOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(EnvironmentOutlined_1);

  var EnvironmentOutlined = function EnvironmentOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: EnvironmentOutlinedSvg
    }));
  };
  var RefIcon$3_ = /*#__PURE__*/React.forwardRef(EnvironmentOutlined);
  {
    RefIcon$3_.displayName = 'EnvironmentOutlined';
  }

  var EnvironmentTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var EnvironmentTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M724.4 224.9C667.7 169.5 592.3 139 512 139s-155.7 30.5-212.4 85.8C243.1 280 212 353.2 212 431.1c0 241.3 234.1 407.2 300 449.1 65.9-41.9 300-207.8 300-449.1 0-77.9-31.1-151.1-87.6-206.2zM512 615c-97.2 0-176-78.8-176-176s78.8-176 176-176 176 78.8 176 176-78.8 176-176 176z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M512 263c-97.2 0-176 78.8-176 176s78.8 176 176 176 176-78.8 176-176-78.8-176-176-176zm79.2 255.2A111.6 111.6 0 01512 551c-29.9 0-58-11.7-79.2-32.8A111.6 111.6 0 01400 439c0-29.9 11.7-58 32.8-79.2C454 338.6 482.1 327 512 327c29.9 0 58 11.6 79.2 32.8S624 409.1 624 439c0 29.9-11.6 58-32.8 79.2z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M854.6 289.1a362.49 362.49 0 00-79.9-115.7 370.83 370.83 0 00-118.2-77.8C610.7 76.6 562.1 67 512 67c-50.1 0-98.7 9.6-144.5 28.5-44.3 18.3-84 44.5-118.2 77.8A363.6 363.6 0 00169.4 289c-19.5 45-29.4 92.8-29.4 142 0 70.6 16.9 140.9 50.1 208.7 26.7 54.5 64 107.6 111 158.1 80.3 86.2 164.5 138.9 188.4 153a43.9 43.9 0 0022.4 6.1c7.8 0 15.5-2 22.4-6.1 23.9-14.1 108.1-66.8 188.4-153 47-50.4 84.3-103.6 111-158.1C867.1 572 884 501.8 884 431.1c0-49.2-9.9-97-29.4-142zM512 880.2c-65.9-41.9-300-207.8-300-449.1 0-77.9 31.1-151.1 87.6-206.3C356.3 169.5 431.7 139 512 139s155.7 30.5 212.4 85.9C780.9 280 812 353.2 812 431.1c0 241.3-234.1 407.2-300 449.1z", "fill": primaryColor } }] }; }, "name": "environment", "theme": "twotone" };
  exports.default = EnvironmentTwoTone;
  });

  var EnvironmentTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(EnvironmentTwoTone_1);

  var EnvironmentTwoTone = function EnvironmentTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: EnvironmentTwoToneSvg
    }));
  };
  var RefIcon$3$ = /*#__PURE__*/React.forwardRef(EnvironmentTwoTone);
  {
    RefIcon$3$.displayName = 'EnvironmentTwoTone';
  }

  var EuroCircleFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var EuroCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm63.5 375.8c4.4 0 8 3.6 8 8V475c0 4.4-3.6 8-8 8h-136c-.3 4.4-.3 9.1-.3 13.8v36h136.2c4.4 0 8 3.6 8 8V568c0 4.4-3.6 8-8 8H444.9c15.3 62 61.3 98.6 129.8 98.6 19.9 0 37.1-1.2 51.8-4.1 4.9-1 9.5 2.8 9.5 7.8v42.8c0 3.8-2.7 7-6.4 7.8-15.9 3.4-34.3 5.1-55.3 5.1-109.8 0-183-58.8-200.2-158H344c-4.4 0-8-3.6-8-8v-27.2c0-4.4 3.6-8 8-8h26.1v-36.9c0-4.4 0-8.8.3-12.8H344c-4.4 0-8-3.6-8-8v-27.2c0-4.4 3.6-8 8-8h31.7c19.7-94.2 92-149.9 198.6-149.9 20.9 0 39.4 1.9 55.3 5.4 3.7.8 6.3 4 6.3 7.8V346h.1c0 5.1-4.6 8.8-9.6 7.8-14.7-2.9-31.8-4.4-51.7-4.4-65.4 0-110.4 33.5-127.6 90.4h128.4z" } }] }, "name": "euro-circle", "theme": "filled" };
  exports.default = EuroCircleFilled;
  });

  var EuroCircleFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(EuroCircleFilled_1);

  var EuroCircleFilled = function EuroCircleFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: EuroCircleFilledSvg
    }));
  };
  var RefIcon$40 = /*#__PURE__*/React.forwardRef(EuroCircleFilled);
  {
    RefIcon$40.displayName = 'EuroCircleFilled';
  }

  var EuroCircleOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var EuroCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372zm117.7-588.6c-15.9-3.5-34.4-5.4-55.3-5.4-106.7 0-178.9 55.7-198.6 149.9H344c-4.4 0-8 3.6-8 8v27.2c0 4.4 3.6 8 8 8h26.4c-.3 4.1-.3 8.4-.3 12.8v36.9H344c-4.4 0-8 3.6-8 8V568c0 4.4 3.6 8 8 8h30.2c17.2 99.2 90.4 158 200.2 158 20.9 0 39.4-1.7 55.3-5.1 3.7-.8 6.4-4 6.4-7.8v-42.8c0-5-4.6-8.8-9.5-7.8-14.7 2.8-31.9 4.1-51.8 4.1-68.5 0-114.5-36.6-129.8-98.6h130.6c4.4 0 8-3.6 8-8v-27.2c0-4.4-3.6-8-8-8H439.2v-36c0-4.7 0-9.4.3-13.8h135.9c4.4 0 8-3.6 8-8v-27.2c0-4.4-3.6-8-8-8H447.1c17.2-56.9 62.3-90.4 127.6-90.4 19.9 0 37.1 1.5 51.7 4.4a8 8 0 009.6-7.8v-42.8c0-3.8-2.6-7-6.3-7.8z" } }] }, "name": "euro-circle", "theme": "outlined" };
  exports.default = EuroCircleOutlined;
  });

  var EuroCircleOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(EuroCircleOutlined_1);

  var EuroCircleOutlined = function EuroCircleOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: EuroCircleOutlinedSvg
    }));
  };
  var RefIcon$41 = /*#__PURE__*/React.forwardRef(EuroCircleOutlined);
  {
    RefIcon$41.displayName = 'EuroCircleOutlined';
  }

  var EuroCircleTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var EuroCircleTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm117.1 581.1c0 3.8-2.7 7-6.4 7.8-15.9 3.4-34.4 5.1-55.3 5.1-109.8 0-183-58.8-200.2-158H337c-4.4 0-8-3.6-8-8v-27.2c0-4.4 3.6-8 8-8h26.1v-36.9c0-4.4 0-8.7.3-12.8H337c-4.4 0-8-3.6-8-8v-27.2c0-4.4 3.6-8 8-8h31.8C388.5 345.7 460.7 290 567.4 290c20.9 0 39.4 1.9 55.3 5.4 3.7.8 6.3 4 6.3 7.8V346a8 8 0 01-9.6 7.8c-14.6-2.9-31.8-4.4-51.7-4.4-65.3 0-110.4 33.5-127.6 90.4h128.3c4.4 0 8 3.6 8 8V475c0 4.4-3.6 8-8 8H432.5c-.3 4.4-.3 9.1-.3 13.8v36h136.4c4.4 0 8 3.6 8 8V568c0 4.4-3.6 8-8 8H438c15.3 62 61.3 98.6 129.8 98.6 19.9 0 37.1-1.3 51.8-4.1 4.9-1 9.5 2.8 9.5 7.8v42.8z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M619.6 670.5c-14.7 2.8-31.9 4.1-51.8 4.1-68.5 0-114.5-36.6-129.8-98.6h130.6c4.4 0 8-3.6 8-8v-27.2c0-4.4-3.6-8-8-8H432.2v-36c0-4.7 0-9.4.3-13.8h135.9c4.4 0 8-3.6 8-8v-27.2c0-4.4-3.6-8-8-8H440.1c17.2-56.9 62.3-90.4 127.6-90.4 19.9 0 37.1 1.5 51.7 4.4a8 8 0 009.6-7.8v-42.8c0-3.8-2.6-7-6.3-7.8-15.9-3.5-34.4-5.4-55.3-5.4-106.7 0-178.9 55.7-198.6 149.9H337c-4.4 0-8 3.6-8 8v27.2c0 4.4 3.6 8 8 8h26.4c-.3 4.1-.3 8.4-.3 12.8v36.9H337c-4.4 0-8 3.6-8 8V568c0 4.4 3.6 8 8 8h30.2c17.2 99.2 90.4 158 200.2 158 20.9 0 39.4-1.7 55.3-5.1 3.7-.8 6.4-4 6.4-7.8v-42.8c0-5-4.6-8.8-9.5-7.8z", "fill": primaryColor } }] }; }, "name": "euro-circle", "theme": "twotone" };
  exports.default = EuroCircleTwoTone;
  });

  var EuroCircleTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(EuroCircleTwoTone_1);

  var EuroCircleTwoTone = function EuroCircleTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: EuroCircleTwoToneSvg
    }));
  };
  var RefIcon$42 = /*#__PURE__*/React.forwardRef(EuroCircleTwoTone);
  {
    RefIcon$42.displayName = 'EuroCircleTwoTone';
  }

  var EuroOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var EuroOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372zm117.7-588.6c-15.9-3.5-34.4-5.4-55.3-5.4-106.7 0-178.9 55.7-198.6 149.9H344c-4.4 0-8 3.6-8 8v27.2c0 4.4 3.6 8 8 8h26.4c-.3 4.1-.3 8.4-.3 12.8v36.9H344c-4.4 0-8 3.6-8 8V568c0 4.4 3.6 8 8 8h30.2c17.2 99.2 90.4 158 200.2 158 20.9 0 39.4-1.7 55.3-5.1 3.7-.8 6.4-4 6.4-7.8v-42.8c0-5-4.6-8.8-9.5-7.8-14.7 2.8-31.9 4.1-51.8 4.1-68.5 0-114.5-36.6-129.8-98.6h130.6c4.4 0 8-3.6 8-8v-27.2c0-4.4-3.6-8-8-8H439.2v-36c0-4.7 0-9.4.3-13.8h135.9c4.4 0 8-3.6 8-8v-27.2c0-4.4-3.6-8-8-8H447.1c17.2-56.9 62.3-90.4 127.6-90.4 19.9 0 37.1 1.5 51.7 4.4a8 8 0 009.6-7.8v-42.8c0-3.8-2.6-7-6.3-7.8z" } }] }, "name": "euro", "theme": "outlined" };
  exports.default = EuroOutlined;
  });

  var EuroOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(EuroOutlined_1);

  var EuroOutlined = function EuroOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: EuroOutlinedSvg
    }));
  };
  var RefIcon$43 = /*#__PURE__*/React.forwardRef(EuroOutlined);
  {
    RefIcon$43.displayName = 'EuroOutlined';
  }

  var EuroTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var EuroTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm117.1 581.1c0 3.8-2.7 7-6.4 7.8-15.9 3.4-34.4 5.1-55.3 5.1-109.8 0-183-58.8-200.2-158H337c-4.4 0-8-3.6-8-8v-27.2c0-4.4 3.6-8 8-8h26.1v-36.9c0-4.4 0-8.7.3-12.8H337c-4.4 0-8-3.6-8-8v-27.2c0-4.4 3.6-8 8-8h31.8C388.5 345.7 460.7 290 567.4 290c20.9 0 39.4 1.9 55.3 5.4 3.7.8 6.3 4 6.3 7.8V346a8 8 0 01-9.6 7.8c-14.6-2.9-31.8-4.4-51.7-4.4-65.3 0-110.4 33.5-127.6 90.4h128.3c4.4 0 8 3.6 8 8V475c0 4.4-3.6 8-8 8H432.5c-.3 4.4-.3 9.1-.3 13.8v36h136.4c4.4 0 8 3.6 8 8V568c0 4.4-3.6 8-8 8H438c15.3 62 61.3 98.6 129.8 98.6 19.9 0 37.1-1.3 51.8-4.1 4.9-1 9.5 2.8 9.5 7.8v42.8z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M619.6 670.5c-14.7 2.8-31.9 4.1-51.8 4.1-68.5 0-114.5-36.6-129.8-98.6h130.6c4.4 0 8-3.6 8-8v-27.2c0-4.4-3.6-8-8-8H432.2v-36c0-4.7 0-9.4.3-13.8h135.9c4.4 0 8-3.6 8-8v-27.2c0-4.4-3.6-8-8-8H440.1c17.2-56.9 62.3-90.4 127.6-90.4 19.9 0 37.1 1.5 51.7 4.4a8 8 0 009.6-7.8v-42.8c0-3.8-2.6-7-6.3-7.8-15.9-3.5-34.4-5.4-55.3-5.4-106.7 0-178.9 55.7-198.6 149.9H337c-4.4 0-8 3.6-8 8v27.2c0 4.4 3.6 8 8 8h26.4c-.3 4.1-.3 8.4-.3 12.8v36.9H337c-4.4 0-8 3.6-8 8V568c0 4.4 3.6 8 8 8h30.2c17.2 99.2 90.4 158 200.2 158 20.9 0 39.4-1.7 55.3-5.1 3.7-.8 6.4-4 6.4-7.8v-42.8c0-5-4.6-8.8-9.5-7.8z", "fill": primaryColor } }] }; }, "name": "euro", "theme": "twotone" };
  exports.default = EuroTwoTone;
  });

  var EuroTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(EuroTwoTone_1);

  var EuroTwoTone = function EuroTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: EuroTwoToneSvg
    }));
  };
  var RefIcon$44 = /*#__PURE__*/React.forwardRef(EuroTwoTone);
  {
    RefIcon$44.displayName = 'EuroTwoTone';
  }

  var ExceptionOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ExceptionOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M688 312v-48c0-4.4-3.6-8-8-8H296c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h384c4.4 0 8-3.6 8-8zm-392 88c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h184c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H296zm376 116c-119.3 0-216 96.7-216 216s96.7 216 216 216 216-96.7 216-216-96.7-216-216-216zm107.5 323.5C750.8 868.2 712.6 884 672 884s-78.8-15.8-107.5-44.5C535.8 810.8 520 772.6 520 732s15.8-78.8 44.5-107.5C593.2 595.8 631.4 580 672 580s78.8 15.8 107.5 44.5C808.2 653.2 824 691.4 824 732s-15.8 78.8-44.5 107.5zM640 812a32 32 0 1064 0 32 32 0 10-64 0zm12-64h40c4.4 0 8-3.6 8-8V628c0-4.4-3.6-8-8-8h-40c-4.4 0-8 3.6-8 8v112c0 4.4 3.6 8 8 8zM440 852H208V148h560v344c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V108c0-17.7-14.3-32-32-32H168c-17.7 0-32 14.3-32 32v784c0 17.7 14.3 32 32 32h272c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8z" } }] }, "name": "exception", "theme": "outlined" };
  exports.default = ExceptionOutlined;
  });

  var ExceptionOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(ExceptionOutlined_1);

  var ExceptionOutlined = function ExceptionOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ExceptionOutlinedSvg
    }));
  };
  var RefIcon$45 = /*#__PURE__*/React.forwardRef(ExceptionOutlined);
  {
    RefIcon$45.displayName = 'ExceptionOutlined';
  }

  var ExclamationCircleFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ExclamationCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm-32 232c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v272c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V296zm32 440a48.01 48.01 0 010-96 48.01 48.01 0 010 96z" } }] }, "name": "exclamation-circle", "theme": "filled" };
  exports.default = ExclamationCircleFilled;
  });

  var ExclamationCircleFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(ExclamationCircleFilled_1);

  var ExclamationCircleFilled = function ExclamationCircleFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ExclamationCircleFilledSvg
    }));
  };
  var RefIcon$46 = /*#__PURE__*/React.forwardRef(ExclamationCircleFilled);
  {
    RefIcon$46.displayName = 'ExclamationCircleFilled';
  }

  var ExclamationCircleOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ExclamationCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z" } }, { "tag": "path", "attrs": { "d": "M464 688a48 48 0 1096 0 48 48 0 10-96 0zm24-112h48c4.4 0 8-3.6 8-8V296c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v272c0 4.4 3.6 8 8 8z" } }] }, "name": "exclamation-circle", "theme": "outlined" };
  exports.default = ExclamationCircleOutlined;
  });

  var ExclamationCircleOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(ExclamationCircleOutlined_1);

  var ExclamationCircleOutlined = function ExclamationCircleOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ExclamationCircleOutlinedSvg
    }));
  };
  var RefIcon$47 = /*#__PURE__*/React.forwardRef(ExclamationCircleOutlined);
  {
    RefIcon$47.displayName = 'ExclamationCircleOutlined';
  }

  var ExclamationCircleTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ExclamationCircleTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm-32 156c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v272c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V296zm32 440a48.01 48.01 0 010-96 48.01 48.01 0 010 96z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M488 576h48c4.4 0 8-3.6 8-8V296c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v272c0 4.4 3.6 8 8 8zm-24 112a48 48 0 1096 0 48 48 0 10-96 0z", "fill": primaryColor } }] }; }, "name": "exclamation-circle", "theme": "twotone" };
  exports.default = ExclamationCircleTwoTone;
  });

  var ExclamationCircleTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(ExclamationCircleTwoTone_1);

  var ExclamationCircleTwoTone = function ExclamationCircleTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ExclamationCircleTwoToneSvg
    }));
  };
  var RefIcon$48 = /*#__PURE__*/React.forwardRef(ExclamationCircleTwoTone);
  {
    RefIcon$48.displayName = 'ExclamationCircleTwoTone';
  }

  var ExclamationOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ExclamationOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M448 804a64 64 0 10128 0 64 64 0 10-128 0zm32-168h64c4.4 0 8-3.6 8-8V164c0-4.4-3.6-8-8-8h-64c-4.4 0-8 3.6-8 8v464c0 4.4 3.6 8 8 8z" } }] }, "name": "exclamation", "theme": "outlined" };
  exports.default = ExclamationOutlined;
  });

  var ExclamationOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(ExclamationOutlined_1);

  var ExclamationOutlined = function ExclamationOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ExclamationOutlinedSvg
    }));
  };
  var RefIcon$49 = /*#__PURE__*/React.forwardRef(ExclamationOutlined);
  {
    RefIcon$49.displayName = 'ExclamationOutlined';
  }

  var ExpandAltOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ExpandAltOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M855 160.1l-189.2 23.5c-6.6.8-9.3 8.8-4.7 13.5l54.7 54.7-153.5 153.5a8.03 8.03 0 000 11.3l45.1 45.1c3.1 3.1 8.2 3.1 11.3 0l153.6-153.6 54.7 54.7a7.94 7.94 0 0013.5-4.7L863.9 169a7.9 7.9 0 00-8.9-8.9zM416.6 562.3a8.03 8.03 0 00-11.3 0L251.8 715.9l-54.7-54.7a7.94 7.94 0 00-13.5 4.7L160.1 855c-.6 5.2 3.7 9.5 8.9 8.9l189.2-23.5c6.6-.8 9.3-8.8 4.7-13.5l-54.7-54.7 153.6-153.6c3.1-3.1 3.1-8.2 0-11.3l-45.2-45z" } }] }, "name": "expand-alt", "theme": "outlined" };
  exports.default = ExpandAltOutlined;
  });

  var ExpandAltOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(ExpandAltOutlined_1);

  var ExpandAltOutlined = function ExpandAltOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ExpandAltOutlinedSvg
    }));
  };
  var RefIcon$4a = /*#__PURE__*/React.forwardRef(ExpandAltOutlined);
  {
    RefIcon$4a.displayName = 'ExpandAltOutlined';
  }

  var ExpandOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ExpandOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M342 88H120c-17.7 0-32 14.3-32 32v224c0 8.8 7.2 16 16 16h48c8.8 0 16-7.2 16-16V168h174c8.8 0 16-7.2 16-16v-48c0-8.8-7.2-16-16-16zm578 576h-48c-8.8 0-16 7.2-16 16v176H682c-8.8 0-16 7.2-16 16v48c0 8.8 7.2 16 16 16h222c17.7 0 32-14.3 32-32V680c0-8.8-7.2-16-16-16zM342 856H168V680c0-8.8-7.2-16-16-16h-48c-8.8 0-16 7.2-16 16v224c0 17.7 14.3 32 32 32h222c8.8 0 16-7.2 16-16v-48c0-8.8-7.2-16-16-16zM904 88H682c-8.8 0-16 7.2-16 16v48c0 8.8 7.2 16 16 16h174v176c0 8.8 7.2 16 16 16h48c8.8 0 16-7.2 16-16V120c0-17.7-14.3-32-32-32z" } }] }, "name": "expand", "theme": "outlined" };
  exports.default = ExpandOutlined;
  });

  var ExpandOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(ExpandOutlined_1);

  var ExpandOutlined = function ExpandOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ExpandOutlinedSvg
    }));
  };
  var RefIcon$4b = /*#__PURE__*/React.forwardRef(ExpandOutlined);
  {
    RefIcon$4b.displayName = 'ExpandOutlined';
  }

  var ExperimentFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ExperimentFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M218.9 636.3l42.6 26.6c.1.1.3.2.4.3l12.7 8 .3.3a186.9 186.9 0 0094.1 25.1c44.9 0 87.2-15.7 121-43.8a256.27 256.27 0 01164.9-59.9c52.3 0 102.2 15.7 144.6 44.5l7.9 5-111.6-289V179.8h63.5c4.4 0 8-3.6 8-8V120c0-4.4-3.6-8-8-8H264.7c-4.4 0-8 3.6-8 8v51.9c0 4.4 3.6 8 8 8h63.5v173.6L218.9 636.3zm333-203.1c22 0 39.9 17.9 39.9 39.9S573.9 513 551.9 513 512 495.1 512 473.1s17.9-39.9 39.9-39.9zM878 825.1l-29.9-77.4-85.7-53.5-.1.1c-.7-.5-1.5-1-2.2-1.5l-8.1-5-.3-.3c-29-17.5-62.3-26.8-97-26.8-44.9 0-87.2 15.7-121 43.8a256.27 256.27 0 01-164.9 59.9c-53 0-103.5-16.1-146.2-45.6l-28.9-18.1L146 825.1c-2.8 7.4-4.3 15.2-4.3 23 0 35.2 28.6 63.8 63.8 63.8h612.9c7.9 0 15.7-1.5 23-4.3a63.6 63.6 0 0036.6-82.5z" } }] }, "name": "experiment", "theme": "filled" };
  exports.default = ExperimentFilled;
  });

  var ExperimentFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(ExperimentFilled_1);

  var ExperimentFilled = function ExperimentFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ExperimentFilledSvg
    }));
  };
  var RefIcon$4c = /*#__PURE__*/React.forwardRef(ExperimentFilled);
  {
    RefIcon$4c.displayName = 'ExperimentFilled';
  }

  var ExperimentOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ExperimentOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 472a40 40 0 1080 0 40 40 0 10-80 0zm367 352.9L696.3 352V178H768v-68H256v68h71.7v174L145 824.9c-2.8 7.4-4.3 15.2-4.3 23.1 0 35.3 28.7 64 64 64h614.6c7.9 0 15.7-1.5 23.1-4.3 33-12.7 49.4-49.8 36.6-82.8zM395.7 364.7V180h232.6v184.7L719.2 600c-20.7-5.3-42.1-8-63.9-8-61.2 0-119.2 21.5-165.3 60a188.78 188.78 0 01-121.3 43.9c-32.7 0-64.1-8.3-91.8-23.7l118.8-307.5zM210.5 844l41.7-107.8c35.7 18.1 75.4 27.8 116.6 27.8 61.2 0 119.2-21.5 165.3-60 33.9-28.2 76.3-43.9 121.3-43.9 35 0 68.4 9.5 97.6 27.1L813.5 844h-603z" } }] }, "name": "experiment", "theme": "outlined" };
  exports.default = ExperimentOutlined;
  });

  var ExperimentOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(ExperimentOutlined_1);

  var ExperimentOutlined = function ExperimentOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ExperimentOutlinedSvg
    }));
  };
  var RefIcon$4d = /*#__PURE__*/React.forwardRef(ExperimentOutlined);
  {
    RefIcon$4d.displayName = 'ExperimentOutlined';
  }

  var ExperimentTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ExperimentTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M551.9 513c19.6 0 35.9-14.2 39.3-32.8A40.02 40.02 0 01552 512a40 40 0 01-40-39.4v.5c0 22 17.9 39.9 39.9 39.9zM752 687.8l-.3-.3c-29-17.5-62.3-26.8-97-26.8-44.9 0-87.2 15.7-121 43.8a256.27 256.27 0 01-164.9 59.9c-41.2 0-81-9.8-116.7-28L210.5 844h603l-59.9-155.2-1.6-1z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M879 824.9L696.3 352V178H768v-68H256v68h71.7v174L145 824.9c-2.8 7.4-4.3 15.2-4.3 23.1 0 35.3 28.7 64 64 64h614.6c7.9 0 15.7-1.5 23.1-4.3 33-12.7 49.4-49.8 36.6-82.8zM395.7 364.7V180h232.6v184.7L719.2 600c-20.7-5.3-42.1-8-63.9-8-61.2 0-119.2 21.5-165.3 60a188.78 188.78 0 01-121.3 43.9c-32.7 0-64.1-8.3-91.8-23.7l118.8-307.5zM210.5 844l41.6-107.6.1-.2c35.7 18.1 75.4 27.8 116.6 27.8 61.2 0 119.2-21.5 165.3-60 33.9-28.2 76.3-43.9 121.3-43.9 35 0 68.4 9.5 97.6 27.1l.6 1.6L813.5 844h-603z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M552 512c19.3 0 35.4-13.6 39.2-31.8.6-2.7.8-5.4.8-8.2 0-22.1-17.9-40-40-40s-40 17.9-40 40v.6a40 40 0 0040 39.4z", "fill": primaryColor } }] }; }, "name": "experiment", "theme": "twotone" };
  exports.default = ExperimentTwoTone;
  });

  var ExperimentTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(ExperimentTwoTone_1);

  var ExperimentTwoTone = function ExperimentTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ExperimentTwoToneSvg
    }));
  };
  var RefIcon$4e = /*#__PURE__*/React.forwardRef(ExperimentTwoTone);
  {
    RefIcon$4e.displayName = 'ExperimentTwoTone';
  }

  var ExportOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ExportOutlined = { "icon": { "tag": "svg", "attrs": { "fill-rule": "evenodd", "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 912H144c-17.7 0-32-14.3-32-32V144c0-17.7 14.3-32 32-32h360c4.4 0 8 3.6 8 8v56c0 4.4-3.6 8-8 8H184v656h656V520c0-4.4 3.6-8 8-8h56c4.4 0 8 3.6 8 8v360c0 17.7-14.3 32-32 32zM770.87 199.13l-52.2-52.2a8.01 8.01 0 014.7-13.6l179.4-21c5.1-.6 9.5 3.7 8.9 8.9l-21 179.4c-.8 6.6-8.9 9.4-13.6 4.7l-52.4-52.4-256.2 256.2a8.03 8.03 0 01-11.3 0l-42.4-42.4a8.03 8.03 0 010-11.3l256.1-256.3z" } }] }, "name": "export", "theme": "outlined" };
  exports.default = ExportOutlined;
  });

  var ExportOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(ExportOutlined_1);

  var ExportOutlined = function ExportOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ExportOutlinedSvg
    }));
  };
  var RefIcon$4f = /*#__PURE__*/React.forwardRef(ExportOutlined);
  {
    RefIcon$4f.displayName = 'ExportOutlined';
  }

  var EyeFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var EyeFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M396 512a112 112 0 10224 0 112 112 0 10-224 0zm546.2-25.8C847.4 286.5 704.1 186 512 186c-192.2 0-335.4 100.5-430.2 300.3a60.3 60.3 0 000 51.5C176.6 737.5 319.9 838 512 838c192.2 0 335.4-100.5 430.2-300.3 7.7-16.2 7.7-35 0-51.5zM508 688c-97.2 0-176-78.8-176-176s78.8-176 176-176 176 78.8 176 176-78.8 176-176 176z" } }] }, "name": "eye", "theme": "filled" };
  exports.default = EyeFilled;
  });

  var EyeFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(EyeFilled_1);

  var EyeFilled = function EyeFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: EyeFilledSvg
    }));
  };
  var RefIcon$4g = /*#__PURE__*/React.forwardRef(EyeFilled);
  {
    RefIcon$4g.displayName = 'EyeFilled';
  }

  var EyeInvisibleFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var EyeInvisibleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M508 624a112 112 0 00112-112c0-3.28-.15-6.53-.43-9.74L498.26 623.57c3.21.28 6.45.43 9.74.43zm370.72-458.44L836 122.88a8 8 0 00-11.31 0L715.37 232.23Q624.91 186 512 186q-288.3 0-430.2 300.3a60.3 60.3 0 000 51.5q56.7 119.43 136.55 191.45L112.56 835a8 8 0 000 11.31L155.25 889a8 8 0 0011.31 0l712.16-712.12a8 8 0 000-11.32zM332 512a176 176 0 01258.88-155.28l-48.62 48.62a112.08 112.08 0 00-140.92 140.92l-48.62 48.62A175.09 175.09 0 01332 512z" } }, { "tag": "path", "attrs": { "d": "M942.2 486.2Q889.4 375 816.51 304.85L672.37 449A176.08 176.08 0 01445 676.37L322.74 798.63Q407.82 838 512 838q288.3 0 430.2-300.3a60.29 60.29 0 000-51.5z" } }] }, "name": "eye-invisible", "theme": "filled" };
  exports.default = EyeInvisibleFilled;
  });

  var EyeInvisibleFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(EyeInvisibleFilled_1);

  var EyeInvisibleFilled = function EyeInvisibleFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: EyeInvisibleFilledSvg
    }));
  };
  var RefIcon$4h = /*#__PURE__*/React.forwardRef(EyeInvisibleFilled);
  {
    RefIcon$4h.displayName = 'EyeInvisibleFilled';
  }

  var EyeInvisibleOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var EyeInvisibleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M942.2 486.2Q889.47 375.11 816.7 305l-50.88 50.88C807.31 395.53 843.45 447.4 874.7 512 791.5 684.2 673.4 766 512 766q-72.67 0-133.87-22.38L323 798.75Q408 838 512 838q288.3 0 430.2-300.3a60.29 60.29 0 000-51.5zm-63.57-320.64L836 122.88a8 8 0 00-11.32 0L715.31 232.2Q624.86 186 512 186q-288.3 0-430.2 300.3a60.3 60.3 0 000 51.5q56.69 119.4 136.5 191.41L112.48 835a8 8 0 000 11.31L155.17 889a8 8 0 0011.31 0l712.15-712.12a8 8 0 000-11.32zM149.3 512C232.6 339.8 350.7 258 512 258c54.54 0 104.13 9.36 149.12 28.39l-70.3 70.3a176 176 0 00-238.13 238.13l-83.42 83.42C223.1 637.49 183.3 582.28 149.3 512zm246.7 0a112.11 112.11 0 01146.2-106.69L401.31 546.2A112 112 0 01396 512z" } }, { "tag": "path", "attrs": { "d": "M508 624c-3.46 0-6.87-.16-10.25-.47l-52.82 52.82a176.09 176.09 0 00227.42-227.42l-52.82 52.82c.31 3.38.47 6.79.47 10.25a111.94 111.94 0 01-112 112z" } }] }, "name": "eye-invisible", "theme": "outlined" };
  exports.default = EyeInvisibleOutlined;
  });

  var EyeInvisibleOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(EyeInvisibleOutlined_1);

  var EyeInvisibleOutlined = function EyeInvisibleOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: EyeInvisibleOutlinedSvg
    }));
  };
  var RefIcon$4i = /*#__PURE__*/React.forwardRef(EyeInvisibleOutlined);
  {
    RefIcon$4i.displayName = 'EyeInvisibleOutlined';
  }

  var EyeInvisibleTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var EyeInvisibleTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M254.89 758.85l125.57-125.57a176 176 0 01248.82-248.82L757 256.72Q651.69 186.07 512 186q-288.3 0-430.2 300.3a60.3 60.3 0 000 51.5q69.27 145.91 173.09 221.05zM942.2 486.2Q889.46 375.11 816.7 305L672.48 449.27a176.09 176.09 0 01-227.22 227.21L323 798.75Q408 838 512 838q288.3 0 430.2-300.3a60.29 60.29 0 000-51.5z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M942.2 486.2Q889.47 375.11 816.7 305l-50.88 50.88C807.31 395.53 843.45 447.4 874.7 512 791.5 684.2 673.4 766 512 766q-72.67 0-133.87-22.38L323 798.75Q408 838 512 838q288.3 0 430.2-300.3a60.29 60.29 0 000-51.5zM878.63 165.56L836 122.88a8 8 0 00-11.32 0L715.31 232.2Q624.86 186 512 186q-288.3 0-430.2 300.3a60.3 60.3 0 000 51.5q56.69 119.4 136.5 191.41L112.48 835a8 8 0 000 11.31L155.17 889a8 8 0 0011.31 0l712.15-712.12a8 8 0 000-11.32zM149.3 512C232.6 339.8 350.7 258 512 258c54.54 0 104.13 9.36 149.12 28.39l-70.3 70.3a176 176 0 00-238.13 238.13l-83.42 83.42C223.1 637.49 183.3 582.28 149.3 512zm246.7 0a112.11 112.11 0 01146.2-106.69L401.31 546.2A112 112 0 01396 512z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M508 624c-3.46 0-6.87-.16-10.25-.47l-52.82 52.82a176.09 176.09 0 00227.42-227.42l-52.82 52.82c.31 3.38.47 6.79.47 10.25a111.94 111.94 0 01-112 112z", "fill": primaryColor } }] }; }, "name": "eye-invisible", "theme": "twotone" };
  exports.default = EyeInvisibleTwoTone;
  });

  var EyeInvisibleTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(EyeInvisibleTwoTone_1);

  var EyeInvisibleTwoTone = function EyeInvisibleTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: EyeInvisibleTwoToneSvg
    }));
  };
  var RefIcon$4j = /*#__PURE__*/React.forwardRef(EyeInvisibleTwoTone);
  {
    RefIcon$4j.displayName = 'EyeInvisibleTwoTone';
  }

  var EyeOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var EyeOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M942.2 486.2C847.4 286.5 704.1 186 512 186c-192.2 0-335.4 100.5-430.2 300.3a60.3 60.3 0 000 51.5C176.6 737.5 319.9 838 512 838c192.2 0 335.4-100.5 430.2-300.3 7.7-16.2 7.7-35 0-51.5zM512 766c-161.3 0-279.4-81.8-362.7-254C232.6 339.8 350.7 258 512 258c161.3 0 279.4 81.8 362.7 254C791.5 684.2 673.4 766 512 766zm-4-430c-97.2 0-176 78.8-176 176s78.8 176 176 176 176-78.8 176-176-78.8-176-176-176zm0 288c-61.9 0-112-50.1-112-112s50.1-112 112-112 112 50.1 112 112-50.1 112-112 112z" } }] }, "name": "eye", "theme": "outlined" };
  exports.default = EyeOutlined;
  });

  var EyeOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(EyeOutlined_1);

  var EyeOutlined = function EyeOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: EyeOutlinedSvg
    }));
  };
  var RefIcon$4k = /*#__PURE__*/React.forwardRef(EyeOutlined);
  {
    RefIcon$4k.displayName = 'EyeOutlined';
  }

  var EyeTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var EyeTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M81.8 537.8a60.3 60.3 0 010-51.5C176.6 286.5 319.8 186 512 186c-192.2 0-335.4 100.5-430.2 300.3a60.3 60.3 0 000 51.5C176.6 737.5 319.9 838 512 838c-192.1 0-335.4-100.5-430.2-300.2z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M512 258c-161.3 0-279.4 81.8-362.7 254C232.6 684.2 350.7 766 512 766c161.4 0 279.5-81.8 362.7-254C791.4 339.8 673.3 258 512 258zm-4 430c-97.2 0-176-78.8-176-176s78.8-176 176-176 176 78.8 176 176-78.8 176-176 176z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M942.2 486.2C847.4 286.5 704.1 186 512 186c-192.2 0-335.4 100.5-430.2 300.3a60.3 60.3 0 000 51.5C176.6 737.5 319.9 838 512 838c192.2 0 335.4-100.5 430.2-300.3 7.7-16.2 7.7-35 0-51.5zM512 766c-161.3 0-279.4-81.8-362.7-254C232.6 339.8 350.7 258 512 258s279.4 81.8 362.7 254C791.5 684.2 673.4 766 512 766z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M508 336c-97.2 0-176 78.8-176 176s78.8 176 176 176 176-78.8 176-176-78.8-176-176-176zm0 288c-61.9 0-112-50.1-112-112s50.1-112 112-112 112 50.1 112 112-50.1 112-112 112z", "fill": primaryColor } }] }; }, "name": "eye", "theme": "twotone" };
  exports.default = EyeTwoTone;
  });

  var EyeTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(EyeTwoTone_1);

  var EyeTwoTone = function EyeTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: EyeTwoToneSvg
    }));
  };
  var RefIcon$4l = /*#__PURE__*/React.forwardRef(EyeTwoTone);
  {
    RefIcon$4l.displayName = 'EyeTwoTone';
  }

  var FacebookFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FacebookFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-92.4 233.5h-63.9c-50.1 0-59.8 23.8-59.8 58.8v77.1h119.6l-15.6 120.7h-104V912H539.2V602.2H434.9V481.4h104.3v-89c0-103.3 63.1-159.6 155.3-159.6 44.2 0 82.1 3.3 93.2 4.8v107.9z" } }] }, "name": "facebook", "theme": "filled" };
  exports.default = FacebookFilled;
  });

  var FacebookFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(FacebookFilled_1);

  var FacebookFilled = function FacebookFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FacebookFilledSvg
    }));
  };
  var RefIcon$4m = /*#__PURE__*/React.forwardRef(FacebookFilled);
  {
    RefIcon$4m.displayName = 'FacebookFilled';
  }

  var FacebookOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FacebookOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-32 736H663.9V602.2h104l15.6-120.7H663.9v-77.1c0-35 9.7-58.8 59.8-58.8h63.9v-108c-11.1-1.5-49-4.8-93.2-4.8-92.2 0-155.3 56.3-155.3 159.6v89H434.9v120.7h104.3V848H176V176h672v672z" } }] }, "name": "facebook", "theme": "outlined" };
  exports.default = FacebookOutlined;
  });

  var FacebookOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FacebookOutlined_1);

  var FacebookOutlined = function FacebookOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FacebookOutlinedSvg
    }));
  };
  var RefIcon$4n = /*#__PURE__*/React.forwardRef(FacebookOutlined);
  {
    RefIcon$4n.displayName = 'FacebookOutlined';
  }

  var FallOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FallOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M925.9 804l-24-199.2c-.8-6.6-8.9-9.4-13.6-4.7L829 659.5 557.7 388.3c-6.3-6.2-16.4-6.2-22.6 0L433.3 490 156.6 213.3a8.03 8.03 0 00-11.3 0l-45 45.2a8.03 8.03 0 000 11.3L422 591.7c6.2 6.3 16.4 6.3 22.6 0L546.4 490l226.1 226-59.3 59.3a8.01 8.01 0 004.7 13.6l199.2 24c5.1.7 9.5-3.7 8.8-8.9z" } }] }, "name": "fall", "theme": "outlined" };
  exports.default = FallOutlined;
  });

  var FallOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FallOutlined_1);

  var FallOutlined = function FallOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FallOutlinedSvg
    }));
  };
  var RefIcon$4o = /*#__PURE__*/React.forwardRef(FallOutlined);
  {
    RefIcon$4o.displayName = 'FallOutlined';
  }

  var FastBackwardFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FastBackwardFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M517.6 273.5L230.2 499.3a16.14 16.14 0 000 25.4l287.4 225.8c10.7 8.4 26.4.8 26.4-12.7V286.2c0-13.5-15.7-21.1-26.4-12.7zm320 0L550.2 499.3a16.14 16.14 0 000 25.4l287.4 225.8c10.7 8.4 26.4.8 26.4-12.7V286.2c0-13.5-15.7-21.1-26.4-12.7zm-620-25.5h-51.2c-3.5 0-6.4 2.7-6.4 6v516c0 3.3 2.9 6 6.4 6h51.2c3.5 0 6.4-2.7 6.4-6V254c0-3.3-2.9-6-6.4-6z" } }] }, "name": "fast-backward", "theme": "filled" };
  exports.default = FastBackwardFilled;
  });

  var FastBackwardFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(FastBackwardFilled_1);

  var FastBackwardFilled = function FastBackwardFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FastBackwardFilledSvg
    }));
  };
  var RefIcon$4p = /*#__PURE__*/React.forwardRef(FastBackwardFilled);
  {
    RefIcon$4p.displayName = 'FastBackwardFilled';
  }

  var FastBackwardOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FastBackwardOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M517.6 273.5L230.2 499.3a16.14 16.14 0 000 25.4l287.4 225.8c10.7 8.4 26.4.8 26.4-12.7V286.2c0-13.5-15.7-21.1-26.4-12.7zm320 0L550.2 499.3a16.14 16.14 0 000 25.4l287.4 225.8c10.7 8.4 26.4.8 26.4-12.7V286.2c0-13.5-15.7-21.1-26.4-12.7zm-620-25.5h-51.2c-3.5 0-6.4 2.7-6.4 6v516c0 3.3 2.9 6 6.4 6h51.2c3.5 0 6.4-2.7 6.4-6V254c0-3.3-2.9-6-6.4-6z" } }] }, "name": "fast-backward", "theme": "outlined" };
  exports.default = FastBackwardOutlined;
  });

  var FastBackwardOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FastBackwardOutlined_1);

  var FastBackwardOutlined = function FastBackwardOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FastBackwardOutlinedSvg
    }));
  };
  var RefIcon$4q = /*#__PURE__*/React.forwardRef(FastBackwardOutlined);
  {
    RefIcon$4q.displayName = 'FastBackwardOutlined';
  }

  var FastForwardFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FastForwardFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M793.8 499.3L506.4 273.5c-10.7-8.4-26.4-.8-26.4 12.7v451.6c0 13.5 15.7 21.1 26.4 12.7l287.4-225.8a16.14 16.14 0 000-25.4zm-320 0L186.4 273.5c-10.7-8.4-26.4-.8-26.4 12.7v451.5c0 13.5 15.7 21.1 26.4 12.7l287.4-225.8c4.1-3.2 6.2-8 6.2-12.7 0-4.6-2.1-9.4-6.2-12.6zM857.6 248h-51.2c-3.5 0-6.4 2.7-6.4 6v516c0 3.3 2.9 6 6.4 6h51.2c3.5 0 6.4-2.7 6.4-6V254c0-3.3-2.9-6-6.4-6z" } }] }, "name": "fast-forward", "theme": "filled" };
  exports.default = FastForwardFilled;
  });

  var FastForwardFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(FastForwardFilled_1);

  var FastForwardFilled = function FastForwardFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FastForwardFilledSvg
    }));
  };
  var RefIcon$4r = /*#__PURE__*/React.forwardRef(FastForwardFilled);
  {
    RefIcon$4r.displayName = 'FastForwardFilled';
  }

  var FastForwardOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FastForwardOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M793.8 499.3L506.4 273.5c-10.7-8.4-26.4-.8-26.4 12.7v451.6c0 13.5 15.7 21.1 26.4 12.7l287.4-225.8a16.14 16.14 0 000-25.4zm-320 0L186.4 273.5c-10.7-8.4-26.4-.8-26.4 12.7v451.5c0 13.5 15.7 21.1 26.4 12.7l287.4-225.8c4.1-3.2 6.2-8 6.2-12.7 0-4.6-2.1-9.4-6.2-12.6zM857.6 248h-51.2c-3.5 0-6.4 2.7-6.4 6v516c0 3.3 2.9 6 6.4 6h51.2c3.5 0 6.4-2.7 6.4-6V254c0-3.3-2.9-6-6.4-6z" } }] }, "name": "fast-forward", "theme": "outlined" };
  exports.default = FastForwardOutlined;
  });

  var FastForwardOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FastForwardOutlined_1);

  var FastForwardOutlined = function FastForwardOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FastForwardOutlinedSvg
    }));
  };
  var RefIcon$4s = /*#__PURE__*/React.forwardRef(FastForwardOutlined);
  {
    RefIcon$4s.displayName = 'FastForwardOutlined';
  }

  var FieldBinaryOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FieldBinaryOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M600 395.4h91V649h79V267c0-4.4-3.6-8-8-8h-48.2c-3.7 0-7 2.6-7.7 6.3-2.6 12.1-6.9 22.3-12.9 30.9a86.14 86.14 0 01-26.3 24.4c-10.3 6.2-22 10.5-35 12.9-10.4 1.9-21 3-32 3.1a8 8 0 00-7.9 8v42.8c0 4.4 3.6 8 8 8zM871 702H567c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h304c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8zM443.9 312.7c-16.1-19-34.4-32.4-55.2-40.4-21.3-8.2-44.1-12.3-68.4-12.3-23.9 0-46.4 4.1-67.7 12.3-20.8 8-39 21.4-54.8 40.3-15.9 19.1-28.7 44.7-38.3 77-9.6 32.5-14.5 73-14.5 121.5 0 49.9 4.9 91.4 14.5 124.4 9.6 32.8 22.4 58.7 38.3 77.7 15.8 18.9 34 32.3 54.8 40.3 21.3 8.2 43.8 12.3 67.7 12.3 24.4 0 47.2-4.1 68.4-12.3 20.8-8 39.2-21.4 55.2-40.4 16.1-19 29-44.9 38.6-77.7 9.6-33 14.5-74.5 14.5-124.4 0-48.4-4.9-88.9-14.5-121.5-9.5-32.1-22.4-57.7-38.6-76.8zm-29.5 251.7c-1 21.4-4.2 42-9.5 61.9-5.5 20.7-14.5 38.5-27 53.4-13.6 16.3-33.2 24.3-57.6 24.3-24 0-43.2-8.1-56.7-24.4-12.2-14.8-21.1-32.6-26.6-53.3-5.3-19.9-8.5-40.6-9.5-61.9-1-20.8-1.5-38.5-1.5-53.2 0-8.8.1-19.4.4-31.8.2-12.7 1.1-25.8 2.6-39.2 1.5-13.6 4-27.1 7.6-40.5 3.7-13.8 8.8-26.3 15.4-37.4 6.9-11.6 15.8-21.1 26.7-28.3 11.4-7.6 25.3-11.3 41.5-11.3 16.1 0 30.1 3.7 41.7 11.2a87.94 87.94 0 0127.4 28.2c6.9 11.2 12.1 23.8 15.6 37.7 3.3 13.2 5.8 26.6 7.5 40.1 1.8 13.5 2.8 26.6 3 39.4.2 12.4.4 23 .4 31.8.1 14.8-.4 32.5-1.4 53.3z" } }] }, "name": "field-binary", "theme": "outlined" };
  exports.default = FieldBinaryOutlined;
  });

  var FieldBinaryOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FieldBinaryOutlined_1);

  var FieldBinaryOutlined = function FieldBinaryOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FieldBinaryOutlinedSvg
    }));
  };
  var RefIcon$4t = /*#__PURE__*/React.forwardRef(FieldBinaryOutlined);
  {
    RefIcon$4t.displayName = 'FieldBinaryOutlined';
  }

  var FieldNumberOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FieldNumberOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M508 280h-63.3c-3.3 0-6 2.7-6 6v340.2H433L197.4 282.6c-1.1-1.6-3-2.6-4.9-2.6H126c-3.3 0-6 2.7-6 6v464c0 3.3 2.7 6 6 6h62.7c3.3 0 6-2.7 6-6V405.1h5.7l238.2 348.3c1.1 1.6 3 2.6 5 2.6H508c3.3 0 6-2.7 6-6V286c0-3.3-2.7-6-6-6zm378 413H582c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h304c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8zm-152.2-63c52.9 0 95.2-17.2 126.2-51.7 29.4-32.9 44-75.8 44-128.8 0-53.1-14.6-96.5-44-129.3-30.9-34.8-73.2-52.2-126.2-52.2-53.7 0-95.9 17.5-126.3 52.8-29.2 33.1-43.4 75.9-43.4 128.7 0 52.4 14.3 95.2 43.5 128.3 30.6 34.7 73 52.2 126.2 52.2zm-71.5-263.7c16.9-20.6 40.3-30.9 71.4-30.9 31.5 0 54.8 9.6 71 29.1 16.4 20.3 24.9 48.6 24.9 84.9 0 36.3-8.4 64.1-24.8 83.9-16.5 19.4-40 29.2-71.1 29.2-31.2 0-55-10.3-71.4-30.4-16.3-20.1-24.5-47.3-24.5-82.6.1-35.8 8.2-63 24.5-83.2z" } }] }, "name": "field-number", "theme": "outlined" };
  exports.default = FieldNumberOutlined;
  });

  var FieldNumberOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FieldNumberOutlined_1);

  var FieldNumberOutlined = function FieldNumberOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FieldNumberOutlinedSvg
    }));
  };
  var RefIcon$4u = /*#__PURE__*/React.forwardRef(FieldNumberOutlined);
  {
    RefIcon$4u.displayName = 'FieldNumberOutlined';
  }

  var FieldStringOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FieldStringOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M875.6 515.9c2.1.8 4.4-.3 5.2-2.4.2-.4.2-.9.2-1.4v-58.3c0-1.8-1.1-3.3-2.8-3.8-6-1.8-17.2-3-27.2-3-32.9 0-61.7 16.7-73.5 41.2v-28.6c0-4.4-3.6-8-8-8H717c-4.4 0-8 3.6-8 8V729c0 4.4 3.6 8 8 8h54.8c4.4 0 8-3.6 8-8V572.7c0-36.2 26.1-60.2 65.1-60.2 10.4.1 26.6 1.8 30.7 3.4zm-537-40.5l-54.7-12.6c-61.2-14.2-87.7-34.8-87.7-70.7 0-44.6 39.1-73.5 96.9-73.5 52.8 0 91.4 26.5 99.9 68.9h70C455.9 311.6 387.6 259 293.4 259c-103.3 0-171 55.5-171 139 0 68.6 38.6 109.5 122.2 128.5l61.6 14.3c63.6 14.9 91.6 37.1 91.6 75.1 0 44.1-43.5 75.2-102.5 75.2-60.6 0-104.5-27.2-112.8-70.5H111c7.2 79.9 75.6 130.4 179.1 130.4C402.3 751 471 695.2 471 605.3c0-70.2-38.6-108.5-132.4-129.9zM841 729a36 36 0 1072 0 36 36 0 10-72 0zM653 457.8h-51.4V396c0-4.4-3.6-8-8-8h-54.7c-4.4 0-8 3.6-8 8v61.8H495c-4.4 0-8 3.6-8 8v42.3c0 4.4 3.6 8 8 8h35.9v147.5c0 56.2 27.4 79.4 93.1 79.4 11.7 0 23.6-1.2 33.8-3.1 1.9-.3 3.2-2 3.2-3.9v-49.3c0-2.2-1.8-4-4-4h-.4c-4.9.5-6.2.6-8.3.8-4.1.3-7.8.5-12.6.5-24.1 0-34.1-10.3-34.1-35.6V516.1H653c4.4 0 8-3.6 8-8v-42.3c0-4.4-3.6-8-8-8z" } }] }, "name": "field-string", "theme": "outlined" };
  exports.default = FieldStringOutlined;
  });

  var FieldStringOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FieldStringOutlined_1);

  var FieldStringOutlined = function FieldStringOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FieldStringOutlinedSvg
    }));
  };
  var RefIcon$4v = /*#__PURE__*/React.forwardRef(FieldStringOutlined);
  {
    RefIcon$4v.displayName = 'FieldStringOutlined';
  }

  var FieldTimeOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FieldTimeOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M945 412H689c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h256c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8zM811 548H689c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h122c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8zM477.3 322.5H434c-6.2 0-11.2 5-11.2 11.2v248c0 3.6 1.7 6.9 4.6 9l148.9 108.6c5 3.6 12 2.6 15.6-2.4l25.7-35.1v-.1c3.6-5 2.5-12-2.5-15.6l-126.7-91.6V333.7c.1-6.2-5-11.2-11.1-11.2z" } }, { "tag": "path", "attrs": { "d": "M804.8 673.9H747c-5.6 0-10.9 2.9-13.9 7.7a321 321 0 01-44.5 55.7 317.17 317.17 0 01-101.3 68.3c-39.3 16.6-81 25-124 25-43.1 0-84.8-8.4-124-25-37.9-16-72-39-101.3-68.3s-52.3-63.4-68.3-101.3c-16.6-39.2-25-80.9-25-124 0-43.1 8.4-84.7 25-124 16-37.9 39-72 68.3-101.3 29.3-29.3 63.4-52.3 101.3-68.3 39.2-16.6 81-25 124-25 43.1 0 84.8 8.4 124 25 37.9 16 72 39 101.3 68.3a321 321 0 0144.5 55.7c3 4.8 8.3 7.7 13.9 7.7h57.8c6.9 0 11.3-7.2 8.2-13.3-65.2-129.7-197.4-214-345-215.7-216.1-2.7-395.6 174.2-396 390.1C71.6 727.5 246.9 903 463.2 903c149.5 0 283.9-84.6 349.8-215.8a9.18 9.18 0 00-8.2-13.3z" } }] }, "name": "field-time", "theme": "outlined" };
  exports.default = FieldTimeOutlined;
  });

  var FieldTimeOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FieldTimeOutlined_1);

  var FieldTimeOutlined = function FieldTimeOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FieldTimeOutlinedSvg
    }));
  };
  var RefIcon$4w = /*#__PURE__*/React.forwardRef(FieldTimeOutlined);
  {
    RefIcon$4w.displayName = 'FieldTimeOutlined';
  }

  var FileAddFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FileAddFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M480 580H372a8 8 0 00-8 8v48a8 8 0 008 8h108v108a8 8 0 008 8h48a8 8 0 008-8V644h108a8 8 0 008-8v-48a8 8 0 00-8-8H544V472a8 8 0 00-8-8h-48a8 8 0 00-8 8v108zm374.6-291.3c6 6 9.4 14.1 9.4 22.6V928c0 17.7-14.3 32-32 32H192c-17.7 0-32-14.3-32-32V96c0-17.7 14.3-32 32-32h424.7c8.5 0 16.7 3.4 22.7 9.4l215.2 215.3zM790.2 326L602 137.8V326h188.2z" } }] }, "name": "file-add", "theme": "filled" };
  exports.default = FileAddFilled;
  });

  var FileAddFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(FileAddFilled_1);

  var FileAddFilled = function FileAddFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FileAddFilledSvg
    }));
  };
  var RefIcon$4x = /*#__PURE__*/React.forwardRef(FileAddFilled);
  {
    RefIcon$4x.displayName = 'FileAddFilled';
  }

  var FileAddOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FileAddOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM790.2 326H602V137.8L790.2 326zm1.8 562H232V136h302v216a42 42 0 0042 42h216v494zM544 472c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v108H372c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h108v108c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V644h108c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H544V472z" } }] }, "name": "file-add", "theme": "outlined" };
  exports.default = FileAddOutlined;
  });

  var FileAddOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FileAddOutlined_1);

  var FileAddOutlined = function FileAddOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FileAddOutlinedSvg
    }));
  };
  var RefIcon$4y = /*#__PURE__*/React.forwardRef(FileAddOutlined);
  {
    RefIcon$4y.displayName = 'FileAddOutlined';
  }

  var FileAddTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FileAddTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M534 352V136H232v752h560V394H576a42 42 0 01-42-42zm126 236v48c0 4.4-3.6 8-8 8H544v108c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V644H372c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h108V472c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v108h108c4.4 0 8 3.6 8 8z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM602 137.8L790.2 326H602V137.8zM792 888H232V136h302v216a42 42 0 0042 42h216v494z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M544 472c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v108H372c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h108v108c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V644h108c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H544V472z", "fill": primaryColor } }] }; }, "name": "file-add", "theme": "twotone" };
  exports.default = FileAddTwoTone;
  });

  var FileAddTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(FileAddTwoTone_1);

  var FileAddTwoTone = function FileAddTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FileAddTwoToneSvg
    }));
  };
  var RefIcon$4z = /*#__PURE__*/React.forwardRef(FileAddTwoTone);
  {
    RefIcon$4z.displayName = 'FileAddTwoTone';
  }

  var FileDoneOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FileDoneOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M688 312v-48c0-4.4-3.6-8-8-8H296c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h384c4.4 0 8-3.6 8-8zm-392 88c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h184c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H296zm376 116c-119.3 0-216 96.7-216 216s96.7 216 216 216 216-96.7 216-216-96.7-216-216-216zm107.5 323.5C750.8 868.2 712.6 884 672 884s-78.8-15.8-107.5-44.5C535.8 810.8 520 772.6 520 732s15.8-78.8 44.5-107.5C593.2 595.8 631.4 580 672 580s78.8 15.8 107.5 44.5C808.2 653.2 824 691.4 824 732s-15.8 78.8-44.5 107.5zM761 656h-44.3c-2.6 0-5 1.2-6.5 3.3l-63.5 87.8-23.1-31.9a7.92 7.92 0 00-6.5-3.3H573c-6.5 0-10.3 7.4-6.5 12.7l73.8 102.1c3.2 4.4 9.7 4.4 12.9 0l114.2-158c3.9-5.3.1-12.7-6.4-12.7zM440 852H208V148h560v344c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V108c0-17.7-14.3-32-32-32H168c-17.7 0-32 14.3-32 32v784c0 17.7 14.3 32 32 32h272c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8z" } }] }, "name": "file-done", "theme": "outlined" };
  exports.default = FileDoneOutlined;
  });

  var FileDoneOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FileDoneOutlined_1);

  var FileDoneOutlined = function FileDoneOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FileDoneOutlinedSvg
    }));
  };
  var RefIcon$4A = /*#__PURE__*/React.forwardRef(FileDoneOutlined);
  {
    RefIcon$4A.displayName = 'FileDoneOutlined';
  }

  var FileExcelFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FileExcelFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.7c6 6 9.4 14.1 9.4 22.6V928c0 17.7-14.3 32-32 32H192c-17.7 0-32-14.3-32-32V96c0-17.7 14.3-32 32-32h424.7c8.5 0 16.7 3.4 22.7 9.4l215.2 215.3zM790.2 326L602 137.8V326h188.2zM575.34 477.84l-61.22 102.3L452.3 477.8a12 12 0 00-10.27-5.79h-38.44a12 12 0 00-6.4 1.85 12 12 0 00-3.75 16.56l82.34 130.42-83.45 132.78a12 12 0 00-1.84 6.39 12 12 0 0012 12h34.46a12 12 0 0010.21-5.7l62.7-101.47 62.3 101.45a12 12 0 0010.23 5.72h37.48a12 12 0 006.48-1.9 12 12 0 003.62-16.58l-83.83-130.55 85.3-132.47a12 12 0 001.9-6.5 12 12 0 00-12-12h-35.7a12 12 0 00-10.29 5.84z" } }] }, "name": "file-excel", "theme": "filled" };
  exports.default = FileExcelFilled;
  });

  var FileExcelFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(FileExcelFilled_1);

  var FileExcelFilled = function FileExcelFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FileExcelFilledSvg
    }));
  };
  var RefIcon$4B = /*#__PURE__*/React.forwardRef(FileExcelFilled);
  {
    RefIcon$4B.displayName = 'FileExcelFilled';
  }

  var FileExcelOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FileExcelOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM790.2 326H602V137.8L790.2 326zm1.8 562H232V136h302v216a42 42 0 0042 42h216v494zM514.1 580.1l-61.8-102.4c-2.2-3.6-6.1-5.8-10.3-5.8h-38.4c-2.3 0-4.5.6-6.4 1.9-5.6 3.5-7.3 10.9-3.7 16.6l82.3 130.4-83.4 132.8a12.04 12.04 0 0010.2 18.4h34.5c4.2 0 8-2.2 10.2-5.7L510 664.8l62.3 101.4c2.2 3.6 6.1 5.7 10.2 5.7H620c2.3 0 4.5-.7 6.5-1.9 5.6-3.6 7.2-11 3.6-16.6l-84-130.4 85.3-132.5a12.04 12.04 0 00-10.1-18.5h-35.7c-4.2 0-8.1 2.2-10.3 5.8l-61.2 102.3z" } }] }, "name": "file-excel", "theme": "outlined" };
  exports.default = FileExcelOutlined;
  });

  var FileExcelOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FileExcelOutlined_1);

  var FileExcelOutlined = function FileExcelOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FileExcelOutlinedSvg
    }));
  };
  var RefIcon$4C = /*#__PURE__*/React.forwardRef(FileExcelOutlined);
  {
    RefIcon$4C.displayName = 'FileExcelOutlined';
  }

  var FileExcelTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FileExcelTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M534 352V136H232v752h560V394H576a42 42 0 01-42-42zm51.6 120h35.7a12.04 12.04 0 0110.1 18.5L546.1 623l84 130.4c3.6 5.6 2 13-3.6 16.6-2 1.2-4.2 1.9-6.5 1.9h-37.5c-4.1 0-8-2.1-10.2-5.7L510 664.8l-62.7 101.5c-2.2 3.5-6 5.7-10.2 5.7h-34.5a12.04 12.04 0 01-10.2-18.4l83.4-132.8-82.3-130.4c-3.6-5.7-1.9-13.1 3.7-16.6 1.9-1.3 4.1-1.9 6.4-1.9H442c4.2 0 8.1 2.2 10.3 5.8l61.8 102.4 61.2-102.3c2.2-3.6 6.1-5.8 10.3-5.8z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM602 137.8L790.2 326H602V137.8zM792 888H232V136h302v216a42 42 0 0042 42h216v494z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M514.1 580.1l-61.8-102.4c-2.2-3.6-6.1-5.8-10.3-5.8h-38.4c-2.3 0-4.5.6-6.4 1.9-5.6 3.5-7.3 10.9-3.7 16.6l82.3 130.4-83.4 132.8a12.04 12.04 0 0010.2 18.4h34.5c4.2 0 8-2.2 10.2-5.7L510 664.8l62.3 101.4c2.2 3.6 6.1 5.7 10.2 5.7H620c2.3 0 4.5-.7 6.5-1.9 5.6-3.6 7.2-11 3.6-16.6l-84-130.4 85.3-132.5a12.04 12.04 0 00-10.1-18.5h-35.7c-4.2 0-8.1 2.2-10.3 5.8l-61.2 102.3z", "fill": primaryColor } }] }; }, "name": "file-excel", "theme": "twotone" };
  exports.default = FileExcelTwoTone;
  });

  var FileExcelTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(FileExcelTwoTone_1);

  var FileExcelTwoTone = function FileExcelTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FileExcelTwoToneSvg
    }));
  };
  var RefIcon$4D = /*#__PURE__*/React.forwardRef(FileExcelTwoTone);
  {
    RefIcon$4D.displayName = 'FileExcelTwoTone';
  }

  var FileExclamationFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FileExclamationFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.7c6 6 9.4 14.1 9.4 22.6V928c0 17.7-14.3 32-32 32H192c-17.7 0-32-14.3-32-32V96c0-17.7 14.3-32 32-32h424.7c8.5 0 16.7 3.4 22.7 9.4l215.2 215.3zM790.2 326L602 137.8V326h188.2zM512 784a40 40 0 100-80 40 40 0 000 80zm32-152V448a8 8 0 00-8-8h-48a8 8 0 00-8 8v184a8 8 0 008 8h48a8 8 0 008-8z" } }] }, "name": "file-exclamation", "theme": "filled" };
  exports.default = FileExclamationFilled;
  });

  var FileExclamationFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(FileExclamationFilled_1);

  var FileExclamationFilled = function FileExclamationFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FileExclamationFilledSvg
    }));
  };
  var RefIcon$4E = /*#__PURE__*/React.forwardRef(FileExclamationFilled);
  {
    RefIcon$4E.displayName = 'FileExclamationFilled';
  }

  var FileExclamationOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FileExclamationOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM790.2 326H602V137.8L790.2 326zm1.8 562H232V136h302v216a42 42 0 0042 42h216v494zM472 744a40 40 0 1080 0 40 40 0 10-80 0zm16-104h48c4.4 0 8-3.6 8-8V448c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v184c0 4.4 3.6 8 8 8z" } }] }, "name": "file-exclamation", "theme": "outlined" };
  exports.default = FileExclamationOutlined;
  });

  var FileExclamationOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FileExclamationOutlined_1);

  var FileExclamationOutlined = function FileExclamationOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FileExclamationOutlinedSvg
    }));
  };
  var RefIcon$4F = /*#__PURE__*/React.forwardRef(FileExclamationOutlined);
  {
    RefIcon$4F.displayName = 'FileExclamationOutlined';
  }

  var FileExclamationTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FileExclamationTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M534 352V136H232v752h560V394H576a42 42 0 01-42-42zm-54 96c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v184c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V448zm32 336c-22.1 0-40-17.9-40-40s17.9-40 40-40 40 17.9 40 40-17.9 40-40 40z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM602 137.8L790.2 326H602V137.8zM792 888H232V136h302v216a42 42 0 0042 42h216v494z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M488 640h48c4.4 0 8-3.6 8-8V448c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v184c0 4.4 3.6 8 8 8zm-16 104a40 40 0 1080 0 40 40 0 10-80 0z", "fill": primaryColor } }] }; }, "name": "file-exclamation", "theme": "twotone" };
  exports.default = FileExclamationTwoTone;
  });

  var FileExclamationTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(FileExclamationTwoTone_1);

  var FileExclamationTwoTone = function FileExclamationTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FileExclamationTwoToneSvg
    }));
  };
  var RefIcon$4G = /*#__PURE__*/React.forwardRef(FileExclamationTwoTone);
  {
    RefIcon$4G.displayName = 'FileExclamationTwoTone';
  }

  var FileFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FileFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.7c6 6 9.4 14.1 9.4 22.6V928c0 17.7-14.3 32-32 32H192c-17.7 0-32-14.3-32-32V96c0-17.7 14.3-32 32-32h424.7c8.5 0 16.7 3.4 22.7 9.4l215.2 215.3zM790.2 326L602 137.8V326h188.2z" } }] }, "name": "file", "theme": "filled" };
  exports.default = FileFilled;
  });

  var FileFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(FileFilled_1);

  var FileFilled = function FileFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FileFilledSvg
    }));
  };
  var RefIcon$4H = /*#__PURE__*/React.forwardRef(FileFilled);
  {
    RefIcon$4H.displayName = 'FileFilled';
  }

  var FileGifOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FileGifOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M551.5 490.5H521c-4.6 0-8.4 3.7-8.4 8.4V720c0 4.6 3.7 8.4 8.4 8.4h30.5c4.6 0 8.4-3.7 8.4-8.4V498.9c-.1-4.6-3.8-8.4-8.4-8.4zM477.3 600h-88.1c-4.6 0-8.4 3.7-8.4 8.4v23.8c0 4.6 3.7 8.4 8.4 8.4h47.6v.7c-.6 29.9-23 49.8-56.5 49.8-39.2 0-63.6-30.7-63.6-81.4 0-50.1 23.9-80.6 62.3-80.6 28.1 0 47.5 13.5 55.4 38.3l.9 2.8h49.2l-.7-4.6C475.9 515.9 434.7 484 379 484c-68.8 0-113 49.4-113 125.9 0 77.5 43.7 126.1 113.6 126.1 64.4 0 106-40.3 106-102.9v-24.8c0-4.6-3.7-8.3-8.3-8.3z" } }, { "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM602 137.8L790.2 326H602V137.8zM792 888H232V136h302v216a42 42 0 0042 42h216v494z" } }, { "tag": "path", "attrs": { "d": "M608.2 727.8h32.3c4.6 0 8.4-3.7 8.4-8.4v-84.8h87.8c4.6 0 8.4-3.7 8.4-8.4v-25.5c0-4.6-3.7-8.4-8.4-8.4h-87.8v-58.9h96.8c4.6 0 8.4-3.7 8.4-8.4v-26.8c0-4.6-3.7-8.4-8.4-8.4H608.2c-4.6 0-8.4 3.7-8.4 8.4v221.1c0 4.8 3.8 8.5 8.4 8.5z" } }] }, "name": "file-gif", "theme": "outlined" };
  exports.default = FileGifOutlined;
  });

  var FileGifOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FileGifOutlined_1);

  var FileGifOutlined = function FileGifOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FileGifOutlinedSvg
    }));
  };
  var RefIcon$4I = /*#__PURE__*/React.forwardRef(FileGifOutlined);
  {
    RefIcon$4I.displayName = 'FileGifOutlined';
  }

  var FileImageFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FileImageFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.7L639.4 73.4c-6-6-14.2-9.4-22.7-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.6-9.4-22.6zM400 402c22.1 0 40 17.9 40 40s-17.9 40-40 40-40-17.9-40-40 17.9-40 40-40zm296 294H328c-6.7 0-10.4-7.7-6.3-12.9l99.8-127.2a8 8 0 0112.6 0l41.1 52.4 77.8-99.2a8 8 0 0112.6 0l136.5 174c4.3 5.2.5 12.9-6.1 12.9zm-94-370V137.8L790.2 326H602z" } }] }, "name": "file-image", "theme": "filled" };
  exports.default = FileImageFilled;
  });

  var FileImageFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(FileImageFilled_1);

  var FileImageFilled = function FileImageFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FileImageFilledSvg
    }));
  };
  var RefIcon$4J = /*#__PURE__*/React.forwardRef(FileImageFilled);
  {
    RefIcon$4J.displayName = 'FileImageFilled';
  }

  var FileImageOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FileImageOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M553.1 509.1l-77.8 99.2-41.1-52.4a8 8 0 00-12.6 0l-99.8 127.2a7.98 7.98 0 006.3 12.9H696c6.7 0 10.4-7.7 6.3-12.9l-136.5-174a8.1 8.1 0 00-12.7 0zM360 442a40 40 0 1080 0 40 40 0 10-80 0zm494.6-153.4L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM790.2 326H602V137.8L790.2 326zm1.8 562H232V136h302v216a42 42 0 0042 42h216v494z" } }] }, "name": "file-image", "theme": "outlined" };
  exports.default = FileImageOutlined;
  });

  var FileImageOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FileImageOutlined_1);

  var FileImageOutlined = function FileImageOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FileImageOutlinedSvg
    }));
  };
  var RefIcon$4K = /*#__PURE__*/React.forwardRef(FileImageOutlined);
  {
    RefIcon$4K.displayName = 'FileImageOutlined';
  }

  var FileImageTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FileImageTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M534 352V136H232v752h560V394H576a42 42 0 01-42-42zm-134 50c22.1 0 40 17.9 40 40s-17.9 40-40 40-40-17.9-40-40 17.9-40 40-40zm296 294H328.1c-6.7 0-10.4-7.7-6.3-12.9l99.8-127.2a8 8 0 0112.6 0l41.1 52.4 77.8-99.2a8.1 8.1 0 0112.7 0l136.5 174c4.1 5.2.4 12.9-6.3 12.9z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM602 137.8L790.2 326H602V137.8zM792 888H232V136h302v216a42 42 0 0042 42h216v494z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M553.1 509.1l-77.8 99.2-41.1-52.4a8 8 0 00-12.6 0l-99.8 127.2a7.98 7.98 0 006.3 12.9H696c6.7 0 10.4-7.7 6.3-12.9l-136.5-174a8.1 8.1 0 00-12.7 0zM360 442a40 40 0 1080 0 40 40 0 10-80 0z", "fill": primaryColor } }] }; }, "name": "file-image", "theme": "twotone" };
  exports.default = FileImageTwoTone;
  });

  var FileImageTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(FileImageTwoTone_1);

  var FileImageTwoTone = function FileImageTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FileImageTwoToneSvg
    }));
  };
  var RefIcon$4L = /*#__PURE__*/React.forwardRef(FileImageTwoTone);
  {
    RefIcon$4L.displayName = 'FileImageTwoTone';
  }

  var FileJpgOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FileJpgOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M874.6 301.8L596.8 21.3c-4.5-4.5-9.4-8.3-14.7-11.5-1.4-.8-2.8-1.6-4.3-2.3-.9-.5-1.9-.9-2.8-1.3-9-4-18.9-6.2-29-6.2H201c-39.8 0-73 32.2-73 72v880c0 39.8 33.2 72 73 72h623c39.8 0 71-32.2 71-72V352.5c0-19-7-37.2-20.4-50.7zM583 110.4L783.8 312H583V110.4zM823 952H200V72h311v240c0 39.8 33.2 72 73 72h239v568zM350 696.5c0 24.2-7.5 31.4-21.9 31.4-9 0-18.4-5.8-24.8-18.5L272.9 732c13.4 22.9 32.3 34.2 61.3 34.2 41.6 0 60.8-29.9 60.8-66.2V577h-45v119.5zM501.3 577H437v186h44v-62h21.6c39.1 0 73.1-19.6 73.1-63.6 0-45.8-33.5-60.4-74.4-60.4zm-.8 89H481v-53h18.2c21.5 0 33.4 6.2 33.4 24.9 0 18.1-10.5 28.1-32.1 28.1zm182.5-9v36h30v30.1c-4 2.9-11 4.7-17.7 4.7-34.3 0-50.7-21.4-50.7-58.2 0-36.1 19.7-57.4 47.1-57.4 15.3 0 25 6.2 34 14.4l23.7-28.3c-12.7-12.8-32.1-24.2-59.2-24.2-49.6 0-91.1 35.3-91.1 97 0 62.7 40 95.1 91.5 95.1 25.9 0 49.2-10.2 61.5-22.6V657H683z" } }] }, "name": "file-jpg", "theme": "outlined" };
  exports.default = FileJpgOutlined;
  });

  var FileJpgOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FileJpgOutlined_1);

  var FileJpgOutlined = function FileJpgOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FileJpgOutlinedSvg
    }));
  };
  var RefIcon$4M = /*#__PURE__*/React.forwardRef(FileJpgOutlined);
  {
    RefIcon$4M.displayName = 'FileJpgOutlined';
  }

  var FileMarkdownFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FileMarkdownFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.7c6 6 9.4 14.1 9.4 22.6V928c0 17.7-14.3 32-32 32H192c-17.7 0-32-14.3-32-32V96c0-17.7 14.3-32 32-32h424.7c8.5 0 16.7 3.4 22.7 9.4l215.2 215.3zM790.2 326L602 137.8V326h188.2zM426.13 600.93l59.11 132.97a16 16 0 0014.62 9.5h24.06a16 16 0 0014.63-9.51l59.1-133.35V758a16 16 0 0016.01 16H641a16 16 0 0016-16V486a16 16 0 00-16-16h-34.75a16 16 0 00-14.67 9.62L512.1 662.2l-79.48-182.59a16 16 0 00-14.67-9.61H383a16 16 0 00-16 16v272a16 16 0 0016 16h27.13a16 16 0 0016-16V600.93z" } }] }, "name": "file-markdown", "theme": "filled" };
  exports.default = FileMarkdownFilled;
  });

  var FileMarkdownFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(FileMarkdownFilled_1);

  var FileMarkdownFilled = function FileMarkdownFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FileMarkdownFilledSvg
    }));
  };
  var RefIcon$4N = /*#__PURE__*/React.forwardRef(FileMarkdownFilled);
  {
    RefIcon$4N.displayName = 'FileMarkdownFilled';
  }

  var FileMarkdownOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FileMarkdownOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM790.2 326H602V137.8L790.2 326zm1.8 562H232V136h302v216a42 42 0 0042 42h216v494zM429 481.2c-1.9-4.4-6.2-7.2-11-7.2h-35c-6.6 0-12 5.4-12 12v272c0 6.6 5.4 12 12 12h27.1c6.6 0 12-5.4 12-12V582.1l66.8 150.2a12 12 0 0011 7.1H524c4.7 0 9-2.8 11-7.1l66.8-150.6V758c0 6.6 5.4 12 12 12H641c6.6 0 12-5.4 12-12V486c0-6.6-5.4-12-12-12h-34.7c-4.8 0-9.1 2.8-11 7.2l-83.1 191-83.2-191z" } }] }, "name": "file-markdown", "theme": "outlined" };
  exports.default = FileMarkdownOutlined;
  });

  var FileMarkdownOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FileMarkdownOutlined_1);

  var FileMarkdownOutlined = function FileMarkdownOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FileMarkdownOutlinedSvg
    }));
  };
  var RefIcon$4O = /*#__PURE__*/React.forwardRef(FileMarkdownOutlined);
  {
    RefIcon$4O.displayName = 'FileMarkdownOutlined';
  }

  var FileMarkdownTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FileMarkdownTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M534 352V136H232v752h560V394H576a42 42 0 01-42-42zm72.3 122H641c6.6 0 12 5.4 12 12v272c0 6.6-5.4 12-12 12h-27.2c-6.6 0-12-5.4-12-12V581.7L535 732.3c-2 4.3-6.3 7.1-11 7.1h-24.1a12 12 0 01-11-7.1l-66.8-150.2V758c0 6.6-5.4 12-12 12H383c-6.6 0-12-5.4-12-12V486c0-6.6 5.4-12 12-12h35c4.8 0 9.1 2.8 11 7.2l83.2 191 83.1-191c1.9-4.4 6.2-7.2 11-7.2z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM602 137.8L790.2 326H602V137.8zM792 888H232V136h302v216a42 42 0 0042 42h216v494z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M429 481.2c-1.9-4.4-6.2-7.2-11-7.2h-35c-6.6 0-12 5.4-12 12v272c0 6.6 5.4 12 12 12h27.1c6.6 0 12-5.4 12-12V582.1l66.8 150.2a12 12 0 0011 7.1H524c4.7 0 9-2.8 11-7.1l66.8-150.6V758c0 6.6 5.4 12 12 12H641c6.6 0 12-5.4 12-12V486c0-6.6-5.4-12-12-12h-34.7c-4.8 0-9.1 2.8-11 7.2l-83.1 191-83.2-191z", "fill": primaryColor } }] }; }, "name": "file-markdown", "theme": "twotone" };
  exports.default = FileMarkdownTwoTone;
  });

  var FileMarkdownTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(FileMarkdownTwoTone_1);

  var FileMarkdownTwoTone = function FileMarkdownTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FileMarkdownTwoToneSvg
    }));
  };
  var RefIcon$4P = /*#__PURE__*/React.forwardRef(FileMarkdownTwoTone);
  {
    RefIcon$4P.displayName = 'FileMarkdownTwoTone';
  }

  var FileOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FileOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM790.2 326H602V137.8L790.2 326zm1.8 562H232V136h302v216a42 42 0 0042 42h216v494z" } }] }, "name": "file", "theme": "outlined" };
  exports.default = FileOutlined;
  });

  var FileOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FileOutlined_1);

  var FileOutlined = function FileOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FileOutlinedSvg
    }));
  };
  var RefIcon$4Q = /*#__PURE__*/React.forwardRef(FileOutlined);
  {
    RefIcon$4Q.displayName = 'FileOutlined';
  }

  var FilePdfFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FilePdfFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.7c6 6 9.4 14.1 9.4 22.6V928c0 17.7-14.3 32-32 32H192c-17.7 0-32-14.3-32-32V96c0-17.7 14.3-32 32-32h424.7c8.5 0 16.7 3.4 22.7 9.4l215.2 215.3zM790.2 326L602 137.8V326h188.2zM633.22 637.26c-15.18-.5-31.32.67-49.65 2.96-24.3-14.99-40.66-35.58-52.28-65.83l1.07-4.38 1.24-5.18c4.3-18.13 6.61-31.36 7.3-44.7.52-10.07-.04-19.36-1.83-27.97-3.3-18.59-16.45-29.46-33.02-30.13-15.45-.63-29.65 8-33.28 21.37-5.91 21.62-2.45 50.07 10.08 98.59-15.96 38.05-37.05 82.66-51.2 107.54-18.89 9.74-33.6 18.6-45.96 28.42-16.3 12.97-26.48 26.3-29.28 40.3-1.36 6.49.69 14.97 5.36 21.92 5.3 7.88 13.28 13 22.85 13.74 24.15 1.87 53.83-23.03 86.6-79.26 3.29-1.1 6.77-2.26 11.02-3.7l11.9-4.02c7.53-2.54 12.99-4.36 18.39-6.11 23.4-7.62 41.1-12.43 57.2-15.17 27.98 14.98 60.32 24.8 82.1 24.8 17.98 0 30.13-9.32 34.52-23.99 3.85-12.88.8-27.82-7.48-36.08-8.56-8.41-24.3-12.43-45.65-13.12zM385.23 765.68v-.36l.13-.34a54.86 54.86 0 015.6-10.76c4.28-6.58 10.17-13.5 17.47-20.87 3.92-3.95 8-7.8 12.79-12.12 1.07-.96 7.91-7.05 9.19-8.25l11.17-10.4-8.12 12.93c-12.32 19.64-23.46 33.78-33 43-3.51 3.4-6.6 5.9-9.1 7.51a16.43 16.43 0 01-2.61 1.42c-.41.17-.77.27-1.13.3a2.2 2.2 0 01-1.12-.15 2.07 2.07 0 01-1.27-1.91zM511.17 547.4l-2.26 4-1.4-4.38c-3.1-9.83-5.38-24.64-6.01-38-.72-15.2.49-24.32 5.29-24.32 6.74 0 9.83 10.8 10.07 27.05.22 14.28-2.03 29.14-5.7 35.65zm-5.81 58.46l1.53-4.05 2.09 3.8c11.69 21.24 26.86 38.96 43.54 51.31l3.6 2.66-4.39.9c-16.33 3.38-31.54 8.46-52.34 16.85 2.17-.88-21.62 8.86-27.64 11.17l-5.25 2.01 2.8-4.88c12.35-21.5 23.76-47.32 36.05-79.77zm157.62 76.26c-7.86 3.1-24.78.33-54.57-12.39l-7.56-3.22 8.2-.6c23.3-1.73 39.8-.45 49.42 3.07 4.1 1.5 6.83 3.39 8.04 5.55a4.64 4.64 0 01-1.36 6.31 6.7 6.7 0 01-2.17 1.28z" } }] }, "name": "file-pdf", "theme": "filled" };
  exports.default = FilePdfFilled;
  });

  var FilePdfFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(FilePdfFilled_1);

  var FilePdfFilled = function FilePdfFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FilePdfFilledSvg
    }));
  };
  var RefIcon$4R = /*#__PURE__*/React.forwardRef(FilePdfFilled);
  {
    RefIcon$4R.displayName = 'FilePdfFilled';
  }

  var FilePdfOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FilePdfOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M531.3 574.4l.3-1.4c5.8-23.9 13.1-53.7 7.4-80.7-3.8-21.3-19.5-29.6-32.9-30.2-15.8-.7-29.9 8.3-33.4 21.4-6.6 24-.7 56.8 10.1 98.6-13.6 32.4-35.3 79.5-51.2 107.5-29.6 15.3-69.3 38.9-75.2 68.7-1.2 5.5.2 12.5 3.5 18.8 3.7 7 9.6 12.4 16.5 15 3 1.1 6.6 2 10.8 2 17.6 0 46.1-14.2 84.1-79.4 5.8-1.9 11.8-3.9 17.6-5.9 27.2-9.2 55.4-18.8 80.9-23.1 28.2 15.1 60.3 24.8 82.1 24.8 21.6 0 30.1-12.8 33.3-20.5 5.6-13.5 2.9-30.5-6.2-39.6-13.2-13-45.3-16.4-95.3-10.2-24.6-15-40.7-35.4-52.4-65.8zM421.6 726.3c-13.9 20.2-24.4 30.3-30.1 34.7 6.7-12.3 19.8-25.3 30.1-34.7zm87.6-235.5c5.2 8.9 4.5 35.8.5 49.4-4.9-19.9-5.6-48.1-2.7-51.4.8.1 1.5.7 2.2 2zm-1.6 120.5c10.7 18.5 24.2 34.4 39.1 46.2-21.6 4.9-41.3 13-58.9 20.2-4.2 1.7-8.3 3.4-12.3 5 13.3-24.1 24.4-51.4 32.1-71.4zm155.6 65.5c.1.2.2.5-.4.9h-.2l-.2.3c-.8.5-9 5.3-44.3-8.6 40.6-1.9 45 7.3 45.1 7.4zm191.4-388.2L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM790.2 326H602V137.8L790.2 326zm1.8 562H232V136h302v216a42 42 0 0042 42h216v494z" } }] }, "name": "file-pdf", "theme": "outlined" };
  exports.default = FilePdfOutlined;
  });

  var FilePdfOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FilePdfOutlined_1);

  var FilePdfOutlined = function FilePdfOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FilePdfOutlinedSvg
    }));
  };
  var RefIcon$4S = /*#__PURE__*/React.forwardRef(FilePdfOutlined);
  {
    RefIcon$4S.displayName = 'FilePdfOutlined';
  }

  var FilePdfTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FilePdfTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M509.2 490.8c-.7-1.3-1.4-1.9-2.2-2-2.9 3.3-2.2 31.5 2.7 51.4 4-13.6 4.7-40.5-.5-49.4zm-1.6 120.5c-7.7 20-18.8 47.3-32.1 71.4 4-1.6 8.1-3.3 12.3-5 17.6-7.2 37.3-15.3 58.9-20.2-14.9-11.8-28.4-27.7-39.1-46.2z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M534 352V136H232v752h560V394H576a42 42 0 01-42-42zm55 287.6c16.1-1.9 30.6-2.8 44.3-2.3 12.8.4 23.6 2 32 5.1.2.1.3.1.5.2.4.2.8.3 1.2.5.5.2 1.1.4 1.6.7.1.1.3.1.4.2 4.1 1.8 7.5 4 10.1 6.6 9.1 9.1 11.8 26.1 6.2 39.6-3.2 7.7-11.7 20.5-33.3 20.5-21.8 0-53.9-9.7-82.1-24.8-25.5 4.3-53.7 13.9-80.9 23.1-5.8 2-11.8 4-17.6 5.9-38 65.2-66.5 79.4-84.1 79.4-4.2 0-7.8-.9-10.8-2-6.9-2.6-12.8-8-16.5-15-.9-1.7-1.6-3.4-2.2-5.2-1.6-4.8-2.1-9.6-1.3-13.6l.6-2.7c.1-.2.1-.4.2-.6.2-.7.4-1.4.7-2.1 0-.1.1-.2.1-.3 4.1-11.9 13.6-23.4 27.7-34.6 12.3-9.8 27.1-18.7 45.9-28.4 15.9-28 37.6-75.1 51.2-107.4-10.8-41.8-16.7-74.6-10.1-98.6.9-3.3 2.5-6.4 4.6-9.1.2-.2.3-.4.5-.6.1-.1.1-.2.2-.2 6.3-7.5 16.9-11.9 28.1-11.5 16.6.7 29.7 11.5 33 30.1 1.7 8 2.2 16.5 1.9 25.7v.7c0 .5 0 1-.1 1.5-.7 13.3-3 26.6-7.3 44.7-.4 1.6-.8 3.2-1.2 5.2l-1 4.1-.1.3c.1.2.1.3.2.5l1.8 4.5c.1.3.3.7.4 1 .7 1.6 1.4 3.3 2.1 4.8v.1c8.7 18.8 19.7 33.4 33.9 45.1 4.3 3.5 8.9 6.7 13.9 9.8 1.8-.5 3.5-.7 5.3-.9z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M391.5 761c5.7-4.4 16.2-14.5 30.1-34.7-10.3 9.4-23.4 22.4-30.1 34.7zm270.9-83l.2-.3h.2c.6-.4.5-.7.4-.9-.1-.1-4.5-9.3-45.1-7.4 35.3 13.9 43.5 9.1 44.3 8.6z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM602 137.8L790.2 326H602V137.8zM792 888H232V136h302v216a42 42 0 0042 42h216v494z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M535.9 585.3c-.8-1.7-1.5-3.3-2.2-4.9-.1-.3-.3-.7-.4-1l-1.8-4.5c-.1-.2-.1-.3-.2-.5l.1-.3.2-1.1c4-16.3 8.6-35.3 9.4-54.4v-.7c.3-8.6-.2-17.2-2-25.6-3.8-21.3-19.5-29.6-32.9-30.2-11.3-.5-21.8 4-28.1 11.4-.1.1-.1.2-.2.2-.2.2-.4.4-.5.6-2.1 2.7-3.7 5.8-4.6 9.1-6.6 24-.7 56.8 10.1 98.6-13.6 32.4-35.3 79.4-51.2 107.4v.1c-27.7 14.3-64.1 35.8-73.6 62.9 0 .1-.1.2-.1.3-.2.7-.5 1.4-.7 2.1-.1.2-.1.4-.2.6-.2.9-.5 1.8-.6 2.7-.9 4-.4 8.8 1.3 13.6.6 1.8 1.3 3.5 2.2 5.2 3.7 7 9.6 12.4 16.5 15 3 1.1 6.6 2 10.8 2 17.6 0 46.1-14.2 84.1-79.4 5.8-1.9 11.8-3.9 17.6-5.9 27.2-9.2 55.4-18.8 80.9-23.1 28.2 15.1 60.3 24.8 82.1 24.8 21.6 0 30.1-12.8 33.3-20.5 5.6-13.5 2.9-30.5-6.2-39.6-2.6-2.6-6-4.8-10.1-6.6-.1-.1-.3-.1-.4-.2-.5-.2-1.1-.4-1.6-.7-.4-.2-.8-.3-1.2-.5-.2-.1-.3-.1-.5-.2-16.2-5.8-41.7-6.7-76.3-2.8l-5.3.6c-5-3-9.6-6.3-13.9-9.8-14.2-11.3-25.1-25.8-33.8-44.7zM391.5 761c6.7-12.3 19.8-25.3 30.1-34.7-13.9 20.2-24.4 30.3-30.1 34.7zM507 488.8c.8.1 1.5.7 2.2 2 5.2 8.9 4.5 35.8.5 49.4-4.9-19.9-5.6-48.1-2.7-51.4zm-19.2 188.9c-4.2 1.7-8.3 3.4-12.3 5 13.3-24.1 24.4-51.4 32.1-71.4 10.7 18.5 24.2 34.4 39.1 46.2-21.6 4.9-41.3 13-58.9 20.2zm175.4-.9c.1.2.2.5-.4.9h-.2l-.2.3c-.8.5-9 5.3-44.3-8.6 40.6-1.9 45 7.3 45.1 7.4z", "fill": primaryColor } }] }; }, "name": "file-pdf", "theme": "twotone" };
  exports.default = FilePdfTwoTone;
  });

  var FilePdfTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(FilePdfTwoTone_1);

  var FilePdfTwoTone = function FilePdfTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FilePdfTwoToneSvg
    }));
  };
  var RefIcon$4T = /*#__PURE__*/React.forwardRef(FilePdfTwoTone);
  {
    RefIcon$4T.displayName = 'FilePdfTwoTone';
  }

  var FilePptFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FilePptFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.7c6 6 9.4 14.1 9.4 22.6V928c0 17.7-14.3 32-32 32H192c-17.7 0-32-14.3-32-32V96c0-17.7 14.3-32 32-32h424.7c8.5 0 16.7 3.4 22.7 9.4l215.2 215.3zM790.2 326L602 137.8V326h188.2zM468.53 760v-91.54h59.27c60.57 0 100.2-39.65 100.2-98.12 0-58.22-39.58-98.34-99.98-98.34H424a12 12 0 00-12 12v276a12 12 0 0012 12h32.53a12 12 0 0012-12zm0-139.33h34.9c47.82 0 67.19-12.93 67.19-50.33 0-32.05-18.12-50.12-49.87-50.12h-52.22v100.45z" } }] }, "name": "file-ppt", "theme": "filled" };
  exports.default = FilePptFilled;
  });

  var FilePptFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(FilePptFilled_1);

  var FilePptFilled = function FilePptFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FilePptFilledSvg
    }));
  };
  var RefIcon$4U = /*#__PURE__*/React.forwardRef(FilePptFilled);
  {
    RefIcon$4U.displayName = 'FilePptFilled';
  }

  var FilePptOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FilePptOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M424 476c-4.4 0-8 3.6-8 8v276c0 4.4 3.6 8 8 8h32.5c4.4 0 8-3.6 8-8v-95.5h63.3c59.4 0 96.2-38.9 96.2-94.1 0-54.5-36.3-94.3-96-94.3H424zm150.6 94.3c0 43.4-26.5 54.3-71.2 54.3h-38.9V516.2h56.2c33.8 0 53.9 19.7 53.9 54.1zm280-281.7L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM790.2 326H602V137.8L790.2 326zm1.8 562H232V136h302v216a42 42 0 0042 42h216v494z" } }] }, "name": "file-ppt", "theme": "outlined" };
  exports.default = FilePptOutlined;
  });

  var FilePptOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FilePptOutlined_1);

  var FilePptOutlined = function FilePptOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FilePptOutlinedSvg
    }));
  };
  var RefIcon$4V = /*#__PURE__*/React.forwardRef(FilePptOutlined);
  {
    RefIcon$4V.displayName = 'FilePptOutlined';
  }

  var FilePptTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FilePptTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M464.5 516.2v108.4h38.9c44.7 0 71.2-10.9 71.2-54.3 0-34.4-20.1-54.1-53.9-54.1h-56.2z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M534 352V136H232v752h560V394H576a42 42 0 01-42-42zm90 218.4c0 55.2-36.8 94.1-96.2 94.1h-63.3V760c0 4.4-3.6 8-8 8H424c-4.4 0-8-3.6-8-8V484c0-4.4 3.6-8 8-8v.1h104c59.7 0 96 39.8 96 94.3z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM602 137.8L790.2 326H602V137.8zM792 888H232V136h302v216a42 42 0 0042 42h216v494z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M424 476.1c-4.4-.1-8 3.5-8 7.9v276c0 4.4 3.6 8 8 8h32.5c4.4 0 8-3.6 8-8v-95.5h63.3c59.4 0 96.2-38.9 96.2-94.1 0-54.5-36.3-94.3-96-94.3H424zm150.6 94.2c0 43.4-26.5 54.3-71.2 54.3h-38.9V516.2h56.2c33.8 0 53.9 19.7 53.9 54.1z", "fill": primaryColor } }] }; }, "name": "file-ppt", "theme": "twotone" };
  exports.default = FilePptTwoTone;
  });

  var FilePptTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(FilePptTwoTone_1);

  var FilePptTwoTone = function FilePptTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FilePptTwoToneSvg
    }));
  };
  var RefIcon$4W = /*#__PURE__*/React.forwardRef(FilePptTwoTone);
  {
    RefIcon$4W.displayName = 'FilePptTwoTone';
  }

  var FileProtectOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FileProtectOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M644.7 669.2a7.92 7.92 0 00-6.5-3.3H594c-6.5 0-10.3 7.4-6.5 12.7l73.8 102.1c3.2 4.4 9.7 4.4 12.9 0l114.2-158c3.8-5.3 0-12.7-6.5-12.7h-44.3c-2.6 0-5 1.2-6.5 3.3l-63.5 87.8-22.9-31.9zM688 306v-48c0-4.4-3.6-8-8-8H296c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h384c4.4 0 8-3.6 8-8zm-392 88c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h184c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H296zm184 458H208V148h560v296c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V108c0-17.7-14.3-32-32-32H168c-17.7 0-32 14.3-32 32v784c0 17.7 14.3 32 32 32h312c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm402.6-320.8l-192-66.7c-.9-.3-1.7-.4-2.6-.4s-1.8.1-2.6.4l-192 66.7a7.96 7.96 0 00-5.4 7.5v251.1c0 2.5 1.1 4.8 3.1 6.3l192 150.2c1.4 1.1 3.2 1.7 4.9 1.7s3.5-.6 4.9-1.7l192-150.2c1.9-1.5 3.1-3.8 3.1-6.3V538.7c0-3.4-2.2-6.4-5.4-7.5zM826 763.7L688 871.6 550 763.7V577l138-48 138 48v186.7z" } }] }, "name": "file-protect", "theme": "outlined" };
  exports.default = FileProtectOutlined;
  });

  var FileProtectOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FileProtectOutlined_1);

  var FileProtectOutlined = function FileProtectOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FileProtectOutlinedSvg
    }));
  };
  var RefIcon$4X = /*#__PURE__*/React.forwardRef(FileProtectOutlined);
  {
    RefIcon$4X.displayName = 'FileProtectOutlined';
  }

  var FileSearchOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FileSearchOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M688 312v-48c0-4.4-3.6-8-8-8H296c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h384c4.4 0 8-3.6 8-8zm-392 88c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h184c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H296zm144 452H208V148h560v344c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V108c0-17.7-14.3-32-32-32H168c-17.7 0-32 14.3-32 32v784c0 17.7 14.3 32 32 32h272c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm445.7 51.5l-93.3-93.3C814.7 780.7 828 743.9 828 704c0-97.2-78.8-176-176-176s-176 78.8-176 176 78.8 176 176 176c35.8 0 69-10.7 96.8-29l94.7 94.7c1.6 1.6 3.6 2.3 5.6 2.3s4.1-.8 5.6-2.3l31-31a7.9 7.9 0 000-11.2zM652 816c-61.9 0-112-50.1-112-112s50.1-112 112-112 112 50.1 112 112-50.1 112-112 112z" } }] }, "name": "file-search", "theme": "outlined" };
  exports.default = FileSearchOutlined;
  });

  var FileSearchOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FileSearchOutlined_1);

  var FileSearchOutlined = function FileSearchOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FileSearchOutlinedSvg
    }));
  };
  var RefIcon$4Y = /*#__PURE__*/React.forwardRef(FileSearchOutlined);
  {
    RefIcon$4Y.displayName = 'FileSearchOutlined';
  }

  var FileSyncOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FileSyncOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M296 256c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h384c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H296zm192 200v-48c0-4.4-3.6-8-8-8H296c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h184c4.4 0 8-3.6 8-8zm-48 396H208V148h560v344c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V108c0-17.7-14.3-32-32-32H168c-17.7 0-32 14.3-32 32v784c0 17.7 14.3 32 32 32h272c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm104.1-115.6c1.8-34.5 16.2-66.8 40.8-91.4 26.2-26.2 62-41 99.1-41 37.4 0 72.6 14.6 99.1 41 3.2 3.2 6.3 6.6 9.2 10.1L769.2 673a8 8 0 003 14.1l93.3 22.5c5 1.2 9.8-2.6 9.9-7.7l.6-95.4a8 8 0 00-12.9-6.4l-20.3 15.8C805.4 569.6 748.1 540 684 540c-109.9 0-199.6 86.9-204 195.7-.2 4.5 3.5 8.3 8 8.3h48.1c4.3 0 7.8-3.3 8-7.6zM880 744h-48.1c-4.3 0-7.8 3.3-8 7.6-1.8 34.5-16.2 66.8-40.8 91.4-26.2 26.2-62 41-99.1 41-37.4 0-72.6-14.6-99.1-41-3.2-3.2-6.3-6.6-9.2-10.1l23.1-17.9a8 8 0 00-3-14.1l-93.3-22.5c-5-1.2-9.8 2.6-9.9 7.7l-.6 95.4a8 8 0 0012.9 6.4l20.3-15.8C562.6 918.4 619.9 948 684 948c109.9 0 199.6-86.9 204-195.7.2-4.5-3.5-8.3-8-8.3z" } }] }, "name": "file-sync", "theme": "outlined" };
  exports.default = FileSyncOutlined;
  });

  var FileSyncOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FileSyncOutlined_1);

  var FileSyncOutlined = function FileSyncOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FileSyncOutlinedSvg
    }));
  };
  var RefIcon$4Z = /*#__PURE__*/React.forwardRef(FileSyncOutlined);
  {
    RefIcon$4Z.displayName = 'FileSyncOutlined';
  }

  var FileTextFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FileTextFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.7c6 6 9.4 14.1 9.4 22.6V928c0 17.7-14.3 32-32 32H192c-17.7 0-32-14.3-32-32V96c0-17.7 14.3-32 32-32h424.7c8.5 0 16.7 3.4 22.7 9.4l215.2 215.3zM790.2 326L602 137.8V326h188.2zM320 482a8 8 0 00-8 8v48a8 8 0 008 8h384a8 8 0 008-8v-48a8 8 0 00-8-8H320zm0 136a8 8 0 00-8 8v48a8 8 0 008 8h184a8 8 0 008-8v-48a8 8 0 00-8-8H320z" } }] }, "name": "file-text", "theme": "filled" };
  exports.default = FileTextFilled;
  });

  var FileTextFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(FileTextFilled_1);

  var FileTextFilled = function FileTextFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FileTextFilledSvg
    }));
  };
  var RefIcon$4_ = /*#__PURE__*/React.forwardRef(FileTextFilled);
  {
    RefIcon$4_.displayName = 'FileTextFilled';
  }

  var FileTextOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FileTextOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM790.2 326H602V137.8L790.2 326zm1.8 562H232V136h302v216a42 42 0 0042 42h216v494zM504 618H320c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h184c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8zM312 490v48c0 4.4 3.6 8 8 8h384c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H320c-4.4 0-8 3.6-8 8z" } }] }, "name": "file-text", "theme": "outlined" };
  exports.default = FileTextOutlined;
  });

  var FileTextOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FileTextOutlined_1);

  var FileTextOutlined = function FileTextOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FileTextOutlinedSvg
    }));
  };
  var RefIcon$4$ = /*#__PURE__*/React.forwardRef(FileTextOutlined);
  {
    RefIcon$4$.displayName = 'FileTextOutlined';
  }

  var FileTextTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FileTextTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M534 352V136H232v752h560V394H576a42 42 0 01-42-42zm-22 322c0 4.4-3.6 8-8 8H320c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h184c4.4 0 8 3.6 8 8v48zm200-184v48c0 4.4-3.6 8-8 8H320c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h384c4.4 0 8 3.6 8 8z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM602 137.8L790.2 326H602V137.8zM792 888H232V136h302v216a42 42 0 0042 42h216v494z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M312 490v48c0 4.4 3.6 8 8 8h384c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H320c-4.4 0-8 3.6-8 8zm192 128H320c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h184c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8z", "fill": primaryColor } }] }; }, "name": "file-text", "theme": "twotone" };
  exports.default = FileTextTwoTone;
  });

  var FileTextTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(FileTextTwoTone_1);

  var FileTextTwoTone = function FileTextTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FileTextTwoToneSvg
    }));
  };
  var RefIcon$50 = /*#__PURE__*/React.forwardRef(FileTextTwoTone);
  {
    RefIcon$50.displayName = 'FileTextTwoTone';
  }

  var FileTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FileTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M534 352V136H232v752h560V394H576a42 42 0 01-42-42z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM602 137.8L790.2 326H602V137.8zM792 888H232V136h302v216a42 42 0 0042 42h216v494z", "fill": primaryColor } }] }; }, "name": "file", "theme": "twotone" };
  exports.default = FileTwoTone;
  });

  var FileTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(FileTwoTone_1);

  var FileTwoTone = function FileTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FileTwoToneSvg
    }));
  };
  var RefIcon$51 = /*#__PURE__*/React.forwardRef(FileTwoTone);
  {
    RefIcon$51.displayName = 'FileTwoTone';
  }

  var FileUnknownFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FileUnknownFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.7c6 6 9.4 14.1 9.4 22.6V928c0 17.7-14.3 32-32 32H192c-17.7 0-32-14.3-32-32V96c0-17.7 14.3-32 32-32h424.7c8.5 0 16.7 3.4 22.7 9.4l215.2 215.3zM790.2 326L602 137.8V326h188.2zM402 549c0 5.4 4.4 9.5 9.8 9.5h32.4c5.4 0 9.8-4.2 9.8-9.4 0-28.2 25.8-51.6 58-51.6s58 23.4 58 51.5c0 25.3-21 47.2-49.3 50.9-19.3 2.8-34.5 20.3-34.7 40.1v32c0 5.5 4.5 10 10 10h32c5.5 0 10-4.5 10-10v-12.2c0-6 4-11.5 9.7-13.3 44.6-14.4 75-54 74.3-98.9-.8-55.5-49.2-100.8-108.5-101.6-61.4-.7-111.5 45.6-111.5 103zm110 227a32 32 0 100-64 32 32 0 000 64z" } }] }, "name": "file-unknown", "theme": "filled" };
  exports.default = FileUnknownFilled;
  });

  var FileUnknownFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(FileUnknownFilled_1);

  var FileUnknownFilled = function FileUnknownFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FileUnknownFilledSvg
    }));
  };
  var RefIcon$52 = /*#__PURE__*/React.forwardRef(FileUnknownFilled);
  {
    RefIcon$52.displayName = 'FileUnknownFilled';
  }

  var FileUnknownOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FileUnknownOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.7L639.4 73.4c-6-6-14.2-9.4-22.7-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.6-9.4-22.6zM790.2 326H602V137.8L790.2 326zm1.8 562H232V136h302v216a42 42 0 0042 42h216v494zM402 549c0 5.4 4.4 9.5 9.8 9.5h32.4c5.4 0 9.8-4.2 9.8-9.4 0-28.2 25.8-51.6 58-51.6s58 23.4 58 51.5c0 25.3-21 47.2-49.3 50.9-19.3 2.8-34.5 20.3-34.7 40.1v32c0 5.5 4.5 10 10 10h32c5.5 0 10-4.5 10-10v-12.2c0-6 4-11.5 9.7-13.3 44.6-14.4 75-54 74.3-98.9-.8-55.5-49.2-100.8-108.5-101.6-61.4-.7-111.5 45.6-111.5 103zm78 195a32 32 0 1064 0 32 32 0 10-64 0z" } }] }, "name": "file-unknown", "theme": "outlined" };
  exports.default = FileUnknownOutlined;
  });

  var FileUnknownOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FileUnknownOutlined_1);

  var FileUnknownOutlined = function FileUnknownOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FileUnknownOutlinedSvg
    }));
  };
  var RefIcon$53 = /*#__PURE__*/React.forwardRef(FileUnknownOutlined);
  {
    RefIcon$53.displayName = 'FileUnknownOutlined';
  }

  var FileUnknownTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FileUnknownTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M534 352V136H232v752h560V394H576a42 42 0 01-42-42zm-22 424c-17.7 0-32-14.3-32-32s14.3-32 32-32 32 14.3 32 32-14.3 32-32 32zm110-228.4c.7 44.9-29.7 84.5-74.3 98.9-5.7 1.8-9.7 7.3-9.7 13.3V672c0 5.5-4.5 10-10 10h-32c-5.5 0-10-4.5-10-10v-32c.2-19.8 15.4-37.3 34.7-40.1C549 596.2 570 574.3 570 549c0-28.1-25.8-51.5-58-51.5s-58 23.4-58 51.6c0 5.2-4.4 9.4-9.8 9.4h-32.4c-5.4 0-9.8-4.1-9.8-9.5 0-57.4 50.1-103.7 111.5-103 59.3.8 107.7 46.1 108.5 101.6z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M854.6 288.7L639.4 73.4c-6-6-14.2-9.4-22.7-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.6-9.4-22.6zM602 137.8L790.2 326H602V137.8zM792 888H232V136h302v216a42 42 0 0042 42h216v494z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M480 744a32 32 0 1064 0 32 32 0 10-64 0zm-78-195c0 5.4 4.4 9.5 9.8 9.5h32.4c5.4 0 9.8-4.2 9.8-9.4 0-28.2 25.8-51.6 58-51.6s58 23.4 58 51.5c0 25.3-21 47.2-49.3 50.9-19.3 2.8-34.5 20.3-34.7 40.1v32c0 5.5 4.5 10 10 10h32c5.5 0 10-4.5 10-10v-12.2c0-6 4-11.5 9.7-13.3 44.6-14.4 75-54 74.3-98.9-.8-55.5-49.2-100.8-108.5-101.6-61.4-.7-111.5 45.6-111.5 103z", "fill": primaryColor } }] }; }, "name": "file-unknown", "theme": "twotone" };
  exports.default = FileUnknownTwoTone;
  });

  var FileUnknownTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(FileUnknownTwoTone_1);

  var FileUnknownTwoTone = function FileUnknownTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FileUnknownTwoToneSvg
    }));
  };
  var RefIcon$54 = /*#__PURE__*/React.forwardRef(FileUnknownTwoTone);
  {
    RefIcon$54.displayName = 'FileUnknownTwoTone';
  }

  var FileWordFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FileWordFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.7c6 6 9.4 14.1 9.4 22.6V928c0 17.7-14.3 32-32 32H192c-17.7 0-32-14.3-32-32V96c0-17.7 14.3-32 32-32h424.7c8.5 0 16.7 3.4 22.7 9.4l215.2 215.3zM790.2 326L602 137.8V326h188.2zM512 566.1l52.81 197a12 12 0 0011.6 8.9h31.77a12 12 0 0011.6-8.88l74.37-276a12 12 0 00.4-3.12 12 12 0 00-12-12h-35.57a12 12 0 00-11.7 9.31l-45.78 199.1-49.76-199.32A12 12 0 00528.1 472h-32.2a12 12 0 00-11.64 9.1L434.6 680.01 388.5 481.3a12 12 0 00-11.68-9.29h-35.39a12 12 0 00-3.11.41 12 12 0 00-8.47 14.7l74.17 276A12 12 0 00415.6 772h31.99a12 12 0 0011.59-8.9l52.81-197z" } }] }, "name": "file-word", "theme": "filled" };
  exports.default = FileWordFilled;
  });

  var FileWordFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(FileWordFilled_1);

  var FileWordFilled = function FileWordFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FileWordFilledSvg
    }));
  };
  var RefIcon$55 = /*#__PURE__*/React.forwardRef(FileWordFilled);
  {
    RefIcon$55.displayName = 'FileWordFilled';
  }

  var FileWordOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FileWordOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM790.2 326H602V137.8L790.2 326zm1.8 562H232V136h302v216a42 42 0 0042 42h216v494zM528.1 472h-32.2c-5.5 0-10.3 3.7-11.6 9.1L434.6 680l-46.1-198.7c-1.3-5.4-6.1-9.3-11.7-9.3h-35.4a12.02 12.02 0 00-11.6 15.1l74.2 276c1.4 5.2 6.2 8.9 11.6 8.9h32c5.4 0 10.2-3.6 11.6-8.9l52.8-197 52.8 197c1.4 5.2 6.2 8.9 11.6 8.9h31.8c5.4 0 10.2-3.6 11.6-8.9l74.4-276a12.04 12.04 0 00-11.6-15.1H647c-5.6 0-10.4 3.9-11.7 9.3l-45.8 199.1-49.8-199.3c-1.3-5.4-6.1-9.1-11.6-9.1z" } }] }, "name": "file-word", "theme": "outlined" };
  exports.default = FileWordOutlined;
  });

  var FileWordOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FileWordOutlined_1);

  var FileWordOutlined = function FileWordOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FileWordOutlinedSvg
    }));
  };
  var RefIcon$56 = /*#__PURE__*/React.forwardRef(FileWordOutlined);
  {
    RefIcon$56.displayName = 'FileWordOutlined';
  }

  var FileWordTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FileWordTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M534 352V136H232v752h560V394H576a42 42 0 01-42-42zm101.3 129.3c1.3-5.4 6.1-9.3 11.7-9.3h35.6a12.04 12.04 0 0111.6 15.1l-74.4 276c-1.4 5.3-6.2 8.9-11.6 8.9h-31.8c-5.4 0-10.2-3.7-11.6-8.9l-52.8-197-52.8 197c-1.4 5.3-6.2 8.9-11.6 8.9h-32c-5.4 0-10.2-3.7-11.6-8.9l-74.2-276a12.02 12.02 0 0111.6-15.1h35.4c5.6 0 10.4 3.9 11.7 9.3L434.6 680l49.7-198.9c1.3-5.4 6.1-9.1 11.6-9.1h32.2c5.5 0 10.3 3.7 11.6 9.1l49.8 199.3 45.8-199.1z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM602 137.8L790.2 326H602V137.8zM792 888H232V136h302v216a42 42 0 0042 42h216v494z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M528.1 472h-32.2c-5.5 0-10.3 3.7-11.6 9.1L434.6 680l-46.1-198.7c-1.3-5.4-6.1-9.3-11.7-9.3h-35.4a12.02 12.02 0 00-11.6 15.1l74.2 276c1.4 5.2 6.2 8.9 11.6 8.9h32c5.4 0 10.2-3.6 11.6-8.9l52.8-197 52.8 197c1.4 5.2 6.2 8.9 11.6 8.9h31.8c5.4 0 10.2-3.6 11.6-8.9l74.4-276a12.04 12.04 0 00-11.6-15.1H647c-5.6 0-10.4 3.9-11.7 9.3l-45.8 199.1-49.8-199.3c-1.3-5.4-6.1-9.1-11.6-9.1z", "fill": primaryColor } }] }; }, "name": "file-word", "theme": "twotone" };
  exports.default = FileWordTwoTone;
  });

  var FileWordTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(FileWordTwoTone_1);

  var FileWordTwoTone = function FileWordTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FileWordTwoToneSvg
    }));
  };
  var RefIcon$57 = /*#__PURE__*/React.forwardRef(FileWordTwoTone);
  {
    RefIcon$57.displayName = 'FileWordTwoTone';
  }

  var FileZipFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FileZipFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.7c6 6 9.4 14.1 9.4 22.6V928c0 17.7-14.3 32-32 32H192c-17.7 0-32-14.3-32-32V96c0-17.7 14.3-32 32-32h424.7c8.5 0 16.7 3.4 22.7 9.4l215.2 215.3zM790.2 326L602 137.8V326h188.2zM296 136v64h64v-64h-64zm64 64v64h64v-64h-64zm-64 64v64h64v-64h-64zm64 64v64h64v-64h-64zm-64 64v64h64v-64h-64zm64 64v64h64v-64h-64zm-64 64v64h64v-64h-64zm0 64v160h128V584H296zm48 48h32v64h-32v-64z" } }] }, "name": "file-zip", "theme": "filled" };
  exports.default = FileZipFilled;
  });

  var FileZipFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(FileZipFilled_1);

  var FileZipFilled = function FileZipFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FileZipFilledSvg
    }));
  };
  var RefIcon$58 = /*#__PURE__*/React.forwardRef(FileZipFilled);
  {
    RefIcon$58.displayName = 'FileZipFilled';
  }

  var FileZipOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FileZipOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M296 392h64v64h-64zm0 190v160h128V582h-64v-62h-64v62zm80 48v64h-32v-64h32zm-16-302h64v64h-64zm-64-64h64v64h-64zm64 192h64v64h-64zm0-256h64v64h-64zm494.6 88.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM790.2 326H602V137.8L790.2 326zm1.8 562H232V136h64v64h64v-64h174v216a42 42 0 0042 42h216v494z" } }] }, "name": "file-zip", "theme": "outlined" };
  exports.default = FileZipOutlined;
  });

  var FileZipOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FileZipOutlined_1);

  var FileZipOutlined = function FileZipOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FileZipOutlinedSvg
    }));
  };
  var RefIcon$59 = /*#__PURE__*/React.forwardRef(FileZipOutlined);
  {
    RefIcon$59.displayName = 'FileZipOutlined';
  }

  var FileZipTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FileZipTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M344 630h32v2h-32z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M534 352V136H360v64h64v64h-64v64h64v64h-64v64h64v64h-64v62h64v160H296V520h64v-64h-64v-64h64v-64h-64v-64h64v-64h-64v-64h-64v752h560V394H576a42 42 0 01-42-42z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM602 137.8L790.2 326H602V137.8zM792 888H232V136h64v64h64v-64h174v216a42 42 0 0042 42h216v494z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M296 392h64v64h-64zm0-128h64v64h-64zm0 318v160h128V582h-64v-62h-64v62zm48 50v-2h32v64h-32v-62zm16-432h64v64h-64zm0 256h64v64h-64zm0-128h64v64h-64z", "fill": primaryColor } }] }; }, "name": "file-zip", "theme": "twotone" };
  exports.default = FileZipTwoTone;
  });

  var FileZipTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(FileZipTwoTone_1);

  var FileZipTwoTone = function FileZipTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FileZipTwoToneSvg
    }));
  };
  var RefIcon$5a = /*#__PURE__*/React.forwardRef(FileZipTwoTone);
  {
    RefIcon$5a.displayName = 'FileZipTwoTone';
  }

  var FilterFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FilterFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M349 838c0 17.7 14.2 32 31.8 32h262.4c17.6 0 31.8-14.3 31.8-32V642H349v196zm531.1-684H143.9c-24.5 0-39.8 26.7-27.5 48l221.3 376h348.8l221.3-376c12.1-21.3-3.2-48-27.7-48z" } }] }, "name": "filter", "theme": "filled" };
  exports.default = FilterFilled;
  });

  var FilterFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(FilterFilled_1);

  var FilterFilled = function FilterFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FilterFilledSvg
    }));
  };
  var RefIcon$5b = /*#__PURE__*/React.forwardRef(FilterFilled);
  {
    RefIcon$5b.displayName = 'FilterFilled';
  }

  var FilterOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FilterOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880.1 154H143.9c-24.5 0-39.8 26.7-27.5 48L349 597.4V838c0 17.7 14.2 32 31.8 32h262.4c17.6 0 31.8-14.3 31.8-32V597.4L907.7 202c12.2-21.3-3.1-48-27.6-48zM603.4 798H420.6V642h182.9v156zm9.6-236.6l-9.5 16.6h-183l-9.5-16.6L212.7 226h598.6L613 561.4z" } }] }, "name": "filter", "theme": "outlined" };
  exports.default = FilterOutlined;
  });

  var FilterOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FilterOutlined_1);

  var FilterOutlined = function FilterOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FilterOutlinedSvg
    }));
  };
  var RefIcon$5c = /*#__PURE__*/React.forwardRef(FilterOutlined);
  {
    RefIcon$5c.displayName = 'FilterOutlined';
  }

  var FilterTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FilterTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M420.6 798h182.9V642H420.6zM411 561.4l9.5 16.6h183l9.5-16.6L811.3 226H212.7z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M880.1 154H143.9c-24.5 0-39.8 26.7-27.5 48L349 597.4V838c0 17.7 14.2 32 31.8 32h262.4c17.6 0 31.8-14.3 31.8-32V597.4L907.7 202c12.2-21.3-3.1-48-27.6-48zM603.5 798H420.6V642h182.9v156zm9.5-236.6l-9.5 16.6h-183l-9.5-16.6L212.7 226h598.6L613 561.4z", "fill": primaryColor } }] }; }, "name": "filter", "theme": "twotone" };
  exports.default = FilterTwoTone;
  });

  var FilterTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(FilterTwoTone_1);

  var FilterTwoTone = function FilterTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FilterTwoToneSvg
    }));
  };
  var RefIcon$5d = /*#__PURE__*/React.forwardRef(FilterTwoTone);
  {
    RefIcon$5d.displayName = 'FilterTwoTone';
  }

  var FireFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FireFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M834.1 469.2A347.49 347.49 0 00751.2 354l-29.1-26.7a8.09 8.09 0 00-13 3.3l-13 37.3c-8.1 23.4-23 47.3-44.1 70.8-1.4 1.5-3 1.9-4.1 2-1.1.1-2.8-.1-4.3-1.5-1.4-1.2-2.1-3-2-4.8 3.7-60.2-14.3-128.1-53.7-202C555.3 171 510 123.1 453.4 89.7l-41.3-24.3c-5.4-3.2-12.3 1-12 7.3l2.2 48c1.5 32.8-2.3 61.8-11.3 85.9-11 29.5-26.8 56.9-47 81.5a295.64 295.64 0 01-47.5 46.1 352.6 352.6 0 00-100.3 121.5A347.75 347.75 0 00160 610c0 47.2 9.3 92.9 27.7 136a349.4 349.4 0 0075.5 110.9c32.4 32 70 57.2 111.9 74.7C418.5 949.8 464.5 959 512 959s93.5-9.2 136.9-27.3A348.6 348.6 0 00760.8 857c32.4-32 57.8-69.4 75.5-110.9a344.2 344.2 0 0027.7-136c0-48.8-10-96.2-29.9-140.9z" } }] }, "name": "fire", "theme": "filled" };
  exports.default = FireFilled;
  });

  var FireFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(FireFilled_1);

  var FireFilled = function FireFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FireFilledSvg
    }));
  };
  var RefIcon$5e = /*#__PURE__*/React.forwardRef(FireFilled);
  {
    RefIcon$5e.displayName = 'FireFilled';
  }

  var FireOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FireOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M834.1 469.2A347.49 347.49 0 00751.2 354l-29.1-26.7a8.09 8.09 0 00-13 3.3l-13 37.3c-8.1 23.4-23 47.3-44.1 70.8-1.4 1.5-3 1.9-4.1 2-1.1.1-2.8-.1-4.3-1.5-1.4-1.2-2.1-3-2-4.8 3.7-60.2-14.3-128.1-53.7-202C555.3 171 510 123.1 453.4 89.7l-41.3-24.3c-5.4-3.2-12.3 1-12 7.3l2.2 48c1.5 32.8-2.3 61.8-11.3 85.9-11 29.5-26.8 56.9-47 81.5a295.64 295.64 0 01-47.5 46.1 352.6 352.6 0 00-100.3 121.5A347.75 347.75 0 00160 610c0 47.2 9.3 92.9 27.7 136a349.4 349.4 0 0075.5 110.9c32.4 32 70 57.2 111.9 74.7C418.5 949.8 464.5 959 512 959s93.5-9.2 136.9-27.3A348.6 348.6 0 00760.8 857c32.4-32 57.8-69.4 75.5-110.9a344.2 344.2 0 0027.7-136c0-48.8-10-96.2-29.9-140.9zM713 808.5c-53.7 53.2-125 82.4-201 82.4s-147.3-29.2-201-82.4c-53.5-53.1-83-123.5-83-198.4 0-43.5 9.8-85.2 29.1-124 18.8-37.9 46.8-71.8 80.8-97.9a349.6 349.6 0 0058.6-56.8c25-30.5 44.6-64.5 58.2-101a240 240 0 0012.1-46.5c24.1 22.2 44.3 49 61.2 80.4 33.4 62.6 48.8 118.3 45.8 165.7a74.01 74.01 0 0024.4 59.8 73.36 73.36 0 0053.4 18.8c19.7-1 37.8-9.7 51-24.4 13.3-14.9 24.8-30.1 34.4-45.6 14 17.9 25.7 37.4 35 58.4 15.9 35.8 24 73.9 24 113.1 0 74.9-29.5 145.4-83 198.4z" } }] }, "name": "fire", "theme": "outlined" };
  exports.default = FireOutlined;
  });

  var FireOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FireOutlined_1);

  var FireOutlined = function FireOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FireOutlinedSvg
    }));
  };
  var RefIcon$5f = /*#__PURE__*/React.forwardRef(FireOutlined);
  {
    RefIcon$5f.displayName = 'FireOutlined';
  }

  var FireTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FireTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M737 438.6c-9.6 15.5-21.1 30.7-34.4 45.6a73.1 73.1 0 01-51 24.4 73.36 73.36 0 01-53.4-18.8 74.01 74.01 0 01-24.4-59.8c3-47.4-12.4-103.1-45.8-165.7-16.9-31.4-37.1-58.2-61.2-80.4a240 240 0 01-12.1 46.5 354.26 354.26 0 01-58.2 101 349.6 349.6 0 01-58.6 56.8c-34 26.1-62 60-80.8 97.9a275.96 275.96 0 00-29.1 124c0 74.9 29.5 145.3 83 198.4 53.7 53.2 125 82.4 201 82.4s147.3-29.2 201-82.4c53.5-53 83-123.5 83-198.4 0-39.2-8.1-77.3-24-113.1-9.3-21-21-40.5-35-58.4z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M834.1 469.2A347.49 347.49 0 00751.2 354l-29.1-26.7a8.09 8.09 0 00-13 3.3l-13 37.3c-8.1 23.4-23 47.3-44.1 70.8-1.4 1.5-3 1.9-4.1 2-1.1.1-2.8-.1-4.3-1.5-1.4-1.2-2.1-3-2-4.8 3.7-60.2-14.3-128.1-53.7-202C555.3 171 510 123.1 453.4 89.7l-41.3-24.3c-5.4-3.2-12.3 1-12 7.3l2.2 48c1.5 32.8-2.3 61.8-11.3 85.9-11 29.5-26.8 56.9-47 81.5a295.64 295.64 0 01-47.5 46.1 352.6 352.6 0 00-100.3 121.5A347.75 347.75 0 00160 610c0 47.2 9.3 92.9 27.7 136a349.4 349.4 0 0075.5 110.9c32.4 32 70 57.2 111.9 74.7C418.5 949.8 464.5 959 512 959s93.5-9.2 136.9-27.3A348.6 348.6 0 00760.8 857c32.4-32 57.8-69.4 75.5-110.9a344.2 344.2 0 0027.7-136c0-48.8-10-96.2-29.9-140.9zM713 808.5c-53.7 53.2-125 82.4-201 82.4s-147.3-29.2-201-82.4c-53.5-53.1-83-123.5-83-198.4 0-43.5 9.8-85.2 29.1-124 18.8-37.9 46.8-71.8 80.8-97.9a349.6 349.6 0 0058.6-56.8c25-30.5 44.6-64.5 58.2-101a240 240 0 0012.1-46.5c24.1 22.2 44.3 49 61.2 80.4 33.4 62.6 48.8 118.3 45.8 165.7a74.01 74.01 0 0024.4 59.8 73.36 73.36 0 0053.4 18.8c19.7-1 37.8-9.7 51-24.4 13.3-14.9 24.8-30.1 34.4-45.6 14 17.9 25.7 37.4 35 58.4 15.9 35.8 24 73.9 24 113.1 0 74.9-29.5 145.4-83 198.4z", "fill": primaryColor } }] }; }, "name": "fire", "theme": "twotone" };
  exports.default = FireTwoTone;
  });

  var FireTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(FireTwoTone_1);

  var FireTwoTone = function FireTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FireTwoToneSvg
    }));
  };
  var RefIcon$5g = /*#__PURE__*/React.forwardRef(FireTwoTone);
  {
    RefIcon$5g.displayName = 'FireTwoTone';
  }

  var FlagFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FlagFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 305H624V192c0-17.7-14.3-32-32-32H184v-40c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v784c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V640h248v113c0 17.7 14.3 32 32 32h416c17.7 0 32-14.3 32-32V337c0-17.7-14.3-32-32-32z" } }] }, "name": "flag", "theme": "filled" };
  exports.default = FlagFilled;
  });

  var FlagFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(FlagFilled_1);

  var FlagFilled = function FlagFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FlagFilledSvg
    }));
  };
  var RefIcon$5h = /*#__PURE__*/React.forwardRef(FlagFilled);
  {
    RefIcon$5h.displayName = 'FlagFilled';
  }

  var FlagOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FlagOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 305H624V192c0-17.7-14.3-32-32-32H184v-40c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v784c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V640h248v113c0 17.7 14.3 32 32 32h416c17.7 0 32-14.3 32-32V337c0-17.7-14.3-32-32-32zM184 568V232h368v336H184zm656 145H504v-73h112c4.4 0 8-3.6 8-8V377h216v336z" } }] }, "name": "flag", "theme": "outlined" };
  exports.default = FlagOutlined;
  });

  var FlagOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FlagOutlined_1);

  var FlagOutlined = function FlagOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FlagOutlinedSvg
    }));
  };
  var RefIcon$5i = /*#__PURE__*/React.forwardRef(FlagOutlined);
  {
    RefIcon$5i.displayName = 'FlagOutlined';
  }

  var FlagTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FlagTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M184 232h368v336H184z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M624 632c0 4.4-3.6 8-8 8H504v73h336V377H624v255z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M880 305H624V192c0-17.7-14.3-32-32-32H184v-40c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v784c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V640h248v113c0 17.7 14.3 32 32 32h416c17.7 0 32-14.3 32-32V337c0-17.7-14.3-32-32-32zM184 568V232h368v336H184zm656 145H504v-73h112c4.4 0 8-3.6 8-8V377h216v336z", "fill": primaryColor } }] }; }, "name": "flag", "theme": "twotone" };
  exports.default = FlagTwoTone;
  });

  var FlagTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(FlagTwoTone_1);

  var FlagTwoTone = function FlagTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FlagTwoToneSvg
    }));
  };
  var RefIcon$5j = /*#__PURE__*/React.forwardRef(FlagTwoTone);
  {
    RefIcon$5j.displayName = 'FlagTwoTone';
  }

  var FolderAddFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FolderAddFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 298.4H521L403.7 186.2a8.15 8.15 0 00-5.5-2.2H144c-17.7 0-32 14.3-32 32v592c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V330.4c0-17.7-14.3-32-32-32zM632 577c0 3.8-3.4 7-7.5 7H540v84.9c0 3.9-3.2 7.1-7 7.1h-42c-3.8 0-7-3.2-7-7.1V584h-84.5c-4.1 0-7.5-3.2-7.5-7v-42c0-3.8 3.4-7 7.5-7H484v-84.9c0-3.9 3.2-7.1 7-7.1h42c3.8 0 7 3.2 7 7.1V528h84.5c4.1 0 7.5 3.2 7.5 7v42z" } }] }, "name": "folder-add", "theme": "filled" };
  exports.default = FolderAddFilled;
  });

  var FolderAddFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(FolderAddFilled_1);

  var FolderAddFilled = function FolderAddFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FolderAddFilledSvg
    }));
  };
  var RefIcon$5k = /*#__PURE__*/React.forwardRef(FolderAddFilled);
  {
    RefIcon$5k.displayName = 'FolderAddFilled';
  }

  var FolderAddOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FolderAddOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M484 443.1V528h-84.5c-4.1 0-7.5 3.1-7.5 7v42c0 3.8 3.4 7 7.5 7H484v84.9c0 3.9 3.2 7.1 7 7.1h42c3.9 0 7-3.2 7-7.1V584h84.5c4.1 0 7.5-3.2 7.5-7v-42c0-3.9-3.4-7-7.5-7H540v-84.9c0-3.9-3.1-7.1-7-7.1h-42c-3.8 0-7 3.2-7 7.1zm396-144.7H521L403.7 186.2a8.15 8.15 0 00-5.5-2.2H144c-17.7 0-32 14.3-32 32v592c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V330.4c0-17.7-14.3-32-32-32zM840 768H184V256h188.5l119.6 114.4H840V768z" } }] }, "name": "folder-add", "theme": "outlined" };
  exports.default = FolderAddOutlined;
  });

  var FolderAddOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FolderAddOutlined_1);

  var FolderAddOutlined = function FolderAddOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FolderAddOutlinedSvg
    }));
  };
  var RefIcon$5l = /*#__PURE__*/React.forwardRef(FolderAddOutlined);
  {
    RefIcon$5l.displayName = 'FolderAddOutlined';
  }

  var FolderAddTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FolderAddTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M372.5 256H184v512h656V370.4H492.1L372.5 256zM540 443.1V528h84.5c4.1 0 7.5 3.1 7.5 7v42c0 3.8-3.4 7-7.5 7H540v84.9c0 3.9-3.1 7.1-7 7.1h-42c-3.8 0-7-3.2-7-7.1V584h-84.5c-4.1 0-7.5-3.2-7.5-7v-42c0-3.9 3.4-7 7.5-7H484v-84.9c0-3.9 3.2-7.1 7-7.1h42c3.9 0 7 3.2 7 7.1z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M880 298.4H521L403.7 186.2a8.15 8.15 0 00-5.5-2.2H144c-17.7 0-32 14.3-32 32v592c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V330.4c0-17.7-14.3-32-32-32zM840 768H184V256h188.5l119.6 114.4H840V768z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M484 443.1V528h-84.5c-4.1 0-7.5 3.1-7.5 7v42c0 3.8 3.4 7 7.5 7H484v84.9c0 3.9 3.2 7.1 7 7.1h42c3.9 0 7-3.2 7-7.1V584h84.5c4.1 0 7.5-3.2 7.5-7v-42c0-3.9-3.4-7-7.5-7H540v-84.9c0-3.9-3.1-7.1-7-7.1h-42c-3.8 0-7 3.2-7 7.1z", "fill": primaryColor } }] }; }, "name": "folder-add", "theme": "twotone" };
  exports.default = FolderAddTwoTone;
  });

  var FolderAddTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(FolderAddTwoTone_1);

  var FolderAddTwoTone = function FolderAddTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FolderAddTwoToneSvg
    }));
  };
  var RefIcon$5m = /*#__PURE__*/React.forwardRef(FolderAddTwoTone);
  {
    RefIcon$5m.displayName = 'FolderAddTwoTone';
  }

  var FolderFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FolderFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 298.4H521L403.7 186.2a8.15 8.15 0 00-5.5-2.2H144c-17.7 0-32 14.3-32 32v592c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V330.4c0-17.7-14.3-32-32-32z" } }] }, "name": "folder", "theme": "filled" };
  exports.default = FolderFilled;
  });

  var FolderFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(FolderFilled_1);

  var FolderFilled = function FolderFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FolderFilledSvg
    }));
  };
  var RefIcon$5n = /*#__PURE__*/React.forwardRef(FolderFilled);
  {
    RefIcon$5n.displayName = 'FolderFilled';
  }

  var FolderOpenFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FolderOpenFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M928 444H820V330.4c0-17.7-14.3-32-32-32H473L355.7 186.2a8.15 8.15 0 00-5.5-2.2H96c-17.7 0-32 14.3-32 32v592c0 17.7 14.3 32 32 32h698c13 0 24.8-7.9 29.7-20l134-332c1.5-3.8 2.3-7.9 2.3-12 0-17.7-14.3-32-32-32zm-180 0H238c-13 0-24.8 7.9-29.7 20L136 643.2V256h188.5l119.6 114.4H748V444z" } }] }, "name": "folder-open", "theme": "filled" };
  exports.default = FolderOpenFilled;
  });

  var FolderOpenFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(FolderOpenFilled_1);

  var FolderOpenFilled = function FolderOpenFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FolderOpenFilledSvg
    }));
  };
  var RefIcon$5o = /*#__PURE__*/React.forwardRef(FolderOpenFilled);
  {
    RefIcon$5o.displayName = 'FolderOpenFilled';
  }

  var FolderOpenOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FolderOpenOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M928 444H820V330.4c0-17.7-14.3-32-32-32H473L355.7 186.2a8.15 8.15 0 00-5.5-2.2H96c-17.7 0-32 14.3-32 32v592c0 17.7 14.3 32 32 32h698c13 0 24.8-7.9 29.7-20l134-332c1.5-3.8 2.3-7.9 2.3-12 0-17.7-14.3-32-32-32zM136 256h188.5l119.6 114.4H748V444H238c-13 0-24.8 7.9-29.7 20L136 643.2V256zm635.3 512H159l103.3-256h612.4L771.3 768z" } }] }, "name": "folder-open", "theme": "outlined" };
  exports.default = FolderOpenOutlined;
  });

  var FolderOpenOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FolderOpenOutlined_1);

  var FolderOpenOutlined = function FolderOpenOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FolderOpenOutlinedSvg
    }));
  };
  var RefIcon$5p = /*#__PURE__*/React.forwardRef(FolderOpenOutlined);
  {
    RefIcon$5p.displayName = 'FolderOpenOutlined';
  }

  var FolderOpenTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FolderOpenTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M159 768h612.3l103.4-256H262.3z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M928 444H820V330.4c0-17.7-14.3-32-32-32H473L355.7 186.2a8.15 8.15 0 00-5.5-2.2H96c-17.7 0-32 14.3-32 32v592c0 17.7 14.3 32 32 32h698c13 0 24.8-7.9 29.7-20l134-332c1.5-3.8 2.3-7.9 2.3-12 0-17.7-14.3-32-32-32zM136 256h188.5l119.6 114.4H748V444H238c-13 0-24.8 7.9-29.7 20L136 643.2V256zm635.3 512H159l103.3-256h612.4L771.3 768z", "fill": primaryColor } }] }; }, "name": "folder-open", "theme": "twotone" };
  exports.default = FolderOpenTwoTone;
  });

  var FolderOpenTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(FolderOpenTwoTone_1);

  var FolderOpenTwoTone = function FolderOpenTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FolderOpenTwoToneSvg
    }));
  };
  var RefIcon$5q = /*#__PURE__*/React.forwardRef(FolderOpenTwoTone);
  {
    RefIcon$5q.displayName = 'FolderOpenTwoTone';
  }

  var FolderOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FolderOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 298.4H521L403.7 186.2a8.15 8.15 0 00-5.5-2.2H144c-17.7 0-32 14.3-32 32v592c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V330.4c0-17.7-14.3-32-32-32zM840 768H184V256h188.5l119.6 114.4H840V768z" } }] }, "name": "folder", "theme": "outlined" };
  exports.default = FolderOutlined;
  });

  var FolderOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FolderOutlined_1);

  var FolderOutlined = function FolderOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FolderOutlinedSvg
    }));
  };
  var RefIcon$5r = /*#__PURE__*/React.forwardRef(FolderOutlined);
  {
    RefIcon$5r.displayName = 'FolderOutlined';
  }

  var FolderTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FolderTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 298.4H521L403.7 186.2a8.15 8.15 0 00-5.5-2.2H144c-17.7 0-32 14.3-32 32v592c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V330.4c0-17.7-14.3-32-32-32zM840 768H184V256h188.5l119.6 114.4H840V768z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M372.5 256H184v512h656V370.4H492.1z", "fill": secondaryColor } }] }; }, "name": "folder", "theme": "twotone" };
  exports.default = FolderTwoTone;
  });

  var FolderTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(FolderTwoTone_1);

  var FolderTwoTone = function FolderTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FolderTwoToneSvg
    }));
  };
  var RefIcon$5s = /*#__PURE__*/React.forwardRef(FolderTwoTone);
  {
    RefIcon$5s.displayName = 'FolderTwoTone';
  }

  var FolderViewOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FolderViewOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M309.1 554.3a42.92 42.92 0 000 36.4C353.3 684 421.6 732 512.5 732s159.2-48.1 203.4-141.3c5.4-11.5 5.4-24.8.1-36.3l-.1-.1-.1-.1C671.7 461 603.4 413 512.5 413s-159.2 48.1-203.4 141.3zM512.5 477c62.1 0 107.4 30 141.1 95.5C620 638 574.6 668 512.5 668s-107.4-30-141.1-95.5c33.7-65.5 79-95.5 141.1-95.5z" } }, { "tag": "path", "attrs": { "d": "M457 573a56 56 0 10112 0 56 56 0 10-112 0z" } }, { "tag": "path", "attrs": { "d": "M880 298.4H521L403.7 186.2a8.15 8.15 0 00-5.5-2.2H144c-17.7 0-32 14.3-32 32v592c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V330.4c0-17.7-14.3-32-32-32zM840 768H184V256h188.5l119.6 114.4H840V768z" } }] }, "name": "folder-view", "theme": "outlined" };
  exports.default = FolderViewOutlined;
  });

  var FolderViewOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FolderViewOutlined_1);

  var FolderViewOutlined = function FolderViewOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FolderViewOutlinedSvg
    }));
  };
  var RefIcon$5t = /*#__PURE__*/React.forwardRef(FolderViewOutlined);
  {
    RefIcon$5t.displayName = 'FolderViewOutlined';
  }

  var FontColorsOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FontColorsOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M904 816H120c-4.4 0-8 3.6-8 8v80c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-80c0-4.4-3.6-8-8-8zm-650.3-80h85c4.2 0 8-2.7 9.3-6.8l53.7-166h219.2l53.2 166c1.3 4 5 6.8 9.3 6.8h89.1c1.1 0 2.2-.2 3.2-.5a9.7 9.7 0 006-12.4L573.6 118.6a9.9 9.9 0 00-9.2-6.6H462.1c-4.2 0-7.9 2.6-9.2 6.6L244.5 723.1c-.4 1-.5 2.1-.5 3.2-.1 5.3 4.3 9.7 9.7 9.7zm255.9-516.1h4.1l83.8 263.8H424.9l84.7-263.8z" } }] }, "name": "font-colors", "theme": "outlined" };
  exports.default = FontColorsOutlined;
  });

  var FontColorsOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FontColorsOutlined_1);

  var FontColorsOutlined = function FontColorsOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FontColorsOutlinedSvg
    }));
  };
  var RefIcon$5u = /*#__PURE__*/React.forwardRef(FontColorsOutlined);
  {
    RefIcon$5u.displayName = 'FontColorsOutlined';
  }

  var FontSizeOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FontSizeOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M920 416H616c-4.4 0-8 3.6-8 8v112c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8v-56h60v320h-46c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h164c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8h-46V480h60v56c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V424c0-4.4-3.6-8-8-8zM656 296V168c0-4.4-3.6-8-8-8H104c-4.4 0-8 3.6-8 8v128c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-64h168v560h-92c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h264c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-92V232h168v64c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8z" } }] }, "name": "font-size", "theme": "outlined" };
  exports.default = FontSizeOutlined;
  });

  var FontSizeOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FontSizeOutlined_1);

  var FontSizeOutlined = function FontSizeOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FontSizeOutlinedSvg
    }));
  };
  var RefIcon$5v = /*#__PURE__*/React.forwardRef(FontSizeOutlined);
  {
    RefIcon$5v.displayName = 'FontSizeOutlined';
  }

  var ForkOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ForkOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M752 100c-61.8 0-112 50.2-112 112 0 47.7 29.9 88.5 72 104.6v27.6L512 601.4 312 344.2v-27.6c42.1-16.1 72-56.9 72-104.6 0-61.8-50.2-112-112-112s-112 50.2-112 112c0 50.6 33.8 93.5 80 107.3v34.4c0 9.7 3.3 19.3 9.3 27L476 672.3v33.6c-44.2 15-76 56.9-76 106.1 0 61.8 50.2 112 112 112s112-50.2 112-112c0-49.2-31.8-91-76-106.1v-33.6l226.7-291.6c6-7.7 9.3-17.3 9.3-27v-34.4c46.2-13.8 80-56.7 80-107.3 0-61.8-50.2-112-112-112zM224 212a48.01 48.01 0 0196 0 48.01 48.01 0 01-96 0zm336 600a48.01 48.01 0 01-96 0 48.01 48.01 0 0196 0zm192-552a48.01 48.01 0 010-96 48.01 48.01 0 010 96z" } }] }, "name": "fork", "theme": "outlined" };
  exports.default = ForkOutlined;
  });

  var ForkOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(ForkOutlined_1);

  var ForkOutlined = function ForkOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ForkOutlinedSvg
    }));
  };
  var RefIcon$5w = /*#__PURE__*/React.forwardRef(ForkOutlined);
  {
    RefIcon$5w.displayName = 'ForkOutlined';
  }

  var FormOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FormOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M904 512h-56c-4.4 0-8 3.6-8 8v320H184V184h320c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V520c0-4.4-3.6-8-8-8z" } }, { "tag": "path", "attrs": { "d": "M355.9 534.9L354 653.8c-.1 8.9 7.1 16.2 16 16.2h.4l118-2.9c2-.1 4-.9 5.4-2.3l415.9-415c3.1-3.1 3.1-8.2 0-11.3L785.4 114.3c-1.6-1.6-3.6-2.3-5.7-2.3s-4.1.8-5.7 2.3l-415.8 415a8.3 8.3 0 00-2.3 5.6zm63.5 23.6L779.7 199l45.2 45.1-360.5 359.7-45.7 1.1.7-46.4z" } }] }, "name": "form", "theme": "outlined" };
  exports.default = FormOutlined;
  });

  var FormOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FormOutlined_1);

  var FormOutlined = function FormOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FormOutlinedSvg
    }));
  };
  var RefIcon$5x = /*#__PURE__*/React.forwardRef(FormOutlined);
  {
    RefIcon$5x.displayName = 'FormOutlined';
  }

  var FormatPainterFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FormatPainterFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M840 192h-56v-72c0-13.3-10.7-24-24-24H168c-13.3 0-24 10.7-24 24v272c0 13.3 10.7 24 24 24h592c13.3 0 24-10.7 24-24V256h32v200H465c-22.1 0-40 17.9-40 40v136h-44c-4.4 0-8 3.6-8 8v228c0 1.1.2 2.2.6 3.1-.4 1.6-.6 3.2-.6 4.9 0 46.4 37.6 84 84 84s84-37.6 84-84c0-1.7-.2-3.3-.6-4.9.4-1 .6-2 .6-3.1V640c0-4.4-3.6-8-8-8h-44V520h351c22.1 0 40-17.9 40-40V232c0-22.1-17.9-40-40-40z" } }] }, "name": "format-painter", "theme": "filled" };
  exports.default = FormatPainterFilled;
  });

  var FormatPainterFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(FormatPainterFilled_1);

  var FormatPainterFilled = function FormatPainterFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FormatPainterFilledSvg
    }));
  };
  var RefIcon$5y = /*#__PURE__*/React.forwardRef(FormatPainterFilled);
  {
    RefIcon$5y.displayName = 'FormatPainterFilled';
  }

  var FormatPainterOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FormatPainterOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M840 192h-56v-72c0-13.3-10.7-24-24-24H168c-13.3 0-24 10.7-24 24v272c0 13.3 10.7 24 24 24h592c13.3 0 24-10.7 24-24V256h32v200H465c-22.1 0-40 17.9-40 40v136h-44c-4.4 0-8 3.6-8 8v228c0 .6.1 1.3.2 1.9A83.99 83.99 0 00457 960c46.4 0 84-37.6 84-84 0-2.1-.1-4.1-.2-6.1.1-.6.2-1.2.2-1.9V640c0-4.4-3.6-8-8-8h-44V520h351c22.1 0 40-17.9 40-40V232c0-22.1-17.9-40-40-40zM720 352H208V160h512v192zM477 876c0 11-9 20-20 20s-20-9-20-20V696h40v180z" } }] }, "name": "format-painter", "theme": "outlined" };
  exports.default = FormatPainterOutlined;
  });

  var FormatPainterOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FormatPainterOutlined_1);

  var FormatPainterOutlined = function FormatPainterOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FormatPainterOutlinedSvg
    }));
  };
  var RefIcon$5z = /*#__PURE__*/React.forwardRef(FormatPainterOutlined);
  {
    RefIcon$5z.displayName = 'FormatPainterOutlined';
  }

  var ForwardFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ForwardFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M825.8 498L538.4 249.9c-10.7-9.2-26.4-.9-26.4 14v496.3c0 14.9 15.7 23.2 26.4 14L825.8 526c8.3-7.2 8.3-20.8 0-28zm-320 0L218.4 249.9c-10.7-9.2-26.4-.9-26.4 14v496.3c0 14.9 15.7 23.2 26.4 14L505.8 526c4.1-3.6 6.2-8.8 6.2-14 0-5.2-2.1-10.4-6.2-14z" } }] }, "name": "forward", "theme": "filled" };
  exports.default = ForwardFilled;
  });

  var ForwardFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(ForwardFilled_1);

  var ForwardFilled = function ForwardFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ForwardFilledSvg
    }));
  };
  var RefIcon$5A = /*#__PURE__*/React.forwardRef(ForwardFilled);
  {
    RefIcon$5A.displayName = 'ForwardFilled';
  }

  var ForwardOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ForwardOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M825.8 498L538.4 249.9c-10.7-9.2-26.4-.9-26.4 14v496.3c0 14.9 15.7 23.2 26.4 14L825.8 526c8.3-7.2 8.3-20.8 0-28zm-320 0L218.4 249.9c-10.7-9.2-26.4-.9-26.4 14v496.3c0 14.9 15.7 23.2 26.4 14L505.8 526c4.1-3.6 6.2-8.8 6.2-14 0-5.2-2.1-10.4-6.2-14z" } }] }, "name": "forward", "theme": "outlined" };
  exports.default = ForwardOutlined;
  });

  var ForwardOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(ForwardOutlined_1);

  var ForwardOutlined = function ForwardOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ForwardOutlinedSvg
    }));
  };
  var RefIcon$5B = /*#__PURE__*/React.forwardRef(ForwardOutlined);
  {
    RefIcon$5B.displayName = 'ForwardOutlined';
  }

  var FrownFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FrownFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zM288 421a48.01 48.01 0 0196 0 48.01 48.01 0 01-96 0zm376 272h-48.1c-4.2 0-7.8-3.2-8.1-7.4C604 636.1 562.5 597 512 597s-92.1 39.1-95.8 88.6c-.3 4.2-3.9 7.4-8.1 7.4H360a8 8 0 01-8-8.4c4.4-84.3 74.5-151.6 160-151.6s155.6 67.3 160 151.6a8 8 0 01-8 8.4zm24-224a48.01 48.01 0 010-96 48.01 48.01 0 010 96z" } }] }, "name": "frown", "theme": "filled" };
  exports.default = FrownFilled;
  });

  var FrownFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(FrownFilled_1);

  var FrownFilled = function FrownFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FrownFilledSvg
    }));
  };
  var RefIcon$5C = /*#__PURE__*/React.forwardRef(FrownFilled);
  {
    RefIcon$5C.displayName = 'FrownFilled';
  }

  var FrownOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FrownOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M288 421a48 48 0 1096 0 48 48 0 10-96 0zm352 0a48 48 0 1096 0 48 48 0 10-96 0zM512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm263 711c-34.2 34.2-74 61-118.3 79.8C611 874.2 562.3 884 512 884c-50.3 0-99-9.8-144.8-29.2A370.4 370.4 0 01248.9 775c-34.2-34.2-61-74-79.8-118.3C149.8 611 140 562.3 140 512s9.8-99 29.2-144.8A370.4 370.4 0 01249 248.9c34.2-34.2 74-61 118.3-79.8C413 149.8 461.7 140 512 140c50.3 0 99 9.8 144.8 29.2A370.4 370.4 0 01775.1 249c34.2 34.2 61 74 79.8 118.3C874.2 413 884 461.7 884 512s-9.8 99-29.2 144.8A368.89 368.89 0 01775 775zM512 533c-85.5 0-155.6 67.3-160 151.6a8 8 0 008 8.4h48.1c4.2 0 7.8-3.2 8.1-7.4C420 636.1 461.5 597 512 597s92.1 39.1 95.8 88.6c.3 4.2 3.9 7.4 8.1 7.4H664a8 8 0 008-8.4C667.6 600.3 597.5 533 512 533z" } }] }, "name": "frown", "theme": "outlined" };
  exports.default = FrownOutlined;
  });

  var FrownOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FrownOutlined_1);

  var FrownOutlined = function FrownOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FrownOutlinedSvg
    }));
  };
  var RefIcon$5D = /*#__PURE__*/React.forwardRef(FrownOutlined);
  {
    RefIcon$5D.displayName = 'FrownOutlined';
  }

  var FrownTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FrownTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zM288 421a48.01 48.01 0 0196 0 48.01 48.01 0 01-96 0zm376 272h-48.1c-4.2 0-7.8-3.2-8.1-7.4C604 636.1 562.5 597 512 597s-92.1 39.1-95.8 88.6c-.3 4.2-3.9 7.4-8.1 7.4H360a8 8 0 01-8-8.4c4.4-84.3 74.5-151.6 160-151.6s155.6 67.3 160 151.6a8 8 0 01-8 8.4zm24-224a48.01 48.01 0 010-96 48.01 48.01 0 010 96z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M288 421a48 48 0 1096 0 48 48 0 10-96 0zm224 112c-85.5 0-155.6 67.3-160 151.6a8 8 0 008 8.4h48.1c4.2 0 7.8-3.2 8.1-7.4 3.7-49.5 45.3-88.6 95.8-88.6s92 39.1 95.8 88.6c.3 4.2 3.9 7.4 8.1 7.4H664a8 8 0 008-8.4C667.6 600.3 597.5 533 512 533zm128-112a48 48 0 1096 0 48 48 0 10-96 0z", "fill": primaryColor } }] }; }, "name": "frown", "theme": "twotone" };
  exports.default = FrownTwoTone;
  });

  var FrownTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(FrownTwoTone_1);

  var FrownTwoTone = function FrownTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FrownTwoToneSvg
    }));
  };
  var RefIcon$5E = /*#__PURE__*/React.forwardRef(FrownTwoTone);
  {
    RefIcon$5E.displayName = 'FrownTwoTone';
  }

  var FullscreenExitOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FullscreenExitOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M391 240.9c-.8-6.6-8.9-9.4-13.6-4.7l-43.7 43.7L200 146.3a8.03 8.03 0 00-11.3 0l-42.4 42.3a8.03 8.03 0 000 11.3L280 333.6l-43.9 43.9a8.01 8.01 0 004.7 13.6L401 410c5.1.6 9.5-3.7 8.9-8.9L391 240.9zm10.1 373.2L240.8 633c-6.6.8-9.4 8.9-4.7 13.6l43.9 43.9L146.3 824a8.03 8.03 0 000 11.3l42.4 42.3c3.1 3.1 8.2 3.1 11.3 0L333.7 744l43.7 43.7A8.01 8.01 0 00391 783l18.9-160.1c.6-5.1-3.7-9.4-8.8-8.8zm221.8-204.2L783.2 391c6.6-.8 9.4-8.9 4.7-13.6L744 333.6 877.7 200c3.1-3.1 3.1-8.2 0-11.3l-42.4-42.3a8.03 8.03 0 00-11.3 0L690.3 279.9l-43.7-43.7a8.01 8.01 0 00-13.6 4.7L614.1 401c-.6 5.2 3.7 9.5 8.8 8.9zM744 690.4l43.9-43.9a8.01 8.01 0 00-4.7-13.6L623 614c-5.1-.6-9.5 3.7-8.9 8.9L633 783.1c.8 6.6 8.9 9.4 13.6 4.7l43.7-43.7L824 877.7c3.1 3.1 8.2 3.1 11.3 0l42.4-42.3c3.1-3.1 3.1-8.2 0-11.3L744 690.4z" } }] }, "name": "fullscreen-exit", "theme": "outlined" };
  exports.default = FullscreenExitOutlined;
  });

  var FullscreenExitOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FullscreenExitOutlined_1);

  var FullscreenExitOutlined = function FullscreenExitOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FullscreenExitOutlinedSvg
    }));
  };
  var RefIcon$5F = /*#__PURE__*/React.forwardRef(FullscreenExitOutlined);
  {
    RefIcon$5F.displayName = 'FullscreenExitOutlined';
  }

  var FullscreenOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FullscreenOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M290 236.4l43.9-43.9a8.01 8.01 0 00-4.7-13.6L169 160c-5.1-.6-9.5 3.7-8.9 8.9L179 329.1c.8 6.6 8.9 9.4 13.6 4.7l43.7-43.7L370 423.7c3.1 3.1 8.2 3.1 11.3 0l42.4-42.3c3.1-3.1 3.1-8.2 0-11.3L290 236.4zm352.7 187.3c3.1 3.1 8.2 3.1 11.3 0l133.7-133.6 43.7 43.7a8.01 8.01 0 0013.6-4.7L863.9 169c.6-5.1-3.7-9.5-8.9-8.9L694.8 179c-6.6.8-9.4 8.9-4.7 13.6l43.9 43.9L600.3 370a8.03 8.03 0 000 11.3l42.4 42.4zM845 694.9c-.8-6.6-8.9-9.4-13.6-4.7l-43.7 43.7L654 600.3a8.03 8.03 0 00-11.3 0l-42.4 42.3a8.03 8.03 0 000 11.3L734 787.6l-43.9 43.9a8.01 8.01 0 004.7 13.6L855 864c5.1.6 9.5-3.7 8.9-8.9L845 694.9zm-463.7-94.6a8.03 8.03 0 00-11.3 0L236.3 733.9l-43.7-43.7a8.01 8.01 0 00-13.6 4.7L160.1 855c-.6 5.1 3.7 9.5 8.9 8.9L329.2 845c6.6-.8 9.4-8.9 4.7-13.6L290 787.6 423.7 654c3.1-3.1 3.1-8.2 0-11.3l-42.4-42.4z" } }] }, "name": "fullscreen", "theme": "outlined" };
  exports.default = FullscreenOutlined;
  });

  var FullscreenOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FullscreenOutlined_1);

  var FullscreenOutlined = function FullscreenOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FullscreenOutlinedSvg
    }));
  };
  var RefIcon$5G = /*#__PURE__*/React.forwardRef(FullscreenOutlined);
  {
    RefIcon$5G.displayName = 'FullscreenOutlined';
  }

  var FunctionOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FunctionOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M841 370c3-3.3 2.7-8.3-.6-11.3a8.24 8.24 0 00-5.3-2.1h-72.6c-2.4 0-4.6 1-6.1 2.8L633.5 504.6a7.96 7.96 0 01-13.4-1.9l-63.5-141.3a7.9 7.9 0 00-7.3-4.7H380.7l.9-4.7 8-42.3c10.5-55.4 38-81.4 85.8-81.4 18.6 0 35.5 1.7 48.8 4.7l14.1-66.8c-22.6-4.7-35.2-6.1-54.9-6.1-103.3 0-156.4 44.3-175.9 147.3l-9.4 49.4h-97.6c-3.8 0-7.1 2.7-7.8 6.4L181.9 415a8.07 8.07 0 007.8 9.7H284l-89 429.9a8.07 8.07 0 007.8 9.7H269c3.8 0 7.1-2.7 7.8-6.4l89.7-433.1h135.8l68.2 139.1c1.4 2.9 1 6.4-1.2 8.8l-180.6 203c-2.9 3.3-2.6 8.4.7 11.3 1.5 1.3 3.4 2 5.3 2h72.7c2.4 0 4.6-1 6.1-2.8l123.7-146.7c2.8-3.4 7.9-3.8 11.3-1 .9.8 1.6 1.7 2.1 2.8L676.4 784c1.3 2.8 4.1 4.7 7.3 4.7h64.6a8.02 8.02 0 007.2-11.5l-95.2-198.9c-1.4-2.9-.9-6.4 1.3-8.8L841 370z" } }] }, "name": "function", "theme": "outlined" };
  exports.default = FunctionOutlined;
  });

  var FunctionOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FunctionOutlined_1);

  var FunctionOutlined = function FunctionOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FunctionOutlinedSvg
    }));
  };
  var RefIcon$5H = /*#__PURE__*/React.forwardRef(FunctionOutlined);
  {
    RefIcon$5H.displayName = 'FunctionOutlined';
  }

  var FundFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FundFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M926 164H94c-17.7 0-32 14.3-32 32v640c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V196c0-17.7-14.3-32-32-32zm-92.3 194.4l-297 297.2a8.03 8.03 0 01-11.3 0L410.9 541.1 238.4 713.7a8.03 8.03 0 01-11.3 0l-36.8-36.8a8.03 8.03 0 010-11.3l214.9-215c3.1-3.1 8.2-3.1 11.3 0L531 565l254.5-254.6c3.1-3.1 8.2-3.1 11.3 0l36.8 36.8c3.2 3 3.2 8.1.1 11.2z" } }] }, "name": "fund", "theme": "filled" };
  exports.default = FundFilled;
  });

  var FundFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(FundFilled_1);

  var FundFilled = function FundFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FundFilledSvg
    }));
  };
  var RefIcon$5I = /*#__PURE__*/React.forwardRef(FundFilled);
  {
    RefIcon$5I.displayName = 'FundFilled';
  }

  var FundOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FundOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M926 164H94c-17.7 0-32 14.3-32 32v640c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V196c0-17.7-14.3-32-32-32zm-40 632H134V236h752v560zm-658.9-82.3c3.1 3.1 8.2 3.1 11.3 0l172.5-172.5 114.4 114.5c3.1 3.1 8.2 3.1 11.3 0l297-297.2c3.1-3.1 3.1-8.2 0-11.3l-36.8-36.8a8.03 8.03 0 00-11.3 0L531 565 416.6 450.5a8.03 8.03 0 00-11.3 0l-214.9 215a8.03 8.03 0 000 11.3l36.7 36.9z" } }] }, "name": "fund", "theme": "outlined" };
  exports.default = FundOutlined;
  });

  var FundOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FundOutlined_1);

  var FundOutlined = function FundOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FundOutlinedSvg
    }));
  };
  var RefIcon$5J = /*#__PURE__*/React.forwardRef(FundOutlined);
  {
    RefIcon$5J.displayName = 'FundOutlined';
  }

  var FundProjectionScreenOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FundProjectionScreenOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M312.1 591.5c3.1 3.1 8.2 3.1 11.3 0l101.8-101.8 86.1 86.2c3.1 3.1 8.2 3.1 11.3 0l226.3-226.5c3.1-3.1 3.1-8.2 0-11.3l-36.8-36.8a8.03 8.03 0 00-11.3 0L517 485.3l-86.1-86.2a8.03 8.03 0 00-11.3 0L275.3 543.4a8.03 8.03 0 000 11.3l36.8 36.8z" } }, { "tag": "path", "attrs": { "d": "M904 160H548V96c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v64H120c-17.7 0-32 14.3-32 32v520c0 17.7 14.3 32 32 32h356.4v32L311.6 884.1a7.92 7.92 0 00-2.3 11l30.3 47.2v.1c2.4 3.7 7.4 4.7 11.1 2.3L512 838.9l161.3 105.8c3.7 2.4 8.7 1.4 11.1-2.3v-.1l30.3-47.2a8 8 0 00-2.3-11L548 776.3V744h356c17.7 0 32-14.3 32-32V192c0-17.7-14.3-32-32-32zm-40 512H160V232h704v440z" } }] }, "name": "fund-projection-screen", "theme": "outlined" };
  exports.default = FundProjectionScreenOutlined;
  });

  var FundProjectionScreenOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FundProjectionScreenOutlined_1);

  var FundProjectionScreenOutlined = function FundProjectionScreenOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FundProjectionScreenOutlinedSvg
    }));
  };
  var RefIcon$5K = /*#__PURE__*/React.forwardRef(FundProjectionScreenOutlined);
  {
    RefIcon$5K.displayName = 'FundProjectionScreenOutlined';
  }

  var FundTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FundTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M928 160H96c-17.7 0-32 14.3-32 32v640c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V192c0-17.7-14.3-32-32-32zm-40 632H136V232h752v560z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M136 792h752V232H136v560zm56.4-130.5l214.9-215c3.1-3.1 8.2-3.1 11.3 0L533 561l254.5-254.6c3.1-3.1 8.2-3.1 11.3 0l36.8 36.8c3.1 3.1 3.1 8.2 0 11.3l-297 297.2a8.03 8.03 0 01-11.3 0L412.9 537.2 240.4 709.7a8.03 8.03 0 01-11.3 0l-36.7-36.9a8.03 8.03 0 010-11.3z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M229.1 709.7c3.1 3.1 8.2 3.1 11.3 0l172.5-172.5 114.4 114.5c3.1 3.1 8.2 3.1 11.3 0l297-297.2c3.1-3.1 3.1-8.2 0-11.3l-36.8-36.8a8.03 8.03 0 00-11.3 0L533 561 418.6 446.5a8.03 8.03 0 00-11.3 0l-214.9 215a8.03 8.03 0 000 11.3l36.7 36.9z", "fill": primaryColor } }] }; }, "name": "fund", "theme": "twotone" };
  exports.default = FundTwoTone;
  });

  var FundTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(FundTwoTone_1);

  var FundTwoTone = function FundTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FundTwoToneSvg
    }));
  };
  var RefIcon$5L = /*#__PURE__*/React.forwardRef(FundTwoTone);
  {
    RefIcon$5L.displayName = 'FundTwoTone';
  }

  var FundViewOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FundViewOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M956 686.5l-.1-.1-.1-.1C911.7 593 843.4 545 752.5 545s-159.2 48.1-203.4 141.3v.1a42.92 42.92 0 000 36.4C593.3 816 661.6 864 752.5 864s159.2-48.1 203.4-141.3c5.4-11.5 5.4-24.8.1-36.2zM752.5 800c-62.1 0-107.4-30-141.1-95.5C645 639 690.4 609 752.5 609c62.1 0 107.4 30 141.1 95.5C860 770 814.6 800 752.5 800z" } }, { "tag": "path", "attrs": { "d": "M697 705a56 56 0 10112 0 56 56 0 10-112 0zM136 232h704v253h72V192c0-17.7-14.3-32-32-32H96c-17.7 0-32 14.3-32 32v520c0 17.7 14.3 32 32 32h352v-72H136V232z" } }, { "tag": "path", "attrs": { "d": "M724.9 338.1l-36.8-36.8a8.03 8.03 0 00-11.3 0L493 485.3l-86.1-86.2a8.03 8.03 0 00-11.3 0L251.3 543.4a8.03 8.03 0 000 11.3l36.8 36.8c3.1 3.1 8.2 3.1 11.3 0l101.8-101.8 86.1 86.2c3.1 3.1 8.2 3.1 11.3 0l226.3-226.5c3.2-3.1 3.2-8.2 0-11.3z" } }] }, "name": "fund-view", "theme": "outlined" };
  exports.default = FundViewOutlined;
  });

  var FundViewOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FundViewOutlined_1);

  var FundViewOutlined = function FundViewOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FundViewOutlinedSvg
    }));
  };
  var RefIcon$5M = /*#__PURE__*/React.forwardRef(FundViewOutlined);
  {
    RefIcon$5M.displayName = 'FundViewOutlined';
  }

  var FunnelPlotFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FunnelPlotFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M336.7 586h350.6l84.9-148H251.8zm543.4-432H143.9c-24.5 0-39.8 26.7-27.5 48L215 374h594l98.7-172c12.2-21.3-3.1-48-27.6-48zM349 838c0 17.7 14.2 32 31.8 32h262.4c17.6 0 31.8-14.3 31.8-32V650H349v188z" } }] }, "name": "funnel-plot", "theme": "filled" };
  exports.default = FunnelPlotFilled;
  });

  var FunnelPlotFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(FunnelPlotFilled_1);

  var FunnelPlotFilled = function FunnelPlotFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FunnelPlotFilledSvg
    }));
  };
  var RefIcon$5N = /*#__PURE__*/React.forwardRef(FunnelPlotFilled);
  {
    RefIcon$5N.displayName = 'FunnelPlotFilled';
  }

  var FunnelPlotOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FunnelPlotOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880.1 154H143.9c-24.5 0-39.8 26.7-27.5 48L349 607.4V838c0 17.7 14.2 32 31.8 32h262.4c17.6 0 31.8-14.3 31.8-32V607.4L907.7 202c12.2-21.3-3.1-48-27.6-48zM603.4 798H420.6V650h182.9v148zm9.6-226.6l-8.4 14.6H419.3l-8.4-14.6L334.4 438h355.2L613 571.4zM726.3 374H297.7l-85-148h598.6l-85 148z" } }] }, "name": "funnel-plot", "theme": "outlined" };
  exports.default = FunnelPlotOutlined;
  });

  var FunnelPlotOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(FunnelPlotOutlined_1);

  var FunnelPlotOutlined = function FunnelPlotOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FunnelPlotOutlinedSvg
    }));
  };
  var RefIcon$5O = /*#__PURE__*/React.forwardRef(FunnelPlotOutlined);
  {
    RefIcon$5O.displayName = 'FunnelPlotOutlined';
  }

  var FunnelPlotTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var FunnelPlotTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M420.6 798h182.9V650H420.6zM297.7 374h428.6l85-148H212.7zm113.2 197.4l8.4 14.6h185.3l8.4-14.6L689.6 438H334.4z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M880.1 154H143.9c-24.5 0-39.8 26.7-27.5 48L349 607.4V838c0 17.7 14.2 32 31.8 32h262.4c17.6 0 31.8-14.3 31.8-32V607.4L907.7 202c12.2-21.3-3.1-48-27.6-48zM603.5 798H420.6V650h182.9v148zm9.5-226.6l-8.4 14.6H419.3l-8.4-14.6L334.4 438h355.2L613 571.4zM726.3 374H297.7l-85-148h598.6l-85 148z", "fill": primaryColor } }] }; }, "name": "funnel-plot", "theme": "twotone" };
  exports.default = FunnelPlotTwoTone;
  });

  var FunnelPlotTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(FunnelPlotTwoTone_1);

  var FunnelPlotTwoTone = function FunnelPlotTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: FunnelPlotTwoToneSvg
    }));
  };
  var RefIcon$5P = /*#__PURE__*/React.forwardRef(FunnelPlotTwoTone);
  {
    RefIcon$5P.displayName = 'FunnelPlotTwoTone';
  }

  var GatewayOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var GatewayOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M928 392c8.8 0 16-7.2 16-16V192c0-8.8-7.2-16-16-16H744c-8.8 0-16 7.2-16 16v56H296v-56c0-8.8-7.2-16-16-16H96c-8.8 0-16 7.2-16 16v184c0 8.8 7.2 16 16 16h56v240H96c-8.8 0-16 7.2-16 16v184c0 8.8 7.2 16 16 16h184c8.8 0 16-7.2 16-16v-56h432v56c0 8.8 7.2 16 16 16h184c8.8 0 16-7.2 16-16V648c0-8.8-7.2-16-16-16h-56V392h56zM792 240h88v88h-88v-88zm-648 88v-88h88v88h-88zm88 456h-88v-88h88v88zm648-88v88h-88v-88h88zm-80-64h-56c-8.8 0-16 7.2-16 16v56H296v-56c0-8.8-7.2-16-16-16h-56V392h56c8.8 0 16-7.2 16-16v-56h432v56c0 8.8 7.2 16 16 16h56v240z" } }] }, "name": "gateway", "theme": "outlined" };
  exports.default = GatewayOutlined;
  });

  var GatewayOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(GatewayOutlined_1);

  var GatewayOutlined = function GatewayOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: GatewayOutlinedSvg
    }));
  };
  var RefIcon$5Q = /*#__PURE__*/React.forwardRef(GatewayOutlined);
  {
    RefIcon$5Q.displayName = 'GatewayOutlined';
  }

  var GifOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var GifOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M944 299H692c-4.4 0-8 3.6-8 8v406c0 4.4 3.6 8 8 8h59.2c4.4 0 8-3.6 8-8V549.9h168.2c4.4 0 8-3.6 8-8V495c0-4.4-3.6-8-8-8H759.2V364.2H944c4.4 0 8-3.6 8-8V307c0-4.4-3.6-8-8-8zm-356 1h-56c-4.4 0-8 3.6-8 8v406c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V308c0-4.4-3.6-8-8-8zM452 500.9H290.5c-4.4 0-8 3.6-8 8v43.7c0 4.4 3.6 8 8 8h94.9l-.3 8.9c-1.2 58.8-45.6 98.5-110.9 98.5-76.2 0-123.9-59.7-123.9-156.7 0-95.8 46.8-155.2 121.5-155.2 54.8 0 93.1 26.9 108.5 75.4h76.2c-13.6-87.2-86-143.4-184.7-143.4C150 288 72 375.2 72 511.9 72 650.2 149.1 736 273 736c114.1 0 187-70.7 187-181.6v-45.5c0-4.4-3.6-8-8-8z" } }] }, "name": "gif", "theme": "outlined" };
  exports.default = GifOutlined;
  });

  var GifOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(GifOutlined_1);

  var GifOutlined = function GifOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: GifOutlinedSvg
    }));
  };
  var RefIcon$5R = /*#__PURE__*/React.forwardRef(GifOutlined);
  {
    RefIcon$5R.displayName = 'GifOutlined';
  }

  var GiftFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var GiftFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M160 894c0 17.7 14.3 32 32 32h286V550H160v344zm386 32h286c17.7 0 32-14.3 32-32V550H546v376zm334-616H732.4c13.6-21.4 21.6-46.8 21.6-74 0-76.1-61.9-138-138-138-41.4 0-78.7 18.4-104 47.4-25.3-29-62.6-47.4-104-47.4-76.1 0-138 61.9-138 138 0 27.2 7.9 52.6 21.6 74H144c-17.7 0-32 14.3-32 32v140h366V310h68v172h366V342c0-17.7-14.3-32-32-32zm-402-4h-70c-38.6 0-70-31.4-70-70s31.4-70 70-70 70 31.4 70 70v70zm138 0h-70v-70c0-38.6 31.4-70 70-70s70 31.4 70 70-31.4 70-70 70z" } }] }, "name": "gift", "theme": "filled" };
  exports.default = GiftFilled;
  });

  var GiftFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(GiftFilled_1);

  var GiftFilled = function GiftFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: GiftFilledSvg
    }));
  };
  var RefIcon$5S = /*#__PURE__*/React.forwardRef(GiftFilled);
  {
    RefIcon$5S.displayName = 'GiftFilled';
  }

  var GiftOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var GiftOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 310H732.4c13.6-21.4 21.6-46.8 21.6-74 0-76.1-61.9-138-138-138-41.4 0-78.7 18.4-104 47.4-25.3-29-62.6-47.4-104-47.4-76.1 0-138 61.9-138 138 0 27.2 7.9 52.6 21.6 74H144c-17.7 0-32 14.3-32 32v200c0 4.4 3.6 8 8 8h40v344c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V550h40c4.4 0 8-3.6 8-8V342c0-17.7-14.3-32-32-32zm-334-74c0-38.6 31.4-70 70-70s70 31.4 70 70-31.4 70-70 70h-70v-70zm-138-70c38.6 0 70 31.4 70 70v70h-70c-38.6 0-70-31.4-70-70s31.4-70 70-70zM180 482V378h298v104H180zm48 68h250v308H228V550zm568 308H546V550h250v308zm48-376H546V378h298v104z" } }] }, "name": "gift", "theme": "outlined" };
  exports.default = GiftOutlined;
  });

  var GiftOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(GiftOutlined_1);

  var GiftOutlined = function GiftOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: GiftOutlinedSvg
    }));
  };
  var RefIcon$5T = /*#__PURE__*/React.forwardRef(GiftOutlined);
  {
    RefIcon$5T.displayName = 'GiftOutlined';
  }

  var GiftTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var GiftTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M546 378h298v104H546zM228 550h250v308H228zm-48-172h298v104H180zm366 172h250v308H546z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M880 310H732.4c13.6-21.4 21.6-46.8 21.6-74 0-76.1-61.9-138-138-138-41.4 0-78.7 18.4-104 47.4-25.3-29-62.6-47.4-104-47.4-76.1 0-138 61.9-138 138 0 27.2 7.9 52.6 21.6 74H144c-17.7 0-32 14.3-32 32v200c0 4.4 3.6 8 8 8h40v344c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V550h40c4.4 0 8-3.6 8-8V342c0-17.7-14.3-32-32-32zM478 858H228V550h250v308zm0-376H180V378h298v104zm0-176h-70c-38.6 0-70-31.4-70-70s31.4-70 70-70 70 31.4 70 70v70zm68-70c0-38.6 31.4-70 70-70s70 31.4 70 70-31.4 70-70 70h-70v-70zm250 622H546V550h250v308zm48-376H546V378h298v104z", "fill": primaryColor } }] }; }, "name": "gift", "theme": "twotone" };
  exports.default = GiftTwoTone;
  });

  var GiftTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(GiftTwoTone_1);

  var GiftTwoTone = function GiftTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: GiftTwoToneSvg
    }));
  };
  var RefIcon$5U = /*#__PURE__*/React.forwardRef(GiftTwoTone);
  {
    RefIcon$5U.displayName = 'GiftTwoTone';
  }

  var GithubFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var GithubFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M511.6 76.3C264.3 76.2 64 276.4 64 523.5 64 718.9 189.3 885 363.8 946c23.5 5.9 19.9-10.8 19.9-22.2v-77.5c-135.7 15.9-141.2-73.9-150.3-88.9C215 726 171.5 718 184.5 703c30.9-15.9 62.4 4 98.9 57.9 26.4 39.1 77.9 32.5 104 26 5.7-23.5 17.9-44.5 34.7-60.8-140.6-25.2-199.2-111-199.2-213 0-49.5 16.3-95 48.3-131.7-20.4-60.5 1.9-112.3 4.9-120 58.1-5.2 118.5 41.6 123.2 45.3 33-8.9 70.7-13.6 112.9-13.6 42.4 0 80.2 4.9 113.5 13.9 11.3-8.6 67.3-48.8 121.3-43.9 2.9 7.7 24.7 58.3 5.5 118 32.4 36.8 48.9 82.7 48.9 132.3 0 102.2-59 188.1-200 212.9a127.5 127.5 0 0138.1 91v112.5c.8 9 0 17.9 15 17.9 177.1-59.7 304.6-227 304.6-424.1 0-247.2-200.4-447.3-447.5-447.3z" } }] }, "name": "github", "theme": "filled" };
  exports.default = GithubFilled;
  });

  var GithubFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(GithubFilled_1);

  var GithubFilled = function GithubFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: GithubFilledSvg
    }));
  };
  var RefIcon$5V = /*#__PURE__*/React.forwardRef(GithubFilled);
  {
    RefIcon$5V.displayName = 'GithubFilled';
  }

  var GithubOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var GithubOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M511.6 76.3C264.3 76.2 64 276.4 64 523.5 64 718.9 189.3 885 363.8 946c23.5 5.9 19.9-10.8 19.9-22.2v-77.5c-135.7 15.9-141.2-73.9-150.3-88.9C215 726 171.5 718 184.5 703c30.9-15.9 62.4 4 98.9 57.9 26.4 39.1 77.9 32.5 104 26 5.7-23.5 17.9-44.5 34.7-60.8-140.6-25.2-199.2-111-199.2-213 0-49.5 16.3-95 48.3-131.7-20.4-60.5 1.9-112.3 4.9-120 58.1-5.2 118.5 41.6 123.2 45.3 33-8.9 70.7-13.6 112.9-13.6 42.4 0 80.2 4.9 113.5 13.9 11.3-8.6 67.3-48.8 121.3-43.9 2.9 7.7 24.7 58.3 5.5 118 32.4 36.8 48.9 82.7 48.9 132.3 0 102.2-59 188.1-200 212.9a127.5 127.5 0 0138.1 91v112.5c.8 9 0 17.9 15 17.9 177.1-59.7 304.6-227 304.6-424.1 0-247.2-200.4-447.3-447.5-447.3z" } }] }, "name": "github", "theme": "outlined" };
  exports.default = GithubOutlined;
  });

  var GithubOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(GithubOutlined_1);

  var GithubOutlined = function GithubOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: GithubOutlinedSvg
    }));
  };
  var RefIcon$5W = /*#__PURE__*/React.forwardRef(GithubOutlined);
  {
    RefIcon$5W.displayName = 'GithubOutlined';
  }

  var GitlabFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var GitlabFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M910.5 553.2l-109-370.8c-6.8-20.4-23.1-34.1-44.9-34.1s-39.5 12.3-46.3 32.7l-72.2 215.4H386.2L314 181.1c-6.8-20.4-24.5-32.7-46.3-32.7s-39.5 13.6-44.9 34.1L113.9 553.2c-4.1 13.6 1.4 28.6 12.3 36.8l385.4 289 386.7-289c10.8-8.1 16.3-23.1 12.2-36.8z" } }] }, "name": "gitlab", "theme": "filled" };
  exports.default = GitlabFilled;
  });

  var GitlabFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(GitlabFilled_1);

  var GitlabFilled = function GitlabFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: GitlabFilledSvg
    }));
  };
  var RefIcon$5X = /*#__PURE__*/React.forwardRef(GitlabFilled);
  {
    RefIcon$5X.displayName = 'GitlabFilled';
  }

  var GitlabOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var GitlabOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M913.9 552.2L805 181.4v-.1c-7.6-22.9-25.7-36.5-48.3-36.5-23.4 0-42.5 13.5-49.7 35.2l-71.4 213H388.8l-71.4-213c-7.2-21.7-26.3-35.2-49.7-35.2-23.1 0-42.5 14.8-48.4 36.6L110.5 552.2c-4.4 14.7 1.2 31.4 13.5 40.7l368.5 276.4c2.6 3.6 6.2 6.3 10.4 7.8l8.6 6.4 8.5-6.4c4.9-1.7 9-4.7 11.9-8.9l368.4-275.4c12.4-9.2 18-25.9 13.6-40.6zM751.7 193.4c1-1.8 2.9-1.9 3.5-1.9 1.1 0 2.5.3 3.4 3L818 394.3H684.5l67.2-200.9zm-487.4 1c.9-2.6 2.3-2.9 3.4-2.9 2.7 0 2.9.1 3.4 1.7l67.3 201.2H206.5l57.8-200zM158.8 558.7l28.2-97.3 202.4 270.2-230.6-172.9zm73.9-116.4h122.1l90.8 284.3-212.9-284.3zM512.9 776L405.7 442.3H620L512.9 776zm157.9-333.7h119.5L580 723.1l90.8-280.8zm-40.7 293.9l207.3-276.7 29.5 99.2-236.8 177.5z" } }] }, "name": "gitlab", "theme": "outlined" };
  exports.default = GitlabOutlined;
  });

  var GitlabOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(GitlabOutlined_1);

  var GitlabOutlined = function GitlabOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: GitlabOutlinedSvg
    }));
  };
  var RefIcon$5Y = /*#__PURE__*/React.forwardRef(GitlabOutlined);
  {
    RefIcon$5Y.displayName = 'GitlabOutlined';
  }

  var GlobalOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var GlobalOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.4 800.9c.2-.3.5-.6.7-.9C920.6 722.1 960 621.7 960 512s-39.4-210.1-104.8-288c-.2-.3-.5-.5-.7-.8-1.1-1.3-2.1-2.5-3.2-3.7-.4-.5-.8-.9-1.2-1.4l-4.1-4.7-.1-.1c-1.5-1.7-3.1-3.4-4.6-5.1l-.1-.1c-3.2-3.4-6.4-6.8-9.7-10.1l-.1-.1-4.8-4.8-.3-.3c-1.5-1.5-3-2.9-4.5-4.3-.5-.5-1-1-1.6-1.5-1-1-2-1.9-3-2.8-.3-.3-.7-.6-1-1C736.4 109.2 629.5 64 512 64s-224.4 45.2-304.3 119.2c-.3.3-.7.6-1 1-1 .9-2 1.9-3 2.9-.5.5-1 1-1.6 1.5-1.5 1.4-3 2.9-4.5 4.3l-.3.3-4.8 4.8-.1.1c-3.3 3.3-6.5 6.7-9.7 10.1l-.1.1c-1.6 1.7-3.1 3.4-4.6 5.1l-.1.1c-1.4 1.5-2.8 3.1-4.1 4.7-.4.5-.8.9-1.2 1.4-1.1 1.2-2.1 2.5-3.2 3.7-.2.3-.5.5-.7.8C103.4 301.9 64 402.3 64 512s39.4 210.1 104.8 288c.2.3.5.6.7.9l3.1 3.7c.4.5.8.9 1.2 1.4l4.1 4.7c0 .1.1.1.1.2 1.5 1.7 3 3.4 4.6 5l.1.1c3.2 3.4 6.4 6.8 9.6 10.1l.1.1c1.6 1.6 3.1 3.2 4.7 4.7l.3.3c3.3 3.3 6.7 6.5 10.1 9.6 80.1 74 187 119.2 304.5 119.2s224.4-45.2 304.3-119.2a300 300 0 0010-9.6l.3-.3c1.6-1.6 3.2-3.1 4.7-4.7l.1-.1c3.3-3.3 6.5-6.7 9.6-10.1l.1-.1c1.5-1.7 3.1-3.3 4.6-5 0-.1.1-.1.1-.2 1.4-1.5 2.8-3.1 4.1-4.7.4-.5.8-.9 1.2-1.4a99 99 0 003.3-3.7zm4.1-142.6c-13.8 32.6-32 62.8-54.2 90.2a444.07 444.07 0 00-81.5-55.9c11.6-46.9 18.8-98.4 20.7-152.6H887c-3 40.9-12.6 80.6-28.5 118.3zM887 484H743.5c-1.9-54.2-9.1-105.7-20.7-152.6 29.3-15.6 56.6-34.4 81.5-55.9A373.86 373.86 0 01887 484zM658.3 165.5c39.7 16.8 75.8 40 107.6 69.2a394.72 394.72 0 01-59.4 41.8c-15.7-45-35.8-84.1-59.2-115.4 3.7 1.4 7.4 2.9 11 4.4zm-90.6 700.6c-9.2 7.2-18.4 12.7-27.7 16.4V697a389.1 389.1 0 01115.7 26.2c-8.3 24.6-17.9 47.3-29 67.8-17.4 32.4-37.8 58.3-59 75.1zm59-633.1c11 20.6 20.7 43.3 29 67.8A389.1 389.1 0 01540 327V141.6c9.2 3.7 18.5 9.1 27.7 16.4 21.2 16.7 41.6 42.6 59 75zM540 640.9V540h147.5c-1.6 44.2-7.1 87.1-16.3 127.8l-.3 1.2A445.02 445.02 0 00540 640.9zm0-156.9V383.1c45.8-2.8 89.8-12.5 130.9-28.1l.3 1.2c9.2 40.7 14.7 83.5 16.3 127.8H540zm-56 56v100.9c-45.8 2.8-89.8 12.5-130.9 28.1l-.3-1.2c-9.2-40.7-14.7-83.5-16.3-127.8H484zm-147.5-56c1.6-44.2 7.1-87.1 16.3-127.8l.3-1.2c41.1 15.6 85 25.3 130.9 28.1V484H336.5zM484 697v185.4c-9.2-3.7-18.5-9.1-27.7-16.4-21.2-16.7-41.7-42.7-59.1-75.1-11-20.6-20.7-43.3-29-67.8 37.2-14.6 75.9-23.3 115.8-26.1zm0-370a389.1 389.1 0 01-115.7-26.2c8.3-24.6 17.9-47.3 29-67.8 17.4-32.4 37.8-58.4 59.1-75.1 9.2-7.2 18.4-12.7 27.7-16.4V327zM365.7 165.5c3.7-1.5 7.3-3 11-4.4-23.4 31.3-43.5 70.4-59.2 115.4-21-12-40.9-26-59.4-41.8 31.8-29.2 67.9-52.4 107.6-69.2zM165.5 365.7c13.8-32.6 32-62.8 54.2-90.2 24.9 21.5 52.2 40.3 81.5 55.9-11.6 46.9-18.8 98.4-20.7 152.6H137c3-40.9 12.6-80.6 28.5-118.3zM137 540h143.5c1.9 54.2 9.1 105.7 20.7 152.6a444.07 444.07 0 00-81.5 55.9A373.86 373.86 0 01137 540zm228.7 318.5c-39.7-16.8-75.8-40-107.6-69.2 18.5-15.8 38.4-29.7 59.4-41.8 15.7 45 35.8 84.1 59.2 115.4-3.7-1.4-7.4-2.9-11-4.4zm292.6 0c-3.7 1.5-7.3 3-11 4.4 23.4-31.3 43.5-70.4 59.2-115.4 21 12 40.9 26 59.4 41.8a373.81 373.81 0 01-107.6 69.2z" } }] }, "name": "global", "theme": "outlined" };
  exports.default = GlobalOutlined;
  });

  var GlobalOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(GlobalOutlined_1);

  var GlobalOutlined = function GlobalOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: GlobalOutlinedSvg
    }));
  };
  var RefIcon$5Z = /*#__PURE__*/React.forwardRef(GlobalOutlined);
  {
    RefIcon$5Z.displayName = 'GlobalOutlined';
  }

  var GoldFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var GoldFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M905.9 806.7l-40.2-248c-.6-3.9-4-6.7-7.9-6.7H596.2c-3.9 0-7.3 2.8-7.9 6.7l-40.2 248c-.1.4-.1.9-.1 1.3 0 4.4 3.6 8 8 8h342c.4 0 .9 0 1.3-.1 4.3-.7 7.3-4.8 6.6-9.2zm-470.2-248c-.6-3.9-4-6.7-7.9-6.7H166.2c-3.9 0-7.3 2.8-7.9 6.7l-40.2 248c-.1.4-.1.9-.1 1.3 0 4.4 3.6 8 8 8h342c.4 0 .9 0 1.3-.1 4.4-.7 7.3-4.8 6.6-9.2l-40.2-248zM342 472h342c.4 0 .9 0 1.3-.1 4.4-.7 7.3-4.8 6.6-9.2l-40.2-248c-.6-3.9-4-6.7-7.9-6.7H382.2c-3.9 0-7.3 2.8-7.9 6.7l-40.2 248c-.1.4-.1.9-.1 1.3 0 4.4 3.6 8 8 8z" } }] }, "name": "gold", "theme": "filled" };
  exports.default = GoldFilled;
  });

  var GoldFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(GoldFilled_1);

  var GoldFilled = function GoldFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: GoldFilledSvg
    }));
  };
  var RefIcon$5_ = /*#__PURE__*/React.forwardRef(GoldFilled);
  {
    RefIcon$5_.displayName = 'GoldFilled';
  }

  var GoldOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var GoldOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M342 472h342c.4 0 .9 0 1.3-.1 4.4-.7 7.3-4.8 6.6-9.2l-40.2-248c-.6-3.9-4-6.7-7.9-6.7H382.2c-3.9 0-7.3 2.8-7.9 6.7l-40.2 248c-.1.4-.1.9-.1 1.3 0 4.4 3.6 8 8 8zm91.2-196h159.5l20.7 128h-201l20.8-128zm2.5 282.7c-.6-3.9-4-6.7-7.9-6.7H166.2c-3.9 0-7.3 2.8-7.9 6.7l-40.2 248c-.1.4-.1.9-.1 1.3 0 4.4 3.6 8 8 8h342c.4 0 .9 0 1.3-.1 4.4-.7 7.3-4.8 6.6-9.2l-40.2-248zM196.5 748l20.7-128h159.5l20.7 128H196.5zm709.4 58.7l-40.2-248c-.6-3.9-4-6.7-7.9-6.7H596.2c-3.9 0-7.3 2.8-7.9 6.7l-40.2 248c-.1.4-.1.9-.1 1.3 0 4.4 3.6 8 8 8h342c.4 0 .9 0 1.3-.1 4.3-.7 7.3-4.8 6.6-9.2zM626.5 748l20.7-128h159.5l20.7 128H626.5z" } }] }, "name": "gold", "theme": "outlined" };
  exports.default = GoldOutlined;
  });

  var GoldOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(GoldOutlined_1);

  var GoldOutlined = function GoldOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: GoldOutlinedSvg
    }));
  };
  var RefIcon$5$ = /*#__PURE__*/React.forwardRef(GoldOutlined);
  {
    RefIcon$5$.displayName = 'GoldOutlined';
  }

  var GoldTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var GoldTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M435.7 558.7c-.6-3.9-4-6.7-7.9-6.7H166.2c-3.9 0-7.3 2.8-7.9 6.7l-40.2 248c-.1.4-.1.9-.1 1.3 0 4.4 3.6 8 8 8h342c.4 0 .9 0 1.3-.1 4.4-.7 7.3-4.8 6.6-9.2l-40.2-248zM196.5 748l20.7-128h159.5l20.7 128H196.5zm709.4 58.7l-40.2-248c-.6-3.9-4-6.7-7.9-6.7H596.2c-3.9 0-7.3 2.8-7.9 6.7l-40.2 248c-.1.4-.1.9-.1 1.3 0 4.4 3.6 8 8 8h342c.4 0 .9 0 1.3-.1 4.3-.7 7.3-4.8 6.6-9.2zM626.5 748l20.7-128h159.5l20.7 128H626.5zM342 472h342c.4 0 .9 0 1.3-.1 4.4-.7 7.3-4.8 6.6-9.2l-40.2-248c-.6-3.9-4-6.7-7.9-6.7H382.2c-3.9 0-7.3 2.8-7.9 6.7l-40.2 248c-.1.4-.1.9-.1 1.3 0 4.4 3.6 8 8 8zm91.2-196h159.5l20.7 128h-201l20.8-128z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M592.7 276H433.2l-20.8 128h201zM217.2 620l-20.7 128h200.9l-20.7-128zm430 0l-20.7 128h200.9l-20.7-128z", "fill": secondaryColor } }] }; }, "name": "gold", "theme": "twotone" };
  exports.default = GoldTwoTone;
  });

  var GoldTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(GoldTwoTone_1);

  var GoldTwoTone = function GoldTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: GoldTwoToneSvg
    }));
  };
  var RefIcon$60 = /*#__PURE__*/React.forwardRef(GoldTwoTone);
  {
    RefIcon$60.displayName = 'GoldTwoTone';
  }

  var GoldenFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var GoldenFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M905.9 806.7l-40.2-248c-.6-3.9-4-6.7-7.9-6.7H596.2c-3.9 0-7.3 2.8-7.9 6.7l-40.2 248c-.1.4-.1.9-.1 1.3 0 4.4 3.6 8 8 8h342c.4 0 .9 0 1.3-.1 4.3-.7 7.3-4.8 6.6-9.2zm-470.2-248c-.6-3.9-4-6.7-7.9-6.7H166.2c-3.9 0-7.3 2.8-7.9 6.7l-40.2 248c-.1.4-.1.9-.1 1.3 0 4.4 3.6 8 8 8h342c.4 0 .9 0 1.3-.1 4.4-.7 7.3-4.8 6.6-9.2l-40.2-248zM342 472h342c.4 0 .9 0 1.3-.1 4.4-.7 7.3-4.8 6.6-9.2l-40.2-248c-.6-3.9-4-6.7-7.9-6.7H382.2c-3.9 0-7.3 2.8-7.9 6.7l-40.2 248c-.1.4-.1.9-.1 1.3 0 4.4 3.6 8 8 8z" } }] }, "name": "golden", "theme": "filled" };
  exports.default = GoldenFilled;
  });

  var GoldenFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(GoldenFilled_1);

  var GoldenFilled = function GoldenFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: GoldenFilledSvg
    }));
  };
  var RefIcon$61 = /*#__PURE__*/React.forwardRef(GoldenFilled);
  {
    RefIcon$61.displayName = 'GoldenFilled';
  }

  var GoogleCircleFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var GoogleCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm167 633.6C638.4 735 583 757 516.9 757c-95.7 0-178.5-54.9-218.8-134.9C281.5 589 272 551.6 272 512s9.5-77 26.1-110.1c40.3-80.1 123.1-135 218.8-135 66 0 121.4 24.3 163.9 63.8L610.6 401c-25.4-24.3-57.7-36.6-93.6-36.6-63.8 0-117.8 43.1-137.1 101-4.9 14.7-7.7 30.4-7.7 46.6s2.8 31.9 7.7 46.6c19.3 57.9 73.3 101 137 101 33 0 61-8.7 82.9-23.4 26-17.4 43.2-43.3 48.9-74H516.9v-94.8h230.7c2.9 16.1 4.4 32.8 4.4 50.1 0 74.7-26.7 137.4-73 180.1z" } }] }, "name": "google-circle", "theme": "filled" };
  exports.default = GoogleCircleFilled;
  });

  var GoogleCircleFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(GoogleCircleFilled_1);

  var GoogleCircleFilled = function GoogleCircleFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: GoogleCircleFilledSvg
    }));
  };
  var RefIcon$62 = /*#__PURE__*/React.forwardRef(GoogleCircleFilled);
  {
    RefIcon$62.displayName = 'GoogleCircleFilled';
  }

  var GoogleOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var GoogleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M881 442.4H519.7v148.5h206.4c-8.9 48-35.9 88.6-76.6 115.8-34.4 23-78.3 36.6-129.9 36.6-99.9 0-184.4-67.5-214.6-158.2-7.6-23-12-47.6-12-72.9s4.4-49.9 12-72.9c30.3-90.6 114.8-158.1 214.7-158.1 56.3 0 106.8 19.4 146.6 57.4l110-110.1c-66.5-62-153.2-100-256.6-100-149.9 0-279.6 86-342.7 211.4-26 51.8-40.8 110.4-40.8 172.4S151 632.8 177 684.6C240.1 810 369.8 896 519.7 896c103.6 0 190.4-34.4 253.8-93 72.5-66.8 114.4-165.2 114.4-282.1 0-27.2-2.4-53.3-6.9-78.5z" } }] }, "name": "google", "theme": "outlined" };
  exports.default = GoogleOutlined;
  });

  var GoogleOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(GoogleOutlined_1);

  var GoogleOutlined = function GoogleOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: GoogleOutlinedSvg
    }));
  };
  var RefIcon$63 = /*#__PURE__*/React.forwardRef(GoogleOutlined);
  {
    RefIcon$63.displayName = 'GoogleOutlined';
  }

  var GooglePlusCircleFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var GooglePlusCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm36.5 558.8c-43.9 61.8-132.1 79.8-200.9 53.3-69-26.3-118-99.2-112.1-173.5 1.5-90.9 85.2-170.6 176.1-167.5 43.6-2 84.6 16.9 118 43.6-14.3 16.2-29 31.8-44.8 46.3-40.1-27.7-97.2-35.6-137.3-3.6-57.4 39.7-60 133.4-4.8 176.1 53.7 48.7 155.2 24.5 170.1-50.1-33.6-.5-67.4 0-101-1.1-.1-20.1-.2-40.1-.1-60.2 56.2-.2 112.5-.3 168.8.2 3.3 47.3-3 97.5-32 136.5zM791 536.5c-16.8.2-33.6.3-50.4.4-.2 16.8-.3 33.6-.3 50.4H690c-.2-16.8-.2-33.5-.3-50.3-16.8-.2-33.6-.3-50.4-.5v-50.1c16.8-.2 33.6-.3 50.4-.3.1-16.8.3-33.6.4-50.4h50.2l.3 50.4c16.8.2 33.6.2 50.4.3v50.1z" } }] }, "name": "google-plus-circle", "theme": "filled" };
  exports.default = GooglePlusCircleFilled;
  });

  var GooglePlusCircleFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(GooglePlusCircleFilled_1);

  var GooglePlusCircleFilled = function GooglePlusCircleFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: GooglePlusCircleFilledSvg
    }));
  };
  var RefIcon$64 = /*#__PURE__*/React.forwardRef(GooglePlusCircleFilled);
  {
    RefIcon$64.displayName = 'GooglePlusCircleFilled';
  }

  var GooglePlusOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var GooglePlusOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M879.5 470.4c-.3-27-.4-54.2-.5-81.3h-80.8c-.3 27-.5 54.1-.7 81.3-27.2.1-54.2.3-81.2.6v80.9c27 .3 54.2.5 81.2.8.3 27 .3 54.1.5 81.1h80.9c.1-27 .3-54.1.5-81.3 27.2-.3 54.2-.4 81.2-.7v-80.9c-26.9-.2-54.1-.2-81.1-.5zm-530 .4c-.1 32.3 0 64.7.1 97 54.2 1.8 108.5 1 162.7 1.8-23.9 120.3-187.4 159.3-273.9 80.7-89-68.9-84.8-220 7.7-284 64.7-51.6 156.6-38.9 221.3 5.8 25.4-23.5 49.2-48.7 72.1-74.7-53.8-42.9-119.8-73.5-190-70.3-146.6-4.9-281.3 123.5-283.7 270.2-9.4 119.9 69.4 237.4 180.6 279.8 110.8 42.7 252.9 13.6 323.7-86 46.7-62.9 56.8-143.9 51.3-220-90.7-.7-181.3-.6-271.9-.3z" } }] }, "name": "google-plus", "theme": "outlined" };
  exports.default = GooglePlusOutlined;
  });

  var GooglePlusOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(GooglePlusOutlined_1);

  var GooglePlusOutlined = function GooglePlusOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: GooglePlusOutlinedSvg
    }));
  };
  var RefIcon$65 = /*#__PURE__*/React.forwardRef(GooglePlusOutlined);
  {
    RefIcon$65.displayName = 'GooglePlusOutlined';
  }

  var GooglePlusSquareFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var GooglePlusSquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM548.5 622.8c-43.9 61.8-132.1 79.8-200.9 53.3-69-26.3-118-99.2-112.1-173.5 1.5-90.9 85.2-170.6 176.1-167.5 43.6-2 84.6 16.9 118 43.6-14.3 16.2-29 31.8-44.8 46.3-40.1-27.7-97.2-35.6-137.3-3.6-57.4 39.7-60 133.4-4.8 176.1 53.7 48.7 155.2 24.5 170.1-50.1-33.6-.5-67.4 0-101-1.1-.1-20.1-.2-40.1-.1-60.2 56.2-.2 112.5-.3 168.8.2 3.3 47.3-3 97.5-32 136.5zM791 536.5c-16.8.2-33.6.3-50.4.4-.2 16.8-.3 33.6-.3 50.4H690c-.2-16.8-.2-33.5-.3-50.3-16.8-.2-33.6-.3-50.4-.5v-50.1c16.8-.2 33.6-.3 50.4-.3.1-16.8.3-33.6.4-50.4h50.2l.3 50.4c16.8.2 33.6.2 50.4.3v50.1z" } }] }, "name": "google-plus-square", "theme": "filled" };
  exports.default = GooglePlusSquareFilled;
  });

  var GooglePlusSquareFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(GooglePlusSquareFilled_1);

  var GooglePlusSquareFilled = function GooglePlusSquareFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: GooglePlusSquareFilledSvg
    }));
  };
  var RefIcon$66 = /*#__PURE__*/React.forwardRef(GooglePlusSquareFilled);
  {
    RefIcon$66.displayName = 'GooglePlusSquareFilled';
  }

  var GoogleSquareFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var GoogleSquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM679 697.6C638.4 735 583 757 516.9 757c-95.7 0-178.5-54.9-218.8-134.9A245.02 245.02 0 01272 512c0-39.6 9.5-77 26.1-110.1 40.3-80.1 123.1-135 218.8-135 66 0 121.4 24.3 163.9 63.8L610.6 401c-25.4-24.3-57.7-36.6-93.6-36.6-63.8 0-117.8 43.1-137.1 101-4.9 14.7-7.7 30.4-7.7 46.6s2.8 31.9 7.7 46.6c19.3 57.9 73.3 101 137 101 33 0 61-8.7 82.9-23.4 26-17.4 43.2-43.3 48.9-74H516.9v-94.8h230.7c2.9 16.1 4.4 32.8 4.4 50.1 0 74.7-26.7 137.4-73 180.1z" } }] }, "name": "google-square", "theme": "filled" };
  exports.default = GoogleSquareFilled;
  });

  var GoogleSquareFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(GoogleSquareFilled_1);

  var GoogleSquareFilled = function GoogleSquareFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: GoogleSquareFilledSvg
    }));
  };
  var RefIcon$67 = /*#__PURE__*/React.forwardRef(GoogleSquareFilled);
  {
    RefIcon$67.displayName = 'GoogleSquareFilled';
  }

  var GroupOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var GroupOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M912 820.1V203.9c28-9.9 48-36.6 48-67.9 0-39.8-32.2-72-72-72-31.3 0-58 20-67.9 48H203.9C194 84 167.3 64 136 64c-39.8 0-72 32.2-72 72 0 31.3 20 58 48 67.9v616.2C84 830 64 856.7 64 888c0 39.8 32.2 72 72 72 31.3 0 58-20 67.9-48h616.2c9.9 28 36.6 48 67.9 48 39.8 0 72-32.2 72-72 0-31.3-20-58-48-67.9zM888 112c13.3 0 24 10.7 24 24s-10.7 24-24 24-24-10.7-24-24 10.7-24 24-24zM136 912c-13.3 0-24-10.7-24-24s10.7-24 24-24 24 10.7 24 24-10.7 24-24 24zm0-752c-13.3 0-24-10.7-24-24s10.7-24 24-24 24 10.7 24 24-10.7 24-24 24zm704 680H184V184h656v656zm48 72c-13.3 0-24-10.7-24-24s10.7-24 24-24 24 10.7 24 24-10.7 24-24 24z" } }, { "tag": "path", "attrs": { "d": "M288 474h448c8.8 0 16-7.2 16-16V282c0-8.8-7.2-16-16-16H288c-8.8 0-16 7.2-16 16v176c0 8.8 7.2 16 16 16zm56-136h336v64H344v-64zm-56 420h448c8.8 0 16-7.2 16-16V566c0-8.8-7.2-16-16-16H288c-8.8 0-16 7.2-16 16v176c0 8.8 7.2 16 16 16zm56-136h336v64H344v-64z" } }] }, "name": "group", "theme": "outlined" };
  exports.default = GroupOutlined;
  });

  var GroupOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(GroupOutlined_1);

  var GroupOutlined = function GroupOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: GroupOutlinedSvg
    }));
  };
  var RefIcon$68 = /*#__PURE__*/React.forwardRef(GroupOutlined);
  {
    RefIcon$68.displayName = 'GroupOutlined';
  }

  var HarmonyOSOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var HarmonyOSOutlined = { "icon": { "tag": "svg", "attrs": { "fill-rule": "evenodd", "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M511.5 65C719.99 65 889 234.01 889 442.5S719.99 820 511.5 820 134 650.99 134 442.5 303.01 65 511.5 65m0 64C338.36 129 198 269.36 198 442.5S338.36 756 511.5 756 825 615.64 825 442.5 684.64 129 511.5 129M745 889v72H278v-72z" } }] }, "name": "harmony-o-s", "theme": "outlined" };
  exports.default = HarmonyOSOutlined;
  });

  var HarmonyOSOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(HarmonyOSOutlined_1);

  var HarmonyOSOutlined = function HarmonyOSOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: HarmonyOSOutlinedSvg
    }));
  };
  var RefIcon$69 = /*#__PURE__*/React.forwardRef(HarmonyOSOutlined);
  {
    RefIcon$69.displayName = 'HarmonyOSOutlined';
  }

  var HddFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var HddFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M832 64H192c-17.7 0-32 14.3-32 32v224h704V96c0-17.7-14.3-32-32-32zM456 216c0 4.4-3.6 8-8 8H264c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h184c4.4 0 8 3.6 8 8v48zM160 928c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V704H160v224zm576-136c22.1 0 40 17.9 40 40s-17.9 40-40 40-40-17.9-40-40 17.9-40 40-40zM160 640h704V384H160v256zm96-152c0-4.4 3.6-8 8-8h184c4.4 0 8 3.6 8 8v48c0 4.4-3.6 8-8 8H264c-4.4 0-8-3.6-8-8v-48z" } }] }, "name": "hdd", "theme": "filled" };
  exports.default = HddFilled;
  });

  var HddFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(HddFilled_1);

  var HddFilled = function HddFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: HddFilledSvg
    }));
  };
  var RefIcon$6a = /*#__PURE__*/React.forwardRef(HddFilled);
  {
    RefIcon$6a.displayName = 'HddFilled';
  }

  var HddOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var HddOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M832 64H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V96c0-17.7-14.3-32-32-32zm-600 72h560v208H232V136zm560 480H232V408h560v208zm0 272H232V680h560v208zM496 208H312c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h184c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8zM312 544h184c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H312c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8zm328 244a40 40 0 1080 0 40 40 0 10-80 0z" } }] }, "name": "hdd", "theme": "outlined" };
  exports.default = HddOutlined;
  });

  var HddOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(HddOutlined_1);

  var HddOutlined = function HddOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: HddOutlinedSvg
    }));
  };
  var RefIcon$6b = /*#__PURE__*/React.forwardRef(HddOutlined);
  {
    RefIcon$6b.displayName = 'HddOutlined';
  }

  var HddTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var HddTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M232 888h560V680H232v208zm448-140c22.1 0 40 17.9 40 40s-17.9 40-40 40-40-17.9-40-40 17.9-40 40-40zM232 616h560V408H232v208zm72-128c0-4.4 3.6-8 8-8h184c4.4 0 8 3.6 8 8v48c0 4.4-3.6 8-8 8H312c-4.4 0-8-3.6-8-8v-48zm-72-144h560V136H232v208zm72-128c0-4.4 3.6-8 8-8h184c4.4 0 8 3.6 8 8v48c0 4.4-3.6 8-8 8H312c-4.4 0-8-3.6-8-8v-48z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M832 64H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V96c0-17.7-14.3-32-32-32zm-40 824H232V680h560v208zm0-272H232V408h560v208zm0-272H232V136h560v208z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M312 544h184c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H312c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8zm0-272h184c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H312c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8zm328 516a40 40 0 1080 0 40 40 0 10-80 0z", "fill": primaryColor } }] }; }, "name": "hdd", "theme": "twotone" };
  exports.default = HddTwoTone;
  });

  var HddTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(HddTwoTone_1);

  var HddTwoTone = function HddTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: HddTwoToneSvg
    }));
  };
  var RefIcon$6c = /*#__PURE__*/React.forwardRef(HddTwoTone);
  {
    RefIcon$6c.displayName = 'HddTwoTone';
  }

  var HeartFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var HeartFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M923 283.6a260.04 260.04 0 00-56.9-82.8 264.4 264.4 0 00-84-55.5A265.34 265.34 0 00679.7 125c-49.3 0-97.4 13.5-139.2 39-10 6.1-19.5 12.8-28.5 20.1-9-7.3-18.5-14-28.5-20.1-41.8-25.5-89.9-39-139.2-39-35.5 0-69.9 6.8-102.4 20.3-31.4 13-59.7 31.7-84 55.5a258.44 258.44 0 00-56.9 82.8c-13.9 32.3-21 66.6-21 101.9 0 33.3 6.8 68 20.3 103.3 11.3 29.5 27.5 60.1 48.2 91 32.8 48.9 77.9 99.9 133.9 151.6 92.8 85.7 184.7 144.9 188.6 147.3l23.7 15.2c10.5 6.7 24 6.7 34.5 0l23.7-15.2c3.9-2.5 95.7-61.6 188.6-147.3 56-51.7 101.1-102.7 133.9-151.6 20.7-30.9 37-61.5 48.2-91 13.5-35.3 20.3-70 20.3-103.3.1-35.3-7-69.6-20.9-101.9z" } }] }, "name": "heart", "theme": "filled" };
  exports.default = HeartFilled;
  });

  var HeartFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(HeartFilled_1);

  var HeartFilled = function HeartFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: HeartFilledSvg
    }));
  };
  var RefIcon$6d = /*#__PURE__*/React.forwardRef(HeartFilled);
  {
    RefIcon$6d.displayName = 'HeartFilled';
  }

  var HeartOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var HeartOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M923 283.6a260.04 260.04 0 00-56.9-82.8 264.4 264.4 0 00-84-55.5A265.34 265.34 0 00679.7 125c-49.3 0-97.4 13.5-139.2 39-10 6.1-19.5 12.8-28.5 20.1-9-7.3-18.5-14-28.5-20.1-41.8-25.5-89.9-39-139.2-39-35.5 0-69.9 6.8-102.4 20.3-31.4 13-59.7 31.7-84 55.5a258.44 258.44 0 00-56.9 82.8c-13.9 32.3-21 66.6-21 101.9 0 33.3 6.8 68 20.3 103.3 11.3 29.5 27.5 60.1 48.2 91 32.8 48.9 77.9 99.9 133.9 151.6 92.8 85.7 184.7 144.9 188.6 147.3l23.7 15.2c10.5 6.7 24 6.7 34.5 0l23.7-15.2c3.9-2.5 95.7-61.6 188.6-147.3 56-51.7 101.1-102.7 133.9-151.6 20.7-30.9 37-61.5 48.2-91 13.5-35.3 20.3-70 20.3-103.3.1-35.3-7-69.6-20.9-101.9zM512 814.8S156 586.7 156 385.5C156 283.6 240.3 201 344.3 201c73.1 0 136.5 40.8 167.7 100.4C543.2 241.8 606.6 201 679.7 201c104 0 188.3 82.6 188.3 184.5 0 201.2-356 429.3-356 429.3z" } }] }, "name": "heart", "theme": "outlined" };
  exports.default = HeartOutlined;
  });

  var HeartOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(HeartOutlined_1);

  var HeartOutlined = function HeartOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: HeartOutlinedSvg
    }));
  };
  var RefIcon$6e = /*#__PURE__*/React.forwardRef(HeartOutlined);
  {
    RefIcon$6e.displayName = 'HeartOutlined';
  }

  var HeartTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var HeartTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M923 283.6a260.04 260.04 0 00-56.9-82.8 264.4 264.4 0 00-84-55.5A265.34 265.34 0 00679.7 125c-49.3 0-97.4 13.5-139.2 39-10 6.1-19.5 12.8-28.5 20.1-9-7.3-18.5-14-28.5-20.1-41.8-25.5-89.9-39-139.2-39-35.5 0-69.9 6.8-102.4 20.3-31.4 13-59.7 31.7-84 55.5a258.44 258.44 0 00-56.9 82.8c-13.9 32.3-21 66.6-21 101.9 0 33.3 6.8 68 20.3 103.3 11.3 29.5 27.5 60.1 48.2 91 32.8 48.9 77.9 99.9 133.9 151.6 92.8 85.7 184.7 144.9 188.6 147.3l23.7 15.2c10.5 6.7 24 6.7 34.5 0l23.7-15.2c3.9-2.5 95.7-61.6 188.6-147.3 56-51.7 101.1-102.7 133.9-151.6 20.7-30.9 37-61.5 48.2-91 13.5-35.3 20.3-70 20.3-103.3.1-35.3-7-69.6-20.9-101.9zM512 814.8S156 586.7 156 385.5C156 283.6 240.3 201 344.3 201c73.1 0 136.5 40.8 167.7 100.4C543.2 241.8 606.6 201 679.7 201c104 0 188.3 82.6 188.3 184.5 0 201.2-356 429.3-356 429.3z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M679.7 201c-73.1 0-136.5 40.8-167.7 100.4C480.8 241.8 417.4 201 344.3 201c-104 0-188.3 82.6-188.3 184.5 0 201.2 356 429.3 356 429.3s356-228.1 356-429.3C868 283.6 783.7 201 679.7 201z", "fill": secondaryColor } }] }; }, "name": "heart", "theme": "twotone" };
  exports.default = HeartTwoTone;
  });

  var HeartTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(HeartTwoTone_1);

  var HeartTwoTone = function HeartTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: HeartTwoToneSvg
    }));
  };
  var RefIcon$6f = /*#__PURE__*/React.forwardRef(HeartTwoTone);
  {
    RefIcon$6f.displayName = 'HeartTwoTone';
  }

  var HeatMapOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var HeatMapOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M955.7 856l-416-720c-6.2-10.7-16.9-16-27.7-16s-21.6 5.3-27.7 16l-416 720C56 877.4 71.4 904 96 904h832c24.6 0 40-26.6 27.7-48zm-790.4-23.9L512 231.9 858.7 832H165.3zm319-474.1l-228 394c-12.3 21.3 3.1 48 27.7 48h455.8c24.7 0 40.1-26.7 27.7-48L539.7 358c-6.2-10.7-17-16-27.7-16-10.8 0-21.6 5.3-27.7 16zm214 386H325.7L512 422l186.3 322zm-214-194.1l-57 98.4C415 669.5 430.4 696 455 696h114c24.6 0 39.9-26.5 27.7-47.7l-57-98.4c-6.1-10.6-16.9-15.9-27.7-15.9s-21.5 5.3-27.7 15.9zm57.1 98.4h-58.7l29.4-50.7 29.3 50.7z" } }] }, "name": "heat-map", "theme": "outlined" };
  exports.default = HeatMapOutlined;
  });

  var HeatMapOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(HeatMapOutlined_1);

  var HeatMapOutlined = function HeatMapOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: HeatMapOutlinedSvg
    }));
  };
  var RefIcon$6g = /*#__PURE__*/React.forwardRef(HeatMapOutlined);
  {
    RefIcon$6g.displayName = 'HeatMapOutlined';
  }

  var HighlightFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var HighlightFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M957.6 507.4L603.2 158.2a7.9 7.9 0 00-11.2 0L353.3 393.4a8.03 8.03 0 00-.1 11.3l.1.1 40 39.4-117.2 115.3a8.03 8.03 0 00-.1 11.3l.1.1 39.5 38.9-189.1 187H72.1c-4.4 0-8.1 3.6-8.1 8V860c0 4.4 3.6 8 8 8h344.9c2.1 0 4.1-.8 5.6-2.3l76.1-75.6 40.4 39.8a7.9 7.9 0 0011.2 0l117.1-115.6 40.1 39.5a7.9 7.9 0 0011.2 0l238.7-235.2c3.4-3 3.4-8 .3-11.2z" } }] }, "name": "highlight", "theme": "filled" };
  exports.default = HighlightFilled;
  });

  var HighlightFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(HighlightFilled_1);

  var HighlightFilled = function HighlightFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: HighlightFilledSvg
    }));
  };
  var RefIcon$6h = /*#__PURE__*/React.forwardRef(HighlightFilled);
  {
    RefIcon$6h.displayName = 'HighlightFilled';
  }

  var HighlightOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var HighlightOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M957.6 507.4L603.2 158.2a7.9 7.9 0 00-11.2 0L353.3 393.4a8.03 8.03 0 00-.1 11.3l.1.1 40 39.4-117.2 115.3a8.03 8.03 0 00-.1 11.3l.1.1 39.5 38.9-189.1 187H72.1c-4.4 0-8.1 3.6-8.1 8V860c0 4.4 3.6 8 8 8h344.9c2.1 0 4.1-.8 5.6-2.3l76.1-75.6 40.4 39.8a7.9 7.9 0 0011.2 0l117.1-115.6 40.1 39.5a7.9 7.9 0 0011.2 0l238.7-235.2c3.4-3 3.4-8 .3-11.2zM389.8 796.2H229.6l134.4-133 80.1 78.9-54.3 54.1zm154.8-62.1L373.2 565.2l68.6-67.6 171.4 168.9-68.6 67.6zM713.1 658L450.3 399.1 597.6 254l262.8 259-147.3 145z" } }] }, "name": "highlight", "theme": "outlined" };
  exports.default = HighlightOutlined;
  });

  var HighlightOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(HighlightOutlined_1);

  var HighlightOutlined = function HighlightOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: HighlightOutlinedSvg
    }));
  };
  var RefIcon$6i = /*#__PURE__*/React.forwardRef(HighlightOutlined);
  {
    RefIcon$6i.displayName = 'HighlightOutlined';
  }

  var HighlightTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var HighlightTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M229.6 796.3h160.2l54.3-54.1-80.1-78.9zm220.7-397.1l262.8 258.9 147.3-145-262.8-259zm-77.1 166.1l171.4 168.9 68.6-67.6-171.4-168.9z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M957.6 507.5L603.2 158.3a7.9 7.9 0 00-11.2 0L353.3 393.5a8.03 8.03 0 00-.1 11.3l.1.1 40 39.4-117.2 115.3a8.03 8.03 0 00-.1 11.3l.1.1 39.5 38.9-189.1 187H72.1c-4.4 0-8.1 3.6-8.1 8v55.2c0 4.4 3.6 8 8 8h344.9c2.1 0 4.1-.8 5.6-2.3l76.1-75.6L539 830a7.9 7.9 0 0011.2 0l117.1-115.6 40.1 39.5a7.9 7.9 0 0011.2 0l238.7-235.2c3.4-3 3.4-8 .3-11.2zM389.8 796.3H229.6l134.4-133 80.1 78.9-54.3 54.1zm154.8-62.1L373.2 565.3l68.6-67.6 171.4 168.9-68.6 67.6zm168.5-76.1L450.3 399.2l147.3-145.1 262.8 259-147.3 145z", "fill": primaryColor } }] }; }, "name": "highlight", "theme": "twotone" };
  exports.default = HighlightTwoTone;
  });

  var HighlightTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(HighlightTwoTone_1);

  var HighlightTwoTone = function HighlightTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: HighlightTwoToneSvg
    }));
  };
  var RefIcon$6j = /*#__PURE__*/React.forwardRef(HighlightTwoTone);
  {
    RefIcon$6j.displayName = 'HighlightTwoTone';
  }

  var HistoryOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var HistoryOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M536.1 273H488c-4.4 0-8 3.6-8 8v275.3c0 2.6 1.2 5 3.3 6.5l165.3 120.7c3.6 2.6 8.6 1.9 11.2-1.7l28.6-39c2.7-3.7 1.9-8.7-1.7-11.2L544.1 528.5V281c0-4.4-3.6-8-8-8zm219.8 75.2l156.8 38.3c5 1.2 9.9-2.6 9.9-7.7l.8-161.5c0-6.7-7.7-10.5-12.9-6.3L752.9 334.1a8 8 0 003 14.1zm167.7 301.1l-56.7-19.5a8 8 0 00-10.1 4.8c-1.9 5.1-3.9 10.1-6 15.1-17.8 42.1-43.3 80-75.9 112.5a353 353 0 01-112.5 75.9 352.18 352.18 0 01-137.7 27.8c-47.8 0-94.1-9.3-137.7-27.8a353 353 0 01-112.5-75.9c-32.5-32.5-58-70.4-75.9-112.5A353.44 353.44 0 01171 512c0-47.8 9.3-94.2 27.8-137.8 17.8-42.1 43.3-80 75.9-112.5a353 353 0 01112.5-75.9C430.6 167.3 477 158 524.8 158s94.1 9.3 137.7 27.8A353 353 0 01775 261.7c10.2 10.3 19.8 21 28.6 32.3l59.8-46.8C784.7 146.6 662.2 81.9 524.6 82 285 82.1 92.6 276.7 95 516.4 97.4 751.9 288.9 942 524.8 942c185.5 0 343.5-117.6 403.7-282.3 1.5-4.2-.7-8.9-4.9-10.4z" } }] }, "name": "history", "theme": "outlined" };
  exports.default = HistoryOutlined;
  });

  var HistoryOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(HistoryOutlined_1);

  var HistoryOutlined = function HistoryOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: HistoryOutlinedSvg
    }));
  };
  var RefIcon$6k = /*#__PURE__*/React.forwardRef(HistoryOutlined);
  {
    RefIcon$6k.displayName = 'HistoryOutlined';
  }

  var HolderOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var HolderOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M300 276.5a56 56 0 1056-97 56 56 0 00-56 97zm0 284a56 56 0 1056-97 56 56 0 00-56 97zM640 228a56 56 0 10112 0 56 56 0 00-112 0zm0 284a56 56 0 10112 0 56 56 0 00-112 0zM300 844.5a56 56 0 1056-97 56 56 0 00-56 97zM640 796a56 56 0 10112 0 56 56 0 00-112 0z" } }] }, "name": "holder", "theme": "outlined" };
  exports.default = HolderOutlined;
  });

  var HolderOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(HolderOutlined_1);

  var HolderOutlined = function HolderOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: HolderOutlinedSvg
    }));
  };
  var RefIcon$6l = /*#__PURE__*/React.forwardRef(HolderOutlined);
  {
    RefIcon$6l.displayName = 'HolderOutlined';
  }

  var HomeFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var HomeFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M946.5 505L534.6 93.4a31.93 31.93 0 00-45.2 0L77.5 505c-12 12-18.8 28.3-18.8 45.3 0 35.3 28.7 64 64 64h43.4V908c0 17.7 14.3 32 32 32H448V716h112v224h265.9c17.7 0 32-14.3 32-32V614.3h43.4c17 0 33.3-6.7 45.3-18.8 24.9-25 24.9-65.5-.1-90.5z" } }] }, "name": "home", "theme": "filled" };
  exports.default = HomeFilled;
  });

  var HomeFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(HomeFilled_1);

  var HomeFilled = function HomeFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: HomeFilledSvg
    }));
  };
  var RefIcon$6m = /*#__PURE__*/React.forwardRef(HomeFilled);
  {
    RefIcon$6m.displayName = 'HomeFilled';
  }

  var HomeOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var HomeOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M946.5 505L560.1 118.8l-25.9-25.9a31.5 31.5 0 00-44.4 0L77.5 505a63.9 63.9 0 00-18.8 46c.4 35.2 29.7 63.3 64.9 63.3h42.5V940h691.8V614.3h43.4c17.1 0 33.2-6.7 45.3-18.8a63.6 63.6 0 0018.7-45.3c0-17-6.7-33.1-18.8-45.2zM568 868H456V664h112v204zm217.9-325.7V868H632V640c0-22.1-17.9-40-40-40H432c-22.1 0-40 17.9-40 40v228H238.1V542.3h-96l370-369.7 23.1 23.1L882 542.3h-96.1z" } }] }, "name": "home", "theme": "outlined" };
  exports.default = HomeOutlined;
  });

  var HomeOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(HomeOutlined_1);

  var HomeOutlined = function HomeOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: HomeOutlinedSvg
    }));
  };
  var RefIcon$6n = /*#__PURE__*/React.forwardRef(HomeOutlined);
  {
    RefIcon$6n.displayName = 'HomeOutlined';
  }

  var HomeTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var HomeTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512.1 172.6l-370 369.7h96V868H392V640c0-22.1 17.9-40 40-40h160c22.1 0 40 17.9 40 40v228h153.9V542.3H882L535.2 195.7l-23.1-23.1zm434.5 422.9c-6 6-13.1 10.8-20.8 13.9 7.7-3.2 14.8-7.9 20.8-13.9zm-887-34.7c5 30.3 31.4 53.5 63.1 53.5h.9c-31.9 0-58.9-23-64-53.5zm-.9-10.5v-1.9 1.9zm.1-2.6c.1-3.1.5-6.1 1-9.1-.6 2.9-.9 6-1 9.1z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M951 510c0-.1-.1-.1-.1-.2l-1.8-2.1c-.1-.1-.2-.3-.4-.4-.7-.8-1.5-1.6-2.2-2.4L560.1 118.8l-25.9-25.9a31.5 31.5 0 00-44.4 0L77.5 505a63.6 63.6 0 00-16 26.6l-.6 2.1-.3 1.1-.3 1.2c-.2.7-.3 1.4-.4 2.1 0 .1 0 .3-.1.4-.6 3-.9 6-1 9.1v3.3c0 .5 0 1 .1 1.5 0 .5 0 .9.1 1.4 0 .5.1 1 .1 1.5 0 .6.1 1.2.2 1.8 0 .3.1.6.1.9l.3 2.5v.1c5.1 30.5 32.2 53.5 64 53.5h42.5V940h691.7V614.3h43.4c8.6 0 16.9-1.7 24.5-4.9s14.7-7.9 20.8-13.9a63.6 63.6 0 0018.7-45.3c0-14.7-5-28.8-14.3-40.2zM568 868H456V664h112v204zm217.9-325.7V868H632V640c0-22.1-17.9-40-40-40H432c-22.1 0-40 17.9-40 40v228H238.1V542.3h-96l370-369.7 23.1 23.1L882 542.3h-96.1z", "fill": primaryColor } }] }; }, "name": "home", "theme": "twotone" };
  exports.default = HomeTwoTone;
  });

  var HomeTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(HomeTwoTone_1);

  var HomeTwoTone = function HomeTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: HomeTwoToneSvg
    }));
  };
  var RefIcon$6o = /*#__PURE__*/React.forwardRef(HomeTwoTone);
  {
    RefIcon$6o.displayName = 'HomeTwoTone';
  }

  var HourglassFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var HourglassFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M742 318V184h86c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H196c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h86v134c0 81.5 42.4 153.2 106.4 194-64 40.8-106.4 112.5-106.4 194v134h-86c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h632c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-86V706c0-81.5-42.4-153.2-106.4-194 64-40.8 106.4-112.5 106.4-194z" } }] }, "name": "hourglass", "theme": "filled" };
  exports.default = HourglassFilled;
  });

  var HourglassFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(HourglassFilled_1);

  var HourglassFilled = function HourglassFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: HourglassFilledSvg
    }));
  };
  var RefIcon$6p = /*#__PURE__*/React.forwardRef(HourglassFilled);
  {
    RefIcon$6p.displayName = 'HourglassFilled';
  }

  var HourglassOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var HourglassOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M742 318V184h86c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H196c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h86v134c0 81.5 42.4 153.2 106.4 194-64 40.8-106.4 112.5-106.4 194v134h-86c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h632c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-86V706c0-81.5-42.4-153.2-106.4-194 64-40.8 106.4-112.5 106.4-194zm-72 388v134H354V706c0-42.2 16.4-81.9 46.3-111.7C430.1 564.4 469.8 548 512 548s81.9 16.4 111.7 46.3C653.6 624.1 670 663.8 670 706zm0-388c0 42.2-16.4 81.9-46.3 111.7C593.9 459.6 554.2 476 512 476s-81.9-16.4-111.7-46.3A156.63 156.63 0 01354 318V184h316v134z" } }] }, "name": "hourglass", "theme": "outlined" };
  exports.default = HourglassOutlined;
  });

  var HourglassOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(HourglassOutlined_1);

  var HourglassOutlined = function HourglassOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: HourglassOutlinedSvg
    }));
  };
  var RefIcon$6q = /*#__PURE__*/React.forwardRef(HourglassOutlined);
  {
    RefIcon$6q.displayName = 'HourglassOutlined';
  }

  var HourglassTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var HourglassTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 548c-42.2 0-81.9 16.4-111.7 46.3A156.63 156.63 0 00354 706v134h316V706c0-42.2-16.4-81.9-46.3-111.7A156.63 156.63 0 00512 548zM354 318c0 42.2 16.4 81.9 46.3 111.7C430.1 459.6 469.8 476 512 476s81.9-16.4 111.7-46.3C653.6 399.9 670 360.2 670 318V184H354v134z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M742 318V184h86c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H196c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h86v134c0 81.5 42.4 153.2 106.4 194-64 40.8-106.4 112.5-106.4 194v134h-86c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h632c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-86V706c0-81.5-42.4-153.2-106.4-194 64-40.8 106.4-112.5 106.4-194zm-72 388v134H354V706c0-42.2 16.4-81.9 46.3-111.7C430.1 564.4 469.8 548 512 548s81.9 16.4 111.7 46.3C653.6 624.1 670 663.8 670 706zm0-388c0 42.2-16.4 81.9-46.3 111.7C593.9 459.6 554.2 476 512 476s-81.9-16.4-111.7-46.3A156.63 156.63 0 01354 318V184h316v134z", "fill": primaryColor } }] }; }, "name": "hourglass", "theme": "twotone" };
  exports.default = HourglassTwoTone;
  });

  var HourglassTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(HourglassTwoTone_1);

  var HourglassTwoTone = function HourglassTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: HourglassTwoToneSvg
    }));
  };
  var RefIcon$6r = /*#__PURE__*/React.forwardRef(HourglassTwoTone);
  {
    RefIcon$6r.displayName = 'HourglassTwoTone';
  }

  var Html5Filled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var Html5Filled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M145.2 96l66 746.6L512 928l299.6-85.4L878.9 96H145.2zm595 177.1l-4.8 47.2-1.7 19.5H382.3l8.2 94.2h335.1l-3.3 24.3-21.2 242.2-1.7 16.2-187 51.6v.3h-1.2l-.3.1v-.1h-.1l-188.6-52L310.8 572h91.1l6.5 73.2 102.4 27.7h.4l102-27.6 11.4-118.6H510.9v-.1H306l-22.8-253.5-1.7-24.3h460.3l-1.6 24.3z" } }] }, "name": "html5", "theme": "filled" };
  exports.default = Html5Filled;
  });

  var Html5FilledSvg = /*@__PURE__*/getDefaultExportFromCjs(Html5Filled_1);

  var Html5Filled = function Html5Filled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: Html5FilledSvg
    }));
  };
  var RefIcon$6s = /*#__PURE__*/React.forwardRef(Html5Filled);
  {
    RefIcon$6s.displayName = 'Html5Filled';
  }

  var Html5Outlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var Html5Outlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M145 96l66 746.6L511.8 928l299.6-85.4L878.7 96H145zm610.9 700.6l-244.1 69.6-245.2-69.6-56.7-641.2h603.8l-57.8 641.2zM281 249l1.7 24.3 22.7 253.5h206.5v-.1h112.9l-11.4 118.5L511 672.9v.2h-.8l-102.4-27.7-6.5-73.2h-91l11.3 144.7 188.6 52h1.7v-.4l187.7-51.7 1.7-16.3 21.2-242.2 3.2-24.3H511v.2H389.9l-8.2-94.2h352.1l1.7-19.5 4.8-47.2L742 249H511z" } }] }, "name": "html5", "theme": "outlined" };
  exports.default = Html5Outlined;
  });

  var Html5OutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(Html5Outlined_1);

  var Html5Outlined = function Html5Outlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: Html5OutlinedSvg
    }));
  };
  var RefIcon$6t = /*#__PURE__*/React.forwardRef(Html5Outlined);
  {
    RefIcon$6t.displayName = 'Html5Outlined';
  }

  var Html5TwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var Html5TwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M145 96l66 746.6L511.8 928l299.6-85.4L878.7 96H145zm610.9 700.6l-244.1 69.6-245.2-69.6-56.7-641.2h603.8l-57.8 641.2z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M209.9 155.4l56.7 641.2 245.2 69.6 244.1-69.6 57.8-641.2H209.9zm530.4 117.9l-4.8 47.2-1.7 19.5H381.7l8.2 94.2H511v-.2h214.7l-3.2 24.3-21.2 242.2-1.7 16.3-187.7 51.7v.4h-1.7l-188.6-52-11.3-144.7h91l6.5 73.2 102.4 27.7h.8v-.2l102.4-27.7 11.4-118.5H511.9v.1H305.4l-22.7-253.5L281 249h461l-1.7 24.3z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M281 249l1.7 24.3 22.7 253.5h206.5v-.1h112.9l-11.4 118.5L511 672.9v.2h-.8l-102.4-27.7-6.5-73.2h-91l11.3 144.7 188.6 52h1.7v-.4l187.7-51.7 1.7-16.3 21.2-242.2 3.2-24.3H511v.2H389.9l-8.2-94.2h352.1l1.7-19.5 4.8-47.2L742 249H511z", "fill": primaryColor } }] }; }, "name": "html5", "theme": "twotone" };
  exports.default = Html5TwoTone;
  });

  var Html5TwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(Html5TwoTone_1);

  var Html5TwoTone = function Html5TwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: Html5TwoToneSvg
    }));
  };
  var RefIcon$6u = /*#__PURE__*/React.forwardRef(Html5TwoTone);
  {
    RefIcon$6u.displayName = 'Html5TwoTone';
  }

  var IdcardFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var IdcardFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M373 411c-28.5 0-51.7 23.3-51.7 52s23.2 52 51.7 52 51.7-23.3 51.7-52-23.2-52-51.7-52zm555-251H96c-17.7 0-32 14.3-32 32v640c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V192c0-17.7-14.3-32-32-32zM608 420c0-4.4 1-8 2.3-8h123.4c1.3 0 2.3 3.6 2.3 8v48c0 4.4-1 8-2.3 8H610.3c-1.3 0-2.3-3.6-2.3-8v-48zm-86 253h-43.9c-4.2 0-7.6-3.3-7.9-7.5-3.8-50.5-46-90.5-97.2-90.5s-93.4 40-97.2 90.5c-.3 4.2-3.7 7.5-7.9 7.5H224a8 8 0 01-8-8.4c2.8-53.3 32-99.7 74.6-126.1a111.8 111.8 0 01-29.1-75.5c0-61.9 49.9-112 111.4-112s111.4 50.1 111.4 112c0 29.1-11 55.5-29.1 75.5 42.7 26.5 71.8 72.8 74.6 126.1.4 4.6-3.2 8.4-7.8 8.4zm278.9-53H615.1c-3.9 0-7.1-3.6-7.1-8v-48c0-4.4 3.2-8 7.1-8h185.7c3.9 0 7.1 3.6 7.1 8v48h.1c0 4.4-3.2 8-7.1 8z" } }] }, "name": "idcard", "theme": "filled" };
  exports.default = IdcardFilled;
  });

  var IdcardFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(IdcardFilled_1);

  var IdcardFilled = function IdcardFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: IdcardFilledSvg
    }));
  };
  var RefIcon$6v = /*#__PURE__*/React.forwardRef(IdcardFilled);
  {
    RefIcon$6v.displayName = 'IdcardFilled';
  }

  var IdcardOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var IdcardOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M928 160H96c-17.7 0-32 14.3-32 32v640c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V192c0-17.7-14.3-32-32-32zm-40 632H136V232h752v560zM610.3 476h123.4c1.3 0 2.3-3.6 2.3-8v-48c0-4.4-1-8-2.3-8H610.3c-1.3 0-2.3 3.6-2.3 8v48c0 4.4 1 8 2.3 8zm4.8 144h185.7c3.9 0 7.1-3.6 7.1-8v-48c0-4.4-3.2-8-7.1-8H615.1c-3.9 0-7.1 3.6-7.1 8v48c0 4.4 3.2 8 7.1 8zM224 673h43.9c4.2 0 7.6-3.3 7.9-7.5 3.8-50.5 46-90.5 97.2-90.5s93.4 40 97.2 90.5c.3 4.2 3.7 7.5 7.9 7.5H522a8 8 0 008-8.4c-2.8-53.3-32-99.7-74.6-126.1a111.8 111.8 0 0029.1-75.5c0-61.9-49.9-112-111.4-112s-111.4 50.1-111.4 112c0 29.1 11 55.5 29.1 75.5a158.09 158.09 0 00-74.6 126.1c-.4 4.6 3.2 8.4 7.8 8.4zm149-262c28.5 0 51.7 23.3 51.7 52s-23.2 52-51.7 52-51.7-23.3-51.7-52 23.2-52 51.7-52z" } }] }, "name": "idcard", "theme": "outlined" };
  exports.default = IdcardOutlined;
  });

  var IdcardOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(IdcardOutlined_1);

  var IdcardOutlined = function IdcardOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: IdcardOutlinedSvg
    }));
  };
  var RefIcon$6w = /*#__PURE__*/React.forwardRef(IdcardOutlined);
  {
    RefIcon$6w.displayName = 'IdcardOutlined';
  }

  var IdcardTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var IdcardTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M928 160H96c-17.7 0-32 14.3-32 32v640c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V192c0-17.7-14.3-32-32-32zm-40 632H136V232h752v560z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M136 792h752V232H136v560zm472-372c0-4.4 1-8 2.3-8h123.4c1.3 0 2.3 3.6 2.3 8v48c0 4.4-1 8-2.3 8H610.3c-1.3 0-2.3-3.6-2.3-8v-48zm0 144c0-4.4 3.2-8 7.1-8h185.7c3.9 0 7.1 3.6 7.1 8v48c0 4.4-3.2 8-7.1 8H615.1c-3.9 0-7.1-3.6-7.1-8v-48zM216.2 664.6c2.8-53.3 31.9-99.6 74.6-126.1-18.1-20-29.1-46.4-29.1-75.5 0-61.9 49.9-112 111.4-112s111.4 50.1 111.4 112c0 29.1-11 55.6-29.1 75.5 42.6 26.4 71.8 72.8 74.6 126.1a8 8 0 01-8 8.4h-43.9c-4.2 0-7.6-3.3-7.9-7.5-3.8-50.5-46-90.5-97.2-90.5s-93.4 40-97.2 90.5c-.3 4.2-3.7 7.5-7.9 7.5H224c-4.6 0-8.2-3.8-7.8-8.4z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M321.3 463a51.7 52 0 10103.4 0 51.7 52 0 10-103.4 0z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M610.3 476h123.4c1.3 0 2.3-3.6 2.3-8v-48c0-4.4-1-8-2.3-8H610.3c-1.3 0-2.3 3.6-2.3 8v48c0 4.4 1 8 2.3 8zm4.8 144h185.7c3.9 0 7.1-3.6 7.1-8v-48c0-4.4-3.2-8-7.1-8H615.1c-3.9 0-7.1 3.6-7.1 8v48c0 4.4 3.2 8 7.1 8zM224 673h43.9c4.2 0 7.6-3.3 7.9-7.5 3.8-50.5 46-90.5 97.2-90.5s93.4 40 97.2 90.5c.3 4.2 3.7 7.5 7.9 7.5H522a8 8 0 008-8.4c-2.8-53.3-32-99.7-74.6-126.1a111.8 111.8 0 0029.1-75.5c0-61.9-49.9-112-111.4-112s-111.4 50.1-111.4 112c0 29.1 11 55.5 29.1 75.5a158.09 158.09 0 00-74.6 126.1c-.4 4.6 3.2 8.4 7.8 8.4zm149-262c28.5 0 51.7 23.3 51.7 52s-23.2 52-51.7 52-51.7-23.3-51.7-52 23.2-52 51.7-52z", "fill": primaryColor } }] }; }, "name": "idcard", "theme": "twotone" };
  exports.default = IdcardTwoTone;
  });

  var IdcardTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(IdcardTwoTone_1);

  var IdcardTwoTone = function IdcardTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: IdcardTwoToneSvg
    }));
  };
  var RefIcon$6x = /*#__PURE__*/React.forwardRef(IdcardTwoTone);
  {
    RefIcon$6x.displayName = 'IdcardTwoTone';
  }

  var IeCircleFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var IeCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M693.6 284.4c-24 0-51.1 11.7-72.6 22 46.3 18 86 57.3 112.3 99.6 7.1-18.9 14.6-47.9 14.6-67.9 0-32-22.8-53.7-54.3-53.7zM512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm253.9 492.9H437.1c0 100.4 144.3 136 196.8 47.4h120.8c-32.6 91.7-119.7 146-216.8 146-35.1 0-70.3-.1-101.7-15.6-87.4 44.5-180.3 56.6-180.3-42 0-45.8 23.2-107.1 44-145C335 484 381.3 422.8 435.6 374.5c-43.7 18.9-91.1 66.3-122 101.2 25.9-112.8 129.5-193.6 237.1-186.5 130-59.8 209.7-34.1 209.7 38.6 0 27.4-10.6 63.3-21.4 87.9 25.2 45.5 33.3 97.6 26.9 141.2zM540.5 399.1c-53.7 0-102 39.7-104 94.9h208c-2-55.1-50.6-94.9-104-94.9zM320.6 602.9c-73 152.4 11.5 172.2 100.3 123.3-46.6-27.5-82.6-72.2-100.3-123.3z" } }] }, "name": "ie-circle", "theme": "filled" };
  exports.default = IeCircleFilled;
  });

  var IeCircleFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(IeCircleFilled_1);

  var IeCircleFilled = function IeCircleFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: IeCircleFilledSvg
    }));
  };
  var RefIcon$6y = /*#__PURE__*/React.forwardRef(IeCircleFilled);
  {
    RefIcon$6y.displayName = 'IeCircleFilled';
  }

  var IeOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var IeOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M852.6 367.6c16.3-36.9 32.1-90.7 32.1-131.8 0-109.1-119.5-147.6-314.5-57.9-161.4-10.8-316.8 110.5-355.6 279.7 46.3-52.3 117.4-123.4 183-151.7C316.1 378.3 246.7 470 194 565.6c-31.1 56.9-66 148.8-66 217.5 0 147.9 139.3 129.8 270.4 63 47.1 23.1 99.8 23.4 152.5 23.4 145.7 0 276.4-81.4 325.2-219H694.9c-78.8 132.9-295.2 79.5-295.2-71.2h493.2c9.6-65.4-2.5-143.6-40.3-211.7zM224.8 648.3c26.6 76.7 80.6 143.8 150.4 185-133.1 73.4-259.9 43.6-150.4-185zm174-163.3c3-82.7 75.4-142.3 156-142.3 80.1 0 153 59.6 156 142.3h-312zm276.8-281.4c32.1-15.4 72.8-33 108.8-33 47.1 0 81.4 32.6 81.4 80.6 0 30-11.1 73.5-21.9 101.8-39.3-63.5-98.9-122.4-168.3-149.4z" } }] }, "name": "ie", "theme": "outlined" };
  exports.default = IeOutlined;
  });

  var IeOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(IeOutlined_1);

  var IeOutlined = function IeOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: IeOutlinedSvg
    }));
  };
  var RefIcon$6z = /*#__PURE__*/React.forwardRef(IeOutlined);
  {
    RefIcon$6z.displayName = 'IeOutlined';
  }

  var IeSquareFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var IeSquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM765.9 556.9H437.1c0 100.4 144.3 136 196.8 47.4h120.8c-32.6 91.7-119.7 146-216.8 146-35.1 0-70.3-.1-101.7-15.6-87.4 44.5-180.3 56.6-180.3-42 0-45.8 23.2-107.1 44-145C335 484 381.3 422.8 435.6 374.5c-43.7 18.9-91.1 66.3-122 101.2 25.9-112.8 129.5-193.6 237.1-186.5 130-59.8 209.7-34.1 209.7 38.6 0 27.4-10.6 63.3-21.4 87.9 25.2 45.5 33.3 97.6 26.9 141.2zm-72.3-272.5c-24 0-51.1 11.7-72.6 22 46.3 18 86 57.3 112.3 99.6 7.1-18.9 14.6-47.9 14.6-67.9 0-32-22.8-53.7-54.3-53.7zM540.5 399.1c-53.7 0-102 39.7-104 94.9h208c-2-55.1-50.6-94.9-104-94.9zM320.6 602.9c-73 152.4 11.5 172.2 100.3 123.3-46.6-27.5-82.6-72.2-100.3-123.3z" } }] }, "name": "ie-square", "theme": "filled" };
  exports.default = IeSquareFilled;
  });

  var IeSquareFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(IeSquareFilled_1);

  var IeSquareFilled = function IeSquareFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: IeSquareFilledSvg
    }));
  };
  var RefIcon$6A = /*#__PURE__*/React.forwardRef(IeSquareFilled);
  {
    RefIcon$6A.displayName = 'IeSquareFilled';
  }

  var ImportOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ImportOutlined = { "icon": { "tag": "svg", "attrs": { "fill-rule": "evenodd", "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 912H144c-17.7 0-32-14.3-32-32V144c0-17.7 14.3-32 32-32h360c4.4 0 8 3.6 8 8v56c0 4.4-3.6 8-8 8H184v656h656V520c0-4.4 3.6-8 8-8h56c4.4 0 8 3.6 8 8v360c0 17.7-14.3 32-32 32zM653.3 424.6l52.2 52.2a8.01 8.01 0 01-4.7 13.6l-179.4 21c-5.1.6-9.5-3.7-8.9-8.9l21-179.4c.8-6.6 8.9-9.4 13.6-4.7l52.4 52.4 256.2-256.2c3.1-3.1 8.2-3.1 11.3 0l42.4 42.4c3.1 3.1 3.1 8.2 0 11.3L653.3 424.6z" } }] }, "name": "import", "theme": "outlined" };
  exports.default = ImportOutlined;
  });

  var ImportOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(ImportOutlined_1);

  var ImportOutlined = function ImportOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ImportOutlinedSvg
    }));
  };
  var RefIcon$6B = /*#__PURE__*/React.forwardRef(ImportOutlined);
  {
    RefIcon$6B.displayName = 'ImportOutlined';
  }

  var InboxOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var InboxOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M885.2 446.3l-.2-.8-112.2-285.1c-5-16.1-19.9-27.2-36.8-27.2H281.2c-17 0-32.1 11.3-36.9 27.6L139.4 443l-.3.7-.2.8c-1.3 4.9-1.7 9.9-1 14.8-.1 1.6-.2 3.2-.2 4.8V830a60.9 60.9 0 0060.8 60.8h627.2c33.5 0 60.8-27.3 60.9-60.8V464.1c0-1.3 0-2.6-.1-3.7.4-4.9 0-9.6-1.3-14.1zm-295.8-43l-.3 15.7c-.8 44.9-31.8 75.1-77.1 75.1-22.1 0-41.1-7.1-54.8-20.6S436 441.2 435.6 419l-.3-15.7H229.5L309 210h399.2l81.7 193.3H589.4zm-375 76.8h157.3c24.3 57.1 76 90.8 140.4 90.8 33.7 0 65-9.4 90.3-27.2 22.2-15.6 39.5-37.4 50.7-63.6h156.5V814H214.4V480.1z" } }] }, "name": "inbox", "theme": "outlined" };
  exports.default = InboxOutlined;
  });

  var InboxOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(InboxOutlined_1);

  var InboxOutlined = function InboxOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: InboxOutlinedSvg
    }));
  };
  var RefIcon$6C = /*#__PURE__*/React.forwardRef(InboxOutlined);
  {
    RefIcon$6C.displayName = 'InboxOutlined';
  }

  var InfoCircleFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var InfoCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm32 664c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V456c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v272zm-32-344a48.01 48.01 0 010-96 48.01 48.01 0 010 96z" } }] }, "name": "info-circle", "theme": "filled" };
  exports.default = InfoCircleFilled;
  });

  var InfoCircleFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(InfoCircleFilled_1);

  var InfoCircleFilled = function InfoCircleFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: InfoCircleFilledSvg
    }));
  };
  var RefIcon$6D = /*#__PURE__*/React.forwardRef(InfoCircleFilled);
  {
    RefIcon$6D.displayName = 'InfoCircleFilled';
  }

  var InfoCircleOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var InfoCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z" } }, { "tag": "path", "attrs": { "d": "M464 336a48 48 0 1096 0 48 48 0 10-96 0zm72 112h-48c-4.4 0-8 3.6-8 8v272c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V456c0-4.4-3.6-8-8-8z" } }] }, "name": "info-circle", "theme": "outlined" };
  exports.default = InfoCircleOutlined;
  });

  var InfoCircleOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(InfoCircleOutlined_1);

  var InfoCircleOutlined = function InfoCircleOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: InfoCircleOutlinedSvg
    }));
  };
  var RefIcon$6E = /*#__PURE__*/React.forwardRef(InfoCircleOutlined);
  {
    RefIcon$6E.displayName = 'InfoCircleOutlined';
  }

  var InfoCircleTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var InfoCircleTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm32 588c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V456c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v272zm-32-344a48.01 48.01 0 010-96 48.01 48.01 0 010 96z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M464 336a48 48 0 1096 0 48 48 0 10-96 0zm72 112h-48c-4.4 0-8 3.6-8 8v272c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V456c0-4.4-3.6-8-8-8z", "fill": primaryColor } }] }; }, "name": "info-circle", "theme": "twotone" };
  exports.default = InfoCircleTwoTone;
  });

  var InfoCircleTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(InfoCircleTwoTone_1);

  var InfoCircleTwoTone = function InfoCircleTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: InfoCircleTwoToneSvg
    }));
  };
  var RefIcon$6F = /*#__PURE__*/React.forwardRef(InfoCircleTwoTone);
  {
    RefIcon$6F.displayName = 'InfoCircleTwoTone';
  }

  var InfoOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var InfoOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M448 224a64 64 0 10128 0 64 64 0 10-128 0zm96 168h-64c-4.4 0-8 3.6-8 8v464c0 4.4 3.6 8 8 8h64c4.4 0 8-3.6 8-8V400c0-4.4-3.6-8-8-8z" } }] }, "name": "info", "theme": "outlined" };
  exports.default = InfoOutlined;
  });

  var InfoOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(InfoOutlined_1);

  var InfoOutlined = function InfoOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: InfoOutlinedSvg
    }));
  };
  var RefIcon$6G = /*#__PURE__*/React.forwardRef(InfoOutlined);
  {
    RefIcon$6G.displayName = 'InfoOutlined';
  }

  var InsertRowAboveOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var InsertRowAboveOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M878.7 336H145.3c-18.4 0-33.3 14.3-33.3 32v464c0 17.7 14.9 32 33.3 32h733.3c18.4 0 33.3-14.3 33.3-32V368c.1-17.7-14.8-32-33.2-32zM360 792H184V632h176v160zm0-224H184V408h176v160zm240 224H424V632h176v160zm0-224H424V408h176v160zm240 224H664V632h176v160zm0-224H664V408h176v160zm64-408H120c-4.4 0-8 3.6-8 8v80c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-80c0-4.4-3.6-8-8-8z" } }] }, "name": "insert-row-above", "theme": "outlined" };
  exports.default = InsertRowAboveOutlined;
  });

  var InsertRowAboveOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(InsertRowAboveOutlined_1);

  var InsertRowAboveOutlined = function InsertRowAboveOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: InsertRowAboveOutlinedSvg
    }));
  };
  var RefIcon$6H = /*#__PURE__*/React.forwardRef(InsertRowAboveOutlined);
  {
    RefIcon$6H.displayName = 'InsertRowAboveOutlined';
  }

  var InsertRowBelowOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var InsertRowBelowOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M904 768H120c-4.4 0-8 3.6-8 8v80c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-80c0-4.4-3.6-8-8-8zm-25.3-608H145.3c-18.4 0-33.3 14.3-33.3 32v464c0 17.7 14.9 32 33.3 32h733.3c18.4 0 33.3-14.3 33.3-32V192c.1-17.7-14.8-32-33.2-32zM360 616H184V456h176v160zm0-224H184V232h176v160zm240 224H424V456h176v160zm0-224H424V232h176v160zm240 224H664V456h176v160zm0-224H664V232h176v160z" } }] }, "name": "insert-row-below", "theme": "outlined" };
  exports.default = InsertRowBelowOutlined;
  });

  var InsertRowBelowOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(InsertRowBelowOutlined_1);

  var InsertRowBelowOutlined = function InsertRowBelowOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: InsertRowBelowOutlinedSvg
    }));
  };
  var RefIcon$6I = /*#__PURE__*/React.forwardRef(InsertRowBelowOutlined);
  {
    RefIcon$6I.displayName = 'InsertRowBelowOutlined';
  }

  var InsertRowLeftOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var InsertRowLeftOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M248 112h-80c-4.4 0-8 3.6-8 8v784c0 4.4 3.6 8 8 8h80c4.4 0 8-3.6 8-8V120c0-4.4-3.6-8-8-8zm584 0H368c-17.7 0-32 14.9-32 33.3v733.3c0 18.4 14.3 33.3 32 33.3h464c17.7 0 32-14.9 32-33.3V145.3c0-18.4-14.3-33.3-32-33.3zM568 840H408V664h160v176zm0-240H408V424h160v176zm0-240H408V184h160v176zm224 480H632V664h160v176zm0-240H632V424h160v176zm0-240H632V184h160v176z" } }] }, "name": "insert-row-left", "theme": "outlined" };
  exports.default = InsertRowLeftOutlined;
  });

  var InsertRowLeftOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(InsertRowLeftOutlined_1);

  var InsertRowLeftOutlined = function InsertRowLeftOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: InsertRowLeftOutlinedSvg
    }));
  };
  var RefIcon$6J = /*#__PURE__*/React.forwardRef(InsertRowLeftOutlined);
  {
    RefIcon$6J.displayName = 'InsertRowLeftOutlined';
  }

  var InsertRowRightOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var InsertRowRightOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M856 112h-80c-4.4 0-8 3.6-8 8v784c0 4.4 3.6 8 8 8h80c4.4 0 8-3.6 8-8V120c0-4.4-3.6-8-8-8zm-200 0H192c-17.7 0-32 14.9-32 33.3v733.3c0 18.4 14.3 33.3 32 33.3h464c17.7 0 32-14.9 32-33.3V145.3c0-18.4-14.3-33.3-32-33.3zM392 840H232V664h160v176zm0-240H232V424h160v176zm0-240H232V184h160v176zm224 480H456V664h160v176zm0-240H456V424h160v176zm0-240H456V184h160v176z" } }] }, "name": "insert-row-right", "theme": "outlined" };
  exports.default = InsertRowRightOutlined;
  });

  var InsertRowRightOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(InsertRowRightOutlined_1);

  var InsertRowRightOutlined = function InsertRowRightOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: InsertRowRightOutlinedSvg
    }));
  };
  var RefIcon$6K = /*#__PURE__*/React.forwardRef(InsertRowRightOutlined);
  {
    RefIcon$6K.displayName = 'InsertRowRightOutlined';
  }

  var InstagramFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var InstagramFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 378.7c-73.4 0-133.3 59.9-133.3 133.3S438.6 645.3 512 645.3 645.3 585.4 645.3 512 585.4 378.7 512 378.7zM911.8 512c0-55.2.5-109.9-2.6-165-3.1-64-17.7-120.8-64.5-167.6-46.9-46.9-103.6-61.4-167.6-64.5-55.2-3.1-109.9-2.6-165-2.6-55.2 0-109.9-.5-165 2.6-64 3.1-120.8 17.7-167.6 64.5C132.6 226.3 118.1 283 115 347c-3.1 55.2-2.6 109.9-2.6 165s-.5 109.9 2.6 165c3.1 64 17.7 120.8 64.5 167.6 46.9 46.9 103.6 61.4 167.6 64.5 55.2 3.1 109.9 2.6 165 2.6 55.2 0 109.9.5 165-2.6 64-3.1 120.8-17.7 167.6-64.5 46.9-46.9 61.4-103.6 64.5-167.6 3.2-55.1 2.6-109.8 2.6-165zM512 717.1c-113.5 0-205.1-91.6-205.1-205.1S398.5 306.9 512 306.9 717.1 398.5 717.1 512 625.5 717.1 512 717.1zm213.5-370.7c-26.5 0-47.9-21.4-47.9-47.9s21.4-47.9 47.9-47.9 47.9 21.4 47.9 47.9a47.84 47.84 0 01-47.9 47.9z" } }] }, "name": "instagram", "theme": "filled" };
  exports.default = InstagramFilled;
  });

  var InstagramFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(InstagramFilled_1);

  var InstagramFilled = function InstagramFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: InstagramFilledSvg
    }));
  };
  var RefIcon$6L = /*#__PURE__*/React.forwardRef(InstagramFilled);
  {
    RefIcon$6L.displayName = 'InstagramFilled';
  }

  var InstagramOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var InstagramOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 306.9c-113.5 0-205.1 91.6-205.1 205.1S398.5 717.1 512 717.1 717.1 625.5 717.1 512 625.5 306.9 512 306.9zm0 338.4c-73.4 0-133.3-59.9-133.3-133.3S438.6 378.7 512 378.7 645.3 438.6 645.3 512 585.4 645.3 512 645.3zm213.5-394.6c-26.5 0-47.9 21.4-47.9 47.9s21.4 47.9 47.9 47.9 47.9-21.3 47.9-47.9a47.84 47.84 0 00-47.9-47.9zM911.8 512c0-55.2.5-109.9-2.6-165-3.1-64-17.7-120.8-64.5-167.6-46.9-46.9-103.6-61.4-167.6-64.5-55.2-3.1-109.9-2.6-165-2.6-55.2 0-109.9-.5-165 2.6-64 3.1-120.8 17.7-167.6 64.5C132.6 226.3 118.1 283 115 347c-3.1 55.2-2.6 109.9-2.6 165s-.5 109.9 2.6 165c3.1 64 17.7 120.8 64.5 167.6 46.9 46.9 103.6 61.4 167.6 64.5 55.2 3.1 109.9 2.6 165 2.6 55.2 0 109.9.5 165-2.6 64-3.1 120.8-17.7 167.6-64.5 46.9-46.9 61.4-103.6 64.5-167.6 3.2-55.1 2.6-109.8 2.6-165zm-88 235.8c-7.3 18.2-16.1 31.8-30.2 45.8-14.1 14.1-27.6 22.9-45.8 30.2C695.2 844.7 570.3 840 512 840c-58.3 0-183.3 4.7-235.9-16.1-18.2-7.3-31.8-16.1-45.8-30.2-14.1-14.1-22.9-27.6-30.2-45.8C179.3 695.2 184 570.3 184 512c0-58.3-4.7-183.3 16.1-235.9 7.3-18.2 16.1-31.8 30.2-45.8s27.6-22.9 45.8-30.2C328.7 179.3 453.7 184 512 184s183.3-4.7 235.9 16.1c18.2 7.3 31.8 16.1 45.8 30.2 14.1 14.1 22.9 27.6 30.2 45.8C844.7 328.7 840 453.7 840 512c0 58.3 4.7 183.2-16.2 235.8z" } }] }, "name": "instagram", "theme": "outlined" };
  exports.default = InstagramOutlined;
  });

  var InstagramOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(InstagramOutlined_1);

  var InstagramOutlined = function InstagramOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: InstagramOutlinedSvg
    }));
  };
  var RefIcon$6M = /*#__PURE__*/React.forwardRef(InstagramOutlined);
  {
    RefIcon$6M.displayName = 'InstagramOutlined';
  }

  var InsuranceFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var InsuranceFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M519.9 358.8h97.9v41.6h-97.9zm347-188.9L527.1 54.1C523 52.7 517.5 52 512 52s-11 .7-15.1 2.1L157.1 169.9c-8.3 2.8-15.1 12.4-15.1 21.2v482.4c0 8.8 5.7 20.4 12.6 25.9L499.3 968c3.5 2.7 8 4.1 12.6 4.1s9.2-1.4 12.6-4.1l344.7-268.6c6.9-5.4 12.6-17 12.6-25.9V191.1c.2-8.8-6.6-18.3-14.9-21.2zM411.3 656h-.2c0 4.4-3.6 8-8 8h-37.3c-4.4 0-8-3.6-8-8V471.4c-7.7 9.2-15.4 17.9-23.1 26a6.04 6.04 0 01-10.2-2.4l-13.2-43.5c-.6-2-.2-4.1 1.2-5.6 37-43.4 64.7-95.1 82.2-153.6 1.1-3.5 5-5.3 8.4-3.7l38.6 18.3c2.7 1.3 4.1 4.4 3.2 7.2a429.2 429.2 0 01-33.6 79V656zm296.5-49.2l-26.3 35.3a5.92 5.92 0 01-8.9.7c-30.6-29.3-56.8-65.2-78.1-106.9V656c0 4.4-3.6 8-8 8h-36.2c-4.4 0-8-3.6-8-8V536c-22 44.7-49 80.8-80.6 107.6a5.9 5.9 0 01-8.9-1.4L430 605.7a6 6 0 011.6-8.1c28.6-20.3 51.9-45.2 71-76h-55.1c-4.4 0-8-3.6-8-8V478c0-4.4 3.6-8 8-8h94.9v-18.6h-65.9c-4.4 0-8-3.6-8-8V316c0-4.4 3.6-8 8-8h184.7c4.4 0 8 3.6 8 8v127.2c0 4.4-3.6 8-8 8h-66.7v18.6h98.8c4.4 0 8 3.6 8 8v35.6c0 4.4-3.6 8-8 8h-59c18.1 29.1 41.8 54.3 72.3 76.9 2.6 2.1 3.2 5.9 1.2 8.5z" } }] }, "name": "insurance", "theme": "filled" };
  exports.default = InsuranceFilled;
  });

  var InsuranceFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(InsuranceFilled_1);

  var InsuranceFilled = function InsuranceFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: InsuranceFilledSvg
    }));
  };
  var RefIcon$6N = /*#__PURE__*/React.forwardRef(InsuranceFilled);
  {
    RefIcon$6N.displayName = 'InsuranceFilled';
  }

  var InsuranceOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var InsuranceOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M441.6 306.8L403 288.6a6.1 6.1 0 00-8.4 3.7c-17.5 58.5-45.2 110.1-82.2 153.6a6.05 6.05 0 00-1.2 5.6l13.2 43.5c1.3 4.4 7 5.7 10.2 2.4 7.7-8.1 15.4-16.9 23.1-26V656c0 4.4 3.6 8 8 8H403c4.4 0 8-3.6 8-8V393.1a429.2 429.2 0 0033.6-79c1-2.9-.3-6-3-7.3zm26.8 9.2v127.2c0 4.4 3.6 8 8 8h65.9v18.6h-94.9c-4.4 0-8 3.6-8 8v35.6c0 4.4 3.6 8 8 8h55.1c-19.1 30.8-42.4 55.7-71 76a6 6 0 00-1.6 8.1l22.8 36.5c1.9 3.1 6.2 3.8 8.9 1.4 31.6-26.8 58.7-62.9 80.6-107.6v120c0 4.4 3.6 8 8 8h36.2c4.4 0 8-3.6 8-8V536c21.3 41.7 47.5 77.5 78.1 106.9 2.6 2.5 6.8 2.1 8.9-.7l26.3-35.3c2-2.7 1.4-6.5-1.2-8.4-30.5-22.6-54.2-47.8-72.3-76.9h59c4.4 0 8-3.6 8-8V478c0-4.4-3.6-8-8-8h-98.8v-18.6h66.7c4.4 0 8-3.6 8-8V316c0-4.4-3.6-8-8-8H476.4c-4.4 0-8 3.6-8 8zm51.5 42.8h97.9v41.6h-97.9v-41.6zm347-188.9L527.1 54.1C523 52.7 517.5 52 512 52s-11 .7-15.1 2.1L157.1 169.9c-8.3 2.8-15.1 12.4-15.1 21.2v482.4c0 8.8 5.7 20.4 12.6 25.9L499.3 968c3.5 2.7 8 4.1 12.6 4.1s9.2-1.4 12.6-4.1l344.7-268.6c6.9-5.4 12.6-17 12.6-25.9V191.1c.2-8.8-6.6-18.3-14.9-21.2zM810 654.3L512 886.5 214 654.3V226.7l298-101.6 298 101.6v427.6z" } }] }, "name": "insurance", "theme": "outlined" };
  exports.default = InsuranceOutlined;
  });

  var InsuranceOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(InsuranceOutlined_1);

  var InsuranceOutlined = function InsuranceOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: InsuranceOutlinedSvg
    }));
  };
  var RefIcon$6O = /*#__PURE__*/React.forwardRef(InsuranceOutlined);
  {
    RefIcon$6O.displayName = 'InsuranceOutlined';
  }

  var InsuranceTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var InsuranceTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M866.9 169.9L527.1 54.1C523 52.7 517.5 52 512 52s-11 .7-15.1 2.1L157.1 169.9c-8.3 2.8-15.1 12.4-15.1 21.2v482.4c0 8.8 5.7 20.4 12.6 25.9L499.3 968c3.5 2.7 8 4.1 12.6 4.1s9.2-1.4 12.6-4.1l344.7-268.6c6.9-5.4 12.6-17 12.6-25.9V191.1c.2-8.8-6.6-18.3-14.9-21.2zM810 654.3L512 886.5 214 654.3V226.7l298-101.6 298 101.6v427.6z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M521.9 358.8h97.9v41.6h-97.9z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M214 226.7v427.6l298 232.2 298-232.2V226.7L512 125.1 214 226.7zM413.3 656h-.2c0 4.4-3.6 8-8 8h-37.3c-4.4 0-8-3.6-8-8V471.4c-7.7 9.2-15.4 17.9-23.1 26a6.04 6.04 0 01-10.2-2.4l-13.2-43.5c-.6-2-.2-4.1 1.2-5.6 37-43.4 64.7-95.1 82.2-153.6 1.1-3.5 5-5.3 8.4-3.7l38.6 18.3c2.7 1.3 4.1 4.4 3.2 7.2a429.2 429.2 0 01-33.6 79V656zm257.9-340v127.2c0 4.4-3.6 8-8 8h-66.7v18.6h98.8c4.4 0 8 3.6 8 8v35.6c0 4.4-3.6 8-8 8h-59c18.1 29.1 41.8 54.3 72.3 76.9 2.6 2.1 3.2 5.9 1.2 8.5l-26.3 35.3a5.92 5.92 0 01-8.9.7c-30.6-29.3-56.8-65.2-78.1-106.9V656c0 4.4-3.6 8-8 8h-36.2c-4.4 0-8-3.6-8-8V536c-22 44.7-49 80.8-80.6 107.6a6.38 6.38 0 01-4.8 1.4c-1.7-.3-3.2-1.3-4.1-2.8L432 605.7a6 6 0 011.6-8.1c28.6-20.3 51.9-45.2 71-76h-55.1c-4.4 0-8-3.6-8-8V478c0-4.4 3.6-8 8-8h94.9v-18.6h-65.9c-4.4 0-8-3.6-8-8V316c0-4.4 3.6-8 8-8h184.7c4.4 0 8 3.6 8 8z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M443.7 306.9l-38.6-18.3c-3.4-1.6-7.3.2-8.4 3.7-17.5 58.5-45.2 110.2-82.2 153.6a5.7 5.7 0 00-1.2 5.6l13.2 43.5c1.4 4.5 7 5.8 10.2 2.4 7.7-8.1 15.4-16.8 23.1-26V656c0 4.4 3.6 8 8 8h37.3c4.4 0 8-3.6 8-8h.2V393.1a429.2 429.2 0 0033.6-79c.9-2.8-.5-5.9-3.2-7.2zm26.8 9.1v127.4c0 4.4 3.6 8 8 8h65.9V470h-94.9c-4.4 0-8 3.6-8 8v35.6c0 4.4 3.6 8 8 8h55.1c-19.1 30.8-42.4 55.7-71 76a6 6 0 00-1.6 8.1l22.8 36.5c.9 1.5 2.4 2.5 4.1 2.8 1.7.3 3.5-.2 4.8-1.4 31.6-26.8 58.6-62.9 80.6-107.6v120c0 4.4 3.6 8 8 8h36.2c4.4 0 8-3.6 8-8V535.9c21.3 41.7 47.5 77.6 78.1 106.9 2.6 2.5 6.7 2.2 8.9-.7l26.3-35.3c2-2.6 1.4-6.4-1.2-8.5-30.5-22.6-54.2-47.8-72.3-76.9h59c4.4 0 8-3.6 8-8v-35.6c0-4.4-3.6-8-8-8h-98.8v-18.6h66.7c4.4 0 8-3.6 8-8V316c0-4.4-3.6-8-8-8H478.5c-4.4 0-8 3.6-8 8zm51.4 42.8h97.9v41.6h-97.9v-41.6z", "fill": primaryColor } }] }; }, "name": "insurance", "theme": "twotone" };
  exports.default = InsuranceTwoTone;
  });

  var InsuranceTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(InsuranceTwoTone_1);

  var InsuranceTwoTone = function InsuranceTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: InsuranceTwoToneSvg
    }));
  };
  var RefIcon$6P = /*#__PURE__*/React.forwardRef(InsuranceTwoTone);
  {
    RefIcon$6P.displayName = 'InsuranceTwoTone';
  }

  var InteractionFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var InteractionFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM726 585.7c0 55.3-44.7 100.1-99.7 100.1H420.6v53.4c0 5.7-6.5 8.8-10.9 5.3l-109.1-85.7c-3.5-2.7-3.5-8 0-10.7l109.1-85.7c4.4-3.5 10.9-.3 10.9 5.3v53.4h205.7c19.6 0 35.5-16 35.5-35.6v-78.9c0-3.7 3-6.8 6.8-6.8h50.7c3.7 0 6.8 3 6.8 6.8v79.1zm-2.6-209.9l-109.1 85.7c-4.4 3.5-10.9.3-10.9-5.3v-53.4H397.7c-19.6 0-35.5 16-35.5 35.6v78.9c0 3.7-3 6.8-6.8 6.8h-50.7c-3.7 0-6.8-3-6.8-6.8v-78.9c0-55.3 44.7-100.1 99.7-100.1h205.7v-53.4c0-5.7 6.5-8.8 10.9-5.3l109.1 85.7c3.6 2.5 3.6 7.8.1 10.5z" } }] }, "name": "interaction", "theme": "filled" };
  exports.default = InteractionFilled;
  });

  var InteractionFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(InteractionFilled_1);

  var InteractionFilled = function InteractionFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: InteractionFilledSvg
    }));
  };
  var RefIcon$6Q = /*#__PURE__*/React.forwardRef(InteractionFilled);
  {
    RefIcon$6Q.displayName = 'InteractionFilled';
  }

  var InteractionOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var InteractionOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656zM304.8 524h50.7c3.7 0 6.8-3 6.8-6.8v-78.9c0-19.7 15.9-35.6 35.5-35.6h205.7v53.4c0 5.7 6.5 8.8 10.9 5.3l109.1-85.7c3.5-2.7 3.5-8 0-10.7l-109.1-85.7c-4.4-3.5-10.9-.3-10.9 5.3V338H397.7c-55.1 0-99.7 44.8-99.7 100.1V517c0 4 3 7 6.8 7zm-4.2 134.9l109.1 85.7c4.4 3.5 10.9.3 10.9-5.3v-53.4h205.7c55.1 0 99.7-44.8 99.7-100.1v-78.9c0-3.7-3-6.8-6.8-6.8h-50.7c-3.7 0-6.8 3-6.8 6.8v78.9c0 19.7-15.9 35.6-35.5 35.6H420.6V568c0-5.7-6.5-8.8-10.9-5.3l-109.1 85.7c-3.5 2.5-3.5 7.8 0 10.5z" } }] }, "name": "interaction", "theme": "outlined" };
  exports.default = InteractionOutlined;
  });

  var InteractionOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(InteractionOutlined_1);

  var InteractionOutlined = function InteractionOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: InteractionOutlinedSvg
    }));
  };
  var RefIcon$6R = /*#__PURE__*/React.forwardRef(InteractionOutlined);
  {
    RefIcon$6R.displayName = 'InteractionOutlined';
  }

  var InteractionTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var InteractionTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M184 840h656V184H184v656zm114-401.9c0-55.3 44.6-100.1 99.7-100.1h205.8v-53.4c0-5.6 6.5-8.8 10.9-5.3L723.5 365c3.5 2.7 3.5 8 0 10.7l-109.1 85.7c-4.4 3.5-10.9.4-10.9-5.3v-53.4H397.8c-19.6 0-35.5 15.9-35.5 35.6v78.9c0 3.8-3.1 6.8-6.8 6.8h-50.7c-3.8 0-6.8-3-6.8-7v-78.9zm2.6 210.3l109.1-85.7c4.4-3.5 10.9-.4 10.9 5.3v53.4h205.6c19.6 0 35.5-15.9 35.5-35.6v-78.9c0-3.8 3.1-6.8 6.8-6.8h50.7c3.8 0 6.8 3.1 6.8 6.8v78.9c0 55.3-44.6 100.1-99.7 100.1H420.6v53.4c0 5.6-6.5 8.8-10.9 5.3l-109.1-85.7c-3.5-2.7-3.5-8 0-10.5z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M304.8 524h50.7c3.7 0 6.8-3 6.8-6.8v-78.9c0-19.7 15.9-35.6 35.5-35.6h205.7v53.4c0 5.7 6.5 8.8 10.9 5.3l109.1-85.7c3.5-2.7 3.5-8 0-10.7l-109.1-85.7c-4.4-3.5-10.9-.3-10.9 5.3V338H397.7c-55.1 0-99.7 44.8-99.7 100.1V517c0 4 3 7 6.8 7zm-4.2 134.9l109.1 85.7c4.4 3.5 10.9.3 10.9-5.3v-53.4h205.7c55.1 0 99.7-44.8 99.7-100.1v-78.9c0-3.7-3-6.8-6.8-6.8h-50.7c-3.7 0-6.8 3-6.8 6.8v78.9c0 19.7-15.9 35.6-35.5 35.6H420.6V568c0-5.7-6.5-8.8-10.9-5.3l-109.1 85.7c-3.5 2.5-3.5 7.8 0 10.5z", "fill": primaryColor } }] }; }, "name": "interaction", "theme": "twotone" };
  exports.default = InteractionTwoTone;
  });

  var InteractionTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(InteractionTwoTone_1);

  var InteractionTwoTone = function InteractionTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: InteractionTwoToneSvg
    }));
  };
  var RefIcon$6S = /*#__PURE__*/React.forwardRef(InteractionTwoTone);
  {
    RefIcon$6S.displayName = 'InteractionTwoTone';
  }

  var IssuesCloseOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var IssuesCloseOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M464 688a48 48 0 1096 0 48 48 0 10-96 0zm72-112c4.4 0 8-3.6 8-8V296c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v272c0 4.4 3.6 8 8 8h48zm400-188h-59.3c-2.6 0-5 1.2-6.5 3.3L763.7 538.1l-49.9-68.8a7.92 7.92 0 00-6.5-3.3H648c-6.5 0-10.3 7.4-6.5 12.7l109.2 150.7a16.1 16.1 0 0026 0l165.8-228.7c3.8-5.3 0-12.7-6.5-12.7zm-44 306h-64.2c-5.5 0-10.6 2.9-13.6 7.5a352.2 352.2 0 01-49.8 62.2A355.92 355.92 0 01651.1 840a355 355 0 01-138.7 27.9c-48.1 0-94.8-9.4-138.7-27.9a355.92 355.92 0 01-113.3-76.3A353.06 353.06 0 01184 650.5c-18.6-43.8-28-90.5-28-138.5s9.4-94.7 28-138.5c17.9-42.4 43.6-80.5 76.4-113.2 32.8-32.7 70.9-58.4 113.3-76.3a355 355 0 01138.7-27.9c48.1 0 94.8 9.4 138.7 27.9 42.4 17.9 80.5 43.6 113.3 76.3 19 19 35.6 39.8 49.8 62.2 2.9 4.7 8.1 7.5 13.6 7.5H892c6 0 9.8-6.3 7.2-11.6C828.8 178.5 684.7 82 517.7 80 278.9 77.2 80.5 272.5 80 511.2 79.5 750.1 273.3 944 512.4 944c169.2 0 315.6-97 386.7-238.4A8 8 0 00892 694z" } }] }, "name": "issues-close", "theme": "outlined" };
  exports.default = IssuesCloseOutlined;
  });

  var IssuesCloseOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(IssuesCloseOutlined_1);

  var IssuesCloseOutlined = function IssuesCloseOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: IssuesCloseOutlinedSvg
    }));
  };
  var RefIcon$6T = /*#__PURE__*/React.forwardRef(IssuesCloseOutlined);
  {
    RefIcon$6T.displayName = 'IssuesCloseOutlined';
  }

  var ItalicOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ItalicOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M798 160H366c-4.4 0-8 3.6-8 8v64c0 4.4 3.6 8 8 8h181.2l-156 544H229c-4.4 0-8 3.6-8 8v64c0 4.4 3.6 8 8 8h432c4.4 0 8-3.6 8-8v-64c0-4.4-3.6-8-8-8H474.4l156-544H798c4.4 0 8-3.6 8-8v-64c0-4.4-3.6-8-8-8z" } }] }, "name": "italic", "theme": "outlined" };
  exports.default = ItalicOutlined;
  });

  var ItalicOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(ItalicOutlined_1);

  var ItalicOutlined = function ItalicOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ItalicOutlinedSvg
    }));
  };
  var RefIcon$6U = /*#__PURE__*/React.forwardRef(ItalicOutlined);
  {
    RefIcon$6U.displayName = 'ItalicOutlined';
  }

  var JavaOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var JavaOutlined = { "icon": { "tag": "svg", "attrs": { "fill-rule": "evenodd", "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M394.68 756.99s-34.33 19.95 24.34 26.6c71.1 8.05 107.35 7 185.64-7.87 0 0 20.66 12.94 49.38 24.14-175.47 75.08-397.18-4.37-259.36-42.87m-21.37-98.17s-38.35 28.35 20.32 34.47c75.83 7.88 135.9 8.4 239.57-11.55 0 0 14.36 14.53 36.95 22.4-212.43 62.13-448.84 5.08-296.84-45.32m180.73-166.43c43.26 49.7-11.38 94.5-11.38 94.5s109.8-56.7 59.37-127.57c-47.11-66.15-83.19-99.05 112.25-212.27.18 0-306.82 76.65-160.24 245.35m232.22 337.04s25.4 20.82-27.85 37.1c-101.4 30.62-421.7 39.9-510.66 1.22-32.05-13.82 28.02-33.25 46.93-37.27 19.62-4.2 31-3.5 31-3.5-35.55-25.03-229.94 49.17-98.77 70.35 357.6 58.1 652.16-26.08 559.35-67.9m-375.12-272.3s-163.04 38.68-57.79 52.68c44.48 5.95 133.1 4.55 215.58-2.28 67.42-5.6 135.2-17.85 135.2-17.85s-23.82 10.15-40.98 21.88c-165.5 43.57-485.1 23.27-393.16-21.18 77.93-37.45 141.15-33.25 141.15-33.25M703.6 720.42c168.3-87.33 90.37-171.33 36.08-159.95-13.31 2.8-19.27 5.25-19.27 5.25s4.9-7.7 14.36-11.03C842.12 516.9 924.78 666 700.1 724.97c0-.18 2.63-2.45 3.5-4.55M602.03 64s93.16 93.1-88.44 236.25c-145.53 114.8-33.27 180.42 0 255.14-84.94-76.65-147.28-144.02-105.42-206.84C469.63 256.67 639.68 211.87 602.03 64M427.78 957.19C589.24 967.5 837.22 951.4 843 875.1c0 0-11.2 28.88-133.44 51.98-137.83 25.9-307.87 22.92-408.57 6.3 0-.18 20.66 16.97 126.79 23.8" } }] }, "name": "java", "theme": "outlined" };
  exports.default = JavaOutlined;
  });

  var JavaOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(JavaOutlined_1);

  var JavaOutlined = function JavaOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: JavaOutlinedSvg
    }));
  };
  var RefIcon$6V = /*#__PURE__*/React.forwardRef(JavaOutlined);
  {
    RefIcon$6V.displayName = 'JavaOutlined';
  }

  var JavaScriptOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var JavaScriptOutlined = { "icon": { "tag": "svg", "attrs": { "fill-rule": "evenodd", "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M416 176H255.54v425.62c0 105.3-36.16 134.71-99.1 134.71-29.5 0-56.05-5.05-76.72-12.14L63 848.79C92.48 858.91 137.73 865 173.13 865 317.63 865 416 797.16 416 602.66zm349.49-16C610.26 160 512 248.13 512 364.6c0 100.32 75.67 163.13 185.7 203.64 79.57 28.36 111.03 53.7 111.03 95.22 0 45.57-36.36 74.96-105.13 74.96-63.87 0-121.85-21.31-161.15-42.58v-.04L512 822.43C549.36 843.73 619.12 865 694.74 865 876.52 865 961 767.75 961 653.3c0-97.25-54.04-160.04-170.94-204.63-86.47-34.44-122.81-53.67-122.81-97.23 0-34.45 31.45-65.84 96.3-65.84 63.83 0 107.73 21.45 133.3 34.64l38.34-128.19C895.1 174.46 841.11 160 765.5 160" } }] }, "name": "java-script", "theme": "outlined" };
  exports.default = JavaScriptOutlined;
  });

  var JavaScriptOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(JavaScriptOutlined_1);

  var JavaScriptOutlined = function JavaScriptOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: JavaScriptOutlinedSvg
    }));
  };
  var RefIcon$6W = /*#__PURE__*/React.forwardRef(JavaScriptOutlined);
  {
    RefIcon$6W.displayName = 'JavaScriptOutlined';
  }

  var KeyOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var KeyOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M608 112c-167.9 0-304 136.1-304 304 0 70.3 23.9 135 63.9 186.5l-41.1 41.1-62.3-62.3a8.15 8.15 0 00-11.4 0l-39.8 39.8a8.15 8.15 0 000 11.4l62.3 62.3-44.9 44.9-62.3-62.3a8.15 8.15 0 00-11.4 0l-39.8 39.8a8.15 8.15 0 000 11.4l62.3 62.3-65.3 65.3a8.03 8.03 0 000 11.3l42.3 42.3c3.1 3.1 8.2 3.1 11.3 0l253.6-253.6A304.06 304.06 0 00608 720c167.9 0 304-136.1 304-304S775.9 112 608 112zm161.2 465.2C726.2 620.3 668.9 644 608 644c-60.9 0-118.2-23.7-161.2-66.8-43.1-43-66.8-100.3-66.8-161.2 0-60.9 23.7-118.2 66.8-161.2 43-43.1 100.3-66.8 161.2-66.8 60.9 0 118.2 23.7 161.2 66.8 43.1 43 66.8 100.3 66.8 161.2 0 60.9-23.7 118.2-66.8 161.2z" } }] }, "name": "key", "theme": "outlined" };
  exports.default = KeyOutlined;
  });

  var KeyOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(KeyOutlined_1);

  var KeyOutlined = function KeyOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: KeyOutlinedSvg
    }));
  };
  var RefIcon$6X = /*#__PURE__*/React.forwardRef(KeyOutlined);
  {
    RefIcon$6X.displayName = 'KeyOutlined';
  }

  var KubernetesOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var KubernetesOutlined = { "icon": { "tag": "svg", "attrs": { "fill-rule": "evenodd", "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M511.99 111a61.55 61.55 0 00-26.8 6.13l-271.3 131a61.71 61.71 0 00-33.32 41.85L113.53 584.5a61.77 61.77 0 0011.86 52.06L313.2 872.71a61.68 61.68 0 0048.26 23.27h301.05a61.68 61.68 0 0048.26-23.27l187.81-236.12v-.03a61.73 61.73 0 0011.9-52.03v-.03L843.4 289.98v-.04a61.72 61.72 0 00-33.3-41.8l-271.28-131a17.43 17.43 0 00-.03-.04 61.76 61.76 0 00-26.8-6.1m0 35.1c3.94 0 7.87.87 11.55 2.64l271.3 131a26.54 26.54 0 0114.36 18.02l67.04 294.52a26.56 26.56 0 01-5.1 22.45L683.31 850.88a26.51 26.51 0 01-20.8 10H361.45a26.45 26.45 0 01-20.77-10L152.88 614.73a26.59 26.59 0 01-5.14-22.45l67.07-294.49a26.51 26.51 0 0114.32-18.02v-.04l271.3-131A26.52 26.52 0 01512 146.1m-.14 73.82c-2.48 0-4.99.5-7.4 1.51-9.65 4.21-14.22 15.44-10.01 25.09 4.04 9.48 5.42 18.94 6.48 28.41.35 4.92.55 9.66.37 14.4.53 4.74-1.94 9.48-5.45 14.22-3.68 4.74-4.03 9.49-4.55 14.23-48.16 4.72-91.51 25.83-124.65 57.54l-.31-.17c-4.04-2.63-7.88-5.27-14.02-5.45-5.79-.35-11.06-1.4-14.4-4.9-3.68-2.8-7.35-5.95-10.69-9.29-6.84-6.67-13.36-13.87-18.1-23a19.66 19.66 0 00-11.58-9.5 19.27 19.27 0 00-23.68 13.17c-2.98 10 2.98 20.7 13.16 23.51 9.83 2.99 18.08 7.9 26.15 13.16a127.38 127.38 0 0111.24 8.6c4.04 2.64 6.13 7.55 7.71 13.17 1.16 5.62 4.39 8.88 7.54 12.03a209.26 209.26 0 00-37.08 142.61c-3.94 1.38-7.83 2.88-11.17 6.82-3.86 4.39-8.08 7.88-12.82 8.23a94.03 94.03 0 01-14.02 2.64c-9.47 1.23-19.13 1.93-29.13-.17a19.53 19.53 0 00-14.74 3.32c-8.6 5.97-10.52 17.9-4.56 26.5a19.13 19.13 0 0026.67 4.59c8.42-5.97 17.37-9.32 26.5-12.3 4.55-1.41 9.13-2.62 13.87-3.5 4.56-1.58 9.64-.2 15.08 2.09 4.52 2.33 8.52 2.15 12.48 1.75 15.44 50.08 49.22 92.03 93.32 118.52-1.5 4.21-2.92 8.6-1.57 14.15 1.05 5.8 1.22 11.25-1.24 15.29a172.58 172.58 0 01-6.3 12.78c-4.92 8.07-10.17 16.15-17.9 23.17a18.97 18.97 0 00-6.33 13.5 19.06 19.06 0 0018.43 19.68A19.21 19.21 0 00409 787.88c.17-10.35 2.97-19.46 6.13-28.59 1.58-4.38 3.52-8.77 5.62-12.99 1.58-4.56 5.78-7.92 10.87-10.72 5.07-2.62 7.35-6.32 9.63-10.22a209.09 209.09 0 0070.74 12.51c25.26 0 49.4-4.72 71.87-12.92 2.37 4.06 4.82 7.91 9.9 10.63 5.1 2.98 9.29 6.16 10.87 10.72 2.1 4.4 3.87 8.78 5.45 13.17 3.15 9.12 5.78 18.23 6.13 28.58 0 5.09 2.1 10.02 6.14 13.71a19.32 19.32 0 0027.04-1.23 19.32 19.32 0 00-1.24-27.05c-7.72-6.84-12.98-15.09-17.72-23.34-2.28-4.03-4.37-8.4-6.3-12.6-2.46-4.22-2.3-9.5-1.06-15.3 1.4-5.96-.18-10.34-1.58-14.9l-.14-.45c43.76-26.75 77.09-68.83 92.2-118.9l.58.04c4.91.35 9.64.85 14.9-2.13 5.27-2.46 10.56-3.87 15.12-2.47 4.56.7 9.29 1.76 13.85 2.99 9.12 2.63 18.27 5.79 26.87 11.58a19.5 19.5 0 0014.73 2.64 18.99 18.99 0 0014.57-22.62 19.11 19.11 0 00-22.82-14.57c-10.18 2.28-19.66 1.9-29.3 1.03-4.75-.53-9.32-1.2-14.06-2.26-4.74-.35-8.92-3.5-12.96-7.71-4.03-4.74-8.6-5.97-13.16-7.37l-.3-.1c.6-6.51.99-13.08.99-19.75 0-43.5-13.28-83.99-35.99-117.6 3.33-3.5 6.7-6.82 7.92-12.78 1.58-5.61 3.68-10.53 7.71-13.16 3.51-3.16 7.38-5.96 11.24-8.77 7.9-5.27 16.16-10.36 25.98-13.16a18.5 18.5 0 0011.55-9.67 18.8 18.8 0 00-8.22-25.6 18.84 18.84 0 00-25.64 8.22c-4.74 9.13-11.22 16.33-17.89 23-3.51 3.34-7 6.51-10.7 9.5-3.33 3.5-8.6 4.55-14.39 4.9-6.14.17-10.01 2.99-14.05 5.62a210 210 0 00-127.4-60.02c-.52-4.73-.87-9.48-4.55-14.22-3.51-4.74-5.98-9.48-5.45-14.22-.17-4.74.03-9.48.38-14.4 1.05-9.47 2.44-18.94 6.48-28.41 1.93-4.56 2.1-10 0-15.08a19.23 19.23 0 00-17.69-11.52m-25.16 133.91l-.85 6.75c-2.46 18.96-4.21 38.08-5.97 57.04a876 876 0 00-2.64 30.2c-8.6-6.15-17.2-12.66-26.32-18.45-15.79-10.7-31.6-21.42-47.91-31.6l-5.52-3.43a174.43 174.43 0 0189.21-40.5m50.59 0a174.38 174.38 0 0192.16 43.21l-5.86 3.7c-16.14 10.35-31.74 21.07-47.54 31.77a491.28 491.28 0 00-18.44 13 7.3 7.3 0 01-11.58-5.46c-.53-7.54-1.22-14.9-1.92-22.45-1.75-18.95-3.5-38.08-5.96-57.03zm-173 78.82l5.58 5.83c13.33 13.86 26.86 27.2 40.54 40.71 5.8 5.8 11.58 11.26 17.55 16.7a7.19 7.19 0 01-2.81 12.27c-8.6 2.63-17.21 5.07-25.8 7.88-18.08 5.97-36.32 11.6-54.4 18.1l-7.95 2.77c-.17-3.2-.48-6.37-.48-9.63 0-34.92 10.27-67.33 27.76-94.63m297.52 3.46a174.67 174.67 0 0125.67 91.17c0 2.93-.3 5.78-.44 8.67l-6.24-1.98c-18.25-5.97-36.48-11.09-54.9-16.35a900.54 900.54 0 00-35.82-9.63c8.95-8.6 18.27-17.04 26.87-25.81 13.51-13.51 27-27.02 40.17-41.06zM501.12 492.2h21.39c3.33 0 6.5 1.58 8.26 4.04l13.67 17.2a10.65 10.65 0 012.13 8.57l-4.94 21.25c-.52 3.34-2.81 5.96-5.62 7.54l-19.64 9.12a9.36 9.36 0 01-9.11 0l-19.67-9.12c-2.81-1.58-5.27-4.2-5.63-7.54l-4.9-21.25c-.52-2.98.2-6.28 2.13-8.56l13.67-17.2a10.25 10.25 0 018.26-4.05m-63.37 83.7c5.44-.88 9.85 4.57 7.75 9.66a784.28 784.28 0 00-9.5 26.15 1976.84 1976.84 0 00-18.78 54.22l-2.4 7.54a175.26 175.26 0 01-68-87.3l9.33-.78c19.13-1.76 37.9-4.06 57.03-6.34 8.25-.88 16.33-2.1 24.57-3.16m151.63 2.47c8.24.88 16.32 1.77 24.57 2.47 19.13 1.75 38.07 3.5 57.2 4.73l6.1.34a175.25 175.25 0 01-66.6 86.58l-1.98-6.38c-5.79-18.25-12.1-36.32-18.23-54.22a951.58 951.58 0 00-8.6-23.85 7.16 7.16 0 017.54-9.67m-76.1 34.62c2.5 0 5.01 1.26 6.42 3.8a526.47 526.47 0 0012.13 21.77c9.48 16.5 18.92 33.17 29.1 49.32l4.15 6.71a176.03 176.03 0 01-53.1 8.2 176.14 176.14 0 01-51.57-7.72l4.38-7.02c10.18-16.15 19.83-32.66 29.48-49.15a451.58 451.58 0 0012.65-22.1 7.2 7.2 0 016.37-3.81" } }] }, "name": "kubernetes", "theme": "outlined" };
  exports.default = KubernetesOutlined;
  });

  var KubernetesOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(KubernetesOutlined_1);

  var KubernetesOutlined = function KubernetesOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: KubernetesOutlinedSvg
    }));
  };
  var RefIcon$6Y = /*#__PURE__*/React.forwardRef(KubernetesOutlined);
  {
    RefIcon$6Y.displayName = 'KubernetesOutlined';
  }

  var LaptopOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var LaptopOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M956.9 845.1L896.4 632V168c0-17.7-14.3-32-32-32h-704c-17.7 0-32 14.3-32 32v464L67.9 845.1C60.4 866 75.8 888 98 888h828.8c22.2 0 37.6-22 30.1-42.9zM200.4 208h624v395h-624V208zm228.3 608l8.1-37h150.3l8.1 37H428.7zm224 0l-19.1-86.7c-.8-3.7-4.1-6.3-7.8-6.3H398.2c-3.8 0-7 2.6-7.8 6.3L371.3 816H151l42.3-149h638.2l42.3 149H652.7z" } }] }, "name": "laptop", "theme": "outlined" };
  exports.default = LaptopOutlined;
  });

  var LaptopOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(LaptopOutlined_1);

  var LaptopOutlined = function LaptopOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: LaptopOutlinedSvg
    }));
  };
  var RefIcon$6Z = /*#__PURE__*/React.forwardRef(LaptopOutlined);
  {
    RefIcon$6Z.displayName = 'LaptopOutlined';
  }

  var LayoutFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var LayoutFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M384 912h496c17.7 0 32-14.3 32-32V340H384v572zm496-800H384v164h528V144c0-17.7-14.3-32-32-32zm-768 32v736c0 17.7 14.3 32 32 32h176V112H144c-17.7 0-32 14.3-32 32z" } }] }, "name": "layout", "theme": "filled" };
  exports.default = LayoutFilled;
  });

  var LayoutFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(LayoutFilled_1);

  var LayoutFilled = function LayoutFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: LayoutFilledSvg
    }));
  };
  var RefIcon$6_ = /*#__PURE__*/React.forwardRef(LayoutFilled);
  {
    RefIcon$6_.displayName = 'LayoutFilled';
  }

  var LayoutOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var LayoutOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-696 72h136v656H184V184zm656 656H384V384h456v456zM384 320V184h456v136H384z" } }] }, "name": "layout", "theme": "outlined" };
  exports.default = LayoutOutlined;
  });

  var LayoutOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(LayoutOutlined_1);

  var LayoutOutlined = function LayoutOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: LayoutOutlinedSvg
    }));
  };
  var RefIcon$6$ = /*#__PURE__*/React.forwardRef(LayoutOutlined);
  {
    RefIcon$6$.displayName = 'LayoutOutlined';
  }

  var LayoutTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var LayoutTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M384 185h456v136H384zm-200 0h136v656H184zm696-73H144c-17.7 0-32 14.3-32 32v1c0-17.7 14.3-32 32-32h736c17.7 0 32 14.3 32 32v-1c0-17.7-14.3-32-32-32zM384 385h456v456H384z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M880 113H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V145c0-17.7-14.3-32-32-32zM320 841H184V185h136v656zm520 0H384V385h456v456zm0-520H384V185h456v136z", "fill": primaryColor } }] }; }, "name": "layout", "theme": "twotone" };
  exports.default = LayoutTwoTone;
  });

  var LayoutTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(LayoutTwoTone_1);

  var LayoutTwoTone = function LayoutTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: LayoutTwoToneSvg
    }));
  };
  var RefIcon$70 = /*#__PURE__*/React.forwardRef(LayoutTwoTone);
  {
    RefIcon$70.displayName = 'LayoutTwoTone';
  }

  var LeftCircleFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var LeftCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm104 316.9c0 10.2-4.9 19.9-13.2 25.9L457.4 512l145.4 105.2c8.3 6 13.2 15.6 13.2 25.9V690c0 6.5-7.4 10.3-12.7 6.5l-246-178a7.95 7.95 0 010-12.9l246-178a8 8 0 0112.7 6.5v46.8z" } }] }, "name": "left-circle", "theme": "filled" };
  exports.default = LeftCircleFilled;
  });

  var LeftCircleFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(LeftCircleFilled_1);

  var LeftCircleFilled = function LeftCircleFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: LeftCircleFilledSvg
    }));
  };
  var RefIcon$71 = /*#__PURE__*/React.forwardRef(LeftCircleFilled);
  {
    RefIcon$71.displayName = 'LeftCircleFilled';
  }

  var LeftCircleOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var LeftCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M603.3 327.5l-246 178a7.95 7.95 0 000 12.9l246 178c5.3 3.8 12.7 0 12.7-6.5V643c0-10.2-4.9-19.9-13.2-25.9L457.4 512l145.4-105.2c8.3-6 13.2-15.6 13.2-25.9V334c0-6.5-7.4-10.3-12.7-6.5z" } }, { "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z" } }] }, "name": "left-circle", "theme": "outlined" };
  exports.default = LeftCircleOutlined;
  });

  var LeftCircleOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(LeftCircleOutlined_1);

  var LeftCircleOutlined = function LeftCircleOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: LeftCircleOutlinedSvg
    }));
  };
  var RefIcon$72 = /*#__PURE__*/React.forwardRef(LeftCircleOutlined);
  {
    RefIcon$72.displayName = 'LeftCircleOutlined';
  }

  var LeftCircleTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var LeftCircleTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm104 240.9c0 10.3-4.9 19.9-13.2 25.9L457.4 512l145.4 105.1c8.3 6 13.2 15.7 13.2 25.9v46.9c0 6.5-7.4 10.3-12.7 6.5l-246-178a7.95 7.95 0 010-12.9l246-178c5.3-3.8 12.7 0 12.7 6.5v46.9z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M603.3 327.5l-246 178a7.95 7.95 0 000 12.9l246 178c5.3 3.8 12.7 0 12.7-6.5V643c0-10.2-4.9-19.9-13.2-25.9L457.4 512l145.4-105.2c8.3-6 13.2-15.6 13.2-25.9V334c0-6.5-7.4-10.3-12.7-6.5z", "fill": primaryColor } }] }; }, "name": "left-circle", "theme": "twotone" };
  exports.default = LeftCircleTwoTone;
  });

  var LeftCircleTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(LeftCircleTwoTone_1);

  var LeftCircleTwoTone = function LeftCircleTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: LeftCircleTwoToneSvg
    }));
  };
  var RefIcon$73 = /*#__PURE__*/React.forwardRef(LeftCircleTwoTone);
  {
    RefIcon$73.displayName = 'LeftCircleTwoTone';
  }

  var LeftOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var LeftOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M724 218.3V141c0-6.7-7.7-10.4-12.9-6.3L260.3 486.8a31.86 31.86 0 000 50.3l450.8 352.1c5.3 4.1 12.9.4 12.9-6.3v-77.3c0-4.9-2.3-9.6-6.1-12.6l-360-281 360-281.1c3.8-3 6.1-7.7 6.1-12.6z" } }] }, "name": "left", "theme": "outlined" };
  exports.default = LeftOutlined;
  });

  var LeftOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(LeftOutlined_1);

  var LeftOutlined = function LeftOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: LeftOutlinedSvg
    }));
  };
  var RefIcon$74 = /*#__PURE__*/React.forwardRef(LeftOutlined);
  {
    RefIcon$74.displayName = 'LeftOutlined';
  }

  var LeftSquareFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var LeftSquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM624 380.9c0 10.2-4.9 19.9-13.2 25.9L465.4 512l145.4 105.2c8.3 6 13.2 15.6 13.2 25.9V690c0 6.5-7.4 10.3-12.7 6.5l-246-178a7.95 7.95 0 010-12.9l246-178c5.3-3.8 12.7 0 12.7 6.5v46.8z" } }] }, "name": "left-square", "theme": "filled" };
  exports.default = LeftSquareFilled;
  });

  var LeftSquareFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(LeftSquareFilled_1);

  var LeftSquareFilled = function LeftSquareFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: LeftSquareFilledSvg
    }));
  };
  var RefIcon$75 = /*#__PURE__*/React.forwardRef(LeftSquareFilled);
  {
    RefIcon$75.displayName = 'LeftSquareFilled';
  }

  var LeftSquareOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var LeftSquareOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M365.3 518.5l246 178c5.3 3.8 12.7 0 12.7-6.5v-46.9c0-10.2-4.9-19.9-13.2-25.9L465.4 512l145.4-105.2c8.3-6 13.2-15.6 13.2-25.9V334c0-6.5-7.4-10.3-12.7-6.5l-246 178a8.05 8.05 0 000 13z" } }, { "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z" } }] }, "name": "left-square", "theme": "outlined" };
  exports.default = LeftSquareOutlined;
  });

  var LeftSquareOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(LeftSquareOutlined_1);

  var LeftSquareOutlined = function LeftSquareOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: LeftSquareOutlinedSvg
    }));
  };
  var RefIcon$76 = /*#__PURE__*/React.forwardRef(LeftSquareOutlined);
  {
    RefIcon$76.displayName = 'LeftSquareOutlined';
  }

  var LeftSquareTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var LeftSquareTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M184 840h656V184H184v656zm181.3-334.5l246-178c5.3-3.8 12.7 0 12.7 6.5v46.9c0 10.3-4.9 19.9-13.2 25.9L465.4 512l145.4 105.2c8.3 6 13.2 15.7 13.2 25.9V690c0 6.5-7.4 10.3-12.7 6.4l-246-178a7.95 7.95 0 010-12.9z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M365.3 518.4l246 178c5.3 3.9 12.7.1 12.7-6.4v-46.9c0-10.2-4.9-19.9-13.2-25.9L465.4 512l145.4-105.2c8.3-6 13.2-15.6 13.2-25.9V334c0-6.5-7.4-10.3-12.7-6.5l-246 178a7.95 7.95 0 000 12.9z", "fill": primaryColor } }] }; }, "name": "left-square", "theme": "twotone" };
  exports.default = LeftSquareTwoTone;
  });

  var LeftSquareTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(LeftSquareTwoTone_1);

  var LeftSquareTwoTone = function LeftSquareTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: LeftSquareTwoToneSvg
    }));
  };
  var RefIcon$77 = /*#__PURE__*/React.forwardRef(LeftSquareTwoTone);
  {
    RefIcon$77.displayName = 'LeftSquareTwoTone';
  }

  var LikeFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var LikeFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M885.9 533.7c16.8-22.2 26.1-49.4 26.1-77.7 0-44.9-25.1-87.4-65.5-111.1a67.67 67.67 0 00-34.3-9.3H572.4l6-122.9c1.4-29.7-9.1-57.9-29.5-79.4A106.62 106.62 0 00471 99.9c-52 0-98 35-111.8 85.1l-85.9 311h-.3v428h472.3c9.2 0 18.2-1.8 26.5-5.4 47.6-20.3 78.3-66.8 78.3-118.4 0-12.6-1.8-25-5.4-37 16.8-22.2 26.1-49.4 26.1-77.7 0-12.6-1.8-25-5.4-37 16.8-22.2 26.1-49.4 26.1-77.7-.2-12.6-2-25.1-5.6-37.1zM112 528v364c0 17.7 14.3 32 32 32h65V496h-65c-17.7 0-32 14.3-32 32z" } }] }, "name": "like", "theme": "filled" };
  exports.default = LikeFilled;
  });

  var LikeFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(LikeFilled_1);

  var LikeFilled = function LikeFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: LikeFilledSvg
    }));
  };
  var RefIcon$78 = /*#__PURE__*/React.forwardRef(LikeFilled);
  {
    RefIcon$78.displayName = 'LikeFilled';
  }

  var LikeOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var LikeOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M885.9 533.7c16.8-22.2 26.1-49.4 26.1-77.7 0-44.9-25.1-87.4-65.5-111.1a67.67 67.67 0 00-34.3-9.3H572.4l6-122.9c1.4-29.7-9.1-57.9-29.5-79.4A106.62 106.62 0 00471 99.9c-52 0-98 35-111.8 85.1l-85.9 311H144c-17.7 0-32 14.3-32 32v364c0 17.7 14.3 32 32 32h601.3c9.2 0 18.2-1.8 26.5-5.4 47.6-20.3 78.3-66.8 78.3-118.4 0-12.6-1.8-25-5.4-37 16.8-22.2 26.1-49.4 26.1-77.7 0-12.6-1.8-25-5.4-37 16.8-22.2 26.1-49.4 26.1-77.7-.2-12.6-2-25.1-5.6-37.1zM184 852V568h81v284h-81zm636.4-353l-21.9 19 13.9 25.4a56.2 56.2 0 016.9 27.3c0 16.5-7.2 32.2-19.6 43l-21.9 19 13.9 25.4a56.2 56.2 0 016.9 27.3c0 16.5-7.2 32.2-19.6 43l-21.9 19 13.9 25.4a56.2 56.2 0 016.9 27.3c0 22.4-13.2 42.6-33.6 51.8H329V564.8l99.5-360.5a44.1 44.1 0 0142.2-32.3c7.6 0 15.1 2.2 21.1 6.7 9.9 7.4 15.2 18.6 14.6 30.5l-9.6 198.4h314.4C829 418.5 840 436.9 840 456c0 16.5-7.2 32.1-19.6 43z" } }] }, "name": "like", "theme": "outlined" };
  exports.default = LikeOutlined;
  });

  var LikeOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(LikeOutlined_1);

  var LikeOutlined = function LikeOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: LikeOutlinedSvg
    }));
  };
  var RefIcon$79 = /*#__PURE__*/React.forwardRef(LikeOutlined);
  {
    RefIcon$79.displayName = 'LikeOutlined';
  }

  var LikeTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var LikeTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M273 495.9v428l.3-428zm538.2-88.3H496.8l9.6-198.4c.6-11.9-4.7-23.1-14.6-30.5-6.1-4.5-13.6-6.8-21.1-6.7-19.6.1-36.9 13.4-42.2 32.3-37.1 134.4-64.9 235.2-83.5 302.5V852h399.4a56.85 56.85 0 0033.6-51.8c0-9.7-2.3-18.9-6.9-27.3l-13.9-25.4 21.9-19a56.76 56.76 0 0019.6-43c0-9.7-2.3-18.9-6.9-27.3l-13.9-25.4 21.9-19a56.76 56.76 0 0019.6-43c0-9.7-2.3-18.9-6.9-27.3l-14-25.5 21.9-19a56.76 56.76 0 0019.6-43c0-19.1-11-37.5-28.8-48.4z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M112 528v364c0 17.7 14.3 32 32 32h65V496h-65c-17.7 0-32 14.3-32 32zm773.9 5.7c16.8-22.2 26.1-49.4 26.1-77.7 0-44.9-25.1-87.5-65.5-111a67.67 67.67 0 00-34.3-9.3H572.3l6-122.9c1.5-29.7-9-57.9-29.5-79.4a106.4 106.4 0 00-77.9-33.4c-52 0-98 35-111.8 85.1l-85.8 310.8-.3 428h472.1c9.3 0 18.2-1.8 26.5-5.4 47.6-20.3 78.3-66.8 78.3-118.4 0-12.6-1.8-25-5.4-37 16.8-22.2 26.1-49.4 26.1-77.7 0-12.6-1.8-25-5.4-37 16.8-22.2 26.1-49.4 26.1-77.7 0-12.6-1.8-25-5.4-37zM820.4 499l-21.9 19 14 25.5a56.2 56.2 0 016.9 27.3c0 16.5-7.1 32.2-19.6 43l-21.9 19 13.9 25.4a56.2 56.2 0 016.9 27.3c0 16.5-7.1 32.2-19.6 43l-21.9 19 13.9 25.4a56.2 56.2 0 016.9 27.3c0 22.4-13.2 42.6-33.6 51.8H345V506.8c18.6-67.2 46.4-168 83.5-302.5a44.28 44.28 0 0142.2-32.3c7.5-.1 15 2.2 21.1 6.7 9.9 7.4 15.2 18.6 14.6 30.5l-9.6 198.4h314.4C829 418.5 840 436.9 840 456c0 16.5-7.1 32.2-19.6 43z", "fill": primaryColor } }] }; }, "name": "like", "theme": "twotone" };
  exports.default = LikeTwoTone;
  });

  var LikeTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(LikeTwoTone_1);

  var LikeTwoTone = function LikeTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: LikeTwoToneSvg
    }));
  };
  var RefIcon$7a = /*#__PURE__*/React.forwardRef(LikeTwoTone);
  {
    RefIcon$7a.displayName = 'LikeTwoTone';
  }

  var LineChartOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var LineChartOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M888 792H200V168c0-4.4-3.6-8-8-8h-56c-4.4 0-8 3.6-8 8v688c0 4.4 3.6 8 8 8h752c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM305.8 637.7c3.1 3.1 8.1 3.1 11.3 0l138.3-137.6L583 628.5c3.1 3.1 8.2 3.1 11.3 0l275.4-275.3c3.1-3.1 3.1-8.2 0-11.3l-39.6-39.6a8.03 8.03 0 00-11.3 0l-230 229.9L461.4 404a8.03 8.03 0 00-11.3 0L266.3 586.7a8.03 8.03 0 000 11.3l39.5 39.7z" } }] }, "name": "line-chart", "theme": "outlined" };
  exports.default = LineChartOutlined;
  });

  var LineChartOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(LineChartOutlined_1);

  var LineChartOutlined = function LineChartOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: LineChartOutlinedSvg
    }));
  };
  var RefIcon$7b = /*#__PURE__*/React.forwardRef(LineChartOutlined);
  {
    RefIcon$7b.displayName = 'LineChartOutlined';
  }

  var LineHeightOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var LineHeightOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M648 160H104c-4.4 0-8 3.6-8 8v128c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8v-64h168v560h-92c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h264c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8h-92V232h168v64c0 4.4 3.6 8 8 8h56c4.4 0 8-3.6 8-8V168c0-4.4-3.6-8-8-8zm272.8 546H856V318h64.8c6 0 9.4-7 5.7-11.7L825.7 178.7a7.14 7.14 0 00-11.3 0L713.6 306.3a7.23 7.23 0 005.7 11.7H784v388h-64.8c-6 0-9.4 7-5.7 11.7l100.8 127.5c2.9 3.7 8.5 3.7 11.3 0l100.8-127.5a7.2 7.2 0 00-5.6-11.7z" } }] }, "name": "line-height", "theme": "outlined" };
  exports.default = LineHeightOutlined;
  });

  var LineHeightOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(LineHeightOutlined_1);

  var LineHeightOutlined = function LineHeightOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: LineHeightOutlinedSvg
    }));
  };
  var RefIcon$7c = /*#__PURE__*/React.forwardRef(LineHeightOutlined);
  {
    RefIcon$7c.displayName = 'LineHeightOutlined';
  }

  var LineOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var LineOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M904 476H120c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8z" } }] }, "name": "line", "theme": "outlined" };
  exports.default = LineOutlined;
  });

  var LineOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(LineOutlined_1);

  var LineOutlined = function LineOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: LineOutlinedSvg
    }));
  };
  var RefIcon$7d = /*#__PURE__*/React.forwardRef(LineOutlined);
  {
    RefIcon$7d.displayName = 'LineOutlined';
  }

  var LinkOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var LinkOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M574 665.4a8.03 8.03 0 00-11.3 0L446.5 781.6c-53.8 53.8-144.6 59.5-204 0-59.5-59.5-53.8-150.2 0-204l116.2-116.2c3.1-3.1 3.1-8.2 0-11.3l-39.8-39.8a8.03 8.03 0 00-11.3 0L191.4 526.5c-84.6 84.6-84.6 221.5 0 306s221.5 84.6 306 0l116.2-116.2c3.1-3.1 3.1-8.2 0-11.3L574 665.4zm258.6-474c-84.6-84.6-221.5-84.6-306 0L410.3 307.6a8.03 8.03 0 000 11.3l39.7 39.7c3.1 3.1 8.2 3.1 11.3 0l116.2-116.2c53.8-53.8 144.6-59.5 204 0 59.5 59.5 53.8 150.2 0 204L665.3 562.6a8.03 8.03 0 000 11.3l39.8 39.8c3.1 3.1 8.2 3.1 11.3 0l116.2-116.2c84.5-84.6 84.5-221.5 0-306.1zM610.1 372.3a8.03 8.03 0 00-11.3 0L372.3 598.7a8.03 8.03 0 000 11.3l39.6 39.6c3.1 3.1 8.2 3.1 11.3 0l226.4-226.4c3.1-3.1 3.1-8.2 0-11.3l-39.5-39.6z" } }] }, "name": "link", "theme": "outlined" };
  exports.default = LinkOutlined;
  });

  var LinkOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(LinkOutlined_1);

  var LinkOutlined = function LinkOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: LinkOutlinedSvg
    }));
  };
  var RefIcon$7e = /*#__PURE__*/React.forwardRef(LinkOutlined);
  {
    RefIcon$7e.displayName = 'LinkOutlined';
  }

  var LinkedinFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var LinkedinFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM349.3 793.7H230.6V411.9h118.7v381.8zm-59.3-434a68.8 68.8 0 1168.8-68.8c-.1 38-30.9 68.8-68.8 68.8zm503.7 434H675.1V608c0-44.3-.8-101.2-61.7-101.2-61.7 0-71.2 48.2-71.2 98v188.9H423.7V411.9h113.8v52.2h1.6c15.8-30 54.5-61.7 112.3-61.7 120.2 0 142.3 79.1 142.3 181.9v209.4z" } }] }, "name": "linkedin", "theme": "filled" };
  exports.default = LinkedinFilled;
  });

  var LinkedinFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(LinkedinFilled_1);

  var LinkedinFilled = function LinkedinFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: LinkedinFilledSvg
    }));
  };
  var RefIcon$7f = /*#__PURE__*/React.forwardRef(LinkedinFilled);
  {
    RefIcon$7f.displayName = 'LinkedinFilled';
  }

  var LinkedinOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var LinkedinOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M847.7 112H176.3c-35.5 0-64.3 28.8-64.3 64.3v671.4c0 35.5 28.8 64.3 64.3 64.3h671.4c35.5 0 64.3-28.8 64.3-64.3V176.3c0-35.5-28.8-64.3-64.3-64.3zm0 736c-447.8-.1-671.7-.2-671.7-.3.1-447.8.2-671.7.3-671.7 447.8.1 671.7.2 671.7.3-.1 447.8-.2 671.7-.3 671.7zM230.6 411.9h118.7v381.8H230.6zm59.4-52.2c37.9 0 68.8-30.8 68.8-68.8a68.8 68.8 0 10-137.6 0c-.1 38 30.7 68.8 68.8 68.8zm252.3 245.1c0-49.8 9.5-98 71.2-98 60.8 0 61.7 56.9 61.7 101.2v185.7h118.6V584.3c0-102.8-22.2-181.9-142.3-181.9-57.7 0-96.4 31.7-112.3 61.7h-1.6v-52.2H423.7v381.8h118.6V604.8z" } }] }, "name": "linkedin", "theme": "outlined" };
  exports.default = LinkedinOutlined;
  });

  var LinkedinOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(LinkedinOutlined_1);

  var LinkedinOutlined = function LinkedinOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: LinkedinOutlinedSvg
    }));
  };
  var RefIcon$7g = /*#__PURE__*/React.forwardRef(LinkedinOutlined);
  {
    RefIcon$7g.displayName = 'LinkedinOutlined';
  }

  var LinuxOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var LinuxOutlined = { "icon": { "tag": "svg", "attrs": { "fill-rule": "evenodd", "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M530.8 64c-5.79 0-11.76.3-17.88.78-157.8 12.44-115.95 179.45-118.34 235.11-2.88 40.8-11.2 72.95-39.24 112.78-33.03 39.23-79.4 102.66-101.39 168.77-10.37 31.06-15.3 62.87-10.71 92.92a15.83 15.83 0 00-4.14 5.04c-9.7 10-16.76 22.43-24.72 31.32-7.42 7.43-18.1 9.96-29.75 14.93-11.68 5.08-24.56 10.04-32.25 25.42a49.7 49.7 0 00-4.93 22.43c0 7.43 1 14.97 2.05 20.01 2.17 14.9 4.33 27.22 1.46 36.21-9.26 25.39-10.42 42.79-3.92 55.44 6.5 12.47 19.97 17.51 35.05 22.44 30.28 7.46 71.3 5.04 103.6 22.36 34.56 17.43 69.66 25.05 97.65 17.54a66.01 66.01 0 0045.1-35.27c21.91-.12 45.92-10.05 84.37-12.47 26.09-2.17 58.75 9.97 96.23 7.43.94 5.04 2.36 7.43 4.26 12.47l.11.1c14.6 29.05 41.55 42.27 70.33 39.99 28.78-2.24 59.43-20.01 84.26-48.76 23.55-28.55 62.83-40.46 88.77-56.1 12.99-7.43 23.48-17.51 24.23-31.85.86-14.93-7.43-30.3-26.66-51.4v-3.62l-.1-.11c-6.35-7.47-9.34-19.98-12.63-34.57-3.17-14.97-6.8-29.34-18.36-39.05h-.11c-2.2-2.02-4.6-2.5-7.02-5.04a13.33 13.33 0 00-7.1-2.39c16.1-47.7 9.86-95.2-6.45-137.9-19.9-52.63-54.7-98.48-81.2-130.02-29.71-37.52-58.83-73.06-58.27-125.77 1-80.33 8.85-228.95-132.3-229.17m19.75 127.11h.48c7.95 0 14.79 2.31 21.8 7.4 7.13 5.03 12.32 12.39 16.4 19.89 3.91 9.67 5.89 17.13 6.19 27.03 0-.75.22-1.5.22-2.2v3.88a3.21 3.21 0 01-.15-.79l-.15-.9a67.46 67.46 0 01-5.6 26.36 35.58 35.58 0 01-7.95 12.5 26.5 26.5 0 00-3.28-1.56c-3.92-1.68-7.43-2.39-10.64-4.96a48.98 48.98 0 00-8.18-2.47c1.83-2.2 5.42-4.96 6.8-7.39a44.22 44.22 0 003.28-15v-.72a45.17 45.17 0 00-2.27-14.93c-1.68-5.04-3.77-7.5-6.84-12.47-3.13-2.46-6.23-4.92-9.96-4.92h-.6c-3.47 0-6.57 1.12-9.78 4.92a29.86 29.86 0 00-7.65 12.47 44.05 44.05 0 00-3.36 14.93v.71c.07 3.33.3 6.69.74 9.97-7.2-2.5-16.35-5.04-22.66-7.54-.37-2.46-.6-4.94-.67-7.43v-.75a66.15 66.15 0 015.6-28.7 40.45 40.45 0 0116.05-19.9 36.77 36.77 0 0122.18-7.43m-110.58 2.2h1.35c5.3 0 10.08 1.8 14.9 5.04a51.6 51.6 0 0112.83 17.36c3.36 7.43 5.27 14.97 5.72 24.9v.15c.26 5 .22 7.5-.08 9.93v2.99c-1.12.26-2.09.67-3.1.9-5.67 2.05-10.23 5.03-14.67 7.46.45-3.32.49-6.68.11-9.97v-.56c-.44-4.96-1.45-7.43-3.06-12.43a22.88 22.88 0 00-6.2-9.97 9.26 9.26 0 00-6.83-2.39h-.78c-2.65.23-4.85 1.53-6.94 4.93a20.6 20.6 0 00-4.48 10.08 35.24 35.24 0 00-.86 12.36v.52c.45 5.04 1.38 7.5 3.02 12.47 1.68 5 3.62 7.46 6.16 10 .41.34.79.67 1.27.9-2.61 2.13-4.37 2.61-6.57 5.08a11.39 11.39 0 01-4.89 2.53 97.84 97.84 0 01-10.27-15 66.15 66.15 0 01-5.78-24.9 65.67 65.67 0 012.98-24.94 53.38 53.38 0 0110.57-19.97c4.78-4.97 9.7-7.47 15.6-7.47M491.15 257c12.36 0 27.33 2.43 45.36 14.9 10.94 7.46 19.52 10.04 39.31 17.47h.11c9.52 5.07 15.12 9.93 17.84 14.9v-4.9a21.32 21.32 0 01.6 17.55c-4.59 11.6-19.26 24.04-39.72 31.47v.07c-10 5.04-18.7 12.43-28.93 17.36-10.3 5.04-21.95 10.9-37.78 9.97a42.52 42.52 0 01-16.72-2.5 133.12 133.12 0 01-12.02-7.4c-7.28-5.04-13.55-12.39-22.85-17.36v-.18h-.19c-14.93-9.19-22.99-19.12-25.6-26.54-2.58-10-.19-17.51 7.2-22.4 8.36-5.04 14.19-10.12 18.03-12.55 3.88-2.76 5.34-3.8 6.57-4.89h.08v-.1c6.3-7.55 16.27-17.52 31.32-22.44a68.65 68.65 0 0117.4-2.43m104.48 80c13.4 52.9 44.69 129.72 64.8 166.98 10.68 19.93 31.93 61.93 41.15 112.89 5.82-.19 12.28.67 19.15 2.39 24.11-62.38-20.39-129.43-40.66-148.06-8.25-7.5-8.66-12.5-4.59-12.5 21.99 19.93 50.96 58.68 61.45 102.92 4.81 19.97 5.93 41.21.78 62.34 2.5 1.05 5.04 2.28 7.65 2.5 38.53 19.94 52.75 35.02 45.92 57.38v-1.6c-2.27-.12-4.48 0-6.75 0h-.56c5.63-17.44-6.8-30.8-39.76-45.7-34.16-14.93-61.45-12.54-66.11 17.36-.27 1.6-.45 2.46-.64 5.04-2.54.86-5.19 1.98-7.8 2.39-16.05 10-24.71 24.97-29.6 44.31-4.86 19.9-6.35 43.16-7.66 69.77v.11c-.78 12.47-6.38 31.29-11.9 50.44-56 40.01-133.65 57.41-199.69 12.46a98.74 98.74 0 00-15-19.9 54.13 54.13 0 00-10.27-12.46c6.8 0 12.62-1.08 17.36-2.5a22.96 22.96 0 0011.72-12.47c4.03-9.97 0-26.02-12.88-43.42C398.87 730.24 377 710.53 345 690.9c-23.51-14.89-36.8-32.47-42.93-52.1-6.16-19.94-5.33-40.51-.56-61.42 9.15-39.94 32.6-78.77 47.56-103.14 4-2.43 1.38 5.04-15.23 36.36-14.78 28.03-42.6 93.21-4.55 143.87a303.27 303.27 0 0124.15-107.36c21.06-47.71 65.07-130.81 68.54-196.66 1.8 1.34 8.1 5.04 10.79 7.54 8.14 4.96 14.18 12.43 22.02 17.36 7.88 7.5 17.81 12.5 32.7 12.5 1.46.12 2.8.23 4.15.23 15.34 0 27.21-5 37.18-10 10.83-5 19.45-12.48 27.63-14.94h.18c17.44-5.04 31.21-15 39.01-26.13m81.6 334.4c1.39 22.44 12.81 46.48 32.93 51.41 21.95 5 53.53-12.43 66.86-28.56l7.88-.33c11.76-.3 21.54.37 31.62 9.97l.1.1c7.77 7.44 11.4 19.83 14.6 32.7 3.18 14.98 5.75 29.13 15.27 39.8 18.15 19.68 24.08 33.82 23.75 42.56l.1-.22v.67l-.1-.45c-.56 9.78-6.91 14.78-18.6 22.21-23.51 14.97-65.17 26.58-91.72 58.61-23.07 27.51-51.18 42.52-76 44.46-24.79 1.98-46.18-7.46-58.76-33.52l-.19-.11c-7.84-14.97-4.48-38.27 2.1-63.1 6.56-24.93 15.97-50.2 17.28-70.85 1.38-26.65 2.83-49.83 7.28-67.71 4.48-17.36 11.5-29.76 23.93-36.74l1.68-.82zm-403.72 1.84h.37c1.98 0 3.92.18 5.86.52 14.04 2.05 26.35 12.43 38.19 28.07l33.97 62.12.11.11c9.07 19.9 28.15 39.72 44.39 61.15 16.2 22.32 28.74 42.22 27.21 58.61v.22c-2.13 27.78-17.88 42.86-42 48.3-24.07 5.05-56.74.08-89.4-17.31-36.14-20.01-79.07-17.51-106.66-22.48-13.77-2.46-22.8-7.5-26.99-14.97-4.14-7.42-4.21-22.43 4.6-45.91v-.11l.07-.12c4.37-12.46 1.12-28.1-1-41.77-2.06-14.97-3.1-26.47 1.6-35.09 5.97-12.47 14.78-14.9 25.72-19.9 11.01-5.04 23.93-7.54 34.2-17.5h.07v-.12c9.55-10 16.61-22.43 24.93-31.28 7.1-7.5 14.19-12.54 24.75-12.54M540.76 334.5c-16.24 7.5-35.27 19.97-55.54 19.97-20.24 0-36.21-9.97-47.75-17.4-5.79-5-10.45-10-13.96-12.5-6.12-5-5.38-12.47-2.76-12.47 4.07.6 4.81 5.04 7.43 7.5 3.58 2.47 8.02 7.43 13.47 12.43 10.86 7.47 25.39 17.44 43.53 17.44 18.1 0 39.3-9.97 52.19-17.4 7.28-5.04 16.6-12.47 24.19-17.43 5.82-5.12 5.56-10 10.41-10 4.82.6 1.27 5-5.48 12.42a302.3 302.3 0 01-25.76 17.47v-.03zm-40.39-59.13v-.83c-.22-.7.49-1.56 1.09-1.86 2.76-1.6 6.72-1.01 9.7.15 2.35 0 5.97 2.5 5.6 5.04-.22 1.83-3.17 2.46-5.04 2.46-2.05 0-3.43-1.6-5.26-2.54-1.94-.67-5.45-.3-6.09-2.42m-20.57 0c-.74 2.16-4.22 1.82-6.2 2.46-1.75.93-3.2 2.54-5.18 2.54-1.9 0-4.9-.71-5.12-2.54-.33-2.47 3.29-4.97 5.6-4.97 3.03-1.15 6.87-1.75 9.67-.18.71.33 1.35 1.12 1.12 1.86v.79h.11z" } }] }, "name": "linux", "theme": "outlined" };
  exports.default = LinuxOutlined;
  });

  var LinuxOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(LinuxOutlined_1);

  var LinuxOutlined = function LinuxOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: LinuxOutlinedSvg
    }));
  };
  var RefIcon$7h = /*#__PURE__*/React.forwardRef(LinuxOutlined);
  {
    RefIcon$7h.displayName = 'LinuxOutlined';
  }

  var Loading3QuartersOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var Loading3QuartersOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 1024c-69.1 0-136.2-13.5-199.3-40.2C251.7 958 197 921 150 874c-47-47-84-101.7-109.8-162.7C13.5 648.2 0 581.1 0 512c0-19.9 16.1-36 36-36s36 16.1 36 36c0 59.4 11.6 117 34.6 171.3 22.2 52.4 53.9 99.5 94.3 139.9 40.4 40.4 87.5 72.2 139.9 94.3C395 940.4 452.6 952 512 952c59.4 0 117-11.6 171.3-34.6 52.4-22.2 99.5-53.9 139.9-94.3 40.4-40.4 72.2-87.5 94.3-139.9C940.4 629 952 571.4 952 512c0-59.4-11.6-117-34.6-171.3a440.45 440.45 0 00-94.3-139.9 437.71 437.71 0 00-139.9-94.3C629 83.6 571.4 72 512 72c-19.9 0-36-16.1-36-36s16.1-36 36-36c69.1 0 136.2 13.5 199.3 40.2C772.3 66 827 103 874 150c47 47 83.9 101.8 109.7 162.7 26.7 63.1 40.2 130.2 40.2 199.3s-13.5 136.2-40.2 199.3C958 772.3 921 827 874 874c-47 47-101.8 83.9-162.7 109.7-63.1 26.8-130.2 40.3-199.3 40.3z" } }] }, "name": "loading-3-quarters", "theme": "outlined" };
  exports.default = Loading3QuartersOutlined;
  });

  var Loading3QuartersOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(Loading3QuartersOutlined_1);

  var Loading3QuartersOutlined = function Loading3QuartersOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: Loading3QuartersOutlinedSvg
    }));
  };
  var RefIcon$7i = /*#__PURE__*/React.forwardRef(Loading3QuartersOutlined);
  {
    RefIcon$7i.displayName = 'Loading3QuartersOutlined';
  }

  var LoadingOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var LoadingOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M988 548c-19.9 0-36-16.1-36-36 0-59.4-11.6-117-34.6-171.3a440.45 440.45 0 00-94.3-139.9 437.71 437.71 0 00-139.9-94.3C629 83.6 571.4 72 512 72c-19.9 0-36-16.1-36-36s16.1-36 36-36c69.1 0 136.2 13.5 199.3 40.3C772.3 66 827 103 874 150c47 47 83.9 101.8 109.7 162.7 26.7 63.1 40.2 130.2 40.2 199.3.1 19.9-16 36-35.9 36z" } }] }, "name": "loading", "theme": "outlined" };
  exports.default = LoadingOutlined;
  });

  var LoadingOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(LoadingOutlined_1);

  var LoadingOutlined = function LoadingOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: LoadingOutlinedSvg
    }));
  };
  var RefIcon$7j = /*#__PURE__*/React.forwardRef(LoadingOutlined);
  {
    RefIcon$7j.displayName = 'LoadingOutlined';
  }

  var LockFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var LockFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M832 464h-68V240c0-70.7-57.3-128-128-128H388c-70.7 0-128 57.3-128 128v224h-68c-17.7 0-32 14.3-32 32v384c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V496c0-17.7-14.3-32-32-32zM540 701v53c0 4.4-3.6 8-8 8h-40c-4.4 0-8-3.6-8-8v-53a48.01 48.01 0 1156 0zm152-237H332V240c0-30.9 25.1-56 56-56h248c30.9 0 56 25.1 56 56v224z" } }] }, "name": "lock", "theme": "filled" };
  exports.default = LockFilled;
  });

  var LockFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(LockFilled_1);

  var LockFilled = function LockFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: LockFilledSvg
    }));
  };
  var RefIcon$7k = /*#__PURE__*/React.forwardRef(LockFilled);
  {
    RefIcon$7k.displayName = 'LockFilled';
  }

  var LockOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var LockOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M832 464h-68V240c0-70.7-57.3-128-128-128H388c-70.7 0-128 57.3-128 128v224h-68c-17.7 0-32 14.3-32 32v384c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V496c0-17.7-14.3-32-32-32zM332 240c0-30.9 25.1-56 56-56h248c30.9 0 56 25.1 56 56v224H332V240zm460 600H232V536h560v304zM484 701v53c0 4.4 3.6 8 8 8h40c4.4 0 8-3.6 8-8v-53a48.01 48.01 0 10-56 0z" } }] }, "name": "lock", "theme": "outlined" };
  exports.default = LockOutlined;
  });

  var LockOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(LockOutlined_1);

  var LockOutlined = function LockOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: LockOutlinedSvg
    }));
  };
  var RefIcon$7l = /*#__PURE__*/React.forwardRef(LockOutlined);
  {
    RefIcon$7l.displayName = 'LockOutlined';
  }

  var LockTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var LockTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M832 464h-68V240c0-70.7-57.3-128-128-128H388c-70.7 0-128 57.3-128 128v224h-68c-17.7 0-32 14.3-32 32v384c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V496c0-17.7-14.3-32-32-32zM332 240c0-30.9 25.1-56 56-56h248c30.9 0 56 25.1 56 56v224H332V240zm460 600H232V536h560v304z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M232 840h560V536H232v304zm280-226a48.01 48.01 0 0128 87v53c0 4.4-3.6 8-8 8h-40c-4.4 0-8-3.6-8-8v-53a48.01 48.01 0 0128-87z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M484 701v53c0 4.4 3.6 8 8 8h40c4.4 0 8-3.6 8-8v-53a48.01 48.01 0 10-56 0z", "fill": primaryColor } }] }; }, "name": "lock", "theme": "twotone" };
  exports.default = LockTwoTone;
  });

  var LockTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(LockTwoTone_1);

  var LockTwoTone = function LockTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: LockTwoToneSvg
    }));
  };
  var RefIcon$7m = /*#__PURE__*/React.forwardRef(LockTwoTone);
  {
    RefIcon$7m.displayName = 'LockTwoTone';
  }

  var LoginOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var LoginOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M521.7 82c-152.5-.4-286.7 78.5-363.4 197.7-3.4 5.3.4 12.3 6.7 12.3h70.3c4.8 0 9.3-2.1 12.3-5.8 7-8.5 14.5-16.7 22.4-24.5 32.6-32.5 70.5-58.1 112.7-75.9 43.6-18.4 90-27.8 137.9-27.8 47.9 0 94.3 9.3 137.9 27.8 42.2 17.8 80.1 43.4 112.7 75.9 32.6 32.5 58.1 70.4 76 112.5C865.7 417.8 875 464.1 875 512c0 47.9-9.4 94.2-27.8 137.8-17.8 42.1-43.4 80-76 112.5s-70.5 58.1-112.7 75.9A352.8 352.8 0 01520.6 866c-47.9 0-94.3-9.4-137.9-27.8A353.84 353.84 0 01270 762.3c-7.9-7.9-15.3-16.1-22.4-24.5-3-3.7-7.6-5.8-12.3-5.8H165c-6.3 0-10.2 7-6.7 12.3C234.9 863.2 368.5 942 520.6 942c236.2 0 428-190.1 430.4-425.6C953.4 277.1 761.3 82.6 521.7 82zM395.02 624v-76h-314c-4.4 0-8-3.6-8-8v-56c0-4.4 3.6-8 8-8h314v-76c0-6.7 7.8-10.5 13-6.3l141.9 112a8 8 0 010 12.6l-141.9 112c-5.2 4.1-13 .4-13-6.3z" } }] }, "name": "login", "theme": "outlined" };
  exports.default = LoginOutlined;
  });

  var LoginOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(LoginOutlined_1);

  var LoginOutlined = function LoginOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: LoginOutlinedSvg
    }));
  };
  var RefIcon$7n = /*#__PURE__*/React.forwardRef(LoginOutlined);
  {
    RefIcon$7n.displayName = 'LoginOutlined';
  }

  var LogoutOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var LogoutOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M868 732h-70.3c-4.8 0-9.3 2.1-12.3 5.8-7 8.5-14.5 16.7-22.4 24.5a353.84 353.84 0 01-112.7 75.9A352.8 352.8 0 01512.4 866c-47.9 0-94.3-9.4-137.9-27.8a353.84 353.84 0 01-112.7-75.9 353.28 353.28 0 01-76-112.5C167.3 606.2 158 559.9 158 512s9.4-94.2 27.8-137.8c17.8-42.1 43.4-80 76-112.5s70.5-58.1 112.7-75.9c43.6-18.4 90-27.8 137.9-27.8 47.9 0 94.3 9.3 137.9 27.8 42.2 17.8 80.1 43.4 112.7 75.9 7.9 7.9 15.3 16.1 22.4 24.5 3 3.7 7.6 5.8 12.3 5.8H868c6.3 0 10.2-7 6.7-12.3C798 160.5 663.8 81.6 511.3 82 271.7 82.6 79.6 277.1 82 516.4 84.4 751.9 276.2 942 512.4 942c152.1 0 285.7-78.8 362.3-197.7 3.4-5.3-.4-12.3-6.7-12.3zm88.9-226.3L815 393.7c-5.3-4.2-13-.4-13 6.3v76H488c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h314v76c0 6.7 7.8 10.5 13 6.3l141.9-112a8 8 0 000-12.6z" } }] }, "name": "logout", "theme": "outlined" };
  exports.default = LogoutOutlined;
  });

  var LogoutOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(LogoutOutlined_1);

  var LogoutOutlined = function LogoutOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: LogoutOutlinedSvg
    }));
  };
  var RefIcon$7o = /*#__PURE__*/React.forwardRef(LogoutOutlined);
  {
    RefIcon$7o.displayName = 'LogoutOutlined';
  }

  var MacCommandFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MacCommandFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M624 672a48.01 48.01 0 0096 0c0-26.5-21.5-48-48-48h-48v48zm96-320a48.01 48.01 0 00-96 0v48h48c26.5 0 48-21.5 48-48z" } }, { "tag": "path", "attrs": { "d": "M928 64H96c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V96c0-17.7-14.3-32-32-32zM672 560c61.9 0 112 50.1 112 112s-50.1 112-112 112-112-50.1-112-112v-48h-96v48c0 61.9-50.1 112-112 112s-112-50.1-112-112 50.1-112 112-112h48v-96h-48c-61.9 0-112-50.1-112-112s50.1-112 112-112 112 50.1 112 112v48h96v-48c0-61.9 50.1-112 112-112s112 50.1 112 112-50.1 112-112 112h-48v96h48z" } }, { "tag": "path", "attrs": { "d": "M464 464h96v96h-96zM352 304a48.01 48.01 0 000 96h48v-48c0-26.5-21.5-48-48-48zm-48 368a48.01 48.01 0 0096 0v-48h-48c-26.5 0-48 21.5-48 48z" } }] }, "name": "mac-command", "theme": "filled" };
  exports.default = MacCommandFilled;
  });

  var MacCommandFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(MacCommandFilled_1);

  var MacCommandFilled = function MacCommandFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MacCommandFilledSvg
    }));
  };
  var RefIcon$7p = /*#__PURE__*/React.forwardRef(MacCommandFilled);
  {
    RefIcon$7p.displayName = 'MacCommandFilled';
  }

  var MacCommandOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MacCommandOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z" } }, { "tag": "path", "attrs": { "d": "M370.8 554.4c-54.6 0-98.8 44.2-98.8 98.8s44.2 98.8 98.8 98.8 98.8-44.2 98.8-98.8v-42.4h84.7v42.4c0 54.6 44.2 98.8 98.8 98.8s98.8-44.2 98.8-98.8-44.2-98.8-98.8-98.8h-42.4v-84.7h42.4c54.6 0 98.8-44.2 98.8-98.8 0-54.6-44.2-98.8-98.8-98.8s-98.8 44.2-98.8 98.8v42.4h-84.7v-42.4c0-54.6-44.2-98.8-98.8-98.8S272 316.2 272 370.8s44.2 98.8 98.8 98.8h42.4v84.7h-42.4zm42.4 98.8c0 23.4-19 42.4-42.4 42.4s-42.4-19-42.4-42.4 19-42.4 42.4-42.4h42.4v42.4zm197.6-282.4c0-23.4 19-42.4 42.4-42.4s42.4 19 42.4 42.4-19 42.4-42.4 42.4h-42.4v-42.4zm0 240h42.4c23.4 0 42.4 19 42.4 42.4s-19 42.4-42.4 42.4-42.4-19-42.4-42.4v-42.4zM469.6 469.6h84.7v84.7h-84.7v-84.7zm-98.8-56.4c-23.4 0-42.4-19-42.4-42.4s19-42.4 42.4-42.4 42.4 19 42.4 42.4v42.4h-42.4z" } }] }, "name": "mac-command", "theme": "outlined" };
  exports.default = MacCommandOutlined;
  });

  var MacCommandOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(MacCommandOutlined_1);

  var MacCommandOutlined = function MacCommandOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MacCommandOutlinedSvg
    }));
  };
  var RefIcon$7q = /*#__PURE__*/React.forwardRef(MacCommandOutlined);
  {
    RefIcon$7q.displayName = 'MacCommandOutlined';
  }

  var MailFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MailFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M928 160H96c-17.7 0-32 14.3-32 32v640c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V192c0-17.7-14.3-32-32-32zm-80.8 108.9L531.7 514.4c-7.8 6.1-18.7 6.1-26.5 0L189.6 268.9A7.2 7.2 0 01194 256h648.8a7.2 7.2 0 014.4 12.9z" } }] }, "name": "mail", "theme": "filled" };
  exports.default = MailFilled;
  });

  var MailFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(MailFilled_1);

  var MailFilled = function MailFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MailFilledSvg
    }));
  };
  var RefIcon$7r = /*#__PURE__*/React.forwardRef(MailFilled);
  {
    RefIcon$7r.displayName = 'MailFilled';
  }

  var MailOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MailOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M928 160H96c-17.7 0-32 14.3-32 32v640c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V192c0-17.7-14.3-32-32-32zm-40 110.8V792H136V270.8l-27.6-21.5 39.3-50.5 42.8 33.3h643.1l42.8-33.3 39.3 50.5-27.7 21.5zM833.6 232L512 482 190.4 232l-42.8-33.3-39.3 50.5 27.6 21.5 341.6 265.6a55.99 55.99 0 0068.7 0L888 270.8l27.6-21.5-39.3-50.5-42.7 33.2z" } }] }, "name": "mail", "theme": "outlined" };
  exports.default = MailOutlined;
  });

  var MailOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(MailOutlined_1);

  var MailOutlined = function MailOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MailOutlinedSvg
    }));
  };
  var RefIcon$7s = /*#__PURE__*/React.forwardRef(MailOutlined);
  {
    RefIcon$7s.displayName = 'MailOutlined';
  }

  var MailTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MailTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M477.5 536.3L135.9 270.7l-27.5-21.4 27.6 21.5V792h752V270.8L546.2 536.3a55.99 55.99 0 01-68.7 0z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M876.3 198.8l39.3 50.5-27.6 21.5 27.7-21.5-39.3-50.5z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M928 160H96c-17.7 0-32 14.3-32 32v640c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V192c0-17.7-14.3-32-32-32zm-94.5 72.1L512 482 190.5 232.1h643zm54.5 38.7V792H136V270.8l-27.6-21.5 27.5 21.4 341.6 265.6a55.99 55.99 0 0068.7 0L888 270.8l27.6-21.5-39.3-50.5h.1l39.3 50.5-27.7 21.5z", "fill": primaryColor } }] }; }, "name": "mail", "theme": "twotone" };
  exports.default = MailTwoTone;
  });

  var MailTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(MailTwoTone_1);

  var MailTwoTone = function MailTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MailTwoToneSvg
    }));
  };
  var RefIcon$7t = /*#__PURE__*/React.forwardRef(MailTwoTone);
  {
    RefIcon$7t.displayName = 'MailTwoTone';
  }

  var ManOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ManOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M874 120H622c-3.3 0-6 2.7-6 6v56c0 3.3 2.7 6 6 6h160.4L583.1 387.3c-50-38.5-111-59.3-175.1-59.3-76.9 0-149.3 30-203.6 84.4S120 539.1 120 616s30 149.3 84.4 203.6C258.7 874 331.1 904 408 904s149.3-30 203.6-84.4C666 765.3 696 692.9 696 616c0-64.1-20.8-124.9-59.2-174.9L836 241.9V402c0 3.3 2.7 6 6 6h56c3.3 0 6-2.7 6-6V150c0-16.5-13.5-30-30-30zM408 828c-116.9 0-212-95.1-212-212s95.1-212 212-212 212 95.1 212 212-95.1 212-212 212z" } }] }, "name": "man", "theme": "outlined" };
  exports.default = ManOutlined;
  });

  var ManOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(ManOutlined_1);

  var ManOutlined = function ManOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ManOutlinedSvg
    }));
  };
  var RefIcon$7u = /*#__PURE__*/React.forwardRef(ManOutlined);
  {
    RefIcon$7u.displayName = 'ManOutlined';
  }

  var MedicineBoxFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MedicineBoxFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M839.2 278.1a32 32 0 00-30.4-22.1H736V144c0-17.7-14.3-32-32-32H320c-17.7 0-32 14.3-32 32v112h-72.8a31.9 31.9 0 00-30.4 22.1L112 502v378c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V502l-72.8-223.9zM660 628c0 4.4-3.6 8-8 8H544v108c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V636H372c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h108V464c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v108h108c4.4 0 8 3.6 8 8v48zm4-372H360v-72h304v72z" } }] }, "name": "medicine-box", "theme": "filled" };
  exports.default = MedicineBoxFilled;
  });

  var MedicineBoxFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(MedicineBoxFilled_1);

  var MedicineBoxFilled = function MedicineBoxFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MedicineBoxFilledSvg
    }));
  };
  var RefIcon$7v = /*#__PURE__*/React.forwardRef(MedicineBoxFilled);
  {
    RefIcon$7v.displayName = 'MedicineBoxFilled';
  }

  var MedicineBoxOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MedicineBoxOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M839.2 278.1a32 32 0 00-30.4-22.1H736V144c0-17.7-14.3-32-32-32H320c-17.7 0-32 14.3-32 32v112h-72.8a31.9 31.9 0 00-30.4 22.1L112 502v378c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V502l-72.8-223.9zM360 184h304v72H360v-72zm480 656H184V513.4L244.3 328h535.4L840 513.4V840zM652 572H544V464c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v108H372c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h108v108c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V636h108c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8z" } }] }, "name": "medicine-box", "theme": "outlined" };
  exports.default = MedicineBoxOutlined;
  });

  var MedicineBoxOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(MedicineBoxOutlined_1);

  var MedicineBoxOutlined = function MedicineBoxOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MedicineBoxOutlinedSvg
    }));
  };
  var RefIcon$7w = /*#__PURE__*/React.forwardRef(MedicineBoxOutlined);
  {
    RefIcon$7w.displayName = 'MedicineBoxOutlined';
  }

  var MedicineBoxTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MedicineBoxTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M244.3 328L184 513.4V840h656V513.4L779.7 328H244.3zM660 628c0 4.4-3.6 8-8 8H544v108c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V636H372c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h108V464c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v108h108c4.4 0 8 3.6 8 8v48z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M652 572H544V464c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v108H372c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h108v108c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V636h108c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M839.2 278.1a32 32 0 00-30.4-22.1H736V144c0-17.7-14.3-32-32-32H320c-17.7 0-32 14.3-32 32v112h-72.8a31.9 31.9 0 00-30.4 22.1L112 502v378c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V502l-72.8-223.9zM360 184h304v72H360v-72zm480 656H184V513.4L244.3 328h535.4L840 513.4V840z", "fill": primaryColor } }] }; }, "name": "medicine-box", "theme": "twotone" };
  exports.default = MedicineBoxTwoTone;
  });

  var MedicineBoxTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(MedicineBoxTwoTone_1);

  var MedicineBoxTwoTone = function MedicineBoxTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MedicineBoxTwoToneSvg
    }));
  };
  var RefIcon$7x = /*#__PURE__*/React.forwardRef(MedicineBoxTwoTone);
  {
    RefIcon$7x.displayName = 'MedicineBoxTwoTone';
  }

  var MediumCircleFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MediumCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm256 253.7l-40.8 39.1c-3.6 2.7-5.3 7.1-4.6 11.4v287.7c-.7 4.4 1 8.8 4.6 11.4l40 39.1v8.7H566.4v-8.3l41.3-40.1c4.1-4.1 4.1-5.3 4.1-11.4V422.5l-115 291.6h-15.5L347.5 422.5V618c-1.2 8.2 1.7 16.5 7.5 22.4l53.8 65.1v8.7H256v-8.7l53.8-65.1a26.1 26.1 0 007-22.4V392c.7-6.3-1.7-12.4-6.5-16.7l-47.8-57.6V309H411l114.6 251.5 100.9-251.3H768v8.5z" } }] }, "name": "medium-circle", "theme": "filled" };
  exports.default = MediumCircleFilled;
  });

  var MediumCircleFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(MediumCircleFilled_1);

  var MediumCircleFilled = function MediumCircleFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MediumCircleFilledSvg
    }));
  };
  var RefIcon$7y = /*#__PURE__*/React.forwardRef(MediumCircleFilled);
  {
    RefIcon$7y.displayName = 'MediumCircleFilled';
  }

  var MediumOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MediumOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M834.7 279.8l61.3-58.9V208H683.7L532.4 586.4 360.3 208H137.7v12.9l71.6 86.6c7 6.4 10.6 15.8 9.7 25.2V673c2.2 12.3-1.7 24.8-10.3 33.7L128 805v12.7h228.6v-12.9l-80.6-98a39.99 39.99 0 01-11.1-33.7V378.7l200.7 439.2h23.3l172.6-439.2v349.9c0 9.2 0 11.1-6 17.2l-62.1 60.3V819h301.2v-12.9l-59.9-58.9c-5.2-4-7.9-10.7-6.8-17.2V297a18.1 18.1 0 016.8-17.2z" } }] }, "name": "medium", "theme": "outlined" };
  exports.default = MediumOutlined;
  });

  var MediumOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(MediumOutlined_1);

  var MediumOutlined = function MediumOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MediumOutlinedSvg
    }));
  };
  var RefIcon$7z = /*#__PURE__*/React.forwardRef(MediumOutlined);
  {
    RefIcon$7z.displayName = 'MediumOutlined';
  }

  var MediumSquareFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MediumSquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM768 317.7l-40.8 39.1c-3.6 2.7-5.3 7.1-4.6 11.4v287.7c-.7 4.4 1 8.8 4.6 11.4l40 39.1v8.7H566.4v-8.3l41.3-40.1c4.1-4.1 4.1-5.3 4.1-11.4V422.5l-115 291.6h-15.5L347.5 422.5V618c-1.2 8.2 1.7 16.5 7.5 22.4l53.8 65.1v8.7H256v-8.7l53.8-65.1a26.1 26.1 0 007-22.4V392c.7-6.3-1.7-12.4-6.5-16.7l-47.8-57.6V309H411l114.6 251.5 100.9-251.3H768v8.5z" } }] }, "name": "medium-square", "theme": "filled" };
  exports.default = MediumSquareFilled;
  });

  var MediumSquareFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(MediumSquareFilled_1);

  var MediumSquareFilled = function MediumSquareFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MediumSquareFilledSvg
    }));
  };
  var RefIcon$7A = /*#__PURE__*/React.forwardRef(MediumSquareFilled);
  {
    RefIcon$7A.displayName = 'MediumSquareFilled';
  }

  var MediumWorkmarkOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MediumWorkmarkOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "0 0 1024 1024", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M517.2 590.55c0 3.55 0 4.36 2.4 6.55l13.43 13.25v.57h-59.57v-25.47a41.44 41.44 0 01-39.5 27.65c-30.61 0-52.84-24.25-52.84-68.87 0-41.8 23.99-69.69 57.65-69.69a35.15 35.15 0 0134.61 21.67v-56.19a6.99 6.99 0 00-2.71-6.79l-12.8-12.45v-.56l59.33-7.04v177.37zm-43.74-8.09v-83.83a22.2 22.2 0 00-17.74-8.4c-14.48 0-28.47 13.25-28.47 52.62 0 36.86 12.07 49.88 27.1 49.88a23.91 23.91 0 0019.11-10.27zm83.23 28.46V497.74a7.65 7.65 0 00-2.4-6.79l-13.19-13.74v-.57h59.56v114.8c0 3.55 0 4.36 2.4 6.54l13.12 12.45v.57l-59.49-.08zm-2.16-175.67c0-13.4 10.74-24.25 23.99-24.25 13.25 0 23.98 10.86 23.98 24.25 0 13.4-10.73 24.25-23.98 24.25s-23.99-10.85-23.99-24.25zm206.83 155.06c0 3.55 0 4.6 2.4 6.79l13.43 13.25v.57h-59.88V581.9a43.4 43.4 0 01-41.01 31.2c-26.55 0-40.78-19.56-40.78-56.59 0-17.86 0-37.43.56-59.41a6.91 6.91 0 00-2.4-6.55L620.5 477.2v-.57h59.09v73.81c0 24.25 3.51 40.42 18.54 40.42a23.96 23.96 0 0019.35-12.2v-80.85a7.65 7.65 0 00-2.4-6.79l-13.27-13.82v-.57h59.56V590.3zm202.76 20.6c0-4.36.8-59.97.8-72.75 0-24.25-3.76-40.98-20.63-40.98a26.7 26.7 0 00-21.19 11.64 99.68 99.68 0 012.4 23.04c0 16.81-.56 38.23-.8 59.66a6.91 6.91 0 002.4 6.55l13.43 12.45v.56h-60.12c0-4.04.8-59.98.8-72.76 0-24.65-3.76-40.98-20.39-40.98-8.2.3-15.68 4.8-19.83 11.96v82.46c0 3.56 0 4.37 2.4 6.55l13.11 12.45v.56h-59.48V498.15a7.65 7.65 0 00-2.4-6.8l-13.19-14.14v-.57H841v28.78c5.53-19 23.13-31.76 42.7-30.96 19.82 0 33.26 11.16 38.93 32.34a46.41 46.41 0 0144.77-32.34c26.55 0 41.58 19.8 41.58 57.23 0 17.87-.56 38.24-.8 59.66a6.5 6.5 0 002.72 6.55l13.11 12.45v.57h-59.88zM215.87 593.3l17.66 17.05v.57h-89.62v-.57l17.99-17.05a6.91 6.91 0 002.4-6.55V477.69c0-4.6 0-10.83.8-16.16L104.66 613.1h-.72l-62.6-139.45c-1.37-3.47-1.77-3.72-2.65-6.06v91.43a32.08 32.08 0 002.96 17.87l25.19 33.46v.57H0v-.57l25.18-33.55a32.16 32.16 0 002.96-17.78V457.97A19.71 19.71 0 0024 444.15L6.16 420.78v-.56h63.96l53.56 118.1 47.17-118.1h62.6v.56l-17.58 19.8a6.99 6.99 0 00-2.72 6.8v139.37a6.5 6.5 0 002.72 6.55zm70.11-54.65v.56c0 34.6 17.67 48.5 38.38 48.5a43.5 43.5 0 0040.77-24.97h.56c-7.2 34.2-28.14 50.36-59.48 50.36-33.82 0-65.72-20.61-65.72-68.39 0-50.2 31.98-70.25 67.32-70.25 28.46 0 58.76 13.58 58.76 57.24v6.95h-80.59zm0-6.95h39.42v-7.04c0-35.57-7.28-45.03-18.23-45.03-13.27 0-21.35 14.15-21.35 52.07h.16z" } }] }, "name": "medium-workmark", "theme": "outlined" };
  exports.default = MediumWorkmarkOutlined;
  });

  var MediumWorkmarkOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(MediumWorkmarkOutlined_1);

  var MediumWorkmarkOutlined = function MediumWorkmarkOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MediumWorkmarkOutlinedSvg
    }));
  };
  var RefIcon$7B = /*#__PURE__*/React.forwardRef(MediumWorkmarkOutlined);
  {
    RefIcon$7B.displayName = 'MediumWorkmarkOutlined';
  }

  var MehFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MehFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zM288 421a48.01 48.01 0 0196 0 48.01 48.01 0 01-96 0zm384 200c0 4.4-3.6 8-8 8H360c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h304c4.4 0 8 3.6 8 8v48zm16-152a48.01 48.01 0 010-96 48.01 48.01 0 010 96z" } }] }, "name": "meh", "theme": "filled" };
  exports.default = MehFilled;
  });

  var MehFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(MehFilled_1);

  var MehFilled = function MehFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MehFilledSvg
    }));
  };
  var RefIcon$7C = /*#__PURE__*/React.forwardRef(MehFilled);
  {
    RefIcon$7C.displayName = 'MehFilled';
  }

  var MehOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MehOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M288 421a48 48 0 1096 0 48 48 0 10-96 0zm352 0a48 48 0 1096 0 48 48 0 10-96 0zM512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm263 711c-34.2 34.2-74 61-118.3 79.8C611 874.2 562.3 884 512 884c-50.3 0-99-9.8-144.8-29.2A370.4 370.4 0 01248.9 775c-34.2-34.2-61-74-79.8-118.3C149.8 611 140 562.3 140 512s9.8-99 29.2-144.8A370.4 370.4 0 01249 248.9c34.2-34.2 74-61 118.3-79.8C413 149.8 461.7 140 512 140c50.3 0 99 9.8 144.8 29.2A370.4 370.4 0 01775.1 249c34.2 34.2 61 74 79.8 118.3C874.2 413 884 461.7 884 512s-9.8 99-29.2 144.8A368.89 368.89 0 01775 775zM664 565H360c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h304c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8z" } }] }, "name": "meh", "theme": "outlined" };
  exports.default = MehOutlined;
  });

  var MehOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(MehOutlined_1);

  var MehOutlined = function MehOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MehOutlinedSvg
    }));
  };
  var RefIcon$7D = /*#__PURE__*/React.forwardRef(MehOutlined);
  {
    RefIcon$7D.displayName = 'MehOutlined';
  }

  var MehTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MehTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zM288 421a48.01 48.01 0 0196 0 48.01 48.01 0 01-96 0zm384 200c0 4.4-3.6 8-8 8H360c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h304c4.4 0 8 3.6 8 8v48zm16-152a48.01 48.01 0 010-96 48.01 48.01 0 010 96z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M288 421a48 48 0 1096 0 48 48 0 10-96 0zm376 144H360c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h304c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8zm-24-144a48 48 0 1096 0 48 48 0 10-96 0z", "fill": primaryColor } }] }; }, "name": "meh", "theme": "twotone" };
  exports.default = MehTwoTone;
  });

  var MehTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(MehTwoTone_1);

  var MehTwoTone = function MehTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MehTwoToneSvg
    }));
  };
  var RefIcon$7E = /*#__PURE__*/React.forwardRef(MehTwoTone);
  {
    RefIcon$7E.displayName = 'MehTwoTone';
  }

  var MenuFoldOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MenuFoldOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M408 442h480c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H408c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm-8 204c0 4.4 3.6 8 8 8h480c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H408c-4.4 0-8 3.6-8 8v56zm504-486H120c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 632H120c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM115.4 518.9L271.7 642c5.8 4.6 14.4.5 14.4-6.9V388.9c0-7.4-8.5-11.5-14.4-6.9L115.4 505.1a8.74 8.74 0 000 13.8z" } }] }, "name": "menu-fold", "theme": "outlined" };
  exports.default = MenuFoldOutlined;
  });

  var MenuFoldOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(MenuFoldOutlined_1);

  var MenuFoldOutlined = function MenuFoldOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MenuFoldOutlinedSvg
    }));
  };
  var RefIcon$7F = /*#__PURE__*/React.forwardRef(MenuFoldOutlined);
  {
    RefIcon$7F.displayName = 'MenuFoldOutlined';
  }

  var MenuOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MenuOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M904 160H120c-4.4 0-8 3.6-8 8v64c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-64c0-4.4-3.6-8-8-8zm0 624H120c-4.4 0-8 3.6-8 8v64c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-64c0-4.4-3.6-8-8-8zm0-312H120c-4.4 0-8 3.6-8 8v64c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-64c0-4.4-3.6-8-8-8z" } }] }, "name": "menu", "theme": "outlined" };
  exports.default = MenuOutlined;
  });

  var MenuOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(MenuOutlined_1);

  var MenuOutlined = function MenuOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MenuOutlinedSvg
    }));
  };
  var RefIcon$7G = /*#__PURE__*/React.forwardRef(MenuOutlined);
  {
    RefIcon$7G.displayName = 'MenuOutlined';
  }

  var MenuUnfoldOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MenuUnfoldOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M408 442h480c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H408c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8zm-8 204c0 4.4 3.6 8 8 8h480c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H408c-4.4 0-8 3.6-8 8v56zm504-486H120c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 632H120c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h784c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM142.4 642.1L298.7 519a8.84 8.84 0 000-13.9L142.4 381.9c-5.8-4.6-14.4-.5-14.4 6.9v246.3a8.9 8.9 0 0014.4 7z" } }] }, "name": "menu-unfold", "theme": "outlined" };
  exports.default = MenuUnfoldOutlined;
  });

  var MenuUnfoldOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(MenuUnfoldOutlined_1);

  var MenuUnfoldOutlined = function MenuUnfoldOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MenuUnfoldOutlinedSvg
    }));
  };
  var RefIcon$7H = /*#__PURE__*/React.forwardRef(MenuUnfoldOutlined);
  {
    RefIcon$7H.displayName = 'MenuUnfoldOutlined';
  }

  var MergeCellsOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MergeCellsOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M482.2 508.4L331.3 389c-3-2.4-7.3-.2-7.3 3.6V478H184V184h204v128c0 2.2 1.8 4 4 4h60c2.2 0 4-1.8 4-4V144c0-15.5-12.5-28-28-28H144c-15.5 0-28 12.5-28 28v736c0 15.5 12.5 28 28 28h284c15.5 0 28-12.5 28-28V712c0-2.2-1.8-4-4-4h-60c-2.2 0-4 1.8-4 4v128H184V546h140v85.4c0 3.8 4.4 6 7.3 3.6l150.9-119.4a4.5 4.5 0 000-7.2zM880 116H596c-15.5 0-28 12.5-28 28v168c0 2.2 1.8 4 4 4h60c2.2 0 4-1.8 4-4V184h204v294H700v-85.4c0-3.8-4.3-6-7.3-3.6l-151 119.4a4.52 4.52 0 000 7.1l151 119.5c2.9 2.3 7.3.2 7.3-3.6V546h140v294H636V712c0-2.2-1.8-4-4-4h-60c-2.2 0-4 1.8-4 4v168c0 15.5 12.5 28 28 28h284c15.5 0 28-12.5 28-28V144c0-15.5-12.5-28-28-28z" } }] }, "name": "merge-cells", "theme": "outlined" };
  exports.default = MergeCellsOutlined;
  });

  var MergeCellsOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(MergeCellsOutlined_1);

  var MergeCellsOutlined = function MergeCellsOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MergeCellsOutlinedSvg
    }));
  };
  var RefIcon$7I = /*#__PURE__*/React.forwardRef(MergeCellsOutlined);
  {
    RefIcon$7I.displayName = 'MergeCellsOutlined';
  }

  var MergeFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MergeFilled = { "icon": { "tag": "svg", "attrs": { "fill-rule": "evenodd", "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M284 924c61.86 0 112-50.14 112-112 0-49.26-31.8-91.1-76-106.09V421.63l386.49 126.55.01 95.92C661 658.34 628 700.8 628 751c0 61.86 50.14 112 112 112s112-50.14 112-112c0-48.33-30.6-89.5-73.5-105.2l-.01-113.04a50.73 50.73 0 00-34.95-48.2L320 345.85V318.1c43.64-14.8 75.2-55.78 75.99-104.24L396 212c0-61.86-50.14-112-112-112s-112 50.14-112 112c0 49.26 31.8 91.1 76 106.09V705.9c-44.2 15-76 56.83-76 106.09 0 61.86 50.14 112 112 112" } }] }, "name": "merge", "theme": "filled" };
  exports.default = MergeFilled;
  });

  var MergeFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(MergeFilled_1);

  var MergeFilled = function MergeFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MergeFilledSvg
    }));
  };
  var RefIcon$7J = /*#__PURE__*/React.forwardRef(MergeFilled);
  {
    RefIcon$7J.displayName = 'MergeFilled';
  }

  var MergeOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MergeOutlined = { "icon": { "tag": "svg", "attrs": { "fill-rule": "evenodd", "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M248 752h72V264h-72z" } }, { "tag": "path", "attrs": { "d": "M740 863c61.86 0 112-50.14 112-112 0-48.33-30.6-89.5-73.5-105.2l-.01-113.04a50.73 50.73 0 00-34.95-48.2l-434.9-142.41-22.4 68.42 420.25 137.61.01 95.92C661 658.34 628 700.8 628 751c0 61.86 50.14 112 112 112m-456 61c61.86 0 112-50.14 112-112s-50.14-112-112-112-112 50.14-112 112 50.14 112 112 112m456-125a48 48 0 110-96 48 48 0 010 96m-456 61a48 48 0 110-96 48 48 0 010 96m0-536c61.86 0 112-50.14 112-112s-50.14-112-112-112-112 50.14-112 112 50.14 112 112 112m0-64a48 48 0 110-96 48 48 0 010 96" } }] }, "name": "merge", "theme": "outlined" };
  exports.default = MergeOutlined;
  });

  var MergeOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(MergeOutlined_1);

  var MergeOutlined = function MergeOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MergeOutlinedSvg
    }));
  };
  var RefIcon$7K = /*#__PURE__*/React.forwardRef(MergeOutlined);
  {
    RefIcon$7K.displayName = 'MergeOutlined';
  }

  var MessageFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MessageFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M924.3 338.4a447.57 447.57 0 00-96.1-143.3 443.09 443.09 0 00-143-96.3A443.91 443.91 0 00512 64h-2c-60.5.3-119 12.3-174.1 35.9a444.08 444.08 0 00-141.7 96.5 445 445 0 00-95 142.8A449.89 449.89 0 0065 514.1c.3 69.4 16.9 138.3 47.9 199.9v152c0 25.4 20.6 46 45.9 46h151.8a447.72 447.72 0 00199.5 48h2.1c59.8 0 117.7-11.6 172.3-34.3A443.2 443.2 0 00827 830.5c41.2-40.9 73.6-88.7 96.3-142 23.5-55.2 35.5-113.9 35.8-174.5.2-60.9-11.6-120-34.8-175.6zM312.4 560c-26.4 0-47.9-21.5-47.9-48s21.5-48 47.9-48 47.9 21.5 47.9 48-21.4 48-47.9 48zm199.6 0c-26.4 0-47.9-21.5-47.9-48s21.5-48 47.9-48 47.9 21.5 47.9 48-21.5 48-47.9 48zm199.6 0c-26.4 0-47.9-21.5-47.9-48s21.5-48 47.9-48 47.9 21.5 47.9 48-21.5 48-47.9 48z" } }] }, "name": "message", "theme": "filled" };
  exports.default = MessageFilled;
  });

  var MessageFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(MessageFilled_1);

  var MessageFilled = function MessageFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MessageFilledSvg
    }));
  };
  var RefIcon$7L = /*#__PURE__*/React.forwardRef(MessageFilled);
  {
    RefIcon$7L.displayName = 'MessageFilled';
  }

  var MessageOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MessageOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M464 512a48 48 0 1096 0 48 48 0 10-96 0zm200 0a48 48 0 1096 0 48 48 0 10-96 0zm-400 0a48 48 0 1096 0 48 48 0 10-96 0zm661.2-173.6c-22.6-53.7-55-101.9-96.3-143.3a444.35 444.35 0 00-143.3-96.3C630.6 75.7 572.2 64 512 64h-2c-60.6.3-119.3 12.3-174.5 35.9a445.35 445.35 0 00-142 96.5c-40.9 41.3-73 89.3-95.2 142.8-23 55.4-34.6 114.3-34.3 174.9A449.4 449.4 0 00112 714v152a46 46 0 0046 46h152.1A449.4 449.4 0 00510 960h2.1c59.9 0 118-11.6 172.7-34.3a444.48 444.48 0 00142.8-95.2c41.3-40.9 73.8-88.7 96.5-142 23.6-55.2 35.6-113.9 35.9-174.5.3-60.9-11.5-120-34.8-175.6zm-151.1 438C704 845.8 611 884 512 884h-1.7c-60.3-.3-120.2-15.3-173.1-43.5l-8.4-4.5H188V695.2l-4.5-8.4C155.3 633.9 140.3 574 140 513.7c-.4-99.7 37.7-193.3 107.6-263.8 69.8-70.5 163.1-109.5 262.8-109.9h1.7c50 0 98.5 9.7 144.2 28.9 44.6 18.7 84.6 45.6 119 80 34.3 34.3 61.3 74.4 80 119 19.4 46.2 29.1 95.2 28.9 145.8-.6 99.6-39.7 192.9-110.1 262.7z" } }] }, "name": "message", "theme": "outlined" };
  exports.default = MessageOutlined;
  });

  var MessageOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(MessageOutlined_1);

  var MessageOutlined = function MessageOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MessageOutlinedSvg
    }));
  };
  var RefIcon$7M = /*#__PURE__*/React.forwardRef(MessageOutlined);
  {
    RefIcon$7M.displayName = 'MessageOutlined';
  }

  var MessageTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MessageTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M775.3 248.9a369.62 369.62 0 00-119-80A370.2 370.2 0 00512.1 140h-1.7c-99.7.4-193 39.4-262.8 109.9-69.9 70.5-108 164.1-107.6 263.8.3 60.3 15.3 120.2 43.5 173.1l4.5 8.4V836h140.8l8.4 4.5c52.9 28.2 112.8 43.2 173.1 43.5h1.7c99 0 192-38.2 262.1-107.6 70.4-69.8 109.5-163.1 110.1-262.7.2-50.6-9.5-99.6-28.9-145.8a370.15 370.15 0 00-80-119zM312 560a48.01 48.01 0 010-96 48.01 48.01 0 010 96zm200 0a48.01 48.01 0 010-96 48.01 48.01 0 010 96zm200 0a48.01 48.01 0 010-96 48.01 48.01 0 010 96z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M664 512a48 48 0 1096 0 48 48 0 10-96 0zm-400 0a48 48 0 1096 0 48 48 0 10-96 0z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M925.2 338.4c-22.6-53.7-55-101.9-96.3-143.3a444.35 444.35 0 00-143.3-96.3C630.6 75.7 572.2 64 512 64h-2c-60.6.3-119.3 12.3-174.5 35.9a445.35 445.35 0 00-142 96.5c-40.9 41.3-73 89.3-95.2 142.8-23 55.4-34.6 114.3-34.3 174.9A449.4 449.4 0 00112 714v152a46 46 0 0046 46h152.1A449.4 449.4 0 00510 960h2.1c59.9 0 118-11.6 172.7-34.3a444.48 444.48 0 00142.8-95.2c41.3-40.9 73.8-88.7 96.5-142 23.6-55.2 35.6-113.9 35.9-174.5.3-60.9-11.5-120-34.8-175.6zm-151.1 438C704 845.8 611 884 512 884h-1.7c-60.3-.3-120.2-15.3-173.1-43.5l-8.4-4.5H188V695.2l-4.5-8.4C155.3 633.9 140.3 574 140 513.7c-.4-99.7 37.7-193.3 107.6-263.8 69.8-70.5 163.1-109.5 262.8-109.9h1.7c50 0 98.5 9.7 144.2 28.9 44.6 18.7 84.6 45.6 119 80 34.3 34.3 61.3 74.4 80 119 19.4 46.2 29.1 95.2 28.9 145.8-.6 99.6-39.7 192.9-110.1 262.7z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M464 512a48 48 0 1096 0 48 48 0 10-96 0z", "fill": primaryColor } }] }; }, "name": "message", "theme": "twotone" };
  exports.default = MessageTwoTone;
  });

  var MessageTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(MessageTwoTone_1);

  var MessageTwoTone = function MessageTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MessageTwoToneSvg
    }));
  };
  var RefIcon$7N = /*#__PURE__*/React.forwardRef(MessageTwoTone);
  {
    RefIcon$7N.displayName = 'MessageTwoTone';
  }

  var MinusCircleFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MinusCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm192 472c0 4.4-3.6 8-8 8H328c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h368c4.4 0 8 3.6 8 8v48z" } }] }, "name": "minus-circle", "theme": "filled" };
  exports.default = MinusCircleFilled;
  });

  var MinusCircleFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(MinusCircleFilled_1);

  var MinusCircleFilled = function MinusCircleFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MinusCircleFilledSvg
    }));
  };
  var RefIcon$7O = /*#__PURE__*/React.forwardRef(MinusCircleFilled);
  {
    RefIcon$7O.displayName = 'MinusCircleFilled';
  }

  var MinusCircleOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MinusCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M696 480H328c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h368c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8z" } }, { "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z" } }] }, "name": "minus-circle", "theme": "outlined" };
  exports.default = MinusCircleOutlined;
  });

  var MinusCircleOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(MinusCircleOutlined_1);

  var MinusCircleOutlined = function MinusCircleOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MinusCircleOutlinedSvg
    }));
  };
  var RefIcon$7P = /*#__PURE__*/React.forwardRef(MinusCircleOutlined);
  {
    RefIcon$7P.displayName = 'MinusCircleOutlined';
  }

  var MinusCircleTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MinusCircleTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm192 396c0 4.4-3.6 8-8 8H328c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h368c4.4 0 8 3.6 8 8v48z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M696 480H328c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h368c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8z", "fill": primaryColor } }] }; }, "name": "minus-circle", "theme": "twotone" };
  exports.default = MinusCircleTwoTone;
  });

  var MinusCircleTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(MinusCircleTwoTone_1);

  var MinusCircleTwoTone = function MinusCircleTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MinusCircleTwoToneSvg
    }));
  };
  var RefIcon$7Q = /*#__PURE__*/React.forwardRef(MinusCircleTwoTone);
  {
    RefIcon$7Q.displayName = 'MinusCircleTwoTone';
  }

  var MinusOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MinusOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M872 474H152c-4.4 0-8 3.6-8 8v60c0 4.4 3.6 8 8 8h720c4.4 0 8-3.6 8-8v-60c0-4.4-3.6-8-8-8z" } }] }, "name": "minus", "theme": "outlined" };
  exports.default = MinusOutlined;
  });

  var MinusOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(MinusOutlined_1);

  var MinusOutlined = function MinusOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MinusOutlinedSvg
    }));
  };
  var RefIcon$7R = /*#__PURE__*/React.forwardRef(MinusOutlined);
  {
    RefIcon$7R.displayName = 'MinusOutlined';
  }

  var MinusSquareFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MinusSquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM704 536c0 4.4-3.6 8-8 8H328c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h368c4.4 0 8 3.6 8 8v48z" } }] }, "name": "minus-square", "theme": "filled" };
  exports.default = MinusSquareFilled;
  });

  var MinusSquareFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(MinusSquareFilled_1);

  var MinusSquareFilled = function MinusSquareFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MinusSquareFilledSvg
    }));
  };
  var RefIcon$7S = /*#__PURE__*/React.forwardRef(MinusSquareFilled);
  {
    RefIcon$7S.displayName = 'MinusSquareFilled';
  }

  var MinusSquareOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MinusSquareOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M328 544h368c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H328c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8z" } }, { "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z" } }] }, "name": "minus-square", "theme": "outlined" };
  exports.default = MinusSquareOutlined;
  });

  var MinusSquareOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(MinusSquareOutlined_1);

  var MinusSquareOutlined = function MinusSquareOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MinusSquareOutlinedSvg
    }));
  };
  var RefIcon$7T = /*#__PURE__*/React.forwardRef(MinusSquareOutlined);
  {
    RefIcon$7T.displayName = 'MinusSquareOutlined';
  }

  var MinusSquareTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MinusSquareTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M184 840h656V184H184v656zm136-352c0-4.4 3.6-8 8-8h368c4.4 0 8 3.6 8 8v48c0 4.4-3.6 8-8 8H328c-4.4 0-8-3.6-8-8v-48z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M328 544h368c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H328c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8z", "fill": primaryColor } }] }; }, "name": "minus-square", "theme": "twotone" };
  exports.default = MinusSquareTwoTone;
  });

  var MinusSquareTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(MinusSquareTwoTone_1);

  var MinusSquareTwoTone = function MinusSquareTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MinusSquareTwoToneSvg
    }));
  };
  var RefIcon$7U = /*#__PURE__*/React.forwardRef(MinusSquareTwoTone);
  {
    RefIcon$7U.displayName = 'MinusSquareTwoTone';
  }

  var MobileFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MobileFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M744 62H280c-35.3 0-64 28.7-64 64v768c0 35.3 28.7 64 64 64h464c35.3 0 64-28.7 64-64V126c0-35.3-28.7-64-64-64zM512 824c-22.1 0-40-17.9-40-40s17.9-40 40-40 40 17.9 40 40-17.9 40-40 40z" } }] }, "name": "mobile", "theme": "filled" };
  exports.default = MobileFilled;
  });

  var MobileFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(MobileFilled_1);

  var MobileFilled = function MobileFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MobileFilledSvg
    }));
  };
  var RefIcon$7V = /*#__PURE__*/React.forwardRef(MobileFilled);
  {
    RefIcon$7V.displayName = 'MobileFilled';
  }

  var MobileOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MobileOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M744 62H280c-35.3 0-64 28.7-64 64v768c0 35.3 28.7 64 64 64h464c35.3 0 64-28.7 64-64V126c0-35.3-28.7-64-64-64zm-8 824H288V134h448v752zM472 784a40 40 0 1080 0 40 40 0 10-80 0z" } }] }, "name": "mobile", "theme": "outlined" };
  exports.default = MobileOutlined;
  });

  var MobileOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(MobileOutlined_1);

  var MobileOutlined = function MobileOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MobileOutlinedSvg
    }));
  };
  var RefIcon$7W = /*#__PURE__*/React.forwardRef(MobileOutlined);
  {
    RefIcon$7W.displayName = 'MobileOutlined';
  }

  var MobileTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MobileTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M744 64H280c-35.3 0-64 28.7-64 64v768c0 35.3 28.7 64 64 64h464c35.3 0 64-28.7 64-64V128c0-35.3-28.7-64-64-64zm-8 824H288V136h448v752z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M288 888h448V136H288v752zm224-142c22.1 0 40 17.9 40 40s-17.9 40-40 40-40-17.9-40-40 17.9-40 40-40z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M472 786a40 40 0 1080 0 40 40 0 10-80 0z", "fill": primaryColor } }] }; }, "name": "mobile", "theme": "twotone" };
  exports.default = MobileTwoTone;
  });

  var MobileTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(MobileTwoTone_1);

  var MobileTwoTone = function MobileTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MobileTwoToneSvg
    }));
  };
  var RefIcon$7X = /*#__PURE__*/React.forwardRef(MobileTwoTone);
  {
    RefIcon$7X.displayName = 'MobileTwoTone';
  }

  var MoneyCollectFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MoneyCollectFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M911.5 699.7a8 8 0 00-10.3-4.8L840 717.2V179c0-37.6-30.4-68-68-68H252c-37.6 0-68 30.4-68 68v538.2l-61.3-22.3c-.9-.3-1.8-.5-2.7-.5-4.4 0-8 3.6-8 8V762c0 3.3 2.1 6.3 5.3 7.5L501 909.1c7.1 2.6 14.8 2.6 21.9 0l383.8-139.5c3.2-1.2 5.3-4.2 5.3-7.5v-59.6c0-1-.2-1.9-.5-2.8zm-243.8-377L564 514.3h57.6c4.4 0 8 3.6 8 8v27.1c0 4.4-3.6 8-8 8h-76.3v39h76.3c4.4 0 8 3.6 8 8v27.1c0 4.4-3.6 8-8 8h-76.3V703c0 4.4-3.6 8-8 8h-49.9c-4.4 0-8-3.6-8-8v-63.4h-76c-4.4 0-8-3.6-8-8v-27.1c0-4.4 3.6-8 8-8h76v-39h-76c-4.4 0-8-3.6-8-8v-27.1c0-4.4 3.6-8 8-8h57L356.5 322.8c-2.1-3.8-.7-8.7 3.2-10.8 1.2-.7 2.5-1 3.8-1h55.7a8 8 0 017.1 4.4L511 484.2h3.3L599 315.4c1.3-2.7 4.1-4.4 7.1-4.4h54.5c4.4 0 8 3.6 8.1 7.9 0 1.3-.4 2.6-1 3.8z" } }] }, "name": "money-collect", "theme": "filled" };
  exports.default = MoneyCollectFilled;
  });

  var MoneyCollectFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(MoneyCollectFilled_1);

  var MoneyCollectFilled = function MoneyCollectFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MoneyCollectFilledSvg
    }));
  };
  var RefIcon$7Y = /*#__PURE__*/React.forwardRef(MoneyCollectFilled);
  {
    RefIcon$7Y.displayName = 'MoneyCollectFilled';
  }

  var MoneyCollectOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MoneyCollectOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M911.5 700.7a8 8 0 00-10.3-4.8L840 718.2V180c0-37.6-30.4-68-68-68H252c-37.6 0-68 30.4-68 68v538.2l-61.3-22.3c-.9-.3-1.8-.5-2.7-.5-4.4 0-8 3.6-8 8V763c0 3.3 2.1 6.3 5.3 7.5L501 910.1c7.1 2.6 14.8 2.6 21.9 0l383.8-139.5c3.2-1.2 5.3-4.2 5.3-7.5v-59.6c0-1-.2-1.9-.5-2.8zM512 837.5l-256-93.1V184h512v560.4l-256 93.1zM660.6 312h-54.5c-3 0-5.8 1.7-7.1 4.4l-84.7 168.8H511l-84.7-168.8a8 8 0 00-7.1-4.4h-55.7c-1.3 0-2.6.3-3.8 1-3.9 2.1-5.3 7-3.2 10.8l103.9 191.6h-57c-4.4 0-8 3.6-8 8v27.1c0 4.4 3.6 8 8 8h76v39h-76c-4.4 0-8 3.6-8 8v27.1c0 4.4 3.6 8 8 8h76V704c0 4.4 3.6 8 8 8h49.9c4.4 0 8-3.6 8-8v-63.5h76.3c4.4 0 8-3.6 8-8v-27.1c0-4.4-3.6-8-8-8h-76.3v-39h76.3c4.4 0 8-3.6 8-8v-27.1c0-4.4-3.6-8-8-8H564l103.7-191.6c.6-1.2 1-2.5 1-3.8-.1-4.3-3.7-7.9-8.1-7.9z" } }] }, "name": "money-collect", "theme": "outlined" };
  exports.default = MoneyCollectOutlined;
  });

  var MoneyCollectOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(MoneyCollectOutlined_1);

  var MoneyCollectOutlined = function MoneyCollectOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MoneyCollectOutlinedSvg
    }));
  };
  var RefIcon$7Z = /*#__PURE__*/React.forwardRef(MoneyCollectOutlined);
  {
    RefIcon$7Z.displayName = 'MoneyCollectOutlined';
  }

  var MoneyCollectTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MoneyCollectTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M256 744.4l256 93.1 256-93.1V184H256v560.4zM359.7 313c1.2-.7 2.5-1 3.8-1h55.7a8 8 0 017.1 4.4L511 485.2h3.3L599 316.4c1.3-2.7 4.1-4.4 7.1-4.4h54.5c4.4 0 8 3.6 8.1 7.9 0 1.3-.4 2.6-1 3.8L564 515.3h57.6c4.4 0 8 3.6 8 8v27.1c0 4.4-3.6 8-8 8h-76.3v39h76.3c4.4 0 8 3.6 8 8v27.1c0 4.4-3.6 8-8 8h-76.3V704c0 4.4-3.6 8-8 8h-49.9c-4.4 0-8-3.6-8-8v-63.4h-76c-4.4 0-8-3.6-8-8v-27.1c0-4.4 3.6-8 8-8h76v-39h-76c-4.4 0-8-3.6-8-8v-27.1c0-4.4 3.6-8 8-8h57L356.5 323.8c-2.1-3.8-.7-8.7 3.2-10.8z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M911.5 700.7a8 8 0 00-10.3-4.8L840 718.2V180c0-37.6-30.4-68-68-68H252c-37.6 0-68 30.4-68 68v538.2l-61.3-22.3c-.9-.3-1.8-.5-2.7-.5-4.4 0-8 3.6-8 8V763c0 3.3 2.1 6.3 5.3 7.5L501 910.1c7.1 2.6 14.8 2.6 21.9 0l383.8-139.5c3.2-1.2 5.3-4.2 5.3-7.5v-59.6c0-1-.2-1.9-.5-2.8zM768 744.4l-256 93.1-256-93.1V184h512v560.4z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M460.4 515.4h-57c-4.4 0-8 3.6-8 8v27.1c0 4.4 3.6 8 8 8h76v39h-76c-4.4 0-8 3.6-8 8v27.1c0 4.4 3.6 8 8 8h76V704c0 4.4 3.6 8 8 8h49.9c4.4 0 8-3.6 8-8v-63.5h76.3c4.4 0 8-3.6 8-8v-27.1c0-4.4-3.6-8-8-8h-76.3v-39h76.3c4.4 0 8-3.6 8-8v-27.1c0-4.4-3.6-8-8-8H564l103.7-191.6c.6-1.2 1-2.5 1-3.8-.1-4.3-3.7-7.9-8.1-7.9h-54.5c-3 0-5.8 1.7-7.1 4.4l-84.7 168.8H511l-84.7-168.8a8 8 0 00-7.1-4.4h-55.7c-1.3 0-2.6.3-3.8 1-3.9 2.1-5.3 7-3.2 10.8l103.9 191.6z", "fill": primaryColor } }] }; }, "name": "money-collect", "theme": "twotone" };
  exports.default = MoneyCollectTwoTone;
  });

  var MoneyCollectTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(MoneyCollectTwoTone_1);

  var MoneyCollectTwoTone = function MoneyCollectTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MoneyCollectTwoToneSvg
    }));
  };
  var RefIcon$7_ = /*#__PURE__*/React.forwardRef(MoneyCollectTwoTone);
  {
    RefIcon$7_.displayName = 'MoneyCollectTwoTone';
  }

  var MonitorOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MonitorOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M692.8 412.7l.2-.2-34.6-44.3a7.97 7.97 0 00-11.2-1.4l-50.4 39.3-70.5-90.1a7.97 7.97 0 00-11.2-1.4l-37.9 29.7a7.97 7.97 0 00-1.4 11.2l70.5 90.2-.2.1 34.6 44.3c2.7 3.5 7.7 4.1 11.2 1.4l50.4-39.3 64.1 82c2.7 3.5 7.7 4.1 11.2 1.4l37.9-29.6c3.5-2.7 4.1-7.7 1.4-11.2l-64.1-82.1zM608 112c-167.9 0-304 136.1-304 304 0 70.3 23.9 135 63.9 186.5L114.3 856.1a8.03 8.03 0 000 11.3l42.3 42.3c3.1 3.1 8.2 3.1 11.3 0l253.6-253.6C473 696.1 537.7 720 608 720c167.9 0 304-136.1 304-304S775.9 112 608 112zm161.2 465.2C726.2 620.3 668.9 644 608 644s-118.2-23.7-161.2-66.8C403.7 534.2 380 476.9 380 416s23.7-118.2 66.8-161.2c43-43.1 100.3-66.8 161.2-66.8s118.2 23.7 161.2 66.8c43.1 43 66.8 100.3 66.8 161.2s-23.7 118.2-66.8 161.2z" } }] }, "name": "monitor", "theme": "outlined" };
  exports.default = MonitorOutlined;
  });

  var MonitorOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(MonitorOutlined_1);

  var MonitorOutlined = function MonitorOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MonitorOutlinedSvg
    }));
  };
  var RefIcon$7$ = /*#__PURE__*/React.forwardRef(MonitorOutlined);
  {
    RefIcon$7$.displayName = 'MonitorOutlined';
  }

  var MoonFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MoonFilled = { "icon": { "tag": "svg", "attrs": { "fill-rule": "evenodd", "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M489.5 111.66c30.65-1.8 45.98 36.44 22.58 56.33A243.35 243.35 0 00426 354c0 134.76 109.24 244 244 244 72.58 0 139.9-31.83 186.01-86.08 19.87-23.38 58.07-8.1 56.34 22.53C900.4 745.82 725.15 912 512.5 912 291.31 912 112 732.69 112 511.5c0-211.39 164.29-386.02 374.2-399.65l.2-.01z" } }] }, "name": "moon", "theme": "filled" };
  exports.default = MoonFilled;
  });

  var MoonFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(MoonFilled_1);

  var MoonFilled = function MoonFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MoonFilledSvg
    }));
  };
  var RefIcon$80 = /*#__PURE__*/React.forwardRef(MoonFilled);
  {
    RefIcon$80.displayName = 'MoonFilled';
  }

  var MoonOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MoonOutlined = { "icon": { "tag": "svg", "attrs": { "fill-rule": "evenodd", "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M489.5 111.66c30.65-1.8 45.98 36.44 22.58 56.33A243.35 243.35 0 00426 354c0 134.76 109.24 244 244 244 72.58 0 139.9-31.83 186.01-86.08 19.87-23.38 58.07-8.1 56.34 22.53C900.4 745.82 725.15 912 512.5 912 291.31 912 112 732.69 112 511.5c0-211.39 164.29-386.02 374.2-399.65l.2-.01zm-81.15 79.75l-4.11 1.36C271.1 237.94 176 364.09 176 511.5 176 697.34 326.66 848 512.5 848c148.28 0 274.94-96.2 319.45-230.41l.63-1.93-.11.07a307.06 307.06 0 01-159.73 46.26L670 662c-170.1 0-308-137.9-308-308 0-58.6 16.48-114.54 46.27-162.47z" } }] }, "name": "moon", "theme": "outlined" };
  exports.default = MoonOutlined;
  });

  var MoonOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(MoonOutlined_1);

  var MoonOutlined = function MoonOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MoonOutlinedSvg
    }));
  };
  var RefIcon$81 = /*#__PURE__*/React.forwardRef(MoonOutlined);
  {
    RefIcon$81.displayName = 'MoonOutlined';
  }

  var MoreOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MoreOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M456 231a56 56 0 10112 0 56 56 0 10-112 0zm0 280a56 56 0 10112 0 56 56 0 10-112 0zm0 280a56 56 0 10112 0 56 56 0 10-112 0z" } }] }, "name": "more", "theme": "outlined" };
  exports.default = MoreOutlined;
  });

  var MoreOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(MoreOutlined_1);

  var MoreOutlined = function MoreOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MoreOutlinedSvg
    }));
  };
  var RefIcon$82 = /*#__PURE__*/React.forwardRef(MoreOutlined);
  {
    RefIcon$82.displayName = 'MoreOutlined';
  }

  var MutedFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MutedFilled = { "icon": { "tag": "svg", "attrs": { "fill-rule": "evenodd", "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M771.91 115a31.65 31.65 0 00-17.42 5.27L400 351.97H236a16 16 0 00-16 16v288.06a16 16 0 0016 16h164l354.5 231.7a31.66 31.66 0 0017.42 5.27c16.65 0 32.08-13.25 32.08-32.06V147.06c0-18.8-15.44-32.06-32.09-32.06" } }] }, "name": "muted", "theme": "filled" };
  exports.default = MutedFilled;
  });

  var MutedFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(MutedFilled_1);

  var MutedFilled = function MutedFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MutedFilledSvg
    }));
  };
  var RefIcon$83 = /*#__PURE__*/React.forwardRef(MutedFilled);
  {
    RefIcon$83.displayName = 'MutedFilled';
  }

  var MutedOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var MutedOutlined = { "icon": { "tag": "svg", "attrs": { "fill-rule": "evenodd", "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M771.91 115a31.65 31.65 0 00-17.42 5.27L400 351.97H236a16 16 0 00-16 16v288.06a16 16 0 0016 16h164l354.5 231.7a31.66 31.66 0 0017.42 5.27c16.65 0 32.08-13.25 32.08-32.06V147.06c0-18.8-15.44-32.06-32.09-32.06M732 221v582L439.39 611.75l-17.95-11.73H292V423.98h129.44l17.95-11.73z" } }] }, "name": "muted", "theme": "outlined" };
  exports.default = MutedOutlined;
  });

  var MutedOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(MutedOutlined_1);

  var MutedOutlined = function MutedOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: MutedOutlinedSvg
    }));
  };
  var RefIcon$84 = /*#__PURE__*/React.forwardRef(MutedOutlined);
  {
    RefIcon$84.displayName = 'MutedOutlined';
  }

  var NodeCollapseOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var NodeCollapseOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M952 612c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H298a95.92 95.92 0 00-89-60c-53 0-96 43-96 96s43 96 96 96c40.3 0 74.8-24.8 89-60h150.3v152c0 55.2 44.8 100 100 100H952c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H548.3c-15.5 0-28-12.5-28-28V612H952zM451.7 313.7l172.5 136.2c6.3 5.1 15.8.5 15.8-7.7V344h264c4.4 0 8-3.6 8-8v-60c0-4.4-3.6-8-8-8H640v-98.2c0-8.1-9.4-12.8-15.8-7.7L451.7 298.3a9.9 9.9 0 000 15.4z" } }] }, "name": "node-collapse", "theme": "outlined" };
  exports.default = NodeCollapseOutlined;
  });

  var NodeCollapseOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(NodeCollapseOutlined_1);

  var NodeCollapseOutlined = function NodeCollapseOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: NodeCollapseOutlinedSvg
    }));
  };
  var RefIcon$85 = /*#__PURE__*/React.forwardRef(NodeCollapseOutlined);
  {
    RefIcon$85.displayName = 'NodeCollapseOutlined';
  }

  var NodeExpandOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var NodeExpandOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M952 612c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H298a95.92 95.92 0 00-89-60c-53 0-96 43-96 96s43 96 96 96c40.3 0 74.8-24.8 89-60h150.3v152c0 55.2 44.8 100 100 100H952c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H548.3c-15.5 0-28-12.5-28-28V612H952zM456 344h264v98.2c0 8.1 9.5 12.8 15.8 7.7l172.5-136.2c5-3.9 5-11.4 0-15.3L735.8 162.1c-6.4-5.1-15.8-.5-15.8 7.7V268H456c-4.4 0-8 3.6-8 8v60c0 4.4 3.6 8 8 8z" } }] }, "name": "node-expand", "theme": "outlined" };
  exports.default = NodeExpandOutlined;
  });

  var NodeExpandOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(NodeExpandOutlined_1);

  var NodeExpandOutlined = function NodeExpandOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: NodeExpandOutlinedSvg
    }));
  };
  var RefIcon$86 = /*#__PURE__*/React.forwardRef(NodeExpandOutlined);
  {
    RefIcon$86.displayName = 'NodeExpandOutlined';
  }

  var NodeIndexOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var NodeIndexOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M843.5 737.4c-12.4-75.2-79.2-129.1-155.3-125.4S550.9 676 546 752c-153.5-4.8-208-40.7-199.1-113.7 3.3-27.3 19.8-41.9 50.1-49 18.4-4.3 38.8-4.9 57.3-3.2 1.7.2 3.5.3 5.2.5 11.3 2.7 22.8 5 34.3 6.8 34.1 5.6 68.8 8.4 101.8 6.6 92.8-5 156-45.9 159.2-132.7 3.1-84.1-54.7-143.7-147.9-183.6-29.9-12.8-61.6-22.7-93.3-30.2-14.3-3.4-26.3-5.7-35.2-7.2-7.9-75.9-71.5-133.8-147.8-134.4-76.3-.6-140.9 56.1-150.1 131.9s40 146.3 114.2 163.9c74.2 17.6 149.9-23.3 175.7-95.1 9.4 1.7 18.7 3.6 28 5.8 28.2 6.6 56.4 15.4 82.4 26.6 70.7 30.2 109.3 70.1 107.5 119.9-1.6 44.6-33.6 65.2-96.2 68.6-27.5 1.5-57.6-.9-87.3-5.8-8.3-1.4-15.9-2.8-22.6-4.3-3.9-.8-6.6-1.5-7.8-1.8l-3.1-.6c-2.2-.3-5.9-.8-10.7-1.3-25-2.3-52.1-1.5-78.5 4.6-55.2 12.9-93.9 47.2-101.1 105.8-15.7 126.2 78.6 184.7 276 188.9 29.1 70.4 106.4 107.9 179.6 87 73.3-20.9 119.3-93.4 106.9-168.6zM329.1 345.2a83.3 83.3 0 11.01-166.61 83.3 83.3 0 01-.01 166.61zM695.6 845a83.3 83.3 0 11.01-166.61A83.3 83.3 0 01695.6 845z" } }] }, "name": "node-index", "theme": "outlined" };
  exports.default = NodeIndexOutlined;
  });

  var NodeIndexOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(NodeIndexOutlined_1);

  var NodeIndexOutlined = function NodeIndexOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: NodeIndexOutlinedSvg
    }));
  };
  var RefIcon$87 = /*#__PURE__*/React.forwardRef(NodeIndexOutlined);
  {
    RefIcon$87.displayName = 'NodeIndexOutlined';
  }

  var NotificationFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var NotificationFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112c-3.8 0-7.7.7-11.6 2.3L292 345.9H128c-8.8 0-16 7.4-16 16.6v299c0 9.2 7.2 16.6 16 16.6h101.6c-3.7 11.6-5.6 23.9-5.6 36.4 0 65.9 53.8 119.5 120 119.5 55.4 0 102.1-37.6 115.9-88.4l408.6 164.2c3.9 1.5 7.8 2.3 11.6 2.3 16.9 0 32-14.2 32-33.2V145.2C912 126.2 897 112 880 112zM344 762.3c-26.5 0-48-21.4-48-47.8 0-11.2 3.9-21.9 11-30.4l84.9 34.1c-2 24.6-22.7 44.1-47.9 44.1z" } }] }, "name": "notification", "theme": "filled" };
  exports.default = NotificationFilled;
  });

  var NotificationFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(NotificationFilled_1);

  var NotificationFilled = function NotificationFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: NotificationFilledSvg
    }));
  };
  var RefIcon$88 = /*#__PURE__*/React.forwardRef(NotificationFilled);
  {
    RefIcon$88.displayName = 'NotificationFilled';
  }

  var NotificationOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var NotificationOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112c-3.8 0-7.7.7-11.6 2.3L292 345.9H128c-8.8 0-16 7.4-16 16.6v299c0 9.2 7.2 16.6 16 16.6h101.7c-3.7 11.6-5.7 23.9-5.7 36.4 0 65.9 53.8 119.5 120 119.5 55.4 0 102.1-37.6 115.9-88.4l408.6 164.2c3.9 1.5 7.8 2.3 11.6 2.3 16.9 0 32-14.2 32-33.2V145.2C912 126.2 897 112 880 112zM344 762.3c-26.5 0-48-21.4-48-47.8 0-11.2 3.9-21.9 11-30.4l84.9 34.1c-2 24.6-22.7 44.1-47.9 44.1zm496 58.4L318.8 611.3l-12.9-5.2H184V417.9h121.9l12.9-5.2L840 203.3v617.4z" } }] }, "name": "notification", "theme": "outlined" };
  exports.default = NotificationOutlined;
  });

  var NotificationOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(NotificationOutlined_1);

  var NotificationOutlined = function NotificationOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: NotificationOutlinedSvg
    }));
  };
  var RefIcon$89 = /*#__PURE__*/React.forwardRef(NotificationOutlined);
  {
    RefIcon$89.displayName = 'NotificationOutlined';
  }

  var NotificationTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var NotificationTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M229.6 678.1c-3.7 11.6-5.6 23.9-5.6 36.4 0-12.5 2-24.8 5.7-36.4h-.1zm76.3-260.2H184v188.2h121.9l12.9 5.2L840 820.7V203.3L318.8 412.7z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M880 112c-3.8 0-7.7.7-11.6 2.3L292 345.9H128c-8.8 0-16 7.4-16 16.6v299c0 9.2 7.2 16.6 16 16.6h101.7c-3.7 11.6-5.7 23.9-5.7 36.4 0 65.9 53.8 119.5 120 119.5 55.4 0 102.1-37.6 115.9-88.4l408.6 164.2c3.9 1.5 7.8 2.3 11.6 2.3 16.9 0 32-14.2 32-33.2V145.2C912 126.2 897 112 880 112zM344 762.3c-26.5 0-48-21.4-48-47.8 0-11.2 3.9-21.9 11-30.4l84.9 34.1c-2 24.6-22.7 44.1-47.9 44.1zm496 58.4L318.8 611.3l-12.9-5.2H184V417.9h121.9l12.9-5.2L840 203.3v617.4z", "fill": primaryColor } }] }; }, "name": "notification", "theme": "twotone" };
  exports.default = NotificationTwoTone;
  });

  var NotificationTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(NotificationTwoTone_1);

  var NotificationTwoTone = function NotificationTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: NotificationTwoToneSvg
    }));
  };
  var RefIcon$8a = /*#__PURE__*/React.forwardRef(NotificationTwoTone);
  {
    RefIcon$8a.displayName = 'NotificationTwoTone';
  }

  var NumberOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var NumberOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M872 394c4.4 0 8-3.6 8-8v-60c0-4.4-3.6-8-8-8H708V152c0-4.4-3.6-8-8-8h-64c-4.4 0-8 3.6-8 8v166H400V152c0-4.4-3.6-8-8-8h-64c-4.4 0-8 3.6-8 8v166H152c-4.4 0-8 3.6-8 8v60c0 4.4 3.6 8 8 8h168v236H152c-4.4 0-8 3.6-8 8v60c0 4.4 3.6 8 8 8h168v166c0 4.4 3.6 8 8 8h64c4.4 0 8-3.6 8-8V706h228v166c0 4.4 3.6 8 8 8h64c4.4 0 8-3.6 8-8V706h164c4.4 0 8-3.6 8-8v-60c0-4.4-3.6-8-8-8H708V394h164zM628 630H400V394h228v236z" } }] }, "name": "number", "theme": "outlined" };
  exports.default = NumberOutlined;
  });

  var NumberOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(NumberOutlined_1);

  var NumberOutlined = function NumberOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: NumberOutlinedSvg
    }));
  };
  var RefIcon$8b = /*#__PURE__*/React.forwardRef(NumberOutlined);
  {
    RefIcon$8b.displayName = 'NumberOutlined';
  }

  var OneToOneOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var OneToOneOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M316 672h60c4.4 0 8-3.6 8-8V360c0-4.4-3.6-8-8-8h-60c-4.4 0-8 3.6-8 8v304c0 4.4 3.6 8 8 8zm196-50c22.1 0 40-17.9 40-39 0-23.1-17.9-41-40-41s-40 17.9-40 41c0 21.1 17.9 39 40 39zm0-140c22.1 0 40-17.9 40-39 0-23.1-17.9-41-40-41s-40 17.9-40 41c0 21.1 17.9 39 40 39z" } }, { "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z" } }, { "tag": "path", "attrs": { "d": "M648 672h60c4.4 0 8-3.6 8-8V360c0-4.4-3.6-8-8-8h-60c-4.4 0-8 3.6-8 8v304c0 4.4 3.6 8 8 8z" } }] }, "name": "one-to-one", "theme": "outlined" };
  exports.default = OneToOneOutlined;
  });

  var OneToOneOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(OneToOneOutlined_1);

  var OneToOneOutlined = function OneToOneOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: OneToOneOutlinedSvg
    }));
  };
  var RefIcon$8c = /*#__PURE__*/React.forwardRef(OneToOneOutlined);
  {
    RefIcon$8c.displayName = 'OneToOneOutlined';
  }

  var OpenAIFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var OpenAIFilled = { "icon": { "tag": "svg", "attrs": { "fill-rule": "evenodd", "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M475.6 112c-74.03 0-139.72 42.38-172.92 104.58v237.28l92.27 56.48 3.38-235.7 189-127.45A194.33 194.33 0 00475.6 112m202.9 62.25c-13.17 0-26.05 1.76-38.8 4.36L453.2 304.36l-1.37 96.15 186.58-125.25 231.22 137.28a195.5 195.5 0 004.87-42.33c0-108.04-87.93-195.96-195.99-195.96M247.34 266C167.34 290.7 109 365.22 109 453.2c0 27.92 5.9 54.83 16.79 79.36l245.48 139.77 90.58-56.12-214.5-131.38zm392.88 74.67l-72.7 48.85L771.5 517.58 797.3 753C867.41 723.11 916 653.97 916 573.1c0-27.55-5.86-54.12-16.57-78.53zm-123 82.6l-66.36 44.56-1.05 76.12 64.7 39.66 69.54-43.04-1.84-76.48zm121.2 76.12l5.87 248.34L443 866.9A195.65 195.65 0 00567.84 912c79.22 0 147.8-46.52 178.62-114.99L719.4 550.22zm-52.86 105.3L372.43 736.68 169.56 621.15a195.35 195.35 0 00-5.22 44.16c0 102.94 79.84 187.41 180.81 195.18L588.2 716.6z" } }] }, "name": "open-a-i", "theme": "filled" };
  exports.default = OpenAIFilled;
  });

  var OpenAIFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(OpenAIFilled_1);

  var OpenAIFilled = function OpenAIFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: OpenAIFilledSvg
    }));
  };
  var RefIcon$8d = /*#__PURE__*/React.forwardRef(OpenAIFilled);
  {
    RefIcon$8d.displayName = 'OpenAIFilled';
  }

  var OpenAIOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var OpenAIOutlined = { "icon": { "tag": "svg", "attrs": { "fill-rule": "evenodd", "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M482.88 128c-84.35 0-156.58 52.8-185.68 126.98-60.89 8.13-115.3 43.63-146.6 97.84-42.16 73-32.55 161.88 17.14 224.16-23.38 56.75-19.85 121.6 11.42 175.78 42.18 73.02 124.1 109.15 202.94 97.23C419.58 898.63 477.51 928 540.12 928c84.35 0 156.58-52.8 185.68-126.98 60.89-8.13 115.3-43.62 146.6-97.84 42.16-73 32.55-161.88-17.14-224.16 23.38-56.75 19.85-121.6-11.42-175.78-42.18-73.02-124.1-109.15-202.94-97.23C603.42 157.38 545.49 128 482.88 128m0 61.54c35.6 0 68.97 13.99 94.22 37.74-1.93 1.03-3.92 1.84-5.83 2.94l-136.68 78.91a46.11 46.11 0 00-23.09 39.78l-.84 183.6-65.72-38.34V327.4c0-76 61.9-137.86 137.94-137.86m197.7 75.9c44.19 3.14 86.16 27.44 109.92 68.57 17.8 30.8 22.38 66.7 14.43 100.42-1.88-1.17-3.6-2.49-5.53-3.6l-136.73-78.91a46.23 46.23 0 00-46-.06l-159.47 91.1.36-76.02 144.5-83.41a137.19 137.19 0 0178.53-18.09m-396.92 55.4c-.07 2.2-.3 4.35-.3 6.56v157.75a46.19 46.19 0 0022.91 39.9l158.68 92.5-66.02 37.67-144.55-83.35c-65.86-38-88.47-122.53-50.45-188.34 17.78-30.78 46.55-52.69 79.73-62.68m340.4 79.93l144.54 83.35c65.86 38 88.47 122.53 50.45 188.34-17.78 30.78-46.55 52.69-79.73 62.68.07-2.19.3-4.34.3-6.55V570.85a46.19 46.19 0 00-22.9-39.9l-158.69-92.5zM511.8 464.84l54.54 31.79-.3 63.22-54.84 31.31-54.54-31.85.3-63.16zm100.54 58.65l65.72 38.35V728.6c0 76-61.9 137.86-137.94 137.86-35.6 0-68.97-13.99-94.22-37.74 1.93-1.03 3.92-1.84 5.83-2.94l136.68-78.9a46.11 46.11 0 0023.09-39.8zm-46.54 89.55l-.36 76.02-144.5 83.41c-65.85 38-150.42 15.34-188.44-50.48-17.8-30.8-22.38-66.7-14.43-100.42 1.88 1.17 3.6 2.5 5.53 3.6l136.74 78.91a46.23 46.23 0 0046 .06z" } }] }, "name": "open-a-i", "theme": "outlined" };
  exports.default = OpenAIOutlined;
  });

  var OpenAIOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(OpenAIOutlined_1);

  var OpenAIOutlined = function OpenAIOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: OpenAIOutlinedSvg
    }));
  };
  var RefIcon$8e = /*#__PURE__*/React.forwardRef(OpenAIOutlined);
  {
    RefIcon$8e.displayName = 'OpenAIOutlined';
  }

  var OrderedListOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var OrderedListOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M920 760H336c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h584c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-568H336c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h584c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0 284H336c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h584c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM216 712H100c-2.2 0-4 1.8-4 4v34c0 2.2 1.8 4 4 4h72.4v20.5h-35.7c-2.2 0-4 1.8-4 4v34c0 2.2 1.8 4 4 4h35.7V838H100c-2.2 0-4 1.8-4 4v34c0 2.2 1.8 4 4 4h116c2.2 0 4-1.8 4-4V716c0-2.2-1.8-4-4-4zM100 188h38v120c0 2.2 1.8 4 4 4h40c2.2 0 4-1.8 4-4V152c0-4.4-3.6-8-8-8h-78c-2.2 0-4 1.8-4 4v36c0 2.2 1.8 4 4 4zm116 240H100c-2.2 0-4 1.8-4 4v36c0 2.2 1.8 4 4 4h68.4l-70.3 77.7a8.3 8.3 0 00-2.1 5.4V592c0 2.2 1.8 4 4 4h116c2.2 0 4-1.8 4-4v-36c0-2.2-1.8-4-4-4h-68.4l70.3-77.7a8.3 8.3 0 002.1-5.4V432c0-2.2-1.8-4-4-4z" } }] }, "name": "ordered-list", "theme": "outlined" };
  exports.default = OrderedListOutlined;
  });

  var OrderedListOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(OrderedListOutlined_1);

  var OrderedListOutlined = function OrderedListOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: OrderedListOutlinedSvg
    }));
  };
  var RefIcon$8f = /*#__PURE__*/React.forwardRef(OrderedListOutlined);
  {
    RefIcon$8f.displayName = 'OrderedListOutlined';
  }

  var PaperClipOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PaperClipOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M779.3 196.6c-94.2-94.2-247.6-94.2-341.7 0l-261 260.8c-1.7 1.7-2.6 4-2.6 6.4s.9 4.7 2.6 6.4l36.9 36.9a9 9 0 0012.7 0l261-260.8c32.4-32.4 75.5-50.2 121.3-50.2s88.9 17.8 121.2 50.2c32.4 32.4 50.2 75.5 50.2 121.2 0 45.8-17.8 88.8-50.2 121.2l-266 265.9-43.1 43.1c-40.3 40.3-105.8 40.3-146.1 0-19.5-19.5-30.2-45.4-30.2-73s10.7-53.5 30.2-73l263.9-263.8c6.7-6.6 15.5-10.3 24.9-10.3h.1c9.4 0 18.1 3.7 24.7 10.3 6.7 6.7 10.3 15.5 10.3 24.9 0 9.3-3.7 18.1-10.3 24.7L372.4 653c-1.7 1.7-2.6 4-2.6 6.4s.9 4.7 2.6 6.4l36.9 36.9a9 9 0 0012.7 0l215.6-215.6c19.9-19.9 30.8-46.3 30.8-74.4s-11-54.6-30.8-74.4c-41.1-41.1-107.9-41-149 0L463 364 224.8 602.1A172.22 172.22 0 00174 724.8c0 46.3 18.1 89.8 50.8 122.5 33.9 33.8 78.3 50.7 122.7 50.7 44.4 0 88.8-16.9 122.6-50.7l309.2-309C824.8 492.7 850 432 850 367.5c.1-64.6-25.1-125.3-70.7-170.9z" } }] }, "name": "paper-clip", "theme": "outlined" };
  exports.default = PaperClipOutlined;
  });

  var PaperClipOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(PaperClipOutlined_1);

  var PaperClipOutlined = function PaperClipOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PaperClipOutlinedSvg
    }));
  };
  var RefIcon$8g = /*#__PURE__*/React.forwardRef(PaperClipOutlined);
  {
    RefIcon$8g.displayName = 'PaperClipOutlined';
  }

  var PartitionOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PartitionOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "defs", "attrs": {}, "children": [{ "tag": "style", "attrs": {} }] }, { "tag": "path", "attrs": { "d": "M640.6 429.8h257.1c7.9 0 14.3-6.4 14.3-14.3V158.3c0-7.9-6.4-14.3-14.3-14.3H640.6c-7.9 0-14.3 6.4-14.3 14.3v92.9H490.6c-3.9 0-7.1 3.2-7.1 7.1v221.5h-85.7v-96.5c0-7.9-6.4-14.3-14.3-14.3H126.3c-7.9 0-14.3 6.4-14.3 14.3v257.2c0 7.9 6.4 14.3 14.3 14.3h257.1c7.9 0 14.3-6.4 14.3-14.3V544h85.7v221.5c0 3.9 3.2 7.1 7.1 7.1h135.7v92.9c0 7.9 6.4 14.3 14.3 14.3h257.1c7.9 0 14.3-6.4 14.3-14.3v-257c0-7.9-6.4-14.3-14.3-14.3h-257c-7.9 0-14.3 6.4-14.3 14.3v100h-78.6v-393h78.6v100c0 7.9 6.4 14.3 14.3 14.3zm53.5-217.9h150V362h-150V211.9zM329.9 587h-150V437h150v150zm364.2 75.1h150v150.1h-150V662.1z" } }] }, "name": "partition", "theme": "outlined" };
  exports.default = PartitionOutlined;
  });

  var PartitionOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(PartitionOutlined_1);

  var PartitionOutlined = function PartitionOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PartitionOutlinedSvg
    }));
  };
  var RefIcon$8h = /*#__PURE__*/React.forwardRef(PartitionOutlined);
  {
    RefIcon$8h.displayName = 'PartitionOutlined';
  }

  var PauseCircleFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PauseCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm-80 600c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V360c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v304zm224 0c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V360c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v304z" } }] }, "name": "pause-circle", "theme": "filled" };
  exports.default = PauseCircleFilled;
  });

  var PauseCircleFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(PauseCircleFilled_1);

  var PauseCircleFilled = function PauseCircleFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PauseCircleFilledSvg
    }));
  };
  var RefIcon$8i = /*#__PURE__*/React.forwardRef(PauseCircleFilled);
  {
    RefIcon$8i.displayName = 'PauseCircleFilled';
  }

  var PauseCircleOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PauseCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372zm-88-532h-48c-4.4 0-8 3.6-8 8v304c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V360c0-4.4-3.6-8-8-8zm224 0h-48c-4.4 0-8 3.6-8 8v304c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V360c0-4.4-3.6-8-8-8z" } }] }, "name": "pause-circle", "theme": "outlined" };
  exports.default = PauseCircleOutlined;
  });

  var PauseCircleOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(PauseCircleOutlined_1);

  var PauseCircleOutlined = function PauseCircleOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PauseCircleOutlinedSvg
    }));
  };
  var RefIcon$8j = /*#__PURE__*/React.forwardRef(PauseCircleOutlined);
  {
    RefIcon$8j.displayName = 'PauseCircleOutlined';
  }

  var PauseCircleTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PauseCircleTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm-80 524c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V360c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v304zm224 0c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V360c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v304z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M424 352h-48c-4.4 0-8 3.6-8 8v304c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V360c0-4.4-3.6-8-8-8zm224 0h-48c-4.4 0-8 3.6-8 8v304c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V360c0-4.4-3.6-8-8-8z", "fill": primaryColor } }] }; }, "name": "pause-circle", "theme": "twotone" };
  exports.default = PauseCircleTwoTone;
  });

  var PauseCircleTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(PauseCircleTwoTone_1);

  var PauseCircleTwoTone = function PauseCircleTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PauseCircleTwoToneSvg
    }));
  };
  var RefIcon$8k = /*#__PURE__*/React.forwardRef(PauseCircleTwoTone);
  {
    RefIcon$8k.displayName = 'PauseCircleTwoTone';
  }

  var PauseOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PauseOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M304 176h80v672h-80zm408 0h-64c-4.4 0-8 3.6-8 8v656c0 4.4 3.6 8 8 8h64c4.4 0 8-3.6 8-8V184c0-4.4-3.6-8-8-8z" } }] }, "name": "pause", "theme": "outlined" };
  exports.default = PauseOutlined;
  });

  var PauseOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(PauseOutlined_1);

  var PauseOutlined = function PauseOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PauseOutlinedSvg
    }));
  };
  var RefIcon$8l = /*#__PURE__*/React.forwardRef(PauseOutlined);
  {
    RefIcon$8l.displayName = 'PauseOutlined';
  }

  var PayCircleFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PayCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm166.6 246.8L567.5 515.6h62c4.4 0 8 3.6 8 8v29.9c0 4.4-3.6 8-8 8h-82V603h82c4.4 0 8 3.6 8 8v29.9c0 4.4-3.6 8-8 8h-82V717c0 4.4-3.6 8-8 8h-54.3c-4.4 0-8-3.6-8-8v-68.1h-81.7c-4.4 0-8-3.6-8-8V611c0-4.4 3.6-8 8-8h81.7v-41.5h-81.7c-4.4 0-8-3.6-8-8v-29.9c0-4.4 3.6-8 8-8h61.4L345.4 310.8a8.07 8.07 0 017-11.9h60.7c3 0 5.8 1.7 7.1 4.4l90.6 180h3.4l90.6-180a8 8 0 017.1-4.4h59.5c4.4 0 8 3.6 8 8 .2 1.4-.2 2.7-.8 3.9z" } }] }, "name": "pay-circle", "theme": "filled" };
  exports.default = PayCircleFilled;
  });

  var PayCircleFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(PayCircleFilled_1);

  var PayCircleFilled = function PayCircleFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PayCircleFilledSvg
    }));
  };
  var RefIcon$8m = /*#__PURE__*/React.forwardRef(PayCircleFilled);
  {
    RefIcon$8m.displayName = 'PayCircleFilled';
  }

  var PayCircleOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PayCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372zm159.6-585h-59.5c-3 0-5.8 1.7-7.1 4.4l-90.6 180H511l-90.6-180a8 8 0 00-7.1-4.4h-60.7c-1.3 0-2.6.3-3.8 1-3.9 2.1-5.3 7-3.2 10.9L457 515.7h-61.4c-4.4 0-8 3.6-8 8v29.9c0 4.4 3.6 8 8 8h81.7V603h-81.7c-4.4 0-8 3.6-8 8v29.9c0 4.4 3.6 8 8 8h81.7V717c0 4.4 3.6 8 8 8h54.3c4.4 0 8-3.6 8-8v-68.1h82c4.4 0 8-3.6 8-8V611c0-4.4-3.6-8-8-8h-82v-41.5h82c4.4 0 8-3.6 8-8v-29.9c0-4.4-3.6-8-8-8h-62l111.1-204.8c.6-1.2 1-2.5 1-3.8-.1-4.4-3.7-8-8.1-8z" } }] }, "name": "pay-circle", "theme": "outlined" };
  exports.default = PayCircleOutlined;
  });

  var PayCircleOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(PayCircleOutlined_1);

  var PayCircleOutlined = function PayCircleOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PayCircleOutlinedSvg
    }));
  };
  var RefIcon$8n = /*#__PURE__*/React.forwardRef(PayCircleOutlined);
  {
    RefIcon$8n.displayName = 'PayCircleOutlined';
  }

  var PercentageOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PercentageOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M855.7 210.8l-42.4-42.4a8.03 8.03 0 00-11.3 0L168.3 801.9a8.03 8.03 0 000 11.3l42.4 42.4c3.1 3.1 8.2 3.1 11.3 0L855.6 222c3.2-3 3.2-8.1.1-11.2zM304 448c79.4 0 144-64.6 144-144s-64.6-144-144-144-144 64.6-144 144 64.6 144 144 144zm0-216c39.7 0 72 32.3 72 72s-32.3 72-72 72-72-32.3-72-72 32.3-72 72-72zm416 344c-79.4 0-144 64.6-144 144s64.6 144 144 144 144-64.6 144-144-64.6-144-144-144zm0 216c-39.7 0-72-32.3-72-72s32.3-72 72-72 72 32.3 72 72-32.3 72-72 72z" } }] }, "name": "percentage", "theme": "outlined" };
  exports.default = PercentageOutlined;
  });

  var PercentageOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(PercentageOutlined_1);

  var PercentageOutlined = function PercentageOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PercentageOutlinedSvg
    }));
  };
  var RefIcon$8o = /*#__PURE__*/React.forwardRef(PercentageOutlined);
  {
    RefIcon$8o.displayName = 'PercentageOutlined';
  }

  var PhoneFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PhoneFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M885.6 230.2L779.1 123.8a80.83 80.83 0 00-57.3-23.8c-21.7 0-42.1 8.5-57.4 23.8L549.8 238.4a80.83 80.83 0 00-23.8 57.3c0 21.7 8.5 42.1 23.8 57.4l83.8 83.8A393.82 393.82 0 01553.1 553 395.34 395.34 0 01437 633.8L353.2 550a80.83 80.83 0 00-57.3-23.8c-21.7 0-42.1 8.5-57.4 23.8L123.8 664.5a80.89 80.89 0 00-23.8 57.4c0 21.7 8.5 42.1 23.8 57.4l106.3 106.3c24.4 24.5 58.1 38.4 92.7 38.4 7.3 0 14.3-.6 21.2-1.8 134.8-22.2 268.5-93.9 376.4-201.7C828.2 612.8 899.8 479.2 922.3 344c6.8-41.3-6.9-83.8-36.7-113.8z" } }] }, "name": "phone", "theme": "filled" };
  exports.default = PhoneFilled;
  });

  var PhoneFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(PhoneFilled_1);

  var PhoneFilled = function PhoneFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PhoneFilledSvg
    }));
  };
  var RefIcon$8p = /*#__PURE__*/React.forwardRef(PhoneFilled);
  {
    RefIcon$8p.displayName = 'PhoneFilled';
  }

  var PhoneOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PhoneOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M877.1 238.7L770.6 132.3c-13-13-30.4-20.3-48.8-20.3s-35.8 7.2-48.8 20.3L558.3 246.8c-13 13-20.3 30.5-20.3 48.9 0 18.5 7.2 35.8 20.3 48.9l89.6 89.7a405.46 405.46 0 01-86.4 127.3c-36.7 36.9-79.6 66-127.2 86.6l-89.6-89.7c-13-13-30.4-20.3-48.8-20.3a68.2 68.2 0 00-48.8 20.3L132.3 673c-13 13-20.3 30.5-20.3 48.9 0 18.5 7.2 35.8 20.3 48.9l106.4 106.4c22.2 22.2 52.8 34.9 84.2 34.9 6.5 0 12.8-.5 19.2-1.6 132.4-21.8 263.8-92.3 369.9-198.3C818 606 888.4 474.6 910.4 342.1c6.3-37.6-6.3-76.3-33.3-103.4zm-37.6 91.5c-19.5 117.9-82.9 235.5-178.4 331s-213 158.9-330.9 178.4c-14.8 2.5-30-2.5-40.8-13.2L184.9 721.9 295.7 611l119.8 120 .9.9 21.6-8a481.29 481.29 0 00285.7-285.8l8-21.6-120.8-120.7 110.8-110.9 104.5 104.5c10.8 10.8 15.8 26 13.3 40.8z" } }] }, "name": "phone", "theme": "outlined" };
  exports.default = PhoneOutlined;
  });

  var PhoneOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(PhoneOutlined_1);

  var PhoneOutlined = function PhoneOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PhoneOutlinedSvg
    }));
  };
  var RefIcon$8q = /*#__PURE__*/React.forwardRef(PhoneOutlined);
  {
    RefIcon$8q.displayName = 'PhoneOutlined';
  }

  var PhoneTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PhoneTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M721.7 184.9L610.9 295.8l120.8 120.7-8 21.6A481.29 481.29 0 01438 723.9l-21.6 8-.9-.9-119.8-120-110.8 110.9 104.5 104.5c10.8 10.7 26 15.7 40.8 13.2 117.9-19.5 235.4-82.9 330.9-178.4s158.9-213.1 178.4-331c2.5-14.8-2.5-30-13.3-40.8L721.7 184.9z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M877.1 238.7L770.6 132.3c-13-13-30.4-20.3-48.8-20.3s-35.8 7.2-48.8 20.3L558.3 246.8c-13 13-20.3 30.5-20.3 48.9 0 18.5 7.2 35.8 20.3 48.9l89.6 89.7a405.46 405.46 0 01-86.4 127.3c-36.7 36.9-79.6 66-127.2 86.6l-89.6-89.7c-13-13-30.4-20.3-48.8-20.3a68.2 68.2 0 00-48.8 20.3L132.3 673c-13 13-20.3 30.5-20.3 48.9 0 18.5 7.2 35.8 20.3 48.9l106.4 106.4c22.2 22.2 52.8 34.9 84.2 34.9 6.5 0 12.8-.5 19.2-1.6 132.4-21.8 263.8-92.3 369.9-198.3C818 606 888.4 474.6 910.4 342.1c6.3-37.6-6.3-76.3-33.3-103.4zm-37.6 91.5c-19.5 117.9-82.9 235.5-178.4 331s-213 158.9-330.9 178.4c-14.8 2.5-30-2.5-40.8-13.2L184.9 721.9 295.7 611l119.8 120 .9.9 21.6-8a481.29 481.29 0 00285.7-285.8l8-21.6-120.8-120.7 110.8-110.9 104.5 104.5c10.8 10.8 15.8 26 13.3 40.8z", "fill": primaryColor } }] }; }, "name": "phone", "theme": "twotone" };
  exports.default = PhoneTwoTone;
  });

  var PhoneTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(PhoneTwoTone_1);

  var PhoneTwoTone = function PhoneTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PhoneTwoToneSvg
    }));
  };
  var RefIcon$8r = /*#__PURE__*/React.forwardRef(PhoneTwoTone);
  {
    RefIcon$8r.displayName = 'PhoneTwoTone';
  }

  var PicCenterOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PicCenterOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M952 792H72c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h880c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-632H72c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h880c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM848 660c8.8 0 16-7.2 16-16V380c0-8.8-7.2-16-16-16H176c-8.8 0-16 7.2-16 16v264c0 8.8 7.2 16 16 16h672zM232 436h560v152H232V436z" } }] }, "name": "pic-center", "theme": "outlined" };
  exports.default = PicCenterOutlined;
  });

  var PicCenterOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(PicCenterOutlined_1);

  var PicCenterOutlined = function PicCenterOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PicCenterOutlinedSvg
    }));
  };
  var RefIcon$8s = /*#__PURE__*/React.forwardRef(PicCenterOutlined);
  {
    RefIcon$8s.displayName = 'PicCenterOutlined';
  }

  var PicLeftOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PicLeftOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M952 792H72c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h880c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-632H72c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h880c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zM608 660c8.8 0 16-7.2 16-16V380c0-8.8-7.2-16-16-16H96c-8.8 0-16 7.2-16 16v264c0 8.8 7.2 16 16 16h512zM152 436h400v152H152V436zm552 210c0 4.4 3.6 8 8 8h224c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H712c-4.4 0-8 3.6-8 8v56zm8-204h224c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H712c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8z" } }] }, "name": "pic-left", "theme": "outlined" };
  exports.default = PicLeftOutlined;
  });

  var PicLeftOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(PicLeftOutlined_1);

  var PicLeftOutlined = function PicLeftOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PicLeftOutlinedSvg
    }));
  };
  var RefIcon$8t = /*#__PURE__*/React.forwardRef(PicLeftOutlined);
  {
    RefIcon$8t.displayName = 'PicLeftOutlined';
  }

  var PicRightOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PicRightOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M952 792H72c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h880c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm0-632H72c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8h880c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8zm-24 500c8.8 0 16-7.2 16-16V380c0-8.8-7.2-16-16-16H416c-8.8 0-16 7.2-16 16v264c0 8.8 7.2 16 16 16h512zM472 436h400v152H472V436zM80 646c0 4.4 3.6 8 8 8h224c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H88c-4.4 0-8 3.6-8 8v56zm8-204h224c4.4 0 8-3.6 8-8v-56c0-4.4-3.6-8-8-8H88c-4.4 0-8 3.6-8 8v56c0 4.4 3.6 8 8 8z" } }] }, "name": "pic-right", "theme": "outlined" };
  exports.default = PicRightOutlined;
  });

  var PicRightOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(PicRightOutlined_1);

  var PicRightOutlined = function PicRightOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PicRightOutlinedSvg
    }));
  };
  var RefIcon$8u = /*#__PURE__*/React.forwardRef(PicRightOutlined);
  {
    RefIcon$8u.displayName = 'PicRightOutlined';
  }

  var PictureFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PictureFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M928 160H96c-17.7 0-32 14.3-32 32v640c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V192c0-17.7-14.3-32-32-32zM338 304c35.3 0 64 28.7 64 64s-28.7 64-64 64-64-28.7-64-64 28.7-64 64-64zm513.9 437.1a8.11 8.11 0 01-5.2 1.9H177.2c-4.4 0-8-3.6-8-8 0-1.9.7-3.7 1.9-5.2l170.3-202c2.8-3.4 7.9-3.8 11.3-1 .3.3.7.6 1 1l99.4 118 158.1-187.5c2.8-3.4 7.9-3.8 11.3-1 .3.3.7.6 1 1l229.6 271.6c2.6 3.3 2.2 8.4-1.2 11.2z" } }] }, "name": "picture", "theme": "filled" };
  exports.default = PictureFilled;
  });

  var PictureFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(PictureFilled_1);

  var PictureFilled = function PictureFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PictureFilledSvg
    }));
  };
  var RefIcon$8v = /*#__PURE__*/React.forwardRef(PictureFilled);
  {
    RefIcon$8v.displayName = 'PictureFilled';
  }

  var PictureOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PictureOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M928 160H96c-17.7 0-32 14.3-32 32v640c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V192c0-17.7-14.3-32-32-32zm-40 632H136v-39.9l138.5-164.3 150.1 178L658.1 489 888 761.6V792zm0-129.8L664.2 396.8c-3.2-3.8-9-3.8-12.2 0L424.6 666.4l-144-170.7c-3.2-3.8-9-3.8-12.2 0L136 652.7V232h752v430.2zM304 456a88 88 0 100-176 88 88 0 000 176zm0-116c15.5 0 28 12.5 28 28s-12.5 28-28 28-28-12.5-28-28 12.5-28 28-28z" } }] }, "name": "picture", "theme": "outlined" };
  exports.default = PictureOutlined;
  });

  var PictureOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(PictureOutlined_1);

  var PictureOutlined = function PictureOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PictureOutlinedSvg
    }));
  };
  var RefIcon$8w = /*#__PURE__*/React.forwardRef(PictureOutlined);
  {
    RefIcon$8w.displayName = 'PictureOutlined';
  }

  var PictureTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PictureTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M928 160H96c-17.7 0-32 14.3-32 32v640c0 17.7 14.3 32 32 32h832c17.7 0 32-14.3 32-32V192c0-17.7-14.3-32-32-32zm-40 632H136v-39.9l138.5-164.3 150.1 178L658.1 489 888 761.6V792zm0-129.8L664.2 396.8c-3.2-3.8-9-3.8-12.2 0L424.6 666.4l-144-170.7c-3.2-3.8-9-3.8-12.2 0L136 652.7V232h752v430.2z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M424.6 765.8l-150.1-178L136 752.1V792h752v-30.4L658.1 489z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M136 652.7l132.4-157c3.2-3.8 9-3.8 12.2 0l144 170.7L652 396.8c3.2-3.8 9-3.8 12.2 0L888 662.2V232H136v420.7zM304 280a88 88 0 110 176 88 88 0 010-176z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M276 368a28 28 0 1056 0 28 28 0 10-56 0z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M304 456a88 88 0 100-176 88 88 0 000 176zm0-116c15.5 0 28 12.5 28 28s-12.5 28-28 28-28-12.5-28-28 12.5-28 28-28z", "fill": primaryColor } }] }; }, "name": "picture", "theme": "twotone" };
  exports.default = PictureTwoTone;
  });

  var PictureTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(PictureTwoTone_1);

  var PictureTwoTone = function PictureTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PictureTwoToneSvg
    }));
  };
  var RefIcon$8x = /*#__PURE__*/React.forwardRef(PictureTwoTone);
  {
    RefIcon$8x.displayName = 'PictureTwoTone';
  }

  var PieChartFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PieChartFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M863.1 518.5H505.5V160.9c0-4.4-3.6-8-8-8h-26a398.57 398.57 0 00-282.5 117 397.47 397.47 0 00-85.6 127C82.6 446.2 72 498.5 72 552.5S82.6 658.7 103.4 708c20.1 47.5 48.9 90.3 85.6 127 36.7 36.7 79.4 65.5 127 85.6a396.64 396.64 0 00155.6 31.5 398.57 398.57 0 00282.5-117c36.7-36.7 65.5-79.4 85.6-127a396.64 396.64 0 0031.5-155.6v-26c-.1-4.4-3.7-8-8.1-8zM951 463l-2.6-28.2c-8.5-92-49.3-178.8-115.1-244.3A398.5 398.5 0 00588.4 75.6L560.1 73c-4.7-.4-8.7 3.2-8.7 7.9v383.7c0 4.4 3.6 8 8 8l383.6-1c4.7-.1 8.4-4 8-8.6z" } }] }, "name": "pie-chart", "theme": "filled" };
  exports.default = PieChartFilled;
  });

  var PieChartFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(PieChartFilled_1);

  var PieChartFilled = function PieChartFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PieChartFilledSvg
    }));
  };
  var RefIcon$8y = /*#__PURE__*/React.forwardRef(PieChartFilled);
  {
    RefIcon$8y.displayName = 'PieChartFilled';
  }

  var PieChartOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PieChartOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M864 518H506V160c0-4.4-3.6-8-8-8h-26a398.46 398.46 0 00-282.8 117.1 398.19 398.19 0 00-85.7 127.1A397.61 397.61 0 0072 552a398.46 398.46 0 00117.1 282.8c36.7 36.7 79.5 65.6 127.1 85.7A397.61 397.61 0 00472 952a398.46 398.46 0 00282.8-117.1c36.7-36.7 65.6-79.5 85.7-127.1A397.61 397.61 0 00872 552v-26c0-4.4-3.6-8-8-8zM705.7 787.8A331.59 331.59 0 01470.4 884c-88.1-.4-170.9-34.9-233.2-97.2C174.5 724.1 140 640.7 140 552c0-88.7 34.5-172.1 97.2-234.8 54.6-54.6 124.9-87.9 200.8-95.5V586h364.3c-7.7 76.3-41.3 147-96.6 201.8zM952 462.4l-2.6-28.2c-8.5-92.1-49.4-179-115.2-244.6A399.4 399.4 0 00589 74.6L560.7 72c-4.7-.4-8.7 3.2-8.7 7.9V464c0 4.4 3.6 8 8 8l384-1c4.7 0 8.4-4 8-8.6zm-332.2-58.2V147.6a332.24 332.24 0 01166.4 89.8c45.7 45.6 77 103.6 90 166.1l-256.4.7z" } }] }, "name": "pie-chart", "theme": "outlined" };
  exports.default = PieChartOutlined;
  });

  var PieChartOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(PieChartOutlined_1);

  var PieChartOutlined = function PieChartOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PieChartOutlinedSvg
    }));
  };
  var RefIcon$8z = /*#__PURE__*/React.forwardRef(PieChartOutlined);
  {
    RefIcon$8z.displayName = 'PieChartOutlined';
  }

  var PieChartTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PieChartTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M316.2 920.5c-47.6-20.1-90.4-49-127.1-85.7a398.19 398.19 0 01-85.7-127.1A397.12 397.12 0 0172 552.2v.2a398.57 398.57 0 00117 282.5c36.7 36.7 79.4 65.5 127 85.6A396.64 396.64 0 00471.6 952c27 0 53.6-2.7 79.7-7.9-25.9 5.2-52.4 7.8-79.3 7.8-54 .1-106.4-10.5-155.8-31.4zM560 472c-4.4 0-8-3.6-8-8V79.9c0-1.3.3-2.5.9-3.6-.9 1.3-1.5 2.9-1.5 4.6v383.7c0 4.4 3.6 8 8 8l383.6-1c1.6 0 3.1-.5 4.4-1.3-1 .5-2.2.7-3.4.7l-384 1z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M619.8 147.6v256.6l256.4-.7c-13-62.5-44.3-120.5-90-166.1a332.24 332.24 0 00-166.4-89.8z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M438 221.7c-75.9 7.6-146.2 40.9-200.8 95.5C174.5 379.9 140 463.3 140 552s34.5 172.1 97.2 234.8c62.3 62.3 145.1 96.8 233.2 97.2 88.2.4 172.7-34.1 235.3-96.2C761 733 794.6 662.3 802.3 586H438V221.7z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M864 518H506V160c0-4.4-3.6-8-8-8h-26a398.46 398.46 0 00-282.8 117.1 398.19 398.19 0 00-85.7 127.1A397.61 397.61 0 0072 552v.2c0 53.9 10.6 106.2 31.4 155.5 20.1 47.6 49 90.4 85.7 127.1 36.7 36.7 79.5 65.6 127.1 85.7A397.61 397.61 0 00472 952c26.9 0 53.4-2.6 79.3-7.8 26.1-5.3 51.7-13.1 76.4-23.6 47.6-20.1 90.4-49 127.1-85.7 36.7-36.7 65.6-79.5 85.7-127.1A397.61 397.61 0 00872 552v-26c0-4.4-3.6-8-8-8zM705.7 787.8A331.59 331.59 0 01470.4 884c-88.1-.4-170.9-34.9-233.2-97.2C174.5 724.1 140 640.7 140 552s34.5-172.1 97.2-234.8c54.6-54.6 124.9-87.9 200.8-95.5V586h364.3c-7.7 76.3-41.3 147-96.6 201.8z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M952 462.4l-2.6-28.2c-8.5-92.1-49.4-179-115.2-244.6A399.4 399.4 0 00589 74.6L560.7 72c-3.4-.3-6.4 1.5-7.8 4.3a8.7 8.7 0 00-.9 3.6V464c0 4.4 3.6 8 8 8l384-1c1.2 0 2.3-.3 3.4-.7a8.1 8.1 0 004.6-7.9zm-332.2-58.2V147.6a332.24 332.24 0 01166.4 89.8c45.7 45.6 77 103.6 90 166.1l-256.4.7z", "fill": primaryColor } }] }; }, "name": "pie-chart", "theme": "twotone" };
  exports.default = PieChartTwoTone;
  });

  var PieChartTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(PieChartTwoTone_1);

  var PieChartTwoTone = function PieChartTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PieChartTwoToneSvg
    }));
  };
  var RefIcon$8A = /*#__PURE__*/React.forwardRef(PieChartTwoTone);
  {
    RefIcon$8A.displayName = 'PieChartTwoTone';
  }

  var PinterestFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PinterestFilled = { "icon": { "tag": "svg", "attrs": { "fill-rule": "evenodd", "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.97 64 64 264.97 64 512c0 192.53 122.08 357.04 292.88 420.28-4.92-43.86-4.14-115.68 3.97-150.46 7.6-32.66 49.11-208.16 49.11-208.16s-12.53-25.1-12.53-62.16c0-58.24 33.74-101.7 75.77-101.7 35.74 0 52.97 26.83 52.97 58.98 0 35.96-22.85 89.66-34.7 139.43-9.87 41.7 20.91 75.7 62.02 75.7 74.43 0 131.64-78.5 131.64-191.77 0-100.27-72.03-170.38-174.9-170.38-119.15 0-189.08 89.38-189.08 181.75 0 35.98 13.85 74.58 31.16 95.58 3.42 4.16 3.92 7.78 2.9 12-3.17 13.22-10.22 41.67-11.63 47.5-1.82 7.68-6.07 9.28-14 5.59-52.3-24.36-85-100.81-85-162.25 0-132.1 95.96-253.43 276.71-253.43 145.29 0 258.18 103.5 258.18 241.88 0 144.34-91.02 260.49-217.31 260.49-42.44 0-82.33-22.05-95.97-48.1 0 0-21 79.96-26.1 99.56-8.82 33.9-46.55 104.13-65.49 136.03A446.16 446.16 0 00512 960c247.04 0 448-200.97 448-448S759.04 64 512 64" } }] }, "name": "pinterest", "theme": "filled" };
  exports.default = PinterestFilled;
  });

  var PinterestFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(PinterestFilled_1);

  var PinterestFilled = function PinterestFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PinterestFilledSvg
    }));
  };
  var RefIcon$8B = /*#__PURE__*/React.forwardRef(PinterestFilled);
  {
    RefIcon$8B.displayName = 'PinterestFilled';
  }

  var PinterestOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PinterestOutlined = { "icon": { "tag": "svg", "attrs": { "fill-rule": "evenodd", "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.8 64 64 264.8 64 512s200.8 448 448 448 448-200.8 448-448S759.2 64 512 64m0 38.96c226.14 0 409.04 182.9 409.04 409.04 0 226.14-182.9 409.04-409.04 409.04-41.37 0-81.27-6.19-118.89-17.57 16.76-28.02 38.4-68.06 46.99-101.12 5.1-19.6 26.1-99.56 26.1-99.56 13.64 26.04 53.5 48.09 95.94 48.09 126.3 0 217.34-116.15 217.34-260.49 0-138.37-112.91-241.88-258.2-241.88-180.75 0-276.69 121.32-276.69 253.4 0 61.44 32.68 137.91 85 162.26 7.92 3.7 12.17 2.1 14-5.59 1.4-5.83 8.46-34.25 11.63-47.48 1.02-4.22.53-7.86-2.89-12.02-17.31-21-31.2-59.58-31.2-95.56 0-92.38 69.94-181.78 189.08-181.78 102.88 0 174.93 70.13 174.93 170.4 0 113.28-57.2 191.78-131.63 191.78-41.11 0-71.89-34-62.02-75.7 11.84-49.78 34.7-103.49 34.7-139.44 0-32.15-17.25-58.97-53-58.97-42.02 0-75.78 43.45-75.78 101.7 0 37.06 12.56 62.16 12.56 62.16s-41.51 175.5-49.12 208.17c-7.62 32.64-5.58 76.6-2.43 109.34C208.55 830.52 102.96 683.78 102.96 512c0-226.14 182.9-409.04 409.04-409.04" } }] }, "name": "pinterest", "theme": "outlined" };
  exports.default = PinterestOutlined;
  });

  var PinterestOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(PinterestOutlined_1);

  var PinterestOutlined = function PinterestOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PinterestOutlinedSvg
    }));
  };
  var RefIcon$8C = /*#__PURE__*/React.forwardRef(PinterestOutlined);
  {
    RefIcon$8C.displayName = 'PinterestOutlined';
  }

  var PlayCircleFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PlayCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm144.1 454.9L437.7 677.8a8.02 8.02 0 01-12.7-6.5V353.7a8 8 0 0112.7-6.5L656.1 506a7.9 7.9 0 010 12.9z" } }] }, "name": "play-circle", "theme": "filled" };
  exports.default = PlayCircleFilled;
  });

  var PlayCircleFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(PlayCircleFilled_1);

  var PlayCircleFilled = function PlayCircleFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PlayCircleFilledSvg
    }));
  };
  var RefIcon$8D = /*#__PURE__*/React.forwardRef(PlayCircleFilled);
  {
    RefIcon$8D.displayName = 'PlayCircleFilled';
  }

  var PlayCircleOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PlayCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z" } }, { "tag": "path", "attrs": { "d": "M719.4 499.1l-296.1-215A15.9 15.9 0 00398 297v430c0 13.1 14.8 20.5 25.3 12.9l296.1-215a15.9 15.9 0 000-25.8zm-257.6 134V390.9L628.5 512 461.8 633.1z" } }] }, "name": "play-circle", "theme": "outlined" };
  exports.default = PlayCircleOutlined;
  });

  var PlayCircleOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(PlayCircleOutlined_1);

  var PlayCircleOutlined = function PlayCircleOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PlayCircleOutlinedSvg
    }));
  };
  var RefIcon$8E = /*#__PURE__*/React.forwardRef(PlayCircleOutlined);
  {
    RefIcon$8E.displayName = 'PlayCircleOutlined';
  }

  var PlayCircleTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PlayCircleTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm164.1 378.2L457.7 677.1a8.02 8.02 0 01-12.7-6.5V353a8 8 0 0112.7-6.5l218.4 158.8a7.9 7.9 0 010 12.9z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M676.1 505.3L457.7 346.5A8 8 0 00445 353v317.6a8.02 8.02 0 0012.7 6.5l218.4-158.9a7.9 7.9 0 000-12.9z", "fill": primaryColor } }] }; }, "name": "play-circle", "theme": "twotone" };
  exports.default = PlayCircleTwoTone;
  });

  var PlayCircleTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(PlayCircleTwoTone_1);

  var PlayCircleTwoTone = function PlayCircleTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PlayCircleTwoToneSvg
    }));
  };
  var RefIcon$8F = /*#__PURE__*/React.forwardRef(PlayCircleTwoTone);
  {
    RefIcon$8F.displayName = 'PlayCircleTwoTone';
  }

  var PlaySquareFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PlaySquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM641.7 520.8L442.3 677.6c-7.4 5.8-18.3.6-18.3-8.8V355.3c0-9.4 10.9-14.7 18.3-8.8l199.4 156.7a11.2 11.2 0 010 17.6z" } }] }, "name": "play-square", "theme": "filled" };
  exports.default = PlaySquareFilled;
  });

  var PlaySquareFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(PlaySquareFilled_1);

  var PlaySquareFilled = function PlaySquareFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PlaySquareFilledSvg
    }));
  };
  var RefIcon$8G = /*#__PURE__*/React.forwardRef(PlaySquareFilled);
  {
    RefIcon$8G.displayName = 'PlaySquareFilled';
  }

  var PlaySquareOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PlaySquareOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M442.3 677.6l199.4-156.7a11.3 11.3 0 000-17.7L442.3 346.4c-7.4-5.8-18.3-.6-18.3 8.8v313.5c0 9.4 10.9 14.7 18.3 8.9z" } }, { "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z" } }] }, "name": "play-square", "theme": "outlined" };
  exports.default = PlaySquareOutlined;
  });

  var PlaySquareOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(PlaySquareOutlined_1);

  var PlaySquareOutlined = function PlaySquareOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PlaySquareOutlinedSvg
    }));
  };
  var RefIcon$8H = /*#__PURE__*/React.forwardRef(PlaySquareOutlined);
  {
    RefIcon$8H.displayName = 'PlaySquareOutlined';
  }

  var PlaySquareTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PlaySquareTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M184 840h656V184H184v656zm240-484.7c0-9.4 10.9-14.7 18.3-8.8l199.4 156.7a11.2 11.2 0 010 17.6L442.3 677.6c-7.4 5.8-18.3.6-18.3-8.8V355.3z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M442.3 677.6l199.4-156.8a11.2 11.2 0 000-17.6L442.3 346.5c-7.4-5.9-18.3-.6-18.3 8.8v313.5c0 9.4 10.9 14.6 18.3 8.8z", "fill": primaryColor } }] }; }, "name": "play-square", "theme": "twotone" };
  exports.default = PlaySquareTwoTone;
  });

  var PlaySquareTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(PlaySquareTwoTone_1);

  var PlaySquareTwoTone = function PlaySquareTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PlaySquareTwoToneSvg
    }));
  };
  var RefIcon$8I = /*#__PURE__*/React.forwardRef(PlaySquareTwoTone);
  {
    RefIcon$8I.displayName = 'PlaySquareTwoTone';
  }

  var PlusCircleFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PlusCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm192 472c0 4.4-3.6 8-8 8H544v152c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V544H328c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h152V328c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v152h152c4.4 0 8 3.6 8 8v48z" } }] }, "name": "plus-circle", "theme": "filled" };
  exports.default = PlusCircleFilled;
  });

  var PlusCircleFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(PlusCircleFilled_1);

  var PlusCircleFilled = function PlusCircleFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PlusCircleFilledSvg
    }));
  };
  var RefIcon$8J = /*#__PURE__*/React.forwardRef(PlusCircleFilled);
  {
    RefIcon$8J.displayName = 'PlusCircleFilled';
  }

  var PlusCircleOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PlusCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M696 480H544V328c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v152H328c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h152v152c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V544h152c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8z" } }, { "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z" } }] }, "name": "plus-circle", "theme": "outlined" };
  exports.default = PlusCircleOutlined;
  });

  var PlusCircleOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(PlusCircleOutlined_1);

  var PlusCircleOutlined = function PlusCircleOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PlusCircleOutlinedSvg
    }));
  };
  var RefIcon$8K = /*#__PURE__*/React.forwardRef(PlusCircleOutlined);
  {
    RefIcon$8K.displayName = 'PlusCircleOutlined';
  }

  var PlusCircleTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PlusCircleTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm192 396c0 4.4-3.6 8-8 8H544v152c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V544H328c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h152V328c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v152h152c4.4 0 8 3.6 8 8v48z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M696 480H544V328c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v152H328c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8h152v152c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V544h152c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8z", "fill": primaryColor } }] }; }, "name": "plus-circle", "theme": "twotone" };
  exports.default = PlusCircleTwoTone;
  });

  var PlusCircleTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(PlusCircleTwoTone_1);

  var PlusCircleTwoTone = function PlusCircleTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PlusCircleTwoToneSvg
    }));
  };
  var RefIcon$8L = /*#__PURE__*/React.forwardRef(PlusCircleTwoTone);
  {
    RefIcon$8L.displayName = 'PlusCircleTwoTone';
  }

  var PlusOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PlusOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M482 152h60q8 0 8 8v704q0 8-8 8h-60q-8 0-8-8V160q0-8 8-8z" } }, { "tag": "path", "attrs": { "d": "M192 474h672q8 0 8 8v60q0 8-8 8H160q-8 0-8-8v-60q0-8 8-8z" } }] }, "name": "plus", "theme": "outlined" };
  exports.default = PlusOutlined;
  });

  var PlusOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(PlusOutlined_1);

  var PlusOutlined = function PlusOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PlusOutlinedSvg
    }));
  };
  var RefIcon$8M = /*#__PURE__*/React.forwardRef(PlusOutlined);
  {
    RefIcon$8M.displayName = 'PlusOutlined';
  }

  var PlusSquareFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PlusSquareFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM704 536c0 4.4-3.6 8-8 8H544v152c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V544H328c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h152V328c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v152h152c4.4 0 8 3.6 8 8v48z" } }] }, "name": "plus-square", "theme": "filled" };
  exports.default = PlusSquareFilled;
  });

  var PlusSquareFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(PlusSquareFilled_1);

  var PlusSquareFilled = function PlusSquareFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PlusSquareFilledSvg
    }));
  };
  var RefIcon$8N = /*#__PURE__*/React.forwardRef(PlusSquareFilled);
  {
    RefIcon$8N.displayName = 'PlusSquareFilled';
  }

  var PlusSquareOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PlusSquareOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M328 544h152v152c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V544h152c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H544V328c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v152H328c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8z" } }, { "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z" } }] }, "name": "plus-square", "theme": "outlined" };
  exports.default = PlusSquareOutlined;
  });

  var PlusSquareOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(PlusSquareOutlined_1);

  var PlusSquareOutlined = function PlusSquareOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PlusSquareOutlinedSvg
    }));
  };
  var RefIcon$8O = /*#__PURE__*/React.forwardRef(PlusSquareOutlined);
  {
    RefIcon$8O.displayName = 'PlusSquareOutlined';
  }

  var PlusSquareTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PlusSquareTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M184 840h656V184H184v656zm136-352c0-4.4 3.6-8 8-8h152V328c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v152h152c4.4 0 8 3.6 8 8v48c0 4.4-3.6 8-8 8H544v152c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V544H328c-4.4 0-8-3.6-8-8v-48z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M328 544h152v152c0 4.4 3.6 8 8 8h48c4.4 0 8-3.6 8-8V544h152c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H544V328c0-4.4-3.6-8-8-8h-48c-4.4 0-8 3.6-8 8v152H328c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8z", "fill": primaryColor } }] }; }, "name": "plus-square", "theme": "twotone" };
  exports.default = PlusSquareTwoTone;
  });

  var PlusSquareTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(PlusSquareTwoTone_1);

  var PlusSquareTwoTone = function PlusSquareTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PlusSquareTwoToneSvg
    }));
  };
  var RefIcon$8P = /*#__PURE__*/React.forwardRef(PlusSquareTwoTone);
  {
    RefIcon$8P.displayName = 'PlusSquareTwoTone';
  }

  var PoundCircleFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PoundCircleFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm146 658c0 4.4-3.6 8-8 8H376.2c-4.4 0-8-3.6-8-8v-38.5c0-3.7 2.5-6.9 6.1-7.8 44-10.9 72.8-49 72.8-94.2 0-14.7-2.5-29.4-5.9-44.2H374c-4.4 0-8-3.6-8-8v-30c0-4.4 3.6-8 8-8h53.7c-7.8-25.1-14.6-50.7-14.6-77.1 0-75.8 58.6-120.3 151.5-120.3 26.5 0 51.4 5.5 70.3 12.7 3.1 1.2 5.2 4.2 5.2 7.5v39.5a8 8 0 01-10.6 7.6c-17.9-6.4-39-10.5-60.4-10.5-53.3 0-87.3 26.6-87.3 70.2 0 24.7 6.2 47.9 13.4 70.5h112c4.4 0 8 3.6 8 8v30c0 4.4-3.6 8-8 8h-98.6c3.1 13.2 5.3 26.9 5.3 41 0 40.7-16.5 73.9-43.9 91.1v4.7h180c4.4 0 8 3.6 8 8V722z" } }] }, "name": "pound-circle", "theme": "filled" };
  exports.default = PoundCircleFilled;
  });

  var PoundCircleFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(PoundCircleFilled_1);

  var PoundCircleFilled = function PoundCircleFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PoundCircleFilledSvg
    }));
  };
  var RefIcon$8Q = /*#__PURE__*/React.forwardRef(PoundCircleFilled);
  {
    RefIcon$8Q.displayName = 'PoundCircleFilled';
  }

  var PoundCircleOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PoundCircleOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372zm138-209.8H469.8v-4.7c27.4-17.2 43.9-50.4 43.9-91.1 0-14.1-2.2-27.9-5.3-41H607c4.4 0 8-3.6 8-8v-30c0-4.4-3.6-8-8-8H495c-7.2-22.6-13.4-45.7-13.4-70.5 0-43.5 34-70.2 87.3-70.2 21.5 0 42.5 4.1 60.4 10.5 5.2 1.9 10.6-2 10.6-7.6v-39.5c0-3.3-2.1-6.3-5.2-7.5-18.8-7.2-43.8-12.7-70.3-12.7-92.9 0-151.5 44.5-151.5 120.3 0 26.3 6.9 52 14.6 77.1H374c-4.4 0-8 3.6-8 8v30c0 4.4 3.6 8 8 8h67.1c3.4 14.7 5.9 29.4 5.9 44.2 0 45.2-28.8 83.3-72.8 94.2-3.6.9-6.1 4.1-6.1 7.8V722c0 4.4 3.6 8 8 8H650c4.4 0 8-3.6 8-8v-39.8c0-4.4-3.6-8-8-8z" } }] }, "name": "pound-circle", "theme": "outlined" };
  exports.default = PoundCircleOutlined;
  });

  var PoundCircleOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(PoundCircleOutlined_1);

  var PoundCircleOutlined = function PoundCircleOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PoundCircleOutlinedSvg
    }));
  };
  var RefIcon$8R = /*#__PURE__*/React.forwardRef(PoundCircleOutlined);
  {
    RefIcon$8R.displayName = 'PoundCircleOutlined';
  }

  var PoundCircleTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PoundCircleTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M512 140c-205.4 0-372 166.6-372 372s166.6 372 372 372 372-166.6 372-372-166.6-372-372-372zm146 582.1c0 4.4-3.6 8-8 8H376.2c-4.4 0-8-3.6-8-8v-38.5c0-3.7 2.5-6.9 6.1-7.8 44-10.9 72.8-49 72.8-94.2 0-14.7-2.5-29.4-5.9-44.2H374c-4.4 0-8-3.6-8-8v-30c0-4.4 3.6-8 8-8h53.7c-7.8-25.1-14.6-50.7-14.6-77.1 0-75.8 58.6-120.3 151.5-120.3 26.5 0 51.4 5.5 70.3 12.7 3.1 1.2 5.2 4.2 5.2 7.5v39.5a8 8 0 01-10.6 7.6c-17.9-6.4-39-10.5-60.4-10.5-53.3 0-87.3 26.6-87.3 70.2 0 24.7 6.2 47.9 13.4 70.5h112c4.4 0 8 3.6 8 8v30c0 4.4-3.6 8-8 8h-98.6c3.1 13.2 5.3 26.9 5.3 41 0 40.7-16.5 73.9-43.9 91.1v4.7h180c4.4 0 8 3.6 8 8v39.8z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M650 674.3H470v-4.7c27.4-17.2 43.9-50.4 43.9-91.1 0-14.1-2.2-27.8-5.3-41h98.6c4.4 0 8-3.6 8-8v-30c0-4.4-3.6-8-8-8h-112c-7.2-22.6-13.4-45.8-13.4-70.5 0-43.6 34-70.2 87.3-70.2 21.4 0 42.5 4.1 60.4 10.5a8 8 0 0010.6-7.6v-39.5c0-3.3-2.1-6.3-5.2-7.5-18.9-7.2-43.8-12.7-70.3-12.7-92.9 0-151.5 44.5-151.5 120.3 0 26.4 6.8 52 14.6 77.1H374c-4.4 0-8 3.6-8 8v30c0 4.4 3.6 8 8 8h67.2c3.4 14.8 5.9 29.5 5.9 44.2 0 45.2-28.8 83.3-72.8 94.2-3.6.9-6.1 4.1-6.1 7.8v38.5c0 4.4 3.6 8 8 8H650c4.4 0 8-3.6 8-8v-39.8c0-4.4-3.6-8-8-8z", "fill": primaryColor } }] }; }, "name": "pound-circle", "theme": "twotone" };
  exports.default = PoundCircleTwoTone;
  });

  var PoundCircleTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(PoundCircleTwoTone_1);

  var PoundCircleTwoTone = function PoundCircleTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PoundCircleTwoToneSvg
    }));
  };
  var RefIcon$8S = /*#__PURE__*/React.forwardRef(PoundCircleTwoTone);
  {
    RefIcon$8S.displayName = 'PoundCircleTwoTone';
  }

  var PoundOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PoundOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448 448-200.6 448-448S759.4 64 512 64zm0 820c-205.4 0-372-166.6-372-372s166.6-372 372-372 372 166.6 372 372-166.6 372-372 372zm138-209.8H469.8v-4.7c27.4-17.2 43.9-50.4 43.9-91.1 0-14.1-2.2-27.9-5.3-41H607c4.4 0 8-3.6 8-8v-30c0-4.4-3.6-8-8-8H495c-7.2-22.6-13.4-45.7-13.4-70.5 0-43.5 34-70.2 87.3-70.2 21.5 0 42.5 4.1 60.4 10.5 5.2 1.9 10.6-2 10.6-7.6v-39.5c0-3.3-2.1-6.3-5.2-7.5-18.8-7.2-43.8-12.7-70.3-12.7-92.9 0-151.5 44.5-151.5 120.3 0 26.3 6.9 52 14.6 77.1H374c-4.4 0-8 3.6-8 8v30c0 4.4 3.6 8 8 8h67.1c3.4 14.7 5.9 29.4 5.9 44.2 0 45.2-28.8 83.3-72.8 94.2-3.6.9-6.1 4.1-6.1 7.8V722c0 4.4 3.6 8 8 8H650c4.4 0 8-3.6 8-8v-39.8c0-4.4-3.6-8-8-8z" } }] }, "name": "pound", "theme": "outlined" };
  exports.default = PoundOutlined;
  });

  var PoundOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(PoundOutlined_1);

  var PoundOutlined = function PoundOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PoundOutlinedSvg
    }));
  };
  var RefIcon$8T = /*#__PURE__*/React.forwardRef(PoundOutlined);
  {
    RefIcon$8T.displayName = 'PoundOutlined';
  }

  var PoweroffOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PoweroffOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M705.6 124.9a8 8 0 00-11.6 7.2v64.2c0 5.5 2.9 10.6 7.5 13.6a352.2 352.2 0 0162.2 49.8c32.7 32.8 58.4 70.9 76.3 113.3a355 355 0 0127.9 138.7c0 48.1-9.4 94.8-27.9 138.7a355.92 355.92 0 01-76.3 113.3 353.06 353.06 0 01-113.2 76.4c-43.8 18.6-90.5 28-138.5 28s-94.7-9.4-138.5-28a353.06 353.06 0 01-113.2-76.4A355.92 355.92 0 01184 650.4a355 355 0 01-27.9-138.7c0-48.1 9.4-94.8 27.9-138.7 17.9-42.4 43.6-80.5 76.3-113.3 19-19 39.8-35.6 62.2-49.8 4.7-2.9 7.5-8.1 7.5-13.6V132c0-6-6.3-9.8-11.6-7.2C178.5 195.2 82 339.3 80 506.3 77.2 745.1 272.5 943.5 511.2 944c239 .5 432.8-193.3 432.8-432.4 0-169.2-97-315.7-238.4-386.7zM480 560h64c4.4 0 8-3.6 8-8V88c0-4.4-3.6-8-8-8h-64c-4.4 0-8 3.6-8 8v464c0 4.4 3.6 8 8 8z" } }] }, "name": "poweroff", "theme": "outlined" };
  exports.default = PoweroffOutlined;
  });

  var PoweroffOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(PoweroffOutlined_1);

  var PoweroffOutlined = function PoweroffOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PoweroffOutlinedSvg
    }));
  };
  var RefIcon$8U = /*#__PURE__*/React.forwardRef(PoweroffOutlined);
  {
    RefIcon$8U.displayName = 'PoweroffOutlined';
  }

  var PrinterFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PrinterFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M732 120c0-4.4-3.6-8-8-8H300c-4.4 0-8 3.6-8 8v148h440V120zm120 212H172c-44.2 0-80 35.8-80 80v328c0 17.7 14.3 32 32 32h168v132c0 4.4 3.6 8 8 8h424c4.4 0 8-3.6 8-8V772h168c17.7 0 32-14.3 32-32V412c0-44.2-35.8-80-80-80zM664 844H360V568h304v276zm164-360c0 4.4-3.6 8-8 8h-40c-4.4 0-8-3.6-8-8v-40c0-4.4 3.6-8 8-8h40c4.4 0 8 3.6 8 8v40z" } }] }, "name": "printer", "theme": "filled" };
  exports.default = PrinterFilled;
  });

  var PrinterFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(PrinterFilled_1);

  var PrinterFilled = function PrinterFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PrinterFilledSvg
    }));
  };
  var RefIcon$8V = /*#__PURE__*/React.forwardRef(PrinterFilled);
  {
    RefIcon$8V.displayName = 'PrinterFilled';
  }

  var PrinterOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PrinterOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M820 436h-40c-4.4 0-8 3.6-8 8v40c0 4.4 3.6 8 8 8h40c4.4 0 8-3.6 8-8v-40c0-4.4-3.6-8-8-8zm32-104H732V120c0-4.4-3.6-8-8-8H300c-4.4 0-8 3.6-8 8v212H172c-44.2 0-80 35.8-80 80v328c0 17.7 14.3 32 32 32h168v132c0 4.4 3.6 8 8 8h424c4.4 0 8-3.6 8-8V772h168c17.7 0 32-14.3 32-32V412c0-44.2-35.8-80-80-80zM360 180h304v152H360V180zm304 664H360V568h304v276zm200-140H732V500H292v204H160V412c0-6.6 5.4-12 12-12h680c6.6 0 12 5.4 12 12v292z" } }] }, "name": "printer", "theme": "outlined" };
  exports.default = PrinterOutlined;
  });

  var PrinterOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(PrinterOutlined_1);

  var PrinterOutlined = function PrinterOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PrinterOutlinedSvg
    }));
  };
  var RefIcon$8W = /*#__PURE__*/React.forwardRef(PrinterOutlined);
  {
    RefIcon$8W.displayName = 'PrinterOutlined';
  }

  var PrinterTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PrinterTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M360 180h304v152H360zm492 220H172c-6.6 0-12 5.4-12 12v292h132V500h440v204h132V412c0-6.6-5.4-12-12-12zm-24 84c0 4.4-3.6 8-8 8h-40c-4.4 0-8-3.6-8-8v-40c0-4.4 3.6-8 8-8h40c4.4 0 8 3.6 8 8v40z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M852 332H732V120c0-4.4-3.6-8-8-8H300c-4.4 0-8 3.6-8 8v212H172c-44.2 0-80 35.8-80 80v328c0 17.7 14.3 32 32 32h168v132c0 4.4 3.6 8 8 8h424c4.4 0 8-3.6 8-8V772h168c17.7 0 32-14.3 32-32V412c0-44.2-35.8-80-80-80zM360 180h304v152H360V180zm304 664H360V568h304v276zm200-140H732V500H292v204H160V412c0-6.6 5.4-12 12-12h680c6.6 0 12 5.4 12 12v292z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M820 436h-40c-4.4 0-8 3.6-8 8v40c0 4.4 3.6 8 8 8h40c4.4 0 8-3.6 8-8v-40c0-4.4-3.6-8-8-8z", "fill": primaryColor } }] }; }, "name": "printer", "theme": "twotone" };
  exports.default = PrinterTwoTone;
  });

  var PrinterTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(PrinterTwoTone_1);

  var PrinterTwoTone = function PrinterTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PrinterTwoToneSvg
    }));
  };
  var RefIcon$8X = /*#__PURE__*/React.forwardRef(PrinterTwoTone);
  {
    RefIcon$8X.displayName = 'PrinterTwoTone';
  }

  var ProductFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ProductFilled = { "icon": { "tag": "svg", "attrs": { "fill-rule": "evenodd", "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M160 144h304a16 16 0 0116 16v304a16 16 0 01-16 16H160a16 16 0 01-16-16V160a16 16 0 0116-16m564.31-25.33l181.02 181.02a16 16 0 010 22.62L724.31 503.33a16 16 0 01-22.62 0L520.67 322.31a16 16 0 010-22.62l181.02-181.02a16 16 0 0122.62 0M160 544h304a16 16 0 0116 16v304a16 16 0 01-16 16H160a16 16 0 01-16-16V560a16 16 0 0116-16m400 0h304a16 16 0 0116 16v304a16 16 0 01-16 16H560a16 16 0 01-16-16V560a16 16 0 0116-16" } }] }, "name": "product", "theme": "filled" };
  exports.default = ProductFilled;
  });

  var ProductFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(ProductFilled_1);

  var ProductFilled = function ProductFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ProductFilledSvg
    }));
  };
  var RefIcon$8Y = /*#__PURE__*/React.forwardRef(ProductFilled);
  {
    RefIcon$8Y.displayName = 'ProductFilled';
  }

  var ProductOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ProductOutlined = { "icon": { "tag": "svg", "attrs": { "fill-rule": "evenodd", "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M464 144a16 16 0 0116 16v304a16 16 0 01-16 16H160a16 16 0 01-16-16V160a16 16 0 0116-16zm-52 68H212v200h200zm493.33 87.69a16 16 0 010 22.62L724.31 503.33a16 16 0 01-22.62 0L520.67 322.31a16 16 0 010-22.62l181.02-181.02a16 16 0 0122.62 0zm-84.85 11.3L713 203.53 605.52 311 713 418.48zM464 544a16 16 0 0116 16v304a16 16 0 01-16 16H160a16 16 0 01-16-16V560a16 16 0 0116-16zm-52 68H212v200h200zm452-68a16 16 0 0116 16v304a16 16 0 01-16 16H560a16 16 0 01-16-16V560a16 16 0 0116-16zm-52 68H612v200h200z" } }] }, "name": "product", "theme": "outlined" };
  exports.default = ProductOutlined;
  });

  var ProductOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(ProductOutlined_1);

  var ProductOutlined = function ProductOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ProductOutlinedSvg
    }));
  };
  var RefIcon$8Z = /*#__PURE__*/React.forwardRef(ProductOutlined);
  {
    RefIcon$8Z.displayName = 'ProductOutlined';
  }

  var ProfileFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ProfileFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM380 696c-22.1 0-40-17.9-40-40s17.9-40 40-40 40 17.9 40 40-17.9 40-40 40zm0-144c-22.1 0-40-17.9-40-40s17.9-40 40-40 40 17.9 40 40-17.9 40-40 40zm0-144c-22.1 0-40-17.9-40-40s17.9-40 40-40 40 17.9 40 40-17.9 40-40 40zm304 272c0 4.4-3.6 8-8 8H492c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h184c4.4 0 8 3.6 8 8v48zm0-144c0 4.4-3.6 8-8 8H492c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h184c4.4 0 8 3.6 8 8v48zm0-144c0 4.4-3.6 8-8 8H492c-4.4 0-8-3.6-8-8v-48c0-4.4 3.6-8 8-8h184c4.4 0 8 3.6 8 8v48z" } }] }, "name": "profile", "theme": "filled" };
  exports.default = ProfileFilled;
  });

  var ProfileFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(ProfileFilled_1);

  var ProfileFilled = function ProfileFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ProfileFilledSvg
    }));
  };
  var RefIcon$8_ = /*#__PURE__*/React.forwardRef(ProfileFilled);
  {
    RefIcon$8_.displayName = 'ProfileFilled';
  }

  var ProfileOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ProfileOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656zM492 400h184c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H492c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8zm0 144h184c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H492c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8zm0 144h184c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H492c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8zM340 368a40 40 0 1080 0 40 40 0 10-80 0zm0 144a40 40 0 1080 0 40 40 0 10-80 0zm0 144a40 40 0 1080 0 40 40 0 10-80 0z" } }] }, "name": "profile", "theme": "outlined" };
  exports.default = ProfileOutlined;
  });

  var ProfileOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(ProfileOutlined_1);

  var ProfileOutlined = function ProfileOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ProfileOutlinedSvg
    }));
  };
  var RefIcon$8$ = /*#__PURE__*/React.forwardRef(ProfileOutlined);
  {
    RefIcon$8$.displayName = 'ProfileOutlined';
  }

  var ProfileTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ProfileTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M184 840h656V184H184v656zm300-496c0-4.4 3.6-8 8-8h184c4.4 0 8 3.6 8 8v48c0 4.4-3.6 8-8 8H492c-4.4 0-8-3.6-8-8v-48zm0 144c0-4.4 3.6-8 8-8h184c4.4 0 8 3.6 8 8v48c0 4.4-3.6 8-8 8H492c-4.4 0-8-3.6-8-8v-48zm0 144c0-4.4 3.6-8 8-8h184c4.4 0 8 3.6 8 8v48c0 4.4-3.6 8-8 8H492c-4.4 0-8-3.6-8-8v-48zM380 328c22.1 0 40 17.9 40 40s-17.9 40-40 40-40-17.9-40-40 17.9-40 40-40zm0 144c22.1 0 40 17.9 40 40s-17.9 40-40 40-40-17.9-40-40 17.9-40 40-40zm0 144c22.1 0 40 17.9 40 40s-17.9 40-40 40-40-17.9-40-40 17.9-40 40-40z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M340 656a40 40 0 1080 0 40 40 0 10-80 0zm0-144a40 40 0 1080 0 40 40 0 10-80 0zm0-144a40 40 0 1080 0 40 40 0 10-80 0zm152 320h184c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H492c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8zm0-144h184c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H492c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8zm0-144h184c4.4 0 8-3.6 8-8v-48c0-4.4-3.6-8-8-8H492c-4.4 0-8 3.6-8 8v48c0 4.4 3.6 8 8 8z", "fill": primaryColor } }] }; }, "name": "profile", "theme": "twotone" };
  exports.default = ProfileTwoTone;
  });

  var ProfileTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(ProfileTwoTone_1);

  var ProfileTwoTone = function ProfileTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ProfileTwoToneSvg
    }));
  };
  var RefIcon$90 = /*#__PURE__*/React.forwardRef(ProfileTwoTone);
  {
    RefIcon$90.displayName = 'ProfileTwoTone';
  }

  var ProjectFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ProjectFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zM368 744c0 4.4-3.6 8-8 8h-80c-4.4 0-8-3.6-8-8V280c0-4.4 3.6-8 8-8h80c4.4 0 8 3.6 8 8v464zm192-280c0 4.4-3.6 8-8 8h-80c-4.4 0-8-3.6-8-8V280c0-4.4 3.6-8 8-8h80c4.4 0 8 3.6 8 8v184zm192 72c0 4.4-3.6 8-8 8h-80c-4.4 0-8-3.6-8-8V280c0-4.4 3.6-8 8-8h80c4.4 0 8 3.6 8 8v256z" } }] }, "name": "project", "theme": "filled" };
  exports.default = ProjectFilled;
  });

  var ProjectFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(ProjectFilled_1);

  var ProjectFilled = function ProjectFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ProjectFilledSvg
    }));
  };
  var RefIcon$91 = /*#__PURE__*/React.forwardRef(ProjectFilled);
  {
    RefIcon$91.displayName = 'ProjectFilled';
  }

  var ProjectOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ProjectOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M280 752h80c4.4 0 8-3.6 8-8V280c0-4.4-3.6-8-8-8h-80c-4.4 0-8 3.6-8 8v464c0 4.4 3.6 8 8 8zm192-280h80c4.4 0 8-3.6 8-8V280c0-4.4-3.6-8-8-8h-80c-4.4 0-8 3.6-8 8v184c0 4.4 3.6 8 8 8zm192 72h80c4.4 0 8-3.6 8-8V280c0-4.4-3.6-8-8-8h-80c-4.4 0-8 3.6-8 8v256c0 4.4 3.6 8 8 8zm216-432H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z" } }] }, "name": "project", "theme": "outlined" };
  exports.default = ProjectOutlined;
  });

  var ProjectOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(ProjectOutlined_1);

  var ProjectOutlined = function ProjectOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ProjectOutlinedSvg
    }));
  };
  var RefIcon$92 = /*#__PURE__*/React.forwardRef(ProjectOutlined);
  {
    RefIcon$92.displayName = 'ProjectOutlined';
  }

  var ProjectTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var ProjectTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M880 112H144c-17.7 0-32 14.3-32 32v736c0 17.7 14.3 32 32 32h736c17.7 0 32-14.3 32-32V144c0-17.7-14.3-32-32-32zm-40 728H184V184h656v656z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M184 840h656V184H184v656zm472-560c0-4.4 3.6-8 8-8h80c4.4 0 8 3.6 8 8v256c0 4.4-3.6 8-8 8h-80c-4.4 0-8-3.6-8-8V280zm-192 0c0-4.4 3.6-8 8-8h80c4.4 0 8 3.6 8 8v184c0 4.4-3.6 8-8 8h-80c-4.4 0-8-3.6-8-8V280zm-192 0c0-4.4 3.6-8 8-8h80c4.4 0 8 3.6 8 8v464c0 4.4-3.6 8-8 8h-80c-4.4 0-8-3.6-8-8V280z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M280 752h80c4.4 0 8-3.6 8-8V280c0-4.4-3.6-8-8-8h-80c-4.4 0-8 3.6-8 8v464c0 4.4 3.6 8 8 8zm192-280h80c4.4 0 8-3.6 8-8V280c0-4.4-3.6-8-8-8h-80c-4.4 0-8 3.6-8 8v184c0 4.4 3.6 8 8 8zm192 72h80c4.4 0 8-3.6 8-8V280c0-4.4-3.6-8-8-8h-80c-4.4 0-8 3.6-8 8v256c0 4.4 3.6 8 8 8z", "fill": primaryColor } }] }; }, "name": "project", "theme": "twotone" };
  exports.default = ProjectTwoTone;
  });

  var ProjectTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(ProjectTwoTone_1);

  var ProjectTwoTone = function ProjectTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: ProjectTwoToneSvg
    }));
  };
  var RefIcon$93 = /*#__PURE__*/React.forwardRef(ProjectTwoTone);
  {
    RefIcon$93.displayName = 'ProjectTwoTone';
  }

  var PropertySafetyFilled_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PropertySafetyFilled = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M866.9 169.9L527.1 54.1C523 52.7 517.5 52 512 52s-11 .7-15.1 2.1L157.1 169.9c-8.3 2.8-15.1 12.4-15.1 21.2v482.4c0 8.8 5.7 20.4 12.6 25.9L499.3 968c3.5 2.7 8 4.1 12.6 4.1s9.2-1.4 12.6-4.1l344.7-268.6c6.9-5.4 12.6-17 12.6-25.9V191.1c.2-8.8-6.6-18.3-14.9-21.2zM648.3 332.8l-87.7 161.1h45.7c5.5 0 10 4.5 10 10v21.3c0 5.5-4.5 10-10 10h-63.4v29.7h63.4c5.5 0 10 4.5 10 10v21.3c0 5.5-4.5 10-10 10h-63.4V658c0 5.5-4.5 10-10 10h-41.3c-5.5 0-10-4.5-10-10v-51.8h-63.1c-5.5 0-10-4.5-10-10v-21.3c0-5.5 4.5-10 10-10h63.1v-29.7h-63.1c-5.5 0-10-4.5-10-10v-21.3c0-5.5 4.5-10 10-10h45.2l-88-161.1c-2.6-4.8-.9-10.9 4-13.6 1.5-.8 3.1-1.2 4.8-1.2h46c3.8 0 7.2 2.1 8.9 5.5l72.9 144.3 73.2-144.3a10 10 0 018.9-5.5h45c5.5 0 10 4.5 10 10 .1 1.7-.3 3.3-1.1 4.8z" } }] }, "name": "property-safety", "theme": "filled" };
  exports.default = PropertySafetyFilled;
  });

  var PropertySafetyFilledSvg = /*@__PURE__*/getDefaultExportFromCjs(PropertySafetyFilled_1);

  var PropertySafetyFilled = function PropertySafetyFilled(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PropertySafetyFilledSvg
    }));
  };
  var RefIcon$94 = /*#__PURE__*/React.forwardRef(PropertySafetyFilled);
  {
    RefIcon$94.displayName = 'PropertySafetyFilled';
  }

  var PropertySafetyOutlined_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PropertySafetyOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M866.9 169.9L527.1 54.1C523 52.7 517.5 52 512 52s-11 .7-15.1 2.1L157.1 169.9c-8.3 2.8-15.1 12.4-15.1 21.2v482.4c0 8.8 5.7 20.4 12.6 25.9L499.3 968c3.5 2.7 8 4.1 12.6 4.1s9.2-1.4 12.6-4.1l344.7-268.6c6.9-5.4 12.6-17 12.6-25.9V191.1c.2-8.8-6.6-18.3-14.9-21.2zM810 654.3L512 886.5 214 654.3V226.7l298-101.6 298 101.6v427.6zM430.5 318h-46c-1.7 0-3.3.4-4.8 1.2a10.1 10.1 0 00-4 13.6l88 161.1h-45.2c-5.5 0-10 4.5-10 10v21.3c0 5.5 4.5 10 10 10h63.1v29.7h-63.1c-5.5 0-10 4.5-10 10v21.3c0 5.5 4.5 10 10 10h63.1V658c0 5.5 4.5 10 10 10h41.3c5.5 0 10-4.5 10-10v-51.8h63.4c5.5 0 10-4.5 10-10v-21.3c0-5.5-4.5-10-10-10h-63.4v-29.7h63.4c5.5 0 10-4.5 10-10v-21.3c0-5.5-4.5-10-10-10h-45.7l87.7-161.1a10.05 10.05 0 00-8.8-14.8h-45c-3.8 0-7.2 2.1-8.9 5.5l-73.2 144.3-72.9-144.3c-1.7-3.4-5.2-5.5-9-5.5z" } }] }, "name": "property-safety", "theme": "outlined" };
  exports.default = PropertySafetyOutlined;
  });

  var PropertySafetyOutlinedSvg = /*@__PURE__*/getDefaultExportFromCjs(PropertySafetyOutlined_1);

  var PropertySafetyOutlined = function PropertySafetyOutlined(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PropertySafetyOutlinedSvg
    }));
  };
  var RefIcon$95 = /*#__PURE__*/React.forwardRef(PropertySafetyOutlined);
  {
    RefIcon$95.displayName = 'PropertySafetyOutlined';
  }

  var PropertySafetyTwoTone_1 = createCommonjsModule(function (module, exports) {
  // This icon file is generated automatically.
  Object.defineProperty(exports, "__esModule", { value: true });
  var PropertySafetyTwoTone = { "icon": function render(primaryColor, secondaryColor) { return { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M866.9 169.9L527.1 54.1C523 52.7 517.5 52 512 52s-11 .7-15.1 2.1L157.1 169.9c-8.3 2.8-15.1 12.4-15.1 21.2v482.4c0 8.8 5.7 20.4 12.6 25.9L499.3 968c3.5 2.7 8 4.1 12.6 4.1s9.2-1.4 12.6-4.1l344.7-268.6c6.9-5.4 12.6-17 12.6-25.9V191.1c.2-8.8-6.6-18.3-14.9-21.2zM810 654.3L512 886.5 214 654.3V226.7l298-101.6 298 101.6v427.6z", "fill": primaryColor } }, { "tag": "path", "attrs": { "d": "M214 226.7v427.6l298 232.2 298-232.2V226.7L512 125.1 214 226.7zM593.9 318h45c5.5 0 10 4.5 10 10 .1 1.7-.3 3.3-1.1 4.8l-87.7 161.1h45.7c5.5 0 10 4.5 10 10v21.3c0 5.5-4.5 10-10 10h-63.4v29.7h63.4c5.5 0 10 4.5 10 10v21.3c0 5.5-4.5 10-10 10h-63.4V658c0 5.5-4.5 10-10 10h-41.3c-5.5 0-10-4.5-10-10v-51.8H418c-5.5 0-10-4.5-10-10v-21.3c0-5.5 4.5-10 10-10h63.1v-29.7H418c-5.5 0-10-4.5-10-10v-21.3c0-5.5 4.5-10 10-10h45.2l-88-161.1c-2.6-4.8-.9-10.9 4-13.6 1.5-.8 3.1-1.2 4.8-1.2h46c3.8 0 7.2 2.1 8.9 5.5l72.9 144.3L585 323.5a10 10 0 018.9-5.5z", "fill": secondaryColor } }, { "tag": "path", "attrs": { "d": "M438.9 323.5a9.88 9.88 0 00-8.9-5.5h-46c-1.7 0-3.3.4-4.8 1.2-4.9 2.7-6.6 8.8-4 13.6l88 161.1H418c-5.5 0-10 4.5-10 10v21.3c0 5.5 4.5 10 10 10h63.1v29.7H418c-5.5 0-10 4.5-10 10v21.3c0 5.5 4.5 10 10 10h63.1V658c0 5.5 4.5 10 10 10h41.3c5.5 0 10-4.5 10-10v-51.8h63.4c5.5 0 10-4.5 10-10v-21.3c0-5.5-4.5-10-10-10h-63.4v-29.7h63.4c5.5 0 10-4.5 10-10v-21.3c0-5.5-4.5-10-10-10h-45.7l87.7-161.1c.8-1.5 1.2-3.1 1.1-4.8 0-5.5-4.5-10-10-10h-45a10 10 0 00-8.9 5.5l-73.2 144.3-72.9-144.3z", "fill": primaryColor } }] }; }, "name": "property-safety", "theme": "twotone" };
  exports.default = PropertySafetyTwoTone;
  });

  var PropertySafetyTwoToneSvg = /*@__PURE__*/getDefaultExportFromCjs(PropertySafetyTwoTone_1);

  var PropertySafetyTwoTone = function PropertySafetyTwoTone(props, ref) {
    return /*#__PURE__*/React.createElement(Icon, _objectSpread(_objectSpread({}, props), {}, {
      ref: ref,
      icon: PropertySafetyTwoToneSvg
    }));
  };
  var RefIcon$96 = /*#__PURE__*/React.forwardRef(PropertySafetyTwoTone);
  {
    RefIcon$96