export type IntlType = {
    locale: string;
    getMessage: (id: string, defaultMessage: string) => string;
};
/**
 * 创建一个国际化的操作函数
 *
 * @param locale
 * @param localeMap
 */
export declare const createIntl: (locale: string, localeMap: Record<string, any>) => IntlType;
declare const mnMNIntl: IntlType;
declare const arEGIntl: IntlType;
declare const zhCNIntl: IntlType;
declare const enUSIntl: IntlType;
declare const enGBIntl: IntlType;
declare const viVNIntl: IntlType;
declare const itITIntl: IntlType;
declare const jaJPIntl: IntlType;
declare const esESIntl: IntlType;
declare const caESIntl: IntlType;
declare const ruRUIntl: IntlType;
declare const srRSIntl: IntlType;
declare const msMYIntl: IntlType;
declare const zhTWIntl: IntlType;
declare const frFRIntl: IntlType;
declare const ptBRIntl: IntlType;
declare const koKRIntl: IntlType;
declare const idIDIntl: IntlType;
declare const deDEIntl: IntlType;
declare const faIRIntl: IntlType;
declare const trTRIntl: IntlType;
declare const plPLIntl: IntlType;
declare const hrHRIntl: IntlType;
declare const thTHIntl: IntlType;
declare const csCZIntl: IntlType;
declare const skSKIntl: IntlType;
declare const heILIntl: IntlType;
declare const ukUAIntl: IntlType;
declare const uzUZIntl: IntlType;
declare const nlNLIntl: IntlType;
declare const roROIntl: IntlType;
declare const svSEIntl: IntlType;
declare const intlMap: {
    'mn-MN': IntlType;
    'ar-EG': IntlType;
    'zh-CN': IntlType;
    'en-US': IntlType;
    'en-GB': IntlType;
    'vi-VN': IntlType;
    'it-IT': IntlType;
    'ja-JP': IntlType;
    'es-ES': IntlType;
    'ca-ES': IntlType;
    'ru-RU': IntlType;
    'sr-RS': IntlType;
    'ms-MY': IntlType;
    'zh-TW': IntlType;
    'fr-FR': IntlType;
    'pt-BR': IntlType;
    'ko-KR': IntlType;
    'id-ID': IntlType;
    'de-DE': IntlType;
    'fa-IR': IntlType;
    'tr-TR': IntlType;
    'pl-PL': IntlType;
    'hr-HR': IntlType;
    'th-TH': IntlType;
    'cs-CZ': IntlType;
    'sk-SK': IntlType;
    'he-IL': IntlType;
    'uk-UA': IntlType;
    'uz-UZ': IntlType;
    'nl-NL': IntlType;
    'ro-RO': IntlType;
    'sv-SE': IntlType;
};
declare const intlMapKeys: string[];
/**
 * 根据 antd 的 key 来找到的 locale 插件的 key
 *
 * @param localeKey
 */
export declare const findIntlKeyByAntdLocaleKey: <T extends string>(localeKey?: T) => T;
export { arEGIntl, caESIntl, csCZIntl, deDEIntl, enGBIntl, enUSIntl, esESIntl, faIRIntl, frFRIntl, heILIntl, hrHRIntl, idIDIntl, intlMap, intlMapKeys, itITIntl, jaJPIntl, koKRIntl, mnMNIntl, msMYIntl, nlNLIntl, plPLIntl, ptBRIntl, roROIntl, ruRUIntl, skSKIntl, srRSIntl, svSEIntl, thTHIntl, trTRIntl, ukUAIntl, uzUZIntl, viVNIntl, zhCNIntl, zhTWIntl, };
