'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol ? "symbol" : typeof obj; };

exports["default"] = Col;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var stringOrNumber = _react.PropTypes.oneOfType([_react.PropTypes.string, _react.PropTypes.number]);
var objectOrNumber = _react.PropTypes.oneOfType([_react.PropTypes.object, _react.PropTypes.number]);

function Col(props) {
  var _extends3;

  var span = props.span;
  var order = props.order;
  var offset = props.offset;
  var push = props.push;
  var pull = props.pull;
  var className = props.className;
  var children = props.children;

  var others = _objectWithoutProperties(props, ['span', 'order', 'offset', 'push', 'pull', 'className', 'children']);

  var sizeClassObj = {};
  ['xs', 'sm', 'md', 'lg'].forEach(function (size) {
    var _extends2;

    var sizeProps = {};
    if (typeof props[size] === 'number') {
      sizeProps.span = props[size];
    } else if (_typeof(props[size]) === 'object') {
      sizeProps = props[size] || {};
    }
    sizeClassObj = _extends({}, sizeClassObj, (_extends2 = {}, _defineProperty(_extends2, 'col-' + size + '-' + sizeProps.span, sizeProps.span !== undefined), _defineProperty(_extends2, 'col-' + size + '-order-' + sizeProps.order, sizeProps.order), _defineProperty(_extends2, 'col-' + size + '-offset-' + sizeProps.offset, sizeProps.offset), _defineProperty(_extends2, 'col-' + size + '-push-' + sizeProps.push, sizeProps.push), _defineProperty(_extends2, 'col-' + size + '-pull-' + sizeProps.pull, sizeProps.pull), _extends2));
  });
  var classes = (0, _classnames2["default"])(_extends((_extends3 = {}, _defineProperty(_extends3, 'col-' + span, span !== undefined), _defineProperty(_extends3, 'col-order-' + order, order), _defineProperty(_extends3, 'col-offset-' + offset, offset), _defineProperty(_extends3, 'col-push-' + push, push), _defineProperty(_extends3, 'col-pull-' + pull, pull), _defineProperty(_extends3, className, !!className), _extends3), sizeClassObj));

  return _react2["default"].createElement(
    'div',
    _extends({}, others, { className: classes }),
    children
  );
}

Col.propTypes = {
  span: stringOrNumber,
  order: stringOrNumber,
  offset: stringOrNumber,
  push: stringOrNumber,
  pull: stringOrNumber,
  className: _react.PropTypes.string,
  children: _react.PropTypes.node,
  xs: objectOrNumber,
  sm: objectOrNumber,
  md: objectOrNumber,
  lg: objectOrNumber
};
module.exports = exports['default'];