'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _class, _temp2;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defaults(obj, defaults) { var keys = Object.getOwnPropertyNames(defaults); for (var i = 0; i < keys.length; i++) { var key = keys[i]; var value = Object.getOwnPropertyDescriptor(defaults, key); if (value && value.configurable && obj[key] === undefined) { Object.defineProperty(obj, key, value); } } return obj; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : _defaults(subClass, superClass); }

function fixControlledValue(value) {
  if (typeof value === 'undefined' || value === null) {
    return '';
  }
  return value;
}

var Input = (_temp2 = _class = function (_React$Component) {
  _inherits(Input, _React$Component);

  function Input() {
    var _temp, _this, _ret;

    _classCallCheck(this, Input);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, _React$Component.call.apply(_React$Component, [this].concat(args))), _this), _this.handleKeyDown = function (e) {
      if (e.keyCode === 13) {
        _this.props.onPressEnter(e);
      }
      _this.props.onKeyDown(e);
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  Input.prototype.renderLabledInput = function renderLabledInput(children) {
    var _classNames;

    var props = this.props;
    var wrapperClassName = props.prefixCls + '-group';
    var addonClassName = wrapperClassName + '-addon';
    var addonBefore = props.addonBefore ? _react2["default"].createElement(
      'span',
      { className: addonClassName },
      props.addonBefore
    ) : null;

    var addonAfter = props.addonAfter ? _react2["default"].createElement(
      'span',
      { className: addonClassName },
      props.addonAfter
    ) : null;

    var className = (0, _classnames2["default"])((_classNames = {}, _defineProperty(_classNames, props.prefixCls + '-wrapper', true), _defineProperty(_classNames, wrapperClassName, addonBefore || addonAfter), _classNames));

    return _react2["default"].createElement(
      'span',
      { className: className },
      addonBefore,
      children,
      addonAfter
    );
  };

  Input.prototype.renderInput = function renderInput() {
    var _classNames2;

    var props = _extends({}, this.props);
    var prefixCls = props.prefixCls;
    if (!props.type) {
      return props.children;
    }

    var inputClassName = (0, _classnames2["default"])((_classNames2 = {}, _defineProperty(_classNames2, prefixCls, true), _defineProperty(_classNames2, prefixCls + '-sm', props.size === 'small'), _defineProperty(_classNames2, prefixCls + '-lg', props.size === 'large'), _defineProperty(_classNames2, props.className, !!props.className), _classNames2));

    var placeholder = props.placeholder;
    if ('value' in props) {
      props.value = fixControlledValue(props.value);
      // Input elements must be either controlled or uncontrolled,
      // specify either the value prop, or the defaultValue prop, but not both.
      delete props.defaultValue;
    }

    switch (props.type) {
      case 'textarea':
        return _react2["default"].createElement('textarea', _extends({}, props, { placeholder: placeholder,
          className: inputClassName, onKeyDown: this.handleKeyDown, ref: 'input' }));
      default:
        return _react2["default"].createElement('input', _extends({}, props, { placeholder: placeholder,
          className: inputClassName, onKeyDown: this.handleKeyDown, ref: 'input' }));
    }
  };

  Input.prototype.render = function render() {
    return this.renderLabledInput(this.renderInput());
  };

  return Input;
}(_react2["default"].Component), _class.defaultProps = {
  defaultValue: '',
  disabled: false,
  prefixCls: 'ant-input',
  type: 'text',
  onPressEnter: function onPressEnter() {},
  onKeyDown: function onKeyDown() {}
}, _class.propTypes = {
  type: _react2["default"].PropTypes.string,
  id: _react2["default"].PropTypes.oneOfType([_react2["default"].PropTypes.string, _react2["default"].PropTypes.number]),
  size: _react2["default"].PropTypes.oneOf(['small', 'default', 'large']),
  disabled: _react2["default"].PropTypes.bool,
  value: _react2["default"].PropTypes.any,
  defaultValue: _react2["default"].PropTypes.any,
  className: _react2["default"].PropTypes.string,
  addonBefore: _react2["default"].PropTypes.node,
  addonAfter: _react2["default"].PropTypes.node,
  prefixCls: _react2["default"].PropTypes.string,
  onPressEnter: _react2["default"].PropTypes.func,
  onKeyDown: _react2["default"].PropTypes.func
}, _temp2);
exports["default"] = Input;
module.exports = exports['default'];