'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports.flatArray = flatArray;
function flatArray() {
  var data = arguments.length <= 0 || arguments[0] === undefined ? [] : arguments[0];
  var childrenName = arguments.length <= 1 || arguments[1] === undefined ? 'children' : arguments[1];

  var result = [];
  var loop = function loop(array) {
    array.forEach(function (item) {
      var newItem = _extends({}, item);
      delete newItem[childrenName];
      result.push(newItem);
      if (item[childrenName] && item[childrenName].length > 0) {
        loop(item[childrenName]);
      }
    });
  };
  loop(data);
  return result;
}