'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports["default"] = undefined;

var _defineProperty2 = require('babel-runtime/helpers/defineProperty');

var _defineProperty3 = _interopRequireDefault(_defineProperty2);

var _extends2 = require('babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _rcCheckbox = require('rc-checkbox');

var _rcCheckbox2 = _interopRequireDefault(_rcCheckbox);

var _shallowequal = require('shallowequal');

var _shallowequal2 = _interopRequireDefault(_shallowequal);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var __rest = undefined && undefined.__rest || function (s, e) {
    var t = {};
    for (var p in s) {
        if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
    }if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
        if (e.indexOf(p[i]) < 0) t[p[i]] = s[p[i]];
    }return t;
};

var Checkbox = function (_React$Component) {
    (0, _inherits3["default"])(Checkbox, _React$Component);

    function Checkbox() {
        (0, _classCallCheck3["default"])(this, Checkbox);
        return (0, _possibleConstructorReturn3["default"])(this, _React$Component.apply(this, arguments));
    }

    Checkbox.prototype.shouldComponentUpdate = function shouldComponentUpdate(nextProps, nextState, nextContext) {
        return !(0, _shallowequal2["default"])(this.props, nextProps) || !(0, _shallowequal2["default"])(this.state, nextState) || !(0, _shallowequal2["default"])(this.context.checkboxGroup, nextContext.checkboxGroup);
    };

    Checkbox.prototype.render = function render() {
        var props = this.props,
            context = this.context;

        var prefixCls = props.prefixCls,
            className = props.className,
            children = props.children,
            indeterminate = props.indeterminate,
            style = props.style,
            onMouseEnter = props.onMouseEnter,
            onMouseLeave = props.onMouseLeave,
            restProps = __rest(props, ["prefixCls", "className", "children", "indeterminate", "style", "onMouseEnter", "onMouseLeave"]);

        var checkboxGroup = context.checkboxGroup;

        var checkboxProps = (0, _extends3["default"])({}, restProps);
        if (checkboxGroup) {
            checkboxProps.onChange = function () {
                return checkboxGroup.toggleOption({ label: children, value: props.value });
            };
            checkboxProps.checked = checkboxGroup.value.indexOf(props.value) !== -1;
            checkboxProps.disabled = 'disabled' in props ? props.disabled : checkboxGroup.disabled;
        }
        var classString = (0, _classnames2["default"])(className, (0, _defineProperty3["default"])({}, prefixCls + '-wrapper', true));
        var checkboxClass = (0, _classnames2["default"])((0, _defineProperty3["default"])({}, prefixCls + '-indeterminate', indeterminate));
        return _react2["default"].createElement(
            'label',
            { className: classString, style: style, onMouseEnter: onMouseEnter, onMouseLeave: onMouseLeave },
            _react2["default"].createElement(_rcCheckbox2["default"], (0, _extends3["default"])({}, checkboxProps, { prefixCls: prefixCls, className: checkboxClass })),
            children !== undefined ? _react2["default"].createElement(
                'span',
                null,
                children
            ) : null
        );
    };

    return Checkbox;
}(_react2["default"].Component);

exports["default"] = Checkbox;

Checkbox.defaultProps = {
    prefixCls: 'ant-checkbox',
    indeterminate: false
};
Checkbox.contextTypes = {
    checkboxGroup: _propTypes2["default"].any
};
module.exports = exports['default'];