'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports["default"] = undefined;

var _extends2 = require('babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

var _defineProperty2 = require('babel-runtime/helpers/defineProperty');

var _defineProperty3 = _interopRequireDefault(_defineProperty2);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _rcSelect = require('rc-select');

var _rcSelect2 = _interopRequireDefault(_rcSelect);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _warning = require('../_util/warning');

var _warning2 = _interopRequireDefault(_warning);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var __rest = undefined && undefined.__rest || function (s, e) {
    var t = {};
    for (var p in s) {
        if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
    }if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
        if (e.indexOf(p[i]) < 0) t[p[i]] = s[p[i]];
    }return t;
};

// => It is needless to export the declaration of below two inner components.
// export { Option, OptGroup };
var Select = function (_React$Component) {
    (0, _inherits3["default"])(Select, _React$Component);

    function Select() {
        (0, _classCallCheck3["default"])(this, Select);
        return (0, _possibleConstructorReturn3["default"])(this, _React$Component.apply(this, arguments));
    }

    Select.prototype.getLocale = function getLocale() {
        var antLocale = this.context.antLocale;

        if (antLocale && antLocale.Select) {
            return antLocale.Select;
        }
        return {
            notFoundContent: '无匹配结果'
        };
    };

    Select.prototype.render = function render() {
        var _classNames;

        var _a = this.props,
            prefixCls = _a.prefixCls,
            _a$className = _a.className,
            className = _a$className === undefined ? '' : _a$className,
            size = _a.size,
            mode = _a.mode,
            multiple = _a.multiple,
            tags = _a.tags,
            combobox = _a.combobox,
            restProps = __rest(_a, ["prefixCls", "className", "size", "mode", "multiple", "tags", "combobox"]);
        (0, _warning2["default"])(!multiple && !tags && !combobox, '`Select[multiple|tags|combobox]` is deprecated, please use `Select[mode]` instead.');
        var cls = (0, _classnames2["default"])((_classNames = {}, (0, _defineProperty3["default"])(_classNames, prefixCls + '-lg', size === 'large'), (0, _defineProperty3["default"])(_classNames, prefixCls + '-sm', size === 'small'), _classNames), className);
        var locale = this.getLocale();
        var _props = this.props,
            _props$notFoundConten = _props.notFoundContent,
            notFoundContent = _props$notFoundConten === undefined ? locale.notFoundContent : _props$notFoundConten,
            optionLabelProp = _props.optionLabelProp;

        var isCombobox = mode === 'combobox' || combobox;
        if (isCombobox) {
            notFoundContent = null;
            // children 带 dom 结构时，无法填入输入框
            optionLabelProp = optionLabelProp || 'value';
        }
        var modeConfig = {
            multiple: mode === 'multiple' || multiple,
            tags: mode === 'tags' || tags,
            combobox: isCombobox
        };
        return _react2["default"].createElement(_rcSelect2["default"], (0, _extends3["default"])({}, restProps, modeConfig, { prefixCls: prefixCls, className: cls, optionLabelProp: optionLabelProp || 'children', notFoundContent: notFoundContent }));
    };

    return Select;
}(_react2["default"].Component);

exports["default"] = Select;

Select.Option = _rcSelect.Option;
Select.OptGroup = _rcSelect.OptGroup;
Select.defaultProps = {
    prefixCls: 'ant-select',
    showSearch: false,
    transitionName: 'slide-up',
    choiceTransitionName: 'zoom'
};
Select.propTypes = {
    prefixCls: _propTypes2["default"].string,
    className: _propTypes2["default"].string,
    size: _propTypes2["default"].oneOf(['default', 'large', 'small']),
    combobox: _propTypes2["default"].bool,
    notFoundContent: _propTypes2["default"].any,
    showSearch: _propTypes2["default"].bool,
    optionLabelProp: _propTypes2["default"].string,
    transitionName: _propTypes2["default"].string,
    choiceTransitionName: _propTypes2["default"].string
};
Select.contextTypes = {
    antLocale: _propTypes2["default"].object
};
module.exports = exports['default'];