'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends2 = require('babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

var _defineProperty2 = require('babel-runtime/helpers/defineProperty');

var _defineProperty3 = _interopRequireDefault(_defineProperty2);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _moment = require('moment');

var _moment2 = _interopRequireDefault(_moment);

var _TimePicker = require('rc-time-picker/lib/TimePicker');

var _TimePicker2 = _interopRequireDefault(_TimePicker);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _objectAssign = require('object-assign');

var _objectAssign2 = _interopRequireDefault(_objectAssign);

var _injectLocale = require('../locale-provider/injectLocale');

var _injectLocale2 = _interopRequireDefault(_injectLocale);

var _zh_CN = require('./locale/zh_CN');

var _zh_CN2 = _interopRequireDefault(_zh_CN);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var TimePicker = function (_React$Component) {
    (0, _inherits3["default"])(TimePicker, _React$Component);

    function TimePicker(props) {
        (0, _classCallCheck3["default"])(this, TimePicker);

        var _this = (0, _possibleConstructorReturn3["default"])(this, _React$Component.call(this, props));

        _this.handleChange = function (value) {
            if (!('value' in _this.props)) {
                _this.setState({ value: value });
            }
            var _this$props = _this.props,
                onChange = _this$props.onChange,
                _this$props$format = _this$props.format,
                format = _this$props$format === undefined ? 'HH:mm:ss' : _this$props$format;

            if (onChange) {
                onChange(value, value && value.format(format) || '');
            }
        };
        _this.handleOpenClose = function (_ref) {
            var open = _ref.open;
            var onOpenChange = _this.props.onOpenChange;

            if (onOpenChange) {
                onOpenChange(open);
            }
        };
        _this.saveTimePicker = function (timePickerRef) {
            _this.timePickerRef = timePickerRef;
        };
        var value = props.value || props.defaultValue;
        if (value && !_moment2["default"].isMoment(value)) {
            throw new Error('The value/defaultValue of TimePicker must be a moment object after `antd@2.0`, ' + 'see: http://u.ant.design/time-picker-value');
        }
        _this.state = {
            value: value
        };
        return _this;
    }

    TimePicker.prototype.componentWillReceiveProps = function componentWillReceiveProps(nextProps) {
        if ('value' in nextProps) {
            this.setState({ value: nextProps.value });
        }
    };

    TimePicker.prototype.focus = function focus() {
        this.timePickerRef.focus();
    };

    TimePicker.prototype.getDefaultFormat = function getDefaultFormat() {
        var _props = this.props,
            format = _props.format,
            use12Hours = _props.use12Hours;

        if (format) {
            return format;
        } else if (use12Hours) {
            return 'h:mm:ss a';
        }
        return 'HH:mm:ss';
    };

    TimePicker.prototype.render = function render() {
        var props = (0, _objectAssign2["default"])({}, this.props);
        delete props.defaultValue;
        var format = this.getDefaultFormat();
        var className = (0, _classnames2["default"])(props.className, (0, _defineProperty3["default"])({}, props.prefixCls + '-' + props.size, !!props.size));
        var addon = function addon(panel) {
            return props.addon ? _react2["default"].createElement(
                'div',
                { className: props.prefixCls + '-panel-addon' },
                props.addon(panel)
            ) : null;
        };
        return _react2["default"].createElement(_TimePicker2["default"], (0, _extends3["default"])({ showHour: format.indexOf('HH') > -1 || format.indexOf('h') > -1, showMinute: format.indexOf('mm') > -1, showSecond: format.indexOf('ss') > -1 }, props, { ref: this.saveTimePicker, format: format, className: className, value: this.state.value, placeholder: props.placeholder === undefined ? this.getLocale().placeholder : props.placeholder, onChange: this.handleChange, onOpen: this.handleOpenClose, onClose: this.handleOpenClose, addon: addon }));
    };

    return TimePicker;
}(_react2["default"].Component);

TimePicker.defaultProps = {
    prefixCls: 'ant-time-picker',
    align: {
        offset: [0, -2]
    },
    disabled: false,
    disabledHours: undefined,
    disabledMinutes: undefined,
    disabledSeconds: undefined,
    hideDisabledOptions: false,
    placement: 'bottomLeft',
    transitionName: 'slide-up'
};
var injectTimePickerLocale = (0, _injectLocale2["default"])('TimePicker', _zh_CN2["default"]);
exports["default"] = injectTimePickerLocale(TimePicker);
module.exports = exports['default'];