'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports["default"] = undefined;

var _defineProperty2 = require('babel-runtime/helpers/defineProperty');

var _defineProperty3 = _interopRequireDefault(_defineProperty2);

var _extends2 = require('babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _rcUpload = require('rc-upload');

var _rcUpload2 = _interopRequireDefault(_rcUpload);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _objectAssign = require('object-assign');

var _objectAssign2 = _interopRequireDefault(_objectAssign);

var _UploadList = require('./UploadList');

var _UploadList2 = _interopRequireDefault(_UploadList);

var _utils = require('./utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var defaultLocale = {
    uploading: '文件上传中',
    removeFile: '删除文件',
    uploadError: '上传错误',
    previewFile: '预览文件'
};

var Upload = function (_React$Component) {
    (0, _inherits3["default"])(Upload, _React$Component);

    function Upload(props) {
        (0, _classCallCheck3["default"])(this, Upload);

        var _this = (0, _possibleConstructorReturn3["default"])(this, _React$Component.call(this, props));

        _this.onStart = function (file) {
            var targetItem = void 0;
            var nextFileList = _this.state.fileList.concat();
            if (file.length > 0) {
                targetItem = file.map(function (f) {
                    var fileObject = (0, _utils.fileToObject)(f);
                    fileObject.status = 'uploading';
                    return fileObject;
                });
                nextFileList = nextFileList.concat(targetItem);
            } else {
                targetItem = (0, _utils.fileToObject)(file);
                targetItem.status = 'uploading';
                nextFileList.push(targetItem);
            }
            _this.onChange({
                file: targetItem,
                fileList: nextFileList
            });
            // fix ie progress
            if (!window.FormData) {
                _this.autoUpdateProgress(0, targetItem);
            }
        };
        _this.onSuccess = function (response, file) {
            _this.clearProgressTimer();
            try {
                if (typeof response === 'string') {
                    response = JSON.parse(response);
                }
            } catch (e) {}
            var fileList = _this.state.fileList;
            var targetItem = (0, _utils.getFileItem)(file, fileList);
            // removed
            if (!targetItem) {
                return;
            }
            targetItem.status = 'done';
            targetItem.response = response;
            _this.onChange({
                file: (0, _extends3["default"])({}, targetItem),
                fileList: fileList
            });
        };
        _this.onProgress = function (e, file) {
            var fileList = _this.state.fileList;
            var targetItem = (0, _utils.getFileItem)(file, fileList);
            // removed
            if (!targetItem) {
                return;
            }
            targetItem.percent = e.percent;
            _this.onChange({
                event: e,
                file: (0, _extends3["default"])({}, targetItem),
                fileList: _this.state.fileList
            });
        };
        _this.onError = function (error, response, file) {
            _this.clearProgressTimer();
            var fileList = _this.state.fileList;
            var targetItem = (0, _utils.getFileItem)(file, fileList);
            // removed
            if (!targetItem) {
                return;
            }
            targetItem.error = error;
            targetItem.response = response;
            targetItem.status = 'error';
            _this.onChange({
                file: (0, _extends3["default"])({}, targetItem),
                fileList: fileList
            });
        };
        _this.handleManualRemove = function (file) {
            _this.refs.upload.abort(file);
            file.status = 'removed'; // eslint-disable-line
            _this.handleRemove(file);
        };
        _this.onChange = function (info) {
            if (!('fileList' in _this.props)) {
                _this.setState({ fileList: info.fileList });
            }
            var onChange = _this.props.onChange;

            if (onChange) {
                onChange(info);
            }
        };
        _this.onFileDrop = function (e) {
            _this.setState({
                dragState: e.type
            });
        };
        _this.state = {
            fileList: _this.props.fileList || _this.props.defaultFileList || [],
            dragState: 'drop'
        };
        return _this;
    }

    Upload.prototype.componentWillUnmount = function componentWillUnmount() {
        this.clearProgressTimer();
    };

    Upload.prototype.getLocale = function getLocale() {
        var locale = {};
        if (this.context.antLocale && this.context.antLocale.Upload) {
            locale = this.context.antLocale.Upload;
        }
        return (0, _objectAssign2["default"])({}, defaultLocale, locale, this.props.locale);
    };

    Upload.prototype.autoUpdateProgress = function autoUpdateProgress(_, file) {
        var _this2 = this;

        var getPercent = (0, _utils.genPercentAdd)();
        var curPercent = 0;
        this.clearProgressTimer();
        this.progressTimer = setInterval(function () {
            curPercent = getPercent(curPercent);
            _this2.onProgress({
                percent: curPercent
            }, file);
        }, 200);
    };

    Upload.prototype.handleRemove = function handleRemove(file) {
        var _this3 = this;

        var onRemove = this.props.onRemove;

        Promise.resolve(typeof onRemove === 'function' ? onRemove(file) : onRemove).then(function (ret) {
            // Prevent removing file
            if (ret === false) {
                return;
            }
            var removedFileList = (0, _utils.removeFileItem)(file, _this3.state.fileList);
            if (removedFileList) {
                _this3.onChange({
                    file: file,
                    fileList: removedFileList
                });
            }
        });
    };

    Upload.prototype.componentWillReceiveProps = function componentWillReceiveProps(nextProps) {
        if ('fileList' in nextProps) {
            this.setState({
                fileList: nextProps.fileList || []
            });
        }
    };

    Upload.prototype.clearProgressTimer = function clearProgressTimer() {
        clearInterval(this.progressTimer);
    };

    Upload.prototype.render = function render() {
        var _classNames2;

        var _props = this.props,
            _props$prefixCls = _props.prefixCls,
            prefixCls = _props$prefixCls === undefined ? '' : _props$prefixCls,
            showUploadList = _props.showUploadList,
            listType = _props.listType,
            onPreview = _props.onPreview,
            type = _props.type,
            disabled = _props.disabled,
            children = _props.children,
            className = _props.className;

        var rcUploadProps = (0, _objectAssign2["default"])({}, {
            onStart: this.onStart,
            onError: this.onError,
            onProgress: this.onProgress,
            onSuccess: this.onSuccess
        }, this.props);
        delete rcUploadProps.className;
        var showRemoveIcon = showUploadList.showRemoveIcon,
            showPreviewIcon = showUploadList.showPreviewIcon;

        var uploadList = showUploadList ? _react2["default"].createElement(_UploadList2["default"], { listType: listType, items: this.state.fileList, onPreview: onPreview, onRemove: this.handleManualRemove, showRemoveIcon: showRemoveIcon, showPreviewIcon: showPreviewIcon, locale: this.getLocale() }) : null;
        if (type === 'drag') {
            var _classNames;

            var dragCls = (0, _classnames2["default"])(prefixCls, (_classNames = {}, (0, _defineProperty3["default"])(_classNames, prefixCls + '-drag', true), (0, _defineProperty3["default"])(_classNames, prefixCls + '-drag-uploading', this.state.fileList.some(function (file) {
                return file.status === 'uploading';
            })), (0, _defineProperty3["default"])(_classNames, prefixCls + '-drag-hover', this.state.dragState === 'dragover'), (0, _defineProperty3["default"])(_classNames, prefixCls + '-disabled', disabled), _classNames));
            return _react2["default"].createElement(
                'span',
                { className: className },
                _react2["default"].createElement(
                    'div',
                    { className: dragCls, onDrop: this.onFileDrop, onDragOver: this.onFileDrop, onDragLeave: this.onFileDrop },
                    _react2["default"].createElement(
                        _rcUpload2["default"],
                        (0, _extends3["default"])({}, rcUploadProps, { ref: 'upload', className: prefixCls + '-btn' }),
                        _react2["default"].createElement(
                            'div',
                            { className: prefixCls + '-drag-container' },
                            children
                        )
                    )
                ),
                uploadList
            );
        }
        var uploadButtonCls = (0, _classnames2["default"])(prefixCls, (_classNames2 = {}, (0, _defineProperty3["default"])(_classNames2, prefixCls + '-select', true), (0, _defineProperty3["default"])(_classNames2, prefixCls + '-select-' + listType, true), (0, _defineProperty3["default"])(_classNames2, prefixCls + '-disabled', disabled), _classNames2));
        var uploadButton = _react2["default"].createElement(
            'div',
            { className: uploadButtonCls, style: { display: children ? '' : 'none' } },
            _react2["default"].createElement(_rcUpload2["default"], (0, _extends3["default"])({}, rcUploadProps, { ref: 'upload' }))
        );
        if (listType === 'picture-card') {
            return _react2["default"].createElement(
                'span',
                { className: className },
                uploadList,
                uploadButton
            );
        }
        return _react2["default"].createElement(
            'span',
            { className: className },
            uploadButton,
            uploadList
        );
    };

    return Upload;
}(_react2["default"].Component);

exports["default"] = Upload;

Upload.defaultProps = {
    prefixCls: 'ant-upload',
    type: 'select',
    multiple: false,
    action: '',
    data: {},
    accept: '',
    beforeUpload: _utils.T,
    showUploadList: true,
    listType: 'text',
    className: '',
    disabled: false,
    supportServerRender: true
};
Upload.contextTypes = {
    antLocale: _propTypes2["default"].object
};
module.exports = exports['default'];