import _extends from "babel-runtime/helpers/extends";
import _defineProperty from "babel-runtime/helpers/defineProperty";
import _classCallCheck from "babel-runtime/helpers/classCallCheck";
import _createClass from "babel-runtime/helpers/createClass";
import _possibleConstructorReturn from "babel-runtime/helpers/possibleConstructorReturn";
import _inherits from "babel-runtime/helpers/inherits";
import _typeof from "babel-runtime/helpers/typeof";
var __decorate = this && this.__decorate || function (decorators, target, key, desc) {
    var c = arguments.length,
        r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
        d;
    if ((typeof Reflect === "undefined" ? "undefined" : _typeof(Reflect)) === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);else for (var i = decorators.length - 1; i >= 0; i--) {
        if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    }return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __rest = this && this.__rest || function (s, e) {
    var t = {};
    for (var p in s) {
        if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
    }if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
        if (e.indexOf(p[i]) < 0) t[p[i]] = s[p[i]];
    }return t;
};
import React, { Component, Children } from 'react';
import classNames from 'classnames';
import addEventListener from "rc-util/es/Dom/addEventListener";
import Grid from './Grid';
import { throttleByAnimationFrameDecorator } from '../_util/throttleByAnimationFrame';

var Card = function (_Component) {
    _inherits(Card, _Component);

    function Card() {
        _classCallCheck(this, Card);

        var _this = _possibleConstructorReturn(this, (Card.__proto__ || Object.getPrototypeOf(Card)).apply(this, arguments));

        _this.state = {
            widerPadding: false
        };
        _this.saveRef = function (node) {
            _this.container = node;
        };
        return _this;
    }

    _createClass(Card, [{
        key: "componentDidMount",
        value: function componentDidMount() {
            this.updateWiderPadding();
            this.resizeEvent = addEventListener(window, 'resize', this.updateWiderPadding);
        }
    }, {
        key: "componentWillUnmount",
        value: function componentWillUnmount() {
            if (this.resizeEvent) {
                this.resizeEvent.remove();
            }
        }
    }, {
        key: "updateWiderPadding",
        value: function updateWiderPadding() {
            var _this2 = this;

            // 936 is a magic card width pixer number indicated by designer
            var WIDTH_BOUDARY_PX = 936;
            if (this.container.offsetWidth >= WIDTH_BOUDARY_PX && !this.state.widerPadding) {
                this.setState({ widerPadding: true }, function () {
                    _this2.updateWiderPaddingCalled = true; // first render without css transition
                });
            }
            if (this.container.offsetWidth < WIDTH_BOUDARY_PX && this.state.widerPadding) {
                this.setState({ widerPadding: false }, function () {
                    _this2.updateWiderPaddingCalled = true; // first render without css transition
                });
            }
        }
    }, {
        key: "isContainGrid",
        value: function isContainGrid() {
            var containGrid = void 0;
            Children.forEach(this.props.children, function (element) {
                if (element && element.type && element.type === Grid) {
                    containGrid = true;
                }
            });
            return containGrid;
        }
    }, {
        key: "render",
        value: function render() {
            var _classNames;

            var _a = this.props,
                _a$prefixCls = _a.prefixCls,
                prefixCls = _a$prefixCls === undefined ? 'ant-card' : _a$prefixCls,
                className = _a.className,
                extra = _a.extra,
                bodyStyle = _a.bodyStyle,
                noHovering = _a.noHovering,
                title = _a.title,
                loading = _a.loading,
                _a$bordered = _a.bordered,
                bordered = _a$bordered === undefined ? true : _a$bordered,
                others = __rest(_a, ["prefixCls", "className", "extra", "bodyStyle", "noHovering", "title", "loading", "bordered"]);
            var children = this.props.children;
            var classString = classNames(prefixCls, className, (_classNames = {}, _defineProperty(_classNames, prefixCls + "-loading", loading), _defineProperty(_classNames, prefixCls + "-bordered", bordered), _defineProperty(_classNames, prefixCls + "-no-hovering", noHovering), _defineProperty(_classNames, prefixCls + "-wider-padding", this.state.widerPadding), _defineProperty(_classNames, prefixCls + "-padding-transition", this.updateWiderPaddingCalled), _defineProperty(_classNames, prefixCls + "-contain-grid", this.isContainGrid()), _classNames));
            if (loading) {
                children = React.createElement(
                    "div",
                    null,
                    React.createElement("p", { className: prefixCls + "-loading-block", style: { width: '94%' } }),
                    React.createElement(
                        "p",
                        null,
                        React.createElement("span", { className: prefixCls + "-loading-block", style: { width: '28%' } }),
                        React.createElement("span", { className: prefixCls + "-loading-block", style: { width: '62%' } })
                    ),
                    React.createElement(
                        "p",
                        null,
                        React.createElement("span", { className: prefixCls + "-loading-block", style: { width: '22%' } }),
                        React.createElement("span", { className: prefixCls + "-loading-block", style: { width: '66%' } })
                    ),
                    React.createElement(
                        "p",
                        null,
                        React.createElement("span", { className: prefixCls + "-loading-block", style: { width: '56%' } }),
                        React.createElement("span", { className: prefixCls + "-loading-block", style: { width: '39%' } })
                    ),
                    React.createElement(
                        "p",
                        null,
                        React.createElement("span", { className: prefixCls + "-loading-block", style: { width: '21%' } }),
                        React.createElement("span", { className: prefixCls + "-loading-block", style: { width: '15%' } }),
                        React.createElement("span", { className: prefixCls + "-loading-block", style: { width: '40%' } })
                    )
                );
            }
            var head = void 0;
            if (!title) {
                head = null;
            } else {
                head = typeof title === 'string' ? React.createElement(
                    "div",
                    { className: prefixCls + "-head" },
                    React.createElement(
                        "h3",
                        { className: prefixCls + "-head-title" },
                        title
                    )
                ) : React.createElement(
                    "div",
                    { className: prefixCls + "-head" },
                    React.createElement(
                        "div",
                        { className: prefixCls + "-head-title" },
                        title
                    )
                );
            }
            return React.createElement(
                "div",
                _extends({}, others, { className: classString, ref: this.saveRef }),
                head,
                extra ? React.createElement(
                    "div",
                    { className: prefixCls + "-extra" },
                    extra
                ) : null,
                React.createElement(
                    "div",
                    { className: prefixCls + "-body", style: bodyStyle },
                    children
                )
            );
        }
    }]);

    return Card;
}(Component);

export default Card;

Card.Grid = Grid;
__decorate([throttleByAnimationFrameDecorator()], Card.prototype, "updateWiderPadding", null);