/// <reference types="react" />
import React from 'react';
export interface AbstractSelectProps {
    prefixCls?: string;
    className?: string;
    size?: 'default' | 'large' | 'small';
    notFoundContent?: React.ReactNode | null;
    transitionName?: string;
    choiceTransitionName?: string;
    showSearch?: boolean;
    allowClear?: boolean;
    disabled?: boolean;
    style?: React.CSSProperties;
    placeholder?: string;
}
export interface LabeledValue {
    key: string;
    label: React.ReactNode;
}
export declare type SelectValue = string | any[] | LabeledValue | LabeledValue[];
export interface SelectProps extends AbstractSelectProps {
    value?: SelectValue;
    defaultValue?: SelectValue;
    mode?: 'default' | 'multiple' | 'tags' | 'combobox';
    multiple?: boolean;
    tags?: boolean;
    combobox?: boolean;
    optionLabelProp?: string;
    filterOption?: boolean | ((inputValue: string, option: Object) => any);
    onChange?: (value: SelectValue) => void;
    onSelect?: (value: SelectValue, option: Object) => any;
    onDeselect?: (value: SelectValue) => any;
    onSearch?: (value: string) => any;
    dropdownMatchSelectWidth?: boolean;
    optionFilterProp?: string;
    defaultActiveFirstOption?: boolean;
    labelInValue?: boolean;
    getPopupContainer?: (triggerNode: Element) => HTMLElement;
    dropdownStyle?: React.CSSProperties;
    dropdownMenuStyle?: React.CSSProperties;
    tokenSeparators?: string[];
    getInputElement?: () => React.ReactElement<any>;
}
export interface OptionProps {
    disabled?: boolean;
    value?: any;
}
export interface OptGroupProps {
    label?: string | React.ReactElement<any>;
}
export interface SelectContext {
    antLocale?: {
        Select?: any;
    };
}
export default class Select extends React.Component<SelectProps, any> {
    static Option: React.ClassicComponentClass<OptionProps>;
    static OptGroup: React.ClassicComponentClass<OptGroupProps>;
    static defaultProps: {
        prefixCls: string;
        showSearch: boolean;
        transitionName: string;
        choiceTransitionName: string;
    };
    static propTypes: {
        prefixCls: React.Requireable<any>;
        className: React.Requireable<any>;
        size: React.Requireable<any>;
        combobox: React.Requireable<any>;
        notFoundContent: React.Requireable<any>;
        showSearch: React.Requireable<any>;
        optionLabelProp: React.Requireable<any>;
        transitionName: React.Requireable<any>;
        choiceTransitionName: React.Requireable<any>;
    };
    context: SelectContext;
    getLocale(): any;
    render(): JSX.Element;
}
