import _extends from 'babel-runtime/helpers/extends';
import _classCallCheck from 'babel-runtime/helpers/classCallCheck';
import _createClass from 'babel-runtime/helpers/createClass';
import _possibleConstructorReturn from 'babel-runtime/helpers/possibleConstructorReturn';
import _inherits from 'babel-runtime/helpers/inherits';
import * as React from 'react';
import PropTypes from 'prop-types';
import * as moment from 'moment';
import FullCalendar from 'rc-calendar/es/FullCalendar';
import LocaleReceiver from '../locale-provider/LocaleReceiver';
import { PREFIX_CLS } from './Constants';
import Header from './Header';
import callMoment from '../_util/callMoment';
function noop() {
    return null;
}
function zerofixed(v) {
    if (v < 10) {
        return '0' + v;
    }
    return '' + v;
}

var Calendar = function (_React$Component) {
    _inherits(Calendar, _React$Component);

    function Calendar(props) {
        _classCallCheck(this, Calendar);

        var _this = _possibleConstructorReturn(this, (Calendar.__proto__ || Object.getPrototypeOf(Calendar)).call(this, props));

        _this.monthCellRender = function (value) {
            var _this$props = _this.props,
                prefixCls = _this$props.prefixCls,
                _this$props$monthCell = _this$props.monthCellRender,
                monthCellRender = _this$props$monthCell === undefined ? noop : _this$props$monthCell;

            return React.createElement(
                'div',
                { className: prefixCls + '-month' },
                React.createElement(
                    'div',
                    { className: prefixCls + '-value' },
                    value.localeData().monthsShort(value)
                ),
                React.createElement(
                    'div',
                    { className: prefixCls + '-content' },
                    monthCellRender(value)
                )
            );
        };
        _this.dateCellRender = function (value) {
            var _this$props2 = _this.props,
                prefixCls = _this$props2.prefixCls,
                _this$props2$dateCell = _this$props2.dateCellRender,
                dateCellRender = _this$props2$dateCell === undefined ? noop : _this$props2$dateCell;

            return React.createElement(
                'div',
                { className: prefixCls + '-date' },
                React.createElement(
                    'div',
                    { className: prefixCls + '-value' },
                    zerofixed(value.date())
                ),
                React.createElement(
                    'div',
                    { className: prefixCls + '-content' },
                    dateCellRender(value)
                )
            );
        };
        _this.setValue = function (value, way) {
            if (!('value' in _this.props)) {
                _this.setState({ value: value });
            }
            if (way === 'select') {
                if (_this.props.onSelect) {
                    _this.props.onSelect(value);
                }
            } else if (way === 'changePanel') {
                _this.onPanelChange(value, _this.state.mode);
            }
        };
        _this.setType = function (type) {
            var mode = type === 'date' ? 'month' : 'year';
            if (_this.state.mode !== mode) {
                _this.setState({ mode: mode });
                _this.onPanelChange(_this.state.value, mode);
            }
        };
        _this.onHeaderValueChange = function (value) {
            _this.setValue(value, 'changePanel');
        };
        _this.onHeaderTypeChange = function (type) {
            _this.setType(type);
        };
        _this.onSelect = function (value) {
            _this.setValue(value, 'select');
        };
        _this.renderCalendar = function (locale, localeCode) {
            var state = _this.state,
                props = _this.props;
            var value = state.value,
                mode = state.mode;

            if (value && localeCode) {
                value.locale(localeCode);
            }
            var prefixCls = props.prefixCls,
                style = props.style,
                className = props.className,
                fullscreen = props.fullscreen,
                dateFullCellRender = props.dateFullCellRender,
                monthFullCellRender = props.monthFullCellRender;

            var type = mode === 'year' ? 'month' : 'date';
            var cls = className || '';
            if (fullscreen) {
                cls += ' ' + prefixCls + '-fullscreen';
            }
            var monthCellRender = monthFullCellRender || _this.monthCellRender;
            var dateCellRender = dateFullCellRender || _this.dateCellRender;
            return React.createElement(
                'div',
                { className: cls, style: style },
                React.createElement(Header, { fullscreen: fullscreen, type: type, value: value, locale: locale.lang, prefixCls: prefixCls, onTypeChange: _this.onHeaderTypeChange, onValueChange: _this.onHeaderValueChange }),
                React.createElement(FullCalendar, _extends({}, props, { Select: noop, locale: locale.lang, type: type, prefixCls: prefixCls, showHeader: false, value: value, monthCellRender: monthCellRender, dateCellRender: dateCellRender, onSelect: _this.onSelect }))
            );
        };
        var value = props.value || props.defaultValue || callMoment(moment);
        if (!moment.isMoment(value)) {
            throw new Error('The value/defaultValue of Calendar must be a moment object after `antd@2.0`, ' + 'see: https://u.ant.design/calendar-value');
        }
        _this.state = {
            value: value,
            mode: props.mode
        };
        return _this;
    }

    _createClass(Calendar, [{
        key: 'componentWillReceiveProps',
        value: function componentWillReceiveProps(nextProps) {
            if ('value' in nextProps) {
                this.setState({
                    value: nextProps.value
                });
            }
        }
    }, {
        key: 'getDefaultLocale',
        value: function getDefaultLocale() {
            var locale = require('./locale/en_US');
            return locale['default'] || locale;
        }
    }, {
        key: 'onPanelChange',
        value: function onPanelChange(value, mode) {
            var onPanelChange = this.props.onPanelChange;

            if (onPanelChange) {
                onPanelChange(value, mode);
            }
        }
    }, {
        key: 'render',
        value: function render() {
            return React.createElement(
                LocaleReceiver,
                { componentName: 'Calendar', defaultLocale: this.getDefaultLocale },
                this.renderCalendar
            );
        }
    }]);

    return Calendar;
}(React.Component);

export default Calendar;

Calendar.defaultProps = {
    locale: {},
    fullscreen: true,
    prefixCls: PREFIX_CLS,
    mode: 'month',
    onSelect: noop,
    onPanelChange: noop
};
Calendar.propTypes = {
    monthCellRender: PropTypes.func,
    dateCellRender: PropTypes.func,
    monthFullCellRender: PropTypes.func,
    dateFullCellRender: PropTypes.func,
    fullscreen: PropTypes.bool,
    locale: PropTypes.object,
    prefixCls: PropTypes.string,
    className: PropTypes.string,
    style: PropTypes.object,
    onPanelChange: PropTypes.func,
    value: PropTypes.object,
    onSelect: PropTypes.func
};