/// <reference types="react" />
import * as React from 'react';
export declare type CollapseType = 'clickTrigger' | 'responsive';
export interface SiderProps {
    style?: React.CSSProperties;
    prefixCls?: string;
    className?: string;
    collapsible?: boolean;
    collapsed?: boolean;
    defaultCollapsed?: boolean;
    reverseArrow?: boolean;
    onCollapse?: (collapsed: boolean, type: CollapseType) => void;
    trigger?: React.ReactNode;
    width?: number | string;
    collapsedWidth?: number | string;
    breakpoint?: 'xs' | 'sm' | 'md' | 'lg' | 'xl';
}
export interface SliderState {
    collapsed?: boolean;
    below: boolean;
    belowShow?: boolean;
}
export interface SliderContext {
    siderCollapsed: boolean;
}
export default class Sider extends React.Component<SiderProps, SliderState> {
    static __ANT_LAYOUT_SIDER: any;
    static defaultProps: {
        prefixCls: string;
        collapsible: boolean;
        defaultCollapsed: boolean;
        reverseArrow: boolean;
        width: number;
        collapsedWidth: number;
        style: {};
    };
    static childContextTypes: {
        siderCollapsed: any;
    };
    static contextTypes: {
        siderHook: any;
    };
    private mql;
    private uniqueId;
    constructor(props: SiderProps);
    getChildContext(): {
        siderCollapsed: boolean | undefined;
    };
    componentWillReceiveProps(nextProps: SiderProps): void;
    componentDidMount(): void;
    componentWillUnmount(): void;
    responsiveHandler: (mql: MediaQueryList) => void;
    setCollapsed: (collapsed: boolean, type: CollapseType) => void;
    toggle: () => void;
    belowShowChange: () => void;
    render(): JSX.Element;
}
