"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var React = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _addEventListener = _interopRequireDefault(require("rc-util/lib/Dom/addEventListener"));

var _omit = _interopRequireDefault(require("omit.js"));

var _Grid = _interopRequireDefault(require("./Grid"));

var _Meta = _interopRequireDefault(require("./Meta"));

var _tabs = _interopRequireDefault(require("../tabs"));

var _row = _interopRequireDefault(require("../row"));

var _col = _interopRequireDefault(require("../col"));

var _configProvider = require("../config-provider");

var _throttleByAnimationFrame = require("../_util/throttleByAnimationFrame");

var _warning = _interopRequireDefault(require("../_util/warning"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var __decorate = void 0 && (void 0).__decorate || function (decorators, target, key, desc) {
  var c = arguments.length,
      r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc,
      d;
  if ((typeof Reflect === "undefined" ? "undefined" : _typeof(Reflect)) === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);else for (var i = decorators.length - 1; i >= 0; i--) {
    if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
  }
  return c > 3 && r && Object.defineProperty(target, key, r), r;
};

var __rest = void 0 && (void 0).__rest || function (s, e) {
  var t = {};

  for (var p in s) {
    if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  }

  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0) t[p[i]] = s[p[i]];
  }
  return t;
};

var Card =
/*#__PURE__*/
function (_React$Component) {
  _inherits(Card, _React$Component);

  function Card() {
    var _this;

    _classCallCheck(this, Card);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Card).apply(this, arguments));
    _this.state = {
      widerPadding: false
    };
    _this.updateWiderPaddingCalled = false;

    _this.onTabChange = function (key) {
      if (_this.props.onTabChange) {
        _this.props.onTabChange(key);
      }
    };

    _this.saveRef = function (node) {
      _this.container = node;
    };

    _this.renderCard = function (_ref) {
      var _classNames;

      var getPrefixCls = _ref.getPrefixCls;

      var _a = _this.props,
          customizePrefixCls = _a.prefixCls,
          className = _a.className,
          extra = _a.extra,
          _a$headStyle = _a.headStyle,
          headStyle = _a$headStyle === void 0 ? {} : _a$headStyle,
          _a$bodyStyle = _a.bodyStyle,
          bodyStyle = _a$bodyStyle === void 0 ? {} : _a$bodyStyle,
          noHovering = _a.noHovering,
          hoverable = _a.hoverable,
          title = _a.title,
          loading = _a.loading,
          _a$bordered = _a.bordered,
          bordered = _a$bordered === void 0 ? true : _a$bordered,
          _a$size = _a.size,
          size = _a$size === void 0 ? 'default' : _a$size,
          type = _a.type,
          cover = _a.cover,
          actions = _a.actions,
          tabList = _a.tabList,
          children = _a.children,
          activeTabKey = _a.activeTabKey,
          defaultActiveTabKey = _a.defaultActiveTabKey,
          others = __rest(_a, ["prefixCls", "className", "extra", "headStyle", "bodyStyle", "noHovering", "hoverable", "title", "loading", "bordered", "size", "type", "cover", "actions", "tabList", "children", "activeTabKey", "defaultActiveTabKey"]);

      var prefixCls = getPrefixCls('card', customizePrefixCls);
      var classString = (0, _classnames["default"])(prefixCls, className, (_classNames = {}, _defineProperty(_classNames, "".concat(prefixCls, "-loading"), loading), _defineProperty(_classNames, "".concat(prefixCls, "-bordered"), bordered), _defineProperty(_classNames, "".concat(prefixCls, "-hoverable"), _this.getCompatibleHoverable()), _defineProperty(_classNames, "".concat(prefixCls, "-wider-padding"), _this.state.widerPadding), _defineProperty(_classNames, "".concat(prefixCls, "-padding-transition"), _this.updateWiderPaddingCalled), _defineProperty(_classNames, "".concat(prefixCls, "-contain-grid"), _this.isContainGrid()), _defineProperty(_classNames, "".concat(prefixCls, "-contain-tabs"), tabList && tabList.length), _defineProperty(_classNames, "".concat(prefixCls, "-").concat(size), size !== 'default'), _defineProperty(_classNames, "".concat(prefixCls, "-type-").concat(type), !!type), _classNames));
      var loadingBlockStyle = bodyStyle.padding === 0 || bodyStyle.padding === '0px' ? {
        padding: 24
      } : undefined;
      var loadingBlock = React.createElement("div", {
        className: "".concat(prefixCls, "-loading-content"),
        style: loadingBlockStyle
      }, React.createElement(_row["default"], {
        gutter: 8
      }, React.createElement(_col["default"], {
        span: 22
      }, React.createElement("div", {
        className: "".concat(prefixCls, "-loading-block")
      }))), React.createElement(_row["default"], {
        gutter: 8
      }, React.createElement(_col["default"], {
        span: 8
      }, React.createElement("div", {
        className: "".concat(prefixCls, "-loading-block")
      })), React.createElement(_col["default"], {
        span: 15
      }, React.createElement("div", {
        className: "".concat(prefixCls, "-loading-block")
      }))), React.createElement(_row["default"], {
        gutter: 8
      }, React.createElement(_col["default"], {
        span: 6
      }, React.createElement("div", {
        className: "".concat(prefixCls, "-loading-block")
      })), React.createElement(_col["default"], {
        span: 18
      }, React.createElement("div", {
        className: "".concat(prefixCls, "-loading-block")
      }))), React.createElement(_row["default"], {
        gutter: 8
      }, React.createElement(_col["default"], {
        span: 13
      }, React.createElement("div", {
        className: "".concat(prefixCls, "-loading-block")
      })), React.createElement(_col["default"], {
        span: 9
      }, React.createElement("div", {
        className: "".concat(prefixCls, "-loading-block")
      }))), React.createElement(_row["default"], {
        gutter: 8
      }, React.createElement(_col["default"], {
        span: 4
      }, React.createElement("div", {
        className: "".concat(prefixCls, "-loading-block")
      })), React.createElement(_col["default"], {
        span: 3
      }, React.createElement("div", {
        className: "".concat(prefixCls, "-loading-block")
      })), React.createElement(_col["default"], {
        span: 16
      }, React.createElement("div", {
        className: "".concat(prefixCls, "-loading-block")
      }))), React.createElement(_row["default"], {
        gutter: 8
      }, React.createElement(_col["default"], {
        span: 8
      }, React.createElement("div", {
        className: "".concat(prefixCls, "-loading-block")
      })), React.createElement(_col["default"], {
        span: 6
      }, React.createElement("div", {
        className: "".concat(prefixCls, "-loading-block")
      })), React.createElement(_col["default"], {
        span: 8
      }, React.createElement("div", {
        className: "".concat(prefixCls, "-loading-block")
      }))));
      var hasActiveTabKey = activeTabKey !== undefined;

      var extraProps = _defineProperty({}, hasActiveTabKey ? 'activeKey' : 'defaultActiveKey', hasActiveTabKey ? activeTabKey : defaultActiveTabKey);

      var head;
      var tabs = tabList && tabList.length ? React.createElement(_tabs["default"], _extends({}, extraProps, {
        className: "".concat(prefixCls, "-head-tabs"),
        size: "large",
        onChange: _this.onTabChange
      }), tabList.map(function (item) {
        return React.createElement(_tabs["default"].TabPane, {
          tab: item.tab,
          disabled: item.disabled,
          key: item.key
        });
      })) : null;

      if (title || extra || tabs) {
        head = React.createElement("div", {
          className: "".concat(prefixCls, "-head"),
          style: headStyle
        }, React.createElement("div", {
          className: "".concat(prefixCls, "-head-wrapper")
        }, title && React.createElement("div", {
          className: "".concat(prefixCls, "-head-title")
        }, title), extra && React.createElement("div", {
          className: "".concat(prefixCls, "-extra")
        }, extra)), tabs);
      }

      var coverDom = cover ? React.createElement("div", {
        className: "".concat(prefixCls, "-cover")
      }, cover) : null;
      var body = React.createElement("div", {
        className: "".concat(prefixCls, "-body"),
        style: bodyStyle
      }, loading ? loadingBlock : children);
      var actionDom = actions && actions.length ? React.createElement("ul", {
        className: "".concat(prefixCls, "-actions")
      }, _this.getAction(actions)) : null;
      var divProps = (0, _omit["default"])(others, ['onTabChange']);
      return React.createElement("div", _extends({}, divProps, {
        className: classString,
        ref: _this.saveRef
      }), head, coverDom, body, actionDom);
    };

    return _this;
  }

  _createClass(Card, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.updateWiderPadding();
      this.resizeEvent = (0, _addEventListener["default"])(window, 'resize', this.updateWiderPadding);

      if ('noHovering' in this.props) {
        (0, _warning["default"])(!this.props.noHovering, '`noHovering` of Card is deprecated, you can remove it safely or use `hoverable` instead.');
        (0, _warning["default"])(!!this.props.noHovering, '`noHovering={false}` of Card is deprecated, use `hoverable` instead.');
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.resizeEvent) {
        this.resizeEvent.remove();
      }

      this.updateWiderPadding.cancel();
    }
  }, {
    key: "updateWiderPadding",
    value: function updateWiderPadding() {
      var _this2 = this;

      if (!this.container) {
        return;
      } // 936 is a magic card width pixel number indicated by designer


      var WIDTH_BOUNDARY_PX = 936;

      if (this.container.offsetWidth >= WIDTH_BOUNDARY_PX && !this.state.widerPadding) {
        this.setState({
          widerPadding: true
        }, function () {
          _this2.updateWiderPaddingCalled = true; // first render without css transition
        });
      }

      if (this.container.offsetWidth < WIDTH_BOUNDARY_PX && this.state.widerPadding) {
        this.setState({
          widerPadding: false
        }, function () {
          _this2.updateWiderPaddingCalled = true; // first render without css transition
        });
      }
    }
  }, {
    key: "isContainGrid",
    value: function isContainGrid() {
      var containGrid;
      React.Children.forEach(this.props.children, function (element) {
        if (element && element.type && element.type === _Grid["default"]) {
          containGrid = true;
        }
      });
      return containGrid;
    }
  }, {
    key: "getAction",
    value: function getAction(actions) {
      if (!actions || !actions.length) {
        return null;
      }

      var actionList = actions.map(function (action, index) {
        return React.createElement("li", {
          style: {
            width: "".concat(100 / actions.length, "%")
          },
          key: "action-".concat(index)
        }, React.createElement("span", null, action));
      });
      return actionList;
    } // For 2.x compatible

  }, {
    key: "getCompatibleHoverable",
    value: function getCompatibleHoverable() {
      var _this$props = this.props,
          noHovering = _this$props.noHovering,
          hoverable = _this$props.hoverable;

      if ('noHovering' in this.props) {
        return !noHovering || hoverable;
      }

      return !!hoverable;
    }
  }, {
    key: "render",
    value: function render() {
      return React.createElement(_configProvider.ConfigConsumer, null, this.renderCard);
    }
  }]);

  return Card;
}(React.Component);

exports["default"] = Card;
Card.Grid = _Grid["default"];
Card.Meta = _Meta["default"];

__decorate([(0, _throttleByAnimationFrame.throttleByAnimationFrameDecorator)()], Card.prototype, "updateWiderPadding", null);