import * as React from 'react';
import { validProgress } from './utils';

var Line = function Line(props) {
  var prefixCls = props.prefixCls,
      percent = props.percent,
      successPercent = props.successPercent,
      strokeWidth = props.strokeWidth,
      size = props.size,
      strokeColor = props.strokeColor,
      strokeLinecap = props.strokeLinecap,
      children = props.children;
  var percentStyle = {
    width: "".concat(validProgress(percent), "%"),
    height: strokeWidth || (size === 'small' ? 6 : 8),
    background: strokeColor,
    borderRadius: strokeLinecap === 'square' ? 0 : '100px'
  };
  var successPercentStyle = {
    width: "".concat(validProgress(successPercent), "%"),
    height: strokeWidth || (size === 'small' ? 6 : 8),
    borderRadius: strokeLinecap === 'square' ? 0 : '100px'
  };
  var successSegment = successPercent !== undefined ? React.createElement("div", {
    className: "".concat(prefixCls, "-success-bg"),
    style: successPercentStyle
  }) : null;
  return React.createElement("div", null, React.createElement("div", {
    className: "".concat(prefixCls, "-outer")
  }, React.createElement("div", {
    className: "".concat(prefixCls, "-inner")
  }, React.createElement("div", {
    className: "".concat(prefixCls, "-bg"),
    style: percentStyle
  }), successSegment)), children);
};

export default Line;