"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var React = _interopRequireWildcard(require("react"));

var moment = _interopRequireWildcard(require("moment"));

var _reactLifecyclesCompat = require("react-lifecycles-compat");

var _rcCalendar = _interopRequireDefault(require("rc-calendar"));

var _Picker = _interopRequireDefault(require("rc-calendar/lib/Picker"));

var _classnames = _interopRequireDefault(require("classnames"));

var _icon = _interopRequireDefault(require("../icon"));

var _configProvider = require("../config-provider");

var _interopDefault = _interopRequireDefault(require("../_util/interopDefault"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function formatValue(value, format) {
  return value && value.format(format) || '';
}

var WeekPicker =
/*#__PURE__*/
function (_React$Component) {
  _inherits(WeekPicker, _React$Component);

  function WeekPicker(props) {
    var _this;

    _classCallCheck(this, WeekPicker);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(WeekPicker).call(this, props));

    _this.weekDateRender = function (current) {
      var selectedValue = _this.state.value;

      var _assertThisInitialize = _assertThisInitialized(_this),
          prefixCls = _assertThisInitialize.prefixCls;

      var dateRender = _this.props.dateRender;
      var dateNode = dateRender ? dateRender(current) : current.date();

      if (selectedValue && current.year() === selectedValue.year() && current.week() === selectedValue.week()) {
        return React.createElement("div", {
          className: "".concat(prefixCls, "-selected-day")
        }, React.createElement("div", {
          className: "".concat(prefixCls, "-date")
        }, dateNode));
      }

      return React.createElement("div", {
        className: "".concat(prefixCls, "-date")
      }, dateNode);
    };

    _this.handleChange = function (value) {
      if (!('value' in _this.props)) {
        _this.setState({
          value: value
        });
      }

      _this.props.onChange(value, formatValue(value, _this.props.format));
    };

    _this.handleOpenChange = function (open) {
      var onOpenChange = _this.props.onOpenChange;

      if (!('open' in _this.props)) {
        _this.setState({
          open: open
        });
      }

      if (onOpenChange) {
        onOpenChange(open);
      }
    };

    _this.clearSelection = function (e) {
      e.preventDefault();
      e.stopPropagation();

      _this.handleChange(null);
    };

    _this.renderFooter = function () {
      var _this$props = _this.props,
          prefixCls = _this$props.prefixCls,
          renderExtraFooter = _this$props.renderExtraFooter;
      return renderExtraFooter ? React.createElement("div", {
        className: "".concat(prefixCls, "-footer-extra")
      }, renderExtraFooter.apply(void 0, arguments)) : null;
    };

    _this.saveInput = function (node) {
      _this.input = node;
    };

    _this.renderWeekPicker = function (_ref) {
      var _classNames;

      var getPrefixCls = _ref.getPrefixCls;
      var _this$props2 = _this.props,
          customizePrefixCls = _this$props2.prefixCls,
          className = _this$props2.className,
          disabled = _this$props2.disabled,
          pickerClass = _this$props2.pickerClass,
          popupStyle = _this$props2.popupStyle,
          pickerInputClass = _this$props2.pickerInputClass,
          format = _this$props2.format,
          allowClear = _this$props2.allowClear,
          locale = _this$props2.locale,
          localeCode = _this$props2.localeCode,
          disabledDate = _this$props2.disabledDate,
          style = _this$props2.style,
          onFocus = _this$props2.onFocus,
          onBlur = _this$props2.onBlur,
          id = _this$props2.id,
          suffixIcon = _this$props2.suffixIcon;
      var prefixCls = getPrefixCls('calendar', customizePrefixCls); // To support old version react.
      // Have to add prefixCls on the instance.
      // https://github.com/facebook/react/issues/12397

      _this.prefixCls = prefixCls;
      var _this$state = _this.state,
          open = _this$state.open,
          pickerValue = _this$state.value;

      if (pickerValue && localeCode) {
        pickerValue.locale(localeCode);
      }

      var placeholder = 'placeholder' in _this.props ? _this.props.placeholder : locale.lang.placeholder;
      var calendar = React.createElement(_rcCalendar["default"], {
        showWeekNumber: true,
        dateRender: _this.weekDateRender,
        prefixCls: prefixCls,
        format: format,
        locale: locale.lang,
        showDateInput: false,
        showToday: false,
        disabledDate: disabledDate,
        renderFooter: _this.renderFooter
      });
      var clearIcon = !disabled && allowClear && _this.state.value ? React.createElement(_icon["default"], {
        type: "close-circle",
        className: "".concat(prefixCls, "-picker-clear"),
        onClick: _this.clearSelection,
        theme: "filled"
      }) : null;
      var inputIcon = suffixIcon && (React.isValidElement(suffixIcon) ? React.cloneElement(suffixIcon, {
        className: (0, _classnames["default"])((_classNames = {}, _defineProperty(_classNames, suffixIcon.props.className, suffixIcon.props.className), _defineProperty(_classNames, "".concat(prefixCls, "-picker-icon"), true), _classNames))
      }) : React.createElement("span", {
        className: "".concat(prefixCls, "-picker-icon")
      }, suffixIcon)) || React.createElement(_icon["default"], {
        type: "calendar",
        className: "".concat(prefixCls, "-picker-icon")
      });

      var input = function input(_ref2) {
        var value = _ref2.value;
        return React.createElement("span", {
          style: {
            display: 'inline-block',
            width: '100%'
          }
        }, React.createElement("input", {
          ref: _this.saveInput,
          disabled: disabled,
          readOnly: true,
          value: value && value.format(format) || '',
          placeholder: placeholder,
          className: pickerInputClass,
          onFocus: onFocus,
          onBlur: onBlur
        }), clearIcon, inputIcon);
      };

      return React.createElement("span", {
        className: (0, _classnames["default"])(className, pickerClass),
        style: style,
        id: id
      }, React.createElement(_Picker["default"], _extends({}, _this.props, {
        calendar: calendar,
        prefixCls: "".concat(prefixCls, "-picker-container"),
        value: pickerValue,
        onChange: _this.handleChange,
        open: open,
        onOpenChange: _this.handleOpenChange,
        style: popupStyle
      }), input));
    };

    var value = props.value || props.defaultValue;

    if (value && !(0, _interopDefault["default"])(moment).isMoment(value)) {
      throw new Error('The value/defaultValue of DatePicker or MonthPicker must be ' + 'a moment object after `antd@2.0`, see: https://u.ant.design/date-picker-value');
    }

    _this.state = {
      value: value,
      open: props.open
    };
    return _this;
  }

  _createClass(WeekPicker, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(_, prevState) {
      if (!('open' in this.props) && prevState.open && !this.state.open) {
        this.focus();
      }
    }
  }, {
    key: "focus",
    value: function focus() {
      this.input.focus();
    }
  }, {
    key: "blur",
    value: function blur() {
      this.input.blur();
    }
  }, {
    key: "render",
    value: function render() {
      return React.createElement(_configProvider.ConfigConsumer, null, this.renderWeekPicker);
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps) {
      if ('value' in nextProps || 'open' in nextProps) {
        var state = {};

        if ('value' in nextProps) {
          state.value = nextProps.value;
        }

        if ('open' in nextProps) {
          state.open = nextProps.open;
        }

        return state;
      }

      return null;
    }
  }]);

  return WeekPicker;
}(React.Component);

WeekPicker.defaultProps = {
  format: 'gggg-wo',
  allowClear: true
};
(0, _reactLifecyclesCompat.polyfill)(WeekPicker);
var _default = WeekPicker;
exports["default"] = _default;