"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var React = _interopRequireWildcard(require("react"));

var _checkbox = _interopRequireDefault(require("../checkbox"));

var _dropdown = _interopRequireDefault(require("../dropdown"));

var _menu = _interopRequireDefault(require("../menu"));

var _icon = _interopRequireDefault(require("../icon"));

var _classnames = _interopRequireDefault(require("classnames"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var SelectionCheckboxAll =
/*#__PURE__*/
function (_React$Component) {
  _inherits(SelectionCheckboxAll, _React$Component);

  function SelectionCheckboxAll(props) {
    var _this;

    _classCallCheck(this, SelectionCheckboxAll);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(SelectionCheckboxAll).call(this, props));

    _this.handleSelectAllChange = function (e) {
      var checked = e.target.checked;

      _this.props.onSelect(checked ? 'all' : 'removeAll', 0, null);
    };

    _this.defaultSelections = props.hideDefaultSelections ? [] : [{
      key: 'all',
      text: props.locale.selectAll,
      onSelect: function onSelect() {}
    }, {
      key: 'invert',
      text: props.locale.selectInvert,
      onSelect: function onSelect() {}
    }];
    _this.state = {
      checked: _this.getCheckState(props),
      indeterminate: _this.getIndeterminateState(props)
    };
    return _this;
  }

  _createClass(SelectionCheckboxAll, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.subscribe();
    }
  }, {
    key: "componentWillReceiveProps",
    value: function componentWillReceiveProps(nextProps) {
      this.setCheckState(nextProps);
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.unsubscribe) {
        this.unsubscribe();
      }
    }
  }, {
    key: "subscribe",
    value: function subscribe() {
      var _this2 = this;

      var store = this.props.store;
      this.unsubscribe = store.subscribe(function () {
        _this2.setCheckState(_this2.props);
      });
    }
  }, {
    key: "checkSelection",
    value: function checkSelection(props, data, type, byDefaultChecked) {
      var _ref = props || this.props,
          store = _ref.store,
          getCheckboxPropsByItem = _ref.getCheckboxPropsByItem,
          getRecordKey = _ref.getRecordKey; // type should be 'every' | 'some'


      if (type === 'every' || type === 'some') {
        return byDefaultChecked ? data[type](function (item, i) {
          return getCheckboxPropsByItem(item, i).defaultChecked;
        }) : data[type](function (item, i) {
          return store.getState().selectedRowKeys.indexOf(getRecordKey(item, i)) >= 0;
        });
      }

      return false;
    }
  }, {
    key: "setCheckState",
    value: function setCheckState(props) {
      var checked = this.getCheckState(props);
      var indeterminate = this.getIndeterminateState(props);
      this.setState(function (prevState) {
        var newState = {};

        if (indeterminate !== prevState.indeterminate) {
          newState.indeterminate = indeterminate;
        }

        if (checked !== prevState.checked) {
          newState.checked = checked;
        }

        return newState;
      });
    }
  }, {
    key: "getCheckState",
    value: function getCheckState(props) {
      var store = props.store,
          data = props.data;
      var checked;

      if (!data.length) {
        checked = false;
      } else {
        checked = store.getState().selectionDirty ? this.checkSelection(props, data, 'every', false) : this.checkSelection(props, data, 'every', false) || this.checkSelection(props, data, 'every', true);
      }

      return checked;
    }
  }, {
    key: "getIndeterminateState",
    value: function getIndeterminateState(props) {
      var store = props.store,
          data = props.data;
      var indeterminate;

      if (!data.length) {
        indeterminate = false;
      } else {
        indeterminate = store.getState().selectionDirty ? this.checkSelection(props, data, 'some', false) && !this.checkSelection(props, data, 'every', false) : this.checkSelection(props, data, 'some', false) && !this.checkSelection(props, data, 'every', false) || this.checkSelection(props, data, 'some', true) && !this.checkSelection(props, data, 'every', true);
      }

      return indeterminate;
    }
  }, {
    key: "renderMenus",
    value: function renderMenus(selections) {
      var _this3 = this;

      return selections.map(function (selection, index) {
        return React.createElement(_menu["default"].Item, {
          key: selection.key || index
        }, React.createElement("div", {
          onClick: function onClick() {
            _this3.props.onSelect(selection.key, index, selection.onSelect);
          }
        }, selection.text));
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          disabled = _this$props.disabled,
          prefixCls = _this$props.prefixCls,
          selections = _this$props.selections,
          getPopupContainer = _this$props.getPopupContainer;
      var _this$state = this.state,
          checked = _this$state.checked,
          indeterminate = _this$state.indeterminate;
      var selectionPrefixCls = "".concat(prefixCls, "-selection");
      var customSelections = null;

      if (selections) {
        var newSelections = Array.isArray(selections) ? this.defaultSelections.concat(selections) : this.defaultSelections;
        var menu = React.createElement(_menu["default"], {
          className: "".concat(selectionPrefixCls, "-menu"),
          selectedKeys: []
        }, this.renderMenus(newSelections));
        customSelections = newSelections.length > 0 ? React.createElement(_dropdown["default"], {
          overlay: menu,
          getPopupContainer: getPopupContainer
        }, React.createElement("div", {
          className: "".concat(selectionPrefixCls, "-down")
        }, React.createElement(_icon["default"], {
          type: "down"
        }))) : null;
      }

      return React.createElement("div", {
        className: selectionPrefixCls
      }, React.createElement(_checkbox["default"], {
        className: (0, _classnames["default"])(_defineProperty({}, "".concat(selectionPrefixCls, "-select-all-custom"), customSelections)),
        checked: checked,
        indeterminate: indeterminate,
        disabled: disabled,
        onChange: this.handleSelectAllChange
      }), customSelections);
    }
  }]);

  return SelectionCheckboxAll;
}(React.Component);

exports["default"] = SelectionCheckboxAll;