import _extends from 'babel-runtime/helpers/extends';

var _this = this;

import * as React from 'react';
import * as ReactDOM from 'react-dom';
import classNames from 'classnames';
import Icon from '../icon';
import Dialog from './Modal';
import ActionButton from './ActionButton';
import { getConfirmLocale } from './locale';
var IS_REACT_16 = !!ReactDOM.createPortal;
var ConfirmDialog = function ConfirmDialog(props) {
    var onCancel = props.onCancel,
        onOk = props.onOk,
        close = props.close,
        zIndex = props.zIndex,
        afterClose = props.afterClose,
        visible = props.visible,
        keyboard = props.keyboard;

    var iconType = props.iconType || 'question-circle';
    var okType = props.okType || 'primary';
    var prefixCls = props.prefixCls || 'ant-confirm';
    // 默认为 true，保持向下兼容
    var okCancel = 'okCancel' in props ? props.okCancel : true;
    var width = props.width || 416;
    var style = props.style || {};
    // 默认为 false，保持旧版默认行为
    var maskClosable = props.maskClosable === undefined ? false : props.maskClosable;
    var runtimeLocale = getConfirmLocale();
    var okText = props.okText || (okCancel ? runtimeLocale.okText : runtimeLocale.justOkText);
    var cancelText = props.cancelText || runtimeLocale.cancelText;
    var classString = classNames(prefixCls, prefixCls + '-' + props.type, props.className);
    var cancelButton = okCancel && React.createElement(
        ActionButton,
        { actionFn: onCancel, closeModal: close },
        cancelText
    );
    return React.createElement(
        Dialog,
        { className: classString, onCancel: close.bind(_this, { triggerCancel: true }), visible: visible, title: '', transitionName: 'zoom', footer: '', maskTransitionName: 'fade', maskClosable: maskClosable, style: style, width: width, zIndex: zIndex, afterClose: afterClose, keyboard: keyboard },
        React.createElement(
            'div',
            { className: prefixCls + '-body-wrapper' },
            React.createElement(
                'div',
                { className: prefixCls + '-body' },
                React.createElement(Icon, { type: iconType }),
                React.createElement(
                    'span',
                    { className: prefixCls + '-title' },
                    props.title
                ),
                React.createElement(
                    'div',
                    { className: prefixCls + '-content' },
                    props.content
                )
            ),
            React.createElement(
                'div',
                { className: prefixCls + '-btns' },
                cancelButton,
                React.createElement(
                    ActionButton,
                    { type: okType, actionFn: onOk, closeModal: close, autoFocus: true },
                    okText
                )
            )
        )
    );
};
export default function confirm(config) {
    var div = document.createElement('div');
    document.body.appendChild(div);
    function close() {
        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        if (IS_REACT_16) {
            render(_extends({}, config, { close: close, visible: false, afterClose: destroy.bind.apply(destroy, [this].concat(args)) }));
        } else {
            destroy.apply(undefined, args);
        }
    }
    function destroy() {
        var unmountResult = ReactDOM.unmountComponentAtNode(div);
        if (unmountResult && div.parentNode) {
            div.parentNode.removeChild(div);
        }

        for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
            args[_key2] = arguments[_key2];
        }

        var triggerCancel = args && args.length && args.some(function (param) {
            return param && param.triggerCancel;
        });
        if (config.onCancel && triggerCancel) {
            config.onCancel.apply(config, args);
        }
    }
    function render(props) {
        ReactDOM.render(React.createElement(ConfirmDialog, props), div);
    }
    render(_extends({}, config, { visible: true, close: close }));
    return {
        destroy: close
    };
}