'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = require('react');

var React = _interopRequireWildcard(_react);

var _reactDom = require('react-dom');

var _Event = require('css-animation/lib/Event');

var _Event2 = _interopRequireDefault(_Event);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj['default'] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var Wave = function (_React$Component) {
    (0, _inherits3['default'])(Wave, _React$Component);

    function Wave() {
        (0, _classCallCheck3['default'])(this, Wave);

        var _this = (0, _possibleConstructorReturn3['default'])(this, (Wave.__proto__ || Object.getPrototypeOf(Wave)).apply(this, arguments));

        _this.onClick = function (node, waveColor) {
            if (node.className.indexOf('-leave') >= 0) {
                return;
            }
            var insertExtraNode = _this.props.insertExtraNode;

            _this.extraNode = document.createElement('div');
            var extraNode = _this.extraNode;
            extraNode.className = 'ant-click-animating-node';
            var attributeName = _this.getAttributeName();
            node.removeAttribute(attributeName);
            node.setAttribute(attributeName, 'true');
            // Not white or transparnt or grey
            if (waveColor && waveColor !== '#ffffff' && waveColor !== 'rgb(255, 255, 255)' && _this.isNotGrey(waveColor) && !/rgba\(\d*, \d*, \d*, 0\)/.test(waveColor) && // any transparent rgba color
            waveColor !== 'transparent') {
                extraNode.style.borderColor = waveColor;
                _this.styleForPesudo = document.createElement('style');
                _this.styleForPesudo.innerHTML = '[ant-click-animating-without-extra-node]:after { border-color: ' + waveColor + '; }';
                document.body.appendChild(_this.styleForPesudo);
            }
            if (insertExtraNode) {
                node.appendChild(extraNode);
            }
            _Event2['default'].addEndEventListener(node, _this.onTransitionEnd);
        };
        _this.bindAnimationEvent = function (node) {
            if (!node || !node.getAttribute || node.getAttribute('disabled') || node.className.indexOf('disabled') >= 0) {
                return;
            }
            var onClick = function onClick(e) {
                // Fix radio button click twice
                if (e.target.tagName === 'INPUT') {
                    return;
                }
                _this.resetEffect(node);
                // Get wave color from target
                var waveColor = getComputedStyle(node).getPropertyValue('border-top-color') || // Firefox Compatible
                getComputedStyle(node).getPropertyValue('border-color') || getComputedStyle(node).getPropertyValue('background-color');
                _this.clickWaveTimeoutId = window.setTimeout(function () {
                    return _this.onClick(node, waveColor);
                }, 0);
            };
            node.addEventListener('click', onClick, true);
            return {
                cancel: function cancel() {
                    node.removeEventListener('click', onClick, true);
                }
            };
        };
        _this.onTransitionEnd = function (e) {
            if (!e || e.animationName !== 'fadeEffect') {
                return;
            }
            _this.resetEffect(e.target);
        };
        return _this;
    }

    (0, _createClass3['default'])(Wave, [{
        key: 'isNotGrey',
        value: function isNotGrey(color) {
            var match = (color || '').match(/rgba?\((\d*), (\d*), (\d*)(, [\.\d]*)?\)/);
            if (match && match[1] && match[2] && match[3]) {
                return !(match[1] === match[2] && match[2] === match[3]);
            }
            return true;
        }
    }, {
        key: 'getAttributeName',
        value: function getAttributeName() {
            var insertExtraNode = this.props.insertExtraNode;

            return insertExtraNode ? 'ant-click-animating' : 'ant-click-animating-without-extra-node';
        }
    }, {
        key: 'resetEffect',
        value: function resetEffect(node) {
            var insertExtraNode = this.props.insertExtraNode;

            var attributeName = this.getAttributeName();
            node.removeAttribute(attributeName);
            this.removeExtraStyleNode();
            if (insertExtraNode) {
                node.removeChild(this.extraNode);
            }
            _Event2['default'].removeEndEventListener(node, this.onTransitionEnd);
        }
    }, {
        key: 'removeExtraStyleNode',
        value: function removeExtraStyleNode() {
            if (this.styleForPesudo && document.body.contains(this.styleForPesudo)) {
                document.body.removeChild(this.styleForPesudo);
                this.styleForPesudo = null;
            }
        }
    }, {
        key: 'componentDidMount',
        value: function componentDidMount() {
            this.instance = this.bindAnimationEvent((0, _reactDom.findDOMNode)(this));
        }
    }, {
        key: 'componentWillUnmount',
        value: function componentWillUnmount() {
            if (this.instance) {
                this.instance.cancel();
            }
            if (this.clickWaveTimeoutId) {
                clearTimeout(this.clickWaveTimeoutId);
            }
        }
    }, {
        key: 'render',
        value: function render() {
            return this.props.children;
        }
    }]);
    return Wave;
}(React.Component);

exports['default'] = Wave;
module.exports = exports['default'];