function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

import * as React from 'react';
import classNames from 'classnames';
import { LoadingOutlined, CloseCircleFilled, CheckCircleFilled, ExclamationCircleFilled } from '@ant-design/icons';
import CSSMotion from "rc-animate/es/CSSMotion";
import Col from '../grid/col';
import { FormContext } from './context';
import { useCacheErrors } from './util';
var iconMap = {
  success: CheckCircleFilled,
  warning: ExclamationCircleFilled,
  error: CloseCircleFilled,
  validating: LoadingOutlined
};

var FormItemInput = function FormItemInput(_ref) {
  var prefixCls = _ref.prefixCls,
      wrapperCol = _ref.wrapperCol,
      children = _ref.children,
      errors = _ref.errors,
      onDomErrorVisibleChange = _ref.onDomErrorVisibleChange,
      hasFeedback = _ref.hasFeedback,
      validateStatus = _ref.validateStatus,
      extra = _ref.extra;
  var baseClassName = "".concat(prefixCls, "-item");
  var formContext = React.useContext(FormContext);
  var mergedWrapperCol = wrapperCol || formContext.wrapperCol || {};
  var className = classNames("".concat(baseClassName, "-control"), mergedWrapperCol.className);

  var _useCacheErrors = useCacheErrors(errors, function (changedVisible) {
    if (changedVisible) {
      onDomErrorVisibleChange(true);
    }
  }),
      _useCacheErrors2 = _slicedToArray(_useCacheErrors, 2),
      visible = _useCacheErrors2[0],
      cacheErrors = _useCacheErrors2[1]; // Should provides additional icon if `hasFeedback`


  var IconNode = validateStatus && iconMap[validateStatus];
  var icon = hasFeedback && IconNode ? React.createElement("span", {
    className: "".concat(baseClassName, "-children-icon")
  }, React.createElement(IconNode, null)) : null; // Pass to sub FormItem should not with col info

  var subFormContext = _extends({}, formContext);

  delete subFormContext.labelCol;
  delete subFormContext.wrapperCol;
  return React.createElement(FormContext.Provider, {
    value: subFormContext
  }, React.createElement(Col, _extends({}, mergedWrapperCol, {
    className: className
  }), React.createElement("div", {
    className: "".concat(baseClassName, "-control-input")
  }, children, icon), React.createElement(CSSMotion, {
    visible: visible,
    motionName: "show-help",
    onLeaveEnd: function onLeaveEnd() {
      onDomErrorVisibleChange(false);
    },
    motionAppear: true,
    removeOnLeave: true
  }, function (_ref2) {
    var motionClassName = _ref2.className;
    return React.createElement("div", {
      className: classNames("".concat(baseClassName, "-explain"), motionClassName),
      key: "help"
    }, cacheErrors);
  }), extra && React.createElement("div", {
    className: "".concat(baseClassName, "-extra")
  }, extra)));
};

export default FormItemInput;
//# sourceMappingURL=FormItemInput.js.map
