function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var __rest = this && this.__rest || function (s, e) {
  var t = {};

  for (var p in s) {
    if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  }

  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};

import * as React from 'react';
import classNames from 'classnames';
import { SearchOutlined, LoadingOutlined } from '@ant-design/icons';
import Input from './Input';
import Button from '../button';
import { ConfigConsumer } from '../config-provider';

var Search =
/*#__PURE__*/
function (_React$Component) {
  _inherits(Search, _React$Component);

  function Search() {
    var _this;

    _classCallCheck(this, Search);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(Search).apply(this, arguments));

    _this.saveInput = function (node) {
      _this.input = node;
    };

    _this.onChange = function (e) {
      var _this$props = _this.props,
          onChange = _this$props.onChange,
          onSearch = _this$props.onSearch;

      if (e && e.target && e.type === 'click' && onSearch) {
        onSearch(e.target.value, e);
      }

      if (onChange) {
        onChange(e);
      }
    };

    _this.onSearch = function (e) {
      var _this$props2 = _this.props,
          onSearch = _this$props2.onSearch,
          loading = _this$props2.loading,
          disabled = _this$props2.disabled;

      if (loading || disabled) {
        return;
      }

      if (onSearch) {
        onSearch(_this.input.input.value, e);
      }

      _this.input.focus();
    };

    _this.renderLoading = function (prefixCls) {
      var _this$props3 = _this.props,
          enterButton = _this$props3.enterButton,
          size = _this$props3.size;

      if (enterButton) {
        return React.createElement(Button, {
          className: "".concat(prefixCls, "-button"),
          type: "primary",
          size: size,
          key: "enterButton"
        }, React.createElement(LoadingOutlined, null));
      }

      return React.createElement(LoadingOutlined, {
        className: "".concat(prefixCls, "-icon"),
        key: "loadingIcon"
      });
    };

    _this.renderSuffix = function (prefixCls) {
      var _this$props4 = _this.props,
          suffix = _this$props4.suffix,
          enterButton = _this$props4.enterButton,
          loading = _this$props4.loading;

      if (loading && !enterButton) {
        return [suffix, _this.renderLoading(prefixCls)];
      }

      if (enterButton) return suffix;
      var icon = React.createElement(SearchOutlined, {
        className: "".concat(prefixCls, "-icon"),
        key: "searchIcon",
        onClick: _this.onSearch
      });

      if (suffix) {
        return [React.isValidElement(suffix) ? React.cloneElement(suffix, {
          key: 'suffix'
        }) : null, icon];
      }

      return icon;
    };

    _this.renderAddonAfter = function (prefixCls) {
      var _this$props5 = _this.props,
          enterButton = _this$props5.enterButton,
          size = _this$props5.size,
          disabled = _this$props5.disabled,
          addonAfter = _this$props5.addonAfter,
          loading = _this$props5.loading;
      var btnClassName = "".concat(prefixCls, "-button");

      if (loading && enterButton) {
        return [_this.renderLoading(prefixCls), addonAfter];
      }

      if (!enterButton) return addonAfter;
      var button;
      var enterButtonAsElement = enterButton;
      var isAntdButton = enterButtonAsElement.type && enterButtonAsElement.type.__ANT_BUTTON === true;

      if (isAntdButton || enterButtonAsElement.type === 'button') {
        button = React.cloneElement(enterButtonAsElement, _extends({
          onClick: _this.onSearch,
          key: 'enterButton'
        }, isAntdButton ? {
          className: btnClassName,
          size: size
        } : {}));
      } else {
        button = React.createElement(Button, {
          className: btnClassName,
          type: "primary",
          size: size,
          disabled: disabled,
          key: "enterButton",
          onClick: _this.onSearch
        }, enterButton === true ? React.createElement(SearchOutlined, null) : enterButton);
      }

      if (addonAfter) {
        return [button, React.isValidElement(addonAfter) ? React.cloneElement(addonAfter, {
          key: 'addonAfter'
        }) : null];
      }

      return button;
    };

    _this.renderSearch = function (_ref) {
      var getPrefixCls = _ref.getPrefixCls;

      var _a = _this.props,
          customizePrefixCls = _a.prefixCls,
          customizeInputPrefixCls = _a.inputPrefixCls,
          size = _a.size,
          enterButton = _a.enterButton,
          className = _a.className,
          restProps = __rest(_a, ["prefixCls", "inputPrefixCls", "size", "enterButton", "className"]);

      delete restProps.onSearch;
      delete restProps.loading;
      var prefixCls = getPrefixCls('input-search', customizePrefixCls);
      var inputPrefixCls = getPrefixCls('input', customizeInputPrefixCls);
      var inputClassName;

      if (enterButton) {
        var _classNames;

        inputClassName = classNames(prefixCls, className, (_classNames = {}, _defineProperty(_classNames, "".concat(prefixCls, "-enter-button"), !!enterButton), _defineProperty(_classNames, "".concat(prefixCls, "-").concat(size), !!size), _classNames));
      } else {
        inputClassName = classNames(prefixCls, className);
      }

      return React.createElement(Input, _extends({
        onPressEnter: _this.onSearch
      }, restProps, {
        size: size,
        prefixCls: inputPrefixCls,
        addonAfter: _this.renderAddonAfter(prefixCls),
        suffix: _this.renderSuffix(prefixCls),
        onChange: _this.onChange,
        ref: _this.saveInput,
        className: inputClassName
      }));
    };

    return _this;
  }

  _createClass(Search, [{
    key: "focus",
    value: function focus() {
      this.input.focus();
    }
  }, {
    key: "blur",
    value: function blur() {
      this.input.blur();
    }
  }, {
    key: "render",
    value: function render() {
      return React.createElement(ConfigConsumer, null, this.renderSearch);
    }
  }]);

  return Search;
}(React.Component);

export { Search as default };
Search.defaultProps = {
  enterButton: false
};
//# sourceMappingURL=Search.js.map
