function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

import { useState } from 'react';
export var DEFAULT_PAGE_SIZE = 10;
export function getPaginationParam(pagination, mergedPagination) {
  var param = {
    current: mergedPagination.current,
    pageSize: mergedPagination.pageSize
  };
  var paginationObj = pagination && _typeof(pagination) === 'object' ? pagination : {};
  Object.keys(paginationObj).forEach(function (pageProp) {
    var value = mergedPagination[pageProp];

    if (typeof value !== 'function') {
      param[pageProp] = value;
    }
  });
  return param;
}
export default function usePagination(total, pagination, onChange) {
  var paginationObj = pagination && _typeof(pagination) === 'object' ? pagination : {};

  var _useState = useState(function () {
    return {
      current: 'defaultCurrent' in paginationObj ? paginationObj.defaultCurrent : 1,
      pageSize: 'defaultPageSize' in paginationObj ? paginationObj.defaultPageSize : DEFAULT_PAGE_SIZE
    };
  }),
      _useState2 = _slicedToArray(_useState, 2),
      innerPagination = _useState2[0],
      setInnerPagination = _useState2[1]; // ============ Basic Pagination Config ============


  var mergedPagination = _extends(_extends(_extends({}, innerPagination), {
    total: total
  }), paginationObj);

  if (!paginationObj.total) {
    // Reset `current` if data length changed. Only reset when paginationObj do not have total
    var maxPage = Math.ceil(total / mergedPagination.pageSize);

    if (maxPage < mergedPagination.current) {
      mergedPagination.current = 1;
    }
  }

  var refreshPagination = function refreshPagination() {
    var current = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;
    setInnerPagination(_extends(_extends({}, mergedPagination), {
      current: current
    }));
  };

  var onInternalChange = function onInternalChange() {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    var current = args[0];
    refreshPagination(current);
    onChange(current, args[1] || mergedPagination.pageSize);

    if (pagination && pagination.onChange) {
      pagination.onChange.apply(pagination, args);
    }
  };

  var onInternalShowSizeChange = function onInternalShowSizeChange() {
    for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      args[_key2] = arguments[_key2];
    }

    var pageSize = args[1];
    setInnerPagination(_extends(_extends({}, mergedPagination), {
      current: 1,
      pageSize: pageSize
    }));
    onChange(1, pageSize);

    if (pagination && pagination.onShowSizeChange) {
      pagination.onShowSizeChange.apply(pagination, args);
    }
  };

  if (pagination === false) {
    return [{}, function () {}];
  }

  return [_extends(_extends({}, mergedPagination), {
    onChange: onInternalChange,
    onShowSizeChange: onInternalShowSizeChange
  }), refreshPagination];
}
//# sourceMappingURL=usePagination.js.map
