import { TransformColumns, ColumnsType, Key, ColumnType, SortOrder, ColumnTitleProps, SorterResult } from '../interface';
export interface SortState<RecordType> {
    column: ColumnType<RecordType>;
    key: Key;
    sortOrder: SortOrder | null;
    multiplePriority: number | false;
}
export declare function getSortData<RecordType>(data: RecordType[], sortStates: SortState<RecordType>[], childrenColumnName: string): RecordType[];
interface SorterConfig<RecordType> {
    prefixCls: string;
    columns: ColumnsType<RecordType>;
    onSorterChange: (sorterResult: SorterResult<RecordType> | SorterResult<RecordType>[], sortStates: SortState<RecordType>[]) => void;
    sortDirections: SortOrder[];
}
export default function useFilterSorter<RecordType>({ prefixCls, columns, onSorterChange, sortDirections, }: SorterConfig<RecordType>): [TransformColumns<RecordType>, SortState<RecordType>[], ColumnTitleProps<RecordType>, () => SorterResult<RecordType> | SorterResult<RecordType>[]];
export {};
