function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

import * as React from 'react';
import RcTreeSelect, { TreeNode, SHOW_ALL, SHOW_PARENT, SHOW_CHILD } from 'rc-tree-select';
import classNames from 'classnames';
import omit from 'omit.js';
import { ConfigConsumer } from '../config-provider';
import collapseMotion from '../_util/motion';
import warning from '../_util/warning';
import getIcons from '../select/utils/iconUtil';
import renderSwitcherIcon from '../tree/utils/iconUtil';

var TreeSelect =
/*#__PURE__*/
function (_React$Component) {
  _inherits(TreeSelect, _React$Component);

  function TreeSelect(props) {
    var _this;

    _classCallCheck(this, TreeSelect);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(TreeSelect).call(this, props));
    _this.selectRef = React.createRef();

    _this.renderTreeSelect = function (_ref) {
      var _classNames;

      var getContextPopupContainer = _ref.getPopupContainer,
          getPrefixCls = _ref.getPrefixCls,
          renderEmpty = _ref.renderEmpty;
      var _this$props = _this.props,
          customizePrefixCls = _this$props.prefixCls,
          size = _this$props.size,
          className = _this$props.className,
          treeCheckable = _this$props.treeCheckable,
          multiple = _this$props.multiple,
          _this$props$listHeigh = _this$props.listHeight,
          listHeight = _this$props$listHeigh === void 0 ? 256 : _this$props$listHeigh,
          _this$props$listItemH = _this$props.listItemHeight,
          listItemHeight = _this$props$listItemH === void 0 ? 32 : _this$props$listItemH,
          notFoundContent = _this$props.notFoundContent,
          _switcherIcon = _this$props.switcherIcon,
          treeLine = _this$props.treeLine,
          getPopupContainer = _this$props.getPopupContainer,
          dropdownClassName = _this$props.dropdownClassName;
      var prefixCls = getPrefixCls('select', customizePrefixCls);
      var treePrefixCls = getPrefixCls('select-tree', customizePrefixCls);
      var treeSelectPrefixCls = getPrefixCls('tree-select', customizePrefixCls);
      var mergedClassName = classNames(!customizePrefixCls && treeSelectPrefixCls, (_classNames = {}, _defineProperty(_classNames, "".concat(prefixCls, "-lg"), size === 'large'), _defineProperty(_classNames, "".concat(prefixCls, "-sm"), size === 'small'), _classNames), className);
      var mergedDropdownClassName = classNames(dropdownClassName, "".concat(treeSelectPrefixCls, "-dropdown"));
      var isMultiple = !!(treeCheckable || multiple); // ===================== Icons =====================

      var _getIcons = getIcons(_extends(_extends({}, _this.props), {
        multiple: isMultiple
      })),
          suffixIcon = _getIcons.suffixIcon,
          itemIcon = _getIcons.itemIcon,
          removeIcon = _getIcons.removeIcon,
          clearIcon = _getIcons.clearIcon; // ===================== Empty =====================


      var mergedNotFound;

      if (notFoundContent !== undefined) {
        mergedNotFound = notFoundContent;
      } else {
        mergedNotFound = renderEmpty('Select');
      } // ==================== Render =====================


      var selectProps = omit(_this.props, ['prefixCls', 'suffixIcon', 'itemIcon', 'removeIcon', 'clearIcon', 'switcherIcon', 'size']);
      return React.createElement(RcTreeSelect, _extends({}, selectProps, {
        ref: _this.selectRef,
        prefixCls: prefixCls,
        className: mergedClassName,
        listHeight: listHeight,
        listItemHeight: listItemHeight,
        treeCheckable: treeCheckable ? React.createElement("span", {
          className: "".concat(prefixCls, "-tree-checkbox-inner")
        }) : treeCheckable,
        inputIcon: suffixIcon,
        menuItemSelectedIcon: itemIcon,
        removeIcon: removeIcon,
        clearIcon: clearIcon,
        switcherIcon: function switcherIcon(nodeProps) {
          return renderSwitcherIcon(treePrefixCls, _switcherIcon, treeLine, nodeProps);
        },
        showTreeIcon: false,
        notFoundContent: mergedNotFound,
        getPopupContainer: getPopupContainer || getContextPopupContainer,
        treeMotion: collapseMotion,
        dropdownClassName: mergedDropdownClassName
      }));
    };

    warning(props.multiple !== false || !props.treeCheckable, 'TreeSelect', '`multiple` will alway be `true` when `treeCheckable` is true');
    return _this;
  }

  _createClass(TreeSelect, [{
    key: "focus",
    value: function focus() {
      if (this.selectRef.current) {
        this.selectRef.current.focus();
      }
    }
  }, {
    key: "blur",
    value: function blur() {
      if (this.selectRef.current) {
        this.selectRef.current.blur();
      }
    }
  }, {
    key: "render",
    value: function render() {
      return React.createElement(ConfigConsumer, null, this.renderTreeSelect);
    }
  }]);

  return TreeSelect;
}(React.Component);

TreeSelect.TreeNode = TreeNode;
TreeSelect.SHOW_ALL = SHOW_ALL;
TreeSelect.SHOW_PARENT = SHOW_PARENT;
TreeSelect.SHOW_CHILD = SHOW_CHILD;
TreeSelect.defaultProps = {
  transitionName: 'slide-up',
  choiceTransitionName: 'zoom'
};
export { TreeNode };
export default TreeSelect;
//# sourceMappingURL=index.js.map
